/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["apm_bundle_jsonpfunction"]=window["apm_bundle_jsonpfunction"]||[]).push([[2],Array(38).concat([function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(1339)()}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return asDecimal}));__webpack_require__.d(__webpack_exports__,"e",(function(){return asInteger}));__webpack_require__.d(__webpack_exports__,"g",(function(){return asPercent}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getDateDifference}));__webpack_require__.d(__webpack_exports__,"a",(function(){return asAbsoluteDateTime}));__webpack_require__.d(__webpack_exports__,"h",(function(){return asRelativeDateTimeRange}));__webpack_require__.d(__webpack_exports__,"k",(function(){return getDurationFormatter}));__webpack_require__.d(__webpack_exports__,"i",(function(){return asTransactionRate}));__webpack_require__.d(__webpack_exports__,"c",(function(){return asDuration}));__webpack_require__.d(__webpack_exports__,"f",(function(){return asMillisecondDuration}));__webpack_require__.d(__webpack_exports__,"l",(function(){return getFixedByteFormatter}));__webpack_require__.d(__webpack_exports__,"d",(function(){return asDynamicBytes}));var external_kbnSharedDeps_ElasticNumeral_=__webpack_require__(19);var external_kbnSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_kbnSharedDeps_ElasticNumeral_);var i18n=__webpack_require__(51);var is_finite_number=__webpack_require__(62);function asDecimal(value){if(!Object(is_finite_number["a"])(value)){return i18n["a"]}return external_kbnSharedDeps_ElasticNumeral_default()(value).format("0,0.0")}function asInteger(value){if(!Object(is_finite_number["a"])(value)){return i18n["a"]}return external_kbnSharedDeps_ElasticNumeral_default()(value).format("0,0")}function asPercent(numerator,denominator,fallbackResult=i18n["a"]){if(!denominator||!Object(is_finite_number["a"])(numerator)){return fallbackResult}const decimal=numerator/denominator;if(Math.abs(decimal)>=.1||decimal===0){return external_kbnSharedDeps_ElasticNumeral_default()(decimal).format("0%")}return external_kbnSharedDeps_ElasticNumeral_default()(decimal).format("0.0%")}function asDecimalOrInteger(value){if(value===0||value>=10){return asInteger(value)}return asDecimal(value)}var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(23);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);function formatTimezone(momentTime){const DEFAULT_TIMEZONE_FORMAT="Z";const utcOffsetHours=momentTime.utcOffset()/60;const customTimezoneFormat=utcOffsetHours>0?`+${utcOffsetHours}`:utcOffsetHours;const utcOffsetFormatted=Number.isInteger(utcOffsetHours)?customTimezoneFormat:DEFAULT_TIMEZONE_FORMAT;return momentTime.format(`(UTC${utcOffsetFormatted})`)}function getTimeFormat(timeUnit){switch(timeUnit){case"hours":return"HH";case"minutes":return"HH:mm";case"seconds":return"HH:mm:ss";case"milliseconds":return"HH:mm:ss.SSS";default:return""}}function getDateFormat(dateUnit){switch(dateUnit){case"years":return"YYYY";case"months":return"MMM YYYY";case"days":return"MMM D, YYYY";default:return""}}const getDateDifference=({start:start,end:end,unitOfTime:unitOfTime,precise:precise})=>end.diff(start,unitOfTime,precise);function getFormatsAccordingToDateDifference(start,end){if(getDateDifference({start:start,end:end,unitOfTime:"years"})>=5){return{dateFormat:getDateFormat("years")}}if(getDateDifference({start:start,end:end,unitOfTime:"months"})>=5){return{dateFormat:getDateFormat("months")}}const dateFormatWithDays=getDateFormat("days");if(getDateDifference({start:start,end:end,unitOfTime:"days"})>1){return{dateFormat:dateFormatWithDays}}if(getDateDifference({start:start,end:end,unitOfTime:"minutes"})>=1){return{dateFormat:dateFormatWithDays,timeFormat:getTimeFormat("minutes")}}if(getDateDifference({start:start,end:end,unitOfTime:"seconds"})>=10){return{dateFormat:dateFormatWithDays,timeFormat:getTimeFormat("seconds")}}return{dateFormat:dateFormatWithDays,timeFormat:getTimeFormat("milliseconds")}}function asAbsoluteDateTime(time,timeUnit="milliseconds"){const momentTime=external_kbnSharedDeps_MomentTimezone_default()(time);const formattedTz=formatTimezone(momentTime);return momentTime.format(`${getDateFormat("days")}, ${getTimeFormat(timeUnit)} ${formattedTz}`)}function asRelativeDateTimeRange(start,end){const momentStartTime=external_kbnSharedDeps_MomentTimezone_default()(start);const momentEndTime=external_kbnSharedDeps_MomentTimezone_default()(end);const{dateFormat:dateFormat,timeFormat:timeFormat}=getFormatsAccordingToDateDifference(momentStartTime,momentEndTime);if(timeFormat){const startFormatted=momentStartTime.format(`${dateFormat}, ${timeFormat}`);const endFormatted=momentEndTime.format(timeFormat);const formattedTz=formatTimezone(momentStartTime);return`${startFormatted} - ${endFormatted} ${formattedTz}`}const startFormatted=momentStartTime.format(dateFormat);const endFormatted=momentEndTime.format(dateFormat);return`${startFormatted} - ${endFormatted}`}var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_Moment_=__webpack_require__(17);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_Lodash_=__webpack_require__(12);function getUnitLabelAndConvertedValue(unitKey,value){switch(unitKey){case"hours":{return{unitLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.formatters.hoursTimeUnitLabel",{defaultMessage:"h"}),convertedValue:asDecimalOrInteger(external_kbnSharedDeps_Moment_default.a.duration(value/1e3).asHours())}}case"minutes":{return{unitLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.formatters.minutesTimeUnitLabel",{defaultMessage:"min"}),convertedValue:asDecimalOrInteger(external_kbnSharedDeps_Moment_default.a.duration(value/1e3).asMinutes())}}case"seconds":{return{unitLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.formatters.secondsTimeUnitLabel",{defaultMessage:"s"}),convertedValue:asDecimalOrInteger(external_kbnSharedDeps_Moment_default.a.duration(value/1e3).asSeconds())}}case"milliseconds":{return{unitLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.formatters.millisTimeUnitLabel",{defaultMessage:"ms"}),convertedValue:asDecimalOrInteger(external_kbnSharedDeps_Moment_default.a.duration(value/1e3).asMilliseconds())}}case"microseconds":{return{unitLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.formatters.microsTimeUnitLabel",{defaultMessage:"μs"}),convertedValue:asInteger(value)}}}}function convertTo({unit:unit,microseconds:microseconds,defaultValue:defaultValue=i18n["a"]}){if(!Object(is_finite_number["a"])(microseconds)){return{value:defaultValue,formatted:defaultValue}}const{convertedValue:convertedValue,unitLabel:unitLabel}=getUnitLabelAndConvertedValue(unit,microseconds);return{value:convertedValue,unit:unitLabel,formatted:`${convertedValue} ${unitLabel}`}}const toMicroseconds=(value,timeUnit)=>external_kbnSharedDeps_Moment_default.a.duration(value,timeUnit).asMilliseconds()*1e3;function getDurationUnitKey(max){if(max>toMicroseconds(10,"hours")){return"hours"}if(max>toMicroseconds(10,"minutes")){return"minutes"}if(max>toMicroseconds(10,"seconds")){return"seconds"}if(max>toMicroseconds(1,"milliseconds")){return"milliseconds"}return"microseconds"}const getDurationFormatter=Object(external_kbnSharedDeps_Lodash_["memoize"])(max=>{const unit=getDurationUnitKey(max);return(value,{defaultValue:defaultValue}={})=>convertTo({unit:unit,microseconds:value,defaultValue:defaultValue})});function asTransactionRate(value){if(!Object(is_finite_number["a"])(value)){return i18n["a"]}let displayedValue;if(value===0){displayedValue="0"}else if(value<=.1){displayedValue="< 0.1"}else{displayedValue=asDecimal(value)}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.apm.transactionRateLabel",{defaultMessage:`{value} tpm`,values:{value:displayedValue}})}function asDuration(value,{defaultValue:defaultValue=i18n["a"]}={}){if(!Object(is_finite_number["a"])(value)){return defaultValue}const formatter=getDurationFormatter(value);return formatter(value,{defaultValue:defaultValue}).formatted}function asMillisecondDuration(value){return convertTo({unit:"milliseconds",microseconds:value}).formatted}function asKilobytes(value){return`${asDecimal(value/1e3)} KB`}function asMegabytes(value){return`${asDecimal(value/1e6)} MB`}function asGigabytes(value){return`${asDecimal(value/1e9)} GB`}function asTerabytes(value){return`${asDecimal(value/1e12)} TB`}function asBytes(value){return`${asDecimal(value)} B`}const bailIfNumberInvalid=cb=>val=>{if(val===null||val===undefined||isNaN(val)){return""}return cb(val)};const getFixedByteFormatter=Object(external_kbnSharedDeps_Lodash_["memoize"])(max=>{const formatter=unmemoizedFixedByteFormatter(max);return bailIfNumberInvalid(formatter)});const asDynamicBytes=bailIfNumberInvalid(value=>unmemoizedFixedByteFormatter(value)(value));const unmemoizedFixedByteFormatter=max=>{if(max>1e12){return asTerabytes}if(max>1e9){return asGigabytes}if(max>1e6){return asMegabytes}if(max>1e3){return asKilobytes}return asBytes}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useTheme}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var styled_components__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(16);var styled_components__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);function useTheme(){const theme=Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(styled_components__WEBPACK_IMPORTED_MODULE_1__["ThemeContext"]);return theme}},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _d3Voronoi=__webpack_require__(558);var _react=__webpack_require__(2);var _animation=__webpack_require__(44);var _scalesUtils=__webpack_require__(59);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var propTypes=_extends({},(0,_scalesUtils.getScalePropTypesByAttribute)("x"),(0,_scalesUtils.getScalePropTypesByAttribute)("y"),(0,_scalesUtils.getScalePropTypesByAttribute)("size"),(0,_scalesUtils.getScalePropTypesByAttribute)("opacity"),(0,_scalesUtils.getScalePropTypesByAttribute)("color"),{width:_propTypes2.default.number,height:_propTypes2.default.number,data:_propTypes2.default.arrayOf(_propTypes2.default.object),onValueMouseOver:_propTypes2.default.func,onValueMouseOut:_propTypes2.default.func,onValueClick:_propTypes2.default.func,onValueRightClick:_propTypes2.default.func,onSeriesMouseOver:_propTypes2.default.func,onSeriesMouseOut:_propTypes2.default.func,onSeriesClick:_propTypes2.default.func,onSeriesRightClick:_propTypes2.default.func,onNearestX:_propTypes2.default.func,onNearestXY:_propTypes2.default.func,style:_propTypes2.default.object,animation:_animation.AnimationPropType});var defaultProps={className:"",style:{}};var AbstractSeries=function(_PureComponent){_inherits(AbstractSeries,_PureComponent);_createClass(AbstractSeries,null,[{key:"getParentConfig",value:function getParentConfig(){return{}}},{key:"requiresSVG",get:function get(){return true}}]);function AbstractSeries(props){_classCallCheck(this,AbstractSeries);var _this=_possibleConstructorReturn(this,(AbstractSeries.__proto__||Object.getPrototypeOf(AbstractSeries)).call(this,props));_this._seriesMouseOverHandler=_this._seriesMouseOverHandler.bind(_this);_this._valueMouseOverHandler=_this._valueMouseOverHandler.bind(_this);_this._seriesMouseOutHandler=_this._seriesMouseOutHandler.bind(_this);_this._valueMouseOutHandler=_this._valueMouseOutHandler.bind(_this);_this._seriesClickHandler=_this._seriesClickHandler.bind(_this);_this._valueClickHandler=_this._valueClickHandler.bind(_this);_this._seriesRightClickHandler=_this._seriesRightClickHandler.bind(_this);_this._valueRightClickHandler=_this._valueRightClickHandler.bind(_this);return _this}_createClass(AbstractSeries,[{key:"_valueMouseOverHandler",value:function _valueMouseOverHandler(d,event){var _props=this.props,onValueMouseOver=_props.onValueMouseOver,onSeriesMouseOver=_props.onSeriesMouseOver;if(onValueMouseOver){onValueMouseOver(d,{event:event})}if(onSeriesMouseOver){onSeriesMouseOver({event:event})}}},{key:"_seriesMouseOverHandler",value:function _seriesMouseOverHandler(event){var onSeriesMouseOver=this.props.onSeriesMouseOver;if(onSeriesMouseOver){onSeriesMouseOver({event:event})}}},{key:"_valueMouseOutHandler",value:function _valueMouseOutHandler(d,event){var _props2=this.props,onValueMouseOut=_props2.onValueMouseOut,onSeriesMouseOut=_props2.onSeriesMouseOut;if(onValueMouseOut){onValueMouseOut(d,{event:event})}if(onSeriesMouseOut){onSeriesMouseOut({event:event})}}},{key:"_seriesMouseOutHandler",value:function _seriesMouseOutHandler(event){var onSeriesMouseOut=this.props.onSeriesMouseOut;if(onSeriesMouseOut){onSeriesMouseOut({event:event})}}},{key:"_valueClickHandler",value:function _valueClickHandler(d,event){var _props3=this.props,onValueClick=_props3.onValueClick,onSeriesClick=_props3.onSeriesClick;if(onValueClick){onValueClick(d,{event:event})}if(onSeriesClick){onSeriesClick({event:event})}}},{key:"_valueRightClickHandler",value:function _valueRightClickHandler(d,event){var _props4=this.props,onValueRightClick=_props4.onValueRightClick,onSeriesRightClick=_props4.onSeriesRightClick;if(onValueRightClick){onValueRightClick(d,{event:event})}if(onSeriesRightClick){onSeriesRightClick({event:event})}}},{key:"_seriesClickHandler",value:function _seriesClickHandler(event){var onSeriesClick=this.props.onSeriesClick;if(onSeriesClick){onSeriesClick({event:event})}}},{key:"_seriesRightClickHandler",value:function _seriesRightClickHandler(event){var onSeriesRightClick=this.props.onSeriesRightClick;if(onSeriesRightClick){onSeriesRightClick({event:event})}}},{key:"_getAttributeFunctor",value:function _getAttributeFunctor(attr){return(0,_scalesUtils.getAttributeFunctor)(this.props,attr)}},{key:"_getAttr0Functor",value:function _getAttr0Functor(attr){return(0,_scalesUtils.getAttr0Functor)(this.props,attr)}},{key:"_getAttributeValue",value:function _getAttributeValue(attr){return(0,_scalesUtils.getAttributeValue)(this.props,attr)}},{key:"_getScaleDistance",value:function _getScaleDistance(attr){var scaleObject=(0,_scalesUtils.getScaleObjectFromProps)(this.props,attr);return scaleObject?scaleObject.distance:0}},{key:"_getXYCoordinateInContainer",value:function _getXYCoordinateInContainer(event){var _props5=this.props,_props5$marginTop=_props5.marginTop,marginTop=_props5$marginTop===undefined?0:_props5$marginTop,_props5$marginLeft=_props5.marginLeft,marginLeft=_props5$marginLeft===undefined?0:_props5$marginLeft;var _event$nativeEvent=event.nativeEvent,clientX=_event$nativeEvent.clientX,clientY=_event$nativeEvent.clientY,currentTarget=event.currentTarget;var rect=currentTarget.getBoundingClientRect();return{x:clientX-rect.left-currentTarget.clientLeft-marginLeft,y:clientY-rect.top-currentTarget.clientTop-marginTop}}},{key:"_handleNearestX",value:function _handleNearestX(event){var _props6=this.props,onNearestX=_props6.onNearestX,data=_props6.data;var minDistance=Number.POSITIVE_INFINITY;var value=null;var valueIndex=null;var coordinate=this._getXYCoordinateInContainer(event);var xScaleFn=this._getAttributeFunctor("x");data.forEach((function(item,i){var currentCoordinate=xScaleFn(item);var newDistance=Math.abs(coordinate.x-currentCoordinate);if(newDistance<minDistance){minDistance=newDistance;value=item;valueIndex=i}}));if(!value){return}onNearestX(value,{innerX:xScaleFn(value),index:valueIndex,event:event.nativeEvent})}},{key:"_handleNearestXY",value:function _handleNearestXY(event){var _props7=this.props,onNearestXY=_props7.onNearestXY,data=_props7.data;var coordinate=this._getXYCoordinateInContainer(event);var xScaleFn=this._getAttributeFunctor("x");var yScaleFn=this._getAttributeFunctor("y");var voronoiInstance=(0,_d3Voronoi.voronoi)().x(xScaleFn).y(yScaleFn);var foundPoint=voronoiInstance(data).find(coordinate.x,coordinate.y);var value=foundPoint.data;if(!value){return}onNearestXY(value,{innerX:foundPoint.x,innerY:foundPoint.y,index:foundPoint.index,event:event.nativeEvent})}},{key:"onParentMouseMove",value:function onParentMouseMove(event){var _props8=this.props,onNearestX=_props8.onNearestX,onNearestXY=_props8.onNearestXY,data=_props8.data;if(!onNearestX&&!onNearestXY||!data){return}if(onNearestXY){this._handleNearestXY(event)}else{this._handleNearestX(event)}}}]);return AbstractSeries}(_react.PureComponent);AbstractSeries.displayName="AbstractSeries";AbstractSeries.propTypes=propTypes;AbstractSeries.defaultProps=defaultProps;exports.default=AbstractSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AnimationPropType=undefined;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.extractAnimatedPropValues=extractAnimatedPropValues;var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _d3Interpolate=__webpack_require__(210);var _reactMotion=__webpack_require__(1355);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function _objectWithoutProperties(obj,keys){var target={};for(var i in obj){if(keys.indexOf(i)>=0)continue;if(!Object.prototype.hasOwnProperty.call(obj,i))continue;target[i]=obj[i]}return target}var ANIMATION_PROPTYPES=_propTypes2.default.oneOfType([_propTypes2.default.string,_propTypes2.default.shape({stiffness:_propTypes2.default.number,nonAnimatedProps:_propTypes2.default.arrayOf(_propTypes2.default.string),damping:_propTypes2.default.number}),_propTypes2.default.bool]);var propTypes={animatedProps:_propTypes2.default.arrayOf(_propTypes2.default.string).isRequired,animation:ANIMATION_PROPTYPES,onStart:_propTypes2.default.func,onEnd:_propTypes2.default.func};function getAnimationStyle(){var animationStyle=arguments.length>0&&arguments[0]!==undefined?arguments[0]:_reactMotion.presets.noWobble;if(typeof animationStyle==="string"){return _reactMotion.presets[animationStyle]||_reactMotion.presets.noWobble}var damping=animationStyle.damping,stiffness=animationStyle.stiffness;return _extends({damping:damping||_reactMotion.presets.noWobble.damping,stiffness:stiffness||_reactMotion.presets.noWobble.stiffness},animationStyle)}function extractAnimatedPropValues(props){var animatedProps=props.animatedProps,otherProps=_objectWithoutProperties(props,["animatedProps"]);return animatedProps.reduce((function(result,animatedPropName){if(otherProps.hasOwnProperty(animatedPropName)){result[animatedPropName]=otherProps[animatedPropName]}return result}),{})}var Animation=function(_PureComponent){_inherits(Animation,_PureComponent);function Animation(props){_classCallCheck(this,Animation);var _this=_possibleConstructorReturn(this,(Animation.__proto__||Object.getPrototypeOf(Animation)).call(this,props));_this._updateInterpolator(props);_this._renderChildren=_this._renderChildren.bind(_this);_this._motionEndHandler=_this._motionEndHandler.bind(_this);return _this}_createClass(Animation,[{key:"componentWillUpdate",value:function componentWillUpdate(props){this._updateInterpolator(this.props,props);if(props.onStart){props.onStart()}}},{key:"_updateInterpolator",value:function _updateInterpolator(oldProps,newProps){this._interpolator=(0,_d3Interpolate.interpolate)(extractAnimatedPropValues(oldProps),newProps?extractAnimatedPropValues(newProps):null)}},{key:"_renderChildren",value:function _renderChildren(_ref){var i=_ref.i;var children=this.props.children;var interpolator=this._interpolator;var child=_react2.default.Children.only(children);var interpolatedProps=interpolator?interpolator(i):interpolator;var data=interpolatedProps&&interpolatedProps.data||null;if(data&&child.props._data){data=data.map((function(row,index){var correspondingCell=child.props._data[index];return _extends({},row,{parent:correspondingCell.parent,children:correspondingCell.children})}))}return _react2.default.cloneElement(child,_extends({},child.props,interpolatedProps,{data:data||child.props.data||null,_animation:Math.random()}))}},{key:"_motionEndHandler",value:function _motionEndHandler(){if(this.props.onEnd){this.props.onEnd()}}},{key:"render",value:function render(){var animationStyle=getAnimationStyle(this.props.animation);var defaultStyle={i:0};var style={i:(0,_reactMotion.spring)(1,animationStyle)};var key=Math.random();return _react2.default.createElement(_reactMotion.Motion,_extends({defaultStyle:defaultStyle,style:style,key:key},{onRest:this._motionEndHandler}),this._renderChildren)}}]);return Animation}(_react.PureComponent);Animation.propTypes=propTypes;Animation.displayName="Animation";exports.default=Animation;var AnimationPropType=exports.AnimationPropType=ANIMATION_PROPTYPES},function(module,exports,__webpack_require__){var lodash;if(true){try{lodash={cloneDeep:__webpack_require__(1248),constant:__webpack_require__(199),defaults:__webpack_require__(1249),each:__webpack_require__(507),filter:__webpack_require__(510),find:__webpack_require__(1250),flatten:__webpack_require__(537),forEach:__webpack_require__(508),forIn:__webpack_require__(1257),has:__webpack_require__(521),isUndefined:__webpack_require__(522),last:__webpack_require__(1258),map:__webpack_require__(523),mapValues:__webpack_require__(1259),max:__webpack_require__(1260),merge:__webpack_require__(1262),min:__webpack_require__(1268),minBy:__webpack_require__(1269),now:__webpack_require__(1270),pick:__webpack_require__(1271),range:__webpack_require__(1276),reduce:__webpack_require__(525),sortBy:__webpack_require__(1279),uniqueId:__webpack_require__(1284),values:__webpack_require__(530),zipObject:__webpack_require__(1285)}}catch(e){}}if(!lodash){lodash=window._}module.exports=lodash},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return useAPMHref}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getAPMHref}));__webpack_require__.d(__webpack_exports__,"a",(function(){return APMLink}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(12);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var react_router_dom__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(11);var react_router_dom__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_3__);var url__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(86);var url__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(url__WEBPACK_IMPORTED_MODULE_4__);var _common_utils_pick_keys__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(84);var _context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(39);var _context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(36);var _url_helpers__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(42);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const PERSISTENT_APM_PARAMS=["kuery","rangeFrom","rangeTo","refreshPaused","refreshInterval","environment"];function useAPMHref({path:path,persistedFilters:persistedFilters,query:query}){const{urlParams:urlParams}=Object(_context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_7__["a"])();const{basePath:basePath}=Object(_context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_6__["a"])().core.http;const{search:search}=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useLocation"])();const nextQuery={...Object(_common_utils_pick_keys__WEBPACK_IMPORTED_MODULE_5__["a"])(urlParams,...persistedFilters!==null&&persistedFilters!==void 0?persistedFilters:[]),...query};return getAPMHref({basePath:basePath,path:path,query:nextQuery,search:search})}function getAPMHref({basePath:basePath,path:path="",search:search,query:query={}}){const currentQuery=Object(_url_helpers__WEBPACK_IMPORTED_MODULE_8__["e"])(search);const nextQuery={...Object(lodash__WEBPACK_IMPORTED_MODULE_1__["pick"])(currentQuery,PERSISTENT_APM_PARAMS),...query};const nextSearch=Object(_url_helpers__WEBPACK_IMPORTED_MODULE_8__["b"])(nextQuery);return url__WEBPACK_IMPORTED_MODULE_4___default.a.format({pathname:basePath.prepend(`/app/apm${path}`),search:nextSearch})}function APMLink({path:path="",query:query,mergeQuery:mergeQuery,...rest}){const{core:core}=Object(_context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_6__["a"])();const{search:search}=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useLocation"])();const{basePath:basePath}=core.http;const mergedQuery=mergeQuery?mergeQuery(query!==null&&query!==void 0?query:{}):query;const href=getAPMHref({basePath:basePath,path:path,search:search,query:mergedQuery});return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiLink"],_extends({},rest,{href:href}))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useApmServiceContext}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _apm_service_context__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(82);function useApmServiceContext(){return Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_apm_service_context__WEBPACK_IMPORTED_MODULE_1__["a"])}},,function(module,exports){var isArray=Array.isArray;module.exports=isArray},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NOT_AVAILABLE_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return UNIDENTIFIED_SERVICE_NODES_LABEL}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const NOT_AVAILABLE_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.notAvailableLabel",{defaultMessage:"N/A"});const UNIDENTIFIED_SERVICE_NODES_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.serviceNodeNameMissing",{defaultMessage:"(Empty)"})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var DISCRETE_COLOR_RANGE=exports.DISCRETE_COLOR_RANGE=["#12939A","#79C7E3","#1A3177","#FF9833","#EF5D28"];var EXTENDED_DISCRETE_COLOR_RANGE=exports.EXTENDED_DISCRETE_COLOR_RANGE=["#19CDD7","#DDB27C","#88572C","#FF991F","#F15C17","#223F9A","#DA70BF","#125C77","#4DC19C","#776E57","#12939A","#17B8BE","#F6D18A","#B7885E","#FFCB99","#F89570","#829AE3","#E79FD5","#1E96BE","#89DAC1","#B3AD9E"];var CONTINUOUS_COLOR_RANGE=exports.CONTINUOUS_COLOR_RANGE=["#EF5D28","#FF9833"];var SIZE_RANGE=exports.SIZE_RANGE=[1,10];var OPACITY_RANGE=exports.OPACITY_RANGE=[.1,1];var OPACITY_TYPE=exports.OPACITY_TYPE="literal";var DEFAULT_OPACITY=exports.DEFAULT_OPACITY=1;var DEFAULT_SIZE=exports.DEFAULT_SIZE=5;var DEFAULT_COLOR=exports.DEFAULT_COLOR=DISCRETE_COLOR_RANGE[0];var DEFAULT_TICK_SIZE=exports.DEFAULT_TICK_SIZE=7},,,function(module,exports){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}module.exports=_interopRequireDefault},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ANIMATED_SERIES_PROPS=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.isSeriesChild=isSeriesChild;exports.getSeriesChildren=getSeriesChildren;exports.getStackedData=getStackedData;exports.getSeriesPropsFromChildren=getSeriesPropsFromChildren;exports.getRadialDomain=getRadialDomain;exports.getStackParams=getStackParams;var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);var _theme=__webpack_require__(52);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function isSeriesChild(child){var prototype=child.type.prototype;return prototype instanceof _abstractSeries2.default}function getSeriesChildren(children){return _react2.default.Children.toArray(children).filter((function(child){return child&&isSeriesChild(child)}))}function collectSeriesTypesInfo(children){var result={};children.filter(isSeriesChild).forEach((function(child){var displayName=child.type.displayName;var cluster=child.props.cluster;if(!result[displayName]){result[displayName]={sameTypeTotal:0,sameTypeIndex:0,clusters:new Set}}result[displayName].clusters.add(cluster);result[displayName].sameTypeTotal++}));return result}function seriesHasAngleRadius(){var data=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];if(!data){return false}return data.some((function(row){return row.radius&&row.angle}))}function prepareData(data){if(!seriesHasAngleRadius(data)){return data}return data.map((function(row){return _extends({},row,{x:row.radius*Math.cos(row.angle),y:row.radius*Math.sin(row.angle)})}))}function getStackedData(children,attr){var latestAttrPositions={};return children.reduce((function(accumulator,series,seriesIndex){if(!series){accumulator.push(null);return accumulator}var _series$props=series.props,data=_series$props.data,_series$props$cluster=_series$props.cluster,cluster=_series$props$cluster===undefined?"default":_series$props$cluster;var preppedData=prepareData(data,attr);if(!attr||!preppedData||!preppedData.length){accumulator.push(preppedData);return accumulator}var attr0=attr+"0";var baseAttr=attr==="y"?"x":"y";accumulator.push(preppedData.map((function(d,dIndex){var _extends2,_latestAttrPositions$2;if(!latestAttrPositions[cluster]){latestAttrPositions[cluster]={}}var prevD=latestAttrPositions[cluster][d[baseAttr]];if(!prevD){var _latestAttrPositions$;latestAttrPositions[cluster][d[baseAttr]]=(_latestAttrPositions$={},_defineProperty(_latestAttrPositions$,attr0,d[attr0]),_defineProperty(_latestAttrPositions$,attr,d[attr]),_latestAttrPositions$);return _extends({},d)}var nextD=_extends({},d,(_extends2={},_defineProperty(_extends2,attr0,prevD[attr]),_defineProperty(_extends2,attr,prevD[attr]+d[attr]-(d[attr0]||0)),_extends2));latestAttrPositions[cluster][d[baseAttr]]=(_latestAttrPositions$2={},_defineProperty(_latestAttrPositions$2,attr0,nextD[attr0]),_defineProperty(_latestAttrPositions$2,attr,nextD[attr]),_latestAttrPositions$2);return nextD})));return accumulator}),[])}function getSeriesPropsFromChildren(children){var result=[];var seriesTypesInfo=collectSeriesTypesInfo(children);var seriesIndex=0;var _opacityValue=_theme.DEFAULT_OPACITY;children.forEach((function(child){var props=void 0;if(isSeriesChild(child)){var seriesTypeInfo=seriesTypesInfo[child.type.displayName];var _colorValue=_theme.DISCRETE_COLOR_RANGE[seriesIndex%_theme.DISCRETE_COLOR_RANGE.length];props=_extends({},seriesTypeInfo,{seriesIndex:seriesIndex,ref:"series"+seriesIndex,_colorValue:_colorValue,_opacityValue:_opacityValue});seriesTypeInfo.sameTypeIndex++;seriesIndex++;if(child.props.cluster){props.cluster=child.props.cluster;props.clusters=Array.from(seriesTypeInfo.clusters);props.sameTypeTotal=props.clusters.length;props.sameTypeIndex=props.clusters.indexOf(child.props.cluster)}}result.push(props)}));return result}function getRadialDomain(data){return data.reduce((function(res,row){return Math.max(row.radius,res)}),0)}var ANIMATED_SERIES_PROPS=exports.ANIMATED_SERIES_PROPS=["xRange","xDomain","x","yRange","yDomain","y","colorRange","colorDomain","color","opacityRange","opacityDomain","opacity","strokeRange","strokeDomain","stroke","fillRange","fillDomain","fill","width","height","marginLeft","marginTop","marginRight","marginBottom","data","angleDomain","angleRange","angle","radiusDomain","radiusRange","radius","innerRadiusDomain","innerRadiusRange","innerRadius"];function getStackParams(props){var _stackBy=props._stackBy,valuePosAttr=props.valuePosAttr,cluster=props.cluster;var _props$sameTypeTotal=props.sameTypeTotal,sameTypeTotal=_props$sameTypeTotal===undefined?1:_props$sameTypeTotal,_props$sameTypeIndex=props.sameTypeIndex,sameTypeIndex=_props$sameTypeIndex===undefined?0:_props$sameTypeIndex;if(_stackBy===valuePosAttr&&!cluster){sameTypeTotal=1;sameTypeIndex=0}return{sameTypeTotal:sameTypeTotal,sameTypeIndex:sameTypeIndex}}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return OPEN_TELEMETRY_AGENT_NAMES}));__webpack_require__.d(__webpack_exports__,"b",(function(){return RUM_AGENT_NAMES}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isJavaAgentName}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isRumAgentName}));const OPEN_TELEMETRY_AGENT_NAMES=["otlp","opentelemetry/cpp","opentelemetry/dotnet","opentelemetry/erlang","opentelemetry/go","opentelemetry/java","opentelemetry/nodejs","opentelemetry/php","opentelemetry/python","opentelemetry/ruby","opentelemetry/webjs"];const AGENT_NAMES=["dotnet","go","java","js-base","nodejs","python","ruby","rum-js",...OPEN_TELEMETRY_AGENT_NAMES];const RUM_AGENT_NAMES=["js-base","rum-js","opentelemetry/webjs"];function isJavaAgentName(agentName){return agentName==="java"}function isRumAgentName(agentName){return RUM_AGENT_NAMES.includes(agentName)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _SCALE_FUNCTIONS;exports._getSmallestDistanceIndex=_getSmallestDistanceIndex;exports.getScaleFnFromScaleObject=getScaleFnFromScaleObject;exports.getDomainByAccessor=getDomainByAccessor;exports._getScaleDistanceAndAdjustedDomain=_getScaleDistanceAndAdjustedDomain;exports._adjustCategoricalScale=_adjustCategoricalScale;exports.getScaleObjectFromProps=getScaleObjectFromProps;exports.getAttributeScale=getAttributeScale;exports.getAttributeFunctor=getAttributeFunctor;exports.getAttr0Functor=getAttr0Functor;exports.getAttributeValue=getAttributeValue;exports.getScalePropTypesByAttribute=getScalePropTypesByAttribute;exports.extractScalePropsFromProps=extractScalePropsFromProps;exports.getMissingScaleProps=getMissingScaleProps;exports.literalScale=literalScale;exports.getFontColorFromBackground=getFontColorFromBackground;exports.getXYPlotValues=getXYPlotValues;exports.getOptionalScaleProps=getOptionalScaleProps;var _d3Scale=__webpack_require__(93);var _d3Array=__webpack_require__(106);var _d3Collection=__webpack_require__(209);var _d3Color=__webpack_require__(94);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _reactUtils=__webpack_require__(107);var _dataUtils=__webpack_require__(1354);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}var LINEAR_SCALE_TYPE="linear";var ORDINAL_SCALE_TYPE="ordinal";var CATEGORY_SCALE_TYPE="category";var LITERAL_SCALE_TYPE="literal";var LOG_SCALE_TYPE="log";var TIME_SCALE_TYPE="time";var TIME_UTC_SCALE_TYPE="time-utc";var SCALE_FUNCTIONS=(_SCALE_FUNCTIONS={},_defineProperty(_SCALE_FUNCTIONS,LINEAR_SCALE_TYPE,_d3Scale.scaleLinear),_defineProperty(_SCALE_FUNCTIONS,ORDINAL_SCALE_TYPE,_d3Scale.scalePoint),_defineProperty(_SCALE_FUNCTIONS,CATEGORY_SCALE_TYPE,_d3Scale.scaleOrdinal),_defineProperty(_SCALE_FUNCTIONS,LITERAL_SCALE_TYPE,literalScale),_defineProperty(_SCALE_FUNCTIONS,LOG_SCALE_TYPE,_d3Scale.scaleLog),_defineProperty(_SCALE_FUNCTIONS,TIME_SCALE_TYPE,_d3Scale.scaleTime),_defineProperty(_SCALE_FUNCTIONS,TIME_UTC_SCALE_TYPE,_d3Scale.scaleUtc),_SCALE_FUNCTIONS);var XYPLOT_ATTR=["color","fill","opacity","stroke"];function toTitleCase(str){return""+str[0].toUpperCase()+str.slice(1)}function _getSmallestDistanceIndex(values,scaleObject){var scaleFn=getScaleFnFromScaleObject(scaleObject);var result=0;if(scaleFn){var nextValue=void 0;var currentValue=scaleFn(values[0]);var distance=Infinity;var nextDistance=void 0;for(var i=1;i<values.length;i++){nextValue=scaleFn(values[i]);nextDistance=Math.abs(nextValue-currentValue);if(nextDistance<distance){distance=nextDistance;result=i}currentValue=nextValue}}return result}function getScaleFnFromScaleObject(scaleObject){if(!scaleObject){return null}var type=scaleObject.type,domain=scaleObject.domain,range=scaleObject.range;var modDomain=domain[0]===domain[1]?domain[0]===0?[-1,0]:[-domain[0],domain[0]]:domain;if(type===LITERAL_SCALE_TYPE){return literalScale(range[0])}var scale=SCALE_FUNCTIONS[type]().domain(modDomain).range(range);if(type===ORDINAL_SCALE_TYPE){scale.padding(.5)}return scale}function getDomainByAccessor(allData,accessor,accessor0,type){var domain=void 0;var values=allData.reduce((function(data,d){var value=accessor(d);var value0=accessor0(d);if(_isDefined(value)){data.push(value)}if(_isDefined(value0)){data.push(value0)}return data}),[]);if(!values.length){return[]}if(type!==ORDINAL_SCALE_TYPE&&type!==CATEGORY_SCALE_TYPE){domain=(0,_d3Array.extent)(values)}else{domain=(0,_d3Collection.set)(values).values()}return domain}function _createScaleObjectForValue(attr,value,type,accessor,accessor0){if(type===LITERAL_SCALE_TYPE){return{type:LITERAL_SCALE_TYPE,domain:[],range:[value],distance:0,attr:attr,baseValue:undefined,isValue:true,accessor:accessor}}if(typeof value==="undefined"){return null}return{type:CATEGORY_SCALE_TYPE,range:[value],domain:[],distance:0,attr:attr,baseValue:undefined,isValue:true,accessor:accessor}}function _createScaleObjectForFunction(_ref){var domain=_ref.domain,range=_ref.range,type=_ref.type,distance=_ref.distance,attr=_ref.attr,baseValue=_ref.baseValue,accessor=_ref.accessor,accessor0=_ref.accessor0;return{domain:domain,range:range,type:type,distance:distance,attr:attr,baseValue:baseValue,isValue:false,accessor:accessor,accessor0:accessor0}}function _collectScaleObjectFromProps(props,attr){var value=props[attr],fallbackValue=props["_"+attr+"Value"],range=props[attr+"Range"],_props$=props[attr+"Distance"],distance=_props$===undefined?0:_props$,baseValue=props[attr+"BaseValue"],_props$2=props[attr+"Type"],type=_props$2===undefined?LINEAR_SCALE_TYPE:_props$2,noFallBack=props[attr+"NoFallBack"],_props$3=props["get"+toTitleCase(attr)],accessor=_props$3===undefined?function(d){return d[attr]}:_props$3,_props$4=props["get"+toTitleCase(attr)+"0"],accessor0=_props$4===undefined?function(d){return d[attr+"0"]}:_props$4;var domain=props[attr+"Domain"];if(!noFallBack&&typeof value!=="undefined"){return _createScaleObjectForValue(attr,value,props[attr+"Type"],accessor,accessor0)}if(typeof baseValue!=="undefined"){domain=(0,_dataUtils.addValueToArray)(domain,baseValue)}if(!range||!domain||!domain.length){return _createScaleObjectForValue(attr,fallbackValue,props[attr+"Type"],accessor,accessor0)}return _createScaleObjectForFunction({domain:domain,range:range,type:type,distance:distance,attr:attr,baseValue:baseValue,accessor:accessor,accessor0:accessor0})}function _computeLeftDomainAdjustment(values){if(values.length>1){return(values[1]-values[0])/2}if(values.length===1){return values[0]-.5}return 0}function _computeRightDomainAdjustment(values){if(values.length>1){return(values[values.length-1]-values[values.length-2])/2}if(values.length===1){return values[0]-.5}return 0}function _computeScaleDistance(values,domain,bestDistIndex,scaleFn){if(values.length>1){var i=Math.max(bestDistIndex,1);return Math.abs(scaleFn(values[i])-scaleFn(values[i-1]))}if(values.length===1){return Math.abs(scaleFn(domain[1])-scaleFn(domain[0]))}return 0}function _normalizeValues(data,values,accessor0,type){if(type===TIME_SCALE_TYPE&&values.length===1){var attr0=accessor0(data[0]);return[attr0].concat(_toConsumableArray(values))}return values}function _getScaleDistanceAndAdjustedDomain(data,scaleObject){var domain=scaleObject.domain,type=scaleObject.type,accessor=scaleObject.accessor,accessor0=scaleObject.accessor0;var uniqueValues=(0,_dataUtils.getUniquePropertyValues)(data,accessor);var values=_normalizeValues(data,uniqueValues,accessor0,type);var index=_getSmallestDistanceIndex(values,scaleObject);var adjustedDomain=[].concat(domain);adjustedDomain[0]-=_computeLeftDomainAdjustment(values);adjustedDomain[domain.length-1]+=_computeRightDomainAdjustment(values);if(type===LOG_SCALE_TYPE&&domain[0]<=0){adjustedDomain[0]=Math.min(domain[1]/10,1)}var adjustedScaleFn=getScaleFnFromScaleObject(_extends({},scaleObject,{domain:adjustedDomain}));var distance=_computeScaleDistance(values,adjustedDomain,index,adjustedScaleFn);return{domain0:adjustedDomain[0],domainN:adjustedDomain[adjustedDomain.length-1],distance:distance}}function _isScaleAdjustmentPossible(props,scaleObject){var attr=scaleObject.attr;var _props$_adjustBy=props._adjustBy,adjustBy=_props$_adjustBy===undefined?[]:_props$_adjustBy,_props$_adjustWhat=props._adjustWhat,adjustWhat=_props$_adjustWhat===undefined?[]:_props$_adjustWhat;return adjustWhat.length&&adjustBy.length&&adjustBy.indexOf(attr)!==-1}function _adjustContinuousScale(props,scaleObject){var allSeriesData=props._allData,_props$_adjustWhat2=props._adjustWhat,adjustWhat=_props$_adjustWhat2===undefined?[]:_props$_adjustWhat2;var domainLength=scaleObject.domain.length;var domain=scaleObject.domain;var scaleDomain0=domain[0];var scaleDomainN=domain[domainLength-1];var scaleDistance=scaleObject.distance;allSeriesData.forEach((function(data,index){if(adjustWhat.indexOf(index)===-1){return}if(data&&data.length){var _getScaleDistanceAndA=_getScaleDistanceAndAdjustedDomain(data,scaleObject),domain0=_getScaleDistanceAndA.domain0,domainN=_getScaleDistanceAndA.domainN,distance=_getScaleDistanceAndA.distance;scaleDomain0=Math.min(scaleDomain0,domain0);scaleDomainN=Math.max(scaleDomainN,domainN);scaleDistance=Math.max(scaleDistance,distance)}}));scaleObject.domain=[scaleDomain0].concat(_toConsumableArray(domain.slice(1,-1)),[scaleDomainN]);scaleObject.distance=scaleDistance;return scaleObject}function _adjustCategoricalScale(scaleObject){var scaleFn=getScaleFnFromScaleObject(scaleObject);var domain=scaleObject.domain,range=scaleObject.range;if(domain.length>1){scaleObject.distance=Math.abs(scaleFn(domain[1])-scaleFn(domain[0]))}else{scaleObject.distance=Math.abs(range[1]-range[0])}return scaleObject}function getScaleObjectFromProps(props,attr){var scaleObject=_collectScaleObjectFromProps(props,attr);if(!scaleObject){return null}if(!_isScaleAdjustmentPossible(props,scaleObject)){return scaleObject}var type=scaleObject.type;if(type===ORDINAL_SCALE_TYPE||type===CATEGORY_SCALE_TYPE){return _adjustCategoricalScale(scaleObject)}return _adjustContinuousScale(props,scaleObject)}function getAttributeScale(props,attr){var scaleObject=getScaleObjectFromProps(props,attr);return getScaleFnFromScaleObject(scaleObject)}function _getAttrValue(d,accessor){return accessor(d.data?d.data:d)}function _isDefined(value){return typeof value!=="undefined"}function _padDomain(domain,padding){if(!domain){return domain}if(isNaN(parseFloat(domain[0]))||isNaN(parseFloat(domain[1]))){return domain}var _domain=_slicedToArray(domain,2),min=_domain[0],max=_domain[1];var domainPadding=(max-min)*(padding*.01);return[min-domainPadding,max+domainPadding]}function getAttributeFunctor(props,attr){var scaleObject=getScaleObjectFromProps(props,attr);if(scaleObject){var scaleFn=getScaleFnFromScaleObject(scaleObject);return function(d){return scaleFn(_getAttrValue(d,scaleObject.accessor))}}return null}function getAttr0Functor(props,attr){var scaleObject=getScaleObjectFromProps(props,attr);if(scaleObject){var attr0=attr+"0";var domain=scaleObject.domain;var _scaleObject$baseValu=scaleObject.baseValue,baseValue=_scaleObject$baseValu===undefined?domain[0]:_scaleObject$baseValu;var scaleFn=getScaleFnFromScaleObject(scaleObject);return function(d){var value=_getAttrValue(d,(function(el){return el[attr0]}));return scaleFn(_isDefined(value)?value:baseValue)}}return null}function getAttributeValue(props,attr){var scaleObject=getScaleObjectFromProps(props,attr);if(scaleObject){if(!scaleObject.isValue&&props["_"+attr+"Value"]===undefined){(0,_reactUtils.warning)("[React-vis] Cannot use data defined "+attr+" for this "+"series type. Using fallback value instead.")}return props["_"+attr+"Value"]||scaleObject.range[0]}return null}function getScalePropTypesByAttribute(attr){var _ref2;return _ref2={},_defineProperty(_ref2,"_"+attr+"Value",_propTypes2.default.any),_defineProperty(_ref2,attr+"Domain",_propTypes2.default.array),_defineProperty(_ref2,"get"+toTitleCase(attr),_propTypes2.default.func),_defineProperty(_ref2,"get"+toTitleCase(attr)+"0",_propTypes2.default.func),_defineProperty(_ref2,attr+"Range",_propTypes2.default.array),_defineProperty(_ref2,attr+"Type",_propTypes2.default.oneOf(Object.keys(SCALE_FUNCTIONS))),_defineProperty(_ref2,attr+"Distance",_propTypes2.default.number),_defineProperty(_ref2,attr+"BaseValue",_propTypes2.default.any),_ref2}function extractScalePropsFromProps(props,attributes){var result={};Object.keys(props).forEach((function(key){var attr=attributes.find((function(a){var isPlainSet=key.indexOf(a)===0;var isUnderscoreSet=key.indexOf("_"+a)===0;var usesGet=key.indexOf("get"+toTitleCase(a))===0;return isPlainSet||isUnderscoreSet||usesGet}));if(!attr){return}result[key]=props[key]}));return result}function getMissingScaleProps(props,data,attributes){var result={};attributes.forEach((function(attr){if(!props["get"+toTitleCase(attr)]){result["get"+toTitleCase(attr)]=function(d){return d[attr]}}if(!props["get"+toTitleCase(attr)+"0"]){result["get"+toTitleCase(attr)+"0"]=function(d){return d[attr+"0"]}}if(!props[attr+"Domain"]){result[attr+"Domain"]=getDomainByAccessor(data,props["get"+toTitleCase(attr)]||result["get"+toTitleCase(attr)],props["get"+toTitleCase(attr)+"0"]||result["get"+toTitleCase(attr)+"0"],props[attr+"Type"]);if(props[attr+"Padding"]){result[attr+"Domain"]=_padDomain(result[attr+"Domain"],props[attr+"Padding"])}}}));return result}function literalScale(defaultValue){function scale(d){if(d===undefined){return defaultValue}return d}function response(){return scale}scale.domain=response;scale.range=response;scale.unknown=response;scale.copy=response;return scale}function getFontColorFromBackground(background){if(background){return(0,_d3Color.hsl)(background).l>.57?"#222":"#fff"}return null}function getXYPlotValues(props,children){var XYPlotScales=XYPLOT_ATTR.reduce((function(prev,attr){var domain=props[attr+"Domain"],range=props[attr+"Range"],type=props[attr+"Type"];if(domain&&range&&type){return _extends({},prev,_defineProperty({},attr,SCALE_FUNCTIONS[type]().domain(domain).range(range)))}return prev}),{});return children.map((function(child){return XYPLOT_ATTR.reduce((function(prev,attr){if(child.props&&child.props[attr]!==undefined){var scaleInput=child.props[attr];var scale=XYPlotScales[attr];var fallbackValue=scale?scale(scaleInput):scaleInput;return _extends({},prev,_defineProperty({},"_"+attr+"Value",fallbackValue))}return prev}),{})}))}var OPTIONAL_SCALE_PROPS=["Padding"];var OPTIONAL_SCALE_PROPS_REGS=OPTIONAL_SCALE_PROPS.map((function(str){return new RegExp(str+"$","i")}));function getOptionalScaleProps(props){return Object.keys(props).reduce((function(acc,prop){var propIsNotOptional=OPTIONAL_SCALE_PROPS_REGS.every((function(reg){return!prop.match(reg)}));if(propIsNotOptional){return acc}acc[prop]=props[prop];return acc}),{})}exports.default={extractScalePropsFromProps:extractScalePropsFromProps,getAttributeScale:getAttributeScale,getAttributeFunctor:getAttributeFunctor,getAttr0Functor:getAttr0Functor,getAttributeValue:getAttributeValue,getDomainByAccessor:getDomainByAccessor,getFontColorFromBackground:getFontColorFromBackground,getMissingScaleProps:getMissingScaleProps,getOptionalScaleProps:getOptionalScaleProps,getScaleObjectFromProps:getScaleObjectFromProps,getScalePropTypesByAttribute:getScalePropTypesByAttribute,getXYPlotValues:getXYPlotValues,literalScale:literalScale}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=curry;function curried(f,length,acc){return function fn(){var combined=acc.concat(Array.prototype.slice.call(arguments));return combined.length>=length?f.apply(this,combined):curried(f,length,combined)}}function curry(f){return curried(f,f.length,[])}module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var _=__webpack_require__(45);var Graph=__webpack_require__(69).Graph;module.exports={addDummyNode:addDummyNode,simplify:simplify,asNonCompoundGraph:asNonCompoundGraph,successorWeights:successorWeights,predecessorWeights:predecessorWeights,intersectRect:intersectRect,buildLayerMatrix:buildLayerMatrix,normalizeRanks:normalizeRanks,removeEmptyRanks:removeEmptyRanks,addBorderNode:addBorderNode,maxRank:maxRank,partition:partition,time:time,notime:notime};function addDummyNode(g,type,attrs,name){var v;do{v=_.uniqueId(name)}while(g.hasNode(v));attrs.dummy=type;g.setNode(v,attrs);return v}function simplify(g){var simplified=(new Graph).setGraph(g.graph());_.forEach(g.nodes(),(function(v){simplified.setNode(v,g.node(v))}));_.forEach(g.edges(),(function(e){var simpleLabel=simplified.edge(e.v,e.w)||{weight:0,minlen:1};var label=g.edge(e);simplified.setEdge(e.v,e.w,{weight:simpleLabel.weight+label.weight,minlen:Math.max(simpleLabel.minlen,label.minlen)})}));return simplified}function asNonCompoundGraph(g){var simplified=new Graph({multigraph:g.isMultigraph()}).setGraph(g.graph());_.forEach(g.nodes(),(function(v){if(!g.children(v).length){simplified.setNode(v,g.node(v))}}));_.forEach(g.edges(),(function(e){simplified.setEdge(e,g.edge(e))}));return simplified}function successorWeights(g){var weightMap=_.map(g.nodes(),(function(v){var sucs={};_.forEach(g.outEdges(v),(function(e){sucs[e.w]=(sucs[e.w]||0)+g.edge(e).weight}));return sucs}));return _.zipObject(g.nodes(),weightMap)}function predecessorWeights(g){var weightMap=_.map(g.nodes(),(function(v){var preds={};_.forEach(g.inEdges(v),(function(e){preds[e.v]=(preds[e.v]||0)+g.edge(e).weight}));return preds}));return _.zipObject(g.nodes(),weightMap)}function intersectRect(rect,point){var x=rect.x;var y=rect.y;var dx=point.x-x;var dy=point.y-y;var w=rect.width/2;var h=rect.height/2;if(!dx&&!dy){throw new Error("Not possible to find intersection inside of the rectangle")}var sx,sy;if(Math.abs(dy)*w>Math.abs(dx)*h){if(dy<0){h=-h}sx=h*dx/dy;sy=h}else{if(dx<0){w=-w}sx=w;sy=w*dy/dx}return{x:x+sx,y:y+sy}}function buildLayerMatrix(g){var layering=_.map(_.range(maxRank(g)+1),(function(){return[]}));_.forEach(g.nodes(),(function(v){var node=g.node(v);var rank=node.rank;if(!_.isUndefined(rank)){layering[rank][node.order]=v}}));return layering}function normalizeRanks(g){var min=_.min(_.map(g.nodes(),(function(v){return g.node(v).rank})));_.forEach(g.nodes(),(function(v){var node=g.node(v);if(_.has(node,"rank")){node.rank-=min}}))}function removeEmptyRanks(g){var offset=_.min(_.map(g.nodes(),(function(v){return g.node(v).rank})));var layers=[];_.forEach(g.nodes(),(function(v){var rank=g.node(v).rank-offset;if(!layers[rank]){layers[rank]=[]}layers[rank].push(v)}));var delta=0;var nodeRankFactor=g.graph().nodeRankFactor;_.forEach(layers,(function(vs,i){if(_.isUndefined(vs)&&i%nodeRankFactor!==0){--delta}else if(delta){_.forEach(vs,(function(v){g.node(v).rank+=delta}))}}))}function addBorderNode(g,prefix,rank,order){var node={width:0,height:0};if(arguments.length>=4){node.rank=rank;node.order=order}return addDummyNode(g,"border",node,prefix)}function maxRank(g){return _.max(_.map(g.nodes(),(function(v){var rank=g.node(v).rank;if(!_.isUndefined(rank)){return rank}})))}function partition(collection,fn){var result={lhs:[],rhs:[]};_.forEach(collection,(function(value){if(fn(value)){result.lhs.push(value)}else{result.rhs.push(value)}}));return result}function time(name,fn){var start=_.now();try{return fn()}finally{console.log(name+" time: "+(_.now()-start)+"ms")}}function notime(name,fn){return fn()}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return isFiniteNumber}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(12);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);function isFiniteNumber(value){return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isFinite"])(value)}},function(module,exports,__webpack_require__){"use strict";module.exports=markupTemplating;markupTemplating.displayName="markupTemplating";markupTemplating.aliases=[];function markupTemplating(Prism){(function(Prism){function getPlaceholder(language,index){return"___"+language.toUpperCase()+index+"___"}Object.defineProperties(Prism.languages["markup-templating"]={},{buildPlaceholders:{value:function(env,language,placeholderPattern,replaceFilter){if(env.language!==language){return}var tokenStack=env.tokenStack=[];env.code=env.code.replace(placeholderPattern,(function(match){if(typeof replaceFilter==="function"&&!replaceFilter(match)){return match}var i=tokenStack.length;var placeholder;while(env.code.indexOf(placeholder=getPlaceholder(language,i))!==-1)++i;tokenStack[i]=match;return placeholder}));env.grammar=Prism.languages.markup}},tokenizePlaceholders:{value:function(env,language){if(env.language!==language||!env.tokenStack){return}env.grammar=Prism.languages[language];var j=0;var keys=Object.keys(env.tokenStack);function walkTokens(tokens){for(var i=0;i<tokens.length;i++){if(j>=keys.length){break}var token=tokens[i];if(typeof token==="string"||token.content&&typeof token.content==="string"){var k=keys[j];var t=env.tokenStack[k];var s=typeof token==="string"?token:token.content;var placeholder=getPlaceholder(language,k);var index=s.indexOf(placeholder);if(index>-1){++j;var before=s.substring(0,index);var middle=new Prism.Token(language,Prism.tokenize(t,env.grammar),"language-"+language,t);var after=s.substring(index+placeholder.length);var replacement=[];if(before){replacement.push.apply(replacement,walkTokens([before]))}replacement.push(middle);if(after){replacement.push.apply(replacement,walkTokens([after]))}if(typeof token==="string"){tokens.splice.apply(tokens,[i,1].concat(replacement))}else{token.content=replacement}}}else if(token.content){walkTokens(token.content)}}return tokens}walkTokens(env.tokens)}}})})(Prism)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(172);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(113);var _rgba2=_interopRequireDefault(_rgba);var _hsl=__webpack_require__(245);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(247);var _hsla2=_interopRequireDefault(_hsla);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var isRgb=function isRgb(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isRgba=function isRgba(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&typeof color.alpha==="number"};var isHsl=function isHsl(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isHsla=function isHsla(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&typeof color.alpha==="number"};var errMsg="Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.";function toColorString(color){if(typeof color!=="object")throw new Error(errMsg);if(isRgba(color))return(0,_rgba2.default)(color);if(isRgb(color))return(0,_rgb2.default)(color);if(isHsla(color))return(0,_hsla2.default)(color);if(isHsl(color))return(0,_hsl2.default)(color);throw new Error(errMsg)}exports.default=toColorString;module.exports=exports["default"]},function(module,exports,__webpack_require__){var lodash;if(true){try{lodash={clone:__webpack_require__(1136),constant:__webpack_require__(199),each:__webpack_require__(507),filter:__webpack_require__(510),has:__webpack_require__(521),isArray:__webpack_require__(49),isEmpty:__webpack_require__(1212),isFunction:__webpack_require__(119),isUndefined:__webpack_require__(522),keys:__webpack_require__(80),map:__webpack_require__(523),reduce:__webpack_require__(525),size:__webpack_require__(1215),transform:__webpack_require__(1221),union:__webpack_require__(1222),values:__webpack_require__(530)}}catch(e){}}if(!lodash){lodash=window._}module.exports=lodash},function(module,exports){function isObject(value){var type=typeof value;return value!=null&&(type=="object"||type=="function")}module.exports=isObject},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DIRECTION=exports.ORIENTATION=undefined;exports.getTicksTotalFromSize=getTicksTotalFromSize;exports.getTickValues=getTickValues;exports.generateFit=generateFit;exports.generatePoints=generatePoints;exports.getAxisAngle=getAxisAngle;var _d3Array=__webpack_require__(106);var _d3Scale=__webpack_require__(93);var ORIENTATION=exports.ORIENTATION={TOP:"top",LEFT:"left",RIGHT:"right",BOTTOM:"bottom",VERTICAL:"vertical",HORIZONTAL:"horizontal"};var DIRECTION=exports.DIRECTION={VERTICAL:"vertical",HORIZONTAL:"horizontal"};function getTicksTotalFromSize(size){if(size<700){if(size>300){return 10}return 5}return 20}function getTickValues(scale,tickTotal,tickValues){return!tickValues?scale.ticks?scale.ticks(tickTotal):scale.domain():tickValues}function generateFit(axisStart,axisEnd){if(axisStart.x===axisEnd.x){return{left:axisStart.y,right:axisEnd.y,slope:0,offset:axisStart.x}}var slope=(axisStart.y-axisEnd.y)/(axisStart.x-axisEnd.x);return{left:axisStart.x,right:axisEnd.x,slope:slope,offset:axisStart.y-slope*axisStart.x}}function generatePoints(_ref){var axisStart=_ref.axisStart,axisEnd=_ref.axisEnd,numberOfTicks=_ref.numberOfTicks,axisDomain=_ref.axisDomain;var _generateFit=generateFit(axisStart,axisEnd),left=_generateFit.left,right=_generateFit.right,slope=_generateFit.slope,offset=_generateFit.offset;var pointSlope=(right-left)/numberOfTicks;var axisScale=(0,_d3Scale.scaleLinear)().domain([left,right]).range(axisDomain);var slopeVertical=axisStart.x===axisEnd.x;return{slope:slopeVertical?Infinity:slope,points:(0,_d3Array.range)(left,right+pointSlope,pointSlope).map((function(val){if(slopeVertical){return{y:val,x:slope*val+offset,text:axisScale(val)}}return{x:val,y:slope*val+offset,text:axisScale(val)}}))}}function getAxisAngle(axisStart,axisEnd){if(axisStart.x===axisEnd.x){return axisEnd.y>axisStart.y?Math.PI/2:3*Math.PI/2}return Math.atan((axisEnd.y-axisStart.y)/(axisEnd.x-axisStart.x))}exports.default={DIRECTION:DIRECTION,ORIENTATION:ORIENTATION,getTicksTotalFromSize:getTicksTotalFromSize,getTickValues:getTickValues}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(78);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _rgbToHsl=__webpack_require__(657);var _rgbToHsl2=_interopRequireDefault(_rgbToHsl);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function parseToHsl(color){return(0,_rgbToHsl2.default)((0,_parseToRgb2.default)(color))}exports.default=parseToHsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){var graphlib;if(true){try{graphlib=__webpack_require__(1134)}catch(e){}}if(!graphlib){graphlib=window.graphlib}module.exports=graphlib},function(module,exports,__webpack_require__){var freeGlobal=__webpack_require__(490);var freeSelf=typeof self=="object"&&self&&self.Object===Object&&self;var root=freeGlobal||freeSelf||Function("return this")();module.exports=root},function(module,exports){var g;g=function(){return this}();try{g=g||new Function("return this")()}catch(e){if(typeof window==="object")g=window}module.exports=g},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return TRANSACTION_PAGE_LOAD}));__webpack_require__.d(__webpack_exports__,"b",(function(){return TRANSACTION_REQUEST}));const TRANSACTION_PAGE_LOAD="page-load";const TRANSACTION_REQUEST="request";const TRANSACTION_ROUTE_CHANGE="route-change"},,function(module,exports){function isObjectLike(value){return value!=null&&typeof value=="object"}module.exports=isObjectLike},function(module,exports,__webpack_require__){var isFunction=__webpack_require__(119),isLength=__webpack_require__(193);function isArrayLike(value){return value!=null&&isLength(value.length)&&!isFunction(value)}module.exports=isArrayLike},function(module,exports,__webpack_require__){var baseMatches=__webpack_require__(1192),baseMatchesProperty=__webpack_require__(1202),identity=__webpack_require__(92),isArray=__webpack_require__(49),property=__webpack_require__(1209);function baseIteratee(value){if(typeof value=="function"){return value}if(value==null){return identity}if(typeof value=="object"){return isArray(value)?baseMatchesProperty(value[0],value[1]):baseMatches(value)}return property(value)}module.exports=baseIteratee},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(171);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _nameToHex=__webpack_require__(656);var _nameToHex2=_interopRequireDefault(_nameToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var hexRegex=/^#[a-fA-F0-9]{6}$/;var reducedHexRegex=/^#[a-fA-F0-9]{3}$/;var rgbRegex=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/;var rgbaRegex=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;var hslRegex=/^hsl\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*\)$/;var hslaRegex=/^hsla\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;function parseToRgb(color){if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}var normalizedColor=(0,_nameToHex2.default)(color);if(normalizedColor.match(hexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[2],16),green:parseInt(""+normalizedColor[3]+normalizedColor[4],16),blue:parseInt(""+normalizedColor[5]+normalizedColor[6],16)}}if(normalizedColor.match(reducedHexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[1],16),green:parseInt(""+normalizedColor[2]+normalizedColor[2],16),blue:parseInt(""+normalizedColor[3]+normalizedColor[3],16)}}var rgbMatched=rgbRegex.exec(normalizedColor);if(rgbMatched){return{red:parseInt(""+rgbMatched[1],10),green:parseInt(""+rgbMatched[2],10),blue:parseInt(""+rgbMatched[3],10)}}var rgbaMatched=rgbaRegex.exec(normalizedColor);if(rgbaMatched){return{red:parseInt(""+rgbaMatched[1],10),green:parseInt(""+rgbaMatched[2],10),blue:parseInt(""+rgbaMatched[3],10),alpha:parseFloat(""+rgbaMatched[4])}}var hslMatched=hslRegex.exec(normalizedColor);if(hslMatched){var hue=parseInt(""+hslMatched[1],10);var saturation=parseInt(""+hslMatched[2],10)/100;var lightness=parseInt(""+hslMatched[3],10)/100;var rgbColorString="rgb("+(0,_hslToRgb2.default)(hue,saturation,lightness)+")";var hslRgbMatched=rgbRegex.exec(rgbColorString);return{red:parseInt(""+hslRgbMatched[1],10),green:parseInt(""+hslRgbMatched[2],10),blue:parseInt(""+hslRgbMatched[3],10)}}var hslaMatched=hslaRegex.exec(normalizedColor);if(hslaMatched){var _hue=parseInt(""+hslaMatched[1],10);var _saturation=parseInt(""+hslaMatched[2],10)/100;var _lightness=parseInt(""+hslaMatched[3],10)/100;var _rgbColorString="rgb("+(0,_hslToRgb2.default)(_hue,_saturation,_lightness)+")";var _hslRgbMatched=rgbRegex.exec(_rgbColorString);return{red:parseInt(""+_hslRgbMatched[1],10),green:parseInt(""+_hslRgbMatched[2],10),blue:parseInt(""+_hslRgbMatched[3],10),alpha:parseFloat(""+hslaMatched[4])}}throw new Error("Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.")}exports.default=parseToRgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";module.exports=c;c.displayName="c";c.aliases=[];function c(Prism){Prism.languages.c=Prism.languages.extend("clike",{comment:{pattern:/\/\/(?:[^\r\n\\]|\\(?:\r\n?|\n|(?![\r\n])))*|\/\*[\s\S]*?(?:\*\/|$)/,greedy:true},"class-name":{pattern:/(\b(?:enum|struct)\s+(?:__attribute__\s*\(\([\s\S]*?\)\)\s*)?)\w+/,lookbehind:true},keyword:/\b(?:__attribute__|_Alignas|_Alignof|_Atomic|_Bool|_Complex|_Generic|_Imaginary|_Noreturn|_Static_assert|_Thread_local|asm|typeof|inline|auto|break|case|char|const|continue|default|do|double|else|enum|extern|float|for|goto|if|int|long|register|return|short|signed|sizeof|static|struct|switch|typedef|union|unsigned|void|volatile|while)\b/,function:/[a-z_]\w*(?=\s*\()/i,operator:/>>=?|<<=?|->|([-+&|:])\1|[?:~]|[-+*/%&|^!=<>]=?/,number:/(?:\b0x(?:[\da-f]+\.?[\da-f]*|\.[\da-f]+)(?:p[+-]?\d+)?|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?)[ful]*/i});Prism.languages.insertBefore("c","string",{macro:{pattern:/(^\s*)#\s*[a-z]+(?:[^\r\n\\/]|\/(?!\*)|\/\*(?:[^*]|\*(?!\/))*\*\/|\\(?:\r\n|[\s\S]))*/im,lookbehind:true,greedy:true,alias:"property",inside:{string:[{pattern:/^(#\s*include\s*)<[^>]+>/,lookbehind:true},Prism.languages.c["string"]],comment:Prism.languages.c["comment"],directive:{pattern:/^(#\s*)[a-z]+/,lookbehind:true,alias:"keyword"},"directive-hash":/^#/,punctuation:/##|\\(?=[\r\n])/,expression:{pattern:/\S[\s\S]*/,inside:Prism.languages.c}}},constant:/\b(?:__FILE__|__LINE__|__DATE__|__TIME__|__TIMESTAMP__|__func__|EOF|NULL|SEEK_CUR|SEEK_END|SEEK_SET|stdin|stdout|stderr)\b/});delete Prism.languages.c["boolean"]}},function(module,exports,__webpack_require__){var arrayLikeKeys=__webpack_require__(493),baseKeys=__webpack_require__(195),isArrayLike=__webpack_require__(75);function keys(object){return isArrayLike(object)?arrayLikeKeys(object):baseKeys(object)}module.exports=keys},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _deepEqual=__webpack_require__(1341);var _deepEqual2=_interopRequireDefault(_deepEqual);var _scalesUtils=__webpack_require__(59);var _seriesUtils=__webpack_require__(56);var _chartUtils=__webpack_require__(95);var _reactUtils=__webpack_require__(107);var _animation=__webpack_require__(44);var _theme=__webpack_require__(52);var _canvasWrapper=__webpack_require__(1367);var _canvasWrapper2=_interopRequireDefault(_canvasWrapper);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var ATTRIBUTES=["x","y","radius","angle","color","fill","stroke","opacity","size"];var DEFAULT_MARGINS={left:40,right:10,top:10,bottom:40};function cleanseData(data){return data.map((function(series){if(!Array.isArray(series)){return series}return series.map((function(row){return _extends({},row,{parent:null})}))}))}function checkIfMixinsAreEqual(nextScaleMixins,scaleMixins,hasTreeStructure){var newMixins=_extends({},nextScaleMixins,{_allData:hasTreeStructure?cleanseData(nextScaleMixins._allData):nextScaleMixins._allData});var oldMixins=_extends({},scaleMixins,{_allData:hasTreeStructure?cleanseData(scaleMixins._allData):scaleMixins._allData});return(0,_deepEqual2.default)(newMixins,oldMixins)}var XYPlot=function(_React$Component){_inherits(XYPlot,_React$Component);_createClass(XYPlot,null,[{key:"propTypes",get:function get(){return{animation:_animation.AnimationPropType,className:_propTypes2.default.string,dontCheckIfEmpty:_propTypes2.default.bool,height:_propTypes2.default.number.isRequired,margin:_chartUtils.MarginPropType,onClick:_propTypes2.default.func,onDoubleClick:_propTypes2.default.func,onMouseDown:_propTypes2.default.func,onMouseEnter:_propTypes2.default.func,onMouseLeave:_propTypes2.default.func,onMouseMove:_propTypes2.default.func,onWheel:_propTypes2.default.func,stackBy:_propTypes2.default.oneOf(ATTRIBUTES),style:_propTypes2.default.object,width:_propTypes2.default.number.isRequired}}},{key:"defaultProps",get:function get(){return{className:""}}}]);function XYPlot(props){_classCallCheck(this,XYPlot);var _this=_possibleConstructorReturn(this,(XYPlot.__proto__||Object.getPrototypeOf(XYPlot)).call(this,props));_this._clickHandler=_this._clickHandler.bind(_this);_this._doubleClickHandler=_this._doubleClickHandler.bind(_this);_this._mouseDownHandler=_this._mouseDownHandler.bind(_this);_this._mouseLeaveHandler=_this._mouseLeaveHandler.bind(_this);_this._mouseEnterHandler=_this._mouseEnterHandler.bind(_this);_this._mouseMoveHandler=_this._mouseMoveHandler.bind(_this);_this._wheelHandler=_this._wheelHandler.bind(_this);var stackBy=props.stackBy;var children=(0,_seriesUtils.getSeriesChildren)(props.children);var data=(0,_seriesUtils.getStackedData)(children,stackBy);_this.state={scaleMixins:_this._getScaleMixins(data,props),data:data};return _this}_createClass(XYPlot,[{key:"componentDidMount",value:function componentDidMount(){(0,_reactUtils.checkIfStyleSheetIsImported)()}},{key:"componentWillReceiveProps",value:function componentWillReceiveProps(nextProps){var children=(0,_seriesUtils.getSeriesChildren)(nextProps.children);var nextData=(0,_seriesUtils.getStackedData)(children,nextProps.stackBy);var scaleMixins=this.state.scaleMixins;var nextScaleMixins=this._getScaleMixins(nextData,nextProps);if(!checkIfMixinsAreEqual(nextScaleMixins,scaleMixins,nextProps.hasTreeStructure)){this.setState({scaleMixins:nextScaleMixins,data:nextData})}}},{key:"_clickHandler",value:function _clickHandler(event){var onClick=this.props.onClick;if(onClick){onClick(event)}}},{key:"_doubleClickHandler",value:function _doubleClickHandler(event){var onDoubleClick=this.props.onDoubleClick;if(onDoubleClick){onDoubleClick(event)}}},{key:"_mouseDownHandler",value:function _mouseDownHandler(event){var _this2=this;var _props=this.props,onMouseDown=_props.onMouseDown,children=_props.children;if(onMouseDown){onMouseDown(event)}var seriesChildren=(0,_seriesUtils.getSeriesChildren)(children);seriesChildren.forEach((function(child,index){var component=_this2.refs["series"+index];if(component&&component.onParentMouseDown){component.onParentMouseDown(event)}}))}},{key:"_mouseMoveHandler",value:function _mouseMoveHandler(event){var _this3=this;var _props2=this.props,onMouseMove=_props2.onMouseMove,children=_props2.children;if(onMouseMove){onMouseMove(event)}var seriesChildren=(0,_seriesUtils.getSeriesChildren)(children);seriesChildren.forEach((function(child,index){var component=_this3.refs["series"+index];if(component&&component.onParentMouseMove){component.onParentMouseMove(event)}}))}},{key:"_mouseLeaveHandler",value:function _mouseLeaveHandler(event){var onMouseLeave=this.props.onMouseLeave;if(onMouseLeave){onMouseLeave({event:event})}}},{key:"_mouseEnterHandler",value:function _mouseEnterHandler(event){var onMouseEnter=this.props.onMouseEnter;if(onMouseEnter){onMouseEnter({event:event})}}},{key:"_wheelHandler",value:function _wheelHandler(event){var onWheel=this.props.onWheel;if(onWheel){onWheel(event)}}},{key:"_getDefaultScaleProps",value:function _getDefaultScaleProps(props){var _getInnerDimensions=(0,_chartUtils.getInnerDimensions)(props,DEFAULT_MARGINS),innerWidth=_getInnerDimensions.innerWidth,innerHeight=_getInnerDimensions.innerHeight;var colorRanges=["color","fill","stroke"].reduce((function(acc,attr){var range=props[attr+"Type"]==="category"?_theme.EXTENDED_DISCRETE_COLOR_RANGE:_theme.CONTINUOUS_COLOR_RANGE;return _extends({},acc,_defineProperty({},attr+"Range",range))}),{});return _extends({xRange:[0,innerWidth],yRange:[innerHeight,0]},colorRanges,{opacityType:_theme.OPACITY_TYPE,sizeRange:_theme.SIZE_RANGE})}},{key:"_getScaleMixins",value:function _getScaleMixins(data,props){var _ref;var filteredData=data.filter((function(d){return d}));var allData=(_ref=[]).concat.apply(_ref,_toConsumableArray(filteredData));var defaultScaleProps=this._getDefaultScaleProps(props);var optionalScaleProps=(0,_scalesUtils.getOptionalScaleProps)(props);var userScaleProps=(0,_scalesUtils.extractScalePropsFromProps)(props,ATTRIBUTES);var missingScaleProps=(0,_scalesUtils.getMissingScaleProps)(_extends({},defaultScaleProps,optionalScaleProps,userScaleProps),allData,ATTRIBUTES);var children=(0,_seriesUtils.getSeriesChildren)(props.children);var zeroBaseProps={};var adjustBy=new Set;var adjustWhat=new Set;children.forEach((function(child,index){if(!child||!data[index]){return}ATTRIBUTES.forEach((function(attr){var _child$type$getParent=child.type.getParentConfig(attr,child.props),isDomainAdjustmentNeeded=_child$type$getParent.isDomainAdjustmentNeeded,zeroBaseValue=_child$type$getParent.zeroBaseValue;if(isDomainAdjustmentNeeded){adjustBy.add(attr);adjustWhat.add(index)}if(zeroBaseValue){var specifiedDomain=props[attr+"Domain"];zeroBaseProps[attr+"BaseValue"]=specifiedDomain?specifiedDomain[0]:0}}))}));return _extends({},defaultScaleProps,zeroBaseProps,userScaleProps,missingScaleProps,{_allData:data,_adjustBy:Array.from(adjustBy),_adjustWhat:Array.from(adjustWhat),_stackBy:props.stackBy})}},{key:"_isPlotEmpty",value:function _isPlotEmpty(){var data=this.state.data;return!data||!data.length||!data.some((function(series){return series&&series.some((function(d){return d}))}))}},{key:"_getClonedChildComponents",value:function _getClonedChildComponents(){var props=this.props;var animation=this.props.animation;var _state=this.state,scaleMixins=_state.scaleMixins,data=_state.data;var dimensions=(0,_chartUtils.getInnerDimensions)(this.props,DEFAULT_MARGINS);var children=_react2.default.Children.toArray(this.props.children);var seriesProps=(0,_seriesUtils.getSeriesPropsFromChildren)(children);var XYPlotValues=(0,_scalesUtils.getXYPlotValues)(props,children);return children.map((function(child,index){var dataProps=null;if(seriesProps[index]){var seriesIndex=seriesProps[index].seriesIndex;dataProps={data:data[seriesIndex]}}return _react2.default.cloneElement(child,_extends({},dimensions,{animation:animation},seriesProps[index],scaleMixins,child.props,XYPlotValues[index],dataProps))}))}},{key:"renderCanvasComponents",value:function renderCanvasComponents(components,props){var componentsToRender=components.filter((function(c){return c&&!c.type.requiresSVG&&c.type.isCanvas}));if(componentsToRender.length===0){return null}var _componentsToRender$=componentsToRender[0].props,marginLeft=_componentsToRender$.marginLeft,marginTop=_componentsToRender$.marginTop,marginBottom=_componentsToRender$.marginBottom,marginRight=_componentsToRender$.marginRight,innerHeight=_componentsToRender$.innerHeight,innerWidth=_componentsToRender$.innerWidth;return _react2.default.createElement(_canvasWrapper2.default,{innerHeight:innerHeight,innerWidth:innerWidth,marginLeft:marginLeft,marginTop:marginTop,marginBottom:marginBottom,marginRight:marginRight},componentsToRender)}},{key:"render",value:function render(){var _props3=this.props,className=_props3.className,dontCheckIfEmpty=_props3.dontCheckIfEmpty,style=_props3.style,width=_props3.width,height=_props3.height;if(!dontCheckIfEmpty&&this._isPlotEmpty()){return _react2.default.createElement("div",{className:"rv-xy-plot "+className,style:_extends({width:width+"px",height:height+"px"},this.props.style)})}var components=this._getClonedChildComponents();return _react2.default.createElement("div",{style:{width:width+"px",height:height+"px"},className:"rv-xy-plot "+className},_react2.default.createElement("svg",{className:"rv-xy-plot__inner",width:width,height:height,style:style,onClick:this._clickHandler,onDoubleClick:this._doubleClickHandler,onMouseDown:this._mouseDownHandler,onMouseMove:this._mouseMoveHandler,onMouseLeave:this._mouseLeaveHandler,onMouseEnter:this._mouseEnterHandler,onWheel:this._wheelHandler},components.filter((function(c){return c&&c.type.requiresSVG}))),this.renderCanvasComponents(components,this.props),components.filter((function(c){return c&&!c.type.requiresSVG&&!c.type.isCanvas})))}}]);return XYPlot}(_react2.default.Component);XYPlot.displayName="XYPlot";exports.default=XYPlot},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return APMServiceContext}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ApmServiceContextProvider}));var external_kbnSharedDeps_React_=__webpack_require__(2);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var agent_name=__webpack_require__(58);var transaction_types=__webpack_require__(72);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(11);var use_fetcher=__webpack_require__(37);var use_url_params=__webpack_require__(36);const INITIAL_DATA={transactionTypes:[]};function useServiceTransactionTypesFetcher(){const{serviceName:serviceName}=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();const{urlParams:urlParams}=Object(use_url_params["a"])();const{start:start,end:end}=urlParams;const{data:data=INITIAL_DATA}=Object(use_fetcher["b"])(callApmApi=>{if(serviceName&&start&&end){return callApmApi({endpoint:"GET /api/apm/services/{serviceName}/transaction_types",params:{path:{serviceName:serviceName},query:{start:start,end:end}}})}},[serviceName,start,end]);return data.transactionTypes}function useServiceAgentNameFetcher(){const{serviceName:serviceName}=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();const{urlParams:urlParams}=Object(use_url_params["a"])();const{start:start,end:end}=urlParams;const{data:data,error:error,status:status}=Object(use_fetcher["b"])(callApmApi=>{if(serviceName&&start&&end){return callApmApi({endpoint:"GET /api/apm/services/{serviceName}/agent_name",params:{path:{serviceName:serviceName},query:{start:start,end:end}}})}},[serviceName,start,end]);return{agentName:data===null||data===void 0?void 0:data.agentName,status:status,error:error}}const APMServiceContext=Object(external_kbnSharedDeps_React_["createContext"])({transactionTypes:[]});function ApmServiceContextProvider({children:children}){const{urlParams:urlParams}=Object(use_url_params["a"])();const{agentName:agentName}=useServiceAgentNameFetcher();const transactionTypes=useServiceTransactionTypesFetcher();const transactionType=getTransactionType({urlParams:urlParams,transactionTypes:transactionTypes,agentName:agentName});return external_kbnSharedDeps_React_default.a.createElement(APMServiceContext.Provider,{value:{agentName:agentName,transactionType:transactionType,transactionTypes:transactionTypes},children:children})}function getTransactionType({urlParams:urlParams,transactionTypes:transactionTypes,agentName:agentName}){if(urlParams.transactionType){return urlParams.transactionType}if(!agentName||transactionTypes.length===0){return}const defaultTransactionType=Object(agent_name["d"])(agentName)?transaction_types["a"]:transaction_types["b"];return transactionTypes.includes(defaultTransactionType)?defaultTransactionType:transactionTypes[0]}},,,,function(module,exports,__webpack_require__){"use strict";var punycode=__webpack_require__(631);var util=__webpack_require__(632);exports.parse=urlParse;exports.resolve=urlResolve;exports.resolveObject=urlResolveObject;exports.format=urlFormat;exports.Url=Url;function Url(){this.protocol=null;this.slashes=null;this.auth=null;this.host=null;this.port=null;this.hostname=null;this.hash=null;this.search=null;this.query=null;this.pathname=null;this.path=null;this.href=null}var protocolPattern=/^([a-z0-9.+-]+:)/i,portPattern=/:[0-9]*$/,simplePathPattern=/^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,delims=["<",">",'"',"`"," ","\r","\n","\t"],unwise=["{","}","|","\\","^","`"].concat(delims),autoEscape=["'"].concat(unwise),nonHostChars=["%","/","?",";","#"].concat(autoEscape),hostEndingChars=["/","?","#"],hostnameMaxLen=255,hostnamePartPattern=/^[+a-z0-9A-Z_-]{0,63}$/,hostnamePartStart=/^([+a-z0-9A-Z_-]{0,63})(.*)$/,unsafeProtocol={javascript:true,"javascript:":true},hostlessProtocol={javascript:true,"javascript:":true},slashedProtocol={http:true,https:true,ftp:true,gopher:true,file:true,"http:":true,"https:":true,"ftp:":true,"gopher:":true,"file:":true},querystring=__webpack_require__(633);function urlParse(url,parseQueryString,slashesDenoteHost){if(url&&util.isObject(url)&&url instanceof Url)return url;var u=new Url;u.parse(url,parseQueryString,slashesDenoteHost);return u}Url.prototype.parse=function(url,parseQueryString,slashesDenoteHost){if(!util.isString(url)){throw new TypeError("Parameter 'url' must be a string, not "+typeof url)}var queryIndex=url.indexOf("?"),splitter=queryIndex!==-1&&queryIndex<url.indexOf("#")?"?":"#",uSplit=url.split(splitter),slashRegex=/\\/g;uSplit[0]=uSplit[0].replace(slashRegex,"/");url=uSplit.join(splitter);var rest=url;rest=rest.trim();if(!slashesDenoteHost&&url.split("#").length===1){var simplePath=simplePathPattern.exec(rest);if(simplePath){this.path=rest;this.href=rest;this.pathname=simplePath[1];if(simplePath[2]){this.search=simplePath[2];if(parseQueryString){this.query=querystring.parse(this.search.substr(1))}else{this.query=this.search.substr(1)}}else if(parseQueryString){this.search="";this.query={}}return this}}var proto=protocolPattern.exec(rest);if(proto){proto=proto[0];var lowerProto=proto.toLowerCase();this.protocol=lowerProto;rest=rest.substr(proto.length)}if(slashesDenoteHost||proto||rest.match(/^\/\/[^@\/]+@[^@\/]+/)){var slashes=rest.substr(0,2)==="//";if(slashes&&!(proto&&hostlessProtocol[proto])){rest=rest.substr(2);this.slashes=true}}if(!hostlessProtocol[proto]&&(slashes||proto&&!slashedProtocol[proto])){var hostEnd=-1;for(var i=0;i<hostEndingChars.length;i++){var hec=rest.indexOf(hostEndingChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd))hostEnd=hec}var auth,atSign;if(hostEnd===-1){atSign=rest.lastIndexOf("@")}else{atSign=rest.lastIndexOf("@",hostEnd)}if(atSign!==-1){auth=rest.slice(0,atSign);rest=rest.slice(atSign+1);this.auth=decodeURIComponent(auth)}hostEnd=-1;for(var i=0;i<nonHostChars.length;i++){var hec=rest.indexOf(nonHostChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd))hostEnd=hec}if(hostEnd===-1)hostEnd=rest.length;this.host=rest.slice(0,hostEnd);rest=rest.slice(hostEnd);this.parseHost();this.hostname=this.hostname||"";var ipv6Hostname=this.hostname[0]==="["&&this.hostname[this.hostname.length-1]==="]";if(!ipv6Hostname){var hostparts=this.hostname.split(/\./);for(var i=0,l=hostparts.length;i<l;i++){var part=hostparts[i];if(!part)continue;if(!part.match(hostnamePartPattern)){var newpart="";for(var j=0,k=part.length;j<k;j++){if(part.charCodeAt(j)>127){newpart+="x"}else{newpart+=part[j]}}if(!newpart.match(hostnamePartPattern)){var validParts=hostparts.slice(0,i);var notHost=hostparts.slice(i+1);var bit=part.match(hostnamePartStart);if(bit){validParts.push(bit[1]);notHost.unshift(bit[2])}if(notHost.length){rest="/"+notHost.join(".")+rest}this.hostname=validParts.join(".");break}}}}if(this.hostname.length>hostnameMaxLen){this.hostname=""}else{this.hostname=this.hostname.toLowerCase()}if(!ipv6Hostname){this.hostname=punycode.toASCII(this.hostname)}var p=this.port?":"+this.port:"";var h=this.hostname||"";this.host=h+p;this.href+=this.host;if(ipv6Hostname){this.hostname=this.hostname.substr(1,this.hostname.length-2);if(rest[0]!=="/"){rest="/"+rest}}}if(!unsafeProtocol[lowerProto]){for(var i=0,l=autoEscape.length;i<l;i++){var ae=autoEscape[i];if(rest.indexOf(ae)===-1)continue;var esc=encodeURIComponent(ae);if(esc===ae){esc=escape(ae)}rest=rest.split(ae).join(esc)}}var hash=rest.indexOf("#");if(hash!==-1){this.hash=rest.substr(hash);rest=rest.slice(0,hash)}var qm=rest.indexOf("?");if(qm!==-1){this.search=rest.substr(qm);this.query=rest.substr(qm+1);if(parseQueryString){this.query=querystring.parse(this.query)}rest=rest.slice(0,qm)}else if(parseQueryString){this.search="";this.query={}}if(rest)this.pathname=rest;if(slashedProtocol[lowerProto]&&this.hostname&&!this.pathname){this.pathname="/"}if(this.pathname||this.search){var p=this.pathname||"";var s=this.search||"";this.path=p+s}this.href=this.format();return this};function urlFormat(obj){if(util.isString(obj))obj=urlParse(obj);if(!(obj instanceof Url))return Url.prototype.format.call(obj);return obj.format()}Url.prototype.format=function(){var auth=this.auth||"";if(auth){auth=encodeURIComponent(auth);auth=auth.replace(/%3A/i,":");auth+="@"}var protocol=this.protocol||"",pathname=this.pathname||"",hash=this.hash||"",host=false,query="";if(this.host){host=auth+this.host}else if(this.hostname){host=auth+(this.hostname.indexOf(":")===-1?this.hostname:"["+this.hostname+"]");if(this.port){host+=":"+this.port}}if(this.query&&util.isObject(this.query)&&Object.keys(this.query).length){query=querystring.stringify(this.query)}var search=this.search||query&&"?"+query||"";if(protocol&&protocol.substr(-1)!==":")protocol+=":";if(this.slashes||(!protocol||slashedProtocol[protocol])&&host!==false){host="//"+(host||"");if(pathname&&pathname.charAt(0)!=="/")pathname="/"+pathname}else if(!host){host=""}if(hash&&hash.charAt(0)!=="#")hash="#"+hash;if(search&&search.charAt(0)!=="?")search="?"+search;pathname=pathname.replace(/[?#]/g,(function(match){return encodeURIComponent(match)}));search=search.replace("#","%23");return protocol+host+pathname+search+hash};function urlResolve(source,relative){return urlParse(source,false,true).resolve(relative)}Url.prototype.resolve=function(relative){return this.resolveObject(urlParse(relative,false,true)).format()};function urlResolveObject(source,relative){if(!source)return relative;return urlParse(source,false,true).resolveObject(relative)}Url.prototype.resolveObject=function(relative){if(util.isString(relative)){var rel=new Url;rel.parse(relative,false,true);relative=rel}var result=new Url;var tkeys=Object.keys(this);for(var tk=0;tk<tkeys.length;tk++){var tkey=tkeys[tk];result[tkey]=this[tkey]}result.hash=relative.hash;if(relative.href===""){result.href=result.format();return result}if(relative.slashes&&!relative.protocol){var rkeys=Object.keys(relative);for(var rk=0;rk<rkeys.length;rk++){var rkey=rkeys[rk];if(rkey!=="protocol")result[rkey]=relative[rkey]}if(slashedProtocol[result.protocol]&&result.hostname&&!result.pathname){result.path=result.pathname="/"}result.href=result.format();return result}if(relative.protocol&&relative.protocol!==result.protocol){if(!slashedProtocol[relative.protocol]){var keys=Object.keys(relative);for(var v=0;v<keys.length;v++){var k=keys[v];result[k]=relative[k]}result.href=result.format();return result}result.protocol=relative.protocol;if(!relative.host&&!hostlessProtocol[relative.protocol]){var relPath=(relative.pathname||"").split("/");while(relPath.length&&!(relative.host=relPath.shift()));if(!relative.host)relative.host="";if(!relative.hostname)relative.hostname="";if(relPath[0]!=="")relPath.unshift("");if(relPath.length<2)relPath.unshift("");result.pathname=relPath.join("/")}else{result.pathname=relative.pathname}result.search=relative.search;result.query=relative.query;result.host=relative.host||"";result.auth=relative.auth;result.hostname=relative.hostname||relative.host;result.port=relative.port;if(result.pathname||result.search){var p=result.pathname||"";var s=result.search||"";result.path=p+s}result.slashes=result.slashes||relative.slashes;result.href=result.format();return result}var isSourceAbs=result.pathname&&result.pathname.charAt(0)==="/",isRelAbs=relative.host||relative.pathname&&relative.pathname.charAt(0)==="/",mustEndAbs=isRelAbs||isSourceAbs||result.host&&relative.pathname,removeAllDots=mustEndAbs,srcPath=result.pathname&&result.pathname.split("/")||[],relPath=relative.pathname&&relative.pathname.split("/")||[],psychotic=result.protocol&&!slashedProtocol[result.protocol];if(psychotic){result.hostname="";result.port=null;if(result.host){if(srcPath[0]==="")srcPath[0]=result.host;else srcPath.unshift(result.host)}result.host="";if(relative.protocol){relative.hostname=null;relative.port=null;if(relative.host){if(relPath[0]==="")relPath[0]=relative.host;else relPath.unshift(relative.host)}relative.host=null}mustEndAbs=mustEndAbs&&(relPath[0]===""||srcPath[0]==="")}if(isRelAbs){result.host=relative.host||relative.host===""?relative.host:result.host;result.hostname=relative.hostname||relative.hostname===""?relative.hostname:result.hostname;result.search=relative.search;result.query=relative.query;srcPath=relPath}else if(relPath.length){if(!srcPath)srcPath=[];srcPath.pop();srcPath=srcPath.concat(relPath);result.search=relative.search;result.query=relative.query}else if(!util.isNullOrUndefined(relative.search)){if(psychotic){result.hostname=result.host=srcPath.shift();var authInHost=result.host&&result.host.indexOf("@")>0?result.host.split("@"):false;if(authInHost){result.auth=authInHost.shift();result.host=result.hostname=authInHost.shift()}}result.search=relative.search;result.query=relative.query;if(!util.isNull(result.pathname)||!util.isNull(result.search)){result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")}result.href=result.format();return result}if(!srcPath.length){result.pathname=null;if(result.search){result.path="/"+result.search}else{result.path=null}result.href=result.format();return result}var last=srcPath.slice(-1)[0];var hasTrailingSlash=(result.host||relative.host||srcPath.length>1)&&(last==="."||last==="..")||last==="";var up=0;for(var i=srcPath.length;i>=0;i--){last=srcPath[i];if(last==="."){srcPath.splice(i,1)}else if(last===".."){srcPath.splice(i,1);up++}else if(up){srcPath.splice(i,1);up--}}if(!mustEndAbs&&!removeAllDots){for(;up--;up){srcPath.unshift("..")}}if(mustEndAbs&&srcPath[0]!==""&&(!srcPath[0]||srcPath[0].charAt(0)!=="/")){srcPath.unshift("")}if(hasTrailingSlash&&srcPath.join("/").substr(-1)!=="/"){srcPath.push("")}var isAbsolute=srcPath[0]===""||srcPath[0]&&srcPath[0].charAt(0)==="/";if(psychotic){result.hostname=result.host=isAbsolute?"":srcPath.length?srcPath.shift():"";var authInHost=result.host&&result.host.indexOf("@")>0?result.host.split("@"):false;if(authInHost){result.auth=authInHost.shift();result.host=result.hostname=authInHost.shift()}}mustEndAbs=mustEndAbs||result.host&&srcPath.length;if(mustEndAbs&&!isAbsolute){srcPath.unshift("")}if(!srcPath.length){result.pathname=null;result.path=null}else{result.pathname=srcPath.join("/")}if(!util.isNull(result.pathname)||!util.isNull(result.search)){result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")}result.auth=relative.auth||result.auth;result.slashes=result.slashes||relative.slashes;result.href=result.format();return result};Url.prototype.parseHost=function(){var host=this.host;var port=portPattern.exec(host);if(port){port=port[0];if(port!==":"){this.port=port.substr(1)}host=host.substr(0,host.length-port.length)}if(host)this.hostname=host}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(240);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["Top","Right","Bottom","Left"];function generateProperty(property,position){if(!property)return position.toLowerCase();var splitProperty=property.split("-");if(splitProperty.length>1){splitProperty.splice(1,0,position);return splitProperty.reduce((function(acc,val){return""+acc+(0,_capitalizeString2.default)(val)}))}var joinedProperty=property.replace(/([a-z])([A-Z])/g,"$1"+position+"$2");return property===joinedProperty?""+property+position:joinedProperty}function generateStyles(property,valuesWithDefaults){var styles={};for(var i=0;i<valuesWithDefaults.length;i+=1){if(valuesWithDefaults[i]||valuesWithDefaults[i]===0){styles[generateProperty(property,positionMap[i])]=valuesWithDefaults[i]}}return styles}function directionalProperty(property){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}var firstValue=values[0],_values$=values[1],secondValue=_values$===undefined?firstValue:_values$,_values$2=values[2],thirdValue=_values$2===undefined?firstValue:_values$2,_values$3=values[3],fourthValue=_values$3===undefined?secondValue:_values$3;var valuesWithDefaults=[firstValue,secondValue,thirdValue,fourthValue];return generateStyles(property,valuesWithDefaults)}exports.default=directionalProperty;module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useBreakPoints}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(250);var react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_1__);var react_use_lib_useDebounce__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(252);var react_use_lib_useDebounce__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_use_lib_useDebounce__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);function useBreakPoints(){const[screenSizes,setScreenSizes]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])({isSmall:false,isMedium:false,isLarge:false,isXl:false});const{width:width}=react_use_lib_useWindowSize__WEBPACK_IMPORTED_MODULE_1___default()();react_use_lib_useDebounce__WEBPACK_IMPORTED_MODULE_2___default()(()=>{const windowWidth=window.innerWidth;setScreenSizes({isSmall:Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["isWithinMaxBreakpoint"])(windowWidth,"s"),isMedium:Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["isWithinMaxBreakpoint"])(windowWidth,"m"),isLarge:Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["isWithinMaxBreakpoint"])(windowWidth,"l"),isXl:Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["isWithinMaxBreakpoint"])(windowWidth,"xl")})},50,[width]);return screenSizes}},function(module,exports,__webpack_require__){var baseIsNative=__webpack_require__(1147),getValue=__webpack_require__(1152);function getNative(object,key){var value=getValue(object,key);return baseIsNative(value)?value:undefined}module.exports=getNative},function(module,exports,__webpack_require__){var Symbol=__webpack_require__(102),getRawTag=__webpack_require__(1148),objectToString=__webpack_require__(1149);var nullTag="[object Null]",undefinedTag="[object Undefined]";var symToStringTag=Symbol?Symbol.toStringTag:undefined;function baseGetTag(value){if(value==null){return value===undefined?undefinedTag:nullTag}return symToStringTag&&symToStringTag in Object(value)?getRawTag(value):objectToString(value)}module.exports=baseGetTag},function(module,exports,__webpack_require__){var arrayLikeKeys=__webpack_require__(493),baseKeysIn=__webpack_require__(1172),isArrayLike=__webpack_require__(75);function keysIn(object){return isArrayLike(object)?arrayLikeKeys(object,true):baseKeysIn(object)}module.exports=keysIn},function(module,exports){function identity(value){return value}module.exports=identity},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(106),__webpack_require__(209),__webpack_require__(210),__webpack_require__(157),__webpack_require__(557),__webpack_require__(1353),__webpack_require__(94)):undefined})(this,(function(exports,d3Array,d3Collection,d3Interpolate,d3Format,d3Time,d3TimeFormat,d3Color){"use strict";var array=Array.prototype;var map$1=array.map;var slice=array.slice;var implicit={name:"implicit"};function ordinal(range$$1){var index=d3Collection.map(),domain=[],unknown=implicit;range$$1=range$$1==null?[]:slice.call(range$$1);function scale(d){var key=d+"",i=index.get(key);if(!i){if(unknown!==implicit)return unknown;index.set(key,i=domain.push(d))}return range$$1[(i-1)%range$$1.length]}scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[],index=d3Collection.map();var i=-1,n=_.length,d,key;while(++i<n)if(!index.has(key=(d=_[i])+""))index.set(key,domain.push(d));return scale};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),scale):range$$1.slice()};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.copy=function(){return ordinal().domain(domain).range(range$$1).unknown(unknown)};return scale}function band(){var scale=ordinal().unknown(undefined),domain=scale.domain,ordinalRange=scale.range,range$$1=[0,1],step,bandwidth,round=false,paddingInner=0,paddingOuter=0,align=.5;delete scale.unknown;function rescale(){var n=domain().length,reverse=range$$1[1]<range$$1[0],start=range$$1[reverse-0],stop=range$$1[1-reverse];step=(stop-start)/Math.max(1,n-paddingInner+paddingOuter*2);if(round)step=Math.floor(step);start+=(stop-start-step*(n-paddingInner))*align;bandwidth=step*(1-paddingInner);if(round)start=Math.round(start),bandwidth=Math.round(bandwidth);var values=d3Array.range(n).map((function(i){return start+step*i}));return ordinalRange(reverse?values.reverse():values)}scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()};scale.range=function(_){return arguments.length?(range$$1=[+_[0],+_[1]],rescale()):range$$1.slice()};scale.rangeRound=function(_){return range$$1=[+_[0],+_[1]],round=true,rescale()};scale.bandwidth=function(){return bandwidth};scale.step=function(){return step};scale.round=function(_){return arguments.length?(round=!!_,rescale()):round};scale.padding=function(_){return arguments.length?(paddingInner=paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingInner};scale.paddingInner=function(_){return arguments.length?(paddingInner=Math.max(0,Math.min(1,_)),rescale()):paddingInner};scale.paddingOuter=function(_){return arguments.length?(paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingOuter};scale.align=function(_){return arguments.length?(align=Math.max(0,Math.min(1,_)),rescale()):align};scale.copy=function(){return band().domain(domain()).range(range$$1).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align)};return rescale()}function pointish(scale){var copy=scale.copy;scale.padding=scale.paddingOuter;delete scale.paddingInner;delete scale.paddingOuter;scale.copy=function(){return pointish(copy())};return scale}function point(){return pointish(band().paddingInner(1))}var constant=function(x){return function(){return x}};var number=function(x){return+x};var unit=[0,1];function deinterpolateLinear(a,b){return(b-=a=+a)?function(x){return(x-a)/b}:constant(b)}function deinterpolateClamp(deinterpolate){return function(a,b){var d=deinterpolate(a=+a,b=+b);return function(x){return x<=a?0:x>=b?1:d(x)}}}function reinterpolateClamp(reinterpolate){return function(a,b){var r=reinterpolate(a=+a,b=+b);return function(t){return t<=0?a:t>=1?b:r(t)}}}function bimap(domain,range$$1,deinterpolate,reinterpolate){var d0=domain[0],d1=domain[1],r0=range$$1[0],r1=range$$1[1];if(d1<d0)d0=deinterpolate(d1,d0),r0=reinterpolate(r1,r0);else d0=deinterpolate(d0,d1),r0=reinterpolate(r0,r1);return function(x){return r0(d0(x))}}function polymap(domain,range$$1,deinterpolate,reinterpolate){var j=Math.min(domain.length,range$$1.length)-1,d=new Array(j),r=new Array(j),i=-1;if(domain[j]<domain[0]){domain=domain.slice().reverse();range$$1=range$$1.slice().reverse()}while(++i<j){d[i]=deinterpolate(domain[i],domain[i+1]);r[i]=reinterpolate(range$$1[i],range$$1[i+1])}return function(x){var i=d3Array.bisect(domain,x,1,j)-1;return r[i](d[i](x))}}function copy(source,target){return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp())}function continuous(deinterpolate,reinterpolate){var domain=unit,range$$1=unit,interpolate$$1=d3Interpolate.interpolate,clamp=false,piecewise,output,input;function rescale(){piecewise=Math.min(domain.length,range$$1.length)>2?polymap:bimap;output=input=null;return scale}function scale(x){return(output||(output=piecewise(domain,range$$1,clamp?deinterpolateClamp(deinterpolate):deinterpolate,interpolate$$1)))(+x)}scale.invert=function(y){return(input||(input=piecewise(range$$1,domain,deinterpolateLinear,clamp?reinterpolateClamp(reinterpolate):reinterpolate)))(+y)};scale.domain=function(_){return arguments.length?(domain=map$1.call(_,number),rescale()):domain.slice()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),rescale()):range$$1.slice()};scale.rangeRound=function(_){return range$$1=slice.call(_),interpolate$$1=d3Interpolate.interpolateRound,rescale()};scale.clamp=function(_){return arguments.length?(clamp=!!_,rescale()):clamp};scale.interpolate=function(_){return arguments.length?(interpolate$$1=_,rescale()):interpolate$$1};return rescale()}var tickFormat=function(domain,count,specifier){var start=domain[0],stop=domain[domain.length-1],step=d3Array.tickStep(start,stop,count==null?10:count),precision;specifier=d3Format.formatSpecifier(specifier==null?",f":specifier);switch(specifier.type){case"s":{var value=Math.max(Math.abs(start),Math.abs(stop));if(specifier.precision==null&&!isNaN(precision=d3Format.precisionPrefix(step,value)))specifier.precision=precision;return d3Format.formatPrefix(specifier,value)}case"":case"e":case"g":case"p":case"r":{if(specifier.precision==null&&!isNaN(precision=d3Format.precisionRound(step,Math.max(Math.abs(start),Math.abs(stop)))))specifier.precision=precision-(specifier.type==="e");break}case"f":case"%":{if(specifier.precision==null&&!isNaN(precision=d3Format.precisionFixed(step)))specifier.precision=precision-(specifier.type==="%")*2;break}}return d3Format.format(specifier)};function linearish(scale){var domain=scale.domain;scale.ticks=function(count){var d=domain();return d3Array.ticks(d[0],d[d.length-1],count==null?10:count)};scale.tickFormat=function(count,specifier){return tickFormat(domain(),count,specifier)};scale.nice=function(count){if(count==null)count=10;var d=domain(),i0=0,i1=d.length-1,start=d[i0],stop=d[i1],step;if(stop<start){step=start,start=stop,stop=step;step=i0,i0=i1,i1=step}step=d3Array.tickIncrement(start,stop,count);if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step;step=d3Array.tickIncrement(start,stop,count)}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step;step=d3Array.tickIncrement(start,stop,count)}if(step>0){d[i0]=Math.floor(start/step)*step;d[i1]=Math.ceil(stop/step)*step;domain(d)}else if(step<0){d[i0]=Math.ceil(start*step)/step;d[i1]=Math.floor(stop*step)/step;domain(d)}return scale};return scale}function linear(){var scale=continuous(deinterpolateLinear,d3Interpolate.interpolateNumber);scale.copy=function(){return copy(scale,linear())};return linearish(scale)}function identity(){var domain=[0,1];function scale(x){return+x}scale.invert=scale;scale.domain=scale.range=function(_){return arguments.length?(domain=map$1.call(_,number),scale):domain.slice()};scale.copy=function(){return identity().domain(domain)};return linearish(scale)}var nice=function(domain,interval){domain=domain.slice();var i0=0,i1=domain.length-1,x0=domain[i0],x1=domain[i1],t;if(x1<x0){t=i0,i0=i1,i1=t;t=x0,x0=x1,x1=t}domain[i0]=interval.floor(x0);domain[i1]=interval.ceil(x1);return domain};function deinterpolate(a,b){return(b=Math.log(b/a))?function(x){return Math.log(x/a)/b}:constant(b)}function reinterpolate(a,b){return a<0?function(t){return-Math.pow(-b,t)*Math.pow(-a,1-t)}:function(t){return Math.pow(b,t)*Math.pow(a,1-t)}}function pow10(x){return isFinite(x)?+("1e"+x):x<0?0:x}function powp(base){return base===10?pow10:base===Math.E?Math.exp:function(x){return Math.pow(base,x)}}function logp(base){return base===Math.E?Math.log:base===10&&Math.log10||base===2&&Math.log2||(base=Math.log(base),function(x){return Math.log(x)/base})}function reflect(f){return function(x){return-f(-x)}}function log(){var scale=continuous(deinterpolate,reinterpolate).domain([1,10]),domain=scale.domain,base=10,logs=logp(10),pows=powp(10);function rescale(){logs=logp(base),pows=powp(base);if(domain()[0]<0)logs=reflect(logs),pows=reflect(pows);return scale}scale.base=function(_){return arguments.length?(base=+_,rescale()):base};scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()};scale.ticks=function(count){var d=domain(),u=d[0],v=d[d.length-1],r;if(r=v<u)i=u,u=v,v=i;var i=logs(u),j=logs(v),p,k,t,n=count==null?10:+count,z=[];if(!(base%1)&&j-i<n){i=Math.round(i)-1,j=Math.round(j)+1;if(u>0)for(;i<j;++i){for(k=1,p=pows(i);k<base;++k){t=p*k;if(t<u)continue;if(t>v)break;z.push(t)}}else for(;i<j;++i){for(k=base-1,p=pows(i);k>=1;--k){t=p*k;if(t<u)continue;if(t>v)break;z.push(t)}}}else{z=d3Array.ticks(i,j,Math.min(j-i,n)).map(pows)}return r?z.reverse():z};scale.tickFormat=function(count,specifier){if(specifier==null)specifier=base===10?".0e":",";if(typeof specifier!=="function")specifier=d3Format.format(specifier);if(count===Infinity)return specifier;if(count==null)count=10;var k=Math.max(1,base*count/scale.ticks().length);return function(d){var i=d/pows(Math.round(logs(d)));if(i*base<base-.5)i*=base;return i<=k?specifier(d):""}};scale.nice=function(){return domain(nice(domain(),{floor:function(x){return pows(Math.floor(logs(x)))},ceil:function(x){return pows(Math.ceil(logs(x)))}}))};scale.copy=function(){return copy(scale,log().base(base))};return scale}function raise(x,exponent){return x<0?-Math.pow(-x,exponent):Math.pow(x,exponent)}function pow(){var exponent=1,scale=continuous(deinterpolate,reinterpolate),domain=scale.domain;function deinterpolate(a,b){return(b=raise(b,exponent)-(a=raise(a,exponent)))?function(x){return(raise(x,exponent)-a)/b}:constant(b)}function reinterpolate(a,b){b=raise(b,exponent)-(a=raise(a,exponent));return function(t){return raise(a+b*t,1/exponent)}}scale.exponent=function(_){return arguments.length?(exponent=+_,domain(domain())):exponent};scale.copy=function(){return copy(scale,pow().exponent(exponent))};return linearish(scale)}function sqrt(){return pow().exponent(.5)}function quantile$1(){var domain=[],range$$1=[],thresholds=[];function rescale(){var i=0,n=Math.max(1,range$$1.length);thresholds=new Array(n-1);while(++i<n)thresholds[i-1]=d3Array.quantile(domain,i/n);return scale}function scale(x){if(!isNaN(x=+x))return range$$1[d3Array.bisect(thresholds,x)]}scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:[i>0?thresholds[i-1]:domain[0],i<thresholds.length?thresholds[i]:domain[domain.length-1]]};scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[];for(var i=0,n=_.length,d;i<n;++i)if(d=_[i],d!=null&&!isNaN(d=+d))domain.push(d);domain.sort(d3Array.ascending);return rescale()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),rescale()):range$$1.slice()};scale.quantiles=function(){return thresholds.slice()};scale.copy=function(){return quantile$1().domain(domain).range(range$$1)};return scale}function quantize(){var x0=0,x1=1,n=1,domain=[.5],range$$1=[0,1];function scale(x){if(x<=x)return range$$1[d3Array.bisect(domain,x,0,n)]}function rescale(){var i=-1;domain=new Array(n);while(++i<n)domain[i]=((i+1)*x1-(i-n)*x0)/(n+1);return scale}scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],rescale()):[x0,x1]};scale.range=function(_){return arguments.length?(n=(range$$1=slice.call(_)).length-1,rescale()):range$$1.slice()};scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:i<1?[x0,domain[0]]:i>=n?[domain[n-1],x1]:[domain[i-1],domain[i]]};scale.copy=function(){return quantize().domain([x0,x1]).range(range$$1)};return linearish(scale)}function threshold(){var domain=[.5],range$$1=[0,1],n=1;function scale(x){if(x<=x)return range$$1[d3Array.bisect(domain,x,0,n)]}scale.domain=function(_){return arguments.length?(domain=slice.call(_),n=Math.min(domain.length,range$$1.length-1),scale):domain.slice()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),n=Math.min(domain.length,range$$1.length-1),scale):range$$1.slice()};scale.invertExtent=function(y){var i=range$$1.indexOf(y);return[domain[i-1],domain[i]]};scale.copy=function(){return threshold().domain(domain).range(range$$1)};return scale}var durationSecond=1e3;var durationMinute=durationSecond*60;var durationHour=durationMinute*60;var durationDay=durationHour*24;var durationWeek=durationDay*7;var durationMonth=durationDay*30;var durationYear=durationDay*365;function date(t){return new Date(t)}function number$1(t){return t instanceof Date?+t:+new Date(+t)}function calendar(year,month,week,day,hour,minute,second,millisecond,format$$1){var scale=continuous(deinterpolateLinear,d3Interpolate.interpolateNumber),invert=scale.invert,domain=scale.domain;var formatMillisecond=format$$1(".%L"),formatSecond=format$$1(":%S"),formatMinute=format$$1("%I:%M"),formatHour=format$$1("%I %p"),formatDay=format$$1("%a %d"),formatWeek=format$$1("%b %d"),formatMonth=format$$1("%B"),formatYear=format$$1("%Y");var tickIntervals=[[second,1,durationSecond],[second,5,5*durationSecond],[second,15,15*durationSecond],[second,30,30*durationSecond],[minute,1,durationMinute],[minute,5,5*durationMinute],[minute,15,15*durationMinute],[minute,30,30*durationMinute],[hour,1,durationHour],[hour,3,3*durationHour],[hour,6,6*durationHour],[hour,12,12*durationHour],[day,1,durationDay],[day,2,2*durationDay],[week,1,durationWeek],[month,1,durationMonth],[month,3,3*durationMonth],[year,1,durationYear]];function tickFormat(date){return(second(date)<date?formatMillisecond:minute(date)<date?formatSecond:hour(date)<date?formatMinute:day(date)<date?formatHour:month(date)<date?week(date)<date?formatDay:formatWeek:year(date)<date?formatMonth:formatYear)(date)}function tickInterval(interval,start,stop,step){if(interval==null)interval=10;if(typeof interval==="number"){var target=Math.abs(stop-start)/interval,i=d3Array.bisector((function(i){return i[2]})).right(tickIntervals,target);if(i===tickIntervals.length){step=d3Array.tickStep(start/durationYear,stop/durationYear,interval);interval=year}else if(i){i=tickIntervals[target/tickIntervals[i-1][2]<tickIntervals[i][2]/target?i-1:i];step=i[1];interval=i[0]}else{step=Math.max(d3Array.tickStep(start,stop,interval),1);interval=millisecond}}return step==null?interval:interval.every(step)}scale.invert=function(y){return new Date(invert(y))};scale.domain=function(_){return arguments.length?domain(map$1.call(_,number$1)):domain().map(date)};scale.ticks=function(interval,step){var d=domain(),t0=d[0],t1=d[d.length-1],r=t1<t0,t;if(r)t=t0,t0=t1,t1=t;t=tickInterval(interval,t0,t1,step);t=t?t.range(t0,t1+1):[];return r?t.reverse():t};scale.tickFormat=function(count,specifier){return specifier==null?tickFormat:format$$1(specifier)};scale.nice=function(interval,step){var d=domain();return(interval=tickInterval(interval,d[0],d[d.length-1],step))?domain(nice(d,interval)):scale};scale.copy=function(){return copy(scale,calendar(year,month,week,day,hour,minute,second,millisecond,format$$1))};return scale}var time=function(){return calendar(d3Time.timeYear,d3Time.timeMonth,d3Time.timeWeek,d3Time.timeDay,d3Time.timeHour,d3Time.timeMinute,d3Time.timeSecond,d3Time.timeMillisecond,d3TimeFormat.timeFormat).domain([new Date(2e3,0,1),new Date(2e3,0,2)])};var utcTime=function(){return calendar(d3Time.utcYear,d3Time.utcMonth,d3Time.utcWeek,d3Time.utcDay,d3Time.utcHour,d3Time.utcMinute,d3Time.utcSecond,d3Time.utcMillisecond,d3TimeFormat.utcFormat).domain([Date.UTC(2e3,0,1),Date.UTC(2e3,0,2)])};var colors=function(s){return s.match(/.{6}/g).map((function(x){return"#"+x}))};var category10=colors("1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf");var category20b=colors("393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6");var category20c=colors("3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9");var category20=colors("1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5");var cubehelix$1=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(300,.5,0),d3Color.cubehelix(-240,.5,1));var warm=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(-100,.75,.35),d3Color.cubehelix(80,1.5,.8));var cool=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(260,.75,.35),d3Color.cubehelix(80,1.5,.8));var rainbow=d3Color.cubehelix();var rainbow$1=function(t){if(t<0||t>1)t-=Math.floor(t);var ts=Math.abs(t-.5);rainbow.h=360*t-100;rainbow.s=1.5-1.5*ts;rainbow.l=.8-.9*ts;return rainbow+""};function ramp(range$$1){var n=range$$1.length;return function(t){return range$$1[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}var viridis=ramp(colors("44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"));var magma=ramp(colors("00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"));var inferno=ramp(colors("00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"));var plasma=ramp(colors("0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"));function sequential(interpolator){var x0=0,x1=1,clamp=false;function scale(x){var t=(x-x0)/(x1-x0);return interpolator(clamp?Math.max(0,Math.min(1,t)):t)}scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],scale):[x0,x1]};scale.clamp=function(_){return arguments.length?(clamp=!!_,scale):clamp};scale.interpolator=function(_){return arguments.length?(interpolator=_,scale):interpolator};scale.copy=function(){return sequential(interpolator).domain([x0,x1]).clamp(clamp)};return linearish(scale)}exports.scaleBand=band;exports.scalePoint=point;exports.scaleIdentity=identity;exports.scaleLinear=linear;exports.scaleLog=log;exports.scaleOrdinal=ordinal;exports.scaleImplicit=implicit;exports.scalePow=pow;exports.scaleSqrt=sqrt;exports.scaleQuantile=quantile$1;exports.scaleQuantize=quantize;exports.scaleThreshold=threshold;exports.scaleTime=time;exports.scaleUtc=utcTime;exports.schemeCategory10=category10;exports.schemeCategory20b=category20b;exports.schemeCategory20c=category20c;exports.schemeCategory20=category20;exports.interpolateCubehelixDefault=cubehelix$1;exports.interpolateRainbow=rainbow$1;exports.interpolateWarm=warm;exports.interpolateCool=cool;exports.interpolateViridis=viridis;exports.interpolateMagma=magma;exports.interpolateInferno=inferno;exports.interpolatePlasma=plasma;exports.scaleSequential=sequential;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function define(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype;prototype.constructor=constructor}function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var darker=.7;var brighter=1/darker;var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex=/^#([0-9a-f]{3,8})$/,reRgbInteger=new RegExp("^rgb\\("+[reI,reI,reI]+"\\)$"),reRgbPercent=new RegExp("^rgb\\("+[reP,reP,reP]+"\\)$"),reRgbaInteger=new RegExp("^rgba\\("+[reI,reI,reI,reN]+"\\)$"),reRgbaPercent=new RegExp("^rgba\\("+[reP,reP,reP,reN]+"\\)$"),reHslPercent=new RegExp("^hsl\\("+[reN,reP,reP]+"\\)$"),reHslaPercent=new RegExp("^hsla\\("+[reN,reP,reP,reN]+"\\)$");var named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};define(Color,color,{copy:function(channels){return Object.assign(new this.constructor,this,channels)},displayable:function(){return this.rgb().displayable()},hex:color_formatHex,formatHex:color_formatHex,formatHsl:color_formatHsl,formatRgb:color_formatRgb,toString:color_formatRgb});function color_formatHex(){return this.rgb().formatHex()}function color_formatHsl(){return hslConvert(this).formatHsl()}function color_formatRgb(){return this.rgb().formatRgb()}function color(format){var m,l;format=(format+"").trim().toLowerCase();return(m=reHex.exec(format))?(l=m[1].length,m=parseInt(m[1],16),l===6?rgbn(m):l===3?new Rgb(m>>8&15|m>>4&240,m>>4&15|m&240,(m&15)<<4|m&15,1):l===8?rgba(m>>24&255,m>>16&255,m>>8&255,(m&255)/255):l===4?rgba(m>>12&15|m>>8&240,m>>8&15|m>>4&240,m>>4&15|m&240,((m&15)<<4|m&15)/255):null):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(m[1]*255/100,m[2]*255/100,m[3]*255/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(m[1]*255/100,m[2]*255/100,m[3]*255/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):format==="transparent"?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,n&255,1)}function rgba(r,g,b,a){if(a<=0)r=g=b=NaN;return new Rgb(r,g,b,a)}function rgbConvert(o){if(!(o instanceof Color))o=color(o);if(!o)return new Rgb;o=o.rgb();return new Rgb(o.r,o.g,o.b,o.opacity)}function rgb(r,g,b,opacity){return arguments.length===1?rgbConvert(r):new Rgb(r,g,b,opacity==null?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r;this.g=+g;this.b=+b;this.opacity=+opacity}define(Rgb,rgb,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb:function(){return this},displayable:function(){return-.5<=this.r&&this.r<255.5&&(-.5<=this.g&&this.g<255.5)&&(-.5<=this.b&&this.b<255.5)&&(0<=this.opacity&&this.opacity<=1)},hex:rgb_formatHex,formatHex:rgb_formatHex,formatRgb:rgb_formatRgb,toString:rgb_formatRgb}));function rgb_formatHex(){return"#"+hex(this.r)+hex(this.g)+hex(this.b)}function rgb_formatRgb(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(a===1?")":", "+a+")")}function hex(value){value=Math.max(0,Math.min(255,Math.round(value)||0));return(value<16?"0":"")+value.toString(16)}function hsla(h,s,l,a){if(a<=0)h=s=l=NaN;else if(l<=0||l>=1)h=s=NaN;else if(s<=0)h=NaN;return new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(!(o instanceof Color))o=color(o);if(!o)return new Hsl;if(o instanceof Hsl)return o;o=o.rgb();var r=o.r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;if(s){if(r===max)h=(g-b)/s+(g<b)*6;else if(g===max)h=(b-r)/s+2;else h=(r-g)/s+4;s/=l<.5?max+min:2-max-min;h*=60}else{s=l>0&&l<1?0:h}return new Hsl(h,s,l,o.opacity)}function hsl(h,s,l,opacity){return arguments.length===1?hslConvert(h):new Hsl(h,s,l,opacity==null?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Hsl,hsl,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=this.h%360+(this.h<0)*360,s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&(0<=this.l&&this.l<=1)&&(0<=this.opacity&&this.opacity<=1)},formatHsl:function(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"hsl(":"hsla(")+(this.h||0)+", "+(this.s||0)*100+"%, "+(this.l||0)*100+"%"+(a===1?")":", "+a+")")}}));function hsl2rgb(h,m1,m2){return(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)*255}var deg2rad=Math.PI/180;var rad2deg=180/Math.PI;var K=18,Xn=.96422,Yn=1,Zn=.82521,t0=4/29,t1=6/29,t2=3*t1*t1,t3=t1*t1*t1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl)return hcl2lab(o);if(!(o instanceof Rgb))o=rgbConvert(o);var r=rgb2lrgb(o.r),g=rgb2lrgb(o.g),b=rgb2lrgb(o.b),y=xyz2lab((.2225045*r+.7168786*g+.0606169*b)/Yn),x,z;if(r===g&&g===b)x=z=y;else{x=xyz2lab((.4360747*r+.3850649*g+.1430804*b)/Xn);z=xyz2lab((.0139322*r+.0971045*g+.7141733*b)/Zn)}return new Lab(116*y-16,500*(x-y),200*(y-z),o.opacity)}function gray(l,opacity){return new Lab(l,0,0,opacity==null?1:opacity)}function lab(l,a,b,opacity){return arguments.length===1?labConvert(l):new Lab(l,a,b,opacity==null?1:opacity)}function Lab(l,a,b,opacity){this.l=+l;this.a=+a;this.b=+b;this.opacity=+opacity}define(Lab,lab,extend(Color,{brighter:function(k){return new Lab(this.l+K*(k==null?1:k),this.a,this.b,this.opacity)},darker:function(k){return new Lab(this.l-K*(k==null?1:k),this.a,this.b,this.opacity)},rgb:function(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;x=Xn*lab2xyz(x);y=Yn*lab2xyz(y);z=Zn*lab2xyz(z);return new Rgb(lrgb2rgb(3.1338561*x-1.6168667*y-.4906146*z),lrgb2rgb(-.9787684*x+1.9161415*y+.033454*z),lrgb2rgb(.0719453*x-.2289914*y+1.4052427*z),this.opacity)}}));function xyz2lab(t){return t>t3?Math.pow(t,1/3):t/t2+t0}function lab2xyz(t){return t>t1?t*t*t:t2*(t-t0)}function lrgb2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2lrgb(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);if(!(o instanceof Lab))o=labConvert(o);if(o.a===0&&o.b===0)return new Hcl(NaN,0<o.l&&o.l<100?0:NaN,o.l,o.opacity);var h=Math.atan2(o.b,o.a)*rad2deg;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function lch(l,c,h,opacity){return arguments.length===1?hclConvert(l):new Hcl(h,c,l,opacity==null?1:opacity)}function hcl(h,c,l,opacity){return arguments.length===1?hclConvert(h):new Hcl(h,c,l,opacity==null?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h;this.c=+c;this.l=+l;this.opacity=+opacity}function hcl2lab(o){if(isNaN(o.h))return new Lab(o.l,0,0,o.opacity);var h=o.h*deg2rad;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}define(Hcl,hcl,extend(Color,{brighter:function(k){return new Hcl(this.h,this.c,this.l+K*(k==null?1:k),this.opacity)},darker:function(k){return new Hcl(this.h,this.c,this.l-K*(k==null?1:k),this.opacity)},rgb:function(){return hcl2lab(this).rgb()}}));var A=-.14861,B=+1.78277,C=-.29227,D=-.90649,E=+1.97294,ED=E*D,EB=E*B,BC_DA=B*C-D*A;function cubehelixConvert(o){if(o instanceof Cubehelix)return new Cubehelix(o.h,o.s,o.l,o.opacity);if(!(o instanceof Rgb))o=rgbConvert(o);var r=o.r/255,g=o.g/255,b=o.b/255,l=(BC_DA*b+ED*r-EB*g)/(BC_DA+ED-EB),bl=b-l,k=(E*(g-l)-C*bl)/D,s=Math.sqrt(k*k+bl*bl)/(E*l*(1-l)),h=s?Math.atan2(k,bl)*rad2deg-120:NaN;return new Cubehelix(h<0?h+360:h,s,l,o.opacity)}function cubehelix(h,s,l,opacity){return arguments.length===1?cubehelixConvert(h):new Cubehelix(h,s,l,opacity==null?1:opacity)}function Cubehelix(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Cubehelix,cubehelix,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=isNaN(this.h)?0:(this.h+120)*deg2rad,l=+this.l,a=isNaN(this.s)?0:this.s*l*(1-l),cosh=Math.cos(h),sinh=Math.sin(h);return new Rgb(255*(l+a*(A*cosh+B*sinh)),255*(l+a*(C*cosh+D*sinh)),255*(l+a*(E*cosh)),this.opacity)}}));exports.color=color;exports.cubehelix=cubehelix;exports.gray=gray;exports.hcl=hcl;exports.hsl=hsl;exports.lab=lab;exports.lch=lch;exports.rgb=rgb;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.MarginPropType=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};exports.getInnerDimensions=getInnerDimensions;exports.getRadialLayoutMargin=getRadialLayoutMargin;var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getInnerDimensions(props,defaultMargins){var margin=props.margin,width=props.width,height=props.height;var marginProps=_extends({},defaultMargins,typeof margin==="number"?{left:margin,right:margin,top:margin,bottom:margin}:margin);var _marginProps$left=marginProps.left,marginLeft=_marginProps$left===undefined?0:_marginProps$left,_marginProps$top=marginProps.top,marginTop=_marginProps$top===undefined?0:_marginProps$top,_marginProps$right=marginProps.right,marginRight=_marginProps$right===undefined?0:_marginProps$right,_marginProps$bottom=marginProps.bottom,marginBottom=_marginProps$bottom===undefined?0:_marginProps$bottom;return{marginLeft:marginLeft,marginTop:marginTop,marginRight:marginRight,marginBottom:marginBottom,innerHeight:height-marginBottom-marginTop,innerWidth:width-marginLeft-marginRight}}function getRadialLayoutMargin(width,height,radius){var marginX=width/2-radius;var marginY=height/2-radius;return{bottom:marginY,left:marginX,right:marginX,top:marginY}}var MarginPropType=exports.MarginPropType=_propTypes2.default.oneOfType([_propTypes2.default.shape({left:_propTypes2.default.number,top:_propTypes2.default.number,right:_propTypes2.default.number,bottom:_propTypes2.default.number}),_propTypes2.default.number])},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _seriesUtils=__webpack_require__(56);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--label";var LabelSeries=function(_AbstractSeries){_inherits(LabelSeries,_AbstractSeries);function LabelSeries(){_classCallCheck(this,LabelSeries);return _possibleConstructorReturn(this,(LabelSeries.__proto__||Object.getPrototypeOf(LabelSeries)).apply(this,arguments))}_createClass(LabelSeries,[{key:"render",value:function render(){var _this2=this;var _props=this.props,animation=_props.animation,allowOffsetToBeReversed=_props.allowOffsetToBeReversed,className=_props.className,data=_props.data,_data=_props._data,getLabel=_props.getLabel,marginLeft=_props.marginLeft,marginTop=_props.marginTop,rotation=_props.rotation,xRange=_props.xRange,yRange=_props.yRange;if(!data){return null}if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS}),_react2.default.createElement(LabelSeries,_extends({},this.props,{animation:null,_data:data})))}var xFunctor=this._getAttributeFunctor("x");var yFunctor=this._getAttributeFunctor("y");return _react2.default.createElement("g",{className:predefinedClassName+" "+className,ref:"container",transform:"translate("+marginLeft+","+marginTop+")"},data.reduce((function(res,d,i){var style=d.style,xOffset=d.xOffset,yOffset=d.yOffset;if(!getLabel(d)){return res}var xVal=xFunctor(d);var yVal=yFunctor(d);var leftOfMiddle=xVal<(xRange[1]-xRange[0])/2;var aboveMiddle=yVal<Math.abs(yRange[1]-yRange[0])/2;var x=xVal+(allowOffsetToBeReversed&&leftOfMiddle?-1:1)*(xOffset||0);var y=yVal+(allowOffsetToBeReversed&&aboveMiddle?-1:1)*(yOffset||0);var attrs=_extends({alignmentBaseline:aboveMiddle?"text-before-edge":"text-after-edge",className:"rv-xy-plot__series--label-text",key:i,onClick:function onClick(e){return _this2._valueClickHandler(d,e)},onContextMenu:function onContextMenu(e){return _this2._valueRightClickHandler(d,e)},onMouseOver:function onMouseOver(e){return _this2._valueMouseOverHandler(d,e)},onMouseOut:function onMouseOut(e){return _this2._valueMouseOutHandler(d,e)},textAnchor:leftOfMiddle?"start":"end",x:x,y:y,transform:"rotate("+(d.rotation||rotation)+","+x+","+y+")"},style);var textContent=getLabel(_data?_data[i]:d);return res.concat([_react2.default.createElement("text",attrs,textContent)])}),[]))}}]);return LabelSeries}(_abstractSeries2.default);LabelSeries.propTypes={animation:_propTypes2.default.bool,allowOffsetToBeReversed:_propTypes2.default.bool,className:_propTypes2.default.string,data:_propTypes2.default.arrayOf(_propTypes2.default.shape({x:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string]),y:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string]),angle:_propTypes2.default.number,radius:_propTypes2.default.number,label:_propTypes2.default.string,xOffset:_propTypes2.default.number,yOffset:_propTypes2.default.number,style:_propTypes2.default.object})).isRequired,marginLeft:_propTypes2.default.number,marginTop:_propTypes2.default.number,rotation:_propTypes2.default.number,xRange:_propTypes2.default.arrayOf(_propTypes2.default.number),yRange:_propTypes2.default.arrayOf(_propTypes2.default.number)};LabelSeries.defaultProps={animation:false,rotation:0,getLabel:function getLabel(d){return d.label}};LabelSeries.displayName="LabelSeries";exports.default=LabelSeries},,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function guard(lowerBoundary,upperBoundary,value){return Math.max(lowerBoundary,Math.min(upperBoundary,value))}exports.default=guard;module.exports=exports["default"]},function(module,exports){function eq(value,other){return value===other||value!==value&&other!==other}module.exports=eq},function(module,exports,__webpack_require__){var root=__webpack_require__(70);var Symbol=root.Symbol;module.exports=Symbol},function(module,exports,__webpack_require__){(function(module){var root=__webpack_require__(70),stubFalse=__webpack_require__(1168);var freeExports=true&&exports&&!exports.nodeType&&exports;var freeModule=freeExports&&typeof module=="object"&&module&&!module.nodeType&&module;var moduleExports=freeModule&&freeModule.exports===freeExports;var Buffer=moduleExports?root.Buffer:undefined;var nativeIsBuffer=Buffer?Buffer.isBuffer:undefined;var isBuffer=nativeIsBuffer||stubFalse;module.exports=isBuffer}).call(this,__webpack_require__(131)(module))},function(module,exports,__webpack_require__){var DataView=__webpack_require__(1177),Map=__webpack_require__(190),Promise=__webpack_require__(1178),Set=__webpack_require__(502),WeakMap=__webpack_require__(1179),baseGetTag=__webpack_require__(90),toSource=__webpack_require__(491);var mapTag="[object Map]",objectTag="[object Object]",promiseTag="[object Promise]",setTag="[object Set]",weakMapTag="[object WeakMap]";var dataViewTag="[object DataView]";var dataViewCtorString=toSource(DataView),mapCtorString=toSource(Map),promiseCtorString=toSource(Promise),setCtorString=toSource(Set),weakMapCtorString=toSource(WeakMap);var getTag=baseGetTag;if(DataView&&getTag(new DataView(new ArrayBuffer(1)))!=dataViewTag||Map&&getTag(new Map)!=mapTag||Promise&&getTag(Promise.resolve())!=promiseTag||Set&&getTag(new Set)!=setTag||WeakMap&&getTag(new WeakMap)!=weakMapTag){getTag=function(value){var result=baseGetTag(value),Ctor=result==objectTag?value.constructor:undefined,ctorString=Ctor?toSource(Ctor):"";if(ctorString){switch(ctorString){case dataViewCtorString:return dataViewTag;case mapCtorString:return mapTag;case promiseCtorString:return promiseTag;case setCtorString:return setTag;case weakMapCtorString:return weakMapTag}}return result}}module.exports=getTag},function(module,exports,__webpack_require__){var baseGetTag=__webpack_require__(90),isObjectLike=__webpack_require__(74);var symbolTag="[object Symbol]";function isSymbol(value){return typeof value=="symbol"||isObjectLike(value)&&baseGetTag(value)==symbolTag}module.exports=isSymbol},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function bisector(compare){if(compare.length===1)compare=ascendingComparator(compare);return{left:function(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid}return lo},right:function(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1}return lo}}}function ascendingComparator(f){return function(d,x){return ascending(f(d),x)}}var ascendingBisect=bisector(ascending);var bisectRight=ascendingBisect.right;var bisectLeft=ascendingBisect.left;function pairs(array,f){if(f==null)f=pair;var i=0,n=array.length-1,p=array[0],pairs=new Array(n<0?0:n);while(i<n)pairs[i]=f(p,p=array[++i]);return pairs}function pair(a,b){return[a,b]}function cross(values0,values1,reduce){var n0=values0.length,n1=values1.length,values=new Array(n0*n1),i0,i1,i,value0;if(reduce==null)reduce=pair;for(i0=i=0;i0<n0;++i0){for(value0=values0[i0],i1=0;i1<n1;++i1,++i){values[i]=reduce(value0,values1[i1])}}return values}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function number(x){return x===null?NaN:+x}function variance(values,valueof){var n=values.length,m=0,i=-1,mean=0,value,delta,sum=0;if(valueof==null){while(++i<n){if(!isNaN(value=number(values[i]))){delta=value-mean;mean+=delta/++m;sum+=delta*(value-mean)}}}else{while(++i<n){if(!isNaN(value=number(valueof(values[i],i,values)))){delta=value-mean;mean+=delta/++m;sum+=delta*(value-mean)}}}if(m>1)return sum/(m-1)}function deviation(array,f){var v=variance(array,f);return v?Math.sqrt(v):v}function extent(values,valueof){var n=values.length,i=-1,value,min,max;if(valueof==null){while(++i<n){if((value=values[i])!=null&&value>=value){min=max=value;while(++i<n){if((value=values[i])!=null){if(min>value)min=value;if(max<value)max=value}}}}}else{while(++i<n){if((value=valueof(values[i],i,values))!=null&&value>=value){min=max=value;while(++i<n){if((value=valueof(values[i],i,values))!=null){if(min>value)min=value;if(max<value)max=value}}}}}return[min,max]}var array=Array.prototype;var slice=array.slice;var map=array.map;function constant(x){return function(){return x}}function identity(x){return x}function range(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}var e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function ticks(start,stop,count){var reverse,i=-1,n,ticks,step;stop=+stop,start=+start,count=+count;if(start===stop&&count>0)return[start];if(reverse=stop<start)n=start,start=stop,stop=n;if((step=tickIncrement(start,stop,count))===0||!isFinite(step))return[];if(step>0){start=Math.ceil(start/step);stop=Math.floor(stop/step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)*step}else{start=Math.floor(start*step);stop=Math.ceil(stop*step);ticks=new Array(n=Math.ceil(start-stop+1));while(++i<n)ticks[i]=(start-i)/step}if(reverse)ticks.reverse();return ticks}function tickIncrement(start,stop,count){var step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log(step)/Math.LN10),error=step/Math.pow(10,power);return power>=0?(error>=e10?10:error>=e5?5:error>=e2?2:1)*Math.pow(10,power):-Math.pow(10,-power)/(error>=e10?10:error>=e5?5:error>=e2?2:1)}function tickStep(start,stop,count){var step0=Math.abs(stop-start)/Math.max(0,count),step1=Math.pow(10,Math.floor(Math.log(step0)/Math.LN10)),error=step0/step1;if(error>=e10)step1*=10;else if(error>=e5)step1*=5;else if(error>=e2)step1*=2;return stop<start?-step1:step1}function sturges(values){return Math.ceil(Math.log(values.length)/Math.LN2)+1}function histogram(){var value=identity,domain=extent,threshold=sturges;function histogram(data){var i,n=data.length,x,values=new Array(n);for(i=0;i<n;++i){values[i]=value(data[i],i,data)}var xz=domain(values),x0=xz[0],x1=xz[1],tz=threshold(values,x0,x1);if(!Array.isArray(tz)){tz=tickStep(x0,x1,tz);tz=range(Math.ceil(x0/tz)*tz,x1,tz)}var m=tz.length;while(tz[0]<=x0)tz.shift(),--m;while(tz[m-1]>x1)tz.pop(),--m;var bins=new Array(m+1),bin;for(i=0;i<=m;++i){bin=bins[i]=[];bin.x0=i>0?tz[i-1]:x0;bin.x1=i<m?tz[i]:x1}for(i=0;i<n;++i){x=values[i];if(x0<=x&&x<=x1){bins[bisectRight(tz,x,0,m)].push(data[i])}}return bins}histogram.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(_),histogram):value};histogram.domain=function(_){return arguments.length?(domain=typeof _==="function"?_:constant([_[0],_[1]]),histogram):domain};histogram.thresholds=function(_){return arguments.length?(threshold=typeof _==="function"?_:Array.isArray(_)?constant(slice.call(_)):constant(_),histogram):threshold};return histogram}function quantile(values,p,valueof){if(valueof==null)valueof=number;if(!(n=values.length))return;if((p=+p)<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function freedmanDiaconis(values,min,max){values=map.call(values,number).sort(ascending);return Math.ceil((max-min)/(2*(quantile(values,.75)-quantile(values,.25))*Math.pow(values.length,-1/3)))}function scott(values,min,max){return Math.ceil((max-min)/(3.5*deviation(values)*Math.pow(values.length,-1/3)))}function max(values,valueof){var n=values.length,i=-1,value,max;if(valueof==null){while(++i<n){if((value=values[i])!=null&&value>=value){max=value;while(++i<n){if((value=values[i])!=null&&value>max){max=value}}}}}else{while(++i<n){if((value=valueof(values[i],i,values))!=null&&value>=value){max=value;while(++i<n){if((value=valueof(values[i],i,values))!=null&&value>max){max=value}}}}}return max}function mean(values,valueof){var n=values.length,m=n,i=-1,value,sum=0;if(valueof==null){while(++i<n){if(!isNaN(value=number(values[i])))sum+=value;else--m}}else{while(++i<n){if(!isNaN(value=number(valueof(values[i],i,values))))sum+=value;else--m}}if(m)return sum/m}function median(values,valueof){var n=values.length,i=-1,value,numbers=[];if(valueof==null){while(++i<n){if(!isNaN(value=number(values[i]))){numbers.push(value)}}}else{while(++i<n){if(!isNaN(value=number(valueof(values[i],i,values)))){numbers.push(value)}}}return quantile(numbers.sort(ascending),.5)}function merge(arrays){var n=arrays.length,m,i=-1,j=0,merged,array;while(++i<n)j+=arrays[i].length;merged=new Array(j);while(--n>=0){array=arrays[n];m=array.length;while(--m>=0){merged[--j]=array[m]}}return merged}function min(values,valueof){var n=values.length,i=-1,value,min;if(valueof==null){while(++i<n){if((value=values[i])!=null&&value>=value){min=value;while(++i<n){if((value=values[i])!=null&&min>value){min=value}}}}}else{while(++i<n){if((value=valueof(values[i],i,values))!=null&&value>=value){min=value;while(++i<n){if((value=valueof(values[i],i,values))!=null&&min>value){min=value}}}}}return min}function permute(array,indexes){var i=indexes.length,permutes=new Array(i);while(i--)permutes[i]=array[indexes[i]];return permutes}function scan(values,compare){if(!(n=values.length))return;var n,i=0,j=0,xi,xj=values[j];if(compare==null)compare=ascending;while(++i<n){if(compare(xi=values[i],xj)<0||compare(xj,xj)!==0){xj=xi,j=i}}if(compare(xj,xj)===0)return j}function shuffle(array,i0,i1){var m=(i1==null?array.length:i1)-(i0=i0==null?0:+i0),t,i;while(m){i=Math.random()*m--|0;t=array[m+i0];array[m+i0]=array[i+i0];array[i+i0]=t}return array}function sum(values,valueof){var n=values.length,i=-1,value,sum=0;if(valueof==null){while(++i<n){if(value=+values[i])sum+=value}}else{while(++i<n){if(value=+valueof(values[i],i,values))sum+=value}}return sum}function transpose(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=min(matrix,length),transpose=new Array(m);++i<m;){for(var j=-1,n,row=transpose[i]=new Array(n);++j<n;){row[j]=matrix[j][i]}}return transpose}function length(d){return d.length}function zip(){return transpose(arguments)}exports.bisect=bisectRight;exports.bisectRight=bisectRight;exports.bisectLeft=bisectLeft;exports.ascending=ascending;exports.bisector=bisector;exports.cross=cross;exports.descending=descending;exports.deviation=deviation;exports.extent=extent;exports.histogram=histogram;exports.thresholdFreedmanDiaconis=freedmanDiaconis;exports.thresholdScott=scott;exports.thresholdSturges=sturges;exports.max=max;exports.mean=mean;exports.median=median;exports.merge=merge;exports.min=min;exports.pairs=pairs;exports.permute=permute;exports.quantile=quantile;exports.range=range;exports.scan=scan;exports.shuffle=shuffle;exports.sum=sum;exports.ticks=ticks;exports.tickIncrement=tickIncrement;exports.tickStep=tickStep;exports.transpose=transpose;exports.variance=variance;exports.zip=zip;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){"use strict";(function(process){Object.defineProperty(exports,"__esModule",{value:true});exports.getDOMNode=exports.isReactDOMSupported=undefined;var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();exports.warning=warning;exports.warnOnce=warnOnce;exports.checkIfStyleSheetIsImported=checkIfStyleSheetIsImported;var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var _React$version$split=_react2.default.version.split("."),_React$version$split2=_slicedToArray(_React$version$split,2),major=_React$version$split2[0],minor=_React$version$split2[1];var versionHigherThanThirteen=Number(minor)>13||Number(major)>13;var isReactDOMSupported=exports.isReactDOMSupported=function isReactDOMSupported(){return versionHigherThanThirteen};var getDOMNode=exports.getDOMNode=function getDOMNode(ref){if(!isReactDOMSupported()){return ref&&ref.getDOMNode()}return ref};var USED_MESSAGES={};var HIDDEN_PROCESSES={test:true,production:true};function warning(message){var onlyShowMessageOnce=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(process&&HIDDEN_PROCESSES["production"]){return}if(!onlyShowMessageOnce||!USED_MESSAGES[message]){console.warn(message);USED_MESSAGES[message]=true}}function warnOnce(message){warning(message,true)}function getCSSRules(styleSheet){if(styleSheet.ownerNode.tagName==="STYLE"||styleSheet.ownerNode.tagName==="LINK"&&styleSheet.ownerNode.href&&styleSheet.ownerNode.href.startsWith(document.location.origin)){try{return styleSheet.rules||styleSheet.cssRules}catch(err){return[]}}return[]}var MAGIC_CSS_RULE=".react-vis-magic-css-import-rule";function checkIfStyleSheetIsImported(){if(process&&HIDDEN_PROCESSES["production"]){return}var foundImportTag=[].concat(_toConsumableArray(document.styleSheets)).some((function(styleSheet){var CSSRulesList=getCSSRules(styleSheet);return[].concat(_toConsumableArray(CSSRulesList)).some((function(selector){return selector.selectorText===MAGIC_CSS_RULE}))}));if(!foundImportTag){warnOnce("REACT-VIS: The style sheet for react-vis has not been imported, checkout https://uber.github.io/react-vis/documentation/general-principles/style for more details.")}}}).call(this,__webpack_require__(108))},,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.wordWrap=exports.triangle=exports.transparentize=exports.transitions=exports.toColorString=exports.tint=exports.timingFunctions=exports.textInputs=exports.stripUnit=exports.size=exports.shade=exports.setSaturation=exports.setLightness=exports.setHue=exports.selection=exports.saturate=exports.rgba=exports.rgb=exports.retinaImage=exports.rem=exports.readableColor=exports.radialGradient=exports.position=exports.placeholder=exports.parseToRgb=exports.parseToHsl=exports.padding=exports.opacify=exports.normalize=exports.modularScale=exports.mix=exports.margin=exports.lighten=exports.hsla=exports.hsl=exports.hiDPI=exports.hideVisually=exports.hideText=exports.invert=exports.grayscale=exports.getLuminance=exports.fontFace=exports.em=exports.ellipsis=exports.directionalProperty=exports.desaturate=exports.darken=exports.complement=exports.clearFix=exports.buttons=exports.borderWidth=exports.borderStyle=exports.borderRadius=exports.borderColor=exports.backgrounds=exports.backgroundImages=exports.animation=exports.adjustHue=undefined;var _directionalProperty=__webpack_require__(87);var _directionalProperty2=_interopRequireDefault(_directionalProperty);var _em=__webpack_require__(638);var _em2=_interopRequireDefault(_em);var _modularScale=__webpack_require__(640);var _modularScale2=_interopRequireDefault(_modularScale);var _rem=__webpack_require__(641);var _rem2=_interopRequireDefault(_rem);var _stripUnit=__webpack_require__(170);var _stripUnit2=_interopRequireDefault(_stripUnit);var _clearFix=__webpack_require__(642);var _clearFix2=_interopRequireDefault(_clearFix);var _ellipsis=__webpack_require__(643);var _ellipsis2=_interopRequireDefault(_ellipsis);var _fontFace=__webpack_require__(644);var _fontFace2=_interopRequireDefault(_fontFace);var _hideText=__webpack_require__(645);var _hideText2=_interopRequireDefault(_hideText);var _hideVisually=__webpack_require__(646);var _hideVisually2=_interopRequireDefault(_hideVisually);var _hiDPI=__webpack_require__(242);var _hiDPI2=_interopRequireDefault(_hiDPI);var _normalize=__webpack_require__(647);var _normalize2=_interopRequireDefault(_normalize);var _placeholder=__webpack_require__(648);var _placeholder2=_interopRequireDefault(_placeholder);var _radialGradient=__webpack_require__(649);var _radialGradient2=_interopRequireDefault(_radialGradient);var _retinaImage=__webpack_require__(650);var _retinaImage2=_interopRequireDefault(_retinaImage);var _selection=__webpack_require__(651);var _selection2=_interopRequireDefault(_selection);var _timingFunctions=__webpack_require__(652);var _timingFunctions2=_interopRequireDefault(_timingFunctions);var _triangle=__webpack_require__(653);var _triangle2=_interopRequireDefault(_triangle);var _wordWrap=__webpack_require__(654);var _wordWrap2=_interopRequireDefault(_wordWrap);var _adjustHue=__webpack_require__(655);var _adjustHue2=_interopRequireDefault(_adjustHue);var _complement=__webpack_require__(658);var _complement2=_interopRequireDefault(_complement);var _darken=__webpack_require__(659);var _darken2=_interopRequireDefault(_darken);var _desaturate=__webpack_require__(660);var _desaturate2=_interopRequireDefault(_desaturate);var _getLuminance=__webpack_require__(248);var _getLuminance2=_interopRequireDefault(_getLuminance);var _grayscale=__webpack_require__(661);var _grayscale2=_interopRequireDefault(_grayscale);var _hsl=__webpack_require__(245);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(247);var _hsla2=_interopRequireDefault(_hsla);var _invert=__webpack_require__(662);var _invert2=_interopRequireDefault(_invert);var _lighten=__webpack_require__(663);var _lighten2=_interopRequireDefault(_lighten);var _mix=__webpack_require__(173);var _mix2=_interopRequireDefault(_mix);var _opacify=__webpack_require__(664);var _opacify2=_interopRequireDefault(_opacify);var _parseToHsl=__webpack_require__(68);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _parseToRgb=__webpack_require__(78);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _readableColor=__webpack_require__(665);var _readableColor2=_interopRequireDefault(_readableColor);var _rgb=__webpack_require__(172);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(113);var _rgba2=_interopRequireDefault(_rgba);var _saturate=__webpack_require__(666);var _saturate2=_interopRequireDefault(_saturate);var _setHue=__webpack_require__(667);var _setHue2=_interopRequireDefault(_setHue);var _setLightness=__webpack_require__(668);var _setLightness2=_interopRequireDefault(_setLightness);var _setSaturation=__webpack_require__(669);var _setSaturation2=_interopRequireDefault(_setSaturation);var _shade=__webpack_require__(670);var _shade2=_interopRequireDefault(_shade);var _tint=__webpack_require__(671);var _tint2=_interopRequireDefault(_tint);var _toColorString=__webpack_require__(64);var _toColorString2=_interopRequireDefault(_toColorString);var _transparentize=__webpack_require__(672);var _transparentize2=_interopRequireDefault(_transparentize);var _animation=__webpack_require__(673);var _animation2=_interopRequireDefault(_animation);var _backgroundImages=__webpack_require__(674);var _backgroundImages2=_interopRequireDefault(_backgroundImages);var _backgrounds=__webpack_require__(675);var _backgrounds2=_interopRequireDefault(_backgrounds);var _borderColor=__webpack_require__(676);var _borderColor2=_interopRequireDefault(_borderColor);var _borderRadius=__webpack_require__(677);var _borderRadius2=_interopRequireDefault(_borderRadius);var _borderStyle=__webpack_require__(678);var _borderStyle2=_interopRequireDefault(_borderStyle);var _borderWidth=__webpack_require__(679);var _borderWidth2=_interopRequireDefault(_borderWidth);var _buttons=__webpack_require__(680);var _buttons2=_interopRequireDefault(_buttons);var _margin=__webpack_require__(681);var _margin2=_interopRequireDefault(_margin);var _padding=__webpack_require__(682);var _padding2=_interopRequireDefault(_padding);var _position=__webpack_require__(683);var _position2=_interopRequireDefault(_position);var _size=__webpack_require__(684);var _size2=_interopRequireDefault(_size);var _textInputs=__webpack_require__(685);var _textInputs2=_interopRequireDefault(_textInputs);var _transitions=__webpack_require__(686);var _transitions2=_interopRequireDefault(_transitions);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.adjustHue=_adjustHue2.default;exports.animation=_animation2.default;exports.backgroundImages=_backgroundImages2.default;exports.backgrounds=_backgrounds2.default;exports.borderColor=_borderColor2.default;exports.borderRadius=_borderRadius2.default;exports.borderStyle=_borderStyle2.default;exports.borderWidth=_borderWidth2.default;exports.buttons=_buttons2.default;exports.clearFix=_clearFix2.default;exports.complement=_complement2.default;exports.darken=_darken2.default;exports.desaturate=_desaturate2.default;exports.directionalProperty=_directionalProperty2.default;exports.ellipsis=_ellipsis2.default;exports.em=_em2.default;exports.fontFace=_fontFace2.default;exports.getLuminance=_getLuminance2.default;exports.grayscale=_grayscale2.default;exports.invert=_invert2.default;exports.hideText=_hideText2.default;exports.hideVisually=_hideVisually2.default;exports.hiDPI=_hiDPI2.default;exports.hsl=_hsl2.default;exports.hsla=_hsla2.default;exports.lighten=_lighten2.default;exports.margin=_margin2.default;exports.mix=_mix2.default;exports.modularScale=_modularScale2.default;exports.normalize=_normalize2.default;exports.opacify=_opacify2.default;exports.padding=_padding2.default;exports.parseToHsl=_parseToHsl2.default;exports.parseToRgb=_parseToRgb2.default;exports.placeholder=_placeholder2.default;exports.position=_position2.default;exports.radialGradient=_radialGradient2.default;exports.readableColor=_readableColor2.default;exports.rem=_rem2.default;exports.retinaImage=_retinaImage2.default;exports.rgb=_rgb2.default;exports.rgba=_rgba2.default;exports.saturate=_saturate2.default;exports.selection=_selection2.default;exports.setHue=_setHue2.default;exports.setLightness=_setLightness2.default;exports.setSaturation=_setSaturation2.default;exports.shade=_shade2.default;exports.size=_size2.default;exports.stripUnit=_stripUnit2.default;exports.textInputs=_textInputs2.default;exports.timingFunctions=_timingFunctions2.default;exports.tint=_tint2.default;exports.toColorString=_toColorString2.default;exports.transitions=_transitions2.default;exports.transparentize=_transparentize2.default;exports.triangle=_triangle2.default;exports.wordWrap=_wordWrap2.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(172);var _rgb2=_interopRequireDefault(_rgb);var _parseToRgb=__webpack_require__(78);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgba(firstValue,secondValue,thirdValue,fourthValue){if(typeof firstValue==="string"&&typeof secondValue==="number"){var rgbValue=(0,_parseToRgb2.default)(firstValue);return"rgba("+rgbValue.red+","+rgbValue.green+","+rgbValue.blue+","+secondValue+")"}else if(typeof firstValue==="number"&&typeof secondValue==="number"&&typeof thirdValue==="number"&&typeof fourthValue==="number"){return fourthValue>=1?(0,_rgb2.default)(firstValue,secondValue,thirdValue):"rgba("+firstValue+","+secondValue+","+thirdValue+","+fourthValue+")"}else if(typeof firstValue==="object"&&secondValue===undefined&&thirdValue===undefined&&fourthValue===undefined){return firstValue.alpha>=1?(0,_rgb2.default)(firstValue.red,firstValue.green,firstValue.blue):"rgba("+firstValue.red+","+firstValue.green+","+firstValue.blue+","+firstValue.alpha+")"}throw new Error("Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).")}exports.default=rgba;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(55);Object.defineProperty(exports,"__esModule",{value:true});exports.default=_default;var _objectWithoutProperties2=_interopRequireDefault(__webpack_require__(694));var _toConsumableArray2=_interopRequireDefault(__webpack_require__(696));var _objectSpread2=_interopRequireDefault(__webpack_require__(255));var _react=_interopRequireDefault(__webpack_require__(2));var _createElement=_interopRequireDefault(__webpack_require__(257));var _checkForListedLanguage=_interopRequireDefault(__webpack_require__(259));var newLineRegex=/\n/g;function getNewLines(str){return str.match(newLineRegex)}function getAllLineNumbers(_ref){var lines=_ref.lines,startingLineNumber=_ref.startingLineNumber,style=_ref.style;return lines.map((function(_,i){var number=i+startingLineNumber;return _react.default.createElement("span",{key:"line-".concat(i),className:"react-syntax-highlighter-line-number",style:typeof style==="function"?style(number):style},"".concat(number,"\n"))}))}function AllLineNumbers(_ref2){var codeString=_ref2.codeString,codeStyle=_ref2.codeStyle,_ref2$containerStyle=_ref2.containerStyle,containerStyle=_ref2$containerStyle===void 0?{float:"left",paddingRight:"10px"}:_ref2$containerStyle,_ref2$numberStyle=_ref2.numberStyle,numberStyle=_ref2$numberStyle===void 0?{}:_ref2$numberStyle,startingLineNumber=_ref2.startingLineNumber;return _react.default.createElement("code",{style:Object.assign({},codeStyle,containerStyle)},getAllLineNumbers({lines:codeString.replace(/\n$/,"").split("\n"),style:numberStyle,startingLineNumber:startingLineNumber}))}function getEmWidthOfNumber(num){var len=num.toString().length;return"".concat(len,"em")}function getInlineLineNumber(lineNumber,inlineLineNumberStyle){return{type:"element",tagName:"span",properties:{key:"line-number--".concat(lineNumber),className:["comment","linenumber","react-syntax-highlighter-line-number"],style:inlineLineNumberStyle},children:[{type:"text",value:lineNumber}]}}function assembleLineNumberStyles(lineNumberStyle,lineNumber,largestLineNumber){var defaultLineNumberStyle={display:"inline-block",minWidth:getEmWidthOfNumber(largestLineNumber),paddingRight:"1em",textAlign:"right",userSelect:"none"};var customLineNumberStyle=typeof lineNumberStyle==="function"?lineNumberStyle(lineNumber):lineNumberStyle;var assembledStyle=(0,_objectSpread2.default)({},defaultLineNumberStyle,customLineNumberStyle);return assembledStyle}function createLineElement(_ref3){var children=_ref3.children,lineNumber=_ref3.lineNumber,lineNumberStyle=_ref3.lineNumberStyle,largestLineNumber=_ref3.largestLineNumber,showInlineLineNumbers=_ref3.showInlineLineNumbers,_ref3$lineProps=_ref3.lineProps,lineProps=_ref3$lineProps===void 0?{}:_ref3$lineProps,_ref3$className=_ref3.className,className=_ref3$className===void 0?[]:_ref3$className,showLineNumbers=_ref3.showLineNumbers,wrapLongLines=_ref3.wrapLongLines;var properties=typeof lineProps==="function"?lineProps(lineNumber):lineProps;properties["className"]=className;if(lineNumber&&showInlineLineNumbers){var inlineLineNumberStyle=assembleLineNumberStyles(lineNumberStyle,lineNumber,largestLineNumber);children.unshift(getInlineLineNumber(lineNumber,inlineLineNumberStyle))}if(wrapLongLines&showLineNumbers){properties.style=(0,_objectSpread2.default)({},properties.style,{display:"flex"})}return{type:"element",tagName:"span",properties:properties,children:children}}function flattenCodeTree(tree){var className=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[];var newTree=arguments.length>2&&arguments[2]!==undefined?arguments[2]:[];for(var i=0;i<tree.length;i++){var node=tree[i];if(node.type==="text"){newTree.push(createLineElement({children:[node],className:(0,_toConsumableArray2.default)(new Set(className))}))}else if(node.children){var classNames=className.concat(node.properties.className);newTree=newTree.concat(flattenCodeTree(node.children,classNames))}}return newTree}function processLines(codeTree,wrapLines,lineProps,showLineNumbers,showInlineLineNumbers,startingLineNumber,largestLineNumber,lineNumberStyle,wrapLongLines){var _ref4;var tree=flattenCodeTree(codeTree.value);var newTree=[];var lastLineBreakIndex=-1;var index=0;function createWrappedLine(children,lineNumber){var className=arguments.length>2&&arguments[2]!==undefined?arguments[2]:[];return createLineElement({children:children,lineNumber:lineNumber,lineNumberStyle:lineNumberStyle,largestLineNumber:largestLineNumber,showInlineLineNumbers:showInlineLineNumbers,lineProps:lineProps,className:className,showLineNumbers:showLineNumbers,wrapLongLines:wrapLongLines})}function createUnwrappedLine(children,lineNumber){if(showLineNumbers&&lineNumber&&showInlineLineNumbers){var inlineLineNumberStyle=assembleLineNumberStyles(lineNumberStyle,lineNumber,largestLineNumber);children.unshift(getInlineLineNumber(lineNumber,inlineLineNumberStyle))}return children}function createLine(children,lineNumber){var className=arguments.length>2&&arguments[2]!==undefined?arguments[2]:[];return wrapLines||className.length>0?createWrappedLine(children,lineNumber,className):createUnwrappedLine(children,lineNumber)}var _loop=function _loop(){var node=tree[index];var value=node.children[0].value;var newLines=getNewLines(value);if(newLines){var splitValue=value.split("\n");splitValue.forEach((function(text,i){var lineNumber=showLineNumbers&&newTree.length+startingLineNumber;var newChild={type:"text",value:"".concat(text,"\n")};if(i===0){var _children=tree.slice(lastLineBreakIndex+1,index).concat(createLineElement({children:[newChild],className:node.properties.className}));var _line=createLine(_children,lineNumber);newTree.push(_line)}else if(i===splitValue.length-1){var stringChild=tree[index+1]&&tree[index+1].children&&tree[index+1].children[0];if(stringChild){var lastLineInPreviousSpan={type:"text",value:"".concat(text)};var newElem=createLineElement({children:[lastLineInPreviousSpan],className:node.properties.className});tree.splice(index+1,0,newElem)}else{var _children2=[newChild];var _line2=createLine(_children2,lineNumber,node.properties.className);newTree.push(_line2)}}else{var _children3=[newChild];var _line3=createLine(_children3,lineNumber,node.properties.className);newTree.push(_line3)}}));lastLineBreakIndex=index}index++};while(index<tree.length){_loop()}if(lastLineBreakIndex!==tree.length-1){var children=tree.slice(lastLineBreakIndex+1,tree.length);if(children&&children.length){var lineNumber=newTree.length+startingLineNumber;var line=createLine(children,lineNumber);newTree.push(line)}}return wrapLines?newTree:(_ref4=[]).concat.apply(_ref4,newTree)}function defaultRenderer(_ref5){var rows=_ref5.rows,stylesheet=_ref5.stylesheet,useInlineStyles=_ref5.useInlineStyles;return rows.map((function(node,i){return(0,_createElement.default)({node:node,stylesheet:stylesheet,useInlineStyles:useInlineStyles,key:"code-segement".concat(i)})}))}function isHighlightJs(astGenerator){return astGenerator&&typeof astGenerator.highlightAuto!=="undefined"}function getCodeTree(_ref6){var astGenerator=_ref6.astGenerator,language=_ref6.language,code=_ref6.code,defaultCodeValue=_ref6.defaultCodeValue;if(isHighlightJs(astGenerator)){var hasLanguage=(0,_checkForListedLanguage.default)(astGenerator,language);if(language==="text"){return{value:defaultCodeValue,language:"text"}}else if(hasLanguage){return astGenerator.highlight(language,code)}else{return astGenerator.highlightAuto(code)}}try{return language&&language!=="text"?{value:astGenerator.highlight(code,language)}:{value:defaultCodeValue}}catch(e){return{value:defaultCodeValue}}}function _default(defaultAstGenerator,defaultStyle){return function SyntaxHighlighter(_ref7){var language=_ref7.language,children=_ref7.children,_ref7$style=_ref7.style,style=_ref7$style===void 0?defaultStyle:_ref7$style,_ref7$customStyle=_ref7.customStyle,customStyle=_ref7$customStyle===void 0?{}:_ref7$customStyle,_ref7$codeTagProps=_ref7.codeTagProps,codeTagProps=_ref7$codeTagProps===void 0?{className:language?"language-".concat(language):undefined,style:(0,_objectSpread2.default)({},style['code[class*="language-"]'],style['code[class*="language-'.concat(language,'"]')])}:_ref7$codeTagProps,_ref7$useInlineStyles=_ref7.useInlineStyles,useInlineStyles=_ref7$useInlineStyles===void 0?true:_ref7$useInlineStyles,_ref7$showLineNumbers=_ref7.showLineNumbers,showLineNumbers=_ref7$showLineNumbers===void 0?false:_ref7$showLineNumbers,_ref7$showInlineLineN=_ref7.showInlineLineNumbers,showInlineLineNumbers=_ref7$showInlineLineN===void 0?true:_ref7$showInlineLineN,_ref7$startingLineNum=_ref7.startingLineNumber,startingLineNumber=_ref7$startingLineNum===void 0?1:_ref7$startingLineNum,lineNumberContainerStyle=_ref7.lineNumberContainerStyle,_ref7$lineNumberStyle=_ref7.lineNumberStyle,lineNumberStyle=_ref7$lineNumberStyle===void 0?{}:_ref7$lineNumberStyle,wrapLines=_ref7.wrapLines,_ref7$wrapLongLines=_ref7.wrapLongLines,wrapLongLines=_ref7$wrapLongLines===void 0?false:_ref7$wrapLongLines,_ref7$lineProps=_ref7.lineProps,lineProps=_ref7$lineProps===void 0?{}:_ref7$lineProps,renderer=_ref7.renderer,_ref7$PreTag=_ref7.PreTag,PreTag=_ref7$PreTag===void 0?"pre":_ref7$PreTag,_ref7$CodeTag=_ref7.CodeTag,CodeTag=_ref7$CodeTag===void 0?"code":_ref7$CodeTag,_ref7$code=_ref7.code,code=_ref7$code===void 0?Array.isArray(children)?children[0]:children:_ref7$code,astGenerator=_ref7.astGenerator,rest=(0,_objectWithoutProperties2.default)(_ref7,["language","children","style","customStyle","codeTagProps","useInlineStyles","showLineNumbers","showInlineLineNumbers","startingLineNumber","lineNumberContainerStyle","lineNumberStyle","wrapLines","wrapLongLines","lineProps","renderer","PreTag","CodeTag","code","astGenerator"]);astGenerator=astGenerator||defaultAstGenerator;var allLineNumbers=showLineNumbers?_react.default.createElement(AllLineNumbers,{containerStyle:lineNumberContainerStyle,codeStyle:codeTagProps.style||{},numberStyle:lineNumberStyle,startingLineNumber:startingLineNumber,codeString:code}):null;var defaultPreStyle=style.hljs||style['pre[class*="language-"]']||{backgroundColor:"#fff"};var generatorClassName=isHighlightJs(astGenerator)?"hljs":"prismjs";var preProps=useInlineStyles?Object.assign({},rest,{style:Object.assign({},defaultPreStyle,customStyle)}):Object.assign({},rest,{className:rest.className?"".concat(generatorClassName," ").concat(rest.className):generatorClassName,style:Object.assign({},customStyle)});if(!astGenerator){return _react.default.createElement(PreTag,preProps,allLineNumbers,_react.default.createElement(CodeTag,codeTagProps,code))}if(wrapLines===undefined&&renderer||wrapLongLines)wrapLines=true;renderer=renderer||defaultRenderer;var defaultCodeValue=[{type:"text",value:code}];var codeTree=getCodeTree({astGenerator:astGenerator,language:language,code:code,defaultCodeValue:defaultCodeValue});if(codeTree.language===null){codeTree.value=defaultCodeValue}var largestLineNumber=codeTree.value.length+startingLineNumber;var rows=processLines(codeTree,wrapLines,lineProps,showLineNumbers,showInlineLineNumbers,startingLineNumber,largestLineNumber,lineNumberStyle,wrapLongLines);if(wrapLongLines){codeTagProps.style=(0,_objectSpread2.default)({},codeTagProps.style,{whiteSpace:"pre-wrap"})}else{codeTagProps.style=(0,_objectSpread2.default)({},codeTagProps.style,{whiteSpace:"pre"})}return _react.default.createElement(PreTag,preProps,_react.default.createElement(CodeTag,codeTagProps,!showInlineLineNumbers&&allLineNumbers,renderer({rows:rows,stylesheet:style,useInlineStyles:useInlineStyles})))}}},function(module,exports,__webpack_require__){"use strict";module.exports=ruby;ruby.displayName="ruby";ruby.aliases=["rb"];function ruby(Prism){(function(Prism){Prism.languages.ruby=Prism.languages.extend("clike",{comment:[/#.*/,{pattern:/^=begin\s[\s\S]*?^=end/m,greedy:true}],"class-name":{pattern:/(\b(?:class)\s+|\bcatch\s+\()[\w.\\]+/i,lookbehind:true,inside:{punctuation:/[.\\]/}},keyword:/\b(?:alias|and|BEGIN|begin|break|case|class|def|define_method|defined|do|each|else|elsif|END|end|ensure|extend|for|if|in|include|module|new|next|nil|not|or|prepend|protected|private|public|raise|redo|require|rescue|retry|return|self|super|then|throw|undef|unless|until|when|while|yield)\b/});var interpolation={pattern:/#\{[^}]+\}/,inside:{delimiter:{pattern:/^#\{|\}$/,alias:"tag"},rest:Prism.languages.ruby}};delete Prism.languages.ruby.function;Prism.languages.insertBefore("ruby","keyword",{regex:[{pattern:RegExp(/%r/.source+"(?:"+[/([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1[gim]{0,3}/.source,/\((?:[^()\\]|\\[\s\S])*\)[gim]{0,3}/.source,/\{(?:[^#{}\\]|#(?:\{[^}]+\})?|\\[\s\S])*\}[gim]{0,3}/.source,/\[(?:[^\[\]\\]|\\[\s\S])*\][gim]{0,3}/.source,/<(?:[^<>\\]|\\[\s\S])*>[gim]{0,3}/.source].join("|")+")"),greedy:true,inside:{interpolation:interpolation}},{pattern:/(^|[^/])\/(?!\/)(?:\[[^\r\n\]]+\]|\\.|[^[/\\\r\n])+\/[gim]{0,3}(?=\s*(?:$|[\r\n,.;})]))/,lookbehind:true,greedy:true}],variable:/[@$]+[a-zA-Z_]\w*(?:[?!]|\b)/,symbol:{pattern:/(^|[^:]):[a-zA-Z_]\w*(?:[?!]|\b)/,lookbehind:true},"method-definition":{pattern:/(\bdef\s+)[\w.]+/,lookbehind:true,inside:{function:/\w+$/,rest:Prism.languages.ruby}}});Prism.languages.insertBefore("ruby","number",{builtin:/\b(?:Array|Bignum|Binding|Class|Continuation|Dir|Exception|FalseClass|File|Stat|Fixnum|Float|Hash|Integer|IO|MatchData|Method|Module|NilClass|Numeric|Object|Proc|Range|Regexp|String|Struct|TMS|Symbol|ThreadGroup|Thread|Time|TrueClass)\b/,constant:/\b[A-Z]\w*(?:[?!]|\b)/});Prism.languages.ruby.string=[{pattern:RegExp(/%[qQiIwWxs]?/.source+"(?:"+[/([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1/.source,/\((?:[^()\\]|\\[\s\S])*\)/.source,/\{(?:[^#{}\\]|#(?:\{[^}]+\})?|\\[\s\S])*\}/.source,/\[(?:[^\[\]\\]|\\[\s\S])*\]/.source,/<(?:[^<>\\]|\\[\s\S])*>/.source].join("|")+")"),greedy:true,inside:{interpolation:interpolation}},{pattern:/("|')(?:#\{[^}]+\}|\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true,inside:{interpolation:interpolation}}];Prism.languages.rb=Prism.languages.ruby})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=javadoclike;javadoclike.displayName="javadoclike";javadoclike.aliases=[];function javadoclike(Prism){(function(Prism){var javaDocLike=Prism.languages.javadoclike={parameter:{pattern:/(^\s*(?:\/{3}|\*|\/\*\*)\s*@(?:param|arg|arguments)\s+)\w+/m,lookbehind:true},keyword:{pattern:/(^\s*(?:\/{3}|\*|\/\*\*)\s*|\{)@[a-z][a-zA-Z-]+\b/m,lookbehind:true},punctuation:/[{}]/};function docCommentSupport(lang,callback){var tokenName="doc-comment";var grammar=Prism.languages[lang];if(!grammar){return}var token=grammar[tokenName];if(!token){var definition={};definition[tokenName]={pattern:/(^|[^\\])\/\*\*[^/][\s\S]*?(?:\*\/|$)/,lookbehind:true,alias:"comment"};grammar=Prism.languages.insertBefore(lang,"comment",definition);token=grammar[tokenName]}if(token instanceof RegExp){token=grammar[tokenName]={pattern:token}}if(Array.isArray(token)){for(var i=0,l=token.length;i<l;i++){if(token[i]instanceof RegExp){token[i]={pattern:token[i]}}callback(token[i])}}else{callback(token)}}function addSupport(languages,docLanguage){if(typeof languages==="string"){languages=[languages]}languages.forEach((function(lang){docCommentSupport(lang,(function(pattern){if(!pattern.inside){pattern.inside={}}pattern.inside.rest=docLanguage}))}))}Object.defineProperty(javaDocLike,"addSupport",{value:addSupport});javaDocLike.addSupport(["java","javascript","php"],javaDocLike)})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=php;php.displayName="php";php.aliases=[];function php(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.php=Prism.languages.extend("clike",{keyword:/\b(?:__halt_compiler|abstract|and|array|as|break|callable|case|catch|class|clone|const|continue|declare|default|die|do|echo|else|elseif|empty|enddeclare|endfor|endforeach|endif|endswitch|endwhile|eval|exit|extends|final|finally|for|foreach|function|global|goto|if|implements|include|include_once|instanceof|insteadof|interface|isset|list|match|namespace|new|or|parent|print|private|protected|public|require|require_once|return|static|switch|throw|trait|try|unset|use|var|while|xor|yield)\b/i,boolean:{pattern:/\b(?:false|true)\b/i,alias:"constant"},constant:[/\b[A-Z_][A-Z0-9_]*\b/,/\b(?:null)\b/i],comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|\/\/.*)/,lookbehind:true}});Prism.languages.insertBefore("php","string",{"shell-comment":{pattern:/(^|[^\\])#.*/,lookbehind:true,alias:"comment"}});Prism.languages.insertBefore("php","comment",{delimiter:{pattern:/\?>$|^<\?(?:php(?=\s)|=)?/i,alias:"important"}});Prism.languages.insertBefore("php","keyword",{variable:/\$+(?:\w+\b|(?={))/i,package:{pattern:/(\\|namespace\s+|use\s+)[\w\\]+/,lookbehind:true,inside:{punctuation:/\\/}}});Prism.languages.insertBefore("php","operator",{property:{pattern:/(->)[\w]+/,lookbehind:true}});var string_interpolation={pattern:/{\$(?:{(?:{[^{}]+}|[^{}]+)}|[^{}])+}|(^|[^\\{])\$+(?:\w+(?:\[[^\r\n\[\]]+\]|->\w+)*)/,lookbehind:true,inside:Prism.languages.php};Prism.languages.insertBefore("php","string",{"nowdoc-string":{pattern:/<<<'([^']+)'[\r\n](?:.*[\r\n])*?\1;/,greedy:true,alias:"string",inside:{delimiter:{pattern:/^<<<'[^']+'|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<'?|[';]$/}}}},"heredoc-string":{pattern:/<<<(?:"([^"]+)"[\r\n](?:.*[\r\n])*?\1;|([a-z_]\w*)[\r\n](?:.*[\r\n])*?\2;)/i,greedy:true,alias:"string",inside:{delimiter:{pattern:/^<<<(?:"[^"]+"|[a-z_]\w*)|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<"?|[";]$/}},interpolation:string_interpolation}},"single-quoted-string":{pattern:/'(?:\\[\s\S]|[^\\'])*'/,greedy:true,alias:"string"},"double-quoted-string":{pattern:/"(?:\\[\s\S]|[^\\"])*"/,greedy:true,alias:"string",inside:{interpolation:string_interpolation}}});delete Prism.languages.php["string"];Prism.hooks.add("before-tokenize",(function(env){if(!/<\?/.test(env.code)){return}var phpPattern=/<\?(?:[^"'/#]|\/(?![*/])|("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|(?:\/\/|#)(?:[^?\n\r]|\?(?!>))*(?=$|\?>|[\r\n])|\/\*[\s\S]*?(?:\*\/|$))*?(?:\?>|$)/gi;Prism.languages["markup-templating"].buildPlaceholders(env,"php",phpPattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"php")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";var normalize=__webpack_require__(187);var Schema=__webpack_require__(480);var DefinedInfo=__webpack_require__(481);module.exports=create;function create(definition){var space=definition.space;var mustUseProperty=definition.mustUseProperty||[];var attributes=definition.attributes||{};var props=definition.properties;var transform=definition.transform;var property={};var normal={};var prop;var info;for(prop in props){info=new DefinedInfo(prop,transform(attributes,prop),props[prop],space);if(mustUseProperty.indexOf(prop)!==-1){info.mustUseProperty=true}property[prop]=info;normal[normalize(prop)]=prop;normal[normalize(info.attribute)]=prop}return new Schema(property,normal,space)}},function(module,exports,__webpack_require__){var baseGetTag=__webpack_require__(90),isObject=__webpack_require__(66);var asyncTag="[object AsyncFunction]",funcTag="[object Function]",genTag="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction(value){if(!isObject(value)){return false}var tag=baseGetTag(value);return tag==funcTag||tag==genTag||tag==asyncTag||tag==proxyTag}module.exports=isFunction},function(module,exports,__webpack_require__){var assignValue=__webpack_require__(143),baseAssignValue=__webpack_require__(144);function copyObject(source,props,object,customizer){var isNew=!object;object||(object={});var index=-1,length=props.length;while(++index<length){var key=props[index];var newValue=customizer?customizer(object[key],source[key],key,object,source):undefined;if(newValue===undefined){newValue=source[key]}if(isNew){baseAssignValue(object,key,newValue)}else{assignValue(object,key,newValue)}}return object}module.exports=copyObject},function(module,exports,__webpack_require__){var baseIsArguments=__webpack_require__(1167),isObjectLike=__webpack_require__(74);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;var propertyIsEnumerable=objectProto.propertyIsEnumerable;var isArguments=baseIsArguments(function(){return arguments}())?baseIsArguments:function(value){return isObjectLike(value)&&hasOwnProperty.call(value,"callee")&&!propertyIsEnumerable.call(value,"callee")};module.exports=isArguments},function(module,exports,__webpack_require__){var baseIsTypedArray=__webpack_require__(1169),baseUnary=__webpack_require__(146),nodeUtil=__webpack_require__(194);var nodeIsTypedArray=nodeUtil&&nodeUtil.isTypedArray;var isTypedArray=nodeIsTypedArray?baseUnary(nodeIsTypedArray):baseIsTypedArray;module.exports=isTypedArray},function(module,exports,__webpack_require__){var isSymbol=__webpack_require__(105);var INFINITY=1/0;function toKey(value){if(typeof value=="string"||isSymbol(value)){return value}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}module.exports=toKey},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getSeverity}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getSeverityColor}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ML_ERRORS}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var _ml_common__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(1);var _ml_common__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_ml_common__WEBPACK_IMPORTED_MODULE_1__);function getSeverity(score){if(score===undefined){return _ml_common__WEBPACK_IMPORTED_MODULE_1__["ANOMALY_SEVERITY"].UNKNOWN}return Object(_ml_common__WEBPACK_IMPORTED_MODULE_1__["getSeverityType"])(score)}function getSeverityColor(score){return Object(_ml_common__WEBPACK_IMPORTED_MODULE_1__["getSeverityColor"])(score)}const ML_ERRORS={INVALID_LICENSE:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.anomaly_detection.error.invalid_license",{defaultMessage:`To use anomaly detection, you must be subscribed to an Elastic Platinum license. With it, you'll be able to monitor your services with the aid of machine learning.`}),MISSING_READ_PRIVILEGES:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.anomaly_detection.error.missing_read_privileges",{defaultMessage:'You must have "read" privileges to Machine Learning and APM in order to view Anomaly Detection jobs'}),MISSING_WRITE_PRIVILEGES:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.anomaly_detection.error.missing_write_privileges",{defaultMessage:'You must have "write" privileges to Machine Learning and APM in order to create Anomaly Detection jobs'}),ML_NOT_AVAILABLE:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.anomaly_detection.error.not_available",{defaultMessage:"Machine learning is not available"}),ML_NOT_AVAILABLE_IN_SPACE:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.apm.anomaly_detection.error.not_available_in_space",{defaultMessage:"Machine learning is not available in the selected space"})}},function(module,exports,__webpack_require__){"use strict";var keys=__webpack_require__(548);var hasSymbols=typeof Symbol==="function"&&typeof Symbol("foo")==="symbol";var toStr=Object.prototype.toString;var concat=Array.prototype.concat;var origDefineProperty=Object.defineProperty;var isFunction=function(fn){return typeof fn==="function"&&toStr.call(fn)==="[object Function]"};var arePropertyDescriptorsSupported=function(){var obj={};try{origDefineProperty(obj,"x",{enumerable:false,value:obj});for(var _ in obj){return false}return obj.x===obj}catch(e){return false}};var supportsDescriptors=origDefineProperty&&arePropertyDescriptorsSupported();var defineProperty=function(object,name,value,predicate){if(name in object&&(!isFunction(predicate)||!predicate())){return}if(supportsDescriptors){origDefineProperty(object,name,{configurable:true,enumerable:false,value:value,writable:true})}else{object[name]=value}};var defineProperties=function(object,map){var predicates=arguments.length>2?arguments[2]:{};var props=keys(map);if(hasSymbols){props=concat.call(props,Object.getOwnPropertySymbols(map))}for(var i=0;i<props.length;i+=1){defineProperty(object,props[i],map[props[i]],predicates[props[i]])}};defineProperties.supportsDescriptors=!!supportsDescriptors;module.exports=defineProperties},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(1368)):undefined})(this,(function(exports,d3Path){"use strict";function constant(x){return function constant(){return x}}var abs=Math.abs;var atan2=Math.atan2;var cos=Math.cos;var max=Math.max;var min=Math.min;var sin=Math.sin;var sqrt=Math.sqrt;var epsilon=1e-12;var pi=Math.PI;var halfPi=pi/2;var tau=2*pi;function acos(x){return x>1?0:x<-1?pi:Math.acos(x)}function asin(x){return x>=1?halfPi:x<=-1?-halfPi:Math.asin(x)}function arcInnerRadius(d){return d.innerRadius}function arcOuterRadius(d){return d.outerRadius}function arcStartAngle(d){return d.startAngle}function arcEndAngle(d){return d.endAngle}function arcPadAngle(d){return d&&d.padAngle}function intersect(x0,y0,x1,y1,x2,y2,x3,y3){var x10=x1-x0,y10=y1-y0,x32=x3-x2,y32=y3-y2,t=y32*x10-x32*y10;if(t*t<epsilon)return;t=(x32*(y0-y2)-y32*(x0-x2))/t;return[x0+t*x10,y0+t*y10]}function cornerTangents(x0,y0,x1,y1,r1,rc,cw){var x01=x0-x1,y01=y0-y1,lo=(cw?rc:-rc)/sqrt(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x11=x0+ox,y11=y0+oy,x10=x1+ox,y10=y1+oy,x00=(x11+x10)/2,y00=(y11+y10)/2,dx=x10-x11,dy=y10-y11,d2=dx*dx+dy*dy,r=r1-rc,D=x11*y10-x10*y11,d=(dy<0?-1:1)*sqrt(max(0,r*r*d2-D*D)),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x00,dy0=cy0-y00,dx1=cx1-x00,dy1=cy1-y00;if(dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1)cx0=cx1,cy0=cy1;return{cx:cx0,cy:cy0,x01:-ox,y01:-oy,x11:cx0*(r1/r-1),y11:cy0*(r1/r-1)}}function arc(){var innerRadius=arcInnerRadius,outerRadius=arcOuterRadius,cornerRadius=constant(0),padRadius=null,startAngle=arcStartAngle,endAngle=arcEndAngle,padAngle=arcPadAngle,context=null;function arc(){var buffer,r,r0=+innerRadius.apply(this,arguments),r1=+outerRadius.apply(this,arguments),a0=startAngle.apply(this,arguments)-halfPi,a1=endAngle.apply(this,arguments)-halfPi,da=abs(a1-a0),cw=a1>a0;if(!context)context=buffer=d3Path.path();if(r1<r0)r=r1,r1=r0,r0=r;if(!(r1>epsilon))context.moveTo(0,0);else if(da>tau-epsilon){context.moveTo(r1*cos(a0),r1*sin(a0));context.arc(0,0,r1,a0,a1,!cw);if(r0>epsilon){context.moveTo(r0*cos(a1),r0*sin(a1));context.arc(0,0,r0,a1,a0,cw)}}else{var a01=a0,a11=a1,a00=a0,a10=a1,da0=da,da1=da,ap=padAngle.apply(this,arguments)/2,rp=ap>epsilon&&(padRadius?+padRadius.apply(this,arguments):sqrt(r0*r0+r1*r1)),rc=min(abs(r1-r0)/2,+cornerRadius.apply(this,arguments)),rc0=rc,rc1=rc,t0,t1;if(rp>epsilon){var p0=asin(rp/r0*sin(ap)),p1=asin(rp/r1*sin(ap));if((da0-=p0*2)>epsilon)p0*=cw?1:-1,a00+=p0,a10-=p0;else da0=0,a00=a10=(a0+a1)/2;if((da1-=p1*2)>epsilon)p1*=cw?1:-1,a01+=p1,a11-=p1;else da1=0,a01=a11=(a0+a1)/2}var x01=r1*cos(a01),y01=r1*sin(a01),x10=r0*cos(a10),y10=r0*sin(a10);if(rc>epsilon){var x11=r1*cos(a11),y11=r1*sin(a11),x00=r0*cos(a00),y00=r0*sin(a00),oc;if(da<pi&&(oc=intersect(x01,y01,x00,y00,x11,y11,x10,y10))){var ax=x01-oc[0],ay=y01-oc[1],bx=x11-oc[0],by=y11-oc[1],kc=1/sin(acos((ax*bx+ay*by)/(sqrt(ax*ax+ay*ay)*sqrt(bx*bx+by*by)))/2),lc=sqrt(oc[0]*oc[0]+oc[1]*oc[1]);rc0=min(rc,(r0-lc)/(kc-1));rc1=min(rc,(r1-lc)/(kc+1))}}if(!(da1>epsilon))context.moveTo(x01,y01);else if(rc1>epsilon){t0=cornerTangents(x00,y00,x01,y01,r1,rc1,cw);t1=cornerTangents(x11,y11,x10,y10,r1,rc1,cw);context.moveTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc1<rc)context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r1,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),!cw);context.arc(t1.cx,t1.cy,rc1,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.moveTo(x01,y01),context.arc(0,0,r1,a01,a11,!cw);if(!(r0>epsilon)||!(da0>epsilon))context.lineTo(x10,y10);else if(rc0>epsilon){t0=cornerTangents(x10,y10,x11,y11,r0,-rc0,cw);t1=cornerTangents(x01,y01,x00,y00,r0,-rc0,cw);context.lineTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc0<rc)context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r0,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),cw);context.arc(t1.cx,t1.cy,rc0,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.arc(0,0,r0,a10,a00,cw)}context.closePath();if(buffer)return context=null,buffer+""||null}arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-pi/2;return[cos(a)*r,sin(a)*r]};arc.innerRadius=function(_){return arguments.length?(innerRadius=typeof _==="function"?_:constant(+_),arc):innerRadius};arc.outerRadius=function(_){return arguments.length?(outerRadius=typeof _==="function"?_:constant(+_),arc):outerRadius};arc.cornerRadius=function(_){return arguments.length?(cornerRadius=typeof _==="function"?_:constant(+_),arc):cornerRadius};arc.padRadius=function(_){return arguments.length?(padRadius=_==null?null:typeof _==="function"?_:constant(+_),arc):padRadius};arc.startAngle=function(_){return arguments.length?(startAngle=typeof _==="function"?_:constant(+_),arc):startAngle};arc.endAngle=function(_){return arguments.length?(endAngle=typeof _==="function"?_:constant(+_),arc):endAngle};arc.padAngle=function(_){return arguments.length?(padAngle=typeof _==="function"?_:constant(+_),arc):padAngle};arc.context=function(_){return arguments.length?(context=_==null?null:_,arc):context};return arc}function Linear(context){this._context=context}Linear.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:this._context.lineTo(x,y);break}}};function curveLinear(context){return new Linear(context)}function x(p){return p[0]}function y(p){return p[1]}function line(){var x$1=x,y$1=y,defined=constant(true),context=null,curve=curveLinear,output=null;function line(data){var i,n=data.length,d,defined0=false,buffer;if(context==null)output=curve(buffer=d3Path.path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0)output.lineStart();else output.lineEnd()}if(defined0)output.point(+x$1(d,i,data),+y$1(d,i,data))}if(buffer)return output=null,buffer+""||null}line.x=function(_){return arguments.length?(x$1=typeof _==="function"?_:constant(+_),line):x$1};line.y=function(_){return arguments.length?(y$1=typeof _==="function"?_:constant(+_),line):y$1};line.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),line):defined};line.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),line):curve};line.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),line):context};return line}function area(){var x0=x,x1=null,y0=constant(0),y1=y,defined=constant(true),context=null,curve=curveLinear,output=null;function area(data){var i,j,k,n=data.length,d,defined0=false,buffer,x0z=new Array(n),y0z=new Array(n);if(context==null)output=curve(buffer=d3Path.path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0){j=i;output.areaStart();output.lineStart()}else{output.lineEnd();output.lineStart();for(k=i-1;k>=j;--k){output.point(x0z[k],y0z[k])}output.lineEnd();output.areaEnd()}}if(defined0){x0z[i]=+x0(d,i,data),y0z[i]=+y0(d,i,data);output.point(x1?+x1(d,i,data):x0z[i],y1?+y1(d,i,data):y0z[i])}}if(buffer)return output=null,buffer+""||null}function arealine(){return line().defined(defined).curve(curve).context(context)}area.x=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),x1=null,area):x0};area.x0=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),area):x0};area.x1=function(_){return arguments.length?(x1=_==null?null:typeof _==="function"?_:constant(+_),area):x1};area.y=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),y1=null,area):y0};area.y0=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),area):y0};area.y1=function(_){return arguments.length?(y1=_==null?null:typeof _==="function"?_:constant(+_),area):y1};area.lineX0=area.lineY0=function(){return arealine().x(x0).y(y0)};area.lineY1=function(){return arealine().x(x0).y(y1)};area.lineX1=function(){return arealine().x(x1).y(y0)};area.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),area):defined};area.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),area):curve};area.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),area):context};return area}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function identity(d){return d}function pie(){var value=identity,sortValues=descending,sort=null,startAngle=constant(0),endAngle=constant(tau),padAngle=constant(0);function pie(data){var i,n=data.length,j,k,sum=0,index=new Array(n),arcs=new Array(n),a0=+startAngle.apply(this,arguments),da=Math.min(tau,Math.max(-tau,endAngle.apply(this,arguments)-a0)),a1,p=Math.min(Math.abs(da)/n,padAngle.apply(this,arguments)),pa=p*(da<0?-1:1),v;for(i=0;i<n;++i){if((v=arcs[index[i]=i]=+value(data[i],i,data))>0){sum+=v}}if(sortValues!=null)index.sort((function(i,j){return sortValues(arcs[i],arcs[j])}));else if(sort!=null)index.sort((function(i,j){return sort(data[i],data[j])}));for(i=0,k=sum?(da-n*pa)/sum:0;i<n;++i,a0=a1){j=index[i],v=arcs[j],a1=a0+(v>0?v*k:0)+pa,arcs[j]={data:data[j],index:i,value:v,startAngle:a0,endAngle:a1,padAngle:p}}return arcs}pie.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(+_),pie):value};pie.sortValues=function(_){return arguments.length?(sortValues=_,sort=null,pie):sortValues};pie.sort=function(_){return arguments.length?(sort=_,sortValues=null,pie):sort};pie.startAngle=function(_){return arguments.length?(startAngle=typeof _==="function"?_:constant(+_),pie):startAngle};pie.endAngle=function(_){return arguments.length?(endAngle=typeof _==="function"?_:constant(+_),pie):endAngle};pie.padAngle=function(_){return arguments.length?(padAngle=typeof _==="function"?_:constant(+_),pie):padAngle};return pie}var curveRadialLinear=curveRadial(curveLinear);function Radial(curve){this._curve=curve}Radial.prototype={areaStart:function(){this._curve.areaStart()},areaEnd:function(){this._curve.areaEnd()},lineStart:function(){this._curve.lineStart()},lineEnd:function(){this._curve.lineEnd()},point:function(a,r){this._curve.point(r*Math.sin(a),r*-Math.cos(a))}};function curveRadial(curve){function radial(context){return new Radial(curve(context))}radial._curve=curve;return radial}function lineRadial(l){var c=l.curve;l.angle=l.x,delete l.x;l.radius=l.y,delete l.y;l.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve};return l}function lineRadial$1(){return lineRadial(line().curve(curveRadialLinear))}function areaRadial(){var a=area().curve(curveRadialLinear),c=a.curve,x0=a.lineX0,x1=a.lineX1,y0=a.lineY0,y1=a.lineY1;a.angle=a.x,delete a.x;a.startAngle=a.x0,delete a.x0;a.endAngle=a.x1,delete a.x1;a.radius=a.y,delete a.y;a.innerRadius=a.y0,delete a.y0;a.outerRadius=a.y1,delete a.y1;a.lineStartAngle=function(){return lineRadial(x0())},delete a.lineX0;a.lineEndAngle=function(){return lineRadial(x1())},delete a.lineX1;a.lineInnerRadius=function(){return lineRadial(y0())},delete a.lineY0;a.lineOuterRadius=function(){return lineRadial(y1())},delete a.lineY1;a.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve};return a}function pointRadial(x,y){return[(y=+y)*Math.cos(x-=Math.PI/2),y*Math.sin(x)]}var slice=Array.prototype.slice;function linkSource(d){return d.source}function linkTarget(d){return d.target}function link(curve){var source=linkSource,target=linkTarget,x$1=x,y$1=y,context=null;function link(){var buffer,argv=slice.call(arguments),s=source.apply(this,argv),t=target.apply(this,argv);if(!context)context=buffer=d3Path.path();curve(context,+x$1.apply(this,(argv[0]=s,argv)),+y$1.apply(this,argv),+x$1.apply(this,(argv[0]=t,argv)),+y$1.apply(this,argv));if(buffer)return context=null,buffer+""||null}link.source=function(_){return arguments.length?(source=_,link):source};link.target=function(_){return arguments.length?(target=_,link):target};link.x=function(_){return arguments.length?(x$1=typeof _==="function"?_:constant(+_),link):x$1};link.y=function(_){return arguments.length?(y$1=typeof _==="function"?_:constant(+_),link):y$1};link.context=function(_){return arguments.length?(context=_==null?null:_,link):context};return link}function curveHorizontal(context,x0,y0,x1,y1){context.moveTo(x0,y0);context.bezierCurveTo(x0=(x0+x1)/2,y0,x0,y1,x1,y1)}function curveVertical(context,x0,y0,x1,y1){context.moveTo(x0,y0);context.bezierCurveTo(x0,y0=(y0+y1)/2,x1,y0,x1,y1)}function curveRadial$1(context,x0,y0,x1,y1){var p0=pointRadial(x0,y0),p1=pointRadial(x0,y0=(y0+y1)/2),p2=pointRadial(x1,y0),p3=pointRadial(x1,y1);context.moveTo(p0[0],p0[1]);context.bezierCurveTo(p1[0],p1[1],p2[0],p2[1],p3[0],p3[1])}function linkHorizontal(){return link(curveHorizontal)}function linkVertical(){return link(curveVertical)}function linkRadial(){var l=link(curveRadial$1);l.angle=l.x,delete l.x;l.radius=l.y,delete l.y;return l}var circle={draw:function(context,size){var r=Math.sqrt(size/pi);context.moveTo(r,0);context.arc(0,0,r,0,tau)}};var cross={draw:function(context,size){var r=Math.sqrt(size/5)/2;context.moveTo(-3*r,-r);context.lineTo(-r,-r);context.lineTo(-r,-3*r);context.lineTo(r,-3*r);context.lineTo(r,-r);context.lineTo(3*r,-r);context.lineTo(3*r,r);context.lineTo(r,r);context.lineTo(r,3*r);context.lineTo(-r,3*r);context.lineTo(-r,r);context.lineTo(-3*r,r);context.closePath()}};var tan30=Math.sqrt(1/3),tan30_2=tan30*2;var diamond={draw:function(context,size){var y=Math.sqrt(size/tan30_2),x=y*tan30;context.moveTo(0,-y);context.lineTo(x,0);context.lineTo(0,y);context.lineTo(-x,0);context.closePath()}};var ka=.8908130915292852,kr=Math.sin(pi/10)/Math.sin(7*pi/10),kx=Math.sin(tau/10)*kr,ky=-Math.cos(tau/10)*kr;var star={draw:function(context,size){var r=Math.sqrt(size*ka),x=kx*r,y=ky*r;context.moveTo(0,-r);context.lineTo(x,y);for(var i=1;i<5;++i){var a=tau*i/5,c=Math.cos(a),s=Math.sin(a);context.lineTo(s*r,-c*r);context.lineTo(c*x-s*y,s*x+c*y)}context.closePath()}};var square={draw:function(context,size){var w=Math.sqrt(size),x=-w/2;context.rect(x,x,w,w)}};var sqrt3=Math.sqrt(3);var triangle={draw:function(context,size){var y=-Math.sqrt(size/(sqrt3*3));context.moveTo(0,y*2);context.lineTo(-sqrt3*y,-y);context.lineTo(sqrt3*y,-y);context.closePath()}};var c=-.5,s=Math.sqrt(3)/2,k=1/Math.sqrt(12),a=(k/2+1)*3;var wye={draw:function(context,size){var r=Math.sqrt(size/a),x0=r/2,y0=r*k,x1=x0,y1=r*k+r,x2=-x1,y2=y1;context.moveTo(x0,y0);context.lineTo(x1,y1);context.lineTo(x2,y2);context.lineTo(c*x0-s*y0,s*x0+c*y0);context.lineTo(c*x1-s*y1,s*x1+c*y1);context.lineTo(c*x2-s*y2,s*x2+c*y2);context.lineTo(c*x0+s*y0,c*y0-s*x0);context.lineTo(c*x1+s*y1,c*y1-s*x1);context.lineTo(c*x2+s*y2,c*y2-s*x2);context.closePath()}};var symbols=[circle,cross,diamond,square,star,triangle,wye];function symbol(){var type=constant(circle),size=constant(64),context=null;function symbol(){var buffer;if(!context)context=buffer=d3Path.path();type.apply(this,arguments).draw(context,+size.apply(this,arguments));if(buffer)return context=null,buffer+""||null}symbol.type=function(_){return arguments.length?(type=typeof _==="function"?_:constant(_),symbol):type};symbol.size=function(_){return arguments.length?(size=typeof _==="function"?_:constant(+_),symbol):size};symbol.context=function(_){return arguments.length?(context=_==null?null:_,symbol):context};return symbol}function noop(){}function point(that,x,y){that._context.bezierCurveTo((2*that._x0+that._x1)/3,(2*that._y0+that._y1)/3,(that._x0+2*that._x1)/3,(that._y0+2*that._y1)/3,(that._x0+4*that._x1+x)/6,(that._y0+4*that._y1+y)/6)}function Basis(context){this._context=context}Basis.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){switch(this._point){case 3:point(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basis(context){return new Basis(context)}function BasisClosed(context){this._context=context}BasisClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x2,this._y2);this._context.closePath();break}case 2:{this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3);this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3);this._context.closePath();break}case 3:{this.point(this._x2,this._y2);this.point(this._x3,this._y3);this.point(this._x4,this._y4);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x2=x,this._y2=y;break;case 1:this._point=2;this._x3=x,this._y3=y;break;case 2:this._point=3;this._x4=x,this._y4=y;this._context.moveTo((this._x0+4*this._x1+x)/6,(this._y0+4*this._y1+y)/6);break;default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basisClosed(context){return new BasisClosed(context)}function BasisOpen(context){this._context=context}BasisOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var x0=(this._x0+4*this._x1+x)/6,y0=(this._y0+4*this._y1+y)/6;this._line?this._context.lineTo(x0,y0):this._context.moveTo(x0,y0);break;case 3:this._point=4;default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basisOpen(context){return new BasisOpen(context)}function Bundle(context,beta){this._basis=new Basis(context);this._beta=beta}Bundle.prototype={lineStart:function(){this._x=[];this._y=[];this._basis.lineStart()},lineEnd:function(){var x=this._x,y=this._y,j=x.length-1;if(j>0){var x0=x[0],y0=y[0],dx=x[j]-x0,dy=y[j]-y0,i=-1,t;while(++i<=j){t=i/j;this._basis.point(this._beta*x[i]+(1-this._beta)*(x0+t*dx),this._beta*y[i]+(1-this._beta)*(y0+t*dy))}}this._x=this._y=null;this._basis.lineEnd()},point:function(x,y){this._x.push(+x);this._y.push(+y)}};var bundle=function custom(beta){function bundle(context){return beta===1?new Basis(context):new Bundle(context,beta)}bundle.beta=function(beta){return custom(+beta)};return bundle}(.85);function point$1(that,x,y){that._context.bezierCurveTo(that._x1+that._k*(that._x2-that._x0),that._y1+that._k*(that._y2-that._y0),that._x2+that._k*(that._x1-x),that._y2+that._k*(that._y1-y),that._x2,that._y2)}function Cardinal(context,tension){this._context=context;this._k=(1-tension)/6}Cardinal.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:point$1(this,this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;this._x1=x,this._y1=y;break;case 2:this._point=3;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinal=function custom(tension){function cardinal(context){return new Cardinal(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalClosed(context,tension){this._context=context;this._k=(1-tension)/6}CardinalClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalClosed=function custom(tension){function cardinal(context){return new CardinalClosed(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalOpen(context,tension){this._context=context;this._k=(1-tension)/6}CardinalOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalOpen=function custom(tension){function cardinal(context){return new CardinalOpen(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function point$2(that,x,y){var x1=that._x1,y1=that._y1,x2=that._x2,y2=that._y2;if(that._l01_a>epsilon){var a=2*that._l01_2a+3*that._l01_a*that._l12_a+that._l12_2a,n=3*that._l01_a*(that._l01_a+that._l12_a);x1=(x1*a-that._x0*that._l12_2a+that._x2*that._l01_2a)/n;y1=(y1*a-that._y0*that._l12_2a+that._y2*that._l01_2a)/n}if(that._l23_a>epsilon){var b=2*that._l23_2a+3*that._l23_a*that._l12_a+that._l12_2a,m=3*that._l23_a*(that._l23_a+that._l12_a);x2=(x2*b+that._x1*that._l23_2a-x*that._l12_2a)/m;y2=(y2*b+that._y1*that._l23_2a-y*that._l12_2a)/m}that._context.bezierCurveTo(x1,y1,x2,y2,that._x2,that._y2)}function CatmullRom(context,alpha){this._context=context;this._alpha=alpha}CatmullRom.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRom=function custom(alpha){function catmullRom(context){return alpha?new CatmullRom(context,alpha):new Cardinal(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomClosed(context,alpha){this._context=context;this._alpha=alpha}CatmullRomClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomClosed=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomClosed(context,alpha):new CardinalClosed(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomOpen(context,alpha){this._context=context;this._alpha=alpha}CatmullRomOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomOpen=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomOpen(context,alpha):new CardinalOpen(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function LinearClosed(context){this._context=context}LinearClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._point=0},lineEnd:function(){if(this._point)this._context.closePath()},point:function(x,y){x=+x,y=+y;if(this._point)this._context.lineTo(x,y);else this._point=1,this._context.moveTo(x,y)}};function linearClosed(context){return new LinearClosed(context)}function sign(x){return x<0?-1:1}function slope3(that,x2,y2){var h0=that._x1-that._x0,h1=x2-that._x1,s0=(that._y1-that._y0)/(h0||h1<0&&-0),s1=(y2-that._y1)/(h1||h0<0&&-0),p=(s0*h1+s1*h0)/(h0+h1);return(sign(s0)+sign(s1))*Math.min(Math.abs(s0),Math.abs(s1),.5*Math.abs(p))||0}function slope2(that,t){var h=that._x1-that._x0;return h?(3*(that._y1-that._y0)/h-t)/2:t}function point$3(that,t0,t1){var x0=that._x0,y0=that._y0,x1=that._x1,y1=that._y1,dx=(x1-x0)/3;that._context.bezierCurveTo(x0+dx,y0+dx*t0,x1-dx,y1-dx*t1,x1,y1)}function MonotoneX(context){this._context=context}MonotoneX.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:point$3(this,this._t0,slope2(this,this._t0));break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){var t1=NaN;x=+x,y=+y;if(x===this._x1&&y===this._y1)return;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;point$3(this,slope2(this,t1=slope3(this,x,y)),t1);break;default:point$3(this,this._t0,t1=slope3(this,x,y));break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y;this._t0=t1}};function MonotoneY(context){this._context=new ReflectContext(context)}(MonotoneY.prototype=Object.create(MonotoneX.prototype)).point=function(x,y){MonotoneX.prototype.point.call(this,y,x)};function ReflectContext(context){this._context=context}ReflectContext.prototype={moveTo:function(x,y){this._context.moveTo(y,x)},closePath:function(){this._context.closePath()},lineTo:function(x,y){this._context.lineTo(y,x)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._context.bezierCurveTo(y1,x1,y2,x2,y,x)}};function monotoneX(context){return new MonotoneX(context)}function monotoneY(context){return new MonotoneY(context)}function Natural(context){this._context=context}Natural.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=[];this._y=[]},lineEnd:function(){var x=this._x,y=this._y,n=x.length;if(n){this._line?this._context.lineTo(x[0],y[0]):this._context.moveTo(x[0],y[0]);if(n===2){this._context.lineTo(x[1],y[1])}else{var px=controlPoints(x),py=controlPoints(y);for(var i0=0,i1=1;i1<n;++i0,++i1){this._context.bezierCurveTo(px[0][i0],py[0][i0],px[1][i0],py[1][i0],x[i1],y[i1])}}}if(this._line||this._line!==0&&n===1)this._context.closePath();this._line=1-this._line;this._x=this._y=null},point:function(x,y){this._x.push(+x);this._y.push(+y)}};function controlPoints(x){var i,n=x.length-1,m,a=new Array(n),b=new Array(n),r=new Array(n);a[0]=0,b[0]=2,r[0]=x[0]+2*x[1];for(i=1;i<n-1;++i)a[i]=1,b[i]=4,r[i]=4*x[i]+2*x[i+1];a[n-1]=2,b[n-1]=7,r[n-1]=8*x[n-1]+x[n];for(i=1;i<n;++i)m=a[i]/b[i-1],b[i]-=m,r[i]-=m*r[i-1];a[n-1]=r[n-1]/b[n-1];for(i=n-2;i>=0;--i)a[i]=(r[i]-a[i+1])/b[i];b[n-1]=(x[n]+a[n-1])/2;for(i=0;i<n-1;++i)b[i]=2*x[i+1]-a[i+1];return[a,b]}function natural(context){return new Natural(context)}function Step(context,t){this._context=context;this._t=t}Step.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=this._y=NaN;this._point=0},lineEnd:function(){if(0<this._t&&this._t<1&&this._point===2)this._context.lineTo(this._x,this._y);if(this._line||this._line!==0&&this._point===1)this._context.closePath();if(this._line>=0)this._t=1-this._t,this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:{if(this._t<=0){this._context.lineTo(this._x,y);this._context.lineTo(x,y)}else{var x1=this._x*(1-this._t)+x*this._t;this._context.lineTo(x1,this._y);this._context.lineTo(x1,y)}break}}this._x=x,this._y=y}};function step(context){return new Step(context,.5)}function stepBefore(context){return new Step(context,0)}function stepAfter(context){return new Step(context,1)}function none(series,order){if(!((n=series.length)>1))return;for(var i=1,j,s0,s1=series[order[0]],n,m=s1.length;i<n;++i){s0=s1,s1=series[order[i]];for(j=0;j<m;++j){s1[j][1]+=s1[j][0]=isNaN(s0[j][1])?s0[j][0]:s0[j][1]}}}function none$1(series){var n=series.length,o=new Array(n);while(--n>=0)o[n]=n;return o}function stackValue(d,key){return d[key]}function stack(){var keys=constant([]),order=none$1,offset=none,value=stackValue;function stack(data){var kz=keys.apply(this,arguments),i,m=data.length,n=kz.length,sz=new Array(n),oz;for(i=0;i<n;++i){for(var ki=kz[i],si=sz[i]=new Array(m),j=0,sij;j<m;++j){si[j]=sij=[0,+value(data[j],ki,j,data)];sij.data=data[j]}si.key=ki}for(i=0,oz=order(sz);i<n;++i){sz[oz[i]].index=i}offset(sz,oz);return sz}stack.keys=function(_){return arguments.length?(keys=typeof _==="function"?_:constant(slice.call(_)),stack):keys};stack.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(+_),stack):value};stack.order=function(_){return arguments.length?(order=_==null?none$1:typeof _==="function"?_:constant(slice.call(_)),stack):order};stack.offset=function(_){return arguments.length?(offset=_==null?none:_,stack):offset};return stack}function expand(series,order){if(!((n=series.length)>0))return;for(var i,n,j=0,m=series[0].length,y;j<m;++j){for(y=i=0;i<n;++i)y+=series[i][j][1]||0;if(y)for(i=0;i<n;++i)series[i][j][1]/=y}none(series,order)}function diverging(series,order){if(!((n=series.length)>0))return;for(var i,j=0,d,dy,yp,yn,n,m=series[order[0]].length;j<m;++j){for(yp=yn=0,i=0;i<n;++i){if((dy=(d=series[order[i]][j])[1]-d[0])>0){d[0]=yp,d[1]=yp+=dy}else if(dy<0){d[1]=yn,d[0]=yn+=dy}else{d[0]=0,d[1]=dy}}}}function silhouette(series,order){if(!((n=series.length)>0))return;for(var j=0,s0=series[order[0]],n,m=s0.length;j<m;++j){for(var i=0,y=0;i<n;++i)y+=series[i][j][1]||0;s0[j][1]+=s0[j][0]=-y/2}none(series,order)}function wiggle(series,order){if(!((n=series.length)>0)||!((m=(s0=series[order[0]]).length)>0))return;for(var y=0,j=1,s0,m,n;j<m;++j){for(var i=0,s1=0,s2=0;i<n;++i){var si=series[order[i]],sij0=si[j][1]||0,sij1=si[j-1][1]||0,s3=(sij0-sij1)/2;for(var k=0;k<i;++k){var sk=series[order[k]],skj0=sk[j][1]||0,skj1=sk[j-1][1]||0;s3+=skj0-skj1}s1+=sij0,s2+=s3*sij0}s0[j-1][1]+=s0[j-1][0]=y;if(s1)y-=s2/s1}s0[j-1][1]+=s0[j-1][0]=y;none(series,order)}function appearance(series){var peaks=series.map(peak);return none$1(series).sort((function(a,b){return peaks[a]-peaks[b]}))}function peak(series){var i=-1,j=0,n=series.length,vi,vj=-Infinity;while(++i<n)if((vi=+series[i][1])>vj)vj=vi,j=i;return j}function ascending(series){var sums=series.map(sum);return none$1(series).sort((function(a,b){return sums[a]-sums[b]}))}function sum(series){var s=0,i=-1,n=series.length,v;while(++i<n)if(v=+series[i][1])s+=v;return s}function descending$1(series){return ascending(series).reverse()}function insideOut(series){var n=series.length,i,j,sums=series.map(sum),order=appearance(series),top=0,bottom=0,tops=[],bottoms=[];for(i=0;i<n;++i){j=order[i];if(top<bottom){top+=sums[j];tops.push(j)}else{bottom+=sums[j];bottoms.push(j)}}return bottoms.reverse().concat(tops)}function reverse(series){return none$1(series).reverse()}exports.arc=arc;exports.area=area;exports.areaRadial=areaRadial;exports.curveBasis=basis;exports.curveBasisClosed=basisClosed;exports.curveBasisOpen=basisOpen;exports.curveBundle=bundle;exports.curveCardinal=cardinal;exports.curveCardinalClosed=cardinalClosed;exports.curveCardinalOpen=cardinalOpen;exports.curveCatmullRom=catmullRom;exports.curveCatmullRomClosed=catmullRomClosed;exports.curveCatmullRomOpen=catmullRomOpen;exports.curveLinear=curveLinear;exports.curveLinearClosed=linearClosed;exports.curveMonotoneX=monotoneX;exports.curveMonotoneY=monotoneY;exports.curveNatural=natural;exports.curveStep=step;exports.curveStepAfter=stepAfter;exports.curveStepBefore=stepBefore;exports.line=line;exports.lineRadial=lineRadial$1;exports.linkHorizontal=linkHorizontal;exports.linkRadial=linkRadial;exports.linkVertical=linkVertical;exports.pie=pie;exports.pointRadial=pointRadial;exports.radialArea=areaRadial;exports.radialLine=lineRadial$1;exports.stack=stack;exports.stackOffsetDiverging=diverging;exports.stackOffsetExpand=expand;exports.stackOffsetNone=none;exports.stackOffsetSilhouette=silhouette;exports.stackOffsetWiggle=wiggle;exports.stackOrderAppearance=appearance;exports.stackOrderAscending=ascending;exports.stackOrderDescending=descending$1;exports.stackOrderInsideOut=insideOut;exports.stackOrderNone=none$1;exports.stackOrderReverse=reverse;exports.symbol=symbol;exports.symbolCircle=circle;exports.symbolCross=cross;exports.symbolDiamond=diamond;exports.symbolSquare=square;exports.symbolStar=star;exports.symbolTriangle=triangle;exports.symbolWye=wye;exports.symbols=symbols;Object.defineProperty(exports,"__esModule",{value:true})}))},,,,,function(module,exports){module.exports=function(module){if(!module.webpackPolyfill){module.deprecate=function(){};module.paths=[];if(!module.children)module.children=[];Object.defineProperty(module,"loaded",{enumerable:true,get:function(){return module.l}});Object.defineProperty(module,"id",{enumerable:true,get:function(){return module.i}});module.webpackPolyfill=1}return module}},function(module,exports,__webpack_require__){"use strict";module.exports=csharp;csharp.displayName="csharp";csharp.aliases=["dotnet","cs"];function csharp(Prism){(function(Prism){function replace(pattern,replacements){return pattern.replace(/<<(\d+)>>/g,(function(m,index){return"(?:"+replacements[+index]+")"}))}function re(pattern,replacements,flags){return RegExp(replace(pattern,replacements),flags||"")}function nested(pattern,depthLog2){for(var i=0;i<depthLog2;i++){pattern=pattern.replace(/<<self>>/g,(function(){return"(?:"+pattern+")"}))}return pattern.replace(/<<self>>/g,"[^\\s\\S]")}var keywordKinds={type:"bool byte char decimal double dynamic float int long object sbyte short string uint ulong ushort var void",typeDeclaration:"class enum interface struct",contextual:"add alias and ascending async await by descending from get global group into join let nameof not notnull on or orderby partial remove select set unmanaged value when where where",other:"abstract as base break case catch checked const continue default delegate do else event explicit extern finally fixed for foreach goto if implicit in internal is lock namespace new null operator out override params private protected public readonly ref return sealed sizeof stackalloc static switch this throw try typeof unchecked unsafe using virtual volatile while yield"};function keywordsToPattern(words){return"\\b(?:"+words.trim().replace(/ /g,"|")+")\\b"}var typeDeclarationKeywords=keywordsToPattern(keywordKinds.typeDeclaration);var keywords=RegExp(keywordsToPattern(keywordKinds.type+" "+keywordKinds.typeDeclaration+" "+keywordKinds.contextual+" "+keywordKinds.other));var nonTypeKeywords=keywordsToPattern(keywordKinds.typeDeclaration+" "+keywordKinds.contextual+" "+keywordKinds.other);var nonContextualKeywords=keywordsToPattern(keywordKinds.type+" "+keywordKinds.typeDeclaration+" "+keywordKinds.other);var generic=nested(/<(?:[^<>;=+\-*/%&|^]|<<self>>)*>/.source,2);var nestedRound=nested(/\((?:[^()]|<<self>>)*\)/.source,2);var name=/@?\b[A-Za-z_]\w*\b/.source;var genericName=replace(/<<0>>(?:\s*<<1>>)?/.source,[name,generic]);var identifier=replace(/(?!<<0>>)<<1>>(?:\s*\.\s*<<1>>)*/.source,[nonTypeKeywords,genericName]);var array=/\[\s*(?:,\s*)*\]/.source;var typeExpressionWithoutTuple=replace(/<<0>>(?:\s*(?:\?\s*)?<<1>>)*(?:\s*\?)?/.source,[identifier,array]);var tupleElement=replace(/[^,()<>[\];=+\-*/%&|^]|<<0>>|<<1>>|<<2>>/.source,[generic,nestedRound,array]);var tuple=replace(/\(<<0>>+(?:,<<0>>+)+\)/.source,[tupleElement]);var typeExpression=replace(/(?:<<0>>|<<1>>)(?:\s*(?:\?\s*)?<<2>>)*(?:\s*\?)?/.source,[tuple,identifier,array]);var typeInside={keyword:keywords,punctuation:/[<>()?,.:[\]]/};var character=/'(?:[^\r\n'\\]|\\.|\\[Uux][\da-fA-F]{1,8})'/.source;var regularString=/"(?:\\.|[^\\"\r\n])*"/.source;var verbatimString=/@"(?:""|\\[\s\S]|[^\\"])*"(?!")/.source;Prism.languages.csharp=Prism.languages.extend("clike",{string:[{pattern:re(/(^|[^$\\])<<0>>/.source,[verbatimString]),lookbehind:true,greedy:true},{pattern:re(/(^|[^@$\\])<<0>>/.source,[regularString]),lookbehind:true,greedy:true},{pattern:RegExp(character),greedy:true,alias:"character"}],"class-name":[{pattern:re(/(\busing\s+static\s+)<<0>>(?=\s*;)/.source,[identifier]),lookbehind:true,inside:typeInside},{pattern:re(/(\busing\s+<<0>>\s*=\s*)<<1>>(?=\s*;)/.source,[name,typeExpression]),lookbehind:true,inside:typeInside},{pattern:re(/(\busing\s+)<<0>>(?=\s*=)/.source,[name]),lookbehind:true},{pattern:re(/(\b<<0>>\s+)<<1>>/.source,[typeDeclarationKeywords,genericName]),lookbehind:true,inside:typeInside},{pattern:re(/(\bcatch\s*\(\s*)<<0>>/.source,[identifier]),lookbehind:true,inside:typeInside},{pattern:re(/(\bwhere\s+)<<0>>/.source,[name]),lookbehind:true},{pattern:re(/(\b(?:is(?:\s+not)?|as)\s+)<<0>>/.source,[typeExpressionWithoutTuple]),lookbehind:true,inside:typeInside},{pattern:re(/\b<<0>>(?=\s+(?!<<1>>)<<2>>(?:\s*[=,;:{)\]]|\s+(?:in|when)\b))/.source,[typeExpression,nonContextualKeywords,name]),inside:typeInside}],keyword:keywords,number:/(?:\b0(?:x[\da-f_]*[\da-f]|b[01_]*[01])|(?:\B\.\d+(?:_+\d+)*|\b\d+(?:_+\d+)*(?:\.\d+(?:_+\d+)*)?)(?:e[-+]?\d+(?:_+\d+)*)?)(?:ul|lu|[dflmu])?\b/i,operator:/>>=?|<<=?|[-=]>|([-+&|])\1|~|\?\?=?|[-+*/%&|^!=<>]=?/,punctuation:/\?\.?|::|[{}[\];(),.:]/});Prism.languages.insertBefore("csharp","number",{range:{pattern:/\.\./,alias:"operator"}});Prism.languages.insertBefore("csharp","punctuation",{"named-parameter":{pattern:re(/([(,]\s*)<<0>>(?=\s*:)/.source,[name]),lookbehind:true,alias:"punctuation"}});Prism.languages.insertBefore("csharp","class-name",{namespace:{pattern:re(/(\b(?:namespace|using)\s+)<<0>>(?:\s*\.\s*<<0>>)*(?=\s*[;{])/.source,[name]),lookbehind:true,inside:{punctuation:/\./}},"type-expression":{pattern:re(/(\b(?:default|typeof|sizeof)\s*\(\s*)(?:[^()\s]|\s(?!\s*\))|<<0>>)*(?=\s*\))/.source,[nestedRound]),lookbehind:true,alias:"class-name",inside:typeInside},"return-type":{pattern:re(/<<0>>(?=\s+(?:<<1>>\s*(?:=>|[({]|\.\s*this\s*\[)|this\s*\[))/.source,[typeExpression,identifier]),inside:typeInside,alias:"class-name"},"constructor-invocation":{pattern:re(/(\bnew\s+)<<0>>(?=\s*[[({])/.source,[typeExpression]),lookbehind:true,inside:typeInside,alias:"class-name"},"generic-method":{pattern:re(/<<0>>\s*<<1>>(?=\s*\()/.source,[name,generic]),inside:{function:re(/^<<0>>/.source,[name]),generic:{pattern:RegExp(generic),alias:"class-name",inside:typeInside}}},"type-list":{pattern:re(/\b((?:<<0>>\s+<<1>>|where\s+<<2>>)\s*:\s*)(?:<<3>>|<<4>>)(?:\s*,\s*(?:<<3>>|<<4>>))*(?=\s*(?:where|[{;]|=>|$))/.source,[typeDeclarationKeywords,genericName,name,typeExpression,keywords.source]),lookbehind:true,inside:{keyword:keywords,"class-name":{pattern:RegExp(typeExpression),greedy:true,inside:typeInside},punctuation:/,/}},preprocessor:{pattern:/(^\s*)#.*/m,lookbehind:true,alias:"property",inside:{directive:{pattern:/(\s*#)\b(?:define|elif|else|endif|endregion|error|if|line|pragma|region|undef|warning)\b/,lookbehind:true,alias:"keyword"}}}});var regularStringOrCharacter=regularString+"|"+character;var regularStringCharacterOrComment=replace(/\/(?![*/])|\/\/[^\r\n]*[\r\n]|\/\*(?:[^*]|\*(?!\/))*\*\/|<<0>>/.source,[regularStringOrCharacter]);var roundExpression=nested(replace(/[^"'/()]|<<0>>|\(<<self>>*\)/.source,[regularStringCharacterOrComment]),2);var attrTarget=/\b(?:assembly|event|field|method|module|param|property|return|type)\b/.source;var attr=replace(/<<0>>(?:\s*\(<<1>>*\))?/.source,[identifier,roundExpression]);Prism.languages.insertBefore("csharp","class-name",{attribute:{pattern:re(/((?:^|[^\s\w>)?])\s*\[\s*)(?:<<0>>\s*:\s*)?<<1>>(?:\s*,\s*<<1>>)*(?=\s*\])/.source,[attrTarget,attr]),lookbehind:true,greedy:true,inside:{target:{pattern:re(/^<<0>>(?=\s*:)/.source,[attrTarget]),alias:"keyword"},"attribute-arguments":{pattern:re(/\(<<0>>*\)/.source,[roundExpression]),inside:Prism.languages.csharp},"class-name":{pattern:RegExp(identifier),inside:{punctuation:/\./}},punctuation:/[:,]/}}});var formatString=/:[^}\r\n]+/.source;var mInterpolationRound=nested(replace(/[^"'/()]|<<0>>|\(<<self>>*\)/.source,[regularStringCharacterOrComment]),2);var mInterpolation=replace(/\{(?!\{)(?:(?![}:])<<0>>)*<<1>>?\}/.source,[mInterpolationRound,formatString]);var sInterpolationRound=nested(replace(/[^"'/()]|\/(?!\*)|\/\*(?:[^*]|\*(?!\/))*\*\/|<<0>>|\(<<self>>*\)/.source,[regularStringOrCharacter]),2);var sInterpolation=replace(/\{(?!\{)(?:(?![}:])<<0>>)*<<1>>?\}/.source,[sInterpolationRound,formatString]);function createInterpolationInside(interpolation,interpolationRound){return{interpolation:{pattern:re(/((?:^|[^{])(?:\{\{)*)<<0>>/.source,[interpolation]),lookbehind:true,inside:{"format-string":{pattern:re(/(^\{(?:(?![}:])<<0>>)*)<<1>>(?=\}$)/.source,[interpolationRound,formatString]),lookbehind:true,inside:{punctuation:/^:/}},punctuation:/^\{|\}$/,expression:{pattern:/[\s\S]+/,alias:"language-csharp",inside:Prism.languages.csharp}}},string:/[\s\S]+/}}Prism.languages.insertBefore("csharp","string",{"interpolation-string":[{pattern:re(/(^|[^\\])(?:\$@|@\$)"(?:""|\\[\s\S]|\{\{|<<0>>|[^\\{"])*"/.source,[mInterpolation]),lookbehind:true,greedy:true,inside:createInterpolationInside(mInterpolation,mInterpolationRound)},{pattern:re(/(^|[^@\\])\$"(?:\\.|\{\{|<<0>>|[^\\"{])*"/.source,[sInterpolation]),lookbehind:true,greedy:true,inside:createInterpolationInside(sInterpolation,sInterpolationRound)}]})})(Prism);Prism.languages.dotnet=Prism.languages.cs=Prism.languages.csharp}},function(module,exports,__webpack_require__){"use strict";module.exports=java;java.displayName="java";java.aliases=[];function java(Prism){(function(Prism){var keywords=/\b(?:abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|exports|extends|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|module|native|new|null|open|opens|package|private|protected|provides|public|record|requires|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|to|transient|transitive|try|uses|var|void|volatile|while|with|yield)\b/;var className=/\b[A-Z](?:\w*[a-z]\w*)?\b/;Prism.languages.java=Prism.languages.extend("clike",{"class-name":[className,/\b[A-Z]\w*(?=\s+\w+\s*[;,=())])/],keyword:keywords,function:[Prism.languages.clike.function,{pattern:/(\:\:)[a-z_]\w*/,lookbehind:true}],number:/\b0b[01][01_]*L?\b|\b0x[\da-f_]*\.?[\da-f_p+-]+\b|(?:\b\d[\d_]*\.?[\d_]*|\B\.\d[\d_]*)(?:e[+-]?\d[\d_]*)?[dfl]?/i,operator:{pattern:/(^|[^.])(?:<<=?|>>>?=?|->|--|\+\+|&&|\|\||::|[?:~]|[-+*/%&|^!=<>]=?)/m,lookbehind:true}});Prism.languages.insertBefore("java","string",{"triple-quoted-string":{pattern:/"""[ \t]*[\r\n](?:(?:"|"")?(?:\\.|[^"\\]))*"""/,greedy:true,alias:"string"}});Prism.languages.insertBefore("java","class-name",{annotation:{alias:"punctuation",pattern:/(^|[^.])@\w+/,lookbehind:true},namespace:{pattern:RegExp(/(\b(?:exports|import(?:\s+static)?|module|open|opens|package|provides|requires|to|transitive|uses|with)\s+)(?!<keyword>)[a-z]\w*(?:\.[a-z]\w*)*\.?/.source.replace(/<keyword>/g,(function(){return keywords.source}))),lookbehind:true,inside:{punctuation:/\./}},generics:{pattern:/<(?:[\w\s,.&?]|<(?:[\w\s,.&?]|<(?:[\w\s,.&?]|<[\w\s,.&?]*>)*>)*>)*>/,inside:{"class-name":className,keyword:keywords,punctuation:/[<>(),.:]/,operator:/[?&|]/}}})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=typescript;typescript.displayName="typescript";typescript.aliases=["ts"];function typescript(Prism){(function(Prism){Prism.languages.typescript=Prism.languages.extend("javascript",{"class-name":{pattern:/(\b(?:class|extends|implements|instanceof|interface|new|type)\s+)(?!keyof\b)[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?:\s*<(?:[^<>]|<(?:[^<>]|<[^<>]*>)*>)*>)?/,lookbehind:true,greedy:true,inside:null},keyword:/\b(?:abstract|as|asserts|async|await|break|case|catch|class|const|constructor|continue|debugger|declare|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|is|keyof|let|module|namespace|new|null|of|package|private|protected|public|readonly|return|require|set|static|super|switch|this|throw|try|type|typeof|undefined|var|void|while|with|yield)\b/,builtin:/\b(?:string|Function|any|number|boolean|Array|symbol|console|Promise|unknown|never)\b/});delete Prism.languages.typescript["parameter"];var typeInside=Prism.languages.extend("typescript",{});delete typeInside["class-name"];Prism.languages.typescript["class-name"].inside=typeInside;Prism.languages.insertBefore("typescript","function",{"generic-function":{pattern:/#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*\s*<(?:[^<>]|<(?:[^<>]|<[^<>]*>)*>)*>(?=\s*\()/,greedy:true,inside:{function:/^#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*/,generic:{pattern:/<[\s\S]+/,alias:"class-name",inside:typeInside}}}});Prism.languages.ts=Prism.languages.typescript})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=json;json.displayName="json";json.aliases=["webmanifest"];function json(Prism){Prism.languages.json={property:{pattern:/"(?:\\.|[^\\"\r\n])*"(?=\s*:)/,greedy:true},string:{pattern:/"(?:\\.|[^\\"\r\n])*"(?!\s*:)/,greedy:true},comment:{pattern:/\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,greedy:true},number:/-?\b\d+(?:\.\d+)?(?:e[+-]?\d+)?\b/i,punctuation:/[{}[\],]/,operator:/:/,boolean:/\b(?:true|false)\b/,null:{pattern:/\bnull\b/,alias:"keyword"}};Prism.languages.webmanifest=Prism.languages.json}},function(module,exports,__webpack_require__){"use strict";module.exports=scheme;scheme.displayName="scheme";scheme.aliases=[];function scheme(Prism){Prism.languages.scheme={comment:/;.*|#;\s*\((?:[^()]|\([^()]*\))*\)|#\|(?:[^#|]|#(?!\|)|\|(?!#)|#\|(?:[^#|]|#(?!\|)|\|(?!#))*\|#)*\|#/,string:{pattern:/"(?:[^"\\]|\\.)*"/,greedy:true},symbol:{pattern:/'[^()#'\s]+/,greedy:true},character:{pattern:/#\\(?:[ux][a-fA-F\d]+\b|[-a-zA-Z]+\b|\S)/,greedy:true,alias:"string"},"lambda-parameter":[{pattern:/(\(lambda\s+)(?:[^|()'\s]+|\|(?:[^\\|]|\\.)*\|)/,lookbehind:true},{pattern:/(\(lambda\s+\()[^()']+/,lookbehind:true}],keyword:{pattern:/(\()(?:begin|case(?:-lambda)?|cond(?:-expand)?|define(?:-library|-macro|-record-type|-syntax|-values)?|defmacro|delay(?:-force)?|do|else|export|except|guard|if|import|include(?:-ci|-library-declarations)?|lambda|let(?:rec)?(?:-syntax|-values|\*)?|let\*-values|only|parameterize|prefix|(?:quasi-?)?quote|rename|set!|syntax-(?:case|rules)|unless|unquote(?:-splicing)?|when)(?=[()\s]|$)/,lookbehind:true},builtin:{pattern:/(\()(?:abs|and|append|apply|assoc|ass[qv]|binary-port\?|boolean=?\?|bytevector(?:-append|-copy|-copy!|-length|-u8-ref|-u8-set!|\?)?|caar|cadr|call-with-(?:current-continuation|port|values)|call\/cc|car|cdar|cddr|cdr|ceiling|char(?:->integer|-ready\?|\?|<\?|<=\?|=\?|>\?|>=\?)|close-(?:input-port|output-port|port)|complex\?|cons|current-(?:error|input|output)-port|denominator|dynamic-wind|eof-object\??|eq\?|equal\?|eqv\?|error|error-object(?:-irritants|-message|\?)|eval|even\?|exact(?:-integer-sqrt|-integer\?|\?)?|expt|features|file-error\?|floor(?:-quotient|-remainder|\/)?|flush-output-port|for-each|gcd|get-output-(?:bytevector|string)|inexact\??|input-port(?:-open\?|\?)|integer(?:->char|\?)|lcm|length|list(?:->string|->vector|-copy|-ref|-set!|-tail|\?)?|make-(?:bytevector|list|parameter|string|vector)|map|max|member|memq|memv|min|modulo|negative\?|newline|not|null\?|number(?:->string|\?)|numerator|odd\?|open-(?:input|output)-(?:bytevector|string)|or|output-port(?:-open\?|\?)|pair\?|peek-char|peek-u8|port\?|positive\?|procedure\?|quotient|raise|raise-continuable|rational\?|rationalize|read-(?:bytevector|bytevector!|char|error\?|line|string|u8)|real\?|remainder|reverse|round|set-c[ad]r!|square|string(?:->list|->number|->symbol|->utf8|->vector|-append|-copy|-copy!|-fill!|-for-each|-length|-map|-ref|-set!|\?|<\?|<=\?|=\?|>\?|>=\?)?|substring|symbol(?:->string|\?|=\?)|syntax-error|textual-port\?|truncate(?:-quotient|-remainder|\/)?|u8-ready\?|utf8->string|values|vector(?:->list|->string|-append|-copy|-copy!|-fill!|-for-each|-length|-map|-ref|-set!|\?)?|with-exception-handler|write-(?:bytevector|char|string|u8)|zero\?)(?=[()\s]|$)/,lookbehind:true},operator:{pattern:/(\()(?:[-+*%/]|[<>]=?|=>?)(?=[()\s]|$)/,lookbehind:true},number:{pattern:/(^|[\s()])(?:(?:#d(?:#[ei])?|#[ei](?:#d)?)?[+-]?(?:(?:\d*\.?\d+(?:[eE][+-]?\d+)?|\d+\/\d+)(?:[+-](?:\d*\.?\d+(?:[eE][+-]?\d+)?|\d+\/\d+)i)?|(?:\d*\.?\d+(?:[eE][+-]?\d+)?|\d+\/\d+)i)|(?:#[box](?:#[ei])?|#[ei](?:#[box])?)[+-]?(?:[\da-fA-F]+(?:\/[\da-fA-F]+)?(?:[+-][\da-fA-F]+(?:\/[\da-fA-F]+)?i)?|[\da-fA-F]+(?:\/[\da-fA-F]+)?i))(?=[()\s]|$)/,lookbehind:true},boolean:{pattern:/(^|[\s()])#(?:[ft]|false|true)(?=[()\s]|$)/,lookbehind:true},function:{pattern:/(\()(?:[^|()'\s]+|\|(?:[^\\|]|\\.)*\|)(?=[()\s]|$)/,lookbehind:true},identifier:{pattern:/(^|[\s()])\|(?:[^\\|]|\\.)*\|(?=[()\s]|$)/,lookbehind:true,greedy:true},punctuation:/[()']/}}},function(module,exports,__webpack_require__){"use strict";module.exports=t4Templating;t4Templating.displayName="t4Templating";t4Templating.aliases=[];function t4Templating(Prism){(function(Prism){function createBlock(prefix,inside,contentAlias){return{pattern:RegExp("<#"+prefix+"[\\s\\S]*?#>"),alias:"block",inside:{delimiter:{pattern:RegExp("^<#"+prefix+"|#>$"),alias:"important"},content:{pattern:/[\s\S]+/,inside:inside,alias:contentAlias}}}}function createT4(insideLang){var grammar=Prism.languages[insideLang];var className="language-"+insideLang;return{block:{pattern:/<#[\s\S]+?#>/,inside:{directive:createBlock("@",{"attr-value":{pattern:/=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">=]+)/,inside:{punctuation:/^=|^["']|["']$/}},keyword:/\w+(?=\s)/,"attr-name":/\w+/}),expression:createBlock("=",grammar,className),"class-feature":createBlock("\\+",grammar,className),standard:createBlock("",grammar,className)}}}}Prism.languages["t4-templating"]=Object.defineProperty({},"createT4",{value:createT4})})(Prism)}},function(module,exports,__webpack_require__){var ListCache=__webpack_require__(139),stackClear=__webpack_require__(1142),stackDelete=__webpack_require__(1143),stackGet=__webpack_require__(1144),stackHas=__webpack_require__(1145),stackSet=__webpack_require__(1146);function Stack(entries){var data=this.__data__=new ListCache(entries);this.size=data.size}Stack.prototype.clear=stackClear;Stack.prototype["delete"]=stackDelete;Stack.prototype.get=stackGet;Stack.prototype.has=stackHas;Stack.prototype.set=stackSet;module.exports=Stack},function(module,exports,__webpack_require__){var listCacheClear=__webpack_require__(1137),listCacheDelete=__webpack_require__(1138),listCacheGet=__webpack_require__(1139),listCacheHas=__webpack_require__(1140),listCacheSet=__webpack_require__(1141);function ListCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}ListCache.prototype.clear=listCacheClear;ListCache.prototype["delete"]=listCacheDelete;ListCache.prototype.get=listCacheGet;ListCache.prototype.has=listCacheHas;ListCache.prototype.set=listCacheSet;module.exports=ListCache},function(module,exports,__webpack_require__){var eq=__webpack_require__(101);function assocIndexOf(array,key){var length=array.length;while(length--){if(eq(array[length][0],key)){return length}}return-1}module.exports=assocIndexOf},function(module,exports,__webpack_require__){var getNative=__webpack_require__(89);var nativeCreate=getNative(Object,"create");module.exports=nativeCreate},function(module,exports,__webpack_require__){var isKeyable=__webpack_require__(1161);function getMapData(map,key){var data=map.__data__;return isKeyable(key)?data[typeof key=="string"?"string":"hash"]:data.map}module.exports=getMapData},function(module,exports,__webpack_require__){var baseAssignValue=__webpack_require__(144),eq=__webpack_require__(101);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function assignValue(object,key,value){var objValue=object[key];if(!(hasOwnProperty.call(object,key)&&eq(objValue,value))||value===undefined&&!(key in object)){baseAssignValue(object,key,value)}}module.exports=assignValue},function(module,exports,__webpack_require__){var defineProperty=__webpack_require__(492);function baseAssignValue(object,key,value){if(key=="__proto__"&&defineProperty){defineProperty(object,key,{configurable:true,enumerable:true,value:value,writable:true})}else{object[key]=value}}module.exports=baseAssignValue},function(module,exports){var MAX_SAFE_INTEGER=9007199254740991;var reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex(value,length){var type=typeof value;length=length==null?MAX_SAFE_INTEGER:length;return!!length&&(type=="number"||type!="symbol"&&reIsUint.test(value))&&(value>-1&&value%1==0&&value<length)}module.exports=isIndex},function(module,exports){function baseUnary(func){return function(value){return func(value)}}module.exports=baseUnary},function(module,exports){var objectProto=Object.prototype;function isPrototype(value){var Ctor=value&&value.constructor,proto=typeof Ctor=="function"&&Ctor.prototype||objectProto;return value===proto}module.exports=isPrototype},function(module,exports,__webpack_require__){var overArg=__webpack_require__(494);var getPrototype=overArg(Object.getPrototypeOf,Object);module.exports=getPrototype},function(module,exports,__webpack_require__){var baseForOwn=__webpack_require__(200),createBaseEach=__webpack_require__(1190);var baseEach=createBaseEach(baseForOwn);module.exports=baseEach},function(module,exports,__webpack_require__){var castPath=__webpack_require__(151),toKey=__webpack_require__(123);function baseGet(object,path){path=castPath(path,object);var index=0,length=path.length;while(object!=null&&index<length){object=object[toKey(path[index++])]}return index&&index==length?object:undefined}module.exports=baseGet},function(module,exports,__webpack_require__){var isArray=__webpack_require__(49),isKey=__webpack_require__(203),stringToPath=__webpack_require__(1204),toString=__webpack_require__(517);function castPath(value,object){if(isArray(value)){return value}return isKey(value,object)?[value]:stringToPath(toString(value))}module.exports=castPath},function(module,exports){function arrayMap(array,iteratee){var index=-1,length=array==null?0:array.length,result=Array(length);while(++index<length){result[index]=iteratee(array[index],index,array)}return result}module.exports=arrayMap},function(module,exports,__webpack_require__){var identity=__webpack_require__(92),overRest=__webpack_require__(526),setToString=__webpack_require__(527);function baseRest(func,start){return setToString(overRest(func,start,identity),func+"")}module.exports=baseRest},function(module,exports,__webpack_require__){var eq=__webpack_require__(101),isArrayLike=__webpack_require__(75),isIndex=__webpack_require__(145),isObject=__webpack_require__(66);function isIterateeCall(value,index,object){if(!isObject(object)){return false}var type=typeof index;if(type=="number"?isArrayLike(object)&&isIndex(index,object.length):type=="string"&&index in object){return eq(object[index],value)}return false}module.exports=isIterateeCall},function(module,exports,__webpack_require__){"use strict";var _=__webpack_require__(45);module.exports={longestPath:longestPath,slack:slack};function longestPath(g){var visited={};function dfs(v){var label=g.node(v);if(_.has(visited,v)){return label.rank}visited[v]=true;var rank=_.min(_.map(g.outEdges(v),(function(e){return dfs(e.w)-g.edge(e).minlen})));if(rank===Number.POSITIVE_INFINITY||rank===undefined||rank===null){rank=0}return label.rank=rank}_.forEach(g.sources(),dfs)}function slack(g,e){return g.node(e.w).rank-g.node(e.v).rank-g.edge(e).minlen}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ErrorDetailLink}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _APMLink__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(46);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function ErrorDetailLink({serviceName:serviceName,errorGroupId:errorGroupId,...rest}){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_APMLink__WEBPACK_IMPORTED_MODULE_1__["a"],_extends({path:`/services/${serviceName}/errors/${errorGroupId}`},rest))}},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function formatDecimal(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]}function exponent(x){return x=formatDecimal(Math.abs(x)),x?x[1]:NaN}function formatGroup(grouping,thousands){return function(value,width){var i=value.length,t=[],j=0,g=grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=grouping[j=(j+1)%grouping.length]}return t.reverse().join(thousands)}}function formatNumerals(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}var re=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function formatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match;return new FormatSpecifier({fill:match[1],align:match[2],sign:match[3],symbol:match[4],zero:match[5],width:match[6],comma:match[7],precision:match[8]&&match[8].slice(1),trim:match[9],type:match[10]})}formatSpecifier.prototype=FormatSpecifier.prototype;function FormatSpecifier(specifier){this.fill=specifier.fill===undefined?" ":specifier.fill+"";this.align=specifier.align===undefined?">":specifier.align+"";this.sign=specifier.sign===undefined?"-":specifier.sign+"";this.symbol=specifier.symbol===undefined?"":specifier.symbol+"";this.zero=!!specifier.zero;this.width=specifier.width===undefined?undefined:+specifier.width;this.comma=!!specifier.comma;this.precision=specifier.precision===undefined?undefined:+specifier.precision;this.trim=!!specifier.trim;this.type=specifier.type===undefined?"":specifier.type+""}FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(this.width===undefined?"":Math.max(1,this.width|0))+(this.comma?",":"")+(this.precision===undefined?"":"."+Math.max(0,this.precision|0))+(this.trim?"~":"")+this.type};function formatTrim(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}var prefixExponent;function formatPrefixAuto(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=Math.max(-8,Math.min(8,Math.floor(exponent/3)))*3)+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimal(x,Math.max(0,p+i-1))[0]}function formatRounded(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")}var formatTypes={"%":function(x,p){return(x*100).toFixed(p)},b:function(x){return Math.round(x).toString(2)},c:function(x){return x+""},d:function(x){return Math.round(x).toString(10)},e:function(x,p){return x.toExponential(p)},f:function(x,p){return x.toFixed(p)},g:function(x,p){return x.toPrecision(p)},o:function(x){return Math.round(x).toString(8)},p:function(x,p){return formatRounded(x*100,p)},r:formatRounded,s:formatPrefixAuto,X:function(x){return Math.round(x).toString(16).toUpperCase()},x:function(x){return Math.round(x).toString(16)}};function identity(x){return x}var map=Array.prototype.map,prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function formatLocale(locale){var group=locale.grouping===undefined||locale.thousands===undefined?identity:formatGroup(map.call(locale.grouping,Number),locale.thousands+""),currencyPrefix=locale.currency===undefined?"":locale.currency[0]+"",currencySuffix=locale.currency===undefined?"":locale.currency[1]+"",decimal=locale.decimal===undefined?".":locale.decimal+"",numerals=locale.numerals===undefined?identity:formatNumerals(map.call(locale.numerals,String)),percent=locale.percent===undefined?"%":locale.percent+"",minus=locale.minus===undefined?"-":locale.minus+"",nan=locale.nan===undefined?"NaN":locale.nan+"";function newFormat(specifier){specifier=formatSpecifier(specifier);var fill=specifier.fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,trim=specifier.trim,type=specifier.type;if(type==="n")comma=true,type="g";else if(!formatTypes[type])precision===undefined&&(precision=12),trim=true,type="g";if(zero||fill==="0"&&align==="=")zero=true,fill="0",align="=";var prefix=symbol==="$"?currencyPrefix:symbol==="#"&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix=symbol==="$"?currencySuffix:/[%p]/.test(type)?percent:"";var formatType=formatTypes[type],maybeSuffix=/[defgprs%]/.test(type);precision=precision===undefined?6:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision));function format(value){var valuePrefix=prefix,valueSuffix=suffix,i,n,c;if(type==="c"){valueSuffix=formatType(value)+valueSuffix;value=""}else{value=+value;var valueNegative=value<0||1/value<0;value=isNaN(value)?nan:formatType(Math.abs(value),precision);if(trim)value=formatTrim(value);if(valueNegative&&+value===0&&sign!=="+")valueNegative=false;valuePrefix=(valueNegative?sign==="("?sign:minus:sign==="-"||sign==="("?"":sign)+valuePrefix;valueSuffix=(type==="s"?prefixes[8+prefixExponent/3]:"")+valueSuffix+(valueNegative&&sign==="("?")":"");if(maybeSuffix){i=-1,n=value.length;while(++i<n){if(c=value.charCodeAt(i),48>c||c>57){valueSuffix=(c===46?decimal+value.slice(i+1):value.slice(i))+valueSuffix;value=value.slice(0,i);break}}}}if(comma&&!zero)value=group(value,Infinity);var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";if(comma&&zero)value=group(padding+value,padding.length?width-valueSuffix.length:Infinity),padding="";switch(align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix;break}return numerals(value)}format.toString=function(){return specifier+""};return format}function formatPrefix(specifier,value){var f=newFormat((specifier=formatSpecifier(specifier),specifier.type="f",specifier)),e=Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3,k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}return{format:newFormat,formatPrefix:formatPrefix}}var locale;defaultLocale({decimal:".",thousands:",",grouping:[3],currency:["$",""],minus:"-"});function defaultLocale(definition){locale=formatLocale(definition);exports.format=locale.format;exports.formatPrefix=locale.formatPrefix;return locale}function precisionFixed(step){return Math.max(0,-exponent(Math.abs(step)))}function precisionPrefix(step,value){return Math.max(0,Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3-exponent(Math.abs(step)))}function precisionRound(step,max){step=Math.abs(step),max=Math.abs(max)-step;return Math.max(0,exponent(max)-exponent(step))+1}exports.FormatSpecifier=FormatSpecifier;exports.formatDefaultLocale=defaultLocale;exports.formatLocale=formatLocale;exports.formatSpecifier=formatSpecifier;exports.precisionFixed=precisionFixed;exports.precisionPrefix=precisionPrefix;exports.precisionRound=precisionRound;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;exports["default"]=stripStyle;function stripStyle(style){var ret={};for(var key in style){if(!Object.prototype.hasOwnProperty.call(style,key)){continue}ret[key]=typeof style[key]==="number"?style[key]:style[key].val}return ret}module.exports=exports["default"]},,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DatePicker}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var react_router_dom__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(11);var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);var _src_plugins_data_common__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(24);var _src_plugins_data_common__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_src_plugins_data_common__WEBPACK_IMPORTED_MODULE_3__);var _context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(39);var _context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(36);var _services_rest_callApi__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(159);var _Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(42);function DatePicker(){const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useHistory"])();const location=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useLocation"])();const{core:core,plugins:plugins}=Object(_context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_4__["a"])();const timePickerQuickRanges=core.uiSettings.get(_src_plugins_data_common__WEBPACK_IMPORTED_MODULE_3__["UI_SETTINGS"].TIMEPICKER_QUICK_RANGES);const timePickerTimeDefaults=core.uiSettings.get(_src_plugins_data_common__WEBPACK_IMPORTED_MODULE_3__["UI_SETTINGS"].TIMEPICKER_TIME_DEFAULTS);const commonlyUsedRanges=timePickerQuickRanges.map(({from:from,to:to,display:display})=>({start:from,end:to,label:display}));const{urlParams:urlParams,refreshTimeRange:refreshTimeRange}=Object(_context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_5__["a"])();function updateUrl(nextQuery){history.push({...location,search:Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["b"])({...Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["e"])(location.search),...nextQuery})})}function onRefreshChange({isPaused:isPaused,refreshInterval:refreshInterval}){updateUrl({refreshPaused:isPaused,refreshInterval:refreshInterval})}function onTimeChange({start:start,end:end}){updateUrl({rangeFrom:start,rangeTo:end})}Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{var _ref,_urlParams$rangeFrom,_ref2,_urlParams$rangeTo;if(urlParams.rangeFrom&&urlParams.rangeTo){plugins.data.query.timefilter.timefilter.setTime({from:urlParams.rangeFrom,to:urlParams.rangeTo});return}const timePickerSharedState=plugins.data.query.timefilter.timefilter.getTime();history.replace({...location,search:Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["b"])({...Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["e"])(location.search),rangeFrom:(_ref=(_urlParams$rangeFrom=urlParams.rangeFrom)!==null&&_urlParams$rangeFrom!==void 0?_urlParams$rangeFrom:timePickerSharedState.from)!==null&&_ref!==void 0?_ref:timePickerTimeDefaults.from,rangeTo:(_ref2=(_urlParams$rangeTo=urlParams.rangeTo)!==null&&_urlParams$rangeTo!==void 0?_urlParams$rangeTo:timePickerSharedState.to)!==null&&_ref2!==void 0?_ref2:timePickerTimeDefaults.to})})},[urlParams.rangeFrom,urlParams.rangeTo,plugins,history,location,timePickerTimeDefaults]);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiSuperDatePicker"],{start:urlParams.rangeFrom,end:urlParams.rangeTo,isPaused:urlParams.refreshPaused,refreshInterval:urlParams.refreshInterval,onTimeChange:onTimeChange,onRefresh:({start:start,end:end})=>{Object(_services_rest_callApi__WEBPACK_IMPORTED_MODULE_6__["b"])();refreshTimeRange({rangeFrom:start,rangeTo:end})},onRefreshChange:onRefreshChange,showUpdateButton:true,commonlyUsedRanges:commonlyUsedRanges})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function stripUnit(value){var unitlessValue=parseFloat(value);if(isNaN(unitlessValue))return value;return unitlessValue}exports.default=stripUnit;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function colorToInt(color){return Math.round(color*255)}function convertToInt(red,green,blue){return colorToInt(red)+","+colorToInt(green)+","+colorToInt(blue)}function hslToRgb(hue,saturation,lightness){var convert=arguments.length>3&&arguments[3]!==undefined?arguments[3]:convertToInt;if(saturation===0){return convert(lightness,lightness,lightness)}var huePrime=hue%360/60;var chroma=(1-Math.abs(2*lightness-1))*saturation;var secondComponent=chroma*(1-Math.abs(huePrime%2-1));var red=0;var green=0;var blue=0;if(huePrime>=0&&huePrime<1){red=chroma;green=secondComponent}else if(huePrime>=1&&huePrime<2){red=secondComponent;green=chroma}else if(huePrime>=2&&huePrime<3){green=chroma;blue=secondComponent}else if(huePrime>=3&&huePrime<4){green=secondComponent;blue=chroma}else if(huePrime>=4&&huePrime<5){red=secondComponent;blue=chroma}else if(huePrime>=5&&huePrime<6){red=chroma;blue=secondComponent}var lightnessModification=lightness-chroma/2;var finalRed=red+lightnessModification;var finalGreen=green+lightnessModification;var finalBlue=blue+lightnessModification;return convert(finalRed,finalGreen,finalBlue)}exports.default=hslToRgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _reduceHexValue=__webpack_require__(243);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(244);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgb(value,green,blue){if(typeof value==="number"&&typeof green==="number"&&typeof blue==="number"){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value)+(0,_numberToHex2.default)(green)+(0,_numberToHex2.default)(blue))}else if(typeof value==="object"&&green===undefined&&blue===undefined){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value.red)+(0,_numberToHex2.default)(value.green)+(0,_numberToHex2.default)(value.blue))}throw new Error("Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).")}exports.default=rgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(113);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(78);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _curry=__webpack_require__(60);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function mix(){var weight=arguments.length>0&&arguments[0]!==undefined?arguments[0]:.5;var color=arguments[1];var otherColor=arguments[2];var parsedColor1=(0,_parseToRgb2.default)(color);var color1=_extends({},parsedColor1,{alpha:typeof parsedColor1.alpha==="number"?parsedColor1.alpha:1});var parsedColor2=(0,_parseToRgb2.default)(otherColor);var color2=_extends({},parsedColor2,{alpha:typeof parsedColor2.alpha==="number"?parsedColor2.alpha:1});var alphaDelta=color1.alpha-color2.alpha;var x=weight*2-1;var y=x*alphaDelta===-1?x:x+alphaDelta;var z=1+x*alphaDelta;var weight1=(y/z+1)/2;var weight2=1-weight1;var mixedColor={red:Math.floor(color1.red*weight1+color2.red*weight2),green:Math.floor(color1.green*weight1+color2.green*weight2),blue:Math.floor(color1.blue*weight1+color2.blue*weight2),alpha:color1.alpha+(color2.alpha-color1.alpha)*(weight/1)};return(0,_rgba2.default)(mixedColor)}var curriedMix=(0,_curry2.default)(mix);exports.default=curriedMix;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var high=__webpack_require__(703);var fault=__webpack_require__(704);exports.highlight=highlight;exports.highlightAuto=highlightAuto;exports.registerLanguage=registerLanguage;exports.listLanguages=listLanguages;exports.registerAlias=registerAlias;Emitter.prototype.addText=text;Emitter.prototype.addKeyword=addKeyword;Emitter.prototype.addSublanguage=addSublanguage;Emitter.prototype.openNode=open;Emitter.prototype.closeNode=close;Emitter.prototype.closeAllNodes=noop;Emitter.prototype.finalize=noop;Emitter.prototype.toHTML=toHtmlNoop;var defaultPrefix="hljs-";function highlight(name,value,options){var before=high.configure({});var settings=options||{};var prefix=settings.prefix;var result;if(typeof name!=="string"){throw fault("Expected `string` for name, got `%s`",name)}if(!high.getLanguage(name)){throw fault("Unknown language: `%s` is not registered",name)}if(typeof value!=="string"){throw fault("Expected `string` for value, got `%s`",value)}if(prefix===null||prefix===undefined){prefix=defaultPrefix}high.configure({__emitter:Emitter,classPrefix:prefix});result=high.highlight(name,value,true);high.configure(before||{});if(result.errorRaised){throw result.errorRaised}return{relevance:result.relevance,language:result.language,value:result.emitter.rootNode.children}}function highlightAuto(value,options){var settings=options||{};var subset=settings.subset||high.listLanguages();var prefix=settings.prefix;var length=subset.length;var index=-1;var result;var secondBest;var current;var name;if(prefix===null||prefix===undefined){prefix=defaultPrefix}if(typeof value!=="string"){throw fault("Expected `string` for value, got `%s`",value)}secondBest={relevance:0,language:null,value:[]};result={relevance:0,language:null,value:[]};while(++index<length){name=subset[index];if(!high.getLanguage(name)){continue}current=highlight(name,value,options);current.language=name;if(current.relevance>secondBest.relevance){secondBest=current}if(current.relevance>result.relevance){secondBest=result;result=current}}if(secondBest.language){result.secondBest=secondBest}return result}function registerLanguage(name,syntax){high.registerLanguage(name,syntax)}function listLanguages(){return high.listLanguages()}function registerAlias(name,alias){var map=name;var key;if(alias){map={};map[name]=alias}for(key in map){high.registerAliases(map[key],{languageName:key})}}function Emitter(options){this.options=options;this.rootNode={children:[]};this.stack=[this.rootNode]}function addKeyword(value,name){this.openNode(name);this.addText(value);this.closeNode()}function addSublanguage(other,name){var stack=this.stack;var current=stack[stack.length-1];var results=other.rootNode.children;var node=name?{type:"element",tagName:"span",properties:{className:[name]},children:results}:results;current.children=current.children.concat(node)}function text(value){var stack=this.stack;var current;var tail;if(value==="")return;current=stack[stack.length-1];tail=current.children[current.children.length-1];if(tail&&tail.type==="text"){tail.value+=value}else{current.children.push({type:"text",value:value})}}function open(name){var stack=this.stack;var className=this.options.classPrefix+name;var current=stack[stack.length-1];var child={type:"element",tagName:"span",properties:{className:[className]},children:[]};current.children.push(child);stack.push(child)}function close(){this.stack.pop()}function toHtmlNoop(){return""}function noop(){}},function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(55);Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _regenerator=_interopRequireDefault(__webpack_require__(260));var _asyncToGenerator2=_interopRequireDefault(__webpack_require__(261));var _extends2=_interopRequireDefault(__webpack_require__(258));var _classCallCheck2=_interopRequireDefault(__webpack_require__(899));var _createClass2=_interopRequireDefault(__webpack_require__(900));var _possibleConstructorReturn2=_interopRequireDefault(__webpack_require__(901));var _getPrototypeOf2=_interopRequireDefault(__webpack_require__(904));var _inherits2=_interopRequireDefault(__webpack_require__(905));var _defineProperty2=_interopRequireDefault(__webpack_require__(256));var _react=_interopRequireDefault(__webpack_require__(2));var _highlight=_interopRequireDefault(__webpack_require__(114));var _default=function _default(options){var loader=options.loader,isLanguageRegistered=options.isLanguageRegistered,registerLanguage=options.registerLanguage,languageLoaders=options.languageLoaders,noAsyncLoadingLanguages=options.noAsyncLoadingLanguages;var ReactAsyncHighlighter=function(_React$PureComponent){(0,_inherits2.default)(ReactAsyncHighlighter,_React$PureComponent);function ReactAsyncHighlighter(){(0,_classCallCheck2.default)(this,ReactAsyncHighlighter);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(ReactAsyncHighlighter).apply(this,arguments))}(0,_createClass2.default)(ReactAsyncHighlighter,[{key:"componentDidUpdate",value:function componentDidUpdate(){if(!ReactAsyncHighlighter.isRegistered(this.props.language)&&languageLoaders){this.loadLanguage()}}},{key:"componentDidMount",value:function componentDidMount(){var _this=this;if(!ReactAsyncHighlighter.astGeneratorPromise){ReactAsyncHighlighter.loadAstGenerator()}if(!ReactAsyncHighlighter.astGenerator){ReactAsyncHighlighter.astGeneratorPromise.then((function(){_this.forceUpdate()}))}if(!ReactAsyncHighlighter.isRegistered(this.props.language)&&languageLoaders){this.loadLanguage()}}},{key:"loadLanguage",value:function loadLanguage(){var _this2=this;var language=this.props.language;if(language==="text"){return}ReactAsyncHighlighter.loadLanguage(language).then((function(){return _this2.forceUpdate()})).catch((function(){}))}},{key:"normalizeLanguage",value:function normalizeLanguage(language){return ReactAsyncHighlighter.isSupportedLanguage(language)?language:"text"}},{key:"render",value:function render(){return _react.default.createElement(ReactAsyncHighlighter.highlightInstance,(0,_extends2.default)({},this.props,{language:this.normalizeLanguage(this.props.language),astGenerator:ReactAsyncHighlighter.astGenerator}))}}],[{key:"preload",value:function preload(){return ReactAsyncHighlighter.loadAstGenerator()}},{key:"loadLanguage",value:function(){var _loadLanguage=(0,_asyncToGenerator2.default)(_regenerator.default.mark((function _callee(language){var languageLoader;return _regenerator.default.wrap((function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:languageLoader=languageLoaders[language];if(!(typeof languageLoader==="function")){_context.next=5;break}return _context.abrupt("return",languageLoader(ReactAsyncHighlighter.registerLanguage));case 5:throw new Error("Language ".concat(language," not supported"));case 6:case"end":return _context.stop()}}}),_callee,this)})));return function loadLanguage(_x){return _loadLanguage.apply(this,arguments)}}()},{key:"isSupportedLanguage",value:function isSupportedLanguage(language){return ReactAsyncHighlighter.isRegistered(language)||typeof languageLoaders[language]==="function"}},{key:"loadAstGenerator",value:function loadAstGenerator(){ReactAsyncHighlighter.astGeneratorPromise=loader().then((function(astGenerator){ReactAsyncHighlighter.astGenerator=astGenerator;if(registerLanguage){ReactAsyncHighlighter.languages.forEach((function(language,name){return registerLanguage(astGenerator,name,language)}))}}));return ReactAsyncHighlighter.astGeneratorPromise}}]);return ReactAsyncHighlighter}(_react.default.PureComponent);(0,_defineProperty2.default)(ReactAsyncHighlighter,"astGenerator",null);(0,_defineProperty2.default)(ReactAsyncHighlighter,"highlightInstance",(0,_highlight.default)(null,{}));(0,_defineProperty2.default)(ReactAsyncHighlighter,"astGeneratorPromise",null);(0,_defineProperty2.default)(ReactAsyncHighlighter,"languages",new Map);(0,_defineProperty2.default)(ReactAsyncHighlighter,"supportedLanguages",options.supportedLanguages||Object.keys(languageLoaders||{}));(0,_defineProperty2.default)(ReactAsyncHighlighter,"isRegistered",(function(language){if(noAsyncLoadingLanguages){return true}if(!registerLanguage){throw new Error("Current syntax highlighter doesn't support registration of languages")}if(!ReactAsyncHighlighter.astGenerator){return ReactAsyncHighlighter.languages.has(language)}return isLanguageRegistered(ReactAsyncHighlighter.astGenerator,language)}));(0,_defineProperty2.default)(ReactAsyncHighlighter,"registerLanguage",(function(name,language){if(!registerLanguage){throw new Error("Current syntax highlighter doesn't support registration of languages")}if(ReactAsyncHighlighter.astGenerator){return registerLanguage(ReactAsyncHighlighter.astGenerator,name,language)}else{ReactAsyncHighlighter.languages.set(name,language)}}));return ReactAsyncHighlighter};exports.default=_default},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=cpp;cpp.displayName="cpp";cpp.aliases=[];function cpp(Prism){Prism.register(refractorC);(function(Prism){var keyword=/\b(?:alignas|alignof|asm|auto|bool|break|case|catch|char|char8_t|char16_t|char32_t|class|compl|concept|const|consteval|constexpr|constinit|const_cast|continue|co_await|co_return|co_yield|decltype|default|delete|do|double|dynamic_cast|else|enum|explicit|export|extern|float|for|friend|goto|if|inline|int|int8_t|int16_t|int32_t|int64_t|uint8_t|uint16_t|uint32_t|uint64_t|long|mutable|namespace|new|noexcept|nullptr|operator|private|protected|public|register|reinterpret_cast|requires|return|short|signed|sizeof|static|static_assert|static_cast|struct|switch|template|this|thread_local|throw|try|typedef|typeid|typename|union|unsigned|using|virtual|void|volatile|wchar_t|while)\b/;Prism.languages.cpp=Prism.languages.extend("c",{"class-name":[{pattern:RegExp(/(\b(?:class|concept|enum|struct|typename)\s+)(?!<keyword>)\w+/.source.replace(/<keyword>/g,(function(){return keyword.source}))),lookbehind:true},/\b[A-Z]\w*(?=\s*::\s*\w+\s*\()/,/\b[A-Z_]\w*(?=\s*::\s*~\w+\s*\()/i,/\w+(?=\s*<(?:[^<>]|<(?:[^<>]|<[^<>]*>)*>)*>\s*::\s*\w+\s*\()/],keyword:keyword,number:{pattern:/(?:\b0b[01']+|\b0x(?:[\da-f']+\.?[\da-f']*|\.[\da-f']+)(?:p[+-]?[\d']+)?|(?:\b[\d']+\.?[\d']*|\B\.[\d']+)(?:e[+-]?[\d']+)?)[ful]*/i,greedy:true},operator:/>>=?|<<=?|->|([-+&|:])\1|[?:~]|<=>|[-+*/%&|^!=<>]=?|\b(?:and|and_eq|bitand|bitor|not|not_eq|or|or_eq|xor|xor_eq)\b/,boolean:/\b(?:true|false)\b/});Prism.languages.insertBefore("cpp","string",{"raw-string":{pattern:/R"([^()\\ ]{0,16})\([\s\S]*?\)\1"/,alias:"string",greedy:true}});Prism.languages.insertBefore("cpp","class-name",{"base-clause":{pattern:/(\b(?:class|struct)\s+\w+\s*:\s*)(?:[^;{}"'])+?(?=\s*[;{])/,lookbehind:true,greedy:true,inside:Prism.languages.extend("cpp",{})}});Prism.languages.insertBefore("inside","operator",{"class-name":/\b[a-z_]\w*\b(?!\s*::)/i},Prism.languages.cpp["base-clause"])})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=bash;bash.displayName="bash";bash.aliases=["shell"];function bash(Prism){(function(Prism){var envVars="\\b(?:BASH|BASHOPTS|BASH_ALIASES|BASH_ARGC|BASH_ARGV|BASH_CMDS|BASH_COMPLETION_COMPAT_DIR|BASH_LINENO|BASH_REMATCH|BASH_SOURCE|BASH_VERSINFO|BASH_VERSION|COLORTERM|COLUMNS|COMP_WORDBREAKS|DBUS_SESSION_BUS_ADDRESS|DEFAULTS_PATH|DESKTOP_SESSION|DIRSTACK|DISPLAY|EUID|GDMSESSION|GDM_LANG|GNOME_KEYRING_CONTROL|GNOME_KEYRING_PID|GPG_AGENT_INFO|GROUPS|HISTCONTROL|HISTFILE|HISTFILESIZE|HISTSIZE|HOME|HOSTNAME|HOSTTYPE|IFS|INSTANCE|JOB|LANG|LANGUAGE|LC_ADDRESS|LC_ALL|LC_IDENTIFICATION|LC_MEASUREMENT|LC_MONETARY|LC_NAME|LC_NUMERIC|LC_PAPER|LC_TELEPHONE|LC_TIME|LESSCLOSE|LESSOPEN|LINES|LOGNAME|LS_COLORS|MACHTYPE|MAILCHECK|MANDATORY_PATH|NO_AT_BRIDGE|OLDPWD|OPTERR|OPTIND|ORBIT_SOCKETDIR|OSTYPE|PAPERSIZE|PATH|PIPESTATUS|PPID|PS1|PS2|PS3|PS4|PWD|RANDOM|REPLY|SECONDS|SELINUX_INIT|SESSION|SESSIONTYPE|SESSION_MANAGER|SHELL|SHELLOPTS|SHLVL|SSH_AUTH_SOCK|TERM|UID|UPSTART_EVENTS|UPSTART_INSTANCE|UPSTART_JOB|UPSTART_SESSION|USER|WINDOWID|XAUTHORITY|XDG_CONFIG_DIRS|XDG_CURRENT_DESKTOP|XDG_DATA_DIRS|XDG_GREETER_DATA_DIR|XDG_MENU_PREFIX|XDG_RUNTIME_DIR|XDG_SEAT|XDG_SEAT_PATH|XDG_SESSION_DESKTOP|XDG_SESSION_ID|XDG_SESSION_PATH|XDG_SESSION_TYPE|XDG_VTNR|XMODIFIERS)\\b";var commandAfterHeredoc={pattern:/(^(["']?)\w+\2)[ \t]+\S.*/,lookbehind:true,alias:"punctuation",inside:null};var insideString={bash:commandAfterHeredoc,environment:{pattern:RegExp("\\$"+envVars),alias:"constant"},variable:[{pattern:/\$?\(\([\s\S]+?\)\)/,greedy:true,inside:{variable:[{pattern:/(^\$\(\([\s\S]+)\)\)/,lookbehind:true},/^\$\(\(/],number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/--?|-=|\+\+?|\+=|!=?|~|\*\*?|\*=|\/=?|%=?|<<=?|>>=?|<=?|>=?|==?|&&?|&=|\^=?|\|\|?|\|=|\?|:/,punctuation:/\(\(?|\)\)?|,|;/}},{pattern:/\$\((?:\([^)]+\)|[^()])+\)|`[^`]+`/,greedy:true,inside:{variable:/^\$\(|^`|\)$|`$/}},{pattern:/\$\{[^}]+\}/,greedy:true,inside:{operator:/:[-=?+]?|[!\/]|##?|%%?|\^\^?|,,?/,punctuation:/[\[\]]/,environment:{pattern:RegExp("(\\{)"+envVars),lookbehind:true,alias:"constant"}}},/\$(?:\w+|[#?*!@$])/],entity:/\\(?:[abceEfnrtv\\"]|O?[0-7]{1,3}|x[0-9a-fA-F]{1,2}|u[0-9a-fA-F]{4}|U[0-9a-fA-F]{8})/};Prism.languages.bash={shebang:{pattern:/^#!\s*\/.*/,alias:"important"},comment:{pattern:/(^|[^"{\\$])#.*/,lookbehind:true},"function-name":[{pattern:/(\bfunction\s+)\w+(?=(?:\s*\(?:\s*\))?\s*\{)/,lookbehind:true,alias:"function"},{pattern:/\b\w+(?=\s*\(\s*\)\s*\{)/,alias:"function"}],"for-or-select":{pattern:/(\b(?:for|select)\s+)\w+(?=\s+in\s)/,alias:"variable",lookbehind:true},"assign-left":{pattern:/(^|[\s;|&]|[<>]\()\w+(?=\+?=)/,inside:{environment:{pattern:RegExp("(^|[\\s;|&]|[<>]\\()"+envVars),lookbehind:true,alias:"constant"}},alias:"variable",lookbehind:true},string:[{pattern:/((?:^|[^<])<<-?\s*)(\w+?)\s[\s\S]*?(?:\r?\n|\r)\2/,lookbehind:true,greedy:true,inside:insideString},{pattern:/((?:^|[^<])<<-?\s*)(["'])(\w+)\2\s[\s\S]*?(?:\r?\n|\r)\3/,lookbehind:true,greedy:true,inside:{bash:commandAfterHeredoc}},{pattern:/(^|[^\\](?:\\\\)*)(["'])(?:\\[\s\S]|\$\([^)]+\)|`[^`]+`|(?!\2)[^\\])*\2/,lookbehind:true,greedy:true,inside:insideString}],environment:{pattern:RegExp("\\$?"+envVars),alias:"constant"},variable:insideString.variable,function:{pattern:/(^|[\s;|&]|[<>]\()(?:add|apropos|apt|aptitude|apt-cache|apt-get|aspell|automysqlbackup|awk|basename|bash|bc|bconsole|bg|bzip2|cal|cat|cfdisk|chgrp|chkconfig|chmod|chown|chroot|cksum|clear|cmp|column|comm|composer|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|debootstrap|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|du|egrep|eject|env|ethtool|expand|expect|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|git|gparted|grep|groupadd|groupdel|groupmod|groups|grub-mkconfig|gzip|halt|head|hg|history|host|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|ip|jobs|join|kill|killall|less|link|ln|locate|logname|logrotate|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|lynx|make|man|mc|mdadm|mkconfig|mkdir|mke2fs|mkfifo|mkfs|mkisofs|mknod|mkswap|mmv|more|most|mount|mtools|mtr|mutt|mv|nano|nc|netstat|nice|nl|nohup|notify-send|npm|nslookup|op|open|parted|passwd|paste|pathchk|ping|pkill|pnpm|popd|pr|printcap|printenv|ps|pushd|pv|quota|quotacheck|quotactl|ram|rar|rcp|reboot|remsync|rename|renice|rev|rm|rmdir|rpm|rsync|scp|screen|sdiff|sed|sendmail|seq|service|sftp|sh|shellcheck|shuf|shutdown|sleep|slocate|sort|split|ssh|stat|strace|su|sudo|sum|suspend|swapon|sync|tac|tail|tar|tee|time|timeout|top|touch|tr|traceroute|tsort|tty|umount|uname|unexpand|uniq|units|unrar|unshar|unzip|update-grub|uptime|useradd|userdel|usermod|users|uudecode|uuencode|v|vdir|vi|vim|virsh|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yarn|yes|zenity|zip|zsh|zypper)(?=$|[)\s;|&])/,lookbehind:true},keyword:{pattern:/(^|[\s;|&]|[<>]\()(?:if|then|else|elif|fi|for|while|in|case|esac|function|select|do|done|until)(?=$|[)\s;|&])/,lookbehind:true},builtin:{pattern:/(^|[\s;|&]|[<>]\()(?:\.|:|break|cd|continue|eval|exec|exit|export|getopts|hash|pwd|readonly|return|shift|test|times|trap|umask|unset|alias|bind|builtin|caller|command|declare|echo|enable|help|let|local|logout|mapfile|printf|read|readarray|source|type|typeset|ulimit|unalias|set|shopt)(?=$|[)\s;|&])/,lookbehind:true,alias:"class-name"},boolean:{pattern:/(^|[\s;|&]|[<>]\()(?:true|false)(?=$|[)\s;|&])/,lookbehind:true},"file-descriptor":{pattern:/\B&\d\b/,alias:"important"},operator:{pattern:/\d?<>|>\||\+=|==?|!=?|=~|<<[<-]?|[&\d]?>>|\d?[<>]&?|&[>&]?|\|[&|]?|<=?|>=?/,inside:{"file-descriptor":{pattern:/^\d/,alias:"important"}}},punctuation:/\$?\(\(?|\)\)?|\.\.|[{}[\];\\]/,number:{pattern:/(^|\s)(?:[1-9]\d*|0)(?:[.,]\d+)?\b/,lookbehind:true}};commandAfterHeredoc.inside=Prism.languages.bash;var toBeCopied=["comment","function-name","for-or-select","assign-left","string","environment","function","keyword","builtin","boolean","file-descriptor","operator","punctuation","number"];var inside=insideString.variable[1].inside;for(var i=0;i<toBeCopied.length;i++){inside[toBeCopied[i]]=Prism.languages.bash[toBeCopied[i]]}Prism.languages.shell=Prism.languages.bash})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=basic;basic.displayName="basic";basic.aliases=[];function basic(Prism){Prism.languages.basic={comment:{pattern:/(?:!|REM\b).+/i,inside:{keyword:/^REM/i}},string:{pattern:/"(?:""|[!#$%&'()*,\/:;<=>?^_ +\-.A-Z\d])*"/i,greedy:true},number:/(?:\b\d+\.?\d*|\B\.\d+)(?:E[+-]?\d+)?/i,keyword:/\b(?:AS|BEEP|BLOAD|BSAVE|CALL(?: ABSOLUTE)?|CASE|CHAIN|CHDIR|CLEAR|CLOSE|CLS|COM|COMMON|CONST|DATA|DECLARE|DEF(?: FN| SEG|DBL|INT|LNG|SNG|STR)|DIM|DO|DOUBLE|ELSE|ELSEIF|END|ENVIRON|ERASE|ERROR|EXIT|FIELD|FILES|FOR|FUNCTION|GET|GOSUB|GOTO|IF|INPUT|INTEGER|IOCTL|KEY|KILL|LINE INPUT|LOCATE|LOCK|LONG|LOOP|LSET|MKDIR|NAME|NEXT|OFF|ON(?: COM| ERROR| KEY| TIMER)?|OPEN|OPTION BASE|OUT|POKE|PUT|READ|REDIM|REM|RESTORE|RESUME|RETURN|RMDIR|RSET|RUN|SHARED|SINGLE|SELECT CASE|SHELL|SLEEP|STATIC|STEP|STOP|STRING|SUB|SWAP|SYSTEM|THEN|TIMER|TO|TROFF|TRON|TYPE|UNLOCK|UNTIL|USING|VIEW PRINT|WAIT|WEND|WHILE|WRITE)(?:\$|\b)/i,function:/\b(?:ABS|ACCESS|ACOS|ANGLE|AREA|ARITHMETIC|ARRAY|ASIN|ASK|AT|ATN|BASE|BEGIN|BREAK|CAUSE|CEIL|CHR|CLIP|COLLATE|COLOR|CON|COS|COSH|COT|CSC|DATE|DATUM|DEBUG|DECIMAL|DEF|DEG|DEGREES|DELETE|DET|DEVICE|DISPLAY|DOT|ELAPSED|EPS|ERASABLE|EXLINE|EXP|EXTERNAL|EXTYPE|FILETYPE|FIXED|FP|GO|GRAPH|HANDLER|IDN|IMAGE|IN|INT|INTERNAL|IP|IS|KEYED|LBOUND|LCASE|LEFT|LEN|LENGTH|LET|LINE|LINES|LOG|LOG10|LOG2|LTRIM|MARGIN|MAT|MAX|MAXNUM|MID|MIN|MISSING|MOD|NATIVE|NUL|NUMERIC|OF|OPTION|ORD|ORGANIZATION|OUTIN|OUTPUT|PI|POINT|POINTER|POINTS|POS|PRINT|PROGRAM|PROMPT|RAD|RADIANS|RANDOMIZE|RECORD|RECSIZE|RECTYPE|RELATIVE|REMAINDER|REPEAT|REST|RETRY|REWRITE|RIGHT|RND|ROUND|RTRIM|SAME|SEC|SELECT|SEQUENTIAL|SET|SETTER|SGN|SIN|SINH|SIZE|SKIP|SQR|STANDARD|STATUS|STR|STREAM|STYLE|TAB|TAN|TANH|TEMPLATE|TEXT|THERE|TIME|TIMEOUT|TRACE|TRANSFORM|TRUNCATE|UBOUND|UCASE|USE|VAL|VARIABLE|VIEWPORT|WHEN|WINDOW|WITH|ZER|ZONEWIDTH)(?:\$|\b)/i,operator:/<[=>]?|>=?|[+\-*\/^=&]|\b(?:AND|EQV|IMP|NOT|OR|XOR)\b/i,punctuation:/[,;:()]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=lua;lua.displayName="lua";lua.aliases=[];function lua(Prism){Prism.languages.lua={comment:/^#!.+|--(?:\[(=*)\[[\s\S]*?\]\1\]|.*)/m,string:{pattern:/(["'])(?:(?!\1)[^\\\r\n]|\\z(?:\r\n|\s)|\\(?:\r\n|[\s\S]))*\1|\[(=*)\[[\s\S]*?\]\2\]/,greedy:true},number:/\b0x[a-f\d]+\.?[a-f\d]*(?:p[+-]?\d+)?\b|\b\d+(?:\.\B|\.?\d*(?:e[+-]?\d+)?\b)|\B\.\d+(?:e[+-]?\d+)?\b/i,keyword:/\b(?:and|break|do|else|elseif|end|false|for|function|goto|if|in|local|nil|not|or|repeat|return|then|true|until|while)\b/,function:/(?!\d)\w+(?=\s*(?:[({]))/,operator:[/[-+*%^&|#]|\/\/?|<[<=]?|>[>=]?|[=~]=?/,{pattern:/(^|[^.])\.\.(?!\.)/,lookbehind:true}],punctuation:/[\[\](){},;]|\.+|:+/}}},function(module,exports,__webpack_require__){"use strict";module.exports=haskell;haskell.displayName="haskell";haskell.aliases=["hs"];function haskell(Prism){Prism.languages.haskell={comment:{pattern:/(^|[^-!#$%*+=?&@|~.:<>^\\\/])(?:--(?:(?=.)[^-!#$%*+=?&@|~.:<>^\\\/].*|$)|{-[\s\S]*?-})/m,lookbehind:true},char:{pattern:/'(?:[^\\']|\\(?:[abfnrtv\\"'&]|\^[A-Z@[\]^_]|NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|\d+|o[0-7]+|x[0-9a-fA-F]+))'/,alias:"string"},string:{pattern:/"(?:[^\\"]|\\(?:\S|\s+\\))*"/,greedy:true},keyword:/\b(?:case|class|data|deriving|do|else|if|in|infixl|infixr|instance|let|module|newtype|of|primitive|then|type|where)\b/,"import-statement":{pattern:/(^\s*)import\s+(?:qualified\s+)?(?:[A-Z][\w']*)(?:\.[A-Z][\w']*)*(?:\s+as\s+(?:[A-Z][\w']*)(?:\.[A-Z][\w']*)*)?(?:\s+hiding\b)?/m,lookbehind:true,inside:{keyword:/\b(?:import|qualified|as|hiding)\b/}},builtin:/\b(?:abs|acos|acosh|all|and|any|appendFile|approxRational|asTypeOf|asin|asinh|atan|atan2|atanh|basicIORun|break|catch|ceiling|chr|compare|concat|concatMap|const|cos|cosh|curry|cycle|decodeFloat|denominator|digitToInt|div|divMod|drop|dropWhile|either|elem|encodeFloat|enumFrom|enumFromThen|enumFromThenTo|enumFromTo|error|even|exp|exponent|fail|filter|flip|floatDigits|floatRadix|floatRange|floor|fmap|foldl|foldl1|foldr|foldr1|fromDouble|fromEnum|fromInt|fromInteger|fromIntegral|fromRational|fst|gcd|getChar|getContents|getLine|group|head|id|inRange|index|init|intToDigit|interact|ioError|isAlpha|isAlphaNum|isAscii|isControl|isDenormalized|isDigit|isHexDigit|isIEEE|isInfinite|isLower|isNaN|isNegativeZero|isOctDigit|isPrint|isSpace|isUpper|iterate|last|lcm|length|lex|lexDigits|lexLitChar|lines|log|logBase|lookup|map|mapM|mapM_|max|maxBound|maximum|maybe|min|minBound|minimum|mod|negate|not|notElem|null|numerator|odd|or|ord|otherwise|pack|pi|pred|primExitWith|print|product|properFraction|putChar|putStr|putStrLn|quot|quotRem|range|rangeSize|read|readDec|readFile|readFloat|readHex|readIO|readInt|readList|readLitChar|readLn|readOct|readParen|readSigned|reads|readsPrec|realToFrac|recip|rem|repeat|replicate|return|reverse|round|scaleFloat|scanl|scanl1|scanr|scanr1|seq|sequence|sequence_|show|showChar|showInt|showList|showLitChar|showParen|showSigned|showString|shows|showsPrec|significand|signum|sin|sinh|snd|sort|span|splitAt|sqrt|subtract|succ|sum|tail|take|takeWhile|tan|tanh|threadToIOResult|toEnum|toInt|toInteger|toLower|toRational|toUpper|truncate|uncurry|undefined|unlines|until|unwords|unzip|unzip3|userError|words|writeFile|zip|zip3|zipWith|zipWith3)\b/,number:/\b(?:\d+(?:\.\d+)?(?:e[+-]?\d+)?|0o[0-7]+|0x[0-9a-f]+)\b/i,operator:/\s\.\s|[-!#$%*+=?&@|~.:<>^\\\/]*\.[-!#$%*+=?&@|~.:<>^\\\/]+|[-!#$%*+=?&@|~.:<>^\\\/]+\.[-!#$%*+=?&@|~.:<>^\\\/]*|[-!#$%*+=?&@|~:<>^\\\/]+|`(?:[A-Z][\w']*\.)*[_a-z][\w']*`/,hvariable:/\b(?:[A-Z][\w']*\.)*[_a-z][\w']*\b/,constant:/\b(?:[A-Z][\w']*\.)*[A-Z][\w']*\b/,punctuation:/[{}[\];(),.:]/};Prism.languages.hs=Prism.languages.haskell}},function(module,exports,__webpack_require__){"use strict";module.exports=jsx;jsx.displayName="jsx";jsx.aliases=[];function jsx(Prism){(function(Prism){var javascript=Prism.util.clone(Prism.languages.javascript);Prism.languages.jsx=Prism.languages.extend("markup",javascript);Prism.languages.jsx.tag.pattern=/<\/?(?:[\w.:-]+\s*(?:\s+(?:[\w.:$-]+(?:=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s{'">=]+|\{(?:\{(?:\{[^{}]*\}|[^{}])*\}|[^{}])+\}))?|\{\s*\.{3}\s*[a-z_$][\w$]*(?:\.[a-z_$][\w$]*)*\s*\}))*\s*\/?)?>/i;Prism.languages.jsx.tag.inside["tag"].pattern=/^<\/?[^\s>\/]*/i;Prism.languages.jsx.tag.inside["attr-value"].pattern=/=(?!\{)(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">]+)/i;Prism.languages.jsx.tag.inside["tag"].inside["class-name"]=/^[A-Z]\w*(?:\.[A-Z]\w*)*$/;Prism.languages.insertBefore("inside","attr-name",{spread:{pattern:/\{\s*\.{3}\s*[a-z_$][\w$]*(?:\.[a-z_$][\w$]*)*\s*\}/,inside:{punctuation:/\.{3}|[{}.]/,"attr-value":/\w+/}}},Prism.languages.jsx.tag);Prism.languages.insertBefore("inside","attr-value",{script:{pattern:/=(?:\{(?:\{(?:\{[^{}]*\}|[^{}])*\}|[^{}])+\})/i,inside:{"script-punctuation":{pattern:/^=(?={)/,alias:"punctuation"},rest:Prism.languages.jsx},alias:"language-javascript"}},Prism.languages.jsx.tag);var stringifyToken=function(token){if(!token){return""}if(typeof token==="string"){return token}if(typeof token.content==="string"){return token.content}return token.content.map(stringifyToken).join("")};var walkTokens=function(tokens){var openedTags=[];for(var i=0;i<tokens.length;i++){var token=tokens[i];var notTagNorBrace=false;if(typeof token!=="string"){if(token.type==="tag"&&token.content[0]&&token.content[0].type==="tag"){if(token.content[0].content[0].content==="</"){if(openedTags.length>0&&openedTags[openedTags.length-1].tagName===stringifyToken(token.content[0].content[1])){openedTags.pop()}}else{if(token.content[token.content.length-1].content==="/>"){}else{openedTags.push({tagName:stringifyToken(token.content[0].content[1]),openedBraces:0})}}}else if(openedTags.length>0&&token.type==="punctuation"&&token.content==="{"){openedTags[openedTags.length-1].openedBraces++}else if(openedTags.length>0&&openedTags[openedTags.length-1].openedBraces>0&&token.type==="punctuation"&&token.content==="}"){openedTags[openedTags.length-1].openedBraces--}else{notTagNorBrace=true}}if(notTagNorBrace||typeof token==="string"){if(openedTags.length>0&&openedTags[openedTags.length-1].openedBraces===0){var plainText=stringifyToken(token);if(i<tokens.length-1&&(typeof tokens[i+1]==="string"||tokens[i+1].type==="plain-text")){plainText+=stringifyToken(tokens[i+1]);tokens.splice(i+1,1)}if(i>0&&(typeof tokens[i-1]==="string"||tokens[i-1].type==="plain-text")){plainText=stringifyToken(tokens[i-1])+plainText;tokens.splice(i-1,1);i--}tokens[i]=new Prism.Token("plain-text",plainText,null,plainText)}}if(token.content&&typeof token.content!=="string"){walkTokens(token.content)}}};Prism.hooks.add("after-tokenize",(function(env){if(env.language!=="jsx"&&env.language!=="tsx"){return}walkTokens(env.tokens)}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=sql;sql.displayName="sql";sql.aliases=[];function sql(Prism){Prism.languages.sql={comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|(?:--|\/\/|#).*)/,lookbehind:true},variable:[{pattern:/@(["'`])(?:\\[\s\S]|(?!\1)[^\\])+\1/,greedy:true},/@[\w.$]+/],string:{pattern:/(^|[^@\\])("|')(?:\\[\s\S]|(?!\2)[^\\]|\2\2)*\2/,greedy:true,lookbehind:true},function:/\b(?:AVG|COUNT|FIRST|FORMAT|LAST|LCASE|LEN|MAX|MID|MIN|MOD|NOW|ROUND|SUM|UCASE)(?=\s*\()/i,keyword:/\b(?:ACTION|ADD|AFTER|ALGORITHM|ALL|ALTER|ANALYZE|ANY|APPLY|AS|ASC|AUTHORIZATION|AUTO_INCREMENT|BACKUP|BDB|BEGIN|BERKELEYDB|BIGINT|BINARY|BIT|BLOB|BOOL|BOOLEAN|BREAK|BROWSE|BTREE|BULK|BY|CALL|CASCADED?|CASE|CHAIN|CHAR(?:ACTER|SET)?|CHECK(?:POINT)?|CLOSE|CLUSTERED|COALESCE|COLLATE|COLUMNS?|COMMENT|COMMIT(?:TED)?|COMPUTE|CONNECT|CONSISTENT|CONSTRAINT|CONTAINS(?:TABLE)?|CONTINUE|CONVERT|CREATE|CROSS|CURRENT(?:_DATE|_TIME|_TIMESTAMP|_USER)?|CURSOR|CYCLE|DATA(?:BASES?)?|DATE(?:TIME)?|DAY|DBCC|DEALLOCATE|DEC|DECIMAL|DECLARE|DEFAULT|DEFINER|DELAYED|DELETE|DELIMITERS?|DENY|DESC|DESCRIBE|DETERMINISTIC|DISABLE|DISCARD|DISK|DISTINCT|DISTINCTROW|DISTRIBUTED|DO|DOUBLE|DROP|DUMMY|DUMP(?:FILE)?|DUPLICATE|ELSE(?:IF)?|ENABLE|ENCLOSED|END|ENGINE|ENUM|ERRLVL|ERRORS|ESCAPED?|EXCEPT|EXEC(?:UTE)?|EXISTS|EXIT|EXPLAIN|EXTENDED|FETCH|FIELDS|FILE|FILLFACTOR|FIRST|FIXED|FLOAT|FOLLOWING|FOR(?: EACH ROW)?|FORCE|FOREIGN|FREETEXT(?:TABLE)?|FROM|FULL|FUNCTION|GEOMETRY(?:COLLECTION)?|GLOBAL|GOTO|GRANT|GROUP|HANDLER|HASH|HAVING|HOLDLOCK|HOUR|IDENTITY(?:_INSERT|COL)?|IF|IGNORE|IMPORT|INDEX|INFILE|INNER|INNODB|INOUT|INSERT|INT|INTEGER|INTERSECT|INTERVAL|INTO|INVOKER|ISOLATION|ITERATE|JOIN|KEYS?|KILL|LANGUAGE|LAST|LEAVE|LEFT|LEVEL|LIMIT|LINENO|LINES|LINESTRING|LOAD|LOCAL|LOCK|LONG(?:BLOB|TEXT)|LOOP|MATCH(?:ED)?|MEDIUM(?:BLOB|INT|TEXT)|MERGE|MIDDLEINT|MINUTE|MODE|MODIFIES|MODIFY|MONTH|MULTI(?:LINESTRING|POINT|POLYGON)|NATIONAL|NATURAL|NCHAR|NEXT|NO|NONCLUSTERED|NULLIF|NUMERIC|OFF?|OFFSETS?|ON|OPEN(?:DATASOURCE|QUERY|ROWSET)?|OPTIMIZE|OPTION(?:ALLY)?|ORDER|OUT(?:ER|FILE)?|OVER|PARTIAL|PARTITION|PERCENT|PIVOT|PLAN|POINT|POLYGON|PRECEDING|PRECISION|PREPARE|PREV|PRIMARY|PRINT|PRIVILEGES|PROC(?:EDURE)?|PUBLIC|PURGE|QUICK|RAISERROR|READS?|REAL|RECONFIGURE|REFERENCES|RELEASE|RENAME|REPEAT(?:ABLE)?|REPLACE|REPLICATION|REQUIRE|RESIGNAL|RESTORE|RESTRICT|RETURN(?:S|ING)?|REVOKE|RIGHT|ROLLBACK|ROUTINE|ROW(?:COUNT|GUIDCOL|S)?|RTREE|RULE|SAVE(?:POINT)?|SCHEMA|SECOND|SELECT|SERIAL(?:IZABLE)?|SESSION(?:_USER)?|SET(?:USER)?|SHARE|SHOW|SHUTDOWN|SIMPLE|SMALLINT|SNAPSHOT|SOME|SONAME|SQL|START(?:ING)?|STATISTICS|STATUS|STRIPED|SYSTEM_USER|TABLES?|TABLESPACE|TEMP(?:ORARY|TABLE)?|TERMINATED|TEXT(?:SIZE)?|THEN|TIME(?:STAMP)?|TINY(?:BLOB|INT|TEXT)|TOP?|TRAN(?:SACTIONS?)?|TRIGGER|TRUNCATE|TSEQUAL|TYPES?|UNBOUNDED|UNCOMMITTED|UNDEFINED|UNION|UNIQUE|UNLOCK|UNPIVOT|UNSIGNED|UPDATE(?:TEXT)?|USAGE|USE|USER|USING|VALUES?|VAR(?:BINARY|CHAR|CHARACTER|YING)|VIEW|WAITFOR|WARNINGS|WHEN|WHERE|WHILE|WITH(?: ROLLUP|IN)?|WORK|WRITE(?:TEXT)?|YEAR)\b/i,boolean:/\b(?:TRUE|FALSE|NULL)\b/i,number:/\b0x[\da-f]+\b|\b\d+\.?\d*|\B\.\d+\b/i,operator:/[-+*\/=%^~]|&&?|\|\|?|!=?|<(?:=>?|<|>)?|>[>=]?|\b(?:AND|BETWEEN|IN|LIKE|NOT|OR|IS|DIV|REGEXP|RLIKE|SOUNDS LIKE|XOR)\b/i,punctuation:/[;[\]()`,.]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=turtle;turtle.displayName="turtle";turtle.aliases=[];function turtle(Prism){Prism.languages.turtle={comment:{pattern:/#.*/,greedy:true},"multiline-string":{pattern:/"""(?:(?:""?)?(?:[^"\\]|\\.))*"""|'''(?:(?:''?)?(?:[^'\\]|\\.))*'''/,greedy:true,alias:"string",inside:{comment:/#.*/}},string:{pattern:/"(?:[^\\"\r\n]|\\.)*"|'(?:[^\\'\r\n]|\\.)*'/,greedy:true},url:{pattern:/<(?:[^\x00-\x20<>"{}|^`\\]|\\(?:u[\da-fA-F]{4}|U[\da-fA-F]{8}))*>/,greedy:true,inside:{punctuation:/[<>]/}},function:{pattern:/(?:(?![-.\d\xB7])[-.\w\xB7\xC0-\uFFFD]+)?:(?:(?![-.])(?:[-.:\w\xC0-\uFFFD]|%[\da-f]{2}|\\.)+)?/i,inside:{"local-name":{pattern:/([^:]*:)[\s\S]+/,lookbehind:true},prefix:{pattern:/[\s\S]+/,inside:{punctuation:/:/}}}},number:/[+-]?\b\d+\.?\d*(?:e[+-]?\d+)?/i,punctuation:/[{}.,;()[\]]|\^\^/,boolean:/\b(?:true|false)\b/,keyword:[/(?:\ba|@prefix|@base)\b|=/,/\b(?:graph|base|prefix)\b/i],tag:{pattern:/@[a-z]+(?:-[a-z\d]+)*/i,inside:{punctuation:/@/}}};Prism.languages.trig=Prism.languages["turtle"]}},function(module,exports,__webpack_require__){"use strict";var refractorBasic=__webpack_require__(178);module.exports=vbnet;vbnet.displayName="vbnet";vbnet.aliases=[];function vbnet(Prism){Prism.register(refractorBasic);Prism.languages.vbnet=Prism.languages.extend("basic",{keyword:/(?:\b(?:ADDHANDLER|ADDRESSOF|ALIAS|AND|ANDALSO|AS|BEEP|BLOAD|BOOLEAN|BSAVE|BYREF|BYTE|BYVAL|CALL(?: ABSOLUTE)?|CASE|CATCH|CBOOL|CBYTE|CCHAR|CDATE|CDEC|CDBL|CHAIN|CHAR|CHDIR|CINT|CLASS|CLEAR|CLNG|CLOSE|CLS|COBJ|COM|COMMON|CONST|CONTINUE|CSBYTE|CSHORT|CSNG|CSTR|CTYPE|CUINT|CULNG|CUSHORT|DATA|DATE|DECIMAL|DECLARE|DEFAULT|DEF(?: FN| SEG|DBL|INT|LNG|SNG|STR)|DELEGATE|DIM|DIRECTCAST|DO|DOUBLE|ELSE|ELSEIF|END|ENUM|ENVIRON|ERASE|ERROR|EVENT|EXIT|FALSE|FIELD|FILES|FINALLY|FOR(?: EACH)?|FRIEND|FUNCTION|GET|GETTYPE|GETXMLNAMESPACE|GLOBAL|GOSUB|GOTO|HANDLES|IF|IMPLEMENTS|IMPORTS|IN|INHERITS|INPUT|INTEGER|INTERFACE|IOCTL|IS|ISNOT|KEY|KILL|LINE INPUT|LET|LIB|LIKE|LOCATE|LOCK|LONG|LOOP|LSET|ME|MKDIR|MOD|MODULE|MUSTINHERIT|MUSTOVERRIDE|MYBASE|MYCLASS|NAME|NAMESPACE|NARROWING|NEW|NEXT|NOT|NOTHING|NOTINHERITABLE|NOTOVERRIDABLE|OBJECT|OF|OFF|ON(?: COM| ERROR| KEY| TIMER)?|OPERATOR|OPEN|OPTION(?: BASE)?|OPTIONAL|OR|ORELSE|OUT|OVERLOADS|OVERRIDABLE|OVERRIDES|PARAMARRAY|PARTIAL|POKE|PRIVATE|PROPERTY|PROTECTED|PUBLIC|PUT|RAISEEVENT|READ|READONLY|REDIM|REM|REMOVEHANDLER|RESTORE|RESUME|RETURN|RMDIR|RSET|RUN|SBYTE|SELECT(?: CASE)?|SET|SHADOWS|SHARED|SHORT|SINGLE|SHELL|SLEEP|STATIC|STEP|STOP|STRING|STRUCTURE|SUB|SYNCLOCK|SWAP|SYSTEM|THEN|THROW|TIMER|TO|TROFF|TRON|TRUE|TRY|TRYCAST|TYPE|TYPEOF|UINTEGER|ULONG|UNLOCK|UNTIL|USHORT|USING|VIEW PRINT|WAIT|WEND|WHEN|WHILE|WIDENING|WITH|WITHEVENTS|WRITE|WRITEONLY|XOR)|\B(?:#CONST|#ELSE|#ELSEIF|#END|#IF))(?:\$|\b)/i,comment:[{pattern:/(?:!|REM\b).+/i,inside:{keyword:/^REM/i}},{pattern:/(^|[^\\:])'.*/,lookbehind:true}]})}},function(module,exports,__webpack_require__){"use strict";module.exports=yaml;yaml.displayName="yaml";yaml.aliases=["yml"];function yaml(Prism){(function(Prism){var anchorOrAlias=/[*&][^\s[\]{},]+/;var tag=/!(?:<[\w\-%#;/?:@&=+$,.!~*'()[\]]+>|(?:[a-zA-Z\d-]*!)?[\w\-%#;/?:@&=+$.~*'()]+)?/;var properties="(?:"+tag.source+"(?:[ \t]+"+anchorOrAlias.source+")?|"+anchorOrAlias.source+"(?:[ \t]+"+tag.source+")?)";var plainKey=/(?:[^\s\x00-\x08\x0e-\x1f!"#%&'*,\-:>?@[\]`{|}\x7f-\x84\x86-\x9f\ud800-\udfff\ufffe\uffff]|[?:-]<PLAIN>)(?:[ \t]*(?:(?![#:])<PLAIN>|:<PLAIN>))*/.source.replace(/<PLAIN>/g,(function(){return/[^\s\x00-\x08\x0e-\x1f,[\]{}\x7f-\x84\x86-\x9f\ud800-\udfff\ufffe\uffff]/.source}));var string=/"(?:[^"\\\r\n]|\\.)*"|'(?:[^'\\\r\n]|\\.)*'/.source;function createValuePattern(value,flags){flags=(flags||"").replace(/m/g,"")+"m";var pattern=/([:\-,[{]\s*(?:\s<<prop>>[ \t]+)?)(?:<<value>>)(?=[ \t]*(?:$|,|]|}|\s*#))/.source.replace(/<<prop>>/g,(function(){return properties})).replace(/<<value>>/g,(function(){return value}));return RegExp(pattern,flags)}Prism.languages.yaml={scalar:{pattern:RegExp(/([\-:]\s*(?:\s<<prop>>[ \t]+)?[|>])[ \t]*(?:((?:\r?\n|\r)[ \t]+)[^\r\n]+(?:\2[^\r\n]+)*)/.source.replace(/<<prop>>/g,(function(){return properties}))),lookbehind:true,alias:"string"},comment:/#.*/,key:{pattern:RegExp(/((?:^|[:\-,[{\r\n?])[ \t]*(?:<<prop>>[ \t]+)?)<<key>>(?=\s*:\s)/.source.replace(/<<prop>>/g,(function(){return properties})).replace(/<<key>>/g,(function(){return"(?:"+plainKey+"|"+string+")"}))),lookbehind:true,greedy:true,alias:"atrule"},directive:{pattern:/(^[ \t]*)%.+/m,lookbehind:true,alias:"important"},datetime:{pattern:createValuePattern(/\d{4}-\d\d?-\d\d?(?:[tT]|[ \t]+)\d\d?:\d{2}:\d{2}(?:\.\d*)?[ \t]*(?:Z|[-+]\d\d?(?::\d{2})?)?|\d{4}-\d{2}-\d{2}|\d\d?:\d{2}(?::\d{2}(?:\.\d*)?)?/.source),lookbehind:true,alias:"number"},boolean:{pattern:createValuePattern(/true|false/.source,"i"),lookbehind:true,alias:"important"},null:{pattern:createValuePattern(/null|~/.source,"i"),lookbehind:true,alias:"important"},string:{pattern:createValuePattern(string),lookbehind:true,greedy:true},number:{pattern:createValuePattern(/[+-]?(?:0x[\da-f]+|0o[0-7]+|(?:\d+\.?\d*|\.?\d+)(?:e[+-]?\d+)?|\.inf|\.nan)/.source,"i"),lookbehind:true},tag:tag,important:anchorOrAlias,punctuation:/---|[:[\]{}\-,|>?]|\.\.\./};Prism.languages.yml=Prism.languages.yaml})(Prism)}},function(module,exports,__webpack_require__){"use strict";(function(global){var restore=capture();var ctx=typeof window==="undefined"?typeof self==="undefined"?{}:self:window;ctx.Prism={manual:true,disableWorkerMessageHandler:true};var h=__webpack_require__(1096);var decode=__webpack_require__(1113);var Prism=__webpack_require__(1120);var markup=__webpack_require__(380);var css=__webpack_require__(303);var clike=__webpack_require__(295);var js=__webpack_require__(356);restore();var own={}.hasOwnProperty;function Refractor(){}Refractor.prototype=Prism;var refract=new Refractor;module.exports=refract;refract.highlight=highlight;refract.register=register;refract.alias=alias;refract.registered=registered;refract.listLanguages=listLanguages;register(markup);register(css);register(clike);register(js);refract.util.encode=encode;refract.Token.stringify=stringify;function register(grammar){if(typeof grammar!=="function"||!grammar.displayName){throw new Error("Expected `function` for `grammar`, got `"+grammar+"`")}if(refract.languages[grammar.displayName]===undefined){grammar(refract)}}function alias(name,alias){var languages=refract.languages;var map=name;var key;var list;var length;var index;if(alias){map={};map[name]=alias}for(key in map){list=map[key];list=typeof list==="string"?[list]:list;length=list.length;index=-1;while(++index<length){languages[list[index]]=languages[key]}}}function highlight(value,name){var sup=Prism.highlight;var grammar;if(typeof value!=="string"){throw new Error("Expected `string` for `value`, got `"+value+"`")}if(refract.util.type(name)==="Object"){grammar=name;name=null}else{if(typeof name!=="string"){throw new Error("Expected `string` for `name`, got `"+name+"`")}if(own.call(refract.languages,name)){grammar=refract.languages[name]}else{throw new Error("Unknown language: `"+name+"` is not registered")}}return sup.call(this,value,grammar,name)}function registered(language){if(typeof language!=="string"){throw new Error("Expected `string` for `language`, got `"+language+"`")}return own.call(refract.languages,language)}function listLanguages(){var languages=refract.languages;var list=[];var language;for(language in languages){if(own.call(languages,language)&&typeof languages[language]==="object"){list.push(language)}}return list}function stringify(value,language,parent){var env;if(typeof value==="string"){return{type:"text",value:value}}if(refract.util.type(value)==="Array"){return stringifyAll(value,language)}env={type:value.type,content:refract.Token.stringify(value.content,language,parent),tag:"span",classes:["token",value.type],attributes:{},language:language,parent:parent};if(value.alias){env.classes=env.classes.concat(value.alias)}refract.hooks.run("wrap",env);return h(env.tag+"."+env.classes.join("."),attributes(env.attributes),env.content)}function stringifyAll(values,language){var result=[];var length=values.length;var index=-1;var value;while(++index<length){value=values[index];if(value!==""&&value!==null&&value!==undefined){result.push(value)}}index=-1;length=result.length;while(++index<length){value=result[index];result[index]=refract.Token.stringify(value,language,result)}return result}function encode(tokens){return tokens}function attributes(attrs){var key;for(key in attrs){attrs[key]=decode(attrs[key])}return attrs}function capture(){var defined="Prism"in global;var current=defined?global.Prism:undefined;return restore;function restore(){if(defined){global.Prism=current}else{delete global.Prism}defined=undefined;current=undefined}}}).call(this,__webpack_require__(71))},function(module,exports,__webpack_require__){"use strict";module.exports=normalize;function normalize(value){return value.toLowerCase()}},function(module,exports,__webpack_require__){"use strict";var powers=0;exports.boolean=increment();exports.booleanish=increment();exports.overloadedBoolean=increment();exports.number=increment();exports.spaceSeparated=increment();exports.commaSeparated=increment();exports.commaOrSpaceSeparated=increment();function increment(){return Math.pow(2,++powers)}},function(module,exports,__webpack_require__){"use strict";var _=__webpack_require__(65);module.exports=Graph;var DEFAULT_EDGE_NAME="\0";var GRAPH_NODE="\0";var EDGE_KEY_DELIM="";function Graph(opts){this._isDirected=_.has(opts,"directed")?opts.directed:true;this._isMultigraph=_.has(opts,"multigraph")?opts.multigraph:false;this._isCompound=_.has(opts,"compound")?opts.compound:false;this._label=undefined;this._defaultNodeLabelFn=_.constant(undefined);this._defaultEdgeLabelFn=_.constant(undefined);this._nodes={};if(this._isCompound){this._parent={};this._children={};this._children[GRAPH_NODE]={}}this._in={};this._preds={};this._out={};this._sucs={};this._edgeObjs={};this._edgeLabels={}}Graph.prototype._nodeCount=0;Graph.prototype._edgeCount=0;Graph.prototype.isDirected=function(){return this._isDirected};Graph.prototype.isMultigraph=function(){return this._isMultigraph};Graph.prototype.isCompound=function(){return this._isCompound};Graph.prototype.setGraph=function(label){this._label=label;return this};Graph.prototype.graph=function(){return this._label};Graph.prototype.setDefaultNodeLabel=function(newDefault){if(!_.isFunction(newDefault)){newDefault=_.constant(newDefault)}this._defaultNodeLabelFn=newDefault;return this};Graph.prototype.nodeCount=function(){return this._nodeCount};Graph.prototype.nodes=function(){return _.keys(this._nodes)};Graph.prototype.sources=function(){var self=this;return _.filter(this.nodes(),(function(v){return _.isEmpty(self._in[v])}))};Graph.prototype.sinks=function(){var self=this;return _.filter(this.nodes(),(function(v){return _.isEmpty(self._out[v])}))};Graph.prototype.setNodes=function(vs,value){var args=arguments;var self=this;_.each(vs,(function(v){if(args.length>1){self.setNode(v,value)}else{self.setNode(v)}}));return this};Graph.prototype.setNode=function(v,value){if(_.has(this._nodes,v)){if(arguments.length>1){this._nodes[v]=value}return this}this._nodes[v]=arguments.length>1?value:this._defaultNodeLabelFn(v);if(this._isCompound){this._parent[v]=GRAPH_NODE;this._children[v]={};this._children[GRAPH_NODE][v]=true}this._in[v]={};this._preds[v]={};this._out[v]={};this._sucs[v]={};++this._nodeCount;return this};Graph.prototype.node=function(v){return this._nodes[v]};Graph.prototype.hasNode=function(v){return _.has(this._nodes,v)};Graph.prototype.removeNode=function(v){var self=this;if(_.has(this._nodes,v)){var removeEdge=function(e){self.removeEdge(self._edgeObjs[e])};delete this._nodes[v];if(this._isCompound){this._removeFromParentsChildList(v);delete this._parent[v];_.each(this.children(v),(function(child){self.setParent(child)}));delete this._children[v]}_.each(_.keys(this._in[v]),removeEdge);delete this._in[v];delete this._preds[v];_.each(_.keys(this._out[v]),removeEdge);delete this._out[v];delete this._sucs[v];--this._nodeCount}return this};Graph.prototype.setParent=function(v,parent){if(!this._isCompound){throw new Error("Cannot set parent in a non-compound graph")}if(_.isUndefined(parent)){parent=GRAPH_NODE}else{parent+="";for(var ancestor=parent;!_.isUndefined(ancestor);ancestor=this.parent(ancestor)){if(ancestor===v){throw new Error("Setting "+parent+" as parent of "+v+" would create a cycle")}}this.setNode(parent)}this.setNode(v);this._removeFromParentsChildList(v);this._parent[v]=parent;this._children[parent][v]=true;return this};Graph.prototype._removeFromParentsChildList=function(v){delete this._children[this._parent[v]][v]};Graph.prototype.parent=function(v){if(this._isCompound){var parent=this._parent[v];if(parent!==GRAPH_NODE){return parent}}};Graph.prototype.children=function(v){if(_.isUndefined(v)){v=GRAPH_NODE}if(this._isCompound){var children=this._children[v];if(children){return _.keys(children)}}else if(v===GRAPH_NODE){return this.nodes()}else if(this.hasNode(v)){return[]}};Graph.prototype.predecessors=function(v){var predsV=this._preds[v];if(predsV){return _.keys(predsV)}};Graph.prototype.successors=function(v){var sucsV=this._sucs[v];if(sucsV){return _.keys(sucsV)}};Graph.prototype.neighbors=function(v){var preds=this.predecessors(v);if(preds){return _.union(preds,this.successors(v))}};Graph.prototype.isLeaf=function(v){var neighbors;if(this.isDirected()){neighbors=this.successors(v)}else{neighbors=this.neighbors(v)}return neighbors.length===0};Graph.prototype.filterNodes=function(filter){var copy=new this.constructor({directed:this._isDirected,multigraph:this._isMultigraph,compound:this._isCompound});copy.setGraph(this.graph());var self=this;_.each(this._nodes,(function(value,v){if(filter(v)){copy.setNode(v,value)}}));_.each(this._edgeObjs,(function(e){if(copy.hasNode(e.v)&&copy.hasNode(e.w)){copy.setEdge(e,self.edge(e))}}));var parents={};function findParent(v){var parent=self.parent(v);if(parent===undefined||copy.hasNode(parent)){parents[v]=parent;return parent}else if(parent in parents){return parents[parent]}else{return findParent(parent)}}if(this._isCompound){_.each(copy.nodes(),(function(v){copy.setParent(v,findParent(v))}))}return copy};Graph.prototype.setDefaultEdgeLabel=function(newDefault){if(!_.isFunction(newDefault)){newDefault=_.constant(newDefault)}this._defaultEdgeLabelFn=newDefault;return this};Graph.prototype.edgeCount=function(){return this._edgeCount};Graph.prototype.edges=function(){return _.values(this._edgeObjs)};Graph.prototype.setPath=function(vs,value){var self=this;var args=arguments;_.reduce(vs,(function(v,w){if(args.length>1){self.setEdge(v,w,value)}else{self.setEdge(v,w)}return w}));return this};Graph.prototype.setEdge=function(){var v,w,name,value;var valueSpecified=false;var arg0=arguments[0];if(typeof arg0==="object"&&arg0!==null&&"v"in arg0){v=arg0.v;w=arg0.w;name=arg0.name;if(arguments.length===2){value=arguments[1];valueSpecified=true}}else{v=arg0;w=arguments[1];name=arguments[3];if(arguments.length>2){value=arguments[2];valueSpecified=true}}v=""+v;w=""+w;if(!_.isUndefined(name)){name=""+name}var e=edgeArgsToId(this._isDirected,v,w,name);if(_.has(this._edgeLabels,e)){if(valueSpecified){this._edgeLabels[e]=value}return this}if(!_.isUndefined(name)&&!this._isMultigraph){throw new Error("Cannot set a named edge when isMultigraph = false")}this.setNode(v);this.setNode(w);this._edgeLabels[e]=valueSpecified?value:this._defaultEdgeLabelFn(v,w,name);var edgeObj=edgeArgsToObj(this._isDirected,v,w,name);v=edgeObj.v;w=edgeObj.w;Object.freeze(edgeObj);this._edgeObjs[e]=edgeObj;incrementOrInitEntry(this._preds[w],v);incrementOrInitEntry(this._sucs[v],w);this._in[w][e]=edgeObj;this._out[v][e]=edgeObj;this._edgeCount++;return this};Graph.prototype.edge=function(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);return this._edgeLabels[e]};Graph.prototype.hasEdge=function(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);return _.has(this._edgeLabels,e)};Graph.prototype.removeEdge=function(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);var edge=this._edgeObjs[e];if(edge){v=edge.v;w=edge.w;delete this._edgeLabels[e];delete this._edgeObjs[e];decrementOrRemoveEntry(this._preds[w],v);decrementOrRemoveEntry(this._sucs[v],w);delete this._in[w][e];delete this._out[v][e];this._edgeCount--}return this};Graph.prototype.inEdges=function(v,u){var inV=this._in[v];if(inV){var edges=_.values(inV);if(!u){return edges}return _.filter(edges,(function(edge){return edge.v===u}))}};Graph.prototype.outEdges=function(v,w){var outV=this._out[v];if(outV){var edges=_.values(outV);if(!w){return edges}return _.filter(edges,(function(edge){return edge.w===w}))}};Graph.prototype.nodeEdges=function(v,w){var inEdges=this.inEdges(v,w);if(inEdges){return inEdges.concat(this.outEdges(v,w))}};function incrementOrInitEntry(map,k){if(map[k]){map[k]++}else{map[k]=1}}function decrementOrRemoveEntry(map,k){if(!--map[k]){delete map[k]}}function edgeArgsToId(isDirected,v_,w_,name){var v=""+v_;var w=""+w_;if(!isDirected&&v>w){var tmp=v;v=w;w=tmp}return v+EDGE_KEY_DELIM+w+EDGE_KEY_DELIM+(_.isUndefined(name)?DEFAULT_EDGE_NAME:name)}function edgeArgsToObj(isDirected,v_,w_,name){var v=""+v_;var w=""+w_;if(!isDirected&&v>w){var tmp=v;v=w;w=tmp}var edgeObj={v:v,w:w};if(name){edgeObj.name=name}return edgeObj}function edgeObjToId(isDirected,edgeObj){return edgeArgsToId(isDirected,edgeObj.v,edgeObj.w,edgeObj.name)}},function(module,exports,__webpack_require__){var getNative=__webpack_require__(89),root=__webpack_require__(70);var Map=getNative(root,"Map");module.exports=Map},function(module,exports,__webpack_require__){var mapCacheClear=__webpack_require__(1153),mapCacheDelete=__webpack_require__(1160),mapCacheGet=__webpack_require__(1162),mapCacheHas=__webpack_require__(1163),mapCacheSet=__webpack_require__(1164);function MapCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}MapCache.prototype.clear=mapCacheClear;MapCache.prototype["delete"]=mapCacheDelete;MapCache.prototype.get=mapCacheGet;MapCache.prototype.has=mapCacheHas;MapCache.prototype.set=mapCacheSet;module.exports=MapCache},function(module,exports){function arrayEach(array,iteratee){var index=-1,length=array==null?0:array.length;while(++index<length){if(iteratee(array[index],index,array)===false){break}}return array}module.exports=arrayEach},function(module,exports){var MAX_SAFE_INTEGER=9007199254740991;function isLength(value){return typeof value=="number"&&value>-1&&value%1==0&&value<=MAX_SAFE_INTEGER}module.exports=isLength},function(module,exports,__webpack_require__){(function(module){var freeGlobal=__webpack_require__(490);var freeExports=true&&exports&&!exports.nodeType&&exports;var freeModule=freeExports&&typeof module=="object"&&module&&!module.nodeType&&module;var moduleExports=freeModule&&freeModule.exports===freeExports;var freeProcess=moduleExports&&freeGlobal.process;var nodeUtil=function(){try{var types=freeModule&&freeModule.require&&freeModule.require("util").types;if(types){return types}return freeProcess&&freeProcess.binding&&freeProcess.binding("util")}catch(e){}}();module.exports=nodeUtil}).call(this,__webpack_require__(131)(module))},function(module,exports,__webpack_require__){var isPrototype=__webpack_require__(147),nativeKeys=__webpack_require__(1170);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function baseKeys(object){if(!isPrototype(object)){return nativeKeys(object)}var result=[];for(var key in Object(object)){if(hasOwnProperty.call(object,key)&&key!="constructor"){result.push(key)}}return result}module.exports=baseKeys},function(module,exports,__webpack_require__){var arrayFilter=__webpack_require__(497),stubArray=__webpack_require__(498);var objectProto=Object.prototype;var propertyIsEnumerable=objectProto.propertyIsEnumerable;var nativeGetSymbols=Object.getOwnPropertySymbols;var getSymbols=!nativeGetSymbols?stubArray:function(object){if(object==null){return[]}object=Object(object);return arrayFilter(nativeGetSymbols(object),(function(symbol){return propertyIsEnumerable.call(object,symbol)}))};module.exports=getSymbols},function(module,exports){function arrayPush(array,values){var index=-1,length=values.length,offset=array.length;while(++index<length){array[offset+index]=values[index]}return array}module.exports=arrayPush},function(module,exports,__webpack_require__){var Uint8Array=__webpack_require__(503);function cloneArrayBuffer(arrayBuffer){var result=new arrayBuffer.constructor(arrayBuffer.byteLength);new Uint8Array(result).set(new Uint8Array(arrayBuffer));return result}module.exports=cloneArrayBuffer},function(module,exports){function constant(value){return function(){return value}}module.exports=constant},function(module,exports,__webpack_require__){var baseFor=__webpack_require__(201),keys=__webpack_require__(80);function baseForOwn(object,iteratee){return object&&baseFor(object,iteratee,keys)}module.exports=baseForOwn},function(module,exports,__webpack_require__){var createBaseFor=__webpack_require__(1189);var baseFor=createBaseFor();module.exports=baseFor},function(module,exports){function setToArray(set){var index=-1,result=Array(set.size);set.forEach((function(value){result[++index]=value}));return result}module.exports=setToArray},function(module,exports,__webpack_require__){var isArray=__webpack_require__(49),isSymbol=__webpack_require__(105);var reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey(value,object){if(isArray(value)){return false}var type=typeof value;if(type=="number"||type=="symbol"||type=="boolean"||value==null||isSymbol(value)){return true}return reIsPlainProp.test(value)||!reIsDeepProp.test(value)||object!=null&&value in Object(object)}module.exports=isKey},function(module,exports,__webpack_require__){var arrayPush=__webpack_require__(197),isFlattenable=__webpack_require__(1223);function baseFlatten(array,depth,predicate,isStrict,result){var index=-1,length=array.length;predicate||(predicate=isFlattenable);result||(result=[]);while(++index<length){var value=array[index];if(depth>0&&predicate(value)){if(depth>1){baseFlatten(value,depth-1,predicate,isStrict,result)}else{arrayPush(result,value)}}else if(!isStrict){result[result.length]=value}}return result}module.exports=baseFlatten},function(module,exports,__webpack_require__){var isSymbol=__webpack_require__(105);function baseExtremum(array,iteratee,comparator){var index=-1,length=array.length;while(++index<length){var value=array[index],current=iteratee(value);if(current!=null&&(computed===undefined?current===current&&!isSymbol(current):comparator(current,computed))){var computed=current,result=value}}return result}module.exports=baseExtremum},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getUpgradeAssistantHref}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useUpgradeAssistantHref}));var _context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(39);function getUpgradeAssistantHref(basePath){return basePath.prepend("/app/management/stack/upgrade_assistant")}function useUpgradeAssistantHref(){const{core:core}=Object(_context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_0__["a"])();return getUpgradeAssistantHref(core.http.basePath)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getResponseTimeTickFormatter}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getMaxY}));var _common_utils_is_finite_number__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(62);function getResponseTimeTickFormatter(formatter){return t=>formatter(t).formatted}function getMaxY(specs){const values=specs===null||specs===void 0?void 0:specs.flatMap(spec=>spec.data).map(coord=>coord.y).filter(_common_utils_is_finite_number__WEBPACK_IMPORTED_MODULE_0__["a"]);if(values!==null&&values!==void 0&&values.length){return Math.max(...values,0)}return 0}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ScaleUtils=exports.AxisUtils=exports.FlexibleHeightXYPlot=exports.FlexibleWidthXYPlot=exports.FlexibleXYPlot=exports.makeWidthFlexible=exports.makeVisFlexible=exports.makeHeightFlexible=exports.Sunburst=exports.Sankey=exports.ParallelCoordinates=exports.RadarChart=exports.RadialChart=exports.Treemap=exports.ContinuousSizeLegend=exports.ContinuousColorLegend=exports.SearchableDiscreteColorLegend=exports.DiscreteColorLegend=exports.Voronoi=exports.HorizontalGridLines=exports.VerticalGridLines=exports.GradientDefs=exports.GridLines=exports.CircularGridLines=exports.YAxis=exports.XAxis=exports.DecorativeAxis=exports.XYPlot=exports.Crosshair=exports.Borders=exports.Hint=exports.LineMarkSeriesCanvas=exports.LineMarkSeries=exports.ArcSeries=exports.AreaSeries=exports.CustomSVGSeries=exports.ContourSeries=exports.HeatmapSeries=exports.WhiskerSeries=exports.MarkSeriesCanvas=exports.MarkSeries=exports.RectSeriesCanvas=exports.RectSeries=exports.PolygonSeries=exports.LabelSeries=exports.HorizontalRectSeriesCanvas=exports.HorizontalRectSeries=exports.VerticalRectSeriesCanvas=exports.VerticalRectSeries=exports.VerticalBarSeriesCanvas=exports.VerticalBarSeries=exports.HorizontalBarSeriesCanvas=exports.HorizontalBarSeries=exports.LineSeriesCanvas=exports.LineSeries=exports.AbstractSeries=undefined;var _makeVisFlexible=__webpack_require__(1337);Object.defineProperty(exports,"makeHeightFlexible",{enumerable:true,get:function get(){return _makeVisFlexible.makeHeightFlexible}});Object.defineProperty(exports,"makeVisFlexible",{enumerable:true,get:function get(){return _makeVisFlexible.makeVisFlexible}});Object.defineProperty(exports,"makeWidthFlexible",{enumerable:true,get:function get(){return _makeVisFlexible.makeWidthFlexible}});Object.defineProperty(exports,"FlexibleXYPlot",{enumerable:true,get:function get(){return _makeVisFlexible.FlexibleXYPlot}});Object.defineProperty(exports,"FlexibleWidthXYPlot",{enumerable:true,get:function get(){return _makeVisFlexible.FlexibleWidthXYPlot}});Object.defineProperty(exports,"FlexibleHeightXYPlot",{enumerable:true,get:function get(){return _makeVisFlexible.FlexibleHeightXYPlot}});var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);var _lineSeries=__webpack_require__(217);var _lineSeries2=_interopRequireDefault(_lineSeries);var _lineSeriesCanvas=__webpack_require__(560);var _lineSeriesCanvas2=_interopRequireDefault(_lineSeriesCanvas);var _horizontalBarSeries=__webpack_require__(1369);var _horizontalBarSeries2=_interopRequireDefault(_horizontalBarSeries);var _horizontalBarSeriesCanvas=__webpack_require__(1370);var _horizontalBarSeriesCanvas2=_interopRequireDefault(_horizontalBarSeriesCanvas);var _verticalBarSeries=__webpack_require__(1371);var _verticalBarSeries2=_interopRequireDefault(_verticalBarSeries);var _verticalBarSeriesCanvas=__webpack_require__(1372);var _verticalBarSeriesCanvas2=_interopRequireDefault(_verticalBarSeriesCanvas);var _verticalRectSeries=__webpack_require__(563);var _verticalRectSeries2=_interopRequireDefault(_verticalRectSeries);var _verticalRectSeriesCanvas=__webpack_require__(1373);var _verticalRectSeriesCanvas2=_interopRequireDefault(_verticalRectSeriesCanvas);var _horizontalRectSeries=__webpack_require__(1374);var _horizontalRectSeries2=_interopRequireDefault(_horizontalRectSeries);var _horizontalRectSeriesCanvas=__webpack_require__(1375);var _horizontalRectSeriesCanvas2=_interopRequireDefault(_horizontalRectSeriesCanvas);var _labelSeries=__webpack_require__(96);var _labelSeries2=_interopRequireDefault(_labelSeries);var _polygonSeries=__webpack_require__(220);var _polygonSeries2=_interopRequireDefault(_polygonSeries);var _rectSeries=__webpack_require__(218);var _rectSeries2=_interopRequireDefault(_rectSeries);var _rectSeriesCanvas=__webpack_require__(219);var _rectSeriesCanvas2=_interopRequireDefault(_rectSeriesCanvas);var _markSeries=__webpack_require__(221);var _markSeries2=_interopRequireDefault(_markSeries);var _markSeriesCanvas=__webpack_require__(564);var _markSeriesCanvas2=_interopRequireDefault(_markSeriesCanvas);var _whiskerSeries=__webpack_require__(1376);var _whiskerSeries2=_interopRequireDefault(_whiskerSeries);var _heatmapSeries=__webpack_require__(1377);var _heatmapSeries2=_interopRequireDefault(_heatmapSeries);var _contourSeries=__webpack_require__(1378);var _contourSeries2=_interopRequireDefault(_contourSeries);var _customSvgSeries=__webpack_require__(1381);var _customSvgSeries2=_interopRequireDefault(_customSvgSeries);var _areaSeries=__webpack_require__(1382);var _areaSeries2=_interopRequireDefault(_areaSeries);var _arcSeries=__webpack_require__(222);var _arcSeries2=_interopRequireDefault(_arcSeries);var _lineMarkSeries=__webpack_require__(565);var _lineMarkSeries2=_interopRequireDefault(_lineMarkSeries);var _lineMarkSeriesCanvas=__webpack_require__(1383);var _lineMarkSeriesCanvas2=_interopRequireDefault(_lineMarkSeriesCanvas);var _hint=__webpack_require__(1384);var _hint2=_interopRequireDefault(_hint);var _borders=__webpack_require__(1385);var _borders2=_interopRequireDefault(_borders);var _crosshair=__webpack_require__(1386);var _crosshair2=_interopRequireDefault(_crosshair);var _xyPlot=__webpack_require__(81);var _xyPlot2=_interopRequireDefault(_xyPlot);var _decorativeAxis=__webpack_require__(223);var _decorativeAxis2=_interopRequireDefault(_decorativeAxis);var _xAxis=__webpack_require__(1388);var _xAxis2=_interopRequireDefault(_xAxis);var _yAxis=__webpack_require__(1392);var _yAxis2=_interopRequireDefault(_yAxis);var _circularGridLines=__webpack_require__(1393);var _circularGridLines2=_interopRequireDefault(_circularGridLines);var _gridLines=__webpack_require__(224);var _gridLines2=_interopRequireDefault(_gridLines);var _gradientDefs=__webpack_require__(1394);var _gradientDefs2=_interopRequireDefault(_gradientDefs);var _verticalGridLines=__webpack_require__(1395);var _verticalGridLines2=_interopRequireDefault(_verticalGridLines);var _horizontalGridLines=__webpack_require__(1396);var _horizontalGridLines2=_interopRequireDefault(_horizontalGridLines);var _voronoi=__webpack_require__(567);var _voronoi2=_interopRequireDefault(_voronoi);var _discreteColorLegend=__webpack_require__(568);var _discreteColorLegend2=_interopRequireDefault(_discreteColorLegend);var _searchableDiscreteColorLegend=__webpack_require__(1398);var _searchableDiscreteColorLegend2=_interopRequireDefault(_searchableDiscreteColorLegend);var _continuousColorLegend=__webpack_require__(1399);var _continuousColorLegend2=_interopRequireDefault(_continuousColorLegend);var _continuousSizeLegend=__webpack_require__(1400);var _continuousSizeLegend2=_interopRequireDefault(_continuousSizeLegend);var _treemap=__webpack_require__(1401);var _treemap2=_interopRequireDefault(_treemap);var _radialChart=__webpack_require__(1405);var _radialChart2=_interopRequireDefault(_radialChart);var _radarChart=__webpack_require__(1406);var _radarChart2=_interopRequireDefault(_radarChart);var _parallelCoordinates=__webpack_require__(1407);var _parallelCoordinates2=_interopRequireDefault(_parallelCoordinates);var _sankey=__webpack_require__(1408);var _sankey2=_interopRequireDefault(_sankey);var _sunburst=__webpack_require__(1411);var _sunburst2=_interopRequireDefault(_sunburst);var _axisUtils=__webpack_require__(67);var _axisUtils2=_interopRequireDefault(_axisUtils);var _scalesUtils=__webpack_require__(59);var _scalesUtils2=_interopRequireDefault(_scalesUtils);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.AbstractSeries=_abstractSeries2.default;exports.LineSeries=_lineSeries2.default;exports.LineSeriesCanvas=_lineSeriesCanvas2.default;exports.HorizontalBarSeries=_horizontalBarSeries2.default;exports.HorizontalBarSeriesCanvas=_horizontalBarSeriesCanvas2.default;exports.VerticalBarSeries=_verticalBarSeries2.default;exports.VerticalBarSeriesCanvas=_verticalBarSeriesCanvas2.default;exports.VerticalRectSeries=_verticalRectSeries2.default;exports.VerticalRectSeriesCanvas=_verticalRectSeriesCanvas2.default;exports.HorizontalRectSeries=_horizontalRectSeries2.default;exports.HorizontalRectSeriesCanvas=_horizontalRectSeriesCanvas2.default;exports.LabelSeries=_labelSeries2.default;exports.PolygonSeries=_polygonSeries2.default;exports.RectSeries=_rectSeries2.default;exports.RectSeriesCanvas=_rectSeriesCanvas2.default;exports.MarkSeries=_markSeries2.default;exports.MarkSeriesCanvas=_markSeriesCanvas2.default;exports.WhiskerSeries=_whiskerSeries2.default;exports.HeatmapSeries=_heatmapSeries2.default;exports.ContourSeries=_contourSeries2.default;exports.CustomSVGSeries=_customSvgSeries2.default;exports.AreaSeries=_areaSeries2.default;exports.ArcSeries=_arcSeries2.default;exports.LineMarkSeries=_lineMarkSeries2.default;exports.LineMarkSeriesCanvas=_lineMarkSeriesCanvas2.default;exports.Hint=_hint2.default;exports.Borders=_borders2.default;exports.Crosshair=_crosshair2.default;exports.XYPlot=_xyPlot2.default;exports.DecorativeAxis=_decorativeAxis2.default;exports.XAxis=_xAxis2.default;exports.YAxis=_yAxis2.default;exports.CircularGridLines=_circularGridLines2.default;exports.GridLines=_gridLines2.default;exports.GradientDefs=_gradientDefs2.default;exports.VerticalGridLines=_verticalGridLines2.default;exports.HorizontalGridLines=_horizontalGridLines2.default;exports.Voronoi=_voronoi2.default;exports.DiscreteColorLegend=_discreteColorLegend2.default;exports.SearchableDiscreteColorLegend=_searchableDiscreteColorLegend2.default;exports.ContinuousColorLegend=_continuousColorLegend2.default;exports.ContinuousSizeLegend=_continuousSizeLegend2.default;exports.Treemap=_treemap2.default;exports.RadialChart=_radialChart2.default;exports.RadarChart=_radarChart2.default;exports.ParallelCoordinates=_parallelCoordinates2.default;exports.Sankey=_sankey2.default;exports.Sunburst=_sunburst2.default;exports.AxisUtils=_axisUtils2.default;exports.ScaleUtils=_scalesUtils2.default},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var prefix="$";function Map(){}Map.prototype=map.prototype={constructor:Map,has:function(key){return prefix+key in this},get:function(key){return this[prefix+key]},set:function(key,value){this[prefix+key]=value;return this},remove:function(key){var property=prefix+key;return property in this&&delete this[property]},clear:function(){for(var property in this)if(property[0]===prefix)delete this[property]},keys:function(){var keys=[];for(var property in this)if(property[0]===prefix)keys.push(property.slice(1));return keys},values:function(){var values=[];for(var property in this)if(property[0]===prefix)values.push(this[property]);return values},entries:function(){var entries=[];for(var property in this)if(property[0]===prefix)entries.push({key:property.slice(1),value:this[property]});return entries},size:function(){var size=0;for(var property in this)if(property[0]===prefix)++size;return size},empty:function(){for(var property in this)if(property[0]===prefix)return false;return true},each:function(f){for(var property in this)if(property[0]===prefix)f(this[property],property.slice(1),this)}};function map(object,f){var map=new Map;if(object instanceof Map)object.each((function(value,key){map.set(key,value)}));else if(Array.isArray(object)){var i=-1,n=object.length,o;if(f==null)while(++i<n)map.set(i,object[i]);else while(++i<n)map.set(f(o=object[i],i,object),o)}else if(object)for(var key in object)map.set(key,object[key]);return map}function nest(){var keys=[],sortKeys=[],sortValues,rollup,nest;function apply(array,depth,createResult,setResult){if(depth>=keys.length){if(sortValues!=null)array.sort(sortValues);return rollup!=null?rollup(array):array}var i=-1,n=array.length,key=keys[depth++],keyValue,value,valuesByKey=map(),values,result=createResult();while(++i<n){if(values=valuesByKey.get(keyValue=key(value=array[i])+"")){values.push(value)}else{valuesByKey.set(keyValue,[value])}}valuesByKey.each((function(values,key){setResult(result,key,apply(values,depth,createResult,setResult))}));return result}function entries(map$$1,depth){if(++depth>keys.length)return map$$1;var array,sortKey=sortKeys[depth-1];if(rollup!=null&&depth>=keys.length)array=map$$1.entries();else array=[],map$$1.each((function(v,k){array.push({key:k,values:entries(v,depth)})}));return sortKey!=null?array.sort((function(a,b){return sortKey(a.key,b.key)})):array}return nest={object:function(array){return apply(array,0,createObject,setObject)},map:function(array){return apply(array,0,createMap,setMap)},entries:function(array){return entries(apply(array,0,createMap,setMap),0)},key:function(d){keys.push(d);return nest},sortKeys:function(order){sortKeys[keys.length-1]=order;return nest},sortValues:function(order){sortValues=order;return nest},rollup:function(f){rollup=f;return nest}}}function createObject(){return{}}function setObject(object,key,value){object[key]=value}function createMap(){return map()}function setMap(map$$1,key,value){map$$1.set(key,value)}function Set(){}var proto=map.prototype;Set.prototype=set.prototype={constructor:Set,has:proto.has,add:function(value){value+="";this[prefix+value]=value;return this},remove:proto.remove,clear:proto.clear,values:proto.keys,size:proto.size,empty:proto.empty,each:proto.each};function set(object,f){var set=new Set;if(object instanceof Set)object.each((function(value){set.add(value)}));else if(object){var i=-1,n=object.length;if(f==null)while(++i<n)set.add(object[i]);else while(++i<n)set.add(f(object[i],i,object))}return set}function keys(map){var keys=[];for(var key in map)keys.push(key);return keys}function values(map){var values=[];for(var key in map)values.push(map[key]);return values}function entries(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries}exports.nest=nest;exports.set=set;exports.map=map;exports.keys=keys;exports.values=values;exports.entries=entries;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(94)):undefined})(this,(function(exports,d3Color){"use strict";function basis(t1,v0,v1,v2,v3){var t2=t1*t1,t3=t2*t1;return((1-3*t1+3*t2-t3)*v0+(4-6*t2+3*t3)*v1+(1+3*t1+3*t2-3*t3)*v2+t3*v3)/6}function basis$1(values){var n=values.length-1;return function(t){var i=t<=0?t=0:t>=1?(t=1,n-1):Math.floor(t*n),v1=values[i],v2=values[i+1],v0=i>0?values[i-1]:2*v1-v2,v3=i<n-1?values[i+2]:2*v2-v1;return basis((t-i/n)*n,v0,v1,v2,v3)}}function basisClosed(values){var n=values.length;return function(t){var i=Math.floor(((t%=1)<0?++t:t)*n),v0=values[(i+n-1)%n],v1=values[i%n],v2=values[(i+1)%n],v3=values[(i+2)%n];return basis((t-i/n)*n,v0,v1,v2,v3)}}function constant(x){return function(){return x}}function linear(a,d){return function(t){return a+t*d}}function exponential(a,b,y){return a=Math.pow(a,y),b=Math.pow(b,y)-a,y=1/y,function(t){return Math.pow(a+t*b,y)}}function hue(a,b){var d=b-a;return d?linear(a,d>180||d<-180?d-360*Math.round(d/360):d):constant(isNaN(a)?b:a)}function gamma(y){return(y=+y)===1?nogamma:function(a,b){return b-a?exponential(a,b,y):constant(isNaN(a)?b:a)}}function nogamma(a,b){var d=b-a;return d?linear(a,d):constant(isNaN(a)?b:a)}var rgb=function rgbGamma(y){var color=gamma(y);function rgb(start,end){var r=color((start=d3Color.rgb(start)).r,(end=d3Color.rgb(end)).r),g=color(start.g,end.g),b=color(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.r=r(t);start.g=g(t);start.b=b(t);start.opacity=opacity(t);return start+""}}rgb.gamma=rgbGamma;return rgb}(1);function rgbSpline(spline){return function(colors){var n=colors.length,r=new Array(n),g=new Array(n),b=new Array(n),i,color;for(i=0;i<n;++i){color=d3Color.rgb(colors[i]);r[i]=color.r||0;g[i]=color.g||0;b[i]=color.b||0}r=spline(r);g=spline(g);b=spline(b);color.opacity=1;return function(t){color.r=r(t);color.g=g(t);color.b=b(t);return color+""}}}var rgbBasis=rgbSpline(basis$1);var rgbBasisClosed=rgbSpline(basisClosed);function numberArray(a,b){if(!b)b=[];var n=a?Math.min(b.length,a.length):0,c=b.slice(),i;return function(t){for(i=0;i<n;++i)c[i]=a[i]*(1-t)+b[i]*t;return c}}function isNumberArray(x){return ArrayBuffer.isView(x)&&!(x instanceof DataView)}function array(a,b){return(isNumberArray(b)?numberArray:genericArray)(a,b)}function genericArray(a,b){var nb=b?b.length:0,na=a?Math.min(nb,a.length):0,x=new Array(na),c=new Array(nb),i;for(i=0;i<na;++i)x[i]=value(a[i],b[i]);for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<na;++i)c[i]=x[i](t);return c}}function date(a,b){var d=new Date;return a=+a,b=+b,function(t){return d.setTime(a*(1-t)+b*t),d}}function number(a,b){return a=+a,b=+b,function(t){return a*(1-t)+b*t}}function object(a,b){var i={},c={},k;if(a===null||typeof a!=="object")a={};if(b===null||typeof b!=="object")b={};for(k in b){if(k in a){i[k]=value(a[k],b[k])}else{c[k]=b[k]}}return function(t){for(k in i)c[k]=i[k](t);return c}}var reA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,reB=new RegExp(reA.source,"g");function zero(b){return function(){return b}}function one(b){return function(t){return b(t)+""}}function string(a,b){var bi=reA.lastIndex=reB.lastIndex=0,am,bm,bs,i=-1,s=[],q=[];a=a+"",b=b+"";while((am=reA.exec(a))&&(bm=reB.exec(b))){if((bs=bm.index)>bi){bs=b.slice(bi,bs);if(s[i])s[i]+=bs;else s[++i]=bs}if((am=am[0])===(bm=bm[0])){if(s[i])s[i]+=bm;else s[++i]=bm}else{s[++i]=null;q.push({i:i,x:number(am,bm)})}bi=reB.lastIndex}if(bi<b.length){bs=b.slice(bi);if(s[i])s[i]+=bs;else s[++i]=bs}return s.length<2?q[0]?one(q[0].x):zero(b):(b=q.length,function(t){for(var i=0,o;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("")})}function value(a,b){var t=typeof b,c;return b==null||t==="boolean"?constant(b):(t==="number"?number:t==="string"?(c=d3Color.color(b))?(b=c,rgb):string:b instanceof d3Color.color?rgb:b instanceof Date?date:isNumberArray(b)?numberArray:Array.isArray(b)?genericArray:typeof b.valueOf!=="function"&&typeof b.toString!=="function"||isNaN(b)?object:number)(a,b)}function discrete(range){var n=range.length;return function(t){return range[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}function hue$1(a,b){var i=hue(+a,+b);return function(t){var x=i(t);return x-360*Math.floor(x/360)}}function round(a,b){return a=+a,b=+b,function(t){return Math.round(a*(1-t)+b*t)}}var degrees=180/Math.PI;var identity={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function decompose(a,b,c,d,e,f){var scaleX,scaleY,skewX;if(scaleX=Math.sqrt(a*a+b*b))a/=scaleX,b/=scaleX;if(skewX=a*c+b*d)c-=a*skewX,d-=b*skewX;if(scaleY=Math.sqrt(c*c+d*d))c/=scaleY,d/=scaleY,skewX/=scaleY;if(a*d<b*c)a=-a,b=-b,skewX=-skewX,scaleX=-scaleX;return{translateX:e,translateY:f,rotate:Math.atan2(b,a)*degrees,skewX:Math.atan(skewX)*degrees,scaleX:scaleX,scaleY:scaleY}}var cssNode,cssRoot,cssView,svgNode;function parseCss(value){if(value==="none")return identity;if(!cssNode)cssNode=document.createElement("DIV"),cssRoot=document.documentElement,cssView=document.defaultView;cssNode.style.transform=value;value=cssView.getComputedStyle(cssRoot.appendChild(cssNode),null).getPropertyValue("transform");cssRoot.removeChild(cssNode);value=value.slice(7,-1).split(",");return decompose(+value[0],+value[1],+value[2],+value[3],+value[4],+value[5])}function parseSvg(value){if(value==null)return identity;if(!svgNode)svgNode=document.createElementNS("http://www.w3.org/2000/svg","g");svgNode.setAttribute("transform",value);if(!(value=svgNode.transform.baseVal.consolidate()))return identity;value=value.matrix;return decompose(value.a,value.b,value.c,value.d,value.e,value.f)}function interpolateTransform(parse,pxComma,pxParen,degParen){function pop(s){return s.length?s.pop()+" ":""}function translate(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push("translate(",null,pxComma,null,pxParen);q.push({i:i-4,x:number(xa,xb)},{i:i-2,x:number(ya,yb)})}else if(xb||yb){s.push("translate("+xb+pxComma+yb+pxParen)}}function rotate(a,b,s,q){if(a!==b){if(a-b>180)b+=360;else if(b-a>180)a+=360;q.push({i:s.push(pop(s)+"rotate(",null,degParen)-2,x:number(a,b)})}else if(b){s.push(pop(s)+"rotate("+b+degParen)}}function skewX(a,b,s,q){if(a!==b){q.push({i:s.push(pop(s)+"skewX(",null,degParen)-2,x:number(a,b)})}else if(b){s.push(pop(s)+"skewX("+b+degParen)}}function scale(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push(pop(s)+"scale(",null,",",null,")");q.push({i:i-4,x:number(xa,xb)},{i:i-2,x:number(ya,yb)})}else if(xb!==1||yb!==1){s.push(pop(s)+"scale("+xb+","+yb+")")}}return function(a,b){var s=[],q=[];a=parse(a),b=parse(b);translate(a.translateX,a.translateY,b.translateX,b.translateY,s,q);rotate(a.rotate,b.rotate,s,q);skewX(a.skewX,b.skewX,s,q);scale(a.scaleX,a.scaleY,b.scaleX,b.scaleY,s,q);a=b=null;return function(t){var i=-1,n=q.length,o;while(++i<n)s[(o=q[i]).i]=o.x(t);return s.join("")}}}var interpolateTransformCss=interpolateTransform(parseCss,"px, ","px)","deg)");var interpolateTransformSvg=interpolateTransform(parseSvg,", ",")",")");var rho=Math.SQRT2,rho2=2,rho4=4,epsilon2=1e-12;function cosh(x){return((x=Math.exp(x))+1/x)/2}function sinh(x){return((x=Math.exp(x))-1/x)/2}function tanh(x){return((x=Math.exp(2*x))-1)/(x+1)}function zoom(p0,p1){var ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy,i,S;if(d2<epsilon2){S=Math.log(w1/w0)/rho;i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(rho*t*S)]}}else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+rho4*d2)/(2*w0*rho2*d1),b1=(w1*w1-w0*w0-rho4*d2)/(2*w1*rho2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/rho;i=function(t){var s=t*S,coshr0=cosh(r0),u=w0/(rho2*d1)*(coshr0*tanh(rho*s+r0)-sinh(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/cosh(rho*s+r0)]}}i.duration=S*1e3;return i}function hsl(hue){return function(start,end){var h=hue((start=d3Color.hsl(start)).h,(end=d3Color.hsl(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hsl$1=hsl(hue);var hslLong=hsl(nogamma);function lab(start,end){var l=nogamma((start=d3Color.lab(start)).l,(end=d3Color.lab(end)).l),a=nogamma(start.a,end.a),b=nogamma(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.l=l(t);start.a=a(t);start.b=b(t);start.opacity=opacity(t);return start+""}}function hcl(hue){return function(start,end){var h=hue((start=d3Color.hcl(start)).h,(end=d3Color.hcl(end)).h),c=nogamma(start.c,end.c),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.c=c(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hcl$1=hcl(hue);var hclLong=hcl(nogamma);function cubehelix(hue){return function cubehelixGamma(y){y=+y;function cubehelix(start,end){var h=hue((start=d3Color.cubehelix(start)).h,(end=d3Color.cubehelix(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(Math.pow(t,y));start.opacity=opacity(t);return start+""}}cubehelix.gamma=cubehelixGamma;return cubehelix}(1)}var cubehelix$1=cubehelix(hue);var cubehelixLong=cubehelix(nogamma);function piecewise(interpolate,values){var i=0,n=values.length-1,v=values[0],I=new Array(n<0?0:n);while(i<n)I[i]=interpolate(v,v=values[++i]);return function(t){var i=Math.max(0,Math.min(n-1,Math.floor(t*=n)));return I[i](t-i)}}function quantize(interpolator,n){var samples=new Array(n);for(var i=0;i<n;++i)samples[i]=interpolator(i/(n-1));return samples}exports.interpolate=value;exports.interpolateArray=array;exports.interpolateBasis=basis$1;exports.interpolateBasisClosed=basisClosed;exports.interpolateCubehelix=cubehelix$1;exports.interpolateCubehelixLong=cubehelixLong;exports.interpolateDate=date;exports.interpolateDiscrete=discrete;exports.interpolateHcl=hcl$1;exports.interpolateHclLong=hclLong;exports.interpolateHsl=hsl$1;exports.interpolateHslLong=hslLong;exports.interpolateHue=hue$1;exports.interpolateLab=lab;exports.interpolateNumber=number;exports.interpolateNumberArray=numberArray;exports.interpolateObject=object;exports.interpolateRgb=rgb;exports.interpolateRgbBasis=rgbBasis;exports.interpolateRgbBasisClosed=rgbBasisClosed;exports.interpolateRound=round;exports.interpolateString=string;exports.interpolateTransformCss=interpolateTransformCss;exports.interpolateTransformSvg=interpolateTransformSvg;exports.interpolateZoom=zoom;exports.piecewise=piecewise;exports.quantize=quantize;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;exports["default"]=mapToZero;function mapToZero(obj){var ret={};for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){ret[key]=0}}return ret}module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;exports["default"]=stepper;var reusedTuple=[0,0];function stepper(secondPerFrame,x,v,destX,k,b,precision){var Fspring=-k*(x-destX);var Fdamper=-b*v;var a=Fspring+Fdamper;var newV=v+a*secondPerFrame;var newX=x+newV*secondPerFrame;if(Math.abs(newV)<precision&&Math.abs(newX-destX)<precision){reusedTuple[0]=destX;reusedTuple[1]=0;return reusedTuple}reusedTuple[0]=newX;reusedTuple[1]=newV;return reusedTuple}module.exports=exports["default"]},function(module,exports,__webpack_require__){(function(process){(function(){var getNanoSeconds,hrtime,loadTime;if(typeof performance!=="undefined"&&performance!==null&&performance.now){module.exports=function(){return performance.now()}}else if(typeof process!=="undefined"&&process!==null&&process.hrtime){module.exports=function(){return(getNanoSeconds()-loadTime)/1e6};hrtime=process.hrtime;getNanoSeconds=function(){var hr;hr=hrtime();return hr[0]*1e9+hr[1]};loadTime=getNanoSeconds()}else if(Date.now){module.exports=function(){return Date.now()-loadTime};loadTime=Date.now()}else{module.exports=function(){return(new Date).getTime()-loadTime};loadTime=(new Date).getTime()}}).call(this)}).call(this,__webpack_require__(108))},function(module,exports,__webpack_require__){(function(global){var now=__webpack_require__(1357),root=typeof window==="undefined"?global:window,vendors=["moz","webkit"],suffix="AnimationFrame",raf=root["request"+suffix],caf=root["cancel"+suffix]||root["cancelRequest"+suffix];for(var i=0;!raf&&i<vendors.length;i++){raf=root[vendors[i]+"Request"+suffix];caf=root[vendors[i]+"Cancel"+suffix]||root[vendors[i]+"CancelRequest"+suffix]}if(!raf||!caf){var last=0,id=0,queue=[],frameDuration=1e3/60;raf=function(callback){if(queue.length===0){var _now=now(),next=Math.max(0,frameDuration-(_now-last));last=next+_now;setTimeout((function(){var cp=queue.slice(0);queue.length=0;for(var i=0;i<cp.length;i++){if(!cp[i].cancelled){try{cp[i].callback(last)}catch(e){setTimeout((function(){throw e}),0)}}}}),Math.round(next))}queue.push({handle:++id,callback:callback,cancelled:false});return id};caf=function(handle){for(var i=0;i<queue.length;i++){if(queue[i].handle===handle){queue[i].cancelled=true}}}}module.exports=function(fn){return raf.call(root,fn)};module.exports.cancel=function(){caf.apply(root,arguments)};module.exports.polyfill=function(object){if(!object){object=root}object.requestAnimationFrame=raf;object.cancelAnimationFrame=caf}}).call(this,__webpack_require__(71))},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;exports["default"]=shouldStopAnimation;function shouldStopAnimation(currentStyle,style,currentVelocity){for(var key in style){if(!Object.prototype.hasOwnProperty.call(style,key)){continue}if(currentVelocity[key]!==0){return false}var styleValue=typeof style[key]==="number"?style[key]:style[key].val;if(currentStyle[key]!==styleValue){return false}}return true}module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var React=__webpack_require__(2);var factory=__webpack_require__(1358);if(typeof React==="undefined"){throw Error("create-react-class could not find the React object. If you are using script tags, "+"make sure that React is being loaded before create-react-class.")}var ReactNoopUpdateQueue=(new React.Component).updater;module.exports=factory(React.Component,React.isValidElement,ReactNoopUpdateQueue)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _d3Shape=__webpack_require__(126);var d3Shape=_interopRequireWildcard(_d3Shape);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _theme=__webpack_require__(52);var _seriesUtils=__webpack_require__(56);var _reactUtils=__webpack_require__(107);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}else{var newObj={};if(obj!=null){for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key))newObj[key]=obj[key]}}newObj.default=obj;return newObj}}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--line";var STROKE_STYLES={dashed:"6, 2",solid:null};var LineSeries=function(_AbstractSeries){_inherits(LineSeries,_AbstractSeries);function LineSeries(){_classCallCheck(this,LineSeries);return _possibleConstructorReturn(this,(LineSeries.__proto__||Object.getPrototypeOf(LineSeries)).apply(this,arguments))}_createClass(LineSeries,[{key:"_renderLine",value:function _renderLine(data,x,y,curve,getNull){var line=d3Shape.line();if(curve!==null){if(typeof curve==="string"&&d3Shape[curve]){line=line.curve(d3Shape[curve])}else if(typeof curve==="function"){line=line.curve(curve)}}line=line.defined(getNull);line=line.x(x).y(y);return line(data)}},{key:"render",value:function render(){var _props=this.props,animation=_props.animation,className=_props.className,data=_props.data;if(this.props.nullAccessor){(0,_reactUtils.warning)("nullAccessor has been renamed to getNull",true)}if(!data){return null}if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS}),_react2.default.createElement(LineSeries,_extends({},this.props,{animation:null})))}var _props2=this.props,curve=_props2.curve,marginLeft=_props2.marginLeft,marginTop=_props2.marginTop,strokeDasharray=_props2.strokeDasharray,strokeStyle=_props2.strokeStyle,strokeWidth=_props2.strokeWidth,style=_props2.style;var x=this._getAttributeFunctor("x");var y=this._getAttributeFunctor("y");var stroke=this._getAttributeValue("stroke")||this._getAttributeValue("color");var newOpacity=this._getAttributeValue("opacity");var opacity=Number.isFinite(newOpacity)?newOpacity:_theme.DEFAULT_OPACITY;var getNull=this.props.nullAccessor||this.props.getNull;var d=this._renderLine(data,x,y,curve,getNull);return _react2.default.createElement("path",{d:d,className:predefinedClassName+" "+className,transform:"translate("+marginLeft+","+marginTop+")",onMouseOver:this._seriesMouseOverHandler,onMouseOut:this._seriesMouseOutHandler,onClick:this._seriesClickHandler,onContextMenu:this._seriesRightClickHandler,style:_extends({opacity:opacity,strokeDasharray:STROKE_STYLES[strokeStyle]||strokeDasharray,strokeWidth:strokeWidth,stroke:stroke},style)})}}]);return LineSeries}(_abstractSeries2.default);LineSeries.displayName="LineSeries";LineSeries.propTypes=_extends({},_abstractSeries2.default.propTypes,{strokeStyle:_propTypes2.default.oneOf(Object.keys(STROKE_STYLES)),curve:_propTypes2.default.oneOfType([_propTypes2.default.string,_propTypes2.default.func]),getNull:_propTypes2.default.func});LineSeries.defaultProps={strokeStyle:"solid",style:{},opacity:1,curve:null,className:"",getNull:function getNull(){return true}};exports.default=LineSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _seriesUtils=__webpack_require__(56);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--rect";var RectSeries=function(_AbstractSeries){_inherits(RectSeries,_AbstractSeries);function RectSeries(){_classCallCheck(this,RectSeries);return _possibleConstructorReturn(this,(RectSeries.__proto__||Object.getPrototypeOf(RectSeries)).apply(this,arguments))}_createClass(RectSeries,[{key:"render",value:function render(){var _this2=this;var _props=this.props,animation=_props.animation,className=_props.className,data=_props.data,linePosAttr=_props.linePosAttr,lineSizeAttr=_props.lineSizeAttr,marginLeft=_props.marginLeft,marginTop=_props.marginTop,style=_props.style,valuePosAttr=_props.valuePosAttr,valueSizeAttr=_props.valueSizeAttr;if(!data){return null}if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS}),_react2.default.createElement(RectSeries,_extends({},this.props,{animation:null})))}var lineFunctor=this._getAttributeFunctor(linePosAttr);var line0Functor=this._getAttr0Functor(linePosAttr);var valueFunctor=this._getAttributeFunctor(valuePosAttr);var value0Functor=this._getAttr0Functor(valuePosAttr);var fillFunctor=this._getAttributeFunctor("fill")||this._getAttributeFunctor("color");var strokeFunctor=this._getAttributeFunctor("stroke")||this._getAttributeFunctor("color");var opacityFunctor=this._getAttributeFunctor("opacity");return _react2.default.createElement("g",{className:predefinedClassName+" "+className,ref:"container",transform:"translate("+marginLeft+","+marginTop+")"},data.map((function(d,i){var _attrs;var attrs=(_attrs={style:_extends({opacity:opacityFunctor&&opacityFunctor(d),stroke:strokeFunctor&&strokeFunctor(d),fill:fillFunctor&&fillFunctor(d)},style)},_defineProperty(_attrs,linePosAttr,line0Functor(d)),_defineProperty(_attrs,lineSizeAttr,Math.abs(lineFunctor(d)-line0Functor(d))),_defineProperty(_attrs,valuePosAttr,Math.min(value0Functor(d),valueFunctor(d))),_defineProperty(_attrs,valueSizeAttr,Math.abs(-value0Functor(d)+valueFunctor(d))),_defineProperty(_attrs,"onClick",(function onClick(e){return _this2._valueClickHandler(d,e)})),_defineProperty(_attrs,"onContextMenu",(function onContextMenu(e){return _this2._valueRightClickHandler(d,e)})),_defineProperty(_attrs,"onMouseOver",(function onMouseOver(e){return _this2._valueMouseOverHandler(d,e)})),_defineProperty(_attrs,"onMouseOut",(function onMouseOut(e){return _this2._valueMouseOutHandler(d,e)})),_defineProperty(_attrs,"key",i),_attrs);return _react2.default.createElement("rect",attrs)})))}}],[{key:"propTypes",get:function get(){return _extends({},_abstractSeries2.default.propTypes,{linePosAttr:_propTypes2.default.string,valuePosAttr:_propTypes2.default.string,lineSizeAttr:_propTypes2.default.string,valueSizeAttr:_propTypes2.default.string})}}]);return RectSeries}(_abstractSeries2.default);RectSeries.displayName="RectSeries";exports.default=RectSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _d3Color=__webpack_require__(94);var _theme=__webpack_require__(52);var _scalesUtils=__webpack_require__(59);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RectSeriesCanvas=function(_AbstractSeries){_inherits(RectSeriesCanvas,_AbstractSeries);function RectSeriesCanvas(){_classCallCheck(this,RectSeriesCanvas);return _possibleConstructorReturn(this,(RectSeriesCanvas.__proto__||Object.getPrototypeOf(RectSeriesCanvas)).apply(this,arguments))}_createClass(RectSeriesCanvas,[{key:"render",value:function render(){return null}}],[{key:"renderLayer",value:function renderLayer(props,ctx){var data=props.data,linePosAttr=props.linePosAttr,lineSizeAttr=props.lineSizeAttr,marginLeft=props.marginLeft,marginTop=props.marginTop,valuePosAttr=props.valuePosAttr;if(!data||data.length===0){return}var line=(0,_scalesUtils.getAttributeFunctor)(props,linePosAttr);var line0=(0,_scalesUtils.getAttr0Functor)(props,linePosAttr);var value=(0,_scalesUtils.getAttributeFunctor)(props,valuePosAttr);var value0=(0,_scalesUtils.getAttr0Functor)(props,valuePosAttr);var fill=(0,_scalesUtils.getAttributeFunctor)(props,"fill")||(0,_scalesUtils.getAttributeFunctor)(props,"color");var stroke=(0,_scalesUtils.getAttributeFunctor)(props,"stroke")||(0,_scalesUtils.getAttributeFunctor)(props,"color");var opacity=(0,_scalesUtils.getAttributeFunctor)(props,"opacity");data.forEach((function(row){var fillColor=(0,_d3Color.rgb)(fill(row));var strokeColor=(0,_d3Color.rgb)(stroke(row));var rowOpacity=opacity(row)||_theme.DEFAULT_OPACITY;var linePos=line0(row);var valuePos=Math.min(value0(row),value(row));var x=valuePosAttr==="x"?valuePos:linePos;var y=valuePosAttr==="y"?valuePos:linePos;var lineSize=Math.abs(line(row)-line0(row));var valueSize=Math.abs(-value0(row)+value(row));var height=lineSizeAttr==="height"?lineSize:valueSize;var width=lineSizeAttr==="width"?lineSize:valueSize;ctx.beginPath();ctx.rect(x+marginLeft,y+marginTop,width,height);ctx.fillStyle="rgba("+fillColor.r+", "+fillColor.g+", "+fillColor.b+", "+rowOpacity+")";ctx.fill();ctx.strokeStyle="rgba("+strokeColor.r+", "+strokeColor.g+", "+strokeColor.b+", "+rowOpacity+")";ctx.stroke()}))}},{key:"requiresSVG",get:function get(){return false}},{key:"isCanvas",get:function get(){return true}}]);return RectSeriesCanvas}(_abstractSeries2.default);RectSeriesCanvas.displayName="RectSeriesCanvas";RectSeriesCanvas.defaultProps={linePosAttr:_propTypes2.default.string.isRequired,valuePosAttr:_propTypes2.default.string.isRequired,lineSizeAttr:_propTypes2.default.string.isRequired,valueSizeAttr:_propTypes2.default.string.isRequired};RectSeriesCanvas.propTypes=_extends({},_abstractSeries2.default.propTypes);exports.default=RectSeriesCanvas},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _seriesUtils=__webpack_require__(56);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--polygon";var DEFAULT_COLOR="#12939A";var generatePath=function generatePath(data,xFunctor,yFunctor){return data.reduce((function(res,row,i){return res+" "+(i?"L":"M")+xFunctor(row)+" "+yFunctor(row)}),"")+" Z"};var PolygonSeries=function(_AbstractSeries){_inherits(PolygonSeries,_AbstractSeries);function PolygonSeries(){_classCallCheck(this,PolygonSeries);return _possibleConstructorReturn(this,(PolygonSeries.__proto__||Object.getPrototypeOf(PolygonSeries)).apply(this,arguments))}_createClass(PolygonSeries,[{key:"render",value:function render(){var _props=this.props,animation=_props.animation,color=_props.color,className=_props.className,data=_props.data,marginLeft=_props.marginLeft,marginTop=_props.marginTop,style=_props.style;if(!data){return null}if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS}),_react2.default.createElement(PolygonSeries,_extends({},this.props,{animation:null})))}var xFunctor=this._getAttributeFunctor("x");var yFunctor=this._getAttributeFunctor("y");return _react2.default.createElement("path",{className:predefinedClassName+" "+className,onMouseOver:this._seriesMouseOverHandler,onMouseOut:this._seriesMouseOutHandler,onClick:this._seriesClickHandler,onContextMenu:this._seriesRightClickHandler,fill:color||DEFAULT_COLOR,style:style,d:generatePath(data,xFunctor,yFunctor),transform:"translate("+marginLeft+","+marginTop+")",ref:"container"})}}],[{key:"propTypes",get:function get(){return _extends({},_abstractSeries2.default.propTypes)}}]);return PolygonSeries}(_abstractSeries2.default);PolygonSeries.displayName="PolygonSeries";exports.default=PolygonSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _seriesUtils=__webpack_require__(56);var _reactUtils=__webpack_require__(107);var _theme=__webpack_require__(52);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--mark";var DEFAULT_STROKE_WIDTH=1;var MarkSeries=function(_AbstractSeries){_inherits(MarkSeries,_AbstractSeries);function MarkSeries(){_classCallCheck(this,MarkSeries);return _possibleConstructorReturn(this,(MarkSeries.__proto__||Object.getPrototypeOf(MarkSeries)).apply(this,arguments))}_createClass(MarkSeries,[{key:"_renderCircle",value:function _renderCircle(d,i,strokeWidth,style,scalingFunctions){var _this2=this;var fill=scalingFunctions.fill,opacity=scalingFunctions.opacity,size=scalingFunctions.size,stroke=scalingFunctions.stroke,x=scalingFunctions.x,y=scalingFunctions.y;var attrs={r:size?size(d):_theme.DEFAULT_SIZE,cx:x(d),cy:y(d),style:_extends({opacity:opacity?opacity(d):_theme.DEFAULT_OPACITY,stroke:stroke&&stroke(d),fill:fill&&fill(d),strokeWidth:strokeWidth||DEFAULT_STROKE_WIDTH},style),key:i,onClick:function onClick(e){return _this2._valueClickHandler(d,e)},onContextMenu:function onContextMenu(e){return _this2._valueRightClickHandler(d,e)},onMouseOver:function onMouseOver(e){return _this2._valueMouseOverHandler(d,e)},onMouseOut:function onMouseOut(e){return _this2._valueMouseOutHandler(d,e)}};return _react2.default.createElement("circle",attrs)}},{key:"render",value:function render(){var _this3=this;var _props=this.props,animation=_props.animation,className=_props.className,data=_props.data,marginLeft=_props.marginLeft,marginTop=_props.marginTop,strokeWidth=_props.strokeWidth,style=_props.style;if(this.props.nullAccessor){(0,_reactUtils.warning)("nullAccessor has been renamed to getNull",true)}var getNull=this.props.nullAccessor||this.props.getNull;if(!data){return null}if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS}),_react2.default.createElement(MarkSeries,_extends({},this.props,{animation:null})))}var scalingFunctions={fill:this._getAttributeFunctor("fill")||this._getAttributeFunctor("color"),opacity:this._getAttributeFunctor("opacity"),size:this._getAttributeFunctor("size"),stroke:this._getAttributeFunctor("stroke")||this._getAttributeFunctor("color"),x:this._getAttributeFunctor("x"),y:this._getAttributeFunctor("y")};return _react2.default.createElement("g",{className:predefinedClassName+" "+className,ref:"container",transform:"translate("+marginLeft+","+marginTop+")"},data.map((function(d,i){return getNull(d)&&_this3._renderCircle(d,i,strokeWidth,style,scalingFunctions)})))}}]);return MarkSeries}(_abstractSeries2.default);MarkSeries.displayName="MarkSeries";MarkSeries.propTypes=_extends({},_abstractSeries2.default.propTypes,{getNull:_propTypes2.default.func,strokeWidth:_propTypes2.default.number});MarkSeries.defaultProps={getNull:function getNull(){return true}};exports.default=MarkSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _seriesUtils=__webpack_require__(56);var _d3Shape=__webpack_require__(126);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);var _scalesUtils=__webpack_require__(59);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-plot__series rv-xy-plot__series--arc";var ATTRIBUTES=["radius","angle"];var defaultProps={center:{x:0,y:0},arcClassName:"",className:"",style:{}};function modifyRow(row){var radius=row.radius,angle=row.angle,angle0=row.angle0;var truedAngle=-1*angle+Math.PI/2;var truedAngle0=-1*angle0+Math.PI/2;return _extends({},row,{x:radius*Math.cos(truedAngle),y:radius*Math.sin(truedAngle),angle:truedAngle,angle0:truedAngle0})}var ArcSeries=function(_AbstractSeries){_inherits(ArcSeries,_AbstractSeries);function ArcSeries(props){_classCallCheck(this,ArcSeries);var _this=_possibleConstructorReturn(this,(ArcSeries.__proto__||Object.getPrototypeOf(ArcSeries)).call(this,props));var scaleProps=_this._getAllScaleProps(props);_this.state={scaleProps:scaleProps};return _this}_createClass(ArcSeries,[{key:"componentWillReceiveProps",value:function componentWillReceiveProps(nextProps){this.setState({scaleProps:this._getAllScaleProps(nextProps)})}},{key:"_getAllScaleProps",value:function _getAllScaleProps(props){var defaultScaleProps=this._getDefaultScaleProps(props);var userScaleProps=(0,_scalesUtils.extractScalePropsFromProps)(props,ATTRIBUTES);var missingScaleProps=(0,_scalesUtils.getMissingScaleProps)(_extends({},defaultScaleProps,userScaleProps),props.data,ATTRIBUTES);return _extends({},defaultScaleProps,userScaleProps,missingScaleProps)}},{key:"_getDefaultScaleProps",value:function _getDefaultScaleProps(props){var innerWidth=props.innerWidth,innerHeight=props.innerHeight;var radius=Math.min(innerWidth/2,innerHeight/2);return{radiusRange:[0,radius],_radiusValue:radius,angleType:"literal"}}},{key:"render",value:function render(){var _this2=this;var _props=this.props,arcClassName=_props.arcClassName,animation=_props.animation,className=_props.className,center=_props.center,data=_props.data,disableSeries=_props.disableSeries,hideSeries=_props.hideSeries,marginLeft=_props.marginLeft,marginTop=_props.marginTop,style=_props.style;if(!data){return null}if(animation){var cloneData=data.map((function(d){return _extends({},d)}));return _react2.default.createElement("g",{className:"rv-xy-plot__series--arc__animation-wrapper"},_react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:_seriesUtils.ANIMATED_SERIES_PROPS,data:cloneData}),_react2.default.createElement(ArcSeries,_extends({},this.props,{animation:null,disableSeries:true,data:cloneData}))),_react2.default.createElement(ArcSeries,_extends({},this.props,{animation:null,hideSeries:true,style:{stroke:"red"}})))}var scaleProps=this.state.scaleProps;var radiusDomain=scaleProps.radiusDomain;var radius=(0,_scalesUtils.getAttributeFunctor)(scaleProps,"radius");var radius0=(0,_scalesUtils.getAttr0Functor)(scaleProps,"radius");var angle=(0,_scalesUtils.getAttributeFunctor)(scaleProps,"angle");var angle0=(0,_scalesUtils.getAttr0Functor)(scaleProps,"angle");var fill=this._getAttributeFunctor("fill")||this._getAttributeFunctor("color");var stroke=this._getAttributeFunctor("stroke")||this._getAttributeFunctor("color");var opacity=this._getAttributeFunctor("opacity");var x=this._getAttributeFunctor("x");var y=this._getAttributeFunctor("y");return _react2.default.createElement("g",{className:predefinedClassName+" "+className,onMouseOver:this._seriesMouseOverHandler,onMouseOut:this._seriesMouseOutHandler,onClick:this._seriesClickHandler,onContextMenu:this._seriesRightClickHandler,ref:"container",opacity:hideSeries?0:1,pointerEvents:disableSeries?"none":"all",transform:"translate("+(marginLeft+x(center))+","+(marginTop+y(center))+")"},data.map((function(row,i){var noRadius=radiusDomain[1]===radiusDomain[0];var arcArg={innerRadius:noRadius?0:radius0(row),outerRadius:radius(row),startAngle:angle0(row)||0,endAngle:angle(row)};var arcedData=(0,_d3Shape.arc)();var rowStyle=row.style||{};var rowClassName=row.className||"";return _react2.default.createElement("path",{style:_extends({opacity:opacity&&opacity(row),stroke:stroke&&stroke(row),fill:fill&&fill(row)},style,rowStyle),onClick:function onClick(e){return _this2._valueClickHandler(modifyRow(row),e)},onContextMenu:function onContextMenu(e){return _this2._valueRightClickHandler(modifyRow(row),e)},onMouseOver:function onMouseOver(e){return _this2._valueMouseOverHandler(modifyRow(row),e)},onMouseOut:function onMouseOut(e){return _this2._valueMouseOutHandler(modifyRow(row),e)},key:i,className:predefinedClassName+"-path "+arcClassName+" "+rowClassName,d:arcedData(arcArg)})})))}}]);return ArcSeries}(_abstractSeries2.default);ArcSeries.propTypes=_extends({},_abstractSeries2.default.propTypes,(0,_scalesUtils.getScalePropTypesByAttribute)("radius"),(0,_scalesUtils.getScalePropTypesByAttribute)("angle"),{center:_propTypes2.default.shape({x:_propTypes2.default.number,y:_propTypes2.default.number}),arcClassName:_propTypes2.default.string});ArcSeries.defaultProps=defaultProps;ArcSeries.displayName="ArcSeries";exports.default=ArcSeries},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _d3Format=__webpack_require__(157);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _abstractSeries=__webpack_require__(43);var _abstractSeries2=_interopRequireDefault(_abstractSeries);var _decorativeAxisTicks=__webpack_require__(1387);var _decorativeAxisTicks2=_interopRequireDefault(_decorativeAxisTicks);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var predefinedClassName="rv-xy-manipulable-axis rv-xy-plot__axis";var animatedProps=["xRange","yRange","xDomain","yDomain","width","height","marginLeft","marginTop","marginRight","marginBottom","tickSize","tickTotal","tickSizeInner","tickSizeOuter"];var DecorativeAxis=function(_AbstractSeries){_inherits(DecorativeAxis,_AbstractSeries);function DecorativeAxis(){_classCallCheck(this,DecorativeAxis);return _possibleConstructorReturn(this,(DecorativeAxis.__proto__||Object.getPrototypeOf(DecorativeAxis)).apply(this,arguments))}_createClass(DecorativeAxis,[{key:"render",value:function render(){var _props=this.props,animation=_props.animation,className=_props.className,marginLeft=_props.marginLeft,marginTop=_props.marginTop,axisStart=_props.axisStart,axisEnd=_props.axisEnd,axisDomain=_props.axisDomain,numberOfTicks=_props.numberOfTicks,tickValue=_props.tickValue,tickSize=_props.tickSize,style=_props.style;if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:animatedProps}),_react2.default.createElement(DecorativeAxis,_extends({},this.props,{animation:null})))}var x=this._getAttributeFunctor("x");var y=this._getAttributeFunctor("y");return _react2.default.createElement("g",{className:predefinedClassName+" "+className,ref:"container",transform:"translate("+marginLeft+","+marginTop+")"},_react2.default.createElement("line",_extends({},_extends({x1:x({x:axisStart.x}),x2:x({x:axisEnd.x}),y1:y({y:axisStart.y}),y2:y({y:axisEnd.y})},style.line),{className:"rv-xy-plot__axis__line"})),_react2.default.createElement("g",{className:"rv-xy-manipulable-axis__ticks"},(0,_decorativeAxisTicks2.default)({axisDomain:axisDomain,axisEnd:{x:x(axisEnd),y:y(axisEnd)},axisStart:{x:x(axisStart),y:y(axisStart)},numberOfTicks:numberOfTicks,tickValue:tickValue,tickSize:tickSize,style:style})))}}]);return DecorativeAxis}(_abstractSeries2.default);var DEFAULT_FORMAT=(0,_d3Format.format)(".2r");DecorativeAxis.defaultProps={className:"",numberOfTicks:10,tickValue:function tickValue(d){return DEFAULT_FORMAT(d)},tickSize:5,style:{line:{strokeWidth:1},ticks:{strokeWidth:2},text:{}}};DecorativeAxis.propTypes=_extends({},_abstractSeries2.default.propTypes,{axisDomain:_propTypes2.default.arrayOf(_propTypes2.default.number).isRequired,axisEnd:_propTypes2.default.shape({x:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string]),y:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string])}).isRequired,axisStart:_propTypes2.default.shape({x:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string]),y:_propTypes2.default.oneOfType([_propTypes2.default.number,_propTypes2.default.string])}).isRequired,className:_propTypes2.default.string,numberOfTicks:_propTypes2.default.number,tickValue:_propTypes2.default.func,tickSize:_propTypes2.default.number,style:_propTypes2.default.shape({line:_propTypes2.default.object,ticks:_propTypes2.default.object,text:_propTypes2.default.object})});DecorativeAxis.displayName="DecorativeAxis";exports.default=DecorativeAxis},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _react=__webpack_require__(2);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(38);var _propTypes2=_interopRequireDefault(_propTypes);var _scalesUtils=__webpack_require__(59);var _animation=__webpack_require__(44);var _animation2=_interopRequireDefault(_animation);var _axisUtils=__webpack_require__(67);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var VERTICAL=_axisUtils.DIRECTION.VERTICAL,HORIZONTAL=_axisUtils.DIRECTION.HORIZONTAL;var propTypes={direction:_propTypes2.default.oneOf([VERTICAL,HORIZONTAL]),attr:_propTypes2.default.string.isRequired,width:_propTypes2.default.number,height:_propTypes2.default.number,top:_propTypes2.default.number,left:_propTypes2.default.number,style:_propTypes2.default.object,tickValues:_propTypes2.default.array,tickTotal:_propTypes2.default.number,animation:_animation.AnimationPropType,marginTop:_propTypes2.default.number,marginBottom:_propTypes2.default.number,marginLeft:_propTypes2.default.number,marginRight:_propTypes2.default.number,innerWidth:_propTypes2.default.number,innerHeight:_propTypes2.default.number};var defaultProps={direction:VERTICAL};var animatedProps=["xRange","yRange","xDomain","yDomain","width","height","marginLeft","marginTop","marginRight","marginBottom","tickTotal"];var GridLines=function(_PureComponent){_inherits(GridLines,_PureComponent);function GridLines(){_classCallCheck(this,GridLines);return _possibleConstructorReturn(this,(GridLines.__proto__||Object.getPrototypeOf(GridLines)).apply(this,arguments))}_createClass(GridLines,[{key:"_getDefaultProps",value:function _getDefaultProps(){var _props=this.props,innerWidth=_props.innerWidth,innerHeight=_props.innerHeight,marginTop=_props.marginTop,marginLeft=_props.marginLeft,direction=_props.direction;return{left:marginLeft,top:marginTop,width:innerWidth,height:innerHeight,tickTotal:(0,_axisUtils.getTicksTotalFromSize)(direction===VERTICAL?innerWidth:innerHeight)}}},{key:"render",value:function render(){var animation=this.props.animation;if(animation){return _react2.default.createElement(_animation2.default,_extends({},this.props,{animatedProps:animatedProps}),_react2.default.createElement(GridLines,_extends({},this.props,{animation:null})))}var props=_extends({},this._getDefaultProps(),this.props);var attr=props.attr,direction=props.direction,width=props.width,height=props.height,style=props.style,tickTotal=props.tickTotal,tickValues=props.tickValues,top=props.top,left=props.left;var isVertical=direction===VERTICAL;var tickXAttr=isVertical?"y":"x";var tickYAttr=isVertical?"x":"y";var length=isVertical?height:width;var scale=(0,_scalesUtils.getAttributeScale)(props,attr);var values=(0,_axisUtils.getTickValues)(scale,tickTotal,tickValues);return _react2.default.createElement("g",{transform:"translate("+left+","+top+")",className:"rv-xy-plot__grid-lines"},values.map((function(v,i){var _pathProps;var pos=scale(v);var pathProps=(_pathProps={},_defineProperty(_pathProps,tickYAttr+"1",pos),_defineProperty(_pathProps,tickYAttr+"2",pos),_defineProperty(_pathProps,tickXAttr+"1",0),_defineProperty(_pathProps,tickXAttr+"2",length),_pathProps);return _react2.default.createElement("line",_extends({},pathProps,{key:i,className:"rv-xy-plot__grid-lines__line",style:style}))})))}}]);return GridLines}(_react.PureComponent);GridLines.displayName="GridLines";GridLines.defaultProps=defaultProps;GridLines.propTypes=propTypes;GridLines.requiresSVG=true;exports.default=GridLines},,,function(module,exports,__webpack_require__){(function(global){var apply=Function.prototype.apply;exports.setTimeout=function(){return new Timeout(apply.call(setTimeout,window,arguments),clearTimeout)};exports.setInterval=function(){return new Timeout(apply.call(setInterval,window,arguments),clearInterval)};exports.clearTimeout=exports.clearInterval=function(timeout){if(timeout){timeout.close()}};function Timeout(id,clearFn){this._id=id;this._clearFn=clearFn}Timeout.prototype.unref=Timeout.prototype.ref=function(){};Timeout.prototype.close=function(){this._clearFn.call(window,this._id)};exports.enroll=function(item,msecs){clearTimeout(item._idleTimeoutId);item._idleTimeout=msecs};exports.unenroll=function(item){clearTimeout(item._idleTimeoutId);item._idleTimeout=-1};exports._unrefActive=exports.active=function(item){clearTimeout(item._idleTimeoutId);var msecs=item._idleTimeout;if(msecs>=0){item._idleTimeoutId=setTimeout((function onTimeout(){if(item._onTimeout)item._onTimeout()}),msecs)}};__webpack_require__(591);exports.setImmediate=typeof self!=="undefined"&&self.setImmediate||typeof global!=="undefined"&&global.setImmediate||this&&this.setImmediate;exports.clearImmediate=typeof self!=="undefined"&&self.clearImmediate||typeof global!=="undefined"&&global.clearImmediate||this&&this.clearImmediate}).call(this,__webpack_require__(71))},,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AnomalyDetectionJobsContext}));__webpack_require__.d(__webpack_exports__,"b",(function(){return AnomalyDetectionJobsContextProvider}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _hooks_use_fetcher__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(37);const AnomalyDetectionJobsContext=Object(react__WEBPACK_IMPORTED_MODULE_0__["createContext"])({});function AnomalyDetectionJobsContextProvider({children:children}){const[fetchId,setFetchId]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(0);const refetch=()=>setFetchId(id=>id+1);const{data:data,status:status}=Object(_hooks_use_fetcher__WEBPACK_IMPORTED_MODULE_1__["b"])(callApmApi=>callApmApi({endpoint:`GET /api/apm/settings/anomaly-detection/jobs`}),[fetchId],{showToastOnError:false});return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(AnomalyDetectionJobsContext.Provider,{value:{anomalyDetectionJobsData:data,anomalyDetectionJobsStatus:status,anomalyDetectionJobsRefetch:refetch}},children)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useKibanaUrl}));var url__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(86);var url__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(url__WEBPACK_IMPORTED_MODULE_0__);var _context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(39);function useKibanaUrl(path,hash){const{core:core}=Object(_context_apm_plugin_use_apm_plugin_context__WEBPACK_IMPORTED_MODULE_1__["a"])();return url__WEBPACK_IMPORTED_MODULE_0___default.a.format({pathname:core.http.basePath.prepend(path),hash:hash})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EnvironmentFilter}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var react_router_dom__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(11);var react_router_dom__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_3__);var _common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(54);var _hooks_use_environments_fetcher__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(111);var _context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(36);var _Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(42);function updateEnvironmentUrl(history,location,environment){const nextEnvironmentQueryParam=environment!==_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["a"].value?environment:undefined;history.push({...location,search:Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["b"])({...Object(_Links_url_helpers__WEBPACK_IMPORTED_MODULE_7__["e"])(location.search),environment:nextEnvironmentQueryParam})})}const SEPARATOR_OPTION={text:`- ${_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.apm.filter.environment.selectEnvironmentLabel",{defaultMessage:"Select environment"})} -`,disabled:true};function getOptions(environments){const environmentOptions=environments.filter(env=>env!==_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["b"].value).map(environment=>({value:environment,text:environment}));return[_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["a"],...environments.includes(_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["b"].value)?[_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["b"]]:[],...environmentOptions.length>0?[SEPARATOR_OPTION]:[],...environmentOptions]}function EnvironmentFilter(){const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useHistory"])();const location=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useLocation"])();const{serviceName:serviceName}=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useParams"])();const{urlParams:urlParams}=Object(_context_url_params_context_use_url_params__WEBPACK_IMPORTED_MODULE_6__["a"])();const{environment:environment,start:start,end:end}=urlParams;const{environments:environments,status:status="loading"}=Object(_hooks_use_environments_fetcher__WEBPACK_IMPORTED_MODULE_5__["a"])({serviceName:serviceName,start:start,end:end});const minWidth=200;return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiSelect"],{prepend:_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.apm.filter.environment.label",{defaultMessage:"Environment"}),options:getOptions(environments),value:environment||_common_environment_filter_values__WEBPACK_IMPORTED_MODULE_4__["a"].value,onChange:event=>{updateEnvironmentUrl(history,location,event.target.value)},isLoading:status==="loading",style:{minWidth:minWidth}})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function capitalizeString(string){return string.charAt(0).toUpperCase()+string.slice(1)}exports.default=capitalizeString;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _endsWith=__webpack_require__(639);var _endsWith2=_interopRequireDefault(_endsWith);var _stripUnit=__webpack_require__(170);var _stripUnit2=_interopRequireDefault(_stripUnit);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var pxtoFactory=function pxtoFactory(to){return function(pxval){var base=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"16px";var newPxval=pxval;var newBase=base;if(typeof pxval==="string"){if(!(0,_endsWith2.default)(pxval,"px")){throw new Error('Expected a string ending in "px" or a number passed as the first argument to '+to+'(), got "'+pxval+'" instead.')}newPxval=(0,_stripUnit2.default)(pxval)}if(typeof base==="string"){if(!(0,_endsWith2.default)(base,"px")){throw new Error('Expected a string ending in "px" or a number passed as the second argument to '+to+'(), got "'+base+'" instead.')}newBase=(0,_stripUnit2.default)(base)}if(typeof newPxval==="string"){throw new Error('Passed invalid pixel value ("'+pxval+'") to '+to+'(), please pass a value like "12px" or 12.')}if(typeof newBase==="string"){throw new Error('Passed invalid base value ("'+base+'") to '+to+'(), please pass a value like "12px" or 12.')}return""+newPxval/newBase+to}};exports.default=pxtoFactory;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hiDPI(){var ratio=arguments.length>0&&arguments[0]!==undefined?arguments[0]:1.3;return"\n    @media only screen and (-webkit-min-device-pixel-ratio: "+ratio+"),\n    only screen and (min--moz-device-pixel-ratio: "+ratio+"),\n    only screen and (-o-min-device-pixel-ratio: "+ratio+"/1),\n    only screen and (min-resolution: "+Math.round(ratio*96)+"dpi),\n    only screen and (min-resolution: "+ratio+"dppx)\n  "}exports.default=hiDPI;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var reduceHexValue=function reduceHexValue(value){if(value.length===7&&value[1]===value[2]&&value[3]===value[4]&&value[5]===value[6]){return"#"+value[1]+value[3]+value[5]}return value};exports.default=reduceHexValue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function numberToHex(value){var hex=value.toString(16);return hex.length===1?"0"+hex:hex}exports.default=numberToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(246);var _hslToHex2=_interopRequireDefault(_hslToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsl(value,saturation,lightness){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"){return(0,_hslToHex2.default)(value,saturation,lightness)}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined){return(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness)}throw new Error("Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).")}exports.default=hsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(171);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _reduceHexValue=__webpack_require__(243);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(244);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function colorToHex(color){return(0,_numberToHex2.default)(Math.round(color*255))}function convertToHex(red,green,blue){return(0,_reduceHexValue2.default)("#"+colorToHex(red)+colorToHex(green)+colorToHex(blue))}function hslToHex(hue,saturation,lightness){return(0,_hslToRgb2.default)(hue,saturation,lightness,convertToHex)}exports.default=hslToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(246);var _hslToHex2=_interopRequireDefault(_hslToHex);var _hslToRgb=__webpack_require__(171);var _hslToRgb2=_interopRequireDefault(_hslToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsla(value,saturation,lightness,alpha){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"&&typeof alpha==="number"){return alpha>=1?(0,_hslToHex2.default)(value,saturation,lightness):"rgba("+(0,_hslToRgb2.default)(value,saturation,lightness)+","+alpha+")"}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined&&alpha===undefined){return value.alpha>=1?(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness):"rgba("+(0,_hslToRgb2.default)(value.hue,value.saturation,value.lightness)+","+value.alpha+")"}throw new Error("Passed invalid arguments to hsla, please pass multiple numbers e.g. hsl(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).")}exports.default=hsla;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(78);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getLuminance(color){var rgbColor=(0,_parseToRgb2.default)(color);var _Object$keys$map=Object.keys(rgbColor).map((function(key){var channel=rgbColor[key]/255;return channel<=.03928?channel/12.92:Math.pow((channel+.055)/1.055,2.4)})),r=_Object$keys$map[0],g=_Object$keys$map[1],b=_Object$keys$map[2];return.2126*r+.7152*g+.0722*b}exports.default=getLuminance;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateSelectors(template,state){var stateSuffix=state?":"+state:"";return template(stateSuffix)}function statefulSelectors(states,template,stateMap){if(!template)throw new Error("You must provide a template to this method.");if(states.length===0)return generateSelectors(template,null);var selectors=[];for(var i=0;i<states.length;i+=1){if(stateMap&&stateMap.indexOf(states[i])<0){throw new Error("You passed an unsupported selector state to this method.")}selectors.push(generateSelectors(template,states[i]))}selectors=selectors.join(",");return selectors}exports.default=statefulSelectors;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(22);var react_1=__webpack_require__(2);var useRafState_1=tslib_1.__importDefault(__webpack_require__(687));var util_1=__webpack_require__(251);var useWindowSize=function(initialWidth,initialHeight){if(initialWidth===void 0){initialWidth=Infinity}if(initialHeight===void 0){initialHeight=Infinity}var _a=useRafState_1.default({width:util_1.isClient?window.innerWidth:initialWidth,height:util_1.isClient?window.innerHeight:initialHeight}),state=_a[0],setState=_a[1];react_1.useEffect((function(){if(util_1.isClient){var handler_1=function(){setState({width:window.innerWidth,height:window.innerHeight})};window.addEventListener("resize",handler_1);return function(){window.removeEventListener("resize",handler_1)}}}),[]);return state};exports.default=useWindowSize},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(22);var react_1=tslib_1.__importDefault(__webpack_require__(690));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(22);var react_1=__webpack_require__(2);var useTimeoutFn_1=tslib_1.__importDefault(__webpack_require__(691));function useDebounce(fn,ms,deps){if(ms===void 0){ms=0}if(deps===void 0){deps=[]}var _a=useTimeoutFn_1.default(fn,ms),isReady=_a[0],cancel=_a[1],reset=_a[2];react_1.useEffect(reset,deps);return[isReady,cancel]}exports.default=useDebounce},function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(55);Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"default",{enumerable:true,get:function get(){return _defaultHighlight.default}});Object.defineProperty(exports,"LightAsync",{enumerable:true,get:function get(){return _lightAsync.default}});Object.defineProperty(exports,"Light",{enumerable:true,get:function get(){return _light.default}});Object.defineProperty(exports,"PrismAsyncLight",{enumerable:true,get:function get(){return _prismAsyncLight.default}});Object.defineProperty(exports,"PrismAsync",{enumerable:true,get:function get(){return _prismAsync.default}});Object.defineProperty(exports,"PrismLight",{enumerable:true,get:function get(){return _prismLight.default}});Object.defineProperty(exports,"Prism",{enumerable:true,get:function get(){return _prism.default}});Object.defineProperty(exports,"createElement",{enumerable:true,get:function get(){return _createElement.default}});var _defaultHighlight=_interopRequireDefault(__webpack_require__(693));var _lightAsync=_interopRequireDefault(__webpack_require__(897));var _light=_interopRequireDefault(__webpack_require__(1093));var _prismAsyncLight=_interopRequireDefault(__webpack_require__(1094));var _prismAsync=_interopRequireDefault(__webpack_require__(1121));var _prismLight=_interopRequireDefault(__webpack_require__(1122));var _prism=_interopRequireDefault(__webpack_require__(1123));var _createElement=_interopRequireDefault(__webpack_require__(257))},function(module,exports){function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++){arr2[i]=arr[i]}return arr2}module.exports=_arrayLikeToArray},function(module,exports,__webpack_require__){var defineProperty=__webpack_require__(256);function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?Object(arguments[i]):{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter((function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable})))}ownKeys.forEach((function(key){defineProperty(target,key,source[key])}))}return target}module.exports=_objectSpread},function(module,exports){function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}module.exports=_defineProperty},function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(55);Object.defineProperty(exports,"__esModule",{value:true});exports.createStyleObject=createStyleObject;exports.createClassNameString=createClassNameString;exports.createChildren=createChildren;exports.default=createElement;var _extends2=_interopRequireDefault(__webpack_require__(258));var _objectSpread2=_interopRequireDefault(__webpack_require__(255));var _react=_interopRequireDefault(__webpack_require__(2));function powerSetPermutations(arr){var arrLength=arr.length;if(arrLength===0||arrLength===1)return arr;if(arrLength===2){return[arr[0],arr[1],"".concat(arr[0],".").concat(arr[1]),"".concat(arr[1],".").concat(arr[0])]}if(arrLength===3){return[arr[0],arr[1],arr[2],"".concat(arr[0],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[0]),"".concat(arr[1],".").concat(arr[2]),"".concat(arr[2],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[1],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[2],".").concat(arr[1]),"".concat(arr[1],".").concat(arr[0],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[2],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[0],".").concat(arr[1]),"".concat(arr[2],".").concat(arr[1],".").concat(arr[0])]}if(arrLength>=4){return[arr[0],arr[1],arr[2],arr[3],"".concat(arr[0],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[3]),"".concat(arr[1],".").concat(arr[0]),"".concat(arr[1],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[3]),"".concat(arr[2],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[1]),"".concat(arr[2],".").concat(arr[3]),"".concat(arr[3],".").concat(arr[0]),"".concat(arr[3],".").concat(arr[1]),"".concat(arr[3],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[1],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[1],".").concat(arr[3]),"".concat(arr[0],".").concat(arr[2],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[2],".").concat(arr[3]),"".concat(arr[0],".").concat(arr[3],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[3],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[0],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[0],".").concat(arr[3]),"".concat(arr[1],".").concat(arr[2],".").concat(arr[0]),"".concat(arr[1],".").concat(arr[2],".").concat(arr[3]),"".concat(arr[1],".").concat(arr[3],".").concat(arr[0]),"".concat(arr[1],".").concat(arr[3],".").concat(arr[2]),"".concat(arr[2],".").concat(arr[0],".").concat(arr[1]),"".concat(arr[2],".").concat(arr[0],".").concat(arr[3]),"".concat(arr[2],".").concat(arr[1],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[1],".").concat(arr[3]),"".concat(arr[2],".").concat(arr[3],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[3],".").concat(arr[1]),"".concat(arr[3],".").concat(arr[0],".").concat(arr[1]),"".concat(arr[3],".").concat(arr[0],".").concat(arr[2]),"".concat(arr[3],".").concat(arr[1],".").concat(arr[0]),"".concat(arr[3],".").concat(arr[1],".").concat(arr[2]),"".concat(arr[3],".").concat(arr[2],".").concat(arr[0]),"".concat(arr[3],".").concat(arr[2],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[1],".").concat(arr[2],".").concat(arr[3]),"".concat(arr[0],".").concat(arr[1],".").concat(arr[3],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[2],".").concat(arr[1],".").concat(arr[3]),"".concat(arr[0],".").concat(arr[2],".").concat(arr[3],".").concat(arr[1]),"".concat(arr[0],".").concat(arr[3],".").concat(arr[1],".").concat(arr[2]),"".concat(arr[0],".").concat(arr[3],".").concat(arr[2],".").concat(arr[1]),"".concat(arr[1],".").concat(arr[0],".").concat(arr[2],".").concat(arr[3]),"".concat(arr[1],".").concat(arr[0],".").concat(arr[3],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[2],".").concat(arr[0],".").concat(arr[3]),"".concat(arr[1],".").concat(arr[2],".").concat(arr[3],".").concat(arr[0]),"".concat(arr[1],".").concat(arr[3],".").concat(arr[0],".").concat(arr[2]),"".concat(arr[1],".").concat(arr[3],".").concat(arr[2],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[0],".").concat(arr[1],".").concat(arr[3]),"".concat(arr[2],".").concat(arr[0],".").concat(arr[3],".").concat(arr[1]),"".concat(arr[2],".").concat(arr[1],".").concat(arr[0],".").concat(arr[3]),"".concat(arr[2],".").concat(arr[1],".").concat(arr[3],".").concat(arr[0]),"".concat(arr[2],".").concat(arr[3],".").concat(arr[0],".").concat(arr[1]),"".concat(arr[2],".").concat(arr[3],".").concat(arr[1],".").concat(arr[0]),"".concat(arr[3],".").concat(arr[0],".").concat(arr[1],".").concat(arr[2]),"".concat(arr[3],".").concat(arr[0],".").concat(arr[2],".").concat(arr[1]),"".concat(arr[3],".").concat(arr[1],".").concat(arr[0],".").concat(arr[2]),"".concat(arr[3],".").concat(arr[1],".").concat(arr[2],".").concat(arr[0]),"".concat(arr[3],".").concat(arr[2],".").concat(arr[0],".").concat(arr[1]),"".concat(arr[3],".").concat(arr[2],".").concat(arr[1],".").concat(arr[0])]}}var classNameCombinations={};function getClassNameCombinations(classNames){if(classNames.length===0||classNames.length===1)return classNames;var key=classNames.join(".");if(!classNameCombinations[key]){classNameCombinations[key]=powerSetPermutations(classNames)}return classNameCombinations[key]}function createStyleObject(classNames){var elementStyle=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var stylesheet=arguments.length>2?arguments[2]:undefined;var nonTokenClassNames=classNames.filter((function(className){return className!=="token"}));var classNamesCombinations=getClassNameCombinations(nonTokenClassNames);return classNamesCombinations.reduce((function(styleObject,className){return(0,_objectSpread2.default)({},styleObject,stylesheet[className])}),elementStyle)}function createClassNameString(classNames){return classNames.join(" ")}function createChildren(stylesheet,useInlineStyles){var childrenCount=0;return function(children){childrenCount+=1;return children.map((function(child,i){return createElement({node:child,stylesheet:stylesheet,useInlineStyles:useInlineStyles,key:"code-segment-".concat(childrenCount,"-").concat(i)})}))}}function createElement(_ref){var node=_ref.node,stylesheet=_ref.stylesheet,_ref$style=_ref.style,style=_ref$style===void 0?{}:_ref$style,useInlineStyles=_ref.useInlineStyles,key=_ref.key;var properties=node.properties,type=node.type,TagName=node.tagName,value=node.value;if(type==="text"){return value}else if(TagName){var childrenCreator=createChildren(stylesheet,useInlineStyles);var props;if(!useInlineStyles){props=(0,_objectSpread2.default)({},properties,{className:createClassNameString(properties.className)})}else{var allStylesheetSelectors=Object.keys(stylesheet).reduce((function(classes,selector){selector.split(".").forEach((function(className){if(!classes.includes(className))classes.push(className)}));return classes}),[]);var startingClassName=properties.className&&properties.className.includes("token")?["token"]:[];var className=properties.className&&startingClassName.concat(properties.className.filter((function(className){return!allStylesheetSelectors.includes(className)})));props=(0,_objectSpread2.default)({},properties,{className:createClassNameString(className)||undefined,style:createStyleObject(properties.className,Object.assign({},properties.style,style),stylesheet)})}var children=childrenCreator(node.children);return _react.default.createElement(TagName,(0,_extends2.default)({key:key},props),children)}}},function(module,exports){function _extends(){module.exports=_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}module.exports=_extends},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _default=function _default(astGenerator,language){var langs=astGenerator.listLanguages();return langs.indexOf(language)!==-1};exports.default=_default},function(module,exports,__webpack_require__){module.exports=__webpack_require__(898)},function(module,exports){function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{Promise.resolve(value).then(_next,_throw)}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise((function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value)}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err)}_next(undefined)}))}}module.exports=_asyncToGenerator},function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(55);Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _regenerator=_interopRequireDefault(__webpack_require__(260));var _asyncToGenerator2=_interopRequireDefault(__webpack_require__(261));var _default=function _default(name,loader){return function(){var _ref=(0,_asyncToGenerator2.default)(_regenerator.default.mark((function _callee(registerLanguage){var module;return _regenerator.default.wrap((function _callee$(_context){while(1){switch(_context.prev=_context.next){case 0:_context.next=2;return loader();case 2:module=_context.sent;registerLanguage(name,module.default||module);case 4:case"end":return _context.stop()}}}),_callee,this)})));return function(_x){return _ref.apply(this,arguments)}}()};exports.default=_default},function(module,exports){const IDENT_RE="[A-Za-z$_][0-9A-Za-z$_]*";const KEYWORDS=["as","in","of","if","for","while","finally","var","new","function","do","return","void","else","break","catch","instanceof","with","throw","case","default","try","switch","continue","typeof","delete","let","yield","const","class","debugger","async","await","static","import","from","export","extends"];const LITERALS=["true","false","null","undefined","NaN","Infinity"];const TYPES=["Intl","DataView","Number","Math","Date","String","RegExp","Object","Function","Boolean","Error","Symbol","Set","Map","WeakSet","WeakMap","Proxy","Reflect","JSON","Promise","Float64Array","Int16Array","Int32Array","Int8Array","Uint16Array","Uint32Array","Float32Array","Array","Uint8Array","Uint8ClampedArray","ArrayBuffer"];const ERROR_TYPES=["EvalError","InternalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"];const BUILT_IN_GLOBALS=["setInterval","setTimeout","clearInterval","clearTimeout","require","exports","eval","isFinite","isNaN","parseFloat","parseInt","decodeURI","decodeURIComponent","encodeURI","encodeURIComponent","escape","unescape"];const BUILT_IN_VARIABLES=["arguments","this","super","console","window","document","localStorage","module","global"];const BUILT_INS=[].concat(BUILT_IN_GLOBALS,BUILT_IN_VARIABLES,TYPES,ERROR_TYPES);function source(re){if(!re)return null;if(typeof re==="string")return re;return re.source}function lookahead(re){return concat("(?=",re,")")}function concat(...args){const joined=args.map(x=>source(x)).join("");return joined}function javascript(hljs){const hasClosingTag=(match,{after:after})=>{const tag="</"+match[0].slice(1);const pos=match.input.indexOf(tag,after);return pos!==-1};const IDENT_RE$1=IDENT_RE;const FRAGMENT={begin:"<>",end:"</>"};const XML_TAG={begin:/<[A-Za-z0-9\\._:-]+/,end:/\/[A-Za-z0-9\\._:-]+>|\/>/,isTrulyOpeningTag:(match,response)=>{const afterMatchIndex=match[0].length+match.index;const nextChar=match.input[afterMatchIndex];if(nextChar==="<"){response.ignoreMatch();return}if(nextChar===">"){if(!hasClosingTag(match,{after:afterMatchIndex})){response.ignoreMatch()}}}};const KEYWORDS$1={$pattern:IDENT_RE,keyword:KEYWORDS.join(" "),literal:LITERALS.join(" "),built_in:BUILT_INS.join(" ")};const decimalDigits="[0-9](_?[0-9])*";const frac=`\\.(${decimalDigits})`;const decimalInteger=`0|[1-9](_?[0-9])*|0[0-7]*[89][0-9]*`;const NUMBER={className:"number",variants:[{begin:`(\\b(${decimalInteger})((${frac})|\\.)?|(${frac}))`+`[eE][+-]?(${decimalDigits})\\b`},{begin:`\\b(${decimalInteger})\\b((${frac})\\b|\\.)?|(${frac})\\b`},{begin:`\\b(0|[1-9](_?[0-9])*)n\\b`},{begin:"\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*n?\\b"},{begin:"\\b0[bB][0-1](_?[0-1])*n?\\b"},{begin:"\\b0[oO][0-7](_?[0-7])*n?\\b"},{begin:"\\b0[0-7]+n?\\b"}],relevance:0};const SUBST={className:"subst",begin:"\\$\\{",end:"\\}",keywords:KEYWORDS$1,contains:[]};const HTML_TEMPLATE={begin:"html`",end:"",starts:{end:"`",returnEnd:false,contains:[hljs.BACKSLASH_ESCAPE,SUBST],subLanguage:"xml"}};const CSS_TEMPLATE={begin:"css`",end:"",starts:{end:"`",returnEnd:false,contains:[hljs.BACKSLASH_ESCAPE,SUBST],subLanguage:"css"}};const TEMPLATE_STRING={className:"string",begin:"`",end:"`",contains:[hljs.BACKSLASH_ESCAPE,SUBST]};const JSDOC_COMMENT=hljs.COMMENT("/\\*\\*","\\*/",{relevance:0,contains:[{className:"doctag",begin:"@[A-Za-z]+",contains:[{className:"type",begin:"\\{",end:"\\}",relevance:0},{className:"variable",begin:IDENT_RE$1+"(?=\\s*(-)|$)",endsParent:true,relevance:0},{begin:/(?=[^\n])\s/,relevance:0}]}]});const COMMENT={className:"comment",variants:[JSDOC_COMMENT,hljs.C_BLOCK_COMMENT_MODE,hljs.C_LINE_COMMENT_MODE]};const SUBST_INTERNALS=[hljs.APOS_STRING_MODE,hljs.QUOTE_STRING_MODE,HTML_TEMPLATE,CSS_TEMPLATE,TEMPLATE_STRING,NUMBER,hljs.REGEXP_MODE];SUBST.contains=SUBST_INTERNALS.concat({begin:/\{/,end:/\}/,keywords:KEYWORDS$1,contains:["self"].concat(SUBST_INTERNALS)});const SUBST_AND_COMMENTS=[].concat(COMMENT,SUBST.contains);const PARAMS_CONTAINS=SUBST_AND_COMMENTS.concat([{begin:/\(/,end:/\)/,keywords:KEYWORDS$1,contains:["self"].concat(SUBST_AND_COMMENTS)}]);const PARAMS={className:"params",begin:/\(/,end:/\)/,excludeBegin:true,excludeEnd:true,keywords:KEYWORDS$1,contains:PARAMS_CONTAINS};return{name:"Javascript",aliases:["js","jsx","mjs","cjs"],keywords:KEYWORDS$1,exports:{PARAMS_CONTAINS:PARAMS_CONTAINS},illegal:/#(?![$_A-z])/,contains:[hljs.SHEBANG({label:"shebang",binary:"node",relevance:5}),{label:"use_strict",className:"meta",relevance:10,begin:/^\s*['"]use (strict|asm)['"]/},hljs.APOS_STRING_MODE,hljs.QUOTE_STRING_MODE,HTML_TEMPLATE,CSS_TEMPLATE,TEMPLATE_STRING,COMMENT,NUMBER,{begin:concat(/[{,\n]\s*/,lookahead(concat(/(((\/\/.*$)|(\/\*(\*[^/]|[^*])*\*\/))\s*)*/,IDENT_RE$1+"\\s*:"))),relevance:0,contains:[{className:"attr",begin:IDENT_RE$1+lookahead("\\s*:"),relevance:0}]},{begin:"("+hljs.RE_STARTERS_RE+"|\\b(case|return|throw)\\b)\\s*",keywords:"return throw case",contains:[COMMENT,hljs.REGEXP_MODE,{className:"function",begin:"(\\("+"[^()]*(\\("+"[^()]*(\\("+"[^()]*"+"\\)[^()]*)*"+"\\)[^()]*)*"+"\\)|"+hljs.UNDERSCORE_IDENT_RE+")\\s*=>",returnBegin:true,end:"\\s*=>",contains:[{className:"params",variants:[{begin:hljs.UNDERSCORE_IDENT_RE,relevance:0},{className:null,begin:/\(\s*\)/,skip:true},{begin:/\(/,end:/\)/,excludeBegin:true,excludeEnd:true,keywords:KEYWORDS$1,contains:PARAMS_CONTAINS}]}]},{begin:/,/,relevance:0},{className:"",begin:/\s/,end:/\s*/,skip:true},{variants:[{begin:FRAGMENT.begin,end:FRAGMENT.end},{begin:XML_TAG.begin,"on:begin":XML_TAG.isTrulyOpeningTag,end:XML_TAG.end}],subLanguage:"xml",contains:[{begin:XML_TAG.begin,end:XML_TAG.end,skip:true,contains:["self"]}]}],relevance:0},{className:"function",beginKeywords:"function",end:/[{;]/,excludeEnd:true,keywords:KEYWORDS$1,contains:["self",hljs.inherit(hljs.TITLE_MODE,{begin:IDENT_RE$1}),PARAMS],illegal:/%/},{beginKeywords:"while if switch catch for"},{className:"function",begin:hljs.UNDERSCORE_IDENT_RE+"\\("+"[^()]*(\\("+"[^()]*(\\("+"[^()]*"+"\\)[^()]*)*"+"\\)[^()]*)*"+"\\)\\s*\\{",returnBegin:true,contains:[PARAMS,hljs.inherit(hljs.TITLE_MODE,{begin:IDENT_RE$1})]},{variants:[{begin:"\\."+IDENT_RE$1},{begin:"\\$"+IDENT_RE$1}],relevance:0},{className:"class",beginKeywords:"class",end:/[{;=]/,excludeEnd:true,illegal:/[:"[\]]/,contains:[{beginKeywords:"extends"},hljs.UNDERSCORE_TITLE_MODE]},{begin:/\b(?=constructor)/,end:/[{;]/,excludeEnd:true,contains:[hljs.inherit(hljs.TITLE_MODE,{begin:IDENT_RE$1}),"self",PARAMS]},{begin:"(get|set)\\s+(?="+IDENT_RE$1+"\\()",end:/\{/,keywords:"get set",contains:[hljs.inherit(hljs.TITLE_MODE,{begin:IDENT_RE$1}),{begin:/\(\)/},PARAMS]},{begin:/\$[(.]/}]}}module.exports=javascript},function(module,exports){function python(hljs){const RESERVED_WORDS=["and","as","assert","async","await","break","class","continue","def","del","elif","else","except","finally","for","","from","global","if","import","in","is","lambda","nonlocal|10","not","or","pass","raise","return","try","while","with","yield"];const BUILT_INS=["__import__","abs","all","any","ascii","bin","bool","breakpoint","bytearray","bytes","callable","chr","classmethod","compile","complex","delattr","dict","dir","divmod","enumerate","eval","exec","filter","float","format","frozenset","getattr","globals","hasattr","hash","help","hex","id","input","int","isinstance","issubclass","iter","len","list","locals","map","max","memoryview","min","next","object","oct","open","ord","pow","print","property","range","repr","reversed","round","set","setattr","slice","sorted","staticmethod","str","sum","super","tuple","type","vars","zip"];const LITERALS=["__debug__","Ellipsis","False","None","NotImplemented","True"];const KEYWORDS={keyword:RESERVED_WORDS.join(" "),built_in:BUILT_INS.join(" "),literal:LITERALS.join(" ")};const PROMPT={className:"meta",begin:/^(>>>|\.\.\.) /};const SUBST={className:"subst",begin:/\{/,end:/\}/,keywords:KEYWORDS,illegal:/#/};const LITERAL_BRACKET={begin:/\{\{/,relevance:0};const STRING={className:"string",contains:[hljs.BACKSLASH_ESCAPE],variants:[{begin:/([uU]|[bB]|[rR]|[bB][rR]|[rR][bB])?'''/,end:/'''/,contains:[hljs.BACKSLASH_ESCAPE,PROMPT],relevance:10},{begin:/([uU]|[bB]|[rR]|[bB][rR]|[rR][bB])?"""/,end:/"""/,contains:[hljs.BACKSLASH_ESCAPE,PROMPT],relevance:10},{begin:/([fF][rR]|[rR][fF]|[fF])'''/,end:/'''/,contains:[hljs.BACKSLASH_ESCAPE,PROMPT,LITERAL_BRACKET,SUBST]},{begin:/([fF][rR]|[rR][fF]|[fF])"""/,end:/"""/,contains:[hljs.BACKSLASH_ESCAPE,PROMPT,LITERAL_BRACKET,SUBST]},{begin:/([uU]|[rR])'/,end:/'/,relevance:10},{begin:/([uU]|[rR])"/,end:/"/,relevance:10},{begin:/([bB]|[bB][rR]|[rR][bB])'/,end:/'/},{begin:/([bB]|[bB][rR]|[rR][bB])"/,end:/"/},{begin:/([fF][rR]|[rR][fF]|[fF])'/,end:/'/,contains:[hljs.BACKSLASH_ESCAPE,LITERAL_BRACKET,SUBST]},{begin:/([fF][rR]|[rR][fF]|[fF])"/,end:/"/,contains:[hljs.BACKSLASH_ESCAPE,LITERAL_BRACKET,SUBST]},hljs.APOS_STRING_MODE,hljs.QUOTE_STRING_MODE]};const digitpart="[0-9](_?[0-9])*";const pointfloat=`(\\b(${digitpart}))?\\.(${digitpart})|\\b(${digitpart})\\.`;const NUMBER={className:"number",relevance:0,variants:[{begin:`(\\b(${digitpart})|(${pointfloat}))[eE][+-]?(${digitpart})[jJ]?\\b`},{begin:`(${pointfloat})[jJ]?`},{begin:"\\b([1-9](_?[0-9])*|0+(_?0)*)[lLjJ]?\\b"},{begin:"\\b0[bB](_?[01])+[lL]?\\b"},{begin:"\\b0[oO](_?[0-7])+[lL]?\\b"},{begin:"\\b0[xX](_?[0-9a-fA-F])+[lL]?\\b"},{begin:`\\b(${digitpart})[jJ]\\b`}]};const PARAMS={className:"params",variants:[{begin:/\(\s*\)/,skip:true,className:null},{begin:/\(/,end:/\)/,excludeBegin:true,excludeEnd:true,keywords:KEYWORDS,contains:["self",PROMPT,NUMBER,STRING,hljs.HASH_COMMENT_MODE]}]};SUBST.contains=[STRING,NUMBER,PROMPT];return{name:"Python",aliases:["py","gyp","ipython"],keywords:KEYWORDS,illegal:/(<\/|->|\?)|=>/,contains:[PROMPT,NUMBER,{begin:/\bself\b/},{beginKeywords:"if",relevance:0},STRING,hljs.HASH_COMMENT_MODE,{variants:[{className:"function",beginKeywords:"def"},{className:"class",beginKeywords:"class"}],end:/:/,illegal:/[${=;\n,]/,contains:[hljs.UNDERSCORE_TITLE_MODE,PARAMS,{begin:/->/,endsWithParent:true,keywords:"None"}]},{className:"meta",begin:/^[\t ]*@/,end:/(?=#)|$/,contains:[NUMBER,PARAMS,STRING]},{begin:/\b(print|exec)\(/}]}}module.exports=python},function(module,exports){function source(re){if(!re)return null;if(typeof re==="string")return re;return re.source}function lookahead(re){return concat("(?=",re,")")}function concat(...args){const joined=args.map(x=>source(x)).join("");return joined}function ruby(hljs){var RUBY_METHOD_RE="([a-zA-Z_]\\w*[!?=]?|[-+~]@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?)";var RUBY_KEYWORDS={keyword:"and then defined module in return redo if BEGIN retry end for self when "+"next until do begin unless END rescue else break undef not super class case "+"require yield alias while ensure elsif or include attr_reader attr_writer attr_accessor "+"__FILE__",built_in:"proc lambda",literal:"true false nil"};var YARDOCTAG={className:"doctag",begin:"@[A-Za-z]+"};var IRB_OBJECT={begin:"#<",end:">"};var COMMENT_MODES=[hljs.COMMENT("#","$",{contains:[YARDOCTAG]}),hljs.COMMENT("^=begin","^=end",{contains:[YARDOCTAG],relevance:10}),hljs.COMMENT("^__END__","\\n$")];var SUBST={className:"subst",begin:/#\{/,end:/\}/,keywords:RUBY_KEYWORDS};var STRING={className:"string",contains:[hljs.BACKSLASH_ESCAPE,SUBST],variants:[{begin:/'/,end:/'/},{begin:/"/,end:/"/},{begin:/`/,end:/`/},{begin:/%[qQwWx]?\(/,end:/\)/},{begin:/%[qQwWx]?\[/,end:/\]/},{begin:/%[qQwWx]?\{/,end:/\}/},{begin:/%[qQwWx]?</,end:/>/},{begin:/%[qQwWx]?\//,end:/\//},{begin:/%[qQwWx]?%/,end:/%/},{begin:/%[qQwWx]?-/,end:/-/},{begin:/%[qQwWx]?\|/,end:/\|/},{begin:/\B\?(\\\d{1,3}|\\x[A-Fa-f0-9]{1,2}|\\u[A-Fa-f0-9]{4}|\\?\S)\b/},{begin:/<<[-~]?'?(\w+)\n(?:[^\n]*\n)*?\s*\1\b/,returnBegin:true,contains:[{begin:/<<[-~]?'?/},hljs.END_SAME_AS_BEGIN({begin:/(\w+)/,end:/(\w+)/,contains:[hljs.BACKSLASH_ESCAPE,SUBST]})]}]};var decimal="[1-9](_?[0-9])*|0";var digits="[0-9](_?[0-9])*";var NUMBER={className:"number",relevance:0,variants:[{begin:`\\b(${decimal})(\\.(${digits}))?([eE][+-]?(${digits})|r)?i?\\b`},{begin:"\\b0[dD][0-9](_?[0-9])*r?i?\\b"},{begin:"\\b0[bB][0-1](_?[0-1])*r?i?\\b"},{begin:"\\b0[oO][0-7](_?[0-7])*r?i?\\b"},{begin:"\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*r?i?\\b"},{begin:"\\b0(_?[0-7])+r?i?\\b"}]};var PARAMS={className:"params",begin:"\\(",end:"\\)",endsParent:true,keywords:RUBY_KEYWORDS};var RUBY_DEFAULT_CONTAINS=[STRING,{className:"class",beginKeywords:"class module",end:"$|;",illegal:/=/,contains:[hljs.inherit(hljs.TITLE_MODE,{begin:"[A-Za-z_]\\w*(::\\w+)*(\\?|!)?"}),{begin:"<\\s*",contains:[{begin:"("+hljs.IDENT_RE+"::)?"+hljs.IDENT_RE}]}].concat(COMMENT_MODES)},{className:"function",begin:concat(/def\s*/,lookahead(RUBY_METHOD_RE+"\\s*(\\(|;|$)")),keywords:"def",end:"$|;",contains:[hljs.inherit(hljs.TITLE_MODE,{begin:RUBY_METHOD_RE}),PARAMS].concat(COMMENT_MODES)},{begin:hljs.IDENT_RE+"::"},{className:"symbol",begin:hljs.UNDERSCORE_IDENT_RE+"(!|\\?)?:",relevance:0},{className:"symbol",begin:":(?!\\s)",contains:[STRING,{begin:RUBY_METHOD_RE}],relevance:0},NUMBER,{className:"variable",begin:"(\\$\\W)|((\\$|@@?)(\\w+))(?=[^@$?])"+`(?![A-Za-z])(?![@$?'])`},{className:"params",begin:/\|/,end:/\|/,relevance:0,keywords:RUBY_KEYWORDS},{begin:"("+hljs.RE_STARTERS_RE+"|unless)\\s*",keywords:"unless",contains:[{className:"regexp",contains:[hljs.BACKSLASH_ESCAPE,SUBST],illegal:/\n/,variants:[{begin:"/",end:"/[a-z]*"},{begin:/%r\{/,end:/\}[a-z]*/},{begin:"%r\\(",end:"\\)[a-z]*"},{begin:"%r!",end:"![a-z]*"},{begin:"%r\\[",end:"\\][a-z]*"}]}].concat(IRB_OBJECT,COMMENT_MODES),relevance:0}].concat(IRB_OBJECT,COMMENT_MODES);SUBST.contains=RUBY_DEFAULT_CONTAINS;PARAMS.contains=RUBY_DEFAULT_CONTAINS;var SIMPLE_PROMPT="[>?]>";var DEFAULT_PROMPT="[\\w#]+\\(\\w+\\):\\d+:\\d+>";var RVM_PROMPT="(\\w+-)?\\d+\\.\\d+\\.\\d+(p\\d+)?[^\\d][^>]+>";var IRB_DEFAULT=[{begin:/^\s*=>/,starts:{end:"$",contains:RUBY_DEFAULT_CONTAINS}},{className:"meta",begin:"^("+SIMPLE_PROMPT+"|"+DEFAULT_PROMPT+"|"+RVM_PROMPT+")(?=[ ])",starts:{end:"$",contains:RUBY_DEFAULT_CONTAINS}}];COMMENT_MODES.unshift(IRB_OBJECT);return{name:"Ruby",aliases:["rb","gemspec","podspec","thor","irb"],keywords:RUBY_KEYWORDS,illegal:/\/\*/,contains:[hljs.SHEBANG({binary:"ruby"})].concat(IRB_DEFAULT).concat(COMMENT_MODES).concat(RUBY_DEFAULT_CONTAINS)}}module.exports=ruby},function(module,exports){function sql(hljs){var COMMENT_MODE=hljs.COMMENT("--","$");return{name:"SQL",case_insensitive:true,illegal:/[<>{}*]/,contains:[{beginKeywords:"begin end start commit rollback savepoint lock alter create drop rename call "+"delete do handler insert load replace select truncate update set show pragma grant "+"merge describe use explain help declare prepare execute deallocate release "+"unlock purge reset change stop analyze cache flush optimize repair kill "+"install uninstall checksum restore check backup revoke comment values with",end:/;/,endsWithParent:true,keywords:{$pattern:/[\w\.]+/,keyword:"as abort abs absolute acc acce accep accept access accessed accessible account acos action activate add "+"addtime admin administer advanced advise aes_decrypt aes_encrypt after agent aggregate ali alia alias "+"all allocate allow alter always analyze ancillary and anti any anydata anydataset anyschema anytype apply "+"archive archived archivelog are as asc ascii asin assembly assertion associate asynchronous at atan "+"atn2 attr attri attrib attribu attribut attribute attributes audit authenticated authentication authid "+"authors auto autoallocate autodblink autoextend automatic availability avg backup badfile basicfile "+"before begin beginning benchmark between bfile bfile_base big bigfile bin binary_double binary_float "+"binlog bit_and bit_count bit_length bit_or bit_xor bitmap blob_base block blocksize body both bound "+"bucket buffer_cache buffer_pool build bulk by byte byteordermark bytes cache caching call calling cancel "+"capacity cascade cascaded case cast catalog category ceil ceiling chain change changed char_base "+"char_length character_length characters characterset charindex charset charsetform charsetid check "+"checksum checksum_agg child choose chr chunk class cleanup clear client clob clob_base clone close "+"cluster_id cluster_probability cluster_set clustering coalesce coercibility col collate collation "+"collect colu colum column column_value columns columns_updated comment commit compact compatibility "+"compiled complete composite_limit compound compress compute concat concat_ws concurrent confirm conn "+"connec connect connect_by_iscycle connect_by_isleaf connect_by_root connect_time connection "+"consider consistent constant constraint constraints constructor container content contents context "+"contributors controlfile conv convert convert_tz corr corr_k corr_s corresponding corruption cos cost "+"count count_big counted covar_pop covar_samp cpu_per_call cpu_per_session crc32 create creation "+"critical cross cube cume_dist curdate current current_date current_time current_timestamp current_user "+"cursor curtime customdatum cycle data database databases datafile datafiles datalength date_add "+"date_cache date_format date_sub dateadd datediff datefromparts datename datepart datetime2fromparts "+"day day_to_second dayname dayofmonth dayofweek dayofyear days db_role_change dbtimezone ddl deallocate "+"declare decode decompose decrement decrypt deduplicate def defa defau defaul default defaults "+"deferred defi defin define degrees delayed delegate delete delete_all delimited demand dense_rank "+"depth dequeue des_decrypt des_encrypt des_key_file desc descr descri describ describe descriptor "+"deterministic diagnostics difference dimension direct_load directory disable disable_all "+"disallow disassociate discardfile disconnect diskgroup distinct distinctrow distribute distributed div "+"do document domain dotnet double downgrade drop dumpfile duplicate duration each edition editionable "+"editions element ellipsis else elsif elt empty enable enable_all enclosed encode encoding encrypt "+"end end-exec endian enforced engine engines enqueue enterprise entityescaping eomonth error errors "+"escaped evalname evaluate event eventdata events except exception exceptions exchange exclude excluding "+"execu execut execute exempt exists exit exp expire explain explode export export_set extended extent external "+"external_1 external_2 externally extract failed failed_login_attempts failover failure far fast "+"feature_set feature_value fetch field fields file file_name_convert filesystem_like_logging final "+"finish first first_value fixed flash_cache flashback floor flush following follows for forall force foreign "+"form forma format found found_rows freelist freelists freepools fresh from from_base64 from_days "+"ftp full function general generated get get_format get_lock getdate getutcdate global global_name "+"globally go goto grant grants greatest group group_concat group_id grouping grouping_id groups "+"gtid_subtract guarantee guard handler hash hashkeys having hea head headi headin heading heap help hex "+"hierarchy high high_priority hosts hour hours http id ident_current ident_incr ident_seed identified "+"identity idle_time if ifnull ignore iif ilike ilm immediate import in include including increment "+"index indexes indexing indextype indicator indices inet6_aton inet6_ntoa inet_aton inet_ntoa infile "+"initial initialized initially initrans inmemory inner innodb input insert install instance instantiable "+"instr interface interleaved intersect into invalidate invisible is is_free_lock is_ipv4 is_ipv4_compat "+"is_not is_not_null is_used_lock isdate isnull isolation iterate java join json json_exists "+"keep keep_duplicates key keys kill language large last last_day last_insert_id last_value lateral lax lcase "+"lead leading least leaves left len lenght length less level levels library like like2 like4 likec limit "+"lines link list listagg little ln load load_file lob lobs local localtime localtimestamp locate "+"locator lock locked log log10 log2 logfile logfiles logging logical logical_reads_per_call "+"logoff logon logs long loop low low_priority lower lpad lrtrim ltrim main make_set makedate maketime "+"managed management manual map mapping mask master master_pos_wait match matched materialized max "+"maxextents maximize maxinstances maxlen maxlogfiles maxloghistory maxlogmembers maxsize maxtrans "+"md5 measures median medium member memcompress memory merge microsecond mid migration min minextents "+"minimum mining minus minute minutes minvalue missing mod mode model modification modify module monitoring month "+"months mount move movement multiset mutex name name_const names nan national native natural nav nchar "+"nclob nested never new newline next nextval no no_write_to_binlog noarchivelog noaudit nobadfile "+"nocheck nocompress nocopy nocycle nodelay nodiscardfile noentityescaping noguarantee nokeep nologfile "+"nomapping nomaxvalue nominimize nominvalue nomonitoring none noneditionable nonschema noorder "+"nopr nopro noprom nopromp noprompt norely noresetlogs noreverse normal norowdependencies noschemacheck "+"noswitch not nothing notice notnull notrim novalidate now nowait nth_value nullif nulls num numb numbe "+"nvarchar nvarchar2 object ocicoll ocidate ocidatetime ociduration ociinterval ociloblocator ocinumber "+"ociref ocirefcursor ocirowid ocistring ocitype oct octet_length of off offline offset oid oidindex old "+"on online only opaque open operations operator optimal optimize option optionally or oracle oracle_date "+"oradata ord ordaudio orddicom orddoc order ordimage ordinality ordvideo organization orlany orlvary "+"out outer outfile outline output over overflow overriding package pad parallel parallel_enable "+"parameters parent parse partial partition partitions pascal passing password password_grace_time "+"password_lock_time password_reuse_max password_reuse_time password_verify_function patch path patindex "+"pctincrease pctthreshold pctused pctversion percent percent_rank percentile_cont percentile_disc "+"performance period period_add period_diff permanent physical pi pipe pipelined pivot pluggable plugin "+"policy position post_transaction pow power pragma prebuilt precedes preceding precision prediction "+"prediction_cost prediction_details prediction_probability prediction_set prepare present preserve "+"prior priority private private_sga privileges procedural procedure procedure_analyze processlist "+"profiles project prompt protection public publishingservername purge quarter query quick quiesce quota "+"quotename radians raise rand range rank raw read reads readsize rebuild record records "+"recover recovery recursive recycle redo reduced ref reference referenced references referencing refresh "+"regexp_like register regr_avgx regr_avgy regr_count regr_intercept regr_r2 regr_slope regr_sxx regr_sxy "+"reject rekey relational relative relaylog release release_lock relies_on relocate rely rem remainder rename "+"repair repeat replace replicate replication required reset resetlogs resize resource respect restore "+"restricted result result_cache resumable resume retention return returning returns reuse reverse revoke "+"right rlike role roles rollback rolling rollup round row row_count rowdependencies rowid rownum rows "+"rtrim rules safe salt sample save savepoint sb1 sb2 sb4 scan schema schemacheck scn scope scroll "+"sdo_georaster sdo_topo_geometry search sec_to_time second seconds section securefile security seed segment select "+"self semi sequence sequential serializable server servererror session session_user sessions_per_user set "+"sets settings sha sha1 sha2 share shared shared_pool short show shrink shutdown si_averagecolor "+"si_colorhistogram si_featurelist si_positionalcolor si_stillimage si_texture siblings sid sign sin "+"size size_t sizes skip slave sleep smalldatetimefromparts smallfile snapshot some soname sort soundex "+"source space sparse spfile split sql sql_big_result sql_buffer_result sql_cache sql_calc_found_rows "+"sql_small_result sql_variant_property sqlcode sqldata sqlerror sqlname sqlstate sqrt square standalone "+"standby start starting startup statement static statistics stats_binomial_test stats_crosstab "+"stats_ks_test stats_mode stats_mw_test stats_one_way_anova stats_t_test_ stats_t_test_indep "+"stats_t_test_one stats_t_test_paired stats_wsr_test status std stddev stddev_pop stddev_samp stdev "+"stop storage store stored str str_to_date straight_join strcmp strict string struct stuff style subdate "+"subpartition subpartitions substitutable substr substring subtime subtring_index subtype success sum "+"suspend switch switchoffset switchover sync synchronous synonym sys sys_xmlagg sysasm sysaux sysdate "+"sysdatetimeoffset sysdba sysoper system system_user sysutcdatetime table tables tablespace tablesample tan tdo "+"template temporary terminated tertiary_weights test than then thread through tier ties time time_format "+"time_zone timediff timefromparts timeout timestamp timestampadd timestampdiff timezone_abbr "+"timezone_minute timezone_region to to_base64 to_date to_days to_seconds todatetimeoffset trace tracking "+"transaction transactional translate translation treat trigger trigger_nestlevel triggers trim truncate "+"try_cast try_convert try_parse type ub1 ub2 ub4 ucase unarchived unbounded uncompress "+"under undo unhex unicode uniform uninstall union unique unix_timestamp unknown unlimited unlock unnest unpivot "+"unrecoverable unsafe unsigned until untrusted unusable unused update updated upgrade upped upper upsert "+"url urowid usable usage use use_stored_outlines user user_data user_resources users using utc_date "+"utc_timestamp uuid uuid_short validate validate_password_strength validation valist value values var "+"var_samp varcharc vari varia variab variabl variable variables variance varp varraw varrawc varray "+"verify version versions view virtual visible void wait wallet warning warnings week weekday weekofyear "+"wellformed when whene whenev wheneve whenever where while whitespace window with within without work wrapped "+"xdb xml xmlagg xmlattributes xmlcast xmlcolattval xmlelement xmlexists xmlforest xmlindex xmlnamespaces "+"xmlpi xmlquery xmlroot xmlschema xmlserialize xmltable xmltype xor year year_to_month years yearweek",literal:"true false null unknown",built_in:"array bigint binary bit blob bool boolean char character date dec decimal float int int8 integer interval number "+"numeric real record serial serial8 smallint text time timestamp tinyint varchar varchar2 varying void"},contains:[{className:"string",begin:"'",end:"'",contains:[{begin:"''"}]},{className:"string",begin:'"',end:'"',contains:[{begin:'""'}]},{className:"string",begin:"`",end:"`"},hljs.C_NUMBER_MODE,hljs.C_BLOCK_COMMENT_MODE,COMMENT_MODE,hljs.HASH_COMMENT_MODE]},hljs.C_BLOCK_COMMENT_MODE,COMMENT_MODE,hljs.HASH_COMMENT_MODE]}}module.exports=sql},function(module,exports,__webpack_require__){"use strict";module.exports=abap;abap.displayName="abap";abap.aliases=[];function abap(Prism){Prism.languages.abap={comment:/^\*.*/m,string:/(`|')(?:\\.|(?!\1)[^\\\r\n])*\1/m,"string-template":{pattern:/([|}])(?:\\.|[^\\|{\r\n])*(?=[|{])/,lookbehind:true,alias:"string"},"eol-comment":{pattern:/(^|\s)".*/m,lookbehind:true,alias:"comment"},keyword:{pattern:/(\s|\.|^)(?:SCIENTIFIC_WITH_LEADING_ZERO|SCALE_PRESERVING_SCIENTIFIC|RMC_COMMUNICATION_FAILURE|END-ENHANCEMENT-SECTION|MULTIPLY-CORRESPONDING|SUBTRACT-CORRESPONDING|VERIFICATION-MESSAGE|DIVIDE-CORRESPONDING|ENHANCEMENT-SECTION|CURRENCY_CONVERSION|RMC_SYSTEM_FAILURE|START-OF-SELECTION|MOVE-CORRESPONDING|RMC_INVALID_STATUS|CUSTOMER-FUNCTION|END-OF-DEFINITION|ENHANCEMENT-POINT|SYSTEM-EXCEPTIONS|ADD-CORRESPONDING|SCALE_PRESERVING|SELECTION-SCREEN|CURSOR-SELECTION|END-OF-SELECTION|LOAD-OF-PROGRAM|SCROLL-BOUNDARY|SELECTION-TABLE|EXCEPTION-TABLE|IMPLEMENTATIONS|PARAMETER-TABLE|RIGHT-JUSTIFIED|UNIT_CONVERSION|AUTHORITY-CHECK|LIST-PROCESSING|SIGN_AS_POSTFIX|COL_BACKGROUND|IMPLEMENTATION|INTERFACE-POOL|TRANSFORMATION|IDENTIFICATION|ENDENHANCEMENT|LINE-SELECTION|INITIALIZATION|LEFT-JUSTIFIED|SELECT-OPTIONS|SELECTION-SETS|COMMUNICATION|CORRESPONDING|DECIMAL_SHIFT|PRINT-CONTROL|VALUE-REQUEST|CHAIN-REQUEST|FUNCTION-POOL|FIELD-SYMBOLS|FUNCTIONALITY|INVERTED-DATE|SELECTION-SET|CLASS-METHODS|OUTPUT-LENGTH|CLASS-CODING|COL_NEGATIVE|ERRORMESSAGE|FIELD-GROUPS|HELP-REQUEST|NO-EXTENSION|NO-TOPOFPAGE|REDEFINITION|DISPLAY-MODE|ENDINTERFACE|EXIT-COMMAND|FIELD-SYMBOL|NO-SCROLLING|SHORTDUMP-ID|ACCESSPOLICY|CLASS-EVENTS|COL_POSITIVE|DECLARATIONS|ENHANCEMENTS|FILTER-TABLE|SWITCHSTATES|SYNTAX-CHECK|TRANSPORTING|ASYNCHRONOUS|SYNTAX-TRACE|TOKENIZATION|USER-COMMAND|WITH-HEADING|ABAP-SOURCE|BREAK-POINT|CHAIN-INPUT|COMPRESSION|FIXED-POINT|NEW-SECTION|NON-UNICODE|OCCURRENCES|RESPONSIBLE|SYSTEM-CALL|TRACE-TABLE|ABBREVIATED|CHAR-TO-HEX|END-OF-FILE|ENDFUNCTION|ENVIRONMENT|ASSOCIATION|COL_HEADING|EDITOR-CALL|END-OF-PAGE|ENGINEERING|IMPLEMENTED|INTENSIFIED|RADIOBUTTON|SYSTEM-EXIT|TOP-OF-PAGE|TRANSACTION|APPLICATION|CONCATENATE|DESTINATION|ENHANCEMENT|IMMEDIATELY|NO-GROUPING|PRECOMPILED|REPLACEMENT|TITLE-LINES|ACTIVATION|BYTE-ORDER|CLASS-POOL|CONNECTION|CONVERSION|DEFINITION|DEPARTMENT|EXPIRATION|INHERITING|MESSAGE-ID|NO-HEADING|PERFORMING|QUEUE-ONLY|RIGHTSPACE|SCIENTIFIC|STATUSINFO|STRUCTURES|SYNCPOINTS|WITH-TITLE|ATTRIBUTES|BOUNDARIES|CLASS-DATA|COL_NORMAL|DD\/MM\/YYYY|DESCENDING|INTERFACES|LINE-COUNT|MM\/DD\/YYYY|NON-UNIQUE|PRESERVING|SELECTIONS|STATEMENTS|SUBROUTINE|TRUNCATION|TYPE-POOLS|ARITHMETIC|BACKGROUND|ENDPROVIDE|EXCEPTIONS|IDENTIFIER|INDEX-LINE|OBLIGATORY|PARAMETERS|PERCENTAGE|PUSHBUTTON|RESOLUTION|COMPONENTS|DEALLOCATE|DISCONNECT|DUPLICATES|FIRST-LINE|HEAD-LINES|NO-DISPLAY|OCCURRENCE|RESPECTING|RETURNCODE|SUBMATCHES|TRACE-FILE|ASCENDING|BYPASSING|ENDMODULE|EXCEPTION|EXCLUDING|EXPORTING|INCREMENT|MATCHCODE|PARAMETER|PARTIALLY|PREFERRED|REFERENCE|REPLACING|RETURNING|SELECTION|SEPARATED|SPECIFIED|STATEMENT|TIMESTAMP|TYPE-POOL|ACCEPTING|APPENDAGE|ASSIGNING|COL_GROUP|COMPARING|CONSTANTS|DANGEROUS|IMPORTING|INSTANCES|LEFTSPACE|LOG-POINT|QUICKINFO|READ-ONLY|SCROLLING|SQLSCRIPT|STEP-LOOP|TOP-LINES|TRANSLATE|APPENDING|AUTHORITY|CHARACTER|COMPONENT|CONDITION|DIRECTORY|DUPLICATE|MESSAGING|RECEIVING|SUBSCREEN|ACCORDING|COL_TOTAL|END-LINES|ENDMETHOD|ENDSELECT|EXPANDING|EXTENSION|INCLUDING|INFOTYPES|INTERFACE|INTERVALS|LINE-SIZE|PF-STATUS|PROCEDURE|PROTECTED|REQUESTED|RESUMABLE|RIGHTPLUS|SAP-SPOOL|SECONDARY|STRUCTURE|SUBSTRING|TABLEVIEW|NUMOFCHAR|ADJACENT|ANALYSIS|ASSIGNED|BACKWARD|CHANNELS|CHECKBOX|CONTINUE|CRITICAL|DATAINFO|DD\/MM\/YY|DURATION|ENCODING|ENDCLASS|FUNCTION|LEFTPLUS|LINEFEED|MM\/DD\/YY|OVERFLOW|RECEIVED|SKIPPING|SORTABLE|STANDARD|SUBTRACT|SUPPRESS|TABSTRIP|TITLEBAR|TRUNCATE|UNASSIGN|WHENEVER|ANALYZER|COALESCE|COMMENTS|CONDENSE|DECIMALS|DEFERRED|ENDWHILE|EXPLICIT|KEYWORDS|MESSAGES|POSITION|PRIORITY|RECEIVER|RENAMING|TIMEZONE|TRAILING|ALLOCATE|CENTERED|CIRCULAR|CONTROLS|CURRENCY|DELETING|DESCRIBE|DISTANCE|ENDCATCH|EXPONENT|EXTENDED|GENERATE|IGNORING|INCLUDES|INTERNAL|MAJOR-ID|MODIFIER|NEW-LINE|OPTIONAL|PROPERTY|ROLLBACK|STARTING|SUPPLIED|ABSTRACT|CHANGING|CONTEXTS|CREATING|CUSTOMER|DATABASE|DAYLIGHT|DEFINING|DISTINCT|DIVISION|ENABLING|ENDCHAIN|ESCAPING|HARMLESS|IMPLICIT|INACTIVE|LANGUAGE|MINOR-ID|MULTIPLY|NEW-PAGE|NO-TITLE|POS_HIGH|SEPARATE|TEXTPOOL|TRANSFER|SELECTOR|DBMAXLEN|ITERATOR|SELECTOR|ARCHIVE|BIT-XOR|BYTE-CO|COLLECT|COMMENT|CURRENT|DEFAULT|DISPLAY|ENDFORM|EXTRACT|LEADING|LISTBOX|LOCATOR|MEMBERS|METHODS|NESTING|POS_LOW|PROCESS|PROVIDE|RAISING|RESERVE|SECONDS|SUMMARY|VISIBLE|BETWEEN|BIT-AND|BYTE-CS|CLEANUP|COMPUTE|CONTROL|CONVERT|DATASET|ENDCASE|FORWARD|HEADERS|HOTSPOT|INCLUDE|INVERSE|KEEPING|NO-ZERO|OBJECTS|OVERLAY|PADDING|PATTERN|PROGRAM|REFRESH|SECTION|SUMMING|TESTING|VERSION|WINDOWS|WITHOUT|BIT-NOT|BYTE-CA|BYTE-NA|CASTING|CONTEXT|COUNTRY|DYNAMIC|ENABLED|ENDLOOP|EXECUTE|FRIENDS|HANDLER|HEADING|INITIAL|\*-INPUT|LOGFILE|MAXIMUM|MINIMUM|NO-GAPS|NO-SIGN|PRAGMAS|PRIMARY|PRIVATE|REDUCED|REPLACE|REQUEST|RESULTS|UNICODE|WARNING|ALIASES|BYTE-CN|BYTE-NS|CALLING|COL_KEY|COLUMNS|CONNECT|ENDEXEC|ENTRIES|EXCLUDE|FILTERS|FURTHER|HELP-ID|LOGICAL|MAPPING|MESSAGE|NAMETAB|OPTIONS|PACKAGE|PERFORM|RECEIVE|STATICS|VARYING|BINDING|CHARLEN|GREATER|XSTRLEN|ACCEPT|APPEND|DETAIL|ELSEIF|ENDING|ENDTRY|FORMAT|FRAMES|GIVING|HASHED|HEADER|IMPORT|INSERT|MARGIN|MODULE|NATIVE|OBJECT|OFFSET|REMOTE|RESUME|SAVING|SIMPLE|SUBMIT|TABBED|TOKENS|UNIQUE|UNPACK|UPDATE|WINDOW|YELLOW|ACTUAL|ASPECT|CENTER|CURSOR|DELETE|DIALOG|DIVIDE|DURING|ERRORS|EVENTS|EXTEND|FILTER|HANDLE|HAVING|IGNORE|LITTLE|MEMORY|NO-GAP|OCCURS|OPTION|PERSON|PLACES|PUBLIC|REDUCE|REPORT|RESULT|SINGLE|SORTED|SWITCH|SYNTAX|TARGET|VALUES|WRITER|ASSERT|BLOCKS|BOUNDS|BUFFER|CHANGE|COLUMN|COMMIT|CONCAT|COPIES|CREATE|DDMMYY|DEFINE|ENDIAN|ESCAPE|EXPAND|KERNEL|LAYOUT|LEGACY|LEVELS|MMDDYY|NUMBER|OUTPUT|RANGES|READER|RETURN|SCREEN|SEARCH|SELECT|SHARED|SOURCE|STABLE|STATIC|SUBKEY|SUFFIX|TABLES|UNWIND|YYMMDD|ASSIGN|BACKUP|BEFORE|BINARY|BIT-OR|BLANKS|CLIENT|CODING|COMMON|DEMAND|DYNPRO|EXCEPT|EXISTS|EXPORT|FIELDS|GLOBAL|GROUPS|LENGTH|LOCALE|MEDIUM|METHOD|MODIFY|NESTED|OTHERS|REJECT|SCROLL|SUPPLY|SYMBOL|ENDFOR|STRLEN|ALIGN|BEGIN|BOUND|ENDAT|ENTRY|EVENT|FINAL|FLUSH|GRANT|INNER|SHORT|USING|WRITE|AFTER|BLACK|BLOCK|CLOCK|COLOR|COUNT|DUMMY|EMPTY|ENDDO|ENDON|GREEN|INDEX|INOUT|LEAVE|LEVEL|LINES|MODIF|ORDER|OUTER|RANGE|RESET|RETRY|RIGHT|SMART|SPLIT|STYLE|TABLE|THROW|UNDER|UNTIL|UPPER|UTF-8|WHERE|ALIAS|BLANK|CLEAR|CLOSE|EXACT|FETCH|FIRST|FOUND|GROUP|LLANG|LOCAL|OTHER|REGEX|SPOOL|TITLE|TYPES|VALID|WHILE|ALPHA|BOXED|CATCH|CHAIN|CHECK|CLASS|COVER|ENDIF|EQUIV|FIELD|FLOOR|FRAME|INPUT|LOWER|MATCH|NODES|PAGES|PRINT|RAISE|ROUND|SHIFT|SPACE|SPOTS|STAMP|STATE|TASKS|TIMES|TRMAC|ULINE|UNION|VALUE|WIDTH|EQUAL|LOG10|TRUNC|BLOB|CASE|CEIL|CLOB|COND|EXIT|FILE|GAPS|HOLD|INCL|INTO|KEEP|KEYS|LAST|LINE|LONG|LPAD|MAIL|MODE|OPEN|PINK|READ|ROWS|TEST|THEN|ZERO|AREA|BACK|BADI|BYTE|CAST|EDIT|EXEC|FAIL|FIND|FKEQ|FONT|FREE|GKEQ|HIDE|INIT|ITNO|LATE|LOOP|MAIN|MARK|MOVE|NEXT|NULL|RISK|ROLE|UNIT|WAIT|ZONE|BASE|CALL|CODE|DATA|DATE|FKGE|GKGE|HIGH|KIND|LEFT|LIST|MASK|MESH|NAME|NODE|PACK|PAGE|POOL|SEND|SIGN|SIZE|SOME|STOP|TASK|TEXT|TIME|USER|VARY|WITH|WORD|BLUE|CONV|COPY|DEEP|ELSE|FORM|FROM|HINT|ICON|JOIN|LIKE|LOAD|ONLY|PART|SCAN|SKIP|SORT|TYPE|UNIX|VIEW|WHEN|WORK|ACOS|ASIN|ATAN|COSH|EACH|FRAC|LESS|RTTI|SINH|SQRT|TANH|AVG|BIT|DIV|ISO|LET|OUT|PAD|SQL|ALL|CI_|CPI|END|LOB|LPI|MAX|MIN|NEW|OLE|RUN|SET|\?TO|YES|ABS|ADD|AND|BIG|FOR|HDB|JOB|LOW|NOT|SAP|TRY|VIA|XML|ANY|GET|IDS|KEY|MOD|OFF|PUT|RAW|RED|REF|SUM|TAB|XSD|CNT|COS|EXP|LOG|SIN|TAN|XOR|AT|CO|CP|DO|GT|ID|IF|NS|OR|BT|CA|CS|GE|NA|NB|EQ|IN|LT|NE|NO|OF|ON|PF|TO|AS|BY|CN|IS|LE|NP|UP|E|I|M|O|Z|C|X)\b/i,lookbehind:true},number:/\b\d+\b/,operator:{pattern:/(\s)(?:\*\*?|<[=>]?|>=?|\?=|[-+\/=])(?=\s)/,lookbehind:true},"string-operator":{pattern:/(\s)&&?(?=\s)/,lookbehind:true,alias:"keyword"},"token-operator":[{pattern:/(\w)(?:->?|=>|[~|{}])(?=\w)/,lookbehind:true,alias:"punctuation"},{pattern:/[|{}]/,alias:"punctuation"}],punctuation:/[,.:()]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=abnf;abnf.displayName="abnf";abnf.aliases=[];function abnf(Prism){(function(Prism){var coreRules="(?:ALPHA|BIT|CHAR|CR|CRLF|CTL|DIGIT|DQUOTE|HEXDIG|HTAB|LF|LWSP|OCTET|SP|VCHAR|WSP)";Prism.languages.abnf={comment:/;.*/,string:{pattern:/(?:%[is])?"[^"\n\r]*"/,greedy:true,inside:{punctuation:/^%[is]/}},range:{pattern:/%(?:b[01]+-[01]+|d\d+-\d+|x[A-F\d]+-[A-F\d]+)/i,alias:"number"},terminal:{pattern:/%(?:b[01]+(?:\.[01]+)*|d\d+(?:\.\d+)*|x[A-F\d]+(?:\.[A-F\d]+)*)/i,alias:"number"},repetition:{pattern:/(^|[^\w-])(?:\d*\*\d*|\d+)/,lookbehind:true,alias:"operator"},definition:{pattern:/(^[ \t]*)(?:[a-z][\w-]*|<[^>\r\n]*>)(?=\s*=)/m,lookbehind:true,alias:"keyword",inside:{punctuation:/<|>/}},"core-rule":{pattern:RegExp("(?:(^|[^<\\w-])"+coreRules+"|<"+coreRules+">)(?![\\w-])","i"),lookbehind:true,alias:["rule","constant"],inside:{punctuation:/<|>/}},rule:{pattern:/(^|[^<\w-])[a-z][\w-]*|<[^>\r\n]*>/i,lookbehind:true,inside:{punctuation:/<|>/}},operator:/=\/?|\//,punctuation:/[()\[\]]/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=actionscript;actionscript.displayName="actionscript";actionscript.aliases=[];function actionscript(Prism){Prism.languages.actionscript=Prism.languages.extend("javascript",{keyword:/\b(?:as|break|case|catch|class|const|default|delete|do|else|extends|finally|for|function|if|implements|import|in|instanceof|interface|internal|is|native|new|null|package|private|protected|public|return|super|switch|this|throw|try|typeof|use|var|void|while|with|dynamic|each|final|get|include|namespace|native|override|set|static)\b/,operator:/\+\+|--|(?:[+\-*\/%^]|&&?|\|\|?|<<?|>>?>?|[!=]=?)=?|[~?@]/});Prism.languages.actionscript["class-name"].alias="function";if(Prism.languages.markup){Prism.languages.insertBefore("actionscript","string",{xml:{pattern:/(^|[^.])<\/?\w+(?:\s+[^\s>\/=]+=("|')(?:\\[\s\S]|(?!\2)[^\\])*\2)*\s*\/?>/,lookbehind:true,inside:Prism.languages.markup}})}}},function(module,exports,__webpack_require__){"use strict";module.exports=ada;ada.displayName="ada";ada.aliases=[];function ada(Prism){Prism.languages.ada={comment:/--.*/,string:/"(?:""|[^"\r\f\n])*"/i,number:[{pattern:/\b\d(?:_?\d)*#[\dA-F](?:_?[\dA-F])*(?:\.[\dA-F](?:_?[\dA-F])*)?#(?:E[+-]?\d(?:_?\d)*)?/i},{pattern:/\b\d(?:_?\d)*(?:\.\d(?:_?\d)*)?(?:E[+-]?\d(?:_?\d)*)?\b/i}],"attr-name":/\b'\w+/i,keyword:/\b(?:abort|abs|abstract|accept|access|aliased|all|and|array|at|begin|body|case|constant|declare|delay|delta|digits|do|else|new|return|elsif|end|entry|exception|exit|for|function|generic|goto|if|in|interface|is|limited|loop|mod|not|null|of|others|out|overriding|package|pragma|private|procedure|protected|raise|range|record|rem|renames|requeue|reverse|select|separate|some|subtype|synchronized|tagged|task|terminate|then|type|until|use|when|while|with|xor)\b/i,boolean:/\b(?:true|false)\b/i,operator:/<[=>]?|>=?|=>?|:=|\/=?|\*\*?|[&+-]/,punctuation:/\.\.?|[,;():]/,char:/'.'/,variable:/\b[a-z](?:[_a-z\d])*\b/i}}},function(module,exports,__webpack_require__){"use strict";module.exports=agda;agda.displayName="agda";agda.aliases=[];function agda(Prism){(function(Prism){Prism.languages.agda={comment:/\{-[\s\S]*?(?:-\}|$)|--.*/,string:{pattern:/"(?:\\(?:\r\n|[\s\S])|[^\\\r\n"])*"/,greedy:true},punctuation:/[(){}⦃⦄.;@]/,"class-name":{pattern:/((?:data|record) +)\S+/,lookbehind:true},function:{pattern:/(^[ \t]*)[^:\r\n]+?(?=:)/m,lookbehind:true},operator:{pattern:/(^\s*|\s)(?:[=|:∀→λ\\?_]|->)(?=\s)/,lookbehind:true},keyword:/\b(?:Set|abstract|constructor|data|eta-equality|field|forall|forall|hiding|import|in|inductive|infix|infixl|infixr|instance|let|macro|module|mutual|no-eta-equality|open|overlap|pattern|postulate|primitive|private|public|quote|quoteContext|quoteGoal|quoteTerm|record|renaming|rewrite|syntax|tactic|unquote|unquoteDecl|unquoteDef|using|variable|where|with)\b/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=al;al.displayName="al";al.aliases=[];function al(Prism){Prism.languages.al={comment:/\/\/.*|\/\*[\s\S]*?\*\//,string:{pattern:/'(?:''|[^'\r\n])*'(?!')|"(?:""|[^"\r\n])*"(?!")/,greedy:true},function:{pattern:/(\b(?:event|procedure|trigger)\s+|(?:^|[^.])\.\s*)[a-z_]\w*(?=\s*\()/i,lookbehind:true},keyword:[/\b(?:array|asserterror|begin|break|case|do|downto|else|end|event|exit|for|foreach|function|if|implements|in|indataset|interface|internal|local|of|procedure|program|protected|repeat|runonclient|securityfiltering|suppressdispose|temporary|then|to|trigger|until|var|while|with|withevents)\b/i,/\b(?:action|actions|addafter|addbefore|addfirst|addlast|area|assembly|chartpart|codeunit|column|controladdin|cuegroup|customizes|dataitem|dataset|dotnet|elements|enum|enumextension|extends|field|fieldattribute|fieldelement|fieldgroup|fieldgroups|fields|filter|fixed|grid|group|key|keys|label|labels|layout|modify|moveafter|movebefore|movefirst|movelast|page|pagecustomization|pageextension|part|profile|query|repeater|report|requestpage|schema|separator|systempart|table|tableelement|tableextension|textattribute|textelement|type|usercontrol|value|xmlport)\b/i],number:/\b(?:0x[\da-f]+|(?:\d+\.?\d*|\.\d+)(?:e[+-]?\d+)?)(?:F|U(?:LL?)?|LL?)?\b/i,boolean:/\b(?:false|true)\b/i,variable:/\b(?:Curr(?:FieldNo|Page|Report)|RequestOptionsPage|x?Rec)\b/,"class-name":/\b(?:automation|biginteger|bigtext|blob|boolean|byte|char|clienttype|code|completiontriggererrorlevel|connectiontype|database|dataclassification|datascope|date|dateformula|datetime|decimal|defaultlayout|dialog|dictionary|dotnetassembly|dotnettypedeclaration|duration|errorinfo|errortype|executioncontext|executionmode|fieldclass|fieldref|fieldtype|file|filterpagebuilder|guid|httpclient|httpcontent|httpheaders|httprequestmessage|httpresponsemessage|instream|integer|joker|jsonarray|jsonobject|jsontoken|jsonvalue|keyref|list|moduledependencyinfo|moduleinfo|none|notification|notificationscope|objecttype|option|outstream|pageresult|record|recordid|recordref|reportformat|securityfilter|sessionsettings|tableconnectiontype|tablefilter|testaction|testfield|testfilterfield|testpage|testpermissions|testrequestpage|text|textbuilder|textconst|textencoding|time|transactionmodel|transactiontype|variant|verbosity|version|view|views|webserviceactioncontext|webserviceactionresultcode|xmlattribute|xmlattributecollection|xmlcdata|xmlcomment|xmldeclaration|xmldocument|xmldocumenttype|xmlelement|xmlnamespacemanager|xmlnametable|xmlnode|xmlnodelist|xmlprocessinginstruction|xmlreadoptions|xmltext|xmlwriteoptions)\b/i,operator:/\.\.|:[=:]|[-+*/]=?|<>|[<>]=?|=|\b(?:and|div|mod|not|or|xor)\b/i,punctuation:/[()\[\]{}:.;,]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=antlr4;antlr4.displayName="antlr4";antlr4.aliases=["g4"];function antlr4(Prism){Prism.languages.antlr4={comment:/\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,string:{pattern:/'(?:\\.|[^\\'\r\n])*'/,greedy:true},"character-class":{pattern:/\[(?:\\.|[^\\\]\r\n])*\]/,greedy:true,alias:"regex",inside:{range:{pattern:/([^[]|(?:^|[^\\])(?:\\\\)*\\\[)-(?!\])/,lookbehind:true,alias:"punctuation"},escape:/\\(?:u(?:[a-fA-F\d]{4}|\{[a-fA-F\d]+\})|[pP]\{[=\w-]+\}|[^\r\nupP])/,punctuation:/[\[\]]/}},action:{pattern:/\{(?:[^{}]|\{(?:[^{}]|\{(?:[^{}]|\{[^{}]*\})*\})*\})*\}/,greedy:true,inside:{content:{pattern:/(\{)[\s\S]+(?=\})/,lookbehind:true},punctuation:/[{}]/}},command:{pattern:/(->\s*)(?:\s*(?:,\s*)?\b[a-z]\w*(?:\s*\([^()\r\n]*\))?)+(?=\s*;)/i,lookbehind:true,inside:{function:/\b\w+(?=\s*(?:[,(]|$))/,punctuation:/[,()]/}},annotation:{pattern:/@\w+(?:::\w+)*/,alias:"keyword"},label:{pattern:/#[ \t]*\w+/,alias:"punctuation"},keyword:/\b(?:catch|channels|finally|fragment|grammar|import|lexer|locals|mode|options|parser|returns|throws|tokens)\b/,definition:[{pattern:/\b[a-z]\w*(?=\s*:)/,alias:["rule","class-name"]},{pattern:/\b[A-Z]\w*(?=\s*:)/,alias:["token","constant"]}],constant:/\b[A-Z][A-Z_]*\b/,operator:/\.\.|->|[|~]|[*+?]\??/,punctuation:/[;:()=]/};Prism.languages.g4=Prism.languages.antlr4}},function(module,exports,__webpack_require__){"use strict";module.exports=apacheconf;apacheconf.displayName="apacheconf";apacheconf.aliases=[];function apacheconf(Prism){Prism.languages.apacheconf={comment:/#.*/,"directive-inline":{pattern:/(^\s*)\b(?:AcceptFilter|AcceptPathInfo|AccessFileName|Action|Add(?:Alt|AltByEncoding|AltByType|Charset|DefaultCharset|Description|Encoding|Handler|Icon|IconByEncoding|IconByType|InputFilter|Language|ModuleInfo|OutputFilter|OutputFilterByType|Type)|Alias|AliasMatch|Allow(?:CONNECT|EncodedSlashes|Methods|Override|OverrideList)?|Anonymous(?:_LogEmail|_MustGiveEmail|_NoUserID|_VerifyEmail)?|AsyncRequestWorkerFactor|Auth(?:BasicAuthoritative|BasicFake|BasicProvider|BasicUseDigestAlgorithm|DBDUserPWQuery|DBDUserRealmQuery|DBMGroupFile|DBMType|DBMUserFile|Digest(?:Algorithm|Domain|NonceLifetime|Provider|Qop|ShmemSize)|Form(?:Authoritative|Body|DisableNoStore|FakeBasicAuth|Location|LoginRequiredLocation|LoginSuccessLocation|LogoutLocation|Method|Mimetype|Password|Provider|SitePassphrase|Size|Username)|GroupFile|LDAP(?:AuthorizePrefix|BindAuthoritative|BindDN|BindPassword|CharsetConfig|CompareAsUser|CompareDNOnServer|DereferenceAliases|GroupAttribute|GroupAttributeIsDN|InitialBindAsUser|InitialBindPattern|MaxSubGroupDepth|RemoteUserAttribute|RemoteUserIsDN|SearchAsUser|SubGroupAttribute|SubGroupClass|Url)|Merging|Name|Type|UserFile|nCache(?:Context|Enable|ProvideFor|SOCache|Timeout)|nzFcgiCheckAuthnProvider|nzFcgiDefineProvider|zDBDLoginToReferer|zDBDQuery|zDBDRedirectQuery|zDBMType|zSendForbiddenOnFailure)|BalancerGrowth|BalancerInherit|BalancerMember|BalancerPersist|BrowserMatch|BrowserMatchNoCase|BufferSize|BufferedLogs|CGIDScriptTimeout|CGIMapExtension|Cache(?:DefaultExpire|DetailHeader|DirLength|DirLevels|Disable|Enable|File|Header|IgnoreCacheControl|IgnoreHeaders|IgnoreNoLastMod|IgnoreQueryString|IgnoreURLSessionIdentifiers|KeyBaseURL|LastModifiedFactor|Lock|LockMaxAge|LockPath|MaxExpire|MaxFileSize|MinExpire|MinFileSize|NegotiatedDocs|QuickHandler|ReadSize|ReadTime|Root|Socache(?:MaxSize|MaxTime|MinTime|ReadSize|ReadTime)?|StaleOnError|StoreExpired|StoreNoStore|StorePrivate)|CharsetDefault|CharsetOptions|CharsetSourceEnc|CheckCaseOnly|CheckSpelling|ChrootDir|ContentDigest|CookieDomain|CookieExpires|CookieName|CookieStyle|CookieTracking|CoreDumpDirectory|CustomLog|DBDExptime|DBDInitSQL|DBDKeep|DBDMax|DBDMin|DBDParams|DBDPersist|DBDPrepareSQL|DBDriver|DTracePrivileges|Dav|DavDepthInfinity|DavGenericLockDB|DavLockDB|DavMinTimeout|DefaultIcon|DefaultLanguage|DefaultRuntimeDir|DefaultType|Define|Deflate(?:BufferSize|CompressionLevel|FilterNote|InflateLimitRequestBody|InflateRatio(?:Burst|Limit)|MemLevel|WindowSize)|Deny|DirectoryCheckHandler|DirectoryIndex|DirectoryIndexRedirect|DirectorySlash|DocumentRoot|DumpIOInput|DumpIOOutput|EnableExceptionHook|EnableMMAP|EnableSendfile|Error|ErrorDocument|ErrorLog|ErrorLogFormat|Example|ExpiresActive|ExpiresByType|ExpiresDefault|ExtFilterDefine|ExtFilterOptions|ExtendedStatus|FallbackResource|FileETag|FilterChain|FilterDeclare|FilterProtocol|FilterProvider|FilterTrace|ForceLanguagePriority|ForceType|ForensicLog|GprofDir|GracefulShutdownTimeout|Group|Header|HeaderName|Heartbeat(?:Address|Listen|MaxServers|Storage)|HostnameLookups|ISAPI(?:AppendLogToErrors|AppendLogToQuery|CacheFile|FakeAsync|LogNotSupported|ReadAheadBuffer)|IdentityCheck|IdentityCheckTimeout|ImapBase|ImapDefault|ImapMenu|Include|IncludeOptional|Index(?:HeadInsert|Ignore|IgnoreReset|Options|OrderDefault|StyleSheet)|InputSed|KeepAlive|KeepAliveTimeout|KeptBodySize|LDAP(?:CacheEntries|CacheTTL|ConnectionPoolTTL|ConnectionTimeout|LibraryDebug|OpCacheEntries|OpCacheTTL|ReferralHopLimit|Referrals|Retries|RetryDelay|SharedCacheFile|SharedCacheSize|Timeout|TrustedClientCert|TrustedGlobalCert|TrustedMode|VerifyServerCert)|LanguagePriority|Limit(?:InternalRecursion|Request(?:Body|FieldSize|Fields|Line)|XMLRequestBody)|Listen|ListenBackLog|LoadFile|LoadModule|LogFormat|LogLevel|LogMessage|LuaAuthzProvider|LuaCodeCache|Lua(?:Hook(?:AccessChecker|AuthChecker|CheckUserID|Fixups|InsertFilter|Log|MapToStorage|TranslateName|TypeChecker)|Inherit|InputFilter|MapHandler|OutputFilter|PackageCPath|PackagePath|QuickHandler|Root|Scope)|MMapFile|Max(?:ConnectionsPerChild|KeepAliveRequests|MemFree|RangeOverlaps|RangeReversals|Ranges|RequestWorkers|SpareServers|SpareThreads|Threads)|MergeTrailers|MetaDir|MetaFiles|MetaSuffix|MimeMagicFile|MinSpareServers|MinSpareThreads|ModMimeUsePathInfo|ModemStandard|MultiviewsMatch|Mutex|NWSSLTrustedCerts|NWSSLUpgradeable|NameVirtualHost|NoProxy|Options|Order|OutputSed|PassEnv|PidFile|PrivilegesMode|Protocol|ProtocolEcho|Proxy(?:AddHeaders|BadHeader|Block|Domain|ErrorOverride|ExpressDBMFile|ExpressDBMType|ExpressEnable|FtpDirCharset|FtpEscapeWildcards|FtpListOnWildcard|HTML(?:BufSize|CharsetOut|DocType|Enable|Events|Extended|Fixups|Interp|Links|Meta|StripComments|URLMap)|IOBufferSize|MaxForwards|Pass(?:Inherit|InterpolateEnv|Match|Reverse|ReverseCookieDomain|ReverseCookiePath)?|PreserveHost|ReceiveBufferSize|Remote|RemoteMatch|Requests|SCGIInternalRedirect|SCGISendfile|Set|SourceAddress|Status|Timeout|Via)|RLimitCPU|RLimitMEM|RLimitNPROC|ReadmeName|ReceiveBufferSize|Redirect|RedirectMatch|RedirectPermanent|RedirectTemp|ReflectorHeader|RemoteIP(?:Header|InternalProxy|InternalProxyList|ProxiesHeader|TrustedProxy|TrustedProxyList)|RemoveCharset|RemoveEncoding|RemoveHandler|RemoveInputFilter|RemoveLanguage|RemoveOutputFilter|RemoveType|RequestHeader|RequestReadTimeout|Require|Rewrite(?:Base|Cond|Engine|Map|Options|Rule)|SSIETag|SSIEndTag|SSIErrorMsg|SSILastModified|SSILegacyExprParser|SSIStartTag|SSITimeFormat|SSIUndefinedEcho|SSL(?:CACertificateFile|CACertificatePath|CADNRequestFile|CADNRequestPath|CARevocationCheck|CARevocationFile|CARevocationPath|CertificateChainFile|CertificateFile|CertificateKeyFile|CipherSuite|Compression|CryptoDevice|Engine|FIPS|HonorCipherOrder|InsecureRenegotiation|OCSP(?:DefaultResponder|Enable|OverrideResponder|ResponderTimeout|ResponseMaxAge|ResponseTimeSkew|UseRequestNonce)|OpenSSLConfCmd|Options|PassPhraseDialog|Protocol|Proxy(?:CACertificateFile|CACertificatePath|CARevocation(?:Check|File|Path)|CheckPeer(?:CN|Expire|Name)|CipherSuite|Engine|MachineCertificate(?:ChainFile|File|Path)|Protocol|Verify|VerifyDepth)|RandomSeed|RenegBufferSize|Require|RequireSSL|SRPUnknownUserSeed|SRPVerifierFile|Session(?:Cache|CacheTimeout|TicketKeyFile|Tickets)|Stapling(?:Cache|ErrorCacheTimeout|FakeTryLater|ForceURL|ResponderTimeout|ResponseMaxAge|ResponseTimeSkew|ReturnResponderErrors|StandardCacheTimeout)|StrictSNIVHostCheck|UseStapling|UserName|VerifyClient|VerifyDepth)|Satisfy|ScoreBoardFile|Script(?:Alias|AliasMatch|InterpreterSource|Log|LogBuffer|LogLength|Sock)?|SecureListen|SeeRequestTail|SendBufferSize|Server(?:Admin|Alias|Limit|Name|Path|Root|Signature|Tokens)|Session(?:Cookie(?:Name|Name2|Remove)|Crypto(?:Cipher|Driver|Passphrase|PassphraseFile)|DBD(?:CookieName|CookieName2|CookieRemove|DeleteLabel|InsertLabel|PerUser|SelectLabel|UpdateLabel)|Env|Exclude|Header|Include|MaxAge)?|SetEnv|SetEnvIf|SetEnvIfExpr|SetEnvIfNoCase|SetHandler|SetInputFilter|SetOutputFilter|StartServers|StartThreads|Substitute|Suexec|SuexecUserGroup|ThreadLimit|ThreadStackSize|ThreadsPerChild|TimeOut|TraceEnable|TransferLog|TypesConfig|UnDefine|UndefMacro|UnsetEnv|Use|UseCanonicalName|UseCanonicalPhysicalPort|User|UserDir|VHostCGIMode|VHostCGIPrivs|VHostGroup|VHostPrivs|VHostSecure|VHostUser|Virtual(?:DocumentRoot|ScriptAlias)(?:IP)?|WatchdogInterval|XBitHack|xml2EncAlias|xml2EncDefault|xml2StartParse)\b/im,lookbehind:true,alias:"property"},"directive-block":{pattern:/<\/?\b(?:Auth[nz]ProviderAlias|Directory|DirectoryMatch|Else|ElseIf|Files|FilesMatch|If|IfDefine|IfModule|IfVersion|Limit|LimitExcept|Location|LocationMatch|Macro|Proxy|Require(?:All|Any|None)|VirtualHost)\b *.*>/i,inside:{"directive-block":{pattern:/^<\/?\w+/,inside:{punctuation:/^<\/?/},alias:"tag"},"directive-block-parameter":{pattern:/.*[^>]/,inside:{punctuation:/:/,string:{pattern:/("|').*\1/,inside:{variable:/[$%]\{?(?:\w\.?[-+:]?)+\}?/}}},alias:"attr-value"},punctuation:/>/},alias:"tag"},"directive-flags":{pattern:/\[(?:\w,?)+\]/,alias:"keyword"},string:{pattern:/("|').*\1/,inside:{variable:/[$%]\{?(?:\w\.?[-+:]?)+\}?/}},variable:/[$%]\{?(?:\w\.?[-+:]?)+\}?/,regex:/\^?.*\$|\^.*\$?/}}},function(module,exports,__webpack_require__){"use strict";module.exports=apl;apl.displayName="apl";apl.aliases=[];function apl(Prism){Prism.languages.apl={comment:/(?:⍝|#[! ]).*$/m,string:{pattern:/'(?:[^'\r\n]|'')*'/,greedy:true},number:/¯?(?:\d*\.?\b\d+(?:e[+¯]?\d+)?|¯|∞)(?:j¯?(?:\d*\.?\d+(?:e[+¯]?\d+)?|¯|∞))?/i,statement:/:[A-Z][a-z][A-Za-z]*\b/,"system-function":{pattern:/⎕[A-Z]+/i,alias:"function"},constant:/[⍬⌾#⎕⍞]/,function:/[-+×÷⌈⌊∣|⍳⍸?*⍟○!⌹<≤=>≥≠≡≢∊⍷∪∩~∨∧⍱⍲⍴,⍪⌽⊖⍉↑↓⊂⊃⊆⊇⌷⍋⍒⊤⊥⍕⍎⊣⊢⍁⍂≈⍯↗¤→]/,"monadic-operator":{pattern:/[\\\/⌿⍀¨⍨⌶&∥]/,alias:"operator"},"dyadic-operator":{pattern:/[.⍣⍠⍤∘⌸@⌺⍥]/,alias:"operator"},assignment:{pattern:/←/,alias:"keyword"},punctuation:/[\[;\]()◇⋄]/,dfn:{pattern:/[{}⍺⍵⍶⍹∇⍫:]/,alias:"builtin"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=applescript;applescript.displayName="applescript";applescript.aliases=[];function applescript(Prism){Prism.languages.applescript={comment:[/\(\*(?:\(\*(?:[^*]|\*(?!\)))*\*\)|(?!\(\*)[\s\S])*?\*\)/,/--.+/,/#.+/],string:/"(?:\\.|[^"\\\r\n])*"/,number:/(?:\b\d+\.?\d*|\B\.\d+)(?:e-?\d+)?\b/i,operator:[/[&=≠≤≥*+\-\/÷^]|[<>]=?/,/\b(?:(?:start|begin|end)s? with|(?:(?:does not|doesn't) contain|contains?)|(?:is|isn't|is not) (?:in|contained by)|(?:(?:is|isn't|is not) )?(?:greater|less) than(?: or equal)?(?: to)?|(?:(?:does not|doesn't) come|comes) (?:before|after)|(?:is|isn't|is not) equal(?: to)?|(?:(?:does not|doesn't) equal|equals|equal to|isn't|is not)|(?:a )?(?:ref(?: to)?|reference to)|(?:and|or|div|mod|as|not))\b/],keyword:/\b(?:about|above|after|against|apart from|around|aside from|at|back|before|beginning|behind|below|beneath|beside|between|but|by|considering|continue|copy|does|eighth|else|end|equal|error|every|exit|false|fifth|first|for|fourth|from|front|get|given|global|if|ignoring|in|instead of|into|is|it|its|last|local|me|middle|my|ninth|of|on|onto|out of|over|prop|property|put|repeat|return|returning|second|set|seventh|since|sixth|some|tell|tenth|that|the|then|third|through|thru|timeout|times|to|transaction|true|try|until|where|while|whose|with|without)\b/,class:{pattern:/\b(?:alias|application|boolean|class|constant|date|file|integer|list|number|POSIX file|real|record|reference|RGB color|script|text|centimetres|centimeters|feet|inches|kilometres|kilometers|metres|meters|miles|yards|square feet|square kilometres|square kilometers|square metres|square meters|square miles|square yards|cubic centimetres|cubic centimeters|cubic feet|cubic inches|cubic metres|cubic meters|cubic yards|gallons|litres|liters|quarts|grams|kilograms|ounces|pounds|degrees Celsius|degrees Fahrenheit|degrees Kelvin)\b/,alias:"builtin"},punctuation:/[{}():,¬«»《》]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=aql;aql.displayName="aql";aql.aliases=[];function aql(Prism){Prism.languages.aql={comment:/\/\/.*|\/\*[\s\S]*?\*\//,property:{pattern:/([{,]\s*)(?:(?!\d)\w+|(["'´`])(?:(?!\2)[^\\\r\n]|\\.)*\2)(?=\s*:)/,lookbehind:true,greedy:true},string:{pattern:/(["'´`])(?:(?!\1)[^\\\r\n]|\\.)*\1/,greedy:true},variable:/@@?\w+/,keyword:[{pattern:/(\bWITH\s+)COUNT(?=\s+INTO\b)/i,lookbehind:true},/\b(?:AGGREGATE|ALL|AND|ANY|ASC|COLLECT|DESC|DISTINCT|FILTER|FOR|GRAPH|IN|INBOUND|INSERT|INTO|K_SHORTEST_PATHS|LET|LIKE|LIMIT|NONE|NOT|NULL|OR|OUTBOUND|REMOVE|REPLACE|RETURN|SHORTEST_PATH|SORT|UPDATE|UPSERT|WITH)\b/i,{pattern:/(^|[^\w.[])(?:KEEP|PRUNE|SEARCH|TO)\b/i,lookbehind:true},{pattern:/(^|[^\w.[])(?:CURRENT|NEW|OLD)\b/,lookbehind:true},{pattern:/\bOPTIONS(?=\s*{)/i}],function:/(?!\d)\w+(?=\s*\()/,boolean:/(?:true|false)/i,range:{pattern:/\.\./,alias:"operator"},number:/(?:\B\.\d+|\b(?:0|[1-9]\d*)(?:\.\d+)?)(?:e[+-]?\d+)?/i,operator:/\*{2,}|[=!]~|[!=<>]=?|&&|\|\||[-+*/%]/,punctuation:/::|[?.:,;()[\]{}]/}}},function(module,exports,__webpack_require__){"use strict";var refractorCpp=__webpack_require__(176);module.exports=arduino;arduino.displayName="arduino";arduino.aliases=[];function arduino(Prism){Prism.register(refractorCpp);Prism.languages.arduino=Prism.languages.extend("cpp",{keyword:/\b(?:setup|if|else|while|do|for|return|in|instanceof|default|function|loop|goto|switch|case|new|try|throw|catch|finally|null|break|continue|boolean|bool|void|byte|word|string|String|array|int|long|integer|double)\b/,builtin:/\b(?:KeyboardController|MouseController|SoftwareSerial|EthernetServer|EthernetClient|LiquidCrystal|LiquidCrystal_I2C|RobotControl|GSMVoiceCall|EthernetUDP|EsploraTFT|HttpClient|RobotMotor|WiFiClient|GSMScanner|FileSystem|Scheduler|GSMServer|YunClient|YunServer|IPAddress|GSMClient|GSMModem|Keyboard|Ethernet|Console|GSMBand|Esplora|Stepper|Process|WiFiUDP|GSM_SMS|Mailbox|USBHost|Firmata|PImage|Client|Server|GSMPIN|FileIO|Bridge|Serial|EEPROM|Stream|Mouse|Audio|Servo|File|Task|GPRS|WiFi|Wire|TFT|GSM|SPI|SD|runShellCommandAsynchronously|analogWriteResolution|retrieveCallingNumber|printFirmwareVersion|analogReadResolution|sendDigitalPortPair|noListenOnLocalhost|readJoystickButton|setFirmwareVersion|readJoystickSwitch|scrollDisplayRight|getVoiceCallStatus|scrollDisplayLeft|writeMicroseconds|delayMicroseconds|beginTransmission|getSignalStrength|runAsynchronously|getAsynchronously|listenOnLocalhost|getCurrentCarrier|readAccelerometer|messageAvailable|sendDigitalPorts|lineFollowConfig|countryNameWrite|runShellCommand|readStringUntil|rewindDirectory|readTemperature|setClockDivider|readLightSensor|endTransmission|analogReference|detachInterrupt|countryNameRead|attachInterrupt|encryptionType|readBytesUntil|robotNameWrite|readMicrophone|robotNameRead|cityNameWrite|userNameWrite|readJoystickY|readJoystickX|mouseReleased|openNextFile|scanNetworks|noInterrupts|digitalWrite|beginSpeaker|mousePressed|isActionDone|mouseDragged|displayLogos|noAutoscroll|addParameter|remoteNumber|getModifiers|keyboardRead|userNameRead|waitContinue|processInput|parseCommand|printVersion|readNetworks|writeMessage|blinkVersion|cityNameRead|readMessage|setDataMode|parsePacket|isListening|setBitOrder|beginPacket|isDirectory|motorsWrite|drawCompass|digitalRead|clearScreen|serialEvent|rightToLeft|setTextSize|leftToRight|requestFrom|keyReleased|compassRead|analogWrite|interrupts|WiFiServer|disconnect|playMelody|parseFloat|autoscroll|getPINUsed|setPINUsed|setTimeout|sendAnalog|readSlider|analogRead|beginWrite|createChar|motorsStop|keyPressed|tempoWrite|readButton|subnetMask|debugPrint|macAddress|writeGreen|randomSeed|attachGPRS|readString|sendString|remotePort|releaseAll|mouseMoved|background|getXChange|getYChange|answerCall|getResult|voiceCall|endPacket|constrain|getSocket|writeJSON|getButton|available|connected|findUntil|readBytes|exitValue|readGreen|writeBlue|startLoop|isPressed|sendSysex|pauseMode|gatewayIP|setCursor|getOemKey|tuneWrite|noDisplay|loadImage|switchPIN|onRequest|onReceive|changePIN|playFile|noBuffer|parseInt|overflow|checkPIN|knobRead|beginTFT|bitClear|updateIR|bitWrite|position|writeRGB|highByte|writeRed|setSpeed|readBlue|noStroke|remoteIP|transfer|shutdown|hangCall|beginSMS|endWrite|attached|maintain|noCursor|checkReg|checkPUK|shiftOut|isValid|shiftIn|pulseIn|connect|println|localIP|pinMode|getIMEI|display|noBlink|process|getBand|running|beginSD|drawBMP|lowByte|setBand|release|bitRead|prepare|pointTo|readRed|setMode|noFill|remove|listen|stroke|detach|attach|noTone|exists|buffer|height|bitSet|circle|config|cursor|random|IRread|setDNS|endSMS|getKey|micros|millis|begin|print|write|ready|flush|width|isPIN|blink|clear|press|mkdir|rmdir|close|point|yield|image|BSSID|click|delay|read|text|move|peek|beep|rect|line|open|seek|fill|size|turn|stop|home|find|step|tone|sqrt|RSSI|SSID|end|bit|tan|cos|sin|pow|map|abs|max|min|get|run|put)\b/,constant:/\b(?:DIGITAL_MESSAGE|FIRMATA_STRING|ANALOG_MESSAGE|REPORT_DIGITAL|REPORT_ANALOG|INPUT_PULLUP|SET_PIN_MODE|INTERNAL2V56|SYSTEM_RESET|LED_BUILTIN|INTERNAL1V1|SYSEX_START|INTERNAL|EXTERNAL|DEFAULT|OUTPUT|INPUT|HIGH|LOW)\b/})}},function(module,exports,__webpack_require__){"use strict";module.exports=arff;arff.displayName="arff";arff.aliases=[];function arff(Prism){Prism.languages.arff={comment:/%.*/,string:{pattern:/(["'])(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},keyword:/@(?:attribute|data|end|relation)\b/i,number:/\b\d+(?:\.\d+)?\b/,punctuation:/[{},]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=asciidoc;asciidoc.displayName="asciidoc";asciidoc.aliases=["adoc"];function asciidoc(Prism){(function(Prism){var attributes={pattern:/(^[ \t]*)\[(?!\[)(?:(["'$`])(?:(?!\2)[^\\]|\\.)*\2|\[(?:[^\]\\]|\\.)*\]|[^\]\\]|\\.)*\]/m,lookbehind:true,inside:{quoted:{pattern:/([$`])(?:(?!\1)[^\\]|\\.)*\1/,inside:{punctuation:/^[$`]|[$`]$/}},interpreted:{pattern:/'(?:[^'\\]|\\.)*'/,inside:{punctuation:/^'|'$/}},string:/"(?:[^"\\]|\\.)*"/,variable:/\w+(?==)/,punctuation:/^\[|\]$|,/,operator:/=/,"attr-value":/(?!^\s+$).+/}};var asciidoc=Prism.languages.asciidoc={"comment-block":{pattern:/^(\/{4,})(?:\r?\n|\r)(?:[\s\S]*(?:\r?\n|\r))??\1/m,alias:"comment"},table:{pattern:/^\|={3,}(?:(?:\r?\n|\r).*)*?(?:\r?\n|\r)\|={3,}$/m,inside:{specifiers:{pattern:/(?!\|)(?:(?:(?:\d+(?:\.\d+)?|\.\d+)[+*])?(?:[<^>](?:\.[<^>])?|\.[<^>])?[a-z]*)(?=\|)/,alias:"attr-value"},punctuation:{pattern:/(^|[^\\])[|!]=*/,lookbehind:true}}},"passthrough-block":{pattern:/^(\+{4,})(?:\r?\n|\r)(?:[\s\S]*(?:\r?\n|\r))??\1$/m,inside:{punctuation:/^\++|\++$/}},"literal-block":{pattern:/^(-{4,}|\.{4,})(?:\r?\n|\r)(?:[\s\S]*(?:\r?\n|\r))??\1$/m,inside:{punctuation:/^(?:-+|\.+)|(?:-+|\.+)$/}},"other-block":{pattern:/^(--|\*{4,}|_{4,}|={4,})(?:\r?\n|\r)(?:[\s\S]*(?:\r?\n|\r))??\1$/m,inside:{punctuation:/^(?:-+|\*+|_+|=+)|(?:-+|\*+|_+|=+)$/}},"list-punctuation":{pattern:/(^[ \t]*)(?:-|\*{1,5}|\.{1,5}|(?:[a-z]|\d+)\.|[xvi]+\))(?= )/im,lookbehind:true,alias:"punctuation"},"list-label":{pattern:/(^[ \t]*)[a-z\d].+(?::{2,4}|;;)(?=\s)/im,lookbehind:true,alias:"symbol"},"indented-block":{pattern:/((\r?\n|\r)\2)([ \t]+)\S.*(?:(?:\r?\n|\r)\3.+)*(?=\2{2}|$)/,lookbehind:true},comment:/^\/\/.*/m,title:{pattern:/^.+(?:\r?\n|\r)(?:={3,}|-{3,}|~{3,}|\^{3,}|\+{3,})$|^={1,5} +.+|^\.(?![\s.]).*/m,alias:"important",inside:{punctuation:/^(?:\.|=+)|(?:=+|-+|~+|\^+|\++)$/}},"attribute-entry":{pattern:/^:[^:\r\n]+:(?: .*?(?: \+(?:\r?\n|\r).*?)*)?$/m,alias:"tag"},attributes:attributes,hr:{pattern:/^'{3,}$/m,alias:"punctuation"},"page-break":{pattern:/^<{3,}$/m,alias:"punctuation"},admonition:{pattern:/^(?:TIP|NOTE|IMPORTANT|WARNING|CAUTION):/m,alias:"keyword"},callout:[{pattern:/(^[ \t]*)<?\d*>/m,lookbehind:true,alias:"symbol"},{pattern:/<\d+>/,alias:"symbol"}],macro:{pattern:/\b[a-z\d][a-z\d-]*::?(?:(?:\S+)??\[(?:[^\]\\"]|(["'])(?:(?!\1)[^\\]|\\.)*\1|\\.)*\])/,inside:{function:/^[a-z\d-]+(?=:)/,punctuation:/^::?/,attributes:{pattern:/(?:\[(?:[^\]\\"]|(["'])(?:(?!\1)[^\\]|\\.)*\1|\\.)*\])/,inside:attributes.inside}}},inline:{pattern:/(^|[^\\])(?:(?:\B\[(?:[^\]\\"]|(["'])(?:(?!\2)[^\\]|\\.)*\2|\\.)*\])?(?:\b_(?!\s)(?: _|[^_\\\r\n]|\\.)+(?:(?:\r?\n|\r)(?: _|[^_\\\r\n]|\\.)+)*_\b|\B``(?!\s).+?(?:(?:\r?\n|\r).+?)*''\B|\B`(?!\s)(?:[^`'\s]|\s+\S)+['`]\B|\B(['*+#])(?!\s)(?: \3|(?!\3)[^\\\r\n]|\\.)+(?:(?:\r?\n|\r)(?: \3|(?!\3)[^\\\r\n]|\\.)+)*\3\B)|(?:\[(?:[^\]\\"]|(["'])(?:(?!\4)[^\\]|\\.)*\4|\\.)*\])?(?:(__|\*\*|\+\+\+?|##|\$\$|[~^]).+?(?:(?:\r?\n|\r).+?)*\5|\{[^}\r\n]+\}|\[\[\[?.+?(?:(?:\r?\n|\r).+?)*\]?\]\]|<<.+?(?:(?:\r?\n|\r).+?)*>>|\(\(\(?.+?(?:(?:\r?\n|\r).+?)*\)?\)\)))/m,lookbehind:true,inside:{attributes:attributes,url:{pattern:/^(?:\[\[\[?.+?\]?\]\]|<<.+?>>)$/,inside:{punctuation:/^(?:\[\[\[?|<<)|(?:\]\]\]?|>>)$/}},"attribute-ref":{pattern:/^\{.+\}$/,inside:{variable:{pattern:/(^\{)[a-z\d,+_-]+/,lookbehind:true},operator:/^[=?!#%@$]|!(?=[:}])/,punctuation:/^\{|\}$|::?/}},italic:{pattern:/^(['_])[\s\S]+\1$/,inside:{punctuation:/^(?:''?|__?)|(?:''?|__?)$/}},bold:{pattern:/^\*[\s\S]+\*$/,inside:{punctuation:/^\*\*?|\*\*?$/}},punctuation:/^(?:``?|\+{1,3}|##?|\$\$|[~^]|\(\(\(?)|(?:''?|\+{1,3}|##?|\$\$|[~^`]|\)?\)\))$/}},replacement:{pattern:/\((?:C|TM|R)\)/,alias:"builtin"},entity:/&#?[\da-z]{1,8};/i,"line-continuation":{pattern:/(^| )\+$/m,lookbehind:true,alias:"punctuation"}};function copyFromAsciiDoc(keys){keys=keys.split(" ");var o={};for(var i=0,l=keys.length;i<l;i++){o[keys[i]]=asciidoc[keys[i]]}return o}attributes.inside["interpreted"].inside.rest=copyFromAsciiDoc("macro inline replacement entity");asciidoc["passthrough-block"].inside.rest=copyFromAsciiDoc("macro");asciidoc["literal-block"].inside.rest=copyFromAsciiDoc("callout");asciidoc["table"].inside.rest=copyFromAsciiDoc("comment-block passthrough-block literal-block other-block list-punctuation indented-block comment title attribute-entry attributes hr page-break admonition list-label callout macro inline replacement entity line-continuation");asciidoc["other-block"].inside.rest=copyFromAsciiDoc("table list-punctuation indented-block comment attribute-entry attributes hr page-break admonition list-label macro inline replacement entity line-continuation");asciidoc["title"].inside.rest=copyFromAsciiDoc("macro inline replacement entity");Prism.hooks.add("wrap",(function(env){if(env.type==="entity"){env.attributes["title"]=env.content.value.replace(/&amp;/,"&")}}));Prism.languages.adoc=Prism.languages.asciidoc})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=asm6502;asm6502.displayName="asm6502";asm6502.aliases=[];function asm6502(Prism){Prism.languages.asm6502={comment:/;.*/,directive:{pattern:/\.\w+(?= )/,alias:"keyword"},string:/(["'`])(?:\\.|(?!\1)[^\\\r\n])*\1/,opcode:{pattern:/\b(?:adc|and|asl|bcc|bcs|beq|bit|bmi|bne|bpl|brk|bvc|bvs|clc|cld|cli|clv|cmp|cpx|cpy|dec|dex|dey|eor|inc|inx|iny|jmp|jsr|lda|ldx|ldy|lsr|nop|ora|pha|php|pla|plp|rol|ror|rti|rts|sbc|sec|sed|sei|sta|stx|sty|tax|tay|tsx|txa|txs|tya|ADC|AND|ASL|BCC|BCS|BEQ|BIT|BMI|BNE|BPL|BRK|BVC|BVS|CLC|CLD|CLI|CLV|CMP|CPX|CPY|DEC|DEX|DEY|EOR|INC|INX|INY|JMP|JSR|LDA|LDX|LDY|LSR|NOP|ORA|PHA|PHP|PLA|PLP|ROL|ROR|RTI|RTS|SBC|SEC|SED|SEI|STA|STX|STY|TAX|TAY|TSX|TXA|TXS|TYA)\b/,alias:"property"},hexnumber:{pattern:/#?\$[\da-f]{2,4}\b/i,alias:"string"},binarynumber:{pattern:/#?%[01]+\b/,alias:"string"},decimalnumber:{pattern:/#?\b\d+\b/,alias:"string"},register:{pattern:/\b[xya]\b/i,alias:"variable"}}}},function(module,exports,__webpack_require__){"use strict";var refractorCsharp=__webpack_require__(132);module.exports=aspnet;aspnet.displayName="aspnet";aspnet.aliases=[];function aspnet(Prism){Prism.register(refractorCsharp);Prism.languages.aspnet=Prism.languages.extend("markup",{"page-directive":{pattern:/<%\s*@.*%>/i,alias:"tag",inside:{"page-directive":{pattern:/<%\s*@\s*(?:Assembly|Control|Implements|Import|Master(?:Type)?|OutputCache|Page|PreviousPageType|Reference|Register)?|%>/i,alias:"tag"},rest:Prism.languages.markup.tag.inside}},directive:{pattern:/<%.*%>/i,alias:"tag",inside:{directive:{pattern:/<%\s*?[$=%#:]{0,2}|%>/i,alias:"tag"},rest:Prism.languages.csharp}}});Prism.languages.aspnet.tag.pattern=/<(?!%)\/?[^\s>\/]+(?:\s+[^\s>\/=]+(?:=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">=]+))?)*\s*\/?>/i;Prism.languages.insertBefore("inside","punctuation",{directive:Prism.languages.aspnet["directive"]},Prism.languages.aspnet.tag.inside["attr-value"]);Prism.languages.insertBefore("aspnet","comment",{"asp-comment":{pattern:/<%--[\s\S]*?--%>/,alias:["asp","comment"]}});Prism.languages.insertBefore("aspnet",Prism.languages.javascript?"script":"tag",{"asp-script":{pattern:/(<script(?=.*runat=['"]?server['"]?)[\s\S]*?>)[\s\S]*?(?=<\/script>)/i,lookbehind:true,alias:["asp","script"],inside:Prism.languages.csharp||{}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=autohotkey;autohotkey.displayName="autohotkey";autohotkey.aliases=[];function autohotkey(Prism){Prism.languages.autohotkey={comment:[{pattern:/(^|\s);.*/,lookbehind:true},{pattern:/(^\s*)\/\*[^\r\n]*(?:[\r\n](?![ \t]*\*\/)|[^\r\n])*(?:[\r\n][ \t]*\*\/)?/m,lookbehind:true,greedy:true}],string:/"(?:[^"\n\r]|"")*"/m,tag:/^[ \t]*[^\s:]+?(?=:(?:[^:]|$))/m,variable:/%\w+%/,number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/\?|\/\/?=?|:=|\|[=|]?|&[=&]?|\+[=+]?|-[=-]?|\*[=*]?|<(?:<=?|>|=)?|>>?=?|[.^!=~]=?|\b(?:AND|NOT|OR)\b/,boolean:/\b(?:true|false)\b/,selector:/\b(?:AutoTrim|BlockInput|Break|Click|ClipWait|Continue|Control|ControlClick|ControlFocus|ControlGet|ControlGetFocus|ControlGetPos|ControlGetText|ControlMove|ControlSend|ControlSendRaw|ControlSetText|CoordMode|Critical|DetectHiddenText|DetectHiddenWindows|Drive|DriveGet|DriveSpaceFree|EnvAdd|EnvDiv|EnvGet|EnvMult|EnvSet|EnvSub|EnvUpdate|Exit|ExitApp|FileAppend|FileCopy|FileCopyDir|FileCreateDir|FileCreateShortcut|FileDelete|FileEncoding|FileGetAttrib|FileGetShortcut|FileGetSize|FileGetTime|FileGetVersion|FileInstall|FileMove|FileMoveDir|FileRead|FileReadLine|FileRecycle|FileRecycleEmpty|FileRemoveDir|FileSelectFile|FileSelectFolder|FileSetAttrib|FileSetTime|FormatTime|GetKeyState|Gosub|Goto|GroupActivate|GroupAdd|GroupClose|GroupDeactivate|Gui|GuiControl|GuiControlGet|Hotkey|ImageSearch|IniDelete|IniRead|IniWrite|Input|InputBox|KeyWait|ListHotkeys|ListLines|ListVars|Loop|Menu|MouseClick|MouseClickDrag|MouseGetPos|MouseMove|MsgBox|OnExit|OutputDebug|Pause|PixelGetColor|PixelSearch|PostMessage|Process|Progress|Random|RegDelete|RegRead|RegWrite|Reload|Repeat|Return|Run|RunAs|RunWait|Send|SendEvent|SendInput|SendMessage|SendMode|SendPlay|SendRaw|SetBatchLines|SetCapslockState|SetControlDelay|SetDefaultMouseSpeed|SetEnv|SetFormat|SetKeyDelay|SetMouseDelay|SetNumlockState|SetRegView|SetScrollLockState|SetStoreCapslockMode|SetTimer|SetTitleMatchMode|SetWinDelay|SetWorkingDir|Shutdown|Sleep|Sort|SoundBeep|SoundGet|SoundGetWaveVolume|SoundPlay|SoundSet|SoundSetWaveVolume|SplashImage|SplashTextOff|SplashTextOn|SplitPath|StatusBarGetText|StatusBarWait|StringCaseSense|StringGetPos|StringLeft|StringLen|StringLower|StringMid|StringReplace|StringRight|StringSplit|StringTrimLeft|StringTrimRight|StringUpper|Suspend|SysGet|Thread|ToolTip|Transform|TrayTip|URLDownloadToFile|WinActivate|WinActivateBottom|WinClose|WinGet|WinGetActiveStats|WinGetActiveTitle|WinGetClass|WinGetPos|WinGetText|WinGetTitle|WinHide|WinKill|WinMaximize|WinMenuSelectItem|WinMinimize|WinMinimizeAll|WinMinimizeAllUndo|WinMove|WinRestore|WinSet|WinSetTitle|WinShow|WinWait|WinWaitActive|WinWaitClose|WinWaitNotActive)\b/i,constant:/\b(?:a_ahkpath|a_ahkversion|a_appdata|a_appdatacommon|a_autotrim|a_batchlines|a_caretx|a_carety|a_computername|a_controldelay|a_cursor|a_dd|a_ddd|a_dddd|a_defaultmousespeed|a_desktop|a_desktopcommon|a_detecthiddentext|a_detecthiddenwindows|a_endchar|a_eventinfo|a_exitreason|a_fileencoding|a_formatfloat|a_formatinteger|a_gui|a_guievent|a_guicontrol|a_guicontrolevent|a_guiheight|a_guiwidth|a_guix|a_guiy|a_hour|a_iconfile|a_iconhidden|a_iconnumber|a_icontip|a_index|a_ipaddress1|a_ipaddress2|a_ipaddress3|a_ipaddress4|a_is64bitos|a_isadmin|a_iscompiled|a_iscritical|a_ispaused|a_issuspended|a_isunicode|a_keydelay|a_language|a_lasterror|a_linefile|a_linenumber|a_loopfield|a_loopfileattrib|a_loopfiledir|a_loopfileext|a_loopfilefullpath|a_loopfilelongpath|a_loopfilename|a_loopfileshortname|a_loopfileshortpath|a_loopfilesize|a_loopfilesizekb|a_loopfilesizemb|a_loopfiletimeaccessed|a_loopfiletimecreated|a_loopfiletimemodified|a_loopreadline|a_loopregkey|a_loopregname|a_loopregsubkey|a_loopregtimemodified|a_loopregtype|a_mday|a_min|a_mm|a_mmm|a_mmmm|a_mon|a_mousedelay|a_msec|a_mydocuments|a_now|a_nowutc|a_numbatchlines|a_ostype|a_osversion|a_priorhotkey|a_priorkey|programfiles|a_programfiles|a_programs|a_programscommon|a_ptrsize|a_regview|a_screendpi|a_screenheight|a_screenwidth|a_scriptdir|a_scriptfullpath|a_scripthwnd|a_scriptname|a_sec|a_space|a_startmenu|a_startmenucommon|a_startup|a_startupcommon|a_stringcasesense|a_tab|a_temp|a_thisfunc|a_thishotkey|a_thislabel|a_thismenu|a_thismenuitem|a_thismenuitempos|a_tickcount|a_timeidle|a_timeidlephysical|a_timesincepriorhotkey|a_timesincethishotkey|a_titlematchmode|a_titlematchmodespeed|a_username|a_wday|a_windelay|a_windir|a_workingdir|a_yday|a_year|a_yweek|a_yyyy|clipboard|clipboardall|comspec|errorlevel)\b/i,builtin:/\b(?:abs|acos|asc|asin|atan|ceil|chr|class|comobjactive|comobjarray|comobjconnect|comobjcreate|comobjerror|comobjflags|comobjget|comobjquery|comobjtype|comobjvalue|cos|dllcall|exp|fileexist|Fileopen|floor|format|il_add|il_create|il_destroy|instr|substr|isfunc|islabel|IsObject|ln|log|lv_add|lv_delete|lv_deletecol|lv_getcount|lv_getnext|lv_gettext|lv_insert|lv_insertcol|lv_modify|lv_modifycol|lv_setimagelist|ltrim|rtrim|mod|onmessage|numget|numput|registercallback|regexmatch|regexreplace|round|sin|tan|sqrt|strlen|strreplace|sb_seticon|sb_setparts|sb_settext|strsplit|tv_add|tv_delete|tv_getchild|tv_getcount|tv_getnext|tv_get|tv_getparent|tv_getprev|tv_getselection|tv_gettext|tv_modify|varsetcapacity|winactive|winexist|__New|__Call|__Get|__Set)\b/i,symbol:/\b(?:alt|altdown|altup|appskey|backspace|browser_back|browser_favorites|browser_forward|browser_home|browser_refresh|browser_search|browser_stop|bs|capslock|ctrl|ctrlbreak|ctrldown|ctrlup|del|delete|down|end|enter|esc|escape|f1|f10|f11|f12|f13|f14|f15|f16|f17|f18|f19|f2|f20|f21|f22|f23|f24|f3|f4|f5|f6|f7|f8|f9|home|ins|insert|joy1|joy10|joy11|joy12|joy13|joy14|joy15|joy16|joy17|joy18|joy19|joy2|joy20|joy21|joy22|joy23|joy24|joy25|joy26|joy27|joy28|joy29|joy3|joy30|joy31|joy32|joy4|joy5|joy6|joy7|joy8|joy9|joyaxes|joybuttons|joyinfo|joyname|joypov|joyr|joyu|joyv|joyx|joyy|joyz|lalt|launch_app1|launch_app2|launch_mail|launch_media|lbutton|lcontrol|lctrl|left|lshift|lwin|lwindown|lwinup|mbutton|media_next|media_play_pause|media_prev|media_stop|numlock|numpad0|numpad1|numpad2|numpad3|numpad4|numpad5|numpad6|numpad7|numpad8|numpad9|numpadadd|numpadclear|numpaddel|numpaddiv|numpaddot|numpaddown|numpadend|numpadenter|numpadhome|numpadins|numpadleft|numpadmult|numpadpgdn|numpadpgup|numpadright|numpadsub|numpadup|pgdn|pgup|printscreen|ralt|rbutton|rcontrol|rctrl|right|rshift|rwin|rwindown|rwinup|scrolllock|shift|shiftdown|shiftup|space|tab|up|volume_down|volume_mute|volume_up|wheeldown|wheelleft|wheelright|wheelup|xbutton1|xbutton2)\b/i,important:/#\b(?:AllowSameLineComments|ClipboardTimeout|CommentFlag|DerefChar|ErrorStdOut|EscapeChar|HotkeyInterval|HotkeyModifierTimeout|Hotstring|If|IfTimeout|IfWinActive|IfWinExist|IfWinNotActive|IfWinNotExist|Include|IncludeAgain|InputLevel|InstallKeybdHook|InstallMouseHook|KeyHistory|MaxHotkeysPerInterval|MaxMem|MaxThreads|MaxThreadsBuffer|MaxThreadsPerHotkey|MenuMaskKey|NoEnv|NoTrayIcon|Persistent|SingleInstance|UseHook|Warn|WinActivateForce)\b/i,keyword:/\b(?:Abort|AboveNormal|Add|ahk_class|ahk_exe|ahk_group|ahk_id|ahk_pid|All|Alnum|Alpha|AltSubmit|AltTab|AltTabAndMenu|AltTabMenu|AltTabMenuDismiss|AlwaysOnTop|AutoSize|Background|BackgroundTrans|BelowNormal|between|BitAnd|BitNot|BitOr|BitShiftLeft|BitShiftRight|BitXOr|Bold|Border|Button|ByRef|Checkbox|Checked|CheckedGray|Choose|ChooseString|Close|Color|ComboBox|Contains|ControlList|Count|Date|DateTime|Days|DDL|Default|DeleteAll|Delimiter|Deref|Destroy|Digit|Disable|Disabled|DropDownList|Edit|Eject|Else|Enable|Enabled|Error|Exist|Expand|ExStyle|FileSystem|First|Flash|Float|FloatFast|Focus|Font|for|global|Grid|Group|GroupBox|GuiClose|GuiContextMenu|GuiDropFiles|GuiEscape|GuiSize|Hdr|Hidden|Hide|High|HKCC|HKCR|HKCU|HKEY_CLASSES_ROOT|HKEY_CURRENT_CONFIG|HKEY_CURRENT_USER|HKEY_LOCAL_MACHINE|HKEY_USERS|HKLM|HKU|Hours|HScroll|Icon|IconSmall|ID|IDLast|If|IfEqual|IfExist|IfGreater|IfGreaterOrEqual|IfInString|IfLess|IfLessOrEqual|IfMsgBox|IfNotEqual|IfNotExist|IfNotInString|IfWinActive|IfWinExist|IfWinNotActive|IfWinNotExist|Ignore|ImageList|in|Integer|IntegerFast|Interrupt|is|italic|Join|Label|LastFound|LastFoundExist|Limit|Lines|List|ListBox|ListView|local|Lock|Logoff|Low|Lower|Lowercase|MainWindow|Margin|Maximize|MaximizeBox|MaxSize|Minimize|MinimizeBox|MinMax|MinSize|Minutes|MonthCal|Mouse|Move|Multi|NA|No|NoActivate|NoDefault|NoHide|NoIcon|NoMainWindow|norm|Normal|NoSort|NoSortHdr|NoStandard|Not|NoTab|NoTimers|Number|Off|Ok|On|OwnDialogs|Owner|Parse|Password|Picture|Pixel|Pos|Pow|Priority|ProcessName|Radio|Range|Read|ReadOnly|Realtime|Redraw|REG_BINARY|REG_DWORD|REG_EXPAND_SZ|REG_MULTI_SZ|REG_SZ|Region|Relative|Rename|Report|Resize|Restore|Retry|RGB|Screen|Seconds|Section|Serial|SetLabel|ShiftAltTab|Show|Single|Slider|SortDesc|Standard|static|Status|StatusBar|StatusCD|strike|Style|Submit|SysMenu|Tab2|TabStop|Text|Theme|Tile|ToggleCheck|ToggleEnable|ToolWindow|Top|Topmost|TransColor|Transparent|Tray|TreeView|TryAgain|Throw|Try|Catch|Finally|Type|UnCheck|underline|Unicode|Unlock|Until|UpDown|Upper|Uppercase|UseErrorLevel|Vis|VisFirst|Visible|VScroll|Wait|WaitClose|WantCtrlA|WantF2|WantReturn|While|Wrap|Xdigit|xm|xp|xs|Yes|ym|yp|ys)\b/i,function:/[^(); \t,\n+*\-=?>:\\\/<&%\[\]]+?(?=\()/m,punctuation:/[{}[\]():,]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=autoit;autoit.displayName="autoit";autoit.aliases=[];function autoit(Prism){Prism.languages.autoit={comment:[/;.*/,{pattern:/(^\s*)#(?:comments-start|cs)[\s\S]*?^\s*#(?:comments-end|ce)/m,lookbehind:true}],url:{pattern:/(^\s*#include\s+)(?:<[^\r\n>]+>|"[^\r\n"]+")/m,lookbehind:true},string:{pattern:/(["'])(?:\1\1|(?!\1)[^\r\n])*\1/,greedy:true,inside:{variable:/([%$@])\w+\1/}},directive:{pattern:/(^\s*)#\w+/m,lookbehind:true,alias:"keyword"},function:/\b\w+(?=\()/,variable:/[$@]\w+/,keyword:/\b(?:Case|Const|Continue(?:Case|Loop)|Default|Dim|Do|Else(?:If)?|End(?:Func|If|Select|Switch|With)|Enum|Exit(?:Loop)?|For|Func|Global|If|In|Local|Next|Null|ReDim|Select|Static|Step|Switch|Then|To|Until|Volatile|WEnd|While|With)\b/i,number:/\b(?:0x[\da-f]+|\d+(?:\.\d+)?(?:e[+-]?\d+)?)\b/i,boolean:/\b(?:True|False)\b/i,operator:/<[=>]?|[-+*\/=&>]=?|[?^]|\b(?:And|Or|Not)\b/i,punctuation:/[\[\]().,:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=batch;batch.displayName="batch";batch.aliases=[];function batch(Prism){(function(Prism){var variable=/%%?[~:\w]+%?|!\S+!/;var parameter={pattern:/\/[a-z?]+(?=[ :]|$):?|-[a-z]\b|--[a-z-]+\b/im,alias:"attr-name",inside:{punctuation:/:/}};var string=/"(?:[\\"]"|[^"])*"(?!")/;var number=/(?:\b|-)\d+\b/;Prism.languages.batch={comment:[/^::.*/m,{pattern:/((?:^|[&(])[ \t]*)rem\b(?:[^^&)\r\n]|\^(?:\r\n|[\s\S]))*/im,lookbehind:true}],label:{pattern:/^:.*/m,alias:"property"},command:[{pattern:/((?:^|[&(])[ \t]*)for(?: ?\/[a-z?](?:[ :](?:"[^"]*"|\S+))?)* \S+ in \([^)]+\) do/im,lookbehind:true,inside:{keyword:/^for\b|\b(?:in|do)\b/i,string:string,parameter:parameter,variable:variable,number:number,punctuation:/[()',]/}},{pattern:/((?:^|[&(])[ \t]*)if(?: ?\/[a-z?](?:[ :](?:"[^"]*"|\S+))?)* (?:not )?(?:cmdextversion \d+|defined \w+|errorlevel \d+|exist \S+|(?:"[^"]*"|\S+)?(?:==| (?:equ|neq|lss|leq|gtr|geq) )(?:"[^"]*"|\S+))/im,lookbehind:true,inside:{keyword:/^if\b|\b(?:not|cmdextversion|defined|errorlevel|exist)\b/i,string:string,parameter:parameter,variable:variable,number:number,operator:/\^|==|\b(?:equ|neq|lss|leq|gtr|geq)\b/i}},{pattern:/((?:^|[&()])[ \t]*)else\b/im,lookbehind:true,inside:{keyword:/^else\b/i}},{pattern:/((?:^|[&(])[ \t]*)set(?: ?\/[a-z](?:[ :](?:"[^"]*"|\S+))?)* (?:[^^&)\r\n]|\^(?:\r\n|[\s\S]))*/im,lookbehind:true,inside:{keyword:/^set\b/i,string:string,parameter:parameter,variable:[variable,/\w+(?=(?:[*\/%+\-&^|]|<<|>>)?=)/],number:number,operator:/[*\/%+\-&^|]=?|<<=?|>>=?|[!~_=]/,punctuation:/[()',]/}},{pattern:/((?:^|[&(])[ \t]*@?)\w+\b(?:"(?:[\\"]"|[^"])*"(?!")|[^"^&)\r\n]|\^(?:\r\n|[\s\S]))*/im,lookbehind:true,inside:{keyword:/^\w+\b/i,string:string,parameter:parameter,label:{pattern:/(^\s*):\S+/m,lookbehind:true,alias:"property"},variable:variable,number:number,operator:/\^/}}],operator:/[&@]/,punctuation:/[()']/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=bbcode;bbcode.displayName="bbcode";bbcode.aliases=["shortcode"];function bbcode(Prism){Prism.languages.bbcode={tag:{pattern:/\[\/?[^\s=\]]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'"\]=]+))?(?:\s+[^\s=\]]+\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'"\]=]+))*\s*\]/,inside:{tag:{pattern:/^\[\/?[^\s=\]]+/,inside:{punctuation:/^\[\/?/}},"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'"\]=]+)/i,inside:{punctuation:[/^=/,{pattern:/^(\s*)["']|["']$/,lookbehind:true}]}},punctuation:/\]/,"attr-name":/[^\s=\]]+/}}};Prism.languages.shortcode=Prism.languages.bbcode}},function(module,exports,__webpack_require__){"use strict";module.exports=birb;birb.displayName="birb";birb.aliases=[];function birb(Prism){Prism.languages.birb=Prism.languages.extend("clike",{"class-name":[/\b[A-Z](?:[\d_]*[a-zA-Z]\w*)?\b/,/\b[A-Z]\w*(?=\s+\w+\s*[;,=()])/],string:{pattern:/r?("|')(?:\\.|(?!\1)[^\\])*\1/,greedy:true},keyword:/\b(?:assert|break|case|class|const|default|else|enum|final|follows|for|grab|if|nest|next|new|noSeeb|return|static|switch|throw|var|void|while)\b/,variable:/\b[a-z_]\w*\b/,operator:/\+\+|--|&&|\|\||<<=?|>>=?|~(?:\/=?)?|[+\-*\/%&^|=!<>]=?|\?|:/});Prism.languages.insertBefore("birb","function",{metadata:{pattern:/<\w+>/,greedy:true,alias:"symbol"}})}},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=bison;bison.displayName="bison";bison.aliases=[];function bison(Prism){Prism.register(refractorC);Prism.languages.bison=Prism.languages.extend("c",{});Prism.languages.insertBefore("bison","comment",{bison:{pattern:/^[\s\S]*?%%[\s\S]*?%%/,inside:{c:{pattern:/%\{[\s\S]*?%\}|\{(?:\{[^}]*\}|[^{}])*\}/,inside:{delimiter:{pattern:/^%?\{|%?\}$/,alias:"punctuation"},"bison-variable":{pattern:/[$@](?:<[^\s>]+>)?[\w$]+/,alias:"variable",inside:{punctuation:/<|>/}},rest:Prism.languages.c}},comment:Prism.languages.c.comment,string:Prism.languages.c.string,property:/\S+(?=:)/,keyword:/%\w+/,number:{pattern:/(^|[^@])\b(?:0x[\da-f]+|\d+)/i,lookbehind:true},punctuation:/%[%?]|[|:;\[\]<>]/}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=bnf;bnf.displayName="bnf";bnf.aliases=["rbnf"];function bnf(Prism){Prism.languages.bnf={string:{pattern:/"[^\r\n"]*"|'[^\r\n']*'/},definition:{pattern:/<[^<>\r\n\t]+>(?=\s*::=)/,alias:["rule","keyword"],inside:{punctuation:/^<|>$/}},rule:{pattern:/<[^<>\r\n\t]+>/,inside:{punctuation:/^<|>$/}},operator:/::=|[|()[\]{}*+?]|\.{3}/};Prism.languages.rbnf=Prism.languages.bnf}},function(module,exports,__webpack_require__){"use strict";module.exports=brainfuck;brainfuck.displayName="brainfuck";brainfuck.aliases=[];function brainfuck(Prism){Prism.languages.brainfuck={pointer:{pattern:/<|>/,alias:"keyword"},increment:{pattern:/\+/,alias:"inserted"},decrement:{pattern:/-/,alias:"deleted"},branching:{pattern:/\[|\]/,alias:"important"},operator:/[.,]/,comment:/\S+/}}},function(module,exports,__webpack_require__){"use strict";module.exports=brightscript;brightscript.displayName="brightscript";brightscript.aliases=[];function brightscript(Prism){Prism.languages.brightscript={comment:/(?:\brem|').*/i,"directive-statement":{pattern:/(^[\t ]*)#(?:const|else(?:[\t ]+if)?|end[\t ]+if|error|if).*/im,lookbehind:true,alias:"property",inside:{"error-message":{pattern:/(^#error).+/,lookbehind:true},directive:{pattern:/^#(?:const|else(?:[\t ]+if)?|end[\t ]+if|error|if)/,alias:"keyword"},expression:{pattern:/[\s\S]+/,inside:null}}},property:{pattern:/([\r\n{,][\t ]*)(?:(?!\d)\w+|"(?:[^"\r\n]|"")*"(?!"))(?=[ \t]*:)/,lookbehind:true,greedy:true},string:{pattern:/"(?:[^"\r\n]|"")*"(?!")/,greedy:true},"class-name":{pattern:/(\bAs[\t ]+)\w+/i,lookbehind:true},keyword:/\b(?:As|Dim|Each|Else|Elseif|End|Exit|For|Function|Goto|If|In|Print|Return|Step|Stop|Sub|Then|To|While)\b/i,boolean:/\b(?:true|false)\b/i,function:/\b(?!\d)\w+(?=[\t ]*\()/i,number:/(?:\b\d+(?:\.\d+)?(?:[ed][+-]\d+)?|&h[a-f\d]+)\b[%&!#]?/i,operator:/--|\+\+|>>=?|<<=?|<>|[-+*/\\<>]=?|[:^=?]|\b(?:and|mod|not|or)\b/i,punctuation:/[.,;()[\]{}]/,constant:/\b(?:LINE_NUM)\b/i};Prism.languages.brightscript["directive-statement"].inside.expression.inside=Prism.languages.brightscript}},function(module,exports,__webpack_require__){"use strict";module.exports=bro;bro.displayName="bro";bro.aliases=[];function bro(Prism){Prism.languages.bro={comment:{pattern:/(^|[^\\$])#.*/,lookbehind:true,inside:{italic:/\b(?:TODO|FIXME|XXX)\b/}},string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},boolean:/\b[TF]\b/,function:{pattern:/(?:function|hook|event) \w+(?:::\w+)?/,inside:{keyword:/^(?:function|hook|event)/}},variable:{pattern:/(?:global|local) \w+/i,inside:{keyword:/(?:global|local)/}},builtin:/(?:@(?:load(?:-(?:sigs|plugin))?|unload|prefixes|ifn?def|else|(?:end)?if|DIR|FILENAME))|(?:&?(?:redef|priority|log|optional|default|add_func|delete_func|expire_func|read_expire|write_expire|create_expire|synchronized|persistent|rotate_interval|rotate_size|encrypt|raw_output|mergeable|group|error_handler|type_column))/,constant:{pattern:/const \w+/i,inside:{keyword:/const/}},keyword:/\b(?:break|next|continue|alarm|using|of|add|delete|export|print|return|schedule|when|timeout|addr|any|bool|count|double|enum|file|int|interval|pattern|opaque|port|record|set|string|subnet|table|time|vector|for|if|else|in|module|function)\b/,operator:/--?|\+\+?|!=?=?|<=?|>=?|==?=?|&&|\|\|?|\?|\*|\/|~|\^|%/,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,punctuation:/[{}[\];(),.:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=bsl;bsl.displayName="bsl";bsl.aliases=[];function bsl(Prism){Prism.languages.bsl={comment:/\/\/.*/,string:[{pattern:/"(?:[^"]|"")*"(?!")/,greedy:true},{pattern:/'(?:[^'\r\n\\]|\\.)*'/}],keyword:[{pattern:/(^|[^\w\u0400-\u0484\u0487-\u052f\u1c80-\u1c88\u1d2b\u1d78\u2de0-\u2dff\ua640-\ua69f\ufe2e\ufe2f])(?:пока|для|новый|прервать|попытка|исключение|вызватьисключение|иначе|конецпопытки|неопределено|функция|перем|возврат|конецфункции|если|иначеесли|процедура|конецпроцедуры|тогда|знач|экспорт|конецесли|из|каждого|истина|ложь|по|цикл|конеццикла|выполнить)(?![\w\u0400-\u0484\u0487-\u052f\u1c80-\u1c88\u1d2b\u1d78\u2de0-\u2dff\ua640-\ua69f\ufe2e\ufe2f])/i,lookbehind:true},{pattern:/\b(?:while|for|new|break|try|except|raise|else|endtry|undefined|function|var|return|endfunction|null|if|elseif|procedure|endprocedure|then|val|export|endif|in|each|true|false|to|do|enddo|execute)\b/i}],number:{pattern:/(^(?=\d)|[^\w\u0400-\u0484\u0487-\u052f\u1c80-\u1c88\u1d2b\u1d78\u2de0-\u2dff\ua640-\ua69f\ufe2e\ufe2f])(?:\d+\.?\d*|\.\d+)(?:E[+-]?\d+)?/i,lookbehind:true},operator:[/[<>+\-*/]=?|[%=]/,{pattern:/(^|[^\w\u0400-\u0484\u0487-\u052f\u1c80-\u1c88\u1d2b\u1d78\u2de0-\u2dff\ua640-\ua69f\ufe2e\ufe2f])(?:и|или|не)(?![\w\u0400-\u0484\u0487-\u052f\u1c80-\u1c88\u1d2b\u1d78\u2de0-\u2dff\ua640-\ua69f\ufe2e\ufe2f])/i,lookbehind:true},{pattern:/\b(?:and|or|not)\b/i}],punctuation:/\(\.|\.\)|[()\[\]:;,.]/,directive:[{pattern:/^(\s*)&.*/m,lookbehind:true,alias:"important"},{pattern:/^\s*#.*/gm,alias:"important"}]};Prism.languages.oscript=Prism.languages["bsl"]}},function(module,exports,__webpack_require__){"use strict";module.exports=cil;cil.displayName="cil";cil.aliases=[];function cil(Prism){Prism.languages.cil={comment:/\/\/.*/,string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},directive:{pattern:/(^|\W)\.[a-z]+(?=\s)/,lookbehind:true,alias:"class-name"},variable:/\[[\w\.]+\]/,keyword:/\b(?:abstract|ansi|assembly|auto|autochar|beforefieldinit|bool|bstr|byvalstr|catch|char|cil|class|currency|date|decimal|default|enum|error|explicit|extends|extern|famandassem|family|famorassem|final(?:ly)?|float32|float64|hidebysig|iant|idispatch|implements|import|initonly|instance|u?int(?:8|16|32|64)?|interface|iunknown|literal|lpstr|lpstruct|lptstr|lpwstr|managed|method|native(?:Type)?|nested|newslot|object(?:ref)?|pinvokeimpl|private|privatescope|public|reqsecobj|rtspecialname|runtime|sealed|sequential|serializable|specialname|static|string|struct|syschar|tbstr|unicode|unmanagedexp|unsigned|value(?:type)?|variant|virtual|void)\b/,function:/\b(?:(?:constrained|unaligned|volatile|readonly|tail|no)\.)?(?:conv\.(?:[iu][1248]?|ovf\.[iu][1248]?(?:\.un)?|r\.un|r4|r8)|ldc\.(?:i4(?:\.[0-9]+|\.[mM]1|\.s)?|i8|r4|r8)|ldelem(?:\.[iu][1248]?|\.r[48]|\.ref|a)?|ldind\.(?:[iu][1248]?|r[48]|ref)|stelem\.?(?:i[1248]?|r[48]|ref)?|stind\.(?:i[1248]?|r[48]|ref)?|end(?:fault|filter|finally)|ldarg(?:\.[0-3s]|a(?:\.s)?)?|ldloc(?:\.[0-9]+|\.s)?|sub(?:\.ovf(?:\.un)?)?|mul(?:\.ovf(?:\.un)?)?|add(?:\.ovf(?:\.un)?)?|stloc(?:\.[0-3s])?|refany(?:type|val)|blt(?:\.un)?(?:\.s)?|ble(?:\.un)?(?:\.s)?|bgt(?:\.un)?(?:\.s)?|bge(?:\.un)?(?:\.s)?|unbox(?:\.any)?|init(?:blk|obj)|call(?:i|virt)?|brfalse(?:\.s)?|bne\.un(?:\.s)?|ldloca(?:\.s)?|brzero(?:\.s)?|brtrue(?:\.s)?|brnull(?:\.s)?|brinst(?:\.s)?|starg(?:\.s)?|leave(?:\.s)?|shr(?:\.un)?|rem(?:\.un)?|div(?:\.un)?|clt(?:\.un)?|alignment|ldvirtftn|castclass|beq(?:\.s)?|mkrefany|localloc|ckfinite|rethrow|ldtoken|ldsflda|cgt\.un|arglist|switch|stsfld|sizeof|newobj|newarr|ldsfld|ldnull|ldflda|isinst|throw|stobj|stfld|ldstr|ldobj|ldlen|ldftn|ldfld|cpobj|cpblk|break|br\.s|xor|shl|ret|pop|not|nop|neg|jmp|dup|cgt|ceq|box|and|or|br)\b/,boolean:/\b(?:true|false)\b/,number:/\b-?(?:0x[0-9a-fA-F]+|[0-9]+)(?:\.[0-9a-fA-F]+)?\b/i,punctuation:/[{}[\];(),:=]|IL_[0-9A-Za-z]+/}}},function(module,exports,__webpack_require__){"use strict";module.exports=clike;clike.displayName="clike";clike.aliases=[];function clike(Prism){Prism.languages.clike={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true,greedy:true}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},"class-name":{pattern:/(\b(?:class|interface|extends|implements|trait|instanceof|new)\s+|\bcatch\s+\()[\w.\\]+/i,lookbehind:true,inside:{punctuation:/[.\\]/}},keyword:/\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,boolean:/\b(?:true|false)\b/,function:/\w+(?=\()/,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/[<>]=?|[!=]=?=?|--?|\+\+?|&&?|\|\|?|[?*/~^%]/,punctuation:/[{}[\];(),.:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=clojure;clojure.displayName="clojure";clojure.aliases=[];function clojure(Prism){Prism.languages.clojure={comment:/;.*/,string:{pattern:/"(?:[^"\\]|\\.)*"/,greedy:true},operator:/(?:::|[:|'])\b[a-z][\w*+!?-]*\b/i,keyword:{pattern:/([^\w+*'?-])(?:def|if|do|let|\.\.|quote|var|->>|->|fn|loop|recur|throw|try|monitor-enter|\.|new|set!|def\-|defn|defn\-|defmacro|defmulti|defmethod|defstruct|defonce|declare|definline|definterface|defprotocol|==|defrecord|>=|deftype|<=|defproject|ns|\*|\+|\-|\/|<|=|>|accessor|agent|agent-errors|aget|alength|all-ns|alter|and|append-child|apply|array-map|aset|aset-boolean|aset-byte|aset-char|aset-double|aset-float|aset-int|aset-long|aset-short|assert|assoc|await|await-for|bean|binding|bit-and|bit-not|bit-or|bit-shift-left|bit-shift-right|bit-xor|boolean|branch\?|butlast|byte|cast|char|children|class|clear-agent-errors|comment|commute|comp|comparator|complement|concat|conj|cons|constantly|cond|if-not|construct-proxy|contains\?|count|create-ns|create-struct|cycle|dec|deref|difference|disj|dissoc|distinct|doall|doc|dorun|doseq|dosync|dotimes|doto|double|down|drop|drop-while|edit|end\?|ensure|eval|every\?|false\?|ffirst|file-seq|filter|find|find-doc|find-ns|find-var|first|float|flush|for|fnseq|frest|gensym|get-proxy-class|get|hash-map|hash-set|identical\?|identity|if-let|import|in-ns|inc|index|insert-child|insert-left|insert-right|inspect-table|inspect-tree|instance\?|int|interleave|intersection|into|into-array|iterate|join|key|keys|keyword|keyword\?|last|lazy-cat|lazy-cons|left|lefts|line-seq|list\*|list|load|load-file|locking|long|macroexpand|macroexpand-1|make-array|make-node|map|map-invert|map\?|mapcat|max|max-key|memfn|merge|merge-with|meta|min|min-key|name|namespace|neg\?|newline|next|nil\?|node|not|not-any\?|not-every\?|not=|ns-imports|ns-interns|ns-map|ns-name|ns-publics|ns-refers|ns-resolve|ns-unmap|nth|nthrest|or|parse|partial|path|peek|pop|pos\?|pr|pr-str|print|print-str|println|println-str|prn|prn-str|project|proxy|proxy-mappings|quot|rand|rand-int|range|re-find|re-groups|re-matcher|re-matches|re-pattern|re-seq|read|read-line|reduce|ref|ref-set|refer|rem|remove|remove-method|remove-ns|rename|rename-keys|repeat|replace|replicate|resolve|rest|resultset-seq|reverse|rfirst|right|rights|root|rrest|rseq|second|select|select-keys|send|send-off|seq|seq-zip|seq\?|set|short|slurp|some|sort|sort-by|sorted-map|sorted-map-by|sorted-set|special-symbol\?|split-at|split-with|str|string\?|struct|struct-map|subs|subvec|symbol|symbol\?|sync|take|take-nth|take-while|test|time|to-array|to-array-2d|tree-seq|true\?|union|up|update-proxy|val|vals|var-get|var-set|var\?|vector|vector-zip|vector\?|when|when-first|when-let|when-not|with-local-vars|with-meta|with-open|with-out-str|xml-seq|xml-zip|zero\?|zipmap|zipper)(?=[^\w+*'?-])/,lookbehind:true},boolean:/\b(?:true|false|nil)\b/,number:/\b[\da-f]+\b/i,punctuation:/[{}\[\](),]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=cmake;cmake.displayName="cmake";cmake.aliases=[];function cmake(Prism){Prism.languages.cmake={comment:/#.*/,string:{pattern:/"(?:[^\\"]|\\.)*"/,greedy:true,inside:{interpolation:{pattern:/\${(?:[^{}$]|\${[^{}$]*})*}/,inside:{punctuation:/\${|}/,variable:/\w+/}}}},variable:/\b(?:CMAKE_\w+|\w+_(?:VERSION(?:_MAJOR|_MINOR|_PATCH|_TWEAK)?|(?:BINARY|SOURCE)_DIR|DESCRIPTION|HOMEPAGE_URL|ROOT)|(?:CTEST_CUSTOM_(?:MAXIMUM_(?:(?:FAIL|PASS)ED_TEST_OUTPUT_SIZE|NUMBER_OF_(?:ERROR|WARNING)S)|ERROR_(?:P(?:OST|RE)_CONTEXT|EXCEPTION|MATCH)|P(?:OST|RE)_MEMCHECK|WARNING_(?:EXCEPTION|MATCH)|(?:MEMCHECK|TESTS)_IGNORE|P(?:OST|RE)_TEST|COVERAGE_EXCLUDE)|ANDROID|APPLE|BORLAND|BUILD_SHARED_LIBS|CACHE|CPACK_(?:ABSOLUTE_DESTINATION_FILES|COMPONENT_INCLUDE_TOPLEVEL_DIRECTORY|ERROR_ON_ABSOLUTE_INSTALL_DESTINATION|INCLUDE_TOPLEVEL_DIRECTORY|INSTALL_DEFAULT_DIRECTORY_PERMISSIONS|INSTALL_SCRIPT|PACKAGING_INSTALL_PREFIX|SET_DESTDIR|WARN_ON_ABSOLUTE_INSTALL_DESTINATION)|CTEST_(?:BINARY_DIRECTORY|BUILD_COMMAND|BUILD_NAME|BZR_COMMAND|BZR_UPDATE_OPTIONS|CHANGE_ID|CHECKOUT_COMMAND|CONFIGURATION_TYPE|CONFIGURE_COMMAND|COVERAGE_COMMAND|COVERAGE_EXTRA_FLAGS|CURL_OPTIONS|CUSTOM_(?:COVERAGE_EXCLUDE|ERROR_EXCEPTION|ERROR_MATCH|ERROR_POST_CONTEXT|ERROR_PRE_CONTEXT|MAXIMUM_FAILED_TEST_OUTPUT_SIZE|MAXIMUM_NUMBER_OF_(?:ERRORS|WARNINGS)|MAXIMUM_PASSED_TEST_OUTPUT_SIZE|MEMCHECK_IGNORE|POST_MEMCHECK|POST_TEST|PRE_MEMCHECK|PRE_TEST|TESTS_IGNORE|WARNING_EXCEPTION|WARNING_MATCH)|CVS_CHECKOUT|CVS_COMMAND|CVS_UPDATE_OPTIONS|DROP_LOCATION|DROP_METHOD|DROP_SITE|DROP_SITE_CDASH|DROP_SITE_PASSWORD|DROP_SITE_USER|EXTRA_COVERAGE_GLOB|GIT_COMMAND|GIT_INIT_SUBMODULES|GIT_UPDATE_CUSTOM|GIT_UPDATE_OPTIONS|HG_COMMAND|HG_UPDATE_OPTIONS|LABELS_FOR_SUBPROJECTS|MEMORYCHECK_(?:COMMAND|COMMAND_OPTIONS|SANITIZER_OPTIONS|SUPPRESSIONS_FILE|TYPE)|NIGHTLY_START_TIME|P4_CLIENT|P4_COMMAND|P4_OPTIONS|P4_UPDATE_OPTIONS|RUN_CURRENT_SCRIPT|SCP_COMMAND|SITE|SOURCE_DIRECTORY|SUBMIT_URL|SVN_COMMAND|SVN_OPTIONS|SVN_UPDATE_OPTIONS|TEST_LOAD|TEST_TIMEOUT|TRIGGER_SITE|UPDATE_COMMAND|UPDATE_OPTIONS|UPDATE_VERSION_ONLY|USE_LAUNCHERS)|CYGWIN|ENV|EXECUTABLE_OUTPUT_PATH|GHS-MULTI|IOS|LIBRARY_OUTPUT_PATH|MINGW|MSVC(?:10|11|12|14|60|70|71|80|90|_IDE|_TOOLSET_VERSION|_VERSION)?|MSYS|PROJECT_(?:BINARY_DIR|DESCRIPTION|HOMEPAGE_URL|NAME|SOURCE_DIR|VERSION|VERSION_(?:MAJOR|MINOR|PATCH|TWEAK))|UNIX|WIN32|WINCE|WINDOWS_PHONE|WINDOWS_STORE|XCODE|XCODE_VERSION))\b/,property:/\b(?:cxx_\w+|(?:ARCHIVE_OUTPUT_(?:DIRECTORY|NAME)|COMPILE_DEFINITIONS|COMPILE_PDB_NAME|COMPILE_PDB_OUTPUT_DIRECTORY|EXCLUDE_FROM_DEFAULT_BUILD|IMPORTED_(?:IMPLIB|LIBNAME|LINK_DEPENDENT_LIBRARIES|LINK_INTERFACE_LANGUAGES|LINK_INTERFACE_LIBRARIES|LINK_INTERFACE_MULTIPLICITY|LOCATION|NO_SONAME|OBJECTS|SONAME)|INTERPROCEDURAL_OPTIMIZATION|LIBRARY_OUTPUT_DIRECTORY|LIBRARY_OUTPUT_NAME|LINK_FLAGS|LINK_INTERFACE_LIBRARIES|LINK_INTERFACE_MULTIPLICITY|LOCATION|MAP_IMPORTED_CONFIG|OSX_ARCHITECTURES|OUTPUT_NAME|PDB_NAME|PDB_OUTPUT_DIRECTORY|RUNTIME_OUTPUT_DIRECTORY|RUNTIME_OUTPUT_NAME|STATIC_LIBRARY_FLAGS|VS_CSHARP|VS_DOTNET_REFERENCEPROP|VS_DOTNET_REFERENCE|VS_GLOBAL_SECTION_POST|VS_GLOBAL_SECTION_PRE|VS_GLOBAL|XCODE_ATTRIBUTE)_\w+|\w+_(?:CLANG_TIDY|COMPILER_LAUNCHER|CPPCHECK|CPPLINT|INCLUDE_WHAT_YOU_USE|OUTPUT_NAME|POSTFIX|VISIBILITY_PRESET)|ABSTRACT|ADDITIONAL_MAKE_CLEAN_FILES|ADVANCED|ALIASED_TARGET|ALLOW_DUPLICATE_CUSTOM_TARGETS|ANDROID_(?:ANT_ADDITIONAL_OPTIONS|API|API_MIN|ARCH|ASSETS_DIRECTORIES|GUI|JAR_DEPENDENCIES|NATIVE_LIB_DEPENDENCIES|NATIVE_LIB_DIRECTORIES|PROCESS_MAX|PROGUARD|PROGUARD_CONFIG_PATH|SECURE_PROPS_PATH|SKIP_ANT_STEP|STL_TYPE)|ARCHIVE_OUTPUT_DIRECTORY|ARCHIVE_OUTPUT_NAME|ATTACHED_FILES|ATTACHED_FILES_ON_FAIL|AUTOGEN_(?:BUILD_DIR|ORIGIN_DEPENDS|PARALLEL|SOURCE_GROUP|TARGETS_FOLDER|TARGET_DEPENDS)|AUTOMOC|AUTOMOC_(?:COMPILER_PREDEFINES|DEPEND_FILTERS|EXECUTABLE|MACRO_NAMES|MOC_OPTIONS|SOURCE_GROUP|TARGETS_FOLDER)|AUTORCC|AUTORCC_EXECUTABLE|AUTORCC_OPTIONS|AUTORCC_SOURCE_GROUP|AUTOUIC|AUTOUIC_EXECUTABLE|AUTOUIC_OPTIONS|AUTOUIC_SEARCH_PATHS|BINARY_DIR|BUILDSYSTEM_TARGETS|BUILD_RPATH|BUILD_RPATH_USE_ORIGIN|BUILD_WITH_INSTALL_NAME_DIR|BUILD_WITH_INSTALL_RPATH|BUNDLE|BUNDLE_EXTENSION|CACHE_VARIABLES|CLEAN_NO_CUSTOM|COMMON_LANGUAGE_RUNTIME|COMPATIBLE_INTERFACE_(?:BOOL|NUMBER_MAX|NUMBER_MIN|STRING)|COMPILE_(?:DEFINITIONS|FEATURES|FLAGS|OPTIONS|PDB_NAME|PDB_OUTPUT_DIRECTORY)|COST|CPACK_DESKTOP_SHORTCUTS|CPACK_NEVER_OVERWRITE|CPACK_PERMANENT|CPACK_STARTUP_SHORTCUTS|CPACK_START_MENU_SHORTCUTS|CPACK_WIX_ACL|CROSSCOMPILING_EMULATOR|CUDA_EXTENSIONS|CUDA_PTX_COMPILATION|CUDA_RESOLVE_DEVICE_SYMBOLS|CUDA_SEPARABLE_COMPILATION|CUDA_STANDARD|CUDA_STANDARD_REQUIRED|CXX_EXTENSIONS|CXX_STANDARD|CXX_STANDARD_REQUIRED|C_EXTENSIONS|C_STANDARD|C_STANDARD_REQUIRED|DEBUG_CONFIGURATIONS|DEBUG_POSTFIX|DEFINE_SYMBOL|DEFINITIONS|DEPENDS|DEPLOYMENT_ADDITIONAL_FILES|DEPLOYMENT_REMOTE_DIRECTORY|DISABLED|DISABLED_FEATURES|ECLIPSE_EXTRA_CPROJECT_CONTENTS|ECLIPSE_EXTRA_NATURES|ENABLED_FEATURES|ENABLED_LANGUAGES|ENABLE_EXPORTS|ENVIRONMENT|EXCLUDE_FROM_ALL|EXCLUDE_FROM_DEFAULT_BUILD|EXPORT_NAME|EXPORT_PROPERTIES|EXTERNAL_OBJECT|EchoString|FAIL_REGULAR_EXPRESSION|FIND_LIBRARY_USE_LIB32_PATHS|FIND_LIBRARY_USE_LIB64_PATHS|FIND_LIBRARY_USE_LIBX32_PATHS|FIND_LIBRARY_USE_OPENBSD_VERSIONING|FIXTURES_CLEANUP|FIXTURES_REQUIRED|FIXTURES_SETUP|FOLDER|FRAMEWORK|Fortran_FORMAT|Fortran_MODULE_DIRECTORY|GENERATED|GENERATOR_FILE_NAME|GENERATOR_IS_MULTI_CONFIG|GHS_INTEGRITY_APP|GHS_NO_SOURCE_GROUP_FILE|GLOBAL_DEPENDS_DEBUG_MODE|GLOBAL_DEPENDS_NO_CYCLES|GNUtoMS|HAS_CXX|HEADER_FILE_ONLY|HELPSTRING|IMPLICIT_DEPENDS_INCLUDE_TRANSFORM|IMPORTED|IMPORTED_(?:COMMON_LANGUAGE_RUNTIME|CONFIGURATIONS|GLOBAL|IMPLIB|LIBNAME|LINK_DEPENDENT_LIBRARIES|LINK_INTERFACE_(?:LANGUAGES|LIBRARIES|MULTIPLICITY)|LOCATION|NO_SONAME|OBJECTS|SONAME)|IMPORT_PREFIX|IMPORT_SUFFIX|INCLUDE_DIRECTORIES|INCLUDE_REGULAR_EXPRESSION|INSTALL_NAME_DIR|INSTALL_RPATH|INSTALL_RPATH_USE_LINK_PATH|INTERFACE_(?:AUTOUIC_OPTIONS|COMPILE_DEFINITIONS|COMPILE_FEATURES|COMPILE_OPTIONS|INCLUDE_DIRECTORIES|LINK_DEPENDS|LINK_DIRECTORIES|LINK_LIBRARIES|LINK_OPTIONS|POSITION_INDEPENDENT_CODE|SOURCES|SYSTEM_INCLUDE_DIRECTORIES)|INTERPROCEDURAL_OPTIMIZATION|IN_TRY_COMPILE|IOS_INSTALL_COMBINED|JOB_POOLS|JOB_POOL_COMPILE|JOB_POOL_LINK|KEEP_EXTENSION|LABELS|LANGUAGE|LIBRARY_OUTPUT_DIRECTORY|LIBRARY_OUTPUT_NAME|LINKER_LANGUAGE|LINK_(?:DEPENDS|DEPENDS_NO_SHARED|DIRECTORIES|FLAGS|INTERFACE_LIBRARIES|INTERFACE_MULTIPLICITY|LIBRARIES|OPTIONS|SEARCH_END_STATIC|SEARCH_START_STATIC|WHAT_YOU_USE)|LISTFILE_STACK|LOCATION|MACOSX_BUNDLE|MACOSX_BUNDLE_INFO_PLIST|MACOSX_FRAMEWORK_INFO_PLIST|MACOSX_PACKAGE_LOCATION|MACOSX_RPATH|MACROS|MANUALLY_ADDED_DEPENDENCIES|MEASUREMENT|MODIFIED|NAME|NO_SONAME|NO_SYSTEM_FROM_IMPORTED|OBJECT_DEPENDS|OBJECT_OUTPUTS|OSX_ARCHITECTURES|OUTPUT_NAME|PACKAGES_FOUND|PACKAGES_NOT_FOUND|PARENT_DIRECTORY|PASS_REGULAR_EXPRESSION|PDB_NAME|PDB_OUTPUT_DIRECTORY|POSITION_INDEPENDENT_CODE|POST_INSTALL_SCRIPT|PREDEFINED_TARGETS_FOLDER|PREFIX|PRE_INSTALL_SCRIPT|PRIVATE_HEADER|PROCESSORS|PROCESSOR_AFFINITY|PROJECT_LABEL|PUBLIC_HEADER|REPORT_UNDEFINED_PROPERTIES|REQUIRED_FILES|RESOURCE|RESOURCE_LOCK|RULE_LAUNCH_COMPILE|RULE_LAUNCH_CUSTOM|RULE_LAUNCH_LINK|RULE_MESSAGES|RUNTIME_OUTPUT_DIRECTORY|RUNTIME_OUTPUT_NAME|RUN_SERIAL|SKIP_AUTOGEN|SKIP_AUTOMOC|SKIP_AUTORCC|SKIP_AUTOUIC|SKIP_BUILD_RPATH|SKIP_RETURN_CODE|SOURCES|SOURCE_DIR|SOVERSION|STATIC_LIBRARY_FLAGS|STATIC_LIBRARY_OPTIONS|STRINGS|SUBDIRECTORIES|SUFFIX|SYMBOLIC|TARGET_ARCHIVES_MAY_BE_SHARED_LIBS|TARGET_MESSAGES|TARGET_SUPPORTS_SHARED_LIBS|TESTS|TEST_INCLUDE_FILE|TEST_INCLUDE_FILES|TIMEOUT|TIMEOUT_AFTER_MATCH|TYPE|USE_FOLDERS|VALUE|VARIABLES|VERSION|VISIBILITY_INLINES_HIDDEN|VS_(?:CONFIGURATION_TYPE|COPY_TO_OUT_DIR|DEBUGGER_(?:COMMAND|COMMAND_ARGUMENTS|ENVIRONMENT|WORKING_DIRECTORY)|DEPLOYMENT_CONTENT|DEPLOYMENT_LOCATION|DOTNET_REFERENCES|DOTNET_REFERENCES_COPY_LOCAL|GLOBAL_KEYWORD|GLOBAL_PROJECT_TYPES|GLOBAL_ROOTNAMESPACE|INCLUDE_IN_VSIX|IOT_STARTUP_TASK|KEYWORD|RESOURCE_GENERATOR|SCC_AUXPATH|SCC_LOCALPATH|SCC_PROJECTNAME|SCC_PROVIDER|SDK_REFERENCES|SHADER_(?:DISABLE_OPTIMIZATIONS|ENABLE_DEBUG|ENTRYPOINT|FLAGS|MODEL|OBJECT_FILE_NAME|OUTPUT_HEADER_FILE|TYPE|VARIABLE_NAME)|STARTUP_PROJECT|TOOL_OVERRIDE|USER_PROPS|WINRT_COMPONENT|WINRT_EXTENSIONS|WINRT_REFERENCES|XAML_TYPE)|WILL_FAIL|WIN32_EXECUTABLE|WINDOWS_EXPORT_ALL_SYMBOLS|WORKING_DIRECTORY|WRAP_EXCLUDE|XCODE_(?:EMIT_EFFECTIVE_PLATFORM_NAME|EXPLICIT_FILE_TYPE|FILE_ATTRIBUTES|LAST_KNOWN_FILE_TYPE|PRODUCT_TYPE|SCHEME_(?:ADDRESS_SANITIZER|ADDRESS_SANITIZER_USE_AFTER_RETURN|ARGUMENTS|DISABLE_MAIN_THREAD_CHECKER|DYNAMIC_LIBRARY_LOADS|DYNAMIC_LINKER_API_USAGE|ENVIRONMENT|EXECUTABLE|GUARD_MALLOC|MAIN_THREAD_CHECKER_STOP|MALLOC_GUARD_EDGES|MALLOC_SCRIBBLE|MALLOC_STACK|THREAD_SANITIZER(?:_STOP)?|UNDEFINED_BEHAVIOUR_SANITIZER(?:_STOP)?|ZOMBIE_OBJECTS))|XCTEST)\b/,keyword:/\b(?:add_compile_definitions|add_compile_options|add_custom_command|add_custom_target|add_definitions|add_dependencies|add_executable|add_library|add_link_options|add_subdirectory|add_test|aux_source_directory|break|build_command|build_name|cmake_host_system_information|cmake_minimum_required|cmake_parse_arguments|cmake_policy|configure_file|continue|create_test_sourcelist|ctest_build|ctest_configure|ctest_coverage|ctest_empty_binary_directory|ctest_memcheck|ctest_read_custom_files|ctest_run_script|ctest_sleep|ctest_start|ctest_submit|ctest_test|ctest_update|ctest_upload|define_property|else|elseif|enable_language|enable_testing|endforeach|endfunction|endif|endmacro|endwhile|exec_program|execute_process|export|export_library_dependencies|file|find_file|find_library|find_package|find_path|find_program|fltk_wrap_ui|foreach|function|get_cmake_property|get_directory_property|get_filename_component|get_property|get_source_file_property|get_target_property|get_test_property|if|include|include_directories|include_external_msproject|include_guard|include_regular_expression|install|install_files|install_programs|install_targets|link_directories|link_libraries|list|load_cache|load_command|macro|make_directory|mark_as_advanced|math|message|option|output_required_files|project|qt_wrap_cpp|qt_wrap_ui|remove|remove_definitions|return|separate_arguments|set|set_directory_properties|set_property|set_source_files_properties|set_target_properties|set_tests_properties|site_name|source_group|string|subdir_depends|subdirs|target_compile_definitions|target_compile_features|target_compile_options|target_include_directories|target_link_directories|target_link_libraries|target_link_options|target_sources|try_compile|try_run|unset|use_mangled_mesa|utility_source|variable_requires|variable_watch|while|write_file)(?=\s*\()\b/,boolean:/\b(?:ON|OFF|TRUE|FALSE)\b/,namespace:/\b(?:PROPERTIES|SHARED|PRIVATE|STATIC|PUBLIC|INTERFACE|TARGET_OBJECTS)\b/,operator:/\b(?:NOT|AND|OR|MATCHES|LESS|GREATER|EQUAL|STRLESS|STRGREATER|STREQUAL|VERSION_LESS|VERSION_EQUAL|VERSION_GREATER|DEFINED)\b/,inserted:{pattern:/\b\w+::\w+\b/,alias:"class-name"},number:/\b\d+(?:\.\d+)*\b/,function:/\b[a-z_]\w*(?=\s*\()\b/i,punctuation:/[()>}]|\$[<{]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=coffeescript;coffeescript.displayName="coffeescript";coffeescript.aliases=["coffee"];function coffeescript(Prism){(function(Prism){var comment=/#(?!\{).+/,interpolation={pattern:/#\{[^}]+\}/,alias:"variable"};Prism.languages.coffeescript=Prism.languages.extend("javascript",{comment:comment,string:[{pattern:/'(?:\\[\s\S]|[^\\'])*'/,greedy:true},{pattern:/"(?:\\[\s\S]|[^\\"])*"/,greedy:true,inside:{interpolation:interpolation}}],keyword:/\b(?:and|break|by|catch|class|continue|debugger|delete|do|each|else|extend|extends|false|finally|for|if|in|instanceof|is|isnt|let|loop|namespace|new|no|not|null|of|off|on|or|own|return|super|switch|then|this|throw|true|try|typeof|undefined|unless|until|when|while|window|with|yes|yield)\b/,"class-member":{pattern:/@(?!\d)\w+/,alias:"variable"}});Prism.languages.insertBefore("coffeescript","comment",{"multiline-comment":{pattern:/###[\s\S]+?###/,alias:"comment"},"block-regex":{pattern:/\/{3}[\s\S]*?\/{3}/,alias:"regex",inside:{comment:comment,interpolation:interpolation}}});Prism.languages.insertBefore("coffeescript","string",{"inline-javascript":{pattern:/`(?:\\[\s\S]|[^\\`])*`/,inside:{delimiter:{pattern:/^`|`$/,alias:"punctuation"},rest:Prism.languages.javascript}},"multiline-string":[{pattern:/'''[\s\S]*?'''/,greedy:true,alias:"string"},{pattern:/"""[\s\S]*?"""/,greedy:true,alias:"string",inside:{interpolation:interpolation}}]});Prism.languages.insertBefore("coffeescript","keyword",{property:/(?!\d)\w+(?=\s*:(?!:))/});delete Prism.languages.coffeescript["template-string"];Prism.languages.coffee=Prism.languages.coffeescript})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=concurnas;concurnas.displayName="concurnas";concurnas.aliases=["conc"];function concurnas(Prism){Prism.languages.concurnas={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true,greedy:true}],langext:{pattern:/\w+\s*\|\|[\s\S]+?\|\|/,greedy:true,alias:"string"},function:{pattern:/((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/,lookbehind:true},keyword:/\b(?:abstract|actor|also|annotation|assert|async|await|bool|boolean|break|byte|case|catch|changed|char|class|closed|constant|continue|def|default|del|double|elif|else|enum|every|extends|false|finally|float|for|from|global|gpudef|gpukernel|if|import|in|init|inject|int|lambda|local|long|loop|match|new|nodefault|null|of|onchange|open|out|override|package|parfor|parforsync|post|pre|private|protected|provide|provider|public|return|shared|short|single|size_t|sizeof|super|sync|this|throw|trait|trans|transient|true|try|typedef|unchecked|using|val|var|void|while|with)\b/,boolean:/\b(?:false|true)\b/,number:/\b0b[01][01_]*L?\b|\b0x[\da-f_]*\.?[\da-f_p+-]+\b|(?:\b\d[\d_]*\.?[\d_]*|\B\.\d[\d_]*)(?:e[+-]?\d[\d_]*)?[dfls]?/i,punctuation:/[{}[\];(),.:]/,operator:/<==|>==|=>|->|<-|<>|\^|&==|&<>|!|\?|\?:|\.\?|\+\+|--|[-+*/=<>]=?|\b(?:and|as|band|bor|bxor|comp|is|isnot|mod|or)\b=?/,annotation:{pattern:/@(?:\w+:)?(?:\w*|\[[^\]]+\])/,alias:"builtin"}};Prism.languages.insertBefore("concurnas","langext",{string:{pattern:/[rs]?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true,inside:{interpolation:{pattern:/((?:^|[^\\])(?:\\{2})*){(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}/,lookbehind:true,inside:Prism.languages.concurnas},string:/[\s\S]+/}}});Prism.languages.conc=Prism.languages.concurnas}},function(module,exports,__webpack_require__){"use strict";var refractorRuby=__webpack_require__(115);module.exports=crystal;crystal.displayName="crystal";crystal.aliases=[];function crystal(Prism){Prism.register(refractorRuby);(function(Prism){Prism.languages.crystal=Prism.languages.extend("ruby",{keyword:[/\b(?:abstract|alias|as|asm|begin|break|case|class|def|do|else|elsif|end|ensure|enum|extend|for|fun|if|include|instance_sizeof|lib|macro|module|next|of|out|pointerof|private|protected|rescue|return|require|select|self|sizeof|struct|super|then|type|typeof|uninitialized|union|unless|until|when|while|with|yield|__DIR__|__END_LINE__|__FILE__|__LINE__)\b/,{pattern:/(\.\s*)(?:is_a|responds_to)\?/,lookbehind:true}],number:/\b(?:0b[01_]*[01]|0o[0-7_]*[0-7]|0x[\da-fA-F_]*[\da-fA-F]|(?:\d(?:[\d_]*\d)?)(?:\.[\d_]*\d)?(?:[eE][+-]?[\d_]*\d)?)(?:_(?:[uif](?:8|16|32|64))?)?\b/});Prism.languages.insertBefore("crystal","string",{attribute:{pattern:/@\[.+?\]/,alias:"attr-name",inside:{delimiter:{pattern:/^@\[|\]$/,alias:"tag"},rest:Prism.languages.crystal}},expansion:[{pattern:/\{\{.+?\}\}/,inside:{delimiter:{pattern:/^\{\{|\}\}$/,alias:"tag"},rest:Prism.languages.crystal}},{pattern:/\{%.+?%\}/,inside:{delimiter:{pattern:/^\{%|%\}$/,alias:"tag"},rest:Prism.languages.crystal}}]})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=csp;csp.displayName="csp";csp.aliases=[];function csp(Prism){Prism.languages.csp={directive:{pattern:/\b(?:base-uri|block-all-mixed-content|(?:child|connect|default|font|frame|img|manifest|media|object|script|style|worker)-src|disown-opener|form-action|frame-ancestors|plugin-types|referrer|reflected-xss|report-to|report-uri|require-sri-for|sandbox|upgrade-insecure-requests)\b/i,alias:"keyword"},safe:{pattern:/'(?:self|none|strict-dynamic|(?:nonce-|sha(?:256|384|512)-)[a-zA-Z\d+=/]+)'/,alias:"selector"},unsafe:{pattern:/(?:'unsafe-inline'|'unsafe-eval'|'unsafe-hashed-attributes'|\*)/,alias:"function"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=cssExtras;cssExtras.displayName="cssExtras";cssExtras.aliases=[];function cssExtras(Prism){(function(Prism){var string=/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/;var selectorInside;Prism.languages.css.selector={pattern:Prism.languages.css.selector,inside:selectorInside={"pseudo-element":/:(?:after|before|first-letter|first-line|selection)|::[-\w]+/,"pseudo-class":/:[-\w]+/,class:/\.[-\w]+/,id:/#[-\w]+/,attribute:{pattern:RegExp("\\[(?:[^[\\]\"']|"+string.source+")*\\]"),greedy:true,inside:{punctuation:/^\[|\]$/,"case-sensitivity":{pattern:/(\s)[si]$/i,lookbehind:true,alias:"keyword"},namespace:{pattern:/^(\s*)[-*\w\xA0-\uFFFF]*\|(?!=)/,lookbehind:true,inside:{punctuation:/\|$/}},"attr-name":{pattern:/^(\s*)[-\w\xA0-\uFFFF]+/,lookbehind:true},"attr-value":[string,{pattern:/(=\s*)[-\w\xA0-\uFFFF]+(?=\s*$)/,lookbehind:true}],operator:/[|~*^$]?=/}},"n-th":[{pattern:/(\(\s*)[+-]?\d*[\dn](?:\s*[+-]\s*\d+)?(?=\s*\))/,lookbehind:true,inside:{number:/[\dn]+/,operator:/[+-]/}},{pattern:/(\(\s*)(?:even|odd)(?=\s*\))/i,lookbehind:true}],combinator:/>|\+|~|\|\|/,punctuation:/[(),]/}};Prism.languages.css["atrule"].inside["selector-function-argument"].inside=selectorInside;Prism.languages.insertBefore("css","property",{variable:{pattern:/(^|[^-\w\xA0-\uFFFF])--[-_a-z\xA0-\uFFFF][-\w\xA0-\uFFFF]*/i,lookbehind:true}});var unit={pattern:/(\b\d+)(?:%|[a-z]+\b)/,lookbehind:true};var number={pattern:/(^|[^\w.-])-?\d*\.?\d+/,lookbehind:true};Prism.languages.insertBefore("css","function",{operator:{pattern:/(\s)[+\-*\/](?=\s)/,lookbehind:true},hexcode:{pattern:/\B#(?:[\da-f]{1,2}){3,4}\b/i,alias:"color"},color:[/\b(?:AliceBlue|AntiqueWhite|Aqua|Aquamarine|Azure|Beige|Bisque|Black|BlanchedAlmond|Blue|BlueViolet|Brown|BurlyWood|CadetBlue|Chartreuse|Chocolate|Coral|CornflowerBlue|Cornsilk|Crimson|Cyan|DarkBlue|DarkCyan|DarkGoldenRod|DarkGr[ae]y|DarkGreen|DarkKhaki|DarkMagenta|DarkOliveGreen|DarkOrange|DarkOrchid|DarkRed|DarkSalmon|DarkSeaGreen|DarkSlateBlue|DarkSlateGr[ae]y|DarkTurquoise|DarkViolet|DeepPink|DeepSkyBlue|DimGr[ae]y|DodgerBlue|FireBrick|FloralWhite|ForestGreen|Fuchsia|Gainsboro|GhostWhite|Gold|GoldenRod|Gr[ae]y|Green|GreenYellow|HoneyDew|HotPink|IndianRed|Indigo|Ivory|Khaki|Lavender|LavenderBlush|LawnGreen|LemonChiffon|LightBlue|LightCoral|LightCyan|LightGoldenRodYellow|LightGr[ae]y|LightGreen|LightPink|LightSalmon|LightSeaGreen|LightSkyBlue|LightSlateGr[ae]y|LightSteelBlue|LightYellow|Lime|LimeGreen|Linen|Magenta|Maroon|MediumAquaMarine|MediumBlue|MediumOrchid|MediumPurple|MediumSeaGreen|MediumSlateBlue|MediumSpringGreen|MediumTurquoise|MediumVioletRed|MidnightBlue|MintCream|MistyRose|Moccasin|NavajoWhite|Navy|OldLace|Olive|OliveDrab|Orange|OrangeRed|Orchid|PaleGoldenRod|PaleGreen|PaleTurquoise|PaleVioletRed|PapayaWhip|PeachPuff|Peru|Pink|Plum|PowderBlue|Purple|Red|RosyBrown|RoyalBlue|SaddleBrown|Salmon|SandyBrown|SeaGreen|SeaShell|Sienna|Silver|SkyBlue|SlateBlue|SlateGr[ae]y|Snow|SpringGreen|SteelBlue|Tan|Teal|Thistle|Tomato|Transparent|Turquoise|Violet|Wheat|White|WhiteSmoke|Yellow|YellowGreen)\b/i,{pattern:/\b(?:rgb|hsl)\(\s*\d{1,3}\s*,\s*\d{1,3}%?\s*,\s*\d{1,3}%?\s*\)\B|\b(?:rgb|hsl)a\(\s*\d{1,3}\s*,\s*\d{1,3}%?\s*,\s*\d{1,3}%?\s*,\s*(?:0|0?\.\d+|1)\s*\)\B/i,inside:{unit:unit,number:number,function:/[\w-]+(?=\()/,punctuation:/[(),]/}}],entity:/\\[\da-f]{1,8}/i,unit:unit,number:number})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=css;css.displayName="css";css.aliases=[];function css(Prism){(function(Prism){var string=/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/;Prism.languages.css={comment:/\/\*[\s\S]*?\*\//,atrule:{pattern:/@[\w-]+[\s\S]*?(?:;|(?=\s*\{))/,inside:{rule:/^@[\w-]+/,"selector-function-argument":{pattern:/(\bselector\s*\((?!\s*\))\s*)(?:[^()]|\((?:[^()]|\([^()]*\))*\))+?(?=\s*\))/,lookbehind:true,alias:"selector"},keyword:{pattern:/(^|[^\w-])(?:and|not|only|or)(?![\w-])/,lookbehind:true}}},url:{pattern:RegExp("\\burl\\((?:"+string.source+"|"+/(?:[^\\\r\n()"']|\\[\s\S])*/.source+")\\)","i"),greedy:true,inside:{function:/^url/i,punctuation:/^\(|\)$/,string:{pattern:RegExp("^"+string.source+"$"),alias:"url"}}},selector:RegExp("[^{}\\s](?:[^{};\"']|"+string.source+")*?(?=\\s*\\{)"),string:{pattern:string,greedy:true},property:/[-_a-z\xA0-\uFFFF][-\w\xA0-\uFFFF]*(?=\s*:)/i,important:/!important\b/i,function:/[-a-z0-9]+(?=\()/i,punctuation:/[(){};:,]/};Prism.languages.css["atrule"].inside.rest=Prism.languages.css;var markup=Prism.languages.markup;if(markup){markup.tag.addInlined("style","css");Prism.languages.insertBefore("inside","attr-value",{"style-attr":{pattern:/\s*style=("|')(?:\\[\s\S]|(?!\1)[^\\])*\1/i,inside:{"attr-name":{pattern:/^\s*style/i,inside:markup.tag.inside},punctuation:/^\s*=\s*['"]|['"]\s*$/,"attr-value":{pattern:/.+/i,inside:Prism.languages.css}},alias:"language-css"}},markup.tag)}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=cypher;cypher.displayName="cypher";cypher.aliases=[];function cypher(Prism){Prism.languages.cypher={comment:/\/\/.*/,string:{pattern:/"(?:[^"\\\r\n]|\\.)*"|'(?:[^'\\\r\n]|\\.)*'/,greedy:true},"class-name":{pattern:/(:\s*)(?:\w+|`(?:[^`\\\r\n])*`)(?=\s*[{):])/,lookbehind:true,greedy:true},relationship:{pattern:/(-\[\s*(?:\w+\s*|`(?:[^`\\\r\n])*`\s*)?:\s*|\|\s*:\s*)(?:\w+|`(?:[^`\\\r\n])*`)/,lookbehind:true,greedy:true,alias:"property"},identifier:{pattern:/`(?:[^`\\\r\n])*`/,greedy:true,alias:"symbol"},variable:/\$\w+/,keyword:/\b(?:ADD|ALL|AND|AS|ASC|ASCENDING|ASSERT|BY|CALL|CASE|COMMIT|CONSTRAINT|CONTAINS|CREATE|CSV|DELETE|DESC|DESCENDING|DETACH|DISTINCT|DO|DROP|ELSE|END|ENDS|EXISTS|FOR|FOREACH|IN|INDEX|IS|JOIN|KEY|LIMIT|LOAD|MANDATORY|MATCH|MERGE|NODE|NOT|OF|ON|OPTIONAL|OR|ORDER(?=\s+BY)|PERIODIC|REMOVE|REQUIRE|RETURN|SCALAR|SCAN|SET|SKIP|START|STARTS|THEN|UNION|UNIQUE|UNWIND|USING|WHEN|WHERE|WITH|XOR|YIELD)\b/i,function:/\b\w+\b(?=\s*\()/,boolean:/\b(?:true|false|null)\b/i,number:/\b(?:0x[\da-fA-F]+|\d+(?:\.\d+)?(?:[eE][+-]?\d+)?)\b/,operator:/:|<--?|--?>?|<>|=~?|[<>]=?|[+*/%^|]|\.\.\.?/,punctuation:/[()[\]{},;.]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=d;d.displayName="d";d.aliases=[];function d(Prism){Prism.languages.d=Prism.languages.extend("clike",{comment:[{pattern:/^\s*#!.+/,greedy:true},{pattern:RegExp(/(^|[^\\])/.source+"(?:"+[/\/\+(?:\/\+(?:[^+]|\+(?!\/))*\+\/|(?!\/\+)[\s\S])*?\+\//.source,/\/\/.*/.source,/\/\*[\s\S]*?\*\//.source].join("|")+")"),lookbehind:true,greedy:true}],string:[{pattern:RegExp([/\b[rx]"(?:\\[\s\S]|[^\\"])*"[cwd]?/.source,/\bq"(?:\[[\s\S]*?\]|\([\s\S]*?\)|<[\s\S]*?>|\{[\s\S]*?\})"/.source,/\bq"((?!\d)\w+)$[\s\S]*?^\1"/.source,/\bq"(.)[\s\S]*?\2"/.source,/'(?:\\(?:\W|\w+)|[^\\])'/.source,/(["`])(?:\\[\s\S]|(?!\3)[^\\])*\3[cwd]?/.source].join("|"),"m"),greedy:true},{pattern:/\bq\{(?:\{[^{}]*\}|[^{}])*\}/,greedy:true,alias:"token-string"}],number:[/\b0x\.?[a-f\d_]+(?:(?!\.\.)\.[a-f\d_]*)?(?:p[+-]?[a-f\d_]+)?[ulfi]*/i,{pattern:/((?:\.\.)?)(?:\b0b\.?|\b|\.)\d[\d_]*(?:(?!\.\.)\.[\d_]*)?(?:e[+-]?\d[\d_]*)?[ulfi]*/i,lookbehind:true}],keyword:/\$|\b(?:abstract|alias|align|asm|assert|auto|body|bool|break|byte|case|cast|catch|cdouble|cent|cfloat|char|class|const|continue|creal|dchar|debug|default|delegate|delete|deprecated|do|double|else|enum|export|extern|false|final|finally|float|for|foreach|foreach_reverse|function|goto|idouble|if|ifloat|immutable|import|inout|int|interface|invariant|ireal|lazy|long|macro|mixin|module|new|nothrow|null|out|override|package|pragma|private|protected|public|pure|real|ref|return|scope|shared|short|static|struct|super|switch|synchronized|template|this|throw|true|try|typedef|typeid|typeof|ubyte|ucent|uint|ulong|union|unittest|ushort|version|void|volatile|wchar|while|with|__(?:(?:FILE|MODULE|LINE|FUNCTION|PRETTY_FUNCTION|DATE|EOF|TIME|TIMESTAMP|VENDOR|VERSION)__|gshared|traits|vector|parameters)|string|wstring|dstring|size_t|ptrdiff_t)\b/,operator:/\|[|=]?|&[&=]?|\+[+=]?|-[-=]?|\.?\.\.|=[>=]?|!(?:i[ns]\b|<>?=?|>=?|=)?|\bi[ns]\b|(?:<[<>]?|>>?>?|\^\^|[*\/%^~])=?/});Prism.languages.insertBefore("d","keyword",{property:/\B@\w*/});Prism.languages.insertBefore("d","function",{register:{pattern:/\b(?:[ABCD][LHX]|E[ABCD]X|E?(?:BP|SP|DI|SI)|[ECSDGF]S|CR[0234]|DR[012367]|TR[3-7]|X?MM[0-7]|R[ABCD]X|[BS]PL|R[BS]P|[DS]IL|R[DS]I|R(?:[89]|1[0-5])[BWD]?|XMM(?:[89]|1[0-5])|YMM(?:1[0-5]|\d))\b|\bST(?:\([0-7]\)|\b)/,alias:"variable"}})}},function(module,exports,__webpack_require__){"use strict";module.exports=dart;dart.displayName="dart";dart.aliases=[];function dart(Prism){Prism.languages.dart=Prism.languages.extend("clike",{string:[{pattern:/r?("""|''')[\s\S]*?\1/,greedy:true},{pattern:/r?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true}],keyword:[/\b(?:async|sync|yield)\*/,/\b(?:abstract|assert|async|await|break|case|catch|class|const|continue|covariant|default|deferred|do|dynamic|else|enum|export|extension|external|extends|factory|final|finally|for|Function|get|hide|if|implements|interface|import|in|library|mixin|new|null|on|operator|part|rethrow|return|set|show|static|super|switch|sync|this|throw|try|typedef|var|void|while|with|yield)\b/],operator:/\bis!|\b(?:as|is)\b|\+\+|--|&&|\|\||<<=?|>>=?|~(?:\/=?)?|[+\-*\/%&^|=!<>]=?|\?/});Prism.languages.insertBefore("dart","function",{metadata:{pattern:/@\w+/,alias:"symbol"}})}},function(module,exports,__webpack_require__){"use strict";module.exports=dax;dax.displayName="dax";dax.aliases=[];function dax(Prism){Prism.languages.dax={comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|(?:--|\/\/).*)/,lookbehind:true},"data-field":{pattern:/'(?:[^']|'')*'(?!')(?:\[[ \w\xA0-\uFFFF]+\])?|\w+\[[ \w\xA0-\uFFFF]+\]/,alias:"symbol"},measure:{pattern:/\[[ \w\xA0-\uFFFF]+\]/,alias:"constant"},string:{pattern:/"(?:[^"]|"")*"(?!")/,greedy:true},function:/\b(?:ABS|ACOS|ACOSH|ACOT|ACOTH|ADDCOLUMNS|ADDMISSINGITEMS|ALL|ALLCROSSFILTERED|ALLEXCEPT|ALLNOBLANKROW|ALLSELECTED|AND|APPROXIMATEDISTINCTCOUNT|ASIN|ASINH|ATAN|ATANH|AVERAGE|AVERAGEA|AVERAGEX|BETA\.DIST|BETA\.INV|BLANK|CALCULATE|CALCULATETABLE|CALENDAR|CALENDARAUTO|CEILING|CHISQ\.DIST|CHISQ\.DIST\.RT|CHISQ\.INV|CHISQ\.INV\.RT|CLOSINGBALANCEMONTH|CLOSINGBALANCEQUARTER|CLOSINGBALANCEYEAR|COALESCE|COMBIN|COMBINA|COMBINEVALUES|CONCATENATE|CONCATENATEX|CONFIDENCE\.NORM|CONFIDENCE\.T|CONTAINS|CONTAINSROW|CONTAINSSTRING|CONTAINSSTRINGEXACT|CONVERT|COS|COSH|COT|COTH|COUNT|COUNTA|COUNTAX|COUNTBLANK|COUNTROWS|COUNTX|CROSSFILTER|CROSSJOIN|CURRENCY|CURRENTGROUP|CUSTOMDATA|DATATABLE|DATE|DATEADD|DATEDIFF|DATESBETWEEN|DATESINPERIOD|DATESMTD|DATESQTD|DATESYTD|DATEVALUE|DAY|DEGREES|DETAILROWS|DISTINCT|DISTINCTCOUNT|DISTINCTCOUNTNOBLANK|DIVIDE|EARLIER|EARLIEST|EDATE|ENDOFMONTH|ENDOFQUARTER|ENDOFYEAR|EOMONTH|ERROR|EVEN|EXACT|EXCEPT|EXP|EXPON\.DIST|FACT|FALSE|FILTER|FILTERS|FIND|FIRSTDATE|FIRSTNONBLANK|FIRSTNONBLANKVALUE|FIXED|FLOOR|FORMAT|GCD|GENERATE|GENERATEALL|GENERATESERIES|GEOMEAN|GEOMEANX|GROUPBY|HASONEFILTER|HASONEVALUE|HOUR|IF|IF\.EAGER|IFERROR|IGNORE|INT|INTERSECT|ISBLANK|ISCROSSFILTERED|ISEMPTY|ISERROR|ISEVEN|ISFILTERED|ISINSCOPE|ISLOGICAL|ISNONTEXT|ISNUMBER|ISO\.CEILING|ISODD|ISONORAFTER|ISSELECTEDMEASURE|ISSUBTOTAL|ISTEXT|KEEPFILTERS|KEYWORDMATCH|LASTDATE|LASTNONBLANK|LASTNONBLANKVALUE|LCM|LEFT|LEN|LN|LOG|LOG10|LOOKUPVALUE|LOWER|MAX|MAXA|MAXX|MEDIAN|MEDIANX|MID|MIN|MINA|MINUTE|MINX|MOD|MONTH|MROUND|NATURALINNERJOIN|NATURALLEFTOUTERJOIN|NEXTDAY|NEXTMONTH|NEXTQUARTER|NEXTYEAR|NONVISUAL|NORM\.DIST|NORM\.INV|NORM\.S\.DIST|NORM\.S\.INV|NOT|NOW|ODD|OPENINGBALANCEMONTH|OPENINGBALANCEQUARTER|OPENINGBALANCEYEAR|OR|PARALLELPERIOD|PATH|PATHCONTAINS|PATHITEM|PATHITEMREVERSE|PATHLENGTH|PERCENTILE\.EXC|PERCENTILE\.INC|PERCENTILEX\.EXC|PERCENTILEX\.INC|PERMUT|PI|POISSON\.DIST|POWER|PREVIOUSDAY|PREVIOUSMONTH|PREVIOUSQUARTER|PREVIOUSYEAR|PRODUCT|PRODUCTX|QUARTER|QUOTIENT|RADIANS|RAND|RANDBETWEEN|RANK\.EQ|RANKX|RELATED|RELATEDTABLE|REMOVEFILTERS|REPLACE|REPT|RIGHT|ROLLUP|ROLLUPADDISSUBTOTAL|ROLLUPGROUP|ROLLUPISSUBTOTAL|ROUND|ROUNDDOWN|ROUNDUP|ROW|SAMEPERIODLASTYEAR|SAMPLE|SEARCH|SECOND|SELECTCOLUMNS|SELECTEDMEASURE|SELECTEDMEASUREFORMATSTRING|SELECTEDMEASURENAME|SELECTEDVALUE|SIGN|SIN|SINH|SQRT|SQRTPI|STARTOFMONTH|STARTOFQUARTER|STARTOFYEAR|STDEV\.P|STDEV\.S|STDEVX\.P|STDEVX\.S|SUBSTITUTE|SUBSTITUTEWITHINDEX|SUM|SUMMARIZE|SUMMARIZECOLUMNS|SUMX|SWITCH|T\.DIST|T\.DIST\.2T|T\.DIST\.RT|T\.INV|T\.INV\.2T|TAN|TANH|TIME|TIMEVALUE|TODAY|TOPN|TOPNPERLEVEL|TOPNSKIP|TOTALMTD|TOTALQTD|TOTALYTD|TREATAS|TRIM|TRUE|TRUNC|UNICHAR|UNICODE|UNION|UPPER|USERELATIONSHIP|USERNAME|USEROBJECTID|USERPRINCIPALNAME|UTCNOW|UTCTODAY|VALUE|VALUES|VAR\.P|VAR\.S|VARX\.P|VARX\.S|WEEKDAY|WEEKNUM|XIRR|XNPV|YEAR|YEARFRAC)(?=\s*\()/i,keyword:/\b(?:DEFINE|MEASURE|EVALUATE|ORDER\s+BY|RETURN|VAR|START\s+AT|ASC|DESC)\b/i,boolean:{pattern:/\b(?:TRUE|FALSE|NULL)\b/i,alias:"constant"},number:/\b\d+\.?\d*|\B\.\d+\b/i,operator:/:=|[-+*\/=^]|&&?|\|\||<(?:=>?|<|>)?|>[>=]?|\b(?:IN|NOT)\b/i,punctuation:/[;\[\](){}`,.]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=dhall;dhall.displayName="dhall";dhall.aliases=[];function dhall(Prism){Prism.languages.dhall={comment:/--.*|\{-(?:[^-{]|-(?!\})|\{(?!-)|\{-(?:[^-{]|-(?!\})|\{(?!-))*-\})*-\}/,string:{pattern:/"(?:[^"\\]|\\.)*"|''(?:[^']|'(?!')|'''|''\$\{)*''(?!'|\$)/,greedy:true,inside:{interpolation:{pattern:/\$\{[^{}]*\}/,inside:{expression:{pattern:/(^\$\{)[\s\S]+(?=\}$)/,lookbehind:true,alias:"language-dhall",inside:null},punctuation:/\$\{|\}/}}}},label:{pattern:/`[^`]*`/,greedy:true},url:{pattern:/\bhttps?:\/\/[\w.:%!$&'*+;=@~-]+(?:\/[\w.:%!$&'*+;=@~-]*)*(?:\?[/?\w.:%!$&'*+;=@~-]*)?/,greedy:true},env:{pattern:/\benv:(?:(?!\d)\w+|"(?:[^"\\=]|\\.)*")/,greedy:true,inside:{function:/^env/,operator:/^:/,variable:/[\s\S]+/}},hash:{pattern:/\bsha256:[\da-fA-F]{64}\b/,inside:{function:/sha256/,operator:/:/,number:/[\da-fA-F]{64}/}},keyword:/\b(?:as|assert|else|forall|if|in|let|merge|missing|then|toMap|using|with)\b|\u2200/,builtin:/\b(?:Some|None)\b/,boolean:/\b(?:False|True)\b/,number:/\bNaN\b|-?\bInfinity\b|[+-]?\b(?:0x[\da-fA-F]+|\d+(?:\.\d+)?(?:e[+-]?\d+)?)\b/,operator:/\/\\|\/\/\\\\|&&|\|\||[!=]=|===|\/\/|->|\+\+|::|[+*#@=:?<>|\\\u2227\u2a53\u2261\u2afd\u03bb\u2192]/,punctuation:/\.\.|[{}\[\](),./]/,"class-name":/\b[A-Z]\w*\b/};Prism.languages.dhall.string.inside.interpolation.inside.expression.inside=Prism.languages.dhall}},function(module,exports,__webpack_require__){"use strict";module.exports=diff;diff.displayName="diff";diff.aliases=[];function diff(Prism){(function(Prism){Prism.languages.diff={coord:[/^(?:\*{3}|-{3}|\+{3}).*$/m,/^@@.*@@$/m,/^\d+.*$/m]};var PREFIXES={"deleted-sign":"-","deleted-arrow":"<","inserted-sign":"+","inserted-arrow":">",unchanged:" ",diff:"!"};Object.keys(PREFIXES).forEach((function(name){var prefix=PREFIXES[name];var alias=[];if(!/^\w+$/.test(name)){alias.push(/\w+/.exec(name)[0])}if(name==="diff"){alias.push("bold")}Prism.languages.diff[name]={pattern:RegExp("^(?:["+prefix+"].*(?:\r\n?|\n|(?![\\s\\S])))+","m"),alias:alias,inside:{line:{pattern:/(.)(?=[\s\S]).*(?:\r\n?|\n)?/,lookbehind:true},prefix:{pattern:/[\s\S]/,alias:/\w+/.exec(name)[0]}}}}));Object.defineProperty(Prism.languages.diff,"PREFIXES",{value:PREFIXES})})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=django;django.displayName="django";django.aliases=["jinja2"];function django(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.django={comment:/^{#[\s\S]*?#}$/,tag:{pattern:/(^{%[+-]?\s*)\w+/,lookbehind:true,alias:"keyword"},delimiter:{pattern:/^{[{%][+-]?|[+-]?[}%]}$/,alias:"punctuation"},string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},filter:{pattern:/(\|)\w+/,lookbehind:true,alias:"function"},test:{pattern:/(\bis\s+(?:not\s+)?)(?!not\b)\w+/,lookbehind:true,alias:"function"},function:/\b[a-z_]\w+(?=\s*\()/i,keyword:/\b(?:and|as|by|else|for|if|import|in|is|loop|not|or|recursive|with|without)\b/,operator:/[-+*/%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]/,number:/\b\d+(?:\.\d+)?\b/,boolean:/[Tt]rue|[Ff]alse|[Nn]one/,variable:/\b\w+?\b/,punctuation:/[{}[\](),.:;]/};var pattern=/{{[\s\S]*?}}|{%[\s\S]*?%}|{#[\s\S]*?#}/g;var markupTemplating=Prism.languages["markup-templating"];Prism.hooks.add("before-tokenize",(function(env){markupTemplating.buildPlaceholders(env,"django",pattern)}));Prism.hooks.add("after-tokenize",(function(env){markupTemplating.tokenizePlaceholders(env,"django")}));Prism.languages.jinja2=Prism.languages.django;Prism.hooks.add("before-tokenize",(function(env){markupTemplating.buildPlaceholders(env,"jinja2",pattern)}));Prism.hooks.add("after-tokenize",(function(env){markupTemplating.tokenizePlaceholders(env,"jinja2")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=dnsZoneFile;dnsZoneFile.displayName="dnsZoneFile";dnsZoneFile.aliases=[];function dnsZoneFile(Prism){Prism.languages["dns-zone-file"]={comment:/;.*/,string:{pattern:/"(?:\\.|[^"\\\r\n])*"/,greedy:true},variable:[{pattern:/(^\$ORIGIN[ \t]+)\S+/m,lookbehind:true},{pattern:/(^|\s)@(?=\s|$)/,lookbehind:true}],keyword:/^\$(?:ORIGIN|INCLUDE|TTL)(?=\s|$)/m,class:{pattern:/(^|\s)(?:IN|CH|CS|HS)(?=\s|$)/,lookbehind:true,alias:"keyword"},type:{pattern:/(^|\s)(?:A|A6|AAAA|AFSDB|APL|ATMA|CAA|CDNSKEY|CDS|CERT|CNAME|DHCID|DLV|DNAME|DNSKEY|DS|EID|GID|GPOS|HINFO|HIP|IPSECKEY|ISDN|KEY|KX|LOC|MAILA|MAILB|MB|MD|MF|MG|MINFO|MR|MX|NAPTR|NB|NBSTAT|NIMLOC|NINFO|NS|NSAP|NSAP-PTR|NSEC|NSEC3|NSEC3PARAM|NULL|NXT|OPENPGPKEY|PTR|PX|RKEY|RP|RRSIG|RT|SIG|SINK|SMIMEA|SOA|SPF|SRV|SSHFP|TA|TKEY|TLSA|TSIG|TXT|UID|UINFO|UNSPEC|URI|WKS|X25)(?=\s|$)/,lookbehind:true,alias:"keyword"},punctuation:/[()]/};Prism.languages["dns-zone"]=Prism.languages["dns-zone-file"]}},function(module,exports,__webpack_require__){"use strict";module.exports=docker;docker.displayName="docker";docker.aliases=["dockerfile"];function docker(Prism){Prism.languages.docker={keyword:{pattern:/(^\s*)(?:ADD|ARG|CMD|COPY|ENTRYPOINT|ENV|EXPOSE|FROM|HEALTHCHECK|LABEL|MAINTAINER|ONBUILD|RUN|SHELL|STOPSIGNAL|USER|VOLUME|WORKDIR)(?=\s)/im,lookbehind:true},string:/("|')(?:(?!\1)[^\\\r\n]|\\(?:\r\n|[\s\S]))*\1/,comment:{pattern:/#.*/,greedy:true},punctuation:/---|\.\.\.|[:[\]{}\-,|>?]/};Prism.languages.dockerfile=Prism.languages.docker}},function(module,exports,__webpack_require__){"use strict";module.exports=ebnf;ebnf.displayName="ebnf";ebnf.aliases=[];function ebnf(Prism){Prism.languages.ebnf={comment:/\(\*[\s\S]*?\*\)/,string:{pattern:/"[^"\r\n]*"|'[^'\r\n]*'/,greedy:true},special:{pattern:/\?[^?\r\n]*\?/,greedy:true,alias:"class-name"},definition:{pattern:/^(\s*)[a-z]\w*(?:[ \t]+[a-z]\w*)*(?=\s*=)/im,lookbehind:true,alias:["rule","keyword"]},rule:/\b[a-z]\w*(?:[ \t]+[a-z]\w*)*\b/i,punctuation:/\([:/]|[:/]\)|[.,;()[\]{}]/,operator:/[-=|*/!]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=editorconfig;editorconfig.displayName="editorconfig";editorconfig.aliases=[];function editorconfig(Prism){Prism.languages.editorconfig={comment:/[;#].*/,section:{pattern:/(^[ \t]*)\[.+]/m,lookbehind:true,alias:"keyword",inside:{regex:/\\\\[\[\]{},!?.*]/,operator:/[!?]|\.\.|\*{1,2}/,punctuation:/[\[\]{},]/}},property:{pattern:/(^[ \t]*)[^\s=]+(?=[ \t]*=)/m,lookbehind:true},value:{pattern:/=.*/,alias:"string",inside:{punctuation:/^=/}}}}},function(module,exports,__webpack_require__){"use strict";module.exports=eiffel;eiffel.displayName="eiffel";eiffel.aliases=[];function eiffel(Prism){Prism.languages.eiffel={comment:/--.*/,string:[{pattern:/"([^[]*)\[[\s\S]*?\]\1"/,greedy:true},{pattern:/"([^{]*)\{[\s\S]*?\}\1"/,greedy:true},{pattern:/"(?:%\s*\n\s*%|%.|[^%"\r\n])*"/,greedy:true}],char:/'(?:%.|[^%'\r\n])+'/,keyword:/\b(?:across|agent|alias|all|and|attached|as|assign|attribute|check|class|convert|create|Current|debug|deferred|detachable|do|else|elseif|end|ensure|expanded|export|external|feature|from|frozen|if|implies|inherit|inspect|invariant|like|local|loop|not|note|obsolete|old|once|or|Precursor|redefine|rename|require|rescue|Result|retry|select|separate|some|then|undefine|until|variant|Void|when|xor)\b/i,boolean:/\b(?:True|False)\b/i,"class-name":{pattern:/\b[A-Z][\dA-Z_]*\b/,alias:"builtin"},number:[/\b0[xcb][\da-f](?:_*[\da-f])*\b/i,/(?:\b\d(?:_*\d)*)?\.(?:(?:\d(?:_*\d)*)?e[+-]?)?\d(?:_*\d)*\b|\b\d(?:_*\d)*\b\.?/i],punctuation:/:=|<<|>>|\(\||\|\)|->|\.(?=\w)|[{}[\];(),:?]/,operator:/\\\\|\|\.\.\||\.\.|\/[~\/=]?|[><]=?|[-+*^=~]/}}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=ejs;ejs.displayName="ejs";ejs.aliases=["eta"];function ejs(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.ejs={delimiter:{pattern:/^<%[-_=]?|[-_]?%>$/,alias:"punctuation"},comment:/^#[\s\S]*/,"language-javascript":{pattern:/[\s\S]+/,inside:Prism.languages.javascript}};Prism.hooks.add("before-tokenize",(function(env){var ejsPattern=/<%(?!%)[\s\S]+?%>/g;Prism.languages["markup-templating"].buildPlaceholders(env,"ejs",ejsPattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"ejs")}));Prism.languages.eta=Prism.languages.ejs})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=elixir;elixir.displayName="elixir";elixir.aliases=[];function elixir(Prism){Prism.languages.elixir={comment:/#.*/m,regex:{pattern:/~[rR](?:("""|''')(?:\\[\s\S]|(?!\1)[^\\])+\1|([\/|"'])(?:\\.|(?!\2)[^\\\r\n])+\2|\((?:\\.|[^\\)\r\n])+\)|\[(?:\\.|[^\\\]\r\n])+\]|\{(?:\\.|[^\\}\r\n])+\}|<(?:\\.|[^\\>\r\n])+>)[uismxfr]*/,greedy:true},string:[{pattern:/~[cCsSwW](?:("""|''')(?:\\[\s\S]|(?!\1)[^\\])+\1|([\/|"'])(?:\\.|(?!\2)[^\\\r\n])+\2|\((?:\\.|[^\\)\r\n])+\)|\[(?:\\.|[^\\\]\r\n])+\]|\{(?:\\.|#\{[^}]+\}|#(?!\{)|[^#\\}\r\n])+\}|<(?:\\.|[^\\>\r\n])+>)[csa]?/,greedy:true,inside:{}},{pattern:/("""|''')[\s\S]*?\1/,greedy:true,inside:{}},{pattern:/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true,inside:{}}],atom:{pattern:/(^|[^:]):\w+/,lookbehind:true,alias:"symbol"},"attr-name":/\w+\??:(?!:)/,capture:{pattern:/(^|[^&])&(?:[^&\s\d()][^\s()]*|(?=\())/,lookbehind:true,alias:"function"},argument:{pattern:/(^|[^&])&\d+/,lookbehind:true,alias:"variable"},attribute:{pattern:/@\w+/,alias:"variable"},number:/\b(?:0[box][a-f\d_]+|\d[\d_]*)(?:\.[\d_]+)?(?:e[+-]?[\d_]+)?\b/i,keyword:/\b(?:after|alias|and|case|catch|cond|def(?:callback|exception|impl|module|p|protocol|struct)?|do|else|end|fn|for|if|import|not|or|require|rescue|try|unless|use|when)\b/,boolean:/\b(?:true|false|nil)\b/,operator:[/\bin\b|&&?|\|[|>]?|\\\\|::|\.\.\.?|\+\+?|-[->]?|<[-=>]|>=|!==?|\B!|=(?:==?|[>~])?|[*\/^]/,{pattern:/([^<])<(?!<)/,lookbehind:true},{pattern:/([^>])>(?!>)/,lookbehind:true}],punctuation:/<<|>>|[.,%\[\]{}()]/};Prism.languages.elixir.string.forEach((function(o){o.inside={interpolation:{pattern:/#\{[^}]+\}/,inside:{delimiter:{pattern:/^#\{|\}$/,alias:"punctuation"},rest:Prism.languages.elixir}}}}))}},function(module,exports,__webpack_require__){"use strict";module.exports=elm;elm.displayName="elm";elm.aliases=[];function elm(Prism){Prism.languages.elm={comment:/--.*|{-[\s\S]*?-}/,char:{pattern:/'(?:[^\\'\r\n]|\\(?:[abfnrtv\\']|\d+|x[0-9a-fA-F]+))'/,greedy:true},string:[{pattern:/"""[\s\S]*?"""/,greedy:true},{pattern:/"(?:[^\\"\r\n]|\\(?:[abfnrtv\\"]|\d+|x[0-9a-fA-F]+))*"/,greedy:true}],import_statement:{pattern:/^\s*import\s+[A-Z]\w*(?:\.[A-Z]\w*)*(?:\s+as\s+(?:[A-Z]\w*)(?:\.[A-Z]\w*)*)?(?:\s+exposing\s+)?/m,inside:{keyword:/\b(?:import|as|exposing)\b/}},keyword:/\b(?:alias|as|case|else|exposing|if|in|infixl|infixr|let|module|of|then|type)\b/,builtin:/\b(?:abs|acos|always|asin|atan|atan2|ceiling|clamp|compare|cos|curry|degrees|e|flip|floor|fromPolar|identity|isInfinite|isNaN|logBase|max|min|negate|never|not|pi|radians|rem|round|sin|sqrt|tan|toFloat|toPolar|toString|truncate|turns|uncurry|xor)\b/,number:/\b(?:\d+(?:\.\d+)?(?:e[+-]?\d+)?|0x[0-9a-f]+)\b/i,operator:/\s\.\s|[+\-/*=.$<>:&|^?%#@~!]{2,}|[+\-/*=$<>:&|^?%#@~!]/,hvariable:/\b(?:[A-Z]\w*\.)*[a-z]\w*\b/,constant:/\b(?:[A-Z]\w*\.)*[A-Z]\w*\b/,punctuation:/[{}[\]|(),.:]/}}},function(module,exports,__webpack_require__){"use strict";var refractorRuby=__webpack_require__(115);var refractorMarkupTemplating=__webpack_require__(63);module.exports=erb;erb.displayName="erb";erb.aliases=[];function erb(Prism){Prism.register(refractorRuby);Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.erb=Prism.languages.extend("ruby",{});Prism.languages.insertBefore("erb","comment",{delimiter:{pattern:/^<%=?|%>$/,alias:"punctuation"}});Prism.hooks.add("before-tokenize",(function(env){var erbPattern=/<%=?(?:[^\r\n]|[\r\n](?!=begin)|[\r\n]=begin\s[\s\S]*?^=end)+?%>/gm;Prism.languages["markup-templating"].buildPlaceholders(env,"erb",erbPattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"erb")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=erlang;erlang.displayName="erlang";erlang.aliases=[];function erlang(Prism){Prism.languages.erlang={comment:/%.+/,string:{pattern:/"(?:\\.|[^\\"\r\n])*"/,greedy:true},"quoted-function":{pattern:/'(?:\\.|[^\\'\r\n])+'(?=\()/,alias:"function"},"quoted-atom":{pattern:/'(?:\\.|[^\\'\r\n])+'/,alias:"atom"},boolean:/\b(?:true|false)\b/,keyword:/\b(?:fun|when|case|of|end|if|receive|after|try|catch)\b/,number:[/\$\\?./,/\d+#[a-z0-9]+/i,/(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i],function:/\b[a-z][\w@]*(?=\()/,variable:{pattern:/(^|[^@])(?:\b|\?)[A-Z_][\w@]*/,lookbehind:true},operator:[/[=\/<>:]=|=[:\/]=|\+\+?|--?|[=*\/!]|\b(?:bnot|div|rem|band|bor|bxor|bsl|bsr|not|and|or|xor|orelse|andalso)\b/,{pattern:/(^|[^<])<(?!<)/,lookbehind:true},{pattern:/(^|[^>])>(?!>)/,lookbehind:true}],atom:/\b[a-z][\w@]*/,punctuation:/[()[\]{}:;,.#|]|<<|>>/}}},function(module,exports,__webpack_require__){"use strict";var refractorLua=__webpack_require__(179);var refractorMarkupTemplating=__webpack_require__(63);module.exports=etlua;etlua.displayName="etlua";etlua.aliases=[];function etlua(Prism){Prism.register(refractorLua);Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.etlua={delimiter:{pattern:/^<%[-=]?|-?%>$/,alias:"punctuation"},"language-lua":{pattern:/[\s\S]+/,inside:Prism.languages.lua}};Prism.hooks.add("before-tokenize",(function(env){var pattern=/<%[\s\S]+?%>/g;Prism.languages["markup-templating"].buildPlaceholders(env,"etlua",pattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"etlua")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=excelFormula;excelFormula.displayName="excelFormula";excelFormula.aliases=[];function excelFormula(Prism){Prism.languages["excel-formula"]={comment:{pattern:/(\bN\(\s*)"(?:[^"]|"")*"(?=\s*\))/i,lookbehind:true,greedy:true},string:{pattern:/"(?:[^"]|"")*"(?!")/,greedy:true},reference:{pattern:/(?:'[^']*'|(?:[^\s()[\]{}<>*?"';,$&]*\[[^^\s()[\]{}<>*?"']+\])?\w+)!/,greedy:true,alias:"string",inside:{operator:/!$/,punctuation:/'/,sheet:{pattern:/[^[\]]+$/,alias:"function"},file:{pattern:/\[[^[\]]+\]$/,inside:{punctuation:/[[\]]/}},path:/[\s\S]+/}},"function-name":{pattern:/\b[A-Z]\w*(?=\()/i,alias:"keyword"},range:{pattern:/\$?\b(?:[A-Z]+\$?\d+:\$?[A-Z]+\$?\d+|[A-Z]+:\$?[A-Z]+|\d+:\$?\d+)\b/i,alias:"property",inside:{operator:/:/,cell:/\$?[A-Z]+\$?\d+/i,column:/\$?[A-Z]+/i,row:/\$?\d+/}},cell:{pattern:/\b[A-Z]+\d+\b|\$[A-Za-z]+\$?\d+\b|\b[A-Za-z]+\$\d+\b/,alias:"property"},number:/(?:\b\d+(?:\.\d+)?|\B\.\d+)(?:e[+-]?\d+)?\b/i,boolean:/\b(?:TRUE|FALSE)\b/i,operator:/[-+*/^%=&,]|<[=>]?|>=?/,punctuation:/[[\]();{}|]/};Prism.languages["xlsx"]=Prism.languages["xls"]=Prism.languages["excel-formula"]}},function(module,exports,__webpack_require__){"use strict";module.exports=factor;factor.displayName="factor";factor.aliases=[];function factor(Prism){(function(Prism){var comment_inside={function:/\b(?:TODOS?|FIX(?:MES?)?|NOTES?|BUGS?|XX+|HACKS?|WARN(?:ING)?|\?{2,}|!{2,})\b/};var string_inside={number:/\\[^\s']|%\w/};var factor={comment:[{pattern:/(^|\s)(?:! .*|!$)/,lookbehind:true,inside:comment_inside},{pattern:/(^|\s)\/\*\s[\s\S]*?\*\/(?=\s|$)/,lookbehind:true,greedy:true,inside:comment_inside},{pattern:/(^|\s)!\[(={0,6})\[\s[\s\S]*?\]\2\](?=\s|$)/,lookbehind:true,greedy:true,inside:comment_inside}],number:[{pattern:/(^|\s)[+-]?\d+(?=\s|$)/,lookbehind:true},{pattern:/(^|\s)[+-]?0(?:b[01]+|o[0-7]+|d\d+|x[\dA-F]+)(?=\s|$)/i,lookbehind:true},{pattern:/(^|\s)[+-]?\d+\/\d+\.?(?=\s|$)/,lookbehind:true},{pattern:/(^|\s)\+?\d+\+\d+\/\d+(?=\s|$)/,lookbehind:true},{pattern:/(^|\s)-\d+-\d+\/\d+(?=\s|$)/,lookbehind:true},{pattern:/(^|\s)[+-]?(?:\d*\.\d+|\d+\.\d*|\d+)(?:e[+-]?\d+)?(?=\s|$)/i,lookbehind:true},{pattern:/(^|\s)NAN:\s+[\da-fA-F]+(?=\s|$)/,lookbehind:true},{pattern:/(^|\s)[+-]?0(?:b1\.[01]*|o1\.[0-7]*|d1\.\d*|x1\.[\dA-F]*)p\d+(?=\s|$)/i,lookbehind:true}],regexp:{pattern:/(^|\s)R\/\s+(?:\\\S|[^\\/])*\/(?:[idmsr]*|[idmsr]+-[idmsr]+)(?=\s|$)/,lookbehind:true,alias:"number",inside:{variable:/\\\S/,keyword:/[+?*\[\]^$(){}.|]/,operator:{pattern:/(\/)[idmsr]+(?:-[idmsr]+)?/,lookbehind:true}}},boolean:{pattern:/(^|\s)[tf](?=\s|$)/,lookbehind:true},"custom-string":{pattern:/(^|\s)[A-Z0-9\-]+"\s(?:\\\S|[^"\\])*"/,lookbehind:true,greedy:true,alias:"string",inside:{number:/\\\S|%\w|\//}},"multiline-string":[{pattern:/(^|\s)STRING:\s+\S+(?:\n|\r\n).*(?:\n|\r\n)\s*;(?=\s|$)/,lookbehind:true,greedy:true,alias:"string",inside:{number:string_inside.number,"semicolon-or-setlocal":{pattern:/((?:\n|\r\n)\s*);(?=\s|$)/,lookbehind:true,alias:"function"}}},{pattern:/(^|\s)HEREDOC:\s+\S+(?:\n|\r\n).*(?:\n|\r\n)\s*\S+(?=\s|$)/,lookbehind:true,greedy:true,alias:"string",inside:string_inside},{pattern:/(^|\s)\[(={0,6})\[\s[\s\S]*?\]\2\](?=\s|$)/,lookbehind:true,greedy:true,alias:"string",inside:string_inside}],"special-using":{pattern:/(^|\s)USING:(?:\s\S+)*(?=\s+;(?:\s|$))/,lookbehind:true,alias:"function",inside:{string:{pattern:/(\s)[^:\s]+/,lookbehind:true}}},"stack-effect-delimiter":[{pattern:/(^|\s)(?:call|execute|eval)?\((?=\s)/,lookbehind:true,alias:"operator"},{pattern:/(\s)--(?=\s)/,lookbehind:true,alias:"operator"},{pattern:/(\s)\)(?=\s|$)/,lookbehind:true,alias:"operator"}],combinators:{pattern:null,lookbehind:true,alias:"keyword"},"kernel-builtin":{pattern:null,lookbehind:true,alias:"variable"},"sequences-builtin":{pattern:null,lookbehind:true,alias:"variable"},"math-builtin":{pattern:null,lookbehind:true,alias:"variable"},"constructor-word":{pattern:/(^|\s)<(?!=+>|-+>)\S+>(?=\s|$)/,lookbehind:true,alias:"keyword"},"other-builtin-syntax":{pattern:null,lookbehind:true,alias:"operator"},"conventionally-named-word":{pattern:/(^|\s)(?!")(?:(?:set|change|with|new)-\S+|\$\S+|>[^>\s]+|[^:>\s]+>|[^>\s]+>[^>\s]+|\+[^+\s]+\+|[^?\s]+\?|\?[^?\s]+|[^>\s]+>>|>>[^>\s]+|[^<\s]+<<|\([^()\s]+\)|[^!\s]+!|[^*\s]\S*\*|[^.\s]\S*\.)(?=\s|$)/,lookbehind:true,alias:"keyword"},"colon-syntax":{pattern:/(^|\s)(?:[A-Z0-9\-]+#?)?:{1,2}\s+(?:;\S+|(?!;)\S+)(?=\s|$)/,lookbehind:true,greedy:true,alias:"function"},"semicolon-or-setlocal":{pattern:/(\s)(?:;|:>)(?=\s|$)/,lookbehind:true,alias:"function"},"curly-brace-literal-delimiter":[{pattern:/(^|\s)[a-z]*\{(?=\s)/i,lookbehind:true,alias:"operator"},{pattern:/(\s)\}(?=\s|$)/,lookbehind:true,alias:"operator"}],"quotation-delimiter":[{pattern:/(^|\s)\[(?=\s)/,lookbehind:true,alias:"operator"},{pattern:/(\s)\](?=\s|$)/,lookbehind:true,alias:"operator"}],"normal-word":{pattern:/(^|\s)[^"\s]\S*(?=\s|$)/,lookbehind:true},string:{pattern:/"(?:\\\S|[^"\\])*"/,greedy:true,inside:string_inside}};var escape=function(str){return(str+"").replace(/([.?*+\^$\[\]\\(){}|\-])/g,"\\$1")};var arrToWordsRegExp=function(arr){return new RegExp("(^|\\s)(?:"+arr.map(escape).join("|")+")(?=\\s|$)")};var builtins={"kernel-builtin":["or","2nipd","4drop","tuck","wrapper","nip","wrapper?","callstack>array","die","dupd","callstack","callstack?","3dup","hashcode","pick","4nip","build",">boolean","nipd","clone","5nip","eq?","?","=","swapd","2over","clear","2dup","get-retainstack","not","tuple?","dup","3nipd","call","-rotd","object","drop","assert=","assert?","-rot","execute","boa","get-callstack","curried?","3drop","pickd","overd","over","roll","3nip","swap","and","2nip","rotd","throw","(clone)","hashcode*","spin","reach","4dup","equal?","get-datastack","assert","2drop","<wrapper>","boolean?","identity-hashcode","identity-tuple?","null","composed?","new","5drop","rot","-roll","xor","identity-tuple","boolean"],"other-builtin-syntax":["=======","recursive","flushable",">>","<<<<<<","M\\","B","PRIVATE>","\\","======","final","inline","delimiter","deprecated","<PRIVATE",">>>>>>","<<<<<<<","parse-complex","malformed-complex","read-only",">>>>>>>","call-next-method","<<","foldable","$","$[","${"],"sequences-builtin":["member-eq?","mismatch","append","assert-sequence=","longer","repetition","clone-like","3sequence","assert-sequence?","last-index-from","reversed","index-from","cut*","pad-tail","join-as","remove-eq!","concat-as","but-last","snip","nths","nth","sequence","longest","slice?","<slice>","remove-nth","tail-slice","empty?","tail*","member?","virtual-sequence?","set-length","drop-prefix","iota","unclip","bounds-error?","unclip-last-slice","non-negative-integer-expected","non-negative-integer-expected?","midpoint@","longer?","?set-nth","?first","rest-slice","prepend-as","prepend","fourth","sift","subseq-start","new-sequence","?last","like","first4","1sequence","reverse","slice","virtual@","repetition?","set-last","index","4sequence","max-length","set-second","immutable-sequence","first2","first3","supremum","unclip-slice","suffix!","insert-nth","tail","3append","short","suffix","concat","flip","immutable?","reverse!","2sequence","sum","delete-all","indices","snip-slice","<iota>","check-slice","sequence?","head","append-as","halves","sequence=","collapse-slice","?second","slice-error?","product","bounds-check?","bounds-check","immutable","virtual-exemplar","harvest","remove","pad-head","last","set-fourth","cartesian-product","remove-eq","shorten","shorter","reversed?","shorter?","shortest","head-slice","pop*","tail-slice*","but-last-slice","iota?","append!","cut-slice","new-resizable","head-slice*","sequence-hashcode","pop","set-nth","?nth","second","join","immutable-sequence?","<reversed>","3append-as","virtual-sequence","subseq?","remove-nth!","length","last-index","lengthen","assert-sequence","copy","move","third","first","tail?","set-first","prefix","bounds-error","<repetition>","exchange","surround","cut","min-length","set-third","push-all","head?","subseq-start-from","delete-slice","rest","sum-lengths","head*","infimum","remove!","glue","slice-error","subseq","push","replace-slice","subseq-as","unclip-last"],"math-builtin":["number=","next-power-of-2","?1+","fp-special?","imaginary-part","float>bits","number?","fp-infinity?","bignum?","fp-snan?","denominator","gcd","*","+","fp-bitwise=","-","u>=","/",">=","bitand","power-of-2?","log2-expects-positive","neg?","<","log2",">","integer?","number","bits>double","2/","zero?","bits>float","float?","shift","ratio?","rect>","even?","ratio","fp-sign","bitnot",">fixnum","complex?","/i","integer>fixnum","/f","sgn",">bignum","next-float","u<","u>","mod","recip","rational",">float","2^","integer","fixnum?","neg","fixnum","sq","bignum",">rect","bit?","fp-qnan?","simple-gcd","complex","<fp-nan>","real",">fraction","double>bits","bitor","rem","fp-nan-payload","real-part","log2-expects-positive?","prev-float","align","unordered?","float","fp-nan?","abs","bitxor","integer>fixnum-strict","u<=","odd?","<=","/mod",">integer","real?","rational?","numerator"]};Object.keys(builtins).forEach((function(k){factor[k].pattern=arrToWordsRegExp(builtins[k])}));var combinators=["2bi","while","2tri","bi*","4dip","both?","same?","tri@","curry","prepose","3bi","?if","tri*","2keep","3keep","curried","2keepd","when","2bi*","2tri*","4keep","bi@","keepdd","do","unless*","tri-curry","if*","loop","bi-curry*","when*","2bi@","2tri@","with","2with","either?","bi","until","3dip","3curry","tri-curry*","tri-curry@","bi-curry","keepd","compose","2dip","if","3tri","unless","tuple","keep","2curry","tri","most","while*","dip","composed","bi-curry@","find-last-from","trim-head-slice","map-as","each-from","none?","trim-tail","partition","if-empty","accumulate*","reject!","find-from","accumulate-as","collector-for-as","reject","map","map-sum","accumulate!","2each-from","follow","supremum-by","map!","unless-empty","collector","padding","reduce-index","replicate-as","infimum-by","trim-tail-slice","count","find-index","filter","accumulate*!","reject-as","map-integers","map-find","reduce","selector","interleave","2map","filter-as","binary-reduce","map-index-as","find","produce","filter!","replicate","cartesian-map","cartesian-each","find-index-from","map-find-last","3map-as","3map","find-last","selector-as","2map-as","2map-reduce","accumulate","each","each-index","accumulate*-as","when-empty","all?","collector-as","push-either","new-like","collector-for","2selector","push-if","2all?","map-reduce","3each","any?","trim-slice","2reduce","change-nth","produce-as","2each","trim","trim-head","cartesian-find","map-index","if-zero","each-integer","unless-zero","(find-integer)","when-zero","find-last-integer","(all-integers?)","times","(each-integer)","find-integer","all-integers?","unless-negative","if-positive","when-positive","when-negative","unless-positive","if-negative","case","2cleave","cond>quot","case>quot","3cleave","wrong-values","to-fixed-point","alist>quot","cond","cleave","call-effect","recursive-hashcode","spread","deep-spread>quot","2||","0||","n||","0&&","2&&","3||","1||","1&&","n&&","3&&","smart-unless*","keep-inputs","reduce-outputs","smart-when*","cleave>array","smart-with","smart-apply","smart-if","inputs/outputs","output>sequence-n","map-outputs","map-reduce-outputs","dropping","output>array","smart-map-reduce","smart-2map-reduce","output>array-n","nullary","input<sequence","append-outputs","drop-inputs","inputs","smart-2reduce","drop-outputs","smart-reduce","preserving","smart-when","outputs","append-outputs-as","smart-unless","smart-if*","sum-outputs","input<sequence-unsafe","output>sequence"];factor.combinators.pattern=arrToWordsRegExp(combinators);Prism.languages.factor=factor})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=firestoreSecurityRules;firestoreSecurityRules.displayName="firestoreSecurityRules";firestoreSecurityRules.aliases=[];function firestoreSecurityRules(Prism){Prism.languages["firestore-security-rules"]=Prism.languages.extend("clike",{comment:/\/\/.*/,keyword:/\b(?:allow|function|if|match|null|return|rules_version|service)\b/,operator:/&&|\|\||[<>!=]=?|[-+*/%]|\b(?:in|is)\b/});delete Prism.languages["firestore-security-rules"]["class-name"];Prism.languages.insertBefore("firestore-security-rules","keyword",{path:{pattern:/(^|[\s(),])(?:\/(?:[\w\xA0-\uFFFF]+|\{[\w\xA0-\uFFFF]+(?:=\*\*)?\}|\$\([\w\xA0-\uFFFF.]+\)))+/,lookbehind:true,greedy:true,inside:{variable:{pattern:/\{[\w\xA0-\uFFFF]+(?:=\*\*)?\}|\$\([\w\xA0-\uFFFF.]+\)/,inside:{operator:/=/,keyword:/\*\*/,punctuation:/[.$(){}]/}},punctuation:/[/]/}},method:{pattern:/(\ballow\s+)[a-z]+(?:\s*,\s*[a-z]+)*(?=\s*[:;])/,lookbehind:true,alias:"builtin",inside:{punctuation:/,/}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=flow;flow.displayName="flow";flow.aliases=[];function flow(Prism){(function(Prism){Prism.languages.flow=Prism.languages.extend("javascript",{});Prism.languages.insertBefore("flow","keyword",{type:[{pattern:/\b(?:[Nn]umber|[Ss]tring|[Bb]oolean|Function|any|mixed|null|void)\b/,alias:"tag"}]});Prism.languages.flow["function-variable"].pattern=/[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*=\s*(?:function\b|(?:\([^()]*\)(?:\s*:\s*\w+)?|[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)\s*=>))/i;delete Prism.languages.flow["parameter"];Prism.languages.insertBefore("flow","operator",{"flow-punctuation":{pattern:/\{\||\|\}/,alias:"punctuation"}});if(!Array.isArray(Prism.languages.flow.keyword)){Prism.languages.flow.keyword=[Prism.languages.flow.keyword]}Prism.languages.flow.keyword.unshift({pattern:/(^|[^$]\b)(?:type|opaque|declare|Class)\b(?!\$)/,lookbehind:true},{pattern:/(^|[^$]\B)\$(?:await|Diff|Exact|Keys|ObjMap|PropertyType|Shape|Record|Supertype|Subtype|Enum)\b(?!\$)/,lookbehind:true})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=fortran;fortran.displayName="fortran";fortran.aliases=[];function fortran(Prism){Prism.languages.fortran={"quoted-number":{pattern:/[BOZ](['"])[A-F0-9]+\1/i,alias:"number"},string:{pattern:/(?:\w+_)?(['"])(?:\1\1|&(?:\r\n?|\n)(?:\s*!.+(?:\r\n?|\n))?|(?!\1).)*(?:\1|&)/,inside:{comment:{pattern:/(&(?:\r\n?|\n)\s*)!.*/,lookbehind:true}}},comment:{pattern:/!.*/,greedy:true},boolean:/\.(?:TRUE|FALSE)\.(?:_\w+)?/i,number:/(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:[ED][+-]?\d+)?(?:_\w+)?/i,keyword:[/\b(?:INTEGER|REAL|DOUBLE ?PRECISION|COMPLEX|CHARACTER|LOGICAL)\b/i,/\b(?:END ?)?(?:BLOCK ?DATA|DO|FILE|FORALL|FUNCTION|IF|INTERFACE|MODULE(?! PROCEDURE)|PROGRAM|SELECT|SUBROUTINE|TYPE|WHERE)\b/i,/\b(?:ALLOCATABLE|ALLOCATE|BACKSPACE|CALL|CASE|CLOSE|COMMON|CONTAINS|CONTINUE|CYCLE|DATA|DEALLOCATE|DIMENSION|DO|END|EQUIVALENCE|EXIT|EXTERNAL|FORMAT|GO ?TO|IMPLICIT(?: NONE)?|INQUIRE|INTENT|INTRINSIC|MODULE PROCEDURE|NAMELIST|NULLIFY|OPEN|OPTIONAL|PARAMETER|POINTER|PRINT|PRIVATE|PUBLIC|READ|RETURN|REWIND|SAVE|SELECT|STOP|TARGET|WHILE|WRITE)\b/i,/\b(?:ASSIGNMENT|DEFAULT|ELEMENTAL|ELSE|ELSEWHERE|ELSEIF|ENTRY|IN|INCLUDE|INOUT|KIND|NULL|ONLY|OPERATOR|OUT|PURE|RECURSIVE|RESULT|SEQUENCE|STAT|THEN|USE)\b/i],operator:[/\*\*|\/\/|=>|[=\/]=|[<>]=?|::|[+\-*=%]|\.[A-Z]+\./i,{pattern:/(^|(?!\().)\/(?!\))/,lookbehind:true}],punctuation:/\(\/|\/\)|[(),;:&]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=fsharp;fsharp.displayName="fsharp";fsharp.aliases=[];function fsharp(Prism){Prism.languages.fsharp=Prism.languages.extend("clike",{comment:[{pattern:/(^|[^\\])\(\*[\s\S]*?\*\)/,lookbehind:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true}],string:{pattern:/(?:"""[\s\S]*?"""|@"(?:""|[^"])*"|"(?:\\[\s\S]|[^\\"])*")B?|'(?:[^\\']|\\(?:.|\d{3}|x[a-fA-F\d]{2}|u[a-fA-F\d]{4}|U[a-fA-F\d]{8}))'B?/,greedy:true},"class-name":{pattern:/(\b(?:exception|inherit|interface|new|of|type)\s+|\w\s*:\s*|\s:\??>\s*)[.\w]+\b(?:\s*(?:->|\*)\s*[.\w]+\b)*(?!\s*[:.])/,lookbehind:true,inside:{operator:/->|\*/,punctuation:/\./}},keyword:/\b(?:let|return|use|yield)(?:!\B|\b)|\b(?:abstract|and|as|assert|base|begin|class|default|delegate|do|done|downcast|downto|elif|else|end|exception|extern|false|finally|for|fun|function|global|if|in|inherit|inline|interface|internal|lazy|match|member|module|mutable|namespace|new|not|null|of|open|or|override|private|public|rec|select|static|struct|then|to|true|try|type|upcast|val|void|when|while|with|asr|land|lor|lsl|lsr|lxor|mod|sig|atomic|break|checked|component|const|constraint|constructor|continue|eager|event|external|fixed|functor|include|method|mixin|object|parallel|process|protected|pure|sealed|tailcall|trait|virtual|volatile)\b/,number:[/\b0x[\da-fA-F]+(?:un|lf|LF)?\b/,/\b0b[01]+(?:y|uy)?\b/,/(?:\b\d+\.?\d*|\B\.\d+)(?:[fm]|e[+-]?\d+)?\b/i,/\b\d+(?:[IlLsy]|u[lsy]?|UL)?\b/],operator:/([<>~&^])\1\1|([*.:<>&])\2|<-|->|[!=:]=|<?\|{1,3}>?|\??(?:<=|>=|<>|[-+*/%=<>])\??|[!?^&]|~[+~-]|:>|:\?>?/});Prism.languages.insertBefore("fsharp","keyword",{preprocessor:{pattern:/^[^\r\n\S]*#.*/m,alias:"property",inside:{directive:{pattern:/(\s*#)\b(?:else|endif|if|light|line|nowarn)\b/,lookbehind:true,alias:"keyword"}}}});Prism.languages.insertBefore("fsharp","punctuation",{"computation-expression":{pattern:/[_a-z]\w*(?=\s*\{)/i,alias:"keyword"}});Prism.languages.insertBefore("fsharp","string",{annotation:{pattern:/\[<.+?>\]/,inside:{punctuation:/^\[<|>\]$/,"class-name":{pattern:/^\w+$|(^|;\s*)[A-Z]\w*(?=\()/,lookbehind:true},"annotation-content":{pattern:/[\s\S]+/,inside:Prism.languages.fsharp}}}})}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=ftl;ftl.displayName="ftl";ftl.aliases=[];function ftl(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){var FTL_EXPR=/[^<()"']|\((?:<expr>)*\)|<(?!#--)|<#--(?:[^-]|-(?!->))*-->|"(?:[^\\"]|\\.)*"|'(?:[^\\']|\\.)*'/.source;for(var i=0;i<2;i++){FTL_EXPR=FTL_EXPR.replace(/<expr>/g,(function(){return FTL_EXPR}))}FTL_EXPR=FTL_EXPR.replace(/<expr>/g,/[^\s\S]/.source);var ftl={comment:/<#--[\s\S]*?-->/,string:[{pattern:/\br("|')(?:(?!\1)[^\\]|\\.)*\1/,greedy:true},{pattern:RegExp(/("|')(?:(?!\1|\$\{)[^\\]|\\.|\$\{(?:<expr>)*?\})*\1/.source.replace(/<expr>/g,(function(){return FTL_EXPR}))),greedy:true,inside:{interpolation:{pattern:RegExp(/((?:^|[^\\])(?:\\\\)*)\$\{(?:<expr>)*?\}/.source.replace(/<expr>/g,(function(){return FTL_EXPR}))),lookbehind:true,inside:{"interpolation-punctuation":{pattern:/^\$\{|\}$/,alias:"punctuation"},rest:null}}}}],keyword:/\b(?:as)\b/,boolean:/\b(?:true|false)\b/,"builtin-function":{pattern:/((?:^|[^?])\?\s*)\w+/,lookbehind:true,alias:"function"},function:/\w+(?=\s*\()/,number:/\d+(?:\.\d+)?/,operator:/\.\.[<*!]?|->|--|\+\+|&&|\|\||\?{1,2}|[-+*/%!=<>]=?|\b(?:gt|gte|lt|lte)\b/,punctuation:/[,;.:()[\]{}]/};ftl.string[1].inside.interpolation.inside.rest=ftl;Prism.languages.ftl={"ftl-comment":{pattern:/^<#--[\s\S]*/,alias:"comment"},"ftl-directive":{pattern:/^<[\s\S]+>$/,inside:{directive:{pattern:/(^<\/?)[#@][a-z]\w*/i,lookbehind:true,alias:"keyword"},punctuation:/^<\/?|\/?>$/,content:{pattern:/[\s\S]*\S[\s\S]*/,alias:"ftl",inside:ftl}}},"ftl-interpolation":{pattern:/^\$\{[\s\S]*\}$/,inside:{punctuation:/^\$\{|\}$/,content:{pattern:/[\s\S]*\S[\s\S]*/,alias:"ftl",inside:ftl}}}};Prism.hooks.add("before-tokenize",(function(env){var pattern=RegExp(/<#--[\s\S]*?-->|<\/?[#@][a-zA-Z](?:<expr>)*?>|\$\{(?:<expr>)*?\}/.source.replace(/<expr>/g,(function(){return FTL_EXPR})),"gi");Prism.languages["markup-templating"].buildPlaceholders(env,"ftl",pattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"ftl")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=gcode;gcode.displayName="gcode";gcode.aliases=[];function gcode(Prism){Prism.languages.gcode={comment:/;.*|\B\(.*?\)\B/,string:{pattern:/"(?:""|[^"])*"/,greedy:true},keyword:/\b[GM]\d+(?:\.\d+)?\b/,property:/\b[A-Z]/,checksum:{pattern:/\*\d+/,alias:"punctuation"},punctuation:/:/}}},function(module,exports,__webpack_require__){"use strict";module.exports=gdscript;gdscript.displayName="gdscript";gdscript.aliases=[];function gdscript(Prism){Prism.languages.gdscript={comment:/#.*/,string:{pattern:/@?(?:("|')(?:(?!\1)[^\n\\]|\\[\s\S])*\1(?!"|')|"""(?:[^\\]|\\[\s\S])*?""")/,greedy:true},"class-name":{pattern:/(^(?:class_name|class|extends)[ \t]+|^export\([ \t]*|\bas[ \t]+|(?:\b(?:const|var)[ \t]|[,(])[ \t]*\w+[ \t]*:[ \t]*|->[ \t]*)[a-zA-Z_]\w*/m,lookbehind:true},keyword:/\b(?:and|as|assert|break|breakpoint|class|class_name|const|continue|elif|else|enum|export|extends|for|func|if|in|is|master|mastersync|match|not|null|onready|or|pass|preload|puppet|puppetsync|remote|remotesync|return|self|setget|signal|static|tool|var|while|yield)\b/,function:/[a-z_]\w*(?=[ \t]*\()/i,variable:/\$\w+/,number:[/\b0b[01_]+\b|\b0x[\da-fA-F_]+\b|(?:\b\d[\d_]*(?:\.[\d_]*)?|\B\.[\d_]+)(?:e[+-]?[\d_]+)?\b/,/\b(?:INF|NAN|PI|TAU)\b/],constant:/\b[A-Z][A-Z_\d]*\b/,boolean:/\b(?:false|true)\b/,operator:/->|:=|&&|\|\||<<|>>|[-+*/%&|!<>=]=?|[~^]/,punctuation:/[.:,;()[\]{}]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=gedcom;gedcom.displayName="gedcom";gedcom.aliases=[];function gedcom(Prism){Prism.languages.gedcom={"line-value":{pattern:/(^\s*\d+ +(?:@\w[\w!"$%&'()*+,\-./:;<=>?[\\\]^`{|}~\x80-\xfe #]*@ +)?\w+ +).+/m,lookbehind:true,inside:{pointer:{pattern:/^@\w[\w!"$%&'()*+,\-./:;<=>?[\\\]^`{|}~\x80-\xfe #]*@$/,alias:"variable"}}},tag:{pattern:/(^\s*\d+ +(?:@\w[\w!"$%&'()*+,\-./:;<=>?[\\\]^`{|}~\x80-\xfe #]*@ +)?)\w+/m,lookbehind:true,alias:"string"},level:{pattern:/(^\s*)\d+/m,lookbehind:true,alias:"number"},pointer:{pattern:/@\w[\w!"$%&'()*+,\-./:;<=>?[\\\]^`{|}~\x80-\xfe #]*@/,alias:"variable"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=gherkin;gherkin.displayName="gherkin";gherkin.aliases=[];function gherkin(Prism){(function(Prism){var tableRow=/(?:\r?\n|\r)[ \t]*\|.+\|.*/.source;Prism.languages.gherkin={pystring:{pattern:/("""|''')[\s\S]+?\1/,alias:"string"},comment:{pattern:/(^[ \t]*)#.*/m,lookbehind:true},tag:{pattern:/(^[ \t]*)@\S*/m,lookbehind:true},feature:{pattern:/((?:^|\r?\n|\r)[ \t]*)(?:Ability|Ahoy matey!|Arwedd|Aspekt|Besigheid Behoefte|Business Need|Caracteristica|Característica|Egenskab|Egenskap|Eiginleiki|Feature|Fīča|Fitur|Fonctionnalité|Fonksyonalite|Funcionalidade|Funcionalitat|Functionalitate|Funcţionalitate|Funcționalitate|Functionaliteit|Fungsi|Funkcia|Funkcija|Funkcionalitāte|Funkcionalnost|Funkcja|Funksie|Funktionalität|Funktionalitéit|Funzionalità|Hwaet|Hwæt|Jellemző|Karakteristik|laH|Lastnost|Mak|Mogucnost|Mogućnost|Moznosti|Možnosti|OH HAI|Omadus|Ominaisuus|Osobina|Özellik|perbogh|poQbogh malja'|Potrzeba biznesowa|Požadavek|Požiadavka|Pretty much|Qap|Qu'meH 'ut|Savybė|Tính năng|Trajto|Vermoë|Vlastnosť|Właściwość|Značilnost|Δυνατότητα|Λειτουργία|Могућност|Мөмкинлек|Особина|Свойство|Үзенчәлеклелек|Функционал|Функционалност|Функция|Функціонал|תכונה|خاصية|خصوصیت|صلاحیت|کاروبار کی ضرورت|وِیژگی|रूप लेख|ਖਾਸੀਅਤ|ਨਕਸ਼ ਨੁਹਾਰ|ਮੁਹਾਂਦਰਾ|గుణము|ಹೆಚ್ಚಳ|ความต้องการทางธุรกิจ|ความสามารถ|โครงหลัก|기능|フィーチャ|功能|機能):(?:[^:]+(?:\r?\n|\r|$))*/,lookbehind:true,inside:{important:{pattern:/(:)[^\r\n]+/,lookbehind:true},keyword:/[^:\r\n]+:/}},scenario:{pattern:/(^[ \t]*)(?:Abstract Scenario|Abstrakt Scenario|Achtergrond|Aer|Ær|Agtergrond|All y'all|Antecedentes|Antecedents|Atburðarás|Atburðarásir|Awww, look mate|B4|Background|Baggrund|Bakgrund|Bakgrunn|Bakgrunnur|Beispiele|Beispiller|Bối cảnh|Cefndir|Cenario|Cenário|Cenario de Fundo|Cenário de Fundo|Cenarios|Cenários|Contesto|Context|Contexte|Contexto|Conto|Contoh|Contone|Dæmi|Dasar|Dead men tell no tales|Delineacao do Cenario|Delineação do Cenário|Dis is what went down|Dữ liệu|Dyagram senaryo|Dyagram Senaryo|Egzanp|Ejemplos|Eksempler|Ekzemploj|Enghreifftiau|Esbozo do escenario|Escenari|Escenario|Esempi|Esquema de l'escenari|Esquema del escenario|Esquema do Cenario|Esquema do Cenário|Examples|EXAMPLZ|Exempel|Exemple|Exemples|Exemplos|First off|Fono|Forgatókönyv|Forgatókönyv vázlat|Fundo|Geçmiş|ghantoH|Grundlage|Hannergrond|Háttér|Heave to|Istorik|Juhtumid|Keadaan|Khung kịch bản|Khung tình huống|Kịch bản|Koncept|Konsep skenario|Kontèks|Kontekst|Kontekstas|Konteksts|Kontext|Konturo de la scenaro|Latar Belakang|lut|lut chovnatlh|lutmey|Lýsing Atburðarásar|Lýsing Dæma|Menggariskan Senario|MISHUN|MISHUN SRSLY|mo'|Náčrt Scenára|Náčrt Scénáře|Náčrt Scenáru|Oris scenarija|Örnekler|Osnova|Osnova Scenára|Osnova scénáře|Osnutek|Ozadje|Paraugs|Pavyzdžiai|Példák|Piemēri|Plan du scénario|Plan du Scénario|Plan senaryo|Plan Senaryo|Plang vum Szenario|Pozadí|Pozadie|Pozadina|Príklady|Příklady|Primer|Primeri|Primjeri|Przykłady|Raamstsenaarium|Reckon it's like|Rerefons|Scenár|Scénář|Scenarie|Scenarij|Scenarijai|Scenarijaus šablonas|Scenariji|Scenārijs|Scenārijs pēc parauga|Scenarijus|Scenario|Scénario|Scenario Amlinellol|Scenario Outline|Scenario Template|Scenariomal|Scenariomall|Scenarios|Scenariu|Scenariusz|Scenaro|Schema dello scenario|Se ðe|Se the|Se þe|Senario|Senaryo|Senaryo deskripsyon|Senaryo Deskripsyon|Senaryo taslağı|Shiver me timbers|Situācija|Situai|Situasie|Situasie Uiteensetting|Skenario|Skenario konsep|Skica|Structura scenariu|Structură scenariu|Struktura scenarija|Stsenaarium|Swa|Swa hwaer swa|Swa hwær swa|Szablon scenariusza|Szenario|Szenariogrundriss|Tapaukset|Tapaus|Tapausaihio|Taust|Tausta|Template Keadaan|Template Senario|Template Situai|The thing of it is|Tình huống|Variantai|Voorbeelde|Voorbeelden|Wharrimean is|Yo\-ho\-ho|You'll wanna|Założenia|Παραδείγματα|Περιγραφή Σεναρίου|Σενάρια|Σενάριο|Υπόβαθρο|Кереш|Контекст|Концепт|Мисаллар|Мисоллар|Основа|Передумова|Позадина|Предистория|Предыстория|Приклади|Пример|Примери|Примеры|Рамка на сценарий|Скица|Структура сценарија|Структура сценария|Структура сценарію|Сценарий|Сценарий структураси|Сценарийның төзелеше|Сценарији|Сценарио|Сценарій|Тарих|Үрнәкләр|דוגמאות|רקע|תבנית תרחיש|תרחיש|الخلفية|الگوی سناریو|امثلة|پس منظر|زمینه|سناریو|سيناريو|سيناريو مخطط|مثالیں|منظر نامے کا خاکہ|منظرنامہ|نمونه ها|उदाहरण|परिदृश्य|परिदृश्य रूपरेखा|पृष्ठभूमि|ਉਦਾਹਰਨਾਂ|ਪਟਕਥਾ|ਪਟਕਥਾ ਢਾਂਚਾ|ਪਟਕਥਾ ਰੂਪ ਰੇਖਾ|ਪਿਛੋਕੜ|ఉదాహరణలు|కథనం|నేపథ్యం|సన్నివేశం|ಉದಾಹರಣೆಗಳು|ಕಥಾಸಾರಾಂಶ|ವಿವರಣೆ|ಹಿನ್ನೆಲೆ|โครงสร้างของเหตุการณ์|ชุดของตัวอย่าง|ชุดของเหตุการณ์|แนวคิด|สรุปเหตุการณ์|เหตุการณ์|배경|시나리오|시나리오 개요|예|サンプル|シナリオ|シナリオアウトライン|シナリオテンプレ|シナリオテンプレート|テンプレ|例|例子|剧本|剧本大纲|劇本|劇本大綱|场景|场景大纲|場景|場景大綱|背景):[^:\r\n]*/m,lookbehind:true,inside:{important:{pattern:/(:)[^\r\n]*/,lookbehind:true},keyword:/[^:\r\n]+:/}},"table-body":{pattern:RegExp("("+tableRow+")(?:"+tableRow+")+"),lookbehind:true,inside:{outline:{pattern:/<[^>]+?>/,alias:"variable"},td:{pattern:/\s*[^\s|][^|]*/,alias:"string"},punctuation:/\|/}},"table-head":{pattern:RegExp(tableRow),inside:{th:{pattern:/\s*[^\s|][^|]*/,alias:"variable"},punctuation:/\|/}},atrule:{pattern:/(^[ \t]+)(?:'ach|'a|'ej|7|a|A také|A taktiež|A tiež|A zároveň|Aber|Ac|Adott|Akkor|Ak|Aleshores|Ale|Ali|Allora|Alors|Als|Ama|Amennyiben|Amikor|Ampak|an|AN|Ananging|And y'all|And|Angenommen|Anrhegedig a|An|Apabila|Atès|Atesa|Atunci|Avast!|Aye|A|awer|Bagi|Banjur|Bet|Biết|Blimey!|Buh|But at the end of the day I reckon|But y'all|But|BUT|Cal|Când|Cando|Cand|Ce|Cuando|Če|Ða ðe|Ða|Dadas|Dada|Dados|Dado|DaH ghu' bejlu'|dann|Dann|Dano|Dan|Dar|Dat fiind|Data|Date fiind|Date|Dati fiind|Dati|Daţi fiind|Dați fiind|Dato|DEN|Den youse gotta|Dengan|De|Diberi|Diyelim ki|Donada|Donat|Donitaĵo|Do|Dun|Duota|Ðurh|Eeldades|Ef|Eğer ki|Entao|Então|Entón|Entonces|En|Epi|E|És|Etant donnée|Etant donné|Et|Étant données|Étant donnée|Étant donné|Etant données|Etant donnés|Étant donnés|Fakat|Gangway!|Gdy|Gegeben seien|Gegeben sei|Gegeven|Gegewe|ghu' noblu'|Gitt|Given y'all|Given|Givet|Givun|Ha|Cho|I CAN HAZ|In|Ir|It's just unbelievable|I|Ja|Jeśli|Jeżeli|Kadar|Kada|Kad|Kai|Kaj|Když|Keď|Kemudian|Ketika|Khi|Kiedy|Ko|Kuid|Kui|Kun|Lan|latlh|Le sa a|Let go and haul|Le|Lè sa a|Lè|Logo|Lorsqu'<|Lorsque|mä|Maar|Mais|Mając|Majd|Maka|Manawa|Mas|Ma|Menawa|Men|Mutta|Nalikaning|Nalika|Nanging|Når|När|Nato|Nhưng|Niin|Njuk|O zaman|Og|Och|Oletetaan|Onda|Ond|Oraz|Pak|Pero|Però|Podano|Pokiaľ|Pokud|Potem|Potom|Privzeto|Pryd|qaSDI'|Quando|Quand|Quan|Så|Sed|Se|Siis|Sipoze ke|Sipoze Ke|Sipoze|Si|Şi|Și|Soit|Stel|Tada|Tad|Takrat|Tak|Tapi|Ter|Tetapi|Tha the|Tha|Then y'all|Then|Thì|Thurh|Toda|Too right|ugeholl|Und|Un|Và|vaj|Vendar|Ve|wann|Wanneer|WEN|Wenn|When y'all|When|Wtedy|Wun|Y'know|Yeah nah|Yna|Youse know like when|Youse know when youse got|Y|Za predpokladu|Za předpokladu|Zadani|Zadano|Zadan|Zadate|Zadato|Zakładając|Zaradi|Zatati|Þa þe|Þa|Þá|Þegar|Þurh|Αλλά|Δεδομένου|Και|Όταν|Τότε|А також|Агар|Але|Али|Аммо|А|Әгәр|Әйтик|Әмма|Бирок|Ва|Вә|Дадено|Дано|Допустим|Если|Задате|Задати|Задато|И|І|К тому же|Када|Кад|Когато|Когда|Коли|Ләкин|Лекин|Нәтиҗәдә|Нехай|Но|Онда|Припустимо, що|Припустимо|Пусть|Также|Та|Тогда|Тоді|То|Унда|Һәм|Якщо|אבל|אזי|אז|בהינתן|וגם|כאשר|آنگاه|اذاً|اگر|اما|اور|با فرض|بالفرض|بفرض|پھر|تب|ثم|جب|عندما|فرض کیا|لكن|لیکن|متى|هنگامی|و|अगर|और|कदा|किन्तु|चूंकि|जब|तथा|तदा|तब|परन्तु|पर|यदि|ਅਤੇ|ਜਦੋਂ|ਜਿਵੇਂ ਕਿ|ਜੇਕਰ|ਤਦ|ਪਰ|అప్పుడు|ఈ పరిస్థితిలో|కాని|చెప్పబడినది|మరియు|ಆದರೆ|ನಂತರ|ನೀಡಿದ|ಮತ್ತು|ಸ್ಥಿತಿಯನ್ನು|กำหนดให้|ดังนั้น|แต่|เมื่อ|และ|그러면<|그리고<|단<|만약<|만일<|먼저<|조건<|하지만<|かつ<|しかし<|ただし<|ならば<|もし<|並且<|但し<|但是<|假如<|假定<|假設<|假设<|前提<|同时<|同時<|并且<|当<|當<|而且<|那么<|那麼<)(?=[ \t])/m,lookbehind:true},string:{pattern:/"(?:\\.|[^"\\\r\n])*"|'(?:\\.|[^'\\\r\n])*'/,inside:{outline:{pattern:/<[^>]+?>/,alias:"variable"}}},outline:{pattern:/<[^>]+?>/,alias:"variable"}}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=git;git.displayName="git";git.aliases=[];function git(Prism){Prism.languages.git={comment:/^#.*/m,deleted:/^[-–].*/m,inserted:/^\+.*/m,string:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/m,command:{pattern:/^.*\$ git .*$/m,inside:{parameter:/\s--?\w+/m}},coord:/^@@.*@@$/m,commit_sha1:/^commit \w{40}$/m}}},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=glsl;glsl.displayName="glsl";glsl.aliases=[];function glsl(Prism){Prism.register(refractorC);Prism.languages.glsl=Prism.languages.extend("c",{keyword:/\b(?:attribute|const|uniform|varying|buffer|shared|coherent|volatile|restrict|readonly|writeonly|atomic_uint|layout|centroid|flat|smooth|noperspective|patch|sample|break|continue|do|for|while|switch|case|default|if|else|subroutine|in|out|inout|float|double|int|void|bool|true|false|invariant|precise|discard|return|d?mat[234](?:x[234])?|[ibdu]?vec[234]|uint|lowp|mediump|highp|precision|[iu]?sampler[123]D|[iu]?samplerCube|sampler[12]DShadow|samplerCubeShadow|[iu]?sampler[12]DArray|sampler[12]DArrayShadow|[iu]?sampler2DRect|sampler2DRectShadow|[iu]?samplerBuffer|[iu]?sampler2DMS(?:Array)?|[iu]?samplerCubeArray|samplerCubeArrayShadow|[iu]?image[123]D|[iu]?image2DRect|[iu]?imageCube|[iu]?imageBuffer|[iu]?image[12]DArray|[iu]?imageCubeArray|[iu]?image2DMS(?:Array)?|struct|common|partition|active|asm|class|union|enum|typedef|template|this|resource|goto|inline|noinline|public|static|extern|external|interface|long|short|half|fixed|unsigned|superp|input|output|hvec[234]|fvec[234]|sampler3DRect|filter|sizeof|cast|namespace|using)\b/})}},function(module,exports,__webpack_require__){"use strict";module.exports=gml;gml.displayName="gml";gml.aliases=[];function gml(Prism){Prism.languages.gamemakerlanguage=Prism.languages.gml=Prism.languages.extend("clike",{number:/(?:\b0x[\da-f]+|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?)[ulf]*/i,keyword:/\b(?:if|else|switch|case|default|break|for|repeat|while|do|until|continue|exit|return|globalvar|var|enum)\b/,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]|\b(?:or|and|not|with|at|xor)\b/,constant:/\b(?:self|other|all|noone|global|local|undefined|pointer_(?:invalid|null)|action_(?:stop|restart|continue|reverse)|pi|GM_build_date|GM_version|timezone_(?:local|utc)|gamespeed_(?:fps|microseconds)|ev_(?:create|destroy|step|alarm|keyboard|mouse|collision|other|draw|draw_(?:begin|end|pre|post)|keypress|keyrelease|trigger|(?:left|right|middle|no)_button|(?:left|right|middle)_press|(?:left|right|middle)_release|mouse_(?:enter|leave|wheel_up|wheel_down)|global_(?:left|right|middle)_button|global_(?:left|right|middle)_press|global_(?:left|right|middle)_release|joystick(?:1|2)_(?:left|right|up|down|button1|button2|button3|button4|button5|button6|button7|button8)|outside|boundary|game_start|game_end|room_start|room_end|no_more_lives|animation_end|end_of_path|no_more_health|user\d|step_(?:normal|begin|end)|gui|gui_begin|gui_end)|vk_(?:nokey|anykey|enter|return|shift|control|alt|escape|space|backspace|tab|pause|printscreen|left|right|up|down|home|end|delete|insert|pageup|pagedown|f\d|numpad\d|divide|multiply|subtract|add|decimal|lshift|lcontrol|lalt|rshift|rcontrol|ralt)|mb_(?:any|none|left|right|middle)|c_(?:aqua|black|blue|dkgray|fuchsia|gray|green|lime|ltgray|maroon|navy|olive|purple|red|silver|teal|white|yellow|orange)|fa_(?:left|center|right|top|middle|bottom|readonly|hidden|sysfile|volumeid|directory|archive)|pr_(?:pointlist|linelist|linestrip|trianglelist|trianglestrip|trianglefan)|bm_(?:complex|normal|add|max|subtract|zero|one|src_colour|inv_src_colour|src_color|inv_src_color|src_alpha|inv_src_alpha|dest_alpha|inv_dest_alpha|dest_colour|inv_dest_colour|dest_color|inv_dest_color|src_alpha_sat)|audio_(?:falloff_(?:none|inverse_distance|inverse_distance_clamped|linear_distance|linear_distance_clamped|exponent_distance|exponent_distance_clamped)|old_system|new_system|mono|stereo|3d)|cr_(?:default|none|arrow|cross|beam|size_nesw|size_ns|size_nwse|size_we|uparrow|hourglass|drag|appstart|handpoint|size_all)|spritespeed_framesper(?:second|gameframe)|asset_(?:object|unknown|sprite|sound|room|path|script|font|timeline|tiles|shader)|ds_type_(?:map|list|stack|queue|grid|priority)|ef_(?:explosion|ring|ellipse|firework|smoke|smokeup|star|spark|flare|cloud|rain|snow)|pt_shape_(?:pixel|disk|square|line|star|circle|ring|sphere|flare|spark|explosion|cloud|smoke|snow)|ps_(?:distr|shape)_(?:linear|gaussian|invgaussian|rectangle|ellipse|diamond|line)|ty_(?:real|string)|dll_(?:cdel|cdecl|stdcall)|matrix_(?:view|projection|world)|os_(?:win32|windows|macosx|ios|android|linux|unknown|winphone|win8native|psvita|ps4|xboxone|ps3|uwp)|browser_(?:not_a_browser|unknown|ie|firefox|chrome|safari|safari_mobile|opera|tizen|windows_store|ie_mobile)|device_ios_(?:unknown|iphone|iphone_retina|ipad|ipad_retina|iphone5|iphone6|iphone6plus)|device_(?:emulator|tablet)|display_(?:landscape|landscape_flipped|portrait|portrait_flipped)|of_challenge_(?:win|lose|tie)|leaderboard_type_(?:number|time_mins_secs)|cmpfunc_(?:never|less|equal|lessequal|greater|notequal|greaterequal|always)|cull_(?:noculling|clockwise|counterclockwise)|lighttype_(?:dir|point)|iap_(?:ev_storeload|ev_product|ev_purchase|ev_consume|ev_restore|storeload_ok|storeload_failed|status_uninitialised|status_unavailable|status_loading|status_available|status_processing|status_restoring|failed|unavailable|available|purchased|canceled|refunded)|fb_login_(?:default|fallback_to_webview|no_fallback_to_webview|forcing_webview|use_system_account|forcing_safari)|phy_joint_(?:anchor_1_x|anchor_1_y|anchor_2_x|anchor_2_y|reaction_force_x|reaction_force_y|reaction_torque|motor_speed|angle|motor_torque|max_motor_torque|translation|speed|motor_force|max_motor_force|length_1|length_2|damping_ratio|frequency|lower_angle_limit|upper_angle_limit|angle_limits|max_length|max_torque|max_force)|phy_debug_render_(?:aabb|collision_pairs|coms|core_shapes|joints|obb|shapes)|phy_particle_flag_(?:water|zombie|wall|spring|elastic|viscous|powder|tensile|colourmixing|colormixing)|phy_particle_group_flag_(?:solid|rigid)|phy_particle_data_flag_(?:typeflags|position|velocity|colour|color|category)|achievement_(?:our_info|friends_info|leaderboard_info|info|filter_(?:all_players|friends_only|favorites_only)|type_challenge|type_score_challenge|pic_loaded|show_(?:ui|profile|leaderboard|achievement|bank|friend_picker|purchase_prompt))|network_(?:socket_(?:tcp|udp|bluetooth)|type_(?:connect|disconnect|data|non_blocking_connect)|config_(?:connect_timeout|use_non_blocking_socket|enable_reliable_udp|disable_reliable_udp))|buffer_(?:fixed|grow|wrap|fast|vbuffer|network|u8|s8|u16|s16|u32|s32|u64|f16|f32|f64|bool|text|string|seek_start|seek_relative|seek_end|generalerror|outofspace|outofbounds|invalidtype)|gp_(?:face\d|shoulderl|shoulderr|shoulderlb|shoulderrb|select|start|stickl|stickr|padu|padd|padl|padr|axislh|axislv|axisrh|axisrv)|ov_(?:friends|community|players|settings|gamegroup|achievements)|lb_sort_(?:none|ascending|descending)|lb_disp_(?:none|numeric|time_sec|time_ms)|ugc_(?:result_success|filetype_(?:community|microtrans)|visibility_(?:public|friends_only|private)|query_RankedBy(?:Vote|PublicationDate|Trend|NumTimesReported|TotalVotesAsc|VotesUp|TextSearch)|query_(?:AcceptedForGameRankedByAcceptanceDate|FavoritedByFriendsRankedByPublicationDate|CreatedByFriendsRankedByPublicationDate|NotYetRated)|sortorder_CreationOrder(?:Desc|Asc)|sortorder_(?:TitleAsc|LastUpdatedDesc|SubscriptionDateDesc|VoteScoreDesc|ForModeration)|list_(?:Published|VotedOn|VotedUp|VotedDown|WillVoteLater|Favorited|Subscribed|UsedOrPlayed|Followed)|match_(?:Items|Items_Mtx|Items_ReadyToUse|Collections|Artwork|Videos|Screenshots|AllGuides|WebGuides|IntegratedGuides|UsableInGame|ControllerBindings))|vertex_usage_(?:position|colour|color|normal|texcoord|textcoord|blendweight|blendindices|psize|tangent|binormal|fog|depth|sample)|vertex_type_(?:float\d|colour|color|ubyte4)|layerelementtype_(?:undefined|background|instance|oldtilemap|sprite|tilemap|particlesystem|tile)|tile_(?:rotate|flip|mirror|index_mask)|input_type|se_(?:chorus|compressor|echo|equalizer|flanger|gargle|none|reverb)|text_type|(?:obj|scr|spr|rm)\w+)\b/,variable:/\b(?:x|y|(?:x|y)(?:previous|start)|(?:h|v)speed|direction|speed|friction|gravity|gravity_direction|path_(?:index|position|positionprevious|speed|scale|orientation|endaction)|object_index|id|solid|persistent|mask_index|instance_(?:count|id)|alarm|timeline_(?:index|position|speed|running|loop)|visible|sprite_(?:index|width|height|xoffset|yoffset)|image_(?:number|index|speed|depth|xscale|yscale|angle|alpha|blend)|bbox_(?:left|right|top|bottom)|layer|phy_(?:rotation|(?:position|linear_velocity|speed|com|collision|col_normal)_(?:x|y)|angular_(?:velocity|damping)|position_(?:x|y)previous|speed|linear_damping|bullet|fixed_rotation|active|mass|inertia|dynamic|kinematic|sleeping|collision_points)|working_directory|webgl_enabled|view_(?:(?:y|x|w|h)view|(?:y|x|w|h)port|(?:v|h)(?:speed|border)|visible|surface_id|object|enabled|current|angle)|undefined|transition_(?:steps|kind|color)|temp_directory|show_(?:score|lives|health)|secure_mode|score|room_(?:width|speed|persistent|last|height|first|caption)|room|pointer_(?:null|invalid)|os_(?:version|type|device|browser)|mouse_(?:y|x|lastbutton|button)|lives|keyboard_(?:string|lastkey|lastchar|key)|iap_data|health|gamemaker_(?:version|registered|pro)|game_(?:save|project|display)_(?:id|name)|fps_real|fps|event_(?:type|object|number|action)|error_(?:occurred|last)|display_aa|delta_time|debug_mode|cursor_sprite|current_(?:year|weekday|time|second|month|minute|hour|day)|caption_(?:score|lives|health)|browser_(?:width|height)|background_(?:yscale|y|xscale|x|width|vtiled|vspeed|visible|showcolour|showcolor|index|htiled|hspeed|height|foreground|colour|color|blend|alpha)|async_load|application_surface|argument(?:_relitive|_count|\d)|argument|global|local|self|other)\b/})}},function(module,exports,__webpack_require__){"use strict";module.exports=go;go.displayName="go";go.aliases=[];function go(Prism){Prism.languages.go=Prism.languages.extend("clike",{keyword:/\b(?:break|case|chan|const|continue|default|defer|else|fallthrough|for|func|go(?:to)?|if|import|interface|map|package|range|return|select|struct|switch|type|var)\b/,builtin:/\b(?:bool|byte|complex(?:64|128)|error|float(?:32|64)|rune|string|u?int(?:8|16|32|64)?|uintptr|append|cap|close|complex|copy|delete|imag|len|make|new|panic|print(?:ln)?|real|recover)\b/,boolean:/\b(?:_|iota|nil|true|false)\b/,operator:/[*\/%^!=]=?|\+[=+]?|-[=-]?|\|[=|]?|&(?:=|&|\^=?)?|>(?:>=?|=)?|<(?:<=?|=|-)?|:=|\.\.\./,number:/(?:\b0x[a-f\d]+|(?:\b\d+\.?\d*|\B\.\d+)(?:e[-+]?\d+)?)i?/i,string:{pattern:/(["'`])(?:\\[\s\S]|(?!\1)[^\\])*\1/,greedy:true}});delete Prism.languages.go["class-name"]}},function(module,exports,__webpack_require__){"use strict";module.exports=graphql;graphql.displayName="graphql";graphql.aliases=[];function graphql(Prism){Prism.languages.graphql={comment:/#.*/,description:{pattern:/(?:"""(?:[^"]|(?!""")")*"""|"(?:\\.|[^\\"\r\n])*")(?=\s*[a-z_])/i,greedy:true,alias:"string",inside:{"language-markdown":{pattern:/(^"(?:"")?)(?!\1)[\s\S]+(?=\1$)/,lookbehind:true,inside:Prism.languages.markdown}}},string:{pattern:/"""(?:[^"]|(?!""")")*"""|"(?:\\.|[^\\"\r\n])*"/,greedy:true},number:/(?:\B-|\b)\d+(?:\.\d+)?(?:e[+-]?\d+)?\b/i,boolean:/\b(?:true|false)\b/,variable:/\$[a-z_]\w*/i,directive:{pattern:/@[a-z_]\w*/i,alias:"function"},"attr-name":{pattern:/[a-z_]\w*(?=\s*(?:\((?:[^()"]|"(?:\\.|[^\\"\r\n])*")*\))?:)/i,greedy:true},"class-name":{pattern:/(\b(?:enum|implements|interface|on|scalar|type|union)\s+|&\s*)[a-zA-Z_]\w*/,lookbehind:true},fragment:{pattern:/(\bfragment\s+|\.{3}\s*(?!on\b))[a-zA-Z_]\w*/,lookbehind:true,alias:"function"},keyword:/\b(?:directive|enum|extend|fragment|implements|input|interface|mutation|on|query|repeatable|scalar|schema|subscription|type|union)\b/,operator:/[!=|&]|\.{3}/,punctuation:/[!(){}\[\]:=,]/,constant:/\b(?!ID\b)[A-Z][A-Z_\d]*\b/}}},function(module,exports,__webpack_require__){"use strict";module.exports=groovy;groovy.displayName="groovy";groovy.aliases=[];function groovy(Prism){Prism.languages.groovy=Prism.languages.extend("clike",{string:[{pattern:/("""|''')(?:[^\\]|\\[\s\S])*?\1|\$\/(?:[^/$]|\$(?:[/$]|(?![/$]))|\/(?!\$))*\/\$/,greedy:true},{pattern:/(["'/])(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true}],keyword:/\b(?:as|def|in|abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|extends|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|native|new|package|private|protected|public|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|trait|transient|try|void|volatile|while)\b/,number:/\b(?:0b[01_]+|0x[\da-f_]+(?:\.[\da-f_p\-]+)?|[\d_]+(?:\.[\d_]+)?(?:e[+-]?[\d]+)?)[glidf]?\b/i,operator:{pattern:/(^|[^.])(?:~|==?~?|\?[.:]?|\*(?:[.=]|\*=?)?|\.[@&]|\.\.<|\.\.(?!\.)|-[-=>]?|\+[+=]?|!=?|<(?:<=?|=>?)?|>(?:>>?=?|=)?|&[&=]?|\|[|=]?|\/=?|\^=?|%=?)/,lookbehind:true},punctuation:/\.+|[{}[\];(),:$]/});Prism.languages.insertBefore("groovy","string",{shebang:{pattern:/#!.+/,alias:"comment"}});Prism.languages.insertBefore("groovy","punctuation",{"spock-block":/\b(?:setup|given|when|then|and|cleanup|expect|where):/});Prism.languages.insertBefore("groovy","function",{annotation:{pattern:/(^|[^.])@\w+/,lookbehind:true,alias:"punctuation"}});Prism.hooks.add("wrap",(function(env){if(env.language==="groovy"&&env.type==="string"){var delimiter=env.content.value[0];if(delimiter!="'"){var pattern=/([^\\])(?:\$(?:\{.*?\}|[\w.]+))/;if(delimiter==="$"){pattern=/([^\$])(?:\$(?:\{.*?\}|[\w.]+))/}env.content.value=env.content.value.replace(/&lt;/g,"<").replace(/&amp;/g,"&");env.content=Prism.highlight(env.content.value,{expression:{pattern:pattern,lookbehind:true,inside:Prism.languages.groovy}});env.classes.push(delimiter==="/"?"regex":"gstring")}}}))}},function(module,exports,__webpack_require__){"use strict";var refractorRuby=__webpack_require__(115);module.exports=haml;haml.displayName="haml";haml.aliases=[];function haml(Prism){Prism.register(refractorRuby);(function(Prism){Prism.languages.haml={"multiline-comment":{pattern:/((?:^|\r?\n|\r)([\t ]*))(?:\/|-#).*(?:(?:\r?\n|\r)\2[\t ]+.+)*/,lookbehind:true,alias:"comment"},"multiline-code":[{pattern:/((?:^|\r?\n|\r)([\t ]*)(?:[~-]|[&!]?=)).*,[\t ]*(?:(?:\r?\n|\r)\2[\t ]+.*,[\t ]*)*(?:(?:\r?\n|\r)\2[\t ]+.+)/,lookbehind:true,inside:Prism.languages.ruby},{pattern:/((?:^|\r?\n|\r)([\t ]*)(?:[~-]|[&!]?=)).*\|[\t ]*(?:(?:\r?\n|\r)\2[\t ]+.*\|[\t ]*)*/,lookbehind:true,inside:Prism.languages.ruby}],filter:{pattern:/((?:^|\r?\n|\r)([\t ]*)):[\w-]+(?:(?:\r?\n|\r)(?:\2[\t ]+.+|\s*?(?=\r?\n|\r)))+/,lookbehind:true,inside:{"filter-name":{pattern:/^:[\w-]+/,alias:"variable"}}},markup:{pattern:/((?:^|\r?\n|\r)[\t ]*)<.+/,lookbehind:true,inside:Prism.languages.markup},doctype:{pattern:/((?:^|\r?\n|\r)[\t ]*)!!!(?: .+)?/,lookbehind:true},tag:{pattern:/((?:^|\r?\n|\r)[\t ]*)[%.#][\w\-#.]*[\w\-](?:\([^)]+\)|\{(?:\{[^}]+\}|[^}])+\}|\[[^\]]+\])*[\/<>]*/,lookbehind:true,inside:{attributes:[{pattern:/(^|[^#])\{(?:\{[^}]+\}|[^}])+\}/,lookbehind:true,inside:Prism.languages.ruby},{pattern:/\([^)]+\)/,inside:{"attr-value":{pattern:/(=\s*)(?:"(?:\\.|[^\\"\r\n])*"|[^)\s]+)/,lookbehind:true},"attr-name":/[\w:-]+(?=\s*!?=|\s*[,)])/,punctuation:/[=(),]/}},{pattern:/\[[^\]]+\]/,inside:Prism.languages.ruby}],punctuation:/[<>]/}},code:{pattern:/((?:^|\r?\n|\r)[\t ]*(?:[~-]|[&!]?=)).+/,lookbehind:true,inside:Prism.languages.ruby},interpolation:{pattern:/#\{[^}]+\}/,inside:{delimiter:{pattern:/^#\{|\}$/,alias:"punctuation"},rest:Prism.languages.ruby}},punctuation:{pattern:/((?:^|\r?\n|\r)[\t ]*)[~=\-&!]+/,lookbehind:true}};var filter_pattern="((?:^|\\r?\\n|\\r)([\\t ]*)):{{filter_name}}(?:(?:\\r?\\n|\\r)(?:\\2[\\t ]+.+|\\s*?(?=\\r?\\n|\\r)))+";var filters=["css",{filter:"coffee",language:"coffeescript"},"erb","javascript","less","markdown","ruby","scss","textile"];var all_filters={};for(var i=0,l=filters.length;i<l;i++){var filter=filters[i];filter=typeof filter==="string"?{filter:filter,language:filter}:filter;if(Prism.languages[filter.language]){all_filters["filter-"+filter.filter]={pattern:RegExp(filter_pattern.replace("{{filter_name}}",(function(){return filter.filter}))),lookbehind:true,inside:{"filter-name":{pattern:/^:[\w-]+/,alias:"variable"},rest:Prism.languages[filter.language]}}}}Prism.languages.insertBefore("haml","filter",all_filters)})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=handlebars;handlebars.displayName="handlebars";handlebars.aliases=[];function handlebars(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.handlebars={comment:/\{\{![\s\S]*?\}\}/,delimiter:{pattern:/^\{\{\{?|\}\}\}?$/i,alias:"punctuation"},string:/(["'])(?:\\.|(?!\1)[^\\\r\n])*\1/,number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee][+-]?\d+)?/,boolean:/\b(?:true|false)\b/,block:{pattern:/^(\s*~?\s*)[#\/]\S+?(?=\s*~?\s*$|\s)/i,lookbehind:true,alias:"keyword"},brackets:{pattern:/\[[^\]]+\]/,inside:{punctuation:/\[|\]/,variable:/[\s\S]+/}},punctuation:/[!"#%&':()*+,.\/;<=>@\[\\\]^`{|}~]/,variable:/[^!"#%&'()*+,\/;<=>@\[\\\]^`{|}~\s]+/};Prism.hooks.add("before-tokenize",(function(env){var handlebarsPattern=/\{\{\{[\s\S]+?\}\}\}|\{\{[\s\S]+?\}\}/g;Prism.languages["markup-templating"].buildPlaceholders(env,"handlebars",handlebarsPattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"handlebars")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=haxe;haxe.displayName="haxe";haxe.aliases=[];function haxe(Prism){Prism.languages.haxe=Prism.languages.extend("clike",{string:{pattern:/(["'])(?:(?!\1)[^\\]|\\[\s\S])*\1/,greedy:true,inside:{interpolation:{pattern:/(^|[^\\])\$(?:\w+|\{[^}]+\})/,lookbehind:true,inside:{interpolation:{pattern:/^\$\w*/,alias:"variable"}}}}},keyword:/\bthis\b|\b(?:abstract|as|break|case|cast|catch|class|continue|default|do|dynamic|else|enum|extends|extern|from|for|function|if|implements|import|in|inline|interface|macro|new|null|override|public|private|return|static|super|switch|throw|to|try|typedef|using|var|while)(?!\.)\b/,operator:/\.{3}|\+\+?|-[->]?|[=!]=?|&&?|\|\|?|<[<=]?|>[>=]?|[*\/%~^]/});Prism.languages.insertBefore("haxe","class-name",{regex:{pattern:/~\/(?:[^\/\\\r\n]|\\.)+\/[igmsu]*/,greedy:true}});Prism.languages.insertBefore("haxe","keyword",{preprocessor:{pattern:/#\w+/,alias:"builtin"},metadata:{pattern:/@:?\w+/,alias:"symbol"},reification:{pattern:/\$(?:\w+|(?=\{))/,alias:"variable"}});Prism.languages.haxe["string"].inside["interpolation"].inside.rest=Prism.languages.haxe;delete Prism.languages.haxe["class-name"]}},function(module,exports,__webpack_require__){"use strict";module.exports=hcl;hcl.displayName="hcl";hcl.aliases=[];function hcl(Prism){Prism.languages.hcl={comment:/(?:\/\/|#).*|\/\*[\s\S]*?(?:\*\/|$)/,heredoc:{pattern:/<<-?(\w+)[\s\S]*?^\s*\1/m,greedy:true,alias:"string"},keyword:[{pattern:/(?:resource|data)\s+(?:"(?:\\[\s\S]|[^\\"])*")(?=\s+"[\w-]+"\s+{)/i,inside:{type:{pattern:/(resource|data|\s+)(?:"(?:\\[\s\S]|[^\\"])*")/i,lookbehind:true,alias:"variable"}}},{pattern:/(?:provider|provisioner|variable|output|module|backend)\s+(?:[\w-]+|"(?:\\[\s\S]|[^\\"])*")\s+(?={)/i,inside:{type:{pattern:/(provider|provisioner|variable|output|module|backend)\s+(?:[\w-]+|"(?:\\[\s\S]|[^\\"])*")\s+/i,lookbehind:true,alias:"variable"}}},/[\w-]+(?=\s+{)/],property:[/[\w-\.]+(?=\s*=(?!=))/,/"(?:\\[\s\S]|[^\\"])+"(?=\s*[:=])/],string:{pattern:/"(?:[^\\$"]|\\[\s\S]|\$(?:(?=")|\$+|[^"${])|\$\{(?:[^{}"]|"(?:[^\\"]|\\[\s\S])*")*\})*"/,greedy:true,inside:{interpolation:{pattern:/(^|[^$])\$\{(?:[^{}"]|"(?:[^\\"]|\\[\s\S])*")*\}/,lookbehind:true,inside:{type:{pattern:/(\b(?:terraform|var|self|count|module|path|data|local)\b\.)[\w\*]+/i,lookbehind:true,alias:"variable"},keyword:/\b(?:terraform|var|self|count|module|path|data|local)\b/i,function:/\w+(?=\()/,string:{pattern:/"(?:\\[\s\S]|[^\\"])*"/,greedy:true},number:/\b0x[\da-f]+\b|\b\d+\.?\d*(?:e[+-]?\d+)?/i,punctuation:/[!\$#%&'()*+,.\/;<=>@\[\\\]^`{|}~?:]/}}}},number:/\b0x[\da-f]+\b|\b\d+\.?\d*(?:e[+-]?\d+)?/i,boolean:/\b(?:true|false)\b/i,punctuation:/[=\[\]{}]/}}},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=hlsl;hlsl.displayName="hlsl";hlsl.aliases=[];function hlsl(Prism){Prism.register(refractorC);Prism.languages.hlsl=Prism.languages.extend("c",{"class-name":[Prism.languages.c["class-name"],/\b(?:AppendStructuredBuffer|BlendState|Buffer|ByteAddressBuffer|CompileShader|ComputeShader|ConsumeStructuredBuffer|DepthStencilState|DepthStencilView|DomainShader|GeometryShader|Hullshader|InputPatch|LineStream|OutputPatch|PixelShader|PointStream|RasterizerState|RenderTargetView|RWBuffer|RWByteAddressBuffer|RWStructuredBuffer|RWTexture(?:1D|1DArray|2D|2DArray|3D)|SamplerComparisonState|SamplerState|StructuredBuffer|Texture(?:1D|1DArray|2D|2DArray|2DMS|2DMSArray|3D|Cube|CubeArray)|TriangleStream|VertexShader)\b/],keyword:[/\b(?:asm|asm_fragment|auto|break|case|catch|cbuffer|centroid|char|class|column_major|compile|compile_fragment|const|const_cast|continue|default|delete|discard|do|dynamic_cast|else|enum|explicit|export|extern|for|friend|fxgroup|goto|groupshared|if|in|inline|inout|interface|line|lineadj|linear|long|matrix|mutable|namespace|new|nointerpolation|noperspective|operator|out|packoffset|pass|pixelfragment|point|precise|private|protected|public|register|reinterpret_cast|return|row_major|sample|sampler|shared|short|signed|sizeof|snorm|stateblock|stateblock_state|static|static_cast|string|struct|switch|tbuffer|technique|technique10|technique11|template|texture|this|throw|triangle|triangleadj|try|typedef|typename|uniform|union|unorm|unsigned|using|vector|vertexfragment|virtual|void|volatile|while)\b/,/\b(?:bool|double|dword|float|half|int|min(?:10float|12int|16(?:float|int|uint))|uint)(?:[1-4](?:x[1-4])?)?\b/],number:/(?:(?:\b\d+\.?\d*|\B\.\d+)(?:[eE][+-]?\d+)?|\b0x[\da-fA-F]+)[fFhHlLuU]?\b/,boolean:/\b(?:false|true)\b/})}},function(module,exports,__webpack_require__){"use strict";module.exports=hpkp;hpkp.displayName="hpkp";hpkp.aliases=[];function hpkp(Prism){Prism.languages.hpkp={directive:{pattern:/\b(?:(?:includeSubDomains|preload|strict)(?: |;)|pin-sha256="[a-zA-Z\d+=/]+"|(?:max-age|report-uri)=|report-to )/,alias:"keyword"},safe:{pattern:/\b\d{7,}\b/,alias:"selector"},unsafe:{pattern:/\b\d{1,6}\b/,alias:"function"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=hsts;hsts.displayName="hsts";hsts.aliases=[];function hsts(Prism){Prism.languages.hsts={directive:{pattern:/\b(?:max-age=|includeSubDomains|preload)/,alias:"keyword"},safe:{pattern:/\b\d{8,}\b/,alias:"selector"},unsafe:{pattern:/\b\d{1,7}\b/,alias:"function"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=http;http.displayName="http";http.aliases=[];function http(Prism){(function(Prism){Prism.languages.http={"request-line":{pattern:/^(?:POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\s(?:https?:\/\/|\/)\S+\sHTTP\/[0-9.]+/m,inside:{property:/^(?:POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\b/,"attr-name":/:\w+/}},"response-status":{pattern:/^HTTP\/1.[01] \d+.*/m,inside:{property:{pattern:/(^HTTP\/1.[01] )\d+.*/i,lookbehind:true}}},"header-name":{pattern:/^[\w-]+:(?=.)/m,alias:"keyword"}};var langs=Prism.languages;var httpLanguages={"application/javascript":langs.javascript,"application/json":langs.json||langs.javascript,"application/xml":langs.xml,"text/xml":langs.xml,"text/html":langs.html,"text/css":langs.css};var suffixTypes={"application/json":true,"application/xml":true};function getSuffixPattern(contentType){var suffix=contentType.replace(/^[a-z]+\//,"");var suffixPattern="\\w+/(?:[\\w.-]+\\+)+"+suffix+"(?![+\\w.-])";return"(?:"+contentType+"|"+suffixPattern+")"}var options;for(var contentType in httpLanguages){if(httpLanguages[contentType]){options=options||{};var pattern=suffixTypes[contentType]?getSuffixPattern(contentType):contentType;options[contentType.replace(/\//g,"-")]={pattern:RegExp("(content-type:\\s*"+pattern+"[\\s\\S]*?)(?:\\r?\\n|\\r){2}[\\s\\S]*","i"),lookbehind:true,inside:httpLanguages[contentType]}}}if(options){Prism.languages.insertBefore("http","header-name",options)}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=ichigojam;ichigojam.displayName="ichigojam";ichigojam.aliases=[];function ichigojam(Prism){Prism.languages.ichigojam={comment:/(?:\B'|REM)(?:[^\n\r]*)/i,string:{pattern:/"(?:""|[!#$%&'()*,\/:;<=>?^_ +\-.A-Z\d])*"/i,greedy:true},number:/\B#[0-9A-F]+|\B`[01]+|(?:\b\d+\.?\d*|\B\.\d+)(?:E[+-]?\d+)?/i,keyword:/\b(?:BEEP|BPS|CASE|CLEAR|CLK|CLO|CLP|CLS|CLT|CLV|CONT|COPY|ELSE|END|FILE|FILES|FOR|GOSUB|GSB|GOTO|IF|INPUT|KBD|LED|LET|LIST|LOAD|LOCATE|LRUN|NEW|NEXT|OUT|RIGHT|PLAY|POKE|PRINT|PWM|REM|RENUM|RESET|RETURN|RTN|RUN|SAVE|SCROLL|SLEEP|SRND|STEP|STOP|SUB|TEMPO|THEN|TO|UART|VIDEO|WAIT)(?:\$|\b)/i,function:/\b(?:ABS|ANA|ASC|BIN|BTN|DEC|END|FREE|HELP|HEX|I2CR|I2CW|IN|INKEY|LEN|LINE|PEEK|RND|SCR|SOUND|STR|TICK|USR|VER|VPEEK|ZER)(?:\$|\b)/i,label:/(?:\B@[^\s]+)/i,operator:/<[=>]?|>=?|\|\||&&|[+\-*\/=|&^~!]|\b(?:AND|NOT|OR)\b/i,punctuation:/[\[,;:()\]]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=icon;icon.displayName="icon";icon.aliases=[];function icon(Prism){Prism.languages.icon={comment:/#.*/,string:{pattern:/(["'])(?:(?!\1)[^\\\r\n_]|\\.|_(?!\1)(?:\r\n|[\s\S]))*\1/,greedy:true},number:/\b(?:\d+r[a-z\d]+|\d+(?:\.\d+)?(?:e[+-]?\d+)?)\b|\.\d+\b/i,"builtin-keyword":{pattern:/&(?:allocated|ascii|clock|collections|cset|current|date|dateline|digits|dump|e|error(?:number|text|value)?|errout|fail|features|file|host|input|lcase|letters|level|line|main|null|output|phi|pi|pos|progname|random|regions|source|storage|subject|time|trace|ucase|version)\b/,alias:"variable"},directive:{pattern:/\$\w+/,alias:"builtin"},keyword:/\b(?:break|by|case|create|default|do|else|end|every|fail|global|if|initial|invocable|link|local|next|not|of|procedure|record|repeat|return|static|suspend|then|to|until|while)\b/,function:/(?!\d)\w+(?=\s*[({]|\s*!\s*\[)/,operator:/[+-]:(?!=)|(?:[\/?@^%&]|\+\+?|--?|==?=?|~==?=?|\*\*?|\|\|\|?|<(?:->?|<?=?)|>>?=?)(?::=)?|:(?:=:?)?|[!.\\|~]/,punctuation:/[\[\](){},;]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=iecst;iecst.displayName="iecst";iecst.aliases=[];function iecst(Prism){Prism.languages.iecst={comment:[{pattern:/(^|[^\\])(?:\/\*[\s\S]*?(?:\*\/|$)|\(\*[\s\S]*?(?:\*\)|$)|\{[\s\S]*?(?:\}|$))/,lookbehind:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true,greedy:true}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},"class-name":/\b(?:END_)?(?:PROGRAM|CONFIGURATION|INTERFACE|FUNCTION_BLOCK|FUNCTION|ACTION|TRANSITION|TYPE|STRUCT|(?:INITIAL_)?STEP|NAMESPACE|LIBRARY|CHANNEL|FOLDER|RESOURCE|VAR_(?:GLOBAL|INPUT|PUTPUT|IN_OUT|ACCESS|TEMP|EXTERNAL|CONFIG)|VAR|METHOD|PROPERTY)\b/i,keyword:/\b(?:(?:END_)?(?:IF|WHILE|REPEAT|CASE|FOR)|ELSE|FROM|THEN|ELSIF|DO|TO|BY|PRIVATE|PUBLIC|PROTECTED|CONSTANT|RETURN|EXIT|CONTINUE|GOTO|JMP|AT|RETAIN|NON_RETAIN|TASK|WITH|UNTIL|USING|EXTENDS|IMPLEMENTS|GET|SET|__TRY|__CATCH|__FINALLY|__ENDTRY)\b/,variable:/\b(?:AT|BOOL|BYTE|(?:D|L)?WORD|U?(?:S|D|L)?INT|L?REAL|TIME(?:_OF_DAY)?|TOD|DT|DATE(?:_AND_TIME)?|STRING|ARRAY|ANY|POINTER)\b/,symbol:/%[IQM][XBWDL][\d.]*|%[IQ][\d.]*/,number:/\b(?:16#[\da-f]+|2#[01_]+|0x[\da-f]+)\b|\b(?:T|D|DT|TOD)#[\d_shmd:]*|\b[A-Z]*\#[\d.,_]*|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,boolean:/\b(?:TRUE|FALSE|NULL)\b/,function:/\w+(?=\()/,operator:/(?:S?R?:?=>?|&&?|\*\*?|<=?|>=?|[-:^/+])|\b(?:OR|AND|MOD|NOT|XOR|LE|GE|EQ|NE|GT|LT)\b/,punctuation:/[();]/,type:{pattern:/#/,alias:"selector"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=ignore;ignore.displayName="ignore";ignore.aliases=[];function ignore(Prism){(function(Prism){Prism.languages.ignore={comment:/^#.*/m,entry:{pattern:/\S(?:.*(?:(?:\\ )|\S))?/,alias:"string",inside:{operator:/^!|\*\*?|\?/,regex:{pattern:/(^|[^\\])\[[^\[\]]*\]/,lookbehind:true},punctuation:/\//}}};Prism.languages.gitignore=Prism.languages.ignore;Prism.languages.hgignore=Prism.languages.ignore;Prism.languages.npmignore=Prism.languages.ignore})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=inform7;inform7.displayName="inform7";inform7.aliases=[];function inform7(Prism){Prism.languages.inform7={string:{pattern:/"[^"]*"/,inside:{substitution:{pattern:/\[[^\]]+\]/,inside:{delimiter:{pattern:/\[|\]/,alias:"punctuation"}}}}},comment:{pattern:/\[[^\]]+\]/,greedy:true},title:{pattern:/^[ \t]*(?:volume|book|part(?! of)|chapter|section|table)\b.+/im,alias:"important"},number:{pattern:/(^|[^-])(?:\b\d+(?:\.\d+)?(?:\^\d+)?\w*|\b(?:one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve))\b(?!-)/i,lookbehind:true},verb:{pattern:/(^|[^-])\b(?:applying to|are|attacking|answering|asking|be(?:ing)?|burning|buying|called|carries|carry(?! out)|carrying|climbing|closing|conceal(?:s|ing)?|consulting|contain(?:s|ing)?|cutting|drinking|dropping|eating|enclos(?:es?|ing)|entering|examining|exiting|getting|giving|going|ha(?:ve|s|ving)|hold(?:s|ing)?|impl(?:y|ies)|incorporat(?:es?|ing)|inserting|is|jumping|kissing|listening|locking|looking|mean(?:s|ing)?|opening|provid(?:es?|ing)|pulling|pushing|putting|relat(?:es?|ing)|removing|searching|see(?:s|ing)?|setting|showing|singing|sleeping|smelling|squeezing|switching|support(?:s|ing)?|swearing|taking|tasting|telling|thinking|throwing|touching|turning|tying|unlock(?:s|ing)?|var(?:y|ies|ying)|waiting|waking|waving|wear(?:s|ing)?)\b(?!-)/i,lookbehind:true,alias:"operator"},keyword:{pattern:/(^|[^-])\b(?:after|before|carry out|check|continue the action|definition(?= *:)|do nothing|else|end (?:if|unless|the story)|every turn|if|include|instead(?: of)?|let|move|no|now|otherwise|repeat|report|resume the story|rule for|running through|say(?:ing)?|stop the action|test|try(?:ing)?|understand|unless|use|when|while|yes)\b(?!-)/i,lookbehind:true},property:{pattern:/(^|[^-])\b(?:adjacent(?! to)|carried|closed|concealed|contained|dark|described|edible|empty|enclosed|enterable|even|female|fixed in place|full|handled|held|improper-named|incorporated|inedible|invisible|lighted|lit|lock(?:able|ed)|male|marked for listing|mentioned|negative|neuter|non-(?:empty|full|recurring)|odd|opaque|open(?:able)?|plural-named|portable|positive|privately-named|proper-named|provided|publically-named|pushable between rooms|recurring|related|rubbing|scenery|seen|singular-named|supported|swinging|switch(?:able|ed(?: on| off)?)|touch(?:able|ed)|transparent|unconcealed|undescribed|unlit|unlocked|unmarked for listing|unmentioned|unopenable|untouchable|unvisited|variable|visible|visited|wearable|worn)\b(?!-)/i,lookbehind:true,alias:"symbol"},position:{pattern:/(^|[^-])\b(?:above|adjacent to|back side of|below|between|down|east|everywhere|front side|here|in|inside(?: from)?|north(?:east|west)?|nowhere|on(?: top of)?|other side|outside(?: from)?|parts? of|regionally in|south(?:east|west)?|through|up|west|within)\b(?!-)/i,lookbehind:true,alias:"keyword"},type:{pattern:/(^|[^-])\b(?:actions?|activit(?:y|ies)|actors?|animals?|backdrops?|containers?|devices?|directions?|doors?|holders?|kinds?|lists?|m[ae]n|nobody|nothing|nouns?|numbers?|objects?|people|persons?|player(?:'s holdall)?|regions?|relations?|rooms?|rule(?:book)?s?|scenes?|someone|something|supporters?|tables?|texts?|things?|time|vehicles?|wom[ae]n)\b(?!-)/i,lookbehind:true,alias:"variable"},punctuation:/[.,:;(){}]/};Prism.languages.inform7["string"].inside["substitution"].inside.rest=Prism.languages.inform7;Prism.languages.inform7["string"].inside["substitution"].inside.rest.text={pattern:/\S(?:\s*\S)*/,alias:"comment"}}},function(module,exports,__webpack_require__){"use strict";module.exports=ini;ini.displayName="ini";ini.aliases=[];function ini(Prism){Prism.languages.ini={comment:/^[ \t]*[;#].*$/m,selector:/^[ \t]*\[.*?\]/m,constant:/^[ \t]*[^\s=]+?(?=[ \t]*=)/m,"attr-value":{pattern:/=.*/,inside:{punctuation:/^[=]/}}}}},function(module,exports,__webpack_require__){"use strict";module.exports=io;io.displayName="io";io.aliases=[];function io(Prism){Prism.languages.io={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:true},{pattern:/(^|[^\\])\/\/.*/,lookbehind:true},{pattern:/(^|[^\\])#.*/,lookbehind:true}],"triple-quoted-string":{pattern:/"""(?:\\[\s\S]|(?!""")[^\\])*"""/,greedy:true,alias:"string"},string:{pattern:/"(?:\\.|[^\\\r\n"])*"/,greedy:true},keyword:/\b(?:activate|activeCoroCount|asString|block|break|catch|clone|collectGarbage|compileString|continue|do|doFile|doMessage|doString|else|elseif|exit|for|foreach|forward|getSlot|getEnvironmentVariable|hasSlot|if|ifFalse|ifNil|ifNilEval|ifTrue|isActive|isNil|isResumable|list|message|method|parent|pass|pause|perform|performWithArgList|print|println|proto|raise|raiseResumable|removeSlot|resend|resume|schedulerSleepSeconds|self|sender|setSchedulerSleepSeconds|setSlot|shallowCopy|slotNames|super|system|then|thisBlock|thisContext|call|try|type|uniqueId|updateSlot|wait|while|write|yield)\b/,builtin:/\b(?:Array|AudioDevice|AudioMixer|Block|Box|Buffer|CFunction|CGI|Color|Curses|DBM|DNSResolver|DOConnection|DOProxy|DOServer|Date|Directory|Duration|DynLib|Error|Exception|FFT|File|Fnmatch|Font|Future|GL|GLE|GLScissor|GLU|GLUCylinder|GLUQuadric|GLUSphere|GLUT|Host|Image|Importer|LinkList|List|Lobby|Locals|MD5|MP3Decoder|MP3Encoder|Map|Message|Movie|Notification|Number|Object|OpenGL|Point|Protos|Regex|SGML|SGMLElement|SGMLParser|SQLite|Server|Sequence|ShowMessage|SleepyCat|SleepyCatCursor|Socket|SocketManager|Sound|Soup|Store|String|Tree|UDPSender|UPDReceiver|URL|User|Warning|WeakLink|Random|BigNum)\b/,boolean:/\b(?:true|false|nil)\b/,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e-?\d+)?/i,operator:/[=!*/%+\-^&|]=|>>?=?|<<?=?|:?:?=|\+\+?|--?|\*\*?|\/\/?|%|\|\|?|&&?|\b(?:return|and|or|not)\b|@@?|\?\??|\.\./,punctuation:/[{}[\];(),.:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=j;j.displayName="j";j.aliases=[];function j(Prism){Prism.languages.j={comment:/\bNB\..*/,string:{pattern:/'(?:''|[^'\r\n])*'/,greedy:true},keyword:/\b(?:(?:adverb|conjunction|CR|def|define|dyad|LF|monad|noun|verb)\b|(?:assert|break|case|catch[dt]?|continue|do|else|elseif|end|fcase|for|for_\w+|goto_\w+|if|label_\w+|return|select|throw|try|while|whilst)\.)/,verb:{pattern:/(?!\^:|;\.|[=!][.:])(?:\{(?:\.|::?)?|p(?:\.\.?|:)|[=!\]]|[<>+*\-%$|,#][.:]?|[?^]\.?|[;\[]:?|[~}"i][.:]|[ACeEIjLor]\.|(?:[_\/\\qsux]|_?\d):)/,alias:"keyword"},number:/\b_?(?:(?!\d:)\d+(?:\.\d+)?(?:(?:[ejpx]|ad|ar)_?\d+(?:\.\d+)?)*(?:b_?[\da-z]+(?:\.[\da-z]+)?)?|_\b(?!\.))/,adverb:{pattern:/[~}]|[\/\\]\.?|[bfM]\.|t[.:]/,alias:"builtin"},operator:/[=a][.:]|_\./,conjunction:{pattern:/&(?:\.:?|:)?|[.:@][.:]?|[!D][.:]|[;dHT]\.|`:?|[\^LS]:|"/,alias:"variable"},punctuation:/[()]/}}},function(module,exports,__webpack_require__){"use strict";var refractorJava=__webpack_require__(133);var refractorJavadoclike=__webpack_require__(116);module.exports=javadoc;javadoc.displayName="javadoc";javadoc.aliases=[];function javadoc(Prism){Prism.register(refractorJava);Prism.register(refractorJavadoclike);(function(Prism){var codeLinePattern=/(^(?:\s*(?:\*\s*)*)).*[^*\s].*$/m;var memberReference=/#\s*\w+(?:\s*\([^()]*\))?/.source;var reference=/(?:[a-zA-Z]\w+\s*\.\s*)*[A-Z]\w*(?:\s*<mem>)?|<mem>/.source.replace(/<mem>/g,(function(){return memberReference}));Prism.languages.javadoc=Prism.languages.extend("javadoclike",{});Prism.languages.insertBefore("javadoc","keyword",{reference:{pattern:RegExp(/(@(?:exception|throws|see|link|linkplain|value)\s+(?:\*\s*)?)/.source+"(?:"+reference+")"),lookbehind:true,inside:{function:{pattern:/(#\s*)\w+(?=\s*\()/,lookbehind:true},field:{pattern:/(#\s*)\w+/,lookbehind:true},namespace:{pattern:/\b(?:[a-z]\w*\s*\.\s*)+/,inside:{punctuation:/\./}},"class-name":/\b[A-Z]\w*/,keyword:Prism.languages.java.keyword,punctuation:/[#()[\],.]/}},"class-name":{pattern:/(@param\s+)<[A-Z]\w*>/,lookbehind:true,inside:{punctuation:/[.<>]/}},"code-section":[{pattern:/(\{@code\s+)(?:[^{}]|\{(?:[^{}]|\{(?:[^{}]|\{(?:[^{}]|\{[^{}]*\})*\})*\})*\})+?(?=\s*\})/,lookbehind:true,inside:{code:{pattern:codeLinePattern,lookbehind:true,inside:Prism.languages.java,alias:"language-java"}}},{pattern:/(<(code|pre|tt)>(?!<code>)\s*)[\s\S]+?(?=\s*<\/\2>)/,lookbehind:true,inside:{line:{pattern:codeLinePattern,lookbehind:true,inside:{tag:Prism.languages.markup.tag,entity:Prism.languages.markup.entity,code:{pattern:/.+/,inside:Prism.languages.java,alias:"language-java"}}}}}],tag:Prism.languages.markup.tag,entity:Prism.languages.markup.entity});Prism.languages.javadoclike.addSupport("java",Prism.languages.javadoc)})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=javascript;javascript.displayName="javascript";javascript.aliases=["js"];function javascript(Prism){Prism.languages.javascript=Prism.languages.extend("clike",{"class-name":[Prism.languages.clike["class-name"],{pattern:/(^|[^$\w\xA0-\uFFFF])[_$A-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\.(?:prototype|constructor))/,lookbehind:true}],keyword:[{pattern:/((?:^|})\s*)(?:catch|finally)\b/,lookbehind:true},{pattern:/(^|[^.]|\.\.\.\s*)\b(?:as|async(?=\s*(?:function\b|\(|[$\w\xA0-\uFFFF]|$))|await|break|case|class|const|continue|debugger|default|delete|do|else|enum|export|extends|for|from|function|(?:get|set)(?=\s*[\[$\w\xA0-\uFFFF])|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)\b/,lookbehind:true}],number:/\b(?:(?:0[xX](?:[\dA-Fa-f](?:_[\dA-Fa-f])?)+|0[bB](?:[01](?:_[01])?)+|0[oO](?:[0-7](?:_[0-7])?)+)n?|(?:\d(?:_\d)?)+n|NaN|Infinity)\b|(?:\b(?:\d(?:_\d)?)+\.?(?:\d(?:_\d)?)*|\B\.(?:\d(?:_\d)?)+)(?:[Ee][+-]?(?:\d(?:_\d)?)+)?/,function:/#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*(?:\.\s*(?:apply|bind|call)\s*)?\()/,operator:/--|\+\+|\*\*=?|=>|&&=?|\|\|=?|[!=]==|<<=?|>>>?=?|[-+*/%&|^!=<>]=?|\.{3}|\?\?=?|\?\.?|[~:]/});Prism.languages.javascript["class-name"][0].pattern=/(\b(?:class|interface|extends|implements|instanceof|new)\s+)[\w.\\]+/;Prism.languages.insertBefore("javascript","keyword",{regex:{pattern:/((?:^|[^$\w\xA0-\uFFFF."'\])\s]|\b(?:return|yield))\s*)\/(?:\[(?:[^\]\\\r\n]|\\.)*]|\\.|[^/\\\[\r\n])+\/[gimyus]{0,6}(?=(?:\s|\/\*(?:[^*]|\*(?!\/))*\*\/)*(?:$|[\r\n,.;:})\]]|\/\/))/,lookbehind:true,greedy:true,inside:{"regex-source":{pattern:/^(\/)[\s\S]+(?=\/[a-z]*$)/,lookbehind:true,alias:"language-regex",inside:Prism.languages.regex},"regex-flags":/[a-z]+$/,"regex-delimiter":/^\/|\/$/}},"function-variable":{pattern:/#?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*[=:]\s*(?:async\s*)?(?:\bfunction\b|(?:\((?:[^()]|\([^()]*\))*\)|[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)\s*=>))/,alias:"function"},parameter:[{pattern:/(function(?:\s+[_$A-Za-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)?\s*\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\))/,lookbehind:true,inside:Prism.languages.javascript},{pattern:/[_$a-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*=>)/i,inside:Prism.languages.javascript},{pattern:/(\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\)\s*=>)/,lookbehind:true,inside:Prism.languages.javascript},{pattern:/((?:\b|\s|^)(?!(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)(?![$\w\xA0-\uFFFF]))(?:[_$A-Za-z\xA0-\uFFFF][$\w\xA0-\uFFFF]*\s*)\(\s*|\]\s*\(\s*)(?!\s)(?:[^()]|\([^()]*\))+?(?=\s*\)\s*\{)/,lookbehind:true,inside:Prism.languages.javascript}],constant:/\b[A-Z](?:[A-Z_]|\dx?)*\b/});Prism.languages.insertBefore("javascript","string",{"template-string":{pattern:/`(?:\\[\s\S]|\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}|(?!\${)[^\\`])*`/,greedy:true,inside:{"template-punctuation":{pattern:/^`|`$/,alias:"string"},interpolation:{pattern:/((?:^|[^\\])(?:\\{2})*)\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}/,lookbehind:true,inside:{"interpolation-punctuation":{pattern:/^\${|}$/,alias:"punctuation"},rest:Prism.languages.javascript}},string:/[\s\S]+/}}});if(Prism.languages.markup){Prism.languages.markup.tag.addInlined("script","javascript")}Prism.languages.js=Prism.languages.javascript}},function(module,exports,__webpack_require__){"use strict";module.exports=javastacktrace;javastacktrace.displayName="javastacktrace";javastacktrace.aliases=[];function javastacktrace(Prism){Prism.languages.javastacktrace={summary:{pattern:/^[\t ]*(?:(?:Caused by:|Suppressed:|Exception in thread "[^"]*")[\t ]+)?[\w$.]+(?:\:.*)?$/m,inside:{keyword:{pattern:/^(\s*)(?:(?:Caused by|Suppressed)(?=:)|Exception in thread)/m,lookbehind:true},string:{pattern:/^(\s*)"[^"]*"/,lookbehind:true},exceptions:{pattern:/^(:?\s*)[\w$.]+(?=:|$)/,lookbehind:true,inside:{"class-name":/[\w$]+(?=$|:)/,namespace:/[a-z]\w*/,punctuation:/[.:]/}},message:{pattern:/(:\s*)\S.*/,lookbehind:true,alias:"string"},punctuation:/[:]/}},"stack-frame":{pattern:/^[\t ]*at [\w$.]+(?:<init>)?\([^()]*\)/m,inside:{keyword:{pattern:/^(\s*)at/,lookbehind:true},source:[{pattern:/(\()\w+.\w+:\d+(?=\))/,lookbehind:true,inside:{file:/^\w+\.\w+/,punctuation:/:/,"line-number":{pattern:/\d+/,alias:"number"}}},{pattern:/(\()[^()]*(?=\))/,lookbehind:true,inside:{keyword:/^(?:Unknown Source|Native Method)$/}}],"class-name":/[\w$]+(?=\.(?:<init>|[\w$]+)\()/,function:/(?:<init>|[\w$]+)(?=\()/,namespace:/[a-z]\w*/,punctuation:/[.()]/}},more:{pattern:/^[\t ]*\.{3} \d+ [a-z]+(?: [a-z]+)*/m,inside:{punctuation:/\.{3}/,number:/\d+/,keyword:/\b[a-z]+(?: [a-z]+)*\b/}}}}},function(module,exports,__webpack_require__){"use strict";module.exports=jolie;jolie.displayName="jolie";jolie.aliases=[];function jolie(Prism){Prism.languages.jolie=Prism.languages.extend("clike",{keyword:/\b(?:include|define|is_defined|undef|main|init|outputPort|inputPort|Location|Protocol|Interfaces|RequestResponse|OneWay|type|interface|extender|throws|cset|csets|forward|Aggregates|Redirects|embedded|courier|execution|sequential|concurrent|single|scope|install|throw|comp|cH|default|global|linkIn|linkOut|synchronized|this|new|for|if|else|while|in|Jolie|Java|Javascript|nullProcess|spawn|constants|with|provide|until|exit|foreach|instanceof|over|service)\b/,builtin:/\b(?:undefined|string|int|void|long|Byte|bool|double|float|char|any)\b/,number:/(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?l?/i,operator:/-[-=>]?|\+[+=]?|<[<=]?|[>=*!]=?|&&|\|\||[:?\/%^]/,symbol:/[|;@]/,punctuation:/[,.]/,string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true}});delete Prism.languages.jolie["class-name"];Prism.languages.insertBefore("jolie","keyword",{function:{pattern:/((?:\b(?:outputPort|inputPort|in|service|courier)\b|@)\s*)\w+/,lookbehind:true},aggregates:{pattern:/(\bAggregates\s*:\s*)(?:\w+(?:\s+with\s+\w+)?\s*,\s*)*\w+(?:\s+with\s+\w+)?/,lookbehind:true,inside:{"with-extension":{pattern:/\bwith\s+\w+/,inside:{keyword:/\bwith\b/}},function:{pattern:/\w+/},punctuation:{pattern:/,/}}},redirects:{pattern:/(\bRedirects\s*:\s*)(?:\w+\s*=>\s*\w+\s*,\s*)*(?:\w+\s*=>\s*\w+)/,lookbehind:true,inside:{punctuation:{pattern:/,/},function:{pattern:/\w+/},symbol:{pattern:/=>/}}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=jq;jq.displayName="jq";jq.aliases=[];function jq(Prism){(function(Prism){var interpolation=/\\\((?:[^()]|\([^()]*\))*\)/.source;var string=RegExp(/"(?:[^"\r\n\\]|\\[^\r\n(]|__)*"/.source.replace(/__/g,(function(){return interpolation})));var stringInterpolation={interpolation:{pattern:RegExp(/((?:^|[^\\])(?:\\{2})*)/.source+interpolation),lookbehind:true,inside:{content:{pattern:/^(\\\()[\s\S]+(?=\)$)/,lookbehind:true,inside:null},punctuation:/^\\\(|\)$/}}};var jq=Prism.languages.jq={comment:/#.*/,property:{pattern:RegExp(string.source+/(?=\s*:(?!:))/.source),greedy:true,inside:stringInterpolation},string:{pattern:string,greedy:true,inside:stringInterpolation},function:{pattern:/(\bdef\s+)[a-z_]\w+/i,lookbehind:true},variable:/\B\$\w+/,"property-literal":{pattern:/\b[a-z_]\w*(?=\s*:(?!:))/i,alias:"property"},keyword:/\b(?:as|break|catch|def|elif|else|end|foreach|if|import|include|label|module|modulemeta|null|reduce|then|try|while)\b/,boolean:/\b(?:true|false)\b/,number:/(?:\b\d+\.|\B\.)?\b\d+(?:[eE][+-]?\d+)?\b/,operator:[{pattern:/\|=?/,alias:"pipe"},/\.\.|[!=<>]?=|\?\/\/|\/\/=?|[-+*/%]=?|[<>?]|\b(?:and|or|not)\b/],"c-style-function":{pattern:/\b[a-z_]\w*(?=\s*\()/i,alias:"function"},punctuation:/::|[()\[\]{},:;]|\.(?=\s*[\[\w$])/,dot:{pattern:/\./,alias:"important"}};stringInterpolation.interpolation.inside.content.inside=jq})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=jsExtras;jsExtras.displayName="jsExtras";jsExtras.aliases=[];function jsExtras(Prism){(function(Prism){Prism.languages.insertBefore("javascript","function-variable",{"method-variable":{pattern:RegExp("(\\.\\s*)"+Prism.languages.javascript["function-variable"].pattern.source),lookbehind:true,alias:["function-variable","method","function","property-access"]}});Prism.languages.insertBefore("javascript","function",{method:{pattern:RegExp("(\\.\\s*)"+Prism.languages.javascript["function"].source),lookbehind:true,alias:["function","property-access"]}});Prism.languages.insertBefore("javascript","constant",{"known-class-name":[{pattern:/\b(?:(?:(?:Uint|Int)(?:8|16|32)|Uint8Clamped|Float(?:32|64))?Array|ArrayBuffer|BigInt|Boolean|DataView|Date|Error|Function|Intl|JSON|Math|Number|Object|Promise|Proxy|Reflect|RegExp|String|Symbol|(?:Weak)?(?:Set|Map)|WebAssembly)\b/,alias:"class-name"},{pattern:/\b(?:[A-Z]\w*)Error\b/,alias:"class-name"}]});function withId(source,flags){return RegExp(source.replace(/<ID>/g,(function(){return/[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*/.source})),flags)}Prism.languages.insertBefore("javascript","keyword",{imports:{pattern:withId(/(\bimport\b\s*)(?:<ID>(?:\s*,\s*(?:\*\s*as\s+<ID>|\{[^{}]*\}))?|\*\s*as\s+<ID>|\{[^{}]*\})(?=\s*\bfrom\b)/.source),lookbehind:true,inside:Prism.languages.javascript},exports:{pattern:withId(/(\bexport\b\s*)(?:\*(?:\s*as\s+<ID>)?(?=\s*\bfrom\b)|\{[^{}]*\})/.source),lookbehind:true,inside:Prism.languages.javascript}});Prism.languages.javascript["keyword"].unshift({pattern:/\b(?:as|default|export|from|import)\b/,alias:"module"},{pattern:/\b(?:await|break|catch|continue|do|else|for|finally|if|return|switch|throw|try|while|yield)\b/,alias:"control-flow"},{pattern:/\bnull\b/,alias:["null","nil"]},{pattern:/\bundefined\b/,alias:"nil"});Prism.languages.insertBefore("javascript","operator",{spread:{pattern:/\.{3}/,alias:"operator"},arrow:{pattern:/=>/,alias:"operator"}});Prism.languages.insertBefore("javascript","punctuation",{"property-access":{pattern:withId(/(\.\s*)#?<ID>/.source),lookbehind:true},"maybe-class-name":{pattern:/(^|[^$\w\xA0-\uFFFF])[A-Z][$\w\xA0-\uFFFF]+/,lookbehind:true},dom:{pattern:/\b(?:document|location|navigator|performance|(?:local|session)Storage|window)\b/,alias:"variable"},console:{pattern:/\bconsole(?=\s*\.)/,alias:"class-name"}});var maybeClassNameTokens=["function","function-variable","method","method-variable","property-access"];for(var i=0;i<maybeClassNameTokens.length;i++){var token=maybeClassNameTokens[i];var value=Prism.languages.javascript[token];if(Prism.util.type(value)==="RegExp"){value=Prism.languages.javascript[token]={pattern:value}}var inside=value.inside||{};value.inside=inside;inside["maybe-class-name"]=/^[A-Z][\s\S]*/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=jsTemplates;jsTemplates.displayName="jsTemplates";jsTemplates.aliases=[];function jsTemplates(Prism){(function(Prism){var templateString=Prism.languages.javascript["template-string"];var templateLiteralPattern=templateString.pattern.source;var interpolationObject=templateString.inside["interpolation"];var interpolationPunctuationObject=interpolationObject.inside["interpolation-punctuation"];var interpolationPattern=interpolationObject.pattern.source;function createTemplate(language,tag){if(!Prism.languages[language]){return undefined}return{pattern:RegExp("((?:"+tag+")\\s*)"+templateLiteralPattern),lookbehind:true,greedy:true,inside:{"template-punctuation":{pattern:/^`|`$/,alias:"string"},"embedded-code":{pattern:/[\s\S]+/,alias:language}}}}Prism.languages.javascript["template-string"]=[createTemplate("css",/\b(?:styled(?:\([^)]*\))?(?:\s*\.\s*\w+(?:\([^)]*\))*)*|css(?:\s*\.\s*(?:global|resolve))?|createGlobalStyle|keyframes)/.source),createTemplate("html",/\bhtml|\.\s*(?:inner|outer)HTML\s*\+?=/.source),createTemplate("svg",/\bsvg/.source),createTemplate("markdown",/\b(?:md|markdown)/.source),createTemplate("graphql",/\b(?:gql|graphql(?:\s*\.\s*experimental)?)/.source),templateString].filter(Boolean);function getPlaceholder(counter,language){return"___"+language.toUpperCase()+"_"+counter+"___"}function tokenizeWithHooks(code,grammar,language){var env={code:code,grammar:grammar,language:language};Prism.hooks.run("before-tokenize",env);env.tokens=Prism.tokenize(env.code,env.grammar);Prism.hooks.run("after-tokenize",env);return env.tokens}function tokenizeInterpolationExpression(expression){var tempGrammar={};tempGrammar["interpolation-punctuation"]=interpolationPunctuationObject;var tokens=Prism.tokenize(expression,tempGrammar);if(tokens.length===3){var args=[1,1];args.push.apply(args,tokenizeWithHooks(tokens[1],Prism.languages.javascript,"javascript"));tokens.splice.apply(tokens,args)}return new Prism.Token("interpolation",tokens,interpolationObject.alias,expression)}function tokenizeEmbedded(code,grammar,language){var _tokens=Prism.tokenize(code,{interpolation:{pattern:RegExp(interpolationPattern),lookbehind:true}});var placeholderCounter=0;var placeholderMap={};var embeddedCode=_tokens.map((function(token){if(typeof token==="string"){return token}else{var interpolationExpression=token.content;var placeholder;while(code.indexOf(placeholder=getPlaceholder(placeholderCounter++,language))!==-1){}placeholderMap[placeholder]=interpolationExpression;return placeholder}})).join("");var embeddedTokens=tokenizeWithHooks(embeddedCode,grammar,language);var placeholders=Object.keys(placeholderMap);placeholderCounter=0;function walkTokens(tokens){for(var i=0;i<tokens.length;i++){if(placeholderCounter>=placeholders.length){return}var token=tokens[i];if(typeof token==="string"||typeof token.content==="string"){var placeholder=placeholders[placeholderCounter];var s=typeof token==="string"?token:token.content;var index=s.indexOf(placeholder);if(index!==-1){++placeholderCounter;var before=s.substring(0,index);var middle=tokenizeInterpolationExpression(placeholderMap[placeholder]);var after=s.substring(index+placeholder.length);var replacement=[];if(before){replacement.push(before)}replacement.push(middle);if(after){var afterTokens=[after];walkTokens(afterTokens);replacement.push.apply(replacement,afterTokens)}if(typeof token==="string"){tokens.splice.apply(tokens,[i,1].concat(replacement));i+=replacement.length-1}else{token.content=replacement}}}else{var content=token.content;if(Array.isArray(content)){walkTokens(content)}else{walkTokens([content])}}}}walkTokens(embeddedTokens);return new Prism.Token(language,embeddedTokens,"language-"+language,code)}var supportedLanguages={javascript:true,js:true,typescript:true,ts:true,jsx:true,tsx:true};Prism.hooks.add("after-tokenize",(function(env){if(!(env.language in supportedLanguages)){return}function findTemplateStrings(tokens){for(var i=0,l=tokens.length;i<l;i++){var token=tokens[i];if(typeof token==="string"){continue}var content=token.content;if(!Array.isArray(content)){if(typeof content!=="string"){findTemplateStrings([content])}continue}if(token.type==="template-string"){var embedded=content[1];if(content.length===3&&typeof embedded!=="string"&&embedded.type==="embedded-code"){var code=stringContent(embedded);var alias=embedded.alias;var language=Array.isArray(alias)?alias[0]:alias;var grammar=Prism.languages[language];if(!grammar){continue}content[1]=tokenizeEmbedded(code,grammar,language)}}else{findTemplateStrings(content)}}}findTemplateStrings(env.tokens)}));function stringContent(value){if(typeof value==="string"){return value}else if(Array.isArray(value)){return value.map(stringContent).join("")}else{return stringContent(value.content)}}})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorJavadoclike=__webpack_require__(116);var refractorTypescript=__webpack_require__(134);module.exports=jsdoc;jsdoc.displayName="jsdoc";jsdoc.aliases=[];function jsdoc(Prism){Prism.register(refractorJavadoclike);Prism.register(refractorTypescript);(function(Prism){var javascript=Prism.languages.javascript;var type=/{(?:[^{}]|{(?:[^{}]|{[^{}]*})*})+}/.source;var parameterPrefix="(@(?:param|arg|argument|property)\\s+(?:"+type+"\\s+)?)";Prism.languages.jsdoc=Prism.languages.extend("javadoclike",{parameter:{pattern:RegExp(parameterPrefix+/[$\w\xA0-\uFFFF.]+(?=\s|$)/.source),lookbehind:true,inside:{punctuation:/\./}}});Prism.languages.insertBefore("jsdoc","keyword",{"optional-parameter":{pattern:RegExp(parameterPrefix+/\[[$\w\xA0-\uFFFF.]+(?:=[^[\]]+)?\](?=\s|$)/.source),lookbehind:true,inside:{parameter:{pattern:/(^\[)[$\w\xA0-\uFFFF\.]+/,lookbehind:true,inside:{punctuation:/\./}},code:{pattern:/(=)[\s\S]*(?=\]$)/,lookbehind:true,inside:javascript,alias:"language-javascript"},punctuation:/[=[\]]/}},"class-name":[{pattern:RegExp(/(@(?:augments|extends|class|interface|memberof!?|template|this|typedef)\s+(?:<TYPE>\s+)?)[A-Z]\w*(?:\.[A-Z]\w*)*/.source.replace(/<TYPE>/g,(function(){return type}))),lookbehind:true,inside:{punctuation:/\./}},{pattern:RegExp("(@[a-z]+\\s+)"+type),lookbehind:true,inside:{string:javascript.string,number:javascript.number,boolean:javascript.boolean,keyword:Prism.languages.typescript.keyword,operator:/=>|\.\.\.|[&|?:*]/,punctuation:/[.,;=<>{}()[\]]/}}],example:{pattern:/(@example\s+)[^@]+?(?=\s*(?:\*\s*)?(?:@\w|\*\/))/,lookbehind:true,inside:{code:{pattern:/^(\s*(?:\*\s*)?).+$/m,lookbehind:true,inside:javascript,alias:"language-javascript"}}}});Prism.languages.javadoclike.addSupport("javascript",Prism.languages.jsdoc)})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorJson=__webpack_require__(135);module.exports=json5;json5.displayName="json5";json5.aliases=[];function json5(Prism){Prism.register(refractorJson);(function(Prism){var string=/("|')(?:\\(?:\r\n?|\n|.)|(?!\1)[^\\\r\n])*\1/;Prism.languages.json5=Prism.languages.extend("json",{property:[{pattern:RegExp(string.source+"(?=\\s*:)"),greedy:true},{pattern:/[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*:)/,alias:"unquoted"}],string:{pattern:string,greedy:true},number:/[+-]?\b(?:NaN|Infinity|0x[a-fA-F\d]+)\b|[+-]?(?:\b\d+\.?\d*|\B\.\d+)(?:[eE][+-]?\d+\b)?/})})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorJson=__webpack_require__(135);module.exports=jsonp;jsonp.displayName="jsonp";jsonp.aliases=[];function jsonp(Prism){Prism.register(refractorJson);Prism.languages.jsonp=Prism.languages.extend("json",{punctuation:/[{}[\]();,.]/});Prism.languages.insertBefore("jsonp","punctuation",{function:/[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*(?=\s*\()/})}},function(module,exports,__webpack_require__){"use strict";module.exports=jsstacktrace;jsstacktrace.displayName="jsstacktrace";jsstacktrace.aliases=[];function jsstacktrace(Prism){Prism.languages.jsstacktrace={"error-message":{pattern:/^\S.*/m,alias:"string"},"stack-frame":{pattern:/^[ \t]+at[ \t]+.*/m,inside:{"not-my-code":{pattern:/[ \t]+at[ \t]+(?:node\.js|\<unknown\>|.*(?:node_modules|\(\<anonymous\>\)|\(\<unknown\>|\<anonymous\>$|\(internal\/|\(node\.js)).*/m,alias:"comment"},filename:{pattern:/(\bat\s+|\()(?:[a-zA-Z]:)?[^():]+(?=:)/,lookbehind:true,alias:"url"},function:{pattern:/(at\s+(?:new\s+)?)[_$a-zA-Z\xA0-\uFFFF<][.$\w\xA0-\uFFFF<>]*/,lookbehind:true,inside:{punctuation:/\./}},punctuation:/[()]/,keyword:/\b(?:at|new)\b/,alias:{pattern:/\[(?:as\s+)?[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*\]/,alias:"variable"},"line-number":{pattern:/:[0-9]+(?::[0-9]+)?\b/,alias:"number",inside:{punctuation:/:/}}}}}}},function(module,exports,__webpack_require__){"use strict";module.exports=julia;julia.displayName="julia";julia.aliases=[];function julia(Prism){Prism.languages.julia={comment:{pattern:/(^|[^\\])(?:#=(?:[^#=]|=(?!#)|#(?!=)|#=(?:[^#=]|=(?!#)|#(?!=))*=#)*=#|#.*)/,lookbehind:true},regex:{pattern:/r"(?:\\.|[^"\\\r\n])*"[imsx]{0,4}/,greedy:true},string:{pattern:/"""[\s\S]+?"""|\w*"(?:\\.|[^"\\\r\n])*"|(^|[^\w'])'(?:\\[^\r\n][^'\r\n]*|[^\\\r\n])'|`(?:[^\\`\r\n]|\\.)*`/,lookbehind:true,greedy:true},keyword:/\b(?:abstract|baremodule|begin|bitstype|break|catch|ccall|const|continue|do|else|elseif|end|export|finally|for|function|global|if|immutable|import|importall|in|let|local|macro|module|print|println|quote|return|struct|try|type|typealias|using|while)\b/,boolean:/\b(?:true|false)\b/,number:/(?:\b(?=\d)|\B(?=\.))(?:0[box])?(?:[\da-f]+(?:_[\da-f]+)*\.?(?:\d+(?:_\d+)*)?|\.\d+(?:_\d+)*)(?:[efp][+-]?\d+(?:_\d+)*)?j?/i,operator:/&&|\|\||[-+*^%÷⊻&$\\]=?|\/[\/=]?|!=?=?|\|[=>]?|<(?:<=?|[=:|])?|>(?:=|>>?=?)?|==?=?|[~≠≤≥'√∛]/,punctuation:/::?|[{}[\]();,.?]/,constant:/\b(?:(?:NaN|Inf)(?:16|32|64)?|im|pi|e|catalan|eulergamma|golden)\b|[πℯγφ]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=keyman;keyman.displayName="keyman";keyman.aliases=[];function keyman(Prism){Prism.languages.keyman={comment:/\bc\s.*/i,function:/\[\s*(?:(?:CTRL|SHIFT|ALT|LCTRL|RCTRL|LALT|RALT|CAPS|NCAPS)\s+)*(?:[TKU]_[\w?]+|".+?"|'.+?')\s*\]/i,string:/("|').*?\1/,bold:[/&(?:baselayout|bitmap|capsononly|capsalwaysoff|shiftfreescaps|copyright|ethnologuecode|hotkey|includecodes|keyboardversion|kmw_embedcss|kmw_embedjs|kmw_helpfile|kmw_helptext|kmw_rtl|language|layer|layoutfile|message|mnemoniclayout|name|oldcharposmatching|platform|targets|version|visualkeyboard|windowslanguages)\b/i,/\b(?:bitmap|bitmaps|caps on only|caps always off|shift frees caps|copyright|hotkey|language|layout|message|name|version)\b/i],keyword:/\b(?:any|baselayout|beep|call|context|deadkey|dk|if|index|layer|notany|nul|outs|platform|return|reset|save|set|store|use)\b/i,atrule:/\b(?:ansi|begin|unicode|group|using keys|match|nomatch)\b/i,number:/\b(?:U\+[\dA-F]+|d\d+|x[\da-f]+|\d+)\b/i,operator:/[+>\\,()]/,tag:/\$(?:keyman|kmfl|weaver|keymanweb|keymanonly):/i}}},function(module,exports,__webpack_require__){"use strict";module.exports=kotlin;kotlin.displayName="kotlin";kotlin.aliases=["kt","kts"];function kotlin(Prism){(function(Prism){Prism.languages.kotlin=Prism.languages.extend("clike",{keyword:{pattern:/(^|[^.])\b(?:abstract|actual|annotation|as|break|by|catch|class|companion|const|constructor|continue|crossinline|data|do|dynamic|else|enum|expect|external|final|finally|for|fun|get|if|import|in|infix|init|inline|inner|interface|internal|is|lateinit|noinline|null|object|open|operator|out|override|package|private|protected|public|reified|return|sealed|set|super|suspend|tailrec|this|throw|to|try|typealias|val|var|vararg|when|where|while)\b/,lookbehind:true},function:[/\w+(?=\s*\()/,{pattern:/(\.)\w+(?=\s*\{)/,lookbehind:true}],number:/\b(?:0[xX][\da-fA-F]+(?:_[\da-fA-F]+)*|0[bB][01]+(?:_[01]+)*|\d+(?:_\d+)*(?:\.\d+(?:_\d+)*)?(?:[eE][+-]?\d+(?:_\d+)*)?[fFL]?)\b/,operator:/\+[+=]?|-[-=>]?|==?=?|!(?:!|==?)?|[\/*%<>]=?|[?:]:?|\.\.|&&|\|\||\b(?:and|inv|or|shl|shr|ushr|xor)\b/});delete Prism.languages.kotlin["class-name"];Prism.languages.insertBefore("kotlin","string",{"raw-string":{pattern:/("""|''')[\s\S]*?\1/,alias:"string"}});Prism.languages.insertBefore("kotlin","keyword",{annotation:{pattern:/\B@(?:\w+:)?(?:[A-Z]\w*|\[[^\]]+\])/,alias:"builtin"}});Prism.languages.insertBefore("kotlin","function",{label:{pattern:/\w+@|@\w+/,alias:"symbol"}});var interpolation=[{pattern:/\$\{[^}]+\}/,inside:{delimiter:{pattern:/^\$\{|\}$/,alias:"variable"},rest:Prism.languages.kotlin}},{pattern:/\$\w+/,alias:"variable"}];Prism.languages.kotlin["string"].inside=Prism.languages.kotlin["raw-string"].inside={interpolation:interpolation};Prism.languages.kt=Prism.languages.kotlin;Prism.languages.kts=Prism.languages.kotlin})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=latex;latex.displayName="latex";latex.aliases=["tex","context"];function latex(Prism){(function(Prism){var funcPattern=/\\(?:[^a-z()[\]]|[a-z*]+)/i;var insideEqu={"equation-command":{pattern:funcPattern,alias:"regex"}};Prism.languages.latex={comment:/%.*/m,cdata:{pattern:/(\\begin\{((?:verbatim|lstlisting)\*?)\})[\s\S]*?(?=\\end\{\2\})/,lookbehind:true},equation:[{pattern:/\$\$(?:\\[\s\S]|[^\\$])+\$\$|\$(?:\\[\s\S]|[^\\$])+\$|\\\([\s\S]*?\\\)|\\\[[\s\S]*?\\\]/,inside:insideEqu,alias:"string"},{pattern:/(\\begin\{((?:equation|math|eqnarray|align|multline|gather)\*?)\})[\s\S]*?(?=\\end\{\2\})/,lookbehind:true,inside:insideEqu,alias:"string"}],keyword:{pattern:/(\\(?:begin|end|ref|cite|label|usepackage|documentclass)(?:\[[^\]]+\])?\{)[^}]+(?=\})/,lookbehind:true},url:{pattern:/(\\url\{)[^}]+(?=\})/,lookbehind:true},headline:{pattern:/(\\(?:part|chapter|section|subsection|frametitle|subsubsection|paragraph|subparagraph|subsubparagraph|subsubsubparagraph)\*?(?:\[[^\]]+\])?\{)[^}]+(?=\}(?:\[[^\]]+\])?)/,lookbehind:true,alias:"class-name"},function:{pattern:funcPattern,alias:"selector"},punctuation:/[[\]{}&]/};Prism.languages.tex=Prism.languages.latex;Prism.languages.context=Prism.languages.latex})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);var refractorPhp=__webpack_require__(117);module.exports=latte;latte.displayName="latte";latte.aliases=[];function latte(Prism){Prism.register(refractorMarkupTemplating);Prism.register(refractorPhp);(function(Prism){Prism.languages.latte={comment:/^\{\*[\s\S]*/,ld:{pattern:/^\{(?:[=_]|\/?(?!\d|\w+\()\w+|)/,inside:{punctuation:/^\{\/?/,tag:{pattern:/.+/,alias:"important"}}},rd:{pattern:/\}$/,inside:{punctuation:/.+/}},php:{pattern:/\S(?:[\s\S]*\S)?/,alias:"language-php",inside:Prism.languages.php}};var markupLatte=Prism.languages.extend("markup",{});Prism.languages.insertBefore("inside","attr-value",{"n-attr":{pattern:/n:[\w-]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+))?/,inside:{"attr-name":{pattern:/^[^\s=]+/,alias:"important"},"attr-value":{pattern:/=[\s\S]+/,inside:{punctuation:[/^=/,{pattern:/^(\s*)["']|["']$/,lookbehind:true}],php:{pattern:/\S(?:[\s\S]*\S)?/,inside:Prism.languages.php}}}}}},markupLatte.tag);Prism.hooks.add("before-tokenize",(function(env){if(env.language!=="latte"){return}var lattePattern=/\{\*[\s\S]*?\*\}|\{[^'"\s{}*](?:[^"'/{}]|\/(?![*/])|("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|\/\*[\s\S]*?\*\/)*?\}/g;Prism.languages["markup-templating"].buildPlaceholders(env,"latte",lattePattern);env.grammar=markupLatte}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"latte")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=less;less.displayName="less";less.aliases=[];function less(Prism){Prism.languages.less=Prism.languages.extend("css",{comment:[/\/\*[\s\S]*?\*\//,{pattern:/(^|[^\\])\/\/.*/,lookbehind:true}],atrule:{pattern:/@[\w-]+?(?:\((?:[^(){}]|\([^(){}]*\))*\)|[^(){};])*?(?=\s*\{)/,inside:{punctuation:/[:()]/}},selector:{pattern:/(?:@\{[\w-]+\}|[^{};\s@])(?:@\{[\w-]+\}|\((?:[^(){}]|\([^(){}]*\))*\)|[^(){};@])*?(?=\s*\{)/,inside:{variable:/@+[\w-]+/}},property:/(?:@\{[\w-]+\}|[\w-])+(?:\+_?)?(?=\s*:)/i,operator:/[+\-*\/]/});Prism.languages.insertBefore("less","property",{variable:[{pattern:/@[\w-]+\s*:/,inside:{punctuation:/:/}},/@@?[\w-]+/],"mixin-usage":{pattern:/([{;]\s*)[.#](?!\d)[\w-]+.*?(?=[(;])/,lookbehind:true,alias:"function"}})}},function(module,exports,__webpack_require__){"use strict";var refractorScheme=__webpack_require__(136);module.exports=lilypond;lilypond.displayName="lilypond";lilypond.aliases=[];function lilypond(Prism){Prism.register(refractorScheme);(function(Prism){var schemeExpression=/\((?:[^();"#\\]|\\[\s\S]|;.*(?!.)|"(?:[^"\\]|\\.)*"|#(?:\{(?:(?!#\})[\s\S])*#\}|[^{])|<expr>)*\)/.source;var recursivenessLog2=5;for(var i=0;i<recursivenessLog2;i++){schemeExpression=schemeExpression.replace(/<expr>/g,(function(){return schemeExpression}))}schemeExpression=schemeExpression.replace(/<expr>/g,/[^\s\S]/.source);var lilypond=Prism.languages.lilypond={comment:/%(?:(?!\{).*|\{[\s\S]*?%\})/,"embedded-scheme":{pattern:RegExp(/(^|[=\s])#(?:"(?:[^"\\]|\\.)*"|[^\s()"]*(?:[^\s()]|<expr>))/.source.replace(/<expr>/g,(function(){return schemeExpression})),"m"),lookbehind:true,greedy:true,inside:{scheme:{pattern:/^(#)[\s\S]+$/,lookbehind:true,alias:"language-scheme",inside:{"embedded-lilypond":{pattern:/#\{[\s\S]*?#\}/,greedy:true,inside:{punctuation:/^#\{|#\}$/,lilypond:{pattern:/[\s\S]+/,alias:"language-lilypond",inside:null}}},rest:Prism.languages.scheme}},punctuation:/#/}},string:{pattern:/"(?:[^"\\]|\\.)*"/,greedy:true},"class-name":{pattern:/(\\new\s+)[\w-]+/,lookbehind:true},keyword:{pattern:/\\[a-z][-\w]*/i,inside:{punctuation:/^\\/}},operator:/[=|]|<<|>>/,punctuation:{pattern:/(^|[a-z\d])(?:'+|,+|[_^]?-[_^]?(?:[-+^!>._]|(?=\d))|[_^]\.?|[.!])|[{}()[\]<>^~]|\\[()[\]<>\\!]|--|__/,lookbehind:true},number:/\b\d+(?:\/\d+)?\b/};lilypond["embedded-scheme"].inside["scheme"].inside["embedded-lilypond"].inside["lilypond"].inside=lilypond;Prism.languages.ly=lilypond})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=liquid;liquid.displayName="liquid";liquid.aliases=[];function liquid(Prism){Prism.languages.liquid={keyword:/\b(?:comment|endcomment|if|elsif|else|endif|unless|endunless|for|endfor|case|endcase|when|in|break|assign|continue|limit|offset|range|reversed|raw|endraw|capture|endcapture|tablerow|endtablerow)\b/,number:/\b0b[01]+\b|\b0x[\da-f]*\.?[\da-fp-]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?[df]?/i,operator:{pattern:/(^|[^.])(?:\+[+=]?|-[-=]?|!=?|<<?=?|>>?>?=?|==?|&[&=]?|\|[|=]?|\*=?|\/=?|%=?|\^=?|[?:~])/m,lookbehind:true},function:{pattern:/(^|[\s;|&])(?:append|prepend|capitalize|cycle|cols|increment|decrement|abs|at_least|at_most|ceil|compact|concat|date|default|divided_by|downcase|escape|escape_once|first|floor|join|last|lstrip|map|minus|modulo|newline_to_br|plus|remove|remove_first|replace|replace_first|reverse|round|rstrip|size|slice|sort|sort_natural|split|strip|strip_html|strip_newlines|times|truncate|truncatewords|uniq|upcase|url_decode|url_encode|include|paginate)(?=$|[\s;|&])/,lookbehind:true}}}},function(module,exports,__webpack_require__){"use strict";module.exports=lisp;lisp.displayName="lisp";lisp.aliases=[];function lisp(Prism){(function(Prism){function simple_form(name){return RegExp("(\\()"+name+"(?=[\\s\\)])")}function primitive(pattern){return RegExp("([\\s([])"+pattern+"(?=[\\s)])")}var symbol="[-+*/_~!@$%^=<>{}\\w]+";var marker="&"+symbol;var par="(\\()";var endpar="(?=\\))";var space="(?=\\s)";var language={heading:{pattern:/;;;.*/,alias:["comment","title"]},comment:/;.*/,string:{pattern:/"(?:[^"\\]|\\.)*"/,greedy:true,inside:{argument:/[-A-Z]+(?=[.,\s])/,symbol:RegExp("`"+symbol+"'")}},"quoted-symbol":{pattern:RegExp("#?'"+symbol),alias:["variable","symbol"]},"lisp-property":{pattern:RegExp(":"+symbol),alias:"property"},splice:{pattern:RegExp(",@?"+symbol),alias:["symbol","variable"]},keyword:[{pattern:RegExp(par+"(?:(?:lexical-)?let\\*?|(?:cl-)?letf|if|when|while|unless|cons|cl-loop|and|or|not|cond|setq|error|message|null|require|provide|use-package)"+space),lookbehind:true},{pattern:RegExp(par+"(?:for|do|collect|return|finally|append|concat|in|by)"+space),lookbehind:true}],declare:{pattern:simple_form("declare"),lookbehind:true,alias:"keyword"},interactive:{pattern:simple_form("interactive"),lookbehind:true,alias:"keyword"},boolean:{pattern:primitive("(?:t|nil)"),lookbehind:true},number:{pattern:primitive("[-+]?\\d+(?:\\.\\d*)?"),lookbehind:true},defvar:{pattern:RegExp(par+"def(?:var|const|custom|group)\\s+"+symbol),lookbehind:true,inside:{keyword:/^def[a-z]+/,variable:RegExp(symbol)}},defun:{pattern:RegExp(par+"(?:cl-)?(?:defun\\*?|defmacro)\\s+"+symbol+"\\s+\\([\\s\\S]*?\\)"),lookbehind:true,inside:{keyword:/^(?:cl-)?def\S+/,arguments:null,function:{pattern:RegExp("(^\\s)"+symbol),lookbehind:true},punctuation:/[()]/}},lambda:{pattern:RegExp(par+"lambda\\s+\\((?:&?"+symbol+"\\s*)*\\)"),lookbehind:true,inside:{keyword:/^lambda/,arguments:null,punctuation:/[()]/}},car:{pattern:RegExp(par+symbol),lookbehind:true},punctuation:[/(?:['`,]?\(|[)\[\]])/,{pattern:/(\s)\.(?=\s)/,lookbehind:true}]};var arg={"lisp-marker":RegExp(marker),rest:{argument:{pattern:RegExp(symbol),alias:"variable"},varform:{pattern:RegExp(par+symbol+"\\s+\\S[\\s\\S]*"+endpar),lookbehind:true,inside:{string:language.string,boolean:language.boolean,number:language.number,symbol:language.symbol,punctuation:/[()]/}}}};var forms="\\S+(?:\\s+\\S+)*";var arglist={pattern:RegExp(par+"[\\s\\S]*"+endpar),lookbehind:true,inside:{"rest-vars":{pattern:RegExp("&(?:rest|body)\\s+"+forms),inside:arg},"other-marker-vars":{pattern:RegExp("&(?:optional|aux)\\s+"+forms),inside:arg},keys:{pattern:RegExp("&key\\s+"+forms+"(?:\\s+&allow-other-keys)?"),inside:arg},argument:{pattern:RegExp(symbol),alias:"variable"},punctuation:/[()]/}};language["lambda"].inside.arguments=arglist;language["defun"].inside.arguments=Prism.util.clone(arglist);language["defun"].inside.arguments.inside.sublist=arglist;Prism.languages.lisp=language;Prism.languages.elisp=language;Prism.languages.emacs=language;Prism.languages["emacs-lisp"]=language})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=livescript;livescript.displayName="livescript";livescript.aliases=[];function livescript(Prism){Prism.languages.livescript={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?\*\//,lookbehind:true},{pattern:/(^|[^\\])#.*/,lookbehind:true}],"interpolated-string":{pattern:/(^|[^"])("""|")(?:\\[\s\S]|(?!\2)[^\\])*\2(?!")/,lookbehind:true,greedy:true,inside:{variable:{pattern:/(^|[^\\])#[a-z_](?:-?[a-z]|[\d_])*/m,lookbehind:true},interpolation:{pattern:/(^|[^\\])#\{[^}]+\}/m,lookbehind:true,inside:{"interpolation-punctuation":{pattern:/^#\{|\}$/,alias:"variable"}}},string:/[\s\S]+/}},string:[{pattern:/('''|')(?:\\[\s\S]|(?!\1)[^\\])*\1/,greedy:true},{pattern:/<\[[\s\S]*?\]>/,greedy:true},/\\[^\s,;\])}]+/],regex:[{pattern:/\/\/(?:\[[^\r\n\]]*\]|\\.|(?!\/\/)[^\\\[])+\/\/[gimyu]{0,5}/,greedy:true,inside:{comment:{pattern:/(^|[^\\])#.*/,lookbehind:true}}},{pattern:/\/(?:\[[^\r\n\]]*\]|\\.|[^/\\\r\n\[])+\/[gimyu]{0,5}/,greedy:true}],keyword:{pattern:/(^|(?!-).)\b(?:break|case|catch|class|const|continue|default|do|else|extends|fallthrough|finally|for(?: ever)?|function|if|implements|it|let|loop|new|null|otherwise|own|return|super|switch|that|then|this|throw|try|unless|until|var|void|when|while|yield)(?!-)\b/m,lookbehind:true},"keyword-operator":{pattern:/(^|[^-])\b(?:(?:delete|require|typeof)!|(?:and|by|delete|export|from|import(?: all)?|in|instanceof|is(?:nt| not)?|not|of|or|til|to|typeof|with|xor)(?!-)\b)/m,lookbehind:true,alias:"operator"},boolean:{pattern:/(^|[^-])\b(?:false|no|off|on|true|yes)(?!-)\b/m,lookbehind:true},argument:{pattern:/(^|(?!\.&\.)[^&])&(?!&)\d*/m,lookbehind:true,alias:"variable"},number:/\b(?:\d+~[\da-z]+|\d[\d_]*(?:\.\d[\d_]*)?(?:[a-z]\w*)?)/i,identifier:/[a-z_](?:-?[a-z]|[\d_])*/i,operator:[{pattern:/( )\.(?= )/,lookbehind:true},/\.(?:[=~]|\.\.?)|\.(?:[&|^]|<<|>>>?)\.|:(?:=|:=?)|&&|\|[|>]|<(?:<<?<?|--?!?|~~?!?|[|=?])?|>[>=?]?|-(?:->?|>)?|\+\+?|@@?|%%?|\*\*?|!(?:~?=|--?>|~?~>)?|~(?:~?>|=)?|==?|\^\^?|[\/?]/],punctuation:/[(){}\[\]|.,:;`]/};Prism.languages.livescript["interpolated-string"].inside["interpolation"].inside.rest=Prism.languages.livescript}},function(module,exports,__webpack_require__){"use strict";module.exports=llvm;llvm.displayName="llvm";llvm.aliases=[];function llvm(Prism){(function(Prism){Prism.languages.llvm={comment:/;.*/,string:{pattern:/"[^"]*"/,greedy:true},boolean:/\b(?:true|false)\b/,variable:/[%@!#](?:(?!\d)(?:[-$.\w]|\\[a-f\d]{2})+|\d+)/i,label:/(?!\d)(?:[-$.\w]|\\[a-f\d]{2})+:/i,type:{pattern:/\b(?:double|float|fp128|half|i[1-9]\d*|label|metadata|ppc_fp128|token|void|x86_fp80|x86_mmx)\b/,alias:"class-name"},keyword:/\b[a-z_][a-z_0-9]*\b/,number:/[+-]?\b\d+(?:\.\d+)?(?:[eE][+-]?\d+)?\b|\b0x[\dA-Fa-f]+\b|\b0xK[\dA-Fa-f]{20}\b|\b0x[ML][\dA-Fa-f]{32}\b|\b0xH[\dA-Fa-f]{4}\b/,punctuation:/[{}[\];(),.!*=<>]/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=lolcode;lolcode.displayName="lolcode";lolcode.aliases=[];function lolcode(Prism){Prism.languages.lolcode={comment:[/\bOBTW\s+[\s\S]*?\s+TLDR\b/,/\bBTW.+/],string:{pattern:/"(?::.|[^":])*"/,inside:{variable:/:\{[^}]+\}/,symbol:[/:\([a-f\d]+\)/i,/:\[[^\]]+\]/,/:[)>o":]/]},greedy:true},number:/(?:\B-)?(?:\b\d+\.?\d*|\B\.\d+)/,symbol:{pattern:/(^|\s)(?:A )?(?:YARN|NUMBR|NUMBAR|TROOF|BUKKIT|NOOB)(?=\s|,|$)/,lookbehind:true,inside:{keyword:/A(?=\s)/}},label:{pattern:/((?:^|\s)(?:IM IN YR|IM OUTTA YR) )[a-zA-Z]\w*/,lookbehind:true,alias:"string"},function:{pattern:/((?:^|\s)(?:I IZ|HOW IZ I|IZ) )[a-zA-Z]\w*/,lookbehind:true},keyword:[{pattern:/(^|\s)(?:O HAI IM|KTHX|HAI|KTHXBYE|I HAS A|ITZ(?: A)?|R|AN|MKAY|SMOOSH|MAEK|IS NOW(?: A)?|VISIBLE|GIMMEH|O RLY\?|YA RLY|NO WAI|OIC|MEBBE|WTF\?|OMG|OMGWTF|GTFO|IM IN YR|IM OUTTA YR|FOUND YR|YR|TIL|WILE|UPPIN|NERFIN|I IZ|HOW IZ I|IF U SAY SO|SRS|HAS A|LIEK(?: A)?|IZ)(?=\s|,|$)/,lookbehind:true},/'Z(?=\s|,|$)/],boolean:{pattern:/(^|\s)(?:WIN|FAIL)(?=\s|,|$)/,lookbehind:true},variable:{pattern:/(^|\s)IT(?=\s|,|$)/,lookbehind:true},operator:{pattern:/(^|\s)(?:NOT|BOTH SAEM|DIFFRINT|(?:SUM|DIFF|PRODUKT|QUOSHUNT|MOD|BIGGR|SMALLR|BOTH|EITHER|WON|ALL|ANY) OF)(?=\s|,|$)/,lookbehind:true},punctuation:/\.{3}|…|,|!/}}},function(module,exports,__webpack_require__){"use strict";module.exports=makefile;makefile.displayName="makefile";makefile.aliases=[];function makefile(Prism){Prism.languages.makefile={comment:{pattern:/(^|[^\\])#(?:\\(?:\r\n|[\s\S])|[^\\\r\n])*/,lookbehind:true},string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},builtin:/\.[A-Z][^:#=\s]+(?=\s*:(?!=))/,symbol:{pattern:/^[^:=\r\n]+(?=\s*:(?!=))/m,inside:{variable:/\$+(?:[^(){}:#=\s]+|(?=[({]))/}},variable:/\$+(?:[^(){}:#=\s]+|\([@*%<^+?][DF]\)|(?=[({]))/,keyword:[/-include\b|\b(?:define|else|endef|endif|export|ifn?def|ifn?eq|include|override|private|sinclude|undefine|unexport|vpath)\b/,{pattern:/(\()(?:addsuffix|abspath|and|basename|call|dir|error|eval|file|filter(?:-out)?|findstring|firstword|flavor|foreach|guile|if|info|join|lastword|load|notdir|or|origin|patsubst|realpath|shell|sort|strip|subst|suffix|value|warning|wildcard|word(?:s|list)?)(?=[ \t])/,lookbehind:true}],operator:/(?:::|[?:+!])?=|[|@]/,punctuation:/[:;(){}]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=markdown;markdown.displayName="markdown";markdown.aliases=["md"];function markdown(Prism){(function(Prism){var inner=/(?:\\.|[^\\\n\r]|(?:\n|\r\n?)(?!\n|\r\n?))/.source;function createInline(pattern){pattern=pattern.replace(/<inner>/g,(function(){return inner}));return RegExp(/((?:^|[^\\])(?:\\{2})*)/.source+"(?:"+pattern+")")}var tableCell=/(?:\\.|``(?:[^`\r\n]|`(?!`))+``|`[^`\r\n]+`|[^\\|\r\n`])+/.source;var tableRow=/\|?__(?:\|__)+\|?(?:(?:\n|\r\n?)|$)/.source.replace(/__/g,(function(){return tableCell}));var tableLine=/\|?[ \t]*:?-{3,}:?[ \t]*(?:\|[ \t]*:?-{3,}:?[ \t]*)+\|?(?:\n|\r\n?)/.source;Prism.languages.markdown=Prism.languages.extend("markup",{});Prism.languages.insertBefore("markdown","prolog",{blockquote:{pattern:/^>(?:[\t ]*>)*/m,alias:"punctuation"},table:{pattern:RegExp("^"+tableRow+tableLine+"(?:"+tableRow+")*","m"),inside:{"table-data-rows":{pattern:RegExp("^("+tableRow+tableLine+")(?:"+tableRow+")*$"),lookbehind:true,inside:{"table-data":{pattern:RegExp(tableCell),inside:Prism.languages.markdown},punctuation:/\|/}},"table-line":{pattern:RegExp("^("+tableRow+")"+tableLine+"$"),lookbehind:true,inside:{punctuation:/\||:?-{3,}:?/}},"table-header-row":{pattern:RegExp("^"+tableRow+"$"),inside:{"table-header":{pattern:RegExp(tableCell),alias:"important",inside:Prism.languages.markdown},punctuation:/\|/}}}},code:[{pattern:/((?:^|\n)[ \t]*\n|(?:^|\r\n?)[ \t]*\r\n?)(?: {4}|\t).+(?:(?:\n|\r\n?)(?: {4}|\t).+)*/,lookbehind:true,alias:"keyword"},{pattern:/``.+?``|`[^`\r\n]+`/,alias:"keyword"},{pattern:/^```[\s\S]*?^```$/m,greedy:true,inside:{"code-block":{pattern:/^(```.*(?:\n|\r\n?))[\s\S]+?(?=(?:\n|\r\n?)^```$)/m,lookbehind:true},"code-language":{pattern:/^(```).+/,lookbehind:true},punctuation:/```/}}],title:[{pattern:/\S.*(?:\n|\r\n?)(?:==+|--+)(?=[ \t]*$)/m,alias:"important",inside:{punctuation:/==+$|--+$/}},{pattern:/(^\s*)#+.+/m,lookbehind:true,alias:"important",inside:{punctuation:/^#+|#+$/}}],hr:{pattern:/(^\s*)([*-])(?:[\t ]*\2){2,}(?=\s*$)/m,lookbehind:true,alias:"punctuation"},list:{pattern:/(^\s*)(?:[*+-]|\d+\.)(?=[\t ].)/m,lookbehind:true,alias:"punctuation"},"url-reference":{pattern:/!?\[[^\]]+\]:[\t ]+(?:\S+|<(?:\\.|[^>\\])+>)(?:[\t ]+(?:"(?:\\.|[^"\\])*"|'(?:\\.|[^'\\])*'|\((?:\\.|[^)\\])*\)))?/,inside:{variable:{pattern:/^(!?\[)[^\]]+/,lookbehind:true},string:/(?:"(?:\\.|[^"\\])*"|'(?:\\.|[^'\\])*'|\((?:\\.|[^)\\])*\))$/,punctuation:/^[\[\]!:]|[<>]/},alias:"url"},bold:{pattern:createInline(/\b__(?:(?!_)<inner>|_(?:(?!_)<inner>)+_)+__\b|\*\*(?:(?!\*)<inner>|\*(?:(?!\*)<inner>)+\*)+\*\*/.source),lookbehind:true,greedy:true,inside:{content:{pattern:/(^..)[\s\S]+(?=..$)/,lookbehind:true,inside:{}},punctuation:/\*\*|__/}},italic:{pattern:createInline(/\b_(?:(?!_)<inner>|__(?:(?!_)<inner>)+__)+_\b|\*(?:(?!\*)<inner>|\*\*(?:(?!\*)<inner>)+\*\*)+\*/.source),lookbehind:true,greedy:true,inside:{content:{pattern:/(^.)[\s\S]+(?=.$)/,lookbehind:true,inside:{}},punctuation:/[*_]/}},strike:{pattern:createInline(/(~~?)(?:(?!~)<inner>)+?\2/.source),lookbehind:true,greedy:true,inside:{content:{pattern:/(^~~?)[\s\S]+(?=\1$)/,lookbehind:true,inside:{}},punctuation:/~~?/}},url:{pattern:createInline(/!?\[(?:(?!\])<inner>)+\](?:\([^\s)]+(?:[\t ]+"(?:\\.|[^"\\])*")?\)| ?\[(?:(?!\])<inner>)+\])/.source),lookbehind:true,greedy:true,inside:{variable:{pattern:/(\[)[^\]]+(?=\]$)/,lookbehind:true},content:{pattern:/(^!?\[)[^\]]+(?=\])/,lookbehind:true,inside:{}},string:{pattern:/"(?:\\.|[^"\\])*"(?=\)$)/}}}});["url","bold","italic","strike"].forEach((function(token){["url","bold","italic","strike"].forEach((function(inside){if(token!==inside){Prism.languages.markdown[token].inside.content.inside[inside]=Prism.languages.markdown[inside]}}))}));Prism.hooks.add("after-tokenize",(function(env){if(env.language!=="markdown"&&env.language!=="md"){return}function walkTokens(tokens){if(!tokens||typeof tokens==="string"){return}for(var i=0,l=tokens.length;i<l;i++){var token=tokens[i];if(token.type!=="code"){walkTokens(token.content);continue}var codeLang=token.content[1];var codeBlock=token.content[3];if(codeLang&&codeBlock&&codeLang.type==="code-language"&&codeBlock.type==="code-block"&&typeof codeLang.content==="string"){var lang=codeLang.content.replace(/\b#/g,"sharp").replace(/\b\+\+/g,"pp");lang=(/[a-z][\w-]*/i.exec(lang)||[""])[0].toLowerCase();var alias="language-"+lang;if(!codeBlock.alias){codeBlock.alias=[alias]}else if(typeof codeBlock.alias==="string"){codeBlock.alias=[codeBlock.alias,alias]}else{codeBlock.alias.push(alias)}}}}walkTokens(env.tokens)}));Prism.hooks.add("wrap",(function(env){if(env.type!=="code-block"){return}var codeLang="";for(var i=0,l=env.classes.length;i<l;i++){var cls=env.classes[i];var match=/language-(.+)/.exec(cls);if(match){codeLang=match[1];break}}var grammar=Prism.languages[codeLang];if(!grammar){if(codeLang&&codeLang!=="none"&&Prism.plugins.autoloader){var id="md-"+(new Date).valueOf()+"-"+Math.floor(Math.random()*1e16);env.attributes["id"]=id;Prism.plugins.autoloader.loadLanguages(codeLang,(function(){var ele=document.getElementById(id);if(ele){ele.innerHTML=Prism.highlight(ele.textContent,Prism.languages[codeLang],codeLang)}}))}}else{var code=env.content.value.replace(/&lt;/g,"<").replace(/&amp;/g,"&");env.content=Prism.highlight(code,grammar,codeLang)}}));Prism.languages.md=Prism.languages.markdown})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=markup;markup.displayName="markup";markup.aliases=["html","mathml","svg","xml","ssml","atom","rss"];function markup(Prism){Prism.languages.markup={comment:/<!--[\s\S]*?-->/,prolog:/<\?[\s\S]+?\?>/,doctype:{pattern:/<!DOCTYPE(?:[^>"'[\]]|"[^"]*"|'[^']*')+(?:\[(?:[^<"'\]]|"[^"]*"|'[^']*'|<(?!!--)|<!--(?:[^-]|-(?!->))*-->)*\]\s*)?>/i,greedy:true,inside:{"internal-subset":{pattern:/(\[)[\s\S]+(?=\]>$)/,lookbehind:true,greedy:true,inside:null},string:{pattern:/"[^"]*"|'[^']*'/,greedy:true},punctuation:/^<!|>$|[[\]]/,"doctype-tag":/^DOCTYPE/,name:/[^\s<>'"]+/}},cdata:/<!\[CDATA\[[\s\S]*?]]>/i,tag:{pattern:/<\/?(?!\d)[^\s>\/=$<%]+(?:\s(?:\s*[^\s>\/=]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+(?=[\s>]))|(?=[\s/>])))+)?\s*\/?>/,greedy:true,inside:{tag:{pattern:/^<\/?[^\s>\/]+/,inside:{punctuation:/^<\/?/,namespace:/^[^\s>\/:]+:/}},"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+)/,inside:{punctuation:[{pattern:/^=/,alias:"attr-equals"},/"|'/]}},punctuation:/\/?>/,"attr-name":{pattern:/[^\s>\/]+/,inside:{namespace:/^[^\s>\/:]+:/}}}},entity:[{pattern:/&[\da-z]{1,8};/i,alias:"named-entity"},/&#x?[\da-f]{1,8};/i]};Prism.languages.markup["tag"].inside["attr-value"].inside["entity"]=Prism.languages.markup["entity"];Prism.languages.markup["doctype"].inside["internal-subset"].inside=Prism.languages.markup;Prism.hooks.add("wrap",(function(env){if(env.type==="entity"){env.attributes["title"]=env.content.value.replace(/&amp;/,"&")}}));Object.defineProperty(Prism.languages.markup.tag,"addInlined",{value:function addInlined(tagName,lang){var includedCdataInside={};includedCdataInside["language-"+lang]={pattern:/(^<!\[CDATA\[)[\s\S]+?(?=\]\]>$)/i,lookbehind:true,inside:Prism.languages[lang]};includedCdataInside["cdata"]=/^<!\[CDATA\[|\]\]>$/i;var inside={"included-cdata":{pattern:/<!\[CDATA\[[\s\S]*?\]\]>/i,inside:includedCdataInside}};inside["language-"+lang]={pattern:/[\s\S]+/,inside:Prism.languages[lang]};var def={};def[tagName]={pattern:RegExp(/(<__[\s\S]*?>)(?:<!\[CDATA\[(?:[^\]]|\](?!\]>))*\]\]>|(?!<!\[CDATA\[)[\s\S])*?(?=<\/__>)/.source.replace(/__/g,(function(){return tagName})),"i"),lookbehind:true,greedy:true,inside:inside};Prism.languages.insertBefore("markup","cdata",def)}});Prism.languages.html=Prism.languages.markup;Prism.languages.mathml=Prism.languages.markup;Prism.languages.svg=Prism.languages.markup;Prism.languages.xml=Prism.languages.extend("markup",{});Prism.languages.ssml=Prism.languages.xml;Prism.languages.atom=Prism.languages.xml;Prism.languages.rss=Prism.languages.xml}},function(module,exports,__webpack_require__){"use strict";module.exports=matlab;matlab.displayName="matlab";matlab.aliases=[];function matlab(Prism){Prism.languages.matlab={comment:[/%\{[\s\S]*?\}%/,/%.+/],string:{pattern:/\B'(?:''|[^'\r\n])*'/,greedy:true},number:/(?:\b\d+\.?\d*|\B\.\d+)(?:[eE][+-]?\d+)?(?:[ij])?|\b[ij]\b/,keyword:/\b(?:break|case|catch|continue|else|elseif|end|for|function|if|inf|NaN|otherwise|parfor|pause|pi|return|switch|try|while)\b/,function:/(?!\d)\w+(?=\s*\()/,operator:/\.?[*^\/\\']|[+\-:@]|[<>=~]=?|&&?|\|\|?/,punctuation:/\.{3}|[.,;\[\](){}!]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=mel;mel.displayName="mel";mel.aliases=[];function mel(Prism){Prism.languages.mel={comment:/\/\/.*/,code:{pattern:/`(?:\\.|[^\\`\r\n])*`/,greedy:true,alias:"italic",inside:{delimiter:{pattern:/^`|`$/,alias:"punctuation"}}},string:{pattern:/"(?:\\.|[^\\"\r\n])*"/,greedy:true},variable:/\$\w+/,number:/\b0x[\da-fA-F]+\b|\b\d+\.?\d*|\B\.\d+/,flag:{pattern:/-[^\d\W]\w*/,alias:"operator"},keyword:/\b(?:break|case|continue|default|do|else|float|for|global|if|in|int|matrix|proc|return|string|switch|vector|while)\b/,function:/\w+(?=\()|\b(?:about|abs|addAttr|addAttributeEditorNodeHelp|addDynamic|addNewShelfTab|addPP|addPanelCategory|addPrefixToName|advanceToNextDrivenKey|affectedNet|affects|aimConstraint|air|alias|aliasAttr|align|alignCtx|alignCurve|alignSurface|allViewFit|ambientLight|angle|angleBetween|animCone|animCurveEditor|animDisplay|animView|annotate|appendStringArray|applicationName|applyAttrPreset|applyTake|arcLenDimContext|arcLengthDimension|arclen|arrayMapper|art3dPaintCtx|artAttrCtx|artAttrPaintVertexCtx|artAttrSkinPaintCtx|artAttrTool|artBuildPaintMenu|artFluidAttrCtx|artPuttyCtx|artSelectCtx|artSetPaintCtx|artUserPaintCtx|assignCommand|assignInputDevice|assignViewportFactories|attachCurve|attachDeviceAttr|attachSurface|attrColorSliderGrp|attrCompatibility|attrControlGrp|attrEnumOptionMenu|attrEnumOptionMenuGrp|attrFieldGrp|attrFieldSliderGrp|attrNavigationControlGrp|attrPresetEditWin|attributeExists|attributeInfo|attributeMenu|attributeQuery|autoKeyframe|autoPlace|bakeClip|bakeFluidShading|bakePartialHistory|bakeResults|bakeSimulation|basename|basenameEx|batchRender|bessel|bevel|bevelPlus|binMembership|bindSkin|blend2|blendShape|blendShapeEditor|blendShapePanel|blendTwoAttr|blindDataType|boneLattice|boundary|boxDollyCtx|boxZoomCtx|bufferCurve|buildBookmarkMenu|buildKeyframeMenu|button|buttonManip|CBG|cacheFile|cacheFileCombine|cacheFileMerge|cacheFileTrack|camera|cameraView|canCreateManip|canvas|capitalizeString|catch|catchQuiet|ceil|changeSubdivComponentDisplayLevel|changeSubdivRegion|channelBox|character|characterMap|characterOutlineEditor|characterize|chdir|checkBox|checkBoxGrp|checkDefaultRenderGlobals|choice|circle|circularFillet|clamp|clear|clearCache|clip|clipEditor|clipEditorCurrentTimeCtx|clipSchedule|clipSchedulerOutliner|clipTrimBefore|closeCurve|closeSurface|cluster|cmdFileOutput|cmdScrollFieldExecuter|cmdScrollFieldReporter|cmdShell|coarsenSubdivSelectionList|collision|color|colorAtPoint|colorEditor|colorIndex|colorIndexSliderGrp|colorSliderButtonGrp|colorSliderGrp|columnLayout|commandEcho|commandLine|commandPort|compactHairSystem|componentEditor|compositingInterop|computePolysetVolume|condition|cone|confirmDialog|connectAttr|connectControl|connectDynamic|connectJoint|connectionInfo|constrain|constrainValue|constructionHistory|container|containsMultibyte|contextInfo|control|convertFromOldLayers|convertIffToPsd|convertLightmap|convertSolidTx|convertTessellation|convertUnit|copyArray|copyFlexor|copyKey|copySkinWeights|cos|cpButton|cpCache|cpClothSet|cpCollision|cpConstraint|cpConvClothToMesh|cpForces|cpGetSolverAttr|cpPanel|cpProperty|cpRigidCollisionFilter|cpSeam|cpSetEdit|cpSetSolverAttr|cpSolver|cpSolverTypes|cpTool|cpUpdateClothUVs|createDisplayLayer|createDrawCtx|createEditor|createLayeredPsdFile|createMotionField|createNewShelf|createNode|createRenderLayer|createSubdivRegion|cross|crossProduct|ctxAbort|ctxCompletion|ctxEditMode|ctxTraverse|currentCtx|currentTime|currentTimeCtx|currentUnit|curve|curveAddPtCtx|curveCVCtx|curveEPCtx|curveEditorCtx|curveIntersect|curveMoveEPCtx|curveOnSurface|curveSketchCtx|cutKey|cycleCheck|cylinder|dagPose|date|defaultLightListCheckBox|defaultNavigation|defineDataServer|defineVirtualDevice|deformer|deg_to_rad|delete|deleteAttr|deleteShadingGroupsAndMaterials|deleteShelfTab|deleteUI|deleteUnusedBrushes|delrandstr|detachCurve|detachDeviceAttr|detachSurface|deviceEditor|devicePanel|dgInfo|dgdirty|dgeval|dgtimer|dimWhen|directKeyCtx|directionalLight|dirmap|dirname|disable|disconnectAttr|disconnectJoint|diskCache|displacementToPoly|displayAffected|displayColor|displayCull|displayLevelOfDetail|displayPref|displayRGBColor|displaySmoothness|displayStats|displayString|displaySurface|distanceDimContext|distanceDimension|doBlur|dolly|dollyCtx|dopeSheetEditor|dot|dotProduct|doubleProfileBirailSurface|drag|dragAttrContext|draggerContext|dropoffLocator|duplicate|duplicateCurve|duplicateSurface|dynCache|dynControl|dynExport|dynExpression|dynGlobals|dynPaintEditor|dynParticleCtx|dynPref|dynRelEdPanel|dynRelEditor|dynamicLoad|editAttrLimits|editDisplayLayerGlobals|editDisplayLayerMembers|editRenderLayerAdjustment|editRenderLayerGlobals|editRenderLayerMembers|editor|editorTemplate|effector|emit|emitter|enableDevice|encodeString|endString|endsWith|env|equivalent|equivalentTol|erf|error|eval|evalDeferred|evalEcho|event|exactWorldBoundingBox|exclusiveLightCheckBox|exec|executeForEachObject|exists|exp|expression|expressionEditorListen|extendCurve|extendSurface|extrude|fcheck|fclose|feof|fflush|fgetline|fgetword|file|fileBrowserDialog|fileDialog|fileExtension|fileInfo|filetest|filletCurve|filter|filterCurve|filterExpand|filterStudioImport|findAllIntersections|findAnimCurves|findKeyframe|findMenuItem|findRelatedSkinCluster|finder|firstParentOf|fitBspline|flexor|floatEq|floatField|floatFieldGrp|floatScrollBar|floatSlider|floatSlider2|floatSliderButtonGrp|floatSliderGrp|floor|flow|fluidCacheInfo|fluidEmitter|fluidVoxelInfo|flushUndo|fmod|fontDialog|fopen|formLayout|format|fprint|frameLayout|fread|freeFormFillet|frewind|fromNativePath|fwrite|gamma|gauss|geometryConstraint|getApplicationVersionAsFloat|getAttr|getClassification|getDefaultBrush|getFileList|getFluidAttr|getInputDeviceRange|getMayaPanelTypes|getModifiers|getPanel|getParticleAttr|getPluginResource|getenv|getpid|glRender|glRenderEditor|globalStitch|gmatch|goal|gotoBindPose|grabColor|gradientControl|gradientControlNoAttr|graphDollyCtx|graphSelectContext|graphTrackCtx|gravity|grid|gridLayout|group|groupObjectsByName|HfAddAttractorToAS|HfAssignAS|HfBuildEqualMap|HfBuildFurFiles|HfBuildFurImages|HfCancelAFR|HfConnectASToHF|HfCreateAttractor|HfDeleteAS|HfEditAS|HfPerformCreateAS|HfRemoveAttractorFromAS|HfSelectAttached|HfSelectAttractors|HfUnAssignAS|hardenPointCurve|hardware|hardwareRenderPanel|headsUpDisplay|headsUpMessage|help|helpLine|hermite|hide|hilite|hitTest|hotBox|hotkey|hotkeyCheck|hsv_to_rgb|hudButton|hudSlider|hudSliderButton|hwReflectionMap|hwRender|hwRenderLoad|hyperGraph|hyperPanel|hyperShade|hypot|iconTextButton|iconTextCheckBox|iconTextRadioButton|iconTextRadioCollection|iconTextScrollList|iconTextStaticLabel|ikHandle|ikHandleCtx|ikHandleDisplayScale|ikSolver|ikSplineHandleCtx|ikSystem|ikSystemInfo|ikfkDisplayMethod|illustratorCurves|image|imfPlugins|inheritTransform|insertJoint|insertJointCtx|insertKeyCtx|insertKnotCurve|insertKnotSurface|instance|instanceable|instancer|intField|intFieldGrp|intScrollBar|intSlider|intSliderGrp|interToUI|internalVar|intersect|iprEngine|isAnimCurve|isConnected|isDirty|isParentOf|isSameObject|isTrue|isValidObjectName|isValidString|isValidUiName|isolateSelect|itemFilter|itemFilterAttr|itemFilterRender|itemFilterType|joint|jointCluster|jointCtx|jointDisplayScale|jointLattice|keyTangent|keyframe|keyframeOutliner|keyframeRegionCurrentTimeCtx|keyframeRegionDirectKeyCtx|keyframeRegionDollyCtx|keyframeRegionInsertKeyCtx|keyframeRegionMoveKeyCtx|keyframeRegionScaleKeyCtx|keyframeRegionSelectKeyCtx|keyframeRegionSetKeyCtx|keyframeRegionTrackCtx|keyframeStats|lassoContext|lattice|latticeDeformKeyCtx|launch|launchImageEditor|layerButton|layeredShaderPort|layeredTexturePort|layout|layoutDialog|lightList|lightListEditor|lightListPanel|lightlink|lineIntersection|linearPrecision|linstep|listAnimatable|listAttr|listCameras|listConnections|listDeviceAttachments|listHistory|listInputDeviceAxes|listInputDeviceButtons|listInputDevices|listMenuAnnotation|listNodeTypes|listPanelCategories|listRelatives|listSets|listTransforms|listUnselected|listerEditor|loadFluid|loadNewShelf|loadPlugin|loadPluginLanguageResources|loadPrefObjects|localizedPanelLabel|lockNode|loft|log|longNameOf|lookThru|ls|lsThroughFilter|lsType|lsUI|Mayatomr|mag|makeIdentity|makeLive|makePaintable|makeRoll|makeSingleSurface|makeTubeOn|makebot|manipMoveContext|manipMoveLimitsCtx|manipOptions|manipRotateContext|manipRotateLimitsCtx|manipScaleContext|manipScaleLimitsCtx|marker|match|max|memory|menu|menuBarLayout|menuEditor|menuItem|menuItemToShelf|menuSet|menuSetPref|messageLine|min|minimizeApp|mirrorJoint|modelCurrentTimeCtx|modelEditor|modelPanel|mouse|movIn|movOut|move|moveIKtoFK|moveKeyCtx|moveVertexAlongDirection|multiProfileBirailSurface|mute|nParticle|nameCommand|nameField|namespace|namespaceInfo|newPanelItems|newton|nodeCast|nodeIconButton|nodeOutliner|nodePreset|nodeType|noise|nonLinear|normalConstraint|normalize|nurbsBoolean|nurbsCopyUVSet|nurbsCube|nurbsEditUV|nurbsPlane|nurbsSelect|nurbsSquare|nurbsToPoly|nurbsToPolygonsPref|nurbsToSubdiv|nurbsToSubdivPref|nurbsUVSet|nurbsViewDirectionVector|objExists|objectCenter|objectLayer|objectType|objectTypeUI|obsoleteProc|oceanNurbsPreviewPlane|offsetCurve|offsetCurveOnSurface|offsetSurface|openGLExtension|openMayaPref|optionMenu|optionMenuGrp|optionVar|orbit|orbitCtx|orientConstraint|outlinerEditor|outlinerPanel|overrideModifier|paintEffectsDisplay|pairBlend|palettePort|paneLayout|panel|panelConfiguration|panelHistory|paramDimContext|paramDimension|paramLocator|parent|parentConstraint|particle|particleExists|particleInstancer|particleRenderInfo|partition|pasteKey|pathAnimation|pause|pclose|percent|performanceOptions|pfxstrokes|pickWalk|picture|pixelMove|planarSrf|plane|play|playbackOptions|playblast|plugAttr|plugNode|pluginInfo|pluginResourceUtil|pointConstraint|pointCurveConstraint|pointLight|pointMatrixMult|pointOnCurve|pointOnSurface|pointPosition|poleVectorConstraint|polyAppend|polyAppendFacetCtx|polyAppendVertex|polyAutoProjection|polyAverageNormal|polyAverageVertex|polyBevel|polyBlendColor|polyBlindData|polyBoolOp|polyBridgeEdge|polyCacheMonitor|polyCheck|polyChipOff|polyClipboard|polyCloseBorder|polyCollapseEdge|polyCollapseFacet|polyColorBlindData|polyColorDel|polyColorPerVertex|polyColorSet|polyCompare|polyCone|polyCopyUV|polyCrease|polyCreaseCtx|polyCreateFacet|polyCreateFacetCtx|polyCube|polyCut|polyCutCtx|polyCylinder|polyCylindricalProjection|polyDelEdge|polyDelFacet|polyDelVertex|polyDuplicateAndConnect|polyDuplicateEdge|polyEditUV|polyEditUVShell|polyEvaluate|polyExtrudeEdge|polyExtrudeFacet|polyExtrudeVertex|polyFlipEdge|polyFlipUV|polyForceUV|polyGeoSampler|polyHelix|polyInfo|polyInstallAction|polyLayoutUV|polyListComponentConversion|polyMapCut|polyMapDel|polyMapSew|polyMapSewMove|polyMergeEdge|polyMergeEdgeCtx|polyMergeFacet|polyMergeFacetCtx|polyMergeUV|polyMergeVertex|polyMirrorFace|polyMoveEdge|polyMoveFacet|polyMoveFacetUV|polyMoveUV|polyMoveVertex|polyNormal|polyNormalPerVertex|polyNormalizeUV|polyOptUvs|polyOptions|polyOutput|polyPipe|polyPlanarProjection|polyPlane|polyPlatonicSolid|polyPoke|polyPrimitive|polyPrism|polyProjection|polyPyramid|polyQuad|polyQueryBlindData|polyReduce|polySelect|polySelectConstraint|polySelectConstraintMonitor|polySelectCtx|polySelectEditCtx|polySeparate|polySetToFaceNormal|polySewEdge|polyShortestPathCtx|polySmooth|polySoftEdge|polySphere|polySphericalProjection|polySplit|polySplitCtx|polySplitEdge|polySplitRing|polySplitVertex|polyStraightenUVBorder|polySubdivideEdge|polySubdivideFacet|polyToSubdiv|polyTorus|polyTransfer|polyTriangulate|polyUVSet|polyUnite|polyWedgeFace|popen|popupMenu|pose|pow|preloadRefEd|print|progressBar|progressWindow|projFileViewer|projectCurve|projectTangent|projectionContext|projectionManip|promptDialog|propModCtx|propMove|psdChannelOutliner|psdEditTextureFile|psdExport|psdTextureFile|putenv|pwd|python|querySubdiv|quit|rad_to_deg|radial|radioButton|radioButtonGrp|radioCollection|radioMenuItemCollection|rampColorPort|rand|randomizeFollicles|randstate|rangeControl|readTake|rebuildCurve|rebuildSurface|recordAttr|recordDevice|redo|reference|referenceEdit|referenceQuery|refineSubdivSelectionList|refresh|refreshAE|registerPluginResource|rehash|reloadImage|removeJoint|removeMultiInstance|removePanelCategory|rename|renameAttr|renameSelectionList|renameUI|render|renderGlobalsNode|renderInfo|renderLayerButton|renderLayerParent|renderLayerPostProcess|renderLayerUnparent|renderManip|renderPartition|renderQualityNode|renderSettings|renderThumbnailUpdate|renderWindowEditor|renderWindowSelectContext|renderer|reorder|reorderDeformers|requires|reroot|resampleFluid|resetAE|resetPfxToPolyCamera|resetTool|resolutionNode|retarget|reverseCurve|reverseSurface|revolve|rgb_to_hsv|rigidBody|rigidSolver|roll|rollCtx|rootOf|rot|rotate|rotationInterpolation|roundConstantRadius|rowColumnLayout|rowLayout|runTimeCommand|runup|sampleImage|saveAllShelves|saveAttrPreset|saveFluid|saveImage|saveInitialState|saveMenu|savePrefObjects|savePrefs|saveShelf|saveToolSettings|scale|scaleBrushBrightness|scaleComponents|scaleConstraint|scaleKey|scaleKeyCtx|sceneEditor|sceneUIReplacement|scmh|scriptCtx|scriptEditorInfo|scriptJob|scriptNode|scriptTable|scriptToShelf|scriptedPanel|scriptedPanelType|scrollField|scrollLayout|sculpt|searchPathArray|seed|selLoadSettings|select|selectContext|selectCurveCV|selectKey|selectKeyCtx|selectKeyframeRegionCtx|selectMode|selectPref|selectPriority|selectType|selectedNodes|selectionConnection|separator|setAttr|setAttrEnumResource|setAttrMapping|setAttrNiceNameResource|setConstraintRestPosition|setDefaultShadingGroup|setDrivenKeyframe|setDynamic|setEditCtx|setEditor|setFluidAttr|setFocus|setInfinity|setInputDeviceMapping|setKeyCtx|setKeyPath|setKeyframe|setKeyframeBlendshapeTargetWts|setMenuMode|setNodeNiceNameResource|setNodeTypeFlag|setParent|setParticleAttr|setPfxToPolyCamera|setPluginResource|setProject|setStampDensity|setStartupMessage|setState|setToolTo|setUITemplate|setXformManip|sets|shadingConnection|shadingGeometryRelCtx|shadingLightRelCtx|shadingNetworkCompare|shadingNode|shapeCompare|shelfButton|shelfLayout|shelfTabLayout|shellField|shortNameOf|showHelp|showHidden|showManipCtx|showSelectionInTitle|showShadingGroupAttrEditor|showWindow|sign|simplify|sin|singleProfileBirailSurface|size|sizeBytes|skinCluster|skinPercent|smoothCurve|smoothTangentSurface|smoothstep|snap2to2|snapKey|snapMode|snapTogetherCtx|snapshot|soft|softMod|softModCtx|sort|sound|soundControl|source|spaceLocator|sphere|sphrand|spotLight|spotLightPreviewPort|spreadSheetEditor|spring|sqrt|squareSurface|srtContext|stackTrace|startString|startsWith|stitchAndExplodeShell|stitchSurface|stitchSurfacePoints|strcmp|stringArrayCatenate|stringArrayContains|stringArrayCount|stringArrayInsertAtIndex|stringArrayIntersector|stringArrayRemove|stringArrayRemoveAtIndex|stringArrayRemoveDuplicates|stringArrayRemoveExact|stringArrayToString|stringToStringArray|strip|stripPrefixFromName|stroke|subdAutoProjection|subdCleanTopology|subdCollapse|subdDuplicateAndConnect|subdEditUV|subdListComponentConversion|subdMapCut|subdMapSewMove|subdMatchTopology|subdMirror|subdToBlind|subdToPoly|subdTransferUVsToCache|subdiv|subdivCrease|subdivDisplaySmoothness|substitute|substituteAllString|substituteGeometry|substring|surface|surfaceSampler|surfaceShaderList|swatchDisplayPort|switchTable|symbolButton|symbolCheckBox|sysFile|system|tabLayout|tan|tangentConstraint|texLatticeDeformContext|texManipContext|texMoveContext|texMoveUVShellContext|texRotateContext|texScaleContext|texSelectContext|texSelectShortestPathCtx|texSmudgeUVContext|texWinToolCtx|text|textCurves|textField|textFieldButtonGrp|textFieldGrp|textManip|textScrollList|textToShelf|textureDisplacePlane|textureHairColor|texturePlacementContext|textureWindow|threadCount|threePointArcCtx|timeControl|timePort|timerX|toNativePath|toggle|toggleAxis|toggleWindowVisibility|tokenize|tokenizeList|tolerance|tolower|toolButton|toolCollection|toolDropped|toolHasOptions|toolPropertyWindow|torus|toupper|trace|track|trackCtx|transferAttributes|transformCompare|transformLimits|translator|trim|trunc|truncateFluidCache|truncateHairCache|tumble|tumbleCtx|turbulence|twoPointArcCtx|uiRes|uiTemplate|unassignInputDevice|undo|undoInfo|ungroup|uniform|unit|unloadPlugin|untangleUV|untitledFileName|untrim|upAxis|updateAE|userCtx|uvLink|uvSnapshot|validateShelfName|vectorize|view2dToolCtx|viewCamera|viewClipPlane|viewFit|viewHeadOn|viewLookAt|viewManip|viewPlace|viewSet|visor|volumeAxis|vortex|waitCursor|warning|webBrowser|webBrowserPrefs|whatIs|window|windowPref|wire|wireContext|workspace|wrinkle|wrinkleContext|writeTake|xbmLangPathList|xform)\b/,operator:[/\+[+=]?|-[-=]?|&&|\|\||[<>]=|[*\/!=]=?|[%^]/,{pattern:/(^|[^<])<(?!<)/,lookbehind:true},{pattern:/(^|[^>])>(?!>)/,lookbehind:true}],punctuation:/<<|>>|[.,:;?\[\](){}]/};Prism.languages.mel["code"].inside.rest=Prism.languages.mel}},function(module,exports,__webpack_require__){"use strict";module.exports=mizar;mizar.displayName="mizar";mizar.aliases=[];function mizar(Prism){Prism.languages.mizar={comment:/::.+/,keyword:/@proof\b|\b(?:according|aggregate|all|and|antonym|are|as|associativity|assume|asymmetry|attr|be|begin|being|by|canceled|case|cases|clusters?|coherence|commutativity|compatibility|connectedness|consider|consistency|constructors|contradiction|correctness|def|deffunc|define|definitions?|defpred|do|does|equals|end|environ|ex|exactly|existence|for|from|func|given|hence|hereby|holds|idempotence|identity|iff?|implies|involutiveness|irreflexivity|is|it|let|means|mode|non|not|notations?|now|of|or|otherwise|over|per|pred|prefix|projectivity|proof|provided|qua|reconsider|redefine|reduce|reducibility|reflexivity|registrations?|requirements|reserve|sch|schemes?|section|selector|set|sethood|st|struct|such|suppose|symmetry|synonym|take|that|the|then|theorems?|thesis|thus|to|transitivity|uniqueness|vocabular(?:y|ies)|when|where|with|wrt)\b/,parameter:{pattern:/\$(?:10|\d)/,alias:"variable"},variable:/\w+(?=:)/,number:/(?:\b|-)\d+\b/,operator:/\.\.\.|->|&|\.?=/,punctuation:/\(#|#\)|[,:;\[\](){}]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=mongodb;mongodb.displayName="mongodb";mongodb.aliases=[];function mongodb(Prism){(function(Prism){var operators=["$eq","$gt","$gte","$in","$lt","$lte","$ne","$nin","$and","$not","$nor","$or","$exists","$type","$expr","$jsonSchema","$mod","$regex","$text","$where","$geoIntersects","$geoWithin","$near","$nearSphere","$all","$elemMatch","$size","$bitsAllClear","$bitsAllSet","$bitsAnyClear","$bitsAnySet","$comment","$elemMatch","$meta","$slice","$currentDate","$inc","$min","$max","$mul","$rename","$set","$setOnInsert","$unset","$addToSet","$pop","$pull","$push","$pullAll","$each","$position","$slice","$sort","$bit","$addFields","$bucket","$bucketAuto","$collStats","$count","$currentOp","$facet","$geoNear","$graphLookup","$group","$indexStats","$limit","$listLocalSessions","$listSessions","$lookup","$match","$merge","$out","$planCacheStats","$project","$redact","$replaceRoot","$replaceWith","$sample","$set","$skip","$sort","$sortByCount","$unionWith","$unset","$unwind","$abs","$accumulator","$acos","$acosh","$add","$addToSet","$allElementsTrue","$and","$anyElementTrue","$arrayElemAt","$arrayToObject","$asin","$asinh","$atan","$atan2","$atanh","$avg","$binarySize","$bsonSize","$ceil","$cmp","$concat","$concatArrays","$cond","$convert","$cos","$dateFromParts","$dateToParts","$dateFromString","$dateToString","$dayOfMonth","$dayOfWeek","$dayOfYear","$degreesToRadians","$divide","$eq","$exp","$filter","$first","$floor","$function","$gt","$gte","$hour","$ifNull","$in","$indexOfArray","$indexOfBytes","$indexOfCP","$isArray","$isNumber","$isoDayOfWeek","$isoWeek","$isoWeekYear","$last","$last","$let","$literal","$ln","$log","$log10","$lt","$lte","$ltrim","$map","$max","$mergeObjects","$meta","$min","$millisecond","$minute","$mod","$month","$multiply","$ne","$not","$objectToArray","$or","$pow","$push","$radiansToDegrees","$range","$reduce","$regexFind","$regexFindAll","$regexMatch","$replaceOne","$replaceAll","$reverseArray","$round","$rtrim","$second","$setDifference","$setEquals","$setIntersection","$setIsSubset","$setUnion","$size","$sin","$slice","$split","$sqrt","$stdDevPop","$stdDevSamp","$strcasecmp","$strLenBytes","$strLenCP","$substr","$substrBytes","$substrCP","$subtract","$sum","$switch","$tan","$toBool","$toDate","$toDecimal","$toDouble","$toInt","$toLong","$toObjectId","$toString","$toLower","$toUpper","$trim","$trunc","$type","$week","$year","$zip","$comment","$explain","$hint","$max","$maxTimeMS","$min","$orderby","$query","$returnKey","$showDiskLoc","$natural"];var builtinFunctions=["ObjectId","Code","BinData","DBRef","Timestamp","NumberLong","NumberDecimal","MaxKey","MinKey","RegExp","ISODate","UUID"];operators=operators.map((function(operator){return operator.replace("$","\\$")}));var operatorsSource="(?:"+operators.join("|")+")\\b";Prism.languages.mongodb=Prism.languages.extend("javascript",{});Prism.languages.insertBefore("mongodb","string",{property:{pattern:/(?:(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1|[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*)(?=\s*:)/,greedy:true,inside:{keyword:RegExp("^(['\"])?"+operatorsSource+"(?:\\1)?$")}}});Prism.languages.mongodb.string.inside={url:{pattern:/https?:\/\/[-\w@:%.+~#=]{1,256}\.[a-z0-9()]{1,6}\b[-\w()@:%+.~#?&/=]*/i,greedy:true},entity:{pattern:/\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b/,greedy:true}};Prism.languages.insertBefore("mongodb","constant",{builtin:{pattern:RegExp("\\b(?:"+builtinFunctions.join("|")+")\\b"),alias:"keyword"}})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=monkey;monkey.displayName="monkey";monkey.aliases=[];function monkey(Prism){Prism.languages.monkey={string:/"[^"\r\n]*"/,comment:[{pattern:/^#Rem\s+[\s\S]*?^#End/im,greedy:true},{pattern:/'.+/,greedy:true}],preprocessor:{pattern:/(^[ \t]*)#.+/m,lookbehind:true,alias:"comment"},function:/\w+(?=\()/,"type-char":{pattern:/(\w)[?%#$]/,lookbehind:true,alias:"variable"},number:{pattern:/((?:\.\.)?)(?:(?:\b|\B-\.?|\B\.)\d+(?:(?!\.\.)\.\d*)?|\$[\da-f]+)/i,lookbehind:true},keyword:/\b(?:Void|Strict|Public|Private|Property|Bool|Int|Float|String|Array|Object|Continue|Exit|Import|Extern|New|Self|Super|Try|Catch|Eachin|True|False|Extends|Abstract|Final|Select|Case|Default|Const|Local|Global|Field|Method|Function|Class|End|If|Then|Else|ElseIf|EndIf|While|Wend|Repeat|Until|Forever|For|To|Step|Next|Return|Module|Interface|Implements|Inline|Throw|Null)\b/i,operator:/\.\.|<[=>]?|>=?|:?=|(?:[+\-*\/&~|]|\b(?:Mod|Shl|Shr)\b)=?|\b(?:And|Not|Or)\b/i,punctuation:/[.,:;()\[\]]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=moonscript;moonscript.displayName="moonscript";moonscript.aliases=["moon"];function moonscript(Prism){Prism.languages.moonscript={comment:/--.*/,string:[{pattern:/'[^']*'|\[(=*)\[[\s\S]*?\]\1\]/,greedy:true},{pattern:/"[^"]*"/,greedy:true,inside:{interpolation:{pattern:/#\{[^{}]*\}/,inside:{moonscript:{pattern:/(^#\{)[\s\S]+(?=\})/,lookbehind:true,inside:null},"interpolation-punctuation":{pattern:/#\{|\}/,alias:"punctuation"}}}}}],"class-name":[{pattern:/(\b(?:class|extends)[ \t]+)\w+/,lookbehind:true},/\b[A-Z]\w*/],keyword:/\b(?:class|continue|do|else|elseif|export|extends|for|from|if|import|in|local|nil|return|self|super|switch|then|unless|using|when|while|with)\b/,variable:/@@?\w*/,property:{pattern:/\b(?!\d)\w+(?=:)|(:)(?!\d)\w+/,lookbehind:true},function:{pattern:/\b(?:_G|_VERSION|assert|collectgarbage|coroutine\.(?:running|create|resume|status|wrap|yield)|debug\.(?:debug|gethook|getinfo|getlocal|getupvalue|setlocal|setupvalue|sethook|traceback|getfenv|getmetatable|getregistry|setfenv|setmetatable)|dofile|error|getfenv|getmetatable|io\.(?:stdin|stdout|stderr|close|flush|input|lines|open|output|popen|read|tmpfile|type|write)|ipairs|load|loadfile|loadstring|math\.(?:abs|acos|asin|atan|atan2|ceil|sin|cos|tan|deg|exp|floor|log|log10|max|min|fmod|modf|cosh|sinh|tanh|pow|rad|sqrt|frexp|ldexp|random|randomseed|pi)|module|next|os\.(?:clock|date|difftime|execute|exit|getenv|remove|rename|setlocale|time|tmpname)|package\.(?:cpath|loaded|loadlib|path|preload|seeall)|pairs|pcall|print|rawequal|rawget|rawset|require|select|setfenv|setmetatable|string\.(?:byte|char|dump|find|len|lower|rep|sub|upper|format|gsub|gmatch|match|reverse)|table\.(?:maxn|concat|sort|insert|remove)|tonumber|tostring|type|unpack|xpcall)\b/,inside:{punctuation:/\./}},boolean:/\b(?:false|true)\b/,number:/(?:\B\.\d+|\b\d+\.\d+|\b\d+(?=[eE]))(?:[eE][-+]?\d+)?\b|\b(?:0x[a-fA-F\d]+|\d+)(?:U?LL)?\b/,operator:/\.{3}|[-=]>|~=|(?:[-+*/%<>!=]|\.\.)=?|[:#^]|\b(?:and|or)\b=?|\b(?:not)\b/,punctuation:/[.,()[\]{}\\]/};Prism.languages.moonscript.string[1].inside.interpolation.inside.moonscript.inside=Prism.languages.moonscript;Prism.languages.moon=Prism.languages.moonscript}},function(module,exports,__webpack_require__){"use strict";module.exports=n1ql;n1ql.displayName="n1ql";n1ql.aliases=[];function n1ql(Prism){Prism.languages.n1ql={comment:/\/\*[\s\S]*?(?:$|\*\/)/,parameter:/\$[\w.]+/,string:{pattern:/(["'])(?:\\[\s\S]|(?!\1)[^\\]|\1\1)*\1/,greedy:true},identifier:{pattern:/`(?:\\[\s\S]|[^\\`]|``)*`/,greedy:true},function:/\b(?:ABS|ACOS|ARRAY_AGG|ARRAY_APPEND|ARRAY_AVG|ARRAY_CONCAT|ARRAY_CONTAINS|ARRAY_COUNT|ARRAY_DISTINCT|ARRAY_FLATTEN|ARRAY_IFNULL|ARRAY_INSERT|ARRAY_INTERSECT|ARRAY_LENGTH|ARRAY_MAX|ARRAY_MIN|ARRAY_POSITION|ARRAY_PREPEND|ARRAY_PUT|ARRAY_RANGE|ARRAY_REMOVE|ARRAY_REPEAT|ARRAY_REPLACE|ARRAY_REVERSE|ARRAY_SORT|ARRAY_STAR|ARRAY_SUM|ARRAY_SYMDIFF|ARRAY_SYMDIFFN|ARRAY_UNION|ASIN|ATAN|ATAN2|AVG|BASE64|BASE64_DECODE|BASE64_ENCODE|BITAND|BITCLEAR|BITNOT|BITOR|BITSET|BITSHIFT|BITTEST|BITXOR|CEIL|CLOCK_LOCAL|CLOCK_MILLIS|CLOCK_STR|CLOCK_TZ|CLOCK_UTC|CONTAINS|CONTAINS_TOKEN|CONTAINS_TOKEN_LIKE|CONTAINS_TOKEN_REGEXP|COS|COUNT|CURL|DATE_ADD_MILLIS|DATE_ADD_STR|DATE_DIFF_MILLIS|DATE_DIFF_STR|DATE_FORMAT_STR|DATE_PART_MILLIS|DATE_PART_STR|DATE_RANGE_MILLIS|DATE_RANGE_STR|DATE_TRUNC_MILLIS|DATE_TRUNC_STR|DECODE_JSON|DEGREES|DURATION_TO_STR|E|ENCODED_SIZE|ENCODE_JSON|EXP|FLOOR|GREATEST|HAS_TOKEN|IFINF|IFMISSING|IFMISSINGORNULL|IFNAN|IFNANORINF|IFNULL|INITCAP|ISARRAY|ISATOM|ISBOOLEAN|ISNUMBER|ISOBJECT|ISSTRING|IsBitSET|LEAST|LENGTH|LN|LOG|LOWER|LTRIM|MAX|META|MILLIS|MILLIS_TO_LOCAL|MILLIS_TO_STR|MILLIS_TO_TZ|MILLIS_TO_UTC|MILLIS_TO_ZONE_NAME|MIN|MISSINGIF|NANIF|NEGINFIF|NOW_LOCAL|NOW_MILLIS|NOW_STR|NOW_TZ|NOW_UTC|NULLIF|OBJECT_ADD|OBJECT_CONCAT|OBJECT_INNER_PAIRS|OBJECT_INNER_VALUES|OBJECT_LENGTH|OBJECT_NAMES|OBJECT_PAIRS|OBJECT_PUT|OBJECT_REMOVE|OBJECT_RENAME|OBJECT_REPLACE|OBJECT_UNWRAP|OBJECT_VALUES|PAIRS|PI|POLY_LENGTH|POSINFIF|POSITION|POWER|RADIANS|RANDOM|REGEXP_CONTAINS|REGEXP_LIKE|REGEXP_POSITION|REGEXP_REPLACE|REPEAT|REPLACE|REVERSE|ROUND|RTRIM|SIGN|SIN|SPLIT|SQRT|STR_TO_DURATION|STR_TO_MILLIS|STR_TO_TZ|STR_TO_UTC|STR_TO_ZONE_NAME|SUBSTR|SUFFIXES|SUM|TAN|TITLE|TOARRAY|TOATOM|TOBOOLEAN|TOKENS|TONUMBER|TOOBJECT|TOSTRING|TRIM|TRUNC|TYPE|UPPER|WEEKDAY_MILLIS|WEEKDAY_STR)(?=\s*\()/i,keyword:/\b(?:ALL|ALTER|ANALYZE|AS|ASC|BEGIN|BINARY|BOOLEAN|BREAK|BUCKET|BUILD|BY|CALL|CAST|CLUSTER|COLLATE|COLLECTION|COMMIT|CONNECT|CONTINUE|CORRELATE|COVER|CREATE|DATABASE|DATASET|DATASTORE|DECLARE|DECREMENT|DELETE|DERIVED|DESC|DESCRIBE|DISTINCT|DO|DROP|EACH|ELEMENT|EXCEPT|EXCLUDE|EXECUTE|EXPLAIN|FETCH|FLATTEN|FOR|FORCE|FROM|FUNCTION|GRANT|GROUP|GSI|HAVING|IF|IGNORE|ILIKE|INCLUDE|INCREMENT|INDEX|INFER|INLINE|INNER|INSERT|INTERSECT|INTO|IS|JOIN|KEY|KEYS|KEYSPACE|KNOWN|LAST|LEFT|LET|LETTING|LIMIT|LSM|MAP|MAPPING|MATCHED|MATERIALIZED|MERGE|MINUS|MISSING|NAMESPACE|NEST|NULL|NUMBER|OBJECT|OFFSET|ON|OPTION|ORDER|OUTER|OVER|PARSE|PARTITION|PASSWORD|PATH|POOL|PREPARE|PRIMARY|PRIVATE|PRIVILEGE|PROCEDURE|PUBLIC|RAW|REALM|REDUCE|RENAME|RETURN|RETURNING|REVOKE|RIGHT|ROLE|ROLLBACK|SATISFIES|SCHEMA|SELECT|SELF|SEMI|SET|SHOW|SOME|START|STATISTICS|STRING|SYSTEM|TO|TRANSACTION|TRIGGER|TRUNCATE|UNDER|UNION|UNIQUE|UNKNOWN|UNNEST|UNSET|UPDATE|UPSERT|USE|USER|USING|VALIDATE|VALUE|VALUES|VIA|VIEW|WHERE|WHILE|WITH|WORK|XOR)\b/i,boolean:/\b(?:TRUE|FALSE)\b/i,number:/(?:\b\d+\.|\B\.)\d+e[+\-]?\d+\b|\b\d+\.?\d*|\B\.\d+\b/i,operator:/[-+*\/%]|!=|==?|\|\||<[>=]?|>=?|\b(?:AND|ANY|ARRAY|BETWEEN|CASE|ELSE|END|EVERY|EXISTS|FIRST|IN|LIKE|NOT|OR|THEN|VALUED|WHEN|WITHIN)\b/i,punctuation:/[;[\](),.{}:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=n4js;n4js.displayName="n4js";n4js.aliases=[];function n4js(Prism){Prism.languages.n4js=Prism.languages.extend("javascript",{keyword:/\b(?:any|Array|boolean|break|case|catch|class|const|constructor|continue|debugger|declare|default|delete|do|else|enum|export|extends|false|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|module|new|null|number|package|private|protected|public|return|set|static|string|super|switch|this|throw|true|try|typeof|var|void|while|with|yield)\b/});Prism.languages.insertBefore("n4js","constant",{annotation:{pattern:/@+\w+/,alias:"operator"}});Prism.languages.n4jsd=Prism.languages.n4js}},function(module,exports,__webpack_require__){"use strict";module.exports=nand2tetrisHdl;nand2tetrisHdl.displayName="nand2tetrisHdl";nand2tetrisHdl.aliases=[];function nand2tetrisHdl(Prism){Prism.languages["nand2tetris-hdl"]={comment:/\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,keyword:/\b(?:CHIP|IN|OUT|PARTS|BUILTIN|CLOCKED)\b/,boolean:/\b(?:true|false)\b/,function:/[A-Za-z][A-Za-z0-9]*(?=\()/,number:/\b\d+\b/,operator:/=|\.\./,punctuation:/[{}[\];(),:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=naniscript;naniscript.displayName="naniscript";naniscript.aliases=[];function naniscript(Prism){(function(Prism){var expressionDef=/\{[^\r\n\[\]{}]*\}/;var params={"quoted-string":{pattern:/"(?:[^"\\]|\\.)*"/,alias:"operator"},"command-param-id":{pattern:/(\s)\w+:/,lookbehind:true,alias:"property"},"command-param-value":[{pattern:expressionDef,alias:"selector"},{pattern:/([\t ])\S+/,lookbehind:true,greedy:true,alias:"operator"},{pattern:/\S(?:.*\S)?/,alias:"operator"}]};Prism.languages.naniscript={comment:{pattern:/^([\t ]*);.*/m,lookbehind:true},define:{pattern:/^>.+/m,alias:"tag",inside:{value:{pattern:/(^>\w+[\t ]+)(?!\s)[^{}\r\n]+/,lookbehind:true,alias:"operator"},key:{pattern:/(^>)\w+/,lookbehind:true}}},label:{pattern:/^([\t ]*)#[\t ]*\w+[\t ]*$/m,lookbehind:true,alias:"regex"},command:{pattern:/^([\t ]*)@\w+(?=[\t ]|$).*/m,lookbehind:true,alias:"function",inside:{"command-name":/^@\w+/,expression:{pattern:expressionDef,greedy:true,alias:"selector"},"command-params":{pattern:/[\s\S]*\S[\s\S]*/,inside:params}}},"generic-text":{pattern:/(^[ \t]*)[^#@>;\s].*/m,lookbehind:true,alias:"punctuation",inside:{"escaped-char":/\\[{}\[\]"]/,expression:{pattern:expressionDef,greedy:true,alias:"selector"},"inline-command":{pattern:/\[[\t ]*\w+[^\r\n\[\]]*\]/,greedy:true,alias:"function",inside:{"command-params":{pattern:/(^\[[\t ]*\w+\b)[\s\S]+(?=\]$)/,lookbehind:true,inside:params},"command-param-name":{pattern:/^(\[[\t ]*)\w+/,lookbehind:true,alias:"name"},"start-stop-char":/[\[\]]/}}}}};Prism.languages.nani=Prism.languages["naniscript"];Prism.hooks.add("after-tokenize",(function(env){var tokens=env.tokens;tokens.forEach((function(token){if(typeof token!=="string"&&token.type==="generic-text"){var content=getTextContent(token);if(!isBracketsBalanced(content)){token.type="bad-line";token.content=content}}}))}));function isBracketsBalanced(input){var brackets="[]{}";var stack=[];for(var i=0;i<input.length;i++){var bracket=input[i];var bracketsIndex=brackets.indexOf(bracket);if(bracketsIndex!==-1){if(bracketsIndex%2===0){stack.push(bracketsIndex+1)}else if(stack.pop()!==bracketsIndex){return false}}}return stack.length===0}function getTextContent(token){if(typeof token==="string"){return token}else if(Array.isArray(token)){return token.map(getTextContent).join("")}else{return getTextContent(token.content)}}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=nasm;nasm.displayName="nasm";nasm.aliases=[];function nasm(Prism){Prism.languages.nasm={comment:/;.*$/m,string:/(["'`])(?:\\.|(?!\1)[^\\\r\n])*\1/,label:{pattern:/(^\s*)[A-Za-z._?$][\w.?$@~#]*:/m,lookbehind:true,alias:"function"},keyword:[/\[?BITS (?:16|32|64)\]?/,{pattern:/(^\s*)section\s*[a-zA-Z.]+:?/im,lookbehind:true},/(?:extern|global)[^;\r\n]*/i,/(?:CPU|FLOAT|DEFAULT).*$/m],register:{pattern:/\b(?:st\d|[xyz]mm\d\d?|[cdt]r\d|r\d\d?[bwd]?|[er]?[abcd]x|[abcd][hl]|[er]?(?:bp|sp|si|di)|[cdefgs]s)\b/i,alias:"variable"},number:/(?:\b|(?=\$))(?:0[hx][\da-f]*\.?[\da-f]+(?:p[+-]?\d+)?|\d[\da-f]+[hx]|\$\d[\da-f]*|0[oq][0-7]+|[0-7]+[oq]|0[by][01]+|[01]+[by]|0[dt]\d+|\d*\.?\d+(?:\.?e[+-]?\d+)?[dt]?)\b/i,operator:/[\[\]*+\-\/%<>=&|$!]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=neon;neon.displayName="neon";neon.aliases=[];function neon(Prism){Prism.languages.neon={comment:{pattern:/#.*/,greedy:true},datetime:{pattern:/(^|[[{(=:,\s])\d\d\d\d-\d\d?-\d\d?(?:(?:[Tt]| +)\d\d?:\d\d:\d\d(?:\.\d*)? *(?:Z|[-+]\d\d?(?::?\d\d)?)?)?(?=$|[\]}),\s])/,lookbehind:true,alias:"number"},key:{pattern:/(^|[[{(,\s])[^,:=[\]{}()'"\s]+(?=\s*:(?:$|[\]}),\s])|\s*=)/,lookbehind:true,alias:"atrule"},number:{pattern:/(^|[[{(=:,\s])[+-]?(?:0x[\da-fA-F]+|0o[0-7]+|0b[01]+|(?:\d+\.?\d*|\.?\d+)(?:[eE][+-]?\d+)?)(?=$|[\]}),:=\s])/,lookbehind:true},boolean:{pattern:/(^|[[{(=:,\s])(?:true|false|yes|no)(?=$|[\]}),:=\s])/i,lookbehind:true},null:{pattern:/(^|[[{(=:,\s])(?:null)(?=$|[\]}),:=\s])/i,lookbehind:true,alias:"keyword"},string:{pattern:/(^|[[{(=:,\s])(?:('''|""")\r?\n(?:(?:[^\r\n]|\r?\n(?![\t ]*\2))*\r?\n)?[\t ]*\2|'[^'\r\n]*'|"(?:\\.|[^\\"\r\n])*")/,lookbehind:true,greedy:true},literal:{pattern:/(^|[[{(=:,\s])(?:[^#"\',:=[\]{}()\s`-]|[:-][^"\',=[\]{}()\s])(?:[^,:=\]})(\s]+|:(?![\s,\]})]|$)|[ \t]+[^#,:=\]})(\s])*/,lookbehind:true,alias:"string"},punctuation:/[,:=[\]{}()-]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=nginx;nginx.displayName="nginx";nginx.aliases=[];function nginx(Prism){Prism.languages.nginx=Prism.languages.extend("clike",{comment:{pattern:/(^|[^"{\\])#.*/,lookbehind:true},keyword:/\b(?:CONTENT_|DOCUMENT_|GATEWAY_|HTTP_|HTTPS|if_not_empty|PATH_|QUERY_|REDIRECT_|REMOTE_|REQUEST_|SCGI|SCRIPT_|SERVER_|http|events|accept_mutex|accept_mutex_delay|access_log|add_after_body|add_before_body|add_header|addition_types|aio|alias|allow|ancient_browser|ancient_browser_value|auth|auth_basic|auth_basic_user_file|auth_http|auth_http_header|auth_http_timeout|autoindex|autoindex_exact_size|autoindex_localtime|break|charset|charset_map|charset_types|chunked_transfer_encoding|client_body_buffer_size|client_body_in_file_only|client_body_in_single_buffer|client_body_temp_path|client_body_timeout|client_header_buffer_size|client_header_timeout|client_max_body_size|connection_pool_size|create_full_put_path|daemon|dav_access|dav_methods|debug_connection|debug_points|default_type|deny|devpoll_changes|devpoll_events|directio|directio_alignment|disable_symlinks|empty_gif|env|epoll_events|error_log|error_page|expires|fastcgi_buffer_size|fastcgi_buffers|fastcgi_busy_buffers_size|fastcgi_cache|fastcgi_cache_bypass|fastcgi_cache_key|fastcgi_cache_lock|fastcgi_cache_lock_timeout|fastcgi_cache_methods|fastcgi_cache_min_uses|fastcgi_cache_path|fastcgi_cache_purge|fastcgi_cache_use_stale|fastcgi_cache_valid|fastcgi_connect_timeout|fastcgi_hide_header|fastcgi_ignore_client_abort|fastcgi_ignore_headers|fastcgi_index|fastcgi_intercept_errors|fastcgi_keep_conn|fastcgi_max_temp_file_size|fastcgi_next_upstream|fastcgi_no_cache|fastcgi_param|fastcgi_pass|fastcgi_pass_header|fastcgi_read_timeout|fastcgi_redirect_errors|fastcgi_send_timeout|fastcgi_split_path_info|fastcgi_store|fastcgi_store_access|fastcgi_temp_file_write_size|fastcgi_temp_path|flv|geo|geoip_city|geoip_country|google_perftools_profiles|gzip|gzip_buffers|gzip_comp_level|gzip_disable|gzip_http_version|gzip_min_length|gzip_proxied|gzip_static|gzip_types|gzip_vary|if|if_modified_since|ignore_invalid_headers|image_filter|image_filter_buffer|image_filter_jpeg_quality|image_filter_sharpen|image_filter_transparency|imap_capabilities|imap_client_buffer|include|index|internal|ip_hash|keepalive|keepalive_disable|keepalive_requests|keepalive_timeout|kqueue_changes|kqueue_events|large_client_header_buffers|limit_conn|limit_conn_log_level|limit_conn_zone|limit_except|limit_rate|limit_rate_after|limit_req|limit_req_log_level|limit_req_zone|limit_zone|lingering_close|lingering_time|lingering_timeout|listen|location|lock_file|log_format|log_format_combined|log_not_found|log_subrequest|map|map_hash_bucket_size|map_hash_max_size|master_process|max_ranges|memcached_buffer_size|memcached_connect_timeout|memcached_next_upstream|memcached_pass|memcached_read_timeout|memcached_send_timeout|merge_slashes|min_delete_depth|modern_browser|modern_browser_value|mp4|mp4_buffer_size|mp4_max_buffer_size|msie_padding|msie_refresh|multi_accept|open_file_cache|open_file_cache_errors|open_file_cache_min_uses|open_file_cache_valid|open_log_file_cache|optimize_server_names|override_charset|pcre_jit|perl|perl_modules|perl_require|perl_set|pid|pop3_auth|pop3_capabilities|port_in_redirect|post_action|postpone_output|protocol|proxy|proxy_buffer|proxy_buffer_size|proxy_buffering|proxy_buffers|proxy_busy_buffers_size|proxy_cache|proxy_cache_bypass|proxy_cache_key|proxy_cache_lock|proxy_cache_lock_timeout|proxy_cache_methods|proxy_cache_min_uses|proxy_cache_path|proxy_cache_use_stale|proxy_cache_valid|proxy_connect_timeout|proxy_cookie_domain|proxy_cookie_path|proxy_headers_hash_bucket_size|proxy_headers_hash_max_size|proxy_hide_header|proxy_http_version|proxy_ignore_client_abort|proxy_ignore_headers|proxy_intercept_errors|proxy_max_temp_file_size|proxy_method|proxy_next_upstream|proxy_no_cache|proxy_pass|proxy_pass_error_message|proxy_pass_header|proxy_pass_request_body|proxy_pass_request_headers|proxy_read_timeout|proxy_redirect|proxy_redirect_errors|proxy_send_lowat|proxy_send_timeout|proxy_set_body|proxy_set_header|proxy_ssl_session_reuse|proxy_store|proxy_store_access|proxy_temp_file_write_size|proxy_temp_path|proxy_timeout|proxy_upstream_fail_timeout|proxy_upstream_max_fails|random_index|read_ahead|real_ip_header|recursive_error_pages|request_pool_size|reset_timedout_connection|resolver|resolver_timeout|return|rewrite|root|rtsig_overflow_events|rtsig_overflow_test|rtsig_overflow_threshold|rtsig_signo|satisfy|satisfy_any|secure_link_secret|send_lowat|send_timeout|sendfile|sendfile_max_chunk|server|server_name|server_name_in_redirect|server_names_hash_bucket_size|server_names_hash_max_size|server_tokens|set|set_real_ip_from|smtp_auth|smtp_capabilities|so_keepalive|source_charset|split_clients|ssi|ssi_silent_errors|ssi_types|ssi_value_length|ssl|ssl_certificate|ssl_certificate_key|ssl_ciphers|ssl_client_certificate|ssl_crl|ssl_dhparam|ssl_engine|ssl_prefer_server_ciphers|ssl_protocols|ssl_session_cache|ssl_session_timeout|ssl_verify_client|ssl_verify_depth|starttls|stub_status|sub_filter|sub_filter_once|sub_filter_types|tcp_nodelay|tcp_nopush|timeout|timer_resolution|try_files|types|types_hash_bucket_size|types_hash_max_size|underscores_in_headers|uninitialized_variable_warn|upstream|use|user|userid|userid_domain|userid_expires|userid_name|userid_p3p|userid_path|userid_service|valid_referers|variables_hash_bucket_size|variables_hash_max_size|worker_connections|worker_cpu_affinity|worker_priority|worker_processes|worker_rlimit_core|worker_rlimit_nofile|worker_rlimit_sigpending|working_directory|xclient|xml_entities|xslt_entities|xslt_stylesheet|xslt_types|ssl_session_tickets|ssl_stapling|ssl_stapling_verify|ssl_ecdh_curve|ssl_trusted_certificate|more_set_headers|ssl_early_data)\b/i});Prism.languages.insertBefore("nginx","keyword",{variable:/\$[a-z_]+/i})}},function(module,exports,__webpack_require__){"use strict";module.exports=nim;nim.displayName="nim";nim.aliases=[];function nim(Prism){Prism.languages.nim={comment:/#.*/,string:{pattern:/(?:(?:\b(?!\d)(?:\w|\\x[8-9a-fA-F][0-9a-fA-F])+)?(?:"""[\s\S]*?"""(?!")|"(?:\\[\s\S]|""|[^"\\])*")|'(?:\\(?:\d+|x[\da-fA-F]{2}|.)|[^'])')/,greedy:true},number:/\b(?:0[xXoObB][\da-fA-F_]+|\d[\d_]*(?:(?!\.\.)\.[\d_]*)?(?:[eE][+-]?\d[\d_]*)?)(?:'?[iuf]\d*)?/,keyword:/\b(?:addr|as|asm|atomic|bind|block|break|case|cast|concept|const|continue|converter|defer|discard|distinct|do|elif|else|end|enum|except|export|finally|for|from|func|generic|if|import|include|interface|iterator|let|macro|method|mixin|nil|object|out|proc|ptr|raise|ref|return|static|template|try|tuple|type|using|var|when|while|with|without|yield)\b/,function:{pattern:/(?:(?!\d)(?:\w|\\x[8-9a-fA-F][0-9a-fA-F])+|`[^`\r\n]+`)\*?(?:\[[^\]]+\])?(?=\s*\()/,inside:{operator:/\*$/}},ignore:{pattern:/`[^`\r\n]+`/,inside:{punctuation:/`/}},operator:{pattern:/(^|[({\[](?=\.\.)|(?![({\[]\.).)(?:(?:[=+\-*\/<>@$~&%|!?^:\\]|\.\.|\.(?![)}\]]))+|\b(?:and|div|of|or|in|is|isnot|mod|not|notin|shl|shr|xor)\b)/m,lookbehind:true},punctuation:/[({\[]\.|\.[)}\]]|[`(){}\[\],:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=nix;nix.displayName="nix";nix.aliases=[];function nix(Prism){Prism.languages.nix={comment:/\/\*[\s\S]*?\*\/|#.*/,string:{pattern:/"(?:[^"\\]|\\[\s\S])*"|''(?:(?!'')[\s\S]|''(?:'|\\|\$\{))*''/,greedy:true,inside:{interpolation:{pattern:/(^|(?:^|(?!'').)[^\\])\$\{(?:[^}]|\{[^}]*\})*}/,lookbehind:true,inside:{antiquotation:{pattern:/^\$(?=\{)/,alias:"variable"}}}}},url:[/\b(?:[a-z]{3,7}:\/\/)[\w\-+%~\/.:#=?&]+/,{pattern:/([^\/])(?:[\w\-+%~.:#=?&]*(?!\/\/)[\w\-+%~\/.:#=?&])?(?!\/\/)\/[\w\-+%~\/.:#=?&]*/,lookbehind:true}],antiquotation:{pattern:/\$(?=\{)/,alias:"variable"},number:/\b\d+\b/,keyword:/\b(?:assert|builtins|else|if|in|inherit|let|null|or|then|with)\b/,function:/\b(?:abort|add|all|any|attrNames|attrValues|baseNameOf|compareVersions|concatLists|currentSystem|deepSeq|derivation|dirOf|div|elem(?:At)?|fetch(?:url|Tarball)|filter(?:Source)?|fromJSON|genList|getAttr|getEnv|hasAttr|hashString|head|import|intersectAttrs|is(?:Attrs|Bool|Function|Int|List|Null|String)|length|lessThan|listToAttrs|map|mul|parseDrvName|pathExists|read(?:Dir|File)|removeAttrs|replaceStrings|seq|sort|stringLength|sub(?:string)?|tail|throw|to(?:File|JSON|Path|String|XML)|trace|typeOf)\b|\bfoldl'\B/,boolean:/\b(?:true|false)\b/,operator:/[=!<>]=?|\+\+?|\|\||&&|\/\/|->?|[?@]/,punctuation:/[{}()[\].,:;]/};Prism.languages.nix.string.inside.interpolation.inside.rest=Prism.languages.nix}},function(module,exports,__webpack_require__){"use strict";module.exports=nsis;nsis.displayName="nsis";nsis.aliases=[];function nsis(Prism){Prism.languages.nsis={comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|[#;].*)/,lookbehind:true},string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},keyword:{pattern:/(^\s*)(?:Abort|Add(?:BrandingImage|Size)|AdvSplash|Allow(?:RootDirInstall|SkipFiles)|AutoCloseWindow|Banner|BG(?:Font|Gradient|Image)|BrandingText|BringToFront|Call(?:InstDLL)?|Caption|ChangeUI|CheckBitmap|ClearErrors|CompletedText|ComponentText|CopyFiles|CRCCheck|Create(?:Directory|Font|ShortCut)|Delete(?:INISec|INIStr|RegKey|RegValue)?|Detail(?:Print|sButtonText)|Dialer|Dir(?:Text|Var|Verify)|EnableWindow|Enum(?:RegKey|RegValue)|Exch|Exec(?:Shell(?:Wait)?|Wait)?|ExpandEnvStrings|File(?:BufSize|Close|ErrorText|Open|Read|ReadByte|ReadUTF16LE|ReadWord|WriteUTF16LE|Seek|Write|WriteByte|WriteWord)?|Find(?:Close|First|Next|Window)|FlushINI|Get(?:CurInstType|CurrentAddress|DlgItem|DLLVersion(?:Local)?|ErrorLevel|FileTime(?:Local)?|FullPathName|Function(?:Address|End)?|InstDirError|LabelAddress|TempFileName)|Goto|HideWindow|Icon|If(?:Abort|Errors|FileExists|RebootFlag|Silent)|InitPluginsDir|Install(?:ButtonText|Colors|Dir(?:RegKey)?)|InstProgressFlags|Inst(?:Type(?:GetText|SetText)?)|Int(?:64|Ptr)?CmpU?|Int(?:64)?Fmt|Int(?:Ptr)?Op|IsWindow|Lang(?:DLL|String)|License(?:BkColor|Data|ForceSelection|LangString|Text)|LoadLanguageFile|LockWindow|Log(?:Set|Text)|Manifest(?:DPIAware|SupportedOS)|Math|MessageBox|MiscButtonText|Name|Nop|ns(?:Dialogs|Exec)|NSISdl|OutFile|Page(?:Callbacks)?|PE(?:DllCharacteristics|SubsysVer)|Pop|Push|Quit|Read(?:EnvStr|INIStr|RegDWORD|RegStr)|Reboot|RegDLL|Rename|RequestExecutionLevel|ReserveFile|Return|RMDir|SearchPath|Section(?:End|GetFlags|GetInstTypes|GetSize|GetText|Group|In|SetFlags|SetInstTypes|SetSize|SetText)?|SendMessage|Set(?:AutoClose|BrandingImage|Compress|Compressor(?:DictSize)?|CtlColors|CurInstType|DatablockOptimize|DateSave|Details(?:Print|View)|ErrorLevel|Errors|FileAttributes|Font|OutPath|Overwrite|PluginUnload|RebootFlag|RegView|ShellVarContext|Silent)|Show(?:InstDetails|UninstDetails|Window)|Silent(?:Install|UnInstall)|Sleep|SpaceTexts|Splash|StartMenu|Str(?:CmpS?|Cpy|Len)|SubCaption|System|Unicode|Uninstall(?:ButtonText|Caption|Icon|SubCaption|Text)|UninstPage|UnRegDLL|UserInfo|Var|VI(?:AddVersionKey|FileVersion|ProductVersion)|VPatch|WindowIcon|Write(?:INIStr|Reg(?:Bin|DWORD|ExpandStr|MultiStr|None|Str)|Uninstaller)|XPStyle)\b/m,lookbehind:true},property:/\b(?:admin|all|auto|both|colored|false|force|hide|highest|lastused|leave|listonly|none|normal|notset|off|on|open|print|show|silent|silentlog|smooth|textonly|true|user|ARCHIVE|FILE_(?:ATTRIBUTE_ARCHIVE|ATTRIBUTE_NORMAL|ATTRIBUTE_OFFLINE|ATTRIBUTE_READONLY|ATTRIBUTE_SYSTEM|ATTRIBUTE_TEMPORARY)|HK(?:(?:CR|CU|LM)(?:32|64)?|DD|PD|U)|HKEY_(?:CLASSES_ROOT|CURRENT_CONFIG|CURRENT_USER|DYN_DATA|LOCAL_MACHINE|PERFORMANCE_DATA|USERS)|ID(?:ABORT|CANCEL|IGNORE|NO|OK|RETRY|YES)|MB_(?:ABORTRETRYIGNORE|DEFBUTTON1|DEFBUTTON2|DEFBUTTON3|DEFBUTTON4|ICONEXCLAMATION|ICONINFORMATION|ICONQUESTION|ICONSTOP|OK|OKCANCEL|RETRYCANCEL|RIGHT|RTLREADING|SETFOREGROUND|TOPMOST|USERICON|YESNO)|NORMAL|OFFLINE|READONLY|SHCTX|SHELL_CONTEXT|SYSTEM|TEMPORARY)\b/,constant:/\${[\w\.:\^-]+}|\$\([\w\.:\^-]+\)/i,variable:/\$\w+/i,number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/--?|\+\+?|<=?|>=?|==?=?|&&?|\|\|?|[?*\/~^%]/,punctuation:/[{}[\];(),.:]/,important:{pattern:/(^\s*)!(?:addincludedir|addplugindir|appendfile|cd|define|delfile|echo|else|endif|error|execute|finalize|getdllversion|gettlbversion|ifdef|ifmacrodef|ifmacrondef|ifndef|if|include|insertmacro|macroend|macro|makensis|packhdr|pragma|searchparse|searchreplace|system|tempfile|undef|verbose|warning)\b/im,lookbehind:true}}}},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=objectivec;objectivec.displayName="objectivec";objectivec.aliases=["objc"];function objectivec(Prism){Prism.register(refractorC);Prism.languages.objectivec=Prism.languages.extend("c",{keyword:/\b(?:asm|typeof|inline|auto|break|case|char|const|continue|default|do|double|else|enum|extern|float|for|goto|if|int|long|register|return|short|signed|sizeof|static|struct|switch|typedef|union|unsigned|void|volatile|while|in|self|super)\b|(?:@interface|@end|@implementation|@protocol|@class|@public|@protected|@private|@property|@try|@catch|@finally|@throw|@synthesize|@dynamic|@selector)\b/,string:/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1|@"(?:\\(?:\r\n|[\s\S])|[^"\\\r\n])*"/,operator:/-[->]?|\+\+?|!=?|<<?=?|>>?=?|==?|&&?|\|\|?|[~^%?*\/@]/});delete Prism.languages.objectivec["class-name"];Prism.languages.objc=Prism.languages.objectivec}},function(module,exports,__webpack_require__){"use strict";module.exports=ocaml;ocaml.displayName="ocaml";ocaml.aliases=[];function ocaml(Prism){Prism.languages.ocaml={comment:/\(\*[\s\S]*?\*\)/,string:[{pattern:/"(?:\\.|[^\\\r\n"])*"/,greedy:true},{pattern:/(['`])(?:\\(?:\d+|x[\da-f]+|.)|(?!\1)[^\\\r\n])\1/i,greedy:true}],number:/\b(?:0x[\da-f][\da-f_]+|(?:0[bo])?\d[\d_]*\.?[\d_]*(?:e[+-]?[\d_]+)?)/i,directive:{pattern:/\B#\w+/,alias:"important"},label:{pattern:/\B~\w+/,alias:"function"},type_variable:{pattern:/\B'\w+/,alias:"function"},variant:{pattern:/`\w+/,alias:"variable"},module:{pattern:/\b[A-Z]\w+/,alias:"variable"},keyword:/\b(?:as|assert|begin|class|constraint|do|done|downto|else|end|exception|external|for|fun|function|functor|if|in|include|inherit|initializer|lazy|let|match|method|module|mutable|new|nonrec|object|of|open|private|rec|sig|struct|then|to|try|type|val|value|virtual|when|where|while|with)\b/,boolean:/\b(?:false|true)\b/,operator:/:=|[=<>@^|&+\-*\/$%!?~][!$%&*+\-.\/:<=>?@^|~]*|\b(?:and|asr|land|lor|lsl|lsr|lxor|mod|or)\b/,punctuation:/[(){}\[\]|.,:;]|\b_\b/}}},function(module,exports,__webpack_require__){"use strict";var refractorC=__webpack_require__(79);module.exports=opencl;opencl.displayName="opencl";opencl.aliases=[];function opencl(Prism){Prism.register(refractorC);(function(Prism){Prism.languages.opencl=Prism.languages.extend("c",{keyword:/\b(?:__attribute__|(?:__)?(?:constant|global|kernel|local|private|read_only|read_write|write_only)|_cl_(?:command_queue|context|device_id|event|kernel|mem|platform_id|program|sampler)|auto|break|case|cl_(?:image_format|mem_fence_flags)|clk_event_t|complex|const|continue|default|do|(?:float|double)(?:16(?:x(?:1|16|2|4|8))?|1x(?:1|16|2|4|8)|2(?:x(?:1|16|2|4|8))?|3|4(?:x(?:1|16|2|4|8))?|8(?:x(?:1|16|2|4|8))?)?|else|enum|event_t|extern|for|goto|(?:u?(?:char|short|int|long)|half|quad|bool)(?:2|3|4|8|16)?|if|image(?:1d_(?:array_|buffer_)?t|2d_(?:array_(?:depth_|msaa_depth_|msaa_)?|depth_|msaa_depth_|msaa_)?t|3d_t)|imaginary|inline|intptr_t|ndrange_t|packed|pipe|ptrdiff_t|queue_t|register|reserve_id_t|restrict|return|sampler_t|signed|size_t|sizeof|static|struct|switch|typedef|uintptr_t|uniform|union|unsigned|void|volatile|while)\b/,"constant-opencl-kernel":{pattern:/\b(?:CHAR_(?:BIT|MAX|MIN)|CLK_(?:ADDRESS_(?:CLAMP(?:_TO_EDGE)?|NONE|REPEAT)|FILTER_(?:LINEAR|NEAREST)|(?:LOCAL|GLOBAL)_MEM_FENCE|NORMALIZED_COORDS_(?:FALSE|TRUE))|CL_(?:BGRA|(?:HALF_)?FLOAT|INTENSITY|LUMINANCE|A?R?G?B?[Ax]?|(?:(?:UN)?SIGNED|[US]NORM)_(?:INT(?:8|16|32))|UNORM_(?:INT_101010|SHORT_(?:555|565)))|(?:DBL|FLT|HALF)_(?:DIG|EPSILON|MANT_DIG|(?:MIN|MAX)(?:(?:_10)?_EXP)?)|FLT_RADIX|HUGE_VALF?|INFINITY|(?:INT|LONG|SCHAR|SHRT)_(?:MAX|MIN)|(?:UCHAR|USHRT|UINT|ULONG)_MAX|MAXFLOAT|M_(?:[12]_PI|2_SQRTPI|E|LN(?:2|10)|LOG(?:10|2)E?|PI(?:_[24])?|SQRT(?:1_2|2))(?:_F|_H)?|NAN)\b/,alias:"constant"},boolean:/\b(?:false|true)\b/,number:/(?:\b0x(?:[\da-f]+\.?[\da-f]*|\.[\da-f]+)(?:p[+-]?\d+)?|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?)[fuhl]*/i});var attributes={"type-opencl-host":{pattern:/\b(?:cl_(?:GLenum|GLint|GLuin|addressing_mode|bitfield|bool|buffer_create_type|build_status|channel_(?:order|type)|(?:u?(?:char|short|int|long)|float|double)(?:2|3|4|8|16)?|command_(?:queue(?:_info|_properties)?|type)|context(?:_info|_properties)?|device_(?:exec_capabilities|fp_config|id|info|local_mem_type|mem_cache_type|type)|(?:event|sampler)(?:_info)?|filter_mode|half|image_info|kernel(?:_info|_work_group_info)?|map_flags|mem(?:_flags|_info|_object_type)?|platform_(?:id|info)|profiling_info|program(?:_build_info|_info)?))\b/,alias:"keyword"},"boolean-opencl-host":{pattern:/\bCL_(?:TRUE|FALSE)\b/,alias:"boolean"},"constant-opencl-host":{pattern:/\bCL_(?:A|ABGR|ADDRESS_(?:CLAMP(?:_TO_EDGE)?|MIRRORED_REPEAT|NONE|REPEAT)|ARGB|BGRA|BLOCKING|BUFFER_CREATE_TYPE_REGION|BUILD_(?:ERROR|IN_PROGRESS|NONE|PROGRAM_FAILURE|SUCCESS)|COMMAND_(?:ACQUIRE_GL_OBJECTS|BARRIER|COPY_(?:BUFFER(?:_RECT|_TO_IMAGE)?|IMAGE(?:_TO_BUFFER)?)|FILL_(?:BUFFER|IMAGE)|MAP(?:_BUFFER|_IMAGE)|MARKER|MIGRATE(?:_SVM)?_MEM_OBJECTS|NATIVE_KERNEL|NDRANGE_KERNEL|READ_(?:BUFFER(?:_RECT)?|IMAGE)|RELEASE_GL_OBJECTS|SVM_(?:FREE|MAP|MEMCPY|MEMFILL|UNMAP)|TASK|UNMAP_MEM_OBJECT|USER|WRITE_(?:BUFFER(?:_RECT)?|IMAGE))|COMPILER_NOT_AVAILABLE|COMPILE_PROGRAM_FAILURE|COMPLETE|CONTEXT_(?:DEVICES|INTEROP_USER_SYNC|NUM_DEVICES|PLATFORM|PROPERTIES|REFERENCE_COUNT)|DEPTH(?:_STENCIL)?|DEVICE_(?:ADDRESS_BITS|AFFINITY_DOMAIN_(?:L[1-4]_CACHE|NEXT_PARTITIONABLE|NUMA)|AVAILABLE|BUILT_IN_KERNELS|COMPILER_AVAILABLE|DOUBLE_FP_CONFIG|ENDIAN_LITTLE|ERROR_CORRECTION_SUPPORT|EXECUTION_CAPABILITIES|EXTENSIONS|GLOBAL_(?:MEM_(?:CACHELINE_SIZE|CACHE_SIZE|CACHE_TYPE|SIZE)|VARIABLE_PREFERRED_TOTAL_SIZE)|HOST_UNIFIED_MEMORY|IL_VERSION|IMAGE(?:2D_MAX_(?:HEIGHT|WIDTH)|3D_MAX_(?:DEPTH|HEIGHT|WIDTH)|_BASE_ADDRESS_ALIGNMENT|_MAX_ARRAY_SIZE|_MAX_BUFFER_SIZE|_PITCH_ALIGNMENT|_SUPPORT)|LINKER_AVAILABLE|LOCAL_MEM_SIZE|LOCAL_MEM_TYPE|MAX_(?:CLOCK_FREQUENCY|COMPUTE_UNITS|CONSTANT_ARGS|CONSTANT_BUFFER_SIZE|GLOBAL_VARIABLE_SIZE|MEM_ALLOC_SIZE|NUM_SUB_GROUPS|ON_DEVICE_(?:EVENTS|QUEUES)|PARAMETER_SIZE|PIPE_ARGS|READ_IMAGE_ARGS|READ_WRITE_IMAGE_ARGS|SAMPLERS|WORK_GROUP_SIZE|WORK_ITEM_DIMENSIONS|WORK_ITEM_SIZES|WRITE_IMAGE_ARGS)|MEM_BASE_ADDR_ALIGN|MIN_DATA_TYPE_ALIGN_SIZE|NAME|NATIVE_VECTOR_WIDTH_(?:CHAR|DOUBLE|FLOAT|HALF|INT|LONG|SHORT)|NOT_(?:AVAILABLE|FOUND)|OPENCL_C_VERSION|PARENT_DEVICE|PARTITION_(?:AFFINITY_DOMAIN|BY_AFFINITY_DOMAIN|BY_COUNTS|BY_COUNTS_LIST_END|EQUALLY|FAILED|MAX_SUB_DEVICES|PROPERTIES|TYPE)|PIPE_MAX_(?:ACTIVE_RESERVATIONS|PACKET_SIZE)|PLATFORM|PREFERRED_(?:GLOBAL_ATOMIC_ALIGNMENT|INTEROP_USER_SYNC|LOCAL_ATOMIC_ALIGNMENT|PLATFORM_ATOMIC_ALIGNMENT|VECTOR_WIDTH_(?:CHAR|DOUBLE|FLOAT|HALF|INT|LONG|SHORT))|PRINTF_BUFFER_SIZE|PROFILE|PROFILING_TIMER_RESOLUTION|QUEUE_(?:ON_(?:DEVICE_(?:MAX_SIZE|PREFERRED_SIZE|PROPERTIES)|HOST_PROPERTIES)|PROPERTIES)|REFERENCE_COUNT|SINGLE_FP_CONFIG|SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS|SVM_(?:ATOMICS|CAPABILITIES|COARSE_GRAIN_BUFFER|FINE_GRAIN_BUFFER|FINE_GRAIN_SYSTEM)|TYPE(?:_ACCELERATOR|_ALL|_CPU|_CUSTOM|_DEFAULT|_GPU)?|VENDOR(?:_ID)?|VERSION)|DRIVER_VERSION|EVENT_(?:COMMAND_(?:EXECUTION_STATUS|QUEUE|TYPE)|CONTEXT|REFERENCE_COUNT)|EXEC_(?:KERNEL|NATIVE_KERNEL|STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST)|FILTER_(?:LINEAR|NEAREST)|FLOAT|FP_(?:CORRECTLY_ROUNDED_DIVIDE_SQRT|DENORM|FMA|INF_NAN|ROUND_TO_INF|ROUND_TO_NEAREST|ROUND_TO_ZERO|SOFT_FLOAT)|GLOBAL|HALF_FLOAT|IMAGE_(?:ARRAY_SIZE|BUFFER|DEPTH|ELEMENT_SIZE|FORMAT|FORMAT_MISMATCH|FORMAT_NOT_SUPPORTED|HEIGHT|NUM_MIP_LEVELS|NUM_SAMPLES|ROW_PITCH|SLICE_PITCH|WIDTH)|INTENSITY|INVALID_(?:ARG_INDEX|ARG_SIZE|ARG_VALUE|BINARY|BUFFER_SIZE|BUILD_OPTIONS|COMMAND_QUEUE|COMPILER_OPTIONS|CONTEXT|DEVICE|DEVICE_PARTITION_COUNT|DEVICE_QUEUE|DEVICE_TYPE|EVENT|EVENT_WAIT_LIST|GLOBAL_OFFSET|GLOBAL_WORK_SIZE|GL_OBJECT|HOST_PTR|IMAGE_DESCRIPTOR|IMAGE_FORMAT_DESCRIPTOR|IMAGE_SIZE|KERNEL|KERNEL_ARGS|KERNEL_DEFINITION|KERNEL_NAME|LINKER_OPTIONS|MEM_OBJECT|MIP_LEVEL|OPERATION|PIPE_SIZE|PLATFORM|PROGRAM|PROGRAM_EXECUTABLE|PROPERTY|QUEUE_PROPERTIES|SAMPLER|VALUE|WORK_DIMENSION|WORK_GROUP_SIZE|WORK_ITEM_SIZE)|KERNEL_(?:ARG_(?:ACCESS_(?:NONE|QUALIFIER|READ_ONLY|READ_WRITE|WRITE_ONLY)|ADDRESS_(?:CONSTANT|GLOBAL|LOCAL|PRIVATE|QUALIFIER)|INFO_NOT_AVAILABLE|NAME|TYPE_(?:CONST|NAME|NONE|PIPE|QUALIFIER|RESTRICT|VOLATILE))|ATTRIBUTES|COMPILE_NUM_SUB_GROUPS|COMPILE_WORK_GROUP_SIZE|CONTEXT|EXEC_INFO_SVM_FINE_GRAIN_SYSTEM|EXEC_INFO_SVM_PTRS|FUNCTION_NAME|GLOBAL_WORK_SIZE|LOCAL_MEM_SIZE|LOCAL_SIZE_FOR_SUB_GROUP_COUNT|MAX_NUM_SUB_GROUPS|MAX_SUB_GROUP_SIZE_FOR_NDRANGE|NUM_ARGS|PREFERRED_WORK_GROUP_SIZE_MULTIPLE|PRIVATE_MEM_SIZE|PROGRAM|REFERENCE_COUNT|SUB_GROUP_COUNT_FOR_NDRANGE|WORK_GROUP_SIZE)|LINKER_NOT_AVAILABLE|LINK_PROGRAM_FAILURE|LOCAL|LUMINANCE|MAP_(?:FAILURE|READ|WRITE|WRITE_INVALIDATE_REGION)|MEM_(?:ALLOC_HOST_PTR|ASSOCIATED_MEMOBJECT|CONTEXT|COPY_HOST_PTR|COPY_OVERLAP|FLAGS|HOST_NO_ACCESS|HOST_PTR|HOST_READ_ONLY|HOST_WRITE_ONLY|KERNEL_READ_AND_WRITE|MAP_COUNT|OBJECT_(?:ALLOCATION_FAILURE|BUFFER|IMAGE1D|IMAGE1D_ARRAY|IMAGE1D_BUFFER|IMAGE2D|IMAGE2D_ARRAY|IMAGE3D|PIPE)|OFFSET|READ_ONLY|READ_WRITE|REFERENCE_COUNT|SIZE|SVM_ATOMICS|SVM_FINE_GRAIN_BUFFER|TYPE|USES_SVM_POINTER|USE_HOST_PTR|WRITE_ONLY)|MIGRATE_MEM_OBJECT_(?:CONTENT_UNDEFINED|HOST)|MISALIGNED_SUB_BUFFER_OFFSET|NONE|NON_BLOCKING|OUT_OF_(?:HOST_MEMORY|RESOURCES)|PIPE_(?:MAX_PACKETS|PACKET_SIZE)|PLATFORM_(?:EXTENSIONS|HOST_TIMER_RESOLUTION|NAME|PROFILE|VENDOR|VERSION)|PROFILING_(?:COMMAND_(?:COMPLETE|END|QUEUED|START|SUBMIT)|INFO_NOT_AVAILABLE)|PROGRAM_(?:BINARIES|BINARY_SIZES|BINARY_TYPE(?:_COMPILED_OBJECT|_EXECUTABLE|_LIBRARY|_NONE)?|BUILD_(?:GLOBAL_VARIABLE_TOTAL_SIZE|LOG|OPTIONS|STATUS)|CONTEXT|DEVICES|IL|KERNEL_NAMES|NUM_DEVICES|NUM_KERNELS|REFERENCE_COUNT|SOURCE)|QUEUED|QUEUE_(?:CONTEXT|DEVICE|DEVICE_DEFAULT|ON_DEVICE|ON_DEVICE_DEFAULT|OUT_OF_ORDER_EXEC_MODE_ENABLE|PROFILING_ENABLE|PROPERTIES|REFERENCE_COUNT|SIZE)|R|RA|READ_(?:ONLY|WRITE)_CACHE|RG|RGB|RGBA|RGBx|RGx|RUNNING|Rx|SAMPLER_(?:ADDRESSING_MODE|CONTEXT|FILTER_MODE|LOD_MAX|LOD_MIN|MIP_FILTER_MODE|NORMALIZED_COORDS|REFERENCE_COUNT)|(?:UN)?SIGNED_INT(?:8|16|32)|SNORM_INT(?:8|16)|SUBMITTED|SUCCESS|UNORM_INT(?:16|24|8|_101010|_101010_2)|UNORM_SHORT_(?:555|565)|VERSION_(?:1_0|1_1|1_2|2_0|2_1)|sBGRA|sRGB|sRGBA|sRGBx)\b/,alias:"constant"},"function-opencl-host":{pattern:/\bcl(?:BuildProgram|CloneKernel|CompileProgram|Create(?:Buffer|CommandQueue(?:WithProperties)?|Context|ContextFromType|Image|Image2D|Image3D|Kernel|KernelsInProgram|Pipe|ProgramWith(?:Binary|BuiltInKernels|IL|Source)|Sampler|SamplerWithProperties|SubBuffer|SubDevices|UserEvent)|Enqueue(?:(?:Barrier|Marker)(?:WithWaitList)?|Copy(?:Buffer(?:Rect|ToImage)?|Image(?:ToBuffer)?)|(?:Fill|Map)(?:Buffer|Image)|MigrateMemObjects|NDRangeKernel|NativeKernel|(?:Read|Write)(?:Buffer(?:Rect)?|Image)|SVM(?:Free|Map|MemFill|Memcpy|MigrateMem|Unmap)|Task|UnmapMemObject|WaitForEvents)|Finish|Flush|Get(?:CommandQueueInfo|ContextInfo|Device(?:AndHostTimer|IDs|Info)|Event(?:Profiling)?Info|ExtensionFunctionAddress(?:ForPlatform)?|HostTimer|ImageInfo|Kernel(?:ArgInfo|Info|SubGroupInfo|WorkGroupInfo)|MemObjectInfo|PipeInfo|Platform(?:IDs|Info)|Program(?:Build)?Info|SamplerInfo|SupportedImageFormats)|LinkProgram|(?:Release|Retain)(?:CommandQueue|Context|Device|Event|Kernel|MemObject|Program|Sampler)|SVM(?:Alloc|Free)|Set(?:CommandQueueProperty|DefaultDeviceCommandQueue|EventCallback|Kernel(?:Arg(?:SVMPointer)?|ExecInfo)|Kernel|MemObjectDestructorCallback|UserEventStatus)|Unload(?:Platform)?Compiler|WaitForEvents)\b/,alias:"function"}};Prism.languages.insertBefore("c","keyword",attributes);if(Prism.languages.cpp){attributes["type-opencl-host-cpp"]={pattern:/\b(?:Buffer|BufferGL|BufferRenderGL|CommandQueue|Context|Device|DeviceCommandQueue|EnqueueArgs|Event|Image|Image1D|Image1DArray|Image1DBuffer|Image2D|Image2DArray|Image2DGL|Image3D|Image3DGL|ImageFormat|ImageGL|Kernel|KernelFunctor|LocalSpaceArg|Memory|NDRange|Pipe|Platform|Program|Sampler|SVMAllocator|SVMTraitAtomic|SVMTraitCoarse|SVMTraitFine|SVMTraitReadOnly|SVMTraitReadWrite|SVMTraitWriteOnly|UserEvent)\b/,alias:"keyword"};Prism.languages.insertBefore("cpp","keyword",attributes)}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=oz;oz.displayName="oz";oz.aliases=[];function oz(Prism){Prism.languages.oz={comment:/\/\*[\s\S]*?\*\/|%.*/,string:{pattern:/"(?:[^"\\]|\\[\s\S])*"/,greedy:true},atom:{pattern:/'(?:[^'\\]|\\[\s\S])*'/,greedy:true,alias:"builtin"},keyword:/\$|\[\]|\b(?:_|at|attr|case|catch|choice|class|cond|declare|define|dis|else(?:case|if)?|end|export|fail|false|feat|finally|from|fun|functor|if|import|in|local|lock|meth|nil|not|of|or|prepare|proc|prop|raise|require|self|skip|then|thread|true|try|unit)\b/,function:[/\b[a-z][A-Za-z\d]*(?=\()/,{pattern:/(\{)[A-Z][A-Za-z\d]*\b/,lookbehind:true}],number:/\b(?:0[bx][\da-f]+|\d+\.?\d*(?:e~?\d+)?)\b|&(?:[^\\]|\\(?:\d{3}|.))/i,variable:/\b[A-Z][A-Za-z\d]*|`(?:[^`\\]|\\.)+`/,"attr-name":/\w+(?=:)/,operator:/:(?:=|::?)|<[-:=]?|=(?:=|<?:?)|>=?:?|\\=:?|!!?|[|#+\-*\/,~^@]|\b(?:andthen|div|mod|orelse)\b/,punctuation:/[\[\](){}.:;?]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=parigp;parigp.displayName="parigp";parigp.aliases=[];function parigp(Prism){Prism.languages.parigp={comment:/\/\*[\s\S]*?\*\/|\\\\.*/,string:{pattern:/"(?:[^"\\\r\n]|\\.)*"/,greedy:true},keyword:function(){var keywords=["breakpoint","break","dbg_down","dbg_err","dbg_up","dbg_x","forcomposite","fordiv","forell","forpart","forprime","forstep","forsubgroup","forvec","for","iferr","if","local","my","next","return","until","while"];keywords=keywords.map((function(keyword){return keyword.split("").join(" *")})).join("|");return RegExp("\\b(?:"+keywords+")\\b")}(),function:/\w[\w ]*?(?= *\()/,number:{pattern:/((?:\. *\. *)?)(?:\b\d(?: *\d)*(?: *(?!\. *\.)\.(?: *\d)*)?|\. *\d(?: *\d)*)(?: *e *[+-]? *\d(?: *\d)*)?/i,lookbehind:true},operator:/\. *\.|[*\/!](?: *=)?|%(?: *=|(?: *#)?(?: *')*)?|\+(?: *[+=])?|-(?: *[-=>])?|<(?:(?: *<)?(?: *=)?| *>)?|>(?: *>)?(?: *=)?|=(?: *=){0,2}|\\(?: *\/)?(?: *=)?|&(?: *&)?|\| *\||['#~^]/,punctuation:/[\[\]{}().,:;|]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=parser;parser.displayName="parser";parser.aliases=[];function parser(Prism){(function(Prism){var parser=Prism.languages.parser=Prism.languages.extend("markup",{keyword:{pattern:/(^|[^^])(?:\^(?:case|eval|for|if|switch|throw)\b|@(?:BASE|CLASS|GET(?:_DEFAULT)?|OPTIONS|SET_DEFAULT|USE)\b)/,lookbehind:true},variable:{pattern:/(^|[^^])\B\$(?:\w+|(?=[.{]))(?:(?:\.|::?)\w+)*(?:\.|::?)?/,lookbehind:true,inside:{punctuation:/\.|:+/}},function:{pattern:/(^|[^^])\B[@^]\w+(?:(?:\.|::?)\w+)*(?:\.|::?)?/,lookbehind:true,inside:{keyword:{pattern:/(^@)(?:GET_|SET_)/,lookbehind:true},punctuation:/\.|:+/}},escape:{pattern:/\^(?:[$^;@()\[\]{}"':]|#[a-f\d]*)/i,alias:"builtin"},punctuation:/[\[\](){};]/});parser=Prism.languages.insertBefore("parser","keyword",{"parser-comment":{pattern:/(\s)#.*/,lookbehind:true,alias:"comment"},expression:{pattern:/(^|[^^])\((?:[^()]|\((?:[^()]|\((?:[^()])*\))*\))*\)/,greedy:true,lookbehind:true,inside:{string:{pattern:/(^|[^^])(["'])(?:(?!\2)[^^]|\^[\s\S])*\2/,lookbehind:true},keyword:parser.keyword,variable:parser.variable,function:parser.function,boolean:/\b(?:true|false)\b/,number:/\b(?:0x[a-f\d]+|\d+\.?\d*(?:e[+-]?\d+)?)\b/i,escape:parser.escape,operator:/[~+*\/\\%]|!(?:\|\|?|=)?|&&?|\|\|?|==|<[<=]?|>[>=]?|-[fd]?|\b(?:def|eq|ge|gt|in|is|le|lt|ne)\b/,punctuation:parser.punctuation}}});parser=Prism.languages.insertBefore("inside","punctuation",{expression:parser.expression,keyword:parser.keyword,variable:parser.variable,function:parser.function,escape:parser.escape,"parser-punctuation":{pattern:parser.punctuation,alias:"punctuation"}},parser["tag"].inside["attr-value"])})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=pascal;pascal.displayName="pascal";pascal.aliases=["objectpascal"];function pascal(Prism){Prism.languages.pascal={comment:[/\(\*[\s\S]+?\*\)/,/\{[\s\S]+?\}/,/\/\/.*/],string:{pattern:/(?:'(?:''|[^'\r\n])*'(?!')|#[&$%]?[a-f\d]+)+|\^[a-z]/i,greedy:true},keyword:[{pattern:/(^|[^&])\b(?:absolute|array|asm|begin|case|const|constructor|destructor|do|downto|else|end|file|for|function|goto|if|implementation|inherited|inline|interface|label|nil|object|of|operator|packed|procedure|program|record|reintroduce|repeat|self|set|string|then|to|type|unit|until|uses|var|while|with)\b/i,lookbehind:true},{pattern:/(^|[^&])\b(?:dispose|exit|false|new|true)\b/i,lookbehind:true},{pattern:/(^|[^&])\b(?:class|dispinterface|except|exports|finalization|finally|initialization|inline|library|on|out|packed|property|raise|resourcestring|threadvar|try)\b/i,lookbehind:true},{pattern:/(^|[^&])\b(?:absolute|abstract|alias|assembler|bitpacked|break|cdecl|continue|cppdecl|cvar|default|deprecated|dynamic|enumerator|experimental|export|external|far|far16|forward|generic|helper|implements|index|interrupt|iochecks|local|message|name|near|nodefault|noreturn|nostackframe|oldfpccall|otherwise|overload|override|pascal|platform|private|protected|public|published|read|register|reintroduce|result|safecall|saveregisters|softfloat|specialize|static|stdcall|stored|strict|unaligned|unimplemented|varargs|virtual|write)\b/i,lookbehind:true}],number:[/(?:[&%]\d+|\$[a-f\d]+)/i,/\b\d+(?:\.\d+)?(?:e[+-]?\d+)?/i],operator:[/\.\.|\*\*|:=|<[<=>]?|>[>=]?|[+\-*\/]=?|[@^=]/i,{pattern:/(^|[^&])\b(?:and|as|div|exclude|in|include|is|mod|not|or|shl|shr|xor)\b/,lookbehind:true}],punctuation:/\(\.|\.\)|[()\[\]:;,.]/};Prism.languages.objectpascal=Prism.languages.pascal}},function(module,exports,__webpack_require__){"use strict";module.exports=pascaligo;pascaligo.displayName="pascaligo";pascaligo.aliases=[];function pascaligo(Prism){(function(Prism){var braces=/\((?:[^()]|\((?:[^()]|\([^()]*\))*\))*\)/.source;var type=/(?:\w+(?:<braces>)?|<braces>)/.source.replace(/<braces>/g,(function(){return braces}));var pascaligo=Prism.languages.pascaligo={comment:/\(\*[\s\S]+?\*\)|\/\/.*/,string:{pattern:/(["'`])(?:\\[\s\S]|(?!\1)[^\\])*\1|\^[a-z]/i,greedy:true},"class-name":[{pattern:RegExp(/(\btype\s+\w+\s+is\s+)<type>/.source.replace(/<type>/g,(function(){return type})),"i"),lookbehind:true,inside:null},{pattern:RegExp(/<type>(?=\s+is\b)/.source.replace(/<type>/g,(function(){return type})),"i"),inside:null},{pattern:RegExp(/(:\s*)<type>/.source.replace(/<type>/g,(function(){return type}))),lookbehind:true,inside:null}],keyword:{pattern:/(^|[^&])\b(?:begin|block|case|const|else|end|fail|for|from|function|if|is|nil|of|remove|return|skip|then|type|var|while|with)\b/i,lookbehind:true},boolean:{pattern:/(^|[^&])\b(?:True|False)\b/i,lookbehind:true},builtin:{pattern:/(^|[^&])\b(?:bool|int|list|map|nat|record|string|unit)\b/i,lookbehind:true},function:/\w+(?=\s*\()/i,number:[/%[01]+|&[0-7]+|\$[a-f\d]+/i,/\b\d+(?:\.\d+)?(?:e[+-]?\d+)?(?:mtz|n)?/i],operator:/->|=\/=|\.\.|\*\*|:=|<[<=>]?|>[>=]?|[+\-*\/]=?|[@^=|]|\b(?:and|mod|or)\b/,punctuation:/\(\.|\.\)|[()\[\]:;,.{}]/};var classNameInside=["comment","keyword","builtin","operator","punctuation"].reduce((function(accum,key){accum[key]=pascaligo[key];return accum}),{});pascaligo["class-name"].forEach((function(p){p.inside=classNameInside}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=pcaxis;pcaxis.displayName="pcaxis";pcaxis.aliases=["px"];function pcaxis(Prism){Prism.languages.pcaxis={string:/"[^"]*"/,keyword:{pattern:/((?:^|;)\s*)[-A-Z\d]+(?:\s*\[[-\w]+\])?(?:\s*\("[^"]*"(?:,\s*"[^"]*")*\))?(?=\s*=)/,lookbehind:true,greedy:true,inside:{keyword:/^[-A-Z\d]+/,language:{pattern:/^(\s*)\[[-\w]+\]/,lookbehind:true,inside:{punctuation:/^\[|\]$/,property:/[-\w]+/}},"sub-key":{pattern:/^(\s*)[\s\S]+/,lookbehind:true,inside:{parameter:{pattern:/"[^"]*"/,alias:"property"},punctuation:/^\(|\)$|,/}}}},operator:/=/,tlist:{pattern:/TLIST\s*\(\s*\w+(?:(?:\s*,\s*"[^"]*")+|\s*,\s*"[^"]*"-"[^"]*")?\s*\)/,greedy:true,inside:{function:/^TLIST/,property:{pattern:/^(\s*\(\s*)\w+/,lookbehind:true},string:/"[^"]*"/,punctuation:/[(),]/,operator:/-/}},punctuation:/[;,]/,number:{pattern:/(^|\s)\d+(?:\.\d+)?(?!\S)/,lookbehind:true},boolean:/YES|NO/};Prism.languages.px=Prism.languages.pcaxis}},function(module,exports,__webpack_require__){"use strict";module.exports=peoplecode;peoplecode.displayName="peoplecode";peoplecode.aliases=["pcode"];function peoplecode(Prism){Prism.languages.peoplecode={comment:RegExp([/\/\*[\s\S]*?\*\//.source,/\bREM[^;]*;/.source,/<\*(?:[^<*]|\*(?!>)|<(?!\*)|<\*(?:(?!\*>)[\s\S])*\*>)*\*>/.source,/\/\+[\s\S]*?\+\//.source].join("|")),string:{pattern:/'(?:''|[^'\r\n])*'(?!')|"(?:""|[^"\r\n])*"(?!")/,greedy:true},variable:/%\w+/,"function-definition":{pattern:/((?:^|[^\w-])(?:function|method)\s+)\w+/i,lookbehind:true,alias:"function"},"class-name":{pattern:/((?:^|[^-\w])(?:as|catch|class|component|create|extends|global|implements|instance|local|of|property|returns)\s+)\w+(?::\w+)*/i,lookbehind:true,inside:{punctuation:/:/}},keyword:/\b(?:abstract|alias|as|catch|class|component|constant|create|declare|else|end-(?:class|evaluate|for|function|get|if|method|set|try|while)|evaluate|extends|for|function|get|global|implements|import|instance|if|library|local|method|null|of|out|peopleCode|private|program|property|protected|readonly|ref|repeat|returns?|set|step|then|throw|to|try|until|value|when(?:-other)?|while)\b/i,"operator-keyword":{pattern:/\b(?:and|not|or)\b/i,alias:"operator"},function:/[_a-z]\w*(?=\s*\()/i,boolean:/\b(?:false|true)\b/i,number:/\b\d+(?:\.\d+)?\b/,operator:/<>|[<>]=?|!=|\*\*|[-+*/|=@]/,punctuation:/[:.;,()[\]]/};Prism.languages.pcode=Prism.languages.peoplecode}},function(module,exports,__webpack_require__){"use strict";module.exports=perl;perl.displayName="perl";perl.aliases=[];function perl(Prism){Prism.languages.perl={comment:[{pattern:/(^\s*)=\w+[\s\S]*?=cut.*/m,lookbehind:true},{pattern:/(^|[^\\$])#.*/,lookbehind:true}],string:[{pattern:/\b(?:q|qq|qx|qw)\s*([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1/,greedy:true},{pattern:/\b(?:q|qq|qx|qw)\s+([a-zA-Z0-9])(?:(?!\1)[^\\]|\\[\s\S])*\1/,greedy:true},{pattern:/\b(?:q|qq|qx|qw)\s*\((?:[^()\\]|\\[\s\S])*\)/,greedy:true},{pattern:/\b(?:q|qq|qx|qw)\s*\{(?:[^{}\\]|\\[\s\S])*\}/,greedy:true},{pattern:/\b(?:q|qq|qx|qw)\s*\[(?:[^[\]\\]|\\[\s\S])*\]/,greedy:true},{pattern:/\b(?:q|qq|qx|qw)\s*<(?:[^<>\\]|\\[\s\S])*>/,greedy:true},{pattern:/("|`)(?:(?!\1)[^\\]|\\[\s\S])*\1/,greedy:true},{pattern:/'(?:[^'\\\r\n]|\\.)*'/,greedy:true}],regex:[{pattern:/\b(?:m|qr)\s*([^a-zA-Z0-9\s{(\[<])(?:(?!\1)[^\\]|\\[\s\S])*\1[msixpodualngc]*/,greedy:true},{pattern:/\b(?:m|qr)\s+([a-zA-Z0-9])(?:(?!\1)[^\\]|\\[\s\S])*\1[msixpodualngc]*/,greedy:true},{pattern:/\b(?:m|qr)\s*\((?:[^()\\]|\\[\s\S])*\)[msixpodualngc]*/,greedy:true},{pattern:/\b(?:m|qr)\s*\{(?:[^{}\\]|\\[\s\S])*\}[msixpodualngc]*/,greedy:true},{pattern:/\b(?:m|qr)\s*\[(?:[^[\]\\]|\\[\s\S])*\][msixpodualngc]*/,greedy:true},{pattern:/\b(?:m|qr)\s*<(?:[^<>\\]|\\[\s\S])*>[msixpodualngc]*/,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s*([^a-zA-Z0-9\s{(\[<])(?:(?!\2)[^\\]|\\[\s\S])*\2(?:(?!\2)[^\\]|\\[\s\S])*\2[msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s+([a-zA-Z0-9])(?:(?!\2)[^\\]|\\[\s\S])*\2(?:(?!\2)[^\\]|\\[\s\S])*\2[msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s*\((?:[^()\\]|\\[\s\S])*\)\s*\((?:[^()\\]|\\[\s\S])*\)[msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s*\{(?:[^{}\\]|\\[\s\S])*\}\s*\{(?:[^{}\\]|\\[\s\S])*\}[msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s*\[(?:[^[\]\\]|\\[\s\S])*\]\s*\[(?:[^[\]\\]|\\[\s\S])*\][msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/(^|[^-]\b)(?:s|tr|y)\s*<(?:[^<>\\]|\\[\s\S])*>\s*<(?:[^<>\\]|\\[\s\S])*>[msixpodualngcer]*/,lookbehind:true,greedy:true},{pattern:/\/(?:[^\/\\\r\n]|\\.)*\/[msixpodualngc]*(?=\s*(?:$|[\r\n,.;})&|\-+*~<>!?^]|(?:lt|gt|le|ge|eq|ne|cmp|not|and|or|xor|x)\b))/,greedy:true}],variable:[/[&*$@%]\{\^[A-Z]+\}/,/[&*$@%]\^[A-Z_]/,/[&*$@%]#?(?=\{)/,/[&*$@%]#?(?:(?:::)*'?(?!\d)[\w$]+)+(?:::)*/i,/[&*$@%]\d+/,/(?!%=)[$@%][!"#$%&'()*+,\-.\/:;<=>?@[\\\]^_`{|}~]/],filehandle:{pattern:/<(?![<=])\S*>|\b_\b/,alias:"symbol"},vstring:{pattern:/v\d+(?:\.\d+)*|\d+(?:\.\d+){2,}/,alias:"string"},function:{pattern:/sub [a-z0-9_]+/i,inside:{keyword:/sub/}},keyword:/\b(?:any|break|continue|default|delete|die|do|else|elsif|eval|for|foreach|given|goto|if|last|local|my|next|our|package|print|redo|require|return|say|state|sub|switch|undef|unless|until|use|when|while)\b/,number:/\b(?:0x[\dA-Fa-f](?:_?[\dA-Fa-f])*|0b[01](?:_?[01])*|(?:\d(?:_?\d)*)?\.?\d(?:_?\d)*(?:[Ee][+-]?\d+)?)\b/,operator:/-[rwxoRWXOezsfdlpSbctugkTBMAC]\b|\+[+=]?|-[-=>]?|\*\*?=?|\/\/?=?|=[=~>]?|~[~=]?|\|\|?=?|&&?=?|<(?:=>?|<=?)?|>>?=?|![~=]?|[%^]=?|\.(?:=|\.\.?)?|[\\?]|\bx(?:=|\b)|\b(?:lt|gt|le|ge|eq|ne|cmp|not|and|or|xor)\b/,punctuation:/[{}[\];(),:]/}}},function(module,exports,__webpack_require__){"use strict";var refractorPhp=__webpack_require__(117);module.exports=phpExtras;phpExtras.displayName="phpExtras";phpExtras.aliases=[];function phpExtras(Prism){Prism.register(refractorPhp);Prism.languages.insertBefore("php","variable",{this:/\$this\b/,global:/\$(?:_(?:SERVER|GET|POST|FILES|REQUEST|SESSION|ENV|COOKIE)|GLOBALS|HTTP_RAW_POST_DATA|argc|argv|php_errormsg|http_response_header)\b/,scope:{pattern:/\b[\w\\]+::/,inside:{keyword:/static|self|parent/,punctuation:/::|\\/}}})}},function(module,exports,__webpack_require__){"use strict";var refractorPhp=__webpack_require__(117);var refractorJavadoclike=__webpack_require__(116);module.exports=phpdoc;phpdoc.displayName="phpdoc";phpdoc.aliases=[];function phpdoc(Prism){Prism.register(refractorPhp);Prism.register(refractorJavadoclike);(function(Prism){var typeExpression=/(?:\b[a-zA-Z]\w*|[|\\[\]])+/.source;Prism.languages.phpdoc=Prism.languages.extend("javadoclike",{parameter:{pattern:RegExp("(@(?:global|param|property(?:-read|-write)?|var)\\s+(?:"+typeExpression+"\\s+)?)\\$\\w+"),lookbehind:true}});Prism.languages.insertBefore("phpdoc","keyword",{"class-name":[{pattern:RegExp("(@(?:global|package|param|property(?:-read|-write)?|return|subpackage|throws|var)\\s+)"+typeExpression),lookbehind:true,inside:{keyword:/\b(?:callback|resource|boolean|integer|double|object|string|array|false|float|mixed|bool|null|self|true|void|int)\b/,punctuation:/[|\\[\]()]/}}]});Prism.languages.javadoclike.addSupport("php",Prism.languages.phpdoc)})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorSql=__webpack_require__(182);module.exports=plsql;plsql.displayName="plsql";plsql.aliases=[];function plsql(Prism){Prism.register(refractorSql);(function(Prism){var plsql=Prism.languages.plsql=Prism.languages.extend("sql",{comment:[/\/\*[\s\S]*?\*\//,/--.*/]});var keyword=plsql["keyword"];if(!Array.isArray(keyword)){keyword=plsql["keyword"]=[keyword]}keyword.unshift(/\b(?:ACCESS|AGENT|AGGREGATE|ARRAY|ARROW|AT|ATTRIBUTE|AUDIT|AUTHID|BFILE_BASE|BLOB_BASE|BLOCK|BODY|BOTH|BOUND|BYTE|CALLING|CHAR_BASE|CHARSET(?:FORM|ID)|CLOB_BASE|COLAUTH|COLLECT|CLUSTERS?|COMPILED|COMPRESS|CONSTANT|CONSTRUCTOR|CONTEXT|CRASH|CUSTOMDATUM|DANGLING|DATE_BASE|DEFINE|DETERMINISTIC|DURATION|ELEMENT|EMPTY|EXCEPTIONS?|EXCLUSIVE|EXTERNAL|FINAL|FORALL|FORM|FOUND|GENERAL|HEAP|HIDDEN|IDENTIFIED|IMMEDIATE|INCLUDING|INCREMENT|INDICATOR|INDEXES|INDICES|INFINITE|INITIAL|ISOPEN|INSTANTIABLE|INTERFACE|INVALIDATE|JAVA|LARGE|LEADING|LENGTH|LIBRARY|LIKE[24C]|LIMITED|LONG|LOOP|MAP|MAXEXTENTS|MAXLEN|MEMBER|MINUS|MLSLABEL|MULTISET|NAME|NAN|NATIVE|NEW|NOAUDIT|NOCOMPRESS|NOCOPY|NOTFOUND|NOWAIT|NUMBER(?:_BASE)?|OBJECT|OCI(?:COLL|DATE|DATETIME|DURATION|INTERVAL|LOBLOCATOR|NUMBER|RAW|REF|REFCURSOR|ROWID|STRING|TYPE)|OFFLINE|ONLINE|ONLY|OPAQUE|OPERATOR|ORACLE|ORADATA|ORGANIZATION|ORL(?:ANY|VARY)|OTHERS|OVERLAPS|OVERRIDING|PACKAGE|PARALLEL_ENABLE|PARAMETERS?|PASCAL|PCTFREE|PIPE(?:LINED)?|PRAGMA|PRIOR|PRIVATE|RAISE|RANGE|RAW|RECORD|REF|REFERENCE|REM|REMAINDER|RESULT|RESOURCE|RETURNING|REVERSE|ROW(?:ID|NUM|TYPE)|SAMPLE|SB[124]|SEGMENT|SELF|SEPARATE|SEQUENCE|SHORT|SIZE(?:_T)?|SPARSE|SQL(?:CODE|DATA|NAME|STATE)|STANDARD|STATIC|STDDEV|STORED|STRING|STRUCT|STYLE|SUBMULTISET|SUBPARTITION|SUBSTITUTABLE|SUBTYPE|SUCCESSFUL|SYNONYM|SYSDATE|TABAUTH|TDO|THE|TIMEZONE_(?:ABBR|HOUR|MINUTE|REGION)|TRAILING|TRANSAC(?:TIONAL)?|TRUSTED|UB[124]|UID|UNDER|UNTRUSTED|VALIDATE|VALIST|VARCHAR2|VARIABLE|VARIANCE|VARRAY|VIEWS|VOID|WHENEVER|WRAPPED|ZONE)\b/i);var operator=plsql["operator"];if(!Array.isArray(operator)){operator=plsql["operator"]=[operator]}operator.unshift(/:=/)})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=powerquery;powerquery.displayName="powerquery";powerquery.aliases=[];function powerquery(Prism){Prism.languages.powerquery={comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|(?:\/\/).*)/,lookbehind:true},"quoted-identifier":{pattern:/#"(?:[^"\r\n]|"")*"(?!")/,greedy:true,alias:"variable"},string:{pattern:/"(?:[^"\r\n]|"")*"(?!")/,greedy:true},constant:[/\bDay\.(?:Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday)\b/,/\bTraceLevel\.(?:Critical|Error|Information|Verbose|Warning)\b/,/\bOccurrence\.(?:First|Last|All)\b/,/\bOrder\.(?:Ascending|Descending)\b/,/\bRoundingMode\.(?:AwayFromZero|Down|ToEven|TowardZero|Up)\b/,/\bMissingField\.(?:Error|Ignore|UseNull)\b/,/\bQuoteStyle\.(?:Csv|None)\b/,/\bJoinKind\.(?:Inner|LeftOuter|RightOuter|FullOuter|LeftAnti|RightAnti)\b/,/\bGroupKind\.(?:Global|Local)\b/,/\bExtraValues\.(?:List|Ignore|Error)\b/,/\bJoinAlgorithm\.(?:Dynamic|PairwiseHash|SortMerge|LeftHash|RightHash|LeftIndex|RightIndex)\b/,/\bJoinSide\.(?:Left|Right)\b/,/\bPrecision\.(?:Double|Decimal)\b/,/\bRelativePosition\.From(?:End|Start)\b/,/\bTextEncoding\.(?:Ascii|BigEndianUnicode|Unicode|Utf8|Utf16|Windows)\b/,/\b(?:Any|Binary|Date|DateTime|DateTimeZone|Duration|Int8|Int16|Int32|Int64|Function|List|Logical|None|Number|Record|Table|Text|Time)\.Type\b/,/\bnull\b/],boolean:/\b(?:true|false)\b/,keyword:/\b(?:and|as|each|else|error|if|in|is|let|meta|not|nullable|optional|or|otherwise|section|shared|then|try|type)\b|#(?:binary|date|datetime|datetimezone|duration|infinity|nan|sections|shared|table|time)\b/,function:{pattern:/(^|[^#\w.])(?!\d)[\w.]+(?=\s*\()/,lookbehind:true},"data-type":{pattern:/\b(?:any|anynonnull|binary|date|datetime|datetimezone|duration|function|list|logical|none|number|record|table|text|time|type)\b/,alias:"variable"},number:{pattern:/\b0x[\da-f]+\b|(?:[+-]?(?:\b\d+\.)?\b\d+|[+-]\.\d+|(^|[^.])\B\.\d+)(?:e[+-]?\d+)?\b/i,lookbehind:true},operator:/[-+*\/&?@^]|<(?:=>?|>)?|>=?|=>?|\.\.\.?/,punctuation:/[,;\[\](){}]/};Prism.languages.pq=Prism.languages["powerquery"];Prism.languages.mscript=Prism.languages["powerquery"]}},function(module,exports,__webpack_require__){"use strict";module.exports=powershell;powershell.displayName="powershell";powershell.aliases=[];function powershell(Prism){(function(Prism){var powershell=Prism.languages.powershell={comment:[{pattern:/(^|[^`])<#[\s\S]*?#>/,lookbehind:true},{pattern:/(^|[^`])#.*/,lookbehind:true}],string:[{pattern:/"(?:`[\s\S]|[^`"])*"/,greedy:true,inside:{function:{pattern:/(^|[^`])\$\((?:\$\([^\r\n()]*\)|(?!\$\()[^\r\n)])*\)/,lookbehind:true,inside:{}}}},{pattern:/'(?:[^']|'')*'/,greedy:true}],namespace:/\[[a-z](?:\[(?:\[[^\]]*]|[^\[\]])*]|[^\[\]])*]/i,boolean:/\$(?:true|false)\b/i,variable:/\$\w+\b/,function:[/\b(?:Add|Approve|Assert|Backup|Block|Checkpoint|Clear|Close|Compare|Complete|Compress|Confirm|Connect|Convert|ConvertFrom|ConvertTo|Copy|Debug|Deny|Disable|Disconnect|Dismount|Edit|Enable|Enter|Exit|Expand|Export|Find|ForEach|Format|Get|Grant|Group|Hide|Import|Initialize|Install|Invoke|Join|Limit|Lock|Measure|Merge|Move|New|Open|Optimize|Out|Ping|Pop|Protect|Publish|Push|Read|Receive|Redo|Register|Remove|Rename|Repair|Request|Reset|Resize|Resolve|Restart|Restore|Resume|Revoke|Save|Search|Select|Send|Set|Show|Skip|Sort|Split|Start|Step|Stop|Submit|Suspend|Switch|Sync|Tee|Test|Trace|Unblock|Undo|Uninstall|Unlock|Unprotect|Unpublish|Unregister|Update|Use|Wait|Watch|Where|Write)-[a-z]+\b/i,/\b(?:ac|cat|chdir|clc|cli|clp|clv|compare|copy|cp|cpi|cpp|cvpa|dbp|del|diff|dir|ebp|echo|epal|epcsv|epsn|erase|fc|fl|ft|fw|gal|gbp|gc|gci|gcs|gdr|gi|gl|gm|gp|gps|group|gsv|gu|gv|gwmi|iex|ii|ipal|ipcsv|ipsn|irm|iwmi|iwr|kill|lp|ls|measure|mi|mount|move|mp|mv|nal|ndr|ni|nv|ogv|popd|ps|pushd|pwd|rbp|rd|rdr|ren|ri|rm|rmdir|rni|rnp|rp|rv|rvpa|rwmi|sal|saps|sasv|sbp|sc|select|set|shcm|si|sl|sleep|sls|sort|sp|spps|spsv|start|sv|swmi|tee|trcm|type|write)\b/i],keyword:/\b(?:Begin|Break|Catch|Class|Continue|Data|Define|Do|DynamicParam|Else|ElseIf|End|Exit|Filter|Finally|For|ForEach|From|Function|If|InlineScript|Parallel|Param|Process|Return|Sequence|Switch|Throw|Trap|Try|Until|Using|Var|While|Workflow)\b/i,operator:{pattern:/(\W?)(?:!|-(?:eq|ne|gt|ge|lt|le|sh[lr]|not|b?(?:and|x?or)|(?:Not)?(?:Like|Match|Contains|In)|Replace|Join|is(?:Not)?|as)\b|-[-=]?|\+[+=]?|[*\/%]=?)/i,lookbehind:true},punctuation:/[|{}[\];(),.]/};var stringInside=powershell.string[0].inside;stringInside.boolean=powershell.boolean;stringInside.variable=powershell.variable;stringInside.function.inside=powershell})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=processing;processing.displayName="processing";processing.aliases=[];function processing(Prism){Prism.languages.processing=Prism.languages.extend("clike",{keyword:/\b(?:break|catch|case|class|continue|default|else|extends|final|for|if|implements|import|new|null|private|public|return|static|super|switch|this|try|void|while)\b/,operator:/<[<=]?|>[>=]?|&&?|\|\|?|[%?]|[!=+\-*\/]=?/});Prism.languages.insertBefore("processing","number",{constant:/\b(?!XML\b)[A-Z][A-Z\d_]+\b/,type:{pattern:/\b(?:boolean|byte|char|color|double|float|int|[A-Z]\w*)\b/,alias:"variable"}});Prism.languages.processing["function"]=/\w+(?=\s*\()/;Prism.languages.processing["class-name"].alias="variable"}},function(module,exports,__webpack_require__){"use strict";module.exports=prolog;prolog.displayName="prolog";prolog.aliases=[];function prolog(Prism){Prism.languages.prolog={comment:[/%.+/,/\/\*[\s\S]*?\*\//],string:{pattern:/(["'])(?:\1\1|\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},builtin:/\b(?:fx|fy|xf[xy]?|yfx?)\b/,variable:/\b[A-Z_]\w*/,function:/\b[a-z]\w*(?:(?=\()|\/\d+)/,number:/\b\d+\.?\d*/,operator:/[:\\=><\-?*@\/;+^|!$.]+|\b(?:is|mod|not|xor)\b/,punctuation:/[(){}\[\],]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=properties;properties.displayName="properties";properties.aliases=[];function properties(Prism){Prism.languages.properties={comment:/^[ \t]*[#!].*$/m,"attr-value":{pattern:/(^[ \t]*(?:\\(?:\r\n|[\s\S])|[^\\\s:=])+?(?: *[=:] *| ))(?:\\(?:\r\n|[\s\S])|[^\\\r\n])+/m,lookbehind:true},"attr-name":/^[ \t]*(?:\\(?:\r\n|[\s\S])|[^\\\s:=])+?(?= *[=:] *| )/m,punctuation:/[=:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=protobuf;protobuf.displayName="protobuf";protobuf.aliases=[];function protobuf(Prism){(function(Prism){var builtinTypes=/\b(?:double|float|[su]?int(?:32|64)|s?fixed(?:32|64)|bool|string|bytes)\b/;Prism.languages.protobuf=Prism.languages.extend("clike",{"class-name":[{pattern:/(\b(?:enum|extend|message|service)\s+)[A-Za-z_]\w*(?=\s*\{)/,lookbehind:true},{pattern:/(\b(?:rpc\s+\w+|returns)\s*\(\s*(?:stream\s+)?)\.?[A-Za-z_]\w*(?:\.[A-Za-z_]\w*)*(?=\s*\))/,lookbehind:true}],keyword:/\b(?:enum|extend|extensions|import|message|oneof|option|optional|package|public|repeated|required|reserved|returns|rpc(?=\s+\w)|service|stream|syntax|to)\b(?!\s*=\s*\d)/,function:/[a-z_]\w*(?=\s*\()/i});Prism.languages.insertBefore("protobuf","operator",{map:{pattern:/\bmap<\s*[\w.]+\s*,\s*[\w.]+\s*>(?=\s+[a-z_]\w*\s*[=;])/i,alias:"class-name",inside:{punctuation:/[<>.,]/,builtin:builtinTypes}},builtin:builtinTypes,"positional-class-name":{pattern:/(?:\b|\B\.)[a-z_]\w*(?:\.[a-z_]\w*)*(?=\s+[a-z_]\w*\s*[=;])/i,alias:"class-name",inside:{punctuation:/\./}},annotation:{pattern:/(\[\s*)[a-z_]\w*(?=\s*=)/i,lookbehind:true}})})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=pug;pug.displayName="pug";pug.aliases=[];function pug(Prism){(function(Prism){Prism.languages.pug={comment:{pattern:/(^([\t ]*))\/\/.*(?:(?:\r?\n|\r)\2[\t ]+.+)*/m,lookbehind:true},"multiline-script":{pattern:/(^([\t ]*)script\b.*\.[\t ]*)(?:(?:\r?\n|\r(?!\n))(?:\2[\t ]+.+|\s*?(?=\r?\n|\r)))+/m,lookbehind:true,inside:Prism.languages.javascript},filter:{pattern:/(^([\t ]*)):.+(?:(?:\r?\n|\r(?!\n))(?:\2[\t ]+.+|\s*?(?=\r?\n|\r)))+/m,lookbehind:true,inside:{"filter-name":{pattern:/^:[\w-]+/,alias:"variable"}}},"multiline-plain-text":{pattern:/(^([\t ]*)[\w\-#.]+\.[\t ]*)(?:(?:\r?\n|\r(?!\n))(?:\2[\t ]+.+|\s*?(?=\r?\n|\r)))+/m,lookbehind:true},markup:{pattern:/(^[\t ]*)<.+/m,lookbehind:true,inside:Prism.languages.markup},doctype:{pattern:/((?:^|\n)[\t ]*)doctype(?: .+)?/,lookbehind:true},"flow-control":{pattern:/(^[\t ]*)(?:if|unless|else|case|when|default|each|while)\b(?: .+)?/m,lookbehind:true,inside:{each:{pattern:/^each .+? in\b/,inside:{keyword:/\b(?:each|in)\b/,punctuation:/,/}},branch:{pattern:/^(?:if|unless|else|case|when|default|while)\b/,alias:"keyword"},rest:Prism.languages.javascript}},keyword:{pattern:/(^[\t ]*)(?:block|extends|include|append|prepend)\b.+/m,lookbehind:true},mixin:[{pattern:/(^[\t ]*)mixin .+/m,lookbehind:true,inside:{keyword:/^mixin/,function:/\w+(?=\s*\(|\s*$)/,punctuation:/[(),.]/}},{pattern:/(^[\t ]*)\+.+/m,lookbehind:true,inside:{name:{pattern:/^\+\w+/,alias:"function"},rest:Prism.languages.javascript}}],script:{pattern:/(^[\t ]*script(?:(?:&[^(]+)?\([^)]+\))*[\t ]+).+/m,lookbehind:true,inside:Prism.languages.javascript},"plain-text":{pattern:/(^[\t ]*(?!-)[\w\-#.]*[\w\-](?:(?:&[^(]+)?\([^)]+\))*\/?[\t ]+).+/m,lookbehind:true},tag:{pattern:/(^[\t ]*)(?!-)[\w\-#.]*[\w\-](?:(?:&[^(]+)?\([^)]+\))*\/?:?/m,lookbehind:true,inside:{attributes:[{pattern:/&[^(]+\([^)]+\)/,inside:Prism.languages.javascript},{pattern:/\([^)]+\)/,inside:{"attr-value":{pattern:/(=\s*)(?:\{[^}]*\}|[^,)\r\n]+)/,lookbehind:true,inside:Prism.languages.javascript},"attr-name":/[\w-]+(?=\s*!?=|\s*[,)])/,punctuation:/[!=(),]+/}}],punctuation:/:/,"attr-id":/#[\w\-]+/,"attr-class":/\.[\w\-]+/}},code:[{pattern:/(^[\t ]*(?:-|!?=)).+/m,lookbehind:true,inside:Prism.languages.javascript}],punctuation:/[.\-!=|]+/};var filter_pattern=/(^([\t ]*)):{{filter_name}}(?:(?:\r?\n|\r(?!\n))(?:\2[\t ]+.+|\s*?(?=\r?\n|\r)))+/.source;var filters=[{filter:"atpl",language:"twig"},{filter:"coffee",language:"coffeescript"},"ejs","handlebars","less","livescript","markdown",{filter:"sass",language:"scss"},"stylus"];var all_filters={};for(var i=0,l=filters.length;i<l;i++){var filter=filters[i];filter=typeof filter==="string"?{filter:filter,language:filter}:filter;if(Prism.languages[filter.language]){all_filters["filter-"+filter.filter]={pattern:RegExp(filter_pattern.replace("{{filter_name}}",(function(){return filter.filter})),"m"),lookbehind:true,inside:{"filter-name":{pattern:/^:[\w-]+/,alias:"variable"},rest:Prism.languages[filter.language]}}}}Prism.languages.insertBefore("pug","filter",all_filters)})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=puppet;puppet.displayName="puppet";puppet.aliases=[];function puppet(Prism){(function(Prism){Prism.languages.puppet={heredoc:[{pattern:/(@\("([^"\r\n\/):]+)"(?:\/[nrts$uL]*)?\).*(?:\r?\n|\r))(?:.*(?:\r?\n|\r))*?[ \t]*\|?[ \t]*-?[ \t]*\2/,lookbehind:true,alias:"string",inside:{punctuation:/(?=\S).*\S(?= *$)/}},{pattern:/(@\(([^"\r\n\/):]+)(?:\/[nrts$uL]*)?\).*(?:\r?\n|\r))(?:.*(?:\r?\n|\r))*?[ \t]*\|?[ \t]*-?[ \t]*\2/,lookbehind:true,greedy:true,alias:"string",inside:{punctuation:/(?=\S).*\S(?= *$)/}},{pattern:/@\("?(?:[^"\r\n\/):]+)"?(?:\/[nrts$uL]*)?\)/,alias:"string",inside:{punctuation:{pattern:/(\().+?(?=\))/,lookbehind:true}}}],"multiline-comment":{pattern:/(^|[^\\])\/\*[\s\S]*?\*\//,lookbehind:true,greedy:true,alias:"comment"},regex:{pattern:/((?:\bnode\s+|[~=\(\[\{,]\s*|[=+]>\s*|^\s*))\/(?:[^\/\\]|\\[\s\S])+\/(?:[imx]+\b|\B)/,lookbehind:true,greedy:true,inside:{"extended-regex":{pattern:/^\/(?:[^\/\\]|\\[\s\S])+\/[im]*x[im]*$/,inside:{comment:/#.*/}}}},comment:{pattern:/(^|[^\\])#.*/,lookbehind:true,greedy:true},string:{pattern:/(["'])(?:\$\{(?:[^'"}]|(["'])(?:(?!\2)[^\\]|\\[\s\S])*\2)+\}|(?!\1)[^\\]|\\[\s\S])*\1/,greedy:true,inside:{"double-quoted":{pattern:/^"[\s\S]*"$/,inside:{}}}},variable:{pattern:/\$(?:::)?\w+(?:::\w+)*/,inside:{punctuation:/::/}},"attr-name":/(?:\w+|\*)(?=\s*=>)/,function:[{pattern:/(\.)(?!\d)\w+/,lookbehind:true},/\b(?:contain|debug|err|fail|include|info|notice|realize|require|tag|warning)\b|\b(?!\d)\w+(?=\()/],number:/\b(?:0x[a-f\d]+|\d+(?:\.\d+)?(?:e-?\d+)?)\b/i,boolean:/\b(?:true|false)\b/,keyword:/\b(?:application|attr|case|class|consumes|default|define|else|elsif|function|if|import|inherits|node|private|produces|type|undef|unless)\b/,datatype:{pattern:/\b(?:Any|Array|Boolean|Callable|Catalogentry|Class|Collection|Data|Default|Enum|Float|Hash|Integer|NotUndef|Numeric|Optional|Pattern|Regexp|Resource|Runtime|Scalar|String|Struct|Tuple|Type|Undef|Variant)\b/,alias:"symbol"},operator:/=[=~>]?|![=~]?|<(?:<\|?|[=~|-])?|>[>=]?|->?|~>|\|>?>?|[*\/%+?]|\b(?:and|in|or)\b/,punctuation:/[\[\]{}().,;]|:+/};var interpolation=[{pattern:/(^|[^\\])\$\{(?:[^'"{}]|\{[^}]*\}|(["'])(?:(?!\2)[^\\]|\\[\s\S])*\2)+\}/,lookbehind:true,inside:{"short-variable":{pattern:/(^\$\{)(?!\w+\()(?:::)?\w+(?:::\w+)*/,lookbehind:true,alias:"variable",inside:{punctuation:/::/}},delimiter:{pattern:/^\$/,alias:"variable"},rest:Prism.languages.puppet}},{pattern:/(^|[^\\])\$(?:::)?\w+(?:::\w+)*/,lookbehind:true,alias:"variable",inside:{punctuation:/::/}}];Prism.languages.puppet["heredoc"][0].inside.interpolation=interpolation;Prism.languages.puppet["string"].inside["double-quoted"].inside.interpolation=interpolation})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=pure;pure.displayName="pure";pure.aliases=[];function pure(Prism){(function(Prism){Prism.languages.pure={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?\*\//,lookbehind:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true},/#!.+/],"inline-lang":{pattern:/%<[\s\S]+?%>/,greedy:true,inside:{lang:{pattern:/(^%< *)-\*-.+?-\*-/,lookbehind:true,alias:"comment"},delimiter:{pattern:/^%<.*|%>$/,alias:"punctuation"}}},string:{pattern:/"(?:\\.|[^"\\\r\n])*"/,greedy:true},number:{pattern:/((?:\.\.)?)(?:\b(?:inf|nan)\b|\b0x[\da-f]+|(?:\b(?:0b)?\d+(?:\.\d)?|\B\.\d)\d*(?:e[+-]?\d+)?L?)/i,lookbehind:true},keyword:/\b(?:ans|break|bt|case|catch|cd|clear|const|def|del|dump|else|end|exit|extern|false|force|help|if|infix[lr]?|interface|let|ls|mem|namespace|nonfix|NULL|of|otherwise|outfix|override|postfix|prefix|private|public|pwd|quit|run|save|show|stats|then|throw|trace|true|type|underride|using|when|with)\b/,function:/\b(?:abs|add_(?:(?:fundef|interface|macdef|typedef)(?:_at)?|addr|constdef|vardef)|all|any|applp?|arity|bigintp?|blob(?:_crc|_size|p)?|boolp?|byte_(?:matrix|pointer)|byte_c?string(?:_pointer)?|calloc|cat|catmap|ceil|char[ps]?|check_ptrtag|chr|clear_sentry|clearsym|closurep?|cmatrixp?|cols?|colcat(?:map)?|colmap|colrev|colvector(?:p|seq)?|complex(?:_float_(?:matrix|pointer)|_matrix(?:_view)?|_pointer|p)?|conj|cookedp?|cst|cstring(?:_(?:dup|list|vector))?|curry3?|cyclen?|del_(?:constdef|fundef|interface|macdef|typedef|vardef)|delete|diag(?:mat)?|dim|dmatrixp?|do|double(?:_matrix(?:_view)?|_pointer|p)?|dowith3?|drop|dropwhile|eval(?:cmd)?|exactp|filter|fix|fixity|flip|float(?:_matrix|_pointer)|floor|fold[lr]1?|frac|free|funp?|functionp?|gcd|get(?:_(?:byte|constdef|double|float|fundef|int(?:64)?|interface(?:_typedef)?|long|macdef|pointer|ptrtag|short|sentry|string|typedef|vardef))?|globsym|hash|head|id|im|imatrixp?|index|inexactp|infp|init|insert|int(?:_matrix(?:_view)?|_pointer|p)?|int64_(?:matrix|pointer)|integerp?|iteraten?|iterwhile|join|keys?|lambdap?|last(?:err(?:pos)?)?|lcd|list[2p]?|listmap|make_ptrtag|malloc|map|matcat|matrixp?|max|member|min|nanp|nargs|nmatrixp?|null|numberp?|ord|pack(?:ed)?|pointer(?:_cast|_tag|_type|p)?|pow|pred|ptrtag|put(?:_(?:byte|double|float|int(?:64)?|long|pointer|short|string))?|rationalp?|re|realp?|realloc|recordp?|redim|reduce(?:_with)?|refp?|repeatn?|reverse|rlistp?|round|rows?|rowcat(?:map)?|rowmap|rowrev|rowvector(?:p|seq)?|same|scan[lr]1?|sentry|sgn|short_(?:matrix|pointer)|slice|smatrixp?|sort|split|str|strcat|stream|stride|string(?:_(?:dup|list|vector)|p)?|subdiag(?:mat)?|submat|subseq2?|substr|succ|supdiag(?:mat)?|symbolp?|tail|take|takewhile|thunkp?|transpose|trunc|tuplep?|typep|ubyte|uint(?:64)?|ulong|uncurry3?|unref|unzip3?|update|ushort|vals?|varp?|vector(?:p|seq)?|void|zip3?|zipwith3?)\b/,special:{pattern:/\b__[a-z]+__\b/i,alias:"builtin"},operator:/(?:[!"#$%&'*+,\-.\/:<=>?@\\^`|~\u00a1-\u00bf\u00d7-\u00f7\u20d0-\u2bff]|\b_+\b)+|\b(?:and|div|mod|not|or)\b/,punctuation:/[(){}\[\];,|]/};var inlineLanguages=["c",{lang:"c++",alias:"cpp"},"fortran"];var inlineLanguageRe=/%< *-\*- *{lang}\d* *-\*-[\s\S]+?%>/.source;inlineLanguages.forEach((function(lang){var alias=lang;if(typeof lang!=="string"){alias=lang.alias;lang=lang.lang}if(Prism.languages[alias]){var o={};o["inline-lang-"+alias]={pattern:RegExp(inlineLanguageRe.replace("{lang}",lang.replace(/([.+*?\/\\(){}\[\]])/g,"\\$1")),"i"),inside:Prism.util.clone(Prism.languages.pure["inline-lang"].inside)};o["inline-lang-"+alias].inside.rest=Prism.util.clone(Prism.languages[alias]);Prism.languages.insertBefore("pure","inline-lang",o)}}));if(Prism.languages.c){Prism.languages.pure["inline-lang"].inside.rest=Prism.util.clone(Prism.languages.c)}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=purebasic;purebasic.displayName="purebasic";purebasic.aliases=[];function purebasic(Prism){Prism.languages.purebasic=Prism.languages.extend("clike",{comment:/;.*/,keyword:/\b(?:declarecdll|declaredll|compilerselect|compilercase|compilerdefault|compilerendselect|compilererror|enableexplicit|disableexplicit|not|and|or|xor|calldebugger|debuglevel|enabledebugger|disabledebugger|restore|read|includepath|includebinary|threaded|runtime|with|endwith|structureunion|endstructureunion|align|newlist|newmap|interface|endinterface|extends|enumeration|endenumeration|swap|foreach|continue|fakereturn|goto|gosub|return|break|module|endmodule|declaremodule|enddeclaremodule|declare|declarec|prototype|prototypec|enableasm|disableasm|dim|redim|data|datasection|enddatasection|to|procedurereturn|debug|default|case|select|endselect|as|import|endimport|importc|compilerif|compilerelse|compilerendif|compilerelseif|end|structure|endstructure|while|wend|for|next|step|if|else|elseif|endif|repeat|until|procedure|proceduredll|procedurec|procedurecdll|endprocedure|protected|shared|static|global|define|includefile|xincludefile|macro|endmacro)\b/i,function:/\b\w+(?:\.\w+)?\s*(?=\()/,number:/(?:\$[\da-f]+|\b-?\d*\.?\d+(?:e[+-]?\d+)?)\b/i,operator:/(?:@\*?|\?|\*)\w+|-[>-]?|\+\+?|!=?|<<?=?|>>?=?|==?|&&?|\|?\||[~^%?*/@]/});Prism.languages.insertBefore("purebasic","keyword",{tag:/#\w+/,asm:{pattern:/(^\s*)!.*/m,lookbehind:true,alias:"tag",inside:{comment:/;.*/,string:{pattern:/(["'`])(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},"label-reference-anonymous":{pattern:/(\s*!\s*j[a-z]+\s+)@[fb]/i,lookbehind:true,alias:"fasm-label"},"label-reference-addressed":{pattern:/(\s*!\s*j[a-z]+\s+)[A-Z._?$@][\w.?$@~#]*/i,lookbehind:true,alias:"fasm-label"},function:{pattern:/^(\s*!\s*)[\da-z]+(?=\s|$)/im,lookbehind:true},"function-inline":{pattern:/(\s*:\s*)[\da-z]+(?=\s)/i,lookbehind:true,alias:"function"},label:{pattern:/^(\s*!\s*)[A-Za-z._?$@][\w.?$@~#]*(?=:)/m,lookbehind:true,alias:"fasm-label"},keyword:[/(?:extern|global)[^;\r\n]*/i,/(?:CPU|FLOAT|DEFAULT).*/],register:/\b(?:st\d|[xyz]mm\d\d?|[cdt]r\d|r\d\d?[bwd]?|[er]?[abcd]x|[abcd][hl]|[er]?(?:bp|sp|si|di)|[cdefgs]s|mm\d+)\b/i,number:/(?:\b|-|(?=\$))(?:0[hx][\da-f]*\.?[\da-f]+(?:p[+-]?\d+)?|\d[\da-f]+[hx]|\$\d[\da-f]*|0[oq][0-7]+|[0-7]+[oq]|0[by][01]+|[01]+[by]|0[dt]\d+|\d*\.?\d+(?:\.?e[+-]?\d+)?[dt]?)\b/i,operator:/[\[\]*+\-/%<>=&|$!,.:]/}}});delete Prism.languages.purebasic["class-name"];delete Prism.languages.purebasic["boolean"];Prism.languages.pbfasm=Prism.languages["purebasic"]}},function(module,exports,__webpack_require__){"use strict";var refractorHaskell=__webpack_require__(180);module.exports=purescript;purescript.displayName="purescript";purescript.aliases=["purs"];function purescript(Prism){Prism.register(refractorHaskell);Prism.languages.purescript=Prism.languages.extend("haskell",{keyword:/\b(?:ado|case|class|data|derive|do|else|forall|if|in|infixl|infixr|instance|let|module|newtype|of|primitive|then|type|where)\b/,"import-statement":{pattern:/(^\s*)import\s+[A-Z][\w']*(?:\.[A-Z][\w']*)*(?:\s+as\s+[A-Z][\w']*(?:\.[A-Z][\w']*)*)?(?:\s+hiding\b)?/m,lookbehind:true,inside:{keyword:/\b(?:import|as|hiding)\b/}},builtin:/\b(?:absurd|add|ap|append|apply|between|bind|bottom|clamp|compare|comparing|compose|conj|const|degree|discard|disj|div|eq|flap|flip|gcd|identity|ifM|join|lcm|liftA1|liftM1|map|max|mempty|min|mod|mul|negate|not|notEq|one|otherwise|recip|show|sub|top|unit|unless|unlessM|void|when|whenM|zero)\b/});Prism.languages.purs=Prism.languages.purescript}},function(module,exports,__webpack_require__){"use strict";module.exports=python;python.displayName="python";python.aliases=["py"];function python(Prism){Prism.languages.python={comment:{pattern:/(^|[^\\])#.*/,lookbehind:true},"string-interpolation":{pattern:/(?:f|rf|fr)(?:("""|''')[\s\S]*?\1|("|')(?:\\.|(?!\2)[^\\\r\n])*\2)/i,greedy:true,inside:{interpolation:{pattern:/((?:^|[^{])(?:{{)*){(?!{)(?:[^{}]|{(?!{)(?:[^{}]|{(?!{)(?:[^{}])+})+})+}/,lookbehind:true,inside:{"format-spec":{pattern:/(:)[^:(){}]+(?=}$)/,lookbehind:true},"conversion-option":{pattern:/![sra](?=[:}]$)/,alias:"punctuation"},rest:null}},string:/[\s\S]+/}},"triple-quoted-string":{pattern:/(?:[rub]|rb|br)?("""|''')[\s\S]*?\1/i,greedy:true,alias:"string"},string:{pattern:/(?:[rub]|rb|br)?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/i,greedy:true},function:{pattern:/((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/g,lookbehind:true},"class-name":{pattern:/(\bclass\s+)\w+/i,lookbehind:true},decorator:{pattern:/(^\s*)@\w+(?:\.\w+)*/im,lookbehind:true,alias:["annotation","punctuation"],inside:{punctuation:/\./}},keyword:/\b(?:and|as|assert|async|await|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|nonlocal|not|or|pass|print|raise|return|try|while|with|yield)\b/,builtin:/\b(?:__import__|abs|all|any|apply|ascii|basestring|bin|bool|buffer|bytearray|bytes|callable|chr|classmethod|cmp|coerce|compile|complex|delattr|dict|dir|divmod|enumerate|eval|execfile|file|filter|float|format|frozenset|getattr|globals|hasattr|hash|help|hex|id|input|int|intern|isinstance|issubclass|iter|len|list|locals|long|map|max|memoryview|min|next|object|oct|open|ord|pow|property|range|raw_input|reduce|reload|repr|reversed|round|set|setattr|slice|sorted|staticmethod|str|sum|super|tuple|type|unichr|unicode|vars|xrange|zip)\b/,boolean:/\b(?:True|False|None)\b/,number:/(?:\b(?=\d)|\B(?=\.))(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*\.?\d*|\.\d+)(?:e[+-]?\d+)?j?\b/i,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]/,punctuation:/[{}[\];(),.:]/};Prism.languages.python["string-interpolation"].inside["interpolation"].inside.rest=Prism.languages.python;Prism.languages.py=Prism.languages.python}},function(module,exports,__webpack_require__){"use strict";module.exports=q;q.displayName="q";q.aliases=[];function q(Prism){Prism.languages.q={string:/"(?:\\.|[^"\\\r\n])*"/,comment:[{pattern:/([\t )\]}])\/.*/,lookbehind:true,greedy:true},{pattern:/(^|\r?\n|\r)\/[\t ]*(?:(?:\r?\n|\r)(?:.*(?:\r?\n|\r))*?(?:\\(?=[\t ]*(?:\r?\n|\r))|$)|\S.*)/,lookbehind:true,greedy:true},{pattern:/^\\[\t ]*(?:\r?\n|\r)[\s\S]+/m,greedy:true},{pattern:/^#!.+/m,greedy:true}],symbol:/`(?::\S+|[\w.]*)/,datetime:{pattern:/0N[mdzuvt]|0W[dtz]|\d{4}\.\d\d(?:m|\.\d\d(?:T(?:\d\d(?::\d\d(?::\d\d(?:[.:]\d\d\d)?)?)?)?)?[dz]?)|\d\d:\d\d(?::\d\d(?:[.:]\d\d\d)?)?[uvt]?/,alias:"number"},number:/\b(?![01]:)(?:0[wn]|0W[hj]?|0N[hje]?|0x[\da-fA-F]+|\d+\.?\d*(?:e[+-]?\d+)?[hjfeb]?)/,keyword:/\\\w+\b|\b(?:abs|acos|aj0?|all|and|any|asc|asin|asof|atan|attr|avgs?|binr?|by|ceiling|cols|cor|cos|count|cov|cross|csv|cut|delete|deltas|desc|dev|differ|distinct|div|do|dsave|ej|enlist|eval|except|exec|exit|exp|fby|fills|first|fkeys|flip|floor|from|get|getenv|group|gtime|hclose|hcount|hdel|hopen|hsym|iasc|identity|idesc|if|ij|in|insert|inter|inv|keys?|last|like|list|ljf?|load|log|lower|lsq|ltime|ltrim|mavg|maxs?|mcount|md5|mdev|med|meta|mins?|mmax|mmin|mmu|mod|msum|neg|next|not|null|or|over|parse|peach|pj|plist|prds?|prev|prior|rand|rank|ratios|raze|read0|read1|reciprocal|reval|reverse|rload|rotate|rsave|rtrim|save|scan|scov|sdev|select|set|setenv|show|signum|sin|sqrt|ssr?|string|sublist|sums?|sv|svar|system|tables|tan|til|trim|txf|type|uj|ungroup|union|update|upper|upsert|value|var|views?|vs|wavg|where|while|within|wj1?|wsum|ww|xasc|xbar|xcols?|xdesc|xexp|xgroup|xkey|xlog|xprev|xrank)\b/,adverb:{pattern:/['\/\\]:?|\beach\b/,alias:"function"},verb:{pattern:/(?:\B\.\B|\b[01]:|<[=>]?|>=?|[:+\-*%,!?~=|$&#@^]):?|\b_\b:?/,alias:"operator"},punctuation:/[(){}\[\];.]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=qml;qml.displayName="qml";qml.aliases=[];function qml(Prism){(function(Prism){var jsString=/"(?:\\.|[^\\"\r\n])*"|'(?:\\.|[^\\'\r\n])*'/.source;var jsComment=/\/\/.*(?!.)|\/\*(?:[^*]|\*(?!\/))*\*\//.source;var jsExpr=/(?:[^\\()[\]{}"'/]|<string>|\/(?![*/])|<comment>|\(<expr>*\)|\[<expr>*\]|\{<expr>*\}|\\[\s\S])/.source.replace(/<string>/g,(function(){return jsString})).replace(/<comment>/g,(function(){return jsComment}));for(var i=0;i<2;i++){jsExpr=jsExpr.replace(/<expr>/g,(function(){return jsExpr}))}jsExpr=jsExpr.replace(/<expr>/g,"[^\\s\\S]");Prism.languages.qml={comment:{pattern:/\/\/.*|\/\*[\s\S]*?\*\//,greedy:true},"javascript-function":{pattern:RegExp(/((?:^|;)[ \t]*)function\s+[_$a-zA-Z\xA0-\uFFFF][$\w\xA0-\uFFFF]*\s*\(<js>*\)\s*\{<js>*\}/.source.replace(/<js>/g,(function(){return jsExpr})),"m"),lookbehind:true,greedy:true,alias:"language-javascript",inside:Prism.languages.javascript},"class-name":{pattern:/((?:^|[:;])[ \t]*)(?!\d)\w+(?=[ \t]*\{|[ \t]+on\b)/m,lookbehind:true},property:[{pattern:/((?:^|[;{])[ \t]*)(?!\d)\w+(?:\.\w+)*(?=[ \t]*:)/m,lookbehind:true},{pattern:/((?:^|[;{])[ \t]*)property[ \t]+(?!\d)\w+(?:\.\w+)*[ \t]+(?!\d)\w+(?:\.\w+)*(?=[ \t]*:)/m,lookbehind:true,inside:{keyword:/^property/,property:/\w+(?:\.\w+)*/}}],"javascript-expression":{pattern:RegExp(/(:[ \t]*)(?![\s;}[])(?:(?!$|[;}])<js>)+/.source.replace(/<js>/g,(function(){return jsExpr})),"m"),lookbehind:true,greedy:true,alias:"language-javascript",inside:Prism.languages.javascript},string:/"(?:\\.|[^\\"\r\n])*"/,keyword:/\b(?:as|import|on)\b/,punctuation:/[{}[\]:;,]/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=qore;qore.displayName="qore";qore.aliases=[];function qore(Prism){Prism.languages.qore=Prism.languages.extend("clike",{comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|(?:\/\/|#).*)/,lookbehind:true},string:{pattern:/("|')(?:\\[\s\S]|(?!\1)[^\\])*\1/,greedy:true},variable:/\$(?!\d)\w+\b/,keyword:/\b(?:abstract|any|assert|binary|bool|boolean|break|byte|case|catch|char|class|code|const|continue|data|default|do|double|else|enum|extends|final|finally|float|for|goto|hash|if|implements|import|inherits|instanceof|int|interface|long|my|native|new|nothing|null|object|our|own|private|reference|rethrow|return|short|soft(?:int|float|number|bool|string|date|list)|static|strictfp|string|sub|super|switch|synchronized|this|throw|throws|transient|try|void|volatile|while)\b/,number:/\b(?:0b[01]+|0x[\da-f]*\.?[\da-fp\-]+|\d*\.?\d+e?\d*[df]|\d*\.?\d+)\b/i,boolean:/\b(?:true|false)\b/i,operator:{pattern:/(^|[^.])(?:\+[+=]?|-[-=]?|[!=](?:==?|~)?|>>?=?|<(?:=>?|<=?)?|&[&=]?|\|[|=]?|[*\/%^]=?|[~?])/,lookbehind:true},function:/\$?\b(?!\d)\w+(?=\()/})}},function(module,exports,__webpack_require__){"use strict";module.exports=r;r.displayName="r";r.aliases=[];function r(Prism){Prism.languages.r={comment:/#.*/,string:{pattern:/(['"])(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},"percent-operator":{pattern:/%[^%\s]*%/,alias:"operator"},boolean:/\b(?:TRUE|FALSE)\b/,ellipsis:/\.\.(?:\.|\d+)/,number:[/\b(?:NaN|Inf)\b/,/(?:\b0x[\dA-Fa-f]+(?:\.\d*)?|\b\d+\.?\d*|\B\.\d+)(?:[EePp][+-]?\d+)?[iL]?/],keyword:/\b(?:if|else|repeat|while|function|for|in|next|break|NULL|NA|NA_integer_|NA_real_|NA_complex_|NA_character_)\b/,operator:/->?>?|<(?:=|<?-)?|[>=!]=?|::?|&&?|\|\|?|[+*\/^$@~]/,punctuation:/[(){}\[\],;]/}}},function(module,exports,__webpack_require__){"use strict";var refractorScheme=__webpack_require__(136);module.exports=racket;racket.displayName="racket";racket.aliases=["rkt"];function racket(Prism){Prism.register(refractorScheme);Prism.languages.racket=Prism.languages.extend("scheme",{"lambda-parameter":{pattern:/(\(lambda\s+\()[^()'\s]+/,lookbehind:true}});Prism.languages.DFS(Prism.languages.racket,(function(key,value){if(Prism.util.type(value)==="RegExp"){var source=value.source.replace(/\\(.)|\[\^?((?:\\.|[^\\\]])*)\]/g,(function(m,g1,g2){if(g1){if(g1==="("){return"[([]"}if(g1===")"){return"[)\\]]"}}if(g2){var prefix=m[1]==="^"?"[^":"[";return prefix+g2.replace(/\\(.)|[()]/g,(function(m,g1){if(m==="("||g1==="("){return"(["}if(m===")"||g1===")"){return")\\]"}return m}))+"]"}return m}));this[key]=RegExp(source,value.flags)}}));Prism.languages.insertBefore("racket","string",{lang:{pattern:/^#lang.+/m,greedy:true,alias:"keyword"}});Prism.languages.rkt=Prism.languages.racket}},function(module,exports,__webpack_require__){"use strict";module.exports=reason;reason.displayName="reason";reason.aliases=[];function reason(Prism){Prism.languages.reason=Prism.languages.extend("clike",{string:{pattern:/"(?:\\(?:\r\n|[\s\S])|[^\\\r\n"])*"/,greedy:true},"class-name":/\b[A-Z]\w*/,keyword:/\b(?:and|as|assert|begin|class|constraint|do|done|downto|else|end|exception|external|for|fun|function|functor|if|in|include|inherit|initializer|lazy|let|method|module|mutable|new|nonrec|object|of|open|or|private|rec|sig|struct|switch|then|to|try|type|val|virtual|when|while|with)\b/,operator:/\.{3}|:[:=]|\|>|->|=(?:==?|>)?|<=?|>=?|[|^?'#!~`]|[+\-*\/]\.?|\b(?:mod|land|lor|lxor|lsl|lsr|asr)\b/});Prism.languages.insertBefore("reason","class-name",{character:{pattern:/'(?:\\x[\da-f]{2}|\\o[0-3][0-7][0-7]|\\\d{3}|\\.|[^'\\\r\n])'/,alias:"string"},constructor:{pattern:/\b[A-Z]\w*\b(?!\s*\.)/,alias:"variable"},label:{pattern:/\b[a-z]\w*(?=::)/,alias:"symbol"}});delete Prism.languages.reason.function}},function(module,exports,__webpack_require__){"use strict";module.exports=regex;regex.displayName="regex";regex.aliases=[];function regex(Prism){(function(Prism){var specialEscape={pattern:/\\[\\(){}[\]^$+*?|.]/,alias:"escape"};var escape=/\\(?:x[\da-fA-F]{2}|u[\da-fA-F]{4}|u\{[\da-fA-F]+\}|c[a-zA-Z]|0[0-7]{0,2}|[123][0-7]{2}|.)/;var charClass={pattern:/\.|\\[wsd]|\\p{[^{}]+}/i,alias:"class-name"};var charClassWithoutDot={pattern:/\\[wsd]|\\p{[^{}]+}/i,alias:"class-name"};var rangeChar="(?:[^\\\\-]|"+escape.source+")";var range=RegExp(rangeChar+"-"+rangeChar);var groupName={pattern:/(<|')[^<>']+(?=[>']$)/,lookbehind:true,alias:"variable"};Prism.languages.regex={charset:{pattern:/((?:^|[^\\])(?:\\\\)*)\[(?:[^\\\]]|\\[\s\S])*\]/,lookbehind:true,inside:{"charset-negation":{pattern:/(^\[)\^/,lookbehind:true,alias:"operator"},"charset-punctuation":{pattern:/^\[|\]$/,alias:"punctuation"},range:{pattern:range,inside:{escape:escape,"range-punctuation":{pattern:/-/,alias:"operator"}}},"special-escape":specialEscape,charclass:charClassWithoutDot,escape:escape}},"special-escape":specialEscape,charclass:charClass,backreference:[{pattern:/\\(?![123][0-7]{2})[1-9]/,alias:"keyword"},{pattern:/\\k<[^<>']+>/,alias:"keyword",inside:{"group-name":groupName}}],anchor:{pattern:/[$^]|\\[ABbGZz]/,alias:"function"},escape:escape,group:[{pattern:/\((?:\?(?:<[^<>']+>|'[^<>']+'|[>:]|<?[=!]|[idmnsuxU]+(?:-[idmnsuxU]+)?:?))?/,alias:"punctuation",inside:{"group-name":groupName}},{pattern:/\)/,alias:"punctuation"}],quantifier:{pattern:/(?:[+*?]|\{(?:\d+,?\d*)\})[?+]?/,alias:"number"},alternation:{pattern:/\|/,alias:"keyword"}}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=renpy;renpy.displayName="renpy";renpy.aliases=["rpy"];function renpy(Prism){Prism.languages.renpy={comment:{pattern:/(^|[^\\])#.+/,lookbehind:true},string:{pattern:/("""|''')[\s\S]+?\1|("|')(?:\\.|(?!\2)[^\\\r\n])*\2|(?:^#?(?:(?:[0-9a-fA-F]{2}){3}|(?:[0-9a-fA-F]){3})$)/m,greedy:true},function:/[a-z_]\w*(?=\()/i,property:/\b(?:insensitive|idle|hover|selected_idle|selected_hover|background|position|alt|xpos|ypos|pos|xanchor|yanchor|anchor|xalign|yalign|align|xcenter|ycenter|xofsset|yoffset|ymaximum|maximum|xmaximum|xminimum|yminimum|minimum|xsize|ysizexysize|xfill|yfill|area|antialias|black_color|bold|caret|color|first_indent|font|size|italic|justify|kerning|language|layout|line_leading|line_overlap_split|line_spacing|min_width|newline_indent|outlines|rest_indent|ruby_style|slow_cps|slow_cps_multiplier|strikethrough|text_align|underline|hyperlink_functions|vertical|hinting|foreground|left_margin|xmargin|top_margin|bottom_margin|ymargin|left_padding|right_padding|xpadding|top_padding|bottom_padding|ypadding|size_group|child|hover_sound|activate_sound|mouse|focus_mask|keyboard_focus|bar_vertical|bar_invert|bar_resizing|left_gutter|right_gutter|top_gutter|bottom_gutter|left_bar|right_bar|top_bar|bottom_bar|thumb|thumb_shadow|thumb_offset|unscrollable|spacing|first_spacing|box_reverse|box_wrap|order_reverse|fit_first|ysize|thumbnail_width|thumbnail_height|help|text_ypos|text_xpos|idle_color|hover_color|selected_idle_color|selected_hover_color|insensitive_color|alpha|insensitive_background|hover_background|zorder|value|width|xadjustment|xanchoraround|xaround|xinitial|xoffset|xzoom|yadjustment|yanchoraround|yaround|yinitial|yzoom|zoom|ground|height|text_style|text_y_fudge|selected_insensitive|has_sound|has_music|has_voice|focus|hovered|image_style|length|minwidth|mousewheel|offset|prefix|radius|range|right_margin|rotate|rotate_pad|developer|screen_width|screen_height|window_title|name|version|windows_icon|default_fullscreen|default_text_cps|default_afm_time|main_menu_music|sample_sound|enter_sound|exit_sound|save_directory|enter_transition|exit_transition|intra_transition|main_game_transition|game_main_transition|end_splash_transition|end_game_transition|after_load_transition|window_show_transition|window_hide_transition|adv_nvl_transition|nvl_adv_transition|enter_yesno_transition|exit_yesno_transition|enter_replay_transition|exit_replay_transition|say_attribute_transition|directory_name|executable_name|include_update|window_icon|modal|google_play_key|google_play_salt|drag_name|drag_handle|draggable|dragged|droppable|dropped|narrator_menu|action|default_afm_enable|version_name|version_tuple|inside|fadeout|fadein|layers|layer_clipping|linear|scrollbars|side_xpos|side_ypos|side_spacing|edgescroll|drag_joined|drag_raise|drop_shadow|drop_shadow_color|subpixel|easein|easeout|time|crop|auto|update|get_installed_packages|can_update|UpdateVersion|Update|overlay_functions|translations|window_left_padding|show_side_image|show_two_window)\b/,tag:/\b(?:label|image|menu|[hv]box|frame|text|imagemap|imagebutton|bar|vbar|screen|textbutton|buttoscreenn|fixed|grid|input|key|mousearea|side|timer|viewport|window|hotspot|hotbar|self|button|drag|draggroup|tag|mm_menu_frame|nvl|block|parallel)\b|\$/,keyword:/\b(?:as|assert|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|pass|print|raise|return|try|while|yield|adjustment|alignaround|allow|angle|around|box_layout|cache|changed|child_size|clicked|clipping|corner1|corner2|default|delay|exclude|scope|slow|slow_abortable|slow_done|sound|style_group|substitute|suffix|transform_anchor|transpose|unhovered|config|theme|mm_root|gm_root|rounded_window|build|disabled_text|disabled|widget_selected|widget_text|widget_hover|widget|updater|behind|call|expression|hide|init|jump|onlayer|python|renpy|scene|set|show|transform|play|queue|stop|pause|define|window|repeat|contains|choice|on|function|event|animation|clockwise|counterclockwise|circles|knot|null|None|random|has|add|use|fade|dissolve|style|store|id|voice|center|left|right|less_rounded|music|movie|clear|persistent|ui)\b/,boolean:/\b(?:[Tt]rue|[Ff]alse)\b/,number:/(?:\b(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*\.?\d*)|\B\.\d+)(?:e[+-]?\d+)?j?/i,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]|\b(?:or|and|not|with|at)\b/,punctuation:/[{}[\];(),.:]/};Prism.languages.rpy=Prism.languages.renpy}},function(module,exports,__webpack_require__){"use strict";module.exports=rest;rest.displayName="rest";rest.aliases=[];function rest(Prism){Prism.languages.rest={table:[{pattern:/(\s*)(?:\+[=-]+)+\+(?:\r?\n|\r)(?:\1(?:[+|].+)+[+|](?:\r?\n|\r))+\1(?:\+[=-]+)+\+/,lookbehind:true,inside:{punctuation:/\||(?:\+[=-]+)+\+/}},{pattern:/(\s*)(?:=+ +)+=+(?:(?:\r?\n|\r)\1.+)+(?:\r?\n|\r)\1(?:=+ +)+=+(?=(?:\r?\n|\r){2}|\s*$)/,lookbehind:true,inside:{punctuation:/[=-]+/}}],"substitution-def":{pattern:/(^\s*\.\. )\|(?:[^|\s](?:[^|]*[^|\s])?)\| [^:]+::/m,lookbehind:true,inside:{substitution:{pattern:/^\|(?:[^|\s]|[^|\s][^|]*[^|\s])\|/,alias:"attr-value",inside:{punctuation:/^\||\|$/}},directive:{pattern:/( +)[^:]+::/,lookbehind:true,alias:"function",inside:{punctuation:/::$/}}}},"link-target":[{pattern:/(^\s*\.\. )\[[^\]]+\]/m,lookbehind:true,alias:"string",inside:{punctuation:/^\[|\]$/}},{pattern:/(^\s*\.\. )_(?:`[^`]+`|(?:[^:\\]|\\.)+):/m,lookbehind:true,alias:"string",inside:{punctuation:/^_|:$/}}],directive:{pattern:/(^\s*\.\. )[^:]+::/m,lookbehind:true,alias:"function",inside:{punctuation:/::$/}},comment:{pattern:/(^\s*\.\.)(?:(?: .+)?(?:(?:\r?\n|\r).+)+| .+)(?=(?:\r?\n|\r){2}|$)/m,lookbehind:true},title:[{pattern:/^(([!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~])\2+)(?:\r?\n|\r).+(?:\r?\n|\r)\1$/m,inside:{punctuation:/^[!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~]+|[!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~]+$/,important:/.+/}},{pattern:/(^|(?:\r?\n|\r){2}).+(?:\r?\n|\r)([!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~])\2+(?=\r?\n|\r|$)/,lookbehind:true,inside:{punctuation:/[!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~]+$/,important:/.+/}}],hr:{pattern:/((?:\r?\n|\r){2})([!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~])\2{3,}(?=(?:\r?\n|\r){2})/,lookbehind:true,alias:"punctuation"},field:{pattern:/(^\s*):[^:\r\n]+:(?= )/m,lookbehind:true,alias:"attr-name"},"command-line-option":{pattern:/(^\s*)(?:[+-][a-z\d]|(?:--|\/)[a-z\d-]+)(?:[ =](?:[a-z][\w-]*|<[^<>]+>))?(?:, (?:[+-][a-z\d]|(?:--|\/)[a-z\d-]+)(?:[ =](?:[a-z][\w-]*|<[^<>]+>))?)*(?=(?:\r?\n|\r)? {2,}\S)/im,lookbehind:true,alias:"symbol"},"literal-block":{pattern:/::(?:\r?\n|\r){2}([ \t]+).+(?:(?:\r?\n|\r)\1.+)*/,inside:{"literal-block-punctuation":{pattern:/^::/,alias:"punctuation"}}},"quoted-literal-block":{pattern:/::(?:\r?\n|\r){2}([!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~]).*(?:(?:\r?\n|\r)\1.*)*/,inside:{"literal-block-punctuation":{pattern:/^(?:::|([!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~])\1*)/m,alias:"punctuation"}}},"list-bullet":{pattern:/(^\s*)(?:[*+\-•‣⁃]|\(?(?:\d+|[a-z]|[ivxdclm]+)\)|(?:\d+|[a-z]|[ivxdclm]+)\.)(?= )/im,lookbehind:true,alias:"punctuation"},"doctest-block":{pattern:/(^\s*)>>> .+(?:(?:\r?\n|\r).+)*/m,lookbehind:true,inside:{punctuation:/^>>>/}},inline:[{pattern:/(^|[\s\-:\/'"<(\[{])(?::[^:]+:`.*?`|`.*?`:[^:]+:|(\*\*?|``?|\|)(?!\s).*?[^\s]\2(?=[\s\-.,:;!?\\\/'")\]}]|$))/m,lookbehind:true,inside:{bold:{pattern:/(^\*\*).+(?=\*\*$)/,lookbehind:true},italic:{pattern:/(^\*).+(?=\*$)/,lookbehind:true},"inline-literal":{pattern:/(^``).+(?=``$)/,lookbehind:true,alias:"symbol"},role:{pattern:/^:[^:]+:|:[^:]+:$/,alias:"function",inside:{punctuation:/^:|:$/}},"interpreted-text":{pattern:/(^`).+(?=`$)/,lookbehind:true,alias:"attr-value"},substitution:{pattern:/(^\|).+(?=\|$)/,lookbehind:true,alias:"attr-value"},punctuation:/\*\*?|``?|\|/}}],link:[{pattern:/\[[^\]]+\]_(?=[\s\-.,:;!?\\\/'")\]}]|$)/,alias:"string",inside:{punctuation:/^\[|\]_$/}},{pattern:/(?:\b[a-z\d]+(?:[_.:+][a-z\d]+)*_?_|`[^`]+`_?_|_`[^`]+`)(?=[\s\-.,:;!?\\\/'")\]}]|$)/i,alias:"string",inside:{punctuation:/^_?`|`$|`?_?_$/}}],punctuation:{pattern:/(^\s*)(?:\|(?= |$)|(?:---?|—|\.\.|__)(?= )|\.\.$)/m,lookbehind:true}}}},function(module,exports,__webpack_require__){"use strict";module.exports=rip;rip.displayName="rip";rip.aliases=[];function rip(Prism){Prism.languages.rip={comment:/#.*/,keyword:/(?:=>|->)|\b(?:class|if|else|switch|case|return|exit|try|catch|finally|raise)\b/,builtin:/@|\bSystem\b/,boolean:/\b(?:true|false)\b/,date:/\b\d{4}-\d{2}-\d{2}\b/,time:/\b\d{2}:\d{2}:\d{2}\b/,datetime:/\b\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\b/,character:/\B`[^\s`'",.:;#\/\\()<>\[\]{}]\b/,regex:{pattern:/(^|[^/])\/(?!\/)(?:\[[^\n\r\]]*\]|\\.|[^/\\\r\n\[])+\/(?=\s*(?:$|[\r\n,.;})]))/,lookbehind:true,greedy:true},symbol:/:[^\d\s`'",.:;#\/\\()<>\[\]{}][^\s`'",.:;#\/\\()<>\[\]{}]*/,string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},number:/[+-]?\b(?:\d+\.\d+|\d+)\b/,punctuation:/(?:\.{2,3})|[`,.:;=\/\\()<>\[\]{}]/,reference:/[^\d\s`'",.:;#\/\\()<>\[\]{}][^\s`'",.:;#\/\\()<>\[\]{}]*/}}},function(module,exports,__webpack_require__){"use strict";module.exports=roboconf;roboconf.displayName="roboconf";roboconf.aliases=[];function roboconf(Prism){Prism.languages.roboconf={comment:/#.*/,keyword:{pattern:/(^|\s)(?:(?:facet|instance of)(?=[ \t]+[\w-]+[ \t]*\{)|(?:external|import)\b)/,lookbehind:true},component:{pattern:/[\w-]+(?=[ \t]*\{)/,alias:"variable"},property:/[\w.-]+(?=[ \t]*:)/,value:{pattern:/(=[ \t]*)[^,;]+/,lookbehind:true,alias:"attr-value"},optional:{pattern:/\(optional\)/,alias:"builtin"},wildcard:{pattern:/(\.)\*/,lookbehind:true,alias:"operator"},punctuation:/[{},.;:=]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=robotframework;robotframework.displayName="robotframework";robotframework.aliases=[];function robotframework(Prism){(function(Prism){var comment={pattern:/(^[ \t]*| {2}|\t)#.*/m,lookbehind:true,greedy:true};var variable={pattern:/((?:^|[^\\])(?:\\{2})*)[$@&%]\{(?:[^{}\r\n]|\{[^{}\r\n]*\})*\}/,lookbehind:true,inside:{punctuation:/^[$@&%]\{|\}$/}};function createSection(name,inside){var extendecInside={};extendecInside["section-header"]={pattern:/^ ?\*{3}.+?\*{3}/,alias:"keyword"};for(var token in inside){extendecInside[token]=inside[token]}extendecInside["tag"]={pattern:/([\r\n](?:  |\t)[ \t]*)\[[-\w]+\]/,lookbehind:true,inside:{punctuation:/\[|\]/}};extendecInside["variable"]=variable;extendecInside["comment"]=comment;return{pattern:RegExp(/^ ?\*{3}[ \t]*<name>[ \t]*\*{3}(?:.|[\r\n](?!\*{3}))*/.source.replace(/<name>/g,(function(){return name})),"im"),alias:"section",inside:extendecInside}}var docTag={pattern:/(\[Documentation\](?:  |\t)[ \t]*)(?![ \t]|#)(?:.|(?:\r\n?|\n)[ \t]*\.{3})+/,lookbehind:true,alias:"string"};var testNameLike={pattern:/([\r\n] ?)(?!#)(?:\S(?:[ \t]\S)*)+/,lookbehind:true,alias:"function",inside:{variable:variable}};var testPropertyLike={pattern:/([\r\n](?:  |\t)[ \t]*)(?!\[|\.{3}|#)(?:\S(?:[ \t]\S)*)+/,lookbehind:true,inside:{variable:variable}};Prism.languages["robotframework"]={settings:createSection("Settings",{documentation:{pattern:/([\r\n] ?Documentation(?:  |\t)[ \t]*)(?![ \t]|#)(?:.|(?:\r\n?|\n)[ \t]*\.{3})+/,lookbehind:true,alias:"string"},property:{pattern:/([\r\n] ?)(?!\.{3}|#)(?:\S(?:[ \t]\S)*)+/,lookbehind:true}}),variables:createSection("Variables"),"test-cases":createSection("Test Cases",{"test-name":testNameLike,documentation:docTag,property:testPropertyLike}),keywords:createSection("Keywords",{"keyword-name":testNameLike,documentation:docTag,property:testPropertyLike}),tasks:createSection("Tasks",{"task-name":testNameLike,documentation:docTag,property:testPropertyLike}),comment:comment};Prism.languages.robot=Prism.languages["robotframework"]})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=rust;rust.displayName="rust";rust.aliases=[];function rust(Prism){(function(Prism){var multilineComment=/\/\*(?:[^*/]|\*(?!\/)|\/(?!\*)|<self>)*\*\//.source;for(var i=0;i<2;i++){multilineComment=multilineComment.replace(/<self>/g,(function(){return multilineComment}))}multilineComment=multilineComment.replace(/<self>/g,(function(){return/[^\s\S]/.source}));Prism.languages.rust={comment:[{pattern:RegExp(/(^|[^\\])/.source+multilineComment),lookbehind:true,greedy:true},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:true,greedy:true}],string:{pattern:/b?"(?:\\[\s\S]|[^\\"])*"|b?r(#*)"(?:[^"]|"(?!\1))*"\1/,greedy:true},char:{pattern:/b?'(?:\\(?:x[0-7][\da-fA-F]|u\{(?:[\da-fA-F]_*){1,6}\}|.)|[^\\\r\n\t'])'/,greedy:true,alias:"string"},attribute:{pattern:/#!?\[(?:[^\[\]"]|"(?:\\[\s\S]|[^\\"])*")*\]/,greedy:true,alias:"attr-name",inside:{string:null}},"closure-params":{pattern:/([=(,:]\s*|\bmove\s*)\|[^|]*\||\|[^|]*\|(?=\s*(?:\{|->))/,lookbehind:true,greedy:true,inside:{"closure-punctuation":{pattern:/^\||\|$/,alias:"punctuation"},rest:null}},"lifetime-annotation":{pattern:/'\w+/,alias:"symbol"},"fragment-specifier":{pattern:/(\$\w+:)[a-z]+/,lookbehind:true,alias:"punctuation"},variable:/\$\w+/,"function-definition":{pattern:/(\bfn\s+)\w+/,lookbehind:true,alias:"function"},"type-definition":{pattern:/(\b(?:enum|struct|union)\s+)\w+/,lookbehind:true,alias:"class-name"},"module-declaration":[{pattern:/(\b(?:crate|mod)\s+)[a-z][a-z_\d]*/,lookbehind:true,alias:"namespace"},{pattern:/(\b(?:crate|self|super)\s*)::\s*[a-z][a-z_\d]*\b(?:\s*::(?:\s*[a-z][a-z_\d]*\s*::)*)?/,lookbehind:true,alias:"namespace",inside:{punctuation:/::/}}],keyword:[/\b(?:abstract|as|async|await|become|box|break|const|continue|crate|do|dyn|else|enum|extern|final|fn|for|if|impl|in|let|loop|macro|match|mod|move|mut|override|priv|pub|ref|return|self|Self|static|struct|super|trait|try|type|typeof|union|unsafe|unsized|use|virtual|where|while|yield)\b/,/\b(?:[ui](?:8|16|32|64|128|size)|f(?:32|64)|bool|char|str)\b/],function:/\b[a-z_]\w*(?=\s*(?:::\s*<|\())/,macro:{pattern:/\w+!/,alias:"property"},constant:/\b[A-Z_][A-Z_\d]+\b/,"class-name":/\b[A-Z]\w*\b/,namespace:{pattern:/(?:\b[a-z][a-z_\d]*\s*::\s*)*\b[a-z][a-z_\d]*\s*::(?!\s*<)/,inside:{punctuation:/::/}},number:/\b(?:0x[\dA-Fa-f](?:_?[\dA-Fa-f])*|0o[0-7](?:_?[0-7])*|0b[01](?:_?[01])*|(?:\d(?:_?\d)*)?\.?\d(?:_?\d)*(?:[Ee][+-]?\d+)?)(?:_?(?:[iu](?:8|16|32|64|size)?|f32|f64))?\b/,boolean:/\b(?:false|true)\b/,punctuation:/->|\.\.=|\.{1,3}|::|[{}[\];(),:]/,operator:/[-+*\/%!^]=?|=[=>]?|&[&=]?|\|[|=]?|<<?=?|>>?=?|[@?]/};Prism.languages.rust["closure-params"].inside.rest=Prism.languages.rust;Prism.languages.rust["attribute"].inside["string"]=Prism.languages.rust["string"]})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=sas;sas.displayName="sas";sas.aliases=[];function sas(Prism){(function(Prism){var stringPattern=/(?:"(?:""|[^"])*"(?!")|'(?:''|[^'])*'(?!'))/.source;var number=/\b(?:\d[\da-f]*x|\d+(?:\.\d+)?(?:e[+-]?\d+)?)\b/i;var numericConstant={pattern:RegExp(stringPattern+"[bx]"),alias:"number"};var macroVariable={pattern:/&[a-z_][a-z_0-9]*/i};var macroKeyword={pattern:/((?:^|\s|=|\())%(?:ABORT|BY|CMS|COPY|DISPLAY|DO|ELSE|END|EVAL|GLOBAL|GO|GOTO|IF|INC|INCLUDE|INDEX|INPUT|KTRIM|LENGTH|LET|LIST|LOCAL|PUT|QKTRIM|QSCAN|QSUBSTR|QSYSFUNC|QUPCASE|RETURN|RUN|SCAN|SUBSTR|SUPERQ|SYMDEL|SYMGLOBL|SYMLOCAL|SYMEXIST|SYSCALL|SYSEVALF|SYSEXEC|SYSFUNC|SYSGET|SYSRPUT|THEN|TO|TSO|UNQUOTE|UNTIL|UPCASE|WHILE|WINDOW)\b/i,lookbehind:true,alias:"keyword"};var step={pattern:/(^|\s+)(?:proc\s+\w+|quit|run|data(?!\=))\b/i,alias:"keyword",lookbehind:true};var comment=[/\/\*[\s\S]*?\*\//,{pattern:/(^\s*|;\s*)\*[^;]*;/m,lookbehind:true}];var string={pattern:RegExp(stringPattern),greedy:true};var punctuation=/[$%@.(){}\[\];,\\]/;var func={pattern:/%?\w+(?=\()/,alias:"keyword"};var args={function:func,"arg-value":{pattern:/(\s*=\s*)[A-Z\.]+/i,lookbehind:true},operator:/=/,"macro-variable":macroVariable,arg:{pattern:/[A-Z]+/i,alias:"keyword"},number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string};var format={pattern:/\b(?:format|put)\b=?[\w'$.]+/im,inside:{keyword:/^(?:format|put)(?=\=)/i,equals:/=/,format:{pattern:/(?:\w|\$\d)+\.\d?/i,alias:"number"}}};var altformat={pattern:/\b(?:format|put)\s+[\w']+(?:\s+[$.\w]+)+(?=;)/i,inside:{keyword:/^(?:format|put)/i,format:{pattern:/[\w$]+\.\d?/,alias:"number"}}};var globalStatements={pattern:/((?:^|[\s])=?)(?:catname|checkpoint execute_always|dm|endsas|filename|footnote|%include|libname|%list|lock|missing|options|page|resetline|%run|sasfile|skip|sysecho|title\d?)\b/i,lookbehind:true,alias:"keyword"};var submitStatement={pattern:/(^|\s)(?:submit(?:\s+(?:load|parseonly|norun))?|endsubmit)\b/i,lookbehind:true,alias:"keyword"};var actionSets=/accessControl|cdm|aggregation|aStore|ruleMining|audio|autotune|bayesianNetClassifier|bioMedImage|boolRule|builtins|cardinality|sccasl|clustering|copula|countreg|dataDiscovery|dataPreprocess|dataSciencePilot|dataStep|decisionTree|deepLearn|deepNeural|varReduce|simSystem|ds2|deduplication|ecm|entityRes|espCluster|explainModel|factmac|fastKnn|fcmpact|fedSql|freqTab|gam|gleam|graphSemiSupLearn|gVarCluster|hiddenMarkovModel|hyperGroup|image|iml|ica|kernalPca|langModel|ldaTopic|sparseML|mlTools|mixed|modelPublishing|mbc|network|optNetwork|neuralNet|nonlinear|nmf|nonParametricBayes|optimization|panel|pls|percentile|pca|phreg|qkb|qlim|quantreg|recommend|tsReconcile|deepRnn|regression|reinforcementLearn|robustPca|sampling|sparkEmbeddedProcess|search(?:Analytics)?|sentimentAnalysis|sequence|configuration|session(?:Prop)?|severity|simple|smartData|sandwich|spatialreg|stabilityMonitoring|spc|loadStreams|svDataDescription|svm|table|conditionalRandomFields|text(?:Rule(?:Develop|Score)|Mining|Parse|Topic|Util|Filters|Frequency)|tsInfo|timeData|transpose|uniTimeSeries/.source;var casActions={pattern:RegExp(/(^|\s)(?:action\s+)?(?:<act>)\.[a-z]+\b[^;]+/.source.replace(/<act>/g,(function(){return actionSets})),"i"),lookbehind:true,inside:{keyword:RegExp(/(?:<act>)\.[a-z]+\b/.source.replace(/<act>/g,(function(){return actionSets})),"i"),action:{pattern:/(?:action)/i,alias:"keyword"},comment:comment,function:func,"arg-value":args["arg-value"],operator:args.operator,argument:args.arg,number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string}};var keywords={pattern:/((?:^|\s)=?)(?:after|analysis|and|array|barchart|barwidth|begingraph|by|call|cas|cbarline|cfill|class(?:lev)?|close|column|computed?|contains|continue|data(?=\=)|define|delete|describe|document|do\s+over|do|dol|drop|dul|end(?:source|comp)?|entryTitle|else|eval(?:uate)?|exec(?:ute)?|exit|fill(?:attrs)?|file(?:name)?|flist|fnc|function(?:list)?|goto|global|group(?:by)?|headline|headskip|histogram|if|infile|keep|keylabel|keyword|label|layout|leave|legendlabel|length|libname|loadactionset|merge|midpoints|name|noobs|nowd|_?null_|ods|options|or|otherwise|out(?:put)?|over(?:lay)?|plot|put|print|raise|ranexp|rannor|rbreak|retain|return|select|set|session|sessref|source|statgraph|sum|summarize|table|temp|terminate|then\s+do|then|title\d?|to|var|when|where|xaxisopts|yaxisopts|y2axisopts)\b/i,lookbehind:true};Prism.languages.sas={datalines:{pattern:/^(\s*)(?:(?:data)?lines|cards);[\s\S]+?^\s*;/im,lookbehind:true,alias:"string",inside:{keyword:{pattern:/^(?:(?:data)?lines|cards)/i},punctuation:/;/}},"proc-sql":{pattern:/(^proc\s+(?:fed)?sql(?:\s+[\w|=]+)?;)[\s\S]+?(?=^(?:proc\s+\w+|quit|run|data);|(?![\s\S]))/im,lookbehind:true,inside:{sql:{pattern:RegExp(/^[ \t]*(?:select|alter\s+table|(?:create|describe|drop)\s+(?:index|table(?:\s+constraints)?|view)|create\s+unique\s+index|insert\s+into|update)(?:<str>|[^;"'])+;/.source.replace(/<str>/g,(function(){return stringPattern})),"im"),alias:"language-sql",inside:Prism.languages.sql},"global-statements":globalStatements,"sql-statements":{pattern:/(^|\s)(?:disconnect\s+from|exec(?:ute)?|begin|commit|rollback|reset|validate)\b/i,lookbehind:true,alias:"keyword"},number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string}},"proc-groovy":{pattern:/(^proc\s+groovy(?:\s+[\w|=]+)?;)[\s\S]+?(?=^(?:proc\s+\w+|quit|run|data);|(?![\s\S]))/im,lookbehind:true,inside:{comment:comment,groovy:{pattern:RegExp(/(^[ \t]*submit(?:\s+(?:load|parseonly|norun))?)(?:<str>|[^"'])+?(?=endsubmit;)/.source.replace(/<str>/g,(function(){return stringPattern})),"im"),lookbehind:true,alias:"language-groovy",inside:Prism.languages.groovy},keyword:keywords,"submit-statement":submitStatement,"global-statements":globalStatements,number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string}},"proc-lua":{pattern:/(^proc\s+lua(?:\s+[\w|=]+)?;)[\s\S]+?(?=^(?:proc\s+\w+|quit|run|data);|(?![\s\S]))/im,lookbehind:true,inside:{comment:comment,lua:{pattern:RegExp(/(^[ \t]*submit(?:\s+(?:load|parseonly|norun))?)(?:<str>|[^"'])+?(?=endsubmit;)/.source.replace(/<str>/g,(function(){return stringPattern})),"im"),lookbehind:true,alias:"language-lua",inside:Prism.languages.lua},keyword:keywords,"submit-statement":submitStatement,"global-statements":globalStatements,number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string}},"proc-cas":{pattern:/(^proc\s+cas(?:\s+[\w|=]+)?;)[\s\S]+?(?=^(?:proc\s+\w+|quit|data);|(?![\s\S]))/im,lookbehind:true,inside:{comment:comment,"statement-var":{pattern:/((?:^|\s)=?)saveresult\s+[^;]+/im,lookbehind:true,inside:{statement:{pattern:/^saveresult\s+\S+/i,inside:{keyword:/^(?:saveresult)/i}},rest:args}},"cas-actions":casActions,statement:{pattern:/((?:^|\s)=?)(?:default|(?:un)?set|on|output|upload)[^;]+/im,lookbehind:true,inside:args},step:step,keyword:keywords,function:func,format:format,altformat:altformat,"global-statements":globalStatements,number:number,"numeric-constant":numericConstant,punctuation:punctuation,string:string}},"proc-args":{pattern:RegExp(/(^proc\s+\w+\s+)(?!\s)(?:[^;"']|<str>)+;/.source.replace(/<str>/g,(function(){return stringPattern})),"im"),lookbehind:true,inside:args},"macro-keyword":macroKeyword,"macro-variable":macroVariable,"macro-string-functions":{pattern:/((?:^|\s|=))%(?:NRBQUOTE|NRQUOTE|NRSTR|BQUOTE|QUOTE|STR)\(.*?(?:[^%]\))/i,lookbehind:true,inside:{function:{pattern:/%(?:NRBQUOTE|NRQUOTE|NRSTR|BQUOTE|QUOTE|STR)/i,alias:"keyword"},"macro-keyword":macroKeyword,"macro-variable":macroVariable,"escaped-char":{pattern:/%['"()<>=¬^~;,#]/i},punctuation:punctuation}},"macro-declaration":{pattern:/^%macro[^;]+(?=;)/im,inside:{keyword:/%macro/i}},"macro-end":{pattern:/^%mend[^;]+(?=;)/im,inside:{keyword:/%mend/i}},macro:{pattern:/%_\w+(?=\()/,alias:"keyword"},input:{pattern:/\binput\s+[-\w\s/*.$&]+;/i,inside:{input:{alias:"keyword",pattern:/^input/i},comment:comment,number:number,"numeric-constant":numericConstant}},"options-args":{pattern:/(^options)[-'"|/\\<>*+=:()\w\s]*(?=;)/im,lookbehind:true,inside:args},"cas-actions":casActions,comment:comment,function:func,format:format,altformat:altformat,"numeric-constant":numericConstant,datetime:{pattern:RegExp(stringPattern+"(?:dt?|t)"),alias:"number"},string:string,step:step,keyword:keywords,"operator-keyword":{pattern:/\b(?:eq|ne|gt|lt|ge|le|in|not)\b/i,alias:"operator"},number:number,operator:/\*\*?|\|\|?|!!?|¦¦?|<[>=]?|>[<=]?|[-+\/=&]|[~¬^]=?/i,punctuation:punctuation}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=sass;sass.displayName="sass";sass.aliases=[];function sass(Prism){(function(Prism){Prism.languages.sass=Prism.languages.extend("css",{comment:{pattern:/^([ \t]*)\/[\/*].*(?:(?:\r?\n|\r)\1[ \t]+.+)*/m,lookbehind:true}});Prism.languages.insertBefore("sass","atrule",{"atrule-line":{pattern:/^(?:[ \t]*)[@+=].+/m,inside:{atrule:/(?:@[\w-]+|[+=])/m}}});delete Prism.languages.sass.atrule;var variable=/\$[-\w]+|#\{\$[-\w]+\}/;var operator=[/[+*\/%]|[=!]=|<=?|>=?|\b(?:and|or|not)\b/,{pattern:/(\s+)-(?=\s)/,lookbehind:true}];Prism.languages.insertBefore("sass","property",{"variable-line":{pattern:/^[ \t]*\$.+/m,inside:{punctuation:/:/,variable:variable,operator:operator}},"property-line":{pattern:/^[ \t]*(?:[^:\s]+ *:.*|:[^:\s]+.*)/m,inside:{property:[/[^:\s]+(?=\s*:)/,{pattern:/(:)[^:\s]+/,lookbehind:true}],punctuation:/:/,variable:variable,operator:operator,important:Prism.languages.sass.important}}});delete Prism.languages.sass.property;delete Prism.languages.sass.important;Prism.languages.insertBefore("sass","punctuation",{selector:{pattern:/([ \t]*)\S(?:,?[^,\r\n]+)*(?:,(?:\r?\n|\r)\1[ \t]+\S(?:,?[^,\r\n]+)*)*/,lookbehind:true}})})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorJava=__webpack_require__(133);module.exports=scala;scala.displayName="scala";scala.aliases=[];function scala(Prism){Prism.register(refractorJava);Prism.languages.scala=Prism.languages.extend("java",{keyword:/<-|=>|\b(?:abstract|case|catch|class|def|do|else|extends|final|finally|for|forSome|if|implicit|import|lazy|match|new|null|object|override|package|private|protected|return|sealed|self|super|this|throw|trait|try|type|val|var|while|with|yield)\b/,"triple-quoted-string":{pattern:/"""[\s\S]*?"""/,greedy:true,alias:"string"},string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:true},builtin:/\b(?:String|Int|Long|Short|Byte|Boolean|Double|Float|Char|Any|AnyRef|AnyVal|Unit|Nothing)\b/,number:/\b0x[\da-f]*\.?[\da-f]+|(?:\b\d+\.?\d*|\B\.\d+)(?:e\d+)?[dfl]?/i,symbol:/'[^\d\s\\]\w*/});delete Prism.languages.scala["class-name"];delete Prism.languages.scala["function"]}},function(module,exports,__webpack_require__){"use strict";module.exports=scss;scss.displayName="scss";scss.aliases=[];function scss(Prism){Prism.languages.scss=Prism.languages.extend("css",{comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|\/\/.*)/,lookbehind:true},atrule:{pattern:/@[\w-]+(?:\([^()]+\)|[^(])*?(?=\s+[{;])/,inside:{rule:/@[\w-]+/}},url:/(?:[-a-z]+-)?url(?=\()/i,selector:{pattern:/(?=\S)[^@;{}()]?(?:[^@;{}()]|#\{\$[-\w]+\})+(?=\s*\{(?:\}|\s|[^}]+[:{][^}]+))/m,inside:{parent:{pattern:/&/,alias:"important"},placeholder:/%[-\w]+/,variable:/\$[-\w]+|#\{\$[-\w]+\}/}},property:{pattern:/(?:[\w-]|\$[-\w]+|#\{\$[-\w]+\})+(?=\s*:)/,inside:{variable:/\$[-\w]+|#\{\$[-\w]+\}/}}});Prism.languages.insertBefore("scss","atrule",{keyword:[/@(?:if|else(?: if)?|for|each|while|import|extend|debug|warn|mixin|include|function|return|content)/i,{pattern:/( +)(?:from|through)(?= )/,lookbehind:true}]});Prism.languages.insertBefore("scss","important",{variable:/\$[-\w]+|#\{\$[-\w]+\}/});Prism.languages.insertBefore("scss","function",{placeholder:{pattern:/%[-\w]+/,alias:"selector"},statement:{pattern:/\B!(?:default|optional)\b/i,alias:"keyword"},boolean:/\b(?:true|false)\b/,null:{pattern:/\bnull\b/,alias:"keyword"},operator:{pattern:/(\s)(?:[-+*\/%]|[=!]=|<=?|>=?|and|or|not)(?=\s)/,lookbehind:true}});Prism.languages.scss["atrule"].inside.rest=Prism.languages.scss}},function(module,exports,__webpack_require__){"use strict";var refractorBash=__webpack_require__(177);module.exports=shellSession;shellSession.displayName="shellSession";shellSession.aliases=[];function shellSession(Prism){Prism.register(refractorBash);(function(Prism){var strings=[/(["'])(?:\\[\s\S]|\$\([^)]+\)|`[^`]+`|(?!\1)[^\\])*\1/.source,/<<-?\s*(["']?)(\w+)\2\s[\s\S]*?[\r\n]\3/.source].join("|");Prism.languages["shell-session"]={info:{pattern:/^[^\r\n$#*!]+(?=[$#])/m,alias:"punctuation",inside:{path:{pattern:/(:)[\s\S]+/,lookbehind:true},user:/^[^\s@:$#*!/\\]+@[^\s@:$#*!/\\]+(?=:|$)/,punctuation:/:/}},command:{pattern:RegExp(/[$#](?:[^\\\r\n'"<]|\\.|<<str>>)+/.source.replace(/<<str>>/g,(function(){return strings}))),greedy:true,inside:{bash:{pattern:/(^[$#]\s*)[\s\S]+/,lookbehind:true,alias:"language-bash",inside:Prism.languages.bash},"shell-symbol":{pattern:/^[$#]/,alias:"important"}}},output:/.(?:.*(?:[\r\n]|.$))*/};Prism.languages["sh-session"]=Prism.languages["shellsession"]=Prism.languages["shell-session"]})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=smali;smali.displayName="smali";smali.aliases=[];function smali(Prism){Prism.languages.smali={comment:/#.*/,string:{pattern:/"(?:[^\r\n\\"]|\\.)*"|'(?:[^\r\n\\']|\\(?:.|u[\da-fA-F]{4}))'/,greedy:true},"class-name":{pattern:/L(?:(?:\w+|`[^`\r\n]*`)\/)*(?:[\w$]+|`[^`\r\n]*`)(?=\s*;)/,inside:{"class-name":{pattern:/(^L|\/)(?:[\w$]+|`[^`\r\n]*`)$/,lookbehind:true},namespace:{pattern:/^(L)(?:(?:\w+|`[^`\r\n]*`)\/)+/,lookbehind:true,inside:{punctuation:/\//}},builtin:/^L/}},builtin:[{pattern:/([();\[])[BCDFIJSVZ]+/,lookbehind:true},{pattern:/([\w$>]:)[BCDFIJSVZ]/,lookbehind:true}],keyword:[{pattern:/(\.end\s+)[\w-]+/,lookbehind:true},{pattern:/(^|[^\w.-])\.(?!\d)[\w-]+/,lookbehind:true},{pattern:/(^|[^\w.-])(?:abstract|annotation|bridge|constructor|enum|final|interface|private|protected|public|runtime|static|synthetic|system|transient)(?![\w.-])/,lookbehind:true}],function:{pattern:/(^|[^\w.-])(?:\w+|<[\w$-]+>)(?=\()/,lookbehind:true},field:{pattern:/[\w$]+(?=:)/,alias:"variable"},register:{pattern:/(^|[^\w.-])[vp]\d(?![\w.-])/,lookbehind:true,alias:"variable"},boolean:{pattern:/(^|[^\w.-])(?:true|false)(?![\w.-])/,lookbehind:true},number:{pattern:/(^|[^/\w.-])-?(?:NAN|INFINITY|0x(?:[\dA-F]+(?:\.[\dA-F]*)?|\.[\dA-F]+)(?:p[+-]?[\dA-F]+)?|(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?)[dflst]?(?![\w.-])/i,lookbehind:true},label:{pattern:/(:)\w+/,lookbehind:true,alias:"property"},operator:/->|\.\.|[\[=]/,punctuation:/[{}(),;:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=smalltalk;smalltalk.displayName="smalltalk";smalltalk.aliases=[];function smalltalk(Prism){Prism.languages.smalltalk={comment:/"(?:""|[^"])*"/,character:{pattern:/\$./,alias:"string"},string:/'(?:''|[^'])*'/,symbol:/#[\da-z]+|#(?:-|([+\/\\*~<>=@%|&?!])\1?)|#(?=\()/i,"block-arguments":{pattern:/(\[\s*):[^\[|]*\|/,lookbehind:true,inside:{variable:/:[\da-z]+/i,punctuation:/\|/}},"temporary-variables":{pattern:/\|[^|]+\|/,inside:{variable:/[\da-z]+/i,punctuation:/\|/}},keyword:/\b(?:nil|true|false|self|super|new)\b/,number:[/\d+r-?[\dA-Z]+(?:\.[\dA-Z]+)?(?:e-?\d+)?/,/\b\d+(?:\.\d+)?(?:e-?\d+)?/],operator:/[<=]=?|:=|~[~=]|\/\/?|\\\\|>[>=]?|[!^+\-*&|,@]/,punctuation:/[.;:?\[\](){}]/}}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=smarty;smarty.displayName="smarty";smarty.aliases=[];function smarty(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.smarty={comment:/\{\*[\s\S]*?\*\}/,delimiter:{pattern:/^\{|\}$/i,alias:"punctuation"},string:/(["'])(?:\\.|(?!\1)[^\\\r\n])*\1/,number:/\b0x[\dA-Fa-f]+|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee][-+]?\d+)?/,variable:[/\$(?!\d)\w+/,/#(?!\d)\w+#/,{pattern:/(\.|->)(?!\d)\w+/,lookbehind:true},{pattern:/(\[)(?!\d)\w+(?=\])/,lookbehind:true}],function:[{pattern:/(\|\s*)@?(?!\d)\w+/,lookbehind:true},/^\/?(?!\d)\w+/,/(?!\d)\w+(?=\()/],"attr-name":{pattern:/\w+\s*=\s*(?:(?!\d)\w+)?/,inside:{variable:{pattern:/(=\s*)(?!\d)\w+/,lookbehind:true},operator:/=/}},punctuation:[/[\[\]().,:`]|->/],operator:[/[+\-*\/%]|==?=?|[!<>]=?|&&|\|\|?/,/\bis\s+(?:not\s+)?(?:div|even|odd)(?:\s+by)?\b/,/\b(?:eq|neq?|gt|lt|gt?e|lt?e|not|mod|or|and)\b/],keyword:/\b(?:false|off|on|no|true|yes)\b/};Prism.hooks.add("before-tokenize",(function(env){var smartyPattern=/\{\*[\s\S]*?\*\}|\{[\s\S]+?\}/g;var smartyLitteralStart="{literal}";var smartyLitteralEnd="{/literal}";var smartyLitteralMode=false;Prism.languages["markup-templating"].buildPlaceholders(env,"smarty",smartyPattern,(function(match){if(match===smartyLitteralEnd){smartyLitteralMode=false}if(!smartyLitteralMode){if(match===smartyLitteralStart){smartyLitteralMode=true}return true}return false}))}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"smarty")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=sml;sml.displayName="sml";sml.aliases=["smlnj"];function sml(Prism){(function(Prism){var keywords=/\b(?:abstype|and|andalso|as|case|datatype|do|else|end|eqtype|exception|fn|fun|functor|handle|if|in|include|infix|infixr|let|local|nonfix|of|op|open|orelse|raise|rec|sharing|sig|signature|struct|structure|then|type|val|where|while|with|withtype)\b/i;Prism.languages.sml={comment:/\(\*(?:[^*(]|\*(?!\))|\((?!\*)|\(\*(?:[^*(]|\*(?!\))|\((?!\*))*\*\))*\*\)/,string:{pattern:/#?"(?:[^"\\]|\\.)*"/,greedy:true},"class-name":[{pattern:RegExp(/((?:^|[^:]):\s*)<TERMINAL>(?:\s*(?:(?:\*|->)\s*<TERMINAL>|,\s*<TERMINAL>(?:(?=<NOT-LAST>)|(?!<NOT-LAST>)\s+<LONG-ID>)))*/.source.replace(/<NOT-LAST>/g,(function(){return/\s*(?:[*,]|->)/.source})).replace(/<TERMINAL>/g,(function(){return/(?:'[\w']*|<LONG-ID>|\((?:[^()]|\([^()]*\))*\)|\{(?:[^{}]|\{[^{}]*\})*\})(?:\s+<LONG-ID>)*/.source})).replace(/<LONG-ID>/g,(function(){return/(?!<KEYWORD>)[a-z\d_][\w'.]*/.source})).replace(/<KEYWORD>/g,(function(){return keywords.source})),"i"),lookbehind:true,greedy:true,inside:null},{pattern:/((?:^|[^\w'])(?:datatype|exception|functor|signature|structure|type)\s+)[a-z_][\w'.]*/i,lookbehind:true}],function:{pattern:/((?:^|[^\w'])fun\s+)[a-z_][\w'.]*/i,lookbehind:true},keyword:keywords,variable:{pattern:/(^|[^\w'])'[\w']*/,lookbehind:true},number:/~?\b(?:\d+(?:\.\d+)?(?:e~?\d+)?|0x[\da-f]+)\b/i,word:{pattern:/\b0w(?:\d+|x[\da-f]+)\b/i,alias:"constant"},boolean:/\b(?:false|true)\b/i,operator:/\.\.\.|:[>=:]|=>?|->|[<>]=?|[!+\-*/^#|@~]/,punctuation:/[(){}\[\].:,;]/};Prism.languages.sml["class-name"][0].inside=Prism.languages.sml;Prism.languages.smlnj=Prism.languages.sml})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=solidity;solidity.displayName="solidity";solidity.aliases=["sol"];function solidity(Prism){Prism.languages.solidity=Prism.languages.extend("clike",{"class-name":{pattern:/(\b(?:contract|enum|interface|library|new|struct|using)\s+)(?!\d)[\w$]+/,lookbehind:true},keyword:/\b(?:_|anonymous|as|assembly|assert|break|calldata|case|constant|constructor|continue|contract|default|delete|do|else|emit|enum|event|external|for|from|function|if|import|indexed|inherited|interface|internal|is|let|library|mapping|memory|modifier|new|payable|pragma|private|public|pure|require|returns?|revert|selfdestruct|solidity|storage|struct|suicide|switch|this|throw|using|var|view|while)\b/,operator:/=>|->|:=|=:|\*\*|\+\+|--|\|\||&&|<<=?|>>=?|[-+*/%^&|<>!=]=?|[~?]/});Prism.languages.insertBefore("solidity","keyword",{builtin:/\b(?:address|bool|string|u?int(?:8|16|24|32|40|48|56|64|72|80|88|96|104|112|120|128|136|144|152|160|168|176|184|192|200|208|216|224|232|240|248|256)?|byte|bytes(?:[1-9]|[12]\d|3[0-2])?)\b/});Prism.languages.insertBefore("solidity","number",{version:{pattern:/([<>]=?|\^)\d+\.\d+\.\d+\b/,lookbehind:true,alias:"number"}});Prism.languages.sol=Prism.languages.solidity}},function(module,exports,__webpack_require__){"use strict";module.exports=solutionFile;solutionFile.displayName="solutionFile";solutionFile.aliases=[];function solutionFile(Prism){(function(Prism){var guid={pattern:/\{[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12}\}/i,alias:"constant",inside:{punctuation:/[{}]/}};Prism.languages["solution-file"]={comment:{pattern:/#.*/,greedy:true},string:{pattern:/"[^"\r\n]*"|'[^'\r\n]*'/,greedy:true,inside:{guid:guid}},object:{pattern:/^([ \t]*)(?:([A-Z]\w*)\b(?=.*(?:\r\n?|\n)(?:\1[ \t].*(?:\r\n?|\n))*\1End\2(?=[ \t]*$))|End[A-Z]\w*(?=[ \t]*$))/m,lookbehind:true,greedy:true,alias:"keyword"},property:{pattern:/^([ \t]*)[^\r\n"#=()]*[^\s"#=()](?=\s*=)/m,lookbehind:true,inside:{guid:guid}},guid:guid,number:/\b\d+(?:\.\d+)*\b/,boolean:/\b(?:FALSE|TRUE)\b/,operator:/=/,punctuation:/[(),]/};Prism.languages["sln"]=Prism.languages["solution-file"]})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=soy;soy.displayName="soy";soy.aliases=[];function soy(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){var stringPattern=/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/;var numberPattern=/\b\d+(?:\.\d+)?(?:[eE][+-]?\d+)?\b|\b0x[\dA-F]+\b/;Prism.languages.soy={comment:[/\/\*[\s\S]*?\*\//,{pattern:/(\s)\/\/.*/,lookbehind:true,greedy:true}],"command-arg":{pattern:/({+\/?\s*(?:alias|call|delcall|delpackage|deltemplate|namespace|template)\s+)\.?[\w.]+/,lookbehind:true,alias:"string",inside:{punctuation:/\./}},parameter:{pattern:/({+\/?\s*@?param\??\s+)\.?[\w.]+/,lookbehind:true,alias:"variable"},keyword:[{pattern:/({+\/?[^\S\r\n]*)(?:\\[nrt]|alias|call|case|css|default|delcall|delpackage|deltemplate|else(?:if)?|fallbackmsg|for(?:each)?|if(?:empty)?|lb|let|literal|msg|namespace|nil|@?param\??|rb|sp|switch|template|xid)/,lookbehind:true},/\b(?:any|as|attributes|bool|css|float|in|int|js|html|list|map|null|number|string|uri)\b/],delimiter:{pattern:/^{+\/?|\/?}+$/,alias:"punctuation"},property:/\w+(?==)/,variable:{pattern:/\$[^\W\d]\w*(?:\??(?:\.\w+|\[[^\]]+]))*/,inside:{string:{pattern:stringPattern,greedy:true},number:numberPattern,punctuation:/[\[\].?]/}},string:{pattern:stringPattern,greedy:true},function:[/\w+(?=\()/,{pattern:/(\|[^\S\r\n]*)\w+/,lookbehind:true}],boolean:/\b(?:true|false)\b/,number:numberPattern,operator:/\?:?|<=?|>=?|==?|!=|[+*/%-]|\b(?:and|not|or)\b/,punctuation:/[{}()\[\]|.,:]/};Prism.hooks.add("before-tokenize",(function(env){var soyPattern=/{{.+?}}|{.+?}|\s\/\/.*|\/\*[\s\S]*?\*\//g;var soyLitteralStart="{literal}";var soyLitteralEnd="{/literal}";var soyLitteralMode=false;Prism.languages["markup-templating"].buildPlaceholders(env,"soy",soyPattern,(function(match){if(match===soyLitteralEnd){soyLitteralMode=false}if(!soyLitteralMode){if(match===soyLitteralStart){soyLitteralMode=true}return true}return false}))}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"soy")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorTurtle=__webpack_require__(183);module.exports=sparql;sparql.displayName="sparql";sparql.aliases=["rq"];function sparql(Prism){Prism.register(refractorTurtle);Prism.languages.sparql=Prism.languages.extend("turtle",{variable:{pattern:/[?$]\w+/,greedy:true},boolean:/\b(?:true|false)\b/i});Prism.languages.insertBefore("sparql","punctuation",{keyword:[/\b(?:A|ADD|ALL|AS|ASC|ASK|BNODE|BY|CLEAR|CONSTRUCT|COPY|CREATE|DATA|DEFAULT|DELETE|DESC|DESCRIBE|DISTINCT|DROP|EXISTS|FILTER|FROM|GROUP|HAVING|INSERT|INTO|LIMIT|LOAD|MINUS|MOVE|NAMED|NOT|NOW|OFFSET|OPTIONAL|ORDER|RAND|REDUCED|SELECT|SEPARATOR|SERVICE|SILENT|STRUUID|UNION|USING|UUID|VALUES|WHERE)\b/i,/\b(?:ABS|AVG|BIND|BOUND|CEIL|COALESCE|CONCAT|CONTAINS|COUNT|DATATYPE|DAY|ENCODE_FOR_URI|FLOOR|GROUP_CONCAT|HOURS|IF|IRI|isBLANK|isIRI|isLITERAL|isNUMERIC|isURI|LANG|LANGMATCHES|LCASE|MAX|MD5|MIN|MINUTES|MONTH|ROUND|REGEX|REPLACE|sameTerm|SAMPLE|SECONDS|SHA1|SHA256|SHA384|SHA512|STR|STRAFTER|STRBEFORE|STRDT|STRENDS|STRLANG|STRLEN|STRSTARTS|SUBSTR|SUM|TIMEZONE|TZ|UCASE|URI|YEAR)\b(?=\s*\()/i,/\b(?:GRAPH|BASE|PREFIX)\b/i]});Prism.languages.rq=Prism.languages.sparql}},function(module,exports,__webpack_require__){"use strict";module.exports=splunkSpl;splunkSpl.displayName="splunkSpl";splunkSpl.aliases=[];function splunkSpl(Prism){Prism.languages["splunk-spl"]={comment:/`comment\("(?:\\.|[^\\"])*"\)`/,string:{pattern:/"(?:\\.|[^\\"])*"/,greedy:true},keyword:/\b(?:abstract|accum|addcoltotals|addinfo|addtotals|analyzefields|anomalies|anomalousvalue|anomalydetection|append|appendcols|appendcsv|appendlookup|appendpipe|arules|associate|audit|autoregress|bin|bucket|bucketdir|chart|cluster|cofilter|collect|concurrency|contingency|convert|correlate|datamodel|dbinspect|dedup|delete|delta|diff|erex|eval|eventcount|eventstats|extract|fieldformat|fields|fieldsummary|filldown|fillnull|findtypes|folderize|foreach|format|from|gauge|gentimes|geom|geomfilter|geostats|head|highlight|history|iconify|input|inputcsv|inputlookup|iplocation|join|kmeans|kv|kvform|loadjob|localize|localop|lookup|makecontinuous|makemv|makeresults|map|mcollect|metadata|metasearch|meventcollect|mstats|multikv|multisearch|mvcombine|mvexpand|nomv|outlier|outputcsv|outputlookup|outputtext|overlap|pivot|predict|rangemap|rare|regex|relevancy|reltime|rename|replace|rest|return|reverse|rex|rtorder|run|savedsearch|script|scrub|search|searchtxn|selfjoin|sendemail|set|setfields|sichart|sirare|sistats|sitimechart|sitop|sort|spath|stats|strcat|streamstats|table|tags|tail|timechart|timewrap|top|transaction|transpose|trendline|tscollect|tstats|typeahead|typelearner|typer|union|uniq|untable|where|x11|xmlkv|xmlunescape|xpath|xyseries)\b/i,"operator-word":{pattern:/\b(?:and|as|by|not|or|xor)\b/i,alias:"operator"},function:/\w+(?=\s*\()/,property:/\w+(?=\s*=(?!=))/,date:{pattern:/\b\d{1,2}\/\d{1,2}\/\d{1,4}(?:(?::\d{1,2}){3})?\b/,alias:"number"},number:/\b\d+(?:\.\d+)?\b/,boolean:/\b(?:f|false|t|true)\b/i,operator:/[<>=]=?|[-+*/%|]/,punctuation:/[()[\],]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=sqf;sqf.displayName="sqf";sqf.aliases=[];function sqf(Prism){Prism.languages.sqf=Prism.languages.extend("clike",{string:{pattern:/"(?:(?:"")?[^"])*"(?!")|'(?:[^'])*'/,greedy:true},keyword:/\b(?:breakOut|breakTo|call|case|catch|default|do|echo|else|execVM|execFSM|exitWith|for|forEach|forEachMember|forEachMemberAgent|forEachMemberTeam|from|goto|if|nil|preprocessFile|preprocessFileLineNumbers|private|scopeName|spawn|step|switch|then|throw|to|try|while|with)\b/i,"magic-variable":{pattern:/\b(?:_exception|_fnc_scriptName|_fnc_scriptNameParent|_forEachIndex|_this|_thisEventHandler|_thisFSM|_thisScript|_x|this|thisList|thisTrigger)\b/i,alias:"keyword"},boolean:/\b(?:true|false)\b/i,function:/\b(?:abs|accTime|acos|action|actionIDs|actionKeys|actionKeysImages|actionKeysNames|actionKeysNamesArray|actionName|actionParams|activateAddons|activatedAddons|activateKey|add3DENConnection|add3DENEventHandler|add3DENLayer|addAction|addBackpack|addBackpackCargo|addBackpackCargoGlobal|addBackpackGlobal|addCamShake|addCuratorAddons|addCuratorCameraArea|addCuratorEditableObjects|addCuratorEditingArea|addCuratorPoints|addEditorObject|addEventHandler|addForce|addForceGeneratorRTD|addGoggles|addGroupIcon|addHandgunItem|addHeadgear|addItem|addItemCargo|addItemCargoGlobal|addItemPool|addItemToBackpack|addItemToUniform|addItemToVest|addLiveStats|addMagazine|addMagazineAmmoCargo|addMagazineCargo|addMagazineCargoGlobal|addMagazineGlobal|addMagazinePool|addMagazines|addMagazineTurret|addMenu|addMenuItem|addMissionEventHandler|addMPEventHandler|addMusicEventHandler|addOwnedMine|addPlayerScores|addPrimaryWeaponItem|addPublicVariableEventHandler|addRating|addResources|addScore|addScoreSide|addSecondaryWeaponItem|addSwitchableUnit|addTeamMember|addToRemainsCollector|addTorque|addUniform|addVehicle|addVest|addWaypoint|addWeapon|addWeaponCargo|addWeaponCargoGlobal|addWeaponGlobal|addWeaponItem|addWeaponPool|addWeaponTurret|admin|agent|agents|AGLToASL|aimedAtTarget|aimPos|airDensityCurveRTD|airDensityRTD|airplaneThrottle|airportSide|AISFinishHeal|alive|all3DENEntities|allAirports|allControls|allCurators|allCutLayers|allDead|allDeadMen|allDisplays|allGroups|allMapMarkers|allMines|allMissionObjects|allow3DMode|allowCrewInImmobile|allowCuratorLogicIgnoreAreas|allowDamage|allowDammage|allowFileOperations|allowFleeing|allowGetIn|allowSprint|allPlayers|allSimpleObjects|allSites|allTurrets|allUnits|allUnitsUAV|allVariables|ammo|ammoOnPylon|animate|animateBay|animateDoor|animatePylon|animateSource|animationNames|animationPhase|animationSourcePhase|animationState|append|apply|armoryPoints|arrayIntersect|asin|ASLToAGL|ASLToATL|assert|assignAsCargo|assignAsCargoIndex|assignAsCommander|assignAsDriver|assignAsGunner|assignAsTurret|assignCurator|assignedCargo|assignedCommander|assignedDriver|assignedGunner|assignedItems|assignedTarget|assignedTeam|assignedVehicle|assignedVehicleRole|assignItem|assignTeam|assignToAirport|atan|atan2|atg|ATLToASL|attachedObject|attachedObjects|attachedTo|attachObject|attachTo|attackEnabled|backpack|backpackCargo|backpackContainer|backpackItems|backpackMagazines|backpackSpaceFor|behaviour|benchmark|binocular|blufor|boundingBox|boundingBoxReal|boundingCenter|briefingName|buildingExit|buildingPos|buldozer_EnableRoadDiag|buldozer_IsEnabledRoadDiag|buldozer_LoadNewRoads|buldozer_reloadOperMap|buttonAction|buttonSetAction|cadetMode|callExtension|camCommand|camCommit|camCommitPrepared|camCommitted|camConstuctionSetParams|camCreate|camDestroy|cameraEffect|cameraEffectEnableHUD|cameraInterest|cameraOn|cameraView|campaignConfigFile|camPreload|camPreloaded|camPrepareBank|camPrepareDir|camPrepareDive|camPrepareFocus|camPrepareFov|camPrepareFovRange|camPreparePos|camPrepareRelPos|camPrepareTarget|camSetBank|camSetDir|camSetDive|camSetFocus|camSetFov|camSetFovRange|camSetPos|camSetRelPos|camSetTarget|camTarget|camUseNVG|canAdd|canAddItemToBackpack|canAddItemToUniform|canAddItemToVest|cancelSimpleTaskDestination|canFire|canMove|canSlingLoad|canStand|canSuspend|canTriggerDynamicSimulation|canUnloadInCombat|canVehicleCargo|captive|captiveNum|cbChecked|cbSetChecked|ceil|channelEnabled|cheatsEnabled|checkAIFeature|checkVisibility|civilian|className|clear3DENAttribute|clear3DENInventory|clearAllItemsFromBackpack|clearBackpackCargo|clearBackpackCargoGlobal|clearForcesRTD|clearGroupIcons|clearItemCargo|clearItemCargoGlobal|clearItemPool|clearMagazineCargo|clearMagazineCargoGlobal|clearMagazinePool|clearOverlay|clearRadio|clearVehicleInit|clearWeaponCargo|clearWeaponCargoGlobal|clearWeaponPool|clientOwner|closeDialog|closeDisplay|closeOverlay|collapseObjectTree|collect3DENHistory|collectiveRTD|combatMode|commandArtilleryFire|commandChat|commander|commandFire|commandFollow|commandFSM|commandGetOut|commandingMenu|commandMove|commandRadio|commandStop|commandSuppressiveFire|commandTarget|commandWatch|comment|commitOverlay|compile|compileFinal|completedFSM|composeText|configClasses|configFile|configHierarchy|configName|configNull|configProperties|configSourceAddonList|configSourceMod|configSourceModList|confirmSensorTarget|connectTerminalToUAV|controlNull|controlsGroupCtrl|copyFromClipboard|copyToClipboard|copyWaypoints|cos|count|countEnemy|countFriendly|countSide|countType|countUnknown|create3DENComposition|create3DENEntity|createAgent|createCenter|createDialog|createDiaryLink|createDiaryRecord|createDiarySubject|createDisplay|createGearDialog|createGroup|createGuardedPoint|createLocation|createMarker|createMarkerLocal|createMenu|createMine|createMissionDisplay|createMPCampaignDisplay|createSimpleObject|createSimpleTask|createSite|createSoundSource|createTask|createTeam|createTrigger|createUnit|createVehicle|createVehicleCrew|createVehicleLocal|crew|ctAddHeader|ctAddRow|ctClear|ctCurSel|ctData|ctFindHeaderRows|ctFindRowHeader|ctHeaderControls|ctHeaderCount|ctRemoveHeaders|ctRemoveRows|ctrlActivate|ctrlAddEventHandler|ctrlAngle|ctrlAutoScrollDelay|ctrlAutoScrollRewind|ctrlAutoScrollSpeed|ctrlChecked|ctrlClassName|ctrlCommit|ctrlCommitted|ctrlCreate|ctrlDelete|ctrlEnable|ctrlEnabled|ctrlFade|ctrlHTMLLoaded|ctrlIDC|ctrlIDD|ctrlMapAnimAdd|ctrlMapAnimClear|ctrlMapAnimCommit|ctrlMapAnimDone|ctrlMapCursor|ctrlMapMouseOver|ctrlMapScale|ctrlMapScreenToWorld|ctrlMapWorldToScreen|ctrlModel|ctrlModelDirAndUp|ctrlModelScale|ctrlParent|ctrlParentControlsGroup|ctrlPosition|ctrlRemoveAllEventHandlers|ctrlRemoveEventHandler|ctrlScale|ctrlSetActiveColor|ctrlSetAngle|ctrlSetAutoScrollDelay|ctrlSetAutoScrollRewind|ctrlSetAutoScrollSpeed|ctrlSetBackgroundColor|ctrlSetChecked|ctrlSetDisabledColor|ctrlSetEventHandler|ctrlSetFade|ctrlSetFocus|ctrlSetFont|ctrlSetFontH1|ctrlSetFontH1B|ctrlSetFontH2|ctrlSetFontH2B|ctrlSetFontH3|ctrlSetFontH3B|ctrlSetFontH4|ctrlSetFontH4B|ctrlSetFontH5|ctrlSetFontH5B|ctrlSetFontH6|ctrlSetFontH6B|ctrlSetFontHeight|ctrlSetFontHeightH1|ctrlSetFontHeightH2|ctrlSetFontHeightH3|ctrlSetFontHeightH4|ctrlSetFontHeightH5|ctrlSetFontHeightH6|ctrlSetFontHeightSecondary|ctrlSetFontP|ctrlSetFontPB|ctrlSetFontSecondary|ctrlSetForegroundColor|ctrlSetModel|ctrlSetModelDirAndUp|ctrlSetModelScale|ctrlSetPixelPrecision|ctrlSetPosition|ctrlSetScale|ctrlSetStructuredText|ctrlSetText|ctrlSetTextColor|ctrlSetTextColorSecondary|ctrlSetTextSecondary|ctrlSetTooltip|ctrlSetTooltipColorBox|ctrlSetTooltipColorShade|ctrlSetTooltipColorText|ctrlShow|ctrlShown|ctrlText|ctrlTextHeight|ctrlTextSecondary|ctrlTextWidth|ctrlType|ctrlVisible|ctRowControls|ctRowCount|ctSetCurSel|ctSetData|ctSetHeaderTemplate|ctSetRowTemplate|ctSetValue|ctValue|curatorAddons|curatorCamera|curatorCameraArea|curatorCameraAreaCeiling|curatorCoef|curatorEditableObjects|curatorEditingArea|curatorEditingAreaType|curatorMouseOver|curatorPoints|curatorRegisteredObjects|curatorSelected|curatorWaypointCost|current3DENOperation|currentChannel|currentCommand|currentMagazine|currentMagazineDetail|currentMagazineDetailTurret|currentMagazineTurret|currentMuzzle|currentNamespace|currentTask|currentTasks|currentThrowable|currentVisionMode|currentWaypoint|currentWeapon|currentWeaponMode|currentWeaponTurret|currentZeroing|cursorObject|cursorTarget|customChat|customRadio|cutFadeOut|cutObj|cutRsc|cutText|damage|date|dateToNumber|daytime|deActivateKey|debriefingText|debugFSM|debugLog|deg|delete3DENEntities|deleteAt|deleteCenter|deleteCollection|deleteEditorObject|deleteGroup|deleteGroupWhenEmpty|deleteIdentity|deleteLocation|deleteMarker|deleteMarkerLocal|deleteRange|deleteResources|deleteSite|deleteStatus|deleteTeam|deleteVehicle|deleteVehicleCrew|deleteWaypoint|detach|detectedMines|diag_activeMissionFSMs|diag_activeScripts|diag_activeSQFScripts|diag_activeSQSScripts|diag_captureFrame|diag_captureFrameToFile|diag_captureSlowFrame|diag_codePerformance|diag_drawMode|diag_dynamicSimulationEnd|diag_enable|diag_enabled|diag_fps|diag_fpsMin|diag_frameNo|diag_lightNewLoad|diag_list|diag_log|diag_logSlowFrame|diag_mergeConfigFile|diag_recordTurretLimits|diag_setLightNew|diag_tickTime|diag_toggle|dialog|diarySubjectExists|didJIP|didJIPOwner|difficulty|difficultyEnabled|difficultyEnabledRTD|difficultyOption|direction|directSay|disableAI|disableCollisionWith|disableConversation|disableDebriefingStats|disableMapIndicators|disableNVGEquipment|disableRemoteSensors|disableSerialization|disableTIEquipment|disableUAVConnectability|disableUserInput|displayAddEventHandler|displayCtrl|displayNull|displayParent|displayRemoveAllEventHandlers|displayRemoveEventHandler|displaySetEventHandler|dissolveTeam|distance|distance2D|distanceSqr|distributionRegion|do3DENAction|doArtilleryFire|doFire|doFollow|doFSM|doGetOut|doMove|doorPhase|doStop|doSuppressiveFire|doTarget|doWatch|drawArrow|drawEllipse|drawIcon|drawIcon3D|drawLine|drawLine3D|drawLink|drawLocation|drawPolygon|drawRectangle|drawTriangle|driver|drop|dynamicSimulationDistance|dynamicSimulationDistanceCoef|dynamicSimulationEnabled|dynamicSimulationSystemEnabled|east|edit3DENMissionAttributes|editObject|editorSetEventHandler|effectiveCommander|emptyPositions|enableAI|enableAIFeature|enableAimPrecision|enableAttack|enableAudioFeature|enableAutoStartUpRTD|enableAutoTrimRTD|enableCamShake|enableCaustics|enableChannel|enableCollisionWith|enableCopilot|enableDebriefingStats|enableDiagLegend|enableDynamicSimulation|enableDynamicSimulationSystem|enableEndDialog|enableEngineArtillery|enableEnvironment|enableFatigue|enableGunLights|enableInfoPanelComponent|enableIRLasers|enableMimics|enablePersonTurret|enableRadio|enableReload|enableRopeAttach|enableSatNormalOnDetail|enableSaving|enableSentences|enableSimulation|enableSimulationGlobal|enableStamina|enableStressDamage|enableTeamSwitch|enableTraffic|enableUAVConnectability|enableUAVWaypoints|enableVehicleCargo|enableVehicleSensor|enableWeaponDisassembly|endl|endLoadingScreen|endMission|engineOn|enginesIsOnRTD|enginesPowerRTD|enginesRpmRTD|enginesTorqueRTD|entities|environmentEnabled|estimatedEndServerTime|estimatedTimeLeft|evalObjectArgument|everyBackpack|everyContainer|exec|execEditorScript|exp|expectedDestination|exportJIPMessages|eyeDirection|eyePos|face|faction|fadeMusic|fadeRadio|fadeSound|fadeSpeech|failMission|fillWeaponsFromPool|find|findCover|findDisplay|findEditorObject|findEmptyPosition|findEmptyPositionReady|findIf|findNearestEnemy|finishMissionInit|finite|fire|fireAtTarget|firstBackpack|flag|flagAnimationPhase|flagOwner|flagSide|flagTexture|fleeing|floor|flyInHeight|flyInHeightASL|fog|fogForecast|fogParams|forceAddUniform|forceAtPositionRTD|forcedMap|forceEnd|forceFlagTexture|forceFollowRoad|forceGeneratorRTD|forceMap|forceRespawn|forceSpeed|forceWalk|forceWeaponFire|forceWeatherChange|forgetTarget|format|formation|formationDirection|formationLeader|formationMembers|formationPosition|formationTask|formatText|formLeader|freeLook|fromEditor|fuel|fullCrew|gearIDCAmmoCount|gearSlotAmmoCount|gearSlotData|get3DENActionState|get3DENAttribute|get3DENCamera|get3DENConnections|get3DENEntity|get3DENEntityID|get3DENGrid|get3DENIconsVisible|get3DENLayerEntities|get3DENLinesVisible|get3DENMissionAttribute|get3DENMouseOver|get3DENSelected|getAimingCoef|getAllEnvSoundControllers|getAllHitPointsDamage|getAllOwnedMines|getAllSoundControllers|getAmmoCargo|getAnimAimPrecision|getAnimSpeedCoef|getArray|getArtilleryAmmo|getArtilleryComputerSettings|getArtilleryETA|getAssignedCuratorLogic|getAssignedCuratorUnit|getBackpackCargo|getBleedingRemaining|getBurningValue|getCameraViewDirection|getCargoIndex|getCenterOfMass|getClientState|getClientStateNumber|getCompatiblePylonMagazines|getConnectedUAV|getContainerMaxLoad|getCursorObjectParams|getCustomAimCoef|getDammage|getDescription|getDir|getDirVisual|getDLCAssetsUsage|getDLCAssetsUsageByName|getDLCs|getDLCUsageTime|getEditorCamera|getEditorMode|getEditorObjectScope|getElevationOffset|getEngineTargetRpmRTD|getEnvSoundController|getFatigue|getFieldManualStartPage|getForcedFlagTexture|getFriend|getFSMVariable|getFuelCargo|getGroupIcon|getGroupIconParams|getGroupIcons|getHideFrom|getHit|getHitIndex|getHitPointDamage|getItemCargo|getMagazineCargo|getMarkerColor|getMarkerPos|getMarkerSize|getMarkerType|getMass|getMissionConfig|getMissionConfigValue|getMissionDLCs|getMissionLayerEntities|getMissionLayers|getModelInfo|getMousePosition|getMusicPlayedTime|getNumber|getObjectArgument|getObjectChildren|getObjectDLC|getObjectMaterials|getObjectProxy|getObjectTextures|getObjectType|getObjectViewDistance|getOxygenRemaining|getPersonUsedDLCs|getPilotCameraDirection|getPilotCameraPosition|getPilotCameraRotation|getPilotCameraTarget|getPlateNumber|getPlayerChannel|getPlayerScores|getPlayerUID|getPlayerUIDOld|getPos|getPosASL|getPosASLVisual|getPosASLW|getPosATL|getPosATLVisual|getPosVisual|getPosWorld|getPylonMagazines|getRelDir|getRelPos|getRemoteSensorsDisabled|getRepairCargo|getResolution|getRotorBrakeRTD|getShadowDistance|getShotParents|getSlingLoad|getSoundController|getSoundControllerResult|getSpeed|getStamina|getStatValue|getSuppression|getTerrainGrid|getTerrainHeightASL|getText|getTotalDLCUsageTime|getTrimOffsetRTD|getUnitLoadout|getUnitTrait|getUserMFDText|getUserMFDValue|getVariable|getVehicleCargo|getWeaponCargo|getWeaponSway|getWingsOrientationRTD|getWingsPositionRTD|getWPPos|glanceAt|globalChat|globalRadio|goggles|group|groupChat|groupFromNetId|groupIconSelectable|groupIconsVisible|groupId|groupOwner|groupRadio|groupSelectedUnits|groupSelectUnit|grpNull|gunner|gusts|halt|handgunItems|handgunMagazine|handgunWeapon|handsHit|hasInterface|hasPilotCamera|hasWeapon|hcAllGroups|hcGroupParams|hcLeader|hcRemoveAllGroups|hcRemoveGroup|hcSelected|hcSelectGroup|hcSetGroup|hcShowBar|hcShownBar|headgear|hideBody|hideObject|hideObjectGlobal|hideSelection|hint|hintC|hintCadet|hintSilent|hmd|hostMission|htmlLoad|HUDMovementLevels|humidity|image|importAllGroups|importance|in|inArea|inAreaArray|incapacitatedState|independent|inflame|inflamed|infoPanel|infoPanelComponentEnabled|infoPanelComponents|infoPanels|inGameUISetEventHandler|inheritsFrom|initAmbientLife|inPolygon|inputAction|inRangeOfArtillery|insertEditorObject|intersect|is3DEN|is3DENMultiplayer|isAbleToBreathe|isAgent|isAimPrecisionEnabled|isArray|isAutoHoverOn|isAutonomous|isAutoStartUpEnabledRTD|isAutotest|isAutoTrimOnRTD|isBleeding|isBurning|isClass|isCollisionLightOn|isCopilotEnabled|isDamageAllowed|isDedicated|isDLCAvailable|isEngineOn|isEqualTo|isEqualType|isEqualTypeAll|isEqualTypeAny|isEqualTypeArray|isEqualTypeParams|isFilePatchingEnabled|isFlashlightOn|isFlatEmpty|isForcedWalk|isFormationLeader|isGroupDeletedWhenEmpty|isHidden|isInRemainsCollector|isInstructorFigureEnabled|isIRLaserOn|isKeyActive|isKindOf|isLaserOn|isLightOn|isLocalized|isManualFire|isMarkedForCollection|isMultiplayer|isMultiplayerSolo|isNil|isNull|isNumber|isObjectHidden|isObjectRTD|isOnRoad|isPipEnabled|isPlayer|isRealTime|isRemoteExecuted|isRemoteExecutedJIP|isServer|isShowing3DIcons|isSimpleObject|isSprintAllowed|isStaminaEnabled|isSteamMission|isStreamFriendlyUIEnabled|isStressDamageEnabled|isText|isTouchingGround|isTurnedOut|isTutHintsEnabled|isUAVConnectable|isUAVConnected|isUIContext|isUniformAllowed|isVehicleCargo|isVehicleRadarOn|isVehicleSensorEnabled|isWalking|isWeaponDeployed|isWeaponRested|itemCargo|items|itemsWithMagazines|join|joinAs|joinAsSilent|joinSilent|joinString|kbAddDatabase|kbAddDatabaseTargets|kbAddTopic|kbHasTopic|kbReact|kbRemoveTopic|kbTell|kbWasSaid|keyImage|keyName|knowsAbout|land|landAt|landResult|language|laserTarget|lbAdd|lbClear|lbColor|lbColorRight|lbCurSel|lbData|lbDelete|lbIsSelected|lbPicture|lbPictureRight|lbSelection|lbSetColor|lbSetColorRight|lbSetCurSel|lbSetData|lbSetPicture|lbSetPictureColor|lbSetPictureColorDisabled|lbSetPictureColorSelected|lbSetPictureRight|lbSetPictureRightColor|lbSetPictureRightColorDisabled|lbSetPictureRightColorSelected|lbSetSelectColor|lbSetSelectColorRight|lbSetSelected|lbSetText|lbSetTextRight|lbSetTooltip|lbSetValue|lbSize|lbSort|lbSortByValue|lbText|lbTextRight|lbValue|leader|leaderboardDeInit|leaderboardGetRows|leaderboardInit|leaderboardRequestRowsFriends|leaderboardRequestRowsGlobal|leaderboardRequestRowsGlobalAroundUser|leaderboardsRequestUploadScore|leaderboardsRequestUploadScoreKeepBest|leaderboardState|leaveVehicle|libraryCredits|libraryDisclaimers|lifeState|lightAttachObject|lightDetachObject|lightIsOn|lightnings|limitSpeed|linearConversion|lineBreak|lineIntersects|lineIntersectsObjs|lineIntersectsSurfaces|lineIntersectsWith|linkItem|list|listObjects|listRemoteTargets|listVehicleSensors|ln|lnbAddArray|lnbAddColumn|lnbAddRow|lnbClear|lnbColor|lnbColorRight|lnbCurSelRow|lnbData|lnbDeleteColumn|lnbDeleteRow|lnbGetColumnsPosition|lnbPicture|lnbPictureRight|lnbSetColor|lnbSetColorRight|lnbSetColumnsPos|lnbSetCurSelRow|lnbSetData|lnbSetPicture|lnbSetPictureColor|lnbSetPictureColorRight|lnbSetPictureColorSelected|lnbSetPictureColorSelectedRight|lnbSetPictureRight|lnbSetText|lnbSetTextRight|lnbSetValue|lnbSize|lnbSort|lnbSortByValue|lnbText|lnbTextRight|lnbValue|load|loadAbs|loadBackpack|loadFile|loadGame|loadIdentity|loadMagazine|loadOverlay|loadStatus|loadUniform|loadVest|local|localize|locationNull|locationPosition|lock|lockCameraTo|lockCargo|lockDriver|locked|lockedCargo|lockedDriver|lockedTurret|lockIdentity|lockTurret|lockWP|log|logEntities|logNetwork|logNetworkTerminate|lookAt|lookAtPos|magazineCargo|magazines|magazinesAllTurrets|magazinesAmmo|magazinesAmmoCargo|magazinesAmmoFull|magazinesDetail|magazinesDetailBackpack|magazinesDetailUniform|magazinesDetailVest|magazinesTurret|magazineTurretAmmo|mapAnimAdd|mapAnimClear|mapAnimCommit|mapAnimDone|mapCenterOnCamera|mapGridPosition|markAsFinishedOnSteam|markerAlpha|markerBrush|markerColor|markerDir|markerPos|markerShape|markerSize|markerText|markerType|max|members|menuAction|menuAdd|menuChecked|menuClear|menuCollapse|menuData|menuDelete|menuEnable|menuEnabled|menuExpand|menuHover|menuPicture|menuSetAction|menuSetCheck|menuSetData|menuSetPicture|menuSetValue|menuShortcut|menuShortcutText|menuSize|menuSort|menuText|menuURL|menuValue|min|mineActive|mineDetectedBy|missionConfigFile|missionDifficulty|missionName|missionNamespace|missionStart|missionVersion|modelToWorld|modelToWorldVisual|modelToWorldVisualWorld|modelToWorldWorld|modParams|moonIntensity|moonPhase|morale|move|move3DENCamera|moveInAny|moveInCargo|moveInCommander|moveInDriver|moveInGunner|moveInTurret|moveObjectToEnd|moveOut|moveTime|moveTo|moveToCompleted|moveToFailed|musicVolume|name|nameSound|nearEntities|nearestBuilding|nearestLocation|nearestLocations|nearestLocationWithDubbing|nearestObject|nearestObjects|nearestTerrainObjects|nearObjects|nearObjectsReady|nearRoads|nearSupplies|nearTargets|needReload|netId|netObjNull|newOverlay|nextMenuItemIndex|nextWeatherChange|nMenuItems|numberOfEnginesRTD|numberToDate|objectCurators|objectFromNetId|objectParent|objNull|objStatus|onBriefingGear|onBriefingGroup|onBriefingNotes|onBriefingPlan|onBriefingTeamSwitch|onCommandModeChanged|onDoubleClick|onEachFrame|onGroupIconClick|onGroupIconOverEnter|onGroupIconOverLeave|onHCGroupSelectionChanged|onMapSingleClick|onPlayerConnected|onPlayerDisconnected|onPreloadFinished|onPreloadStarted|onShowNewObject|onTeamSwitch|openCuratorInterface|openDLCPage|openDSInterface|openMap|openSteamApp|openYoutubeVideo|opfor|orderGetIn|overcast|overcastForecast|owner|param|params|parseNumber|parseSimpleArray|parseText|parsingNamespace|particlesQuality|pi|pickWeaponPool|pitch|pixelGrid|pixelGridBase|pixelGridNoUIScale|pixelH|pixelW|playableSlotsNumber|playableUnits|playAction|playActionNow|player|playerRespawnTime|playerSide|playersNumber|playGesture|playMission|playMove|playMoveNow|playMusic|playScriptedMission|playSound|playSound3D|position|positionCameraToWorld|posScreenToWorld|posWorldToScreen|ppEffectAdjust|ppEffectCommit|ppEffectCommitted|ppEffectCreate|ppEffectDestroy|ppEffectEnable|ppEffectEnabled|ppEffectForceInNVG|precision|preloadCamera|preloadObject|preloadSound|preloadTitleObj|preloadTitleRsc|primaryWeapon|primaryWeaponItems|primaryWeaponMagazine|priority|processDiaryLink|processInitCommands|productVersion|profileName|profileNamespace|profileNameSteam|progressLoadingScreen|progressPosition|progressSetPosition|publicVariable|publicVariableClient|publicVariableServer|pushBack|pushBackUnique|putWeaponPool|queryItemsPool|queryMagazinePool|queryWeaponPool|rad|radioChannelAdd|radioChannelCreate|radioChannelRemove|radioChannelSetCallSign|radioChannelSetLabel|radioVolume|rain|rainbow|random|rank|rankId|rating|rectangular|registeredTasks|registerTask|reload|reloadEnabled|remoteControl|remoteExec|remoteExecCall|remoteExecutedOwner|remove3DENConnection|remove3DENEventHandler|remove3DENLayer|removeAction|removeAll3DENEventHandlers|removeAllActions|removeAllAssignedItems|removeAllContainers|removeAllCuratorAddons|removeAllCuratorCameraAreas|removeAllCuratorEditingAreas|removeAllEventHandlers|removeAllHandgunItems|removeAllItems|removeAllItemsWithMagazines|removeAllMissionEventHandlers|removeAllMPEventHandlers|removeAllMusicEventHandlers|removeAllOwnedMines|removeAllPrimaryWeaponItems|removeAllWeapons|removeBackpack|removeBackpackGlobal|removeCuratorAddons|removeCuratorCameraArea|removeCuratorEditableObjects|removeCuratorEditingArea|removeDrawIcon|removeDrawLinks|removeEventHandler|removeFromRemainsCollector|removeGoggles|removeGroupIcon|removeHandgunItem|removeHeadgear|removeItem|removeItemFromBackpack|removeItemFromUniform|removeItemFromVest|removeItems|removeMagazine|removeMagazineGlobal|removeMagazines|removeMagazinesTurret|removeMagazineTurret|removeMenuItem|removeMissionEventHandler|removeMPEventHandler|removeMusicEventHandler|removeOwnedMine|removePrimaryWeaponItem|removeSecondaryWeaponItem|removeSimpleTask|removeSwitchableUnit|removeTeamMember|removeUniform|removeVest|removeWeapon|removeWeaponAttachmentCargo|removeWeaponCargo|removeWeaponGlobal|removeWeaponTurret|reportRemoteTarget|requiredVersion|resetCamShake|resetSubgroupDirection|resistance|resize|resources|respawnVehicle|restartEditorCamera|reveal|revealMine|reverse|reversedMouseY|roadAt|roadsConnectedTo|roleDescription|ropeAttachedObjects|ropeAttachedTo|ropeAttachEnabled|ropeAttachTo|ropeCreate|ropeCut|ropeDestroy|ropeDetach|ropeEndPosition|ropeLength|ropes|ropeUnwind|ropeUnwound|rotorsForcesRTD|rotorsRpmRTD|round|runInitScript|safeZoneH|safeZoneW|safeZoneWAbs|safeZoneX|safeZoneXAbs|safeZoneY|save3DENInventory|saveGame|saveIdentity|saveJoysticks|saveOverlay|saveProfileNamespace|saveStatus|saveVar|savingEnabled|say|say2D|say3D|score|scoreSide|screenshot|screenToWorld|scriptDone|scriptName|scriptNull|scudState|secondaryWeapon|secondaryWeaponItems|secondaryWeaponMagazine|select|selectBestPlaces|selectDiarySubject|selectedEditorObjects|selectEditorObject|selectionNames|selectionPosition|selectLeader|selectMax|selectMin|selectNoPlayer|selectPlayer|selectRandom|selectRandomWeighted|selectWeapon|selectWeaponTurret|sendAUMessage|sendSimpleCommand|sendTask|sendTaskResult|sendUDPMessage|serverCommand|serverCommandAvailable|serverCommandExecutable|serverName|serverTime|set|set3DENAttribute|set3DENAttributes|set3DENGrid|set3DENIconsVisible|set3DENLayer|set3DENLinesVisible|set3DENLogicType|set3DENMissionAttribute|set3DENMissionAttributes|set3DENModelsVisible|set3DENObjectType|set3DENSelected|setAccTime|setActualCollectiveRTD|setAirplaneThrottle|setAirportSide|setAmmo|setAmmoCargo|setAmmoOnPylon|setAnimSpeedCoef|setAperture|setApertureNew|setArmoryPoints|setAttributes|setAutonomous|setBehaviour|setBleedingRemaining|setBrakesRTD|setCameraInterest|setCamShakeDefParams|setCamShakeParams|setCamUseTI|setCaptive|setCenterOfMass|setCollisionLight|setCombatMode|setCompassOscillation|setConvoySeparation|setCuratorCameraAreaCeiling|setCuratorCoef|setCuratorEditingAreaType|setCuratorWaypointCost|setCurrentChannel|setCurrentTask|setCurrentWaypoint|setCustomAimCoef|setCustomWeightRTD|setDamage|setDammage|setDate|setDebriefingText|setDefaultCamera|setDestination|setDetailMapBlendPars|setDir|setDirection|setDrawIcon|setDriveOnPath|setDropInterval|setDynamicSimulationDistance|setDynamicSimulationDistanceCoef|setEditorMode|setEditorObjectScope|setEffectCondition|setEngineRpmRTD|setFace|setFaceAnimation|setFatigue|setFeatureType|setFlagAnimationPhase|setFlagOwner|setFlagSide|setFlagTexture|setFog|setForceGeneratorRTD|setFormation|setFormationTask|setFormDir|setFriend|setFromEditor|setFSMVariable|setFuel|setFuelCargo|setGroupIcon|setGroupIconParams|setGroupIconsSelectable|setGroupIconsVisible|setGroupId|setGroupIdGlobal|setGroupOwner|setGusts|setHideBehind|setHit|setHitIndex|setHitPointDamage|setHorizonParallaxCoef|setHUDMovementLevels|setIdentity|setImportance|setInfoPanel|setLeader|setLightAmbient|setLightAttenuation|setLightBrightness|setLightColor|setLightDayLight|setLightFlareMaxDistance|setLightFlareSize|setLightIntensity|setLightnings|setLightUseFlare|setLocalWindParams|setMagazineTurretAmmo|setMarkerAlpha|setMarkerAlphaLocal|setMarkerBrush|setMarkerBrushLocal|setMarkerColor|setMarkerColorLocal|setMarkerDir|setMarkerDirLocal|setMarkerPos|setMarkerPosLocal|setMarkerShape|setMarkerShapeLocal|setMarkerSize|setMarkerSizeLocal|setMarkerText|setMarkerTextLocal|setMarkerType|setMarkerTypeLocal|setMass|setMimic|setMousePosition|setMusicEffect|setMusicEventHandler|setName|setNameSound|setObjectArguments|setObjectMaterial|setObjectMaterialGlobal|setObjectProxy|setObjectTexture|setObjectTextureGlobal|setObjectViewDistance|setOvercast|setOwner|setOxygenRemaining|setParticleCircle|setParticleClass|setParticleFire|setParticleParams|setParticleRandom|setPilotCameraDirection|setPilotCameraRotation|setPilotCameraTarget|setPilotLight|setPiPEffect|setPitch|setPlateNumber|setPlayable|setPlayerRespawnTime|setPos|setPosASL|setPosASL2|setPosASLW|setPosATL|setPosition|setPosWorld|setPylonLoadOut|setPylonsPriority|setRadioMsg|setRain|setRainbow|setRandomLip|setRank|setRectangular|setRepairCargo|setRotorBrakeRTD|setShadowDistance|setShotParents|setSide|setSimpleTaskAlwaysVisible|setSimpleTaskCustomData|setSimpleTaskDescription|setSimpleTaskDestination|setSimpleTaskTarget|setSimpleTaskType|setSimulWeatherLayers|setSize|setSkill|setSlingLoad|setSoundEffect|setSpeaker|setSpeech|setSpeedMode|setStamina|setStaminaScheme|setStatValue|setSuppression|setSystemOfUnits|setTargetAge|setTaskMarkerOffset|setTaskResult|setTaskState|setTerrainGrid|setText|setTimeMultiplier|setTitleEffect|setToneMapping|setToneMappingParams|setTrafficDensity|setTrafficDistance|setTrafficGap|setTrafficSpeed|setTriggerActivation|setTriggerArea|setTriggerStatements|setTriggerText|setTriggerTimeout|setTriggerType|setType|setUnconscious|setUnitAbility|setUnitLoadout|setUnitPos|setUnitPosWeak|setUnitRank|setUnitRecoilCoefficient|setUnitTrait|setUnloadInCombat|setUserActionText|setUserMFDText|setUserMFDValue|setVariable|setVectorDir|setVectorDirAndUp|setVectorUp|setVehicleAmmo|setVehicleAmmoDef|setVehicleArmor|setVehicleCargo|setVehicleId|setVehicleInit|setVehicleLock|setVehiclePosition|setVehicleRadar|setVehicleReceiveRemoteTargets|setVehicleReportOwnPosition|setVehicleReportRemoteTargets|setVehicleTIPars|setVehicleVarName|setVelocity|setVelocityModelSpace|setVelocityTransformation|setViewDistance|setVisibleIfTreeCollapsed|setWantedRpmRTD|setWaves|setWaypointBehaviour|setWaypointCombatMode|setWaypointCompletionRadius|setWaypointDescription|setWaypointForceBehaviour|setWaypointFormation|setWaypointHousePosition|setWaypointLoiterRadius|setWaypointLoiterType|setWaypointName|setWaypointPosition|setWaypointScript|setWaypointSpeed|setWaypointStatements|setWaypointTimeout|setWaypointType|setWaypointVisible|setWeaponReloadingTime|setWind|setWindDir|setWindForce|setWindStr|setWingForceScaleRTD|setWPPos|show3DIcons|showChat|showCinemaBorder|showCommandingMenu|showCompass|showCuratorCompass|showGPS|showHUD|showLegend|showMap|shownArtilleryComputer|shownChat|shownCompass|shownCuratorCompass|showNewEditorObject|shownGPS|shownHUD|shownMap|shownPad|shownRadio|shownScoretable|shownUAVFeed|shownWarrant|shownWatch|showPad|showRadio|showScoretable|showSubtitles|showUAVFeed|showWarrant|showWatch|showWaypoint|showWaypoints|side|sideAmbientLife|sideChat|sideEmpty|sideEnemy|sideFriendly|sideLogic|sideRadio|sideUnknown|simpleTasks|simulationEnabled|simulCloudDensity|simulCloudOcclusion|simulInClouds|simulWeatherSync|sin|size|sizeOf|skill|skillFinal|skipTime|sleep|sliderPosition|sliderRange|sliderSetPosition|sliderSetRange|sliderSetSpeed|sliderSpeed|slingLoadAssistantShown|soldierMagazines|someAmmo|sort|soundVolume|speaker|speed|speedMode|splitString|sqrt|squadParams|stance|startLoadingScreen|stop|stopEngineRTD|stopped|str|sunOrMoon|supportInfo|suppressFor|surfaceIsWater|surfaceNormal|surfaceType|swimInDepth|switchableUnits|switchAction|switchCamera|switchGesture|switchLight|switchMove|synchronizedObjects|synchronizedTriggers|synchronizedWaypoints|synchronizeObjectsAdd|synchronizeObjectsRemove|synchronizeTrigger|synchronizeWaypoint|systemChat|systemOfUnits|tan|targetKnowledge|targets|targetsAggregate|targetsQuery|taskAlwaysVisible|taskChildren|taskCompleted|taskCustomData|taskDescription|taskDestination|taskHint|taskMarkerOffset|taskNull|taskParent|taskResult|taskState|taskType|teamMember|teamMemberNull|teamName|teams|teamSwitch|teamSwitchEnabled|teamType|terminate|terrainIntersect|terrainIntersectASL|terrainIntersectAtASL|text|textLog|textLogFormat|tg|time|timeMultiplier|titleCut|titleFadeOut|titleObj|titleRsc|titleText|toArray|toFixed|toLower|toString|toUpper|triggerActivated|triggerActivation|triggerArea|triggerAttachedVehicle|triggerAttachObject|triggerAttachVehicle|triggerDynamicSimulation|triggerStatements|triggerText|triggerTimeout|triggerTimeoutCurrent|triggerType|turretLocal|turretOwner|turretUnit|tvAdd|tvClear|tvCollapse|tvCollapseAll|tvCount|tvCurSel|tvData|tvDelete|tvExpand|tvExpandAll|tvPicture|tvPictureRight|tvSetColor|tvSetCurSel|tvSetData|tvSetPicture|tvSetPictureColor|tvSetPictureColorDisabled|tvSetPictureColorSelected|tvSetPictureRight|tvSetPictureRightColor|tvSetPictureRightColorDisabled|tvSetPictureRightColorSelected|tvSetSelectColor|tvSetText|tvSetTooltip|tvSetValue|tvSort|tvSortByValue|tvText|tvTooltip|tvValue|type|typeName|typeOf|UAVControl|uiNamespace|uiSleep|unassignCurator|unassignItem|unassignTeam|unassignVehicle|underwater|uniform|uniformContainer|uniformItems|uniformMagazines|unitAddons|unitAimPosition|unitAimPositionVisual|unitBackpack|unitIsUAV|unitPos|unitReady|unitRecoilCoefficient|units|unitsBelowHeight|unlinkItem|unlockAchievement|unregisterTask|updateDrawIcon|updateMenuItem|updateObjectTree|useAIOperMapObstructionTest|useAISteeringComponent|useAudioTimeForMoves|userInputDisabled|vectorAdd|vectorCos|vectorCrossProduct|vectorDiff|vectorDir|vectorDirVisual|vectorDistance|vectorDistanceSqr|vectorDotProduct|vectorFromTo|vectorMagnitude|vectorMagnitudeSqr|vectorModelToWorld|vectorModelToWorldVisual|vectorMultiply|vectorNormalized|vectorUp|vectorUpVisual|vectorWorldToModel|vectorWorldToModelVisual|vehicle|vehicleCargoEnabled|vehicleChat|vehicleRadio|vehicleReceiveRemoteTargets|vehicleReportOwnPosition|vehicleReportRemoteTargets|vehicles|vehicleVarName|velocity|velocityModelSpace|verifySignature|vest|vestContainer|vestItems|vestMagazines|viewDistance|visibleCompass|visibleGPS|visibleMap|visiblePosition|visiblePositionASL|visibleScoretable|visibleWatch|waitUntil|waves|waypointAttachedObject|waypointAttachedVehicle|waypointAttachObject|waypointAttachVehicle|waypointBehaviour|waypointCombatMode|waypointCompletionRadius|waypointDescription|waypointForceBehaviour|waypointFormation|waypointHousePosition|waypointLoiterRadius|waypointLoiterType|waypointName|waypointPosition|waypoints|waypointScript|waypointsEnabledUAV|waypointShow|waypointSpeed|waypointStatements|waypointTimeout|waypointTimeoutCurrent|waypointType|waypointVisible|weaponAccessories|weaponAccessoriesCargo|weaponCargo|weaponDirection|weaponInertia|weaponLowered|weapons|weaponsItems|weaponsItemsCargo|weaponState|weaponsTurret|weightRTD|west|WFSideText|wind|windDir|windRTD|windStr|wingsForcesRTD|worldName|worldSize|worldToModel|worldToModelVisual|worldToScreen)\b/i,number:/(?:\$|\b0x)[\da-f]+\b|(?:\B\.\d+|\b\d+(?:\.\d+)?)(?:e[+-]?\d+)?\b/i,operator:/##|>>|&&|\|\||[!=<>]=?|[-+*/%#^]|\b(?:and|mod|not|or)\b/i,constant:/\bDIK(?:_[a-z\d]+)+\b/i});Prism.languages.insertBefore("sqf","string",{macro:{pattern:/(^\s*)#[a-z]+(?:[^\r\n\\]|\\(?:\r\n|[\s\S]))*/im,lookbehind:true,greedy:true,alias:"property",inside:{directive:{pattern:/#[a-z]+\b/i,alias:"keyword"},comment:Prism.languages.sqf.comment}}});delete Prism.languages.sqf["class-name"]}},function(module,exports,__webpack_require__){"use strict";module.exports=stan;stan.displayName="stan";stan.aliases=[];function stan(Prism){Prism.languages.stan={comment:/\/\/.*|\/\*[\s\S]*?\*\/|#(?!include).*/,string:{pattern:/"[\x20\x21\x23-\x5B\x5D-\x7E]*"/,greedy:true},directive:{pattern:/^([ \t]*)#include\b.*/m,lookbehind:true,alias:"property"},"function-arg":{pattern:/(\b(?:algebra_solver|integrate_1d|integrate_ode|integrate_ode_bdf|integrate_ode_rk45|map_rect)\s*\(\s*)[a-zA-Z]\w*/,lookbehind:true,alias:"function"},constraint:{pattern:/(\b(?:int|matrix|real|row_vector|vector)\s*)<[^<>]*>/,lookbehind:true,inside:{expression:{pattern:/(=\s*)(?:(?!\s*(?:>$|,\s*\w+\s*=))[\s\S])+/,lookbehind:true,inside:null},property:/\b[a-z]\w*(?=\s*=)/i,operator:/=/,punctuation:/^<|>$|[,]/}},keyword:[/\b(?:break|cholesky_factor_corr|cholesky_factor_cov|continue|corr_matrix|cov_matrix|data|else|for|functions|generated|if|in|increment_log_prob|int|matrix|model|ordered|parameters|positive_ordered|print|quantities|real|reject|return|row_vector|simplex|target|transformed|unit_vector|vector|void|while)\b/,/\b(?:algebra_solver|integrate_1d|integrate_ode|integrate_ode_bdf|integrate_ode_rk45|map_rect)\b/],function:/\b[a-z]\w*(?=\s*\()/i,number:/(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:E[+-]?\d+)?\b/i,boolean:/\b(?:false|true)\b/,operator:/<-|\.[*/]=?|\|\|?|&&|[!=<>+\-*/]=?|['^%~?:]/,punctuation:/[()\[\]{},;]/};Prism.languages.stan.constraint.inside.expression.inside=Prism.languages.stan}},function(module,exports,__webpack_require__){"use strict";module.exports=stylus;stylus.displayName="stylus";stylus.aliases=[];function stylus(Prism){(function(Prism){var unit={pattern:/(\b\d+)(?:%|[a-z]+)/,lookbehind:true};var number={pattern:/(^|[^\w.-])-?\d*\.?\d+/,lookbehind:true};var inside={comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|\/\/.*)/,lookbehind:true},url:{pattern:/url\((["']?).*?\1\)/i,greedy:true},string:{pattern:/("|')(?:(?!\1)[^\\\r\n]|\\(?:\r\n|[\s\S]))*\1/,greedy:true},interpolation:null,func:null,important:/\B!(?:important|optional)\b/i,keyword:{pattern:/(^|\s+)(?:(?:if|else|for|return|unless)(?=\s+|$)|@[\w-]+)/,lookbehind:true},hexcode:/#[\da-f]{3,6}/i,color:[/\b(?:AliceBlue|AntiqueWhite|Aqua|Aquamarine|Azure|Beige|Bisque|Black|BlanchedAlmond|Blue|BlueViolet|Brown|BurlyWood|CadetBlue|Chartreuse|Chocolate|Coral|CornflowerBlue|Cornsilk|Crimson|Cyan|DarkBlue|DarkCyan|DarkGoldenRod|DarkGr[ae]y|DarkGreen|DarkKhaki|DarkMagenta|DarkOliveGreen|DarkOrange|DarkOrchid|DarkRed|DarkSalmon|DarkSeaGreen|DarkSlateBlue|DarkSlateGr[ae]y|DarkTurquoise|DarkViolet|DeepPink|DeepSkyBlue|DimGr[ae]y|DodgerBlue|FireBrick|FloralWhite|ForestGreen|Fuchsia|Gainsboro|GhostWhite|Gold|GoldenRod|Gr[ae]y|Green|GreenYellow|HoneyDew|HotPink|IndianRed|Indigo|Ivory|Khaki|Lavender|LavenderBlush|LawnGreen|LemonChiffon|LightBlue|LightCoral|LightCyan|LightGoldenRodYellow|LightGr[ae]y|LightGreen|LightPink|LightSalmon|LightSeaGreen|LightSkyBlue|LightSlateGr[ae]y|LightSteelBlue|LightYellow|Lime|LimeGreen|Linen|Magenta|Maroon|MediumAquaMarine|MediumBlue|MediumOrchid|MediumPurple|MediumSeaGreen|MediumSlateBlue|MediumSpringGreen|MediumTurquoise|MediumVioletRed|MidnightBlue|MintCream|MistyRose|Moccasin|NavajoWhite|Navy|OldLace|Olive|OliveDrab|Orange|OrangeRed|Orchid|PaleGoldenRod|PaleGreen|PaleTurquoise|PaleVioletRed|PapayaWhip|PeachPuff|Peru|Pink|Plum|PowderBlue|Purple|Red|RosyBrown|RoyalBlue|SaddleBrown|Salmon|SandyBrown|SeaGreen|SeaShell|Sienna|Silver|SkyBlue|SlateBlue|SlateGr[ae]y|Snow|SpringGreen|SteelBlue|Tan|Teal|Thistle|Tomato|Transparent|Turquoise|Violet|Wheat|White|WhiteSmoke|Yellow|YellowGreen)\b/i,{pattern:/\b(?:rgb|hsl)\(\s*\d{1,3}\s*,\s*\d{1,3}%?\s*,\s*\d{1,3}%?\s*\)\B|\b(?:rgb|hsl)a\(\s*\d{1,3}\s*,\s*\d{1,3}%?\s*,\s*\d{1,3}%?\s*,\s*(?:0|0?\.\d+|1)\s*\)\B/i,inside:{unit:unit,number:number,function:/[\w-]+(?=\()/,punctuation:/[(),]/}}],entity:/\\[\da-f]{1,8}/i,unit:unit,boolean:/\b(?:true|false)\b/,operator:[/~|[+!\/%<>?=]=?|[-:]=|\*[*=]?|\.{2,3}|&&|\|\||\B-\B|\b(?:and|in|is(?: a| defined| not|nt)?|not|or)\b/],number:number,punctuation:/[{}()\[\];:,]/};inside["interpolation"]={pattern:/\{[^\r\n}:]+\}/,alias:"variable",inside:{delimiter:{pattern:/^{|}$/,alias:"punctuation"},rest:inside}};inside["func"]={pattern:/[\w-]+\([^)]*\).*/,inside:{function:/^[^(]+/,rest:inside}};Prism.languages.stylus={"atrule-declaration":{pattern:/(^\s*)@.+/m,lookbehind:true,inside:{atrule:/^@[\w-]+/,rest:inside}},"variable-declaration":{pattern:/(^[ \t]*)[\w$-]+\s*.?=[ \t]*(?:(?:\{[^}]*\}|.+)|$)/m,lookbehind:true,inside:{variable:/^\S+/,rest:inside}},statement:{pattern:/(^[ \t]*)(?:if|else|for|return|unless)[ \t]+.+/m,lookbehind:true,inside:{keyword:/^\S+/,rest:inside}},"property-declaration":{pattern:/((?:^|\{)([ \t]*))(?:[\w-]|\{[^}\r\n]+\})+(?:\s*:\s*|[ \t]+)[^{\r\n]*(?:;|[^{\r\n,](?=$)(?!(?:\r?\n|\r)(?:\{|\2[ \t]+)))/m,lookbehind:true,inside:{property:{pattern:/^[^\s:]+/,inside:{interpolation:inside.interpolation}},rest:inside}},selector:{pattern:/(^[ \t]*)(?:(?=\S)(?:[^{}\r\n:()]|::?[\w-]+(?:\([^)\r\n]*\))?|\{[^}\r\n]+\})+)(?:(?:\r?\n|\r)(?:\1(?:(?=\S)(?:[^{}\r\n:()]|::?[\w-]+(?:\([^)\r\n]*\))?|\{[^}\r\n]+\})+)))*(?:,$|\{|(?=(?:\r?\n|\r)(?:\{|\1[ \t]+)))/m,lookbehind:true,inside:{interpolation:inside.interpolation,comment:inside.comment,punctuation:/[{},]/}},func:inside.func,string:inside.string,comment:{pattern:/(^|[^\\])(?:\/\*[\s\S]*?\*\/|\/\/.*)/,lookbehind:true,greedy:true},interpolation:inside.interpolation,punctuation:/[{}()\[\];:.]/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=swift;swift.displayName="swift";swift.aliases=[];function swift(Prism){Prism.languages.swift=Prism.languages.extend("clike",{string:{pattern:/("|')(?:\\(?:\((?:[^()]|\([^)]+\))+\)|\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true,inside:{interpolation:{pattern:/\\\((?:[^()]|\([^)]+\))+\)/,inside:{delimiter:{pattern:/^\\\(|\)$/,alias:"variable"}}}}},keyword:/\b(?:as|associativity|break|case|catch|class|continue|convenience|default|defer|deinit|didSet|do|dynamic(?:Type)?|else|enum|extension|fallthrough|final|for|func|get|guard|if|import|in|infix|init|inout|internal|is|lazy|left|let|mutating|new|none|nonmutating|operator|optional|override|postfix|precedence|prefix|private|protocol|public|repeat|required|rethrows|return|right|safe|self|Self|set|static|struct|subscript|super|switch|throws?|try|Type|typealias|unowned|unsafe|var|weak|where|while|willSet|__(?:COLUMN__|FILE__|FUNCTION__|LINE__))\b/,number:/\b(?:[\d_]+(?:\.[\de_]+)?|0x[a-f0-9_]+(?:\.[a-f0-9p_]+)?|0b[01_]+|0o[0-7_]+)\b/i,constant:/\b(?:nil|[A-Z_]{2,}|k[A-Z][A-Za-z_]+)\b/,atrule:/@\b(?:IB(?:Outlet|Designable|Action|Inspectable)|class_protocol|exported|noreturn|NS(?:Copying|Managed)|objc|UIApplicationMain|auto_closure)\b/,builtin:/\b(?:[A-Z]\S+|abs|advance|alignof(?:Value)?|assert|contains|count(?:Elements)?|debugPrint(?:ln)?|distance|drop(?:First|Last)|dump|enumerate|equal|filter|find|first|getVaList|indices|isEmpty|join|last|lexicographicalCompare|map|max(?:Element)?|min(?:Element)?|numericCast|overlaps|partition|print(?:ln)?|reduce|reflect|reverse|sizeof(?:Value)?|sort(?:ed)?|split|startsWith|stride(?:of(?:Value)?)?|suffix|swap|toDebugString|toString|transcode|underestimateCount|unsafeBitCast|with(?:ExtendedLifetime|Unsafe(?:MutablePointers?|Pointers?)|VaList))\b/});Prism.languages.swift["string"].inside["interpolation"].inside.rest=Prism.languages.swift}},function(module,exports,__webpack_require__){"use strict";var refractorT4Templating=__webpack_require__(137);var refractorCsharp=__webpack_require__(132);module.exports=t4Cs;t4Cs.displayName="t4Cs";t4Cs.aliases=[];function t4Cs(Prism){Prism.register(refractorT4Templating);Prism.register(refractorCsharp);Prism.languages.t4=Prism.languages["t4-cs"]=Prism.languages["t4-templating"].createT4("csharp")}},function(module,exports,__webpack_require__){"use strict";var refractorT4Templating=__webpack_require__(137);var refractorVbnet=__webpack_require__(184);module.exports=t4Vb;t4Vb.displayName="t4Vb";t4Vb.aliases=[];function t4Vb(Prism){Prism.register(refractorT4Templating);Prism.register(refractorVbnet);Prism.languages["t4-vb"]=Prism.languages["t4-templating"].createT4("vbnet")}},function(module,exports,__webpack_require__){"use strict";var refractorYaml=__webpack_require__(185);module.exports=tap;tap.displayName="tap";tap.aliases=[];function tap(Prism){Prism.register(refractorYaml);Prism.languages.tap={fail:/not ok[^#{\n\r]*/,pass:/ok[^#{\n\r]*/,pragma:/pragma [+-][a-z]+/,bailout:/bail out!.*/i,version:/TAP version \d+/i,plan:/\d+\.\.\d+(?: +#.*)?/,subtest:{pattern:/# Subtest(?:: .*)?/,greedy:true},punctuation:/[{}]/,directive:/#.*/,yamlish:{pattern:/(^[^\S\r\n]*)---(?:\r\n?|\n)(?:.*(?:\r\n?|\n))*?[^\S\r\n]*\.\.\.$/m,lookbehind:true,inside:Prism.languages.yaml,alias:"language-yaml"}}}},function(module,exports,__webpack_require__){"use strict";module.exports=tcl;tcl.displayName="tcl";tcl.aliases=[];function tcl(Prism){Prism.languages.tcl={comment:{pattern:/(^|[^\\])#.*/,lookbehind:true},string:{pattern:/"(?:[^"\\\r\n]|\\(?:\r\n|[\s\S]))*"/,greedy:true},variable:[{pattern:/(\$)(?:::)?(?:[a-zA-Z0-9]+::)*\w+/,lookbehind:true},{pattern:/(\$){[^}]+}/,lookbehind:true},{pattern:/(^\s*set[ \t]+)(?:::)?(?:[a-zA-Z0-9]+::)*\w+/m,lookbehind:true}],function:{pattern:/(^\s*proc[ \t]+)[^\s]+/m,lookbehind:true},builtin:[{pattern:/(^\s*)(?:proc|return|class|error|eval|exit|for|foreach|if|switch|while|break|continue)\b/m,lookbehind:true},/\b(?:elseif|else)\b/],scope:{pattern:/(^\s*)(?:global|upvar|variable)\b/m,lookbehind:true,alias:"constant"},keyword:{pattern:/(^\s*|\[)(?:after|append|apply|array|auto_(?:execok|import|load|mkindex|qualify|reset)|automkindex_old|bgerror|binary|catch|cd|chan|clock|close|concat|dde|dict|encoding|eof|exec|expr|fblocked|fconfigure|fcopy|file(?:event|name)?|flush|gets|glob|history|http|incr|info|interp|join|lappend|lassign|lindex|linsert|list|llength|load|lrange|lrepeat|lreplace|lreverse|lsearch|lset|lsort|math(?:func|op)|memory|msgcat|namespace|open|package|parray|pid|pkg_mkIndex|platform|puts|pwd|re_syntax|read|refchan|regexp|registry|regsub|rename|Safe_Base|scan|seek|set|socket|source|split|string|subst|Tcl|tcl(?:_endOfWord|_findLibrary|startOf(?:Next|Previous)Word|wordBreak(?:After|Before)|test|vars)|tell|time|tm|trace|unknown|unload|unset|update|uplevel|vwait)\b/m,lookbehind:true},operator:/!=?|\*\*?|==|&&?|\|\|?|<[=<]?|>[=>]?|[-+~\/%?^]|\b(?:eq|ne|in|ni)\b/,punctuation:/[{}()\[\]]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=textile;textile.displayName="textile";textile.aliases=[];function textile(Prism){(function(Prism){var modifierRegex=/\([^|()\n]+\)|\[[^\]\n]+\]|\{[^}\n]+\}/.source;var parenthesesRegex=/\)|\((?![^|()\n]+\))/.source;function withModifier(source,flags){return RegExp(source.replace(/<MOD>/g,(function(){return"(?:"+modifierRegex+")"})).replace(/<PAR>/g,(function(){return"(?:"+parenthesesRegex+")"})),flags||"")}var modifierTokens={css:{pattern:/\{[^}]+\}/,inside:{rest:Prism.languages.css}},"class-id":{pattern:/(\()[^)]+(?=\))/,lookbehind:true,alias:"attr-value"},lang:{pattern:/(\[)[^\]]+(?=\])/,lookbehind:true,alias:"attr-value"},punctuation:/[\\\/]\d+|\S/};var textile=Prism.languages.textile=Prism.languages.extend("markup",{phrase:{pattern:/(^|\r|\n)\S[\s\S]*?(?=$|\r?\n\r?\n|\r\r)/,lookbehind:true,inside:{"block-tag":{pattern:withModifier(/^[a-z]\w*(?:<MOD>|<PAR>|[<>=])*\./.source),inside:{modifier:{pattern:withModifier(/(^[a-z]\w*)(?:<MOD>|<PAR>|[<>=])+(?=\.)/.source),lookbehind:true,inside:modifierTokens},tag:/^[a-z]\w*/,punctuation:/\.$/}},list:{pattern:withModifier(/^[*#]+<MOD>*\s+.+/.source,"m"),inside:{modifier:{pattern:withModifier(/(^[*#]+)<MOD>+/.source),lookbehind:true,inside:modifierTokens},punctuation:/^[*#]+/}},table:{pattern:withModifier(/^(?:(?:<MOD>|<PAR>|[<>=^~])+\.\s*)?(?:\|(?:(?:<MOD>|<PAR>|[<>=^~_]|[\\/]\d+)+\.)?[^|]*)+\|/.source,"m"),inside:{modifier:{pattern:withModifier(/(^|\|(?:\r?\n|\r)?)(?:<MOD>|<PAR>|[<>=^~_]|[\\/]\d+)+(?=\.)/.source),lookbehind:true,inside:modifierTokens},punctuation:/\||^\./}},inline:{pattern:withModifier(/(^|[^a-zA-Z\d])(\*\*|__|\?\?|[*_%@+\-^~])<MOD>*.+?\2(?![a-zA-Z\d])/.source),lookbehind:true,inside:{bold:{pattern:withModifier(/(^(\*\*?)<MOD>*).+?(?=\2)/.source),lookbehind:true},italic:{pattern:withModifier(/(^(__?)<MOD>*).+?(?=\2)/.source),lookbehind:true},cite:{pattern:withModifier(/(^\?\?<MOD>*).+?(?=\?\?)/.source),lookbehind:true,alias:"string"},code:{pattern:withModifier(/(^@<MOD>*).+?(?=@)/.source),lookbehind:true,alias:"keyword"},inserted:{pattern:withModifier(/(^\+<MOD>*).+?(?=\+)/.source),lookbehind:true},deleted:{pattern:withModifier(/(^-<MOD>*).+?(?=-)/.source),lookbehind:true},span:{pattern:withModifier(/(^%<MOD>*).+?(?=%)/.source),lookbehind:true},modifier:{pattern:withModifier(/(^\*\*|__|\?\?|[*_%@+\-^~])<MOD>+/.source),lookbehind:true,inside:modifierTokens},punctuation:/[*_%?@+\-^~]+/}},"link-ref":{pattern:/^\[[^\]]+\]\S+$/m,inside:{string:{pattern:/(\[)[^\]]+(?=\])/,lookbehind:true},url:{pattern:/(\])\S+$/,lookbehind:true},punctuation:/[\[\]]/}},link:{pattern:withModifier(/"<MOD>*[^"]+":.+?(?=[^\w/]?(?:\s|$))/.source),inside:{text:{pattern:withModifier(/(^"<MOD>*)[^"]+(?=")/.source),lookbehind:true},modifier:{pattern:withModifier(/(^")<MOD>+/.source),lookbehind:true,inside:modifierTokens},url:{pattern:/(:).+/,lookbehind:true},punctuation:/[":]/}},image:{pattern:withModifier(/!(?:<MOD>|<PAR>|[<>=])*[^!\s()]+(?:\([^)]+\))?!(?::.+?(?=[^\w/]?(?:\s|$)))?/.source),inside:{source:{pattern:withModifier(/(^!(?:<MOD>|<PAR>|[<>=])*)[^!\s()]+(?:\([^)]+\))?(?=!)/.source),lookbehind:true,alias:"url"},modifier:{pattern:withModifier(/(^!)(?:<MOD>|<PAR>|[<>=])+/.source),lookbehind:true,inside:modifierTokens},url:{pattern:/(:).+/,lookbehind:true},punctuation:/[!:]/}},footnote:{pattern:/\b\[\d+\]/,alias:"comment",inside:{punctuation:/\[|\]/}},acronym:{pattern:/\b[A-Z\d]+\([^)]+\)/,inside:{comment:{pattern:/(\()[^)]+(?=\))/,lookbehind:true},punctuation:/[()]/}},mark:{pattern:/\b\((?:TM|R|C)\)/,alias:"comment",inside:{punctuation:/[()]/}}}}});var phraseInside=textile["phrase"].inside;var nestedPatterns={inline:phraseInside["inline"],link:phraseInside["link"],image:phraseInside["image"],footnote:phraseInside["footnote"],acronym:phraseInside["acronym"],mark:phraseInside["mark"]};textile.tag.pattern=/<\/?(?!\d)[a-z0-9]+(?:\s+[^\s>\/=]+(?:=(?:("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|[^\s'">=]+))?)*\s*\/?>/i;var phraseInlineInside=phraseInside["inline"].inside;phraseInlineInside["bold"].inside=nestedPatterns;phraseInlineInside["italic"].inside=nestedPatterns;phraseInlineInside["inserted"].inside=nestedPatterns;phraseInlineInside["deleted"].inside=nestedPatterns;phraseInlineInside["span"].inside=nestedPatterns;var phraseTableInside=phraseInside["table"].inside;phraseTableInside["inline"]=nestedPatterns["inline"];phraseTableInside["link"]=nestedPatterns["link"];phraseTableInside["image"]=nestedPatterns["image"];phraseTableInside["footnote"]=nestedPatterns["footnote"];phraseTableInside["acronym"]=nestedPatterns["acronym"];phraseTableInside["mark"]=nestedPatterns["mark"]})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=toml;toml.displayName="toml";toml.aliases=[];function toml(Prism){(function(Prism){var key=/(?:[\w-]+|'[^'\n\r]*'|"(?:\\.|[^\\"\r\n])*")/.source;function insertKey(pattern){return pattern.replace(/__/g,(function(){return key}))}Prism.languages.toml={comment:{pattern:/#.*/,greedy:true},table:{pattern:RegExp(insertKey(/(^\s*\[\s*(?:\[\s*)?)__(?:\s*\.\s*__)*(?=\s*\])/.source),"m"),lookbehind:true,greedy:true,alias:"class-name"},key:{pattern:RegExp(insertKey(/(^\s*|[{,]\s*)__(?:\s*\.\s*__)*(?=\s*=)/.source),"m"),lookbehind:true,greedy:true,alias:"property"},string:{pattern:/"""(?:\\[\s\S]|[^\\])*?"""|'''[\s\S]*?'''|'[^'\n\r]*'|"(?:\\.|[^\\"\r\n])*"/,greedy:true},date:[{pattern:/\b\d{4}-\d{2}-\d{2}(?:[T\s]\d{2}:\d{2}:\d{2}(?:\.\d+)?(?:Z|[+-]\d{2}:\d{2})?)?\b/i,alias:"number"},{pattern:/\b\d{2}:\d{2}:\d{2}(?:\.\d+)?\b/,alias:"number"}],number:/(?:\b0(?:x[\da-zA-Z]+(?:_[\da-zA-Z]+)*|o[0-7]+(?:_[0-7]+)*|b[10]+(?:_[10]+)*))\b|[-+]?\b\d+(?:_\d+)*(?:\.\d+(?:_\d+)*)?(?:[eE][+-]?\d+(?:_\d+)*)?\b|[-+]?\b(?:inf|nan)\b/,boolean:/\b(?:true|false)\b/,punctuation:/[.,=[\]{}]/}})(Prism)}},function(module,exports,__webpack_require__){"use strict";var refractorJsx=__webpack_require__(181);var refractorTypescript=__webpack_require__(134);module.exports=tsx;tsx.displayName="tsx";tsx.aliases=[];function tsx(Prism){Prism.register(refractorJsx);Prism.register(refractorTypescript);var typescript=Prism.util.clone(Prism.languages.typescript);Prism.languages.tsx=Prism.languages.extend("jsx",typescript)}},function(module,exports,__webpack_require__){"use strict";var refractorMarkupTemplating=__webpack_require__(63);module.exports=tt2;tt2.displayName="tt2";tt2.aliases=[];function tt2(Prism){Prism.register(refractorMarkupTemplating);(function(Prism){Prism.languages.tt2=Prism.languages.extend("clike",{comment:/#.*|\[%#[\s\S]*?%\]/,keyword:/\b(?:BLOCK|CALL|CASE|CATCH|CLEAR|DEBUG|DEFAULT|ELSE|ELSIF|END|FILTER|FINAL|FOREACH|GET|IF|IN|INCLUDE|INSERT|LAST|MACRO|META|NEXT|PERL|PROCESS|RAWPERL|RETURN|SET|STOP|TAGS|THROW|TRY|SWITCH|UNLESS|USE|WHILE|WRAPPER)\b/,punctuation:/[[\]{},()]/});Prism.languages.insertBefore("tt2","number",{operator:/=[>=]?|!=?|<=?|>=?|&&|\|\|?|\b(?:and|or|not)\b/,variable:{pattern:/\b[a-z]\w*(?:\s*\.\s*(?:\d+|\$?[a-z]\w*))*\b/i}});Prism.languages.insertBefore("tt2","keyword",{delimiter:{pattern:/^(?:\[%|%%)-?|-?%]$/,alias:"punctuation"}});Prism.languages.insertBefore("tt2","string",{"single-quoted-string":{pattern:/'[^\\']*(?:\\[\s\S][^\\']*)*'/,greedy:true,alias:"string"},"double-quoted-string":{pattern:/"[^\\"]*(?:\\[\s\S][^\\"]*)*"/,greedy:true,alias:"string",inside:{variable:{pattern:/\$(?:[a-z]\w*(?:\.(?:\d+|\$?[a-z]\w*))*)/i}}}});delete Prism.languages.tt2.string;Prism.hooks.add("before-tokenize",(function(env){var tt2Pattern=/\[%[\s\S]+?%\]/g;Prism.languages["markup-templating"].buildPlaceholders(env,"tt2",tt2Pattern)}));Prism.hooks.add("after-tokenize",(function(env){Prism.languages["markup-templating"].tokenizePlaceholders(env,"tt2")}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=twig;twig.displayName="twig";twig.aliases=[];function twig(Prism){Prism.languages.twig={comment:/\{#[\s\S]*?#\}/,tag:{pattern:/\{\{[\s\S]*?\}\}|\{%[\s\S]*?%\}/,inside:{ld:{pattern:/^(?:\{\{-?|\{%-?\s*\w+)/,inside:{punctuation:/^(?:\{\{|\{%)-?/,keyword:/\w+/}},rd:{pattern:/-?(?:%\}|\}\})$/,inside:{punctuation:/.+/}},string:{pattern:/("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,inside:{punctuation:/^['"]|['"]$/}},keyword:/\b(?:even|if|odd)\b/,boolean:/\b(?:true|false|null)\b/,number:/\b0x[\dA-Fa-f]+|(?:\b\d+\.?\d*|\B\.\d+)(?:[Ee][-+]?\d+)?/,operator:[{pattern:/(\s)(?:and|b-and|b-xor|b-or|ends with|in|is|matches|not|or|same as|starts with)(?=\s)/,lookbehind:true},/[=<>]=?|!=|\*\*?|\/\/?|\?:?|[-+~%|]/],property:/\b[a-zA-Z_]\w*\b/,punctuation:/[()\[\]{}:.,]/}},other:{pattern:/\S(?:[\s\S]*\S)?/,inside:Prism.languages.markup}}}},function(module,exports,__webpack_require__){"use strict";module.exports=typoscript;typoscript.displayName="typoscript";typoscript.aliases=["tsconfig"];function typoscript(Prism){(function(Prism){var keywords=/\b(?:ACT|ACTIFSUB|CARRAY|CASE|CLEARGIF|COA|COA_INT|CONSTANTS|CONTENT|CUR|EDITPANEL|EFFECT|EXT|FILE|FLUIDTEMPLATE|FORM|FRAME|FRAMESET|GIFBUILDER|GMENU|GMENU_FOLDOUT|GMENU_LAYERS|GP|HMENU|HRULER|HTML|IENV|IFSUB|IMAGE|IMGMENU|IMGMENUITEM|IMGTEXT|IMG_RESOURCE|INCLUDE_TYPOSCRIPT|JSMENU|JSMENUITEM|LLL|LOAD_REGISTER|NO|PAGE|RECORDS|RESTORE_REGISTER|TEMPLATE|TEXT|TMENU|TMENUITEM|TMENU_LAYERS|USER|USER_INT|_GIFBUILDER|global|globalString|globalVar)\b/;Prism.languages.typoscript={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:true},{pattern:/(^|[^\\:= \t]|(?:^|[^= \t])[ \t]+)\/\/.*/,lookbehind:true,greedy:true},{pattern:/(^|[^"'])#.*/,lookbehind:true,greedy:true}],function:[{pattern:/<INCLUDE_TYPOSCRIPT:\s*source\s*=\s*(?:"[^"\r\n]*"|'[^'\r\n]*')\s*>/,inside:{string:{pattern:/"[^"\r\n]*"|'[^'\r\n]*'/,inside:{keyword:keywords}},keyword:{pattern:/INCLUDE_TYPOSCRIPT/}}},{pattern:/@import\s*(?:"[^"\r\n]*"|'[^'\r\n]*')/,inside:{string:/"[^"\r\n]*"|'[^'\r\n]*'/}}],string:{pattern:/^([^=]*=[< ]?)(?:(?!]\n).)*/,lookbehind:true,inside:{function:/{\$.*}/,keyword:keywords,number:/^[0-9]+$/,punctuation:/[,|:]/}},keyword:keywords,number:{pattern:/[0-9]+\s*[.{=]/,inside:{operator:/[.{=]/}},tag:{pattern:/\.?[\w-\\]+\.?/,inside:{punctuation:/\./}},punctuation:/[{}[\];(),.:|]/,operator:/[<>]=?|[!=]=?=?|--?|\+\+?|&&?|\|\|?|[?*/~^%]/};Prism.languages.tsconfig=Prism.languages.typoscript})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=unrealscript;unrealscript.displayName="unrealscript";unrealscript.aliases=["uc","uscript"];function unrealscript(Prism){Prism.languages.unrealscript={comment:/\/\/.*|\/\*[\s\S]*?\*\//,string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:true},category:{pattern:/(\b(?:(?:autoexpand|hide|show)categories|var)\s*\()[^()]+(?=\))/,lookbehind:true,greedy:true,alias:"property"},metadata:{pattern:/(\w\s*)<\s*\w+\s*=[^<>|=\r\n]+(?:\|\s*\w+\s*=[^<>|=\r\n]+)*>/,lookbehind:true,greedy:true,inside:{property:/\w+(?=\s*=)/,operator:/=/,punctuation:/[<>|]/}},macro:{pattern:/`\w+/,alias:"property"},"class-name":{pattern:/(\b(?:class|enum|extends|interface|state(?:\(\))?|struct|within)\s+)\w+/,lookbehind:true},keyword:/\b(?:abstract|actor|array|auto|autoexpandcategories|bool|break|byte|case|class|classgroup|client|coerce|collapsecategories|config|const|continue|default|defaultproperties|delegate|dependson|deprecated|do|dontcollapsecategories|editconst|editinlinenew|else|enum|event|exec|export|extends|final|float|for|forcescriptorder|foreach|function|goto|guid|hidecategories|hidedropdown|if|ignores|implements|inherits|input|int|interface|iterator|latent|local|material|name|native|nativereplication|noexport|nontransient|noteditinlinenew|notplaceable|operator|optional|out|pawn|perobjectconfig|perobjectlocalized|placeable|postoperator|preoperator|private|protected|reliable|replication|return|server|showcategories|simulated|singular|state|static|string|struct|structdefault|structdefaultproperties|switch|texture|transient|travel|unreliable|until|var|vector|while|within)\b/,function:/[a-z_]\w*(?=\s*\()/i,boolean:/\b(?:false|true)\b/,number:/\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/>>|<<|--|\+\+|\*\*|[-+*/~!=<>$@]=?|&&?|\|\|?|\^\^?|[?:%]|\b(?:Cross|Dot|ClockwiseFrom)\b/,punctuation:/[()[\]{};,.]/};Prism.languages.uc=Prism.languages.uscript=Prism.languages.unrealscript}},function(module,exports,__webpack_require__){"use strict";module.exports=vala;vala.displayName="vala";vala.aliases=[];function vala(Prism){Prism.languages.vala=Prism.languages.extend("clike",{"class-name":[{pattern:/\b[A-Z]\w*(?:\.\w+)*\b(?=(?:\?\s+|\*?\s+\*?)\w+)/,inside:{punctuation:/\./}},{pattern:/(\[)[A-Z]\w*(?:\.\w+)*\b/,lookbehind:true,inside:{punctuation:/\./}},{pattern:/(\b(?:class|interface)\s+[A-Z]\w*(?:\.\w+)*\s*:\s*)[A-Z]\w*(?:\.\w+)*\b/,lookbehind:true,inside:{punctuation:/\./}},{pattern:/((?:\b(?:class|interface|new|struct|enum)\s+)|(?:catch\s+\())[A-Z]\w*(?:\.\w+)*\b/,lookbehind:true,inside:{punctuation:/\./}}],constant:/\b[A-Z0-9_]+\b/,function:/\w+(?=\s*\()/,keyword:/\b(?:bool|char|double|float|null|size_t|ssize_t|string|unichar|void|int|int8|int16|int32|int64|long|short|uchar|uint|uint8|uint16|uint32|uint64|ulong|ushort|class|delegate|enum|errordomain|interface|namespace|struct|break|continue|do|for|foreach|return|while|else|if|switch|assert|case|default|abstract|const|dynamic|ensures|extern|inline|internal|override|private|protected|public|requires|signal|static|virtual|volatile|weak|async|owned|unowned|try|catch|finally|throw|as|base|construct|delete|get|in|is|lock|new|out|params|ref|sizeof|set|this|throws|typeof|using|value|var|yield)\b/i,number:/(?:\b0x[\da-f]+\b|(?:\b\d+\.?\d*|\B\.\d+)(?:e[+-]?\d+)?)(?:f|u?l?)?/i,operator:/\+\+|--|&&|\|\||<<=?|>>=?|=>|->|~|[+\-*\/%&^|=!<>]=?|\?\??|\.\.\./,punctuation:/[{}[\];(),.:]/});Prism.languages.insertBefore("vala","string",{"raw-string":{pattern:/"""[\s\S]*?"""/,greedy:true,alias:"string"},"template-string":{pattern:/@"[\s\S]*?"/,greedy:true,inside:{interpolation:{pattern:/\$(?:\([^)]*\)|[a-zA-Z]\w*)/,inside:{delimiter:{pattern:/^\$\(?|\)$/,alias:"punctuation"},rest:Prism.languages.vala}},string:/[\s\S]+/}}});Prism.languages.insertBefore("vala","keyword",{regex:{pattern:/\/(?:\[(?:[^\]\\\r\n]|\\.)*]|\\.|[^/\\\[\r\n])+\/[imsx]{0,4}(?=\s*(?:$|[\r\n,.;})\]]))/,greedy:true,inside:{"regex-source":{pattern:/^(\/)[\s\S]+(?=\/[a-z]*$)/,lookbehind:true,alias:"language-regex",inside:Prism.languages.regex},"regex-flags":/[a-z]+$/,"regex-delimiter":/^\/|\/$/}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=velocity;velocity.displayName="velocity";velocity.aliases=[];function velocity(Prism){(function(Prism){Prism.languages.velocity=Prism.languages.extend("markup",{});var velocity={variable:{pattern:/(^|[^\\](?:\\\\)*)\$!?(?:[a-z][\w-]*(?:\([^)]*\))?(?:\.[a-z][\w-]*(?:\([^)]*\))?|\[[^\]]+])*|{[^}]+})/i,lookbehind:true,inside:{}},string:{pattern:/"[^"]*"|'[^']*'/,greedy:true},number:/\b\d+\b/,boolean:/\b(?:true|false)\b/,operator:/[=!<>]=?|[+*/%-]|&&|\|\||\.\.|\b(?:eq|g[et]|l[et]|n(?:e|ot))\b/,punctuation:/[(){}[\]:,.]/};velocity.variable.inside={string:velocity["string"],function:{pattern:/([^\w-])[a-z][\w-]*(?=\()/,lookbehind:true},number:velocity["number"],boolean:velocity["boolean"],punctuation:velocity["punctuation"]};Prism.languages.insertBefore("velocity","comment",{unparsed:{pattern:/(^|[^\\])#\[\[[\s\S]*?]]#/,lookbehind:true,greedy:true,inside:{punctuation:/^#\[\[|]]#$/}},"velocity-comment":[{pattern:/(^|[^\\])#\*[\s\S]*?\*#/,lookbehind:true,greedy:true,alias:"comment"},{pattern:/(^|[^\\])##.*/,lookbehind:true,greedy:true,alias:"comment"}],directive:{pattern:/(^|[^\\](?:\\\\)*)#@?(?:[a-z][\w-]*|{[a-z][\w-]*})(?:\s*\((?:[^()]|\([^()]*\))*\))?/i,lookbehind:true,inside:{keyword:{pattern:/^#@?(?:[a-z][\w-]*|{[a-z][\w-]*})|\bin\b/,inside:{punctuation:/[{}]/}},rest:velocity}},variable:velocity["variable"]});Prism.languages.velocity["tag"].inside["attr-value"].inside.rest=Prism.languages.velocity})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=verilog;verilog.displayName="verilog";verilog.aliases=[];function verilog(Prism){Prism.languages.verilog={comment:/\/\/.*|\/\*[\s\S]*?\*\//,string:{pattern:/"(?:\\(?:\r\n|[\s\S])|[^"\\\r\n])*"/,greedy:true},property:/\B\$\w+\b/,constant:/\B`\w+\b/,function:/\w+(?=\()/,keyword:/\b(?:alias|and|assert|assign|assume|automatic|before|begin|bind|bins|binsof|bit|break|buf|bufif0|bufif1|byte|class|case|casex|casez|cell|chandle|clocking|cmos|config|const|constraint|context|continue|cover|covergroup|coverpoint|cross|deassign|default|defparam|design|disable|dist|do|edge|else|end|endcase|endclass|endclocking|endconfig|endfunction|endgenerate|endgroup|endinterface|endmodule|endpackage|endprimitive|endprogram|endproperty|endspecify|endsequence|endtable|endtask|enum|event|expect|export|extends|extern|final|first_match|for|force|foreach|forever|fork|forkjoin|function|generate|genvar|highz0|highz1|if|iff|ifnone|ignore_bins|illegal_bins|import|incdir|include|initial|inout|input|inside|instance|int|integer|interface|intersect|join|join_any|join_none|large|liblist|library|local|localparam|logic|longint|macromodule|matches|medium|modport|module|nand|negedge|new|nmos|nor|noshowcancelled|not|notif0|notif1|null|or|output|package|packed|parameter|pmos|posedge|primitive|priority|program|property|protected|pull0|pull1|pulldown|pullup|pulsestyle_onevent|pulsestyle_ondetect|pure|rand|randc|randcase|randsequence|rcmos|real|realtime|ref|reg|release|repeat|return|rnmos|rpmos|rtran|rtranif0|rtranif1|scalared|sequence|shortint|shortreal|showcancelled|signed|small|solve|specify|specparam|static|string|strong0|strong1|struct|super|supply0|supply1|table|tagged|task|this|throughout|time|timeprecision|timeunit|tran|tranif0|tranif1|tri|tri0|tri1|triand|trior|trireg|type|typedef|union|unique|unsigned|use|uwire|var|vectored|virtual|void|wait|wait_order|wand|weak0|weak1|while|wildcard|wire|with|within|wor|xnor|xor)\b/,important:/\b(?:always_latch|always_comb|always_ff|always)\b ?@?/,number:/\B##?\d+|(?:\b\d+)?'[odbh] ?[\da-fzx_?]+|\b\d*[._]?\d+(?:e[-+]?\d+)?/i,operator:/[-+{}^~%*\/?=!<>&|]+/,punctuation:/[[\];(),.:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=vhdl;vhdl.displayName="vhdl";vhdl.aliases=[];function vhdl(Prism){Prism.languages.vhdl={comment:/--.+/,"vhdl-vectors":{pattern:/\b[oxb]"[\da-f_]+"|"[01uxzwlh-]+"/i,alias:"number"},"quoted-function":{pattern:/"\S+?"(?=\()/,alias:"function"},string:/"(?:[^\\"\r\n]|\\(?:\r\n|[\s\S]))*"/,constant:/\b(?:use|library)\b/i,keyword:/\b(?:'active|'ascending|'base|'delayed|'driving|'driving_value|'event|'high|'image|'instance_name|'last_active|'last_event|'last_value|'left|'leftof|'length|'low|'path_name|'pos|'pred|'quiet|'range|'reverse_range|'right|'rightof|'simple_name|'stable|'succ|'transaction|'val|'value|access|after|alias|all|architecture|array|assert|attribute|begin|block|body|buffer|bus|case|component|configuration|constant|disconnect|downto|else|elsif|end|entity|exit|file|for|function|generate|generic|group|guarded|if|impure|in|inertial|inout|is|label|library|linkage|literal|loop|map|new|next|null|of|on|open|others|out|package|port|postponed|procedure|process|pure|range|record|register|reject|report|return|select|severity|shared|signal|subtype|then|to|transport|type|unaffected|units|until|use|variable|wait|when|while|with)\b/i,boolean:/\b(?:true|false)\b/i,function:/\w+(?=\()/,number:/'[01uxzwlh-]'|\b(?:\d+#[\da-f_.]+#|\d[\d_.]*)(?:e[-+]?\d+)?/i,operator:/[<>]=?|:=|[-+*/&=]|\b(?:abs|not|mod|rem|sll|srl|sla|sra|rol|ror|and|or|nand|xnor|xor|nor)\b/i,punctuation:/[{}[\];(),.:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=vim;vim.displayName="vim";vim.aliases=[];function vim(Prism){Prism.languages.vim={string:/"(?:[^"\\\r\n]|\\.)*"|'(?:[^'\r\n]|'')*'/,comment:/".*/,function:/\w+(?=\()/,keyword:/\b(?:ab|abbreviate|abc|abclear|abo|aboveleft|al|all|arga|argadd|argd|argdelete|argdo|arge|argedit|argg|argglobal|argl|arglocal|ar|args|argu|argument|as|ascii|bad|badd|ba|ball|bd|bdelete|be|bel|belowright|bf|bfirst|bl|blast|bm|bmodified|bn|bnext|bN|bNext|bo|botright|bp|bprevious|brea|break|breaka|breakadd|breakd|breakdel|breakl|breaklist|br|brewind|bro|browse|bufdo|b|buffer|buffers|bun|bunload|bw|bwipeout|ca|cabbrev|cabc|cabclear|caddb|caddbuffer|cad|caddexpr|caddf|caddfile|cal|call|cat|catch|cb|cbuffer|cc|ccl|cclose|cd|ce|center|cex|cexpr|cf|cfile|cfir|cfirst|cgetb|cgetbuffer|cgete|cgetexpr|cg|cgetfile|c|change|changes|chd|chdir|che|checkpath|checkt|checktime|cla|clast|cl|clist|clo|close|cmapc|cmapclear|cnew|cnewer|cn|cnext|cN|cNext|cnf|cnfile|cNfcNfile|cnorea|cnoreabbrev|col|colder|colo|colorscheme|comc|comclear|comp|compiler|conf|confirm|con|continue|cope|copen|co|copy|cpf|cpfile|cp|cprevious|cq|cquit|cr|crewind|cuna|cunabbrev|cu|cunmap|cw|cwindow|debugg|debuggreedy|delc|delcommand|d|delete|delf|delfunction|delm|delmarks|diffg|diffget|diffoff|diffpatch|diffpu|diffput|diffsplit|diffthis|diffu|diffupdate|dig|digraphs|di|display|dj|djump|dl|dlist|dr|drop|ds|dsearch|dsp|dsplit|earlier|echoe|echoerr|echom|echomsg|echon|e|edit|el|else|elsei|elseif|em|emenu|endfo|endfor|endf|endfunction|endfun|en|endif|endt|endtry|endw|endwhile|ene|enew|ex|exi|exit|exu|exusage|f|file|files|filetype|fina|finally|fin|find|fini|finish|fir|first|fix|fixdel|fo|fold|foldc|foldclose|folddoc|folddoclosed|foldd|folddoopen|foldo|foldopen|for|fu|fun|function|go|goto|gr|grep|grepa|grepadd|ha|hardcopy|h|help|helpf|helpfind|helpg|helpgrep|helpt|helptags|hid|hide|his|history|ia|iabbrev|iabc|iabclear|if|ij|ijump|il|ilist|imapc|imapclear|in|inorea|inoreabbrev|isearch|isp|isplit|iuna|iunabbrev|iu|iunmap|j|join|ju|jumps|k|keepalt|keepj|keepjumps|kee|keepmarks|laddb|laddbuffer|lad|laddexpr|laddf|laddfile|lan|language|la|last|later|lb|lbuffer|lc|lcd|lch|lchdir|lcl|lclose|let|left|lefta|leftabove|lex|lexpr|lf|lfile|lfir|lfirst|lgetb|lgetbuffer|lgete|lgetexpr|lg|lgetfile|lgr|lgrep|lgrepa|lgrepadd|lh|lhelpgrep|l|list|ll|lla|llast|lli|llist|lmak|lmake|lm|lmap|lmapc|lmapclear|lnew|lnewer|lne|lnext|lN|lNext|lnf|lnfile|lNf|lNfile|ln|lnoremap|lo|loadview|loc|lockmarks|lockv|lockvar|lol|lolder|lop|lopen|lpf|lpfile|lp|lprevious|lr|lrewind|ls|lt|ltag|lu|lunmap|lv|lvimgrep|lvimgrepa|lvimgrepadd|lw|lwindow|mak|make|ma|mark|marks|mat|match|menut|menutranslate|mk|mkexrc|mks|mksession|mksp|mkspell|mkvie|mkview|mkv|mkvimrc|mod|mode|m|move|mzf|mzfile|mz|mzscheme|nbkey|new|n|next|N|Next|nmapc|nmapclear|noh|nohlsearch|norea|noreabbrev|nu|number|nun|nunmap|omapc|omapclear|on|only|o|open|opt|options|ou|ounmap|pc|pclose|ped|pedit|pe|perl|perld|perldo|po|pop|popu|popup|pp|ppop|pre|preserve|prev|previous|p|print|P|Print|profd|profdel|prof|profile|promptf|promptfind|promptr|promptrepl|ps|psearch|pta|ptag|ptf|ptfirst|ptj|ptjump|ptl|ptlast|ptn|ptnext|ptN|ptNext|ptp|ptprevious|ptr|ptrewind|pts|ptselect|pu|put|pw|pwd|pyf|pyfile|py|python|qa|qall|q|quit|quita|quitall|r|read|rec|recover|redi|redir|red|redo|redr|redraw|redraws|redrawstatus|reg|registers|res|resize|ret|retab|retu|return|rew|rewind|ri|right|rightb|rightbelow|rub|ruby|rubyd|rubydo|rubyf|rubyfile|ru|runtime|rv|rviminfo|sal|sall|san|sandbox|sa|sargument|sav|saveas|sba|sball|sbf|sbfirst|sbl|sblast|sbm|sbmodified|sbn|sbnext|sbN|sbNext|sbp|sbprevious|sbr|sbrewind|sb|sbuffer|scripte|scriptencoding|scrip|scriptnames|se|set|setf|setfiletype|setg|setglobal|setl|setlocal|sf|sfind|sfir|sfirst|sh|shell|sign|sil|silent|sim|simalt|sla|slast|sl|sleep|sm|smagic|smap|smapc|smapclear|sme|smenu|sn|snext|sN|sNext|sni|sniff|sno|snomagic|snor|snoremap|snoreme|snoremenu|sor|sort|so|source|spelld|spelldump|spe|spellgood|spelli|spellinfo|spellr|spellrepall|spellu|spellundo|spellw|spellwrong|sp|split|spr|sprevious|sre|srewind|sta|stag|startg|startgreplace|star|startinsert|startr|startreplace|stj|stjump|st|stop|stopi|stopinsert|sts|stselect|sun|sunhide|sunm|sunmap|sus|suspend|sv|sview|syncbind|t|tab|tabc|tabclose|tabd|tabdo|tabe|tabedit|tabf|tabfind|tabfir|tabfirst|tabl|tablast|tabm|tabmove|tabnew|tabn|tabnext|tabN|tabNext|tabo|tabonly|tabp|tabprevious|tabr|tabrewind|tabs|ta|tag|tags|tc|tcl|tcld|tcldo|tclf|tclfile|te|tearoff|tf|tfirst|th|throw|tj|tjump|tl|tlast|tm|tmenu|tn|tnext|tN|tNext|to|topleft|tp|tprevious|tr|trewind|try|ts|tselect|tu|tunmenu|una|unabbreviate|u|undo|undoj|undojoin|undol|undolist|unh|unhide|unlet|unlo|unlockvar|unm|unmap|up|update|verb|verbose|ve|version|vert|vertical|vie|view|vim|vimgrep|vimgrepa|vimgrepadd|vi|visual|viu|viusage|vmapc|vmapclear|vne|vnew|vs|vsplit|vu|vunmap|wa|wall|wh|while|winc|wincmd|windo|winp|winpos|win|winsize|wn|wnext|wN|wNext|wp|wprevious|wq|wqa|wqall|w|write|ws|wsverb|wv|wviminfo|X|xa|xall|x|xit|xm|xmap|xmapc|xmapclear|xme|xmenu|XMLent|XMLns|xn|xnoremap|xnoreme|xnoremenu|xu|xunmap|y|yank)\b/,builtin:/\b(?:autocmd|acd|ai|akm|aleph|allowrevins|altkeymap|ambiwidth|ambw|anti|antialias|arab|arabic|arabicshape|ari|arshape|autochdir|autoindent|autoread|autowrite|autowriteall|aw|awa|background|backspace|backup|backupcopy|backupdir|backupext|backupskip|balloondelay|ballooneval|balloonexpr|bdir|bdlay|beval|bex|bexpr|bg|bh|bin|binary|biosk|bioskey|bk|bkc|bomb|breakat|brk|browsedir|bs|bsdir|bsk|bt|bufhidden|buflisted|buftype|casemap|ccv|cdpath|cedit|cfu|ch|charconvert|ci|cin|cindent|cink|cinkeys|cino|cinoptions|cinw|cinwords|clipboard|cmdheight|cmdwinheight|cmp|cms|columns|com|comments|commentstring|compatible|complete|completefunc|completeopt|consk|conskey|copyindent|cot|cpo|cpoptions|cpt|cscopepathcomp|cscopeprg|cscopequickfix|cscopetag|cscopetagorder|cscopeverbose|cspc|csprg|csqf|cst|csto|csverb|cuc|cul|cursorcolumn|cursorline|cwh|debug|deco|def|define|delcombine|dex|dg|dict|dictionary|diff|diffexpr|diffopt|digraph|dip|dir|directory|dy|ea|ead|eadirection|eb|ed|edcompatible|ef|efm|ei|ek|enc|encoding|endofline|eol|ep|equalalways|equalprg|errorbells|errorfile|errorformat|esckeys|et|eventignore|expandtab|exrc|fcl|fcs|fdc|fde|fdi|fdl|fdls|fdm|fdn|fdo|fdt|fen|fenc|fencs|fex|ff|ffs|fileencoding|fileencodings|fileformat|fileformats|fillchars|fk|fkmap|flp|fml|fmr|foldcolumn|foldenable|foldexpr|foldignore|foldlevel|foldlevelstart|foldmarker|foldmethod|foldminlines|foldnestmax|foldtext|formatexpr|formatlistpat|formatoptions|formatprg|fp|fs|fsync|ft|gcr|gd|gdefault|gfm|gfn|gfs|gfw|ghr|gp|grepformat|grepprg|gtl|gtt|guicursor|guifont|guifontset|guifontwide|guiheadroom|guioptions|guipty|guitablabel|guitabtooltip|helpfile|helpheight|helplang|hf|hh|hi|hidden|highlight|hk|hkmap|hkmapp|hkp|hl|hlg|hls|hlsearch|ic|icon|iconstring|ignorecase|im|imactivatekey|imak|imc|imcmdline|imd|imdisable|imi|iminsert|ims|imsearch|inc|include|includeexpr|incsearch|inde|indentexpr|indentkeys|indk|inex|inf|infercase|insertmode|isf|isfname|isi|isident|isk|iskeyword|isprint|joinspaces|js|key|keymap|keymodel|keywordprg|km|kmp|kp|langmap|langmenu|laststatus|lazyredraw|lbr|lcs|linebreak|lines|linespace|lisp|lispwords|listchars|loadplugins|lpl|lsp|lz|macatsui|magic|makeef|makeprg|matchpairs|matchtime|maxcombine|maxfuncdepth|maxmapdepth|maxmem|maxmempattern|maxmemtot|mco|mef|menuitems|mfd|mh|mis|mkspellmem|ml|mls|mm|mmd|mmp|mmt|modeline|modelines|modifiable|modified|more|mouse|mousef|mousefocus|mousehide|mousem|mousemodel|mouses|mouseshape|mouset|mousetime|mp|mps|msm|mzq|mzquantum|nf|nrformats|numberwidth|nuw|odev|oft|ofu|omnifunc|opendevice|operatorfunc|opfunc|osfiletype|pa|para|paragraphs|paste|pastetoggle|patchexpr|patchmode|path|pdev|penc|pex|pexpr|pfn|ph|pheader|pi|pm|pmbcs|pmbfn|popt|preserveindent|previewheight|previewwindow|printdevice|printencoding|printexpr|printfont|printheader|printmbcharset|printmbfont|printoptions|prompt|pt|pumheight|pvh|pvw|qe|quoteescape|readonly|remap|report|restorescreen|revins|rightleft|rightleftcmd|rl|rlc|ro|rs|rtp|ruf|ruler|rulerformat|runtimepath|sbo|sc|scb|scr|scroll|scrollbind|scrolljump|scrolloff|scrollopt|scs|sect|sections|secure|sel|selection|selectmode|sessionoptions|sft|shcf|shellcmdflag|shellpipe|shellquote|shellredir|shellslash|shelltemp|shelltype|shellxquote|shiftround|shiftwidth|shm|shortmess|shortname|showbreak|showcmd|showfulltag|showmatch|showmode|showtabline|shq|si|sidescroll|sidescrolloff|siso|sj|slm|smartcase|smartindent|smarttab|smc|smd|softtabstop|sol|spc|spell|spellcapcheck|spellfile|spelllang|spellsuggest|spf|spl|splitbelow|splitright|sps|sr|srr|ss|ssl|ssop|stal|startofline|statusline|stl|stmp|su|sua|suffixes|suffixesadd|sw|swapfile|swapsync|swb|swf|switchbuf|sws|sxq|syn|synmaxcol|syntax|tabline|tabpagemax|tabstop|tagbsearch|taglength|tagrelative|tagstack|tal|tb|tbi|tbidi|tbis|tbs|tenc|term|termbidi|termencoding|terse|textauto|textmode|textwidth|tgst|thesaurus|tildeop|timeout|timeoutlen|title|titlelen|titleold|titlestring|toolbar|toolbariconsize|top|tpm|tsl|tsr|ttimeout|ttimeoutlen|ttm|tty|ttybuiltin|ttyfast|ttym|ttymouse|ttyscroll|ttytype|tw|tx|uc|ul|undolevels|updatecount|updatetime|ut|vb|vbs|vdir|verbosefile|vfile|viewdir|viewoptions|viminfo|virtualedit|visualbell|vop|wak|warn|wb|wc|wcm|wd|weirdinvert|wfh|wfw|whichwrap|wi|wig|wildchar|wildcharm|wildignore|wildmenu|wildmode|wildoptions|wim|winaltkeys|window|winfixheight|winfixwidth|winheight|winminheight|winminwidth|winwidth|wiv|wiw|wm|wmh|wmnu|wmw|wop|wrap|wrapmargin|wrapscan|writeany|writebackup|writedelay|ww|noacd|noai|noakm|noallowrevins|noaltkeymap|noanti|noantialias|noar|noarab|noarabic|noarabicshape|noari|noarshape|noautochdir|noautoindent|noautoread|noautowrite|noautowriteall|noaw|noawa|nobackup|noballooneval|nobeval|nobin|nobinary|nobiosk|nobioskey|nobk|nobl|nobomb|nobuflisted|nocf|noci|nocin|nocindent|nocompatible|noconfirm|noconsk|noconskey|nocopyindent|nocp|nocscopetag|nocscopeverbose|nocst|nocsverb|nocuc|nocul|nocursorcolumn|nocursorline|nodeco|nodelcombine|nodg|nodiff|nodigraph|nodisable|noea|noeb|noed|noedcompatible|noek|noendofline|noeol|noequalalways|noerrorbells|noesckeys|noet|noex|noexpandtab|noexrc|nofen|nofk|nofkmap|nofoldenable|nogd|nogdefault|noguipty|nohid|nohidden|nohk|nohkmap|nohkmapp|nohkp|nohls|noic|noicon|noignorecase|noim|noimc|noimcmdline|noimd|noincsearch|noinf|noinfercase|noinsertmode|nois|nojoinspaces|nojs|nolazyredraw|nolbr|nolinebreak|nolisp|nolist|noloadplugins|nolpl|nolz|noma|nomacatsui|nomagic|nomh|noml|nomod|nomodeline|nomodifiable|nomodified|nomore|nomousef|nomousefocus|nomousehide|nonu|nonumber|noodev|noopendevice|nopaste|nopi|nopreserveindent|nopreviewwindow|noprompt|nopvw|noreadonly|noremap|norestorescreen|norevins|nori|norightleft|norightleftcmd|norl|norlc|noro|nors|noru|noruler|nosb|nosc|noscb|noscrollbind|noscs|nosecure|nosft|noshellslash|noshelltemp|noshiftround|noshortname|noshowcmd|noshowfulltag|noshowmatch|noshowmode|nosi|nosm|nosmartcase|nosmartindent|nosmarttab|nosmd|nosn|nosol|nospell|nosplitbelow|nosplitright|nospr|nosr|nossl|nosta|nostartofline|nostmp|noswapfile|noswf|nota|notagbsearch|notagrelative|notagstack|notbi|notbidi|notbs|notermbidi|noterse|notextauto|notextmode|notf|notgst|notildeop|notimeout|notitle|noto|notop|notr|nottimeout|nottybuiltin|nottyfast|notx|novb|novisualbell|nowa|nowarn|nowb|noweirdinvert|nowfh|nowfw|nowildmenu|nowinfixheight|nowinfixwidth|nowiv|nowmnu|nowrap|nowrapscan|nowrite|nowriteany|nowritebackup|nows|invacd|invai|invakm|invallowrevins|invaltkeymap|invanti|invantialias|invar|invarab|invarabic|invarabicshape|invari|invarshape|invautochdir|invautoindent|invautoread|invautowrite|invautowriteall|invaw|invawa|invbackup|invballooneval|invbeval|invbin|invbinary|invbiosk|invbioskey|invbk|invbl|invbomb|invbuflisted|invcf|invci|invcin|invcindent|invcompatible|invconfirm|invconsk|invconskey|invcopyindent|invcp|invcscopetag|invcscopeverbose|invcst|invcsverb|invcuc|invcul|invcursorcolumn|invcursorline|invdeco|invdelcombine|invdg|invdiff|invdigraph|invdisable|invea|inveb|inved|invedcompatible|invek|invendofline|inveol|invequalalways|inverrorbells|invesckeys|invet|invex|invexpandtab|invexrc|invfen|invfk|invfkmap|invfoldenable|invgd|invgdefault|invguipty|invhid|invhidden|invhk|invhkmap|invhkmapp|invhkp|invhls|invhlsearch|invic|invicon|invignorecase|invim|invimc|invimcmdline|invimd|invincsearch|invinf|invinfercase|invinsertmode|invis|invjoinspaces|invjs|invlazyredraw|invlbr|invlinebreak|invlisp|invlist|invloadplugins|invlpl|invlz|invma|invmacatsui|invmagic|invmh|invml|invmod|invmodeline|invmodifiable|invmodified|invmore|invmousef|invmousefocus|invmousehide|invnu|invnumber|invodev|invopendevice|invpaste|invpi|invpreserveindent|invpreviewwindow|invprompt|invpvw|invreadonly|invremap|invrestorescreen|invrevins|invri|invrightleft|invrightleftcmd|invrl|invrlc|invro|invrs|invru|invruler|invsb|invsc|invscb|invscrollbind|invscs|invsecure|invsft|invshellslash|invshelltemp|invshiftround|invshortname|invshowcmd|invshowfulltag|invshowmatch|invshowmode|invsi|invsm|invsmartcase|invsmartindent|invsmarttab|invsmd|invsn|invsol|invspell|invsplitbelow|invsplitright|invspr|invsr|invssl|invsta|invstartofline|invstmp|invswapfile|invswf|invta|invtagbsearch|invtagrelative|invtagstack|invtbi|invtbidi|invtbs|invtermbidi|invterse|invtextauto|invtextmode|invtf|invtgst|invtildeop|invtimeout|invtitle|invto|invtop|invtr|invttimeout|invttybuiltin|invttyfast|invtx|invvb|invvisualbell|invwa|invwarn|invwb|invweirdinvert|invwfh|invwfw|invwildmenu|invwinfixheight|invwinfixwidth|invwiv|invwmnu|invwrap|invwrapscan|invwrite|invwriteany|invwritebackup|invws|t_AB|t_AF|t_al|t_AL|t_bc|t_cd|t_ce|t_Ce|t_cl|t_cm|t_Co|t_cs|t_Cs|t_CS|t_CV|t_da|t_db|t_dl|t_DL|t_EI|t_F1|t_F2|t_F3|t_F4|t_F5|t_F6|t_F7|t_F8|t_F9|t_fs|t_IE|t_IS|t_k1|t_K1|t_k2|t_k3|t_K3|t_k4|t_K4|t_k5|t_K5|t_k6|t_K6|t_k7|t_K7|t_k8|t_K8|t_k9|t_K9|t_KA|t_kb|t_kB|t_KB|t_KC|t_kd|t_kD|t_KD|t_ke|t_KE|t_KF|t_KG|t_kh|t_KH|t_kI|t_KI|t_KJ|t_KK|t_kl|t_KL|t_kN|t_kP|t_kr|t_ks|t_ku|t_le|t_mb|t_md|t_me|t_mr|t_ms|t_nd|t_op|t_RI|t_RV|t_Sb|t_se|t_Sf|t_SI|t_so|t_sr|t_te|t_ti|t_ts|t_ue|t_us|t_ut|t_vb|t_ve|t_vi|t_vs|t_WP|t_WS|t_xs|t_ZH|t_ZR)\b/,number:/\b(?:0x[\da-f]+|\d+(?:\.\d+)?)\b/i,operator:/\|\||&&|[-+.]=?|[=!](?:[=~][#?]?)?|[<>]=?[#?]?|[*\/%?]|\b(?:is(?:not)?)\b/,punctuation:/[{}[\](),;:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=visualBasic;visualBasic.displayName="visualBasic";visualBasic.aliases=[];function visualBasic(Prism){Prism.languages["visual-basic"]={comment:{pattern:/(?:['‘’]|REM\b)(?:[^\r\n_]|_(?:\r\n?|\n)?)*/i,inside:{keyword:/^REM/i}},directive:{pattern:/#(?:Const|Else|ElseIf|End|ExternalChecksum|ExternalSource|If|Region)(?:[^\S\r\n]_[^\S\r\n]*(?:\r\n?|\n)|.)+/i,alias:"comment",greedy:true},string:{pattern:/\$?["“”](?:["“”]{2}|[^"“”])*["“”]C?/i,greedy:true},date:{pattern:/#[^\S\r\n]*(?:\d+([/-])\d+\1\d+(?:[^\S\r\n]+(?:\d+[^\S\r\n]*(?:AM|PM)|\d+:\d+(?::\d+)?(?:[^\S\r\n]*(?:AM|PM))?))?|\d+[^\S\r\n]*(?:AM|PM)|\d+:\d+(?::\d+)?(?:[^\S\r\n]*(?:AM|PM))?)[^\S\r\n]*#/i,alias:"builtin"},number:/(?:(?:\b\d+(?:\.\d+)?|\.\d+)(?:E[+-]?\d+)?|&[HO][\dA-F]+)(?:U?[ILS]|[FRD])?/i,boolean:/\b(?:True|False|Nothing)\b/i,keyword:/\b(?:AddHandler|AddressOf|Alias|And(?:Also)?|As|Boolean|ByRef|Byte|ByVal|Call|Case|Catch|C(?:Bool|Byte|Char|Date|Dbl|Dec|Int|Lng|Obj|SByte|Short|Sng|Str|Type|UInt|ULng|UShort)|Char|Class|Const|Continue|Currency|Date|Decimal|Declare|Default|Delegate|Dim|DirectCast|Do|Double|Each|Else(?:If)?|End(?:If)?|Enum|Erase|Error|Event|Exit|Finally|For|Friend|Function|Get(?:Type|XMLNamespace)?|Global|GoSub|GoTo|Handles|If|Implements|Imports|In|Inherits|Integer|Interface|Is|IsNot|Let|Lib|Like|Long|Loop|Me|Mod|Module|Must(?:Inherit|Override)|My(?:Base|Class)|Namespace|Narrowing|New|Next|Not(?:Inheritable|Overridable)?|Object|Of|On|Operator|Option(?:al)?|Or(?:Else)?|Out|Overloads|Overridable|Overrides|ParamArray|Partial|Private|Property|Protected|Public|RaiseEvent|ReadOnly|ReDim|RemoveHandler|Resume|Return|SByte|Select|Set|Shadows|Shared|short|Single|Static|Step|Stop|String|Structure|Sub|SyncLock|Then|Throw|To|Try|TryCast|Type|TypeOf|U(?:Integer|Long|Short)|Using|Variant|Wend|When|While|Widening|With(?:Events)?|WriteOnly|Until|Xor)\b/i,operator:[/[+\-*/\\^<=>&#@$%!]/,{pattern:/([^\S\r\n])_(?=[^\S\r\n]*[\r\n])/,lookbehind:true}],punctuation:/[{}().,:?]/};Prism.languages.vb=Prism.languages["visual-basic"];Prism.languages.vba=Prism.languages["visual-basic"]}},function(module,exports,__webpack_require__){"use strict";module.exports=warpscript;warpscript.displayName="warpscript";warpscript.aliases=[];function warpscript(Prism){Prism.languages.warpscript={comment:/#.*|\/\/.*|\/\*[\s\S]*?\*\//,string:{pattern:/"(?:[^"\\\r\n]|\\.)*"|'(?:[^'\\\r\n]|\\.)*'|<'(?:[^\\']|'(?!>)|\\.)*'>/,greedy:true},variable:/\$\S+/,macro:{pattern:/@\S+/,alias:"property"},keyword:/\b(?:BREAK|CHECKMACRO|CONTINUE|CUDF|DEFINED|DEFINEDMACRO|EVAL|FAIL|FOR|FOREACH|FORSTEP|IFT|IFTE|MSGFAIL|NRETURN|RETHROW|RETURN|SWITCH|TRY|UDF|UNTIL|WHILE)\b/,number:/[+-]?\b(?:NaN|Infinity|\d+(?:\.\d*)?(?:[Ee][+-]?\d+)?|0x[\da-fA-F]+|0b[01]+)\b/,boolean:/\b(?:false|true|F|T)\b/,punctuation:/<%|%>|[{}[\]()]/,operator:/==|&&?|\|\|?|\*\*?|>>>?|<<|[<>!~]=?|[-/%^]|\+!?|\b(?:AND|NOT|OR)\b/}}},function(module,exports,__webpack_require__){"use strict";module.exports=wasm;wasm.displayName="wasm";wasm.aliases=[];function wasm(Prism){Prism.languages.wasm={comment:[/\(;[\s\S]*?;\)/,{pattern:/;;.*/,greedy:true}],string:{pattern:/"(?:\\[\s\S]|[^"\\])*"/,greedy:true},keyword:[{pattern:/\b(?:align|offset)=/,inside:{operator:/=/}},{pattern:/\b(?:(?:f32|f64|i32|i64)(?:\.(?:abs|add|and|ceil|clz|const|convert_[su]\/i(?:32|64)|copysign|ctz|demote\/f64|div(?:_[su])?|eqz?|extend_[su]\/i32|floor|ge(?:_[su])?|gt(?:_[su])?|le(?:_[su])?|load(?:(?:8|16|32)_[su])?|lt(?:_[su])?|max|min|mul|nearest|neg?|or|popcnt|promote\/f32|reinterpret\/[fi](?:32|64)|rem_[su]|rot[lr]|shl|shr_[su]|store(?:8|16|32)?|sqrt|sub|trunc(?:_[su]\/f(?:32|64))?|wrap\/i64|xor))?|memory\.(?:grow|size))\b/,inside:{punctuation:/\./}},/\b(?:anyfunc|block|br(?:_if|_table)?|call(?:_indirect)?|data|drop|elem|else|end|export|func|get_(?:global|local)|global|if|import|local|loop|memory|module|mut|nop|offset|param|result|return|select|set_(?:global|local)|start|table|tee_local|then|type|unreachable)\b/],variable:/\$[\w!#$%&'*+\-./:<=>?@\\^_`|~]+/i,number:/[+-]?\b(?:\d(?:_?\d)*(?:\.\d(?:_?\d)*)?(?:[eE][+-]?\d(?:_?\d)*)?|0x[\da-fA-F](?:_?[\da-fA-F])*(?:\.[\da-fA-F](?:_?[\da-fA-D])*)?(?:[pP][+-]?\d(?:_?\d)*)?)\b|\binf\b|\bnan(?::0x[\da-fA-F](?:_?[\da-fA-D])*)?\b/,punctuation:/[()]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=wiki;wiki.displayName="wiki";wiki.aliases=[];function wiki(Prism){Prism.languages.wiki=Prism.languages.extend("markup",{"block-comment":{pattern:/(^|[^\\])\/\*[\s\S]*?\*\//,lookbehind:true,alias:"comment"},heading:{pattern:/^(=+).+?\1/m,inside:{punctuation:/^=+|=+$/,important:/.+/}},emphasis:{pattern:/('{2,5}).+?\1/,inside:{"bold-italic":{pattern:/(''''').+?(?=\1)/,lookbehind:true,alias:["bold","italic"]},bold:{pattern:/(''')[^'](?:.*?[^'])?(?=\1)/,lookbehind:true},italic:{pattern:/('')[^'](?:.*?[^'])?(?=\1)/,lookbehind:true},punctuation:/^''+|''+$/}},hr:{pattern:/^-{4,}/m,alias:"punctuation"},url:[/ISBN +(?:97[89][ -]?)?(?:\d[ -]?){9}[\dx]\b|(?:RFC|PMID) +\d+/i,/\[\[.+?\]\]|\[.+?\]/],variable:[/__[A-Z]+__/,/\{{3}.+?\}{3}/,/\{\{.+?\}\}/],symbol:[/^#redirect/im,/~{3,5}/],"table-tag":{pattern:/((?:^|[|!])[|!])[^|\r\n]+\|(?!\|)/m,lookbehind:true,inside:{"table-bar":{pattern:/\|$/,alias:"punctuation"},rest:Prism.languages.markup["tag"].inside}},punctuation:/^(?:\{\||\|\}|\|-|[*#:;!|])|\|\||!!/m});Prism.languages.insertBefore("wiki","tag",{nowiki:{pattern:/<(nowiki|pre|source)\b[\s\S]*?>[\s\S]*?<\/\1>/i,inside:{tag:{pattern:/<(?:nowiki|pre|source)\b[\s\S]*?>|<\/(?:nowiki|pre|source)>/i,inside:Prism.languages.markup["tag"].inside}}}})}},function(module,exports,__webpack_require__){"use strict";module.exports=xeora;xeora.displayName="xeora";xeora.aliases=["xeoracube"];function xeora(Prism){(function(Prism){Prism.languages.xeora=Prism.languages.extend("markup",{constant:{pattern:/\$(?:DomainContents|PageRenderDuration)\$/,inside:{punctuation:{pattern:/\$/}}},variable:{pattern:/\$@?(?:#+|[-+*~=^])?[\w.]+\$/,inside:{punctuation:{pattern:/[$.]/},operator:{pattern:/#+|[-+*~=^@]/}}},"function-inline":{pattern:/\$F:[-\w.]+\?[-\w.]+(?:,(?:\|?(?:[-#.^+*~]*(?:[\w+][^$]*)|=(?:[\S+][^$]*)|@[-#]*(?:\w+.)[\w+.]+)?)*)?\$/,inside:{variable:{pattern:/(?:[,|])@?(?:#+|[-+*~=^])?[\w.]+/,inside:{punctuation:{pattern:/[,.|]/},operator:{pattern:/#+|[-+*~=^@]/}}},punctuation:{pattern:/\$\w:|[$:?.,|]/}},alias:"function"},"function-block":{pattern:/\$XF:{[-\w.]+\?[-\w.]+(?:,(?:\|?(?:[-#.^+*~]*(?:[\w+][^$]*)|=(?:[\S+][^$]*)|@[-#]*(?:\w+.)[\w+.]+)?)*)?}:XF\$/,inside:{punctuation:{pattern:/[$:{}?.,|]/}},alias:"function"},"directive-inline":{pattern:/\$\w(?:#\d+\+?)?(?:\[[-\w.]+])?:[-\/\w.]+\$/,inside:{punctuation:{pattern:/\$(?:\w:|C(?:\[|#\d))?|[:{[\]]/,inside:{tag:{pattern:/#\d/}}}},alias:"function"},"directive-block-open":{pattern:/\$\w+:{|\$\w(?:#\d+\+?)?(?:\[[-\w.]+])?:[-\w.]+:{(?:![A-Z]+)?/,inside:{punctuation:{pattern:/\$(?:\w:|C(?:\[|#\d))?|[:{[\]]/,inside:{tag:{pattern:/#\d/}}},attribute:{pattern:/![A-Z]+$/,inside:{punctuation:{pattern:/!/}},alias:"keyword"}},alias:"function"},"directive-block-separator":{pattern:/}:[-\w.]+:{/,inside:{punctuation:{pattern:/[:{}]/}},alias:"function"},"directive-block-close":{pattern:/}:[-\w.]+\$/,inside:{punctuation:{pattern:/[:{}$]/}},alias:"function"}});Prism.languages.insertBefore("inside","punctuation",{variable:Prism.languages.xeora["function-inline"].inside["variable"]},Prism.languages.xeora["function-block"]);Prism.languages.xeoracube=Prism.languages.xeora})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=xmlDoc;xmlDoc.displayName="xmlDoc";xmlDoc.aliases=[];function xmlDoc(Prism){(function(Prism){function insertDocComment(lang,docComment){if(Prism.languages[lang]){Prism.languages.insertBefore(lang,"comment",{"doc-comment":docComment})}}var tag=Prism.languages.markup.tag;var slashDocComment={pattern:/\/\/\/.*/,greedy:true,alias:"comment",inside:{tag:tag}};var tickDocComment={pattern:/'''.*/,greedy:true,alias:"comment",inside:{tag:tag}};insertDocComment("csharp",slashDocComment);insertDocComment("fsharp",slashDocComment);insertDocComment("vbnet",tickDocComment)})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=xojo;xojo.displayName="xojo";xojo.aliases=[];function xojo(Prism){Prism.languages.xojo={comment:{pattern:/(?:'|\/\/|Rem\b).+/i,inside:{keyword:/^Rem/i}},string:{pattern:/"(?:""|[^"])*"/,greedy:true},number:[/(?:\b\d+\.?\d*|\B\.\d+)(?:E[+-]?\d+)?/i,/&[bchou][a-z\d]+/i],symbol:/#(?:If|Else|ElseIf|Endif|Pragma)\b/i,keyword:/\b(?:AddHandler|App|Array|As(?:signs)?|By(?:Ref|Val)|Break|Call|Case|Catch|Const|Continue|CurrentMethodName|Declare|Dim|Do(?:wnTo)?|Each|Else(?:If)?|End|Exit|Extends|False|Finally|For|Global|If|In|Lib|Loop|Me|Next|Nil|Optional|ParamArray|Raise(?:Event)?|ReDim|Rem|RemoveHandler|Return|Select|Self|Soft|Static|Step|Super|Then|To|True|Try|Ubound|Until|Using|Wend|While)\b/i,operator:/<[=>]?|>=?|[+\-*\/\\^=]|\b(?:AddressOf|And|Ctype|IsA?|Mod|New|Not|Or|Xor|WeakAddressOf)\b/i,punctuation:/[.,;:()]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=xquery;xquery.displayName="xquery";xquery.aliases=[];function xquery(Prism){(function(Prism){Prism.languages.xquery=Prism.languages.extend("markup",{"xquery-comment":{pattern:/\(:[\s\S]*?:\)/,greedy:true,alias:"comment"},string:{pattern:/(["'])(?:\1\1|(?!\1)[\s\S])*\1/,greedy:true},extension:{pattern:/\(#.+?#\)/,alias:"symbol"},variable:/\$[\w-:]+/,axis:{pattern:/(^|[^-])(?:ancestor(?:-or-self)?|attribute|child|descendant(?:-or-self)?|following(?:-sibling)?|parent|preceding(?:-sibling)?|self)(?=::)/,lookbehind:true,alias:"operator"},"keyword-operator":{pattern:/(^|[^:-])\b(?:and|castable as|div|eq|except|ge|gt|idiv|instance of|intersect|is|le|lt|mod|ne|or|union)\b(?=$|[^:-])/,lookbehind:true,alias:"operator"},keyword:{pattern:/(^|[^:-])\b(?:as|ascending|at|base-uri|boundary-space|case|cast as|collation|construction|copy-namespaces|declare|default|descending|else|empty (?:greatest|least)|encoding|every|external|for|function|if|import|in|inherit|lax|let|map|module|namespace|no-inherit|no-preserve|option|order(?: by|ed|ing)?|preserve|return|satisfies|schema|some|stable|strict|strip|then|to|treat as|typeswitch|unordered|validate|variable|version|where|xquery)\b(?=$|[^:-])/,lookbehind:true},function:/[\w-]+(?::[\w-]+)*(?=\s*\()/,"xquery-element":{pattern:/(element\s+)[\w-]+(?::[\w-]+)*/,lookbehind:true,alias:"tag"},"xquery-attribute":{pattern:/(attribute\s+)[\w-]+(?::[\w-]+)*/,lookbehind:true,alias:"attr-name"},builtin:{pattern:/(^|[^:-])\b(?:attribute|comment|document|element|processing-instruction|text|xs:(?:anyAtomicType|anyType|anyURI|base64Binary|boolean|byte|date|dateTime|dayTimeDuration|decimal|double|duration|ENTITIES|ENTITY|float|gDay|gMonth|gMonthDay|gYear|gYearMonth|hexBinary|ID|IDREFS?|int|integer|language|long|Name|NCName|negativeInteger|NMTOKENS?|nonNegativeInteger|nonPositiveInteger|normalizedString|NOTATION|positiveInteger|QName|short|string|time|token|unsigned(?:Byte|Int|Long|Short)|untyped(?:Atomic)?|yearMonthDuration))\b(?=$|[^:-])/,lookbehind:true},number:/\b\d+(?:\.\d+)?(?:E[+-]?\d+)?/,operator:[/[+*=?|@]|\.\.?|:=|!=|<[=<]?|>[=>]?/,{pattern:/(\s)-(?=\s)/,lookbehind:true}],punctuation:/[[\](){},;:/]/});Prism.languages.xquery.tag.pattern=/<\/?(?!\d)[^\s>\/=$<%]+(?:\s+[^\s>\/=]+(?:=(?:("|')(?:\\[\s\S]|{(?!{)(?:{(?:{[^{}]*}|[^{}])*}|[^{}])+}|(?!\1)[^\\])*\1|[^\s'">=]+))?)*\s*\/?>/i;Prism.languages.xquery["tag"].inside["attr-value"].pattern=/=(?:("|')(?:\\[\s\S]|{(?!{)(?:{(?:{[^{}]*}|[^{}])*}|[^{}])+}|(?!\1)[^\\])*\1|[^\s'">=]+)/i;Prism.languages.xquery["tag"].inside["attr-value"].inside["punctuation"]=/^="|"$/;Prism.languages.xquery["tag"].inside["attr-value"].inside["expression"]={pattern:/{(?!{)(?:{(?:{[^{}]*}|[^{}])*}|[^{}])+}/,inside:Prism.languages.xquery,alias:"language-xquery"};var stringifyToken=function(token){if(typeof token==="string"){return token}if(typeof token.content==="string"){return token.content}return token.content.map(stringifyToken).join("")};var walkTokens=function(tokens){var openedTags=[];for(var i=0;i<tokens.length;i++){var token=tokens[i];var notTagNorBrace=false;if(typeof token!=="string"){if(token.type==="tag"&&token.content[0]&&token.content[0].type==="tag"){if(token.content[0].content[0].content==="</"){if(openedTags.length>0&&openedTags[openedTags.length-1].tagName===stringifyToken(token.content[0].content[1])){openedTags.pop()}}else{if(token.content[token.content.length-1].content==="/>"){}else{openedTags.push({tagName:stringifyToken(token.content[0].content[1]),openedBraces:0})}}}else if(openedTags.length>0&&token.type==="punctuation"&&token.content==="{"&&(!tokens[i+1]||tokens[i+1].type!=="punctuation"||tokens[i+1].content!=="{")&&(!tokens[i-1]||tokens[i-1].type!=="plain-text"||tokens[i-1].content!=="{")){openedTags[openedTags.length-1].openedBraces++}else if(openedTags.length>0&&openedTags[openedTags.length-1].openedBraces>0&&token.type==="punctuation"&&token.content==="}"){openedTags[openedTags.length-1].openedBraces--}else if(token.type!=="comment"){notTagNorBrace=true}}if(notTagNorBrace||typeof token==="string"){if(openedTags.length>0&&openedTags[openedTags.length-1].openedBraces===0){var plainText=stringifyToken(token);if(i<tokens.length-1&&(typeof tokens[i+1]==="string"||tokens[i+1].type==="plain-text")){plainText+=stringifyToken(tokens[i+1]);tokens.splice(i+1,1)}if(i>0&&(typeof tokens[i-1]==="string"||tokens[i-1].type==="plain-text")){plainText=stringifyToken(tokens[i-1])+plainText;tokens.splice(i-1,1);i--}if(/^\s+$/.test(plainText)){tokens[i]=plainText}else{tokens[i]=new Prism.Token("plain-text",plainText,null,plainText)}}}if(token.content&&typeof token.content!=="string"){walkTokens(token.content)}}};Prism.hooks.add("after-tokenize",(function(env){if(env.language!=="xquery"){return}walkTokens(env.tokens)}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=yang;yang.displayName="yang";yang.aliases=[];function yang(Prism){Prism.languages.yang={comment:/\/\*[\s\S]*?\*\/|\/\/.*/,string:{pattern:/"(?:[^\\"]|\\.)*"|'[^']*'/,greedy:true},keyword:{pattern:/(^|[{};\r\n][ \t]*)[a-z_][\w.-]*/i,lookbehind:true},namespace:{pattern:/(\s)[a-z_][\w.-]*(?=:)/i,lookbehind:true},boolean:/\b(?:false|true)\b/,operator:/\+/,punctuation:/[{};:]/}}},function(module,exports,__webpack_require__){"use strict";module.exports=zig;zig.displayName="zig";zig.aliases=[];function zig(Prism){(function(Prism){function literal(str){return function(){return str}}var keyword=/\b(?:align|allowzero|and|asm|async|await|break|cancel|catch|comptime|const|continue|defer|else|enum|errdefer|error|export|extern|fn|for|if|inline|linksection|nakedcc|noalias|null|or|orelse|packed|promise|pub|resume|return|stdcallcc|struct|suspend|switch|test|threadlocal|try|undefined|union|unreachable|usingnamespace|var|volatile|while)\b/;var IDENTIFIER="\\b(?!"+keyword.source+")(?!\\d)\\w+\\b";var ALIGN=/align\s*\((?:[^()]|\([^()]*\))*\)/.source;var PREFIX_TYPE_OP=/(?:\?|\bpromise->|(?:\[[^[\]]*\]|\*(?!\*)|\*\*)(?:\s*<ALIGN>|\s*const\b|\s*volatile\b|\s*allowzero\b)*)/.source.replace(/<ALIGN>/g,literal(ALIGN));var SUFFIX_EXPR=/(?:\bpromise\b|(?:\berror\.)?<ID>(?:\.<ID>)*(?!\s+<ID>))/.source.replace(/<ID>/g,literal(IDENTIFIER));var TYPE="(?!\\s)(?:!?\\s*(?:"+PREFIX_TYPE_OP+"\\s*)*"+SUFFIX_EXPR+")+";Prism.languages.zig={comment:[{pattern:/\/{3}.*/,alias:"doc-comment"},/\/{2}.*/],string:[{pattern:/(^|[^\\@])c?"(?:[^"\\\r\n]|\\.)*"/,lookbehind:true,greedy:true},{pattern:/([\r\n])([ \t]+c?\\{2}).*(?:(?:\r\n?|\n)\2.*)*/,lookbehind:true,greedy:true},{pattern:/(^|[^\\])'(?:[^'\\\r\n]|\\(?:.|x[a-fA-F\d]{2}|u\{[a-fA-F\d]{1,6}\}))'/,lookbehind:true,greedy:true}],builtin:/\B@(?!\d)\w+(?=\s*\()/,label:{pattern:/(\b(?:break|continue)\s*:\s*)\w+\b|\b(?!\d)\w+\b(?=\s*:\s*(?:\{|while\b))/,lookbehind:true},"class-name":[/\b(?!\d)\w+(?=\s*=\s*(?:(?:extern|packed)\s+)?(?:enum|struct|union)\s*[({])/,{pattern:RegExp(/(:\s*)<TYPE>(?=\s*(?:<ALIGN>\s*)?[=;,)])|<TYPE>(?=\s*(?:<ALIGN>\s*)?\{)/.source.replace(/<TYPE>/g,literal(TYPE)).replace(/<ALIGN>/g,literal(ALIGN))),lookbehind:true,inside:null},{pattern:RegExp(/(\)\s*)<TYPE>(?=\s*(?:<ALIGN>\s*)?;)/.source.replace(/<TYPE>/g,literal(TYPE)).replace(/<ALIGN>/g,literal(ALIGN))),lookbehind:true,inside:null}],"builtin-types":{pattern:/\b(?:anyerror|bool|c_u?(?:short|int|long|longlong)|c_longdouble|c_void|comptime_(?:float|int)|[iu](?:8|16|32|64|128|size)|f(?:16|32|64|128)|noreturn|type|void)\b/,alias:"keyword"},keyword:keyword,function:/\b(?!\d)\w+(?=\s*\()/,number:/\b(?:0b[01]+|0o[0-7]+|0x[a-fA-F\d]+\.?[a-fA-F\d]*(?:[pP][+-]?[a-fA-F\d]+)?|\d+\.?\d*(?:[eE][+-]?\d+)?)\b/,boolean:/\b(?:false|true)\b/,operator:/\.[*?]|\.{2,3}|[-=]>|\*\*|\+\+|\|\||(?:<<|>>|[-+*]%|[-+*/%^&|<>!=])=?|[?~]/,punctuation:/[.:,;(){}[\]]/};Prism.languages.zig["class-name"].forEach((function(obj){if(obj.inside===null){obj.inside=Prism.languages.zig}}))})(Prism)}},function(module,exports,__webpack_require__){"use strict";module.exports=Schema;var proto=Schema.prototype;proto.space=null;proto.normal={};proto.property={};function Schema(property,normal,space){this.property=property;this.normal=normal;if(space){this.space=space}}},function(module,exports,__webpack_require__){"use strict";var Info=__webpack_require__(482);var types=__webpack_require__(188);module.exports=DefinedInfo;DefinedInfo.prototype=new Info;DefinedInfo.prototype.defined=true;var checks=["boolean","booleanish","overloadedBoolean","number","commaSeparated","spaceSeparated","commaOrSpaceSeparated"];var checksLength=checks.length;function DefinedInfo(property,attribute,mask,space){var index=-1;var check;mark(this,"space",space);Info.call(this,property,attribute);while(++index<checksLength){check=checks[index];mark(this,check,(mask&types[check])===types[check])}}function mark(values,key,value){if(value){values[key]=value}}},function(module,exports,__webpack_require__){"use strict";module.exports=Info;var proto=Info.prototype;proto.space=null;proto.attribute=null;proto.property=null;proto.boolean=false;proto.booleanish=false;proto.overloadedBoolean=false;proto.number=false;proto.commaSeparated=false;proto.spaceSeparated=false;proto.commaOrSpaceSeparated=false;proto.mustUseProperty=false;proto.defined=false;function Info(property,attribute){this.property=property;this.attribute=attribute}},function(module,exports,__webpack_require__){"use strict";var caseSensitiveTransform=__webpack_require__(1104);module.exports=caseInsensitiveTransform;function caseInsensitiveTransform(attributes,property){return caseSensitiveTransform(attributes,property.toLowerCase())}},function(module,exports,__webpack_require__){"use strict";module.exports=decimal;function decimal(character){var code=typeof character==="string"?character.charCodeAt(0):character;return code>=48&&code<=57}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _default=["abap","abnf","actionscript","ada","agda","al","antlr4","apacheconf","apl","applescript","aql","arduino","arff","asciidoc","asm6502","aspnet","autohotkey","autoit","bash","basic","batch","bbcode","birb","bison","bnf","brainfuck","brightscript","bro","bsl","c","cil","clike","clojure","cmake","coffeescript","concurnas","cpp","crystal","csharp","csp","css-extras","css","cypher","d","dart","dax","dhall","diff","django","dns-zone-file","docker","ebnf","editorconfig","eiffel","ejs","elixir","elm","erb","erlang","etlua","excel-formula","factor","firestore-security-rules","flow","fortran","fsharp","ftl","gcode","gdscript","gedcom","gherkin","git","glsl","gml","go","graphql","groovy","haml","handlebars","haskell","haxe","hcl","hlsl","hpkp","hsts","http","ichigojam","icon","iecst","ignore","inform7","ini","io","j","java","javadoc","javadoclike","javascript","javastacktrace","jolie","jq","js-extras","js-templates","jsdoc","json","json5","jsonp","jsstacktrace","jsx","julia","keyman","kotlin","latex","latte","less","lilypond","liquid","lisp","livescript","llvm","lolcode","lua","makefile","markdown","markup-templating","markup","matlab","mel","mizar","mongodb","monkey","moonscript","n1ql","n4js","nand2tetris-hdl","naniscript","nasm","neon","nginx","nim","nix","nsis","objectivec","ocaml","opencl","oz","parigp","parser","pascal","pascaligo","pcaxis","peoplecode","perl","php-extras","php","phpdoc","plsql","powerquery","powershell","processing","prolog","properties","protobuf","pug","puppet","pure","purebasic","purescript","python","q","qml","qore","r","racket","reason","regex","renpy","rest","rip","roboconf","robotframework","ruby","rust","sas","sass","scala","scheme","scss","shell-session","smali","smalltalk","smarty","sml","solidity","solution-file","soy","sparql","splunk-spl","sqf","sql","stan","stylus","swift","t4-cs","t4-templating","t4-vb","tap","tcl","textile","toml","tsx","tt2","turtle","twig","typescript","typoscript","unrealscript","vala","vbnet","velocity","verilog","vhdl","vim","visual-basic","warpscript","wasm","wiki","xeora","xml-doc","xojo","xquery","yaml","yang","zig"];exports.default=_default},function(module,exports,__webpack_require__){"use strict";var refractor=__webpack_require__(186);module.exports=refractor;refractor.register(__webpack_require__(267));refractor.register(__webpack_require__(268));refractor.register(__webpack_require__(269));refractor.register(__webpack_require__(270));refractor.register(__webpack_require__(271));refractor.register(__webpack_require__(272));refractor.register(__webpack_require__(273));refractor.register(__webpack_require__(274));refractor.register(__webpack_require__(275));refractor.register(__webpack_require__(276));refractor.register(__webpack_require__(277));refractor.register(__webpack_require__(278));refractor.register(__webpack_require__(279));refractor.register(__webpack_require__(280));refractor.register(__webpack_require__(281));refractor.register(__webpack_require__(282));refractor.register(__webpack_require__(283));refractor.register(__webpack_require__(284));refractor.register(__webpack_require__(177));refractor.register(__webpack_require__(178));refractor.register(__webpack_require__(285));refractor.register(__webpack_require__(286));refractor.register(__webpack_require__(287));refractor.register(__webpack_require__(288));refractor.register(__webpack_require__(289));refractor.register(__webpack_require__(290));refractor.register(__webpack_require__(291));refractor.register(__webpack_require__(292));refractor.register(__webpack_require__(293));refractor.register(__webpack_require__(79));refractor.register(__webpack_require__(294));refractor.register(__webpack_require__(296));refractor.register(__webpack_require__(297));refractor.register(__webpack_require__(298));refractor.register(__webpack_require__(299));refractor.register(__webpack_require__(176));refractor.register(__webpack_require__(300));refractor.register(__webpack_require__(132));refractor.register(__webpack_require__(301));refractor.register(__webpack_require__(302));refractor.register(__webpack_require__(304));refractor.register(__webpack_require__(305));refractor.register(__webpack_require__(306));refractor.register(__webpack_require__(307));refractor.register(__webpack_require__(308));refractor.register(__webpack_require__(309));refractor.register(__webpack_require__(310));refractor.register(__webpack_require__(311));refractor.register(__webpack_require__(312));refractor.register(__webpack_require__(313));refractor.register(__webpack_require__(314));refractor.register(__webpack_require__(315));refractor.register(__webpack_require__(316));refractor.register(__webpack_require__(317));refractor.register(__webpack_require__(318));refractor.register(__webpack_require__(319));refractor.register(__webpack_require__(320));refractor.register(__webpack_require__(321));refractor.register(__webpack_require__(322));refractor.register(__webpack_require__(323));refractor.register(__webpack_require__(324));refractor.register(__webpack_require__(325));refractor.register(__webpack_require__(326));refractor.register(__webpack_require__(327));refractor.register(__webpack_require__(328));refractor.register(__webpack_require__(329));refractor.register(__webpack_require__(330));refractor.register(__webpack_require__(331));refractor.register(__webpack_require__(332));refractor.register(__webpack_require__(333));refractor.register(__webpack_require__(334));refractor.register(__webpack_require__(335));refractor.register(__webpack_require__(336));refractor.register(__webpack_require__(337));refractor.register(__webpack_require__(338));refractor.register(__webpack_require__(339));refractor.register(__webpack_require__(340));refractor.register(__webpack_require__(180));refractor.register(__webpack_require__(341));refractor.register(__webpack_require__(342));refractor.register(__webpack_require__(343));refractor.register(__webpack_require__(344));refractor.register(__webpack_require__(345));refractor.register(__webpack_require__(346));refractor.register(__webpack_require__(347));refractor.register(__webpack_require__(348));refractor.register(__webpack_require__(349));refractor.register(__webpack_require__(350));refractor.register(__webpack_require__(351));refractor.register(__webpack_require__(352));refractor.register(__webpack_require__(353));refractor.register(__webpack_require__(354));refractor.register(__webpack_require__(133));refractor.register(__webpack_require__(355));refractor.register(__webpack_require__(116));refractor.register(__webpack_require__(357));refractor.register(__webpack_require__(358));refractor.register(__webpack_require__(359));refractor.register(__webpack_require__(360));refractor.register(__webpack_require__(361));refractor.register(__webpack_require__(362));refractor.register(__webpack_require__(135));refractor.register(__webpack_require__(363));refractor.register(__webpack_require__(364));refractor.register(__webpack_require__(365));refractor.register(__webpack_require__(181));refractor.register(__webpack_require__(366));refractor.register(__webpack_require__(367));refractor.register(__webpack_require__(368));refractor.register(__webpack_require__(369));refractor.register(__webpack_require__(370));refractor.register(__webpack_require__(371));refractor.register(__webpack_require__(372));refractor.register(__webpack_require__(373));refractor.register(__webpack_require__(374));refractor.register(__webpack_require__(375));refractor.register(__webpack_require__(376));refractor.register(__webpack_require__(377));refractor.register(__webpack_require__(179));refractor.register(__webpack_require__(378));refractor.register(__webpack_require__(379));refractor.register(__webpack_require__(63));refractor.register(__webpack_require__(381));refractor.register(__webpack_require__(382));refractor.register(__webpack_require__(383));refractor.register(__webpack_require__(384));refractor.register(__webpack_require__(385));refractor.register(__webpack_require__(386));refractor.register(__webpack_require__(387));refractor.register(__webpack_require__(388));refractor.register(__webpack_require__(389));refractor.register(__webpack_require__(390));refractor.register(__webpack_require__(391));refractor.register(__webpack_require__(392));refractor.register(__webpack_require__(393));refractor.register(__webpack_require__(394));refractor.register(__webpack_require__(395));refractor.register(__webpack_require__(396));refractor.register(__webpack_require__(397));refractor.register(__webpack_require__(398));refractor.register(__webpack_require__(399));refractor.register(__webpack_require__(400));refractor.register(__webpack_require__(401));refractor.register(__webpack_require__(402));refractor.register(__webpack_require__(403));refractor.register(__webpack_require__(404));refractor.register(__webpack_require__(405));refractor.register(__webpack_require__(406));refractor.register(__webpack_require__(407));refractor.register(__webpack_require__(408));refractor.register(__webpack_require__(117));refractor.register(__webpack_require__(409));refractor.register(__webpack_require__(410));refractor.register(__webpack_require__(411));refractor.register(__webpack_require__(412));refractor.register(__webpack_require__(413));refractor.register(__webpack_require__(414));refractor.register(__webpack_require__(415));refractor.register(__webpack_require__(416));refractor.register(__webpack_require__(417));refractor.register(__webpack_require__(418));refractor.register(__webpack_require__(419));refractor.register(__webpack_require__(420));refractor.register(__webpack_require__(421));refractor.register(__webpack_require__(422));refractor.register(__webpack_require__(423));refractor.register(__webpack_require__(424));refractor.register(__webpack_require__(425));refractor.register(__webpack_require__(426));refractor.register(__webpack_require__(427));refractor.register(__webpack_require__(428));refractor.register(__webpack_require__(429));refractor.register(__webpack_require__(430));refractor.register(__webpack_require__(431));refractor.register(__webpack_require__(432));refractor.register(__webpack_require__(433));refractor.register(__webpack_require__(434));refractor.register(__webpack_require__(115));refractor.register(__webpack_require__(435));refractor.register(__webpack_require__(436));refractor.register(__webpack_require__(437));refractor.register(__webpack_require__(438));refractor.register(__webpack_require__(136));refractor.register(__webpack_require__(439));refractor.register(__webpack_require__(440));refractor.register(__webpack_require__(441));refractor.register(__webpack_require__(442));refractor.register(__webpack_require__(443));refractor.register(__webpack_require__(444));refractor.register(__webpack_require__(445));refractor.register(__webpack_require__(446));refractor.register(__webpack_require__(447));refractor.register(__webpack_require__(448));refractor.register(__webpack_require__(449));refractor.register(__webpack_require__(450));refractor.register(__webpack_require__(182));refractor.register(__webpack_require__(451));refractor.register(__webpack_require__(452));refractor.register(__webpack_require__(453));refractor.register(__webpack_require__(454));refractor.register(__webpack_require__(137));refractor.register(__webpack_require__(455));refractor.register(__webpack_require__(456));refractor.register(__webpack_require__(457));refractor.register(__webpack_require__(458));refractor.register(__webpack_require__(459));refractor.register(__webpack_require__(460));refractor.register(__webpack_require__(461));refractor.register(__webpack_require__(183));refractor.register(__webpack_require__(462));refractor.register(__webpack_require__(134));refractor.register(__webpack_require__(463));refractor.register(__webpack_require__(464));refractor.register(__webpack_require__(465));refractor.register(__webpack_require__(184));refractor.register(__webpack_require__(466));refractor.register(__webpack_require__(467));refractor.register(__webpack_require__(468));refractor.register(__webpack_require__(469));refractor.register(__webpack_require__(470));refractor.register(__webpack_require__(471));refractor.register(__webpack_require__(472));refractor.register(__webpack_require__(473));refractor.register(__webpack_require__(474));refractor.register(__webpack_require__(475));refractor.register(__webpack_require__(476));refractor.register(__webpack_require__(477));refractor.register(__webpack_require__(185));refractor.register(__webpack_require__(478));refractor.register(__webpack_require__(479))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _default={hljs:{display:"block",overflowX:"auto",padding:"0.5em",background:"#fff",color:"black"},"xml .hljs-meta":{color:"#c0c0c0"},"hljs-comment":{color:"#007400"},"hljs-quote":{color:"#007400"},"hljs-tag":{color:"#aa0d91"},"hljs-attribute":{color:"#aa0d91"},"hljs-keyword":{color:"#aa0d91"},"hljs-selector-tag":{color:"#aa0d91"},"hljs-literal":{color:"#aa0d91"},"hljs-name":{color:"#aa0d91"},"hljs-variable":{color:"#3F6E74"},"hljs-template-variable":{color:"#3F6E74"},"hljs-code":{color:"#c41a16"},"hljs-string":{color:"#c41a16"},"hljs-meta-string":{color:"#c41a16"},"hljs-regexp":{color:"#0E0EFF"},"hljs-link":{color:"#0E0EFF"},"hljs-title":{color:"#1c00cf"},"hljs-symbol":{color:"#1c00cf"},"hljs-bullet":{color:"#1c00cf"},"hljs-number":{color:"#1c00cf"},"hljs-section":{color:"#643820"},"hljs-meta":{color:"#643820"},"hljs-class .hljs-title":{color:"#5c2699"},"hljs-type":{color:"#5c2699"},"hljs-built_in":{color:"#5c2699"},"hljs-builtin-name":{color:"#5c2699"},"hljs-params":{color:"#5c2699"},"hljs-attr":{color:"#836C28"},"hljs-subst":{color:"#000"},"hljs-formula":{backgroundColor:"#eee",fontStyle:"italic"},"hljs-addition":{backgroundColor:"#baeeba"},"hljs-deletion":{backgroundColor:"#ffc8bd"},"hljs-selector-id":{color:"#9b703f"},"hljs-selector-class":{color:"#9b703f"},"hljs-doctag":{fontWeight:"bold"},"hljs-strong":{fontWeight:"bold"},"hljs-emphasis":{fontStyle:"italic"}};exports.default=_default},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_RESULT__;!function(){var d3={version:"3.5.17"};var d3_arraySlice=[].slice,d3_array=function(list){return d3_arraySlice.call(list)};var d3_document=this.document;function d3_documentElement(node){return node&&(node.ownerDocument||node.document||node).documentElement}function d3_window(node){return node&&(node.ownerDocument&&node.ownerDocument.defaultView||node.document&&node||node.defaultView)}if(d3_document){try{d3_array(d3_document.documentElement.childNodes)[0].nodeType}catch(e){d3_array=function(list){var i=list.length,array=new Array(i);while(i--)array[i]=list[i];return array}}}if(!Date.now)Date.now=function(){return+new Date};if(d3_document){try{d3_document.createElement("DIV").style.setProperty("opacity",0,"")}catch(error){var d3_element_prototype=this.Element.prototype,d3_element_setAttribute=d3_element_prototype.setAttribute,d3_element_setAttributeNS=d3_element_prototype.setAttributeNS,d3_style_prototype=this.CSSStyleDeclaration.prototype,d3_style_setProperty=d3_style_prototype.setProperty;d3_element_prototype.setAttribute=function(name,value){d3_element_setAttribute.call(this,name,value+"")};d3_element_prototype.setAttributeNS=function(space,local,value){d3_element_setAttributeNS.call(this,space,local,value+"")};d3_style_prototype.setProperty=function(name,value,priority){d3_style_setProperty.call(this,name,value+"",priority)}}}d3.ascending=d3_ascending;function d3_ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}d3.descending=function(a,b){return b<a?-1:b>a?1:b>=a?0:NaN};d3.min=function(array,f){var i=-1,n=array.length,a,b;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=b;break}while(++i<n)if((b=array[i])!=null&&a>b)a=b}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=b;break}while(++i<n)if((b=f.call(array,array[i],i))!=null&&a>b)a=b}return a};d3.max=function(array,f){var i=-1,n=array.length,a,b;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=b;break}while(++i<n)if((b=array[i])!=null&&b>a)a=b}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=b;break}while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>a)a=b}return a};d3.extent=function(array,f){var i=-1,n=array.length,a,b,c;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=c=b;break}while(++i<n)if((b=array[i])!=null){if(a>b)a=b;if(c<b)c=b}}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=c=b;break}while(++i<n)if((b=f.call(array,array[i],i))!=null){if(a>b)a=b;if(c<b)c=b}}return[a,c]};function d3_number(x){return x===null?NaN:+x}function d3_numeric(x){return!isNaN(x)}d3.sum=function(array,f){var s=0,n=array.length,a,i=-1;if(arguments.length===1){while(++i<n)if(d3_numeric(a=+array[i]))s+=a}else{while(++i<n)if(d3_numeric(a=+f.call(array,array[i],i)))s+=a}return s};d3.mean=function(array,f){var s=0,n=array.length,a,i=-1,j=n;if(arguments.length===1){while(++i<n)if(d3_numeric(a=d3_number(array[i])))s+=a;else--j}else{while(++i<n)if(d3_numeric(a=d3_number(f.call(array,array[i],i))))s+=a;else--j}if(j)return s/j};d3.quantile=function(values,p){var H=(values.length-1)*p+1,h=Math.floor(H),v=+values[h-1],e=H-h;return e?v+e*(values[h]-v):v};d3.median=function(array,f){var numbers=[],n=array.length,a,i=-1;if(arguments.length===1){while(++i<n)if(d3_numeric(a=d3_number(array[i])))numbers.push(a)}else{while(++i<n)if(d3_numeric(a=d3_number(f.call(array,array[i],i))))numbers.push(a)}if(numbers.length)return d3.quantile(numbers.sort(d3_ascending),.5)};d3.variance=function(array,f){var n=array.length,m=0,a,d,s=0,i=-1,j=0;if(arguments.length===1){while(++i<n){if(d3_numeric(a=d3_number(array[i]))){d=a-m;m+=d/++j;s+=d*(a-m)}}}else{while(++i<n){if(d3_numeric(a=d3_number(f.call(array,array[i],i)))){d=a-m;m+=d/++j;s+=d*(a-m)}}}if(j>1)return s/(j-1)};d3.deviation=function(){var v=d3.variance.apply(this,arguments);return v?Math.sqrt(v):v};function d3_bisector(compare){return{left:function(a,x,lo,hi){if(arguments.length<3)lo=0;if(arguments.length<4)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid}return lo},right:function(a,x,lo,hi){if(arguments.length<3)lo=0;if(arguments.length<4)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1}return lo}}}var d3_bisect=d3_bisector(d3_ascending);d3.bisectLeft=d3_bisect.left;d3.bisect=d3.bisectRight=d3_bisect.right;d3.bisector=function(f){return d3_bisector(f.length===1?function(d,x){return d3_ascending(f(d),x)}:f)};d3.shuffle=function(array,i0,i1){if((m=arguments.length)<3){i1=array.length;if(m<2)i0=0}var m=i1-i0,t,i;while(m){i=Math.random()*m--|0;t=array[m+i0],array[m+i0]=array[i+i0],array[i+i0]=t}return array};d3.permute=function(array,indexes){var i=indexes.length,permutes=new Array(i);while(i--)permutes[i]=array[indexes[i]];return permutes};d3.pairs=function(array){var i=0,n=array.length-1,p0,p1=array[0],pairs=new Array(n<0?0:n);while(i<n)pairs[i]=[p0=p1,p1=array[++i]];return pairs};d3.transpose=function(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=d3.min(matrix,d3_transposeLength),transpose=new Array(m);++i<m;){for(var j=-1,n,row=transpose[i]=new Array(n);++j<n;){row[j]=matrix[j][i]}}return transpose};function d3_transposeLength(d){return d.length}d3.zip=function(){return d3.transpose(arguments)};d3.keys=function(map){var keys=[];for(var key in map)keys.push(key);return keys};d3.values=function(map){var values=[];for(var key in map)values.push(map[key]);return values};d3.entries=function(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries};d3.merge=function(arrays){var n=arrays.length,m,i=-1,j=0,merged,array;while(++i<n)j+=arrays[i].length;merged=new Array(j);while(--n>=0){array=arrays[n];m=array.length;while(--m>=0){merged[--j]=array[m]}}return merged};var abs=Math.abs;d3.range=function(start,stop,step){if(arguments.length<3){step=1;if(arguments.length<2){stop=start;start=0}}if((stop-start)/step===Infinity)throw new Error("infinite range");var range=[],k=d3_range_integerScale(abs(step)),i=-1,j;start*=k,stop*=k,step*=k;if(step<0)while((j=start+step*++i)>stop)range.push(j/k);else while((j=start+step*++i)<stop)range.push(j/k);return range};function d3_range_integerScale(x){var k=1;while(x*k%1)k*=10;return k}function d3_class(ctor,properties){for(var key in properties){Object.defineProperty(ctor.prototype,key,{value:properties[key],enumerable:false})}}d3.map=function(object,f){var map=new d3_Map;if(object instanceof d3_Map){object.forEach((function(key,value){map.set(key,value)}))}else if(Array.isArray(object)){var i=-1,n=object.length,o;if(arguments.length===1)while(++i<n)map.set(i,object[i]);else while(++i<n)map.set(f.call(object,o=object[i],i),o)}else{for(var key in object)map.set(key,object[key])}return map};function d3_Map(){this._=Object.create(null)}var d3_map_proto="__proto__",d3_map_zero="\0";d3_class(d3_Map,{has:d3_map_has,get:function(key){return this._[d3_map_escape(key)]},set:function(key,value){return this._[d3_map_escape(key)]=value},remove:d3_map_remove,keys:d3_map_keys,values:function(){var values=[];for(var key in this._)values.push(this._[key]);return values},entries:function(){var entries=[];for(var key in this._)entries.push({key:d3_map_unescape(key),value:this._[key]});return entries},size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key),this._[key])}});function d3_map_escape(key){return(key+="")===d3_map_proto||key[0]===d3_map_zero?d3_map_zero+key:key}function d3_map_unescape(key){return(key+="")[0]===d3_map_zero?key.slice(1):key}function d3_map_has(key){return d3_map_escape(key)in this._}function d3_map_remove(key){return(key=d3_map_escape(key))in this._&&delete this._[key]}function d3_map_keys(){var keys=[];for(var key in this._)keys.push(d3_map_unescape(key));return keys}function d3_map_size(){var size=0;for(var key in this._)++size;return size}function d3_map_empty(){for(var key in this._)return false;return true}d3.nest=function(){var nest={},keys=[],sortKeys=[],sortValues,rollup;function map(mapType,array,depth){if(depth>=keys.length)return rollup?rollup.call(nest,array):sortValues?array.sort(sortValues):array;var i=-1,n=array.length,key=keys[depth++],keyValue,object,setter,valuesByKey=new d3_Map,values;while(++i<n){if(values=valuesByKey.get(keyValue=key(object=array[i]))){values.push(object)}else{valuesByKey.set(keyValue,[object])}}if(mapType){object=mapType();setter=function(keyValue,values){object.set(keyValue,map(mapType,values,depth))}}else{object={};setter=function(keyValue,values){object[keyValue]=map(mapType,values,depth)}}valuesByKey.forEach(setter);return object}function entries(map,depth){if(depth>=keys.length)return map;var array=[],sortKey=sortKeys[depth++];map.forEach((function(key,keyMap){array.push({key:key,values:entries(keyMap,depth)})}));return sortKey?array.sort((function(a,b){return sortKey(a.key,b.key)})):array}nest.map=function(array,mapType){return map(mapType,array,0)};nest.entries=function(array){return entries(map(d3.map,array,0),0)};nest.key=function(d){keys.push(d);return nest};nest.sortKeys=function(order){sortKeys[keys.length-1]=order;return nest};nest.sortValues=function(order){sortValues=order;return nest};nest.rollup=function(f){rollup=f;return nest};return nest};d3.set=function(array){var set=new d3_Set;if(array)for(var i=0,n=array.length;i<n;++i)set.add(array[i]);return set};function d3_Set(){this._=Object.create(null)}d3_class(d3_Set,{has:d3_map_has,add:function(key){this._[d3_map_escape(key+="")]=true;return key},remove:d3_map_remove,values:d3_map_keys,size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key))}});d3.behavior={};function d3_identity(d){return d}d3.rebind=function(target,source){var i=1,n=arguments.length,method;while(++i<n)target[method=arguments[i]]=d3_rebind(target,source,source[method]);return target};function d3_rebind(target,source,method){return function(){var value=method.apply(source,arguments);return value===source?target:value}}function d3_vendorSymbol(object,name){if(name in object)return name;name=name.charAt(0).toUpperCase()+name.slice(1);for(var i=0,n=d3_vendorPrefixes.length;i<n;++i){var prefixName=d3_vendorPrefixes[i]+name;if(prefixName in object)return prefixName}}var d3_vendorPrefixes=["webkit","ms","moz","Moz","o","O"];function d3_noop(){}d3.dispatch=function(){var dispatch=new d3_dispatch,i=-1,n=arguments.length;while(++i<n)dispatch[arguments[i]]=d3_dispatch_event(dispatch);return dispatch};function d3_dispatch(){}d3_dispatch.prototype.on=function(type,listener){var i=type.indexOf("."),name="";if(i>=0){name=type.slice(i+1);type=type.slice(0,i)}if(type)return arguments.length<2?this[type].on(name):this[type].on(name,listener);if(arguments.length===2){if(listener==null)for(type in this){if(this.hasOwnProperty(type))this[type].on(name,null)}return this}};function d3_dispatch_event(dispatch){var listeners=[],listenerByName=new d3_Map;function event(){var z=listeners,i=-1,n=z.length,l;while(++i<n)if(l=z[i].on)l.apply(this,arguments);return dispatch}event.on=function(name,listener){var l=listenerByName.get(name),i;if(arguments.length<2)return l&&l.on;if(l){l.on=null;listeners=listeners.slice(0,i=listeners.indexOf(l)).concat(listeners.slice(i+1));listenerByName.remove(name)}if(listener)listeners.push(listenerByName.set(name,{on:listener}));return dispatch};return event}d3.event=null;function d3_eventPreventDefault(){d3.event.preventDefault()}function d3_eventSource(){var e=d3.event,s;while(s=e.sourceEvent)e=s;return e}function d3_eventDispatch(target){var dispatch=new d3_dispatch,i=0,n=arguments.length;while(++i<n)dispatch[arguments[i]]=d3_dispatch_event(dispatch);dispatch.of=function(thiz,argumentz){return function(e1){try{var e0=e1.sourceEvent=d3.event;e1.target=target;d3.event=e1;dispatch[e1.type].apply(thiz,argumentz)}finally{d3.event=e0}}};return dispatch}d3.requote=function(s){return s.replace(d3_requote_re,"\\$&")};var d3_requote_re=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;var d3_subclass={}.__proto__?function(object,prototype){object.__proto__=prototype}:function(object,prototype){for(var property in prototype)object[property]=prototype[property]};function d3_selection(groups){d3_subclass(groups,d3_selectionPrototype);return groups}var d3_select=function(s,n){return n.querySelector(s)},d3_selectAll=function(s,n){return n.querySelectorAll(s)},d3_selectMatches=function(n,s){var d3_selectMatcher=n.matches||n[d3_vendorSymbol(n,"matchesSelector")];d3_selectMatches=function(n,s){return d3_selectMatcher.call(n,s)};return d3_selectMatches(n,s)};if(typeof Sizzle==="function"){d3_select=function(s,n){return Sizzle(s,n)[0]||null};d3_selectAll=Sizzle;d3_selectMatches=Sizzle.matchesSelector}d3.selection=function(){return d3.select(d3_document.documentElement)};var d3_selectionPrototype=d3.selection.prototype=[];d3_selectionPrototype.select=function(selector){var subgroups=[],subgroup,subnode,group,node;selector=d3_selection_selector(selector);for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);subgroup.parentNode=(group=this[j]).parentNode;for(var i=-1,n=group.length;++i<n;){if(node=group[i]){subgroup.push(subnode=selector.call(node,node.__data__,i,j));if(subnode&&"__data__"in node)subnode.__data__=node.__data__}else{subgroup.push(null)}}}return d3_selection(subgroups)};function d3_selection_selector(selector){return typeof selector==="function"?selector:function(){return d3_select(selector,this)}}d3_selectionPrototype.selectAll=function(selector){var subgroups=[],subgroup,node;selector=d3_selection_selectorAll(selector);for(var j=-1,m=this.length;++j<m;){for(var group=this[j],i=-1,n=group.length;++i<n;){if(node=group[i]){subgroups.push(subgroup=d3_array(selector.call(node,node.__data__,i,j)));subgroup.parentNode=node}}}return d3_selection(subgroups)};function d3_selection_selectorAll(selector){return typeof selector==="function"?selector:function(){return d3_selectAll(selector,this)}}var d3_nsXhtml="http://www.w3.org/1999/xhtml";var d3_nsPrefix={svg:"http://www.w3.org/2000/svg",xhtml:d3_nsXhtml,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};d3.ns={prefix:d3_nsPrefix,qualify:function(name){var i=name.indexOf(":"),prefix=name;if(i>=0&&(prefix=name.slice(0,i))!=="xmlns")name=name.slice(i+1);return d3_nsPrefix.hasOwnProperty(prefix)?{space:d3_nsPrefix[prefix],local:name}:name}};d3_selectionPrototype.attr=function(name,value){if(arguments.length<2){if(typeof name==="string"){var node=this.node();name=d3.ns.qualify(name);return name.local?node.getAttributeNS(name.space,name.local):node.getAttribute(name)}for(value in name)this.each(d3_selection_attr(value,name[value]));return this}return this.each(d3_selection_attr(name,value))};function d3_selection_attr(name,value){name=d3.ns.qualify(name);function attrNull(){this.removeAttribute(name)}function attrNullNS(){this.removeAttributeNS(name.space,name.local)}function attrConstant(){this.setAttribute(name,value)}function attrConstantNS(){this.setAttributeNS(name.space,name.local,value)}function attrFunction(){var x=value.apply(this,arguments);if(x==null)this.removeAttribute(name);else this.setAttribute(name,x)}function attrFunctionNS(){var x=value.apply(this,arguments);if(x==null)this.removeAttributeNS(name.space,name.local);else this.setAttributeNS(name.space,name.local,x)}return value==null?name.local?attrNullNS:attrNull:typeof value==="function"?name.local?attrFunctionNS:attrFunction:name.local?attrConstantNS:attrConstant}function d3_collapse(s){return s.trim().replace(/\s+/g," ")}d3_selectionPrototype.classed=function(name,value){if(arguments.length<2){if(typeof name==="string"){var node=this.node(),n=(name=d3_selection_classes(name)).length,i=-1;if(value=node.classList){while(++i<n)if(!value.contains(name[i]))return false}else{value=node.getAttribute("class");while(++i<n)if(!d3_selection_classedRe(name[i]).test(value))return false}return true}for(value in name)this.each(d3_selection_classed(value,name[value]));return this}return this.each(d3_selection_classed(name,value))};function d3_selection_classedRe(name){return new RegExp("(?:^|\\s+)"+d3.requote(name)+"(?:\\s+|$)","g")}function d3_selection_classes(name){return(name+"").trim().split(/^|\s+/)}function d3_selection_classed(name,value){name=d3_selection_classes(name).map(d3_selection_classedName);var n=name.length;function classedConstant(){var i=-1;while(++i<n)name[i](this,value)}function classedFunction(){var i=-1,x=value.apply(this,arguments);while(++i<n)name[i](this,x)}return typeof value==="function"?classedFunction:classedConstant}function d3_selection_classedName(name){var re=d3_selection_classedRe(name);return function(node,value){if(c=node.classList)return value?c.add(name):c.remove(name);var c=node.getAttribute("class")||"";if(value){re.lastIndex=0;if(!re.test(c))node.setAttribute("class",d3_collapse(c+" "+name))}else{node.setAttribute("class",d3_collapse(c.replace(re," ")))}}}d3_selectionPrototype.style=function(name,value,priority){var n=arguments.length;if(n<3){if(typeof name!=="string"){if(n<2)value="";for(priority in name)this.each(d3_selection_style(priority,name[priority],value));return this}if(n<2){var node=this.node();return d3_window(node).getComputedStyle(node,null).getPropertyValue(name)}priority=""}return this.each(d3_selection_style(name,value,priority))};function d3_selection_style(name,value,priority){function styleNull(){this.style.removeProperty(name)}function styleConstant(){this.style.setProperty(name,value,priority)}function styleFunction(){var x=value.apply(this,arguments);if(x==null)this.style.removeProperty(name);else this.style.setProperty(name,x,priority)}return value==null?styleNull:typeof value==="function"?styleFunction:styleConstant}d3_selectionPrototype.property=function(name,value){if(arguments.length<2){if(typeof name==="string")return this.node()[name];for(value in name)this.each(d3_selection_property(value,name[value]));return this}return this.each(d3_selection_property(name,value))};function d3_selection_property(name,value){function propertyNull(){delete this[name]}function propertyConstant(){this[name]=value}function propertyFunction(){var x=value.apply(this,arguments);if(x==null)delete this[name];else this[name]=x}return value==null?propertyNull:typeof value==="function"?propertyFunction:propertyConstant}d3_selectionPrototype.text=function(value){return arguments.length?this.each(typeof value==="function"?function(){var v=value.apply(this,arguments);this.textContent=v==null?"":v}:value==null?function(){this.textContent=""}:function(){this.textContent=value}):this.node().textContent};d3_selectionPrototype.html=function(value){return arguments.length?this.each(typeof value==="function"?function(){var v=value.apply(this,arguments);this.innerHTML=v==null?"":v}:value==null?function(){this.innerHTML=""}:function(){this.innerHTML=value}):this.node().innerHTML};d3_selectionPrototype.append=function(name){name=d3_selection_creator(name);return this.select((function(){return this.appendChild(name.apply(this,arguments))}))};function d3_selection_creator(name){function create(){var document=this.ownerDocument,namespace=this.namespaceURI;return namespace===d3_nsXhtml&&document.documentElement.namespaceURI===d3_nsXhtml?document.createElement(name):document.createElementNS(namespace,name)}function createNS(){return this.ownerDocument.createElementNS(name.space,name.local)}return typeof name==="function"?name:(name=d3.ns.qualify(name)).local?createNS:create}d3_selectionPrototype.insert=function(name,before){name=d3_selection_creator(name);before=d3_selection_selector(before);return this.select((function(){return this.insertBefore(name.apply(this,arguments),before.apply(this,arguments)||null)}))};d3_selectionPrototype.remove=function(){return this.each(d3_selectionRemove)};function d3_selectionRemove(){var parent=this.parentNode;if(parent)parent.removeChild(this)}d3_selectionPrototype.data=function(value,key){var i=-1,n=this.length,group,node;if(!arguments.length){value=new Array(n=(group=this[0]).length);while(++i<n){if(node=group[i]){value[i]=node.__data__}}return value}function bind(group,groupData){var i,n=group.length,m=groupData.length,n0=Math.min(n,m),updateNodes=new Array(m),enterNodes=new Array(m),exitNodes=new Array(n),node,nodeData;if(key){var nodeByKeyValue=new d3_Map,keyValues=new Array(n),keyValue;for(i=-1;++i<n;){if(node=group[i]){if(nodeByKeyValue.has(keyValue=key.call(node,node.__data__,i))){exitNodes[i]=node}else{nodeByKeyValue.set(keyValue,node)}keyValues[i]=keyValue}}for(i=-1;++i<m;){if(!(node=nodeByKeyValue.get(keyValue=key.call(groupData,nodeData=groupData[i],i)))){enterNodes[i]=d3_selection_dataNode(nodeData)}else if(node!==true){updateNodes[i]=node;node.__data__=nodeData}nodeByKeyValue.set(keyValue,true)}for(i=-1;++i<n;){if(i in keyValues&&nodeByKeyValue.get(keyValues[i])!==true){exitNodes[i]=group[i]}}}else{for(i=-1;++i<n0;){node=group[i];nodeData=groupData[i];if(node){node.__data__=nodeData;updateNodes[i]=node}else{enterNodes[i]=d3_selection_dataNode(nodeData)}}for(;i<m;++i){enterNodes[i]=d3_selection_dataNode(groupData[i])}for(;i<n;++i){exitNodes[i]=group[i]}}enterNodes.update=updateNodes;enterNodes.parentNode=updateNodes.parentNode=exitNodes.parentNode=group.parentNode;enter.push(enterNodes);update.push(updateNodes);exit.push(exitNodes)}var enter=d3_selection_enter([]),update=d3_selection([]),exit=d3_selection([]);if(typeof value==="function"){while(++i<n){bind(group=this[i],value.call(group,group.parentNode.__data__,i))}}else{while(++i<n){bind(group=this[i],value)}}update.enter=function(){return enter};update.exit=function(){return exit};return update};function d3_selection_dataNode(data){return{__data__:data}}d3_selectionPrototype.datum=function(value){return arguments.length?this.property("__data__",value):this.property("__data__")};d3_selectionPrototype.filter=function(filter){var subgroups=[],subgroup,group,node;if(typeof filter!=="function")filter=d3_selection_filter(filter);for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);subgroup.parentNode=(group=this[j]).parentNode;for(var i=0,n=group.length;i<n;i++){if((node=group[i])&&filter.call(node,node.__data__,i,j)){subgroup.push(node)}}}return d3_selection(subgroups)};function d3_selection_filter(selector){return function(){return d3_selectMatches(this,selector)}}d3_selectionPrototype.order=function(){for(var j=-1,m=this.length;++j<m;){for(var group=this[j],i=group.length-1,next=group[i],node;--i>=0;){if(node=group[i]){if(next&&next!==node.nextSibling)next.parentNode.insertBefore(node,next);next=node}}}return this};d3_selectionPrototype.sort=function(comparator){comparator=d3_selection_sortComparator.apply(this,arguments);for(var j=-1,m=this.length;++j<m;)this[j].sort(comparator);return this.order()};function d3_selection_sortComparator(comparator){if(!arguments.length)comparator=d3_ascending;return function(a,b){return a&&b?comparator(a.__data__,b.__data__):!a-!b}}d3_selectionPrototype.each=function(callback){return d3_selection_each(this,(function(node,i,j){callback.call(node,node.__data__,i,j)}))};function d3_selection_each(groups,callback){for(var j=0,m=groups.length;j<m;j++){for(var group=groups[j],i=0,n=group.length,node;i<n;i++){if(node=group[i])callback(node,i,j)}}return groups}d3_selectionPrototype.call=function(callback){var args=d3_array(arguments);callback.apply(args[0]=this,args);return this};d3_selectionPrototype.empty=function(){return!this.node()};d3_selectionPrototype.node=function(){for(var j=0,m=this.length;j<m;j++){for(var group=this[j],i=0,n=group.length;i<n;i++){var node=group[i];if(node)return node}}return null};d3_selectionPrototype.size=function(){var n=0;d3_selection_each(this,(function(){++n}));return n};function d3_selection_enter(selection){d3_subclass(selection,d3_selection_enterPrototype);return selection}var d3_selection_enterPrototype=[];d3.selection.enter=d3_selection_enter;d3.selection.enter.prototype=d3_selection_enterPrototype;d3_selection_enterPrototype.append=d3_selectionPrototype.append;d3_selection_enterPrototype.empty=d3_selectionPrototype.empty;d3_selection_enterPrototype.node=d3_selectionPrototype.node;d3_selection_enterPrototype.call=d3_selectionPrototype.call;d3_selection_enterPrototype.size=d3_selectionPrototype.size;d3_selection_enterPrototype.select=function(selector){var subgroups=[],subgroup,subnode,upgroup,group,node;for(var j=-1,m=this.length;++j<m;){upgroup=(group=this[j]).update;subgroups.push(subgroup=[]);subgroup.parentNode=group.parentNode;for(var i=-1,n=group.length;++i<n;){if(node=group[i]){subgroup.push(upgroup[i]=subnode=selector.call(group.parentNode,node.__data__,i,j));subnode.__data__=node.__data__}else{subgroup.push(null)}}}return d3_selection(subgroups)};d3_selection_enterPrototype.insert=function(name,before){if(arguments.length<2)before=d3_selection_enterInsertBefore(this);return d3_selectionPrototype.insert.call(this,name,before)};function d3_selection_enterInsertBefore(enter){var i0,j0;return function(d,i,j){var group=enter[j].update,n=group.length,node;if(j!=j0)j0=j,i0=0;if(i>=i0)i0=i+1;while(!(node=group[i0])&&++i0<n);return node}}d3.select=function(node){var group;if(typeof node==="string"){group=[d3_select(node,d3_document)];group.parentNode=d3_document.documentElement}else{group=[node];group.parentNode=d3_documentElement(node)}return d3_selection([group])};d3.selectAll=function(nodes){var group;if(typeof nodes==="string"){group=d3_array(d3_selectAll(nodes,d3_document));group.parentNode=d3_document.documentElement}else{group=d3_array(nodes);group.parentNode=null}return d3_selection([group])};d3_selectionPrototype.on=function(type,listener,capture){var n=arguments.length;if(n<3){if(typeof type!=="string"){if(n<2)listener=false;for(capture in type)this.each(d3_selection_on(capture,type[capture],listener));return this}if(n<2)return(n=this.node()["__on"+type])&&n._;capture=false}return this.each(d3_selection_on(type,listener,capture))};function d3_selection_on(type,listener,capture){var name="__on"+type,i=type.indexOf("."),wrap=d3_selection_onListener;if(i>0)type=type.slice(0,i);var filter=d3_selection_onFilters.get(type);if(filter)type=filter,wrap=d3_selection_onFilter;function onRemove(){var l=this[name];if(l){this.removeEventListener(type,l,l.$);delete this[name]}}function onAdd(){var l=wrap(listener,d3_array(arguments));onRemove.call(this);this.addEventListener(type,this[name]=l,l.$=capture);l._=listener}function removeAll(){var re=new RegExp("^__on([^.]+)"+d3.requote(type)+"$"),match;for(var name in this){if(match=name.match(re)){var l=this[name];this.removeEventListener(match[1],l,l.$);delete this[name]}}}return i?listener?onAdd:onRemove:listener?d3_noop:removeAll}var d3_selection_onFilters=d3.map({mouseenter:"mouseover",mouseleave:"mouseout"});if(d3_document){d3_selection_onFilters.forEach((function(k){if("on"+k in d3_document)d3_selection_onFilters.remove(k)}))}function d3_selection_onListener(listener,argumentz){return function(e){var o=d3.event;d3.event=e;argumentz[0]=this.__data__;try{listener.apply(this,argumentz)}finally{d3.event=o}}}function d3_selection_onFilter(listener,argumentz){var l=d3_selection_onListener(listener,argumentz);return function(e){var target=this,related=e.relatedTarget;if(!related||related!==target&&!(related.compareDocumentPosition(target)&8)){l.call(target,e)}}}var d3_event_dragSelect,d3_event_dragId=0;function d3_event_dragSuppress(node){var name=".dragsuppress-"+ ++d3_event_dragId,click="click"+name,w=d3.select(d3_window(node)).on("touchmove"+name,d3_eventPreventDefault).on("dragstart"+name,d3_eventPreventDefault).on("selectstart"+name,d3_eventPreventDefault);if(d3_event_dragSelect==null){d3_event_dragSelect="onselectstart"in node?false:d3_vendorSymbol(node.style,"userSelect")}if(d3_event_dragSelect){var style=d3_documentElement(node).style,select=style[d3_event_dragSelect];style[d3_event_dragSelect]="none"}return function(suppressClick){w.on(name,null);if(d3_event_dragSelect)style[d3_event_dragSelect]=select;if(suppressClick){var off=function(){w.on(click,null)};w.on(click,(function(){d3_eventPreventDefault();off()}),true);setTimeout(off,0)}}}d3.mouse=function(container){return d3_mousePoint(container,d3_eventSource())};var d3_mouse_bug44083=this.navigator&&/WebKit/.test(this.navigator.userAgent)?-1:0;function d3_mousePoint(container,e){if(e.changedTouches)e=e.changedTouches[0];var svg=container.ownerSVGElement||container;if(svg.createSVGPoint){var point=svg.createSVGPoint();if(d3_mouse_bug44083<0){var window=d3_window(container);if(window.scrollX||window.scrollY){svg=d3.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important");var ctm=svg[0][0].getScreenCTM();d3_mouse_bug44083=!(ctm.f||ctm.e);svg.remove()}}if(d3_mouse_bug44083)point.x=e.pageX,point.y=e.pageY;else point.x=e.clientX,point.y=e.clientY;point=point.matrixTransform(container.getScreenCTM().inverse());return[point.x,point.y]}var rect=container.getBoundingClientRect();return[e.clientX-rect.left-container.clientLeft,e.clientY-rect.top-container.clientTop]}d3.touch=function(container,touches,identifier){if(arguments.length<3)identifier=touches,touches=d3_eventSource().changedTouches;if(touches)for(var i=0,n=touches.length,touch;i<n;++i){if((touch=touches[i]).identifier===identifier){return d3_mousePoint(container,touch)}}};d3.behavior.drag=function(){var event=d3_eventDispatch(drag,"drag","dragstart","dragend"),origin=null,mousedown=dragstart(d3_noop,d3.mouse,d3_window,"mousemove","mouseup"),touchstart=dragstart(d3_behavior_dragTouchId,d3.touch,d3_identity,"touchmove","touchend");function drag(){this.on("mousedown.drag",mousedown).on("touchstart.drag",touchstart)}function dragstart(id,position,subject,move,end){return function(){var that=this,target=d3.event.target.correspondingElement||d3.event.target,parent=that.parentNode,dispatch=event.of(that,arguments),dragged=0,dragId=id(),dragName=".drag"+(dragId==null?"":"-"+dragId),dragOffset,dragSubject=d3.select(subject(target)).on(move+dragName,moved).on(end+dragName,ended),dragRestore=d3_event_dragSuppress(target),position0=position(parent,dragId);if(origin){dragOffset=origin.apply(that,arguments);dragOffset=[dragOffset.x-position0[0],dragOffset.y-position0[1]]}else{dragOffset=[0,0]}dispatch({type:"dragstart"});function moved(){var position1=position(parent,dragId),dx,dy;if(!position1)return;dx=position1[0]-position0[0];dy=position1[1]-position0[1];dragged|=dx|dy;position0=position1;dispatch({type:"drag",x:position1[0]+dragOffset[0],y:position1[1]+dragOffset[1],dx:dx,dy:dy})}function ended(){if(!position(parent,dragId))return;dragSubject.on(move+dragName,null).on(end+dragName,null);dragRestore(dragged);dispatch({type:"dragend"})}}}drag.origin=function(x){if(!arguments.length)return origin;origin=x;return drag};return d3.rebind(drag,event,"on")};function d3_behavior_dragTouchId(){return d3.event.changedTouches[0].identifier}d3.touches=function(container,touches){if(arguments.length<2)touches=d3_eventSource().touches;return touches?d3_array(touches).map((function(touch){var point=d3_mousePoint(container,touch);point.identifier=touch.identifier;return point})):[]};var ε=1e-6,ε2=ε*ε,π=Math.PI,τ=2*π,τε=τ-ε,halfπ=π/2,d3_radians=π/180,d3_degrees=180/π;function d3_sgn(x){return x>0?1:x<0?-1:0}function d3_cross2d(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(b[1]-a[1])*(c[0]-a[0])}function d3_acos(x){return x>1?0:x<-1?π:Math.acos(x)}function d3_asin(x){return x>1?halfπ:x<-1?-halfπ:Math.asin(x)}function d3_sinh(x){return((x=Math.exp(x))-1/x)/2}function d3_cosh(x){return((x=Math.exp(x))+1/x)/2}function d3_tanh(x){return((x=Math.exp(2*x))-1)/(x+1)}function d3_haversin(x){return(x=Math.sin(x/2))*x}var ρ=Math.SQRT2,ρ2=2,ρ4=4;d3.interpolateZoom=function(p0,p1){var ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy,i,S;if(d2<ε2){S=Math.log(w1/w0)/ρ;i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(ρ*t*S)]}}else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+ρ4*d2)/(2*w0*ρ2*d1),b1=(w1*w1-w0*w0-ρ4*d2)/(2*w1*ρ2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/ρ;i=function(t){var s=t*S,coshr0=d3_cosh(r0),u=w0/(ρ2*d1)*(coshr0*d3_tanh(ρ*s+r0)-d3_sinh(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/d3_cosh(ρ*s+r0)]}}i.duration=S*1e3;return i};d3.behavior.zoom=function(){var view={x:0,y:0,k:1},translate0,center0,center,size=[960,500],scaleExtent=d3_behavior_zoomInfinity,duration=250,zooming=0,mousedown="mousedown.zoom",mousemove="mousemove.zoom",mouseup="mouseup.zoom",mousewheelTimer,touchstart="touchstart.zoom",touchtime,event=d3_eventDispatch(zoom,"zoomstart","zoom","zoomend"),x0,x1,y0,y1;if(!d3_behavior_zoomWheel){d3_behavior_zoomWheel="onwheel"in d3_document?(d3_behavior_zoomDelta=function(){return-d3.event.deltaY*(d3.event.deltaMode?120:1)},"wheel"):"onmousewheel"in d3_document?(d3_behavior_zoomDelta=function(){return d3.event.wheelDelta},"mousewheel"):(d3_behavior_zoomDelta=function(){return-d3.event.detail},"MozMousePixelScroll")}function zoom(g){g.on(mousedown,mousedowned).on(d3_behavior_zoomWheel+".zoom",mousewheeled).on("dblclick.zoom",dblclicked).on(touchstart,touchstarted)}zoom.event=function(g){g.each((function(){var dispatch=event.of(this,arguments),view1=view;if(d3_transitionInheritId){d3.select(this).transition().each("start.zoom",(function(){view=this.__chart__||{x:0,y:0,k:1};zoomstarted(dispatch)})).tween("zoom:zoom",(function(){var dx=size[0],dy=size[1],cx=center0?center0[0]:dx/2,cy=center0?center0[1]:dy/2,i=d3.interpolateZoom([(cx-view.x)/view.k,(cy-view.y)/view.k,dx/view.k],[(cx-view1.x)/view1.k,(cy-view1.y)/view1.k,dx/view1.k]);return function(t){var l=i(t),k=dx/l[2];this.__chart__=view={x:cx-l[0]*k,y:cy-l[1]*k,k:k};zoomed(dispatch)}})).each("interrupt.zoom",(function(){zoomended(dispatch)})).each("end.zoom",(function(){zoomended(dispatch)}))}else{this.__chart__=view;zoomstarted(dispatch);zoomed(dispatch);zoomended(dispatch)}}))};zoom.translate=function(_){if(!arguments.length)return[view.x,view.y];view={x:+_[0],y:+_[1],k:view.k};rescale();return zoom};zoom.scale=function(_){if(!arguments.length)return view.k;view={x:view.x,y:view.y,k:null};scaleTo(+_);rescale();return zoom};zoom.scaleExtent=function(_){if(!arguments.length)return scaleExtent;scaleExtent=_==null?d3_behavior_zoomInfinity:[+_[0],+_[1]];return zoom};zoom.center=function(_){if(!arguments.length)return center;center=_&&[+_[0],+_[1]];return zoom};zoom.size=function(_){if(!arguments.length)return size;size=_&&[+_[0],+_[1]];return zoom};zoom.duration=function(_){if(!arguments.length)return duration;duration=+_;return zoom};zoom.x=function(z){if(!arguments.length)return x1;x1=z;x0=z.copy();view={x:0,y:0,k:1};return zoom};zoom.y=function(z){if(!arguments.length)return y1;y1=z;y0=z.copy();view={x:0,y:0,k:1};return zoom};function location(p){return[(p[0]-view.x)/view.k,(p[1]-view.y)/view.k]}function point(l){return[l[0]*view.k+view.x,l[1]*view.k+view.y]}function scaleTo(s){view.k=Math.max(scaleExtent[0],Math.min(scaleExtent[1],s))}function translateTo(p,l){l=point(l);view.x+=p[0]-l[0];view.y+=p[1]-l[1]}function zoomTo(that,p,l,k){that.__chart__={x:view.x,y:view.y,k:view.k};scaleTo(Math.pow(2,k));translateTo(center0=p,l);that=d3.select(that);if(duration>0)that=that.transition().duration(duration);that.call(zoom.event)}function rescale(){if(x1)x1.domain(x0.range().map((function(x){return(x-view.x)/view.k})).map(x0.invert));if(y1)y1.domain(y0.range().map((function(y){return(y-view.y)/view.k})).map(y0.invert))}function zoomstarted(dispatch){if(!zooming++)dispatch({type:"zoomstart"})}function zoomed(dispatch){rescale();dispatch({type:"zoom",scale:view.k,translate:[view.x,view.y]})}function zoomended(dispatch){if(!--zooming)dispatch({type:"zoomend"}),center0=null}function mousedowned(){var that=this,dispatch=event.of(that,arguments),dragged=0,subject=d3.select(d3_window(that)).on(mousemove,moved).on(mouseup,ended),location0=location(d3.mouse(that)),dragRestore=d3_event_dragSuppress(that);d3_selection_interrupt.call(that);zoomstarted(dispatch);function moved(){dragged=1;translateTo(d3.mouse(that),location0);zoomed(dispatch)}function ended(){subject.on(mousemove,null).on(mouseup,null);dragRestore(dragged);zoomended(dispatch)}}function touchstarted(){var that=this,dispatch=event.of(that,arguments),locations0={},distance0=0,scale0,zoomName=".zoom-"+d3.event.changedTouches[0].identifier,touchmove="touchmove"+zoomName,touchend="touchend"+zoomName,targets=[],subject=d3.select(that),dragRestore=d3_event_dragSuppress(that);started();zoomstarted(dispatch);subject.on(mousedown,null).on(touchstart,started);function relocate(){var touches=d3.touches(that);scale0=view.k;touches.forEach((function(t){if(t.identifier in locations0)locations0[t.identifier]=location(t)}));return touches}function started(){var target=d3.event.target;d3.select(target).on(touchmove,moved).on(touchend,ended);targets.push(target);var changed=d3.event.changedTouches;for(var i=0,n=changed.length;i<n;++i){locations0[changed[i].identifier]=null}var touches=relocate(),now=Date.now();if(touches.length===1){if(now-touchtime<500){var p=touches[0];zoomTo(that,p,locations0[p.identifier],Math.floor(Math.log(view.k)/Math.LN2)+1);d3_eventPreventDefault()}touchtime=now}else if(touches.length>1){var p=touches[0],q=touches[1],dx=p[0]-q[0],dy=p[1]-q[1];distance0=dx*dx+dy*dy}}function moved(){var touches=d3.touches(that),p0,l0,p1,l1;d3_selection_interrupt.call(that);for(var i=0,n=touches.length;i<n;++i,l1=null){p1=touches[i];if(l1=locations0[p1.identifier]){if(l0)break;p0=p1,l0=l1}}if(l1){var distance1=(distance1=p1[0]-p0[0])*distance1+(distance1=p1[1]-p0[1])*distance1,scale1=distance0&&Math.sqrt(distance1/distance0);p0=[(p0[0]+p1[0])/2,(p0[1]+p1[1])/2];l0=[(l0[0]+l1[0])/2,(l0[1]+l1[1])/2];scaleTo(scale1*scale0)}touchtime=null;translateTo(p0,l0);zoomed(dispatch)}function ended(){if(d3.event.touches.length){var changed=d3.event.changedTouches;for(var i=0,n=changed.length;i<n;++i){delete locations0[changed[i].identifier]}for(var identifier in locations0){return void relocate()}}d3.selectAll(targets).on(zoomName,null);subject.on(mousedown,mousedowned).on(touchstart,touchstarted);dragRestore();zoomended(dispatch)}}function mousewheeled(){var dispatch=event.of(this,arguments);if(mousewheelTimer)clearTimeout(mousewheelTimer);else d3_selection_interrupt.call(this),translate0=location(center0=center||d3.mouse(this)),zoomstarted(dispatch);mousewheelTimer=setTimeout((function(){mousewheelTimer=null;zoomended(dispatch)}),50);d3_eventPreventDefault();scaleTo(Math.pow(2,d3_behavior_zoomDelta()*.002)*view.k);translateTo(center0,translate0);zoomed(dispatch)}function dblclicked(){var p=d3.mouse(this),k=Math.log(view.k)/Math.LN2;zoomTo(this,p,location(p),d3.event.shiftKey?Math.ceil(k)-1:Math.floor(k)+1)}return d3.rebind(zoom,event,"on")};var d3_behavior_zoomInfinity=[0,Infinity],d3_behavior_zoomDelta,d3_behavior_zoomWheel;d3.color=d3_color;function d3_color(){}d3_color.prototype.toString=function(){return this.rgb()+""};d3.hsl=d3_hsl;function d3_hsl(h,s,l){return this instanceof d3_hsl?void(this.h=+h,this.s=+s,this.l=+l):arguments.length<2?h instanceof d3_hsl?new d3_hsl(h.h,h.s,h.l):d3_rgb_parse(""+h,d3_rgb_hsl,d3_hsl):new d3_hsl(h,s,l)}var d3_hslPrototype=d3_hsl.prototype=new d3_color;d3_hslPrototype.brighter=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_hsl(this.h,this.s,this.l/k)};d3_hslPrototype.darker=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_hsl(this.h,this.s,k*this.l)};d3_hslPrototype.rgb=function(){return d3_hsl_rgb(this.h,this.s,this.l)};function d3_hsl_rgb(h,s,l){var m1,m2;h=isNaN(h)?0:(h%=360)<0?h+360:h;s=isNaN(s)?0:s<0?0:s>1?1:s;l=l<0?0:l>1?1:l;m2=l<=.5?l*(1+s):l+s-l*s;m1=2*l-m2;function v(h){if(h>360)h-=360;else if(h<0)h+=360;if(h<60)return m1+(m2-m1)*h/60;if(h<180)return m2;if(h<240)return m1+(m2-m1)*(240-h)/60;return m1}function vv(h){return Math.round(v(h)*255)}return new d3_rgb(vv(h+120),vv(h),vv(h-120))}d3.hcl=d3_hcl;function d3_hcl(h,c,l){return this instanceof d3_hcl?void(this.h=+h,this.c=+c,this.l=+l):arguments.length<2?h instanceof d3_hcl?new d3_hcl(h.h,h.c,h.l):h instanceof d3_lab?d3_lab_hcl(h.l,h.a,h.b):d3_lab_hcl((h=d3_rgb_lab((h=d3.rgb(h)).r,h.g,h.b)).l,h.a,h.b):new d3_hcl(h,c,l)}var d3_hclPrototype=d3_hcl.prototype=new d3_color;d3_hclPrototype.brighter=function(k){return new d3_hcl(this.h,this.c,Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)))};d3_hclPrototype.darker=function(k){return new d3_hcl(this.h,this.c,Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)))};d3_hclPrototype.rgb=function(){return d3_hcl_lab(this.h,this.c,this.l).rgb()};function d3_hcl_lab(h,c,l){if(isNaN(h))h=0;if(isNaN(c))c=0;return new d3_lab(l,Math.cos(h*=d3_radians)*c,Math.sin(h)*c)}d3.lab=d3_lab;function d3_lab(l,a,b){return this instanceof d3_lab?void(this.l=+l,this.a=+a,this.b=+b):arguments.length<2?l instanceof d3_lab?new d3_lab(l.l,l.a,l.b):l instanceof d3_hcl?d3_hcl_lab(l.h,l.c,l.l):d3_rgb_lab((l=d3_rgb(l)).r,l.g,l.b):new d3_lab(l,a,b)}var d3_lab_K=18;var d3_lab_X=.95047,d3_lab_Y=1,d3_lab_Z=1.08883;var d3_labPrototype=d3_lab.prototype=new d3_color;d3_labPrototype.brighter=function(k){return new d3_lab(Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)),this.a,this.b)};d3_labPrototype.darker=function(k){return new d3_lab(Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)),this.a,this.b)};d3_labPrototype.rgb=function(){return d3_lab_rgb(this.l,this.a,this.b)};function d3_lab_rgb(l,a,b){var y=(l+16)/116,x=y+a/500,z=y-b/200;x=d3_lab_xyz(x)*d3_lab_X;y=d3_lab_xyz(y)*d3_lab_Y;z=d3_lab_xyz(z)*d3_lab_Z;return new d3_rgb(d3_xyz_rgb(3.2404542*x-1.5371385*y-.4985314*z),d3_xyz_rgb(-.969266*x+1.8760108*y+.041556*z),d3_xyz_rgb(.0556434*x-.2040259*y+1.0572252*z))}function d3_lab_hcl(l,a,b){return l>0?new d3_hcl(Math.atan2(b,a)*d3_degrees,Math.sqrt(a*a+b*b),l):new d3_hcl(NaN,NaN,l)}function d3_lab_xyz(x){return x>.206893034?x*x*x:(x-4/29)/7.787037}function d3_xyz_lab(x){return x>.008856?Math.pow(x,1/3):7.787037*x+4/29}function d3_xyz_rgb(r){return Math.round(255*(r<=.00304?12.92*r:1.055*Math.pow(r,1/2.4)-.055))}d3.rgb=d3_rgb;function d3_rgb(r,g,b){return this instanceof d3_rgb?void(this.r=~~r,this.g=~~g,this.b=~~b):arguments.length<2?r instanceof d3_rgb?new d3_rgb(r.r,r.g,r.b):d3_rgb_parse(""+r,d3_rgb,d3_hsl_rgb):new d3_rgb(r,g,b)}function d3_rgbNumber(value){return new d3_rgb(value>>16,value>>8&255,value&255)}function d3_rgbString(value){return d3_rgbNumber(value)+""}var d3_rgbPrototype=d3_rgb.prototype=new d3_color;d3_rgbPrototype.brighter=function(k){k=Math.pow(.7,arguments.length?k:1);var r=this.r,g=this.g,b=this.b,i=30;if(!r&&!g&&!b)return new d3_rgb(i,i,i);if(r&&r<i)r=i;if(g&&g<i)g=i;if(b&&b<i)b=i;return new d3_rgb(Math.min(255,r/k),Math.min(255,g/k),Math.min(255,b/k))};d3_rgbPrototype.darker=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_rgb(k*this.r,k*this.g,k*this.b)};d3_rgbPrototype.hsl=function(){return d3_rgb_hsl(this.r,this.g,this.b)};d3_rgbPrototype.toString=function(){return"#"+d3_rgb_hex(this.r)+d3_rgb_hex(this.g)+d3_rgb_hex(this.b)};function d3_rgb_hex(v){return v<16?"0"+Math.max(0,v).toString(16):Math.min(255,v).toString(16)}function d3_rgb_parse(format,rgb,hsl){var r=0,g=0,b=0,m1,m2,color;m1=/([a-z]+)\((.*)\)/.exec(format=format.toLowerCase());if(m1){m2=m1[2].split(",");switch(m1[1]){case"hsl":{return hsl(parseFloat(m2[0]),parseFloat(m2[1])/100,parseFloat(m2[2])/100)}case"rgb":{return rgb(d3_rgb_parseNumber(m2[0]),d3_rgb_parseNumber(m2[1]),d3_rgb_parseNumber(m2[2]))}}}if(color=d3_rgb_names.get(format)){return rgb(color.r,color.g,color.b)}if(format!=null&&format.charAt(0)==="#"&&!isNaN(color=parseInt(format.slice(1),16))){if(format.length===4){r=(color&3840)>>4;r=r>>4|r;g=color&240;g=g>>4|g;b=color&15;b=b<<4|b}else if(format.length===7){r=(color&16711680)>>16;g=(color&65280)>>8;b=color&255}}return rgb(r,g,b)}function d3_rgb_hsl(r,g,b){var min=Math.min(r/=255,g/=255,b/=255),max=Math.max(r,g,b),d=max-min,h,s,l=(max+min)/2;if(d){s=l<.5?d/(max+min):d/(2-max-min);if(r==max)h=(g-b)/d+(g<b?6:0);else if(g==max)h=(b-r)/d+2;else h=(r-g)/d+4;h*=60}else{h=NaN;s=l>0&&l<1?0:h}return new d3_hsl(h,s,l)}function d3_rgb_lab(r,g,b){r=d3_rgb_xyz(r);g=d3_rgb_xyz(g);b=d3_rgb_xyz(b);var x=d3_xyz_lab((.4124564*r+.3575761*g+.1804375*b)/d3_lab_X),y=d3_xyz_lab((.2126729*r+.7151522*g+.072175*b)/d3_lab_Y),z=d3_xyz_lab((.0193339*r+.119192*g+.9503041*b)/d3_lab_Z);return d3_lab(116*y-16,500*(x-y),200*(y-z))}function d3_rgb_xyz(r){return(r/=255)<=.04045?r/12.92:Math.pow((r+.055)/1.055,2.4)}function d3_rgb_parseNumber(c){var f=parseFloat(c);return c.charAt(c.length-1)==="%"?Math.round(f*2.55):f}var d3_rgb_names=d3.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});d3_rgb_names.forEach((function(key,value){d3_rgb_names.set(key,d3_rgbNumber(value))}));function d3_functor(v){return typeof v==="function"?v:function(){return v}}d3.functor=d3_functor;d3.xhr=d3_xhrType(d3_identity);function d3_xhrType(response){return function(url,mimeType,callback){if(arguments.length===2&&typeof mimeType==="function")callback=mimeType,mimeType=null;return d3_xhr(url,mimeType,response,callback)}}function d3_xhr(url,mimeType,response,callback){var xhr={},dispatch=d3.dispatch("beforesend","progress","load","error"),headers={},request=new XMLHttpRequest,responseType=null;if(this.XDomainRequest&&!("withCredentials"in request)&&/^(http(s)?:)?\/\//.test(url))request=new XDomainRequest;"onload"in request?request.onload=request.onerror=respond:request.onreadystatechange=function(){request.readyState>3&&respond()};function respond(){var status=request.status,result;if(!status&&d3_xhrHasResponse(request)||status>=200&&status<300||status===304){try{result=response.call(xhr,request)}catch(e){dispatch.error.call(xhr,e);return}dispatch.load.call(xhr,result)}else{dispatch.error.call(xhr,request)}}request.onprogress=function(event){var o=d3.event;d3.event=event;try{dispatch.progress.call(xhr,request)}finally{d3.event=o}};xhr.header=function(name,value){name=(name+"").toLowerCase();if(arguments.length<2)return headers[name];if(value==null)delete headers[name];else headers[name]=value+"";return xhr};xhr.mimeType=function(value){if(!arguments.length)return mimeType;mimeType=value==null?null:value+"";return xhr};xhr.responseType=function(value){if(!arguments.length)return responseType;responseType=value;return xhr};xhr.response=function(value){response=value;return xhr};["get","post"].forEach((function(method){xhr[method]=function(){return xhr.send.apply(xhr,[method].concat(d3_array(arguments)))}}));xhr.send=function(method,data,callback){if(arguments.length===2&&typeof data==="function")callback=data,data=null;request.open(method,url,true);if(mimeType!=null&&!("accept"in headers))headers["accept"]=mimeType+",*/*";if(request.setRequestHeader)for(var name in headers)request.setRequestHeader(name,headers[name]);if(mimeType!=null&&request.overrideMimeType)request.overrideMimeType(mimeType);if(responseType!=null)request.responseType=responseType;if(callback!=null)xhr.on("error",callback).on("load",(function(request){callback(null,request)}));dispatch.beforesend.call(xhr,request);request.send(data==null?null:data);return xhr};xhr.abort=function(){request.abort();return xhr};d3.rebind(xhr,dispatch,"on");return callback==null?xhr:xhr.get(d3_xhr_fixCallback(callback))}function d3_xhr_fixCallback(callback){return callback.length===1?function(error,request){callback(error==null?request:null)}:callback}function d3_xhrHasResponse(request){var type=request.responseType;return type&&type!=="text"?request.response:request.responseText}d3.dsv=function(delimiter,mimeType){var reFormat=new RegExp('["'+delimiter+"\n]"),delimiterCode=delimiter.charCodeAt(0);function dsv(url,row,callback){if(arguments.length<3)callback=row,row=null;var xhr=d3_xhr(url,mimeType,row==null?response:typedResponse(row),callback);xhr.row=function(_){return arguments.length?xhr.response((row=_)==null?response:typedResponse(_)):row};return xhr}function response(request){return dsv.parse(request.responseText)}function typedResponse(f){return function(request){return dsv.parse(request.responseText,f)}}dsv.parse=function(text,f){var o;return dsv.parseRows(text,(function(row,i){if(o)return o(row,i-1);var a=new Function("d","return {"+row.map((function(name,i){return JSON.stringify(name)+": d["+i+"]"})).join(",")+"}");o=f?function(row,i){return f(a(row),i)}:a}))};dsv.parseRows=function(text,f){var EOL={},EOF={},rows=[],N=text.length,I=0,n=0,t,eol;function token(){if(I>=N)return EOF;if(eol)return eol=false,EOL;var j=I;if(text.charCodeAt(j)===34){var i=j;while(i++<N){if(text.charCodeAt(i)===34){if(text.charCodeAt(i+1)!==34)break;++i}}I=i+2;var c=text.charCodeAt(i+1);if(c===13){eol=true;if(text.charCodeAt(i+2)===10)++I}else if(c===10){eol=true}return text.slice(j+1,i).replace(/""/g,'"')}while(I<N){var c=text.charCodeAt(I++),k=1;if(c===10)eol=true;else if(c===13){eol=true;if(text.charCodeAt(I)===10)++I,++k}else if(c!==delimiterCode)continue;return text.slice(j,I-k)}return text.slice(j)}while((t=token())!==EOF){var a=[];while(t!==EOL&&t!==EOF){a.push(t);t=token()}if(f&&(a=f(a,n++))==null)continue;rows.push(a)}return rows};dsv.format=function(rows){if(Array.isArray(rows[0]))return dsv.formatRows(rows);var fieldSet=new d3_Set,fields=[];rows.forEach((function(row){for(var field in row){if(!fieldSet.has(field)){fields.push(fieldSet.add(field))}}}));return[fields.map(formatValue).join(delimiter)].concat(rows.map((function(row){return fields.map((function(field){return formatValue(row[field])})).join(delimiter)}))).join("\n")};dsv.formatRows=function(rows){return rows.map(formatRow).join("\n")};function formatRow(row){return row.map(formatValue).join(delimiter)}function formatValue(text){return reFormat.test(text)?'"'+text.replace(/\"/g,'""')+'"':text}return dsv};d3.csv=d3.dsv(",","text/csv");d3.tsv=d3.dsv("\t","text/tab-separated-values");var d3_timer_queueHead,d3_timer_queueTail,d3_timer_interval,d3_timer_timeout,d3_timer_frame=this[d3_vendorSymbol(this,"requestAnimationFrame")]||function(callback){setTimeout(callback,17)};d3.timer=function(){d3_timer.apply(this,arguments)};function d3_timer(callback,delay,then){var n=arguments.length;if(n<2)delay=0;if(n<3)then=Date.now();var time=then+delay,timer={c:callback,t:time,n:null};if(d3_timer_queueTail)d3_timer_queueTail.n=timer;else d3_timer_queueHead=timer;d3_timer_queueTail=timer;if(!d3_timer_interval){d3_timer_timeout=clearTimeout(d3_timer_timeout);d3_timer_interval=1;d3_timer_frame(d3_timer_step)}return timer}function d3_timer_step(){var now=d3_timer_mark(),delay=d3_timer_sweep()-now;if(delay>24){if(isFinite(delay)){clearTimeout(d3_timer_timeout);d3_timer_timeout=setTimeout(d3_timer_step,delay)}d3_timer_interval=0}else{d3_timer_interval=1;d3_timer_frame(d3_timer_step)}}d3.timer.flush=function(){d3_timer_mark();d3_timer_sweep()};function d3_timer_mark(){var now=Date.now(),timer=d3_timer_queueHead;while(timer){if(now>=timer.t&&timer.c(now-timer.t))timer.c=null;timer=timer.n}return now}function d3_timer_sweep(){var t0,t1=d3_timer_queueHead,time=Infinity;while(t1){if(t1.c){if(t1.t<time)time=t1.t;t1=(t0=t1).n}else{t1=t0?t0.n=t1.n:d3_timer_queueHead=t1.n}}d3_timer_queueTail=t0;return time}function d3_format_precision(x,p){return p-(x?Math.ceil(Math.log(x)/Math.LN10):1)}d3.round=function(x,n){return n?Math.round(x*(n=Math.pow(10,n)))/n:Math.round(x)};var d3_formatPrefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map(d3_formatPrefix);d3.formatPrefix=function(value,precision){var i=0;if(value=+value){if(value<0)value*=-1;if(precision)value=d3.round(value,d3_format_precision(value,precision));i=1+Math.floor(1e-12+Math.log(value)/Math.LN10);i=Math.max(-24,Math.min(24,Math.floor((i-1)/3)*3))}return d3_formatPrefixes[8+i/3]};function d3_formatPrefix(d,i){var k=Math.pow(10,abs(8-i)*3);return{scale:i>8?function(d){return d/k}:function(d){return d*k},symbol:d}}function d3_locale_numberFormat(locale){var locale_decimal=locale.decimal,locale_thousands=locale.thousands,locale_grouping=locale.grouping,locale_currency=locale.currency,formatGroup=locale_grouping&&locale_thousands?function(value,width){var i=value.length,t=[],j=0,g=locale_grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=locale_grouping[j=(j+1)%locale_grouping.length]}return t.reverse().join(locale_thousands)}:d3_identity;return function(specifier){var match=d3_format_re.exec(specifier),fill=match[1]||" ",align=match[2]||">",sign=match[3]||"-",symbol=match[4]||"",zfill=match[5],width=+match[6],comma=match[7],precision=match[8],type=match[9],scale=1,prefix="",suffix="",integer=false,exponent=true;if(precision)precision=+precision.substring(1);if(zfill||fill==="0"&&align==="="){zfill=fill="0";align="="}switch(type){case"n":comma=true;type="g";break;case"%":scale=100;suffix="%";type="f";break;case"p":scale=100;suffix="%";type="r";break;case"b":case"o":case"x":case"X":if(symbol==="#")prefix="0"+type.toLowerCase();case"c":exponent=false;case"d":integer=true;precision=0;break;case"s":scale=-1;type="r";break}if(symbol==="$")prefix=locale_currency[0],suffix=locale_currency[1];if(type=="r"&&!precision)type="g";if(precision!=null){if(type=="g")precision=Math.max(1,Math.min(21,precision));else if(type=="e"||type=="f")precision=Math.max(0,Math.min(20,precision))}type=d3_format_types.get(type)||d3_format_typeDefault;var zcomma=zfill&&comma;return function(value){var fullSuffix=suffix;if(integer&&value%1)return"";var negative=value<0||value===0&&1/value<0?(value=-value,"-"):sign==="-"?"":sign;if(scale<0){var unit=d3.formatPrefix(value,precision);value=unit.scale(value);fullSuffix=unit.symbol+suffix}else{value*=scale}value=type(value,precision);var i=value.lastIndexOf("."),before,after;if(i<0){var j=exponent?value.lastIndexOf("e"):-1;if(j<0)before=value,after="";else before=value.substring(0,j),after=value.substring(j)}else{before=value.substring(0,i);after=locale_decimal+value.substring(i+1)}if(!zfill&&comma)before=formatGroup(before,Infinity);var length=prefix.length+before.length+after.length+(zcomma?0:negative.length),padding=length<width?new Array(length=width-length+1).join(fill):"";if(zcomma)before=formatGroup(padding+before,padding.length?width-after.length:Infinity);negative+=prefix;value=before+after;return(align==="<"?negative+value+padding:align===">"?padding+negative+value:align==="^"?padding.substring(0,length>>=1)+negative+value+padding.substring(length):negative+(zcomma?value:padding+value))+fullSuffix}}}var d3_format_re=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i;var d3_format_types=d3.map({b:function(x){return x.toString(2)},c:function(x){return String.fromCharCode(x)},o:function(x){return x.toString(8)},x:function(x){return x.toString(16)},X:function(x){return x.toString(16).toUpperCase()},g:function(x,p){return x.toPrecision(p)},e:function(x,p){return x.toExponential(p)},f:function(x,p){return x.toFixed(p)},r:function(x,p){return(x=d3.round(x,d3_format_precision(x,p))).toFixed(Math.max(0,Math.min(20,d3_format_precision(x*(1+1e-15),p))))}});function d3_format_typeDefault(x){return x+""}var d3_time=d3.time={},d3_date=Date;function d3_date_utc(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0])}d3_date_utc.prototype={getDate:function(){return this._.getUTCDate()},getDay:function(){return this._.getUTCDay()},getFullYear:function(){return this._.getUTCFullYear()},getHours:function(){return this._.getUTCHours()},getMilliseconds:function(){return this._.getUTCMilliseconds()},getMinutes:function(){return this._.getUTCMinutes()},getMonth:function(){return this._.getUTCMonth()},getSeconds:function(){return this._.getUTCSeconds()},getTime:function(){return this._.getTime()},getTimezoneOffset:function(){return 0},valueOf:function(){return this._.valueOf()},setDate:function(){d3_time_prototype.setUTCDate.apply(this._,arguments)},setDay:function(){d3_time_prototype.setUTCDay.apply(this._,arguments)},setFullYear:function(){d3_time_prototype.setUTCFullYear.apply(this._,arguments)},setHours:function(){d3_time_prototype.setUTCHours.apply(this._,arguments)},setMilliseconds:function(){d3_time_prototype.setUTCMilliseconds.apply(this._,arguments)},setMinutes:function(){d3_time_prototype.setUTCMinutes.apply(this._,arguments)},setMonth:function(){d3_time_prototype.setUTCMonth.apply(this._,arguments)},setSeconds:function(){d3_time_prototype.setUTCSeconds.apply(this._,arguments)},setTime:function(){d3_time_prototype.setTime.apply(this._,arguments)}};var d3_time_prototype=Date.prototype;function d3_time_interval(local,step,number){function round(date){var d0=local(date),d1=offset(d0,1);return date-d0<d1-date?d0:d1}function ceil(date){step(date=local(new d3_date(date-1)),1);return date}function offset(date,k){step(date=new d3_date(+date),k);return date}function range(t0,t1,dt){var time=ceil(t0),times=[];if(dt>1){while(time<t1){if(!(number(time)%dt))times.push(new Date(+time));step(time,1)}}else{while(time<t1)times.push(new Date(+time)),step(time,1)}return times}function range_utc(t0,t1,dt){try{d3_date=d3_date_utc;var utc=new d3_date_utc;utc._=t0;return range(utc,t1,dt)}finally{d3_date=Date}}local.floor=local;local.round=round;local.ceil=ceil;local.offset=offset;local.range=range;var utc=local.utc=d3_time_interval_utc(local);utc.floor=utc;utc.round=d3_time_interval_utc(round);utc.ceil=d3_time_interval_utc(ceil);utc.offset=d3_time_interval_utc(offset);utc.range=range_utc;return local}function d3_time_interval_utc(method){return function(date,k){try{d3_date=d3_date_utc;var utc=new d3_date_utc;utc._=date;return method(utc,k)._}finally{d3_date=Date}}}d3_time.year=d3_time_interval((function(date){date=d3_time.day(date);date.setMonth(0,1);return date}),(function(date,offset){date.setFullYear(date.getFullYear()+offset)}),(function(date){return date.getFullYear()}));d3_time.years=d3_time.year.range;d3_time.years.utc=d3_time.year.utc.range;d3_time.day=d3_time_interval((function(date){var day=new d3_date(2e3,0);day.setFullYear(date.getFullYear(),date.getMonth(),date.getDate());return day}),(function(date,offset){date.setDate(date.getDate()+offset)}),(function(date){return date.getDate()-1}));d3_time.days=d3_time.day.range;d3_time.days.utc=d3_time.day.utc.range;d3_time.dayOfYear=function(date){var year=d3_time.year(date);return Math.floor((date-year-(date.getTimezoneOffset()-year.getTimezoneOffset())*6e4)/864e5)};["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach((function(day,i){i=7-i;var interval=d3_time[day]=d3_time_interval((function(date){(date=d3_time.day(date)).setDate(date.getDate()-(date.getDay()+i)%7);return date}),(function(date,offset){date.setDate(date.getDate()+Math.floor(offset)*7)}),(function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7)-(day!==i)}));d3_time[day+"s"]=interval.range;d3_time[day+"s"].utc=interval.utc.range;d3_time[day+"OfYear"]=function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7)}}));d3_time.week=d3_time.sunday;d3_time.weeks=d3_time.sunday.range;d3_time.weeks.utc=d3_time.sunday.utc.range;d3_time.weekOfYear=d3_time.sundayOfYear;function d3_locale_timeFormat(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_days=locale.days,locale_shortDays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;function d3_time_format(template){var n=template.length;function format(date){var string=[],i=-1,j=0,c,p,f;while(++i<n){if(template.charCodeAt(i)===37){string.push(template.slice(j,i));if((p=d3_time_formatPads[c=template.charAt(++i)])!=null)c=template.charAt(++i);if(f=d3_time_formats[c])c=f(date,p==null?c==="e"?" ":"0":p);string.push(c);j=i+1}}string.push(template.slice(j,i));return string.join("")}format.parse=function(string){var d={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null},i=d3_time_parse(d,template,string,0);if(i!=string.length)return null;if("p"in d)d.H=d.H%12+d.p*12;var localZ=d.Z!=null&&d3_date!==d3_date_utc,date=new(localZ?d3_date_utc:d3_date);if("j"in d)date.setFullYear(d.y,0,d.j);else if("W"in d||"U"in d){if(!("w"in d))d.w="W"in d?1:0;date.setFullYear(d.y,0,1);date.setFullYear(d.y,0,"W"in d?(d.w+6)%7+d.W*7-(date.getDay()+5)%7:d.w+d.U*7-(date.getDay()+6)%7)}else date.setFullYear(d.y,d.m,d.d);date.setHours(d.H+(d.Z/100|0),d.M+d.Z%100,d.S,d.L);return localZ?date._:date};format.toString=function(){return template};return format}function d3_time_parse(date,template,string,j){var c,p,t,i=0,n=template.length,m=string.length;while(i<n){if(j>=m)return-1;c=template.charCodeAt(i++);if(c===37){t=template.charAt(i++);p=d3_time_parsers[t in d3_time_formatPads?template.charAt(i++):t];if(!p||(j=p(date,string,j))<0)return-1}else if(c!=string.charCodeAt(j++)){return-1}}return j}d3_time_format.utc=function(template){var local=d3_time_format(template);function format(date){try{d3_date=d3_date_utc;var utc=new d3_date;utc._=date;return local(utc)}finally{d3_date=Date}}format.parse=function(string){try{d3_date=d3_date_utc;var date=local.parse(string);return date&&date._}finally{d3_date=Date}};format.toString=local.toString;return format};d3_time_format.multi=d3_time_format.utc.multi=d3_time_formatMulti;var d3_time_periodLookup=d3.map(),d3_time_dayRe=d3_time_formatRe(locale_days),d3_time_dayLookup=d3_time_formatLookup(locale_days),d3_time_dayAbbrevRe=d3_time_formatRe(locale_shortDays),d3_time_dayAbbrevLookup=d3_time_formatLookup(locale_shortDays),d3_time_monthRe=d3_time_formatRe(locale_months),d3_time_monthLookup=d3_time_formatLookup(locale_months),d3_time_monthAbbrevRe=d3_time_formatRe(locale_shortMonths),d3_time_monthAbbrevLookup=d3_time_formatLookup(locale_shortMonths);locale_periods.forEach((function(p,i){d3_time_periodLookup.set(p.to