"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

module.exports = {
  resolve: {
    extensions: ['.ts', '.js']
  },
  node: {
    fs: 'empty',
    child_process: 'empty',
    readline: 'empty'
  },
  module: {
    rules: [{
      test: /\.ts$/,
      exclude: [/node_modules/],
      include: [/e2e\/cypress/],
      use: [{
        loader: 'ts-loader'
      }]
    }, {
      test: /\.feature$/,
      use: [{
        loader: 'cypress-cucumber-preprocessor/loader'
      }]
    }, {
      test: /\.features$/,
      use: [{
        loader: 'cypress-cucumber-preprocessor/lib/featuresLoader'
      }]
    }]
  }
};