"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// ***********************************************************
// This example plugins/index.js can be used to load plugins
//
// You can change the location of this file or turn off loading
// the plugins file with the 'pluginsFile' configuration option.
//
// You can read more here:
// https://on.cypress.io/plugins-guide
// ***********************************************************
// This function is called when a project is opened or re-opened (e.g. due to
// the project's config changing)
// eslint-disable-next-line import/no-extraneous-dependencies

const wp = require('@cypress/webpack-preprocessor');

const fs = require('fs');

module.exports = on => {
  const options = {
    webpackOptions: require('../webpack.config.js')
  };
  on('file:preprocessor', wp(options)); // readFileMaybe

  on('task', {
    // ESLint thinks this is a react component for some reason.
    // eslint-disable-next-line react/function-component-definition
    readFileMaybe(filename) {
      if (fs.existsSync(filename)) {
        return fs.readFileSync(filename, 'utf8');
      }

      return null;
    }

  });
};