(window["visTypeVega_bundle_jsonpfunction"]=window["visTypeVega_bundle_jsonpfunction"]||[]).push([[0],Array(36).concat([function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function accessor(fn,fields,name){fn.fields=fields||[];fn.fname=name;return fn}function accessorName(fn){return fn==null?null:fn.fname}function accessorFields(fn){return fn==null?null:fn.fields}function getter(path){return path.length===1?get1(path[0]):getN(path)}const get1=field=>function(obj){return obj[field]};const getN=path=>{const len=path.length;return function(obj){for(let i=0;i<len;++i){obj=obj[path[i]]}return obj}};function error(message){throw Error(message)}function splitAccessPath(p){const path=[],n=p.length;let q=null,b=0,s="",i,j,c;p=p+"";function push(){path.push(s+p.substring(i,j));s="";i=j+1}for(i=j=0;j<n;++j){c=p[j];if(c==="\\"){s+=p.substring(i,j);s+=p.substring(++j,++j);i=j}else if(c===q){push();q=null;b=-1}else if(q){continue}else if(i===b&&c==='"'){i=j+1;q=c}else if(i===b&&c==="'"){i=j+1;q=c}else if(c==="."&&!b){if(j>i){push()}else{i=j+1}}else if(c==="["){if(j>i)push();b=i=j+1}else if(c==="]"){if(!b)error("Access path missing open bracket: "+p);if(b>0)push();b=0;i=j+1}}if(b)error("Access path missing closing bracket: "+p);if(q)error("Access path missing closing quote: "+p);if(j>i){j++;push()}return path}function field(field,name,opt){const path=splitAccessPath(field);field=path.length===1?path[0]:field;return accessor((opt&&opt.get||getter)(path),[field],name||field)}const id=field("id");const identity=accessor(_=>_,[],"identity");const zero=accessor(()=>0,[],"zero");const one=accessor(()=>1,[],"one");const truthy=accessor(()=>true,[],"true");const falsy=accessor(()=>false,[],"false");function log(method,level,input){const args=[level].concat([].slice.call(input));console[method].apply(console,args)}const None=0;const Error$1=1;const Warn=2;const Info=3;const Debug=4;function logger(_,method){let level=_||None;return{level(_){if(arguments.length){level=+_;return this}else{return level}},error(){if(level>=Error$1)log(method||"error","ERROR",arguments);return this},warn(){if(level>=Warn)log(method||"warn","WARN",arguments);return this},info(){if(level>=Info)log(method||"log","INFO",arguments);return this},debug(){if(level>=Debug)log(method||"log","DEBUG",arguments);return this}}}var isArray=Array.isArray;function isObject(_){return _===Object(_)}const isLegalKey=key=>key!=="__proto__";function mergeConfig(...configs){return configs.reduce((out,source)=>{for(const key in source){if(key==="signals"){out.signals=mergeNamed(out.signals,source.signals)}else{const r=key==="legend"?{layout:1}:key==="style"?true:null;writeConfig(out,key,source[key],r)}}return out},{})}function writeConfig(output,key,value,recurse){if(!isLegalKey(key))return;let k,o;if(isObject(value)&&!isArray(value)){o=isObject(output[key])?output[key]:output[key]={};for(k in value){if(recurse&&(recurse===true||recurse[k])){writeConfig(o,k,value[k])}else if(isLegalKey(k)){o[k]=value[k]}}}else{output[key]=value}}function mergeNamed(a,b){if(a==null)return b;const map={},out=[];function add(_){if(!map[_.name]){map[_.name]=1;out.push(_)}}b.forEach(add);a.forEach(add);return out}function peek(array){return array[array.length-1]}function toNumber(_){return _==null||_===""?null:+_}const exp=sign=>x=>sign*Math.exp(x);const log$1=sign=>x=>Math.log(sign*x);const symlog=c=>x=>Math.sign(x)*Math.log1p(Math.abs(x/c));const symexp=c=>x=>Math.sign(x)*Math.expm1(Math.abs(x))*c;const pow=exponent=>x=>x<0?-Math.pow(-x,exponent):Math.pow(x,exponent);function pan(domain,delta,lift,ground){const d0=lift(domain[0]),d1=lift(peek(domain)),dd=(d1-d0)*delta;return[ground(d0-dd),ground(d1-dd)]}function panLinear(domain,delta){return pan(domain,delta,toNumber,identity)}function panLog(domain,delta){var sign=Math.sign(domain[0]);return pan(domain,delta,log$1(sign),exp(sign))}function panPow(domain,delta,exponent){return pan(domain,delta,pow(exponent),pow(1/exponent))}function panSymlog(domain,delta,constant){return pan(domain,delta,symlog(constant),symexp(constant))}function zoom(domain,anchor,scale,lift,ground){const d0=lift(domain[0]),d1=lift(peek(domain)),da=anchor!=null?lift(anchor):(d0+d1)/2;return[ground(da+(d0-da)*scale),ground(da+(d1-da)*scale)]}function zoomLinear(domain,anchor,scale){return zoom(domain,anchor,scale,toNumber,identity)}function zoomLog(domain,anchor,scale){const sign=Math.sign(domain[0]);return zoom(domain,anchor,scale,log$1(sign),exp(sign))}function zoomPow(domain,anchor,scale,exponent){return zoom(domain,anchor,scale,pow(exponent),pow(1/exponent))}function zoomSymlog(domain,anchor,scale,constant){return zoom(domain,anchor,scale,symlog(constant),symexp(constant))}function quarter(date){return 1+~~(new Date(date).getMonth()/3)}function utcquarter(date){return 1+~~(new Date(date).getUTCMonth()/3)}function array(_){return _!=null?isArray(_)?_:[_]:[]}function clampRange(range,min,max){let lo=range[0],hi=range[1],span;if(hi<lo){span=hi;hi=lo;lo=span}span=hi-lo;return span>=max-min?[min,max]:[lo=Math.min(Math.max(lo,min),max-span),lo+span]}function isFunction(_){return typeof _==="function"}const DESCENDING="descending";function compare(fields,orders,opt){opt=opt||{};orders=array(orders)||[];const ord=[],get=[],fmap={},gen=opt.comparator||comparator;array(fields).forEach((f,i)=>{if(f==null)return;ord.push(orders[i]===DESCENDING?-1:1);get.push(f=isFunction(f)?f:field(f,null,opt));(accessorFields(f)||[]).forEach(_=>fmap[_]=1)});return get.length===0?null:accessor(gen(get,ord),Object.keys(fmap))}const ascending=(u,v)=>(u<v||u==null)&&v!=null?-1:(u>v||v==null)&&u!=null?1:(v=v instanceof Date?+v:v,u=u instanceof Date?+u:u)!==u&&v===v?-1:v!==v&&u===u?1:0;const comparator=(fields,orders)=>fields.length===1?compare1(fields[0],orders[0]):compareN(fields,orders,fields.length);const compare1=(field,order)=>function(a,b){return ascending(field(a),field(b))*order};const compareN=(fields,orders,n)=>{orders.push(0);return function(a,b){let f,c=0,i=-1;while(c===0&&++i<n){f=fields[i];c=ascending(f(a),f(b))}return c*orders[i]}};function constant(_){return isFunction(_)?_:()=>_}function debounce(delay,handler){let tid;return e=>{if(tid)clearTimeout(tid);tid=setTimeout(()=>(handler(e),tid=null),delay)}}function extend(_){for(let x,k,i=1,len=arguments.length;i<len;++i){x=arguments[i];for(k in x){_[k]=x[k]}}return _}function extent(array,f){let i=0,n,v,min,max;if(array&&(n=array.length)){if(f==null){for(v=array[i];i<n&&(v==null||v!==v);v=array[++i]);min=max=v;for(;i<n;++i){v=array[i];if(v!=null){if(v<min)min=v;if(v>max)max=v}}}else{for(v=f(array[i]);i<n&&(v==null||v!==v);v=f(array[++i]));min=max=v;for(;i<n;++i){v=f(array[i]);if(v!=null){if(v<min)min=v;if(v>max)max=v}}}}return[min,max]}function extentIndex(array,f){const n=array.length;let i=-1,a,b,c,u,v;if(f==null){while(++i<n){b=array[i];if(b!=null&&b>=b){a=c=b;break}}if(i===n)return[-1,-1];u=v=i;while(++i<n){b=array[i];if(b!=null){if(a>b){a=b;u=i}if(c<b){c=b;v=i}}}}else{while(++i<n){b=f(array[i],i,array);if(b!=null&&b>=b){a=c=b;break}}if(i===n)return[-1,-1];u=v=i;while(++i<n){b=f(array[i],i,array);if(b!=null){if(a>b){a=b;u=i}if(c<b){c=b;v=i}}}}return[u,v]}const hop=Object.prototype.hasOwnProperty;function has(object,property){return hop.call(object,property)}const NULL={};function fastmap(input){let obj={},test;function has$1(key){return has(obj,key)&&obj[key]!==NULL}const map={size:0,empty:0,object:obj,has:has$1,get(key){return has$1(key)?obj[key]:undefined},set(key,value){if(!has$1(key)){++map.size;if(obj[key]===NULL)--map.empty}obj[key]=value;return this},delete(key){if(has$1(key)){--map.size;++map.empty;obj[key]=NULL}return this},clear(){map.size=map.empty=0;map.object=obj={}},test(_){if(arguments.length){test=_;return map}else{return test}},clean(){const next={};let size=0;for(const key in obj){const value=obj[key];if(value!==NULL&&(!test||!test(value))){next[key]=value;++size}}map.size=size;map.empty=0;map.object=obj=next}};if(input)Object.keys(input).forEach(key=>{map.set(key,input[key])});return map}function flush(range,value,threshold,left,right,center){if(!threshold&&threshold!==0)return center;const t=+threshold;let a=range[0],b=peek(range),l;if(b<a){l=a;a=b;b=l}l=Math.abs(value-a);const r=Math.abs(b-value);return l<r&&l<=t?left:r<=t?right:center}function inherits(child,parent,members){const proto=child.prototype=Object.create(parent.prototype);proto.constructor=child;return extend(proto,members)}function inrange(value,range,left,right){let r0=range[0],r1=range[range.length-1],t;if(r0>r1){t=r0;r0=r1;r1=t}left=left===undefined||left;right=right===undefined||right;return(left?r0<=value:r0<value)&&(right?value<=r1:value<r1)}function isBoolean(_){return typeof _==="boolean"}function isDate(_){return Object.prototype.toString.call(_)==="[object Date]"}function isIterable(_){return _&&isFunction(_[Symbol.iterator])}function isNumber(_){return typeof _==="number"}function isRegExp(_){return Object.prototype.toString.call(_)==="[object RegExp]"}function isString(_){return typeof _==="string"}function key(fields,flat,opt){if(fields){fields=flat?array(fields).map(f=>f.replace(/\\(.)/g,"$1")):array(fields)}const len=fields&&fields.length,gen=opt&&opt.get||getter,map=f=>gen(flat?[f]:splitAccessPath(f));let fn;if(!len){fn=function(){return""}}else if(len===1){const get=map(fields[0]);fn=function(_){return""+get(_)}}else{const get=fields.map(map);fn=function(_){let s=""+get[0](_),i=0;while(++i<len)s+="|"+get[i](_);return s}}return accessor(fn,fields,"key")}function lerp(array,frac){const lo=array[0],hi=peek(array),f=+frac;return!f?lo:f===1?hi:lo+f*(hi-lo)}const DEFAULT_MAX_SIZE=1e4;function lruCache(maxsize){maxsize=+maxsize||DEFAULT_MAX_SIZE;let curr,prev,size;const clear=()=>{curr={};prev={};size=0};const update=(key,value)=>{if(++size>maxsize){prev=curr;curr={};size=1}return curr[key]=value};clear();return{clear:clear,has:key=>has(curr,key)||has(prev,key),get:key=>has(curr,key)?curr[key]:has(prev,key)?update(key,prev[key]):undefined,set:(key,value)=>has(curr,key)?curr[key]=value:update(key,value)}}function merge(compare,array0,array1,output){const n0=array0.length,n1=array1.length;if(!n1)return array0;if(!n0)return array1;const merged=output||new array0.constructor(n0+n1);let i0=0,i1=0,i=0;for(;i0<n0&&i1<n1;++i){merged[i]=compare(array0[i0],array1[i1])>0?array1[i1++]:array0[i0++]}for(;i0<n0;++i0,++i){merged[i]=array0[i0]}for(;i1<n1;++i1,++i){merged[i]=array1[i1]}return merged}function repeat(str,reps){let s="";while(--reps>=0)s+=str;return s}function pad(str,length,padchar,align){const c=padchar||" ",s=str+"",n=length-s.length;return n<=0?s:align==="left"?repeat(c,n)+s:align==="center"?repeat(c,~~(n/2))+s+repeat(c,Math.ceil(n/2)):s+repeat(c,n)}function span(array){return array&&peek(array)-array[0]||0}function $(x){return isArray(x)?"["+x.map($)+"]":isObject(x)||isString(x)?JSON.stringify(x).replace("\u2028","\\u2028").replace("\u2029","\\u2029"):x}function toBoolean(_){return _==null||_===""?null:!_||_==="false"||_==="0"?false:!!_}const defaultParser=_=>isNumber(_)?_:isDate(_)?_:Date.parse(_);function toDate(_,parser){parser=parser||defaultParser;return _==null||_===""?null:parser(_)}function toString(_){return _==null||_===""?null:_+""}function toSet(_){const s={},n=_.length;for(let i=0;i<n;++i)s[_[i]]=true;return s}function truncate(str,length,align,ellipsis){const e=ellipsis!=null?ellipsis:"…",s=str+"",n=s.length,l=Math.max(0,length-e.length);return n<=length?s:align==="left"?e+s.slice(n-l):align==="center"?s.slice(0,Math.ceil(l/2))+e+s.slice(n-~~(l/2)):s.slice(0,l)+e}function visitArray(array,filter,visitor){if(array){if(filter){const n=array.length;for(let i=0;i<n;++i){const t=filter(array[i]);if(t)visitor(t,i,array)}}else{array.forEach(visitor)}}}exports.Debug=Debug;exports.Error=Error$1;exports.Info=Info;exports.None=None;exports.Warn=Warn;exports.accessor=accessor;exports.accessorFields=accessorFields;exports.accessorName=accessorName;exports.array=array;exports.ascending=ascending;exports.clampRange=clampRange;exports.compare=compare;exports.constant=constant;exports.debounce=debounce;exports.error=error;exports.extend=extend;exports.extent=extent;exports.extentIndex=extentIndex;exports.falsy=falsy;exports.fastmap=fastmap;exports.field=field;exports.flush=flush;exports.hasOwnProperty=has;exports.id=id;exports.identity=identity;exports.inherits=inherits;exports.inrange=inrange;exports.isArray=isArray;exports.isBoolean=isBoolean;exports.isDate=isDate;exports.isFunction=isFunction;exports.isIterable=isIterable;exports.isNumber=isNumber;exports.isObject=isObject;exports.isRegExp=isRegExp;exports.isString=isString;exports.key=key;exports.lerp=lerp;exports.logger=logger;exports.lruCache=lruCache;exports.merge=merge;exports.mergeConfig=mergeConfig;exports.one=one;exports.pad=pad;exports.panLinear=panLinear;exports.panLog=panLog;exports.panPow=panPow;exports.panSymlog=panSymlog;exports.peek=peek;exports.quarter=quarter;exports.repeat=repeat;exports.span=span;exports.splitAccessPath=splitAccessPath;exports.stringValue=$;exports.toBoolean=toBoolean;exports.toDate=toDate;exports.toNumber=toNumber;exports.toSet=toSet;exports.toString=toString;exports.truncate=truncate;exports.truthy=truthy;exports.utcquarter=utcquarter;exports.visitArray=visitArray;exports.writeConfig=writeConfig;exports.zero=zero;exports.zoomLinear=zoomLinear;exports.zoomLog=zoomLog;exports.zoomPow=zoomPow;exports.zoomSymlog=zoomSymlog;Object.defineProperty(exports,"__esModule",{value:true})}))},,,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(58),__webpack_require__(50)):undefined})(this,(function(exports,vegaUtil,vegaLoader,vegaFormat){"use strict";function UniqueList(idFunc){const $=idFunc||vegaUtil.identity,list=[],ids={};list.add=_=>{const id=$(_);if(!ids[id]){ids[id]=1;list.push(_)}return list};list.remove=_=>{const id=$(_);if(ids[id]){ids[id]=0;const idx=list.indexOf(_);if(idx>=0)list.splice(idx,1)}return list};return list}async function asyncCallback(df,callback){try{await callback(df)}catch(err){df.error(err)}}const TUPLE_ID_KEY=Symbol("vega_id");let TUPLE_ID=1;function isTuple(t){return!!(t&&tupleid(t))}function tupleid(t){return t[TUPLE_ID_KEY]}function setid(t,id){t[TUPLE_ID_KEY]=id;return t}function ingest(datum){const t=datum===Object(datum)?datum:{data:datum};return tupleid(t)?t:setid(t,TUPLE_ID++)}function derive(t){return rederive(t,ingest({}))}function rederive(t,d){for(const k in t)d[k]=t[k];return d}function replace(t,d){return setid(d,tupleid(t))}function stableCompare(cmp,f){return!cmp?null:f?(a,b)=>cmp(a,b)||tupleid(f(a))-tupleid(f(b)):(a,b)=>cmp(a,b)||tupleid(a)-tupleid(b)}function isChangeSet(v){return v&&v.constructor===changeset}function changeset(){const add=[],rem=[],mod=[],remp=[],modp=[];let clean=null,reflow=false;return{constructor:changeset,insert(t){const d=vegaUtil.array(t),n=d.length;for(let i=0;i<n;++i)add.push(d[i]);return this},remove(t){const a=vegaUtil.isFunction(t)?remp:rem,d=vegaUtil.array(t),n=d.length;for(let i=0;i<n;++i)a.push(d[i]);return this},modify(t,field,value){const m={field:field,value:vegaUtil.constant(value)};if(vegaUtil.isFunction(t)){m.filter=t;modp.push(m)}else{m.tuple=t;mod.push(m)}return this},encode(t,set){if(vegaUtil.isFunction(t))modp.push({filter:t,field:set});else mod.push({tuple:t,field:set});return this},clean(value){clean=value;return this},reflow(){reflow=true;return this},pulse(pulse,tuples){const cur={},out={};let i,n,m,f,t,id;for(i=0,n=tuples.length;i<n;++i){cur[tupleid(tuples[i])]=1}for(i=0,n=rem.length;i<n;++i){t=rem[i];cur[tupleid(t)]=-1}for(i=0,n=remp.length;i<n;++i){f=remp[i];tuples.forEach(t=>{if(f(t))cur[tupleid(t)]=-1})}for(i=0,n=add.length;i<n;++i){t=add[i];id=tupleid(t);if(cur[id]){cur[id]=1}else{pulse.add.push(ingest(add[i]))}}for(i=0,n=tuples.length;i<n;++i){t=tuples[i];if(cur[tupleid(t)]<0)pulse.rem.push(t)}function modify(t,f,v){if(v){t[f]=v(t)}else{pulse.encode=f}if(!reflow)out[tupleid(t)]=t}for(i=0,n=mod.length;i<n;++i){m=mod[i];t=m.tuple;f=m.field;id=cur[tupleid(t)];if(id>0){modify(t,f,m.value);pulse.modifies(f)}}for(i=0,n=modp.length;i<n;++i){m=modp[i];f=m.filter;tuples.forEach(t=>{if(f(t)&&cur[tupleid(t)]>0){modify(t,m.field,m.value)}});pulse.modifies(m.field)}if(reflow){pulse.mod=rem.length||remp.length?tuples.filter(t=>cur[tupleid(t)]>0):tuples.slice()}else{for(id in out)pulse.mod.push(out[id])}if(clean||clean==null&&(rem.length||remp.length)){pulse.clean(true)}return pulse}}}const CACHE="_:mod:_";function Parameters(){Object.defineProperty(this,CACHE,{writable:true,value:{}})}Parameters.prototype={set(name,index,value,force){const o=this,v=o[name],mod=o[CACHE];if(index!=null&&index>=0){if(v[index]!==value||force){v[index]=value;mod[index+":"+name]=-1;mod[name]=-1}}else if(v!==value||force){o[name]=value;mod[name]=vegaUtil.isArray(value)?1+value.length:-1}return o},modified(name,index){const mod=this[CACHE];if(!arguments.length){for(const k in mod){if(mod[k])return true}return false}else if(vegaUtil.isArray(name)){for(let k=0;k<name.length;++k){if(mod[name[k]])return true}return false}return index!=null&&index>=0?index+1<mod[name]||!!mod[index+":"+name]:!!mod[name]},clear(){this[CACHE]={};return this}};let OP_ID=0;const PULSE="pulse",NO_PARAMS=new Parameters;const SKIP=1,MODIFIED=2;function Operator(init,update,params,react){this.id=++OP_ID;this.value=init;this.stamp=-1;this.rank=-1;this.qrank=-1;this.flags=0;if(update){this._update=update}if(params)this.parameters(params,react)}function flag(bit){return function(state){const f=this.flags;if(arguments.length===0)return!!(f&bit);this.flags=state?f|bit:f&~bit;return this}}Operator.prototype={targets(){return this._targets||(this._targets=UniqueList(vegaUtil.id))},set(value){if(this.value!==value){this.value=value;return 1}else{return 0}},skip:flag(SKIP),modified:flag(MODIFIED),parameters(params,react,initonly){react=react!==false;const argval=this._argval=this._argval||new Parameters,argops=this._argops=this._argops||[],deps=[];let name,value,n,i;const add=(name,index,value)=>{if(value instanceof Operator){if(value!==this){if(react)value.targets().add(this);deps.push(value)}argops.push({op:value,name:name,index:index})}else{argval.set(name,index,value)}};for(name in params){value=params[name];if(name===PULSE){vegaUtil.array(value).forEach(op=>{if(!(op instanceof Operator)){vegaUtil.error("Pulse parameters must be operator instances.")}else if(op!==this){op.targets().add(this);deps.push(op)}});this.source=value}else if(vegaUtil.isArray(value)){argval.set(name,-1,Array(n=value.length));for(i=0;i<n;++i)add(name,i,value[i])}else{add(name,-1,value)}}this.marshall().clear();if(initonly)argops.initonly=true;return deps},marshall(stamp){const argval=this._argval||NO_PARAMS,argops=this._argops;let item,i,op,mod;if(argops){const n=argops.length;for(i=0;i<n;++i){item=argops[i];op=item.op;mod=op.modified()&&op.stamp===stamp;argval.set(item.name,item.index,op.value,mod)}if(argops.initonly){for(i=0;i<n;++i){item=argops[i];item.op.targets().remove(this)}this._argops=null;this._update=null}}return argval},detach(){const argops=this._argops;let i,n,item,op;if(argops){for(i=0,n=argops.length;i<n;++i){item=argops[i];op=item.op;if(op._targets){op._targets.remove(this)}}}},evaluate(pulse){const update=this._update;if(update){const params=this.marshall(pulse.stamp),v=update.call(this,params,pulse);params.clear();if(v!==this.value){this.value=v}else if(!this.modified()){return pulse.StopPropagation}}},run(pulse){if(pulse.stamp<this.stamp)return pulse.StopPropagation;let rv;if(this.skip()){this.skip(false);rv=0}else{rv=this.evaluate(pulse)}return this.pulse=rv||pulse}};function add(init,update,params,react){let shift=1,op;if(init instanceof Operator){op=init}else if(init&&init.prototype instanceof Operator){op=new init}else if(vegaUtil.isFunction(init)){op=new Operator(null,init)}else{shift=0;op=new Operator(init,update)}this.rank(op);if(shift){react=params;params=update}if(params)this.connect(op,op.parameters(params,react));this.touch(op);return op}function connect(target,sources){const targetRank=target.rank,n=sources.length;for(let i=0;i<n;++i){if(targetRank<sources[i].rank){this.rerank(target);return}}}let STREAM_ID=0;function EventStream(filter,apply,receive){this.id=++STREAM_ID;this.value=null;if(receive)this.receive=receive;if(filter)this._filter=filter;if(apply)this._apply=apply}function stream(filter,apply,receive){return new EventStream(filter,apply,receive)}EventStream.prototype={_filter:vegaUtil.truthy,_apply:vegaUtil.identity,targets(){return this._targets||(this._targets=UniqueList(vegaUtil.id))},consume(_){if(!arguments.length)return!!this._consume;this._consume=!!_;return this},receive(evt){if(this._filter(evt)){const val=this.value=this._apply(evt),trg=this._targets,n=trg?trg.length:0;for(let i=0;i<n;++i)trg[i].receive(val);if(this._consume){evt.preventDefault();evt.stopPropagation()}}},filter(filter){const s=stream(filter);this.targets().add(s);return s},apply(apply){const s=stream(null,apply);this.targets().add(s);return s},merge(){const s=stream();this.targets().add(s);for(let i=0,n=arguments.length;i<n;++i){arguments[i].targets().add(s)}return s},throttle(pause){let t=-1;return this.filter(()=>{const now=Date.now();if(now-t>pause){t=now;return 1}else{return 0}})},debounce(delay){const s=stream();this.targets().add(stream(null,null,vegaUtil.debounce(delay,e=>{const df=e.dataflow;s.receive(e);if(df&&df.run)df.run()})));return s},between(a,b){let active=false;a.targets().add(stream(null,null,()=>active=true));b.targets().add(stream(null,null,()=>active=false));return this.filter(()=>active)},detach(){}};function events(source,type,filter,apply){const df=this,s=stream(filter,apply),send=function(e){e.dataflow=df;try{s.receive(e)}catch(error){df.error(error)}finally{df.run()}};let sources;if(typeof source==="string"&&typeof document!=="undefined"){sources=document.querySelectorAll(source)}else{sources=vegaUtil.array(source)}const n=sources.length;for(let i=0;i<n;++i){sources[i].addEventListener(type,send)}return s}function parse(data,format){const locale=this.locale();return vegaLoader.read(data,format,locale.timeParse,locale.utcParse)}function ingest$1(target,data,format){data=this.parse(data,format);return this.pulse(target,this.changeset().insert(data))}async function request(url,format){const df=this;let status=0,data;try{data=await df.loader().load(url,{context:"dataflow",response:vegaLoader.responseType(format&&format.type)});try{data=df.parse(data,format)}catch(err){status=-2;df.warn("Data ingestion failed",url,err)}}catch(err){status=-1;df.warn("Loading failed",url,err)}return{data:data,status:status}}async function preload(target,url,format){const df=this,pending=df._pending||loadPending(df);pending.requests+=1;const res=await df.request(url,format);df.pulse(target,df.changeset().remove(vegaUtil.truthy).insert(res.data||[]));pending.done();return res}function loadPending(df){let accept;const pending=new Promise(a=>accept=a);pending.requests=0;pending.done=()=>{if(--pending.requests===0){df._pending=null;accept(df)}};return df._pending=pending}const SKIP$1={skip:true};function on(source,target,update,params,options){const fn=source instanceof Operator?onOperator:onStream;fn(this,source,target,update,params,options);return this}function onStream(df,stream,target,update,params,options){const opt=vegaUtil.extend({},options,SKIP$1);let func,op;if(!vegaUtil.isFunction(target))target=vegaUtil.constant(target);if(update===undefined){func=e=>df.touch(target(e))}else if(vegaUtil.isFunction(update)){op=new Operator(null,update,params,false);func=e=>{op.evaluate(e);const t=target(e),v=op.value;isChangeSet(v)?df.pulse(t,v,options):df.update(t,v,opt)}}else{func=e=>df.update(target(e),update,opt)}stream.apply(func)}function onOperator(df,source,target,update,params,options){if(update===undefined){source.targets().add(target)}else{const opt=options||{},op=new Operator(null,updater(target,update),params,false);op.modified(opt.force);op.rank=source.rank;source.targets().add(op);if(target){op.skip(true);op.value=target.value;op.targets().add(target);df.connect(target,[op])}}}function updater(target,update){update=vegaUtil.isFunction(update)?update:vegaUtil.constant(update);return target?function(_,pulse){const value=update(_,pulse);if(!target.skip()){target.skip(value!==this.value).value=value}return value}:update}function rank(op){op.rank=++this._rank}function rerank(op){const queue=[op];let cur,list,i;while(queue.length){this.rank(cur=queue.pop());if(list=cur._targets){for(i=list.length;--i>=0;){queue.push(cur=list[i]);if(cur===op)vegaUtil.error("Cycle detected in dataflow graph.")}}}}const StopPropagation={};const ADD=1<<0,REM=1<<1,MOD=1<<2,ADD_REM=ADD|REM,ADD_MOD=ADD|MOD,ALL=ADD|REM|MOD,REFLOW=1<<3,SOURCE=1<<4,NO_SOURCE=1<<5,NO_FIELDS=1<<6;function Pulse(dataflow,stamp,encode){this.dataflow=dataflow;this.stamp=stamp==null?-1:stamp;this.add=[];this.rem=[];this.mod=[];this.fields=null;this.encode=encode||null}function materialize(data,filter){const out=[];vegaUtil.visitArray(data,filter,_=>out.push(_));return out}function filter(pulse,flags){const map={};pulse.visit(flags,t=>{map[tupleid(t)]=1});return t=>map[tupleid(t)]?null:t}function addFilter(a,b){return a?(t,i)=>a(t,i)&&b(t,i):b}Pulse.prototype={StopPropagation:StopPropagation,ADD:ADD,REM:REM,MOD:MOD,ADD_REM:ADD_REM,ADD_MOD:ADD_MOD,ALL:ALL,REFLOW:REFLOW,SOURCE:SOURCE,NO_SOURCE:NO_SOURCE,NO_FIELDS:NO_FIELDS,fork(flags){return new Pulse(this.dataflow).init(this,flags)},clone(){const p=this.fork(ALL);p.add=p.add.slice();p.rem=p.rem.slice();p.mod=p.mod.slice();if(p.source)p.source=p.source.slice();return p.materialize(ALL|SOURCE)},addAll(){let p=this;const reuse=!p.source||p.add===p.rem||!p.rem.length&&p.source.length===p.add.length;if(reuse){return p}else{p=new Pulse(this.dataflow).init(this);p.add=p.source;p.rem=[];return p}},init(src,flags){const p=this;p.stamp=src.stamp;p.encode=src.encode;if(src.fields&&!(flags&NO_FIELDS)){p.fields=src.fields}if(flags&ADD){p.addF=src.addF;p.add=src.add}else{p.addF=null;p.add=[]}if(flags&REM){p.remF=src.remF;p.rem=src.rem}else{p.remF=null;p.rem=[]}if(flags&MOD){p.modF=src.modF;p.mod=src.mod}else{p.modF=null;p.mod=[]}if(flags&NO_SOURCE){p.srcF=null;p.source=null}else{p.srcF=src.srcF;p.source=src.source;if(src.cleans)p.cleans=src.cleans}return p},runAfter(func){this.dataflow.runAfter(func)},changed(flags){const f=flags||ALL;return f&ADD&&this.add.length||f&REM&&this.rem.length||f&MOD&&this.mod.length},reflow(fork){if(fork)return this.fork(ALL).reflow();const len=this.add.length,src=this.source&&this.source.length;if(src&&src!==len){this.mod=this.source;if(len)this.filter(MOD,filter(this,ADD))}return this},clean(value){if(arguments.length){this.cleans=!!value;return this}else{return this.cleans}},modifies(_){const hash=this.fields||(this.fields={});if(vegaUtil.isArray(_)){_.forEach(f=>hash[f]=true)}else{hash[_]=true}return this},modified(_,nomod){const fields=this.fields;return!((nomod||this.mod.length)&&fields)?false:!arguments.length?!!fields:vegaUtil.isArray(_)?_.some(f=>fields[f]):fields[_]},filter(flags,filter){const p=this;if(flags&ADD)p.addF=addFilter(p.addF,filter);if(flags&REM)p.remF=addFilter(p.remF,filter);if(flags&MOD)p.modF=addFilter(p.modF,filter);if(flags&SOURCE)p.srcF=addFilter(p.srcF,filter);return p},materialize(flags){flags=flags||ALL;const p=this;if(flags&ADD&&p.addF){p.add=materialize(p.add,p.addF);p.addF=null}if(flags&REM&&p.remF){p.rem=materialize(p.rem,p.remF);p.remF=null}if(flags&MOD&&p.modF){p.mod=materialize(p.mod,p.modF);p.modF=null}if(flags&SOURCE&&p.srcF){p.source=p.source.filter(p.srcF);p.srcF=null}return p},visit(flags,visitor){const p=this,v=visitor;if(flags&SOURCE){vegaUtil.visitArray(p.source,p.srcF,v);return p}if(flags&ADD)vegaUtil.visitArray(p.add,p.addF,v);if(flags&REM)vegaUtil.visitArray(p.rem,p.remF,v);if(flags&MOD)vegaUtil.visitArray(p.mod,p.modF,v);const src=p.source;if(flags&REFLOW&&src){const sum=p.add.length+p.mod.length;if(sum===src.length);else if(sum){vegaUtil.visitArray(src,filter(p,ADD_MOD),v)}else{vegaUtil.visitArray(src,p.srcF,v)}}return p}};function MultiPulse(dataflow,stamp,pulses,encode){const p=this,n=pulses.length;let c=0;this.dataflow=dataflow;this.stamp=stamp;this.fields=null;this.encode=encode||null;this.pulses=pulses;for(let i=0;i<n;++i){const pulse=pulses[i];if(pulse.stamp!==stamp)continue;if(pulse.fields){const hash=p.fields||(p.fields={});for(const f in pulse.fields){hash[f]=1}}if(pulse.changed(p.ADD))c|=p.ADD;if(pulse.changed(p.REM))c|=p.REM;if(pulse.changed(p.MOD))c|=p.MOD}this.changes=c}vegaUtil.inherits(MultiPulse,Pulse,{fork(flags){const p=new Pulse(this.dataflow).init(this,flags&this.NO_FIELDS);if(flags!==undefined){if(flags&p.ADD)this.visit(p.ADD,t=>p.add.push(t));if(flags&p.REM)this.visit(p.REM,t=>p.rem.push(t));if(flags&p.MOD)this.visit(p.MOD,t=>p.mod.push(t))}return p},changed(flags){return this.changes&flags},modified(_){const p=this,fields=p.fields;return!(fields&&p.changes&p.MOD)?0:vegaUtil.isArray(_)?_.some(f=>fields[f]):fields[_]},filter(){vegaUtil.error("MultiPulse does not support filtering.")},materialize(){vegaUtil.error("MultiPulse does not support materialization.")},visit(flags,visitor){const p=this,pulses=p.pulses,n=pulses.length;let i=0;if(flags&p.SOURCE){for(;i<n;++i){pulses[i].visit(flags,visitor)}}else{for(;i<n;++i){if(pulses[i].stamp===p.stamp){pulses[i].visit(flags,visitor)}}}return p}});async function evaluate(encode,prerun,postrun){const df=this,async=[];if(df._pulse)return reentrant(df);if(df._pending)await df._pending;if(prerun)await asyncCallback(df,prerun);if(!df._touched.length){df.debug("Dataflow invoked, but nothing to do.");return df}const stamp=++df._clock;df._pulse=new Pulse(df,stamp,encode);df._touched.forEach(op=>df._enqueue(op,true));df._touched=UniqueList(vegaUtil.id);let count=0,op,next,error;try{while(df._heap.size()>0){op=df._heap.pop();if(op.rank!==op.qrank){df._enqueue(op,true);continue}next=op.run(df._getPulse(op,encode));if(next.then){next=await next}else if(next.async){async.push(next.async);next=StopPropagation}if(next!==StopPropagation){if(op._targets)op._targets.forEach(op=>df._enqueue(op))}++count}}catch(err){df._heap.clear();error=err}df._input={};df._pulse=null;df.debug(`Pulse ${stamp}: ${count} operators`);if(error){df._postrun=[];df.error(error)}if(df._postrun.length){const pr=df._postrun.sort((a,b)=>b.priority-a.priority);df._postrun=[];for(let i=0;i<pr.length;++i){await asyncCallback(df,pr[i].callback)}}if(postrun)await asyncCallback(df,postrun);if(async.length){Promise.all(async).then(cb=>df.runAsync(null,()=>{cb.forEach(f=>{try{f(df)}catch(err){df.error(err)}})}))}return df}async function runAsync(encode,prerun,postrun){while(this._running)await this._running;const clear=()=>this._running=null;(this._running=this.evaluate(encode,prerun,postrun)).then(clear,clear);return this._running}function run(encode,prerun,postrun){return this._pulse?reentrant(this):(this.evaluate(encode,prerun,postrun),this)}function runAfter(callback,enqueue,priority){if(this._pulse||enqueue){this._postrun.push({priority:priority||0,callback:callback})}else{try{callback(this)}catch(err){this.error(err)}}}function reentrant(df){df.error("Dataflow already running. Use runAsync() to chain invocations.");return df}function enqueue(op,force){const q=op.stamp<this._clock;if(q)op.stamp=this._clock;if(q||force){op.qrank=op.rank;this._heap.push(op)}}function getPulse(op,encode){const s=op.source,stamp=this._clock;return s&&vegaUtil.isArray(s)?new MultiPulse(this,stamp,s.map(_=>_.pulse),encode):this._input[op.id]||singlePulse(this._pulse,s&&s.pulse)}function singlePulse(p,s){if(s&&s.stamp===p.stamp){return s}p=p.fork();if(s&&s!==StopPropagation){p.source=s.source}return p}const NO_OPT={skip:false,force:false};function touch(op,options){const opt=options||NO_OPT;if(this._pulse){this._enqueue(op)}else{this._touched.add(op)}if(opt.skip)op.skip(true);return this}function update(op,value,options){const opt=options||NO_OPT;if(op.set(value)||opt.force){this.touch(op,opt)}return this}function pulse(op,changeset,options){this.touch(op,options||NO_OPT);const p=new Pulse(this,this._clock+(this._pulse?0:1)),t=op.pulse&&op.pulse.source||[];p.target=op;this._input[op.id]=changeset.pulse(p,t);return this}function Heap(cmp){let nodes=[];return{clear:()=>nodes=[],size:()=>nodes.length,peek:()=>nodes[0],push:x=>{nodes.push(x);return siftdown(nodes,0,nodes.length-1,cmp)},pop:()=>{const last=nodes.pop();let item;if(nodes.length){item=nodes[0];nodes[0]=last;siftup(nodes,0,cmp)}else{item=last}return item}}}function siftdown(array,start,idx,cmp){let parent,pidx;const item=array[idx];while(idx>start){pidx=idx-1>>1;parent=array[pidx];if(cmp(item,parent)<0){array[idx]=parent;idx=pidx;continue}break}return array[idx]=item}function siftup(array,idx,cmp){const start=idx,end=array.length,item=array[idx];let cidx=(idx<<1)+1,ridx;while(cidx<end){ridx=cidx+1;if(ridx<end&&cmp(array[cidx],array[ridx])>=0){cidx=ridx}array[idx]=array[cidx];idx=cidx;cidx=(idx<<1)+1}array[idx]=item;return siftdown(array,start,idx,cmp)}function Dataflow(){this.logger(vegaUtil.logger());this.logLevel(vegaUtil.Error);this._clock=0;this._rank=0;this._locale=vegaFormat.defaultLocale();try{this._loader=vegaLoader.loader()}catch(e){}this._touched=UniqueList(vegaUtil.id);this._input={};this._pulse=null;this._heap=Heap((a,b)=>a.qrank-b.qrank);this._postrun=[]}function logMethod(method){return function(){return this._log[method].apply(this,arguments)}}Dataflow.prototype={stamp(){return this._clock},loader(_){if(arguments.length){this._loader=_;return this}else{return this._loader}},locale(_){if(arguments.length){this._locale=_;return this}else{return this._locale}},logger(logger){if(arguments.length){this._log=logger;return this}else{return this._log}},error:logMethod("error"),warn:logMethod("warn"),info:logMethod("info"),debug:logMethod("debug"),logLevel:logMethod("level"),cleanThreshold:1e4,add:add,connect:connect,rank:rank,rerank:rerank,pulse:pulse,touch:touch,update:update,changeset:changeset,ingest:ingest$1,parse:parse,preload:preload,request:request,events:events,on:on,evaluate:evaluate,run:run,runAsync:runAsync,runAfter:runAfter,_enqueue:enqueue,_getPulse:getPulse};function Transform(init,params){Operator.call(this,init,null,params)}vegaUtil.inherits(Transform,Operator,{run(pulse){if(pulse.stamp<this.stamp)return pulse.StopPropagation;let rv;if(this.skip()){this.skip(false)}else{rv=this.evaluate(pulse)}rv=rv||pulse;if(rv.then){rv=rv.then(_=>this.pulse=_)}else if(rv!==pulse.StopPropagation){this.pulse=rv}return rv},evaluate(pulse){const params=this.marshall(pulse.stamp),out=this.transform(params,pulse);params.clear();return out},transform(){}});const transforms={};function definition(type){const t=transform(type);return t&&t.Definition||null}function transform(type){type=type&&type.toLowerCase();return vegaUtil.hasOwnProperty(transforms,type)?transforms[type]:null}exports.Dataflow=Dataflow;exports.EventStream=EventStream;exports.MultiPulse=MultiPulse;exports.Operator=Operator;exports.Parameters=Parameters;exports.Pulse=Pulse;exports.Transform=Transform;exports.UniqueList=UniqueList;exports.asyncCallback=asyncCallback;exports.changeset=changeset;exports.definition=definition;exports.derive=derive;exports.ingest=ingest;exports.isChangeSet=isChangeSet;exports.isTuple=isTuple;exports.rederive=rederive;exports.replace=replace;exports.stableCompare=stableCompare;exports.transform=transform;exports.transforms=transforms;exports.tupleid=tupleid;Object.defineProperty(exports,"__esModule",{value:true})}))},,,,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(95)):undefined})(this,(function(exports,d3Array){"use strict";function*numbers(values,valueof){if(valueof==null){for(let value of values){if(value!=null&&value!==""&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){value=valueof(value,++index,values);if(value!=null&&value!==""&&(value=+value)>=value){yield value}}}}function quantiles(array,p,f){const values=Float64Array.from(numbers(array,f));values.sort(d3Array.ascending);return p.map(_=>d3Array.quantileSorted(values,_))}function quartiles(array,f){return quantiles(array,[.25,.5,.75],f)}function estimateBandwidth(array,f){const n=array.length,d=d3Array.deviation(array,f),q=quartiles(array,f),h=(q[2]-q[0])/1.34,v=Math.min(d,h)||d||Math.abs(q[0])||1;return 1.06*v*Math.pow(n,-.2)}function bin(_){const maxb=_.maxbins||20,base=_.base||10,logb=Math.log(base),div=_.divide||[5,2];let min=_.extent[0],max=_.extent[1],step,level,minstep,v,i,n;const span=_.span||max-min||Math.abs(min)||1;if(_.step){step=_.step}else if(_.steps){v=span/maxb;for(i=0,n=_.steps.length;i<n&&_.steps[i]<v;++i);step=_.steps[Math.max(0,i-1)]}else{level=Math.ceil(Math.log(maxb)/logb);minstep=_.minstep||0;step=Math.max(minstep,Math.pow(base,Math.round(Math.log(span)/logb)-level));while(Math.ceil(span/step)>maxb){step*=base}for(i=0,n=div.length;i<n;++i){v=step/div[i];if(v>=minstep&&span/v<=maxb)step=v}}v=Math.log(step);const precision=v>=0?0:~~(-v/logb)+1,eps=Math.pow(base,-precision-1);if(_.nice||_.nice===undefined){v=Math.floor(min/step+eps)*step;min=min<v?v-step:v;max=Math.ceil(max/step)*step}return{start:min,stop:max===min?min+step:max,step:step}}exports.random=Math.random;function setRandom(r){exports.random=r}function bootstrapCI(array,samples,alpha,f){if(!array.length)return[undefined,undefined];const values=Float64Array.from(numbers(array,f)),n=values.length,m=samples;let a,i,j,mu;for(j=0,mu=Array(m);j<m;++j){for(a=0,i=0;i<n;++i){a+=values[~~(exports.random()*n)]}mu[j]=a/n}mu.sort(d3Array.ascending);return[d3Array.quantile(mu,alpha/2),d3Array.quantile(mu,1-alpha/2)]}function dotbin(array,step,smooth,f){f=f||(_=>_);const n=array.length,v=new Float64Array(n);let i=0,j=1,a=f(array[0]),b=a,w=a+step,x;for(;j<n;++j){x=f(array[j]);if(x>=w){b=(a+b)/2;for(;i<j;++i)v[i]=b;w=x+step;a=x}b=x}b=(a+b)/2;for(;i<j;++i)v[i]=b;return smooth?smoothing(v,step+step/4):v}function smoothing(v,thresh){const n=v.length;let a=0,b=1,c,d;while(v[a]===v[b])++b;while(b<n){c=b+1;while(v[b]===v[c])++c;if(v[b]-v[b-1]<thresh){d=b+(a+c-b-b>>1);while(d<b)v[d++]=v[b];while(d>b)v[d--]=v[a]}a=b;b=c}return v}function lcg(seed){return function(){seed=(1103515245*seed+12345)%2147483647;return seed/2147483647}}function integer(min,max){if(max==null){max=min;min=0}let a,b,d;const dist={min(_){if(arguments.length){a=_||0;d=b-a;return dist}else{return a}},max(_){if(arguments.length){b=_||0;d=b-a;return dist}else{return b}},sample(){return a+Math.floor(d*exports.random())},pdf(x){return x===Math.floor(x)&&x>=a&&x<b?1/d:0},cdf(x){const v=Math.floor(x);return v<a?0:v>=b?1:(v-a+1)/d},icdf(p){return p>=0&&p<=1?a-1+Math.floor(p*d):NaN}};return dist.min(min).max(max)}const SQRT2PI=Math.sqrt(2*Math.PI);const SQRT2=Math.SQRT2;let nextSample=NaN;function sampleNormal(mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;let x=0,y=0,rds,c;if(nextSample===nextSample){x=nextSample;nextSample=NaN}else{do{x=exports.random()*2-1;y=exports.random()*2-1;rds=x*x+y*y}while(rds===0||rds>1);c=Math.sqrt(-2*Math.log(rds)/rds);x*=c;nextSample=y*c}return mean+x*stdev}function densityNormal(value,mean,stdev){stdev=stdev==null?1:stdev;const z=(value-(mean||0))/stdev;return Math.exp(-.5*z*z)/(stdev*SQRT2PI)}function cumulativeNormal(value,mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;const z=(value-mean)/stdev,Z=Math.abs(z);let cd;if(Z>37){cd=0}else{const exp=Math.exp(-Z*Z/2);let sum;if(Z<7.07106781186547){sum=.0352624965998911*Z+.700383064443688;sum=sum*Z+6.37396220353165;sum=sum*Z+33.912866078383;sum=sum*Z+112.079291497871;sum=sum*Z+221.213596169931;sum=sum*Z+220.206867912376;cd=exp*sum;sum=.0883883476483184*Z+1.75566716318264;sum=sum*Z+16.064177579207;sum=sum*Z+86.7807322029461;sum=sum*Z+296.564248779674;sum=sum*Z+637.333633378831;sum=sum*Z+793.826512519948;sum=sum*Z+440.413735824752;cd=cd/sum}else{sum=Z+.65;sum=Z+4/sum;sum=Z+3/sum;sum=Z+2/sum;sum=Z+1/sum;cd=exp/sum/2.506628274631}}return z>0?1-cd:cd}function quantileNormal(p,mean,stdev){if(p<0||p>1)return NaN;return(mean||0)+(stdev==null?1:stdev)*SQRT2*erfinv(2*p-1)}function erfinv(x){let w=-Math.log((1-x)*(1+x)),p;if(w<6.25){w-=3.125;p=-364441206401782e-35;p=-16850591381820166e-35+p*w;p=128584807152564e-32+p*w;p=11157877678025181e-33+p*w;p=-1333171662854621e-31+p*w;p=20972767875968562e-33+p*w;p=6637638134358324e-30+p*w;p=-4054566272975207e-29+p*w;p=-8151934197605472e-29+p*w;p=26335093153082323e-28+p*w;p=-12975133253453532e-27+p*w;p=-5415412054294628e-26+p*w;p=1.0512122733215323e-9+p*w;p=-4.112633980346984e-9+p*w;p=-2.9070369957882005e-8+p*w;p=4.2347877827932404e-7+p*w;p=-13654692000834679e-22+p*w;p=-13882523362786469e-21+p*w;p=.00018673420803405714+p*w;p=-.000740702534166267+p*w;p=-.006033670871430149+p*w;p=.24015818242558962+p*w;p=1.6536545626831027+p*w}else if(w<16){w=Math.sqrt(w)-3.25;p=2.2137376921775787e-9;p=9.075656193888539e-8+p*w;p=-2.7517406297064545e-7+p*w;p=1.8239629214389228e-8+p*w;p=15027403968909828e-22+p*w;p=-4013867526981546e-21+p*w;p=29234449089955446e-22+p*w;p=12475304481671779e-21+p*w;p=-47318229009055734e-21+p*w;p=6828485145957318e-20+p*w;p=24031110387097894e-21+p*w;p=-.0003550375203628475+p*w;p=.0009532893797373805+p*w;p=-.0016882755560235047+p*w;p=.002491442096107851+p*w;p=-.003751208507569241+p*w;p=.005370914553590064+p*w;p=1.0052589676941592+p*w;p=3.0838856104922208+p*w}else if(Number.isFinite(w)){w=Math.sqrt(w)-5;p=-27109920616438573e-27;p=-2.555641816996525e-10+p*w;p=1.5076572693500548e-9+p*w;p=-3.789465440126737e-9+p*w;p=7.61570120807834e-9+p*w;p=-1.496002662714924e-8+p*w;p=2.914795345090108e-8+p*w;p=-6.771199775845234e-8+p*w;p=2.2900482228026655e-7+p*w;p=-9.9298272942317e-7+p*w;p=4526062597223154e-21+p*w;p=-1968177810553167e-20+p*w;p=7599527703001776e-20+p*w;p=-.00021503011930044477+p*w;p=-.00013871931833623122+p*w;p=1.0103004648645344+p*w;p=4.849906401408584+p*w}else{p=Infinity}return p*x}function gaussian(mean,stdev){let mu,sigma;const dist={mean(_){if(arguments.length){mu=_||0;return dist}else{return mu}},stdev(_){if(arguments.length){sigma=_==null?1:_;return dist}else{return sigma}},sample:()=>sampleNormal(mu,sigma),pdf:value=>densityNormal(value,mu,sigma),cdf:value=>cumulativeNormal(value,mu,sigma),icdf:p=>quantileNormal(p,mu,sigma)};return dist.mean(mean).stdev(stdev)}function kde(support,bandwidth){const kernel=gaussian();let n=0;const dist={data(_){if(arguments.length){support=_;n=_?_.length:0;return dist.bandwidth(bandwidth)}else{return support}},bandwidth(_){if(!arguments.length)return bandwidth;bandwidth=_;if(!bandwidth&&support)bandwidth=estimateBandwidth(support);return dist},sample(){return support[~~(exports.random()*n)]+bandwidth*kernel.sample()},pdf(x){let y=0,i=0;for(;i<n;++i){y+=kernel.pdf((x-support[i])/bandwidth)}return y/bandwidth/n},cdf(x){let y=0,i=0;for(;i<n;++i){y+=kernel.cdf((x-support[i])/bandwidth)}return y/n},icdf(){throw Error("KDE icdf not supported.")}};return dist.data(support)}function sampleLogNormal(mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;return Math.exp(mean+sampleNormal()*stdev)}function densityLogNormal(value,mean,stdev){if(value<=0)return 0;mean=mean||0;stdev=stdev==null?1:stdev;const z=(Math.log(value)-mean)/stdev;return Math.exp(-.5*z*z)/(stdev*SQRT2PI*value)}function cumulativeLogNormal(value,mean,stdev){return cumulativeNormal(Math.log(value),mean,stdev)}function quantileLogNormal(p,mean,stdev){return Math.exp(quantileNormal(p,mean,stdev))}function lognormal(mean,stdev){let mu,sigma;const dist={mean(_){if(arguments.length){mu=_||0;return dist}else{return mu}},stdev(_){if(arguments.length){sigma=_==null?1:_;return dist}else{return sigma}},sample:()=>sampleLogNormal(mu,sigma),pdf:value=>densityLogNormal(value,mu,sigma),cdf:value=>cumulativeLogNormal(value,mu,sigma),icdf:p=>quantileLogNormal(p,mu,sigma)};return dist.mean(mean).stdev(stdev)}function mixture(dists,weights){let m=0,w;function normalize(x){const w=[];let sum=0,i;for(i=0;i<m;++i){sum+=w[i]=x[i]==null?1:+x[i]}for(i=0;i<m;++i){w[i]/=sum}return w}const dist={weights(_){if(arguments.length){w=normalize(weights=_||[]);return dist}return weights},distributions(_){if(arguments.length){if(_){m=_.length;dists=_}else{m=0;dists=[]}return dist.weights(weights)}return dists},sample(){const r=exports.random();let d=dists[m-1],v=w[0],i=0;for(;i<m-1;v+=w[++i]){if(r<v){d=dists[i];break}}return d.sample()},pdf(x){let p=0,i=0;for(;i<m;++i){p+=w[i]*dists[i].pdf(x)}return p},cdf(x){let p=0,i=0;for(;i<m;++i){p+=w[i]*dists[i].cdf(x)}return p},icdf(){throw Error("Mixture icdf not supported.")}};return dist.distributions(dists).weights(weights)}function sampleUniform(min,max){if(max==null){max=min==null?1:min;min=0}return min+(max-min)*exports.random()}function densityUniform(value,min,max){if(max==null){max=min==null?1:min;min=0}return value>=min&&value<=max?1/(max-min):0}function cumulativeUniform(value,min,max){if(max==null){max=min==null?1:min;min=0}return value<min?0:value>max?1:(value-min)/(max-min)}function quantileUniform(p,min,max){if(max==null){max=min==null?1:min;min=0}return p>=0&&p<=1?min+p*(max-min):NaN}function uniform(min,max){let a,b;const dist={min(_){if(arguments.length){a=_||0;return dist}else{return a}},max(_){if(arguments.length){b=_==null?1:_;return dist}else{return b}},sample:()=>sampleUniform(a,b),pdf:value=>densityUniform(value,a,b),cdf:value=>cumulativeUniform(value,a,b),icdf:p=>quantileUniform(p,a,b)};if(max==null){max=min==null?1:min;min=0}return dist.min(min).max(max)}function ols(uX,uY,uXY,uX2){const delta=uX2-uX*uX,slope=Math.abs(delta)<1e-24?0:(uXY-uX*uY)/delta,intercept=uY-slope*uX;return[intercept,slope]}function points(data,x,y,sort){data=data.filter(d=>{let u=x(d),v=y(d);return u!=null&&(u=+u)>=u&&v!=null&&(v=+v)>=v});if(sort){data.sort((a,b)=>x(a)-x(b))}const n=data.length,X=new Float64Array(n),Y=new Float64Array(n);let i=0,ux=0,uy=0,xv,yv,d;for(d of data){X[i]=xv=+x(d);Y[i]=yv=+y(d);++i;ux+=(xv-ux)/i;uy+=(yv-uy)/i}for(i=0;i<n;++i){X[i]-=ux;Y[i]-=uy}return[X,Y,ux,uy]}function visitPoints(data,x,y,callback){let i=-1,u,v;for(const d of data){u=x(d);v=y(d);if(u!=null&&(u=+u)>=u&&v!=null&&(v=+v)>=v){callback(u,v,++i)}}}function rSquared(data,x,y,uY,predict){let SSE=0,SST=0;visitPoints(data,x,y,(dx,dy)=>{const sse=dy-predict(dx),sst=dy-uY;SSE+=sse*sse;SST+=sst*sst});return 1-SSE/SST}function linear(data,x,y){let X=0,Y=0,XY=0,X2=0,n=0;visitPoints(data,x,y,(dx,dy)=>{++n;X+=(dx-X)/n;Y+=(dy-Y)/n;XY+=(dx*dy-XY)/n;X2+=(dx*dx-X2)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]+coef[1]*x;return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,Y,predict)}}function log(data,x,y){let X=0,Y=0,XY=0,X2=0,n=0;visitPoints(data,x,y,(dx,dy)=>{++n;dx=Math.log(dx);X+=(dx-X)/n;Y+=(dy-Y)/n;XY+=(dx*dy-XY)/n;X2+=(dx*dx-X2)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]+coef[1]*Math.log(x);return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,Y,predict)}}function exp(data,x,y){const[xv,yv,ux,uy]=points(data,x,y);let YL=0,XY=0,XYL=0,X2Y=0,n=0,dx,ly,xy;visitPoints(data,x,y,(_,dy)=>{dx=xv[n++];ly=Math.log(dy);xy=dx*dy;YL+=(dy*ly-YL)/n;XY+=(xy-XY)/n;XYL+=(xy*ly-XYL)/n;X2Y+=(dx*xy-X2Y)/n});const[c0,c1]=ols(XY/uy,YL/uy,XYL/uy,X2Y/uy),predict=x=>Math.exp(c0+c1*(x-ux));return{coef:[Math.exp(c0-c1*ux),c1],predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function pow(data,x,y){let X=0,Y=0,XY=0,X2=0,YS=0,n=0;visitPoints(data,x,y,(dx,dy)=>{const lx=Math.log(dx),ly=Math.log(dy);++n;X+=(lx-X)/n;Y+=(ly-Y)/n;XY+=(lx*ly-XY)/n;X2+=(lx*lx-X2)/n;YS+=(dy-YS)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]*Math.pow(x,coef[1]);coef[0]=Math.exp(coef[0]);return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,YS,predict)}}function quad(data,x,y){const[xv,yv,ux,uy]=points(data,x,y),n=xv.length;let X2=0,X3=0,X4=0,XY=0,X2Y=0,i,dx,dy,x2;for(i=0;i<n;){dx=xv[i];dy=yv[i++];x2=dx*dx;X2+=(x2-X2)/i;X3+=(x2*dx-X3)/i;X4+=(x2*x2-X4)/i;XY+=(dx*dy-XY)/i;X2Y+=(x2*dy-X2Y)/i}const X2X2=X4-X2*X2,d=X2*X2X2-X3*X3,a=(X2Y*X2-XY*X3)/d,b=(XY*X2X2-X2Y*X3)/d,c=-a*X2,predict=x=>{x=x-ux;return a*x*x+b*x+c+uy};return{coef:[c-b*ux+a*ux*ux+uy,b-2*a*ux,a],predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function poly(data,x,y,order){if(order===1)return linear(data,x,y);if(order===2)return quad(data,x,y);const[xv,yv,ux,uy]=points(data,x,y),n=xv.length,lhs=[],rhs=[],k=order+1;let i,j,l,v,c;for(i=0;i<k;++i){for(l=0,v=0;l<n;++l){v+=Math.pow(xv[l],i)*yv[l]}lhs.push(v);c=new Float64Array(k);for(j=0;j<k;++j){for(l=0,v=0;l<n;++l){v+=Math.pow(xv[l],i+j)}c[j]=v}rhs.push(c)}rhs.push(lhs);const coef=gaussianElimination(rhs),predict=x=>{x-=ux;let y=uy+coef[0]+coef[1]*x+coef[2]*x*x;for(i=3;i<k;++i)y+=coef[i]*Math.pow(x,i);return y};return{coef:uncenter(k,coef,-ux,uy),predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function uncenter(k,a,x,y){const z=Array(k);let i,j,v,c;for(i=0;i<k;++i)z[i]=0;for(i=k-1;i>=0;--i){v=a[i];c=1;z[i]+=v;for(j=1;j<=i;++j){c*=(i+1-j)/j;z[i-j]+=v*Math.pow(x,j)*c}}z[0]+=y;return z}function gaussianElimination(matrix){const n=matrix.length-1,coef=[];let i,j,k,r,t;for(i=0;i<n;++i){r=i;for(j=i+1;j<n;++j){if(Math.abs(matrix[i][j])>Math.abs(matrix[i][r])){r=j}}for(k=i;k<n+1;++k){t=matrix[k][i];matrix[k][i]=matrix[k][r];matrix[k][r]=t}for(j=i+1;j<n;++j){for(k=n;k>=i;k--){matrix[k][j]-=matrix[k][i]*matrix[i][j]/matrix[i][i]}}}for(j=n-1;j>=0;--j){t=0;for(k=j+1;k<n;++k){t+=matrix[k][j]*coef[k]}coef[j]=(matrix[n][j]-t)/matrix[j][j]}return coef}const maxiters=2,epsilon=1e-12;function loess(data,x,y,bandwidth){const[xv,yv,ux,uy]=points(data,x,y,true),n=xv.length,bw=Math.max(2,~~(bandwidth*n)),yhat=new Float64Array(n),residuals=new Float64Array(n),robustWeights=new Float64Array(n).fill(1);for(let iter=-1;++iter<=maxiters;){const interval=[0,bw-1];for(let i=0;i<n;++i){const dx=xv[i],i0=interval[0],i1=interval[1],edge=dx-xv[i0]>xv[i1]-dx?i0:i1;let W=0,X=0,Y=0,XY=0,X2=0;const denom=1/Math.abs(xv[edge]-dx||1);for(let k=i0;k<=i1;++k){const xk=xv[k],yk=yv[k],w=tricube(Math.abs(dx-xk)*denom)*robustWeights[k],xkw=xk*w;W+=w;X+=xkw;Y+=yk*w;XY+=yk*xkw;X2+=xk*xkw}const[a,b]=ols(X/W,Y/W,XY/W,X2/W);yhat[i]=a+b*dx;residuals[i]=Math.abs(yv[i]-yhat[i]);updateInterval(xv,i+1,interval)}if(iter===maxiters){break}const medianResidual=d3Array.median(residuals);if(Math.abs(medianResidual)<epsilon)break;for(let i=0,arg,w;i<n;++i){arg=residuals[i]/(6*medianResidual);robustWeights[i]=arg>=1?epsilon:(w=1-arg*arg)*w}}return output(xv,yhat,ux,uy)}function tricube(x){return(x=1-x*x*x)*x*x}function updateInterval(xv,i,interval){const val=xv[i];let left=interval[0],right=interval[1]+1;if(right>=xv.length)return;while(i>left&&xv[right]-val<=val-xv[left]){interval[0]=++left;interval[1]=right;++right}}function output(xv,yhat,ux,uy){const n=xv.length,out=[];let i=0,cnt=0,prev=[],v;for(;i<n;++i){v=xv[i]+ux;if(prev[0]===v){prev[1]+=(yhat[i]-prev[1])/++cnt}else{cnt=0;prev[1]+=uy;prev=[v,yhat[i]];out.push(prev)}}prev[1]+=uy;return out}const MIN_RADIANS=.1*Math.PI/180;function sampleCurve(f,extent,minSteps,maxSteps){minSteps=minSteps||25;maxSteps=Math.max(minSteps,maxSteps||200);const point=x=>[x,f(x)],minX=extent[0],maxX=extent[1],span=maxX-minX,stop=span/maxSteps,prev=[point(minX)],next=[];if(minSteps===maxSteps){for(let i=1;i<maxSteps;++i){prev.push(point(minX+i/minSteps*span))}prev.push(point(maxX));return prev}else{next.push(point(maxX));for(let i=minSteps;--i>0;){next.push(point(minX+i/minSteps*span))}}let p0=prev[0],p1=next[next.length-1];while(p1){const pm=point((p0[0]+p1[0])/2);if(pm[0]-p0[0]>=stop&&angleDelta(p0,pm,p1)>MIN_RADIANS){next.push(pm)}else{p0=p1;prev.push(p1);next.pop()}p1=next[next.length-1]}return prev}function angleDelta(p,q,r){const a0=Math.atan2(r[1]-p[1],r[0]-p[0]),a1=Math.atan2(q[1]-p[1],q[0]-p[0]);return Math.abs(a0-a1)}exports.bandwidthNRD=estimateBandwidth;exports.bin=bin;exports.bootstrapCI=bootstrapCI;exports.cumulativeLogNormal=cumulativeLogNormal;exports.cumulativeNormal=cumulativeNormal;exports.cumulativeUniform=cumulativeUniform;exports.densityLogNormal=densityLogNormal;exports.densityNormal=densityNormal;exports.densityUniform=densityUniform;exports.dotbin=dotbin;exports.quantileLogNormal=quantileLogNormal;exports.quantileNormal=quantileNormal;exports.quantileUniform=quantileUniform;exports.quantiles=quantiles;exports.quartiles=quartiles;exports.randomInteger=integer;exports.randomKDE=kde;exports.randomLCG=lcg;exports.randomLogNormal=lognormal;exports.randomMixture=mixture;exports.randomNormal=gaussian;exports.randomUniform=uniform;exports.regressionExp=exp;exports.regressionLinear=linear;exports.regressionLoess=loess;exports.regressionLog=log;exports.regressionPoly=poly;exports.regressionPow=pow;exports.regressionQuad=quad;exports.sampleCurve=sampleCurve;exports.sampleLogNormal=sampleLogNormal;exports.sampleNormal=sampleNormal;exports.sampleUniform=sampleUniform;exports.setRandom=setRandom;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(74),__webpack_require__(99),__webpack_require__(103),__webpack_require__(47)):undefined})(this,(function(exports,vegaUtil,d3Array,$,$$1,vegaTime){"use strict";function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e){Object.keys(e).forEach((function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}}))}n["default"]=e;return Object.freeze(n)}var $__namespace=_interopNamespace($$1);function bandSpace(count,paddingInner,paddingOuter){const space=count-paddingInner+paddingOuter*2;return count?space>0?space:1:0}const Identity="identity";const Linear="linear";const Log="log";const Pow="pow";const Sqrt="sqrt";const Symlog="symlog";const Time="time";const UTC="utc";const Sequential="sequential";const Diverging="diverging";const Quantile="quantile";const Quantize="quantize";const Threshold="threshold";const Ordinal="ordinal";const Point="point";const Band="band";const BinOrdinal="bin-ordinal";const Continuous="continuous";const Discrete="discrete";const Discretizing="discretizing";const Interpolating="interpolating";const Temporal="temporal";function invertRange(scale){return function(_){let lo=_[0],hi=_[1],t;if(hi<lo){t=lo;lo=hi;hi=t}return[scale.invert(lo),scale.invert(hi)]}}function invertRangeExtent(scale){return function(_){const range=scale.range();let lo=_[0],hi=_[1],min=-1,max,t,i,n;if(hi<lo){t=lo;lo=hi;hi=t}for(i=0,n=range.length;i<n;++i){if(range[i]>=lo&&range[i]<=hi){if(min<0)min=i;max=i}}if(min<0)return undefined;lo=scale.invertExtent(range[min]);hi=scale.invertExtent(range[max]);return[lo[0]===undefined?lo[1]:lo[0],hi[1]===undefined?hi[0]:hi[1]]}}function band(){const scale=$.scaleOrdinal().unknown(undefined),domain=scale.domain,ordinalRange=scale.range;let range=[0,1],step,bandwidth,round=false,paddingInner=0,paddingOuter=0,align=.5;delete scale.unknown;function rescale(){const n=domain().length,reverse=range[1]<range[0],stop=range[1-reverse],space=bandSpace(n,paddingInner,paddingOuter);let start=range[reverse-0];step=(stop-start)/(space||1);if(round){step=Math.floor(step)}start+=(stop-start-step*(n-paddingInner))*align;bandwidth=step*(1-paddingInner);if(round){start=Math.round(start);bandwidth=Math.round(bandwidth)}const values=d3Array.range(n).map(i=>start+step*i);return ordinalRange(reverse?values.reverse():values)}scale.domain=function(_){if(arguments.length){domain(_);return rescale()}else{return domain()}};scale.range=function(_){if(arguments.length){range=[+_[0],+_[1]];return rescale()}else{return range.slice()}};scale.rangeRound=function(_){range=[+_[0],+_[1]];round=true;return rescale()};scale.bandwidth=function(){return bandwidth};scale.step=function(){return step};scale.round=function(_){if(arguments.length){round=!!_;return rescale()}else{return round}};scale.padding=function(_){if(arguments.length){paddingOuter=Math.max(0,Math.min(1,_));paddingInner=paddingOuter;return rescale()}else{return paddingInner}};scale.paddingInner=function(_){if(arguments.length){paddingInner=Math.max(0,Math.min(1,_));return rescale()}else{return paddingInner}};scale.paddingOuter=function(_){if(arguments.length){paddingOuter=Math.max(0,Math.min(1,_));return rescale()}else{return paddingOuter}};scale.align=function(_){if(arguments.length){align=Math.max(0,Math.min(1,_));return rescale()}else{return align}};scale.invertRange=function(_){if(_[0]==null||_[1]==null)return;const reverse=range[1]<range[0],values=reverse?ordinalRange().reverse():ordinalRange(),n=values.length-1;let lo=+_[0],hi=+_[1],a,b,t;if(lo!==lo||hi!==hi)return;if(hi<lo){t=lo;lo=hi;hi=t}if(hi<values[0]||lo>range[1-reverse])return;a=Math.max(0,d3Array.bisectRight(values,lo)-1);b=lo===hi?a:d3Array.bisectRight(values,hi)-1;if(lo-values[a]>bandwidth+1e-10)++a;if(reverse){t=a;a=n-b;b=n-t}return a>b?undefined:domain().slice(a,b+1)};scale.invert=function(_){const value=scale.invertRange([_,_]);return value?value[0]:value};scale.copy=function(){return band().domain(domain()).range(range).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align)};return rescale()}function pointish(scale){const copy=scale.copy;scale.padding=scale.paddingOuter;delete scale.paddingInner;scale.copy=function(){return pointish(copy())};return scale}function point(){return pointish(band().paddingInner(1))}var map=Array.prototype.map;function numbers(_){return map.call(_,vegaUtil.toNumber)}const slice=Array.prototype.slice;function scaleBinOrdinal(){let domain=[],range=[];function scale(x){return x==null||x!==x?undefined:range[(d3Array.bisect(domain,x)-1)%range.length]}scale.domain=function(_){if(arguments.length){domain=numbers(_);return scale}else{return domain.slice()}};scale.range=function(_){if(arguments.length){range=slice.call(_);return scale}else{return range.slice()}};scale.tickFormat=function(count,specifier){return $.tickFormat(domain[0],vegaUtil.peek(domain),count==null?10:count,specifier)};scale.copy=function(){return scaleBinOrdinal().domain(scale.domain()).range(scale.range())};return scale}const scales={};function create(type,constructor,metadata){const ctr=function scale(){const s=constructor();if(!s.invertRange){s.invertRange=s.invert?invertRange(s):s.invertExtent?invertRangeExtent(s):undefined}s.type=type;return s};ctr.metadata=vegaUtil.toSet(vegaUtil.array(metadata));return ctr}function scale(type,scale,metadata){if(arguments.length>1){scales[type]=create(type,scale,metadata);return this}else{return isValidScaleType(type)?scales[type]:undefined}}scale(Identity,$.scaleIdentity);scale(Linear,$.scaleLinear,Continuous);scale(Log,$.scaleLog,[Continuous,Log]);scale(Pow,$.scalePow,Continuous);scale(Sqrt,$.scaleSqrt,Continuous);scale(Symlog,$.scaleSymlog,Continuous);scale(Time,$.scaleTime,[Continuous,Temporal]);scale(UTC,$.scaleUtc,[Continuous,Temporal]);scale(Sequential,$.scaleSequential,[Continuous,Interpolating]);scale(`${Sequential}-${Linear}`,$.scaleSequential,[Continuous,Interpolating]);scale(`${Sequential}-${Log}`,$.scaleSequentialLog,[Continuous,Interpolating,Log]);scale(`${Sequential}-${Pow}`,$.scaleSequentialPow,[Continuous,Interpolating]);scale(`${Sequential}-${Sqrt}`,$.scaleSequentialSqrt,[Continuous,Interpolating]);scale(`${Sequential}-${Symlog}`,$.scaleSequentialSymlog,[Continuous,Interpolating]);scale(`${Diverging}-${Linear}`,$.scaleDiverging,[Continuous,Interpolating]);scale(`${Diverging}-${Log}`,$.scaleDivergingLog,[Continuous,Interpolating,Log]);scale(`${Diverging}-${Pow}`,$.scaleDivergingPow,[Continuous,Interpolating]);scale(`${Diverging}-${Sqrt}`,$.scaleDivergingSqrt,[Continuous,Interpolating]);scale(`${Diverging}-${Symlog}`,$.scaleDivergingSymlog,[Continuous,Interpolating]);scale(Quantile,$.scaleQuantile,[Discretizing,Quantile]);scale(Quantize,$.scaleQuantize,Discretizing);scale(Threshold,$.scaleThreshold,Discretizing);scale(BinOrdinal,scaleBinOrdinal,[Discrete,Discretizing]);scale(Ordinal,$.scaleOrdinal,Discrete);scale(Band,band,Discrete);scale(Point,point,Discrete);function isValidScaleType(type){return vegaUtil.hasOwnProperty(scales,type)}function hasType(key,type){const s=scales[key];return s&&s.metadata[type]}function isContinuous(key){return hasType(key,Continuous)}function isDiscrete(key){return hasType(key,Discrete)}function isDiscretizing(key){return hasType(key,Discretizing)}function isLogarithmic(key){return hasType(key,Log)}function isTemporal(key){return hasType(key,Temporal)}function isInterpolating(key){return hasType(key,Interpolating)}function isQuantile(key){return hasType(key,Quantile)}const scaleProps=["clamp","base","constant","exponent"];function interpolateRange(interpolator,range){const start=range[0],span=vegaUtil.peek(range)-start;return function(i){return interpolator(start+i*span)}}function interpolateColors(colors,type,gamma){return $$1.piecewise(interpolate(type||"rgb",gamma),colors)}function quantizeInterpolator(interpolator,count){const samples=new Array(count),n=count+1;for(let i=0;i<count;)samples[i]=interpolator(++i/n);return samples}function scaleCopy(scale){const t=scale.type,s=scale.copy();s.type=t;return s}function scaleFraction(scale$1,min,max){const delta=max-min;let i,t,s;if(!delta||!Number.isFinite(delta)){return vegaUtil.constant(.5)}else{i=(t=scale$1.type).indexOf("-");t=i<0?t:t.slice(i+1);s=scale(t)().domain([min,max]).range([0,1]);scaleProps.forEach(m=>scale$1[m]?s[m](scale$1[m]()):0);return s}}function interpolate(type,gamma){const interp=$__namespace[method(type)];return gamma!=null&&interp&&interp.gamma?interp.gamma(gamma):interp}function method(type){return"interpolate"+type.toLowerCase().split("-").map(s=>s[0].toUpperCase()+s.slice(1)).join("")}const continuous={blues:"cfe1f2bed8eca8cee58fc1de74b2d75ba3cf4592c63181bd206fb2125ca40a4a90",greens:"d3eecdc0e6baabdda594d3917bc77d60ba6c46ab5e329a512089430e7735036429",greys:"e2e2e2d4d4d4c4c4c4b1b1b19d9d9d8888887575756262624d4d4d3535351e1e1e",oranges:"fdd8b3fdc998fdb87bfda55efc9244f87f2cf06b18e4580bd14904b93d029f3303",purples:"e2e1efd4d4e8c4c5e0b4b3d6a3a0cc928ec3827cb97566ae684ea25c3696501f8c",reds:"fdc9b4fcb49afc9e80fc8767fa7051f6573fec3f2fdc2a25c81b1db21218970b13",blueGreen:"d5efedc1e8e0a7ddd18bd2be70c6a958ba9144ad77319c5d2089460e7736036429",bluePurple:"ccddecbad0e4a8c2dd9ab0d4919cc98d85be8b6db28a55a6873c99822287730f71",greenBlue:"d3eecec5e8c3b1e1bb9bd8bb82cec269c2ca51b2cd3c9fc7288abd1675b10b60a1",orangeRed:"fddcaffdcf9bfdc18afdad77fb9562f67d53ee6545e24932d32d1ebf130da70403",purpleBlue:"dbdaebc8cee4b1c3de97b7d87bacd15b9fc93a90c01e7fb70b70ab056199045281",purpleBlueGreen:"dbd8eac8cee4b0c3de93b7d872acd1549fc83892bb1c88a3097f8702736b016353",purpleRed:"dcc9e2d3b3d7ce9eccd186c0da6bb2e14da0e23189d91e6fc61159ab07498f023a",redPurple:"fccfccfcbec0faa9b8f98faff571a5ec539ddb3695c41b8aa908808d0179700174",yellowGreen:"e4f4acd1eca0b9e2949ed68880c97c62bb6e47aa5e3297502083440e723b036034",yellowOrangeBrown:"feeaa1fedd84fecc63feb746fca031f68921eb7215db5e0bc54c05ab3d038f3204",yellowOrangeRed:"fee087fed16ffebd59fea849fd903efc7335f9522bee3423de1b20ca0b22af0225",blueOrange:"134b852f78b35da2cb9dcae1d2e5eff2f0ebfce0bafbbf74e8932fc5690d994a07",brownBlueGreen:"704108a0651ac79548e3c78af3e6c6eef1eac9e9e48ed1c74da79e187a72025147",purpleGreen:"5b1667834792a67fb6c9aed3e6d6e8eff0efd9efd5aedda971bb75368e490e5e29",purpleOrange:"4114696647968f83b7b9b4d6dadbebf3eeeafce0bafbbf74e8932fc5690d994a07",redBlue:"8c0d25bf363adf745ef4ae91fbdbc9f2efeed2e5ef9dcae15da2cb2f78b3134b85",redGrey:"8c0d25bf363adf745ef4ae91fcdccbfaf4f1e2e2e2c0c0c0969696646464343434",yellowGreenBlue:"eff9bddbf1b4bde5b594d5b969c5be45b4c22c9ec02182b82163aa23479c1c3185",redYellowBlue:"a50026d4322cf16e43fcac64fedd90faf8c1dcf1ecabd6e875abd04a74b4313695",redYellowGreen:"a50026d4322cf16e43fcac63fedd8df9f7aed7ee8ea4d86e64bc6122964f006837",pinkYellowGreen:"8e0152c0267edd72adf0b3d6faddedf5f3efe1f2cab6de8780bb474f9125276419",spectral:"9e0142d13c4bf0704afcac63fedd8dfbf8b0e0f3a1a9dda269bda94288b55e4fa2",viridis:"440154470e61481a6c482575472f7d443a834144873d4e8a39568c35608d31688e2d708e2a788e27818e23888e21918d1f988b1fa08822a8842ab07f35b77943bf7154c56866cc5d7ad1518fd744a5db36bcdf27d2e21be9e51afde725",magma:"0000040404130b0924150e3720114b2c11603b0f704a107957157e651a80721f817f24828c29819a2e80a8327db6377ac43c75d1426fde4968e95462f1605df76f5cfa7f5efc8f65fe9f6dfeaf78febf84fece91fddea0fcedaffcfdbf",inferno:"0000040403130c0826170c3b240c4f330a5f420a68500d6c5d126e6b176e781c6d86216b932667a12b62ae305cbb3755c73e4cd24644dd513ae65c30ed6925f3771af8850ffb9506fca50afcb519fac62df6d645f2e661f3f484fcffa4",plasma:"0d088723069033059742039d5002a25d01a66a00a87801a88405a7900da49c179ea72198b12a90ba3488c33d80cb4779d35171da5a69e16462e76e5bed7953f2834cf68f44fa9a3dfca636fdb32ffec029fcce25f9dc24f5ea27f0f921",cividis:"00205100235800265d002961012b65042e670831690d346b11366c16396d1c3c6e213f6e26426e2c456e31476e374a6e3c4d6e42506e47536d4c566d51586e555b6e5a5e6e5e616e62646f66676f6a6a706e6d717270717573727976737c79747f7c75827f758682768985778c8877908b78938e789691789a94789e9778a19b78a59e77a9a177aea575b2a874b6ab73bbaf71c0b26fc5b66dc9b96acebd68d3c065d8c462ddc85fe2cb5ce7cf58ebd355f0d652f3da4ff7de4cfae249fce647",rainbow:"6e40aa883eb1a43db3bf3cafd83fa4ee4395fe4b83ff576eff6659ff7847ff8c38f3a130e2b72fcfcc36bee044aff05b8ff4576ff65b52f6673af27828ea8d1ddfa319d0b81cbecb23abd82f96e03d82e14c6edb5a5dd0664dbf6e40aa",sinebow:"ff4040fc582af47218e78d0bd5a703bfbf00a7d5038de70b72f41858fc2a40ff402afc5818f4720be78d03d5a700bfbf03a7d50b8de71872f42a58fc4040ff582afc7218f48d0be7a703d5bf00bfd503a7e70b8df41872fc2a58ff4040",turbo:"23171b32204a3e2a71453493493eae4b49c54a53d7485ee44569ee4074f53c7ff8378af93295f72e9ff42ba9ef28b3e926bce125c5d925cdcf27d5c629dcbc2de3b232e9a738ee9d3ff39347f68950f9805afc7765fd6e70fe667cfd5e88fc5795fb51a1f84badf545b9f140c5ec3cd0e637dae034e4d931ecd12ef4c92bfac029ffb626ffad24ffa223ff9821ff8d1fff821dff771cfd6c1af76118f05616e84b14df4111d5380fcb2f0dc0260ab61f07ac1805a313029b0f00950c00910b00",browns:"eedbbdecca96e9b97ae4a865dc9856d18954c7784cc0673fb85536ad44339f3632",tealBlues:"bce4d89dd3d181c3cb65b3c245a2b9368fae347da0306a932c5985",teals:"bbdfdfa2d4d58ac9c975bcbb61b0af4da5a43799982b8b8c1e7f7f127273006667",warmGreys:"dcd4d0cec5c1c0b8b4b3aaa7a59c9998908c8b827f7e7673726866665c5a59504e",goldGreen:"f4d166d5ca60b6c35c98bb597cb25760a6564b9c533f8f4f33834a257740146c36",goldOrange:"f4d166f8be5cf8aa4cf5983bf3852aef701be2621fd65322c54923b142239e3a26",goldRed:"f4d166f6be59f9aa51fc964ef6834bee734ae56249db5247cf4244c43141b71d3e",lightGreyRed:"efe9e6e1dad7d5cbc8c8bdb9bbaea9cd967ddc7b43e15f19df4011dc000b",lightGreyTeal:"e4eaead6dcddc8ced2b7c2c7a6b4bc64b0bf22a6c32295c11f85be1876bc",lightMulti:"e0f1f2c4e9d0b0de9fd0e181f6e072f6c053f3993ef77440ef4a3c",lightOrange:"f2e7daf7d5baf9c499fab184fa9c73f68967ef7860e8645bde515bd43d5b",lightTealBlue:"e3e9e0c0dccf9aceca7abfc859afc0389fb9328dad2f7ca0276b95255988",darkBlue:"3232322d46681a5c930074af008cbf05a7ce25c0dd38daed50f3faffffff",darkGold:"3c3c3c584b37725e348c7631ae8b2bcfa424ecc31ef9de30fff184ffffff",darkGreen:"3a3a3a215748006f4d048942489e4276b340a6c63dd2d836ffeb2cffffaa",darkMulti:"3737371f5287197d8c29a86995ce3fffe800ffffff",darkRed:"3434347036339e3c38cc4037e75d1eec8620eeab29f0ce32ffeb2c"};const discrete={category10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf",category20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",category20b:"393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6",category20c:"3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9",tableau10:"4c78a8f58518e4575672b7b254a24beeca3bb279a2ff9da69d755dbab0ac",tableau20:"4c78a89ecae9f58518ffbf7954a24b88d27ab79a20f2cf5b43989483bcb6e45756ff9d9879706ebab0acd67195fcbfd2b279a2d6a5c99e765fd8b5a5",accent:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666",dark2:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666",paired:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928",pastel1:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2",pastel2:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc",set1:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999",set2:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3",set3:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"};function colors(palette){const n=palette.length/6|0,c=new Array(n);for(let i=0;i<n;){c[i]="#"+palette.slice(i*6,++i*6)}return c}function apply(_,f){for(const k in _)scheme(k,f(_[k]))}const schemes={};apply(discrete,colors);apply(continuous,_=>interpolateColors(colors(_)));function scheme(name,scheme){name=name&&name.toLowerCase();if(arguments.length>1){schemes[name]=scheme;return this}else{return schemes[name]}}const SymbolLegend="symbol";const DiscreteLegend="discrete";const GradientLegend="gradient";const defaultFormatter=value=>vegaUtil.isArray(value)?value.map(v=>String(v)):String(value);const ascending=(a,b)=>a[1]-b[1];const descending=(a,b)=>b[1]-a[1];function tickCount(scale,count,minStep){let step;if(vegaUtil.isNumber(count)){if(scale.bins){count=Math.max(count,scale.bins.length)}if(minStep!=null){count=Math.min(count,Math.floor(vegaUtil.span(scale.domain())/minStep||1))}}if(vegaUtil.isObject(count)){step=count.step;count=count.interval}if(vegaUtil.isString(count)){count=scale.type===Time?vegaTime.timeInterval(count):scale.type==UTC?vegaTime.utcInterval(count):vegaUtil.error("Only time and utc scales accept interval strings.");if(step)count=count.every(step)}return count}function validTicks(scale,ticks,count){let range=scale.range(),lo=range[0],hi=vegaUtil.peek(range),cmp=ascending;if(lo>hi){range=hi;hi=lo;lo=range;cmp=descending}lo=Math.floor(lo);hi=Math.ceil(hi);ticks=ticks.map(v=>[v,scale(v)]).filter(_=>lo<=_[1]&&_[1]<=hi).sort(cmp).map(_=>_[0]);if(count>0&&ticks.length>1){const endpoints=[ticks[0],vegaUtil.peek(ticks)];while(ticks.length>count&&ticks.length>=3){ticks=ticks.filter((_,i)=>!(i%2))}if(ticks.length<3){ticks=endpoints}}return ticks}function tickValues(scale,count){return scale.bins?validTicks(scale,scale.bins):scale.ticks?scale.ticks(count):scale.domain()}function tickFormat(locale,scale,count,specifier,formatType,noSkip){const type=scale.type;let format=defaultFormatter;if(type===Time||formatType===Time){format=locale.timeFormat(specifier)}else if(type===UTC||formatType===UTC){format=locale.utcFormat(specifier)}else if(isLogarithmic(type)){const varfmt=locale.formatFloat(specifier);if(noSkip||scale.bins){format=varfmt}else{const test=tickLog(scale,count,false);format=_=>test(_)?varfmt(_):""}}else if(scale.tickFormat){const d=scale.domain();format=locale.formatSpan(d[0],d[d.length-1],count,specifier)}else if(specifier){format=locale.format(specifier)}return format}function tickLog(scale,count,values){const ticks=tickValues(scale,count),base=scale.base(),logb=Math.log(base),k=Math.max(1,base*count/ticks.length);const test=d=>{let i=d/Math.pow(base,Math.round(Math.log(d)/logb));if(i*base<base-.5)i*=base;return i<=k};return values?ticks.filter(test):test}const symbols={[Quantile]:"quantiles",[Quantize]:"thresholds",[Threshold]:"domain"};const formats={[Quantile]:"quantiles",[Quantize]:"domain"};function labelValues(scale,count){return scale.bins?binValues(scale.bins):scale.type===Log?tickLog(scale,count,true):symbols[scale.type]?thresholdValues(scale[symbols[scale.type]]()):tickValues(scale,count)}function thresholdFormat(locale,scale,specifier){const _=scale[formats[scale.type]](),n=_.length;let d=n>1?_[1]-_[0]:_[0],i;for(i=1;i<n;++i){d=Math.min(d,_[i]-_[i-1])}return locale.formatSpan(0,d,3*10,specifier)}function thresholdValues(thresholds){const values=[-Infinity].concat(thresholds);values.max=+Infinity;return values}function binValues(bins){const values=bins.slice(0,-1);values.max=vegaUtil.peek(bins);return values}const isDiscreteRange=scale=>symbols[scale.type]||scale.bins;function labelFormat(locale,scale,count,type,specifier,formatType,noSkip){const format=formats[scale.type]&&formatType!==Time&&formatType!==UTC?thresholdFormat(locale,scale,specifier):tickFormat(locale,scale,count,specifier,formatType,noSkip);return type===SymbolLegend&&isDiscreteRange(scale)?formatRange(format):type===DiscreteLegend?formatDiscrete(format):formatPoint(format)}const formatRange=format=>(value,index,array)=>{const limit=get(array[index+1],get(array.max,+Infinity)),lo=formatValue(value,format),hi=formatValue(limit,format);return lo&&hi?lo+" – "+hi:hi?"< "+hi:"≥ "+lo};const get=(value,dflt)=>value!=null?value:dflt;const formatDiscrete=format=>(value,index)=>index?format(value):null;const formatPoint=format=>value=>format(value);const formatValue=(value,format)=>Number.isFinite(value)?format(value):null;function labelFraction(scale){const domain=scale.domain(),count=domain.length-1;let lo=+domain[0],hi=+vegaUtil.peek(domain),span=hi-lo;if(scale.type===Threshold){const adjust=count?span/count:.1;lo-=adjust;hi+=adjust;span=hi-lo}return value=>(value-lo)/span}function format(locale,scale,specifier,formatType){const type=formatType||scale.type;if(vegaUtil.isString(specifier)&&isTemporal(type)){specifier=specifier.replace(/%a/g,"%A").replace(/%b/g,"%B")}return!specifier&&type===Time?locale.timeFormat("%A, %d %B %Y, %X"):!specifier&&type===UTC?locale.utcFormat("%A, %d %B %Y, %X UTC"):labelFormat(locale,scale,5,null,specifier,formatType,true)}function domainCaption(locale,scale,opt){opt=opt||{};const max=Math.max(3,opt.maxlen||7),fmt=format(locale,scale,opt.format,opt.formatType);if(isDiscretizing(scale.type)){const v=labelValues(scale).slice(1).map(fmt),n=v.length;return`${n} boundar${n===1?"y":"ies"}: ${v.join(", ")}`}else if(isDiscrete(scale.type)){const d=scale.domain(),n=d.length,v=n>max?d.slice(0,max-2).map(fmt).join(", ")+", ending with "+d.slice(-1).map(fmt):d.map(fmt).join(", ");return`${n} value${n===1?"":"s"}: ${v}`}else{const d=scale.domain();return`values from ${fmt(d[0])} to ${fmt(vegaUtil.peek(d))}`}}Object.defineProperty(exports,"scaleImplicit",{enumerable:true,get:function(){return $.scaleImplicit}});exports.Band=Band;exports.BinOrdinal=BinOrdinal;exports.DiscreteLegend=DiscreteLegend;exports.Diverging=Diverging;exports.GradientLegend=GradientLegend;exports.Identity=Identity;exports.Linear=Linear;exports.Log=Log;exports.Ordinal=Ordinal;exports.Point=Point;exports.Pow=Pow;exports.Quantile=Quantile;exports.Quantize=Quantize;exports.Sequential=Sequential;exports.Sqrt=Sqrt;exports.SymbolLegend=SymbolLegend;exports.Symlog=Symlog;exports.Threshold=Threshold;exports.Time=Time;exports.UTC=UTC;exports.bandSpace=bandSpace;exports.domainCaption=domainCaption;exports.interpolate=interpolate;exports.interpolateColors=interpolateColors;exports.interpolateRange=interpolateRange;exports.isContinuous=isContinuous;exports.isDiscrete=isDiscrete;exports.isDiscretizing=isDiscretizing;exports.isInterpolating=isInterpolating;exports.isLogarithmic=isLogarithmic;exports.isQuantile=isQuantile;exports.isTemporal=isTemporal;exports.isValidScaleType=isValidScaleType;exports.labelFormat=labelFormat;exports.labelFraction=labelFraction;exports.labelValues=labelValues;exports.quantizeInterpolator=quantizeInterpolator;exports.scale=scale;exports.scaleCopy=scaleCopy;exports.scaleFraction=scaleFraction;exports.scheme=scheme;exports.tickCount=tickCount;exports.tickFormat=tickFormat;exports.tickValues=tickValues;exports.validTicks=validTicks;Object.defineProperty(exports,"__esModule",{value:true})}))},,,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(91),__webpack_require__(92)):undefined})(this,(function(exports,vegaUtil,d3Time,d3Array){"use strict";const YEAR="year";const QUARTER="quarter";const MONTH="month";const WEEK="week";const DATE="date";const DAY="day";const DAYOFYEAR="dayofyear";const HOURS="hours";const MINUTES="minutes";const SECONDS="seconds";const MILLISECONDS="milliseconds";const TIME_UNITS=[YEAR,QUARTER,MONTH,WEEK,DATE,DAY,DAYOFYEAR,HOURS,MINUTES,SECONDS,MILLISECONDS];const UNITS=TIME_UNITS.reduce((o,u,i)=>(o[u]=1+i,o),{});function timeUnits(units){const u=vegaUtil.array(units).slice(),m={};if(!u.length)vegaUtil.error("Missing time unit.");u.forEach(unit=>{if(vegaUtil.hasOwnProperty(UNITS,unit)){m[unit]=1}else{vegaUtil.error(`Invalid time unit: ${unit}.`)}});const numTypes=(m[WEEK]||m[DAY]?1:0)+(m[QUARTER]||m[MONTH]||m[DATE]?1:0)+(m[DAYOFYEAR]?1:0);if(numTypes>1){vegaUtil.error(`Incompatible time units: ${units}`)}u.sort((a,b)=>UNITS[a]-UNITS[b]);return u}const defaultSpecifiers={[YEAR]:"%Y ",[QUARTER]:"Q%q ",[MONTH]:"%b ",[DATE]:"%d ",[WEEK]:"W%U ",[DAY]:"%a ",[DAYOFYEAR]:"%j ",[HOURS]:"%H:00",[MINUTES]:"00:%M",[SECONDS]:":%S",[MILLISECONDS]:".%L",[`${YEAR}-${MONTH}`]:"%Y-%m ",[`${YEAR}-${MONTH}-${DATE}`]:"%Y-%m-%d ",[`${HOURS}-${MINUTES}`]:"%H:%M"};function timeUnitSpecifier(units,specifiers){const s=vegaUtil.extend({},defaultSpecifiers,specifiers),u=timeUnits(units),n=u.length;let fmt="",start=0,end,key;for(start=0;start<n;){for(end=u.length;end>start;--end){key=u.slice(start,end).join("-");if(s[key]!=null){fmt+=s[key];start=end;break}}}return fmt.trim()}const t0=new Date;function localYear(y){t0.setFullYear(y);t0.setMonth(0);t0.setDate(1);t0.setHours(0,0,0,0);return t0}function dayofyear(d){return localDayOfYear(new Date(d))}function week(d){return localWeekNum(new Date(d))}function localDayOfYear(d){return d3Time.timeDay.count(localYear(d.getFullYear())-1,d)}function localWeekNum(d){return d3Time.timeWeek.count(localYear(d.getFullYear())-1,d)}function localFirst(y){return localYear(y).getDay()}function localDate(y,m,d,H,M,S,L){if(0<=y&&y<100){const date=new Date(-1,m,d,H,M,S,L);date.setFullYear(y);return date}return new Date(y,m,d,H,M,S,L)}function utcdayofyear(d){return utcDayOfYear(new Date(d))}function utcweek(d){return utcWeekNum(new Date(d))}function utcDayOfYear(d){const y=Date.UTC(d.getUTCFullYear(),0,1);return d3Time.utcDay.count(y-1,d)}function utcWeekNum(d){const y=Date.UTC(d.getUTCFullYear(),0,1);return d3Time.utcWeek.count(y-1,d)}function utcFirst(y){t0.setTime(Date.UTC(y,0,1));return t0.getUTCDay()}function utcDate(y,m,d,H,M,S,L){if(0<=y&&y<100){const date=new Date(Date.UTC(-1,m,d,H,M,S,L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(y,m,d,H,M,S,L))}function floor(units,step,get,inv,newDate){const s=step||1,b=vegaUtil.peek(units),_=(unit,p,key)=>{key=key||unit;return getUnit(get[key],inv[key],unit===b&&s,p)};const t=new Date,u=vegaUtil.toSet(units),y=u[YEAR]?_(YEAR):vegaUtil.constant(2012),m=u[MONTH]?_(MONTH):u[QUARTER]?_(QUARTER):vegaUtil.zero,d=u[WEEK]&&u[DAY]?_(DAY,1,WEEK+DAY):u[WEEK]?_(WEEK,1):u[DAY]?_(DAY,1):u[DATE]?_(DATE,1):u[DAYOFYEAR]?_(DAYOFYEAR,1):vegaUtil.one,H=u[HOURS]?_(HOURS):vegaUtil.zero,M=u[MINUTES]?_(MINUTES):vegaUtil.zero,S=u[SECONDS]?_(SECONDS):vegaUtil.zero,L=u[MILLISECONDS]?_(MILLISECONDS):vegaUtil.zero;return function(v){t.setTime(+v);const year=y(t);return newDate(year,m(t),d(t,year),H(t),M(t),S(t),L(t))}}function getUnit(f,inv,step,phase){const u=step<=1?f:phase?(d,y)=>phase+step*Math.floor((f(d,y)-phase)/step):(d,y)=>step*Math.floor(f(d,y)/step);return inv?(d,y)=>inv(u(d,y),y):u}function weekday(week,day,firstDay){return day+week*7-(firstDay+6)%7}const localGet={[YEAR]:d=>d.getFullYear(),[QUARTER]:d=>Math.floor(d.getMonth()/3),[MONTH]:d=>d.getMonth(),[DATE]:d=>d.getDate(),[HOURS]:d=>d.getHours(),[MINUTES]:d=>d.getMinutes(),[SECONDS]:d=>d.getSeconds(),[MILLISECONDS]:d=>d.getMilliseconds(),[DAYOFYEAR]:d=>localDayOfYear(d),[WEEK]:d=>localWeekNum(d),[WEEK+DAY]:(d,y)=>weekday(localWeekNum(d),d.getDay(),localFirst(y)),[DAY]:(d,y)=>weekday(1,d.getDay(),localFirst(y))};const localInv={[QUARTER]:q=>3*q,[WEEK]:(w,y)=>weekday(w,0,localFirst(y))};function timeFloor(units,step){return floor(units,step||1,localGet,localInv,localDate)}const utcGet={[YEAR]:d=>d.getUTCFullYear(),[QUARTER]:d=>Math.floor(d.getUTCMonth()/3),[MONTH]:d=>d.getUTCMonth(),[DATE]:d=>d.getUTCDate(),[HOURS]:d=>d.getUTCHours(),[MINUTES]:d=>d.getUTCMinutes(),[SECONDS]:d=>d.getUTCSeconds(),[MILLISECONDS]:d=>d.getUTCMilliseconds(),[DAYOFYEAR]:d=>utcDayOfYear(d),[WEEK]:d=>utcWeekNum(d),[DAY]:(d,y)=>weekday(1,d.getUTCDay(),utcFirst(y)),[WEEK+DAY]:(d,y)=>weekday(utcWeekNum(d),d.getUTCDay(),utcFirst(y))};const utcInv={[QUARTER]:q=>3*q,[WEEK]:(w,y)=>weekday(w,0,utcFirst(y))};function utcFloor(units,step){return floor(units,step||1,utcGet,utcInv,utcDate)}const timeIntervals={[YEAR]:d3Time.timeYear,[QUARTER]:d3Time.timeMonth.every(3),[MONTH]:d3Time.timeMonth,[WEEK]:d3Time.timeWeek,[DATE]:d3Time.timeDay,[DAY]:d3Time.timeDay,[DAYOFYEAR]:d3Time.timeDay,[HOURS]:d3Time.timeHour,[MINUTES]:d3Time.timeMinute,[SECONDS]:d3Time.timeSecond,[MILLISECONDS]:d3Time.timeMillisecond};const utcIntervals={[YEAR]:d3Time.utcYear,[QUARTER]:d3Time.utcMonth.every(3),[MONTH]:d3Time.utcMonth,[WEEK]:d3Time.utcWeek,[DATE]:d3Time.utcDay,[DAY]:d3Time.utcDay,[DAYOFYEAR]:d3Time.utcDay,[HOURS]:d3Time.utcHour,[MINUTES]:d3Time.utcMinute,[SECONDS]:d3Time.utcSecond,[MILLISECONDS]:d3Time.utcMillisecond};function timeInterval(unit){return timeIntervals[unit]}function utcInterval(unit){return utcIntervals[unit]}function offset(ival,date,step){return ival?ival.offset(date,step):undefined}function timeOffset(unit,date,step){return offset(timeInterval(unit),date,step)}function utcOffset(unit,date,step){return offset(utcInterval(unit),date,step)}function sequence(ival,start,stop,step){return ival?ival.range(start,stop,step):undefined}function timeSequence(unit,start,stop,step){return sequence(timeInterval(unit),start,stop,step)}function utcSequence(unit,start,stop,step){return sequence(utcInterval(unit),start,stop,step)}const durationSecond=1e3,durationMinute=durationSecond*60,durationHour=durationMinute*60,durationDay=durationHour*24,durationWeek=durationDay*7,durationMonth=durationDay*30,durationYear=durationDay*365;const Milli=[YEAR,MONTH,DATE,HOURS,MINUTES,SECONDS,MILLISECONDS],Seconds=Milli.slice(0,-1),Minutes=Seconds.slice(0,-1),Hours=Minutes.slice(0,-1),Day=Hours.slice(0,-1),Week=[YEAR,WEEK],Month=[YEAR,MONTH],Year=[YEAR];const intervals=[[Seconds,1,durationSecond],[Seconds,5,5*durationSecond],[Seconds,15,15*durationSecond],[Seconds,30,30*durationSecond],[Minutes,1,durationMinute],[Minutes,5,5*durationMinute],[Minutes,15,15*durationMinute],[Minutes,30,30*durationMinute],[Hours,1,durationHour],[Hours,3,3*durationHour],[Hours,6,6*durationHour],[Hours,12,12*durationHour],[Day,1,durationDay],[Week,1,durationWeek],[Month,1,durationMonth],[Month,3,3*durationMonth],[Year,1,durationYear]];function bin(opt){const ext=opt.extent,max=opt.maxbins||40,target=Math.abs(vegaUtil.span(ext))/max;let i=d3Array.bisector(i=>i[2]).right(intervals,target),units,step;if(i===intervals.length){units=Year,step=d3Array.tickStep(ext[0]/durationYear,ext[1]/durationYear,max)}else if(i){i=intervals[target/intervals[i-1][2]<intervals[i][2]/target?i-1:i];units=i[0];step=i[1]}else{units=Milli;step=Math.max(d3Array.tickStep(ext[0],ext[1],max),1)}return{units:units,step:step}}exports.DATE=DATE;exports.DAY=DAY;exports.DAYOFYEAR=DAYOFYEAR;exports.HOURS=HOURS;exports.MILLISECONDS=MILLISECONDS;exports.MINUTES=MINUTES;exports.MONTH=MONTH;exports.QUARTER=QUARTER;exports.SECONDS=SECONDS;exports.TIME_UNITS=TIME_UNITS;exports.WEEK=WEEK;exports.YEAR=YEAR;exports.dayofyear=dayofyear;exports.timeBin=bin;exports.timeFloor=timeFloor;exports.timeInterval=timeInterval;exports.timeOffset=timeOffset;exports.timeSequence=timeSequence;exports.timeUnitSpecifier=timeUnitSpecifier;exports.timeUnits=timeUnits;exports.utcFloor=utcFloor;exports.utcInterval=utcInterval;exports.utcOffset=utcOffset;exports.utcSequence=utcSequence;exports.utcdayofyear=utcdayofyear;exports.utcweek=utcweek;exports.week=week;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(98),__webpack_require__(73),__webpack_require__(57),__webpack_require__(58),__webpack_require__(44)):undefined})(this,(function(exports,vegaUtil,d3Shape,d3Path,vegaCanvas,vegaLoader,vegaScale){"use strict";let gradient_id=0;function resetSVGGradientId(){gradient_id=0}const patternPrefix="p_";function isGradient(value){return value&&value.gradient}function gradientRef(g,defs,base){const type=g.gradient;let id=g.id,prefix=type==="radial"?patternPrefix:"";if(!id){id=g.id="gradient_"+gradient_id++;if(type==="radial"){g.x1=get(g.x1,.5);g.y1=get(g.y1,.5);g.r1=get(g.r1,0);g.x2=get(g.x2,.5);g.y2=get(g.y2,.5);g.r2=get(g.r2,.5);prefix=patternPrefix}else{g.x1=get(g.x1,0);g.y1=get(g.y1,0);g.x2=get(g.x2,1);g.y2=get(g.y2,0)}}defs[id]=g;return"url("+(base||"")+"#"+prefix+id+")"}function get(val,def){return val!=null?val:def}function Gradient(p0,p1){var stops=[],gradient;return gradient={gradient:"linear",x1:p0?p0[0]:0,y1:p0?p0[1]:0,x2:p1?p1[0]:1,y2:p1?p1[1]:0,stops:stops,stop:function(offset,color){stops.push({offset:offset,color:color});return gradient}}}const lookup={basis:{curve:d3Shape.curveBasis},"basis-closed":{curve:d3Shape.curveBasisClosed},"basis-open":{curve:d3Shape.curveBasisOpen},bundle:{curve:d3Shape.curveBundle,tension:"beta",value:.85},cardinal:{curve:d3Shape.curveCardinal,tension:"tension",value:0},"cardinal-open":{curve:d3Shape.curveCardinalOpen,tension:"tension",value:0},"cardinal-closed":{curve:d3Shape.curveCardinalClosed,tension:"tension",value:0},"catmull-rom":{curve:d3Shape.curveCatmullRom,tension:"alpha",value:.5},"catmull-rom-closed":{curve:d3Shape.curveCatmullRomClosed,tension:"alpha",value:.5},"catmull-rom-open":{curve:d3Shape.curveCatmullRomOpen,tension:"alpha",value:.5},linear:{curve:d3Shape.curveLinear},"linear-closed":{curve:d3Shape.curveLinearClosed},monotone:{horizontal:d3Shape.curveMonotoneY,vertical:d3Shape.curveMonotoneX},natural:{curve:d3Shape.curveNatural},step:{curve:d3Shape.curveStep},"step-after":{curve:d3Shape.curveStepAfter},"step-before":{curve:d3Shape.curveStepBefore}};function curves(type,orientation,tension){var entry=vegaUtil.hasOwnProperty(lookup,type)&&lookup[type],curve=null;if(entry){curve=entry.curve||entry[orientation||"vertical"];if(entry.tension&&tension!=null){curve=curve[entry.tension](tension)}}return curve}const cmdlen={m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7},regexp=[/([MLHVCSQTAZmlhvcsqtaz])/g,/###/,/(\.\d+)(\.\d)/g,/(\d)([-+])/g,/\s|,|###/];function pathParse(pathstr){const result=[];let curr,chunks,parsed,param,cmd,len,i,j,n,m;const path=pathstr.slice().replace(regexp[0],"###$1").split(regexp[1]).slice(1);for(i=0,n=path.length;i<n;++i){curr=path[i];chunks=curr.slice(1).trim().replace(regexp[2],"$1###$2").replace(regexp[3],"$1###$2").split(regexp[4]);cmd=curr.charAt(0);parsed=[cmd];for(j=0,m=chunks.length;j<m;++j){if((param=+chunks[j])===param){parsed.push(param)}}len=cmdlen[cmd.toLowerCase()];if(parsed.length-1>len){const m=parsed.length;j=1;result.push([cmd].concat(parsed.slice(j,j+=len)));cmd=cmd==="M"?"L":cmd==="m"?"l":cmd;for(;j<m;j+=len){result.push([cmd].concat(parsed.slice(j,j+len)))}}else{result.push(parsed)}}return result}const DegToRad=Math.PI/180;const Epsilon=1e-14;const HalfPi=Math.PI/2;const Tau=Math.PI*2;const HalfSqrt3=Math.sqrt(3)/2;var segmentCache={};var bezierCache={};var join=[].join;function segments(x,y,rx,ry,large,sweep,rotateX,ox,oy){const key=join.call(arguments);if(segmentCache[key]){return segmentCache[key]}const th=rotateX*DegToRad;const sin_th=Math.sin(th);const cos_th=Math.cos(th);rx=Math.abs(rx);ry=Math.abs(ry);const px=cos_th*(ox-x)*.5+sin_th*(oy-y)*.5;const py=cos_th*(oy-y)*.5-sin_th*(ox-x)*.5;let pl=px*px/(rx*rx)+py*py/(ry*ry);if(pl>1){pl=Math.sqrt(pl);rx*=pl;ry*=pl}const a00=cos_th/rx;const a01=sin_th/rx;const a10=-sin_th/ry;const a11=cos_th/ry;const x0=a00*ox+a01*oy;const y0=a10*ox+a11*oy;const x1=a00*x+a01*y;const y1=a10*x+a11*y;const d=(x1-x0)*(x1-x0)+(y1-y0)*(y1-y0);let sfactor_sq=1/d-.25;if(sfactor_sq<0)sfactor_sq=0;let sfactor=Math.sqrt(sfactor_sq);if(sweep==large)sfactor=-sfactor;const xc=.5*(x0+x1)-sfactor*(y1-y0);const yc=.5*(y0+y1)+sfactor*(x1-x0);const th0=Math.atan2(y0-yc,x0-xc);const th1=Math.atan2(y1-yc,x1-xc);let th_arc=th1-th0;if(th_arc<0&&sweep===1){th_arc+=Tau}else if(th_arc>0&&sweep===0){th_arc-=Tau}const segs=Math.ceil(Math.abs(th_arc/(HalfPi+.001)));const result=[];for(let i=0;i<segs;++i){const th2=th0+i*th_arc/segs;const th3=th0+(i+1)*th_arc/segs;result[i]=[xc,yc,th2,th3,rx,ry,sin_th,cos_th]}return segmentCache[key]=result}function bezier(params){const key=join.call(params);if(bezierCache[key]){return bezierCache[key]}var cx=params[0],cy=params[1],th0=params[2],th1=params[3],rx=params[4],ry=params[5],sin_th=params[6],cos_th=params[7];const a00=cos_th*rx;const a01=-sin_th*ry;const a10=sin_th*rx;const a11=cos_th*ry;const cos_th0=Math.cos(th0);const sin_th0=Math.sin(th0);const cos_th1=Math.cos(th1);const sin_th1=Math.sin(th1);const th_half=.5*(th1-th0);const sin_th_h2=Math.sin(th_half*.5);const t=8/3*sin_th_h2*sin_th_h2/Math.sin(th_half);const x1=cx+cos_th0-t*sin_th0;const y1=cy+sin_th0+t*cos_th0;const x3=cx+cos_th1;const y3=cy+sin_th1;const x2=x3+t*sin_th1;const y2=y3-t*cos_th1;return bezierCache[key]=[a00*x1+a01*y1,a10*x1+a11*y1,a00*x2+a01*y2,a10*x2+a11*y2,a00*x3+a01*y3,a10*x3+a11*y3]}const temp=["l",0,0,0,0,0,0,0];function scale(current,sX,sY){const c=temp[0]=current[0];if(c==="a"||c==="A"){temp[1]=sX*current[1];temp[2]=sY*current[2];temp[3]=current[3];temp[4]=current[4];temp[5]=current[5];temp[6]=sX*current[6];temp[7]=sY*current[7]}else if(c==="h"||c==="H"){temp[1]=sX*current[1]}else if(c==="v"||c==="V"){temp[1]=sY*current[1]}else{for(var i=1,n=current.length;i<n;++i){temp[i]=(i%2==1?sX:sY)*current[i]}}return temp}function pathRender(context,path,l,t,sX,sY){var current,previous=null,x=0,y=0,controlX=0,controlY=0,tempX,tempY,tempControlX,tempControlY;if(l==null)l=0;if(t==null)t=0;if(sX==null)sX=1;if(sY==null)sY=sX;if(context.beginPath)context.beginPath();for(var i=0,len=path.length;i<len;++i){current=path[i];if(sX!==1||sY!==1){current=scale(current,sX,sY)}switch(current[0]){case"l":x+=current[1];y+=current[2];context.lineTo(x+l,y+t);break;case"L":x=current[1];y=current[2];context.lineTo(x+l,y+t);break;case"h":x+=current[1];context.lineTo(x+l,y+t);break;case"H":x=current[1];context.lineTo(x+l,y+t);break;case"v":y+=current[1];context.lineTo(x+l,y+t);break;case"V":y=current[1];context.lineTo(x+l,y+t);break;case"m":x+=current[1];y+=current[2];context.moveTo(x+l,y+t);break;case"M":x=current[1];y=current[2];context.moveTo(x+l,y+t);break;case"c":tempX=x+current[5];tempY=y+current[6];controlX=x+current[3];controlY=y+current[4];context.bezierCurveTo(x+current[1]+l,y+current[2]+t,controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"C":x=current[5];y=current[6];controlX=current[3];controlY=current[4];context.bezierCurveTo(current[1]+l,current[2]+t,controlX+l,controlY+t,x+l,y+t);break;case"s":tempX=x+current[3];tempY=y+current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,x+current[1]+l,y+current[2]+t,tempX+l,tempY+t);controlX=x+current[1];controlY=y+current[2];x=tempX;y=tempY;break;case"S":tempX=current[3];tempY=current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];controlY=current[2];break;case"q":tempX=x+current[3];tempY=y+current[4];controlX=x+current[1];controlY=y+current[2];context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"Q":tempX=current[3];tempY=current[4];context.quadraticCurveTo(current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];controlY=current[2];break;case"t":tempX=x+current[1];tempY=y+current[2];if(previous[0].match(/[QqTt]/)===null){controlX=x;controlY=y}else if(previous[0]==="t"){controlX=2*x-tempControlX;controlY=2*y-tempControlY}else if(previous[0]==="q"){controlX=2*x-controlX;controlY=2*y-controlY}tempControlX=controlX;tempControlY=controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=x+current[1];controlY=y+current[2];break;case"T":tempX=current[1];tempY=current[2];controlX=2*x-controlX;controlY=2*y-controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"a":drawArc(context,x+l,y+t,[current[1],current[2],current[3],current[4],current[5],current[6]+x+l,current[7]+y+t]);x+=current[6];y+=current[7];break;case"A":drawArc(context,x+l,y+t,[current[1],current[2],current[3],current[4],current[5],current[6]+l,current[7]+t]);x=current[6];y=current[7];break;case"z":case"Z":context.closePath();break}previous=current}}function drawArc(context,x,y,coords){const seg=segments(coords[5],coords[6],coords[0],coords[1],coords[3],coords[4],coords[2],x,y);for(let i=0;i<seg.length;++i){const bez=bezier(seg[i]);context.bezierCurveTo(bez[0],bez[1],bez[2],bez[3],bez[4],bez[5])}}const Tan30=.5773502691896257;const builtins={circle:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(r,0);context.arc(0,0,r,0,Tau)}},cross:{draw:function(context,size){var r=Math.sqrt(size)/2,s=r/2.5;context.moveTo(-r,-s);context.lineTo(-r,s);context.lineTo(-s,s);context.lineTo(-s,r);context.lineTo(s,r);context.lineTo(s,s);context.lineTo(r,s);context.lineTo(r,-s);context.lineTo(s,-s);context.lineTo(s,-r);context.lineTo(-s,-r);context.lineTo(-s,-s);context.closePath()}},diamond:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(-r,0);context.lineTo(0,-r);context.lineTo(r,0);context.lineTo(0,r);context.closePath()}},square:{draw:function(context,size){var w=Math.sqrt(size),x=-w/2;context.rect(x,x,w,w)}},arrow:{draw:function(context,size){var r=Math.sqrt(size)/2,s=r/7,t=r/2.5,v=r/8;context.moveTo(-s,r);context.lineTo(s,r);context.lineTo(s,-v);context.lineTo(t,-v);context.lineTo(0,-r);context.lineTo(-t,-v);context.lineTo(-s,-v);context.closePath()}},wedge:{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r,o=h-r*Tan30,b=r/4;context.moveTo(0,-h-o);context.lineTo(-b,h-o);context.lineTo(b,h-o);context.closePath()}},triangle:{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r,o=h-r*Tan30;context.moveTo(0,-h-o);context.lineTo(-r,h-o);context.lineTo(r,h-o);context.closePath()}},"triangle-up":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(0,-h);context.lineTo(-r,h);context.lineTo(r,h);context.closePath()}},"triangle-down":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(0,h);context.lineTo(-r,-h);context.lineTo(r,-h);context.closePath()}},"triangle-right":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(h,0);context.lineTo(-h,-r);context.lineTo(-h,r);context.closePath()}},"triangle-left":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(-h,0);context.lineTo(h,-r);context.lineTo(h,r);context.closePath()}},stroke:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(-r,0);context.lineTo(r,0)}}};function symbols(_){return vegaUtil.hasOwnProperty(builtins,_)?builtins[_]:customSymbol(_)}var custom={};function customSymbol(path){if(!vegaUtil.hasOwnProperty(custom,path)){const parsed=pathParse(path);custom[path]={draw:function(context,size){pathRender(context,parsed,0,0,Math.sqrt(size)/2)}}}return custom[path]}const C=.448084975506;function rectangleX(d){return d.x}function rectangleY(d){return d.y}function rectangleWidth(d){return d.width}function rectangleHeight(d){return d.height}function number(_){return typeof _==="function"?_:()=>+_}function clamp(value,min,max){return Math.max(min,Math.min(value,max))}function vg_rect(){var x=rectangleX,y=rectangleY,width=rectangleWidth,height=rectangleHeight,crTL=number(0),crTR=crTL,crBL=crTL,crBR=crTL,context=null;function rectangle(_,x0,y0){var buffer,x1=x0!=null?x0:+x.call(this,_),y1=y0!=null?y0:+y.call(this,_),w=+width.call(this,_),h=+height.call(this,_),s=Math.min(w,h)/2,tl=clamp(+crTL.call(this,_),0,s),tr=clamp(+crTR.call(this,_),0,s),bl=clamp(+crBL.call(this,_),0,s),br=clamp(+crBR.call(this,_),0,s);if(!context)context=buffer=d3Path.path();if(tl<=0&&tr<=0&&bl<=0&&br<=0){context.rect(x1,y1,w,h)}else{var x2=x1+w,y2=y1+h;context.moveTo(x1+tl,y1);context.lineTo(x2-tr,y1);context.bezierCurveTo(x2-C*tr,y1,x2,y1+C*tr,x2,y1+tr);context.lineTo(x2,y2-br);context.bezierCurveTo(x2,y2-C*br,x2-C*br,y2,x2-br,y2);context.lineTo(x1+bl,y2);context.bezierCurveTo(x1+C*bl,y2,x1,y2-C*bl,x1,y2-bl);context.lineTo(x1,y1+tl);context.bezierCurveTo(x1,y1+C*tl,x1+C*tl,y1,x1+tl,y1);context.closePath()}if(buffer){context=null;return buffer+""||null}}rectangle.x=function(_){if(arguments.length){x=number(_);return rectangle}else{return x}};rectangle.y=function(_){if(arguments.length){y=number(_);return rectangle}else{return y}};rectangle.width=function(_){if(arguments.length){width=number(_);return rectangle}else{return width}};rectangle.height=function(_){if(arguments.length){height=number(_);return rectangle}else{return height}};rectangle.cornerRadius=function(tl,tr,br,bl){if(arguments.length){crTL=number(tl);crTR=tr!=null?number(tr):crTL;crBR=br!=null?number(br):crTL;crBL=bl!=null?number(bl):crTR;return rectangle}else{return crTL}};rectangle.context=function(_){if(arguments.length){context=_==null?null:_;return rectangle}else{return context}};return rectangle}function vg_trail(){var x,y,size,defined,context=null,ready,x1,y1,r1;function point(x2,y2,w2){const r2=w2/2;if(ready){var ux=y1-y2,uy=x2-x1;if(ux||uy){var ud=Math.sqrt(ux*ux+uy*uy),rx=(ux/=ud)*r1,ry=(uy/=ud)*r1,t=Math.atan2(uy,ux);context.moveTo(x1-rx,y1-ry);context.lineTo(x2-ux*r2,y2-uy*r2);context.arc(x2,y2,r2,t-Math.PI,t);context.lineTo(x1+rx,y1+ry);context.arc(x1,y1,r1,t,t+Math.PI)}else{context.arc(x2,y2,r2,0,Tau)}context.closePath()}else{ready=1}x1=x2;y1=y2;r1=r2}function trail(data){var i,n=data.length,d,defined0=false,buffer;if(context==null)context=buffer=d3Path.path();for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0)ready=0}if(defined0)point(+x(d,i,data),+y(d,i,data),+size(d,i,data))}if(buffer){context=null;return buffer+""||null}}trail.x=function(_){if(arguments.length){x=_;return trail}else{return x}};trail.y=function(_){if(arguments.length){y=_;return trail}else{return y}};trail.size=function(_){if(arguments.length){size=_;return trail}else{return size}};trail.defined=function(_){if(arguments.length){defined=_;return trail}else{return defined}};trail.context=function(_){if(arguments.length){if(_==null){context=null}else{context=_}return trail}else{return context}};return trail}function value(a,b){return a!=null?a:b}const x=item=>item.x||0,y=item=>item.y||0,w=item=>item.width||0,h=item=>item.height||0,xw=item=>(item.x||0)+(item.width||0),yh=item=>(item.y||0)+(item.height||0),sa=item=>item.startAngle||0,ea=item=>item.endAngle||0,pa=item=>item.padAngle||0,ir=item=>item.innerRadius||0,or=item=>item.outerRadius||0,cr=item=>item.cornerRadius||0,tl=item=>value(item.cornerRadiusTopLeft,item.cornerRadius)||0,tr=item=>value(item.cornerRadiusTopRight,item.cornerRadius)||0,br=item=>value(item.cornerRadiusBottomRight,item.cornerRadius)||0,bl=item=>value(item.cornerRadiusBottomLeft,item.cornerRadius)||0,sz=item=>value(item.size,64),ts=item=>item.size||1,def=item=>!(item.defined===false),type=item=>symbols(item.shape||"circle");const arcShape=d3Shape.arc().startAngle(sa).endAngle(ea).padAngle(pa).innerRadius(ir).outerRadius(or).cornerRadius(cr),areavShape=d3Shape.area().x(x).y1(y).y0(yh).defined(def),areahShape=d3Shape.area().y(y).x1(x).x0(xw).defined(def),lineShape=d3Shape.line().x(x).y(y).defined(def),rectShape=vg_rect().x(x).y(y).width(w).height(h).cornerRadius(tl,tr,br,bl),symbolShape=d3Shape.symbol().type(type).size(sz),trailShape=vg_trail().x(x).y(y).defined(def).size(ts);function hasCornerRadius(item){return item.cornerRadius||item.cornerRadiusTopLeft||item.cornerRadiusTopRight||item.cornerRadiusBottomRight||item.cornerRadiusBottomLeft}function arc(context,item){return arcShape.context(context)(item)}function area(context,items){const item=items[0],interp=item.interpolate||"linear";return(item.orient==="horizontal"?areahShape:areavShape).curve(curves(interp,item.orient,item.tension)).context(context)(items)}function line(context,items){const item=items[0],interp=item.interpolate||"linear";return lineShape.curve(curves(interp,item.orient,item.tension)).context(context)(items)}function rectangle(context,item,x,y){return rectShape.context(context)(item,x,y)}function shape(context,item){return(item.mark.shape||item.shape).context(context)(item)}function symbol(context,item){return symbolShape.context(context)(item)}function trail(context,items){return trailShape.context(context)(items)}var clip_id=1;function resetSVGClipId(){clip_id=1}function clip(renderer,item,size){var clip=item.clip,defs=renderer._defs,id=item.clip_id||(item.clip_id="clip"+clip_id++),c=defs.clipping[id]||(defs.clipping[id]={id:id});if(vegaUtil.isFunction(clip)){c.path=clip(null)}else if(hasCornerRadius(size)){c.path=rectangle(null,size,0,0)}else{c.width=size.width||0;c.height=size.height||0}return"url(#"+id+")"}function Bounds(b){this.clear();if(b)this.union(b)}Bounds.prototype={clone(){return new Bounds(this)},clear(){this.x1=+Number.MAX_VALUE;this.y1=+Number.MAX_VALUE;this.x2=-Number.MAX_VALUE;this.y2=-Number.MAX_VALUE;return this},empty(){return this.x1===+Number.MAX_VALUE&&this.y1===+Number.MAX_VALUE&&this.x2===-Number.MAX_VALUE&&this.y2===-Number.MAX_VALUE},equals(b){return this.x1===b.x1&&this.y1===b.y1&&this.x2===b.x2&&this.y2===b.y2},set(x1,y1,x2,y2){if(x2<x1){this.x2=x1;this.x1=x2}else{this.x1=x1;this.x2=x2}if(y2<y1){this.y2=y1;this.y1=y2}else{this.y1=y1;this.y2=y2}return this},add(x,y){if(x<this.x1)this.x1=x;if(y<this.y1)this.y1=y;if(x>this.x2)this.x2=x;if(y>this.y2)this.y2=y;return this},expand(d){this.x1-=d;this.y1-=d;this.x2+=d;this.y2+=d;return this},round(){this.x1=Math.floor(this.x1);this.y1=Math.floor(this.y1);this.x2=Math.ceil(this.x2);this.y2=Math.ceil(this.y2);return this},scale(s){this.x1*=s;this.y1*=s;this.x2*=s;this.y2*=s;return this},translate(dx,dy){this.x1+=dx;this.x2+=dx;this.y1+=dy;this.y2+=dy;return this},rotate(angle,x,y){const p=this.rotatedPoints(angle,x,y);return this.clear().add(p[0],p[1]).add(p[2],p[3]).add(p[4],p[5]).add(p[6],p[7])},rotatedPoints(angle,x,y){var{x1:x1,y1:y1,x2:x2,y2:y2}=this,cos=Math.cos(angle),sin=Math.sin(angle),cx=x-x*cos+y*sin,cy=y-x*sin-y*cos;return[cos*x1-sin*y1+cx,sin*x1+cos*y1+cy,cos*x1-sin*y2+cx,sin*x1+cos*y2+cy,cos*x2-sin*y1+cx,sin*x2+cos*y1+cy,cos*x2-sin*y2+cx,sin*x2+cos*y2+cy]},union(b){if(b.x1<this.x1)this.x1=b.x1;if(b.y1<this.y1)this.y1=b.y1;if(b.x2>this.x2)this.x2=b.x2;if(b.y2>this.y2)this.y2=b.y2;return this},intersect(b){if(b.x1>this.x1)this.x1=b.x1;if(b.y1>this.y1)this.y1=b.y1;if(b.x2<this.x2)this.x2=b.x2;if(b.y2<this.y2)this.y2=b.y2;return this},encloses(b){return b&&this.x1<=b.x1&&this.x2>=b.x2&&this.y1<=b.y1&&this.y2>=b.y2},alignsWith(b){return b&&(this.x1==b.x1||this.x2==b.x2||this.y1==b.y1||this.y2==b.y2)},intersects(b){return b&&!(this.x2<b.x1||this.x1>b.x2||this.y2<b.y1||this.y1>b.y2)},contains(x,y){return!(x<this.x1||x>this.x2||y<this.y1||y>this.y2)},width(){return this.x2-this.x1},height(){return this.y2-this.y1}};function Item(mark){this.mark=mark;this.bounds=this.bounds||new Bounds}function GroupItem(mark){Item.call(this,mark);this.items=this.items||[]}vegaUtil.inherits(GroupItem,Item);function ResourceLoader(customLoader){this._pending=0;this._loader=customLoader||vegaLoader.loader()}function increment(loader){loader._pending+=1}function decrement(loader){loader._pending-=1}ResourceLoader.prototype={pending(){return this._pending},sanitizeURL(uri){const loader=this;increment(loader);return loader._loader.sanitize(uri,{context:"href"}).then(opt=>{decrement(loader);return opt}).catch(()=>{decrement(loader);return null})},loadImage(uri){const loader=this,Image=vegaCanvas.image();increment(loader);return loader._loader.sanitize(uri,{context:"image"}).then(opt=>{const url=opt.href;if(!url||!Image)throw{url:url};const img=new Image;const cors=vegaUtil.hasOwnProperty(opt,"crossOrigin")?opt.crossOrigin:"anonymous";if(cors!=null)img.crossOrigin=cors;img.onload=()=>decrement(loader);img.onerror=()=>decrement(loader);img.src=url;return img}).catch(e=>{decrement(loader);return{complete:false,width:0,height:0,src:e&&e.url||""}})},ready(){const loader=this;return new Promise(accept=>{function poll(value){if(!loader.pending())accept(value);else setTimeout(()=>{poll(true)},10)}poll(false)})}};function boundStroke(bounds,item,miter){if(item.stroke&&item.opacity!==0&&item.strokeOpacity!==0){const sw=item.strokeWidth!=null?+item.strokeWidth:1;bounds.expand(sw+(miter?miterAdjustment(item,sw):0))}return bounds}function miterAdjustment(item,strokeWidth){return item.strokeJoin&&item.strokeJoin!=="miter"?0:strokeWidth}const circleThreshold=Tau-1e-8;let bounds,lx,ly,rot,ma,mb,mc,md;const add=(x,y)=>bounds.add(x,y);const addL=(x,y)=>add(lx=x,ly=y);const addX=x=>add(x,bounds.y1);const addY=y=>add(bounds.x1,y);const px=(x,y)=>ma*x+mc*y;const py=(x,y)=>mb*x+md*y;const addp=(x,y)=>add(px(x,y),py(x,y));const addpL=(x,y)=>addL(px(x,y),py(x,y));function boundContext(_,deg){bounds=_;if(deg){rot=deg*DegToRad;ma=md=Math.cos(rot);mb=Math.sin(rot);mc=-mb}else{ma=md=1;rot=mb=mc=0}return context}const context={beginPath(){},closePath(){},moveTo:addpL,lineTo:addpL,rect(x,y,w,h){if(rot){addp(x+w,y);addp(x+w,y+h);addp(x,y+h);addpL(x,y)}else{add(x+w,y+h);addL(x,y)}},quadraticCurveTo(x1,y1,x2,y2){const px1=px(x1,y1),py1=py(x1,y1),px2=px(x2,y2),py2=py(x2,y2);quadExtrema(lx,px1,px2,addX);quadExtrema(ly,py1,py2,addY);addL(px2,py2)},bezierCurveTo(x1,y1,x2,y2,x3,y3){const px1=px(x1,y1),py1=py(x1,y1),px2=px(x2,y2),py2=py(x2,y2),px3=px(x3,y3),py3=py(x3,y3);cubicExtrema(lx,px1,px2,px3,addX);cubicExtrema(ly,py1,py2,py3,addY);addL(px3,py3)},arc(cx,cy,r,sa,ea,ccw){sa+=rot;ea+=rot;lx=r*Math.cos(ea)+cx;ly=r*Math.sin(ea)+cy;if(Math.abs(ea-sa)>circleThreshold){add(cx-r,cy-r);add(cx+r,cy+r)}else{const update=a=>add(r*Math.cos(a)+cx,r*Math.sin(a)+cy);let s,i;update(sa);update(ea);if(ea!==sa){sa=sa%Tau;if(sa<0)sa+=Tau;ea=ea%Tau;if(ea<0)ea+=Tau;if(ea<sa){ccw=!ccw;s=sa;sa=ea;ea=s}if(ccw){ea-=Tau;s=sa-sa%HalfPi;for(i=0;i<4&&s>ea;++i,s-=HalfPi)update(s)}else{s=sa-sa%HalfPi+HalfPi;for(i=0;i<4&&s<ea;++i,s=s+HalfPi)update(s)}}}}};function quadExtrema(x0,x1,x2,cb){const t=(x0-x1)/(x0+x2-2*x1);if(0<t&&t<1)cb(x0+(x1-x0)*t)}function cubicExtrema(x0,x1,x2,x3,cb){const a=x3-x0+3*x1-3*x2,b=x0+x2-2*x1,c=x0-x1;let t0=0,t1=0,r;if(Math.abs(a)>Epsilon){r=b*b+c*a;if(r>=0){r=Math.sqrt(r);t0=(-b+r)/a;t1=(-b-r)/a}}else{t0=.5*c/b}if(0<t0&&t0<1)cb(cubic(t0,x0,x1,x2,x3));if(0<t1&&t1<1)cb(cubic(t1,x0,x1,x2,x3))}function cubic(t,x0,x1,x2,x3){const s=1-t,s2=s*s,t2=t*t;return s2*s*x0+3*s2*t*x1+3*s*t2*x2+t2*t*x3}var context$1=(context$1=vegaCanvas.canvas(1,1))?context$1.getContext("2d"):null;const b=new Bounds;function intersectPath(draw){return function(item,brush){if(!context$1)return true;draw(context$1,item);b.clear().union(item.bounds).intersect(brush).round();const{x1:x1,y1:y1,x2:x2,y2:y2}=b;for(let y=y1;y<=y2;++y){for(let x=x1;x<=x2;++x){if(context$1.isPointInPath(x,y)){return true}}}return false}}function intersectPoint(item,box){return box.contains(item.x||0,item.y||0)}function intersectRect(item,box){const x=item.x||0,y=item.y||0,w=item.width||0,h=item.height||0;return box.intersects(b.set(x,y,x+w,y+h))}function intersectRule(item,box){const x=item.x||0,y=item.y||0,x2=item.x2!=null?item.x2:x,y2=item.y2!=null?item.y2:y;return intersectBoxLine(box,x,y,x2,y2)}function intersectBoxLine(box,x,y,u,v){const{x1:x1,y1:y1,x2:x2,y2:y2}=box,dx=u-x,dy=v-y;let t0=0,t1=1,p,q,r,e;for(e=0;e<4;++e){if(e===0){p=-dx;q=-(x1-x)}if(e===1){p=dx;q=x2-x}if(e===2){p=-dy;q=-(y1-y)}if(e===3){p=dy;q=y2-y}if(Math.abs(p)<1e-10&&q<0)return false;r=q/p;if(p<0){if(r>t1)return false;else if(r>t0)t0=r}else if(p>0){if(r<t0)return false;else if(r<t1)t1=r}}return true}function blend(context,item){context.globalCompositeOperation=item.blend||"source-over"}function value$1(value,dflt){return value==null?dflt:value}function addStops(gradient,stops){const n=stops.length;for(let i=0;i<n;++i){gradient.addColorStop(stops[i].offset,stops[i].color)}return gradient}function gradient(context,spec,bounds){const w=bounds.width(),h=bounds.height();let gradient;if(spec.gradient==="radial"){gradient=context.createRadialGradient(bounds.x1+value$1(spec.x1,.5)*w,bounds.y1+value$1(spec.y1,.5)*h,Math.max(w,h)*value$1(spec.r1,0),bounds.x1+value$1(spec.x2,.5)*w,bounds.y1+value$1(spec.y2,.5)*h,Math.max(w,h)*value$1(spec.r2,.5))}else{const x1=value$1(spec.x1,0),y1=value$1(spec.y1,0),x2=value$1(spec.x2,1),y2=value$1(spec.y2,0);if(x1===x2||y1===y2||w===h){gradient=context.createLinearGradient(bounds.x1+x1*w,bounds.y1+y1*h,bounds.x1+x2*w,bounds.y1+y2*h)}else{const image=vegaCanvas.canvas(Math.ceil(w),Math.ceil(h)),ictx=image.getContext("2d");ictx.scale(w,h);ictx.fillStyle=addStops(ictx.createLinearGradient(x1,y1,x2,y2),spec.stops);ictx.fillRect(0,0,w,h);return context.createPattern(image,"no-repeat")}}return addStops(gradient,spec.stops)}function color(context,item,value){return isGradient(value)?gradient(context,value,item.bounds):value}function fill(context,item,opacity){opacity*=item.fillOpacity==null?1:item.fillOpacity;if(opacity>0){context.globalAlpha=opacity;context.fillStyle=color(context,item,item.fill);return true}else{return false}}var Empty=[];function stroke(context,item,opacity){var lw=(lw=item.strokeWidth)!=null?lw:1;if(lw<=0)return false;opacity*=item.strokeOpacity==null?1:item.strokeOpacity;if(opacity>0){context.globalAlpha=opacity;context.strokeStyle=color(context,item,item.stroke);context.lineWidth=lw;context.lineCap=item.strokeCap||"butt";context.lineJoin=item.strokeJoin||"miter";context.miterLimit=item.strokeMiterLimit||10;if(context.setLineDash){context.setLineDash(item.strokeDash||Empty);context.lineDashOffset=item.strokeDashOffset||0}return true}else{return false}}function compare(a,b){return a.zindex-b.zindex||a.index-b.index}function zorder(scene){if(!scene.zdirty)return scene.zitems;var items=scene.items,output=[],item,i,n;for(i=0,n=items.length;i<n;++i){item=items[i];item.index=i;if(item.zindex)output.push(item)}scene.zdirty=false;return scene.zitems=output.sort(compare)}function visit(scene,visitor){var items=scene.items,i,n;if(!items||!items.length)return;const zitems=zorder(scene);if(zitems&&zitems.length){for(i=0,n=items.length;i<n;++i){if(!items[i].zindex)visitor(items[i])}items=zitems}for(i=0,n=items.length;i<n;++i){visitor(items[i])}}function pickVisit(scene,visitor){var items=scene.items,hit,i;if(!items||!items.length)return null;const zitems=zorder(scene);if(zitems&&zitems.length)items=zitems;for(i=items.length;--i>=0;){if(hit=visitor(items[i]))return hit}if(items===zitems){for(items=scene.items,i=items.length;--i>=0;){if(!items[i].zindex){if(hit=visitor(items[i]))return hit}}}return null}function drawAll(path){return function(context,scene,bounds){visit(scene,item=>{if(!bounds||bounds.intersects(item.bounds)){drawPath(path,context,item,item)}})}}function drawOne(path){return function(context,scene,bounds){if(scene.items.length&&(!bounds||bounds.intersects(scene.bounds))){drawPath(path,context,scene.items[0],scene.items)}}}function drawPath(path,context,item,items){var opacity=item.opacity==null?1:item.opacity;if(opacity===0)return;if(path(context,items))return;blend(context,item);if(item.fill&&fill(context,item,opacity)){context.fill()}if(item.stroke&&stroke(context,item,opacity)){context.stroke()}}function pick(test){test=test||vegaUtil.truthy;return function(context,scene,x,y,gx,gy){x*=context.pixelRatio;y*=context.pixelRatio;return pickVisit(scene,item=>{const b=item.bounds;if(b&&!b.contains(gx,gy)||!b)return;if(test(context,item,x,y,gx,gy))return item})}}function hitPath(path,filled){return function(context,o,x,y){var item=Array.isArray(o)?o[0]:o,fill=filled==null?item.fill:filled,stroke=item.stroke&&context.isPointInStroke,lw,lc;if(stroke){lw=item.strokeWidth;lc=item.strokeCap;context.lineWidth=lw!=null?lw:1;context.lineCap=lc!=null?lc:"butt"}return path(context,o)?false:fill&&context.isPointInPath(x,y)||stroke&&context.isPointInStroke(x,y)}}function pickPath(path){return pick(hitPath(path))}function translate(x,y){return"translate("+x+","+y+")"}function rotate(a){return"rotate("+a+")"}function scale$1(scaleX,scaleY){return"scale("+scaleX+","+scaleY+")"}function translateItem(item){return translate(item.x||0,item.y||0)}function rotateItem(item){return translate(item.x||0,item.y||0)+(item.angle?" "+rotate(item.angle):"")}function transformItem(item){return translate(item.x||0,item.y||0)+(item.angle?" "+rotate(item.angle):"")+(item.scaleX||item.scaleY?" "+scale$1(item.scaleX||1,item.scaleY||1):"")}function markItemPath(type,shape,isect){function attr(emit,item){emit("transform",rotateItem(item));emit("d",shape(null,item))}function bound(bounds,item){shape(boundContext(bounds,item.angle),item);return boundStroke(bounds,item).translate(item.x||0,item.y||0)}function draw(context,item){var x=item.x||0,y=item.y||0,a=item.angle||0;context.translate(x,y);if(a)context.rotate(a*=DegToRad);context.beginPath();shape(context,item);if(a)context.rotate(-a);context.translate(-x,-y)}return{type:type,tag:"path",nested:false,attr:attr,bound:bound,draw:drawAll(draw),pick:pickPath(draw),isect:isect||intersectPath(draw)}}var arc$1=markItemPath("arc",arc);function pickArea(a,p){var v=a[0].orient==="horizontal"?p[1]:p[0],z=a[0].orient==="horizontal"?"y":"x",i=a.length,min=+Infinity,hit,d;while(--i>=0){if(a[i].defined===false)continue;d=Math.abs(a[i][z]-v);if(d<min){min=d;hit=a[i]}}return hit}function pickLine(a,p){var t=Math.pow(a[0].strokeWidth||1,2),i=a.length,dx,dy,dd;while(--i>=0){if(a[i].defined===false)continue;dx=a[i].x-p[0];dy=a[i].y-p[1];dd=dx*dx+dy*dy;if(dd<t)return a[i]}return null}function pickTrail(a,p){var i=a.length,dx,dy,dd;while(--i>=0){if(a[i].defined===false)continue;dx=a[i].x-p[0];dy=a[i].y-p[1];dd=dx*dx+dy*dy;dx=a[i].size||1;if(dd<dx*dx)return a[i]}return null}function markMultiItemPath(type,shape,tip){function attr(emit,item){var items=item.mark.items;if(items.length)emit("d",shape(null,items))}function bound(bounds,mark){var items=mark.items;if(items.length===0){return bounds}else{shape(boundContext(bounds),items);return boundStroke(bounds,items[0])}}function draw(context,items){context.beginPath();shape(context,items)}const hit=hitPath(draw);function pick(context,scene,x,y,gx,gy){var items=scene.items,b=scene.bounds;if(!items||!items.length||b&&!b.contains(gx,gy)){return null}x*=context.pixelRatio;y*=context.pixelRatio;return hit(context,items,x,y)?items[0]:null}return{type:type,tag:"path",nested:true,attr:attr,bound:bound,draw:drawOne(draw),pick:pick,isect:intersectPoint,tip:tip}}var area$1=markMultiItemPath("area",area,pickArea);function clip$1(context,scene){var clip=scene.clip;context.save();if(vegaUtil.isFunction(clip)){context.beginPath();clip(context);context.clip()}else{clipGroup(context,scene.group)}}function clipGroup(context,group){context.beginPath();hasCornerRadius(group)?rectangle(context,group,0,0):context.rect(0,0,group.width||0,group.height||0);context.clip()}function offset(item){const sw=value$1(item.strokeWidth,1);return item.strokeOffset!=null?item.strokeOffset:item.stroke&&sw>.5&&sw<1.5?.5-Math.abs(sw-1):0}function attr(emit,item){emit("transform",translateItem(item))}function emitRectangle(emit,item){const off=offset(item);emit("d",rectangle(null,item,off,off))}function background(emit,item){emit("class","background");emit("aria-hidden",true);emitRectangle(emit,item)}function foreground(emit,item){emit("class","foreground");emit("aria-hidden",true);if(item.strokeForeground){emitRectangle(emit,item)}else{emit("d","")}}function content(emit,item,renderer){const url=item.clip?clip(renderer,item,item):null;emit("clip-path",url)}function bound(bounds,group){if(!group.clip&&group.items){const items=group.items,m=items.length;for(let j=0;j<m;++j){bounds.union(items[j].bounds)}}if((group.clip||group.width||group.height)&&!group.noBound){bounds.add(0,0).add(group.width||0,group.height||0)}boundStroke(bounds,group);return bounds.translate(group.x||0,group.y||0)}function rectanglePath(context,group,x,y){const off=offset(group);context.beginPath();rectangle(context,group,(x||0)+off,(y||0)+off)}const hitBackground=hitPath(rectanglePath);const hitForeground=hitPath(rectanglePath,false);const hitCorner=hitPath(rectanglePath,true);function draw(context,scene,bounds){visit(scene,group=>{const gx=group.x||0,gy=group.y||0,fore=group.strokeForeground,opacity=group.opacity==null?1:group.opacity;if((group.stroke||group.fill)&&opacity){rectanglePath(context,group,gx,gy);blend(context,group);if(group.fill&&fill(context,group,opacity)){context.fill()}if(group.stroke&&!fore&&stroke(context,group,opacity)){context.stroke()}}context.save();context.translate(gx,gy);if(group.clip)clipGroup(context,group);if(bounds)bounds.translate(-gx,-gy);visit(group,item=>{this.draw(context,item,bounds)});if(bounds)bounds.translate(gx,gy);context.restore();if(fore&&group.stroke&&opacity){rectanglePath(context,group,gx,gy);blend(context,group);if(stroke(context,group,opacity)){context.stroke()}}})}function pick$1(context,scene,x,y,gx,gy){if(scene.bounds&&!scene.bounds.contains(gx,gy)||!scene.items){return null}const cx=x*context.pixelRatio,cy=y*context.pixelRatio;return pickVisit(scene,group=>{let hit,dx,dy;const b=group.bounds;if(b&&!b.contains(gx,gy))return;dx=group.x||0;dy=group.y||0;const dw=dx+(group.width||0),dh=dy+(group.height||0),c=group.clip;if(c&&(gx<dx||gx>dw||gy<dy||gy>dh))return;context.save();context.translate(dx,dy);dx=gx-dx;dy=gy-dy;if(c&&hasCornerRadius(group)&&!hitCorner(context,group,cx,cy)){context.restore();return null}const fore=group.strokeForeground,ix=scene.interactive!==false;if(ix&&fore&&group.stroke&&hitForeground(context,group,cx,cy)){context.restore();return group}hit=pickVisit(group,mark=>pickMark(mark,dx,dy)?this.pick(mark,x,y,dx,dy):null);if(!hit&&ix&&(group.fill||!fore&&group.stroke)&&hitBackground(context,group,cx,cy)){hit=group}context.restore();return hit||null})}function pickMark(mark,x,y){return(mark.interactive!==false||mark.marktype==="group")&&mark.bounds&&mark.bounds.contains(x,y)}var group={type:"group",tag:"g",nested:false,attr:attr,bound:bound,draw:draw,pick:pick$1,isect:intersectRect,content:content,background:background,foreground:foreground};var metadata={xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink",version:"1.1"};function getImage(item,renderer){var image=item.image;if(!image||item.url&&item.url!==image.url){image={complete:false,width:0,height:0};renderer.loadImage(item.url).then(image=>{item.image=image;item.image.url=item.url})}return image}function imageWidth(item,image){return item.width!=null?item.width:!image||!image.width?0:item.aspect!==false&&item.height?item.height*image.width/image.height:image.width}function imageHeight(item,image){return item.height!=null?item.height:!image||!image.height?0:item.aspect!==false&&item.width?item.width*image.height/image.width:image.height}function imageXOffset(align,w){return align==="center"?w/2:align==="right"?w:0}function imageYOffset(baseline,h){return baseline==="middle"?h/2:baseline==="bottom"?h:0}function attr$1(emit,item,renderer){const img=getImage(item,renderer),w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h),i=!img.src&&img.toDataURL?img.toDataURL():img.src||"";emit("href",i,metadata["xmlns:xlink"],"xlink:href");emit("transform",translate(x,y));emit("width",w);emit("height",h);emit("preserveAspectRatio",item.aspect===false?"none":"xMidYMid")}function bound$1(bounds,item){const img=item.image,w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h);return bounds.set(x,y,x+w,y+h)}function draw$1(context,scene,bounds){visit(scene,item=>{if(bounds&&!bounds.intersects(item.bounds))return;const img=getImage(item,this);let w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h),opacity,ar0,ar1,t;if(item.aspect!==false){ar0=img.width/img.height;ar1=item.width/item.height;if(ar0===ar0&&ar1===ar1&&ar0!==ar1){if(ar1<ar0){t=w/ar0;y+=(h-t)/2;h=t}else{t=h*ar0;x+=(w-t)/2;w=t}}}if(img.complete||img.toDataURL){blend(context,item);context.globalAlpha=(opacity=item.opacity)!=null?opacity:1;context.imageSmoothingEnabled=item.smooth!==false;context.drawImage(img,x,y,w,h)}})}var image={type:"image",tag:"image",nested:false,attr:attr$1,bound:bound$1,draw:draw$1,pick:pick(),isect:vegaUtil.truthy,get:getImage,xOffset:imageXOffset,yOffset:imageYOffset};var line$1=markMultiItemPath("line",line,pickLine);function attr$2(emit,item){var sx=item.scaleX||1,sy=item.scaleY||1;if(sx!==1||sy!==1){emit("vector-effect","non-scaling-stroke")}emit("transform",transformItem(item));emit("d",item.path)}function path(context,item){var path=item.path;if(path==null)return true;var x=item.x||0,y=item.y||0,sx=item.scaleX||1,sy=item.scaleY||1,a=(item.angle||0)*DegToRad,cache=item.pathCache;if(!cache||cache.path!==path){(item.pathCache=cache=pathParse(path)).path=path}if(a&&context.rotate&&context.translate){context.translate(x,y);context.rotate(a);pathRender(context,cache,0,0,sx,sy);context.rotate(-a);context.translate(-x,-y)}else{pathRender(context,cache,x,y,sx,sy)}}function bound$2(bounds,item){return path(boundContext(bounds,item.angle),item)?bounds.set(0,0,0,0):boundStroke(bounds,item,true)}var path$1={type:"path",tag:"path",nested:false,attr:attr$2,bound:bound$2,draw:drawAll(path),pick:pickPath(path),isect:intersectPath(path)};function attr$3(emit,item){emit("d",rectangle(null,item))}function bound$3(bounds,item){var x,y;return boundStroke(bounds.set(x=item.x||0,y=item.y||0,x+item.width||0,y+item.height||0),item)}function draw$2(context,item){context.beginPath();rectangle(context,item)}var rect={type:"rect",tag:"path",nested:false,attr:attr$3,bound:bound$3,draw:drawAll(draw$2),pick:pickPath(draw$2),isect:intersectRect};function attr$4(emit,item){emit("transform",translateItem(item));emit("x2",item.x2!=null?item.x2-(item.x||0):0);emit("y2",item.y2!=null?item.y2-(item.y||0):0)}function bound$4(bounds,item){var x1,y1;return boundStroke(bounds.set(x1=item.x||0,y1=item.y||0,item.x2!=null?item.x2:x1,item.y2!=null?item.y2:y1),item)}function path$2(context,item,opacity){var x1,y1,x2,y2;if(item.stroke&&stroke(context,item,opacity)){x1=item.x||0;y1=item.y||0;x2=item.x2!=null?item.x2:x1;y2=item.y2!=null?item.y2:y1;context.beginPath();context.moveTo(x1,y1);context.lineTo(x2,y2);return true}return false}function draw$3(context,scene,bounds){visit(scene,item=>{if(bounds&&!bounds.intersects(item.bounds))return;var opacity=item.opacity==null?1:item.opacity;if(opacity&&path$2(context,item,opacity)){blend(context,item);context.stroke()}})}function hit(context,item,x,y){if(!context.isPointInStroke)return false;return path$2(context,item,1)&&context.isPointInStroke(x,y)}var rule={type:"rule",tag:"line",nested:false,attr:attr$4,bound:bound$4,draw:draw$3,pick:pick(hit),isect:intersectRule};var shape$1=markItemPath("shape",shape);var symbol$1=markItemPath("symbol",symbol,intersectPoint);const widthCache=vegaUtil.lruCache();var textMetrics={height:fontSize,measureWidth:measureWidth,estimateWidth:estimateWidth,width:estimateWidth,canvas:useCanvas};useCanvas(true);function useCanvas(use){textMetrics.width=use&&context$1?measureWidth:estimateWidth}function estimateWidth(item,text){return _estimateWidth(textValue(item,text),fontSize(item))}function _estimateWidth(text,currentFontHeight){return~~(.8*text.length*currentFontHeight)}function measureWidth(item,text){return fontSize(item)<=0||!(text=textValue(item,text))?0:_measureWidth(text,font(item))}function _measureWidth(text,currentFont){const key=`(${currentFont}) ${text}`;let width=widthCache.get(key);if(width===undefined){context$1.font=currentFont;width=context$1.measureText(text).width;widthCache.set(key,width)}return width}function fontSize(item){return item.fontSize!=null?+item.fontSize||0:11}function lineHeight(item){return item.lineHeight!=null?item.lineHeight:fontSize(item)+2}function lineArray(_){return vegaUtil.isArray(_)?_.length>1?_:_[0]:_}function textLines(item){return lineArray(item.lineBreak&&item.text&&!vegaUtil.isArray(item.text)?item.text.split(item.lineBreak):item.text)}function multiLineOffset(item){const tl=textLines(item);return(vegaUtil.isArray(tl)?tl.length-1:0)*lineHeight(item)}function textValue(item,line){const text=line==null?"":(line+"").trim();return item.limit>0&&text.length?truncate(item,text):text}function widthGetter(item){if(textMetrics.width===measureWidth){const currentFont=font(item);return text=>_measureWidth(text,currentFont)}else{const currentFontHeight=fontSize(item);return text=>_estimateWidth(text,currentFontHeight)}}function truncate(item,text){var limit=+item.limit,width=widthGetter(item);if(width(text)<limit)return text;var ellipsis=item.ellipsis||"…",rtl=item.dir==="rtl",lo=0,hi=text.length,mid;limit-=width(ellipsis);if(rtl){while(lo<hi){mid=lo+hi>>>1;if(width(text.slice(mid))>limit)lo=mid+1;else hi=mid}return ellipsis+text.slice(lo)}else{while(lo<hi){mid=1+(lo+hi>>>1);if(width(text.slice(0,mid))<limit)lo=mid;else hi=mid-1}return text.slice(0,lo)+ellipsis}}function fontFamily(item,quote){var font=item.font;return(quote&&font?String(font).replace(/"/g,"'"):font)||"sans-serif"}function font(item,quote){return""+(item.fontStyle?item.fontStyle+" ":"")+(item.fontVariant?item.fontVariant+" ":"")+(item.fontWeight?item.fontWeight+" ":"")+fontSize(item)+"px "+fontFamily(item,quote)}function offset$1(item){var baseline=item.baseline,h=fontSize(item);return Math.round(baseline==="top"?.79*h:baseline==="middle"?.3*h:baseline==="bottom"?-.21*h:baseline==="line-top"?.29*h+.5*lineHeight(item):baseline==="line-bottom"?.29*h-.5*lineHeight(item):0)}const textAlign={left:"start",center:"middle",right:"end"};const tempBounds=new Bounds;function anchorPoint(item){var x=item.x||0,y=item.y||0,r=item.radius||0,t;if(r){t=(item.theta||0)-HalfPi;x+=r*Math.cos(t);y+=r*Math.sin(t)}tempBounds.x1=x;tempBounds.y1=y;return tempBounds}function attr$5(emit,item){var dx=item.dx||0,dy=(item.dy||0)+offset$1(item),p=anchorPoint(item),x=p.x1,y=p.y1,a=item.angle||0,t;emit("text-anchor",textAlign[item.align]||"start");if(a){t=translate(x,y)+" "+rotate(a);if(dx||dy)t+=" "+translate(dx,dy)}else{t=translate(x+dx,y+dy)}emit("transform",t)}function bound$5(bounds,item,mode){var h=textMetrics.height(item),a=item.align,p=anchorPoint(item),x=p.x1,y=p.y1,dx=item.dx||0,dy=(item.dy||0)+offset$1(item)-Math.round(.8*h),tl=textLines(item),w;if(vegaUtil.isArray(tl)){h+=lineHeight(item)*(tl.length-1);w=tl.reduce((w,t)=>Math.max(w,textMetrics.width(item,t)),0)}else{w=textMetrics.width(item,tl)}if(a==="center"){dx-=w/2}else if(a==="right"){dx-=w}else;bounds.set(dx+=x,dy+=y,dx+w,dy+h);if(item.angle&&!mode){bounds.rotate(item.angle*DegToRad,x,y)}else if(mode===2){return bounds.rotatedPoints(item.angle*DegToRad,x,y)}return bounds}function draw$4(context,scene,bounds){visit(scene,item=>{var opacity=item.opacity==null?1:item.opacity,p,x,y,i,lh,tl,str;if(bounds&&!bounds.intersects(item.bounds)||opacity===0||item.fontSize<=0||item.text==null||item.text.length===0)return;context.font=font(item);context.textAlign=item.align||"left";p=anchorPoint(item);x=p.x1,y=p.y1;if(item.angle){context.save();context.translate(x,y);context.rotate(item.angle*DegToRad);x=y=0}x+=item.dx||0;y+=(item.dy||0)+offset$1(item);tl=textLines(item);blend(context,item);if(vegaUtil.isArray(tl)){lh=lineHeight(item);for(i=0;i<tl.length;++i){str=textValue(item,tl[i]);if(item.fill&&fill(context,item,opacity)){context.fillText(str,x,y)}if(item.stroke&&stroke(context,item,opacity)){context.strokeText(str,x,y)}y+=lh}}else{str=textValue(item,tl);if(item.fill&&fill(context,item,opacity)){context.fillText(str,x,y)}if(item.stroke&&stroke(context,item,opacity)){context.strokeText(str,x,y)}}if(item.angle)context.restore()})}function hit$1(context,item,x,y,gx,gy){if(item.fontSize<=0)return false;if(!item.angle)return true;var p=anchorPoint(item),ax=p.x1,ay=p.y1,b=bound$5(tempBounds,item,1),a=-item.angle*DegToRad,cos=Math.cos(a),sin=Math.sin(a),px=cos*gx-sin*gy+(ax-cos*ax+sin*ay),py=sin*gx+cos*gy+(ay-sin*ax-cos*ay);return b.contains(px,py)}function intersectText(item,box){const p=bound$5(tempBounds,item,2);return intersectBoxLine(box,p[0],p[1],p[2],p[3])||intersectBoxLine(box,p[0],p[1],p[4],p[5])||intersectBoxLine(box,p[4],p[5],p[6],p[7])||intersectBoxLine(box,p[2],p[3],p[6],p[7])}var text={type:"text",tag:"text",nested:false,attr:attr$5,bound:bound$5,draw:draw$4,pick:pick(hit$1),isect:intersectText};var trail$1=markMultiItemPath("trail",trail,pickTrail);var Marks={arc:arc$1,area:area$1,group:group,image:image,line:line$1,path:path$1,rect:rect,rule:rule,shape:shape$1,symbol:symbol$1,text:text,trail:trail$1};function boundItem(item,func,opt){var type=Marks[item.mark.marktype],bound=func||type.bound;if(type.nested)item=item.mark;return bound(item.bounds||(item.bounds=new Bounds),item,opt)}var DUMMY={mark:null};function boundMark(mark,bounds,opt){var type=Marks[mark.marktype],bound=type.bound,items=mark.items,hasItems=items&&items.length,i,n,item,b;if(type.nested){if(hasItems){item=items[0]}else{DUMMY.mark=mark;item=DUMMY}b=boundItem(item,bound,opt);bounds=bounds&&bounds.union(b)||b;return bounds}bounds=bounds||mark.bounds&&mark.bounds.clear()||new Bounds;if(hasItems){for(i=0,n=items.length;i<n;++i){bounds.union(boundItem(items[i],bound,opt))}}return mark.bounds=bounds}const keys=["marktype","name","role","interactive","clip","items","zindex","x","y","width","height","align","baseline","fill","fillOpacity","opacity","blend","stroke","strokeOpacity","strokeWidth","strokeCap","strokeDash","strokeDashOffset","strokeForeground","strokeOffset","startAngle","endAngle","innerRadius","outerRadius","cornerRadius","padAngle","cornerRadiusTopLeft","cornerRadiusTopRight","cornerRadiusBottomLeft","cornerRadiusBottomRight","interpolate","tension","orient","defined","url","aspect","smooth","path","scaleX","scaleY","x2","y2","size","shape","text","angle","theta","radius","dir","dx","dy","ellipsis","limit","lineBreak","lineHeight","font","fontSize","fontWeight","fontStyle","fontVariant","description","aria","ariaRole","ariaRoleDescription"];function sceneToJSON(scene,indent){return JSON.stringify(scene,keys,indent)}function sceneFromJSON(json){const scene=typeof json==="string"?JSON.parse(json):json;return initialize(scene)}function initialize(scene){var type=scene.marktype,items=scene.items,parent,i,n;if(items){for(i=0,n=items.length;i<n;++i){parent=type?"mark":"group";items[i][parent]=scene;if(items[i].zindex)items[i][parent].zdirty=true;if("group"===(type||parent))initialize(items[i])}}if(type)boundMark(scene);return scene}function Scenegraph(scene){if(arguments.length){this.root=sceneFromJSON(scene)}else{this.root=createMark({marktype:"group",name:"root",role:"frame"});this.root.items=[new GroupItem(this.root)]}}Scenegraph.prototype={toJSON(indent){return sceneToJSON(this.root,indent||0)},mark(markdef,group,index){group=group||this.root.items[0];const mark=createMark(markdef,group);group.items[index]=mark;if(mark.zindex)mark.group.zdirty=true;return mark}};function createMark(def,group){const mark={bounds:new Bounds,clip:!!def.clip,group:group,interactive:def.interactive===false?false:true,items:[],marktype:def.marktype,name:def.name||undefined,role:def.role||undefined,zindex:def.zindex||0};if(def.aria!=null){mark.aria=def.aria}if(def.description){mark.description=def.description}return mark}function domCreate(doc,tag,ns){if(!doc&&typeof document!=="undefined"&&document.createElement){doc=document}return doc?ns?doc.createElementNS(ns,tag):doc.createElement(tag):null}function domFind(el,tag){tag=tag.toLowerCase();var nodes=el.childNodes,i=0,n=nodes.length;for(;i<n;++i)if(nodes[i].tagName.toLowerCase()===tag){return nodes[i]}}function domChild(el,index,tag,ns){var a=el.childNodes[index],b;if(!a||a.tagName.toLowerCase()!==tag.toLowerCase()){b=a||null;a=domCreate(el.ownerDocument,tag,ns);el.insertBefore(a,b)}return a}function domClear(el,index){var nodes=el.childNodes,curr=nodes.length;while(curr>index)el.removeChild(nodes[--curr]);return el}function cssClass(mark){return"mark-"+mark.marktype+(mark.role?" role-"+mark.role:"")+(mark.name?" "+mark.name:"")}function point(event,el){const rect=el.getBoundingClientRect();return[event.clientX-rect.left-(el.clientLeft||0),event.clientY-rect.top-(el.clientTop||0)]}function resolveItem(item,event,el,origin){var mark=item&&item.mark,mdef,p;if(mark&&(mdef=Marks[mark.marktype]).tip){p=point(event,el);p[0]-=origin[0];p[1]-=origin[1];while(item=item.mark.group){p[0]-=item.x||0;p[1]-=item.y||0}item=mdef.tip(mark.items,p)}return item}function Handler(customLoader,customTooltip){this._active=null;this._handlers={};this._loader=customLoader||vegaLoader.loader();this._tooltip=customTooltip||defaultTooltip}function defaultTooltip(handler,event,item,value){handler.element().setAttribute("title",value||"")}Handler.prototype={initialize(el,origin,obj){this._el=el;this._obj=obj||null;return this.origin(origin)},element(){return this._el},canvas(){return this._el&&this._el.firstChild},origin(origin){if(arguments.length){this._origin=origin||[0,0];return this}else{return this._origin.slice()}},scene(scene){if(!arguments.length)return this._scene;this._scene=scene;return this},on(){},off(){},_handlerIndex(h,type,handler){for(let i=h?h.length:0;--i>=0;){if(h[i].type===type&&(!handler||h[i].handler===handler)){return i}}return-1},handlers(type){const h=this._handlers,a=[];if(type){a.push(...h[this.eventName(type)])}else{for(const k in h){a.push(...h[k])}}return a},eventName(name){const i=name.indexOf(".");return i<0?name:name.slice(0,i)},handleHref(event,item,href){this._loader.sanitize(href,{context:"href"}).then(opt=>{const e=new MouseEvent(event.type,event),a=domCreate(null,"a");for(const name in opt)a.setAttribute(name,opt[name]);a.dispatchEvent(e)}).catch(()=>{})},handleTooltip(event,item,show){if(item&&item.tooltip!=null){item=resolveItem(item,event,this.canvas(),this._origin);const value=show&&item&&item.tooltip||null;this._tooltip.call(this._obj,this,event,item,value)}},getItemBoundingClientRect(item){const el=this.canvas();if(!el)return;const rect=el.getBoundingClientRect(),origin=this._origin,bounds=item.bounds,width=bounds.width(),height=bounds.height();let x=bounds.x1+origin[0]+rect.left,y=bounds.y1+origin[1]+rect.top;while(item.mark&&(item=item.mark.group)){x+=item.x||0;y+=item.y||0}return{x:x,y:y,width:width,height:height,left:x,top:y,right:x+width,bottom:y+height}}};function Renderer(loader){this._el=null;this._bgcolor=null;this._loader=new ResourceLoader(loader)}Renderer.prototype={initialize(el,width,height,origin,scaleFactor){this._el=el;return this.resize(width,height,origin,scaleFactor)},element(){return this._el},canvas(){return this._el&&this._el.firstChild},background(bgcolor){if(arguments.length===0)return this._bgcolor;this._bgcolor=bgcolor;return this},resize(width,height,origin,scaleFactor){this._width=width;this._height=height;this._origin=origin||[0,0];this._scale=scaleFactor||1;return this},dirty(){},render(scene){const r=this;r._call=function(){r._render(scene)};r._call();r._call=null;return r},_render(){},renderAsync(scene){const r=this.render(scene);return this._ready?this._ready.then(()=>r):Promise.resolve(r)},_load(method,uri){var r=this,p=r._loader[method](uri);if(!r._ready){const call=r._call;r._ready=r._loader.ready().then(redraw=>{if(redraw)call();r._ready=null})}return p},sanitizeURL(uri){return this._load("sanitizeURL",uri)},loadImage(uri){return this._load("loadImage",uri)}};const KeyDownEvent="keydown";const KeyPressEvent="keypress";const KeyUpEvent="keyup";const DragEnterEvent="dragenter";const DragLeaveEvent="dragleave";const DragOverEvent="dragover";const MouseDownEvent="mousedown";const MouseUpEvent="mouseup";const MouseMoveEvent="mousemove";const MouseOutEvent="mouseout";const MouseOverEvent="mouseover";const ClickEvent="click";const DoubleClickEvent="dblclick";const WheelEvent="wheel";const MouseWheelEvent="mousewheel";const TouchStartEvent="touchstart";const TouchMoveEvent="touchmove";const TouchEndEvent="touchend";const Events=[KeyDownEvent,KeyPressEvent,KeyUpEvent,DragEnterEvent,DragLeaveEvent,DragOverEvent,MouseDownEvent,MouseUpEvent,MouseMoveEvent,MouseOutEvent,MouseOverEvent,ClickEvent,DoubleClickEvent,WheelEvent,MouseWheelEvent,TouchStartEvent,TouchMoveEvent,TouchEndEvent];const TooltipShowEvent=MouseMoveEvent;const TooltipHideEvent=MouseOutEvent;const HrefEvent=ClickEvent;function CanvasHandler(loader,tooltip){Handler.call(this,loader,tooltip);this._down=null;this._touch=null;this._first=true;this._events={}}const eventBundle=type=>type===TouchStartEvent||type===TouchMoveEvent||type===TouchEndEvent?[TouchStartEvent,TouchMoveEvent,TouchEndEvent]:[type];function eventListenerCheck(handler,type){eventBundle(type).forEach(_=>addEventListener(handler,_))}function addEventListener(handler,type){const canvas=handler.canvas();if(canvas&&!handler._events[type]){handler._events[type]=1;canvas.addEventListener(type,handler[type]?evt=>handler[type](evt):evt=>handler.fire(type,evt))}}function move(moveEvent,overEvent,outEvent){return function(evt){const a=this._active,p=this.pickEvent(evt);if(p===a){this.fire(moveEvent,evt)}else{if(!a||!a.exit){this.fire(outEvent,evt)}this._active=p;this.fire(overEvent,evt);this.fire(moveEvent,evt)}}}function inactive(type){return function(evt){this.fire(type,evt);this._active=null}}vegaUtil.inherits(CanvasHandler,Handler,{initialize(el,origin,obj){this._canvas=el&&domFind(el,"canvas");[ClickEvent,MouseDownEvent,MouseMoveEvent,MouseOutEvent,DragLeaveEvent].forEach(type=>eventListenerCheck(this,type));return Handler.prototype.initialize.call(this,el,origin,obj)},canvas(){return this._canvas},context(){return this._canvas.getContext("2d")},events:Events,DOMMouseScroll(evt){this.fire(MouseWheelEvent,evt)},mousemove:move(MouseMoveEvent,MouseOverEvent,MouseOutEvent),dragover:move(DragOverEvent,DragEnterEvent,DragLeaveEvent),mouseout:inactive(MouseOutEvent),dragleave:inactive(DragLeaveEvent),mousedown(evt){this._down=this._active;this.fire(MouseDownEvent,evt)},click(evt){if(this._down===this._active){this.fire(ClickEvent,evt);this._down=null}},touchstart(evt){this._touch=this.pickEvent(evt.changedTouches[0]);if(this._first){this._active=this._touch;this._first=false}this.fire(TouchStartEvent,evt,true)},touchmove(evt){this.fire(TouchMoveEvent,evt,true)},touchend(evt){this.fire(TouchEndEvent,evt,true);this._touch=null},fire(type,evt,touch){const a=touch?this._touch:this._active,h=this._handlers[type];evt.vegaType=type;if(type===HrefEvent&&a&&a.href){this.handleHref(evt,a,a.href)}else if(type===TooltipShowEvent||type===TooltipHideEvent){this.handleTooltip(evt,a,type!==TooltipHideEvent)}if(h){for(let i=0,len=h.length;i<len;++i){h[i].handler.call(this._obj,evt,a)}}},on(type,handler){const name=this.eventName(type),h=this._handlers,i=this._handlerIndex(h[name],type,handler);if(i<0){eventListenerCheck(this,type);(h[name]||(h[name]=[])).push({type:type,handler:handler})}return this},off(type,handler){const name=this.eventName(type),h=this._handlers[name],i=this._handlerIndex(h,type,handler);if(i>=0){h.splice(i,1)}return this},pickEvent(evt){const p=point(evt,this._canvas),o=this._origin;return this.pick(this._scene,p[0],p[1],p[0]-o[0],p[1]-o[1])},pick(scene,x,y,gx,gy){const g=this.context(),mark=Marks[scene.marktype];return mark.pick.call(this,g,scene,x,y,gx,gy)}});function devicePixelRatio(){return typeof window!=="undefined"?window.devicePixelRatio||1:1}var pixelRatio=devicePixelRatio();function resize(canvas,width,height,origin,scaleFactor,opt){const inDOM=typeof HTMLElement!=="undefined"&&canvas instanceof HTMLElement&&canvas.parentNode!=null,context=canvas.getContext("2d"),ratio=inDOM?pixelRatio:scaleFactor;canvas.width=width*ratio;canvas.height=height*ratio;for(const key in opt){context[key]=opt[key]}if(inDOM&&ratio!==1){canvas.style.width=width+"px";canvas.style.height=height+"px"}context.pixelRatio=ratio;context.setTransform(ratio,0,0,ratio,ratio*origin[0],ratio*origin[1]);return canvas}function CanvasRenderer(loader){Renderer.call(this,loader);this._options={};this._redraw=false;this._dirty=new Bounds;this._tempb=new Bounds}const base=Renderer.prototype;const viewBounds=(origin,width,height)=>(new Bounds).set(0,0,width,height).translate(-origin[0],-origin[1]);function clipToBounds(g,b,origin){b.expand(1).round();if(g.pixelRatio%1){b.scale(g.pixelRatio).round().scale(1/g.pixelRatio)}b.translate(-(origin[0]%1),-(origin[1]%1));g.beginPath();g.rect(b.x1,b.y1,b.width(),b.height());g.clip();return b}vegaUtil.inherits(CanvasRenderer,Renderer,{initialize(el,width,height,origin,scaleFactor,options){this._options=options||{};this._canvas=this._options.externalContext?null:vegaCanvas.canvas(1,1,this._options.type);if(el&&this._canvas){domClear(el,0).appendChild(this._canvas);this._canvas.setAttribute("class","marks")}return base.initialize.call(this,el,width,height,origin,scaleFactor)},resize(width,height,origin,scaleFactor){base.resize.call(this,width,height,origin,scaleFactor);if(this._canvas){resize(this._canvas,this._width,this._height,this._origin,this._scale,this._options.context)}else{const ctx=this._options.externalContext;if(!ctx)vegaUtil.error("CanvasRenderer is missing a valid canvas or context");ctx.scale(this._scale,this._scale);ctx.translate(this._origin[0],this._origin[1])}this._redraw=true;return this},canvas(){return this._canvas},context(){return this._options.externalContext||(this._canvas?this._canvas.getContext("2d"):null)},dirty(item){const b=this._tempb.clear().union(item.bounds);let g=item.mark.group;while(g){b.translate(g.x||0,g.y||0);g=g.mark.group}this._dirty.union(b)},_render(scene){const g=this.context(),o=this._origin,w=this._width,h=this._height,db=this._dirty,vb=viewBounds(o,w,h);g.save();const b=this._redraw||db.empty()?(this._redraw=false,vb.expand(1)):clipToBounds(g,vb.intersect(db),o);this.clear(-o[0],-o[1],w,h);this.draw(g,scene,b);g.restore();db.clear();return this},draw(ctx,scene,bounds){const mark=Marks[scene.marktype];if(scene.clip)clip$1(ctx,scene);mark.draw.call(this,ctx,scene,bounds);if(scene.clip)ctx.restore()},clear(x,y,w,h){const opt=this._options,g=this.context();if(opt.type!=="pdf"&&!opt.externalContext){g.clearRect(x,y,w,h)}if(this._bgcolor!=null){g.fillStyle=this._bgcolor;g.fillRect(x,y,w,h)}}});function SVGHandler(loader,tooltip){Handler.call(this,loader,tooltip);const h=this;h._hrefHandler=listener(h,(evt,item)=>{if(item&&item.href)h.handleHref(evt,item,item.href)});h._tooltipHandler=listener(h,(evt,item)=>{h.handleTooltip(evt,item,evt.type!==TooltipHideEvent)})}const listener=(context,handler)=>evt=>{let item=evt.target.__data__;item=Array.isArray(item)?item[0]:item;evt.vegaType=evt.type;handler.call(context._obj,evt,item)};vegaUtil.inherits(SVGHandler,Handler,{initialize(el,origin,obj){let svg=this._svg;if(svg){svg.removeEventListener(HrefEvent,this._hrefHandler);svg.removeEventListener(TooltipShowEvent,this._tooltipHandler);svg.removeEventListener(TooltipHideEvent,this._tooltipHandler)}this._svg=svg=el&&domFind(el,"svg");if(svg){svg.addEventListener(HrefEvent,this._hrefHandler);svg.addEventListener(TooltipShowEvent,this._tooltipHandler);svg.addEventListener(TooltipHideEvent,this._tooltipHandler)}return Handler.prototype.initialize.call(this,el,origin,obj)},canvas(){return this._svg},on(type,handler){const name=this.eventName(type),h=this._handlers,i=this._handlerIndex(h[name],type,handler);if(i<0){const x={type:type,handler:handler,listener:listener(this,handler)};(h[name]||(h[name]=[])).push(x);if(this._svg){this._svg.addEventListener(name,x.listener)}}return this},off(type,handler){const name=this.eventName(type),h=this._handlers[name],i=this._handlerIndex(h,type,handler);if(i>=0){if(this._svg){this._svg.removeEventListener(name,h[i].listener)}h.splice(i,1)}return this}});const ARIA_HIDDEN="aria-hidden";const ARIA_LABEL="aria-label";const ARIA_ROLE="role";const ARIA_ROLEDESCRIPTION="aria-roledescription";const GRAPHICS_OBJECT="graphics-object";const GRAPHICS_SYMBOL="graphics-symbol";const bundle=(role,roledesc,label)=>({[ARIA_ROLE]:role,[ARIA_ROLEDESCRIPTION]:roledesc,[ARIA_LABEL]:label||undefined});const AriaIgnore=vegaUtil.toSet(["axis-domain","axis-grid","axis-label","axis-tick","axis-title","legend-band","legend-entry","legend-gradient","legend-label","legend-title","legend-symbol","title"]);const AriaGuides={axis:{desc:"axis",caption:axisCaption},legend:{desc:"legend",caption:legendCaption},"title-text":{desc:"title",caption:item=>`Title text '${titleCaption(item)}'`},"title-subtitle":{desc:"subtitle",caption:item=>`Subtitle text '${titleCaption(item)}'`}};const AriaEncode={ariaRole:ARIA_ROLE,ariaRoleDescription:ARIA_ROLEDESCRIPTION,description:ARIA_LABEL};function ariaItemAttributes(emit,item){const hide=item.aria===false;emit(ARIA_HIDDEN,hide||undefined);if(hide||item.description==null){for(const prop in AriaEncode){emit(AriaEncode[prop],undefined)}}else{const type=item.mark.marktype;emit(ARIA_LABEL,item.description);emit(ARIA_ROLE,item.ariaRole||(type==="group"?GRAPHICS_OBJECT:GRAPHICS_SYMBOL));emit(ARIA_ROLEDESCRIPTION,item.ariaRoleDescription||`${type} mark`)}}function ariaMarkAttributes(mark){return mark.aria===false?{[ARIA_HIDDEN]:true}:AriaIgnore[mark.role]?null:AriaGuides[mark.role]?ariaGuide(mark,AriaGuides[mark.role]):ariaMark(mark)}function ariaMark(mark){const type=mark.marktype;const recurse=type==="group"||type==="text"||mark.items.some(_=>_.description!=null&&_.aria!==false);return bundle(recurse?GRAPHICS_OBJECT:GRAPHICS_SYMBOL,`${type} mark container`,mark.description)}function ariaGuide(mark,opt){try{const item=mark.items[0],caption=opt.caption||(()=>"");return bundle(opt.role||GRAPHICS_SYMBOL,opt.desc,item.description||caption(item))}catch(err){return null}}function titleCaption(item){return vegaUtil.array(item.text).join(" ")}function axisCaption(item){const datum=item.datum,orient=item.orient,title=datum.title?extractTitle(item):null,ctx=item.context,scale=ctx.scales[datum.scale].value,locale=ctx.dataflow.locale(),type=scale.type,xy=orient==="left"||orient==="right"?"Y":"X";return`${xy}-axis`+(title?` titled '${title}'`:"")+` for a ${vegaScale.isDiscrete(type)?"discrete":type} scale`+` with ${vegaScale.domainCaption(locale,scale,item)}`}function legendCaption(item){const datum=item.datum,title=datum.title?extractTitle(item):null,type=`${datum.type||""} legend`.trim(),scales=datum.scales,props=Object.keys(scales),ctx=item.context,scale=ctx.scales[scales[props[0]]].value,locale=ctx.dataflow.locale();return capitalize(type)+(title?` titled '${title}'`:"")+` for ${channelCaption(props)}`+` with ${vegaScale.domainCaption(locale,scale,item)}`}function extractTitle(item){try{return vegaUtil.array(vegaUtil.peek(item.items).items[0].text).join(" ")}catch(err){return null}}function channelCaption(props){props=props.map(p=>p+(p==="fill"||p==="stroke"?" color":""));return props.length<2?props[0]:props.slice(0,-1).join(", ")+" and "+vegaUtil.peek(props)}function capitalize(s){return s.length?s[0].toUpperCase()+s.slice(1):s}const innerText=val=>(val+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");const attrText=val=>innerText(val).replace(/"/g,"&quot;").replace(/\t/g,"&#x9;").replace(/\n/g,"&#xA;").replace(/\r/g,"&#xD;");function markup(){let buf="",outer="",inner="";const stack=[],clear=()=>outer=inner="",push=tag=>{if(outer){buf+=`${outer}>${inner}`;clear()}stack.push(tag)},attr=(name,value)=>{if(value!=null)outer+=` ${name}="${attrText(value)}"`;return m},m={open(tag,...attrs){push(tag);outer="<"+tag;for(const set of attrs){for(const key in set)attr(key,set[key])}return m},close(){const tag=stack.pop();if(outer){buf+=outer+(inner?`>${inner}</${tag}>`:"/>")}else{buf+=`</${tag}>`}clear();return m},attr:attr,text:t=>(inner+=innerText(t),m),toString:()=>buf};return m}const serializeXML=node=>_serialize(markup(),node)+"";function _serialize(m,node){m.open(node.tagName);if(node.hasAttributes()){const attrs=node.attributes,n=attrs.length;for(let i=0;i<n;++i){m.attr(attrs[i].name,attrs[i].value)}}if(node.hasChildNodes()){const children=node.childNodes,n=children.length;for(let i=0;i<n;i++){const child=children[i];child.nodeType===3?m.text(child.nodeValue):_serialize(m,child)}}return m.close()}const styles={fill:"fill",fillOpacity:"fill-opacity",stroke:"stroke",strokeOpacity:"stroke-opacity",strokeWidth:"stroke-width",strokeCap:"stroke-linecap",strokeJoin:"stroke-linejoin",strokeDash:"stroke-dasharray",strokeDashOffset:"stroke-dashoffset",strokeMiterLimit:"stroke-miterlimit",opacity:"opacity",blend:"mix-blend-mode"};const rootAttributes={fill:"none","stroke-miterlimit":10};const RootIndex=0,xmlns="http://www.w3.org/2000/xmlns/",svgns=metadata.xmlns;function SVGRenderer(loader){Renderer.call(this,loader);this._dirtyID=0;this._dirty=[];this._svg=null;this._root=null;this._defs=null}const base$1=Renderer.prototype;vegaUtil.inherits(SVGRenderer,Renderer,{initialize(el,width,height,origin,scaleFactor){this._defs={};this._clearDefs();if(el){this._svg=domChild(el,0,"svg",svgns);this._svg.setAttributeNS(xmlns,"xmlns",svgns);this._svg.setAttributeNS(xmlns,"xmlns:xlink",metadata["xmlns:xlink"]);this._svg.setAttribute("version",metadata["version"]);this._svg.setAttribute("class","marks");domClear(el,1);this._root=domChild(this._svg,RootIndex,"g",svgns);setAttributes(this._root,rootAttributes);domClear(this._svg,RootIndex+1)}this.background(this._bgcolor);return base$1.initialize.call(this,el,width,height,origin,scaleFactor)},background(bgcolor){if(arguments.length&&this._svg){this._svg.style.setProperty("background-color",bgcolor)}return base$1.background.apply(this,arguments)},resize(width,height,origin,scaleFactor){base$1.resize.call(this,width,height,origin,scaleFactor);if(this._svg){setAttributes(this._svg,{width:this._width*this._scale,height:this._height*this._scale,viewBox:`0 0 ${this._width} ${this._height}`});this._root.setAttribute("transform",`translate(${this._origin})`)}this._dirty=[];return this},canvas(){return this._svg},svg(){const svg=this._svg,bg=this._bgcolor;if(!svg)return null;let node;if(bg){svg.removeAttribute("style");node=domChild(svg,RootIndex,"rect",svgns);setAttributes(node,{width:this._width,height:this._height,fill:bg})}const text=serializeXML(svg);if(bg){svg.removeChild(node);this._svg.style.setProperty("background-color",bg)}return text},_render(scene){if(this._dirtyCheck()){if(this._dirtyAll)this._clearDefs();this.mark(this._root,scene);domClear(this._root,1)}this.defs();this._dirty=[];++this._dirtyID;return this},dirty(item){if(item.dirty!==this._dirtyID){item.dirty=this._dirtyID;this._dirty.push(item)}},isDirty(item){return this._dirtyAll||!item._svg||item.dirty===this._dirtyID},_dirtyCheck(){this._dirtyAll=true;const items=this._dirty;if(!items.length||!this._dirtyID)return true;const id=++this._dirtyID;let item,mark,type,mdef,i,n,o;for(i=0,n=items.length;i<n;++i){item=items[i];mark=item.mark;if(mark.marktype!==type){type=mark.marktype;mdef=Marks[type]}if(mark.zdirty&&mark.dirty!==id){this._dirtyAll=false;dirtyParents(item,id);mark.items.forEach(i=>{i.dirty=id})}if(mark.zdirty)continue;if(item.exit){if(mdef.nested&&mark.items.length){o=mark.items[0];if(o._svg)this._update(mdef,o._svg,o)}else if(item._svg){o=item._svg.parentNode;if(o)o.removeChild(item._svg)}item._svg=null;continue}item=mdef.nested?mark.items[0]:item;if(item._update===id)continue;if(!item._svg||!item._svg.ownerSVGElement){this._dirtyAll=false;dirtyParents(item,id)}else{this._update(mdef,item._svg,item)}item._update=id}return!this._dirtyAll},mark(el,scene,prev){if(!this.isDirty(scene))return scene._svg;const svg=this._svg,mdef=Marks[scene.marktype],events=scene.interactive===false?"none":null,isGroup=mdef.tag==="g";let sibling=null,i=0;const parent=bind(scene,el,prev,"g",svg);parent.setAttribute("class",cssClass(scene));const aria=ariaMarkAttributes(scene);for(const key in aria)setAttribute(parent,key,aria[key]);if(!isGroup){setAttribute(parent,"pointer-events",events)}setAttribute(parent,"clip-path",scene.clip?clip(this,scene,scene.group):null);const process=item=>{const dirty=this.isDirty(item),node=bind(item,parent,sibling,mdef.tag,svg);if(dirty){this._update(mdef,node,item);if(isGroup)recurse(this,node,item)}sibling=node;++i};if(mdef.nested){if(scene.items.length)process(scene.items[0])}else{visit(scene,process)}domClear(parent,i);return parent},_update(mdef,el,item){element=el;values=el.__values__;ariaItemAttributes(emit,item);mdef.attr(emit,item,this);const extra=mark_extras[mdef.type];if(extra)extra.call(this,mdef,el,item);if(element)this.style(element,item)},style(el,item){if(item==null)return;for(const prop in styles){let value=prop==="font"?fontFamily(item):item[prop];if(value===values[prop])continue;const name=styles[prop];if(value==null){el.removeAttribute(name)}else{if(isGradient(value)){value=gradientRef(value,this._defs.gradient,href())}el.setAttribute(name,value+"")}values[prop]=value}},defs(){const svg=this._svg,defs=this._defs;let el=defs.el,index=0;for(const id in defs.gradient){if(!el)defs.el=el=domChild(svg,RootIndex+1,"defs",svgns);index=updateGradient(el,defs.gradient[id],index)}for(const id in defs.clipping){if(!el)defs.el=el=domChild(svg,RootIndex+1,"defs",svgns);index=updateClipping(el,defs.clipping[id],index)}if(el){index===0?(svg.removeChild(el),defs.el=null):domClear(el,index)}},_clearDefs(){const def=this._defs;def.gradient={};def.clipping={}}});function dirtyParents(item,id){for(;item&&item.dirty!==id;item=item.mark.group){item.dirty=id;if(item.mark&&item.mark.dirty!==id){item.mark.dirty=id}else return}}function updateGradient(el,grad,index){let i,n,stop;if(grad.gradient==="radial"){let pt=domChild(el,index++,"pattern",svgns);setAttributes(pt,{id:patternPrefix+grad.id,viewBox:"0,0,1,1",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid slice"});pt=domChild(pt,0,"rect",svgns);setAttributes(pt,{width:1,height:1,fill:`url(${href()}#${grad.id})`});el=domChild(el,index++,"radialGradient",svgns);setAttributes(el,{id:grad.id,fx:grad.x1,fy:grad.y1,fr:grad.r1,cx:grad.x2,cy:grad.y2,r:grad.r2})}else{el=domChild(el,index++,"linearGradient",svgns);setAttributes(el,{id:grad.id,x1:grad.x1,x2:grad.x2,y1:grad.y1,y2:grad.y2})}for(i=0,n=grad.stops.length;i<n;++i){stop=domChild(el,i,"stop",svgns);stop.setAttribute("offset",grad.stops[i].offset);stop.setAttribute("stop-color",grad.stops[i].color)}domClear(el,i);return index}function updateClipping(el,clip,index){let mask;el=domChild(el,index,"clipPath",svgns);el.setAttribute("id",clip.id);if(clip.path){mask=domChild(el,0,"path",svgns);mask.setAttribute("d",clip.path)}else{mask=domChild(el,0,"rect",svgns);setAttributes(mask,{x:0,y:0,width:clip.width,height:clip.height})}domClear(el,1);return index+1}function recurse(renderer,el,group){el=el.lastChild.previousSibling;let prev,idx=0;visit(group,item=>{prev=renderer.mark(el,item,prev);++idx});domClear(el,1+idx)}function bind(item,el,sibling,tag,svg){let node=item._svg,doc;if(!node){doc=el.ownerDocument;node=domCreate(doc,tag,svgns);item._svg=node;if(item.mark){node.__data__=item;node.__values__={fill:"default"};if(tag==="g"){const bg=domCreate(doc,"path",svgns);node.appendChild(bg);bg.__data__=item;const cg=domCreate(doc,"g",svgns);node.appendChild(cg);cg.__data__=item;const fg=domCreate(doc,"path",svgns);node.appendChild(fg);fg.__data__=item;fg.__values__={fill:"default"}}}}if(node.ownerSVGElement!==svg||siblingCheck(node,sibling)){el.insertBefore(node,sibling?sibling.nextSibling:el.firstChild)}return node}function siblingCheck(node,sibling){return node.parentNode&&node.parentNode.childNodes.length>1&&node.previousSibling!=sibling}let element=null,values=null;const mark_extras={group(mdef,el,item){const fg=element=el.childNodes[2];values=fg.__values__;mdef.foreground(emit,item,this);values=el.__values__;element=el.childNodes[1];mdef.content(emit,item,this);const bg=element=el.childNodes[0];mdef.background(emit,item,this);const value=item.mark.interactive===false?"none":null;if(value!==values.events){setAttribute(fg,"pointer-events",value);setAttribute(bg,"pointer-events",value);values.events=value}if(item.strokeForeground&&item.stroke){const fill=item.fill;setAttribute(fg,"display",null);this.style(bg,item);setAttribute(bg,"stroke",null);if(fill)item.fill=null;values=fg.__values__;this.style(fg,item);if(fill)item.fill=fill;element=null}else{setAttribute(fg,"display","none")}},image(mdef,el,item){if(item.smooth===false){setStyle(el,"image-rendering","optimizeSpeed");setStyle(el,"image-rendering","pixelated")}else{setStyle(el,"image-rendering",null)}},text(mdef,el,item){const tl=textLines(item);let key,value,doc,lh;if(vegaUtil.isArray(tl)){value=tl.map(_=>textValue(item,_));key=value.join("\n");if(key!==values.text){domClear(el,0);doc=el.ownerDocument;lh=lineHeight(item);value.forEach((t,i)=>{const ts=domCreate(doc,"tspan",svgns);ts.__data__=item;ts.textContent=t;if(i){ts.setAttribute("x",0);ts.setAttribute("dy",lh)}el.appendChild(ts)});values.text=key}}else{value=textValue(item,tl);if(value!==values.text){el.textContent=value;values.text=value}}setAttribute(el,"font-family",fontFamily(item));setAttribute(el,"font-size",fontSize(item)+"px");setAttribute(el,"font-style",item.fontStyle);setAttribute(el,"font-variant",item.fontVariant);setAttribute(el,"font-weight",item.fontWeight)}};function emit(name,value,ns){if(value===values[name])return;if(ns){setAttributeNS(element,name,value,ns)}else{setAttribute(element,name,value)}values[name]=value}function setStyle(el,name,value){if(value!==values[name]){if(value==null){el.style.removeProperty(name)}else{el.style.setProperty(name,value+"")}values[name]=value}}function setAttributes(el,attrs){for(const key in attrs){setAttribute(el,key,attrs[key])}}function setAttribute(el,name,value){if(value!=null){el.setAttribute(name,value)}else{el.removeAttribute(name)}}function setAttributeNS(el,name,value,ns){if(value!=null){el.setAttributeNS(ns,name,value)}else{el.removeAttributeNS(ns,name)}}function href(){let loc;return typeof window==="undefined"?"":(loc=window.location).hash?loc.href.slice(0,-loc.hash.length):loc.href}function SVGStringRenderer(loader){Renderer.call(this,loader);this._text=null;this._defs={gradient:{},clipping:{}}}vegaUtil.inherits(SVGStringRenderer,Renderer,{svg(){return this._text},_render(scene){const m=markup();m.open("svg",vegaUtil.extend({},metadata,{class:"marks",width:this._width*this._scale,height:this._height*this._scale,viewBox:`0 0 ${this._width} ${this._height}`}));const bg=this._bgcolor;if(bg&&bg!=="transparent"&&bg!=="none"){m.open("rect",{width:this._width,height:this._height,fill:bg}).close()}m.open("g",rootAttributes,{transform:"translate("+this._origin+")"});this.mark(m,scene);m.close();this.defs(m);this._text=m.close()+"";return this},mark(m,scene){const mdef=Marks[scene.marktype],tag=mdef.tag,attrList=[ariaItemAttributes,mdef.attr];m.open("g",{class:cssClass(scene),"clip-path":scene.clip?clip(this,scene,scene.group):null},ariaMarkAttributes(scene),{"pointer-events":tag!=="g"&&scene.interactive===false?"none":null});const process=item=>{const href=this.href(item);if(href)m.open("a",href);m.open(tag,this.attr(scene,item,attrList,tag!=="g"?tag:null));if(tag==="text"){const tl=textLines(item);if(vegaUtil.isArray(tl)){const attrs={x:0,dy:lineHeight(item)};for(let i=0;i<tl.length;++i){m.open("tspan",i?attrs:null).text(textValue(item,tl[i])).close()}}else{m.text(textValue(item,tl))}}else if(tag==="g"){const fore=item.strokeForeground,fill=item.fill,stroke=item.stroke;if(fore&&stroke){item.stroke=null}m.open("path",this.attr(scene,item,mdef.background,"bgrect")).close();m.open("g",this.attr(scene,item,mdef.content));visit(item,scene=>this.mark(m,scene));m.close();if(fore&&stroke){if(fill)item.fill=null;item.stroke=stroke;m.open("path",this.attr(scene,item,mdef.foreground,"bgrect")).close();if(fill)item.fill=fill}else{m.open("path",this.attr(scene,item,mdef.foreground,"bgfore")).close()}}m.close();if(href)m.close()};if(mdef.nested){if(scene.items&&scene.items.length)process(scene.items[0])}else{visit(scene,process)}return m.close()},href(item){const href=item.href;let attr;if(href){if(attr=this._hrefs&&this._hrefs[href]){return attr}else{this.sanitizeURL(href).then(attr=>{attr["xlink:href"]=attr.href;attr.href=null;(this._hrefs||(this._hrefs={}))[href]=attr})}}return null},attr(scene,item,attrs,tag){const object={},emit=(name,value,ns,prefixed)=>{object[prefixed||name]=value};if(Array.isArray(attrs)){attrs.forEach(fn=>fn(emit,item,this))}else{attrs(emit,item,this)}if(tag){style(object,item,scene,tag,this._defs)}return object},defs(m){const gradient=this._defs.gradient,clipping=this._defs.clipping,count=Object.keys(gradient).length+Object.keys(clipping).length;if(count===0)return;m.open("defs");for(const id in gradient){const def=gradient[id],stops=def.stops;if(def.gradient==="radial"){m.open("pattern",{id:patternPrefix+id,viewBox:"0,0,1,1",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid slice"});m.open("rect",{width:"1",height:"1",fill:"url(#"+id+")"}).close();m.close();m.open("radialGradient",{id:id,fx:def.x1,fy:def.y1,fr:def.r1,cx:def.x2,cy:def.y2,r:def.r2})}else{m.open("linearGradient",{id:id,x1:def.x1,x2:def.x2,y1:def.y1,y2:def.y2})}for(let i=0;i<stops.length;++i){m.open("stop",{offset:stops[i].offset,"stop-color":stops[i].color}).close()}m.close()}for(const id in clipping){const def=clipping[id];m.open("clipPath",{id:id});if(def.path){m.open("path",{d:def.path}).close()}else{m.open("rect",{x:0,y:0,width:def.width,height:def.height}).close()}m.close()}m.close()}});function style(s,item,scene,tag,defs){if(item==null)return s;if(tag==="bgrect"&&scene.interactive===false){s["pointer-events"]="none"}if(tag==="bgfore"){if(scene.interactive===false){s["pointer-events"]="none"}s.display="none";if(item.fill!==null)return s}if(tag==="image"&&item.smooth===false){s.style="image-rendering: optimizeSpeed; image-rendering: pixelated;"}if(tag==="text"){s["font-family"]=fontFamily(item);s["font-size"]=fontSize(item)+"px";s["font-style"]=item.fontStyle;s["font-variant"]=item.fontVariant;s["font-weight"]=item.fontWeight}for(const prop in styles){let value=item[prop];const name=styles[prop];if(value==="transparent"&&(name==="fill"||name==="stroke"));else if(value!=null){if(isGradient(value)){value=gradientRef(value,defs.gradient,"")}s[name]=value}}return s}const Canvas="canvas";const PNG="png";const SVG="svg";const None="none";const RenderType={Canvas:Canvas,PNG:PNG,SVG:SVG,None:None};const modules={};modules[Canvas]=modules[PNG]={renderer:CanvasRenderer,headless:CanvasRenderer,handler:CanvasHandler};modules[SVG]={renderer:SVGRenderer,headless:SVGStringRenderer,handler:SVGHandler};modules[None]={};function renderModule(name,_){name=String(name||"").toLowerCase();if(arguments.length>1){modules[name]=_;return this}else{return modules[name]}}function intersect(scene,bounds,filter){const hits=[],box=(new Bounds).union(bounds),type=scene.marktype;return type?intersectMark(scene,box,filter,hits):type==="group"?intersectGroup(scene,box,filter,hits):vegaUtil.error("Intersect scene must be mark node or group item.")}function intersectMark(mark,box,filter,hits){if(visitMark(mark,box,filter)){const items=mark.items,type=mark.marktype,n=items.length;let i=0;if(type==="group"){for(;i<n;++i){intersectGroup(items[i],box,filter,hits)}}else{for(const test=Marks[type].isect;i<n;++i){const item=items[i];if(intersectItem(item,box,test))hits.push(item)}}}return hits}function visitMark(mark,box,filter){return mark.bounds&&box.intersects(mark.bounds)&&(mark.marktype==="group"||mark.interactive!==false&&(!filter||filter(mark)))}function intersectGroup(group,box,filter,hits){if(filter&&filter(group.mark)&&intersectItem(group,box,Marks.group.isect)){hits.push(group)}const marks=group.items,n=marks&&marks.length;if(n){const x=group.x||0,y=group.y||0;box.translate(-x,-y);for(let i=0;i<n;++i){intersectMark(marks[i],box,filter,hits)}box.translate(x,y)}return hits}function intersectItem(item,box,test){const bounds=item.bounds;return box.encloses(bounds)||box.intersects(bounds)&&test(item,box)}const clipBounds=new Bounds;function boundClip(mark){const clip=mark.clip;if(vegaUtil.isFunction(clip)){clip(boundContext(clipBounds.clear()))}else if(clip){clipBounds.set(0,0,mark.group.width,mark.group.height)}else return;mark.bounds.intersect(clipBounds)}const TOLERANCE=1e-9;function sceneEqual(a,b,key){return a===b?true:key==="path"?pathEqual(a,b):a instanceof Date&&b instanceof Date?+a===+b:vegaUtil.isNumber(a)&&vegaUtil.isNumber(b)?Math.abs(a-b)<=TOLERANCE:!a||!b||!vegaUtil.isObject(a)&&!vegaUtil.isObject(b)?a==b:objectEqual(a,b)}function pathEqual(a,b){return sceneEqual(pathParse(a),pathParse(b))}function objectEqual(a,b){var ka=Object.keys(a),kb=Object.keys(b),key,i;if(ka.length!==kb.length)return false;ka.sort();kb.sort();for(i=ka.length-1;i>=0;i--){if(ka[i]!=kb[i])return false}for(i=ka.length-1;i>=0;i--){key=ka[i];if(!sceneEqual(a[key],b[key],key))return false}return typeof a===typeof b}function resetSVGDefIds(){resetSVGClipId();resetSVGGradientId()}exports.Bounds=Bounds;exports.CanvasHandler=CanvasHandler;exports.CanvasRenderer=CanvasRenderer;exports.Gradient=Gradient;exports.GroupItem=GroupItem;exports.Handler=Handler;exports.Item=Item;exports.Marks=Marks;exports.RenderType=RenderType;exports.Renderer=Renderer;exports.ResourceLoader=ResourceLoader;exports.SVGHandler=SVGHandler;exports.SVGRenderer=SVGRenderer;exports.SVGStringRenderer=SVGStringRenderer;exports.Scenegraph=Scenegraph;exports.boundClip=boundClip;exports.boundContext=boundContext;exports.boundItem=boundItem;exports.boundMark=boundMark;exports.boundStroke=boundStroke;exports.domChild=domChild;exports.domClear=domClear;exports.domCreate=domCreate;exports.domFind=domFind;exports.font=font;exports.fontFamily=fontFamily;exports.fontSize=fontSize;exports.intersect=intersect;exports.intersectBoxLine=intersectBoxLine;exports.intersectPath=intersectPath;exports.intersectPoint=intersectPoint;exports.intersectRule=intersectRule;exports.lineHeight=lineHeight;exports.markup=markup;exports.multiLineOffset=multiLineOffset;exports.pathCurves=curves;exports.pathEqual=pathEqual;exports.pathParse=pathParse;exports.pathRectangle=vg_rect;exports.pathRender=pathRender;exports.pathSymbols=symbols;exports.pathTrail=vg_trail;exports.point=point;exports.renderModule=renderModule;exports.resetSVGClipId=resetSVGClipId;exports.resetSVGDefIds=resetSVGDefIds;exports.sceneEqual=sceneEqual;exports.sceneFromJSON=sceneFromJSON;exports.scenePickVisit=pickVisit;exports.sceneToJSON=sceneToJSON;exports.sceneVisit=visit;exports.sceneZOrder=zorder;exports.serializeXML=serializeXML;exports.textMetrics=textMetrics;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var vegaUtil=__webpack_require__(36);var vegaDataflow=__webpack_require__(39);var tx=__webpack_require__(94);var vtx=__webpack_require__(97);var encode=__webpack_require__(104);var geo=__webpack_require__(107);var force=__webpack_require__(113);var tree=__webpack_require__(117);var label=__webpack_require__(119);var reg=__webpack_require__(120);var voronoi=__webpack_require__(121);var wordcloud=__webpack_require__(123);var xf=__webpack_require__(124);var vegaStatistics=__webpack_require__(43);var vegaTime=__webpack_require__(47);var vegaLoader=__webpack_require__(58);var vegaScenegraph=__webpack_require__(48);var vegaScale=__webpack_require__(44);var vegaProjection=__webpack_require__(75);var vegaView=__webpack_require__(126);var vegaFormat=__webpack_require__(50);var vegaFunctions=__webpack_require__(61);var vegaParser=__webpack_require__(131);var vegaRuntime=__webpack_require__(78);function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e){Object.keys(e).forEach((function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}}))}n["default"]=e;return Object.freeze(n)}var tx__namespace=_interopNamespace(tx);var vtx__namespace=_interopNamespace(vtx);var encode__namespace=_interopNamespace(encode);var geo__namespace=_interopNamespace(geo);var force__namespace=_interopNamespace(force);var tree__namespace=_interopNamespace(tree);var label__namespace=_interopNamespace(label);var reg__namespace=_interopNamespace(reg);var voronoi__namespace=_interopNamespace(voronoi);var wordcloud__namespace=_interopNamespace(wordcloud);var xf__namespace=_interopNamespace(xf);var name="vega";var version="5.19.1";var description="The Vega visualization grammar.";var keywords=["vega","visualization","interaction","dataflow","library","data","d3"];var license="BSD-3-Clause";var author="UW Interactive Data Lab (http://idl.cs.washington.edu)";var main="build/vega-node.js";var module$1="build/vega.module.js";var unpkg="build/vega.min.js";var jsdelivr="build/vega.min.js";var types="index.d.ts";var repository="vega/vega";var scripts={bundle:"rollup -c --config-bundle",prebuild:"rimraf build && rimraf build-es5",build:"rollup -c --config-core --config-bundle --config-ie",postbuild:"node schema-copy",pretest:"yarn build --config-test",test:"TZ=America/Los_Angeles tape 'test/**/*-test.js'",prepublishOnly:"yarn test && yarn build",postpublish:"./schema-deploy.sh"};var dependencies={"vega-crossfilter":"~4.0.5","vega-dataflow":"~5.7.3","vega-encode":"~4.8.3","vega-event-selector":"~2.0.6","vega-expression":"~4.0.1","vega-force":"~4.0.7","vega-format":"~1.0.4","vega-functions":"~5.12.0","vega-geo":"~4.3.8","vega-hierarchy":"~4.0.9","vega-label":"~1.0.0","vega-loader":"~4.4.0","vega-parser":"~6.1.3","vega-projection":"~1.4.5","vega-regression":"~1.0.9","vega-runtime":"~6.1.3","vega-scale":"~7.1.1","vega-scenegraph":"~4.9.3","vega-statistics":"~1.7.9","vega-time":"~2.0.4","vega-transforms":"~4.9.3","vega-typings":"~0.19.2","vega-util":"~1.16.0","vega-view":"~5.9.2","vega-view-transforms":"~4.5.8","vega-voronoi":"~4.1.5","vega-wordcloud":"~4.1.3"};var devDependencies={"vega-schema":"*"};var gitHead="f112ee55fc5ddd025df8820fce371803106a3968";var pkg={name:name,version:version,description:description,keywords:keywords,license:license,author:author,main:main,module:module$1,unpkg:unpkg,jsdelivr:jsdelivr,types:types,repository:repository,scripts:scripts,dependencies:dependencies,devDependencies:devDependencies,gitHead:gitHead};vegaUtil.extend(vegaDataflow.transforms,tx__namespace,vtx__namespace,encode__namespace,geo__namespace,force__namespace,label__namespace,tree__namespace,reg__namespace,voronoi__namespace,wordcloud__namespace,xf__namespace);const version$1=pkg.version;Object.keys(vegaUtil).forEach((function(k){if(k!=="default")Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaUtil[k]}})}));Object.keys(vegaStatistics).forEach((function(k){if(k!=="default")Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaStatistics[k]}})}));Object.keys(vegaTime).forEach((function(k){if(k!=="default")Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaTime[k]}})}));Object.keys(vegaLoader).forEach((function(k){if(k!=="default")Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaLoader[k]}})}));Object.keys(vegaScenegraph).forEach((function(k){if(k!=="default")Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaScenegraph[k]}})}));Object.defineProperty(exports,"Dataflow",{enumerable:true,get:function(){return vegaDataflow.Dataflow}});Object.defineProperty(exports,"EventStream",{enumerable:true,get:function(){return vegaDataflow.EventStream}});Object.defineProperty(exports,"MultiPulse",{enumerable:true,get:function(){return vegaDataflow.MultiPulse}});Object.defineProperty(exports,"Operator",{enumerable:true,get:function(){return vegaDataflow.Operator}});Object.defineProperty(exports,"Parameters",{enumerable:true,get:function(){return vegaDataflow.Parameters}});Object.defineProperty(exports,"Pulse",{enumerable:true,get:function(){return vegaDataflow.Pulse}});Object.defineProperty(exports,"Transform",{enumerable:true,get:function(){return vegaDataflow.Transform}});Object.defineProperty(exports,"changeset",{enumerable:true,get:function(){return vegaDataflow.changeset}});Object.defineProperty(exports,"definition",{enumerable:true,get:function(){return vegaDataflow.definition}});Object.defineProperty(exports,"ingest",{enumerable:true,get:function(){return vegaDataflow.ingest}});Object.defineProperty(exports,"isTuple",{enumerable:true,get:function(){return vegaDataflow.isTuple}});Object.defineProperty(exports,"transform",{enumerable:true,get:function(){return vegaDataflow.transform}});Object.defineProperty(exports,"transforms",{enumerable:true,get:function(){return vegaDataflow.transforms}});Object.defineProperty(exports,"tupleid",{enumerable:true,get:function(){return vegaDataflow.tupleid}});Object.defineProperty(exports,"interpolate",{enumerable:true,get:function(){return vegaScale.interpolate}});Object.defineProperty(exports,"interpolateColors",{enumerable:true,get:function(){return vegaScale.interpolateColors}});Object.defineProperty(exports,"interpolateRange",{enumerable:true,get:function(){return vegaScale.interpolateRange}});Object.defineProperty(exports,"quantizeInterpolator",{enumerable:true,get:function(){return vegaScale.quantizeInterpolator}});Object.defineProperty(exports,"scale",{enumerable:true,get:function(){return vegaScale.scale}});Object.defineProperty(exports,"scheme",{enumerable:true,get:function(){return vegaScale.scheme}});Object.defineProperty(exports,"projection",{enumerable:true,get:function(){return vegaProjection.projection}});Object.defineProperty(exports,"View",{enumerable:true,get:function(){return vegaView.View}});Object.defineProperty(exports,"defaultLocale",{enumerable:true,get:function(){return vegaFormat.defaultLocale}});Object.defineProperty(exports,"formatLocale",{enumerable:true,get:function(){return vegaFormat.numberFormatDefaultLocale}});Object.defineProperty(exports,"locale",{enumerable:true,get:function(){return vegaFormat.locale}});Object.defineProperty(exports,"resetDefaultLocale",{enumerable:true,get:function(){return vegaFormat.resetDefaultLocale}});Object.defineProperty(exports,"timeFormatLocale",{enumerable:true,get:function(){return vegaFormat.timeFormatDefaultLocale}});Object.defineProperty(exports,"expressionFunction",{enumerable:true,get:function(){return vegaFunctions.expressionFunction}});Object.defineProperty(exports,"parse",{enumerable:true,get:function(){return vegaParser.parse}});Object.defineProperty(exports,"runtimeContext",{enumerable:true,get:function(){return vegaRuntime.context}});exports.version=version$1},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(89),__webpack_require__(90),__webpack_require__(47),__webpack_require__(36),__webpack_require__(72)):undefined})(this,(function(exports,d3Array,d3Format,vegaTime,vegaUtil,d3TimeFormat){"use strict";function memoize(method){const cache={};return spec=>cache[spec]||(cache[spec]=method(spec))}function trimZeroes(numberFormat,decimalChar){return x=>{const str=numberFormat(x),dec=str.indexOf(decimalChar);if(dec<0)return str;let idx=rightmostDigit(str,dec);const end=idx<str.length?str.slice(idx):"";while(--idx>dec)if(str[idx]!=="0"){++idx;break}return str.slice(0,idx)+end}}function rightmostDigit(str,dec){let i=str.lastIndexOf("e"),c;if(i>0)return i;for(i=str.length;--i>dec;){c=str.charCodeAt(i);if(c>=48&&c<=57)return i+1}}function numberLocale(locale){const format=memoize(locale.format),formatPrefix=locale.formatPrefix;return{format:format,formatPrefix:formatPrefix,formatFloat(spec){const s=d3Format.formatSpecifier(spec||",");if(s.precision==null){s.precision=12;switch(s.type){case"%":s.precision-=2;break;case"e":s.precision-=1;break}return trimZeroes(format(s),format(".1f")(1)[1])}else{return format(s)}},formatSpan(start,stop,count,specifier){specifier=d3Format.formatSpecifier(specifier==null?",f":specifier);const step=d3Array.tickStep(start,stop,count),value=Math.max(Math.abs(start),Math.abs(stop));let precision;if(specifier.precision==null){switch(specifier.type){case"s":{if(!isNaN(precision=d3Format.precisionPrefix(step,value))){specifier.precision=precision}return formatPrefix(specifier,value)}case"":case"e":case"g":case"p":case"r":{if(!isNaN(precision=d3Format.precisionRound(step,value))){specifier.precision=precision-(specifier.type==="e")}break}case"f":case"%":{if(!isNaN(precision=d3Format.precisionFixed(step))){specifier.precision=precision-(specifier.type==="%")*2}break}}}return format(specifier)}}}let defaultNumberLocale;resetNumberFormatDefaultLocale();function resetNumberFormatDefaultLocale(){return defaultNumberLocale=numberLocale({format:d3Format.format,formatPrefix:d3Format.formatPrefix})}function numberFormatLocale(definition){return numberLocale(d3Format.formatLocale(definition))}function numberFormatDefaultLocale(definition){return arguments.length?defaultNumberLocale=numberFormatLocale(definition):defaultNumberLocale}function timeMultiFormat(format,interval,spec){spec=spec||{};if(!vegaUtil.isObject(spec)){vegaUtil.error(`Invalid time multi-format specifier: ${spec}`)}const second=interval(vegaTime.SECONDS),minute=interval(vegaTime.MINUTES),hour=interval(vegaTime.HOURS),day=interval(vegaTime.DATE),week=interval(vegaTime.WEEK),month=interval(vegaTime.MONTH),quarter=interval(vegaTime.QUARTER),year=interval(vegaTime.YEAR),L=format(spec[vegaTime.MILLISECONDS]||".%L"),S=format(spec[vegaTime.SECONDS]||":%S"),M=format(spec[vegaTime.MINUTES]||"%I:%M"),H=format(spec[vegaTime.HOURS]||"%I %p"),d=format(spec[vegaTime.DATE]||spec[vegaTime.DAY]||"%a %d"),w=format(spec[vegaTime.WEEK]||"%b %d"),m=format(spec[vegaTime.MONTH]||"%B"),q=format(spec[vegaTime.QUARTER]||"%B"),y=format(spec[vegaTime.YEAR]||"%Y");return date=>(second(date)<date?L:minute(date)<date?S:hour(date)<date?M:day(date)<date?H:month(date)<date?week(date)<date?d:w:year(date)<date?quarter(date)<date?m:q:y)(date)}function timeLocale(locale){const timeFormat=memoize(locale.format),utcFormat=memoize(locale.utcFormat);return{timeFormat:spec=>vegaUtil.isString(spec)?timeFormat(spec):timeMultiFormat(timeFormat,vegaTime.timeInterval,spec),utcFormat:spec=>vegaUtil.isString(spec)?utcFormat(spec):timeMultiFormat(utcFormat,vegaTime.utcInterval,spec),timeParse:memoize(locale.parse),utcParse:memoize(locale.utcParse)}}let defaultTimeLocale;resetTimeFormatDefaultLocale();function resetTimeFormatDefaultLocale(){return defaultTimeLocale=timeLocale({format:d3TimeFormat.timeFormat,parse:d3TimeFormat.timeParse,utcFormat:d3TimeFormat.utcFormat,utcParse:d3TimeFormat.utcParse})}function timeFormatLocale(definition){return timeLocale(d3TimeFormat.timeFormatLocale(definition))}function timeFormatDefaultLocale(definition){return arguments.length?defaultTimeLocale=timeFormatLocale(definition):defaultTimeLocale}const createLocale=(number,time)=>vegaUtil.extend({},number,time);function locale(numberSpec,timeSpec){const number=numberSpec?numberFormatLocale(numberSpec):numberFormatDefaultLocale();const time=timeSpec?timeFormatLocale(timeSpec):timeFormatDefaultLocale();return createLocale(number,time)}function defaultLocale(numberSpec,timeSpec){const args=arguments.length;if(args&&args!==2){vegaUtil.error("defaultLocale expects either zero or two arguments.")}return args?createLocale(numberFormatDefaultLocale(numberSpec),timeFormatDefaultLocale(timeSpec)):createLocale(numberFormatDefaultLocale(),timeFormatDefaultLocale())}function resetDefaultLocale(){resetNumberFormatDefaultLocale();resetTimeFormatDefaultLocale();return defaultLocale()}exports.defaultLocale=defaultLocale;exports.locale=locale;exports.numberFormatDefaultLocale=numberFormatDefaultLocale;exports.numberFormatLocale=numberFormatLocale;exports.resetDefaultLocale=resetDefaultLocale;exports.resetNumberFormatDefaultLocale=resetNumberFormatDefaultLocale;exports.resetTimeFormatDefaultLocale=resetTimeFormatDefaultLocale;exports.timeFormatDefaultLocale=timeFormatDefaultLocale;exports.timeFormatLocale=timeFormatLocale;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(109)):undefined})(this,(function(exports,d3Array){"use strict";var epsilon=1e-6;var epsilon2=1e-12;var pi=Math.PI;var halfPi=pi/2;var quarterPi=pi/4;var tau=pi*2;var degrees=180/pi;var radians=pi/180;var abs=Math.abs;var atan=Math.atan;var atan2=Math.atan2;var cos=Math.cos;var ceil=Math.ceil;var exp=Math.exp;var hypot=Math.hypot;var log=Math.log;var pow=Math.pow;var sin=Math.sin;var sign=Math.sign||function(x){return x>0?1:x<0?-1:0};var sqrt=Math.sqrt;var tan=Math.tan;function acos(x){return x>1?0:x<-1?pi:Math.acos(x)}function asin(x){return x>1?halfPi:x<-1?-halfPi:Math.asin(x)}function haversin(x){return(x=sin(x/2))*x}function noop(){}function streamGeometry(geometry,stream){if(geometry&&streamGeometryType.hasOwnProperty(geometry.type)){streamGeometryType[geometry.type](geometry,stream)}}var streamObjectType={Feature:function(object,stream){streamGeometry(object.geometry,stream)},FeatureCollection:function(object,stream){var features=object.features,i=-1,n=features.length;while(++i<n)streamGeometry(features[i].geometry,stream)}};var streamGeometryType={Sphere:function(object,stream){stream.sphere()},Point:function(object,stream){object=object.coordinates;stream.point(object[0],object[1],object[2])},MultiPoint:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)object=coordinates[i],stream.point(object[0],object[1],object[2])},LineString:function(object,stream){streamLine(object.coordinates,stream,0)},MultiLineString:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamLine(coordinates[i],stream,0)},Polygon:function(object,stream){streamPolygon(object.coordinates,stream)},MultiPolygon:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamPolygon(coordinates[i],stream)},GeometryCollection:function(object,stream){var geometries=object.geometries,i=-1,n=geometries.length;while(++i<n)streamGeometry(geometries[i],stream)}};function streamLine(coordinates,stream,closed){var i=-1,n=coordinates.length-closed,coordinate;stream.lineStart();while(++i<n)coordinate=coordinates[i],stream.point(coordinate[0],coordinate[1],coordinate[2]);stream.lineEnd()}function streamPolygon(coordinates,stream){var i=-1,n=coordinates.length;stream.polygonStart();while(++i<n)streamLine(coordinates[i],stream,1);stream.polygonEnd()}function geoStream(object,stream){if(object&&streamObjectType.hasOwnProperty(object.type)){streamObjectType[object.type](object,stream)}else{streamGeometry(object,stream)}}var areaRingSum=new d3Array.Adder;var areaSum=new d3Array.Adder,lambda00,phi00,lambda0,cosPhi0,sinPhi0;var areaStream={point:noop,lineStart:noop,lineEnd:noop,polygonStart:function(){areaRingSum=new d3Array.Adder;areaStream.lineStart=areaRingStart;areaStream.lineEnd=areaRingEnd},polygonEnd:function(){var areaRing=+areaRingSum;areaSum.add(areaRing<0?tau+areaRing:areaRing);this.lineStart=this.lineEnd=this.point=noop},sphere:function(){areaSum.add(tau)}};function areaRingStart(){areaStream.point=areaPointFirst}function areaRingEnd(){areaPoint(lambda00,phi00)}function areaPointFirst(lambda,phi){areaStream.point=areaPoint;lambda00=lambda,phi00=phi;lambda*=radians,phi*=radians;lambda0=lambda,cosPhi0=cos(phi=phi/2+quarterPi),sinPhi0=sin(phi)}function areaPoint(lambda,phi){lambda*=radians,phi*=radians;phi=phi/2+quarterPi;var dLambda=lambda-lambda0,sdLambda=dLambda>=0?1:-1,adLambda=sdLambda*dLambda,cosPhi=cos(phi),sinPhi=sin(phi),k=sinPhi0*sinPhi,u=cosPhi0*cosPhi+k*cos(adLambda),v=k*sdLambda*sin(adLambda);areaRingSum.add(atan2(v,u));lambda0=lambda,cosPhi0=cosPhi,sinPhi0=sinPhi}function area(object){areaSum=new d3Array.Adder;geoStream(object,areaStream);return areaSum*2}function spherical(cartesian){return[atan2(cartesian[1],cartesian[0]),asin(cartesian[2])]}function cartesian(spherical){var lambda=spherical[0],phi=spherical[1],cosPhi=cos(phi);return[cosPhi*cos(lambda),cosPhi*sin(lambda),sin(phi)]}function cartesianDot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]}function cartesianAddInPlace(a,b){a[0]+=b[0],a[1]+=b[1],a[2]+=b[2]}function cartesianScale(vector,k){return[vector[0]*k,vector[1]*k,vector[2]*k]}function cartesianNormalizeInPlace(d){var l=sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l,d[1]/=l,d[2]/=l}var lambda0$1,phi0,lambda1,phi1,lambda2,lambda00$1,phi00$1,p0,deltaSum,ranges,range;var boundsStream={point:boundsPoint,lineStart:boundsLineStart,lineEnd:boundsLineEnd,polygonStart:function(){boundsStream.point=boundsRingPoint;boundsStream.lineStart=boundsRingStart;boundsStream.lineEnd=boundsRingEnd;deltaSum=new d3Array.Adder;areaStream.polygonStart()},polygonEnd:function(){areaStream.polygonEnd();boundsStream.point=boundsPoint;boundsStream.lineStart=boundsLineStart;boundsStream.lineEnd=boundsLineEnd;if(areaRingSum<0)lambda0$1=-(lambda1=180),phi0=-(phi1=90);else if(deltaSum>epsilon)phi1=90;else if(deltaSum<-epsilon)phi0=-90;range[0]=lambda0$1,range[1]=lambda1},sphere:function(){lambda0$1=-(lambda1=180),phi0=-(phi1=90)}};function boundsPoint(lambda,phi){ranges.push(range=[lambda0$1=lambda,lambda1=lambda]);if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi}function linePoint(lambda,phi){var p=cartesian([lambda*radians,phi*radians]);if(p0){var normal=cartesianCross(p0,p),equatorial=[normal[1],-normal[0],0],inflection=cartesianCross(equatorial,normal);cartesianNormalizeInPlace(inflection);inflection=spherical(inflection);var delta=lambda-lambda2,sign=delta>0?1:-1,lambdai=inflection[0]*degrees*sign,phii,antimeridian=abs(delta)>180;if(antimeridian^(sign*lambda2<lambdai&&lambdai<sign*lambda)){phii=inflection[1]*degrees;if(phii>phi1)phi1=phii}else if(lambdai=(lambdai+360)%360-180,antimeridian^(sign*lambda2<lambdai&&lambdai<sign*lambda)){phii=-inflection[1]*degrees;if(phii<phi0)phi0=phii}else{if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi}if(antimeridian){if(lambda<lambda2){if(angle(lambda0$1,lambda)>angle(lambda0$1,lambda1))lambda1=lambda}else{if(angle(lambda,lambda1)>angle(lambda0$1,lambda1))lambda0$1=lambda}}else{if(lambda1>=lambda0$1){if(lambda<lambda0$1)lambda0$1=lambda;if(lambda>lambda1)lambda1=lambda}else{if(lambda>lambda2){if(angle(lambda0$1,lambda)>angle(lambda0$1,lambda1))lambda1=lambda}else{if(angle(lambda,lambda1)>angle(lambda0$1,lambda1))lambda0$1=lambda}}}}else{ranges.push(range=[lambda0$1=lambda,lambda1=lambda])}if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi;p0=p,lambda2=lambda}function boundsLineStart(){boundsStream.point=linePoint}function boundsLineEnd(){range[0]=lambda0$1,range[1]=lambda1;boundsStream.point=boundsPoint;p0=null}function boundsRingPoint(lambda,phi){if(p0){var delta=lambda-lambda2;deltaSum.add(abs(delta)>180?delta+(delta>0?360:-360):delta)}else{lambda00$1=lambda,phi00$1=phi}areaStream.point(lambda,phi);linePoint(lambda,phi)}function boundsRingStart(){areaStream.lineStart()}function boundsRingEnd(){boundsRingPoint(lambda00$1,phi00$1);areaStream.lineEnd();if(abs(deltaSum)>epsilon)lambda0$1=-(lambda1=180);range[0]=lambda0$1,range[1]=lambda1;p0=null}function angle(lambda0,lambda1){return(lambda1-=lambda0)<0?lambda1+360:lambda1}function rangeCompare(a,b){return a[0]-b[0]}function rangeContains(range,x){return range[0]<=range[1]?range[0]<=x&&x<=range[1]:x<range[0]||range[1]<x}function bounds(feature){var i,n,a,b,merged,deltaMax,delta;phi1=lambda1=-(lambda0$1=phi0=Infinity);ranges=[];geoStream(feature,boundsStream);if(n=ranges.length){ranges.sort(rangeCompare);for(i=1,a=ranges[0],merged=[a];i<n;++i){b=ranges[i];if(rangeContains(a,b[0])||rangeContains(a,b[1])){if(angle(a[0],b[1])>angle(a[0],a[1]))a[1]=b[1];if(angle(b[0],a[1])>angle(a[0],a[1]))a[0]=b[0]}else{merged.push(a=b)}}for(deltaMax=-Infinity,n=merged.length-1,i=0,a=merged[n];i<=n;a=b,++i){b=merged[i];if((delta=angle(a[1],b[0]))>deltaMax)deltaMax=delta,lambda0$1=b[0],lambda1=a[1]}}ranges=range=null;return lambda0$1===Infinity||phi0===Infinity?[[NaN,NaN],[NaN,NaN]]:[[lambda0$1,phi0],[lambda1,phi1]]}var W0,W1,X0,Y0,Z0,X1,Y1,Z1,X2,Y2,Z2,lambda00$2,phi00$2,x0,y0,z0;var centroidStream={sphere:noop,point:centroidPoint,lineStart:centroidLineStart,lineEnd:centroidLineEnd,polygonStart:function(){centroidStream.lineStart=centroidRingStart;centroidStream.lineEnd=centroidRingEnd},polygonEnd:function(){centroidStream.lineStart=centroidLineStart;centroidStream.lineEnd=centroidLineEnd}};function centroidPoint(lambda,phi){lambda*=radians,phi*=radians;var cosPhi=cos(phi);centroidPointCartesian(cosPhi*cos(lambda),cosPhi*sin(lambda),sin(phi))}function centroidPointCartesian(x,y,z){++W0;X0+=(x-X0)/W0;Y0+=(y-Y0)/W0;Z0+=(z-Z0)/W0}function centroidLineStart(){centroidStream.point=centroidLinePointFirst}function centroidLinePointFirst(lambda,phi){lambda*=radians,phi*=radians;var cosPhi=cos(phi);x0=cosPhi*cos(lambda);y0=cosPhi*sin(lambda);z0=sin(phi);centroidStream.point=centroidLinePoint;centroidPointCartesian(x0,y0,z0)}function centroidLinePoint(lambda,phi){lambda*=radians,phi*=radians;var cosPhi=cos(phi),x=cosPhi*cos(lambda),y=cosPhi*sin(lambda),z=sin(phi),w=atan2(sqrt((w=y0*z-z0*y)*w+(w=z0*x-x0*z)*w+(w=x0*y-y0*x)*w),x0*x+y0*y+z0*z);W1+=w;X1+=w*(x0+(x0=x));Y1+=w*(y0+(y0=y));Z1+=w*(z0+(z0=z));centroidPointCartesian(x0,y0,z0)}function centroidLineEnd(){centroidStream.point=centroidPoint}function centroidRingStart(){centroidStream.point=centroidRingPointFirst}function centroidRingEnd(){centroidRingPoint(lambda00$2,phi00$2);centroidStream.point=centroidPoint}function centroidRingPointFirst(lambda,phi){lambda00$2=lambda,phi00$2=phi;lambda*=radians,phi*=radians;centroidStream.point=centroidRingPoint;var cosPhi=cos(phi);x0=cosPhi*cos(lambda);y0=cosPhi*sin(lambda);z0=sin(phi);centroidPointCartesian(x0,y0,z0)}function centroidRingPoint(lambda,phi){lambda*=radians,phi*=radians;var cosPhi=cos(phi),x=cosPhi*cos(lambda),y=cosPhi*sin(lambda),z=sin(phi),cx=y0*z-z0*y,cy=z0*x-x0*z,cz=x0*y-y0*x,m=hypot(cx,cy,cz),w=asin(m),v=m&&-w/m;X2.add(v*cx);Y2.add(v*cy);Z2.add(v*cz);W1+=w;X1+=w*(x0+(x0=x));Y1+=w*(y0+(y0=y));Z1+=w*(z0+(z0=z));centroidPointCartesian(x0,y0,z0)}function centroid(object){W0=W1=X0=Y0=Z0=X1=Y1=Z1=0;X2=new d3Array.Adder;Y2=new d3Array.Adder;Z2=new d3Array.Adder;geoStream(object,centroidStream);var x=+X2,y=+Y2,z=+Z2,m=hypot(x,y,z);if(m<epsilon2){x=X1,y=Y1,z=Z1;if(W1<epsilon)x=X0,y=Y0,z=Z0;m=hypot(x,y,z);if(m<epsilon2)return[NaN,NaN]}return[atan2(y,x)*degrees,asin(z/m)*degrees]}function constant(x){return function(){return x}}function compose(a,b){function compose(x,y){return x=a(x,y),b(x[0],x[1])}if(a.invert&&b.invert)compose.invert=function(x,y){return x=b.invert(x,y),x&&a.invert(x[0],x[1])};return compose}function rotationIdentity(lambda,phi){return[abs(lambda)>pi?lambda+Math.round(-lambda/tau)*tau:lambda,phi]}rotationIdentity.invert=rotationIdentity;function rotateRadians(deltaLambda,deltaPhi,deltaGamma){return(deltaLambda%=tau)?deltaPhi||deltaGamma?compose(rotationLambda(deltaLambda),rotationPhiGamma(deltaPhi,deltaGamma)):rotationLambda(deltaLambda):deltaPhi||deltaGamma?rotationPhiGamma(deltaPhi,deltaGamma):rotationIdentity}function forwardRotationLambda(deltaLambda){return function(lambda,phi){return lambda+=deltaLambda,[lambda>pi?lambda-tau:lambda<-pi?lambda+tau:lambda,phi]}}function rotationLambda(deltaLambda){var rotation=forwardRotationLambda(deltaLambda);rotation.invert=forwardRotationLambda(-deltaLambda);return rotation}function rotationPhiGamma(deltaPhi,deltaGamma){var cosDeltaPhi=cos(deltaPhi),sinDeltaPhi=sin(deltaPhi),cosDeltaGamma=cos(deltaGamma),sinDeltaGamma=sin(deltaGamma);function rotation(lambda,phi){var cosPhi=cos(phi),x=cos(lambda)*cosPhi,y=sin(lambda)*cosPhi,z=sin(phi),k=z*cosDeltaPhi+x*sinDeltaPhi;return[atan2(y*cosDeltaGamma-k*sinDeltaGamma,x*cosDeltaPhi-z*sinDeltaPhi),asin(k*cosDeltaGamma+y*sinDeltaGamma)]}rotation.invert=function(lambda,phi){var cosPhi=cos(phi),x=cos(lambda)*cosPhi,y=sin(lambda)*cosPhi,z=sin(phi),k=z*cosDeltaGamma-y*sinDeltaGamma;return[atan2(y*cosDeltaGamma+z*sinDeltaGamma,x*cosDeltaPhi+k*sinDeltaPhi),asin(k*cosDeltaPhi-x*sinDeltaPhi)]};return rotation}function rotation(rotate){rotate=rotateRadians(rotate[0]*radians,rotate[1]*radians,rotate.length>2?rotate[2]*radians:0);function forward(coordinates){coordinates=rotate(coordinates[0]*radians,coordinates[1]*radians);return coordinates[0]*=degrees,coordinates[1]*=degrees,coordinates}forward.invert=function(coordinates){coordinates=rotate.invert(coordinates[0]*radians,coordinates[1]*radians);return coordinates[0]*=degrees,coordinates[1]*=degrees,coordinates};return forward}function circleStream(stream,radius,delta,direction,t0,t1){if(!delta)return;var cosRadius=cos(radius),sinRadius=sin(radius),step=direction*delta;if(t0==null){t0=radius+direction*tau;t1=radius-step/2}else{t0=circleRadius(cosRadius,t0);t1=circleRadius(cosRadius,t1);if(direction>0?t0<t1:t0>t1)t0+=direction*tau}for(var point,t=t0;direction>0?t>t1:t<t1;t-=step){point=spherical([cosRadius,-sinRadius*cos(t),-sinRadius*sin(t)]);stream.point(point[0],point[1])}}function circleRadius(cosRadius,point){point=cartesian(point),point[0]-=cosRadius;cartesianNormalizeInPlace(point);var radius=acos(-point[1]);return((-point[2]<0?-radius:radius)+tau-epsilon)%tau}function circle(){var center=constant([0,0]),radius=constant(90),precision=constant(6),ring,rotate,stream={point:point};function point(x,y){ring.push(x=rotate(x,y));x[0]*=degrees,x[1]*=degrees}function circle(){var c=center.apply(this,arguments),r=radius.apply(this,arguments)*radians,p=precision.apply(this,arguments)*radians;ring=[];rotate=rotateRadians(-c[0]*radians,-c[1]*radians,0).invert;circleStream(stream,r,p,1);c={type:"Polygon",coordinates:[ring]};ring=rotate=null;return c}circle.center=function(_){return arguments.length?(center=typeof _==="function"?_:constant([+_[0],+_[1]]),circle):center};circle.radius=function(_){return arguments.length?(radius=typeof _==="function"?_:constant(+_),circle):radius};circle.precision=function(_){return arguments.length?(precision=typeof _==="function"?_:constant(+_),circle):precision};return circle}function clipBuffer(){var lines=[],line;return{point:function(x,y,m){line.push([x,y,m])},lineStart:function(){lines.push(line=[])},lineEnd:noop,rejoin:function(){if(lines.length>1)lines.push(lines.pop().concat(lines.shift()))},result:function(){var result=lines;lines=[];line=null;return result}}}function pointEqual(a,b){return abs(a[0]-b[0])<epsilon&&abs(a[1]-b[1])<epsilon}function Intersection(point,points,other,entry){this.x=point;this.z=points;this.o=other;this.e=entry;this.v=false;this.n=this.p=null}function clipRejoin(segments,compareIntersection,startInside,interpolate,stream){var subject=[],clip=[],i,n;segments.forEach((function(segment){if((n=segment.length-1)<=0)return;var n,p0=segment[0],p1=segment[n],x;if(pointEqual(p0,p1)){if(!p0[2]&&!p1[2]){stream.lineStart();for(i=0;i<n;++i)stream.point((p0=segment[i])[0],p0[1]);stream.lineEnd();return}p1[0]+=2*epsilon}subject.push(x=new Intersection(p0,segment,null,true));clip.push(x.o=new Intersection(p0,null,x,false));subject.push(x=new Intersection(p1,segment,null,false));clip.push(x.o=new Intersection(p1,null,x,true))}));if(!subject.length)return;clip.sort(compareIntersection);link(subject);link(clip);for(i=0,n=clip.length;i<n;++i){clip[i].e=startInside=!startInside}var start=subject[0],points,point;while(1){var current=start,isSubject=true;while(current.v)if((current=current.n)===start)return;points=current.z;stream.lineStart();do{current.v=current.o.v=true;if(current.e){if(isSubject){for(i=0,n=points.length;i<n;++i)stream.point((point=points[i])[0],point[1])}else{interpolate(current.x,current.n.x,1,stream)}current=current.n}else{if(isSubject){points=current.p.z;for(i=points.length-1;i>=0;--i)stream.point((point=points[i])[0],point[1])}else{interpolate(current.x,current.p.x,-1,stream)}current=current.p}current=current.o;points=current.z;isSubject=!isSubject}while(!current.v);stream.lineEnd()}}function link(array){if(!(n=array.length))return;var n,i=0,a=array[0],b;while(++i<n){a.n=b=array[i];b.p=a;a=b}a.n=b=array[0];b.p=a}function longitude(point){if(abs(point[0])<=pi)return point[0];else return sign(point[0])*((abs(point[0])+pi)%tau-pi)}function polygonContains(polygon,point){var lambda=longitude(point),phi=point[1],sinPhi=sin(phi),normal=[sin(lambda),-cos(lambda),0],angle=0,winding=0;var sum=new d3Array.Adder;if(sinPhi===1)phi=halfPi+epsilon;else if(sinPhi===-1)phi=-halfPi-epsilon;for(var i=0,n=polygon.length;i<n;++i){if(!(m=(ring=polygon[i]).length))continue;var ring,m,point0=ring[m-1],lambda0=longitude(point0),phi0=point0[1]/2+quarterPi,sinPhi0=sin(phi0),cosPhi0=cos(phi0);for(var j=0;j<m;++j,lambda0=lambda1,sinPhi0=sinPhi1,cosPhi0=cosPhi1,point0=point1){var point1=ring[j],lambda1=longitude(point1),phi1=point1[1]/2+quarterPi,sinPhi1=sin(phi1),cosPhi1=cos(phi1),delta=lambda1-lambda0,sign=delta>=0?1:-1,absDelta=sign*delta,antimeridian=absDelta>pi,k=sinPhi0*sinPhi1;sum.add(atan2(k*sign*sin(absDelta),cosPhi0*cosPhi1+k*cos(absDelta)));angle+=antimeridian?delta+sign*tau:delta;if(antimeridian^lambda0>=lambda^lambda1>=lambda){var arc=cartesianCross(cartesian(point0),cartesian(point1));cartesianNormalizeInPlace(arc);var intersection=cartesianCross(normal,arc);cartesianNormalizeInPlace(intersection);var phiArc=(antimeridian^delta>=0?-1:1)*asin(intersection[2]);if(phi>phiArc||phi===phiArc&&(arc[0]||arc[1])){winding+=antimeridian^delta>=0?1:-1}}}}return(angle<-epsilon||angle<epsilon&&sum<-epsilon2)^winding&1}function clip(pointVisible,clipLine,interpolate,start){return function(sink){var line=clipLine(sink),ringBuffer=clipBuffer(),ringSink=clipLine(ringBuffer),polygonStarted=false,polygon,segments,ring;var clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){clip.point=pointRing;clip.lineStart=ringStart;clip.lineEnd=ringEnd;segments=[];polygon=[]},polygonEnd:function(){clip.point=point;clip.lineStart=lineStart;clip.lineEnd=lineEnd;segments=d3Array.merge(segments);var startInside=polygonContains(polygon,start);if(segments.length){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;clipRejoin(segments,compareIntersection,startInside,interpolate,sink)}else if(startInside){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;sink.lineStart();interpolate(null,null,1,sink);sink.lineEnd()}if(polygonStarted)sink.polygonEnd(),polygonStarted=false;segments=polygon=null},sphere:function(){sink.polygonStart();sink.lineStart();interpolate(null,null,1,sink);sink.lineEnd();sink.polygonEnd()}};function point(lambda,phi){if(pointVisible(lambda,phi))sink.point(lambda,phi)}function pointLine(lambda,phi){line.point(lambda,phi)}function lineStart(){clip.point=pointLine;line.lineStart()}function lineEnd(){clip.point=point;line.lineEnd()}function pointRing(lambda,phi){ring.push([lambda,phi]);ringSink.point(lambda,phi)}function ringStart(){ringSink.lineStart();ring=[]}function ringEnd(){pointRing(ring[0][0],ring[0][1]);ringSink.lineEnd();var clean=ringSink.clean(),ringSegments=ringBuffer.result(),i,n=ringSegments.length,m,segment,point;ring.pop();polygon.push(ring);ring=null;if(!n)return;if(clean&1){segment=ringSegments[0];if((m=segment.length-1)>0){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;sink.lineStart();for(i=0;i<m;++i)sink.point((point=segment[i])[0],point[1]);sink.lineEnd()}return}if(n>1&&clean&2)ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));segments.push(ringSegments.filter(validSegment))}return clip}}function validSegment(segment){return segment.length>1}function compareIntersection(a,b){return((a=a.x)[0]<0?a[1]-halfPi-epsilon:halfPi-a[1])-((b=b.x)[0]<0?b[1]-halfPi-epsilon:halfPi-b[1])}var clipAntimeridian=clip((function(){return true}),clipAntimeridianLine,clipAntimeridianInterpolate,[-pi,-halfPi]);function clipAntimeridianLine(stream){var lambda0=NaN,phi0=NaN,sign0=NaN,clean;return{lineStart:function(){stream.lineStart();clean=1},point:function(lambda1,phi1){var sign1=lambda1>0?pi:-pi,delta=abs(lambda1-lambda0);if(abs(delta-pi)<epsilon){stream.point(lambda0,phi0=(phi0+phi1)/2>0?halfPi:-halfPi);stream.point(sign0,phi0);stream.lineEnd();stream.lineStart();stream.point(sign1,phi0);stream.point(lambda1,phi0);clean=0}else if(sign0!==sign1&&delta>=pi){if(abs(lambda0-sign0)<epsilon)lambda0-=sign0*epsilon;if(abs(lambda1-sign1)<epsilon)lambda1-=sign1*epsilon;phi0=clipAntimeridianIntersect(lambda0,phi0,lambda1,phi1);stream.point(sign0,phi0);stream.lineEnd();stream.lineStart();stream.point(sign1,phi0);clean=0}stream.point(lambda0=lambda1,phi0=phi1);sign0=sign1},lineEnd:function(){stream.lineEnd();lambda0=phi0=NaN},clean:function(){return 2-clean}}}function clipAntimeridianIntersect(lambda0,phi0,lambda1,phi1){var cosPhi0,cosPhi1,sinLambda0Lambda1=sin(lambda0-lambda1);return abs(sinLambda0Lambda1)>epsilon?atan((sin(phi0)*(cosPhi1=cos(phi1))*sin(lambda1)-sin(phi1)*(cosPhi0=cos(phi0))*sin(lambda0))/(cosPhi0*cosPhi1*sinLambda0Lambda1)):(phi0+phi1)/2}function clipAntimeridianInterpolate(from,to,direction,stream){var phi;if(from==null){phi=direction*halfPi;stream.point(-pi,phi);stream.point(0,phi);stream.point(pi,phi);stream.point(pi,0);stream.point(pi,-phi);stream.point(0,-phi);stream.point(-pi,-phi);stream.point(-pi,0);stream.point(-pi,phi)}else if(abs(from[0]-to[0])>epsilon){var lambda=from[0]<to[0]?pi:-pi;phi=direction*lambda/2;stream.point(-lambda,phi);stream.point(0,phi);stream.point(lambda,phi)}else{stream.point(to[0],to[1])}}function clipCircle(radius){var cr=cos(radius),delta=6*radians,smallRadius=cr>0,notHemisphere=abs(cr)>epsilon;function interpolate(from,to,direction,stream){circleStream(stream,radius,delta,direction,from,to)}function visible(lambda,phi){return cos(lambda)*cos(phi)>cr}function clipLine(stream){var point0,c0,v0,v00,clean;return{lineStart:function(){v00=v0=false;clean=1},point:function(lambda,phi){var point1=[lambda,phi],point2,v=visible(lambda,phi),c=smallRadius?v?0:code(lambda,phi):v?code(lambda+(lambda<0?pi:-pi),phi):0;if(!point0&&(v00=v0=v))stream.lineStart();if(v!==v0){point2=intersect(point0,point1);if(!point2||pointEqual(point0,point2)||pointEqual(point1,point2))point1[2]=1}if(v!==v0){clean=0;if(v){stream.lineStart();point2=intersect(point1,point0);stream.point(point2[0],point2[1])}else{point2=intersect(point0,point1);stream.point(point2[0],point2[1],2);stream.lineEnd()}point0=point2}else if(notHemisphere&&point0&&smallRadius^v){var t;if(!(c&c0)&&(t=intersect(point1,point0,true))){clean=0;if(smallRadius){stream.lineStart();stream.point(t[0][0],t[0][1]);stream.point(t[1][0],t[1][1]);stream.lineEnd()}else{stream.point(t[1][0],t[1][1]);stream.lineEnd();stream.lineStart();stream.point(t[0][0],t[0][1],3)}}}if(v&&(!point0||!pointEqual(point0,point1))){stream.point(point1[0],point1[1])}point0=point1,v0=v,c0=c},lineEnd:function(){if(v0)stream.lineEnd();point0=null},clean:function(){return clean|(v00&&v0)<<1}}}function intersect(a,b,two){var pa=cartesian(a),pb=cartesian(b);var n1=[1,0,0],n2=cartesianCross(pa,pb),n2n2=cartesianDot(n2,n2),n1n2=n2[0],determinant=n2n2-n1n2*n1n2;if(!determinant)return!two&&a;var c1=cr*n2n2/determinant,c2=-cr*n1n2/determinant,n1xn2=cartesianCross(n1,n2),A=cartesianScale(n1,c1),B=cartesianScale(n2,c2);cartesianAddInPlace(A,B);var u=n1xn2,w=cartesianDot(A,u),uu=cartesianDot(u,u),t2=w*w-uu*(cartesianDot(A,A)-1);if(t2<0)return;var t=sqrt(t2),q=cartesianScale(u,(-w-t)/uu);cartesianAddInPlace(q,A);q=spherical(q);if(!two)return q;var lambda0=a[0],lambda1=b[0],phi0=a[1],phi1=b[1],z;if(lambda1<lambda0)z=lambda0,lambda0=lambda1,lambda1=z;var delta=lambda1-lambda0,polar=abs(delta-pi)<epsilon,meridian=polar||delta<epsilon;if(!polar&&phi1<phi0)z=phi0,phi0=phi1,phi1=z;if(meridian?polar?phi0+phi1>0^q[1]<(abs(q[0]-lambda0)<epsilon?phi0:phi1):phi0<=q[1]&&q[1]<=phi1:delta>pi^(lambda0<=q[0]&&q[0]<=lambda1)){var q1=cartesianScale(u,(-w+t)/uu);cartesianAddInPlace(q1,A);return[q,spherical(q1)]}}function code(lambda,phi){var r=smallRadius?radius:pi-radius,code=0;if(lambda<-r)code|=1;else if(lambda>r)code|=2;if(phi<-r)code|=4;else if(phi>r)code|=8;return code}return clip(visible,clipLine,interpolate,smallRadius?[0,-radius]:[-pi,radius-pi])}function clipLine(a,b,x0,y0,x1,y1){var ax=a[0],ay=a[1],bx=b[0],by=b[1],t0=0,t1=1,dx=bx-ax,dy=by-ay,r;r=x0-ax;if(!dx&&r>0)return;r/=dx;if(dx<0){if(r<t0)return;if(r<t1)t1=r}else if(dx>0){if(r>t1)return;if(r>t0)t0=r}r=x1-ax;if(!dx&&r<0)return;r/=dx;if(dx<0){if(r>t1)return;if(r>t0)t0=r}else if(dx>0){if(r<t0)return;if(r<t1)t1=r}r=y0-ay;if(!dy&&r>0)return;r/=dy;if(dy<0){if(r<t0)return;if(r<t1)t1=r}else if(dy>0){if(r>t1)return;if(r>t0)t0=r}r=y1-ay;if(!dy&&r<0)return;r/=dy;if(dy<0){if(r>t1)return;if(r>t0)t0=r}else if(dy>0){if(r<t0)return;if(r<t1)t1=r}if(t0>0)a[0]=ax+t0*dx,a[1]=ay+t0*dy;if(t1<1)b[0]=ax+t1*dx,b[1]=ay+t1*dy;return true}var clipMax=1e9,clipMin=-clipMax;function clipRectangle(x0,y0,x1,y1){function visible(x,y){return x0<=x&&x<=x1&&y0<=y&&y<=y1}function interpolate(from,to,direction,stream){var a=0,a1=0;if(from==null||(a=corner(from,direction))!==(a1=corner(to,direction))||comparePoint(from,to)<0^direction>0){do{stream.point(a===0||a===3?x0:x1,a>1?y1:y0)}while((a=(a+direction+4)%4)!==a1)}else{stream.point(to[0],to[1])}}function corner(p,direction){return abs(p[0]-x0)<epsilon?direction>0?0:3:abs(p[0]-x1)<epsilon?direction>0?2:1:abs(p[1]-y0)<epsilon?direction>0?1:0:direction>0?3:2}function compareIntersection(a,b){return comparePoint(a.x,b.x)}function comparePoint(a,b){var ca=corner(a,1),cb=corner(b,1);return ca!==cb?ca-cb:ca===0?b[1]-a[1]:ca===1?a[0]-b[0]:ca===2?a[1]-b[1]:b[0]-a[0]}return function(stream){var activeStream=stream,bufferStream=clipBuffer(),segments,polygon,ring,x__,y__,v__,x_,y_,v_,first,clean;var clipStream={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:polygonStart,polygonEnd:polygonEnd};function point(x,y){if(visible(x,y))activeStream.point(x,y)}function polygonInside(){var winding=0;for(var i=0,n=polygon.length;i<n;++i){for(var ring=polygon[i],j=1,m=ring.length,point=ring[0],a0,a1,b0=point[0],b1=point[1];j<m;++j){a0=b0,a1=b1,point=ring[j],b0=point[0],b1=point[1];if(a1<=y1){if(b1>y1&&(b0-a0)*(y1-a1)>(b1-a1)*(x0-a0))++winding}else{if(b1<=y1&&(b0-a0)*(y1-a1)<(b1-a1)*(x0-a0))--winding}}}return winding}function polygonStart(){activeStream=bufferStream,segments=[],polygon=[],clean=true}function polygonEnd(){var startInside=polygonInside(),cleanInside=clean&&startInside,visible=(segments=d3Array.merge(segments)).length;if(cleanInside||visible){stream.polygonStart();if(cleanInside){stream.lineStart();interpolate(null,null,1,stream);stream.lineEnd()}if(visible){clipRejoin(segments,compareIntersection,startInside,interpolate,stream)}stream.polygonEnd()}activeStream=stream,segments=polygon=ring=null}function lineStart(){clipStream.point=linePoint;if(polygon)polygon.push(ring=[]);first=true;v_=false;x_=y_=NaN}function lineEnd(){if(segments){linePoint(x__,y__);if(v__&&v_)bufferStream.rejoin();segments.push(bufferStream.result())}clipStream.point=point;if(v_)activeStream.lineEnd()}function linePoint(x,y){var v=visible(x,y);if(polygon)ring.push([x,y]);if(first){x__=x,y__=y,v__=v;first=false;if(v){activeStream.lineStart();activeStream.point(x,y)}}else{if(v&&v_)activeStream.point(x,y);else{var a=[x_=Math.max(clipMin,Math.min(clipMax,x_)),y_=Math.max(clipMin,Math.min(clipMax,y_))],b=[x=Math.max(clipMin,Math.min(clipMax,x)),y=Math.max(clipMin,Math.min(clipMax,y))];if(clipLine(a,b,x0,y0,x1,y1)){if(!v_){activeStream.lineStart();activeStream.point(a[0],a[1])}activeStream.point(b[0],b[1]);if(!v)activeStream.lineEnd();clean=false}else if(v){activeStream.lineStart();activeStream.point(x,y);clean=false}}}x_=x,y_=y,v_=v}return clipStream}}function extent(){var x0=0,y0=0,x1=960,y1=500,cache,cacheStream,clip;return clip={stream:function(stream){return cache&&cacheStream===stream?cache:cache=clipRectangle(x0,y0,x1,y1)(cacheStream=stream)},extent:function(_){return arguments.length?(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1],cache=cacheStream=null,clip):[[x0,y0],[x1,y1]]}}}var lengthSum,lambda0$2,sinPhi0$1,cosPhi0$1;var lengthStream={sphere:noop,point:noop,lineStart:lengthLineStart,lineEnd:noop,polygonStart:noop,polygonEnd:noop};function lengthLineStart(){lengthStream.point=lengthPointFirst;lengthStream.lineEnd=lengthLineEnd}function lengthLineEnd(){lengthStream.point=lengthStream.lineEnd=noop}function lengthPointFirst(lambda,phi){lambda*=radians,phi*=radians;lambda0$2=lambda,sinPhi0$1=sin(phi),cosPhi0$1=cos(phi);lengthStream.point=lengthPoint}function lengthPoint(lambda,phi){lambda*=radians,phi*=radians;var sinPhi=sin(phi),cosPhi=cos(phi),delta=abs(lambda-lambda0$2),cosDelta=cos(delta),sinDelta=sin(delta),x=cosPhi*sinDelta,y=cosPhi0$1*sinPhi-sinPhi0$1*cosPhi*cosDelta,z=sinPhi0$1*sinPhi+cosPhi0$1*cosPhi*cosDelta;lengthSum.add(atan2(sqrt(x*x+y*y),z));lambda0$2=lambda,sinPhi0$1=sinPhi,cosPhi0$1=cosPhi}function length(object){lengthSum=new d3Array.Adder;geoStream(object,lengthStream);return+lengthSum}var coordinates=[null,null],object={type:"LineString",coordinates:coordinates};function distance(a,b){coordinates[0]=a;coordinates[1]=b;return length(object)}var containsObjectType={Feature:function(object,point){return containsGeometry(object.geometry,point)},FeatureCollection:function(object,point){var features=object.features,i=-1,n=features.length;while(++i<n)if(containsGeometry(features[i].geometry,point))return true;return false}};var containsGeometryType={Sphere:function(){return true},Point:function(object,point){return containsPoint(object.coordinates,point)},MultiPoint:function(object,point){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)if(containsPoint(coordinates[i],point))return true;return false},LineString:function(object,point){return containsLine(object.coordinates,point)},MultiLineString:function(object,point){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)if(containsLine(coordinates[i],point))return true;return false},Polygon:function(object,point){return containsPolygon(object.coordinates,point)},MultiPolygon:function(object,point){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)if(containsPolygon(coordinates[i],point))return true;return false},GeometryCollection:function(object,point){var geometries=object.geometries,i=-1,n=geometries.length;while(++i<n)if(containsGeometry(geometries[i],point))return true;return false}};function containsGeometry(geometry,point){return geometry&&containsGeometryType.hasOwnProperty(geometry.type)?containsGeometryType[geometry.type](geometry,point):false}function containsPoint(coordinates,point){return distance(coordinates,point)===0}function containsLine(coordinates,point){var ao,bo,ab;for(var i=0,n=coordinates.length;i<n;i++){bo=distance(coordinates[i],point);if(bo===0)return true;if(i>0){ab=distance(coordinates[i],coordinates[i-1]);if(ab>0&&ao<=ab&&bo<=ab&&(ao+bo-ab)*(1-Math.pow((ao-bo)/ab,2))<epsilon2*ab)return true}ao=bo}return false}function containsPolygon(coordinates,point){return!!polygonContains(coordinates.map(ringRadians),pointRadians(point))}function ringRadians(ring){return ring=ring.map(pointRadians),ring.pop(),ring}function pointRadians(point){return[point[0]*radians,point[1]*radians]}function contains(object,point){return(object&&containsObjectType.hasOwnProperty(object.type)?containsObjectType[object.type]:containsGeometry)(object,point)}function graticuleX(y0,y1,dy){var y=d3Array.range(y0,y1-epsilon,dy).concat(y1);return function(x){return y.map((function(y){return[x,y]}))}}function graticuleY(x0,x1,dx){var x=d3Array.range(x0,x1-epsilon,dx).concat(x1);return function(y){return x.map((function(x){return[x,y]}))}}function graticule(){var x1,x0,X1,X0,y1,y0,Y1,Y0,dx=10,dy=dx,DX=90,DY=360,x,y,X,Y,precision=2.5;function graticule(){return{type:"MultiLineString",coordinates:lines()}}function lines(){return d3Array.range(ceil(X0/DX)*DX,X1,DX).map(X).concat(d3Array.range(ceil(Y0/DY)*DY,Y1,DY).map(Y)).concat(d3Array.range(ceil(x0/dx)*dx,x1,dx).filter((function(x){return abs(x%DX)>epsilon})).map(x)).concat(d3Array.range(ceil(y0/dy)*dy,y1,dy).filter((function(y){return abs(y%DY)>epsilon})).map(y))}graticule.lines=function(){return lines().map((function(coordinates){return{type:"LineString",coordinates:coordinates}}))};graticule.outline=function(){return{type:"Polygon",coordinates:[X(X0).concat(Y(Y1).slice(1),X(X1).reverse().slice(1),Y(Y0).reverse().slice(1))]}};graticule.extent=function(_){if(!arguments.length)return graticule.extentMinor();return graticule.extentMajor(_).extentMinor(_)};graticule.extentMajor=function(_){if(!arguments.length)return[[X0,Y0],[X1,Y1]];X0=+_[0][0],X1=+_[1][0];Y0=+_[0][1],Y1=+_[1][1];if(X0>X1)_=X0,X0=X1,X1=_;if(Y0>Y1)_=Y0,Y0=Y1,Y1=_;return graticule.precision(precision)};graticule.extentMinor=function(_){if(!arguments.length)return[[x0,y0],[x1,y1]];x0=+_[0][0],x1=+_[1][0];y0=+_[0][1],y1=+_[1][1];if(x0>x1)_=x0,x0=x1,x1=_;if(y0>y1)_=y0,y0=y1,y1=_;return graticule.precision(precision)};graticule.step=function(_){if(!arguments.length)return graticule.stepMinor();return graticule.stepMajor(_).stepMinor(_)};graticule.stepMajor=function(_){if(!arguments.length)return[DX,DY];DX=+_[0],DY=+_[1];return graticule};graticule.stepMinor=function(_){if(!arguments.length)return[dx,dy];dx=+_[0],dy=+_[1];return graticule};graticule.precision=function(_){if(!arguments.length)return precision;precision=+_;x=graticuleX(y0,y1,90);y=graticuleY(x0,x1,precision);X=graticuleX(Y0,Y1,90);Y=graticuleY(X0,X1,precision);return graticule};return graticule.extentMajor([[-180,-90+epsilon],[180,90-epsilon]]).extentMinor([[-180,-80-epsilon],[180,80+epsilon]])}function graticule10(){return graticule()()}function interpolate(a,b){var x0=a[0]*radians,y0=a[1]*radians,x1=b[0]*radians,y1=b[1]*radians,cy0=cos(y0),sy0=sin(y0),cy1=cos(y1),sy1=sin(y1),kx0=cy0*cos(x0),ky0=cy0*sin(x0),kx1=cy1*cos(x1),ky1=cy1*sin(x1),d=2*asin(sqrt(haversin(y1-y0)+cy0*cy1*haversin(x1-x0))),k=sin(d);var interpolate=d?function(t){var B=sin(t*=d)/k,A=sin(d-t)/k,x=A*kx0+B*kx1,y=A*ky0+B*ky1,z=A*sy0+B*sy1;return[atan2(y,x)*degrees,atan2(z,sqrt(x*x+y*y))*degrees]}:function(){return[x0*degrees,y0*degrees]};interpolate.distance=d;return interpolate}var identity=x=>x;var areaSum$1=new d3Array.Adder,areaRingSum$1=new d3Array.Adder,x00,y00,x0$1,y0$1;var areaStream$1={point:noop,lineStart:noop,lineEnd:noop,polygonStart:function(){areaStream$1.lineStart=areaRingStart$1;areaStream$1.lineEnd=areaRingEnd$1},polygonEnd:function(){areaStream$1.lineStart=areaStream$1.lineEnd=areaStream$1.point=noop;areaSum$1.add(abs(areaRingSum$1));areaRingSum$1=new d3Array.Adder},result:function(){var area=areaSum$1/2;areaSum$1=new d3Array.Adder;return area}};function areaRingStart$1(){areaStream$1.point=areaPointFirst$1}function areaPointFirst$1(x,y){areaStream$1.point=areaPoint$1;x00=x0$1=x,y00=y0$1=y}function areaPoint$1(x,y){areaRingSum$1.add(y0$1*x-x0$1*y);x0$1=x,y0$1=y}function areaRingEnd$1(){areaPoint$1(x00,y00)}var x0$2=Infinity,y0$2=x0$2,x1=-x0$2,y1=x1;var boundsStream$1={point:boundsPoint$1,lineStart:noop,lineEnd:noop,polygonStart:noop,polygonEnd:noop,result:function(){var bounds=[[x0$2,y0$2],[x1,y1]];x1=y1=-(y0$2=x0$2=Infinity);return bounds}};function boundsPoint$1(x,y){if(x<x0$2)x0$2=x;if(x>x1)x1=x;if(y<y0$2)y0$2=y;if(y>y1)y1=y}var X0$1=0,Y0$1=0,Z0$1=0,X1$1=0,Y1$1=0,Z1$1=0,X2$1=0,Y2$1=0,Z2$1=0,x00$1,y00$1,x0$3,y0$3;var centroidStream$1={point:centroidPoint$1,lineStart:centroidLineStart$1,lineEnd:centroidLineEnd$1,polygonStart:function(){centroidStream$1.lineStart=centroidRingStart$1;centroidStream$1.lineEnd=centroidRingEnd$1},polygonEnd:function(){centroidStream$1.point=centroidPoint$1;centroidStream$1.lineStart=centroidLineStart$1;centroidStream$1.lineEnd=centroidLineEnd$1},result:function(){var centroid=Z2$1?[X2$1/Z2$1,Y2$1/Z2$1]:Z1$1?[X1$1/Z1$1,Y1$1/Z1$1]:Z0$1?[X0$1/Z0$1,Y0$1/Z0$1]:[NaN,NaN];X0$1=Y0$1=Z0$1=X1$1=Y1$1=Z1$1=X2$1=Y2$1=Z2$1=0;return centroid}};function centroidPoint$1(x,y){X0$1+=x;Y0$1+=y;++Z0$1}function centroidLineStart$1(){centroidStream$1.point=centroidPointFirstLine}function centroidPointFirstLine(x,y){centroidStream$1.point=centroidPointLine;centroidPoint$1(x0$3=x,y0$3=y)}function centroidPointLine(x,y){var dx=x-x0$3,dy=y-y0$3,z=sqrt(dx*dx+dy*dy);X1$1+=z*(x0$3+x)/2;Y1$1+=z*(y0$3+y)/2;Z1$1+=z;centroidPoint$1(x0$3=x,y0$3=y)}function centroidLineEnd$1(){centroidStream$1.point=centroidPoint$1}function centroidRingStart$1(){centroidStream$1.point=centroidPointFirstRing}function centroidRingEnd$1(){centroidPointRing(x00$1,y00$1)}function centroidPointFirstRing(x,y){centroidStream$1.point=centroidPointRing;centroidPoint$1(x00$1=x0$3=x,y00$1=y0$3=y)}function centroidPointRing(x,y){var dx=x-x0$3,dy=y-y0$3,z=sqrt(dx*dx+dy*dy);X1$1+=z*(x0$3+x)/2;Y1$1+=z*(y0$3+y)/2;Z1$1+=z;z=y0$3*x-x0$3*y;X2$1+=z*(x0$3+x);Y2$1+=z*(y0$3+y);Z2$1+=z*3;centroidPoint$1(x0$3=x,y0$3=y)}function PathContext(context){this._context=context}PathContext.prototype={_radius:4.5,pointRadius:function(_){return this._radius=_,this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line===0)this._context.closePath();this._point=NaN},point:function(x,y){switch(this._point){case 0:{this._context.moveTo(x,y);this._point=1;break}case 1:{this._context.lineTo(x,y);break}default:{this._context.moveTo(x+this._radius,y);this._context.arc(x,y,this._radius,0,tau);break}}},result:noop};var lengthSum$1=new d3Array.Adder,lengthRing,x00$2,y00$2,x0$4,y0$4;var lengthStream$1={point:noop,lineStart:function(){lengthStream$1.point=lengthPointFirst$1},lineEnd:function(){if(lengthRing)lengthPoint$1(x00$2,y00$2);lengthStream$1.point=noop},polygonStart:function(){lengthRing=true},polygonEnd:function(){lengthRing=null},result:function(){var length=+lengthSum$1;lengthSum$1=new d3Array.Adder;return length}};function lengthPointFirst$1(x,y){lengthStream$1.point=lengthPoint$1;x00$2=x0$4=x,y00$2=y0$4=y}function lengthPoint$1(x,y){x0$4-=x,y0$4-=y;lengthSum$1.add(sqrt(x0$4*x0$4+y0$4*y0$4));x0$4=x,y0$4=y}function PathString(){this._string=[]}PathString.prototype={_radius:4.5,_circle:circle$1(4.5),pointRadius:function(_){if((_=+_)!==this._radius)this._radius=_,this._circle=null;return this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line===0)this._string.push("Z");this._point=NaN},point:function(x,y){switch(this._point){case 0:{this._string.push("M",x,",",y);this._point=1;break}case 1:{this._string.push("L",x,",",y);break}default:{if(this._circle==null)this._circle=circle$1(this._radius);this._string.push("M",x,",",y,this._circle);break}}},result:function(){if(this._string.length){var result=this._string.join("");this._string=[];return result}else{return null}}};function circle$1(radius){return"m0,"+radius+"a"+radius+","+radius+" 0 1,1 0,"+-2*radius+"a"+radius+","+radius+" 0 1,1 0,"+2*radius+"z"}function index(projection,context){var pointRadius=4.5,projectionStream,contextStream;function path(object){if(object){if(typeof pointRadius==="function")contextStream.pointRadius(+pointRadius.apply(this,arguments));geoStream(object,projectionStream(contextStream))}return contextStream.result()}path.area=function(object){geoStream(object,projectionStream(areaStream$1));return areaStream$1.result()};path.measure=function(object){geoStream(object,projectionStream(lengthStream$1));return lengthStream$1.result()};path.bounds=function(object){geoStream(object,projectionStream(boundsStream$1));return boundsStream$1.result()};path.centroid=function(object){geoStream(object,projectionStream(centroidStream$1));return centroidStream$1.result()};path.projection=function(_){return arguments.length?(projectionStream=_==null?(projection=null,identity):(projection=_).stream,path):projection};path.context=function(_){if(!arguments.length)return context;contextStream=_==null?(context=null,new PathString):new PathContext(context=_);if(typeof pointRadius!=="function")contextStream.pointRadius(pointRadius);return path};path.pointRadius=function(_){if(!arguments.length)return pointRadius;pointRadius=typeof _==="function"?_:(contextStream.pointRadius(+_),+_);return path};return path.projection(projection).context(context)}function transform(methods){return{stream:transformer(methods)}}function transformer(methods){return function(stream){var s=new TransformStream;for(var key in methods)s[key]=methods[key];s.stream=stream;return s}}function TransformStream(){}TransformStream.prototype={constructor:TransformStream,point:function(x,y){this.stream.point(x,y)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}};function fit(projection,fitBounds,object){var clip=projection.clipExtent&&projection.clipExtent();projection.scale(150).translate([0,0]);if(clip!=null)projection.clipExtent(null);geoStream(object,projection.stream(boundsStream$1));fitBounds(boundsStream$1.result());if(clip!=null)projection.clipExtent(clip);return projection}function fitExtent(projection,extent,object){return fit(projection,(function(b){var w=extent[1][0]-extent[0][0],h=extent[1][1]-extent[0][1],k=Math.min(w/(b[1][0]-b[0][0]),h/(b[1][1]-b[0][1])),x=+extent[0][0]+(w-k*(b[1][0]+b[0][0]))/2,y=+extent[0][1]+(h-k*(b[1][1]+b[0][1]))/2;projection.scale(150*k).translate([x,y])}),object)}function fitSize(projection,size,object){return fitExtent(projection,[[0,0],size],object)}function fitWidth(projection,width,object){return fit(projection,(function(b){var w=+width,k=w/(b[1][0]-b[0][0]),x=(w-k*(b[1][0]+b[0][0]))/2,y=-k*b[0][1];projection.scale(150*k).translate([x,y])}),object)}function fitHeight(projection,height,object){return fit(projection,(function(b){var h=+height,k=h/(b[1][1]-b[0][1]),x=-k*b[0][0],y=(h-k*(b[1][1]+b[0][1]))/2;projection.scale(150*k).translate([x,y])}),object)}var maxDepth=16,cosMinDistance=cos(30*radians);function resample(project,delta2){return+delta2?resample$1(project,delta2):resampleNone(project)}function resampleNone(project){return transformer({point:function(x,y){x=project(x,y);this.stream.point(x[0],x[1])}})}function resample$1(project,delta2){function resampleLineTo(x0,y0,lambda0,a0,b0,c0,x1,y1,lambda1,a1,b1,c1,depth,stream){var dx=x1-x0,dy=y1-y0,d2=dx*dx+dy*dy;if(d2>4*delta2&&depth--){var a=a0+a1,b=b0+b1,c=c0+c1,m=sqrt(a*a+b*b+c*c),phi2=asin(c/=m),lambda2=abs(abs(c)-1)<epsilon||abs(lambda0-lambda1)<epsilon?(lambda0+lambda1)/2:atan2(b,a),p=project(lambda2,phi2),x2=p[0],y2=p[1],dx2=x2-x0,dy2=y2-y0,dz=dy*dx2-dx*dy2;if(dz*dz/d2>delta2||abs((dx*dx2+dy*dy2)/d2-.5)>.3||a0*a1+b0*b1+c0*c1<cosMinDistance){resampleLineTo(x0,y0,lambda0,a0,b0,c0,x2,y2,lambda2,a/=m,b/=m,c,depth,stream);stream.point(x2,y2);resampleLineTo(x2,y2,lambda2,a,b,c,x1,y1,lambda1,a1,b1,c1,depth,stream)}}}return function(stream){var lambda00,x00,y00,a00,b00,c00,lambda0,x0,y0,a0,b0,c0;var resampleStream={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){stream.polygonStart();resampleStream.lineStart=ringStart},polygonEnd:function(){stream.polygonEnd();resampleStream.lineStart=lineStart}};function point(x,y){x=project(x,y);stream.point(x[0],x[1])}function lineStart(){x0=NaN;resampleStream.point=linePoint;stream.lineStart()}function linePoint(lambda,phi){var c=cartesian([lambda,phi]),p=project(lambda,phi);resampleLineTo(x0,y0,lambda0,a0,b0,c0,x0=p[0],y0=p[1],lambda0=lambda,a0=c[0],b0=c[1],c0=c[2],maxDepth,stream);stream.point(x0,y0)}function lineEnd(){resampleStream.point=point;stream.lineEnd()}function ringStart(){lineStart();resampleStream.point=ringPoint;resampleStream.lineEnd=ringEnd}function ringPoint(lambda,phi){linePoint(lambda00=lambda,phi),x00=x0,y00=y0,a00=a0,b00=b0,c00=c0;resampleStream.point=linePoint}function ringEnd(){resampleLineTo(x0,y0,lambda0,a0,b0,c0,x00,y00,lambda00,a00,b00,c00,maxDepth,stream);resampleStream.lineEnd=lineEnd;lineEnd()}return resampleStream}}var transformRadians=transformer({point:function(x,y){this.stream.point(x*radians,y*radians)}});function transformRotate(rotate){return transformer({point:function(x,y){var r=rotate(x,y);return this.stream.point(r[0],r[1])}})}function scaleTranslate(k,dx,dy,sx,sy){function transform(x,y){x*=sx;y*=sy;return[dx+k*x,dy-k*y]}transform.invert=function(x,y){return[(x-dx)/k*sx,(dy-y)/k*sy]};return transform}function scaleTranslateRotate(k,dx,dy,sx,sy,alpha){if(!alpha)return scaleTranslate(k,dx,dy,sx,sy);var cosAlpha=cos(alpha),sinAlpha=sin(alpha),a=cosAlpha*k,b=sinAlpha*k,ai=cosAlpha/k,bi=sinAlpha/k,ci=(sinAlpha*dy-cosAlpha*dx)/k,fi=(sinAlpha*dx+cosAlpha*dy)/k;function transform(x,y){x*=sx;y*=sy;return[a*x-b*y+dx,dy-b*x-a*y]}transform.invert=function(x,y){return[sx*(ai*x-bi*y+ci),sy*(fi-bi*x-ai*y)]};return transform}function projection(project){return projectionMutator((function(){return project}))()}function projectionMutator(projectAt){var project,k=150,x=480,y=250,lambda=0,phi=0,deltaLambda=0,deltaPhi=0,deltaGamma=0,rotate,alpha=0,sx=1,sy=1,theta=null,preclip=clipAntimeridian,x0=null,y0,x1,y1,postclip=identity,delta2=.5,projectResample,projectTransform,projectRotateTransform,cache,cacheStream;function projection(point){return projectRotateTransform(point[0]*radians,point[1]*radians)}function invert(point){point=projectRotateTransform.invert(point[0],point[1]);return point&&[point[0]*degrees,point[1]*degrees]}projection.stream=function(stream){return cache&&cacheStream===stream?cache:cache=transformRadians(transformRotate(rotate)(preclip(projectResample(postclip(cacheStream=stream)))))};projection.preclip=function(_){return arguments.length?(preclip=_,theta=undefined,reset()):preclip};projection.postclip=function(_){return arguments.length?(postclip=_,x0=y0=x1=y1=null,reset()):postclip};projection.clipAngle=function(_){return arguments.length?(preclip=+_?clipCircle(theta=_*radians):(theta=null,clipAntimeridian),reset()):theta*degrees};projection.clipExtent=function(_){return arguments.length?(postclip=_==null?(x0=y0=x1=y1=null,identity):clipRectangle(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):x0==null?null:[[x0,y0],[x1,y1]]};projection.scale=function(_){return arguments.length?(k=+_,recenter()):k};projection.translate=function(_){return arguments.length?(x=+_[0],y=+_[1],recenter()):[x,y]};projection.center=function(_){return arguments.length?(lambda=_[0]%360*radians,phi=_[1]%360*radians,recenter()):[lambda*degrees,phi*degrees]};projection.rotate=function(_){return arguments.length?(deltaLambda=_[0]%360*radians,deltaPhi=_[1]%360*radians,deltaGamma=_.length>2?_[2]%360*radians:0,recenter()):[deltaLambda*degrees,deltaPhi*degrees,deltaGamma*degrees]};projection.angle=function(_){return arguments.length?(alpha=_%360*radians,recenter()):alpha*degrees};projection.reflectX=function(_){return arguments.length?(sx=_?-1:1,recenter()):sx<0};projection.reflectY=function(_){return arguments.length?(sy=_?-1:1,recenter()):sy<0};projection.precision=function(_){return arguments.length?(projectResample=resample(projectTransform,delta2=_*_),reset()):sqrt(delta2)};projection.fitExtent=function(extent,object){return fitExtent(projection,extent,object)};projection.fitSize=function(size,object){return fitSize(projection,size,object)};projection.fitWidth=function(width,object){return fitWidth(projection,width,object)};projection.fitHeight=function(height,object){return fitHeight(projection,height,object)};function recenter(){var center=scaleTranslateRotate(k,0,0,sx,sy,alpha).apply(null,project(lambda,phi)),transform=scaleTranslateRotate(k,x-center[0],y-center[1],sx,sy,alpha);rotate=rotateRadians(deltaLambda,deltaPhi,deltaGamma);projectTransform=compose(project,transform);projectRotateTransform=compose(rotate,projectTransform);projectResample=resample(projectTransform,delta2);return reset()}function reset(){cache=cacheStream=null;return projection}return function(){project=projectAt.apply(this,arguments);projection.invert=project.invert&&invert;return recenter()}}function conicProjection(projectAt){var phi0=0,phi1=pi/3,m=projectionMutator(projectAt),p=m(phi0,phi1);p.parallels=function(_){return arguments.length?m(phi0=_[0]*radians,phi1=_[1]*radians):[phi0*degrees,phi1*degrees]};return p}function cylindricalEqualAreaRaw(phi0){var cosPhi0=cos(phi0);function forward(lambda,phi){return[lambda*cosPhi0,sin(phi)/cosPhi0]}forward.invert=function(x,y){return[x/cosPhi0,asin(y*cosPhi0)]};return forward}function conicEqualAreaRaw(y0,y1){var sy0=sin(y0),n=(sy0+sin(y1))/2;if(abs(n)<epsilon)return cylindricalEqualAreaRaw(y0);var c=1+sy0*(2*n-sy0),r0=sqrt(c)/n;function project(x,y){var r=sqrt(c-2*n*sin(y))/n;return[r*sin(x*=n),r0-r*cos(x)]}project.invert=function(x,y){var r0y=r0-y,l=atan2(x,abs(r0y))*sign(r0y);if(r0y*n<0)l-=pi*sign(x)*sign(r0y);return[l/n,asin((c-(x*x+r0y*r0y)*n*n)/(2*n))]};return project}function conicEqualArea(){return conicProjection(conicEqualAreaRaw).scale(155.424).center([0,33.6442])}function albers(){return conicEqualArea().parallels([29.5,45.5]).scale(1070).translate([480,250]).rotate([96,0]).center([-.6,38.7])}function multiplex(streams){var n=streams.length;return{point:function(x,y){var i=-1;while(++i<n)streams[i].point(x,y)},sphere:function(){var i=-1;while(++i<n)streams[i].sphere()},lineStart:function(){var i=-1;while(++i<n)streams[i].lineStart()},lineEnd:function(){var i=-1;while(++i<n)streams[i].lineEnd()},polygonStart:function(){var i=-1;while(++i<n)streams[i].polygonStart()},polygonEnd:function(){var i=-1;while(++i<n)streams[i].polygonEnd()}}}function albersUsa(){var cache,cacheStream,lower48=albers(),lower48Point,alaska=conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),alaskaPoint,hawaii=conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),hawaiiPoint,point,pointStream={point:function(x,y){point=[x,y]}};function albersUsa(coordinates){var x=coordinates[0],y=coordinates[1];return point=null,(lower48Point.point(x,y),point)||(alaskaPoint.point(x,y),point)||(hawaiiPoint.point(x,y),point)}albersUsa.invert=function(coordinates){var k=lower48.scale(),t=lower48.translate(),x=(coordinates[0]-t[0])/k,y=(coordinates[1]-t[1])/k;return(y>=.12&&y<.234&&x>=-.425&&x<-.214?alaska:y>=.166&&y<.234&&x>=-.214&&x<-.115?hawaii:lower48).invert(coordinates)};albersUsa.stream=function(stream){return cache&&cacheStream===stream?cache:cache=multiplex([lower48.stream(cacheStream=stream),alaska.stream(stream),hawaii.stream(stream)])};albersUsa.precision=function(_){if(!arguments.length)return lower48.precision();lower48.precision(_),alaska.precision(_),hawaii.precision(_);return reset()};albersUsa.scale=function(_){if(!arguments.length)return lower48.scale();lower48.scale(_),alaska.scale(_*.35),hawaii.scale(_);return albersUsa.translate(lower48.translate())};albersUsa.translate=function(_){if(!arguments.length)return lower48.translate();var k=lower48.scale(),x=+_[0],y=+_[1];lower48Point=lower48.translate(_).clipExtent([[x-.455*k,y-.238*k],[x+.455*k,y+.238*k]]).stream(pointStream);alaskaPoint=alaska.translate([x-.307*k,y+.201*k]).clipExtent([[x-.425*k+epsilon,y+.12*k+epsilon],[x-.214*k-epsilon,y+.234*k-epsilon]]).stream(pointStream);hawaiiPoint=hawaii.translate([x-.205*k,y+.212*k]).clipExtent([[x-.214*k+epsilon,y+.166*k+epsilon],[x-.115*k-epsilon,y+.234*k-epsilon]]).stream(pointStream);return reset()};albersUsa.fitExtent=function(extent,object){return fitExtent(albersUsa,extent,object)};albersUsa.fitSize=function(size,object){return fitSize(albersUsa,size,object)};albersUsa.fitWidth=function(width,object){return fitWidth(albersUsa,width,object)};albersUsa.fitHeight=function(height,object){return fitHeight(albersUsa,height,object)};function reset(){cache=cacheStream=null;return albersUsa}return albersUsa.scale(1070)}function azimuthalRaw(scale){return function(x,y){var cx=cos(x),cy=cos(y),k=scale(cx*cy);if(k===Infinity)return[2,0];return[k*cy*sin(x),k*sin(y)]}}function azimuthalInvert(angle){return function(x,y){var z=sqrt(x*x+y*y),c=angle(z),sc=sin(c),cc=cos(c);return[atan2(x*sc,z*cc),asin(z&&y*sc/z)]}}var azimuthalEqualAreaRaw=azimuthalRaw((function(cxcy){return sqrt(2/(1+cxcy))}));azimuthalEqualAreaRaw.invert=azimuthalInvert((function(z){return 2*asin(z/2)}));function azimuthalEqualArea(){return projection(azimuthalEqualAreaRaw).scale(124.75).clipAngle(180-.001)}var azimuthalEquidistantRaw=azimuthalRaw((function(c){return(c=acos(c))&&c/sin(c)}));azimuthalEquidistantRaw.invert=azimuthalInvert((function(z){return z}));function azimuthalEquidistant(){return projection(azimuthalEquidistantRaw).scale(79.4188).clipAngle(180-.001)}function mercatorRaw(lambda,phi){return[lambda,log(tan((halfPi+phi)/2))]}mercatorRaw.invert=function(x,y){return[x,2*atan(exp(y))-halfPi]};function mercator(){return mercatorProjection(mercatorRaw).scale(961/tau)}function mercatorProjection(project){var m=projection(project),center=m.center,scale=m.scale,translate=m.translate,clipExtent=m.clipExtent,x0=null,y0,x1,y1;m.scale=function(_){return arguments.length?(scale(_),reclip()):scale()};m.translate=function(_){return arguments.length?(translate(_),reclip()):translate()};m.center=function(_){return arguments.length?(center(_),reclip()):center()};m.clipExtent=function(_){return arguments.length?(_==null?x0=y0=x1=y1=null:(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reclip()):x0==null?null:[[x0,y0],[x1,y1]]};function reclip(){var k=pi*scale(),t=m(rotation(m.rotate()).invert([0,0]));return clipExtent(x0==null?[[t[0]-k,t[1]-k],[t[0]+k,t[1]+k]]:project===mercatorRaw?[[Math.max(t[0]-k,x0),y0],[Math.min(t[0]+k,x1),y1]]:[[x0,Math.max(t[1]-k,y0)],[x1,Math.min(t[1]+k,y1)]])}return reclip()}function tany(y){return tan((halfPi+y)/2)}function conicConformalRaw(y0,y1){var cy0=cos(y0),n=y0===y1?sin(y0):log(cy0/cos(y1))/log(tany(y1)/tany(y0)),f=cy0*pow(tany(y0),n)/n;if(!n)return mercatorRaw;function project(x,y){if(f>0){if(y<-halfPi+epsilon)y=-halfPi+epsilon}else{if(y>halfPi-epsilon)y=halfPi-epsilon}var r=f/pow(tany(y),n);return[r*sin(n*x),f-r*cos(n*x)]}project.invert=function(x,y){var fy=f-y,r=sign(n)*sqrt(x*x+fy*fy),l=atan2(x,abs(fy))*sign(fy);if(fy*n<0)l-=pi*sign(x)*sign(fy);return[l/n,2*atan(pow(f/r,1/n))-halfPi]};return project}function conicConformal(){return conicProjection(conicConformalRaw).scale(109.5).parallels([30,30])}function equirectangularRaw(lambda,phi){return[lambda,phi]}equirectangularRaw.invert=equirectangularRaw;function equirectangular(){return projection(equirectangularRaw).scale(152.63)}function conicEquidistantRaw(y0,y1){var cy0=cos(y0),n=y0===y1?sin(y0):(cy0-cos(y1))/(y1-y0),g=cy0/n+y0;if(abs(n)<epsilon)return equirectangularRaw;function project(x,y){var gy=g-y,nx=n*x;return[gy*sin(nx),g-gy*cos(nx)]}project.invert=function(x,y){var gy=g-y,l=atan2(x,abs(gy))*sign(gy);if(gy*n<0)l-=pi*sign(x)*sign(gy);return[l/n,g-sign(n)*sqrt(x*x+gy*gy)]};return project}function conicEquidistant(){return conicProjection(conicEquidistantRaw).scale(131.154).center([0,13.9389])}var A1=1.340264,A2=-.081106,A3=893e-6,A4=.003796,M=sqrt(3)/2,iterations=12;function equalEarthRaw(lambda,phi){var l=asin(M*sin(phi)),l2=l*l,l6=l2*l2*l2;return[lambda*cos(l)/(M*(A1+3*A2*l2+l6*(7*A3+9*A4*l2))),l*(A1+A2*l2+l6*(A3+A4*l2))]}equalEarthRaw.invert=function(x,y){var l=y,l2=l*l,l6=l2*l2*l2;for(var i=0,delta,fy,fpy;i<iterations;++i){fy=l*(A1+A2*l2+l6*(A3+A4*l2))-y;fpy=A1+3*A2*l2+l6*(7*A3+9*A4*l2);l-=delta=fy/fpy,l2=l*l,l6=l2*l2*l2;if(abs(delta)<epsilon2)break}return[M*x*(A1+3*A2*l2+l6*(7*A3+9*A4*l2))/cos(l),asin(sin(l)/M)]};function equalEarth(){return projection(equalEarthRaw).scale(177.158)}function gnomonicRaw(x,y){var cy=cos(y),k=cos(x)*cy;return[cy*sin(x)/k,sin(y)/k]}gnomonicRaw.invert=azimuthalInvert(atan);function gnomonic(){return projection(gnomonicRaw).scale(144.049).clipAngle(60)}function identity$1(){var k=1,tx=0,ty=0,sx=1,sy=1,alpha=0,ca,sa,x0=null,y0,x1,y1,kx=1,ky=1,transform=transformer({point:function(x,y){var p=projection([x,y]);this.stream.point(p[0],p[1])}}),postclip=identity,cache,cacheStream;function reset(){kx=k*sx;ky=k*sy;cache=cacheStream=null;return projection}function projection(p){var x=p[0]*kx,y=p[1]*ky;if(alpha){var t=y*ca-x*sa;x=x*ca+y*sa;y=t}return[x+tx,y+ty]}projection.invert=function(p){var x=p[0]-tx,y=p[1]-ty;if(alpha){var t=y*ca+x*sa;x=x*ca-y*sa;y=t}return[x/kx,y/ky]};projection.stream=function(stream){return cache&&cacheStream===stream?cache:cache=transform(postclip(cacheStream=stream))};projection.postclip=function(_){return arguments.length?(postclip=_,x0=y0=x1=y1=null,reset()):postclip};projection.clipExtent=function(_){return arguments.length?(postclip=_==null?(x0=y0=x1=y1=null,identity):clipRectangle(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):x0==null?null:[[x0,y0],[x1,y1]]};projection.scale=function(_){return arguments.length?(k=+_,reset()):k};projection.translate=function(_){return arguments.length?(tx=+_[0],ty=+_[1],reset()):[tx,ty]};projection.angle=function(_){return arguments.length?(alpha=_%360*radians,sa=sin(alpha),ca=cos(alpha),reset()):alpha*degrees};projection.reflectX=function(_){return arguments.length?(sx=_?-1:1,reset()):sx<0};projection.reflectY=function(_){return arguments.length?(sy=_?-1:1,reset()):sy<0};projection.fitExtent=function(extent,object){return fitExtent(projection,extent,object)};projection.fitSize=function(size,object){return fitSize(projection,size,object)};projection.fitWidth=function(width,object){return fitWidth(projection,width,object)};projection.fitHeight=function(height,object){return fitHeight(projection,height,object)};return projection}function naturalEarth1Raw(lambda,phi){var phi2=phi*phi,phi4=phi2*phi2;return[lambda*(.8707-.131979*phi2+phi4*(-.013791+phi4*(.003971*phi2-.001529*phi4))),phi*(1.007226+phi2*(.015085+phi4*(-.044475+.028874*phi2-.005916*phi4)))]}naturalEarth1Raw.invert=function(x,y){var phi=y,i=25,delta;do{var phi2=phi*phi,phi4=phi2*phi2;phi-=delta=(phi*(1.007226+phi2*(.015085+phi4*(-.044475+.028874*phi2-.005916*phi4)))-y)/(1.007226+phi2*(.015085*3+phi4*(-.044475*7+.028874*9*phi2-.005916*11*phi4)))}while(abs(delta)>epsilon&&--i>0);return[x/(.8707+(phi2=phi*phi)*(-.131979+phi2*(-.013791+phi2*phi2*phi2*(.003971-.001529*phi2)))),phi]};function naturalEarth1(){return projection(naturalEarth1Raw).scale(175.295)}function orthographicRaw(x,y){return[cos(y)*sin(x),sin(y)]}orthographicRaw.invert=azimuthalInvert(asin);function orthographic(){return projection(orthographicRaw).scale(249.5).clipAngle(90+epsilon)}function stereographicRaw(x,y){var cy=cos(y),k=1+cos(x)*cy;return[cy*sin(x)/k,sin(y)/k]}stereographicRaw.invert=azimuthalInvert((function(z){return 2*atan(z)}));function stereographic(){return projection(stereographicRaw).scale(250).clipAngle(142)}function transverseMercatorRaw(lambda,phi){return[log(tan((halfPi+phi)/2)),-lambda]}transverseMercatorRaw.invert=function(x,y){return[-y,2*atan(exp(x))-halfPi]};function transverseMercator(){var m=mercatorProjection(transverseMercatorRaw),center=m.center,rotate=m.rotate;m.center=function(_){return arguments.length?center([-_[1],_[0]]):(_=center(),[_[1],-_[0]])};m.rotate=function(_){return arguments.length?rotate([_[0],_[1],_.length>2?_[2]+90:90]):(_=rotate(),[_[0],_[1],_[2]-90])};return rotate([0,0,90]).scale(159.155)}exports.geoAlbers=albers;exports.geoAlbersUsa=albersUsa;exports.geoArea=area;exports.geoAzimuthalEqualArea=azimuthalEqualArea;exports.geoAzimuthalEqualAreaRaw=azimuthalEqualAreaRaw;exports.geoAzimuthalEquidistant=azimuthalEquidistant;exports.geoAzimuthalEquidistantRaw=azimuthalEquidistantRaw;exports.geoBounds=bounds;exports.geoCentroid=centroid;exports.geoCircle=circle;exports.geoClipAntimeridian=clipAntimeridian;exports.geoClipCircle=clipCircle;exports.geoClipExtent=extent;exports.geoClipRectangle=clipRectangle;exports.geoConicConformal=conicConformal;exports.geoConicConformalRaw=conicConformalRaw;exports.geoConicEqualArea=conicEqualArea;exports.geoConicEqualAreaRaw=conicEqualAreaRaw;exports.geoConicEquidistant=conicEquidistant;exports.geoConicEquidistantRaw=conicEquidistantRaw;exports.geoContains=contains;exports.geoDistance=distance;exports.geoEqualEarth=equalEarth;exports.geoEqualEarthRaw=equalEarthRaw;exports.geoEquirectangular=equirectangular;exports.geoEquirectangularRaw=equirectangularRaw;exports.geoGnomonic=gnomonic;exports.geoGnomonicRaw=gnomonicRaw;exports.geoGraticule=graticule;exports.geoGraticule10=graticule10;exports.geoIdentity=identity$1;exports.geoInterpolate=interpolate;exports.geoLength=length;exports.geoMercator=mercator;exports.geoMercatorRaw=mercatorRaw;exports.geoNaturalEarth1=naturalEarth1;exports.geoNaturalEarth1Raw=naturalEarth1Raw;exports.geoOrthographic=orthographic;exports.geoOrthographicRaw=orthographicRaw;exports.geoPath=index;exports.geoProjection=projection;exports.geoProjectionMutator=projectionMutator;exports.geoRotation=rotation;exports.geoStereographic=stereographic;exports.geoStereographicRaw=stereographicRaw;exports.geoStream=geoStream;exports.geoTransform=transform;exports.geoTransverseMercator=transverseMercator;exports.geoTransverseMercatorRaw=transverseMercatorRaw;Object.defineProperty(exports,"__esModule",{value:true})}))},,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"domCanvas",(function(){return domCanvas}));__webpack_require__.d(__webpack_exports__,"canvas",(function(){return domCanvas}));__webpack_require__.d(__webpack_exports__,"image",(function(){return domImage}));function domCanvas(w,h){if(typeof document!=="undefined"&&document.createElement){const c=document.createElement("canvas");if(c&&c.getContext){c.width=w;c.height=h;return c}}return null}const domImage=()=>typeof Image!=="undefined"?Image:null},function(module,exports,__webpack_require__){(function(Buffer){!function(e,t){true?t(exports,__webpack_require__(36),__webpack_require__(50)):undefined}(this,(function(e,t,n){"use strict";const r=/^([A-Za-z]+:)?\/\//,o=/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp|file|data):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i,i=/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205f\u3000]/g,a="file://";async function u(e,t){const n=await this.sanitize(e,t),r=n.href;return n.localFile?this.file(r):this.http(r,t)}async function s(e,n){n=t.extend({},this.options,n);const u=this.fileAccess,s={href:null};let c,f,l;const p=o.test(e.replace(i,""));null!=e&&"string"==typeof e&&p||t.error("Sanitize failure, invalid URI: "+t.stringValue(e));const h=r.test(e);return(l=n.baseURL)&&!h&&(e.startsWith("/")||"/"===l[l.length-1]||(e="/"+e),e=l+e),f=(c=e.startsWith(a))||"file"===n.mode||"http"!==n.mode&&!h&&u,c?e=e.slice(a.length):e.startsWith("//")&&("file"===n.defaultProtocol?(e=e.slice(2),f=!0):e=(n.defaultProtocol||"http")+":"+e),Object.defineProperty(s,"localFile",{value:!!f}),s.href=e,n.target&&(s.target=n.target+""),n.rel&&(s.rel=n.rel+""),"image"===n.context&&n.crossOrigin&&(s.crossOrigin=n.crossOrigin+""),s}function c(e){return e?t=>new Promise((n,r)=>{e.readFile(t,(e,t)=>{e?r(e):n(t)})}):f}async function f(){t.error("No file system access.")}function l(e){return e?async function(n,r){const o=t.extend({},this.options.http,r),i=r&&r.response,a=await e(n,o);return a.ok?t.isFunction(a[i])?a[i]():a.text():t.error(a.status+""+a.statusText)}:p}async function p(){t.error("No HTTP fetch method available.")}const h=e=>!(Number.isNaN(+e)||e instanceof Date),d={boolean:t.toBoolean,integer:t.toNumber,number:t.toNumber,date:t.toDate,string:t.toString,unknown:t.identity},g=[e=>"true"===e||"false"===e||!0===e||!1===e,e=>h(e)&&Number.isInteger(+e),h,e=>!Number.isNaN(Date.parse(e))],m=["boolean","integer","number","date"];function y(e,t){if(!e||!e.length)return"unknown";const n=e.length,r=g.length,o=g.map((e,t)=>t+1);for(let a,u,s=0,c=0;s<n;++s)for(u=t?e[s][t]:e[s],a=0;a<r;++a)if(o[a]&&(null!=(i=u)&&i==i)&&!g[a](u)&&(o[a]=0,++c,c===g.length))return"string";var i;return m[o.reduce((e,t)=>0===e?t:e,0)-1]}function v(e,t){return t.reduce((t,n)=>(t[n]=y(e,n),t),{})}var b={},T={};function j(e){return new Function("d","return {"+e.map((function(e,t){return JSON.stringify(e)+": d["+t+'] || ""'})).join(",")+"}")}function C(e){var t=Object.create(null),n=[];return e.forEach((function(e){for(var r in e)r in t||n.push(t[r]=r)})),n}function w(e,t){var n=e+"",r=n.length;return r<t?new Array(t-r+1).join(0)+n:n}function N(e){var t,n=e.getUTCHours(),r=e.getUTCMinutes(),o=e.getUTCSeconds(),i=e.getUTCMilliseconds();return isNaN(e)?"Invalid Date":((t=e.getUTCFullYear())<0?"-"+w(-t,6):t>9999?"+"+w(t,6):w(t,4))+"-"+w(e.getUTCMonth()+1,2)+"-"+w(e.getUTCDate(),2)+(i?"T"+w(n,2)+":"+w(r,2)+":"+w(o,2)+"."+w(i,3)+"Z":o?"T"+w(n,2)+":"+w(r,2)+":"+w(o,2)+"Z":r||n?"T"+w(n,2)+":"+w(r,2)+"Z":"")}function A(e){var t=new RegExp('["'+e+"\n\r]"),n=e.charCodeAt(0);function r(e,t){var r,o=[],i=e.length,a=0,u=0,s=i<=0,c=!1;function f(){if(s)return T;if(c)return c=!1,b;var t,r,o=a;if(34===e.charCodeAt(o)){for(;a++<i&&34!==e.charCodeAt(a)||34===e.charCodeAt(++a););return(t=a)>=i?s=!0:10===(r=e.charCodeAt(a++))?c=!0:13===r&&(c=!0,10===e.charCodeAt(a)&&++a),e.slice(o+1,t-1).replace(/""/g,'"')}for(;a<i;){if(10===(r=e.charCodeAt(t=a++)))c=!0;else if(13===r)c=!0,10===e.charCodeAt(a)&&++a;else if(r!==n)continue;return e.slice(o,t)}return s=!0,e.slice(o,i)}for(10===e.charCodeAt(i-1)&&--i,13===e.charCodeAt(i-1)&&--i;(r=f())!==T;){for(var l=[];r!==b&&r!==T;)l.push(r),r=f();t&&null==(l=t(l,u++))||o.push(l)}return o}function o(t,n){return t.map((function(t){return n.map((function(e){return a(t[e])})).join(e)}))}function i(t){return t.map(a).join(e)}function a(e){return null==e?"":e instanceof Date?N(e):t.test(e+="")?'"'+e.replace(/"/g,'""')+'"':e}return{parse:function(e,t){var n,o,i=r(e,(function(e,r){if(n)return n(e,r-1);o=e,n=t?function(e,t){var n=j(e);return function(r,o){return t(n(r),o,e)}}(e,t):j(e)}));return i.columns=o||[],i},parseRows:r,format:function(t,n){return null==n&&(n=C(t)),[n.map(a).join(e)].concat(o(t,n)).join("\n")},formatBody:function(e,t){return null==t&&(t=C(e)),o(e,t).join("\n")},formatRows:function(e){return e.map(i).join("\n")},formatRow:i,formatValue:a}}function x(e){const n=function(n,r){const o={delimiter:e};return O(n,r?t.extend(r,o):o)};return n.responseType="text",n}function O(e,n){return n.header&&(e=n.header.map(t.stringValue).join(n.delimiter)+"\n"+e),A(n.delimiter).parse(e+"")}function P(e,n){const r=n&&n.property?t.field(n.property):t.identity;return!t.isObject(e)||(o=e,"function"==typeof Buffer&&t.isFunction(Buffer.isBuffer)&&Buffer.isBuffer(o))?r(JSON.parse(e)):function(e,n){!t.isArray(e)&&t.isIterable(e)&&(e=[...e]);return n&&n.copy?JSON.parse(JSON.stringify(e)):e}(r(e),n);var o}function k(e){return e}function E(e,t){return"string"==typeof t&&(t=e.objects[t]),"GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map((function(t){return S(e,t)}))}:S(e,t)}function S(e,t){var n=t.id,r=t.bbox,o=null==t.properties?{}:t.properties,i=F(e,t);return null==n&&null==r?{type:"Feature",properties:o,geometry:i}:null==r?{type:"Feature",id:n,properties:o,geometry:i}:{type:"Feature",id:n,bbox:r,properties:o,geometry:i}}function F(e,t){var n=function(e){if(null==e)return k;var t,n,r=e.scale[0],o=e.scale[1],i=e.translate[0],a=e.translate[1];return function(e,u){u||(t=n=0);var s=2,c=e.length,f=new Array(c);for(f[0]=(t+=e[0])*r+i,f[1]=(n+=e[1])*o+a;s<c;)f[s]=e[s],++s;return f}}(e.transform),r=e.arcs;function o(e,t){t.length&&t.pop();for(var o=r[e<0?~e:e],i=0,a=o.length;i<a;++i)t.push(n(o[i],i));e<0&&function(e,t){for(var n,r=e.length,o=r-t;o<--r;)n=e[o],e[o++]=e[r],e[r]=n}(t,a)}function i(e){return n(e)}function a(e){for(var t=[],n=0,r=e.length;n<r;++n)o(e[n],t);return t.length<2&&t.push(t[0]),t}function u(e){for(var t=a(e);t.length<4;)t.push(t[0]);return t}function s(e){return e.map(u)}return function e(t){var n,r=t.type;switch(r){case"GeometryCollection":return{type:r,geometries:t.geometries.map(e)};case"Point":n=i(t.coordinates);break;case"MultiPoint":n=t.coordinates.map(i);break;case"LineString":n=a(t.arcs);break;case"MultiLineString":n=t.arcs.map(a);break;case"Polygon":n=s(t.arcs);break;case"MultiPolygon":n=t.arcs.map(s);break;default:return null}return{type:r,coordinates:n}}(t)}function M(e,t){var n={},r={},o={},i=[],a=-1;function u(e,t){for(var r in e){var o=e[r];delete t[o.start],delete o.start,delete o.end,o.forEach((function(e){n[e<0?~e:e]=1})),i.push(o)}}return t.forEach((function(n,r){var o,i=e.arcs[n<0?~n:n];i.length<3&&!i[1][0]&&!i[1][1]&&(o=t[++a],t[a]=n,t[r]=o)})),t.forEach((function(t){var n,i,a=function(t){var n,r=e.arcs[t<0?~t:t],o=r[0];e.transform?(n=[0,0],r.forEach((function(e){n[0]+=e[0],n[1]+=e[1]}))):n=r[r.length-1];return t<0?[n,o]:[o,n]}(t),u=a[0],s=a[1];if(n=o[u])if(delete o[n.end],n.push(t),n.end=s,i=r[s]){delete r[i.start];var c=i===n?n:n.concat(i);r[c.start=n.start]=o[c.end=i.end]=c}else r[n.start]=o[n.end]=n;else if(n=r[s])if(delete r[n.start],n.unshift(t),n.start=u,i=o[u]){delete o[i.end];var f=i===n?n:i.concat(n);r[f.start=i.start]=o[f.end=n.end]=f}else r[n.start]=o[n.end]=n;else r[(n=[t]).start=u]=o[n.end=s]=n})),u(o,r),u(r,o),t.forEach((function(e){n[e<0?~e:e]||i.push([e])})),i}function U(e){return F(e,z.apply(this,arguments))}function z(e,t,n){var r,o,i;if(arguments.length>1)r=B(e,t,n);else for(o=0,r=new Array(i=e.arcs.length);o<i;++o)r[o]=o;return{type:"MultiLineString",arcs:M(e,r)}}function B(e,t,n){var r,o=[],i=[];function a(e){var t=e<0?~e:e;(i[t]||(i[t]=[])).push({i:e,g:r})}function u(e){e.forEach(a)}function s(e){e.forEach(u)}return function e(t){switch(r=t,t.type){case"GeometryCollection":t.geometries.forEach(e);break;case"LineString":u(t.arcs);break;case"MultiLineString":case"Polygon":s(t.arcs);break;case"MultiPolygon":!function(e){e.forEach(s)}(t.arcs)}}(t),i.forEach(null==n?function(e){o.push(e[0].i)}:function(e){n(e[0].g,e[e.length-1].g)&&o.push(e[0].i)}),o}O.responseType="text",P.responseType="json";const D={interior:(e,t)=>e!==t,exterior:(e,t)=>e===t};function L(e,n){let r,o,i,a;return e=P(e,n),n&&n.feature?(r=E,i=n.feature):n&&n.mesh?(r=U,i=n.mesh,a=D[n.filter]):t.error("Missing TopoJSON feature or mesh parameter."),o=(o=e.objects[i])?r(e,o,a):t.error("Invalid TopoJSON object: "+i),o&&o.features||[o]}L.responseType="json";const I={dsv:O,csv:x(","),tsv:x("\t"),json:P,topojson:L};function J(e,n){return arguments.length>1?(I[e]=n,this):t.hasOwnProperty(I,e)?I[e]:null}const R=function(e,t){return n=>({options:n||{},sanitize:s,load:u,fileAccess:!!t,file:c(t),http:l(e)})}("undefined"!=typeof fetch&&fetch,null);e.format=I,e.formats=J,e.inferType=y,e.inferTypes=v,e.loader=R,e.read=function(e,r,o,i){const a=J((r=r||{}).type||"json");return a||t.error("Unknown data format type: "+r.type),e=a(e,r),r.parse&&function(e,t,r,o){if(!e.length)return;const i=n.timeFormatDefaultLocale();r=r||i.timeParse,o=o||i.utcParse;let a,u,s,c,f,l,p=e.columns||Object.keys(e[0]);"auto"===t&&(t=v(e,p));p=Object.keys(t);const h=p.map(e=>{const n=t[e];let i,a;if(n&&(n.startsWith("date:")||n.startsWith("utc:"))){i=n.split(/:(.+)?/,2),a=i[1],("'"===a[0]&&"'"===a[a.length-1]||'"'===a[0]&&'"'===a[a.length-1])&&(a=a.slice(1,-1));return("utc"===i[0]?o:r)(a)}if(!d[n])throw Error("Illegal format pattern: "+e+":"+n);return d[n]});for(s=0,f=e.length,l=p.length;s<f;++s)for(a=e[s],c=0;c<l;++c)u=p[c],a[u]=h[c](a[u])}(e,r.parse,o,i),t.hasOwnProperty(e,"columns")&&delete e.columns,e},e.responseType=function(e){const t=J(e);return t&&t.responseType||"text"},e.typeParsers=d,Object.defineProperty(e,"__esModule",{value:!0})}))}).call(this,__webpack_require__(71).Buffer)},function(module,exports){var g;g=function(){return this}();try{g=g||new Function("return this")()}catch(e){if(typeof window==="object")g=window}module.exports=g},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function define(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype;prototype.constructor=constructor}function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var darker=.7;var brighter=1/darker;var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex=/^#([0-9a-f]{3,8})$/,reRgbInteger=new RegExp("^rgb\\("+[reI,reI,reI]+"\\)$"),reRgbPercent=new RegExp("^rgb\\("+[reP,reP,reP]+"\\)$"),reRgbaInteger=new RegExp("^rgba\\("+[reI,reI,reI,reN]+"\\)$"),reRgbaPercent=new RegExp("^rgba\\("+[reP,reP,reP,reN]+"\\)$"),reHslPercent=new RegExp("^hsl\\("+[reN,reP,reP]+"\\)$"),reHslaPercent=new RegExp("^hsla\\("+[reN,reP,reP,reN]+"\\)$");var named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};define(Color,color,{copy:function(channels){return Object.assign(new this.constructor,this,channels)},displayable:function(){return this.rgb().displayable()},hex:color_formatHex,formatHex:color_formatHex,formatHsl:color_formatHsl,formatRgb:color_formatRgb,toString:color_formatRgb});function color_formatHex(){return this.rgb().formatHex()}function color_formatHsl(){return hslConvert(this).formatHsl()}function color_formatRgb(){return this.rgb().formatRgb()}function color(format){var m,l;format=(format+"").trim().toLowerCase();return(m=reHex.exec(format))?(l=m[1].length,m=parseInt(m[1],16),l===6?rgbn(m):l===3?new Rgb(m>>8&15|m>>4&240,m>>4&15|m&240,(m&15)<<4|m&15,1):l===8?rgba(m>>24&255,m>>16&255,m>>8&255,(m&255)/255):l===4?rgba(m>>12&15|m>>8&240,m>>8&15|m>>4&240,m>>4&15|m&240,((m&15)<<4|m&15)/255):null):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(m[1]*255/100,m[2]*255/100,m[3]*255/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(m[1]*255/100,m[2]*255/100,m[3]*255/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):format==="transparent"?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,n&255,1)}function rgba(r,g,b,a){if(a<=0)r=g=b=NaN;return new Rgb(r,g,b,a)}function rgbConvert(o){if(!(o instanceof Color))o=color(o);if(!o)return new Rgb;o=o.rgb();return new Rgb(o.r,o.g,o.b,o.opacity)}function rgb(r,g,b,opacity){return arguments.length===1?rgbConvert(r):new Rgb(r,g,b,opacity==null?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r;this.g=+g;this.b=+b;this.opacity=+opacity}define(Rgb,rgb,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb:function(){return this},displayable:function(){return-.5<=this.r&&this.r<255.5&&(-.5<=this.g&&this.g<255.5)&&(-.5<=this.b&&this.b<255.5)&&(0<=this.opacity&&this.opacity<=1)},hex:rgb_formatHex,formatHex:rgb_formatHex,formatRgb:rgb_formatRgb,toString:rgb_formatRgb}));function rgb_formatHex(){return"#"+hex(this.r)+hex(this.g)+hex(this.b)}function rgb_formatRgb(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(a===1?")":", "+a+")")}function hex(value){value=Math.max(0,Math.min(255,Math.round(value)||0));return(value<16?"0":"")+value.toString(16)}function hsla(h,s,l,a){if(a<=0)h=s=l=NaN;else if(l<=0||l>=1)h=s=NaN;else if(s<=0)h=NaN;return new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(!(o instanceof Color))o=color(o);if(!o)return new Hsl;if(o instanceof Hsl)return o;o=o.rgb();var r=o.r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;if(s){if(r===max)h=(g-b)/s+(g<b)*6;else if(g===max)h=(b-r)/s+2;else h=(r-g)/s+4;s/=l<.5?max+min:2-max-min;h*=60}else{s=l>0&&l<1?0:h}return new Hsl(h,s,l,o.opacity)}function hsl(h,s,l,opacity){return arguments.length===1?hslConvert(h):new Hsl(h,s,l,opacity==null?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Hsl,hsl,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=this.h%360+(this.h<0)*360,s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&(0<=this.l&&this.l<=1)&&(0<=this.opacity&&this.opacity<=1)},formatHsl:function(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"hsl(":"hsla(")+(this.h||0)+", "+(this.s||0)*100+"%, "+(this.l||0)*100+"%"+(a===1?")":", "+a+")")}}));function hsl2rgb(h,m1,m2){return(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)*255}var deg2rad=Math.PI/180;var rad2deg=180/Math.PI;var K=18,Xn=.96422,Yn=1,Zn=.82521,t0=4/29,t1=6/29,t2=3*t1*t1,t3=t1*t1*t1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl)return hcl2lab(o);if(!(o instanceof Rgb))o=rgbConvert(o);var r=rgb2lrgb(o.r),g=rgb2lrgb(o.g),b=rgb2lrgb(o.b),y=xyz2lab((.2225045*r+.7168786*g+.0606169*b)/Yn),x,z;if(r===g&&g===b)x=z=y;else{x=xyz2lab((.4360747*r+.3850649*g+.1430804*b)/Xn);z=xyz2lab((.0139322*r+.0971045*g+.7141733*b)/Zn)}return new Lab(116*y-16,500*(x-y),200*(y-z),o.opacity)}function gray(l,opacity){return new Lab(l,0,0,opacity==null?1:opacity)}function lab(l,a,b,opacity){return arguments.length===1?labConvert(l):new Lab(l,a,b,opacity==null?1:opacity)}function Lab(l,a,b,opacity){this.l=+l;this.a=+a;this.b=+b;this.opacity=+opacity}define(Lab,lab,extend(Color,{brighter:function(k){return new Lab(this.l+K*(k==null?1:k),this.a,this.b,this.opacity)},darker:function(k){return new Lab(this.l-K*(k==null?1:k),this.a,this.b,this.opacity)},rgb:function(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;x=Xn*lab2xyz(x);y=Yn*lab2xyz(y);z=Zn*lab2xyz(z);return new Rgb(lrgb2rgb(3.1338561*x-1.6168667*y-.4906146*z),lrgb2rgb(-.9787684*x+1.9161415*y+.033454*z),lrgb2rgb(.0719453*x-.2289914*y+1.4052427*z),this.opacity)}}));function xyz2lab(t){return t>t3?Math.pow(t,1/3):t/t2+t0}function lab2xyz(t){return t>t1?t*t*t:t2*(t-t0)}function lrgb2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2lrgb(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);if(!(o instanceof Lab))o=labConvert(o);if(o.a===0&&o.b===0)return new Hcl(NaN,0<o.l&&o.l<100?0:NaN,o.l,o.opacity);var h=Math.atan2(o.b,o.a)*rad2deg;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function lch(l,c,h,opacity){return arguments.length===1?hclConvert(l):new Hcl(h,c,l,opacity==null?1:opacity)}function hcl(h,c,l,opacity){return arguments.length===1?hclConvert(h):new Hcl(h,c,l,opacity==null?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h;this.c=+c;this.l=+l;this.opacity=+opacity}function hcl2lab(o){if(isNaN(o.h))return new Lab(o.l,0,0,o.opacity);var h=o.h*deg2rad;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}define(Hcl,hcl,extend(Color,{brighter:function(k){return new Hcl(this.h,this.c,this.l+K*(k==null?1:k),this.opacity)},darker:function(k){return new Hcl(this.h,this.c,this.l-K*(k==null?1:k),this.opacity)},rgb:function(){return hcl2lab(this).rgb()}}));var A=-.14861,B=+1.78277,C=-.29227,D=-.90649,E=+1.97294,ED=E*D,EB=E*B,BC_DA=B*C-D*A;function cubehelixConvert(o){if(o instanceof Cubehelix)return new Cubehelix(o.h,o.s,o.l,o.opacity);if(!(o instanceof Rgb))o=rgbConvert(o);var r=o.r/255,g=o.g/255,b=o.b/255,l=(BC_DA*b+ED*r-EB*g)/(BC_DA+ED-EB),bl=b-l,k=(E*(g-l)-C*bl)/D,s=Math.sqrt(k*k+bl*bl)/(E*l*(1-l)),h=s?Math.atan2(k,bl)*rad2deg-120:NaN;return new Cubehelix(h<0?h+360:h,s,l,o.opacity)}function cubehelix(h,s,l,opacity){return arguments.length===1?cubehelixConvert(h):new Cubehelix(h,s,l,opacity==null?1:opacity)}function Cubehelix(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Cubehelix,cubehelix,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=isNaN(this.h)?0:(this.h+120)*deg2rad,l=+this.l,a=isNaN(this.s)?0:this.s*l*(1-l),cosh=Math.cos(h),sinh=Math.sin(h);return new Rgb(255*(l+a*(A*cosh+B*sinh)),255*(l+a*(C*cosh+D*sinh)),255*(l+a*(E*cosh)),this.opacity)}}));exports.color=color;exports.cubehelix=cubehelix;exports.gray=gray;exports.hcl=hcl;exports.hsl=hsl;exports.lab=lab;exports.lch=lch;exports.rgb=rgb;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(77),__webpack_require__(51),__webpack_require__(128),__webpack_require__(39),__webpack_require__(44),__webpack_require__(48),__webpack_require__(129),__webpack_require__(43),__webpack_require__(47),__webpack_require__(130)):undefined})(this,(function(exports,vegaUtil,vegaExpression,d3Geo,d3Color,vegaDataflow,vegaScale,vegaScenegraph,vegaSelections,vegaStatistics,vegaTime,d3Array){"use strict";function data(name){const data=this.context.data[name];return data?data.values.value:[]}function indata(name,field,value){const index=this.context.data[name]["index:"+field],entry=index?index.value.get(value):undefined;return entry?entry.count:entry}function setdata(name,tuples){const df=this.context.dataflow,data=this.context.data[name],input=data.input;df.pulse(input,df.changeset().remove(vegaUtil.truthy).insert(tuples));return 1}function encode(item,name,retval){if(item){const df=this.context.dataflow,target=item.mark.source;df.pulse(target,df.changeset().encode(item,name))}return retval!==undefined?retval:item}const wrap=method=>function(value,spec){const locale=this.context.dataflow.locale();return locale[method](spec)(value)};const format=wrap("format");const timeFormat=wrap("timeFormat");const utcFormat=wrap("utcFormat");const timeParse=wrap("timeParse");const utcParse=wrap("utcParse");const dateObj=new Date(2e3,0,1);function time(month,day,specifier){if(!Number.isInteger(month)||!Number.isInteger(day))return"";dateObj.setYear(2e3);dateObj.setMonth(month);dateObj.setDate(day);return timeFormat.call(this,dateObj,specifier)}function monthFormat(month){return time.call(this,month,1,"%B")}function monthAbbrevFormat(month){return time.call(this,month,1,"%b")}function dayFormat(day){return time.call(this,0,2+day,"%A")}function dayAbbrevFormat(day){return time.call(this,0,2+day,"%a")}const DataPrefix=":";const IndexPrefix="@";const ScalePrefix="%";const SignalPrefix="$";function dataVisitor(name,args,scope,params){if(args[0].type!==vegaExpression.Literal){vegaUtil.error("First argument to data functions must be a string literal.")}const data=args[0].value,dataName=DataPrefix+data;if(!vegaUtil.hasOwnProperty(dataName,params)){try{params[dataName]=scope.getData(data).tuplesRef()}catch(err){}}}function indataVisitor(name,args,scope,params){if(args[0].type!==vegaExpression.Literal)vegaUtil.error("First argument to indata must be a string literal.");if(args[1].type!==vegaExpression.Literal)vegaUtil.error("Second argument to indata must be a string literal.");const data=args[0].value,field=args[1].value,indexName=IndexPrefix+field;if(!vegaUtil.hasOwnProperty(indexName,params)){params[indexName]=scope.getData(data).indataRef(scope,field)}}function scaleVisitor(name,args,scope,params){if(args[0].type===vegaExpression.Literal){addScaleDependency(scope,params,args[0].value)}else{for(name in scope.scales){addScaleDependency(scope,params,name)}}}function addScaleDependency(scope,params,name){const scaleName=ScalePrefix+name;if(!vegaUtil.hasOwnProperty(params,scaleName)){try{params[scaleName]=scope.scaleRef(name)}catch(err){}}}function getScale(name,ctx){let s;return vegaUtil.isFunction(name)?name:vegaUtil.isString(name)?(s=ctx.scales[name])&&s.value:undefined}function internalScaleFunctions(codegen,fnctx,visitors){fnctx.__bandwidth=s=>s&&s.bandwidth?s.bandwidth():0;visitors._bandwidth=scaleVisitor;visitors._range=scaleVisitor;visitors._scale=scaleVisitor;const ref=arg=>"_["+(arg.type===vegaExpression.Literal?vegaUtil.stringValue(ScalePrefix+arg.value):vegaUtil.stringValue(ScalePrefix)+"+"+codegen(arg))+"]";return{_bandwidth:args=>`this.__bandwidth(${ref(args[0])})`,_range:args=>`${ref(args[0])}.range()`,_scale:args=>`${ref(args[0])}(${codegen(args[1])})`}}function geoMethod(methodName,globalMethod){return function(projection,geojson,group){if(projection){const p=getScale(projection,(group||this).context);return p&&p.path[methodName](geojson)}else{return globalMethod(geojson)}}}const geoArea=geoMethod("area",d3Geo.geoArea);const geoBounds=geoMethod("bounds",d3Geo.geoBounds);const geoCentroid=geoMethod("centroid",d3Geo.geoCentroid);function inScope(item){const group=this.context.group;let value=false;if(group)while(item){if(item===group){value=true;break}item=item.mark.group}return value}function log(df,method,args){try{df[method].apply(df,["EXPRESSION"].concat([].slice.call(args)))}catch(err){df.warn(err)}return args[args.length-1]}function warn(){return log(this.context.dataflow,"warn",arguments)}function info(){return log(this.context.dataflow,"info",arguments)}function debug(){return log(this.context.dataflow,"debug",arguments)}function channel_luminance_value(channelValue){const val=channelValue/255;if(val<=.03928){return val/12.92}return Math.pow((val+.055)/1.055,2.4)}function luminance(color){const c=d3Color.rgb(color),r=channel_luminance_value(c.r),g=channel_luminance_value(c.g),b=channel_luminance_value(c.b);return.2126*r+.7152*g+.0722*b}function contrast(color1,color2){const lum1=luminance(color1),lum2=luminance(color2),lumL=Math.max(lum1,lum2),lumD=Math.min(lum1,lum2);return(lumL+.05)/(lumD+.05)}function merge(){const args=[].slice.call(arguments);args.unshift({});return vegaUtil.extend(...args)}function equal(a,b){return a===b||a!==a&&b!==b?true:vegaUtil.isArray(a)?vegaUtil.isArray(b)&&a.length===b.length?equalArray(a,b):false:vegaUtil.isObject(a)&&vegaUtil.isObject(b)?equalObject(a,b):false}function equalArray(a,b){for(let i=0,n=a.length;i<n;++i){if(!equal(a[i],b[i]))return false}return true}function equalObject(a,b){for(const key in a){if(!equal(a[key],b[key]))return false}return true}function removePredicate(props){return _=>equalObject(props,_)}function modify(name,insert,remove,toggle,modify,values){const df=this.context.dataflow,data=this.context.data[name],input=data.input,stamp=df.stamp();let changes=data.changes,predicate,key;if(df._trigger===false||!(input.value.length||insert||toggle)){return 0}if(!changes||changes.stamp<stamp){data.changes=changes=df.changeset();changes.stamp=stamp;df.runAfter(()=>{data.modified=true;df.pulse(input,changes).run()},true,1)}if(remove){predicate=remove===true?vegaUtil.truthy:vegaUtil.isArray(remove)||vegaDataflow.isTuple(remove)?remove:removePredicate(remove);changes.remove(predicate)}if(insert){changes.insert(insert)}if(toggle){predicate=removePredicate(toggle);if(input.value.some(predicate)){changes.remove(predicate)}else{changes.insert(toggle)}}if(modify){for(key in values){changes.modify(modify,key,values[key])}}return 1}function pinchDistance(event){const t=event.touches,dx=t[0].clientX-t[1].clientX,dy=t[0].clientY-t[1].clientY;return Math.sqrt(dx*dx+dy*dy)}function pinchAngle(event){const t=event.touches;return Math.atan2(t[0].clientY-t[1].clientY,t[0].clientX-t[1].clientX)}const accessors={};function pluck(data,name){const accessor=accessors[name]||(accessors[name]=vegaUtil.field(name));return vegaUtil.isArray(data)?data.map(accessor):accessor(data)}function array(seq){return vegaUtil.isArray(seq)||ArrayBuffer.isView(seq)?seq:null}function sequence(seq){return array(seq)||(vegaUtil.isString(seq)?seq:null)}function join(seq,...args){return array(seq).join(...args)}function indexof(seq,...args){return sequence(seq).indexOf(...args)}function lastindexof(seq,...args){return sequence(seq).lastIndexOf(...args)}function slice(seq,...args){return sequence(seq).slice(...args)}function replace(str,pattern,repl){if(vegaUtil.isFunction(repl))vegaUtil.error("Function argument passed to replace.");return String(str).replace(pattern,repl)}function reverse(seq){return array(seq).slice().reverse()}function bandspace(count,paddingInner,paddingOuter){return vegaScale.bandSpace(count||0,paddingInner||0,paddingOuter||0)}function bandwidth(name,group){const s=getScale(name,(group||this).context);return s&&s.bandwidth?s.bandwidth():0}function copy(name,group){const s=getScale(name,(group||this).context);return s?s.copy():undefined}function domain(name,group){const s=getScale(name,(group||this).context);return s?s.domain():[]}function invert(name,range,group){const s=getScale(name,(group||this).context);return!s?undefined:vegaUtil.isArray(range)?(s.invertRange||s.invert)(range):(s.invert||s.invertExtent)(range)}function range(name,group){const s=getScale(name,(group||this).context);return s&&s.range?s.range():[]}function scale(name,value,group){const s=getScale(name,(group||this).context);return s?s(value):undefined}function scaleGradient(scale,p0,p1,count,group){scale=getScale(scale,(group||this).context);const gradient=vegaScenegraph.Gradient(p0,p1);let stops=scale.domain(),min=stops[0],max=vegaUtil.peek(stops),fraction=vegaUtil.identity;if(!(max-min)){scale=(scale.interpolator?vegaScale.scale("sequential")().interpolator(scale.interpolator()):vegaScale.scale("linear")().interpolate(scale.interpolate()).range(scale.range())).domain([min=0,max=1])}else{fraction=vegaScale.scaleFraction(scale,min,max)}if(scale.ticks){stops=scale.ticks(+count||15);if(min!==stops[0])stops.unshift(min);if(max!==vegaUtil.peek(stops))stops.push(max)}stops.forEach(_=>gradient.stop(fraction(_),scale(_)));return gradient}function geoShape(projection,geojson,group){const p=getScale(projection,(group||this).context);return function(context){return p?p.path.context(context)(geojson):""}}function pathShape(path){let p=null;return function(context){return context?vegaScenegraph.pathRender(context,p=p||vegaScenegraph.pathParse(path)):path}}const datum=d=>d.data;function treeNodes(name,context){const tree=data.call(context,name);return tree.root&&tree.root.lookup||{}}function treePath(name,source,target){const nodes=treeNodes(name,this),s=nodes[source],t=nodes[target];return s&&t?s.path(t).map(datum):undefined}function treeAncestors(name,node){const n=treeNodes(name,this)[node];return n?n.ancestors().map(datum):undefined}const _window=()=>typeof window!=="undefined"&&window||null;function screen(){const w=_window();return w?w.screen:{}}function windowSize(){const w=_window();return w?[w.innerWidth,w.innerHeight]:[undefined,undefined]}function containerSize(){const view=this.context.dataflow,el=view.container&&view.container();return el?[el.clientWidth,el.clientHeight]:[undefined,undefined]}function intersect(b,opt,group){if(!b)return[];const[u,v]=b,box=(new vegaScenegraph.Bounds).set(u[0],u[1],v[0],v[1]),scene=group||this.context.dataflow.scenegraph().root;return vegaScenegraph.intersect(scene,box,filter(opt))}function filter(opt){let p=null;if(opt){const types=vegaUtil.array(opt.marktype),names=vegaUtil.array(opt.markname);p=_=>(!types.length||types.some(t=>_.marktype===t))&&(!names.length||names.some(s=>_.name===s))}return p}const functionContext={random(){return vegaStatistics.random()},cumulativeNormal:vegaStatistics.cumulativeNormal,cumulativeLogNormal:vegaStatistics.cumulativeLogNormal,cumulativeUniform:vegaStatistics.cumulativeUniform,densityNormal:vegaStatistics.densityNormal,densityLogNormal:vegaStatistics.densityLogNormal,densityUniform:vegaStatistics.densityUniform,quantileNormal:vegaStatistics.quantileNormal,quantileLogNormal:vegaStatistics.quantileLogNormal,quantileUniform:vegaStatistics.quantileUniform,sampleNormal:vegaStatistics.sampleNormal,sampleLogNormal:vegaStatistics.sampleLogNormal,sampleUniform:vegaStatistics.sampleUniform,isArray:vegaUtil.isArray,isBoolean:vegaUtil.isBoolean,isDate:vegaUtil.isDate,isDefined(_){return _!==undefined},isNumber:vegaUtil.isNumber,isObject:vegaUtil.isObject,isRegExp:vegaUtil.isRegExp,isString:vegaUtil.isString,isTuple:vegaDataflow.isTuple,isValid(_){return _!=null&&_===_},toBoolean:vegaUtil.toBoolean,toDate:vegaUtil.toDate,toNumber:vegaUtil.toNumber,toString:vegaUtil.toString,indexof:indexof,join:join,lastindexof:lastindexof,replace:replace,reverse:reverse,slice:slice,flush:vegaUtil.flush,lerp:vegaUtil.lerp,merge:merge,pad:vegaUtil.pad,peek:vegaUtil.peek,pluck:pluck,span:vegaUtil.span,inrange:vegaUtil.inrange,truncate:vegaUtil.truncate,rgb:d3Color.rgb,lab:d3Color.lab,hcl:d3Color.hcl,hsl:d3Color.hsl,luminance:luminance,contrast:contrast,sequence:d3Array.range,format:format,utcFormat:utcFormat,utcParse:utcParse,utcOffset:vegaTime.utcOffset,utcSequence:vegaTime.utcSequence,timeFormat:timeFormat,timeParse:timeParse,timeOffset:vegaTime.timeOffset,timeSequence:vegaTime.timeSequence,timeUnitSpecifier:vegaTime.timeUnitSpecifier,monthFormat:monthFormat,monthAbbrevFormat:monthAbbrevFormat,dayFormat:dayFormat,dayAbbrevFormat:dayAbbrevFormat,quarter:vegaUtil.quarter,utcquarter:vegaUtil.utcquarter,week:vegaTime.week,utcweek:vegaTime.utcweek,dayofyear:vegaTime.dayofyear,utcdayofyear:vegaTime.utcdayofyear,warn:warn,info:info,debug:debug,extent:vegaUtil.extent,inScope:inScope,intersect:intersect,clampRange:vegaUtil.clampRange,pinchDistance:pinchDistance,pinchAngle:pinchAngle,screen:screen,containerSize:containerSize,windowSize:windowSize,bandspace:bandspace,setdata:setdata,pathShape:pathShape,panLinear:vegaUtil.panLinear,panLog:vegaUtil.panLog,panPow:vegaUtil.panPow,panSymlog:vegaUtil.panSymlog,zoomLinear:vegaUtil.zoomLinear,zoomLog:vegaUtil.zoomLog,zoomPow:vegaUtil.zoomPow,zoomSymlog:vegaUtil.zoomSymlog,encode:encode,modify:modify};const eventFunctions=["view","item","group","xy","x","y"],eventPrefix="event.vega.",thisPrefix="this.",astVisitors={};const codegenParams={forbidden:["_"],allowed:["datum","event","item"],fieldvar:"datum",globalvar:id=>`_[${vegaUtil.stringValue(SignalPrefix+id)}]`,functions:buildFunctions,constants:vegaExpression.constants,visitors:astVisitors};const codeGenerator=vegaExpression.codegen(codegenParams);function buildFunctions(codegen){const fn=vegaExpression.functions(codegen);eventFunctions.forEach(name=>fn[name]=eventPrefix+name);for(const name in functionContext){fn[name]=thisPrefix+name}vegaUtil.extend(fn,internalScaleFunctions(codegen,functionContext,astVisitors));return fn}function expressionFunction(name,fn,visitor){if(arguments.length===1){return functionContext[name]}functionContext[name]=fn;if(visitor)astVisitors[name]=visitor;if(codeGenerator)codeGenerator.functions[name]=thisPrefix+name;return this}expressionFunction("bandwidth",bandwidth,scaleVisitor);expressionFunction("copy",copy,scaleVisitor);expressionFunction("domain",domain,scaleVisitor);expressionFunction("range",range,scaleVisitor);expressionFunction("invert",invert,scaleVisitor);expressionFunction("scale",scale,scaleVisitor);expressionFunction("gradient",scaleGradient,scaleVisitor);expressionFunction("geoArea",geoArea,scaleVisitor);expressionFunction("geoBounds",geoBounds,scaleVisitor);expressionFunction("geoCentroid",geoCentroid,scaleVisitor);expressionFunction("geoShape",geoShape,scaleVisitor);expressionFunction("indata",indata,indataVisitor);expressionFunction("data",data,dataVisitor);expressionFunction("treePath",treePath,dataVisitor);expressionFunction("treeAncestors",treeAncestors,dataVisitor);expressionFunction("vlSelectionTest",vegaSelections.selectionTest,vegaSelections.selectionVisitor);expressionFunction("vlSelectionIdTest",vegaSelections.selectionIdTest,vegaSelections.selectionVisitor);expressionFunction("vlSelectionResolve",vegaSelections.selectionResolve,vegaSelections.selectionVisitor);expressionFunction("vlSelectionTuples",vegaSelections.selectionTuples);function parser(expr,scope){const params={};let ast;try{expr=vegaUtil.isString(expr)?expr:vegaUtil.stringValue(expr)+"";ast=vegaExpression.parse(expr)}catch(err){vegaUtil.error("Expression parse error: "+expr)}ast.visit(node=>{if(node.type!==vegaExpression.CallExpression)return;const name=node.callee.name,visit=codegenParams.visitors[name];if(visit)visit(name,node.arguments,scope,params)});const gen=codeGenerator(ast);gen.globals.forEach(name=>{const signalName=SignalPrefix+name;if(!vegaUtil.hasOwnProperty(params,signalName)&&scope.getSignal(name)){params[signalName]=scope.signalRef(name)}});return{$expr:vegaUtil.extend({code:gen.code},scope.options.ast?{ast:ast}:null),$fields:gen.fields,$params:params}}exports.DataPrefix=DataPrefix;exports.IndexPrefix=IndexPrefix;exports.ScalePrefix=ScalePrefix;exports.SignalPrefix=SignalPrefix;exports.bandspace=bandspace;exports.bandwidth=bandwidth;exports.codeGenerator=codeGenerator;exports.codegenParams=codegenParams;exports.containerSize=containerSize;exports.contrast=contrast;exports.copy=copy;exports.data=data;exports.dataVisitor=dataVisitor;exports.dayAbbrevFormat=dayAbbrevFormat;exports.dayFormat=dayFormat;exports.debug=debug;exports.domain=domain;exports.encode=encode;exports.expressionFunction=expressionFunction;exports.format=format;exports.functionContext=functionContext;exports.geoArea=geoArea;exports.geoBounds=geoBounds;exports.geoCentroid=geoCentroid;exports.geoShape=geoShape;exports.inScope=inScope;exports.indata=indata;exports.indataVisitor=indataVisitor;exports.indexof=indexof;exports.info=info;exports.invert=invert;exports.join=join;exports.lastindexof=lastindexof;exports.luminance=luminance;exports.merge=merge;exports.modify=modify;exports.monthAbbrevFormat=monthAbbrevFormat;exports.monthFormat=monthFormat;exports.parseExpression=parser;exports.pathShape=pathShape;exports.pinchAngle=pinchAngle;exports.pinchDistance=pinchDistance;exports.pluck=pluck;exports.range=range;exports.replace=replace;exports.reverse=reverse;exports.scale=scale;exports.scaleGradient=scaleGradient;exports.scaleVisitor=scaleVisitor;exports.screen=screen;exports.setdata=setdata;exports.slice=slice;exports.timeFormat=timeFormat;exports.timeParse=timeParse;exports.treeAncestors=treeAncestors;exports.treePath=treePath;exports.utcFormat=utcFormat;exports.utcParse=utcParse;exports.warn=warn;exports.windowSize=windowSize;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports){function stringify(obj,options){options=options||{};var indent=JSON.stringify([1],null,get(options,"indent",2)).slice(2,-3);var addMargin=get(options,"margins",false);var maxLength=indent===""?Infinity:get(options,"maxLength",80);return function _stringify(obj,currentIndent,reserved){if(obj&&typeof obj.toJSON==="function"){obj=obj.toJSON()}var string=JSON.stringify(obj);if(string===undefined){return string}var length=maxLength-currentIndent.length-reserved;if(string.length<=length){var prettified=prettify(string,addMargin);if(prettified.length<=length){return prettified}}if(typeof obj==="object"&&obj!==null){var nextIndent=currentIndent+indent;var items=[];var delimiters;var comma=function(array,index){return index===array.length-1?0:1};if(Array.isArray(obj)){for(var index=0;index<obj.length;index++){items.push(_stringify(obj[index],nextIndent,comma(obj,index))||"null")}delimiters="[]"}else{Object.keys(obj).forEach((function(key,index,array){var keyPart=JSON.stringify(key)+": ";var value=_stringify(obj[key],nextIndent,keyPart.length+comma(array,index));if(value!==undefined){items.push(keyPart+value)}}));delimiters="{}"}if(items.length>0){return[delimiters[0],indent+items.join(",\n"+nextIndent),delimiters[1]].join("\n"+currentIndent)}}return string}(obj,"",0)}var stringOrChar=/("(?:[^\\"]|\\.)*")|[:,\][}{]/g;function prettify(string,addMargin){var m=addMargin?" ":"";var tokens={"{":"{"+m,"[":"["+m,"}":m+"}","]":m+"]",",":", ",":":": "};return string.replace(stringOrChar,(function(match,string){return string?match:tokens[match]}))}function get(options,name,defaultValue){return name in options?options[name]:defaultValue}module.exports=stringify},,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return bypassExternalUrlCheck}));__webpack_require__.d(__webpack_exports__,"a",(function(){return vega_base_view_VegaBaseView}));var external_kbnSharedDeps_Jquery_=__webpack_require__(32);var external_kbnSharedDeps_Jquery_default=__webpack_require__.n(external_kbnSharedDeps_Jquery_);var external_kbnSharedDeps_Moment_=__webpack_require__(31);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var elastic_datemath=__webpack_require__(133);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);var vega_node=__webpack_require__(49);var vega_lite=__webpack_require__(79);var utils=__webpack_require__(80);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(3);var vega_tooltip=__webpack_require__(134);var external_kbnSharedDeps_Lodash_=__webpack_require__(7);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);const tooltipId="vega-kibana-tooltip";function createRect(left,top,width,height){return{left:left,top:top,width:width,height:height,x:left,y:top,right:left+width,bottom:top+height}}class vega_tooltip_TooltipHandler{constructor(container,view,opts){this.container=container;this.position=opts.position;this.padding=opts.padding;this.centerOnMark=opts.centerOnMark;this.textTruncate=opts.textTruncate;view.tooltip(this.handler.bind(this))}handler(view,event,item,value){this.hideTooltip();if(value==null||value===""){return}const el=document.createElement("div");el.setAttribute("id",tooltipId);["vgaVis__tooltip","euiToolTipPopover","euiToolTip",`euiToolTip--${this.position}`].forEach(className=>{el.classList.add(className)});if(this.textTruncate){el.classList.add("vgaVis__tooltip--textTruncate")}el.innerHTML=Object(vega_tooltip["formatValue"])(value,external_kbnSharedDeps_Lodash_default.a.escape,2);document.body.appendChild(el);let anchorBounds;if(item.bounds.width()>this.centerOnMark||item.bounds.height()>this.centerOnMark){anchorBounds=createRect(event.clientX,event.clientY,0,0)}else{const containerBox=this.container.getBoundingClientRect();anchorBounds=createRect(containerBox.left+view._origin[0]+item.bounds.x1,containerBox.top+view._origin[1]+item.bounds.y1,item.bounds.width(),item.bounds.height())}const pos=Object(external_kbnSharedDeps_ElasticEui_["calculatePopoverPosition"])(anchorBounds,el.getBoundingClientRect(),this.position,this.padding);el.setAttribute("style",`top: ${pos.top}px; left: ${pos.left}px`)}hideTooltip(){const el=document.getElementById(tooltipId);if(el)el.remove()}}var public_=__webpack_require__(5);var services=__webpack_require__(1);var extract_index_pattern=__webpack_require__(17);Object(vega_node["scheme"])("elastic",Object(external_kbnSharedDeps_ElasticEui_["euiPaletteColorBlind"])());const vegaFunctions={kibanaAddFilter:"addFilterHandler",kibanaRemoveFilter:"removeFilterHandler",kibanaRemoveAllFilters:"removeAllFiltersHandler",kibanaSetTimeFilter:"setTimeFilterHandler"};for(const funcName of Object.keys(vegaFunctions)){if(!Object(vega_node["expressionFunction"])(funcName)){Object(vega_node["expressionFunction"])(funcName,(function handlerFwd(...args){const view=this.context.dataflow;view.runAfter(()=>view._kibanaView.vegaFunctionsHandler(funcName,...args))}))}}const bypassToken=Symbol();function bypassExternalUrlCheck(url){return{url:url,bypassToken:bypassToken}}class vega_base_view_VegaBaseView{constructor(opts){this._$parentEl=external_kbnSharedDeps_Jquery_default()(opts.parentEl);this._parser=opts.vegaParser;this._serviceSettings=opts.serviceSettings;this._filterManager=opts.filterManager;this._fireEvent=opts.fireEvent;this._timefilter=opts.timefilter;this._view=null;this._vegaViewConfig=null;this._$messages=null;this._destroyHandlers=[];this._initialized=false;this._enableExternalUrls=Object(services["b"])();this._vegaStateRestorer=opts.vegaStateRestorer}async init(){if(this._initialized)throw new Error;this._initialized=true;try{this._$parentEl.empty().addClass(`vgaVis`).css("flex-direction",this._parser.containerDir);for(const warn of this._parser.warnings){this._addMessage("warn",warn)}if(this._parser.error){this._addMessage("err",this._parser.error);return}this._$container=external_kbnSharedDeps_Jquery_default()('<div class="vgaVis__view">').css("height","100%").appendTo(this._$parentEl);this._$controls=external_kbnSharedDeps_Jquery_default()(`<div class="vgaVis__controls vgaVis__controls--${this._parser.controlsDir}">`).appendTo(this._$parentEl);this._addDestroyHandler(()=>{if(this._$container){this._$container.remove();this._$container=null}if(this._$controls){this._$controls.remove();this._$controls=null}if(this._$messages){this._$messages.remove();this._$messages=null}if(this._view){const state=this._view.getState();if(state){this._vegaStateRestorer.save(state)}this._view.finalize()}this._view=null});this._vegaViewConfig=this.createViewConfig();await this._initViewCustomizations()}catch(err){this.onError(err)}}async findIndex(index){const{indexPatterns:indexPatterns}=Object(services["a"])();let idxObj;if(index){[idxObj]=await indexPatterns.find(index);if(!idxObj){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("visTypeVega.vegaParser.baseView.indexNotFoundErrorMessage",{defaultMessage:"Index {index} not found",values:{index:`"${index}"`}}))}}else{[idxObj]=await Object(extract_index_pattern["a"])(this._parser.isVegaLite?this._parser.vlspec:this._parser.spec);if(!idxObj){const defaultIdx=await indexPatterns.getDefault();if(defaultIdx){idxObj=defaultIdx}else{throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("visTypeVega.vegaParser.baseView.unableToFindDefaultIndexErrorMessage",{defaultMessage:"Unable to find default index"}))}}}return idxObj.id}createViewConfig(){const config={renderer:this._parser.renderer};const vegaLoader=Object(vega_node["loader"])();const originalSanitize=vegaLoader.sanitize.bind(vegaLoader);vegaLoader.sanitize=(uri,options)=>{if(uri.bypassToken===bypassToken){uri=uri.url}else if(!this._enableExternalUrls){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("visTypeVega.vegaParser.baseView.externalUrlsAreNotEnabledErrorMessage",{defaultMessage:"External URLs are not enabled. Add   {enableExternalUrls}   to {kibanaConfigFileName}",values:{enableExternalUrls:"vis_type_vega.enableExternalUrls: true",kibanaConfigFileName:"kibana.yml"}}))}return originalSanitize(uri,options)};config.loader=vegaLoader;const vegaLogger=Object(vega_node["logger"])(vega_node["Warn"]);vegaLogger.warn=this.onWarn.bind(this);vegaLogger.error=this.onError.bind(this);config.logger=vegaLogger;return config}onError(){this._addMessage("err",utils["a"].formatErrorToStr(...arguments))}onWarn(){if(!this._parser||!this._parser.hideWarnings){this._addMessage("warn",utils["a"].formatWarningToStr(...arguments))}}_addMessage(type,text){if(!this._$messages){this._$messages=external_kbnSharedDeps_Jquery_default()(`<ul class="vgaVis__messages">`).appendTo(this._$parentEl)}this._$messages.append(external_kbnSharedDeps_Jquery_default()(`<li class="vgaVis__message vgaVis__message--${type}">`).append(external_kbnSharedDeps_Jquery_default()(`<pre class="vgaVis__messageCode">`).text(text)))}resize(){if(this._parser.useResize&&this._view&&this.updateVegaSize(this._view)){return this._view.runAsync()}}updateVegaSize(view){const heightExtraPadding=6;const width=Math.max(0,this._$container.width());const height=Math.max(0,this._$container.height())-heightExtraPadding;if(view.width()!==width||view.height()!==height){view.width(width).height(height);return true}return false}setView(view){if(this._view===view)return;if(this._view){this._view.finalize()}this._view=view;if(view){view._kibanaView=this;if(this._parser.tooltips){const tthandler=new vega_tooltip_TooltipHandler(this._$container[0],view,this._parser.tooltips);this._addDestroyHandler(()=>tthandler.hideTooltip())}const state=this._vegaStateRestorer.restore();if(state){return view.setState(state)}else{return view.runAsync()}}}async vegaFunctionsHandler(funcName,...args){try{const handlerFunc=vegaFunctions[funcName];if(!handlerFunc||!this[handlerFunc]){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("visTypeVega.vegaParser.baseView.functionIsNotDefinedForGraphErrorMessage",{defaultMessage:"{funcName} is not defined for this graph",values:{funcName:`${funcName}()`}}))}await this[handlerFunc](...args)}catch(err){this.onError(err)}}async addFilterHandler(query,index){const indexId=await this.findIndex(index);const filter=public_["esFilters"].buildQueryFilter(query,indexId);this._fireEvent({name:"applyFilter",data:{filters:[filter]}})}async removeFilterHandler(query,index){const indexId=await this.findIndex(index);const filterToRemove=public_["esFilters"].buildQueryFilter(query,indexId);const currentFilters=this._filterManager.getFilters();const existingFilter=currentFilters.find(filter=>public_["esFilters"].compareFilters(filter,filterToRemove));if(!existingFilter)return;try{this._filterManager.removeFilter(existingFilter)}catch(err){this.onError(err)}}removeAllFiltersHandler(){this._filterManager.removeAll()}setTimeFilterHandler(start,end){const{from:from,to:to,mode:mode}=vega_base_view_VegaBaseView._parseTimeRange(start,end);this._fireEvent({name:"applyFilter",data:{timeFieldName:"*",filters:[{range:{"*":{mode:mode,gte:from,lte:to}}}]}})}static _parseTimeRange(start,end){const absStart=external_kbnSharedDeps_Moment_default()(start);const absEnd=external_kbnSharedDeps_Moment_default()(end);const isValidAbsStart=absStart.isValid();const isValidAbsEnd=absEnd.isValid();let mode="absolute";let from;let to;let reverse;if(isValidAbsStart&&isValidAbsEnd){from=absStart;to=absEnd;reverse=absStart.isAfter(absEnd)}else{const startDate=elastic_datemath_default.a.parse(start);const endDate=elastic_datemath_default.a.parse(end);if(!startDate||!endDate||!startDate.isValid()||!endDate.isValid()){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("visTypeVega.vegaParser.baseView.timeValuesTypeErrorMessage",{defaultMessage:"Error setting time filter: both time values must be either relative or absolute dates. {start}, {end}",values:{start:`start=${JSON.stringify(start)}`,end:`end=${JSON.stringify(end)}`}}))}reverse=startDate.isAfter(endDate);if(isValidAbsStart||isValidAbsEnd){from=startDate;to=endDate}else{mode="relative";from=start;to=end}}if(reverse){[from,to]=[to,from]}return{from:from,to:to,mode:mode}}setDebugValues(view,spec,vlspec){var _this$_parser$searchA;(_this$_parser$searchA=this._parser.searchAPI.inspectorAdapters)===null||_this$_parser$searchA===void 0?void 0:_this$_parser$searchA.vega.bindInspectValues({view:view,spec:vlspec||spec});if(window){if(window.VEGA_DEBUG===undefined&&console){console.log("%cWelcome to Kibana Vega Plugin!","font-size: 16px; font-weight: bold;");console.log("You can access the Vega view with VEGA_DEBUG. "+"Learn more at https://vega.github.io/vega/docs/api/debugging/.")}const debugObj={};window.VEGA_DEBUG=debugObj;window.VEGA_DEBUG.VEGA_VERSION=vega_node["version"];window.VEGA_DEBUG.VEGA_LITE_VERSION=vega_lite["version"];window.VEGA_DEBUG.view=view;window.VEGA_DEBUG.vega_spec=spec;window.VEGA_DEBUG.vegalite_spec=vlspec;this._addDestroyHandler(()=>{if(debugObj===window.VEGA_DEBUG){window.VEGA_DEBUG=null}})}}destroy(){if(this._destroyHandlers){this._ongoingDestroy=Promise.all(this._destroyHandlers.map(v=>v()));this._destroyHandlers=null}return this._ongoingDestroy}_addDestroyHandler(handler){if(this._destroyHandlers){this._destroyHandlers.push(handler)}else{handler()}}}},function(module,exports,__webpack_require__){"use strict";(function(global){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
var base64=__webpack_require__(86);var ieee754=__webpack_require__(87);var isArray=__webpack_require__(88);exports.Buffer=Buffer;exports.SlowBuffer=SlowBuffer;exports.INSPECT_MAX_BYTES=50;Buffer.TYPED_ARRAY_SUPPORT=global.TYPED_ARRAY_SUPPORT!==undefined?global.TYPED_ARRAY_SUPPORT:typedArraySupport();exports.kMaxLength=kMaxLength();function typedArraySupport(){try{var arr=new Uint8Array(1);arr.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}};return arr.foo()===42&&typeof arr.subarray==="function"&&arr.subarray(1,1).byteLength===0}catch(e){return false}}function kMaxLength(){return Buffer.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function createBuffer(that,length){if(kMaxLength()<length){throw new RangeError("Invalid typed array length")}if(Buffer.TYPED_ARRAY_SUPPORT){that=new Uint8Array(length);that.__proto__=Buffer.prototype}else{if(that===null){that=new Buffer(length)}that.length=length}return that}function Buffer(arg,encodingOrOffset,length){if(!Buffer.TYPED_ARRAY_SUPPORT&&!(this instanceof Buffer)){return new Buffer(arg,encodingOrOffset,length)}if(typeof arg==="number"){if(typeof encodingOrOffset==="string"){throw new Error("If encoding is specified then the first argument must be a string")}return allocUnsafe(this,arg)}return from(this,arg,encodingOrOffset,length)}Buffer.poolSize=8192;Buffer._augment=function(arr){arr.__proto__=Buffer.prototype;return arr};function from(that,value,encodingOrOffset,length){if(typeof value==="number"){throw new TypeError('"value" argument must not be a number')}if(typeof ArrayBuffer!=="undefined"&&value instanceof ArrayBuffer){return fromArrayBuffer(that,value,encodingOrOffset,length)}if(typeof value==="string"){return fromString(that,value,encodingOrOffset)}return fromObject(that,value)}Buffer.from=function(value,encodingOrOffset,length){return from(null,value,encodingOrOffset,length)};if(Buffer.TYPED_ARRAY_SUPPORT){Buffer.prototype.__proto__=Uint8Array.prototype;Buffer.__proto__=Uint8Array;if(typeof Symbol!=="undefined"&&Symbol.species&&Buffer[Symbol.species]===Buffer){Object.defineProperty(Buffer,Symbol.species,{value:null,configurable:true})}}function assertSize(size){if(typeof size!=="number"){throw new TypeError('"size" argument must be a number')}else if(size<0){throw new RangeError('"size" argument must not be negative')}}function alloc(that,size,fill,encoding){assertSize(size);if(size<=0){return createBuffer(that,size)}if(fill!==undefined){return typeof encoding==="string"?createBuffer(that,size).fill(fill,encoding):createBuffer(that,size).fill(fill)}return createBuffer(that,size)}Buffer.alloc=function(size,fill,encoding){return alloc(null,size,fill,encoding)};function allocUnsafe(that,size){assertSize(size);that=createBuffer(that,size<0?0:checked(size)|0);if(!Buffer.TYPED_ARRAY_SUPPORT){for(var i=0;i<size;++i){that[i]=0}}return that}Buffer.allocUnsafe=function(size){return allocUnsafe(null,size)};Buffer.allocUnsafeSlow=function(size){return allocUnsafe(null,size)};function fromString(that,string,encoding){if(typeof encoding!=="string"||encoding===""){encoding="utf8"}if(!Buffer.isEncoding(encoding)){throw new TypeError('"encoding" must be a valid string encoding')}var length=byteLength(string,encoding)|0;that=createBuffer(that,length);var actual=that.write(string,encoding);if(actual!==length){that=that.slice(0,actual)}return that}function fromArrayLike(that,array){var length=array.length<0?0:checked(array.length)|0;that=createBuffer(that,length);for(var i=0;i<length;i+=1){that[i]=array[i]&255}return that}function fromArrayBuffer(that,array,byteOffset,length){array.byteLength;if(byteOffset<0||array.byteLength<byteOffset){throw new RangeError("'offset' is out of bounds")}if(array.byteLength<byteOffset+(length||0)){throw new RangeError("'length' is out of bounds")}if(byteOffset===undefined&&length===undefined){array=new Uint8Array(array)}else if(length===undefined){array=new Uint8Array(array,byteOffset)}else{array=new Uint8Array(array,byteOffset,length)}if(Buffer.TYPED_ARRAY_SUPPORT){that=array;that.__proto__=Buffer.prototype}else{that=fromArrayLike(that,array)}return that}function fromObject(that,obj){if(Buffer.isBuffer(obj)){var len=checked(obj.length)|0;that=createBuffer(that,len);if(that.length===0){return that}obj.copy(that,0,0,len);return that}if(obj){if(typeof ArrayBuffer!=="undefined"&&obj.buffer instanceof ArrayBuffer||"length"in obj){if(typeof obj.length!=="number"||isnan(obj.length)){return createBuffer(that,0)}return fromArrayLike(that,obj)}if(obj.type==="Buffer"&&isArray(obj.data)){return fromArrayLike(that,obj.data)}}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function checked(length){if(length>=kMaxLength()){throw new RangeError("Attempt to allocate Buffer larger than maximum "+"size: 0x"+kMaxLength().toString(16)+" bytes")}return length|0}function SlowBuffer(length){if(+length!=length){length=0}return Buffer.alloc(+length)}Buffer.isBuffer=function isBuffer(b){return!!(b!=null&&b._isBuffer)};Buffer.compare=function compare(a,b){if(!Buffer.isBuffer(a)||!Buffer.isBuffer(b)){throw new TypeError("Arguments must be Buffers")}if(a===b)return 0;var x=a.length;var y=b.length;for(var i=0,len=Math.min(x,y);i<len;++i){if(a[i]!==b[i]){x=a[i];y=b[i];break}}if(x<y)return-1;if(y<x)return 1;return 0};Buffer.isEncoding=function isEncoding(encoding){switch(String(encoding).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return true;default:return false}};Buffer.concat=function concat(list,length){if(!isArray(list)){throw new TypeError('"list" argument must be an Array of Buffers')}if(list.length===0){return Buffer.alloc(0)}var i;if(length===undefined){length=0;for(i=0;i<list.length;++i){length+=list[i].length}}var buffer=Buffer.allocUnsafe(length);var pos=0;for(i=0;i<list.length;++i){var buf=list[i];if(!Buffer.isBuffer(buf)){throw new TypeError('"list" argument must be an Array of Buffers')}buf.copy(buffer,pos);pos+=buf.length}return buffer};function byteLength(string,encoding){if(Buffer.isBuffer(string)){return string.length}if(typeof ArrayBuffer!=="undefined"&&typeof ArrayBuffer.isView==="function"&&(ArrayBuffer.isView(string)||string instanceof ArrayBuffer)){return string.byteLength}if(typeof string!=="string"){string=""+string}var len=string.length;if(len===0)return 0;var loweredCase=false;for(;;){switch(encoding){case"ascii":case"latin1":case"binary":return len;case"utf8":case"utf-8":case undefined:return utf8ToBytes(string).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return len*2;case"hex":return len>>>1;case"base64":return base64ToBytes(string).length;default:if(loweredCase)return utf8ToBytes(string).length;encoding=(""+encoding).toLowerCase();loweredCase=true}}}Buffer.byteLength=byteLength;function slowToString(encoding,start,end){var loweredCase=false;if(start===undefined||start<0){start=0}if(start>this.length){return""}if(end===undefined||end>this.length){end=this.length}if(end<=0){return""}end>>>=0;start>>>=0;if(end<=start){return""}if(!encoding)encoding="utf8";while(true){switch(encoding){case"hex":return hexSlice(this,start,end);case"utf8":case"utf-8":return utf8Slice(this,start,end);case"ascii":return asciiSlice(this,start,end);case"latin1":case"binary":return latin1Slice(this,start,end);case"base64":return base64Slice(this,start,end);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return utf16leSlice(this,start,end);default:if(loweredCase)throw new TypeError("Unknown encoding: "+encoding);encoding=(encoding+"").toLowerCase();loweredCase=true}}}Buffer.prototype._isBuffer=true;function swap(b,n,m){var i=b[n];b[n]=b[m];b[m]=i}Buffer.prototype.swap16=function swap16(){var len=this.length;if(len%2!==0){throw new RangeError("Buffer size must be a multiple of 16-bits")}for(var i=0;i<len;i+=2){swap(this,i,i+1)}return this};Buffer.prototype.swap32=function swap32(){var len=this.length;if(len%4!==0){throw new RangeError("Buffer size must be a multiple of 32-bits")}for(var i=0;i<len;i+=4){swap(this,i,i+3);swap(this,i+1,i+2)}return this};Buffer.prototype.swap64=function swap64(){var len=this.length;if(len%8!==0){throw new RangeError("Buffer size must be a multiple of 64-bits")}for(var i=0;i<len;i+=8){swap(this,i,i+7);swap(this,i+1,i+6);swap(this,i+2,i+5);swap(this,i+3,i+4)}return this};Buffer.prototype.toString=function toString(){var length=this.length|0;if(length===0)return"";if(arguments.length===0)return utf8Slice(this,0,length);return slowToString.apply(this,arguments)};Buffer.prototype.equals=function equals(b){if(!Buffer.isBuffer(b))throw new TypeError("Argument must be a Buffer");if(this===b)return true;return Buffer.compare(this,b)===0};Buffer.prototype.inspect=function inspect(){var str="";var max=exports.INSPECT_MAX_BYTES;if(this.length>0){str=this.toString("hex",0,max).match(/.{2}/g).join(" ");if(this.length>max)str+=" ... "}return"<Buffer "+str+">"};Buffer.prototype.compare=function compare(target,start,end,thisStart,thisEnd){if(!Buffer.isBuffer(target)){throw new TypeError("Argument must be a Buffer")}if(start===undefined){start=0}if(end===undefined){end=target?target.length:0}if(thisStart===undefined){thisStart=0}if(thisEnd===undefined){thisEnd=this.length}if(start<0||end>target.length||thisStart<0||thisEnd>this.length){throw new RangeError("out of range index")}if(thisStart>=thisEnd&&start>=end){return 0}if(thisStart>=thisEnd){return-1}if(start>=end){return 1}start>>>=0;end>>>=0;thisStart>>>=0;thisEnd>>>=0;if(this===target)return 0;var x=thisEnd-thisStart;var y=end-start;var len=Math.min(x,y);var thisCopy=this.slice(thisStart,thisEnd);var targetCopy=target.slice(start,end);for(var i=0;i<len;++i){if(thisCopy[i]!==targetCopy[i]){x=thisCopy[i];y=targetCopy[i];break}}if(x<y)return-1;if(y<x)return 1;return 0};function bidirectionalIndexOf(buffer,val,byteOffset,encoding,dir){if(buffer.length===0)return-1;if(typeof byteOffset==="string"){encoding=byteOffset;byteOffset=0}else if(byteOffset>2147483647){byteOffset=2147483647}else if(byteOffset<-2147483648){byteOffset=-2147483648}byteOffset=+byteOffset;if(isNaN(byteOffset)){byteOffset=dir?0:buffer.length-1}if(byteOffset<0)byteOffset=buffer.length+byteOffset;if(byteOffset>=buffer.length){if(dir)return-1;else byteOffset=buffer.length-1}else if(byteOffset<0){if(dir)byteOffset=0;else return-1}if(typeof val==="string"){val=Buffer.from(val,encoding)}if(Buffer.isBuffer(val)){if(val.length===0){return-1}return arrayIndexOf(buffer,val,byteOffset,encoding,dir)}else if(typeof val==="number"){val=val&255;if(Buffer.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf==="function"){if(dir){return Uint8Array.prototype.indexOf.call(buffer,val,byteOffset)}else{return Uint8Array.prototype.lastIndexOf.call(buffer,val,byteOffset)}}return arrayIndexOf(buffer,[val],byteOffset,encoding,dir)}throw new TypeError("val must be string, number or Buffer")}function arrayIndexOf(arr,val,byteOffset,encoding,dir){var indexSize=1;var arrLength=arr.length;var valLength=val.length;if(encoding!==undefined){encoding=String(encoding).toLowerCase();if(encoding==="ucs2"||encoding==="ucs-2"||encoding==="utf16le"||encoding==="utf-16le"){if(arr.length<2||val.length<2){return-1}indexSize=2;arrLength/=2;valLength/=2;byteOffset/=2}}function read(buf,i){if(indexSize===1){return buf[i]}else{return buf.readUInt16BE(i*indexSize)}}var i;if(dir){var foundIndex=-1;for(i=byteOffset;i<arrLength;i++){if(read(arr,i)===read(val,foundIndex===-1?0:i-foundIndex)){if(foundIndex===-1)foundIndex=i;if(i-foundIndex+1===valLength)return foundIndex*indexSize}else{if(foundIndex!==-1)i-=i-foundIndex;foundIndex=-1}}}else{if(byteOffset+valLength>arrLength)byteOffset=arrLength-valLength;for(i=byteOffset;i>=0;i--){var found=true;for(var j=0;j<valLength;j++){if(read(arr,i+j)!==read(val,j)){found=false;break}}if(found)return i}}return-1}Buffer.prototype.includes=function includes(val,byteOffset,encoding){return this.indexOf(val,byteOffset,encoding)!==-1};Buffer.prototype.indexOf=function indexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,true)};Buffer.prototype.lastIndexOf=function lastIndexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,false)};function hexWrite(buf,string,offset,length){offset=Number(offset)||0;var remaining=buf.length-offset;if(!length){length=remaining}else{length=Number(length);if(length>remaining){length=remaining}}var strLen=string.length;if(strLen%2!==0)throw new TypeError("Invalid hex string");if(length>strLen/2){length=strLen/2}for(var i=0;i<length;++i){var parsed=parseInt(string.substr(i*2,2),16);if(isNaN(parsed))return i;buf[offset+i]=parsed}return i}function utf8Write(buf,string,offset,length){return blitBuffer(utf8ToBytes(string,buf.length-offset),buf,offset,length)}function asciiWrite(buf,string,offset,length){return blitBuffer(asciiToBytes(string),buf,offset,length)}function latin1Write(buf,string,offset,length){return asciiWrite(buf,string,offset,length)}function base64Write(buf,string,offset,length){return blitBuffer(base64ToBytes(string),buf,offset,length)}function ucs2Write(buf,string,offset,length){return blitBuffer(utf16leToBytes(string,buf.length-offset),buf,offset,length)}Buffer.prototype.write=function write(string,offset,length,encoding){if(offset===undefined){encoding="utf8";length=this.length;offset=0}else if(length===undefined&&typeof offset==="string"){encoding=offset;length=this.length;offset=0}else if(isFinite(offset)){offset=offset|0;if(isFinite(length)){length=length|0;if(encoding===undefined)encoding="utf8"}else{encoding=length;length=undefined}}else{throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported")}var remaining=this.length-offset;if(length===undefined||length>remaining)length=remaining;if(string.length>0&&(length<0||offset<0)||offset>this.length){throw new RangeError("Attempt to write outside buffer bounds")}if(!encoding)encoding="utf8";var loweredCase=false;for(;;){switch(encoding){case"hex":return hexWrite(this,string,offset,length);case"utf8":case"utf-8":return utf8Write(this,string,offset,length);case"ascii":return asciiWrite(this,string,offset,length);case"latin1":case"binary":return latin1Write(this,string,offset,length);case"base64":return base64Write(this,string,offset,length);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return ucs2Write(this,string,offset,length);default:if(loweredCase)throw new TypeError("Unknown encoding: "+encoding);encoding=(""+encoding).toLowerCase();loweredCase=true}}};Buffer.prototype.toJSON=function toJSON(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};function base64Slice(buf,start,end){if(start===0&&end===buf.length){return base64.fromByteArray(buf)}else{return base64.fromByteArray(buf.slice(start,end))}}function utf8Slice(buf,start,end){end=Math.min(buf.length,end);var res=[];var i=start;while(i<end){var firstByte=buf[i];var codePoint=null;var bytesPerSequence=firstByte>239?4:firstByte>223?3:firstByte>191?2:1;if(i+bytesPerSequence<=end){var secondByte,thirdByte,fourthByte,tempCodePoint;switch(bytesPerSequence){case 1:if(firstByte<128){codePoint=firstByte}break;case 2:secondByte=buf[i+1];if((secondByte&192)===128){tempCodePoint=(firstByte&31)<<6|secondByte&63;if(tempCodePoint>127){codePoint=tempCodePoint}}break;case 3:secondByte=buf[i+1];thirdByte=buf[i+2];if((secondByte&192)===128&&(thirdByte&192)===128){tempCodePoint=(firstByte&15)<<12|(secondByte&63)<<6|thirdByte&63;if(tempCodePoint>2047&&(tempCodePoint<55296||tempCodePoint>57343)){codePoint=tempCodePoint}}break;case 4:secondByte=buf[i+1];thirdByte=buf[i+2];fourthByte=buf[i+3];if((secondByte&192)===128&&(thirdByte&192)===128&&(fourthByte&192)===128){tempCodePoint=(firstByte&15)<<18|(secondByte&63)<<12|(thirdByte&63)<<6|fourthByte&63;if(tempCodePoint>65535&&tempCodePoint<1114112){codePoint=tempCodePoint}}}}if(codePoint===null){codePoint=65533;bytesPerSequence=1}else if(codePoint>65535){codePoint-=65536;res.push(codePoint>>>10&1023|55296);codePoint=56320|codePoint&1023}res.push(codePoint);i+=bytesPerSequence}return decodeCodePointsArray(res)}var MAX_ARGUMENTS_LENGTH=4096;function decodeCodePointsArray(codePoints){var len=codePoints.length;if(len<=MAX_ARGUMENTS_LENGTH){return String.fromCharCode.apply(String,codePoints)}var res="";var i=0;while(i<len){res+=String.fromCharCode.apply(String,codePoints.slice(i,i+=MAX_ARGUMENTS_LENGTH))}return res}function asciiSlice(buf,start,end){var ret="";end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i]&127)}return ret}function latin1Slice(buf,start,end){var ret="";end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i])}return ret}function hexSlice(buf,start,end){var len=buf.length;if(!start||start<0)start=0;if(!end||end<0||end>len)end=len;var out="";for(var i=start;i<end;++i){out+=toHex(buf[i])}return out}function utf16leSlice(buf,start,end){var bytes=buf.slice(start,end);var res="";for(var i=0;i<bytes.length;i+=2){res+=String.fromCharCode(bytes[i]+bytes[i+1]*256)}return res}Buffer.prototype.slice=function slice(start,end){var len=this.length;start=~~start;end=end===undefined?len:~~end;if(start<0){start+=len;if(start<0)start=0}else if(start>len){start=len}if(end<0){end+=len;if(end<0)end=0}else if(end>len){end=len}if(end<start)end=start;var newBuf;if(Buffer.TYPED_ARRAY_SUPPORT){newBuf=this.subarray(start,end);newBuf.__proto__=Buffer.prototype}else{var sliceLen=end-start;newBuf=new Buffer(sliceLen,undefined);for(var i=0;i<sliceLen;++i){newBuf[i]=this[i+start]}}return newBuf};function checkOffset(offset,ext,length){if(offset%1!==0||offset<0)throw new RangeError("offset is not uint");if(offset+ext>length)throw new RangeError("Trying to access beyond buffer length")}Buffer.prototype.readUIntLE=function readUIntLE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=256)){val+=this[offset+i]*mul}return val};Buffer.prototype.readUIntBE=function readUIntBE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert){checkOffset(offset,byteLength,this.length)}var val=this[offset+--byteLength];var mul=1;while(byteLength>0&&(mul*=256)){val+=this[offset+--byteLength]*mul}return val};Buffer.prototype.readUInt8=function readUInt8(offset,noAssert){if(!noAssert)checkOffset(offset,1,this.length);return this[offset]};Buffer.prototype.readUInt16LE=function readUInt16LE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);return this[offset]|this[offset+1]<<8};Buffer.prototype.readUInt16BE=function readUInt16BE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);return this[offset]<<8|this[offset+1]};Buffer.prototype.readUInt32LE=function readUInt32LE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return(this[offset]|this[offset+1]<<8|this[offset+2]<<16)+this[offset+3]*16777216};Buffer.prototype.readUInt32BE=function readUInt32BE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]*16777216+(this[offset+1]<<16|this[offset+2]<<8|this[offset+3])};Buffer.prototype.readIntLE=function readIntLE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=256)){val+=this[offset+i]*mul}mul*=128;if(val>=mul)val-=Math.pow(2,8*byteLength);return val};Buffer.prototype.readIntBE=function readIntBE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var i=byteLength;var mul=1;var val=this[offset+--i];while(i>0&&(mul*=256)){val+=this[offset+--i]*mul}mul*=128;if(val>=mul)val-=Math.pow(2,8*byteLength);return val};Buffer.prototype.readInt8=function readInt8(offset,noAssert){if(!noAssert)checkOffset(offset,1,this.length);if(!(this[offset]&128))return this[offset];return(255-this[offset]+1)*-1};Buffer.prototype.readInt16LE=function readInt16LE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset]|this[offset+1]<<8;return val&32768?val|4294901760:val};Buffer.prototype.readInt16BE=function readInt16BE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset+1]|this[offset]<<8;return val&32768?val|4294901760:val};Buffer.prototype.readInt32LE=function readInt32LE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]|this[offset+1]<<8|this[offset+2]<<16|this[offset+3]<<24};Buffer.prototype.readInt32BE=function readInt32BE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]<<24|this[offset+1]<<16|this[offset+2]<<8|this[offset+3]};Buffer.prototype.readFloatLE=function readFloatLE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,true,23,4)};Buffer.prototype.readFloatBE=function readFloatBE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,false,23,4)};Buffer.prototype.readDoubleLE=function readDoubleLE(offset,noAssert){if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,true,52,8)};Buffer.prototype.readDoubleBE=function readDoubleBE(offset,noAssert){if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,false,52,8)};function checkInt(buf,value,offset,ext,max,min){if(!Buffer.isBuffer(buf))throw new TypeError('"buffer" argument must be a Buffer instance');if(value>max||value<min)throw new RangeError('"value" argument is out of bounds');if(offset+ext>buf.length)throw new RangeError("Index out of range")}Buffer.prototype.writeUIntLE=function writeUIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;byteLength=byteLength|0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0)}var mul=1;var i=0;this[offset]=value&255;while(++i<byteLength&&(mul*=256)){this[offset+i]=value/mul&255}return offset+byteLength};Buffer.prototype.writeUIntBE=function writeUIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;byteLength=byteLength|0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0)}var i=byteLength-1;var mul=1;this[offset+i]=value&255;while(--i>=0&&(mul*=256)){this[offset+i]=value/mul&255}return offset+byteLength};Buffer.prototype.writeUInt8=function writeUInt8(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,1,255,0);if(!Buffer.TYPED_ARRAY_SUPPORT)value=Math.floor(value);this[offset]=value&255;return offset+1};function objectWriteUInt16(buf,value,offset,littleEndian){if(value<0)value=65535+value+1;for(var i=0,j=Math.min(buf.length-offset,2);i<j;++i){buf[offset+i]=(value&255<<8*(littleEndian?i:1-i))>>>(littleEndian?i:1-i)*8}}Buffer.prototype.writeUInt16LE=function writeUInt16LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,65535,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&255;this[offset+1]=value>>>8}else{objectWriteUInt16(this,value,offset,true)}return offset+2};Buffer.prototype.writeUInt16BE=function writeUInt16BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,65535,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>8;this[offset+1]=value&255}else{objectWriteUInt16(this,value,offset,false)}return offset+2};function objectWriteUInt32(buf,value,offset,littleEndian){if(value<0)value=4294967295+value+1;for(var i=0,j=Math.min(buf.length-offset,4);i<j;++i){buf[offset+i]=value>>>(littleEndian?i:3-i)*8&255}}Buffer.prototype.writeUInt32LE=function writeUInt32LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,4294967295,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset+3]=value>>>24;this[offset+2]=value>>>16;this[offset+1]=value>>>8;this[offset]=value&255}else{objectWriteUInt32(this,value,offset,true)}return offset+4};Buffer.prototype.writeUInt32BE=function writeUInt32BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,4294967295,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&255}else{objectWriteUInt32(this,value,offset,false)}return offset+4};Buffer.prototype.writeIntLE=function writeIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit)}var i=0;var mul=1;var sub=0;this[offset]=value&255;while(++i<byteLength&&(mul*=256)){if(value<0&&sub===0&&this[offset+i-1]!==0){sub=1}this[offset+i]=(value/mul>>0)-sub&255}return offset+byteLength};Buffer.prototype.writeIntBE=function writeIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit)}var i=byteLength-1;var mul=1;var sub=0;this[offset+i]=value&255;while(--i>=0&&(mul*=256)){if(value<0&&sub===0&&this[offset+i+1]!==0){sub=1}this[offset+i]=(value/mul>>0)-sub&255}return offset+byteLength};Buffer.prototype.writeInt8=function writeInt8(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,1,127,-128);if(!Buffer.TYPED_ARRAY_SUPPORT)value=Math.floor(value);if(value<0)value=255+value+1;this[offset]=value&255;return offset+1};Buffer.prototype.writeInt16LE=function writeInt16LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,32767,-32768);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&255;this[offset+1]=value>>>8}else{objectWriteUInt16(this,value,offset,true)}return offset+2};Buffer.prototype.writeInt16BE=function writeInt16BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,32767,-32768);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>8;this[offset+1]=value&255}else{objectWriteUInt16(this,value,offset,false)}return offset+2};Buffer.prototype.writeInt32LE=function writeInt32LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,2147483647,-2147483648);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&255;this[offset+1]=value>>>8;this[offset+2]=value>>>16;this[offset+3]=value>>>24}else{objectWriteUInt32(this,value,offset,true)}return offset+4};Buffer.prototype.writeInt32BE=function writeInt32BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,2147483647,-2147483648);if(value<0)value=4294967295+value+1;if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&255}else{objectWriteUInt32(this,value,offset,false)}return offset+4};function checkIEEE754(buf,value,offset,ext,max,min){if(offset+ext>buf.length)throw new RangeError("Index out of range");if(offset<0)throw new RangeError("Index out of range")}function writeFloat(buf,value,offset,littleEndian,noAssert){if(!noAssert){checkIEEE754(buf,value,offset,4,34028234663852886e22,-34028234663852886e22)}ieee754.write(buf,value,offset,littleEndian,23,4);return offset+4}Buffer.prototype.writeFloatLE=function writeFloatLE(value,offset,noAssert){return writeFloat(this,value,offset,true,noAssert)};Buffer.prototype.writeFloatBE=function writeFloatBE(value,offset,noAssert){return writeFloat(this,value,offset,false,noAssert)};function writeDouble(buf,value,offset,littleEndian,noAssert){if(!noAssert){checkIEEE754(buf,value,offset,8,17976931348623157e292,-17976931348623157e292)}ieee754.write(buf,value,offset,littleEndian,52,8);return offset+8}Buffer.prototype.writeDoubleLE=function writeDoubleLE(value,offset,noAssert){return writeDouble(this,value,offset,true,noAssert)};Buffer.prototype.writeDoubleBE=function writeDoubleBE(value,offset,noAssert){return writeDouble(this,value,offset,false,noAssert)};Buffer.prototype.copy=function copy(target,targetStart,start,end){if(!start)start=0;if(!end&&end!==0)end=this.length;if(targetStart>=target.length)targetStart=target.length;if(!targetStart)targetStart=0;if(end>0&&end<start)end=start;if(end===start)return 0;if(target.length===0||this.length===0)return 0;if(targetStart<0){throw new RangeError("targetStart out of bounds")}if(start<0||start>=this.length)throw new RangeError("sourceStart out of bounds");if(end<0)throw new RangeError("sourceEnd out of bounds");if(end>this.length)end=this.length;if(target.length-targetStart<end-start){end=target.length-targetStart+start}var len=end-start;var i;if(this===target&&start<targetStart&&targetStart<end){for(i=len-1;i>=0;--i){target[i+targetStart]=this[i+start]}}else if(len<1e3||!Buffer.TYPED_ARRAY_SUPPORT){for(i=0;i<len;++i){target[i+targetStart]=this[i+start]}}else{Uint8Array.prototype.set.call(target,this.subarray(start,start+len),targetStart)}return len};Buffer.prototype.fill=function fill(val,start,end,encoding){if(typeof val==="string"){if(typeof start==="string"){encoding=start;start=0;end=this.length}else if(typeof end==="string"){encoding=end;end=this.length}if(val.length===1){var code=val.charCodeAt(0);if(code<256){val=code}}if(encoding!==undefined&&typeof encoding!=="string"){throw new TypeError("encoding must be a string")}if(typeof encoding==="string"&&!Buffer.isEncoding(encoding)){throw new TypeError("Unknown encoding: "+encoding)}}else if(typeof val==="number"){val=val&255}if(start<0||this.length<start||this.length<end){throw new RangeError("Out of range index")}if(end<=start){return this}start=start>>>0;end=end===undefined?this.length:end>>>0;if(!val)val=0;var i;if(typeof val==="number"){for(i=start;i<end;++i){this[i]=val}}else{var bytes=Buffer.isBuffer(val)?val:utf8ToBytes(new Buffer(val,encoding).toString());var len=bytes.length;for(i=0;i<end-start;++i){this[i+start]=bytes[i%len]}}return this};var INVALID_BASE64_RE=/[^+\/0-9A-Za-z-_]/g;function base64clean(str){str=stringtrim(str).replace(INVALID_BASE64_RE,"");if(str.length<2)return"";while(str.length%4!==0){str=str+"="}return str}function stringtrim(str){if(str.trim)return str.trim();return str.replace(/^\s+|\s+$/g,"")}function toHex(n){if(n<16)return"0"+n.toString(16);return n.toString(16)}function utf8ToBytes(string,units){units=units||Infinity;var codePoint;var length=string.length;var leadSurrogate=null;var bytes=[];for(var i=0;i<length;++i){codePoint=string.charCodeAt(i);if(codePoint>55295&&codePoint<57344){if(!leadSurrogate){if(codePoint>56319){if((units-=3)>-1)bytes.push(239,191,189);continue}else if(i+1===length){if((units-=3)>-1)bytes.push(239,191,189);continue}leadSurrogate=codePoint;continue}if(codePoint<56320){if((units-=3)>-1)bytes.push(239,191,189);leadSurrogate=codePoint;continue}codePoint=(leadSurrogate-55296<<10|codePoint-56320)+65536}else if(leadSurrogate){if((units-=3)>-1)bytes.push(239,191,189)}leadSurrogate=null;if(codePoint<128){if((units-=1)<0)break;bytes.push(codePoint)}else if(codePoint<2048){if((units-=2)<0)break;bytes.push(codePoint>>6|192,codePoint&63|128)}else if(codePoint<65536){if((units-=3)<0)break;bytes.push(codePoint>>12|224,codePoint>>6&63|128,codePoint&63|128)}else if(codePoint<1114112){if((units-=4)<0)break;bytes.push(codePoint>>18|240,codePoint>>12&63|128,codePoint>>6&63|128,codePoint&63|128)}else{throw new Error("Invalid code point")}}return bytes}function asciiToBytes(str){var byteArray=[];for(var i=0;i<str.length;++i){byteArray.push(str.charCodeAt(i)&255)}return byteArray}function utf16leToBytes(str,units){var c,hi,lo;var byteArray=[];for(var i=0;i<str.length;++i){if((units-=2)<0)break;c=str.charCodeAt(i);hi=c>>8;lo=c%256;byteArray.push(lo);byteArray.push(hi)}return byteArray}function base64ToBytes(str){return base64.toByteArray(base64clean(str))}function blitBuffer(src,dst,offset,length){for(var i=0;i<length;++i){if(i+offset>=dst.length||i>=src.length)break;dst[i+offset]=src[i]}return i}function isnan(val){return val!==val}}).call(this,__webpack_require__(59))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(93)):undefined})(this,(function(exports,d3Time){"use strict";function localDate(d){if(0<=d.y&&d.y<100){var date=new Date(-1,d.m,d.d,d.H,d.M,d.S,d.L);date.setFullYear(d.y);return date}return new Date(d.y,d.m,d.d,d.H,d.M,d.S,d.L)}function utcDate(d){if(0<=d.y&&d.y<100){var date=new Date(Date.UTC(-1,d.m,d.d,d.H,d.M,d.S,d.L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(d.y,d.m,d.d,d.H,d.M,d.S,d.L))}function newDate(y,m,d){return{y:y,m:m,d:d,H:0,M:0,S:0,L:0}}function formatLocale(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_weekdays=locale.days,locale_shortWeekdays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;var periodRe=formatRe(locale_periods),periodLookup=formatLookup(locale_periods),weekdayRe=formatRe(locale_weekdays),weekdayLookup=formatLookup(locale_weekdays),shortWeekdayRe=formatRe(locale_shortWeekdays),shortWeekdayLookup=formatLookup(locale_shortWeekdays),monthRe=formatRe(locale_months),monthLookup=formatLookup(locale_months),shortMonthRe=formatRe(locale_shortMonths),shortMonthLookup=formatLookup(locale_shortMonths);var formats={a:formatShortWeekday,A:formatWeekday,b:formatShortMonth,B:formatMonth,c:null,d:formatDayOfMonth,e:formatDayOfMonth,f:formatMicroseconds,g:formatYearISO,G:formatFullYearISO,H:formatHour24,I:formatHour12,j:formatDayOfYear,L:formatMilliseconds,m:formatMonthNumber,M:formatMinutes,p:formatPeriod,q:formatQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatSeconds,u:formatWeekdayNumberMonday,U:formatWeekNumberSunday,V:formatWeekNumberISO,w:formatWeekdayNumberSunday,W:formatWeekNumberMonday,x:null,X:null,y:formatYear,Y:formatFullYear,Z:formatZone,"%":formatLiteralPercent};var utcFormats={a:formatUTCShortWeekday,A:formatUTCWeekday,b:formatUTCShortMonth,B:formatUTCMonth,c:null,d:formatUTCDayOfMonth,e:formatUTCDayOfMonth,f:formatUTCMicroseconds,g:formatUTCYearISO,G:formatUTCFullYearISO,H:formatUTCHour24,I:formatUTCHour12,j:formatUTCDayOfYear,L:formatUTCMilliseconds,m:formatUTCMonthNumber,M:formatUTCMinutes,p:formatUTCPeriod,q:formatUTCQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatUTCSeconds,u:formatUTCWeekdayNumberMonday,U:formatUTCWeekNumberSunday,V:formatUTCWeekNumberISO,w:formatUTCWeekdayNumberSunday,W:formatUTCWeekNumberMonday,x:null,X:null,y:formatUTCYear,Y:formatUTCFullYear,Z:formatUTCZone,"%":formatLiteralPercent};var parses={a:parseShortWeekday,A:parseWeekday,b:parseShortMonth,B:parseMonth,c:parseLocaleDateTime,d:parseDayOfMonth,e:parseDayOfMonth,f:parseMicroseconds,g:parseYear,G:parseFullYear,H:parseHour24,I:parseHour24,j:parseDayOfYear,L:parseMilliseconds,m:parseMonthNumber,M:parseMinutes,p:parsePeriod,q:parseQuarter,Q:parseUnixTimestamp,s:parseUnixTimestampSeconds,S:parseSeconds,u:parseWeekdayNumberMonday,U:parseWeekNumberSunday,V:parseWeekNumberISO,w:parseWeekdayNumberSunday,W:parseWeekNumberMonday,x:parseLocaleDate,X:parseLocaleTime,y:parseYear,Y:parseFullYear,Z:parseZone,"%":parseLiteralPercent};formats.x=newFormat(locale_date,formats);formats.X=newFormat(locale_time,formats);formats.c=newFormat(locale_dateTime,formats);utcFormats.x=newFormat(locale_date,utcFormats);utcFormats.X=newFormat(locale_time,utcFormats);utcFormats.c=newFormat(locale_dateTime,utcFormats);function newFormat(specifier,formats){return function(date){var string=[],i=-1,j=0,n=specifier.length,c,pad,format;if(!(date instanceof Date))date=new Date(+date);while(++i<n){if(specifier.charCodeAt(i)===37){string.push(specifier.slice(j,i));if((pad=pads[c=specifier.charAt(++i)])!=null)c=specifier.charAt(++i);else pad=c==="e"?" ":"0";if(format=formats[c])c=format(date,pad);string.push(c);j=i+1}}string.push(specifier.slice(j,i));return string.join("")}}function newParse(specifier,Z){return function(string){var d=newDate(1900,undefined,1),i=parseSpecifier(d,specifier,string+="",0),week,day;if(i!=string.length)return null;if("Q"in d)return new Date(d.Q);if("s"in d)return new Date(d.s*1e3+("L"in d?d.L:0));if(Z&&!("Z"in d))d.Z=0;if("p"in d)d.H=d.H%12+d.p*12;if(d.m===undefined)d.m="q"in d?d.q:0;if("V"in d){if(d.V<1||d.V>53)return null;if(!("w"in d))d.w=1;if("Z"in d){week=utcDate(newDate(d.y,0,1)),day=week.getUTCDay();week=day>4||day===0?d3Time.utcMonday.ceil(week):d3Time.utcMonday(week);week=d3Time.utcDay.offset(week,(d.V-1)*7);d.y=week.getUTCFullYear();d.m=week.getUTCMonth();d.d=week.getUTCDate()+(d.w+6)%7}else{week=localDate(newDate(d.y,0,1)),day=week.getDay();week=day>4||day===0?d3Time.timeMonday.ceil(week):d3Time.timeMonday(week);week=d3Time.timeDay.offset(week,(d.V-1)*7);d.y=week.getFullYear();d.m=week.getMonth();d.d=week.getDate()+(d.w+6)%7}}else if("W"in d||"U"in d){if(!("w"in d))d.w="u"in d?d.u%7:"W"in d?1:0;day="Z"in d?utcDate(newDate(d.y,0,1)).getUTCDay():localDate(newDate(d.y,0,1)).getDay();d.m=0;d.d="W"in d?(d.w+6)%7+d.W*7-(day+5)%7:d.w+d.U*7-(day+6)%7}if("Z"in d){d.H+=d.Z/100|0;d.M+=d.Z%100;return utcDate(d)}return localDate(d)}}function parseSpecifier(d,specifier,string,j){var i=0,n=specifier.length,m=string.length,c,parse;while(i<n){if(j>=m)return-1;c=specifier.charCodeAt(i++);if(c===37){c=specifier.charAt(i++);parse=parses[c in pads?specifier.charAt(i++):c];if(!parse||(j=parse(d,string,j))<0)return-1}else if(c!=string.charCodeAt(j++)){return-1}}return j}function parsePeriod(d,string,i){var n=periodRe.exec(string.slice(i));return n?(d.p=periodLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortWeekday(d,string,i){var n=shortWeekdayRe.exec(string.slice(i));return n?(d.w=shortWeekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseWeekday(d,string,i){var n=weekdayRe.exec(string.slice(i));return n?(d.w=weekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortMonth(d,string,i){var n=shortMonthRe.exec(string.slice(i));return n?(d.m=shortMonthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseMonth(d,string,i){var n=monthRe.exec(string.slice(i));return n?(d.m=monthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseLocaleDateTime(d,string,i){return parseSpecifier(d,locale_dateTime,string,i)}function parseLocaleDate(d,string,i){return parseSpecifier(d,locale_date,string,i)}function parseLocaleTime(d,string,i){return parseSpecifier(d,locale_time,string,i)}function formatShortWeekday(d){return locale_shortWeekdays[d.getDay()]}function formatWeekday(d){return locale_weekdays[d.getDay()]}function formatShortMonth(d){return locale_shortMonths[d.getMonth()]}function formatMonth(d){return locale_months[d.getMonth()]}function formatPeriod(d){return locale_periods[+(d.getHours()>=12)]}function formatQuarter(d){return 1+~~(d.getMonth()/3)}function formatUTCShortWeekday(d){return locale_shortWeekdays[d.getUTCDay()]}function formatUTCWeekday(d){return locale_weekdays[d.getUTCDay()]}function formatUTCShortMonth(d){return locale_shortMonths[d.getUTCMonth()]}function formatUTCMonth(d){return locale_months[d.getUTCMonth()]}function formatUTCPeriod(d){return locale_periods[+(d.getUTCHours()>=12)]}function formatUTCQuarter(d){return 1+~~(d.getUTCMonth()/3)}return{format:function(specifier){var f=newFormat(specifier+="",formats);f.toString=function(){return specifier};return f},parse:function(specifier){var p=newParse(specifier+="",false);p.toString=function(){return specifier};return p},utcFormat:function(specifier){var f=newFormat(specifier+="",utcFormats);f.toString=function(){return specifier};return f},utcParse:function(specifier){var p=newParse(specifier+="",true);p.toString=function(){return specifier};return p}}}var pads={"-":"",_:" ",0:"0"},numberRe=/^\s*\d+/,percentRe=/^%/,requoteRe=/[\\^$*+?|[\]().{}]/g;function pad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function requote(s){return s.replace(requoteRe,"\\$&")}function formatRe(names){return new RegExp("^(?:"+names.map(requote).join("|")+")","i")}function formatLookup(names){return new Map(names.map((name,i)=>[name.toLowerCase(),i]))}function parseWeekdayNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.w=+n[0],i+n[0].length):-1}function parseWeekdayNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.u=+n[0],i+n[0].length):-1}function parseWeekNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.U=+n[0],i+n[0].length):-1}function parseWeekNumberISO(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.V=+n[0],i+n[0].length):-1}function parseWeekNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.W=+n[0],i+n[0].length):-1}function parseFullYear(d,string,i){var n=numberRe.exec(string.slice(i,i+4));return n?(d.y=+n[0],i+n[0].length):-1}function parseYear(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.y=+n[0]+(+n[0]>68?1900:2e3),i+n[0].length):-1}function parseZone(d,string,i){var n=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i,i+6));return n?(d.Z=n[1]?0:-(n[2]+(n[3]||"00")),i+n[0].length):-1}function parseQuarter(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.q=n[0]*3-3,i+n[0].length):-1}function parseMonthNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.m=n[0]-1,i+n[0].length):-1}function parseDayOfMonth(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.d=+n[0],i+n[0].length):-1}function parseDayOfYear(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.m=0,d.d=+n[0],i+n[0].length):-1}function parseHour24(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.H=+n[0],i+n[0].length):-1}function parseMinutes(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.M=+n[0],i+n[0].length):-1}function parseSeconds(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.S=+n[0],i+n[0].length):-1}function parseMilliseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.L=+n[0],i+n[0].length):-1}function parseMicroseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+6));return n?(d.L=Math.floor(n[0]/1e3),i+n[0].length):-1}function parseLiteralPercent(d,string,i){var n=percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function parseUnixTimestamp(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.Q=+n[0],i+n[0].length):-1}function parseUnixTimestampSeconds(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.s=+n[0],i+n[0].length):-1}function formatDayOfMonth(d,p){return pad(d.getDate(),p,2)}function formatHour24(d,p){return pad(d.getHours(),p,2)}function formatHour12(d,p){return pad(d.getHours()%12||12,p,2)}function formatDayOfYear(d,p){return pad(1+d3Time.timeDay.count(d3Time.timeYear(d),d),p,3)}function formatMilliseconds(d,p){return pad(d.getMilliseconds(),p,3)}function formatMicroseconds(d,p){return formatMilliseconds(d,p)+"000"}function formatMonthNumber(d,p){return pad(d.getMonth()+1,p,2)}function formatMinutes(d,p){return pad(d.getMinutes(),p,2)}function formatSeconds(d,p){return pad(d.getSeconds(),p,2)}function formatWeekdayNumberMonday(d){var day=d.getDay();return day===0?7:day}function formatWeekNumberSunday(d,p){return pad(d3Time.timeSunday.count(d3Time.timeYear(d)-1,d),p,2)}function dISO(d){var day=d.getDay();return day>=4||day===0?d3Time.timeThursday(d):d3Time.timeThursday.ceil(d)}function formatWeekNumberISO(d,p){d=dISO(d);return pad(d3Time.timeThursday.count(d3Time.timeYear(d),d)+(d3Time.timeYear(d).getDay()===4),p,2)}function formatWeekdayNumberSunday(d){return d.getDay()}function formatWeekNumberMonday(d,p){return pad(d3Time.timeMonday.count(d3Time.timeYear(d)-1,d),p,2)}function formatYear(d,p){return pad(d.getFullYear()%100,p,2)}function formatYearISO(d,p){d=dISO(d);return pad(d.getFullYear()%100,p,2)}function formatFullYear(d,p){return pad(d.getFullYear()%1e4,p,4)}function formatFullYearISO(d,p){var day=d.getDay();d=day>=4||day===0?d3Time.timeThursday(d):d3Time.timeThursday.ceil(d);return pad(d.getFullYear()%1e4,p,4)}function formatZone(d){var z=d.getTimezoneOffset();return(z>0?"-":(z*=-1,"+"))+pad(z/60|0,"0",2)+pad(z%60,"0",2)}function formatUTCDayOfMonth(d,p){return pad(d.getUTCDate(),p,2)}function formatUTCHour24(d,p){return pad(d.getUTCHours(),p,2)}function formatUTCHour12(d,p){return pad(d.getUTCHours()%12||12,p,2)}function formatUTCDayOfYear(d,p){return pad(1+d3Time.utcDay.count(d3Time.utcYear(d),d),p,3)}function formatUTCMilliseconds(d,p){return pad(d.getUTCMilliseconds(),p,3)}function formatUTCMicroseconds(d,p){return formatUTCMilliseconds(d,p)+"000"}function formatUTCMonthNumber(d,p){return pad(d.getUTCMonth()+1,p,2)}function formatUTCMinutes(d,p){return pad(d.getUTCMinutes(),p,2)}function formatUTCSeconds(d,p){return pad(d.getUTCSeconds(),p,2)}function formatUTCWeekdayNumberMonday(d){var dow=d.getUTCDay();return dow===0?7:dow}function formatUTCWeekNumberSunday(d,p){return pad(d3Time.utcSunday.count(d3Time.utcYear(d)-1,d),p,2)}function UTCdISO(d){var day=d.getUTCDay();return day>=4||day===0?d3Time.utcThursday(d):d3Time.utcThursday.ceil(d)}function formatUTCWeekNumberISO(d,p){d=UTCdISO(d);return pad(d3Time.utcThursday.count(d3Time.utcYear(d),d)+(d3Time.utcYear(d).getUTCDay()===4),p,2)}function formatUTCWeekdayNumberSunday(d){return d.getUTCDay()}function formatUTCWeekNumberMonday(d,p){return pad(d3Time.utcMonday.count(d3Time.utcYear(d)-1,d),p,2)}function formatUTCYear(d,p){return pad(d.getUTCFullYear()%100,p,2)}function formatUTCYearISO(d,p){d=UTCdISO(d);return pad(d.getUTCFullYear()%100,p,2)}function formatUTCFullYear(d,p){return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCFullYearISO(d,p){var day=d.getUTCDay();d=day>=4||day===0?d3Time.utcThursday(d):d3Time.utcThursday.ceil(d);return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCZone(){return"+0000"}function formatLiteralPercent(){return"%"}function formatUnixTimestamp(d){return+d}function formatUnixTimestampSeconds(d){return Math.floor(+d/1e3)}var locale;defaultLocale({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function defaultLocale(definition){locale=formatLocale(definition);exports.timeFormat=locale.format;exports.timeParse=locale.parse;exports.utcFormat=locale.utcFormat;exports.utcParse=locale.utcParse;return locale}var isoSpecifier="%Y-%m-%dT%H:%M:%S.%LZ";function formatIsoNative(date){return date.toISOString()}var formatIso=Date.prototype.toISOString?formatIsoNative:exports.utcFormat(isoSpecifier);function parseIsoNative(string){var date=new Date(string);return isNaN(date)?null:date}var parseIso=+new Date("2000-01-01T00:00:00.000Z")?parseIsoNative:exports.utcParse(isoSpecifier);exports.isoFormat=formatIso;exports.isoParse=parseIso;exports.timeFormatDefaultLocale=defaultLocale;exports.timeFormatLocale=formatLocale;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";const pi=Math.PI,tau=2*pi,epsilon=1e-6,tauEpsilon=tau-epsilon;function Path(){this._x0=this._y0=this._x1=this._y1=null;this._=""}function path(){return new Path}Path.prototype=path.prototype={constructor:Path,moveTo:function(x,y){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)},closePath:function(){if(this._x1!==null){this._x1=this._x0,this._y1=this._y0;this._+="Z"}},lineTo:function(x,y){this._+="L"+(this._x1=+x)+","+(this._y1=+y)},quadraticCurveTo:function(x1,y1,x,y){this._+="Q"+ +x1+","+ +y1+","+(this._x1=+x)+","+(this._y1=+y)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._+="C"+ +x1+","+ +y1+","+ +x2+","+ +y2+","+(this._x1=+x)+","+(this._y1=+y)},arcTo:function(x1,y1,x2,y2,r){x1=+x1,y1=+y1,x2=+x2,y2=+y2,r=+r;var x0=this._x1,y0=this._y1,x21=x2-x1,y21=y2-y1,x01=x0-x1,y01=y0-y1,l01_2=x01*x01+y01*y01;if(r<0)throw new Error("negative radius: "+r);if(this._x1===null){this._+="M"+(this._x1=x1)+","+(this._y1=y1)}else if(!(l01_2>epsilon));else if(!(Math.abs(y01*x21-y21*x01)>epsilon)||!r){this._+="L"+(this._x1=x1)+","+(this._y1=y1)}else{var x20=x2-x0,y20=y2-y0,l21_2=x21*x21+y21*y21,l20_2=x20*x20+y20*y20,l21=Math.sqrt(l21_2),l01=Math.sqrt(l01_2),l=r*Math.tan((pi-Math.acos((l21_2+l01_2-l20_2)/(2*l21*l01)))/2),t01=l/l01,t21=l/l21;if(Math.abs(t01-1)>epsilon){this._+="L"+(x1+t01*x01)+","+(y1+t01*y01)}this._+="A"+r+","+r+",0,0,"+ +(y01*x20>x01*y20)+","+(this._x1=x1+t21*x21)+","+(this._y1=y1+t21*y21)}},arc:function(x,y,r,a0,a1,ccw){x=+x,y=+y,r=+r,ccw=!!ccw;var dx=r*Math.cos(a0),dy=r*Math.sin(a0),x0=x+dx,y0=y+dy,cw=1^ccw,da=ccw?a0-a1:a1-a0;if(r<0)throw new Error("negative radius: "+r);if(this._x1===null){this._+="M"+x0+","+y0}else if(Math.abs(this._x1-x0)>epsilon||Math.abs(this._y1-y0)>epsilon){this._+="L"+x0+","+y0}if(!r)return;if(da<0)da=da%tau+tau;if(da>tauEpsilon){this._+="A"+r+","+r+",0,1,"+cw+","+(x-dx)+","+(y-dy)+"A"+r+","+r+",0,1,"+cw+","+(this._x1=x0)+","+(this._y1=y0)}else if(da>epsilon){this._+="A"+r+","+r+",0,"+ +(da>=pi)+","+cw+","+(this._x1=x+r*Math.cos(a1))+","+(this._y1=y+r*Math.sin(a1))}},rect:function(x,y,w,h){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)+"h"+ +w+"v"+ +h+"h"+-w+"Z"},toString:function(){return this._}};exports.path=path;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function bisector(f){let delta=f;let compare=f;if(f.length===1){delta=(d,x)=>f(d)-x;compare=ascendingComparator(f)}function left(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid}return lo}function right(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1}return lo}function center(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;const i=left(a,x,lo,hi-1);return i>lo&&delta(a[i-1],x)>-delta(a[i],x)?i-1:i}return{left:left,center:center,right:right}}function ascendingComparator(f){return(d,x)=>ascending(f(d),x)}function number(x){return x===null?NaN:+x}function*numbers(values,valueof){if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){yield value}}}}const ascendingBisect=bisector(ascending);const bisectRight=ascendingBisect.right;const bisectLeft=ascendingBisect.left;const bisectCenter=bisector(number).center;function count(values,valueof){let count=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count}}}return count}function length(array){return array.length|0}function empty(length){return!(length>0)}function arrayify(values){return typeof values!=="object"||"length"in values?values:Array.from(values)}function reducer(reduce){return values=>reduce(...values)}function cross(...values){const reduce=typeof values[values.length-1]==="function"&&reducer(values.pop());values=values.map(arrayify);const lengths=values.map(length);const j=values.length-1;const index=new Array(j+1).fill(0);const product=[];if(j<0||lengths.some(empty))return product;while(true){product.push(index.map((j,i)=>values[i][j]));let i=j;while(++index[i]===lengths[i]){if(i===0)return reduce?product.map(reduce):product;index[i--]=0}}}function cumsum(values,valueof){var sum=0,index=0;return Float64Array.from(values,valueof===undefined?v=>sum+=+v||0:v=>sum+=+valueof(v,index++,values)||0)}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function variance(values,valueof){let count=0;let delta;let mean=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}if(count>1)return sum/(count-1)}function deviation(values,valueof){const v=variance(values,valueof);return v?Math.sqrt(v):v}function extent(values,valueof){let min;let max;if(valueof===undefined){for(const value of values){if(value!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}return[min,max]}class Adder{constructor(){this._partials=new Float64Array(32);this._n=0}add(x){const p=this._partials;let i=0;for(let j=0;j<this._n&&j<32;j++){const y=p[j],hi=x+y,lo=Math.abs(x)<Math.abs(y)?x-(hi-y):y-(hi-x);if(lo)p[i++]=lo;x=hi}p[i]=x;this._n=i+1;return this}valueOf(){const p=this._partials;let n=this._n,x,y,lo,hi=0;if(n>0){hi=p[--n];while(n>0){x=hi;y=p[--n];hi=x+y;lo=y-(hi-x);if(lo)break}if(n>0&&(lo<0&&p[n-1]<0||lo>0&&p[n-1]>0)){y=lo*2;x=hi+y;if(y==x-hi)hi=x}}return hi}}function fsum(values,valueof){const adder=new Adder;if(valueof===undefined){for(let value of values){if(value=+value){adder.add(value)}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){adder.add(value)}}}return+adder}function identity(x){return x}function group(values,...keys){return nest(values,identity,identity,keys)}function groups(values,...keys){return nest(values,Array.from,identity,keys)}function rollup(values,reduce,...keys){return nest(values,identity,reduce,keys)}function rollups(values,reduce,...keys){return nest(values,Array.from,reduce,keys)}function index(values,...keys){return nest(values,identity,unique,keys)}function indexes(values,...keys){return nest(values,Array.from,unique,keys)}function unique(values){if(values.length!==1)throw new Error("duplicate key");return values[0]}function nest(values,map,reduce,keys){return function regroup(values,i){if(i>=keys.length)return reduce(values);const groups=new Map;const keyof=keys[i++];let index=-1;for(const value of values){const key=keyof(value,++index,values);const group=groups.get(key);if(group)group.push(value);else groups.set(key,[value])}for(const[key,values]of groups){groups.set(key,regroup(values,i))}return map(groups)}(values,0)}var array=Array.prototype;var slice=array.slice;function constant(x){return function(){return x}}var e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function ticks(start,stop,count){var reverse,i=-1,n,ticks,step;stop=+stop,start=+start,count=+count;if(start===stop&&count>0)return[start];if(reverse=stop<start)n=start,start=stop,stop=n;if((step=tickIncrement(start,stop,count))===0||!isFinite(step))return[];if(step>0){start=Math.ceil(start/step);stop=Math.floor(stop/step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)*step}else{step=-step;start=Math.ceil(start*step);stop=Math.floor(stop*step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)/step}if(reverse)ticks.reverse();return ticks}function tickIncrement(start,stop,count){var step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log(step)/Math.LN10),error=step/Math.pow(10,power);return power>=0?(error>=e10?10:error>=e5?5:error>=e2?2:1)*Math.pow(10,power):-Math.pow(10,-power)/(error>=e10?10:error>=e5?5:error>=e2?2:1)}function tickStep(start,stop,count){var step0=Math.abs(stop-start)/Math.max(0,count),step1=Math.pow(10,Math.floor(Math.log(step0)/Math.LN10)),error=step0/step1;if(error>=e10)step1*=10;else if(error>=e5)step1*=5;else if(error>=e2)step1*=2;return stop<start?-step1:step1}function nice(start,stop,count){let prestep;while(true){const step=tickIncrement(start,stop,count);if(step===prestep||step===0||!isFinite(step)){return[start,stop]}else if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step}prestep=step}}function sturges(values){return Math.ceil(Math.log(count(values))/Math.LN2)+1}function bin(){var value=identity,domain=extent,threshold=sturges;function histogram(data){if(!Array.isArray(data))data=Array.from(data);var i,n=data.length,x,values=new Array(n);for(i=0;i<n;++i){values[i]=value(data[i],i,data)}var xz=domain(values),x0=xz[0],x1=xz[1],tz=threshold(values,x0,x1);if(!Array.isArray(tz)){tz=+tz;if(domain===extent)[x0,x1]=nice(x0,x1,tz);tz=ticks(x0,x1,tz);if(tz[tz.length-1]===x1)tz.pop()}var m=tz.length;while(tz[0]<=x0)tz.shift(),--m;while(tz[m-1]>x1)tz.pop(),--m;var bins=new Array(m+1),bin;for(i=0;i<=m;++i){bin=bins[i]=[];bin.x0=i>0?tz[i-1]:x0;bin.x1=i<m?tz[i]:x1}for(i=0;i<n;++i){x=values[i];if(x0<=x&&x<=x1){bins[bisectRight(tz,x,0,m)].push(data[i])}}return bins}histogram.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(_),histogram):value};histogram.domain=function(_){return arguments.length?(domain=typeof _==="function"?_:constant([_[0],_[1]]),histogram):domain};histogram.thresholds=function(_){return arguments.length?(threshold=typeof _==="function"?_:Array.isArray(_)?constant(slice.call(_)):constant(_),histogram):threshold};return histogram}function max(values,valueof){let max;if(valueof===undefined){for(const value of values){if(value!=null&&(max<value||max===undefined&&value>=value)){max=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value}}}return max}function min(values,valueof){let min;if(valueof===undefined){for(const value of values){if(value!=null&&(min>value||min===undefined&&value>=value)){min=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value}}}return min}function quickselect(array,k,left=0,right=array.length-1,compare=ascending){while(right>left){if(right-left>600){const n=right-left+1;const m=k-left+1;const z=Math.log(n);const s=.5*Math.exp(2*z/3);const sd=.5*Math.sqrt(z*s*(n-s)/n)*(m-n/2<0?-1:1);const newLeft=Math.max(left,Math.floor(k-m*s/n+sd));const newRight=Math.min(right,Math.floor(k+(n-m)*s/n+sd));quickselect(array,k,newLeft,newRight,compare)}const t=array[k];let i=left;let j=right;swap(array,left,k);if(compare(array[right],t)>0)swap(array,left,right);while(i<j){swap(array,i,j),++i,--j;while(compare(array[i],t)<0)++i;while(compare(array[j],t)>0)--j}if(compare(array[left],t)===0)swap(array,left,j);else++j,swap(array,j,right);if(j<=k)left=j+1;if(k<=j)right=j-1}return array}function swap(array,i,j){const t=array[i];array[i]=array[j];array[j]=t}function quantile(values,p,valueof){values=Float64Array.from(numbers(values,valueof));if(!(n=values.length))return;if((p=+p)<=0||n<2)return min(values);if(p>=1)return max(values);var n,i=(n-1)*p,i0=Math.floor(i),value0=max(quickselect(values,i0).subarray(0,i0+1)),value1=min(values.subarray(i0+1));return value0+(value1-value0)*(i-i0)}function quantileSorted(values,p,valueof=number){if(!(n=values.length))return;if((p=+p)<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function freedmanDiaconis(values,min,max){return Math.ceil((max-min)/(2*(quantile(values,.75)-quantile(values,.25))*Math.pow(count(values),-1/3)))}function scott(values,min,max){return Math.ceil((max-min)/(3.5*deviation(values)*Math.pow(count(values),-1/3)))}function maxIndex(values,valueof){let max;let maxIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}return maxIndex}function mean(values,valueof){let count=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count,sum+=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count,sum+=value}}}if(count)return sum/count}function median(values,valueof){return quantile(values,.5,valueof)}function*flatten(arrays){for(const array of arrays){yield*array}}function merge(arrays){return Array.from(flatten(arrays))}function minIndex(values,valueof){let min;let minIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}return minIndex}function pairs(values,pairof=pair){const pairs=[];let previous;let first=false;for(const value of values){if(first)pairs.push(pairof(previous,value));previous=value;first=true}return pairs}function pair(a,b){return[a,b]}function permute(source,keys){return Array.from(keys,key=>source[key])}function range(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}function least(values,compare=ascending){let min;let defined=false;if(compare.length===1){let minValue;for(const element of values){const value=compare(element);if(defined?ascending(value,minValue)<0:ascending(value,value)===0){min=element;minValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,min)<0:compare(value,value)===0){min=value;defined=true}}}return min}function leastIndex(values,compare=ascending){if(compare.length===1)return minIndex(values,compare);let minValue;let min=-1;let index=-1;for(const value of values){++index;if(min<0?compare(value,value)===0:compare(value,minValue)<0){minValue=value;min=index}}return min}function greatest(values,compare=ascending){let max;let defined=false;if(compare.length===1){let maxValue;for(const element of values){const value=compare(element);if(defined?ascending(value,maxValue)>0:ascending(value,value)===0){max=element;maxValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,max)>0:compare(value,value)===0){max=value;defined=true}}}return max}function greatestIndex(values,compare=ascending){if(compare.length===1)return maxIndex(values,compare);let maxValue;let max=-1;let index=-1;for(const value of values){++index;if(max<0?compare(value,value)===0:compare(value,maxValue)>0){maxValue=value;max=index}}return max}function scan(values,compare){const index=leastIndex(values,compare);return index<0?undefined:index}var shuffle=shuffler(Math.random);function shuffler(random){return function shuffle(array,i0=0,i1=array.length){let m=i1-(i0=+i0);while(m){const i=random()*m--|0,t=array[m+i0];array[m+i0]=array[i+i0];array[i+i0]=t}return array}}function sum(values,valueof){let sum=0;if(valueof===undefined){for(let value of values){if(value=+value){sum+=value}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){sum+=value}}}return sum}function transpose(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=min(matrix,length$1),transpose=new Array(m);++i<m;){for(var j=-1,n,row=transpose[i]=new Array(n);++j<n;){row[j]=matrix[j][i]}}return transpose}function length$1(d){return d.length}function zip(){return transpose(arguments)}function every(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(!test(value,++index,values)){return false}}return true}function some(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(test(value,++index,values)){return true}}return false}function filter(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");const array=[];let index=-1;for(const value of values){if(test(value,++index,values)){array.push(value)}}return array}function map(values,mapper){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");if(typeof mapper!=="function")throw new TypeError("mapper is not a function");return Array.from(values,(value,index)=>mapper(value,index,values))}function reduce(values,reducer,value){if(typeof reducer!=="function")throw new TypeError("reducer is not a function");const iterator=values[Symbol.iterator]();let done,next,index=-1;if(arguments.length<3){({done:done,value:value}=iterator.next());if(done)return;++index}while(({done:done,value:next}=iterator.next()),!done){value=reducer(value,next,++index,values)}return value}function reverse(values){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).reverse()}function sort(values,comparator=ascending){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).sort(comparator)}function difference(values,...others){values=new Set(values);for(const other of others){for(const value of other){values.delete(value)}}return values}function disjoint(values,other){const iterator=other[Symbol.iterator](),set=new Set;for(const v of values){if(set.has(v))return false;let value,done;while(({value:value,done:done}=iterator.next())){if(done)break;if(Object.is(v,value))return false;set.add(value)}}return true}function set(values){return values instanceof Set?values:new Set(values)}function intersection(values,...others){values=new Set(values);others=others.map(set);out:for(const value of values){for(const other of others){if(!other.has(value)){values.delete(value);continue out}}}return values}function superset(values,other){const iterator=values[Symbol.iterator](),set=new Set;for(const o of other){if(set.has(o))continue;let value,done;while(({value:value,done:done}=iterator.next())){if(done)return false;set.add(value);if(Object.is(o,value))break}}return true}function subset(values,other){return superset(other,values)}function union(...others){const set=new Set;for(const other of others){for(const o of other){set.add(o)}}return set}exports.Adder=Adder;exports.ascending=ascending;exports.bin=bin;exports.bisect=bisectRight;exports.bisectCenter=bisectCenter;exports.bisectLeft=bisectLeft;exports.bisectRight=bisectRight;exports.bisector=bisector;exports.count=count;exports.cross=cross;exports.cumsum=cumsum;exports.descending=descending;exports.deviation=deviation;exports.difference=difference;exports.disjoint=disjoint;exports.every=every;exports.extent=extent;exports.filter=filter;exports.fsum=fsum;exports.greatest=greatest;exports.greatestIndex=greatestIndex;exports.group=group;exports.groups=groups;exports.histogram=bin;exports.index=index;exports.indexes=indexes;exports.intersection=intersection;exports.least=least;exports.leastIndex=leastIndex;exports.map=map;exports.max=max;exports.maxIndex=maxIndex;exports.mean=mean;exports.median=median;exports.merge=merge;exports.min=min;exports.minIndex=minIndex;exports.nice=nice;exports.pairs=pairs;exports.permute=permute;exports.quantile=quantile;exports.quantileSorted=quantileSorted;exports.quickselect=quickselect;exports.range=range;exports.reduce=reduce;exports.reverse=reverse;exports.rollup=rollup;exports.rollups=rollups;exports.scan=scan;exports.shuffle=shuffle;exports.shuffler=shuffler;exports.some=some;exports.sort=sort;exports.subset=subset;exports.sum=sum;exports.superset=superset;exports.thresholdFreedmanDiaconis=freedmanDiaconis;exports.thresholdScott=scott;exports.thresholdSturges=sturges;exports.tickIncrement=tickIncrement;exports.tickStep=tickStep;exports.ticks=ticks;exports.transpose=transpose;exports.union=union;exports.variance=variance;exports.zip=zip;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(51),__webpack_require__(110)):undefined})(this,(function(exports,d3Geo,d3GeoProjection){"use strict";const defaultPath=d3Geo.geoPath();const projectionProperties=["clipAngle","clipExtent","scale","translate","center","rotate","parallels","precision","reflectX","reflectY","coefficient","distance","fraction","lobes","parallel","radius","ratio","spacing","tilt"];function create(type,constructor){return function projection(){const p=constructor();p.type=type;p.path=d3Geo.geoPath().projection(p);p.copy=p.copy||function(){const c=projection();projectionProperties.forEach(prop=>{if(p[prop])c[prop](p[prop]())});c.path.pointRadius(p.path.pointRadius());return c};return p}}function projection(type,proj){if(!type||typeof type!=="string"){throw new Error("Projection type must be a name string.")}type=type.toLowerCase();if(arguments.length>1){projections[type]=create(type,proj);return this}else{return projections[type]||null}}function getProjectionPath(proj){return proj&&proj.path||defaultPath}const projections={albers:d3Geo.geoAlbers,albersusa:d3Geo.geoAlbersUsa,azimuthalequalarea:d3Geo.geoAzimuthalEqualArea,azimuthalequidistant:d3Geo.geoAzimuthalEquidistant,conicconformal:d3Geo.geoConicConformal,conicequalarea:d3Geo.geoConicEqualArea,conicequidistant:d3Geo.geoConicEquidistant,equalEarth:d3Geo.geoEqualEarth,equirectangular:d3Geo.geoEquirectangular,gnomonic:d3Geo.geoGnomonic,identity:d3Geo.geoIdentity,mercator:d3Geo.geoMercator,mollweide:d3GeoProjection.geoMollweide,naturalEarth1:d3Geo.geoNaturalEarth1,orthographic:d3Geo.geoOrthographic,stereographic:d3Geo.geoStereographic,transversemercator:d3Geo.geoTransverseMercator};for(const key in projections){projection(key,projections[key])}exports.getProjectionPath=getProjectionPath;exports.projection=projection;exports.projectionProperties=projectionProperties;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var frame=0,timeout=0,interval=0,pokeDelay=1e3,taskHead,taskTail,clockLast=0,clockNow=0,clockSkew=0,clock=typeof performance==="object"&&performance.now?performance:Date,setFrame=typeof window==="object"&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(f){setTimeout(f,17)};function now(){return clockNow||(setFrame(clearNow),clockNow=clock.now()+clockSkew)}function clearNow(){clockNow=0}function Timer(){this._call=this._time=this._next=null}Timer.prototype=timer.prototype={constructor:Timer,restart:function(callback,delay,time){if(typeof callback!=="function")throw new TypeError("callback is not a function");time=(time==null?now():+time)+(delay==null?0:+delay);if(!this._next&&taskTail!==this){if(taskTail)taskTail._next=this;else taskHead=this;taskTail=this}this._call=callback;this._time=time;sleep()},stop:function(){if(this._call){this._call=null;this._time=Infinity;sleep()}}};function timer(callback,delay,time){var t=new Timer;t.restart(callback,delay,time);return t}function timerFlush(){now();++frame;var t=taskHead,e;while(t){if((e=clockNow-t._time)>=0)t._call.call(null,e);t=t._next}--frame}function wake(){clockNow=(clockLast=clock.now())+clockSkew;frame=timeout=0;try{timerFlush()}finally{frame=0;nap();clockNow=0}}function poke(){var now=clock.now(),delay=now-clockLast;if(delay>pokeDelay)clockSkew-=delay,clockLast=now}function nap(){var t0,t1=taskHead,t2,time=Infinity;while(t1){if(t1._call){if(time>t1._time)time=t1._time;t0=t1,t1=t1._next}else{t2=t1._next,t1._next=null;t1=t0?t0._next=t2:taskHead=t2}}taskTail=t0;sleep(time)}function sleep(time){if(frame)return;if(timeout)timeout=clearTimeout(timeout);var delay=time-clockNow;if(delay>24){if(time<Infinity)timeout=setTimeout(wake,time-clock.now()-clockSkew);if(interval)interval=clearInterval(interval)}else{if(!interval)clockLast=clock.now(),interval=setInterval(poke,pokeDelay);frame=1,setFrame(wake)}}function timeout$1(callback,delay,time){var t=new Timer;delay=delay==null?0:+delay;t.restart(elapsed=>{t.stop();callback(elapsed+delay)},delay,time);return t}function interval$1(callback,delay,time){var t=new Timer,total=delay;if(delay==null)return t.restart(callback,delay,time),t;t._restart=t.restart;t.restart=function(callback,delay,time){delay=+delay,time=time==null?now():+time;t._restart((function tick(elapsed){elapsed+=total;t._restart(tick,total+=delay,time);callback(elapsed)}),delay,time)};t.restart(callback,delay,time);return t}exports.interval=interval$1;exports.now=now;exports.timeout=timeout$1;exports.timer=timer;exports.timerFlush=timerFlush;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36)):undefined})(this,(function(exports,vegaUtil){"use strict";const RawCode="RawCode";const Literal="Literal";const Property="Property";const Identifier="Identifier";const ArrayExpression="ArrayExpression";const BinaryExpression="BinaryExpression";const CallExpression="CallExpression";const ConditionalExpression="ConditionalExpression";const LogicalExpression="LogicalExpression";const MemberExpression="MemberExpression";const ObjectExpression="ObjectExpression";const UnaryExpression="UnaryExpression";function ASTNode(type){this.type=type}ASTNode.prototype.visit=function(visitor){let c,i,n;if(visitor(this))return 1;for(c=children(this),i=0,n=c.length;i<n;++i){if(c[i].visit(visitor))return 1}};function children(node){switch(node.type){case ArrayExpression:return node.elements;case BinaryExpression:case LogicalExpression:return[node.left,node.right];case CallExpression:return[node.callee].concat(node.arguments);case ConditionalExpression:return[node.test,node.consequent,node.alternate];case MemberExpression:return[node.object,node.property];case ObjectExpression:return node.properties;case Property:return[node.key,node.value];case UnaryExpression:return[node.argument];case Identifier:case Literal:case RawCode:default:return[]}}var TokenName,source,index,length,lookahead;var TokenBooleanLiteral=1,TokenEOF=2,TokenIdentifier=3,TokenKeyword=4,TokenNullLiteral=5,TokenNumericLiteral=6,TokenPunctuator=7,TokenStringLiteral=8,TokenRegularExpression=9;TokenName={};TokenName[TokenBooleanLiteral]="Boolean";TokenName[TokenEOF]="<end>";TokenName[TokenIdentifier]="Identifier";TokenName[TokenKeyword]="Keyword";TokenName[TokenNullLiteral]="Null";TokenName[TokenNumericLiteral]="Numeric";TokenName[TokenPunctuator]="Punctuator";TokenName[TokenStringLiteral]="String";TokenName[TokenRegularExpression]="RegularExpression";var SyntaxArrayExpression="ArrayExpression",SyntaxBinaryExpression="BinaryExpression",SyntaxCallExpression="CallExpression",SyntaxConditionalExpression="ConditionalExpression",SyntaxIdentifier="Identifier",SyntaxLiteral="Literal",SyntaxLogicalExpression="LogicalExpression",SyntaxMemberExpression="MemberExpression",SyntaxObjectExpression="ObjectExpression",SyntaxProperty="Property",SyntaxUnaryExpression="UnaryExpression";var MessageUnexpectedToken="Unexpected token %0",MessageUnexpectedNumber="Unexpected number",MessageUnexpectedString="Unexpected string",MessageUnexpectedIdentifier="Unexpected identifier",MessageUnexpectedReserved="Unexpected reserved word",MessageUnexpectedEOS="Unexpected end of input",MessageInvalidRegExp="Invalid regular expression",MessageUnterminatedRegExp="Invalid regular expression: missing /",MessageStrictOctalLiteral="Octal literals are not allowed in strict mode.",MessageStrictDuplicateProperty="Duplicate data property in object literal not allowed in strict mode";var ILLEGAL="ILLEGAL",DISABLED="Disabled.";var RegexNonAsciiIdentifierStart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u08A0-\\u08B2\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1CE9-\\u1CEC\\u1CEE-\\u1CF1\\u1CF5\\u1CF6\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"),RegexNonAsciiIdentifierPart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u0800-\\u082D\\u0840-\\u085B\\u08A0-\\u08B2\\u08E4-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B56\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C03\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58\\u0C59\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C81-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D01-\\u0D03\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D57\\u0D60-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D82\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB9\\u0EBB-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1877\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19D9\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1CD0-\\u1CD2\\u1CD4-\\u1CF6\\u1CF8\\u1CF9\\u1D00-\\u1DF5\\u1DFC-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u2E2F\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099\\u309A\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA69D\\uA69F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA827\\uA840-\\uA873\\uA880-\\uA8C4\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA900-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2D\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]");function assert(condition,message){if(!condition){throw new Error("ASSERT: "+message)}}function isDecimalDigit(ch){return ch>=48&&ch<=57}function isHexDigit(ch){return"0123456789abcdefABCDEF".indexOf(ch)>=0}function isOctalDigit(ch){return"01234567".indexOf(ch)>=0}function isWhiteSpace(ch){return ch===32||ch===9||ch===11||ch===12||ch===160||ch>=5760&&[5760,6158,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8239,8287,12288,65279].indexOf(ch)>=0}function isLineTerminator(ch){return ch===10||ch===13||ch===8232||ch===8233}function isIdentifierStart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch===92||ch>=128&&RegexNonAsciiIdentifierStart.test(String.fromCharCode(ch))}function isIdentifierPart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch>=48&&ch<=57||ch===92||ch>=128&&RegexNonAsciiIdentifierPart.test(String.fromCharCode(ch))}const keywords={if:1,in:1,do:1,var:1,for:1,new:1,try:1,let:1,this:1,else:1,case:1,void:1,with:1,enum:1,while:1,break:1,catch:1,throw:1,const:1,yield:1,class:1,super:1,return:1,typeof:1,delete:1,switch:1,export:1,import:1,public:1,static:1,default:1,finally:1,extends:1,package:1,private:1,function:1,continue:1,debugger:1,interface:1,protected:1,instanceof:1,implements:1};function skipComment(){while(index<length){const ch=source.charCodeAt(index);if(isWhiteSpace(ch)||isLineTerminator(ch)){++index}else{break}}}function scanHexEscape(prefix){var i,len,ch,code=0;len=prefix==="u"?4:2;for(i=0;i<len;++i){if(index<length&&isHexDigit(source[index])){ch=source[index++];code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}else{throwError({},MessageUnexpectedToken,ILLEGAL)}}return String.fromCharCode(code)}function scanUnicodeCodePointEscape(){var ch,code,cu1,cu2;ch=source[index];code=0;if(ch==="}"){throwError({},MessageUnexpectedToken,ILLEGAL)}while(index<length){ch=source[index++];if(!isHexDigit(ch)){break}code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}if(code>1114111||ch!=="}"){throwError({},MessageUnexpectedToken,ILLEGAL)}if(code<=65535){return String.fromCharCode(code)}cu1=(code-65536>>10)+55296;cu2=(code-65536&1023)+56320;return String.fromCharCode(cu1,cu2)}function getEscapedIdentifier(){var ch,id;ch=source.charCodeAt(index++);id=String.fromCharCode(ch);if(ch===92){if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierStart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}id=ch}while(index<length){ch=source.charCodeAt(index);if(!isIdentifierPart(ch)){break}++index;id+=String.fromCharCode(ch);if(ch===92){id=id.substr(0,id.length-1);if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierPart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}id+=ch}}return id}function getIdentifier(){var start,ch;start=index++;while(index<length){ch=source.charCodeAt(index);if(ch===92){index=start;return getEscapedIdentifier()}if(isIdentifierPart(ch)){++index}else{break}}return source.slice(start,index)}function scanIdentifier(){var start,id,type;start=index;id=source.charCodeAt(index)===92?getEscapedIdentifier():getIdentifier();if(id.length===1){type=TokenIdentifier}else if(keywords.hasOwnProperty(id)){type=TokenKeyword}else if(id==="null"){type=TokenNullLiteral}else if(id==="true"||id==="false"){type=TokenBooleanLiteral}else{type=TokenIdentifier}return{type:type,value:id,start:start,end:index}}function scanPunctuator(){var start=index,code=source.charCodeAt(index),code2,ch1=source[index],ch2,ch3,ch4;switch(code){case 46:case 40:case 41:case 59:case 44:case 123:case 125:case 91:case 93:case 58:case 63:case 126:++index;return{type:TokenPunctuator,value:String.fromCharCode(code),start:start,end:index};default:code2=source.charCodeAt(index+1);if(code2===61){switch(code){case 43:case 45:case 47:case 60:case 62:case 94:case 124:case 37:case 38:case 42:index+=2;return{type:TokenPunctuator,value:String.fromCharCode(code)+String.fromCharCode(code2),start:start,end:index};case 33:case 61:index+=2;if(source.charCodeAt(index)===61){++index}return{type:TokenPunctuator,value:source.slice(start,index),start:start,end:index}}}}ch4=source.substr(index,4);if(ch4===">>>="){index+=4;return{type:TokenPunctuator,value:ch4,start:start,end:index}}ch3=ch4.substr(0,3);if(ch3===">>>"||ch3==="<<="||ch3===">>="){index+=3;return{type:TokenPunctuator,value:ch3,start:start,end:index}}ch2=ch3.substr(0,2);if(ch1===ch2[1]&&"+-<>&|".indexOf(ch1)>=0||ch2==="=>"){index+=2;return{type:TokenPunctuator,value:ch2,start:start,end:index}}if(ch2==="//"){throwError({},MessageUnexpectedToken,ILLEGAL)}if("<>=!+-*%&|^/".indexOf(ch1)>=0){++index;return{type:TokenPunctuator,value:ch1,start:start,end:index}}throwError({},MessageUnexpectedToken,ILLEGAL)}function scanHexLiteral(start){let number="";while(index<length){if(!isHexDigit(source[index])){break}number+=source[index++]}if(number.length===0){throwError({},MessageUnexpectedToken,ILLEGAL)}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseInt("0x"+number,16),start:start,end:index}}function scanOctalLiteral(start){let number="0"+source[index++];while(index<length){if(!isOctalDigit(source[index])){break}number+=source[index++]}if(isIdentifierStart(source.charCodeAt(index))||isDecimalDigit(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseInt(number,8),octal:true,start:start,end:index}}function scanNumericLiteral(){var number,start,ch;ch=source[index];assert(isDecimalDigit(ch.charCodeAt(0))||ch===".","Numeric literal must start with a decimal digit or a decimal point");start=index;number="";if(ch!=="."){number=source[index++];ch=source[index];if(number==="0"){if(ch==="x"||ch==="X"){++index;return scanHexLiteral(start)}if(isOctalDigit(ch)){return scanOctalLiteral(start)}if(ch&&isDecimalDigit(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}}while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="."){number+=source[index++];while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="e"||ch==="E"){number+=source[index++];ch=source[index];if(ch==="+"||ch==="-"){number+=source[index++]}if(isDecimalDigit(source.charCodeAt(index))){while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}}else{throwError({},MessageUnexpectedToken,ILLEGAL)}}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseFloat(number),start:start,end:index}}function scanStringLiteral(){var str="",quote,start,ch,code,octal=false;quote=source[index];assert(quote==="'"||quote==='"',"String literal must starts with a quote");start=index;++index;while(index<length){ch=source[index++];if(ch===quote){quote="";break}else if(ch==="\\"){ch=source[index++];if(!ch||!isLineTerminator(ch.charCodeAt(0))){switch(ch){case"u":case"x":if(source[index]==="{"){++index;str+=scanUnicodeCodePointEscape()}else{str+=scanHexEscape(ch)}break;case"n":str+="\n";break;case"r":str+="\r";break;case"t":str+="\t";break;case"b":str+="\b";break;case"f":str+="\f";break;case"v":str+="\v";break;default:if(isOctalDigit(ch)){code="01234567".indexOf(ch);if(code!==0){octal=true}if(index<length&&isOctalDigit(source[index])){octal=true;code=code*8+"01234567".indexOf(source[index++]);if("0123".indexOf(ch)>=0&&index<length&&isOctalDigit(source[index])){code=code*8+"01234567".indexOf(source[index++])}}str+=String.fromCharCode(code)}else{str+=ch}break}}else{if(ch==="\r"&&source[index]==="\n"){++index}}}else if(isLineTerminator(ch.charCodeAt(0))){break}else{str+=ch}}if(quote!==""){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenStringLiteral,value:str,octal:octal,start:start,end:index}}function testRegExp(pattern,flags){let tmp=pattern;if(flags.indexOf("u")>=0){tmp=tmp.replace(/\\u\{([0-9a-fA-F]+)\}/g,($0,$1)=>{if(parseInt($1,16)<=1114111){return"x"}throwError({},MessageInvalidRegExp)}).replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,"x")}try{new RegExp(tmp)}catch(e){throwError({},MessageInvalidRegExp)}try{return new RegExp(pattern,flags)}catch(exception){return null}}function scanRegExpBody(){var ch,str,classMarker,terminated,body;ch=source[index];assert(ch==="/","Regular expression literal must start with a slash");str=source[index++];classMarker=false;terminated=false;while(index<length){ch=source[index++];str+=ch;if(ch==="\\"){ch=source[index++];if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}str+=ch}else if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}else if(classMarker){if(ch==="]"){classMarker=false}}else{if(ch==="/"){terminated=true;break}else if(ch==="["){classMarker=true}}}if(!terminated){throwError({},MessageUnterminatedRegExp)}body=str.substr(1,str.length-2);return{value:body,literal:str}}function scanRegExpFlags(){var ch,str,flags;str="";flags="";while(index<length){ch=source[index];if(!isIdentifierPart(ch.charCodeAt(0))){break}++index;if(ch==="\\"&&index<length){throwError({},MessageUnexpectedToken,ILLEGAL)}else{flags+=ch;str+=ch}}if(flags.search(/[^gimuy]/g)>=0){throwError({},MessageInvalidRegExp,flags)}return{value:flags,literal:str}}function scanRegExp(){var start,body,flags,value;lookahead=null;skipComment();start=index;body=scanRegExpBody();flags=scanRegExpFlags();value=testRegExp(body.value,flags.value);return{literal:body.literal+flags.literal,value:value,regex:{pattern:body.value,flags:flags.value},start:start,end:index}}function isIdentifierName(token){return token.type===TokenIdentifier||token.type===TokenKeyword||token.type===TokenBooleanLiteral||token.type===TokenNullLiteral}function advance(){skipComment();if(index>=length){return{type:TokenEOF,start:index,end:index}}const ch=source.charCodeAt(index);if(isIdentifierStart(ch)){return scanIdentifier()}if(ch===40||ch===41||ch===59){return scanPunctuator()}if(ch===39||ch===34){return scanStringLiteral()}if(ch===46){if(isDecimalDigit(source.charCodeAt(index+1))){return scanNumericLiteral()}return scanPunctuator()}if(isDecimalDigit(ch)){return scanNumericLiteral()}return scanPunctuator()}function lex(){const token=lookahead;index=token.end;lookahead=advance();index=token.end;return token}function peek(){const pos=index;lookahead=advance();index=pos}function finishArrayExpression(elements){const node=new ASTNode(SyntaxArrayExpression);node.elements=elements;return node}function finishBinaryExpression(operator,left,right){const node=new ASTNode(operator==="||"||operator==="&&"?SyntaxLogicalExpression:SyntaxBinaryExpression);node.operator=operator;node.left=left;node.right=right;return node}function finishCallExpression(callee,args){const node=new ASTNode(SyntaxCallExpression);node.callee=callee;node.arguments=args;return node}function finishConditionalExpression(test,consequent,alternate){const node=new ASTNode(SyntaxConditionalExpression);node.test=test;node.consequent=consequent;node.alternate=alternate;return node}function finishIdentifier(name){const node=new ASTNode(SyntaxIdentifier);node.name=name;return node}function finishLiteral(token){const node=new ASTNode(SyntaxLiteral);node.value=token.value;node.raw=source.slice(token.start,token.end);if(token.regex){if(node.raw==="//"){node.raw="/(?:)/"}node.regex=token.regex}return node}function finishMemberExpression(accessor,object,property){const node=new ASTNode(SyntaxMemberExpression);node.computed=accessor==="[";node.object=object;node.property=property;if(!node.computed)property.member=true;return node}function finishObjectExpression(properties){const node=new ASTNode(SyntaxObjectExpression);node.properties=properties;return node}function finishProperty(kind,key,value){const node=new ASTNode(SyntaxProperty);node.key=key;node.value=value;node.kind=kind;return node}function finishUnaryExpression(operator,argument){const node=new ASTNode(SyntaxUnaryExpression);node.operator=operator;node.argument=argument;node.prefix=true;return node}function throwError(token,messageFormat){var error,args=Array.prototype.slice.call(arguments,2),msg=messageFormat.replace(/%(\d)/g,(whole,index)=>{assert(index<args.length,"Message reference must be in range");return args[index]});error=new Error(msg);error.index=index;error.description=msg;throw error}function throwUnexpected(token){if(token.type===TokenEOF){throwError(token,MessageUnexpectedEOS)}if(token.type===TokenNumericLiteral){throwError(token,MessageUnexpectedNumber)}if(token.type===TokenStringLiteral){throwError(token,MessageUnexpectedString)}if(token.type===TokenIdentifier){throwError(token,MessageUnexpectedIdentifier)}if(token.type===TokenKeyword){throwError(token,MessageUnexpectedReserved)}throwError(token,MessageUnexpectedToken,token.value)}function expect(value){const token=lex();if(token.type!==TokenPunctuator||token.value!==value){throwUnexpected(token)}}function match(value){return lookahead.type===TokenPunctuator&&lookahead.value===value}function matchKeyword(keyword){return lookahead.type===TokenKeyword&&lookahead.value===keyword}function parseArrayInitialiser(){const elements=[];index=lookahead.start;expect("[");while(!match("]")){if(match(",")){lex();elements.push(null)}else{elements.push(parseConditionalExpression());if(!match("]")){expect(",")}}}lex();return finishArrayExpression(elements)}function parseObjectPropertyKey(){index=lookahead.start;const token=lex();if(token.type===TokenStringLiteral||token.type===TokenNumericLiteral){if(token.octal){throwError(token,MessageStrictOctalLiteral)}return finishLiteral(token)}return finishIdentifier(token.value)}function parseObjectProperty(){var token,key,id,value;index=lookahead.start;token=lookahead;if(token.type===TokenIdentifier){id=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",id,value)}if(token.type===TokenEOF||token.type===TokenPunctuator){throwUnexpected(token)}else{key=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",key,value)}}function parseObjectInitialiser(){var properties=[],property,name,key,map={},toString=String;index=lookahead.start;expect("{");while(!match("}")){property=parseObjectProperty();if(property.key.type===SyntaxIdentifier){name=property.key.name}else{name=toString(property.key.value)}key="$"+name;if(Object.prototype.hasOwnProperty.call(map,key)){throwError({},MessageStrictDuplicateProperty)}else{map[key]=true}properties.push(property);if(!match("}")){expect(",")}}expect("}");return finishObjectExpression(properties)}function parseGroupExpression(){expect("(");const expr=parseExpression();expect(")");return expr}const legalKeywords={if:1};function parsePrimaryExpression(){var type,token,expr;if(match("(")){return parseGroupExpression()}if(match("[")){return parseArrayInitialiser()}if(match("{")){return parseObjectInitialiser()}type=lookahead.type;index=lookahead.start;if(type===TokenIdentifier||legalKeywords[lookahead.value]){expr=finishIdentifier(lex().value)}else if(type===TokenStringLiteral||type===TokenNumericLiteral){if(lookahead.octal){throwError(lookahead,MessageStrictOctalLiteral)}expr=finishLiteral(lex())}else if(type===TokenKeyword){throw new Error(DISABLED)}else if(type===TokenBooleanLiteral){token=lex();token.value=token.value==="true";expr=finishLiteral(token)}else if(type===TokenNullLiteral){token=lex();token.value=null;expr=finishLiteral(token)}else if(match("/")||match("/=")){expr=finishLiteral(scanRegExp());peek()}else{throwUnexpected(lex())}return expr}function parseArguments(){const args=[];expect("(");if(!match(")")){while(index<length){args.push(parseConditionalExpression());if(match(")")){break}expect(",")}}expect(")");return args}function parseNonComputedProperty(){index=lookahead.start;const token=lex();if(!isIdentifierName(token)){throwUnexpected(token)}return finishIdentifier(token.value)}function parseNonComputedMember(){expect(".");return parseNonComputedProperty()}function parseComputedMember(){expect("[");const expr=parseExpression();expect("]");return expr}function parseLeftHandSideExpressionAllowCall(){var expr,args,property;expr=parsePrimaryExpression();for(;;){if(match(".")){property=parseNonComputedMember();expr=finishMemberExpression(".",expr,property)}else if(match("(")){args=parseArguments();expr=finishCallExpression(expr,args)}else if(match("[")){property=parseComputedMember();expr=finishMemberExpression("[",expr,property)}else{break}}return expr}function parsePostfixExpression(){const expr=parseLeftHandSideExpressionAllowCall();if(lookahead.type===TokenPunctuator){if(match("++")||match("--")){throw new Error(DISABLED)}}return expr}function parseUnaryExpression(){var token,expr;if(lookahead.type!==TokenPunctuator&&lookahead.type!==TokenKeyword){expr=parsePostfixExpression()}else if(match("++")||match("--")){throw new Error(DISABLED)}else if(match("+")||match("-")||match("~")||match("!")){token=lex();expr=parseUnaryExpression();expr=finishUnaryExpression(token.value,expr)}else if(matchKeyword("delete")||matchKeyword("void")||matchKeyword("typeof")){throw new Error(DISABLED)}else{expr=parsePostfixExpression()}return expr}function binaryPrecedence(token){let prec=0;if(token.type!==TokenPunctuator&&token.type!==TokenKeyword){return 0}switch(token.value){case"||":prec=1;break;case"&&":prec=2;break;case"|":prec=3;break;case"^":prec=4;break;case"&":prec=5;break;case"==":case"!=":case"===":case"!==":prec=6;break;case"<":case">":case"<=":case">=":case"instanceof":case"in":prec=7;break;case"<<":case">>":case">>>":prec=8;break;case"+":case"-":prec=9;break;case"*":case"/":case"%":prec=11;break}return prec}function parseBinaryExpression(){var marker,markers,expr,token,prec,stack,right,operator,left,i;marker=lookahead;left=parseUnaryExpression();token=lookahead;prec=binaryPrecedence(token);if(prec===0){return left}token.prec=prec;lex();markers=[marker,lookahead];right=parseUnaryExpression();stack=[left,token,right];while((prec=binaryPrecedence(lookahead))>0){while(stack.length>2&&prec<=stack[stack.length-2].prec){right=stack.pop();operator=stack.pop().value;left=stack.pop();markers.pop();expr=finishBinaryExpression(operator,left,right);stack.push(expr)}token=lex();token.prec=prec;stack.push(token);markers.push(lookahead);expr=parseUnaryExpression();stack.push(expr)}i=stack.length-1;expr=stack[i];markers.pop();while(i>1){markers.pop();expr=finishBinaryExpression(stack[i-1].value,stack[i-2],expr);i-=2}return expr}function parseConditionalExpression(){var expr,consequent,alternate;expr=parseBinaryExpression();if(match("?")){lex();consequent=parseConditionalExpression();expect(":");alternate=parseConditionalExpression();expr=finishConditionalExpression(expr,consequent,alternate)}return expr}function parseExpression(){const expr=parseConditionalExpression();if(match(",")){throw new Error(DISABLED)}return expr}function parser(code){source=code;index=0;length=source.length;lookahead=null;peek();const expr=parseExpression();if(lookahead.type!==TokenEOF){throw new Error("Unexpect token after expression.")}return expr}var Constants={NaN:"NaN",E:"Math.E",LN2:"Math.LN2",LN10:"Math.LN10",LOG2E:"Math.LOG2E",LOG10E:"Math.LOG10E",PI:"Math.PI",SQRT1_2:"Math.SQRT1_2",SQRT2:"Math.SQRT2",MIN_VALUE:"Number.MIN_VALUE",MAX_VALUE:"Number.MAX_VALUE"};function Functions(codegen){function fncall(name,args,cast,type){let obj=codegen(args[0]);if(cast){obj=cast+"("+obj+")";if(cast.lastIndexOf("new ",0)===0)obj="("+obj+")"}return obj+"."+name+(type<0?"":type===0?"()":"("+args.slice(1).map(codegen).join(",")+")")}function fn(name,cast,type){return args=>fncall(name,args,cast,type)}const DATE="new Date",STRING="String",REGEXP="RegExp";return{isNaN:"Number.isNaN",isFinite:"Number.isFinite",abs:"Math.abs",acos:"Math.acos",asin:"Math.asin",atan:"Math.atan",atan2:"Math.atan2",ceil:"Math.ceil",cos:"Math.cos",exp:"Math.exp",floor:"Math.floor",log:"Math.log",max:"Math.max",min:"Math.min",pow:"Math.pow",random:"Math.random",round:"Math.round",sin:"Math.sin",sqrt:"Math.sqrt",tan:"Math.tan",clamp:function(args){if(args.length<3)vegaUtil.error("Missing arguments to clamp function.");if(args.length>3)vegaUtil.error("Too many arguments to clamp function.");const a=args.map(codegen);return"Math.max("+a[1]+", Math.min("+a[2]+","+a[0]+"))"},now:"Date.now",utc:"Date.UTC",datetime:DATE,date:fn("getDate",DATE,0),day:fn("getDay",DATE,0),year:fn("getFullYear",DATE,0),month:fn("getMonth",DATE,0),hours:fn("getHours",DATE,0),minutes:fn("getMinutes",DATE,0),seconds:fn("getSeconds",DATE,0),milliseconds:fn("getMilliseconds",DATE,0),time:fn("getTime",DATE,0),timezoneoffset:fn("getTimezoneOffset",DATE,0),utcdate:fn("getUTCDate",DATE,0),utcday:fn("getUTCDay",DATE,0),utcyear:fn("getUTCFullYear",DATE,0),utcmonth:fn("getUTCMonth",DATE,0),utchours:fn("getUTCHours",DATE,0),utcminutes:fn("getUTCMinutes",DATE,0),utcseconds:fn("getUTCSeconds",DATE,0),utcmilliseconds:fn("getUTCMilliseconds",DATE,0),length:fn("length",null,-1),parseFloat:"parseFloat",parseInt:"parseInt",upper:fn("toUpperCase",STRING,0),lower:fn("toLowerCase",STRING,0),substring:fn("substring",STRING),split:fn("split",STRING),trim:fn("trim",STRING,0),regexp:REGEXP,test:fn("test",REGEXP),if:function(args){if(args.length<3)vegaUtil.error("Missing arguments to if function.");if(args.length>3)vegaUtil.error("Too many arguments to if function.");const a=args.map(codegen);return"("+a[0]+"?"+a[1]+":"+a[2]+")"}}}function stripQuotes(s){const n=s&&s.length-1;return n&&(s[0]==='"'&&s[n]==='"'||s[0]==="'"&&s[n]==="'")?s.slice(1,-1):s}function codegen(opt){opt=opt||{};const allowed=opt.allowed?vegaUtil.toSet(opt.allowed):{},forbidden=opt.forbidden?vegaUtil.toSet(opt.forbidden):{},constants=opt.constants||Constants,functions=(opt.functions||Functions)(visit),globalvar=opt.globalvar,fieldvar=opt.fieldvar,outputGlobal=vegaUtil.isFunction(globalvar)?globalvar:id=>`${globalvar}["${id}"]`;let globals={},fields={},memberDepth=0;function visit(ast){if(vegaUtil.isString(ast))return ast;const generator=Generators[ast.type];if(generator==null)vegaUtil.error("Unsupported type: "+ast.type);return generator(ast)}const Generators={Literal:n=>n.raw,Identifier:n=>{const id=n.name;if(memberDepth>0){return id}else if(vegaUtil.hasOwnProperty(forbidden,id)){return vegaUtil.error("Illegal identifier: "+id)}else if(vegaUtil.hasOwnProperty(constants,id)){return constants[id]}else if(vegaUtil.hasOwnProperty(allowed,id)){return id}else{globals[id]=1;return outputGlobal(id)}},MemberExpression:n=>{const d=!n.computed,o=visit(n.object);if(d)memberDepth+=1;const p=visit(n.property);if(o===fieldvar){fields[stripQuotes(p)]=1}if(d)memberDepth-=1;return o+(d?"."+p:"["+p+"]")},CallExpression:n=>{if(n.callee.type!=="Identifier"){vegaUtil.error("Illegal callee type: "+n.callee.type)}const callee=n.callee.name,args=n.arguments,fn=vegaUtil.hasOwnProperty(functions,callee)&&functions[callee];if(!fn)vegaUtil.error("Unrecognized function: "+callee);return vegaUtil.isFunction(fn)?fn(args):fn+"("+args.map(visit).join(",")+")"},ArrayExpression:n=>"["+n.elements.map(visit).join(",")+"]",BinaryExpression:n=>"("+visit(n.left)+" "+n.operator+" "+visit(n.right)+")",UnaryExpression:n=>"("+n.operator+visit(n.argument)+")",ConditionalExpression:n=>"("+visit(n.test)+"?"+visit(n.consequent)+":"+visit(n.alternate)+")",LogicalExpression:n=>"("+visit(n.left)+n.operator+visit(n.right)+")",ObjectExpression:n=>"{"+n.properties.map(visit).join(",")+"}",Property:n=>{memberDepth+=1;const k=visit(n.key);memberDepth-=1;return k+":"+visit(n.value)}};function codegen(ast){const result={code:visit(ast),globals:Object.keys(globals),fields:Object.keys(fields)};globals={};fields={};return result}codegen.functions=functions;codegen.constants=constants;return codegen}exports.ASTNode=ASTNode;exports.ArrayExpression=ArrayExpression;exports.BinaryExpression=BinaryExpression;exports.CallExpression=CallExpression;exports.ConditionalExpression=ConditionalExpression;exports.Identifier=Identifier;exports.Literal=Literal;exports.LogicalExpression=LogicalExpression;exports.MemberExpression=MemberExpression;exports.ObjectExpression=ObjectExpression;exports.Property=Property;exports.RawCode=RawCode;exports.UnaryExpression=UnaryExpression;exports.codegen=codegen;exports.constants=Constants;exports.functions=Functions;exports.parse=parser;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(39)):undefined})(this,(function(exports,vegaUtil,vegaDataflow){"use strict";function parse(spec){const ctx=this,operators=spec.operators||[];if(spec.background){ctx.background=spec.background}if(spec.eventConfig){ctx.eventConfig=spec.eventConfig}if(spec.locale){ctx.locale=spec.locale}operators.forEach(entry=>ctx.parseOperator(entry));operators.forEach(entry=>ctx.parseOperatorParameters(entry));(spec.streams||[]).forEach(entry=>ctx.parseStream(entry));(spec.updates||[]).forEach(entry=>ctx.parseUpdate(entry));return ctx.resolve()}const Skip=vegaUtil.toSet(["rule"]),Swap=vegaUtil.toSet(["group","image","rect"]);function adjustSpatial(encode,marktype){let code="";if(Skip[marktype])return code;if(encode.x2){if(encode.x){if(Swap[marktype]){code+="if(o.x>o.x2)$=o.x,o.x=o.x2,o.x2=$;"}code+="o.width=o.x2-o.x;"}else{code+="o.x=o.x2-(o.width||0);"}}if(encode.xc){code+="o.x=o.xc-(o.width||0)/2;"}if(encode.y2){if(encode.y){if(Swap[marktype]){code+="if(o.y>o.y2)$=o.y,o.y=o.y2,o.y2=$;"}code+="o.height=o.y2-o.y;"}else{code+="o.y=o.y2-(o.height||0);"}}if(encode.yc){code+="o.y=o.yc-(o.height||0)/2;"}return code}function canonicalType(type){return(type+"").toLowerCase()}function isOperator(type){return canonicalType(type)==="operator"}function isCollect(type){return canonicalType(type)==="collect"}function expression(ctx,args,code){if(code[code.length-1]!==";"){code="return("+code+");"}const fn=Function(...args.concat(code));return ctx&&ctx.functions?fn.bind(ctx.functions):fn}function _compare(u,v,lt,gt){return`((u = ${u}) < (v = ${v}) || u == null) && v != null ? ${lt}\n  : (u > v || v == null) && u != null ? ${gt}\n  : ((v = v instanceof Date ? +v : v), (u = u instanceof Date ? +u : u)) !== u && v === v ? ${lt}\n  : v !== v && u === u ? ${gt} : `}var expressionCodegen={operator:(ctx,expr)=>expression(ctx,["_"],expr.code),parameter:(ctx,expr)=>expression(ctx,["datum","_"],expr.code),event:(ctx,expr)=>expression(ctx,["event"],expr.code),handler:(ctx,expr)=>{const code=`var datum=event.item&&event.item.datum;return ${expr.code};`;return expression(ctx,["_","event"],code)},encode:(ctx,encode)=>{const{marktype:marktype,channels:channels}=encode;let code="var o=item,datum=o.datum,m=0,$;";for(const name in channels){const o="o["+vegaUtil.stringValue(name)+"]";code+=`$=${channels[name].code};if(${o}!==$)${o}=$,m=1;`}code+=adjustSpatial(channels,marktype);code+="return m;";return expression(ctx,["item","_"],code)},codegen:{get(path){const ref=`[${path.map(vegaUtil.stringValue).join("][")}]`;const get=Function("_",`return _${ref};`);get.path=ref;return get},comparator(fields,orders){let t;const map=(f,i)=>{const o=orders[i];let u,v;if(f.path){u=`a${f.path}`;v=`b${f.path}`}else{(t=t||{})["f"+i]=f;u=`this.f${i}(a)`;v=`this.f${i}(b)`}return _compare(u,v,-o,o)};const fn=Function("a","b","var u, v; return "+fields.map(map).join("")+"0;");return t?fn.bind(t):fn}}};function parseOperator(spec){const ctx=this;if(isOperator(spec.type)||!spec.type){ctx.operator(spec,spec.update?ctx.operatorExpression(spec.update):null)}else{ctx.transform(spec,spec.type)}}function parseOperatorParameters(spec){const ctx=this;if(spec.params){const op=ctx.get(spec.id);if(!op)vegaUtil.error("Invalid operator id: "+spec.id);ctx.dataflow.connect(op,op.parameters(ctx.parseParameters(spec.params),spec.react,spec.initonly))}}function parseParameters(spec,params){params=params||{};const ctx=this;for(const key in spec){const value=spec[key];params[key]=vegaUtil.isArray(value)?value.map(v=>parseParameter(v,ctx,params)):parseParameter(value,ctx,params)}return params}function parseParameter(spec,ctx,params){if(!spec||!vegaUtil.isObject(spec))return spec;for(let i=0,n=PARSERS.length,p;i<n;++i){p=PARSERS[i];if(vegaUtil.hasOwnProperty(spec,p.key)){return p.parse(spec,ctx,params)}}return spec}var PARSERS=[{key:"$ref",parse:getOperator},{key:"$key",parse:getKey},{key:"$expr",parse:getExpression},{key:"$field",parse:getField},{key:"$encode",parse:getEncode},{key:"$compare",parse:getCompare},{key:"$context",parse:getContext},{key:"$subflow",parse:getSubflow},{key:"$tupleid",parse:getTupleId}];function getOperator(_,ctx){return ctx.get(_.$ref)||vegaUtil.error("Operator not defined: "+_.$ref)}function getExpression(_,ctx,params){if(_.$params){ctx.parseParameters(_.$params,params)}const k="e:"+_.$expr.code+"_"+_.$name;return ctx.fn[k]||(ctx.fn[k]=vegaUtil.accessor(ctx.parameterExpression(_.$expr),_.$fields,_.$name))}function getKey(_,ctx){const k="k:"+_.$key+"_"+!!_.$flat;return ctx.fn[k]||(ctx.fn[k]=vegaUtil.key(_.$key,_.$flat,ctx.expr.codegen))}function getField(_,ctx){if(!_.$field)return null;const k="f:"+_.$field+"_"+_.$name;return ctx.fn[k]||(ctx.fn[k]=vegaUtil.field(_.$field,_.$name,ctx.expr.codegen))}function getCompare(_,ctx){const k="c:"+_.$compare+"_"+_.$order,c=vegaUtil.array(_.$compare).map(_=>_&&_.$tupleid?vegaDataflow.tupleid:_);return ctx.fn[k]||(ctx.fn[k]=vegaUtil.compare(c,_.$order,ctx.expr.codegen))}function getEncode(_,ctx){const spec=_.$encode,encode={};for(const name in spec){const enc=spec[name];encode[name]=vegaUtil.accessor(ctx.encodeExpression(enc.$expr),enc.$fields);encode[name].output=enc.$output}return encode}function getContext(_,ctx){return ctx}function getSubflow(_,ctx){const spec=_.$subflow;return function(dataflow,key,parent){const subctx=ctx.fork().parse(spec),op=subctx.get(spec.operators[0].id),p=subctx.signals.parent;if(p)p.set(parent);op.detachSubflow=()=>ctx.detach(subctx);return op}}function getTupleId(){return vegaDataflow.tupleid}function parseStream(spec){var ctx=this,filter=spec.filter!=null?ctx.eventExpression(spec.filter):undefined,stream=spec.stream!=null?ctx.get(spec.stream):undefined,args;if(spec.source){stream=ctx.events(spec.source,spec.type,filter)}else if(spec.merge){args=spec.merge.map(_=>ctx.get(_));stream=args[0].merge.apply(args[0],args.slice(1))}if(spec.between){args=spec.between.map(_=>ctx.get(_));stream=stream.between(args[0],args[1])}if(spec.filter){stream=stream.filter(filter)}if(spec.throttle!=null){stream=stream.throttle(+spec.throttle)}if(spec.debounce!=null){stream=stream.debounce(+spec.debounce)}if(stream==null){vegaUtil.error("Invalid stream definition: "+JSON.stringify(spec))}if(spec.consume)stream.consume(true);ctx.stream(spec,stream)}function parseUpdate(spec){var ctx=this,srcid=vegaUtil.isObject(srcid=spec.source)?srcid.$ref:srcid,source=ctx.get(srcid),target=null,update=spec.update,params=undefined;if(!source)vegaUtil.error("Source not defined: "+spec.source);target=spec.target&&spec.target.$expr?ctx.eventExpression(spec.target.$expr):ctx.get(spec.target);if(update&&update.$expr){if(update.$params){params=ctx.parseParameters(update.$params)}update=ctx.handlerExpression(update.$expr)}ctx.update(spec,source,target,update,params)}const SKIP={skip:true};function getState(options){var ctx=this,state={};if(options.signals){var signals=state.signals={};Object.keys(ctx.signals).forEach(key=>{const op=ctx.signals[key];if(options.signals(key,op)){signals[key]=op.value}})}if(options.data){var data=state.data={};Object.keys(ctx.data).forEach(key=>{const dataset=ctx.data[key];if(options.data(key,dataset)){data[key]=dataset.input.value}})}if(ctx.subcontext&&options.recurse!==false){state.subcontext=ctx.subcontext.map(ctx=>ctx.getState(options))}return state}function setState(state){var ctx=this,df=ctx.dataflow,data=state.data,signals=state.signals;Object.keys(signals||{}).forEach(key=>{df.update(ctx.signals[key],signals[key],SKIP)});Object.keys(data||{}).forEach(key=>{df.pulse(ctx.data[key].input,df.changeset().remove(vegaUtil.truthy).insert(data[key]))});(state.subcontext||[]).forEach((substate,i)=>{const subctx=ctx.subcontext[i];if(subctx)subctx.setState(substate)})}function context(df,transforms,functions,expr){return new Context(df,transforms,functions,expr)}function Context(df,transforms,functions,expr){this.dataflow=df;this.transforms=transforms;this.events=df.events.bind(df);this.expr=expr||expressionCodegen,this.signals={};this.scales={};this.nodes={};this.data={};this.fn={};if(functions){this.functions=Object.create(functions);this.functions.context=this}}function Subcontext(ctx){this.dataflow=ctx.dataflow;this.transforms=ctx.transforms;this.events=ctx.events;this.expr=ctx.expr;this.signals=Object.create(ctx.signals);this.scales=Object.create(ctx.scales);this.nodes=Object.create(ctx.nodes);this.data=Object.create(ctx.data);this.fn=Object.create(ctx.fn);if(ctx.functions){this.functions=Object.create(ctx.functions);this.functions.context=this}}Context.prototype=Subcontext.prototype={fork(){const ctx=new Subcontext(this);(this.subcontext||(this.subcontext=[])).push(ctx);return ctx},detach(ctx){this.subcontext=this.subcontext.filter(c=>c!==ctx);const keys=Object.keys(ctx.nodes);for(const key of keys)ctx.nodes[key]._targets=null;for(const key of keys)ctx.nodes[key].detach();ctx.nodes=null},get(id){return this.nodes[id]},set(id,node){return this.nodes[id]=node},add(spec,op){const ctx=this,df=ctx.dataflow,data=spec.value;ctx.set(spec.id,op);if(isCollect(spec.type)&&data){if(data.$ingest){df.ingest(op,data.$ingest,data.$format)}else if(data.$request){df.preload(op,data.$request,data.$format)}else{df.pulse(op,df.changeset().insert(data))}}if(spec.root){ctx.root=op}if(spec.parent){let p=ctx.get(spec.parent.$ref);if(p){df.connect(p,[op]);op.targets().add(p)}else{(ctx.unresolved=ctx.unresolved||[]).push(()=>{p=ctx.get(spec.parent.$ref);df.connect(p,[op]);op.targets().add(p)})}}if(spec.signal){ctx.signals[spec.signal]=op}if(spec.scale){ctx.scales[spec.scale]=op}if(spec.data){for(const name in spec.data){const data=ctx.data[name]||(ctx.data[name]={});spec.data[name].forEach(role=>data[role]=op)}}},resolve(){(this.unresolved||[]).forEach(fn=>fn());delete this.unresolved;return this},operator(spec,update){this.add(spec,this.dataflow.add(spec.value,update))},transform(spec,type){this.add(spec,this.dataflow.add(this.transforms[canonicalType(type)]))},stream(spec,stream){this.set(spec.id,stream)},update(spec,stream,target,update,params){this.dataflow.on(stream,target,update,params,spec.options)},operatorExpression(expr){return this.expr.operator(this,expr)},parameterExpression(expr){return this.expr.parameter(this,expr)},eventExpression(expr){return this.expr.event(this,expr)},handlerExpression(expr){return this.expr.handler(this,expr)},encodeExpression(encode){return this.expr.encode(this,encode)},parse:parse,parseOperator:parseOperator,parseOperatorParameters:parseOperatorParameters,parseParameters:parseParameters,parseStream:parseStream,parseUpdate:parseUpdate,getState:getState,setState:setState};exports.context=context;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(Buffer){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var version="4.17.0";function accessor(fn,fields,name){fn.fields=fields||[];fn.fname=name;return fn}function getter(path){return path.length===1?get1(path[0]):getN(path)}const get1=field=>function(obj){return obj[field]};const getN=path=>{const len=path.length;return function(obj){for(let i=0;i<len;++i){obj=obj[path[i]]}return obj}};function error(message){throw Error(message)}function splitAccessPath(p){const path=[],n=p.length;let q=null,b=0,s="",i,j,c;p=p+"";function push(){path.push(s+p.substring(i,j));s="";i=j+1}for(i=j=0;j<n;++j){c=p[j];if(c==="\\"){s+=p.substring(i,j);s+=p.substring(++j,++j);i=j}else if(c===q){push();q=null;b=-1}else if(q){continue}else if(i===b&&c==='"'){i=j+1;q=c}else if(i===b&&c==="'"){i=j+1;q=c}else if(c==="."&&!b){if(j>i){push()}else{i=j+1}}else if(c==="["){if(j>i)push();b=i=j+1}else if(c==="]"){if(!b)error("Access path missing open bracket: "+p);if(b>0)push();b=0;i=j+1}}if(b)error("Access path missing closing bracket: "+p);if(q)error("Access path missing closing quote: "+p);if(j>i){j++;push()}return path}function field(field,name,opt){const path=splitAccessPath(field);field=path.length===1?path[0]:field;return accessor((opt&&opt.get||getter)(path),[field],name||field)}const id=field("id");const identity=accessor(_=>_,[],"identity");const zero=accessor(()=>0,[],"zero");const one=accessor(()=>1,[],"one");const truthy=accessor(()=>true,[],"true");const falsy=accessor(()=>false,[],"false");function log(method,level,input){const args=[level].concat([].slice.call(input));console[method].apply(console,args)}const None=0;const Error$1=1;const Warn=2;const Info=3;const Debug=4;function logger(_,method){let level=_||None;return{level(_){if(arguments.length){level=+_;return this}else{return level}},error(){if(level>=Error$1)log(method||"error","ERROR",arguments);return this},warn(){if(level>=Warn)log(method||"warn","WARN",arguments);return this},info(){if(level>=Info)log(method||"log","INFO",arguments);return this},debug(){if(level>=Debug)log(method||"log","DEBUG",arguments);return this}}}var isArray=Array.isArray;function isObject(_){return _===Object(_)}const isLegalKey=key=>key!=="__proto__";function mergeConfig(...configs){return configs.reduce((out,source)=>{for(const key in source){if(key==="signals"){out.signals=mergeNamed(out.signals,source.signals)}else{const r=key==="legend"?{layout:1}:key==="style"?true:null;writeConfig(out,key,source[key],r)}}return out},{})}function writeConfig(output,key,value,recurse){if(!isLegalKey(key))return;let k,o;if(isObject(value)&&!isArray(value)){o=isObject(output[key])?output[key]:output[key]={};for(k in value){if(recurse&&(recurse===true||recurse[k])){writeConfig(o,k,value[k])}else if(isLegalKey(k)){o[k]=value[k]}}}else{output[key]=value}}function mergeNamed(a,b){if(a==null)return b;const map={},out=[];function add(_){if(!map[_.name]){map[_.name]=1;out.push(_)}}b.forEach(add);a.forEach(add);return out}function array(_){return _!=null?isArray(_)?_:[_]:[]}function isFunction(_){return typeof _==="function"}const hop=Object.prototype.hasOwnProperty;function has(object,property){return hop.call(object,property)}function isBoolean(_){return typeof _==="boolean"}function isNumber(_){return typeof _==="number"}function isString(_){return typeof _==="string"}function $(x){return isArray(x)?"["+x.map($)+"]":isObject(x)||isString(x)?JSON.stringify(x).replace("\u2028","\\u2028").replace("\u2029","\\u2029"):x}function toSet(_){const s={},n=_.length;for(let i=0;i<n;++i)s[_[i]]=true;return s}Array.prototype.flat||Object.defineProperty(Array.prototype,"flat",{configurable:!0,value:function r(){var t=isNaN(arguments[0])?1:Number(arguments[0]);return t?Array.prototype.reduce.call(this,(function(a,e){return Array.isArray(e)?a.push.apply(a,r.call(e,t-1)):a.push(e),a}),[]):Array.prototype.slice.call(this)},writable:!0}),Array.prototype.flatMap||Object.defineProperty(Array.prototype,"flatMap",{configurable:!0,value:function(r){return Array.prototype.map.apply(this,arguments).flat()},writable:!0});function createCommonjsModule(fn,basedir,module){return module={path:basedir,exports:{},require:function(path,base){return commonjsRequire(path,base===undefined||base===null?module.path:base)}},fn(module,module.exports),module.exports}function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}var clone_1=createCommonjsModule((function(module){var clone=function(){function _instanceof(obj,type){return type!=null&&obj instanceof type}var nativeMap;try{nativeMap=Map}catch(_){nativeMap=function(){}}var nativeSet;try{nativeSet=Set}catch(_){nativeSet=function(){}}var nativePromise;try{nativePromise=Promise}catch(_){nativePromise=function(){}}function clone(parent,circular,depth,prototype,includeNonEnumerable){if(typeof circular==="object"){depth=circular.depth;prototype=circular.prototype;includeNonEnumerable=circular.includeNonEnumerable;circular=circular.circular}var allParents=[];var allChildren=[];var useBuffer=typeof Buffer!="undefined";if(typeof circular=="undefined")circular=true;if(typeof depth=="undefined")depth=Infinity;function _clone(parent,depth){if(parent===null)return null;if(depth===0)return parent;var child;var proto;if(typeof parent!="object"){return parent}if(_instanceof(parent,nativeMap)){child=new nativeMap}else if(_instanceof(parent,nativeSet)){child=new nativeSet}else if(_instanceof(parent,nativePromise)){child=new nativePromise((function(resolve,reject){parent.then((function(value){resolve(_clone(value,depth-1))}),(function(err){reject(_clone(err,depth-1))}))}))}else if(clone.__isArray(parent)){child=[]}else if(clone.__isRegExp(parent)){child=new RegExp(parent.source,__getRegExpFlags(parent));if(parent.lastIndex)child.lastIndex=parent.lastIndex}else if(clone.__isDate(parent)){child=new Date(parent.getTime())}else if(useBuffer&&Buffer.isBuffer(parent)){if(Buffer.allocUnsafe){child=Buffer.allocUnsafe(parent.length)}else{child=new Buffer(parent.length)}parent.copy(child);return child}else if(_instanceof(parent,Error)){child=Object.create(parent)}else{if(typeof prototype=="undefined"){proto=Object.getPrototypeOf(parent);child=Object.create(proto)}else{child=Object.create(prototype);proto=prototype}}if(circular){var index=allParents.indexOf(parent);if(index!=-1){return allChildren[index]}allParents.push(parent);allChildren.push(child)}if(_instanceof(parent,nativeMap)){parent.forEach((function(value,key){var keyChild=_clone(key,depth-1);var valueChild=_clone(value,depth-1);child.set(keyChild,valueChild)}))}if(_instanceof(parent,nativeSet)){parent.forEach((function(value){var entryChild=_clone(value,depth-1);child.add(entryChild)}))}for(var i in parent){var attrs;if(proto){attrs=Object.getOwnPropertyDescriptor(proto,i)}if(attrs&&attrs.set==null){continue}child[i]=_clone(parent[i],depth-1)}if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(parent);for(var i=0;i<symbols.length;i++){var symbol=symbols[i];var descriptor=Object.getOwnPropertyDescriptor(parent,symbol);if(descriptor&&!descriptor.enumerable&&!includeNonEnumerable){continue}child[symbol]=_clone(parent[symbol],depth-1);if(!descriptor.enumerable){Object.defineProperty(child,symbol,{enumerable:false})}}}if(includeNonEnumerable){var allPropertyNames=Object.getOwnPropertyNames(parent);for(var i=0;i<allPropertyNames.length;i++){var propertyName=allPropertyNames[i];var descriptor=Object.getOwnPropertyDescriptor(parent,propertyName);if(descriptor&&descriptor.enumerable){continue}child[propertyName]=_clone(parent[propertyName],depth-1);Object.defineProperty(child,propertyName,{enumerable:false})}}return child}return _clone(parent,depth)}clone.clonePrototype=function clonePrototype(parent){if(parent===null)return null;var c=function(){};c.prototype=parent;return new c};function __objToStr(o){return Object.prototype.toString.call(o)}clone.__objToStr=__objToStr;function __isDate(o){return typeof o==="object"&&__objToStr(o)==="[object Date]"}clone.__isDate=__isDate;function __isArray(o){return typeof o==="object"&&__objToStr(o)==="[object Array]"}clone.__isArray=__isArray;function __isRegExp(o){return typeof o==="object"&&__objToStr(o)==="[object RegExp]"}clone.__isRegExp=__isRegExp;function __getRegExpFlags(re){var flags="";if(re.global)flags+="g";if(re.ignoreCase)flags+="i";if(re.multiline)flags+="m";return flags}clone.__getRegExpFlags=__getRegExpFlags;return clone}();if(module.exports){module.exports=clone}}));var fastDeepEqual=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b};var fastJsonStableStringify=function(data,opts){if(!opts)opts={};if(typeof opts==="function")opts={cmp:opts};var cycles=typeof opts.cycles==="boolean"?opts.cycles:false;var cmp=opts.cmp&&function(f){return function(node){return function(a,b){var aobj={key:a,value:node[a]};var bobj={key:b,value:node[b]};return f(aobj,bobj)}}}(opts.cmp);var seen=[];return function stringify(node){if(node&&node.toJSON&&typeof node.toJSON==="function"){node=node.toJSON()}if(node===undefined)return;if(typeof node=="number")return isFinite(node)?""+node:"null";if(typeof node!=="object")return JSON.stringify(node);var i,out;if(Array.isArray(node)){out="[";for(i=0;i<node.length;i++){if(i)out+=",";out+=stringify(node[i])||"null"}return out+"]"}if(node===null)return"null";if(seen.indexOf(node)!==-1){if(cycles)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}var seenIndex=seen.push(node)-1;var keys=Object.keys(node).sort(cmp&&cmp(node));out="";for(i=0;i<keys.length;i++){var key=keys[i];var value=stringify(node[key]);if(!value)continue;if(out)out+=",";out+=JSON.stringify(key)+":"+value}seen.splice(seenIndex,1);return"{"+out+"}"}(data)};function isLogicalOr(op){return!!op.or}function isLogicalAnd(op){return!!op.and}function isLogicalNot(op){return!!op.not}function forEachLeaf(op,fn){if(isLogicalNot(op)){forEachLeaf(op.not,fn)}else if(isLogicalAnd(op)){for(const subop of op.and){forEachLeaf(subop,fn)}}else if(isLogicalOr(op)){for(const subop of op.or){forEachLeaf(subop,fn)}}else{fn(op)}}function normalizeLogicalComposition(op,normalizer){if(isLogicalNot(op)){return{not:normalizeLogicalComposition(op.not,normalizer)}}else if(isLogicalAnd(op)){return{and:op.and.map(o=>normalizeLogicalComposition(o,normalizer))}}else if(isLogicalOr(op)){return{or:op.or.map(o=>normalizeLogicalComposition(o,normalizer))}}else{return normalizer(op)}}const deepEqual=fastDeepEqual;const duplicate=clone_1;function pick(obj,props){const copy={};for(const prop of props){if(has(obj,prop)){copy[prop]=obj[prop]}}return copy}function omit(obj,props){const copy={...obj};for(const prop of props){delete copy[prop]}return copy}Set.prototype["toJSON"]=function(){return"Set(".concat([...this].map(x=>fastJsonStableStringify(x)).join(","),")")};const stringify=fastJsonStableStringify;function hash(a){if(isNumber(a)){return a}const str=isString(a)?a:fastJsonStableStringify(a);if(str.length<250){return str}let h=0;for(let i=0;i<str.length;i++){const char=str.charCodeAt(i);h=(h<<5)-h+char;h=h&h}return h}function isNullOrFalse(x){return x===false||x===null}function contains(array,item){return array.indexOf(item)>-1}function some(arr,f){let i=0;for(const[k,a]of arr.entries()){if(f(a,k,i++)){return true}}return false}function every(arr,f){let i=0;for(const[k,a]of arr.entries()){if(!f(a,k,i++)){return false}}return true}function mergeDeep(dest,...src){for(const s of src){deepMerge_(dest,s!==null&&s!==void 0?s:{})}return dest}function deepMerge_(dest,src){for(const property of keys(src)){writeConfig(dest,property,src[property],true)}}function unique(values,f){const results=[];const u={};let v;for(const val of values){v=f(val);if(v in u){continue}u[v]=1;results.push(val)}return results}function isEqual(dict,other){const dictKeys=keys(dict);const otherKeys=keys(other);if(dictKeys.length!==otherKeys.length){return false}for(const key of dictKeys){if(dict[key]!==other[key]){return false}}return true}function setEqual(a,b){if(a.size!==b.size){return false}for(const e of a){if(!b.has(e)){return false}}return true}function hasIntersection(a,b){for(const key of a){if(b.has(key)){return true}}return false}function prefixGenerator(a){const prefixes=new Set;for(const x of a){const splitField=splitAccessPath(x);const wrappedWithAccessors=splitField.map((y,i)=>i===0?y:"[".concat(y,"]"));const computedPrefixes=wrappedWithAccessors.map((_,i)=>wrappedWithAccessors.slice(0,i+1).join(""));for(const y of computedPrefixes){prefixes.add(y)}}return prefixes}function fieldIntersection(a,b){if(a===undefined||b===undefined){return true}return hasIntersection(prefixGenerator(a),prefixGenerator(b))}function isEmpty(obj){return keys(obj).length===0}const keys=Object.keys;const vals=Object.values;const entries=Object.entries;function isBoolean$1(b){return b===true||b===false}function varName(s){const alphanumericS=s.replace(/\W/g,"_");return(s.match(/^\d+/)?"_":"")+alphanumericS}function logicalExpr(op,cb){if(isLogicalNot(op)){return"!("+logicalExpr(op.not,cb)+")"}else if(isLogicalAnd(op)){return"("+op.and.map(and=>logicalExpr(and,cb)).join(") && (")+")"}else if(isLogicalOr(op)){return"("+op.or.map(or=>logicalExpr(or,cb)).join(") || (")+")"}else{return cb(op)}}function deleteNestedProperty(obj,orderedProps){if(orderedProps.length===0){return true}const prop=orderedProps.shift();if(prop in obj&&deleteNestedProperty(obj[prop],orderedProps)){delete obj[prop]}return isEmpty(obj)}function titleCase(s){return s.charAt(0).toUpperCase()+s.substr(1)}function accessPathWithDatum(path,datum="datum"){const pieces=splitAccessPath(path);const prefixes=[];for(let i=1;i<=pieces.length;i++){const prefix="[".concat(pieces.slice(0,i).map($).join("]["),"]");prefixes.push("".concat(datum).concat(prefix))}return prefixes.join(" && ")}function flatAccessWithDatum(path,datum="datum"){return"".concat(datum,"[").concat($(splitAccessPath(path).join(".")),"]")}function escapePathAccess(string){return string.replace(/(\[|\]|\.|'|")/g,"\\$1")}function replacePathInField(path){return"".concat(splitAccessPath(path).map(escapePathAccess).join("\\."))}function replaceAll(string,find,replacement){return string.replace(new RegExp(find.replace(/[-/\\^$*+?.()|[\]{}]/g,"\\$&"),"g"),replacement)}function removePathFromField(path){return"".concat(splitAccessPath(path).join("."))}function accessPathDepth(path){if(!path){return 0}return splitAccessPath(path).length}function getFirstDefined(...args){for(const arg of args){if(arg!==undefined){return arg}}return undefined}let idCounter=42;function uniqueId(prefix){const id=++idCounter;return prefix?String(prefix)+id:id}function resetIdCounter(){idCounter=42}function internalField(name){return isInternalField(name)?name:"__".concat(name)}function isInternalField(name){return name.indexOf("__")===0}function normalizeAngle(angle){if(angle===undefined){return undefined}return(angle%360+360)%360}function isNumeric(value){if(isNumber(value)){return true}return!isNaN(value)&&!isNaN(parseFloat(value))}const CONDITIONAL_AXIS_PROP_INDEX={labelAlign:{part:"labels",vgProp:"align"},labelBaseline:{part:"labels",vgProp:"baseline"},labelColor:{part:"labels",vgProp:"fill"},labelFont:{part:"labels",vgProp:"font"},labelFontSize:{part:"labels",vgProp:"fontSize"},labelFontStyle:{part:"labels",vgProp:"fontStyle"},labelFontWeight:{part:"labels",vgProp:"fontWeight"},labelOpacity:{part:"labels",vgProp:"opacity"},labelOffset:null,labelPadding:null,gridColor:{part:"grid",vgProp:"stroke"},gridDash:{part:"grid",vgProp:"strokeDash"},gridDashOffset:{part:"grid",vgProp:"strokeDashOffset"},gridOpacity:{part:"grid",vgProp:"opacity"},gridWidth:{part:"grid",vgProp:"strokeWidth"},tickColor:{part:"ticks",vgProp:"stroke"},tickDash:{part:"ticks",vgProp:"strokeDash"},tickDashOffset:{part:"ticks",vgProp:"strokeDashOffset"},tickOpacity:{part:"ticks",vgProp:"opacity"},tickSize:null,tickWidth:{part:"ticks",vgProp:"strokeWidth"}};function isConditionalAxisValue(v){return v&&v["condition"]}const AXIS_PARTS=["domain","grid","labels","ticks","title"];const AXIS_PROPERTY_TYPE={grid:"grid",gridCap:"grid",gridColor:"grid",gridDash:"grid",gridDashOffset:"grid",gridOpacity:"grid",gridScale:"grid",gridWidth:"grid",orient:"main",bandPosition:"both",aria:"main",description:"main",domain:"main",domainCap:"main",domainColor:"main",domainDash:"main",domainDashOffset:"main",domainOpacity:"main",domainWidth:"main",format:"main",formatType:"main",labelAlign:"main",labelAngle:"main",labelBaseline:"main",labelBound:"main",labelColor:"main",labelFlush:"main",labelFlushOffset:"main",labelFont:"main",labelFontSize:"main",labelFontStyle:"main",labelFontWeight:"main",labelLimit:"main",labelLineHeight:"main",labelOffset:"main",labelOpacity:"main",labelOverlap:"main",labelPadding:"main",labels:"main",labelSeparation:"main",maxExtent:"main",minExtent:"main",offset:"both",position:"main",tickCap:"main",tickColor:"main",tickDash:"main",tickDashOffset:"main",tickMinStep:"main",tickOffset:"both",tickOpacity:"main",tickRound:"both",ticks:"main",tickSize:"main",tickWidth:"both",title:"main",titleAlign:"main",titleAnchor:"main",titleAngle:"main",titleBaseline:"main",titleColor:"main",titleFont:"main",titleFontSize:"main",titleFontStyle:"main",titleFontWeight:"main",titleLimit:"main",titleLineHeight:"main",titleOpacity:"main",titlePadding:"main",titleX:"main",titleY:"main",encode:"both",scale:"both",tickBand:"both",tickCount:"both",tickExtra:"both",translate:"both",values:"both",zindex:"both"};const COMMON_AXIS_PROPERTIES_INDEX={orient:1,aria:1,bandPosition:1,description:1,domain:1,domainCap:1,domainColor:1,domainDash:1,domainDashOffset:1,domainOpacity:1,domainWidth:1,format:1,formatType:1,grid:1,gridCap:1,gridColor:1,gridDash:1,gridDashOffset:1,gridOpacity:1,gridWidth:1,labelAlign:1,labelAngle:1,labelBaseline:1,labelBound:1,labelColor:1,labelFlush:1,labelFlushOffset:1,labelFont:1,labelFontSize:1,labelFontStyle:1,labelFontWeight:1,labelLimit:1,labelLineHeight:1,labelOffset:1,labelOpacity:1,labelOverlap:1,labelPadding:1,labels:1,labelSeparation:1,maxExtent:1,minExtent:1,offset:1,position:1,tickBand:1,tickCap:1,tickColor:1,tickCount:1,tickDash:1,tickDashOffset:1,tickExtra:1,tickMinStep:1,tickOffset:1,tickOpacity:1,tickRound:1,ticks:1,tickSize:1,tickWidth:1,title:1,titleAlign:1,titleAnchor:1,titleAngle:1,titleBaseline:1,titleColor:1,titleFont:1,titleFontSize:1,titleFontStyle:1,titleFontWeight:1,titleLimit:1,titleLineHeight:1,titleOpacity:1,titlePadding:1,titleX:1,titleY:1,translate:1,values:1,zindex:1};const AXIS_PROPERTIES_INDEX={...COMMON_AXIS_PROPERTIES_INDEX,style:1,labelExpr:1,encoding:1};function isAxisProperty(prop){return!!AXIS_PROPERTIES_INDEX[prop]}const AXIS_CONFIGS_INDEX={axis:1,axisBand:1,axisBottom:1,axisDiscrete:1,axisLeft:1,axisPoint:1,axisQuantitative:1,axisRight:1,axisTemporal:1,axisTop:1,axisX:1,axisXBand:1,axisXDiscrete:1,axisXPoint:1,axisXQuantitative:1,axisXTemporal:1,axisY:1,axisYBand:1,axisYDiscrete:1,axisYPoint:1,axisYQuantitative:1,axisYTemporal:1};const AXIS_CONFIGS=keys(AXIS_CONFIGS_INDEX);const AGGREGATE_OP_INDEX={argmax:1,argmin:1,average:1,count:1,distinct:1,product:1,max:1,mean:1,median:1,min:1,missing:1,q1:1,q3:1,ci0:1,ci1:1,stderr:1,stdev:1,stdevp:1,sum:1,valid:1,values:1,variance:1,variancep:1};const MULTIDOMAIN_SORT_OP_INDEX={count:1,min:1,max:1};function isArgminDef(a){return!!a&&!!a["argmin"]}function isArgmaxDef(a){return!!a&&!!a["argmax"]}function isAggregateOp(a){return isString(a)&&!!AGGREGATE_OP_INDEX[a]}const COUNTING_OPS=["count","valid","missing","distinct"];function isCountingAggregateOp(aggregate){return isString(aggregate)&&contains(COUNTING_OPS,aggregate)}function isMinMaxOp(aggregate){return isString(aggregate)&&contains(["min","max"],aggregate)}const SUM_OPS=["count","sum","distinct","valid","missing"];const SHARED_DOMAIN_OPS=["mean","average","median","q1","q3","min","max"];const SHARED_DOMAIN_OP_INDEX=toSet(SHARED_DOMAIN_OPS);const ROW="row";const COLUMN="column";const FACET="facet";const X="x";const Y="y";const X2="x2";const Y2="y2";const RADIUS="radius";const RADIUS2="radius2";const THETA="theta";const THETA2="theta2";const LATITUDE="latitude";const LONGITUDE="longitude";const LATITUDE2="latitude2";const LONGITUDE2="longitude2";const COLOR="color";const FILL="fill";const STROKE="stroke";const SHAPE="shape";const SIZE="size";const ANGLE="angle";const OPACITY="opacity";const FILLOPACITY="fillOpacity";const STROKEOPACITY="strokeOpacity";const STROKEWIDTH="strokeWidth";const STROKEDASH="strokeDash";const TEXT="text";const ORDER="order";const DETAIL="detail";const KEY="key";const TOOLTIP="tooltip";const HREF="href";const URL="url";const DESCRIPTION="description";const POSITION_CHANNEL_INDEX={x:1,y:1,x2:1,y2:1};const POLAR_POSITION_CHANNEL_INDEX={theta:1,theta2:1,radius:1,radius2:1};function isPolarPositionChannel(c){return c in POLAR_POSITION_CHANNEL_INDEX}const GEO_POSIITON_CHANNEL_INDEX={longitude:1,longitude2:1,latitude:1,latitude2:1};function getPositionChannelFromLatLong(channel){switch(channel){case LATITUDE:return"y";case LATITUDE2:return"y2";case LONGITUDE:return"x";case LONGITUDE2:return"x2"}}function isGeoPositionChannel(c){return c in GEO_POSIITON_CHANNEL_INDEX}const GEOPOSITION_CHANNELS=keys(GEO_POSIITON_CHANNEL_INDEX);const UNIT_CHANNEL_INDEX={...POSITION_CHANNEL_INDEX,...POLAR_POSITION_CHANNEL_INDEX,...GEO_POSIITON_CHANNEL_INDEX,color:1,fill:1,stroke:1,opacity:1,fillOpacity:1,strokeOpacity:1,strokeWidth:1,strokeDash:1,size:1,angle:1,shape:1,order:1,text:1,detail:1,key:1,tooltip:1,href:1,url:1,description:1};function isColorChannel(channel){return channel===COLOR||channel===FILL||channel===STROKE}const FACET_CHANNEL_INDEX={row:1,column:1,facet:1};const FACET_CHANNELS=keys(FACET_CHANNEL_INDEX);const CHANNEL_INDEX={...UNIT_CHANNEL_INDEX,...FACET_CHANNEL_INDEX};const CHANNELS=keys(CHANNEL_INDEX);const{order:_o,detail:_d,tooltip:_tt1,...SINGLE_DEF_CHANNEL_INDEX}=CHANNEL_INDEX;const{row:_r,column:_c,facet:_f,...SINGLE_DEF_UNIT_CHANNEL_INDEX}=SINGLE_DEF_CHANNEL_INDEX;function isSingleDefUnitChannel(str){return!!SINGLE_DEF_UNIT_CHANNEL_INDEX[str]}function isChannel(str){return!!CHANNEL_INDEX[str]}const SECONDARY_RANGE_CHANNEL=[X2,Y2,LATITUDE2,LONGITUDE2,THETA2,RADIUS2];function isSecondaryRangeChannel(c){const main=getMainRangeChannel(c);return main!==c}function getMainRangeChannel(channel){switch(channel){case X2:return X;case Y2:return Y;case LATITUDE2:return LATITUDE;case LONGITUDE2:return LONGITUDE;case THETA2:return THETA;case RADIUS2:return RADIUS}return channel}function getVgPositionChannel(channel){if(isPolarPositionChannel(channel)){switch(channel){case THETA:return"startAngle";case THETA2:return"endAngle";case RADIUS:return"outerRadius";case RADIUS2:return"innerRadius"}}return channel}function getSecondaryRangeChannel(channel){switch(channel){case X:return X2;case Y:return Y2;case LATITUDE:return LATITUDE2;case LONGITUDE:return LONGITUDE2;case THETA:return THETA2;case RADIUS:return RADIUS2}return undefined}function getSizeChannel(channel){switch(channel){case X:case X2:return"width";case Y:case Y2:return"height"}return undefined}function getOffsetChannel(channel){switch(channel){case X:return"xOffset";case Y:return"yOffset";case X2:return"x2Offset";case Y2:return"y2Offset";case THETA:return"thetaOffset";case RADIUS:return"radiusOffset";case THETA2:return"theta2Offset";case RADIUS2:return"radius2Offset"}return undefined}const{x:_x,y:_y,x2:_x2,y2:_y2,latitude:_latitude,longitude:_longitude,latitude2:_latitude2,longitude2:_longitude2,theta:_theta,theta2:_theta2,radius:_radius,radius2:_radius2,...NONPOSITION_CHANNEL_INDEX}=UNIT_CHANNEL_INDEX;const NONPOSITION_CHANNELS=keys(NONPOSITION_CHANNEL_INDEX);const POSITION_SCALE_CHANNEL_INDEX={x:1,y:1};const POSITION_SCALE_CHANNELS=keys(POSITION_SCALE_CHANNEL_INDEX);function isXorY(channel){return channel in POSITION_SCALE_CHANNEL_INDEX}const POLAR_POSITION_SCALE_CHANNEL_INDEX={theta:1,radius:1};const POLAR_POSITION_SCALE_CHANNELS=keys(POLAR_POSITION_SCALE_CHANNEL_INDEX);function getPositionScaleChannel(sizeType){return sizeType==="width"?X:Y}const{text:_t,tooltip:_tt,href:_hr,url:_u,description:_al,detail:_dd,key:_k,order:_oo,...NONPOSITION_SCALE_CHANNEL_INDEX}=NONPOSITION_CHANNEL_INDEX;const NONPOSITION_SCALE_CHANNELS=keys(NONPOSITION_SCALE_CHANNEL_INDEX);function isNonPositionScaleChannel(channel){return!!NONPOSITION_CHANNEL_INDEX[channel]}function supportLegend(channel){switch(channel){case COLOR:case FILL:case STROKE:case SIZE:case SHAPE:case OPACITY:case STROKEWIDTH:case STROKEDASH:return true;case FILLOPACITY:case STROKEOPACITY:case ANGLE:return false}}const SCALE_CHANNEL_INDEX={...POSITION_SCALE_CHANNEL_INDEX,...POLAR_POSITION_SCALE_CHANNEL_INDEX,...NONPOSITION_SCALE_CHANNEL_INDEX};const SCALE_CHANNELS=keys(SCALE_CHANNEL_INDEX);function isScaleChannel(channel){return!!SCALE_CHANNEL_INDEX[channel]}function supportMark(channel,mark){return getSupportedMark(channel)[mark]}const ALL_MARKS={arc:"always",area:"always",bar:"always",circle:"always",geoshape:"always",image:"always",line:"always",rule:"always",point:"always",rect:"always",square:"always",trail:"always",text:"always",tick:"always"};const{geoshape:_g,...ALL_MARKS_EXCEPT_GEOSHAPE}=ALL_MARKS;function getSupportedMark(channel){switch(channel){case COLOR:case FILL:case STROKE:case DESCRIPTION:case DETAIL:case KEY:case TOOLTIP:case HREF:case ORDER:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEWIDTH:case FACET:case ROW:case COLUMN:return ALL_MARKS;case X:case Y:case LATITUDE:case LONGITUDE:return ALL_MARKS_EXCEPT_GEOSHAPE;case X2:case Y2:case LATITUDE2:case LONGITUDE2:return{area:"always",bar:"always",image:"always",rect:"always",rule:"always",circle:"binned",point:"binned",square:"binned",tick:"binned",line:"binned",trail:"binned"};case SIZE:return{point:"always",tick:"always",rule:"always",circle:"always",square:"always",bar:"always",text:"always",line:"always",trail:"always"};case STROKEDASH:return{line:"always",point:"always",tick:"always",rule:"always",circle:"always",square:"always",bar:"always",geoshape:"always"};case SHAPE:return{point:"always",geoshape:"always"};case TEXT:return{text:"always"};case ANGLE:return{point:"always",square:"always",text:"always"};case URL:return{image:"always"};case THETA:return{text:"always",arc:"always"};case RADIUS:return{text:"always",arc:"always"};case THETA2:case RADIUS2:return{arc:"always"}}}function rangeType(channel){switch(channel){case X:case Y:case THETA:case RADIUS:case SIZE:case ANGLE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case X2:case Y2:case THETA2:case RADIUS2:return undefined;case FACET:case ROW:case COLUMN:case SHAPE:case STROKEDASH:case TEXT:case TOOLTIP:case HREF:case URL:case DESCRIPTION:return"discrete";case COLOR:case FILL:case STROKE:return"flexible";case LATITUDE:case LONGITUDE:case LATITUDE2:case LONGITUDE2:case DETAIL:case KEY:case ORDER:return undefined}}function binToString(bin){if(isBoolean(bin)){bin=normalizeBin(bin,undefined)}return"bin"+keys(bin).map(p=>isSelectionExtent(bin[p])?varName("_".concat(p,"_").concat(entries(bin[p]))):varName("_".concat(p,"_").concat(bin[p]))).join("")}function isBinning(bin){return bin===true||isBinParams(bin)&&!bin.binned}function isBinned(bin){return bin==="binned"||isBinParams(bin)&&bin.binned===true}function isBinParams(bin){return isObject(bin)}function isSelectionExtent(extent){return extent===null||extent===void 0?void 0:extent["selection"]}function autoMaxBins(channel){switch(channel){case ROW:case COLUMN:case SIZE:case COLOR:case FILL:case STROKE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case SHAPE:return 6;case STROKEDASH:return 4;default:return 10}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classPrivateFieldGet(receiver,privateMap){var descriptor=privateMap.get(receiver);if(!descriptor){throw new TypeError("attempted to get private field on non-instance")}if(descriptor.get){return descriptor.get.call(receiver)}return descriptor.value}function _classPrivateFieldSet(receiver,privateMap,value){var descriptor=privateMap.get(receiver);if(!descriptor){throw new TypeError("attempted to set private field on non-instance")}if(descriptor.set){descriptor.set.call(receiver,value)}else{if(!descriptor.writable){throw new TypeError("attempted to set read only private field")}descriptor.value=value}return value}function invalidSpec(spec){return"Invalid specification ".concat(JSON.stringify(spec),'. Make sure the specification includes at least one of the following properties: "mark", "layer", "facet", "hconcat", "vconcat", "concat", or "repeat".')}const FIT_NON_SINGLE='Autosize "fit" only works for single views and layered views.';function containerSizeNonSingle(name){const uName=name=="width"?"Width":"Height";return"".concat(uName,' "container" only works for single views and layered views.')}function containerSizeNotCompatibleWithAutosize(name){const uName=name=="width"?"Width":"Height";const fitDirection=name=="width"?"x":"y";return"".concat(uName,' "container" only works well with autosize "fit" or "fit-').concat(fitDirection,'".')}function droppingFit(channel){return channel?'Dropping "fit-'.concat(channel,'" because spec has discrete ').concat(getSizeChannel(channel),"."):'Dropping "fit" because spec has discrete size.'}function unknownField(channel){return"Unknown field for ".concat(channel,". Cannot calculate view size.")}function cannotProjectOnChannelWithoutField(channel){return'Cannot project a selection on encoding channel "'.concat(channel,'", which has no field.')}function cannotProjectAggregate(channel,aggregate){return'Cannot project a selection on encoding channel "'.concat(channel,'" as it uses an aggregate function ("').concat(aggregate,'").')}function nearestNotSupportForContinuous(mark){return'The "nearest" transform is not supported for '.concat(mark," marks.")}function selectionNotSupported(mark){return"Selection not supported for ".concat(mark," yet.")}function selectionNotFound(name){return'Cannot find a selection named "'.concat(name,'".')}const SCALE_BINDINGS_CONTINUOUS="Scale bindings are currently only supported for scales with unbinned, continuous domains.";const LEGEND_BINDINGS_MUST_HAVE_PROJECTION="Legend bindings are only supported for selections over an individual field or encoding channel.";function noSameUnitLookup(name){return'Cannot define and lookup the "'.concat(name,'" selection in the same view. ')+"Try moving the lookup into a second, layered view?"}const NEEDS_SAME_SELECTION="The same selection must be used to override scale domains in a layered view.";const INTERVAL_INITIALIZED_WITH_X_Y='Interval selections should be initialized using "x" and/or "y" keys.';function noSuchRepeatedValue(field){return'Unknown repeated value "'.concat(field,'".')}function columnsNotSupportByRowCol(type){return'The "columns" property cannot be used when "'.concat(type,'" has nested row/column.')}const CONCAT_CANNOT_SHARE_AXIS="Axes cannot be shared in concatenated or repeated views yet (https://github.com/vega/vega-lite/issues/2415).";function unrecognizedParse(p){return'Unrecognized parse "'.concat(p,'".')}function differentParse(field,local,ancestor){return'An ancestor parsed field "'.concat(field,'" as ').concat(ancestor," but a child wants to parse the field as ").concat(local,".")}const ADD_SAME_CHILD_TWICE="Attempt to add the same child twice.";function invalidTransformIgnored(transform){return"Ignoring an invalid transform: ".concat(stringify(transform),".")}const NO_FIELDS_NEEDS_AS='If "from.fields" is not specified, "as" has to be a string that specifies the key to be used for the data from the secondary source.';function customFormatTypeNotAllowed(channel){return"Config.customFormatTypes is not true, thus custom format type and format for channel ".concat(channel," are dropped.")}function projectionOverridden(opt){const{parentProjection:parentProjection,projection:projection}=opt;return"Layer's shared projection ".concat(stringify(parentProjection)," is overridden by a child projection ").concat(stringify(projection),".")}const REPLACE_ANGLE_WITH_THETA="Arc marks uses theta channel rather than angle, replacing angle with theta.";function primitiveChannelDef(channel,type,value){return"Channel ".concat(channel," is a ").concat(type,". Converted to {value: ").concat(stringify(value),"}.")}function invalidFieldType(type){return'Invalid field type "'.concat(type,'".')}function invalidFieldTypeForCountAggregate(type,aggregate){return'Invalid field type "'.concat(type,'" for aggregate: "').concat(aggregate,'", using "quantitative" instead.')}function invalidAggregate(aggregate){return'Invalid aggregation operator "'.concat(aggregate,'".')}function droppingColor(type,opt){const{fill:fill,stroke:stroke}=opt;return"Dropping color ".concat(type," as the plot also has ").concat(fill&&stroke?"fill and stroke":fill?"fill":"stroke",".")}function emptyFieldDef(fieldDef,channel){return"Dropping ".concat(stringify(fieldDef),' from channel "').concat(channel,'" since it does not contain any data field, datum, value, or signal.')}const LINE_WITH_VARYING_SIZE="Line marks cannot encode size with a non-groupby field. You may want to use trail marks instead.";function incompatibleChannel(channel,markOrFacet,when){return"".concat(channel,' dropped as it is incompatible with "').concat(markOrFacet,'"').concat(when?" when ".concat(when):"",".")}function invalidEncodingChannel(channel){return"".concat(channel,"-encoding is dropped as ").concat(channel," is not a valid encoding channel.")}function facetChannelShouldBeDiscrete(channel){return"".concat(channel," encoding should be discrete (ordinal / nominal / binned).")}function facetChannelDropped(channels){return"Facet encoding dropped as ".concat(channels.join(" and ")," ").concat(channels.length>1?"are":"is"," also specified.")}function discreteChannelCannotEncode(channel,type){return'Using discrete channel "'.concat(channel,'" to encode "').concat(type,'" field can be misleading as it does not encode ').concat(type==="ordinal"?"order":"magnitude",".")}function rangeMarkAlignmentCannotBeExpression(align){return"The ".concat(align," for range marks cannot be an expression")}function lineWithRange(hasX2,hasY2){const channels=hasX2&&hasY2?"x2 and y2":hasX2?"x2":"y2";return"Line mark is for continuous lines and thus cannot be used with ".concat(channels,". We will use the rule mark (line segments) instead.")}function orientOverridden(original,actual){return'Specified orient "'.concat(original,'" overridden with "').concat(actual,'".')}const RANGE_STEP_DEPRECATED='Scale\'s "rangeStep" is deprecated and will be removed in Vega-Lite 5.0. Please use "width"/"height": {"step": ...} instead. See https://vega.github.io/vega-lite/docs/size.html.';function cannotUseScalePropertyWithNonColor(prop){return'Cannot use the scale property "'.concat(prop,'" with non-color channel.')}function unaggregateDomainHasNoEffectForRawField(fieldDef){return"Using unaggregated domain with raw field has no effect (".concat(stringify(fieldDef),").")}function unaggregateDomainWithNonSharedDomainOp(aggregate){return'Unaggregated domain not applicable for "'.concat(aggregate,'" since it produces values outside the origin domain of the source data.')}function unaggregatedDomainWithLogScale(fieldDef){return"Unaggregated domain is currently unsupported for log scale (".concat(stringify(fieldDef),").")}function cannotApplySizeToNonOrientedMark(mark){return'Cannot apply size to non-oriented mark "'.concat(mark,'".')}function scaleTypeNotWorkWithChannel(channel,scaleType,defaultScaleType){return'Channel "'.concat(channel,'" does not work with "').concat(scaleType,'" scale. We are using "').concat(defaultScaleType,'" scale instead.')}function scaleTypeNotWorkWithFieldDef(scaleType,defaultScaleType){return'FieldDef does not work with "'.concat(scaleType,'" scale. We are using "').concat(defaultScaleType,'" scale instead.')}function scalePropertyNotWorkWithScaleType(scaleType,propName,channel){return"".concat(channel,"-scale's \"").concat(propName,'" is dropped as it does not work with ').concat(scaleType," scale.")}function stepDropped(channel){return'The step for "'.concat(channel,'" is dropped because the ').concat(channel==="width"?"x":"y"," is continuous.")}function mergeConflictingProperty(property,propertyOf,v1,v2){return"Conflicting ".concat(propertyOf.toString(),' property "').concat(property.toString(),'" (').concat(stringify(v1)," and ").concat(stringify(v2),"). Using ").concat(stringify(v1),".")}function mergeConflictingDomainProperty(property,propertyOf,v1,v2){return"Conflicting ".concat(propertyOf.toString(),' property "').concat(property.toString(),'" (').concat(stringify(v1)," and ").concat(stringify(v2),"). Using the union of the two domains.")}function independentScaleMeansIndependentGuide(channel){return'Setting the scale to be independent for "'.concat(channel,'" means we also have to set the guide (axis or legend) to be independent.')}function domainSortDropped(sort){return"Dropping sort property ".concat(stringify(sort),' as unioned domains only support boolean or op "count", "min", and "max".')}const MORE_THAN_ONE_SORT="Domains that should be unioned has conflicting sort properties. Sort will be set to true.";const FACETED_INDEPENDENT_DIFFERENT_SOURCES="Detected faceted independent scales that union domain of multiple fields from different data sources. We will use the first field. The result view size may be incorrect.";const FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES="Detected faceted independent scales that union domain of the same fields from different source. We will assume that this is the same field from a different fork of the same data source. However, if this is not the case, the result view size may be incorrect.";const FACETED_INDEPENDENT_SAME_SOURCE="Detected faceted independent scales that union domain of multiple fields from the same data source. We will use the first field. The result view size may be incorrect.";function cannotStackRangedMark(channel){return'Cannot stack "'.concat(channel,'" if there is already "').concat(channel,'2".')}function cannotStackNonLinearScale(scaleType){return"Cannot stack non-linear scale (".concat(scaleType,").")}function stackNonSummativeAggregate(aggregate){return'Stacking is applied even though the aggregate function is non-summative ("'.concat(aggregate,'").')}function invalidTimeUnit(unitName,value){return"Invalid ".concat(unitName,": ").concat(stringify(value),".")}function droppedDay(d){return"Dropping day from datetime ".concat(stringify(d)," as day cannot be combined with other units.")}function errorBarCenterAndExtentAreNotNeeded(center,extent){return"".concat(extent?"extent ":"").concat(extent&&center?"and ":"").concat(center?"center ":"").concat(extent&&center?"are ":"is ","not needed when data are aggregated.")}function errorBarCenterIsUsedWithWrongExtent(center,extent,mark){return"".concat(center," is not usually used with ").concat(extent," for ").concat(mark,".")}function errorBarContinuousAxisHasCustomizedAggregate(aggregate,compositeMark){return"Continuous axis should not have customized aggregation function ".concat(aggregate,"; ").concat(compositeMark," already agregates the axis.")}function errorBand1DNotSupport(property){return"1D error band does not support ".concat(property,".")}function channelRequiredForBinned(channel){return"Channel ".concat(channel,' is required for "binned" bin.')}function channelShouldNotBeUsedForBinned(channel){return"Channel ".concat(channel,' should not be used with "binned" bin.')}function domainRequiredForThresholdScale(channel){return"Domain for ".concat(channel," is required for threshold scale.")}const main=logger(Warn);let current=main;function set(newLogger){current=newLogger;return current}function reset(){current=main;return current}function warn(...args){current.warn(...args)}function debug(...args){current.debug(...args)}function isDateTime(o){if(o&&isObject(o)){for(const part of TIMEUNIT_PARTS){if(part in o){return true}}}return false}const MONTHS=["january","february","march","april","may","june","july","august","september","october","november","december"];const SHORT_MONTHS=MONTHS.map(m=>m.substr(0,3));const DAYS=["sunday","monday","tuesday","wednesday","thursday","friday","saturday"];const SHORT_DAYS=DAYS.map(d=>d.substr(0,3));function normalizeQuarter(q){if(isNumeric(q)){q=+q}if(isNumber(q)){if(q>4){warn(invalidTimeUnit("quarter",q))}return q-1}else{throw new Error(invalidTimeUnit("quarter",q))}}function normalizeMonth(m){if(isNumeric(m)){m=+m}if(isNumber(m)){return m-1}else{const lowerM=m.toLowerCase();const monthIndex=MONTHS.indexOf(lowerM);if(monthIndex!==-1){return monthIndex}const shortM=lowerM.substr(0,3);const shortMonthIndex=SHORT_MONTHS.indexOf(shortM);if(shortMonthIndex!==-1){return shortMonthIndex}throw new Error(invalidTimeUnit("month",m))}}function normalizeDay(d){if(isNumeric(d)){d=+d}if(isNumber(d)){return d%7}else{const lowerD=d.toLowerCase();const dayIndex=DAYS.indexOf(lowerD);if(dayIndex!==-1){return dayIndex}const shortD=lowerD.substr(0,3);const shortDayIndex=SHORT_DAYS.indexOf(shortD);if(shortDayIndex!==-1){return shortDayIndex}throw new Error(invalidTimeUnit("day",d))}}function dateTimeParts(d,normalize){const parts=[];if(normalize&&d.day!==undefined){if(keys(d).length>1){warn(droppedDay(d));d=duplicate(d);delete d.day}}if(d.year!==undefined){parts.push(d.year)}else{parts.push(2012)}if(d.month!==undefined){const month=normalize?normalizeMonth(d.month):d.month;parts.push(month)}else if(d.quarter!==undefined){const quarter=normalize?normalizeQuarter(d.quarter):d.quarter;parts.push(isNumber(quarter)?quarter*3:quarter+"*3")}else{parts.push(0)}if(d.date!==undefined){parts.push(d.date)}else if(d.day!==undefined){const day=normalize?normalizeDay(d.day):d.day;parts.push(isNumber(day)?day+1:day+"+1")}else{parts.push(1)}for(const timeUnit of["hours","minutes","seconds","milliseconds"]){const unit=d[timeUnit];parts.push(typeof unit==="undefined"?0:unit)}return parts}function dateTimeToExpr(d){const parts=dateTimeParts(d,true);const string=parts.join(", ");if(d.utc){return"utc(".concat(string,")")}else{return"datetime(".concat(string,")")}}function dateTimeExprToExpr(d){const parts=dateTimeParts(d,false);const string=parts.join(", ");if(d.utc){return"utc(".concat(string,")")}else{return"datetime(".concat(string,")")}}function dateTimeToTimestamp(d){const parts=dateTimeParts(d,true);if(d.utc){return+new Date(Date.UTC(...parts))}else{return+new Date(...parts)}}const LOCAL_SINGLE_TIMEUNIT_INDEX={year:1,quarter:1,month:1,week:1,day:1,dayofyear:1,date:1,hours:1,minutes:1,seconds:1,milliseconds:1};const TIMEUNIT_PARTS=keys(LOCAL_SINGLE_TIMEUNIT_INDEX);function isLocalSingleTimeUnit(timeUnit){return!!LOCAL_SINGLE_TIMEUNIT_INDEX[timeUnit]}function isUTCTimeUnit(t){return t.startsWith("utc")}function getLocalTimeUnit(t){return t.substr(3)}const VEGALITE_TIMEFORMAT={"year-month":"%b %Y ","year-month-date":"%b %d, %Y "};function getTimeUnitParts(timeUnit){const parts=[];for(const part of TIMEUNIT_PARTS){if(containsTimeUnit(timeUnit,part)){parts.push(part)}}return parts}function containsTimeUnit(fullTimeUnit,timeUnit){const index=fullTimeUnit.indexOf(timeUnit);if(index<0){return false}if(index>0&&timeUnit==="seconds"&&fullTimeUnit.charAt(index-1)==="i"){return false}if(fullTimeUnit.length>index+3&&timeUnit==="day"&&fullTimeUnit.charAt(index+3)==="o"){return false}if(index>0&&timeUnit==="year"&&fullTimeUnit.charAt(index-1)==="f"){return false}return true}function fieldExpr(fullTimeUnit,field,{end:end}={end:false}){const fieldRef=accessPathWithDatum(field);const utc=isUTCTimeUnit(fullTimeUnit)?"utc":"";function func(timeUnit){if(timeUnit==="quarter"){return"(".concat(utc,"quarter(").concat(fieldRef,")-1)")}else{return"".concat(utc).concat(timeUnit,"(").concat(fieldRef,")")}}let lastTimeUnit;const dateExpr={};for(const part of TIMEUNIT_PARTS){if(containsTimeUnit(fullTimeUnit,part)){dateExpr[part]=func(part);lastTimeUnit=part}}if(end){dateExpr[lastTimeUnit]+="+1"}return dateTimeExprToExpr(dateExpr)}function timeUnitSpecifierExpression(timeUnit){if(!timeUnit){return undefined}const timeUnitParts=getTimeUnitParts(timeUnit);return"timeUnitSpecifier(".concat(fastJsonStableStringify(timeUnitParts),", ").concat(fastJsonStableStringify(VEGALITE_TIMEFORMAT),")")}function formatExpression(timeUnit,field,isUTCScale){if(!timeUnit){return undefined}const expr=timeUnitSpecifierExpression(timeUnit);const utc=isUTCScale||isUTCTimeUnit(timeUnit);return"".concat(utc?"utc":"time","Format(").concat(field,", ").concat(expr,")")}function normalizeTimeUnit(timeUnit){if(!timeUnit){return undefined}let params;if(isString(timeUnit)){params={unit:timeUnit}}else if(isObject(timeUnit)){params={...timeUnit,...timeUnit.unit?{unit:timeUnit.unit}:{}}}if(isUTCTimeUnit(params.unit)){params.utc=true;params.unit=getLocalTimeUnit(params.unit)}return params}function timeUnitToString(tu){const{utc:utc,...rest}=normalizeTimeUnit(tu);if(rest.unit){return(utc?"utc":"")+keys(rest).map(p=>varName("".concat(p==="unit"?"":"_".concat(p,"_")).concat(rest[p]))).join("")}else{return(utc?"utc":"")+"timeunit"+keys(rest).map(p=>varName("_".concat(p,"_").concat(rest[p]))).join("")}}function isSignalRef(o){return o&&!!o["signal"]}function isVgRangeStep(range){return!!range["step"]}function isDataRefUnionedDomain(domain){if(!isArray(domain)){return"fields"in domain&&!("data"in domain)}return false}function isFieldRefUnionDomain(domain){if(!isArray(domain)){return"fields"in domain&&"data"in domain}return false}function isDataRefDomain(domain){if(!isArray(domain)){return"field"in domain&&"data"in domain}return false}const VG_MARK_CONFIG_INDEX={aria:1,description:1,ariaRole:1,ariaRoleDescription:1,blend:1,opacity:1,fill:1,fillOpacity:1,stroke:1,strokeCap:1,strokeWidth:1,strokeOpacity:1,strokeDash:1,strokeDashOffset:1,strokeJoin:1,strokeOffset:1,strokeMiterLimit:1,startAngle:1,endAngle:1,padAngle:1,innerRadius:1,outerRadius:1,size:1,shape:1,interpolate:1,tension:1,orient:1,align:1,baseline:1,text:1,dir:1,dx:1,dy:1,ellipsis:1,limit:1,radius:1,theta:1,angle:1,font:1,fontSize:1,fontWeight:1,fontStyle:1,lineBreak:1,lineHeight:1,cursor:1,href:1,tooltip:1,cornerRadius:1,cornerRadiusTopLeft:1,cornerRadiusTopRight:1,cornerRadiusBottomLeft:1,cornerRadiusBottomRight:1,aspect:1,width:1,height:1,url:1,smooth:1};const VG_MARK_CONFIGS=keys(VG_MARK_CONFIG_INDEX);const VG_MARK_INDEX={arc:1,area:1,group:1,image:1,line:1,path:1,rect:1,rule:1,shape:1,symbol:1,text:1,trail:1};const VG_CORNERRADIUS_CHANNELS=["cornerRadius","cornerRadiusTopLeft","cornerRadiusTopRight","cornerRadiusBottomLeft","cornerRadiusBottomRight"];function isSelectionPredicate(predicate){return predicate===null||predicate===void 0?void 0:predicate["selection"]}function isFieldEqualPredicate(predicate){return predicate&&!!predicate.field&&predicate.equal!==undefined}function isFieldLTPredicate(predicate){return predicate&&!!predicate.field&&predicate.lt!==undefined}function isFieldLTEPredicate(predicate){return predicate&&!!predicate.field&&predicate.lte!==undefined}function isFieldGTPredicate(predicate){return predicate&&!!predicate.field&&predicate.gt!==undefined}function isFieldGTEPredicate(predicate){return predicate&&!!predicate.field&&predicate.gte!==undefined}function isFieldRangePredicate(predicate){if(predicate&&predicate.field){if(isArray(predicate.range)&&predicate.range.length===2){return true}else if(isSignalRef(predicate.range)){return true}}return false}function isFieldOneOfPredicate(predicate){return predicate&&!!predicate.field&&(isArray(predicate.oneOf)||isArray(predicate.in))}function isFieldValidPredicate(predicate){return predicate&&!!predicate.field&&predicate.valid!==undefined}function isFieldPredicate(predicate){return isFieldOneOfPredicate(predicate)||isFieldEqualPredicate(predicate)||isFieldRangePredicate(predicate)||isFieldLTPredicate(predicate)||isFieldGTPredicate(predicate)||isFieldLTEPredicate(predicate)||isFieldGTEPredicate(predicate)}function predicateValueExpr(v,timeUnit){return valueExpr(v,{timeUnit:timeUnit,wrapTime:true})}function predicateValuesExpr(vals,timeUnit){return vals.map(v=>predicateValueExpr(v,timeUnit))}function fieldFilterExpression(predicate,useInRange=true){var _normalizeTimeUnit;const{field:field}=predicate;const timeUnit=(_normalizeTimeUnit=normalizeTimeUnit(predicate.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit;const fieldExpr$1=timeUnit?"time("+fieldExpr(timeUnit,field)+")":vgField(predicate,{expr:"datum"});if(isFieldEqualPredicate(predicate)){return fieldExpr$1+"==="+predicateValueExpr(predicate.equal,timeUnit)}else if(isFieldLTPredicate(predicate)){const upper=predicate.lt;return"".concat(fieldExpr$1,"<").concat(predicateValueExpr(upper,timeUnit))}else if(isFieldGTPredicate(predicate)){const lower=predicate.gt;return"".concat(fieldExpr$1,">").concat(predicateValueExpr(lower,timeUnit))}else if(isFieldLTEPredicate(predicate)){const upper=predicate.lte;return"".concat(fieldExpr$1,"<=").concat(predicateValueExpr(upper,timeUnit))}else if(isFieldGTEPredicate(predicate)){const lower=predicate.gte;return"".concat(fieldExpr$1,">=").concat(predicateValueExpr(lower,timeUnit))}else if(isFieldOneOfPredicate(predicate)){return"indexof([".concat(predicateValuesExpr(predicate.oneOf,timeUnit).join(","),"], ").concat(fieldExpr$1,") !== -1")}else if(isFieldValidPredicate(predicate)){return fieldValidPredicate(fieldExpr$1,predicate.valid)}else if(isFieldRangePredicate(predicate)){const{range:range}=predicate;const lower=isSignalRef(range)?{signal:"".concat(range.signal,"[0]")}:range[0];const upper=isSignalRef(range)?{signal:"".concat(range.signal,"[1]")}:range[1];if(lower!==null&&upper!==null&&useInRange){return"inrange("+fieldExpr$1+", ["+predicateValueExpr(lower,timeUnit)+", "+predicateValueExpr(upper,timeUnit)+"])"}const exprs=[];if(lower!==null){exprs.push("".concat(fieldExpr$1," >= ").concat(predicateValueExpr(lower,timeUnit)))}if(upper!==null){exprs.push("".concat(fieldExpr$1," <= ").concat(predicateValueExpr(upper,timeUnit)))}return exprs.length>0?exprs.join(" && "):"true"}throw new Error("Invalid field predicate: ".concat(JSON.stringify(predicate)))}function fieldValidPredicate(fieldExpr,valid=true){if(valid){return"isValid(".concat(fieldExpr,") && isFinite(+").concat(fieldExpr,")")}else{return"!isValid(".concat(fieldExpr,") || !isFinite(+").concat(fieldExpr,")")}}function normalizePredicate(f){if(isFieldPredicate(f)&&f.timeUnit){var _normalizeTimeUnit2;return{...f,timeUnit:(_normalizeTimeUnit2=normalizeTimeUnit(f.timeUnit))===null||_normalizeTimeUnit2===void 0?void 0:_normalizeTimeUnit2.unit}}return f}const Type={quantitative:"quantitative",ordinal:"ordinal",temporal:"temporal",nominal:"nominal",geojson:"geojson"};const QUANTITATIVE=Type.quantitative;const ORDINAL=Type.ordinal;const TEMPORAL=Type.temporal;const NOMINAL=Type.nominal;const GEOJSON=Type.geojson;function getFullName(type){if(type){type=type.toLowerCase();switch(type){case"q":case QUANTITATIVE:return"quantitative";case"t":case TEMPORAL:return"temporal";case"o":case ORDINAL:return"ordinal";case"n":case NOMINAL:return"nominal";case GEOJSON:return"geojson"}}return undefined}const ScaleType={LINEAR:"linear",LOG:"log",POW:"pow",SQRT:"sqrt",SYMLOG:"symlog",IDENTITY:"identity",SEQUENTIAL:"sequential",TIME:"time",UTC:"utc",QUANTILE:"quantile",QUANTIZE:"quantize",THRESHOLD:"threshold",BIN_ORDINAL:"bin-ordinal",ORDINAL:"ordinal",POINT:"point",BAND:"band"};const SCALE_CATEGORY_INDEX={linear:"numeric",log:"numeric",pow:"numeric",sqrt:"numeric",symlog:"numeric",identity:"numeric",sequential:"numeric",time:"time",utc:"time",ordinal:"ordinal","bin-ordinal":"bin-ordinal",point:"ordinal-position",band:"ordinal-position",quantile:"discretizing",quantize:"discretizing",threshold:"discretizing"};function scaleCompatible(scaleType1,scaleType2){const scaleCategory1=SCALE_CATEGORY_INDEX[scaleType1];const scaleCategory2=SCALE_CATEGORY_INDEX[scaleType2];return scaleCategory1===scaleCategory2||scaleCategory1==="ordinal-position"&&scaleCategory2==="time"||scaleCategory2==="ordinal-position"&&scaleCategory1==="time"}const SCALE_PRECEDENCE_INDEX={linear:0,log:1,pow:1,sqrt:1,symlog:1,identity:1,sequential:1,time:0,utc:0,point:10,band:11,ordinal:0,"bin-ordinal":0,quantile:0,quantize:0,threshold:0};function scaleTypePrecedence(scaleType){return SCALE_PRECEDENCE_INDEX[scaleType]}const CONTINUOUS_TO_CONTINUOUS_SCALES=["linear","log","pow","sqrt","symlog","time","utc"];const CONTINUOUS_TO_CONTINUOUS_INDEX=toSet(CONTINUOUS_TO_CONTINUOUS_SCALES);const QUANTITATIVE_SCALES=["linear","log","pow","sqrt","symlog"];const QUANTITATIVE_SCALES_INDEX=toSet(QUANTITATIVE_SCALES);function isQuantitative(type){return type in QUANTITATIVE_SCALES_INDEX}const CONTINUOUS_TO_DISCRETE_SCALES=["quantile","quantize","threshold"];const CONTINUOUS_TO_DISCRETE_INDEX=toSet(CONTINUOUS_TO_DISCRETE_SCALES);const CONTINUOUS_DOMAIN_SCALES=CONTINUOUS_TO_CONTINUOUS_SCALES.concat(["quantile","quantize","threshold","sequential","identity"]);const CONTINUOUS_DOMAIN_INDEX=toSet(CONTINUOUS_DOMAIN_SCALES);const DISCRETE_DOMAIN_SCALES=["ordinal","bin-ordinal","point","band"];const DISCRETE_DOMAIN_INDEX=toSet(DISCRETE_DOMAIN_SCALES);function hasDiscreteDomain(type){return type in DISCRETE_DOMAIN_INDEX}function hasContinuousDomain(type){return type in CONTINUOUS_DOMAIN_INDEX}function isContinuousToContinuous(type){return type in CONTINUOUS_TO_CONTINUOUS_INDEX}function isContinuousToDiscrete(type){return type in CONTINUOUS_TO_DISCRETE_INDEX}const defaultScaleConfig={pointPadding:.5,barBandPaddingInner:.1,rectBandPaddingInner:0,minBandSize:2,minFontSize:8,maxFontSize:40,minOpacity:.3,maxOpacity:.8,minSize:9,minStrokeWidth:1,maxStrokeWidth:4,quantileCount:4,quantizeCount:4};function isExtendedScheme(scheme){return!isString(scheme)&&!!scheme["name"]}function isSelectionDomain(domain){return domain===null||domain===void 0?void 0:domain["selection"]}function isDomainUnionWith(domain){return domain&&domain["unionWith"]}const SCALE_PROPERTY_INDEX={type:1,domain:1,domainMax:1,domainMin:1,domainMid:1,align:1,range:1,rangeMax:1,rangeMin:1,scheme:1,bins:1,reverse:1,round:1,clamp:1,nice:1,base:1,exponent:1,constant:1,interpolate:1,zero:1,padding:1,paddingInner:1,paddingOuter:1};const{type:type,domain:domain,range:range,rangeMax:rangeMax,rangeMin:rangeMin,scheme:scheme,...NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTY_INDEX}=SCALE_PROPERTY_INDEX;const NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTIES=keys(NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTY_INDEX);function scaleTypeSupportProperty(scaleType,propName){switch(propName){case"type":case"domain":case"reverse":case"range":return true;case"scheme":case"interpolate":return!contains(["point","band","identity"],scaleType);case"bins":return!contains(["point","band","identity","ordinal"],scaleType);case"round":return isContinuousToContinuous(scaleType)||scaleType==="band"||scaleType==="point";case"padding":case"rangeMin":case"rangeMax":return isContinuousToContinuous(scaleType)||contains(["point","band"],scaleType);case"paddingOuter":case"align":return contains(["point","band"],scaleType);case"paddingInner":return scaleType==="band";case"domainMax":case"domainMid":case"domainMin":case"clamp":return isContinuousToContinuous(scaleType);case"nice":return isContinuousToContinuous(scaleType)||scaleType==="quantize"||scaleType==="threshold";case"exponent":return scaleType==="pow";case"base":return scaleType==="log";case"constant":return scaleType==="symlog";case"zero":return hasContinuousDomain(scaleType)&&!contains(["log","time","utc","threshold","quantile"],scaleType)}}function channelScalePropertyIncompatability(channel,propName){switch(propName){case"interpolate":case"scheme":case"domainMid":if(!isColorChannel(channel)){return cannotUseScalePropertyWithNonColor(channel)}return undefined;case"align":case"type":case"bins":case"domain":case"domainMax":case"domainMin":case"range":case"base":case"exponent":case"constant":case"nice":case"padding":case"paddingInner":case"paddingOuter":case"rangeMax":case"rangeMin":case"reverse":case"round":case"clamp":case"zero":return undefined}}function scaleTypeSupportDataType(specifiedType,fieldDefType){if(contains([ORDINAL,NOMINAL],fieldDefType)){return specifiedType===undefined||hasDiscreteDomain(specifiedType)}else if(fieldDefType===TEMPORAL){return contains([ScaleType.TIME,ScaleType.UTC,undefined],specifiedType)}else if(fieldDefType===QUANTITATIVE){return contains([ScaleType.LOG,ScaleType.POW,ScaleType.SQRT,ScaleType.SYMLOG,ScaleType.QUANTILE,ScaleType.QUANTIZE,ScaleType.THRESHOLD,ScaleType.LINEAR,undefined],specifiedType)}return true}function channelSupportScaleType(channel,scaleType){if(!isScaleChannel(channel)){return false}switch(channel){case X:case Y:case THETA:case RADIUS:return isContinuousToContinuous(scaleType)||contains(["band","point"],scaleType);case SIZE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case ANGLE:return isContinuousToContinuous(scaleType)||isContinuousToDiscrete(scaleType)||contains(["band","point","ordinal"],scaleType);case COLOR:case FILL:case STROKE:return scaleType!=="band";case STROKEDASH:return scaleType==="ordinal"||isContinuousToDiscrete(scaleType);case SHAPE:return scaleType==="ordinal"}}function isExprRef(o){return o&&!!o["expr"]}function replaceExprRefInIndex(index){const props=keys(index||{});const newIndex={};for(const prop of props){newIndex[prop]=signalRefOrValue(index[prop])}return newIndex}const Mark={arc:"arc",area:"area",bar:"bar",image:"image",line:"line",point:"point",rect:"rect",rule:"rule",text:"text",tick:"tick",trail:"trail",circle:"circle",square:"square",geoshape:"geoshape"};const ARC=Mark.arc;const AREA=Mark.area;const BAR=Mark.bar;const IMAGE=Mark.image;const LINE=Mark.line;const POINT=Mark.point;const RECT=Mark.rect;const RULE=Mark.rule;const TEXT$1=Mark.text;const TICK=Mark.tick;const TRAIL=Mark.trail;const CIRCLE=Mark.circle;const SQUARE=Mark.square;const GEOSHAPE=Mark.geoshape;function isPathMark(m){return contains(["line","area","trail"],m)}function isRectBasedMark(m){return contains(["rect","bar","image","arc"],m)}const PRIMITIVE_MARKS=keys(Mark);function isMarkDef(mark){return mark["type"]}const PRIMITIVE_MARK_INDEX=toSet(PRIMITIVE_MARKS);const STROKE_CONFIG=["stroke","strokeWidth","strokeDash","strokeDashOffset","strokeOpacity","strokeJoin","strokeMiterLimit"];const FILL_CONFIG=["fill","fillOpacity"];const FILL_STROKE_CONFIG=[...STROKE_CONFIG,...FILL_CONFIG];const VL_ONLY_MARK_CONFIG_INDEX={color:1,filled:1,invalid:1,order:1,radius2:1,theta2:1,timeUnitBand:1,timeUnitBandPosition:1};const VL_ONLY_MARK_CONFIG_PROPERTIES=keys(VL_ONLY_MARK_CONFIG_INDEX);const VL_ONLY_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX={area:["line","point"],bar:["binSpacing","continuousBandSize","discreteBandSize"],rect:["binSpacing","continuousBandSize","discreteBandSize"],line:["point"],tick:["bandSize","thickness"]};const defaultMarkConfig={color:"#4c78a8",invalid:"filter",timeUnitBand:1};const MARK_CONFIG_INDEX={mark:1,arc:1,area:1,bar:1,circle:1,image:1,line:1,point:1,rect:1,rule:1,square:1,text:1,tick:1,trail:1,geoshape:1};const MARK_CONFIGS=keys(MARK_CONFIG_INDEX);const BAR_CORNER_RADIUS_INDEX={horizontal:["cornerRadiusTopRight","cornerRadiusBottomRight"],vertical:["cornerRadiusTopLeft","cornerRadiusTopRight"]};const DEFAULT_RECT_BAND_SIZE=5;const defaultBarConfig={binSpacing:1,continuousBandSize:DEFAULT_RECT_BAND_SIZE,timeUnitBandPosition:.5};const defaultRectConfig={binSpacing:0,continuousBandSize:DEFAULT_RECT_BAND_SIZE,timeUnitBandPosition:.5};const defaultTickConfig={thickness:1};function getMarkType(m){return isMarkDef(m)?m.type:m}function midPointRefWithPositionInvalidTest(params){const{channel:channel,channelDef:channelDef,markDef:markDef,scale:scale,config:config}=params;const ref=midPoint(params);if(isFieldDef(channelDef)&&!isCountingAggregateOp(channelDef.aggregate)&&scale&&isContinuousToContinuous(scale.get("type"))&&scale.get("zero")===false){return wrapPositionInvalidTest({fieldDef:channelDef,channel:channel,markDef:markDef,ref:ref,config:config})}return ref}function wrapPositionInvalidTest({fieldDef:fieldDef,channel:channel,markDef:markDef,ref:ref,config:config}){if(isPathMark(markDef.type)){return ref}const invalid=getMarkPropOrConfig("invalid",markDef,config);if(invalid===null){return ref}return[fieldInvalidTestValueRef(fieldDef,channel),ref]}function fieldInvalidTestValueRef(fieldDef,channel){const test=fieldInvalidPredicate(fieldDef,true);const mainChannel=getMainRangeChannel(channel);const zeroValueRef=mainChannel==="y"?{field:{group:"height"}}:{value:0};return{test:test,...zeroValueRef}}function fieldInvalidPredicate(field,invalid=true){return fieldValidPredicate(isString(field)?field:vgField(field,{expr:"datum"}),!invalid)}function datumDefToExpr(datumDef){const{datum:datum}=datumDef;if(isDateTime(datum)){return dateTimeToExpr(datum)}return"".concat(JSON.stringify(datum))}function valueRefForFieldOrDatumDef(fieldDef,scaleName,opt,encode){const ref={};if(scaleName){ref.scale=scaleName}if(isDatumDef(fieldDef)){const{datum:datum}=fieldDef;if(isDateTime(datum)){ref.signal=dateTimeToExpr(datum)}else if(isSignalRef(datum)){ref.signal=datum.signal}else if(isExprRef(datum)){ref.signal=datum.expr}else{ref.value=datum}}else{ref.field=vgField(fieldDef,opt)}if(encode){const{offset:offset,band:band}=encode;if(offset){ref.offset=offset}if(band){ref.band=band}}return ref}function interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:fieldOrDatumDef,fieldOrDatumDef2:fieldOrDatumDef2,offset:offset,startSuffix:startSuffix,band:band=.5}){const expr=0<band&&band<1?"datum":undefined;const start=vgField(fieldOrDatumDef,{expr:expr,suffix:startSuffix});const end=fieldOrDatumDef2!==undefined?vgField(fieldOrDatumDef2,{expr:expr}):vgField(fieldOrDatumDef,{suffix:"end",expr:expr});const ref={};if(band===0||band===1){ref.scale=scaleName;const val=band===0?start:end;ref.field=val}else{const datum="".concat(band," * ").concat(start," + ").concat(1-band," * ").concat(end);ref.signal='scale("'.concat(scaleName,'", ').concat(datum,")")}if(offset){ref.offset=offset}return ref}function midPoint({channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef,band:band}){if(channelDef){if(isFieldOrDatumDef(channelDef)){var _ref,_band2;if(isTypedFieldDef(channelDef)){var _band;band=(_band=band)!==null&&_band!==void 0?_band:getBand({channel:channel,fieldDef:channelDef,fieldDef2:channel2Def,markDef:markDef,stack:stack,config:config,isMidPoint:true});const{bin:bin,timeUnit:timeUnit,type:type}=channelDef;if(isBinning(bin)||band&&timeUnit&&type===TEMPORAL){if(stack&&stack.impute){return valueRefForFieldOrDatumDef(channelDef,scaleName,{binSuffix:"mid"},{offset:offset})}if(band){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,band:band,offset:offset})}return valueRefForFieldOrDatumDef(channelDef,scaleName,binRequiresRange(channelDef,channel)?{binSuffix:"range"}:{},{offset:offset})}else if(isBinned(bin)){if(isFieldDef(channel2Def)){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,fieldOrDatumDef2:channel2Def,band:band,offset:offset})}else{const channel2=channel===X?X2:Y2;warn(channelRequiredForBinned(channel2))}}}const scaleType=scale===null||scale===void 0?void 0:scale.get("type");return valueRefForFieldOrDatumDef(channelDef,scaleName,hasDiscreteDomain(scaleType)?{binSuffix:"range"}:{},{offset:offset,band:scaleType==="band"?(_ref=(_band2=band)!==null&&_band2!==void 0?_band2:channelDef.band)!==null&&_ref!==void 0?_ref:.5:undefined})}else if(isValueDef(channelDef)){const value=channelDef.value;const offsetMixins=offset?{offset:offset}:{};return{...widthHeightValueOrSignalRef(channel,value),...offsetMixins}}}if(isFunction(defaultRef)){defaultRef=defaultRef()}if(defaultRef){return{...defaultRef,...offset?{offset:offset}:{}}}return defaultRef}function widthHeightValueOrSignalRef(channel,value){if(contains(["x","x2"],channel)&&value==="width"){return{field:{group:"width"}}}else if(contains(["y","y2"],channel)&&value==="height"){return{field:{group:"height"}}}return signalOrValueRef(value)}function isCustomFormatType(formatType){return formatType&&formatType!=="number"&&formatType!=="time"}function customFormatExpr(formatType,field,format){return"".concat(formatType,"(").concat(field).concat(format?", ".concat(JSON.stringify(format)):"",")")}const BIN_RANGE_DELIMITER=" – ";function formatSignalRef({fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,normalizeStack:normalizeStack,config:config}){if(isCustomFormatType(formatType)){return formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,config:config})}const field=fieldToFormat(fieldOrDatumDef,expr,normalizeStack);if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)){var _normalizeTimeUnit,_fieldOrDatumDef$scal;const signal=timeFormatExpression(field,isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit:undefined,format,config.timeFormat,isScaleFieldDef(fieldOrDatumDef)&&((_fieldOrDatumDef$scal=fieldOrDatumDef.scale)===null||_fieldOrDatumDef$scal===void 0?void 0:_fieldOrDatumDef$scal.type)===ScaleType.UTC);return signal?{signal:signal}:undefined}format=numberFormat(channelDefType(fieldOrDatumDef),format,config);if(isFieldDef(fieldOrDatumDef)&&isBinning(fieldOrDatumDef.bin)){const endField=vgField(fieldOrDatumDef,{expr:expr,binSuffix:"end"});return{signal:binFormatExpression(field,endField,format,formatType,config)}}else if(format||channelDefType(fieldOrDatumDef)==="quantitative"){return{signal:"".concat(formatExpr(field,format))}}else{return{signal:"isValid(".concat(field,") ? ").concat(field,' : ""+').concat(field)}}}function fieldToFormat(fieldOrDatumDef,expr,normalizeStack){if(isFieldDef(fieldOrDatumDef)){if(normalizeStack){return"".concat(vgField(fieldOrDatumDef,{expr:expr,suffix:"end"}),"-").concat(vgField(fieldOrDatumDef,{expr:expr,suffix:"start"}))}else{return vgField(fieldOrDatumDef,{expr:expr})}}else{return datumDefToExpr(fieldOrDatumDef)}}function formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,normalizeStack:normalizeStack,config:config,field:field}){var _field;field=(_field=field)!==null&&_field!==void 0?_field:fieldToFormat(fieldOrDatumDef,expr,normalizeStack);if(isFieldDef(fieldOrDatumDef)&&isBinning(fieldOrDatumDef.bin)){const endField=vgField(fieldOrDatumDef,{expr:expr,binSuffix:"end"});return{signal:binFormatExpression(field,endField,format,formatType,config)}}return{signal:customFormatExpr(formatType,field,format)}}function guideFormat(fieldOrDatumDef,type,format,formatType,config,omitTimeFormatConfig){if(isCustomFormatType(formatType)){return undefined}if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)){var _normalizeTimeUnit2;const timeUnit=isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit2=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit2===void 0?void 0:_normalizeTimeUnit2.unit:undefined;return timeFormat(format,timeUnit,config,omitTimeFormatConfig)}return numberFormat(type,format,config)}function guideFormatType(formatType,fieldOrDatumDef,scaleType){if(formatType&&(isSignalRef(formatType)||formatType==="number"||formatType==="time")){return formatType}if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)&&scaleType!=="time"&&scaleType!=="utc"){return"time"}return undefined}function numberFormat(type,specifiedFormat,config){if(isString(specifiedFormat)){return specifiedFormat}if(type===QUANTITATIVE){return config.numberFormat}return undefined}function timeFormat(specifiedFormat,timeUnit,config,omitTimeFormatConfig){if(specifiedFormat){return specifiedFormat}if(timeUnit){return{signal:timeUnitSpecifierExpression(timeUnit)}}return omitTimeFormatConfig?undefined:config.timeFormat}function formatExpr(field,format){return"format(".concat(field,', "').concat(format||"",'")')}function binNumberFormatExpr(field,format,formatType,config){var _ref;if(isCustomFormatType(formatType)){return customFormatExpr(formatType,field,format)}return formatExpr(field,(_ref=isString(format)?format:undefined)!==null&&_ref!==void 0?_ref:config.numberFormat)}function binFormatExpression(startField,endField,format,formatType,config){const start=binNumberFormatExpr(startField,format,formatType,config);const end=binNumberFormatExpr(endField,format,formatType,config);return"".concat(fieldValidPredicate(startField,false),' ? "null" : ').concat(start,' + "').concat(BIN_RANGE_DELIMITER,'" + ').concat(end)}function timeFormatExpression(field,timeUnit,format,rawTimeFormat,isUTCScale){if(!timeUnit||format){format=isString(format)?format:rawTimeFormat;return"".concat(isUTCScale?"utc":"time","Format(").concat(field,", '").concat(format,"')")}else{return formatExpression(timeUnit,field,isUTCScale)}}const DEFAULT_SORT_OP="min";const SORT_BY_CHANNEL_INDEX={x:1,y:1,color:1,fill:1,stroke:1,strokeWidth:1,size:1,shape:1,fillOpacity:1,strokeOpacity:1,opacity:1,text:1};function isSortByChannel(c){return c in SORT_BY_CHANNEL_INDEX}function isSortByEncoding(sort){return!!sort&&!!sort["encoding"]}function isSortField(sort){return!!sort&&(sort["op"]==="count"||!!sort["field"])}function isSortArray(sort){return!!sort&&isArray(sort)}function isFacetMapping(f){return"row"in f||"column"in f}function isFacetFieldDef(channelDef){return!!channelDef&&"header"in channelDef}function isFacetSpec(spec){return"facet"in spec}function isConditionalSelection(c){return c["selection"]}function isRepeatRef(field){return field&&!isString(field)&&"repeat"in field}function toFieldDefBase(fieldDef){const{field:field,timeUnit:timeUnit,bin:bin,aggregate:aggregate}=fieldDef;return{...timeUnit?{timeUnit:timeUnit}:{},...bin?{bin:bin}:{},...aggregate?{aggregate:aggregate}:{},field:field}}function isSortableFieldDef(fieldDef){return"sort"in fieldDef}function getBand({channel:channel,fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:mark,stack:stack,config:config,isMidPoint:isMidPoint}){if(isFieldOrDatumDef(fieldDef)&&fieldDef.band!==undefined){return fieldDef.band}if(isFieldDef(fieldDef)){const{timeUnit:timeUnit,bin:bin}=fieldDef;if(timeUnit&&!fieldDef2){if(isMidPoint){return getMarkConfig("timeUnitBandPosition",mark,config)}else{return isRectBasedMark(mark.type)?getMarkConfig("timeUnitBand",mark,config):0}}else if(isBinning(bin)){return isRectBasedMark(mark.type)&&!isMidPoint?1:.5}}if((stack===null||stack===void 0?void 0:stack.fieldChannel)===channel&&isMidPoint){return.5}return undefined}function hasBand(channel,fieldDef,fieldDef2,stack,markDef,config){if(isBinning(fieldDef.bin)||fieldDef.timeUnit&&isTypedFieldDef(fieldDef)&&fieldDef.type==="temporal"){return!!getBand({channel:channel,fieldDef:fieldDef,fieldDef2:fieldDef2,stack:stack,markDef:markDef,config:config})}return false}function isConditionalDef(channelDef){return!!channelDef&&"condition"in channelDef}function hasConditionalFieldDef(channelDef){const condition=channelDef&&channelDef["condition"];return!!condition&&!isArray(condition)&&isFieldDef(condition)}function hasConditionalFieldOrDatumDef(channelDef){const condition=channelDef&&channelDef["condition"];return!!condition&&!isArray(condition)&&isFieldOrDatumDef(condition)}function hasConditionalValueDef(channelDef){const condition=channelDef&&channelDef["condition"];return!!condition&&(isArray(condition)||isValueDef(condition))}function isFieldDef(channelDef){return!!channelDef&&(!!channelDef["field"]||channelDef["aggregate"]==="count")}function channelDefType(channelDef){return channelDef&&channelDef["type"]}function isDatumDef(channelDef){return!!channelDef&&"datum"in channelDef}function isContinuousFieldOrDatumDef(cd){return isTypedFieldDef(cd)&&isContinuous(cd)||isNumericDataDef(cd)}function isNumericDataDef(cd){return isDatumDef(cd)&&isNumber(cd.datum)}function isFieldOrDatumDef(channelDef){return isFieldDef(channelDef)||isDatumDef(channelDef)}function isTypedFieldDef(channelDef){return!!channelDef&&("field"in channelDef||channelDef["aggregate"]==="count")&&"type"in channelDef}function isValueDef(channelDef){return channelDef&&"value"in channelDef&&"value"in channelDef}function isScaleFieldDef(channelDef){return!!channelDef&&("scale"in channelDef||"sort"in channelDef)}function isPositionFieldOrDatumDef(channelDef){return channelDef&&("axis"in channelDef||"stack"in channelDef||"impute"in channelDef)}function isMarkPropFieldOrDatumDef(channelDef){return!!channelDef&&"legend"in channelDef}function isStringFieldOrDatumDef(channelDef){return!!channelDef&&("format"in channelDef||"formatType"in channelDef)}function toStringFieldDef(fieldDef){return omit(fieldDef,["legend","axis","header","scale"])}function isOpFieldDef(fieldDef){return"op"in fieldDef}function vgField(fieldDef,opt={}){let field=fieldDef.field;const prefix=opt.prefix;let suffix=opt.suffix;let argAccessor="";if(isCount(fieldDef)){field=internalField("count")}else{let fn;if(!opt.nofn){if(isOpFieldDef(fieldDef)){fn=fieldDef.op}else{const{bin:bin,aggregate:aggregate,timeUnit:timeUnit}=fieldDef;if(isBinning(bin)){var _opt$binSuffix,_opt$suffix;fn=binToString(bin);suffix=((_opt$binSuffix=opt.binSuffix)!==null&&_opt$binSuffix!==void 0?_opt$binSuffix:"")+((_opt$suffix=opt.suffix)!==null&&_opt$suffix!==void 0?_opt$suffix:"")}else if(aggregate){if(isArgmaxDef(aggregate)){argAccessor='["'.concat(field,'"]');field="argmax_".concat(aggregate.argmax)}else if(isArgminDef(aggregate)){argAccessor='["'.concat(field,'"]');field="argmin_".concat(aggregate.argmin)}else{fn=String(aggregate)}}else if(timeUnit){var _opt$suffix2;fn=timeUnitToString(timeUnit);suffix=(!contains(["range","mid"],opt.binSuffix)&&opt.binSuffix||"")+((_opt$suffix2=opt.suffix)!==null&&_opt$suffix2!==void 0?_opt$suffix2:"")}}}if(fn){field=field?"".concat(fn,"_").concat(field):fn}}if(suffix){field="".concat(field,"_").concat(suffix)}if(prefix){field="".concat(prefix,"_").concat(field)}if(opt.forAs){return removePathFromField(field)}else if(opt.expr){return flatAccessWithDatum(field,opt.expr)+argAccessor}else{return replacePathInField(field)+argAccessor}}function isDiscrete(def){switch(def.type){case"nominal":case"ordinal":case"geojson":return true;case"quantitative":return isFieldDef(def)&&!!def.bin;case"temporal":return false}throw new Error(invalidFieldType(def.type))}function isContinuous(fieldDef){return!isDiscrete(fieldDef)}function isCount(fieldDef){return fieldDef.aggregate==="count"}function verbalTitleFormatter(fieldDef,config){const{field:field,bin:bin,timeUnit:timeUnit,aggregate:aggregate}=fieldDef;if(aggregate==="count"){return config.countTitle}else if(isBinning(bin)){return"".concat(field," (binned)")}else if(timeUnit){var _normalizeTimeUnit;const unit=(_normalizeTimeUnit=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit;if(unit){return"".concat(field," (").concat(getTimeUnitParts(unit).join("-"),")")}}else if(aggregate){if(isArgmaxDef(aggregate)){return"".concat(field," for max ").concat(aggregate.argmax)}else if(isArgminDef(aggregate)){return"".concat(field," for min ").concat(aggregate.argmin)}else{return"".concat(titleCase(aggregate)," of ").concat(field)}}return field}function functionalTitleFormatter(fieldDef){const{aggregate:aggregate,bin:bin,timeUnit:timeUnit,field:field}=fieldDef;if(isArgmaxDef(aggregate)){return"".concat(field," for argmax(").concat(aggregate.argmax,")")}else if(isArgminDef(aggregate)){return"".concat(field," for argmin(").concat(aggregate.argmin,")")}const timeUnitParams=normalizeTimeUnit(timeUnit);const fn=aggregate||(timeUnitParams===null||timeUnitParams===void 0?void 0:timeUnitParams.unit)||(timeUnitParams===null||timeUnitParams===void 0?void 0:timeUnitParams.maxbins)&&"timeunit"||isBinning(bin)&&"bin";if(fn){return fn.toUpperCase()+"("+field+")"}else{return field}}const defaultTitleFormatter=(fieldDef,config)=>{switch(config.fieldTitle){case"plain":return fieldDef.field;case"functional":return functionalTitleFormatter(fieldDef);default:return verbalTitleFormatter(fieldDef,config)}};let titleFormatter=defaultTitleFormatter;function setTitleFormatter(formatter){titleFormatter=formatter}function resetTitleFormatter(){setTitleFormatter(defaultTitleFormatter)}function title(fieldOrDatumDef,config,{allowDisabling:allowDisabling,includeDefault:includeDefault=true}){var _getGuide;const guideTitle=(_getGuide=getGuide(fieldOrDatumDef))===null||_getGuide===void 0?void 0:_getGuide.title;if(!isFieldDef(fieldOrDatumDef)){return guideTitle}const fieldDef=fieldOrDatumDef;const def=includeDefault?defaultTitle(fieldDef,config):undefined;if(allowDisabling){return getFirstDefined(guideTitle,fieldDef.title,def)}else{var _ref;return(_ref=guideTitle!==null&&guideTitle!==void 0?guideTitle:fieldDef.title)!==null&&_ref!==void 0?_ref:def}}function getGuide(fieldDef){if(isPositionFieldOrDatumDef(fieldDef)&&fieldDef.axis){return fieldDef.axis}else if(isMarkPropFieldOrDatumDef(fieldDef)&&fieldDef.legend){return fieldDef.legend}else if(isFacetFieldDef(fieldDef)&&fieldDef.header){return fieldDef.header}return undefined}function defaultTitle(fieldDef,config){return titleFormatter(fieldDef,config)}function getFormatMixins(fieldDef){if(isStringFieldOrDatumDef(fieldDef)){const{format:format,formatType:formatType}=fieldDef;return{format:format,formatType:formatType}}else{var _getGuide2;const guide=(_getGuide2=getGuide(fieldDef))!==null&&_getGuide2!==void 0?_getGuide2:{};const{format:format,formatType:formatType}=guide;return{format:format,formatType:formatType}}}function defaultType(fieldDef,channel){var _fieldDef$scale;switch(channel){case"latitude":case"longitude":return"quantitative";case"row":case"column":case"facet":case"shape":case"strokeDash":return"nominal";case"order":return"ordinal"}if(isSortableFieldDef(fieldDef)&&isArray(fieldDef.sort)){return"ordinal"}const{aggregate:aggregate,bin:bin,timeUnit:timeUnit}=fieldDef;if(timeUnit){return"temporal"}if(bin||aggregate&&!isArgmaxDef(aggregate)&&!isArgminDef(aggregate)){return"quantitative"}if(isScaleFieldDef(fieldDef)&&((_fieldDef$scale=fieldDef.scale)===null||_fieldDef$scale===void 0?void 0:_fieldDef$scale.type)){switch(SCALE_CATEGORY_INDEX[fieldDef.scale.type]){case"numeric":case"discretizing":return"quantitative";case"time":return"temporal"}}return"nominal"}function getFieldDef(channelDef){if(isFieldDef(channelDef)){return channelDef}else if(hasConditionalFieldDef(channelDef)){return channelDef.condition}return undefined}function getFieldOrDatumDef(channelDef){if(isFieldOrDatumDef(channelDef)){return channelDef}else if(hasConditionalFieldOrDatumDef(channelDef)){return channelDef.condition}return undefined}function initChannelDef(channelDef,channel,config,opt={}){if(isString(channelDef)||isNumber(channelDef)||isBoolean(channelDef)){const primitiveType=isString(channelDef)?"string":isNumber(channelDef)?"number":"boolean";warn(primitiveChannelDef(channel,primitiveType,channelDef));return{value:channelDef}}if(isFieldOrDatumDef(channelDef)){return initFieldOrDatumDef(channelDef,channel,config,opt)}else if(hasConditionalFieldOrDatumDef(channelDef)){return{...channelDef,condition:initFieldOrDatumDef(channelDef.condition,channel,config,opt)}}return channelDef}function initFieldOrDatumDef(fd,channel,config,opt){if(isStringFieldOrDatumDef(fd)){const{format:format,formatType:formatType,...rest}=fd;if(isCustomFormatType(formatType)&&!config.customFormatTypes){warn(customFormatTypeNotAllowed(channel));return initFieldOrDatumDef(rest,channel,config,opt)}}else{const guideType=isPositionFieldOrDatumDef(fd)?"axis":isMarkPropFieldOrDatumDef(fd)?"legend":isFacetFieldDef(fd)?"header":null;if(guideType&&fd[guideType]){const{format:format,formatType:formatType,...newGuide}=fd[guideType];if(isCustomFormatType(formatType)&&!config.customFormatTypes){warn(customFormatTypeNotAllowed(channel));return initFieldOrDatumDef({...fd,[guideType]:newGuide},channel,config,opt)}}}if(isFieldDef(fd)){return initFieldDef(fd,channel,opt)}return initDatumDef(fd)}function initDatumDef(datumDef){let type=datumDef["type"];if(type){return datumDef}const{datum:datum}=datumDef;type=isNumber(datum)?"quantitative":isString(datum)?"nominal":isDateTime(datum)?"temporal":undefined;return{...datumDef,type:type}}function initFieldDef(fd,channel,{compositeMark:compositeMark=false}={}){const{aggregate:aggregate,timeUnit:timeUnit,bin:bin,field:field}=fd;const fieldDef={...fd};if(!compositeMark&&aggregate&&!isAggregateOp(aggregate)&&!isArgmaxDef(aggregate)&&!isArgminDef(aggregate)){warn(invalidAggregate(aggregate));delete fieldDef.aggregate}if(timeUnit){fieldDef.timeUnit=normalizeTimeUnit(timeUnit)}if(field){fieldDef.field="".concat(field)}if(isBinning(bin)){fieldDef.bin=normalizeBin(bin,channel)}if(isBinned(bin)&&!isXorY(channel)){warn(channelShouldNotBeUsedForBinned(channel))}if(isTypedFieldDef(fieldDef)){const{type:type}=fieldDef;const fullType=getFullName(type);if(type!==fullType){fieldDef.type=fullType}if(type!=="quantitative"){if(isCountingAggregateOp(aggregate)){warn(invalidFieldTypeForCountAggregate(type,aggregate));fieldDef.type="quantitative"}}}else if(!isSecondaryRangeChannel(channel)){const newType=defaultType(fieldDef,channel);fieldDef["type"]=newType}if(isTypedFieldDef(fieldDef)){const{compatible:compatible,warning:warning}=channelCompatibility(fieldDef,channel)||{};if(compatible===false){warn(warning)}}if(isSortableFieldDef(fieldDef)&&isString(fieldDef.sort)){const{sort:sort}=fieldDef;if(isSortByChannel(sort)){return{...fieldDef,sort:{encoding:sort}}}const sub=sort.substr(1);if(sort.charAt(0)==="-"&&isSortByChannel(sub)){return{...fieldDef,sort:{encoding:sub,order:"descending"}}}}if(isFacetFieldDef(fieldDef)){const{header:header}=fieldDef;const{orient:orient,...rest}=header;if(orient){return{...fieldDef,header:{...rest,labelOrient:header.labelOrient||orient,titleOrient:header.titleOrient||orient}}}}return fieldDef}function normalizeBin(bin,channel){if(isBoolean(bin)){return{maxbins:autoMaxBins(channel)}}else if(bin==="binned"){return{binned:true}}else if(!bin.maxbins&&!bin.step){return{...bin,maxbins:autoMaxBins(channel)}}else{return bin}}const COMPATIBLE={compatible:true};function channelCompatibility(fieldDef,channel){const type=fieldDef.type;if(type==="geojson"&&channel!=="shape"){return{compatible:false,warning:"Channel ".concat(channel," should not be used with a geojson data.")}}switch(channel){case ROW:case COLUMN:case FACET:if(isContinuous(fieldDef)){return{compatible:false,warning:facetChannelShouldBeDiscrete(channel)}}return COMPATIBLE;case X:case Y:case COLOR:case FILL:case STROKE:case TEXT:case DETAIL:case KEY:case TOOLTIP:case HREF:case URL:case ANGLE:case THETA:case RADIUS:case DESCRIPTION:return COMPATIBLE;case LONGITUDE:case LONGITUDE2:case LATITUDE:case LATITUDE2:if(type!==QUANTITATIVE){return{compatible:false,warning:"Channel ".concat(channel," should be used with a quantitative field only, not ").concat(fieldDef.type," field.")}}return COMPATIBLE;case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEWIDTH:case SIZE:case THETA2:case RADIUS2:case X2:case Y2:if(type==="nominal"&&!fieldDef["sort"]){return{compatible:false,warning:"Channel ".concat(channel," should not be used with an unsorted discrete field.")}}return COMPATIBLE;case STROKEDASH:if(!contains(["ordinal","nominal"],fieldDef.type)){return{compatible:false,warning:"StrokeDash channel should be used with only discrete data."}}return COMPATIBLE;case SHAPE:if(!contains(["ordinal","nominal","geojson"],fieldDef.type)){return{compatible:false,warning:"Shape channel should be used with only either discrete or geojson data."}}return COMPATIBLE;case ORDER:if(fieldDef.type==="nominal"&&!("sort"in fieldDef)){return{compatible:false,warning:"Channel order is inappropriate for nominal field, which has no inherent order."}}return COMPATIBLE}}function isFieldOrDatumDefForTimeFormat(fieldOrDatumDef){const{formatType:formatType}=getFormatMixins(fieldOrDatumDef);return formatType==="time"||!formatType&&isTimeFieldDef(fieldOrDatumDef)}function isTimeFieldDef(def){return def&&(def["type"]==="temporal"||isFieldDef(def)&&!!def.timeUnit)}function valueExpr(v,{timeUnit:timeUnit,type:type,wrapTime:wrapTime,undefinedIfExprNotRequired:undefinedIfExprNotRequired}){var _normalizeTimeUnit2;const unit=timeUnit&&((_normalizeTimeUnit2=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit2===void 0?void 0:_normalizeTimeUnit2.unit);let isTime=unit||type==="temporal";let expr;if(isExprRef(v)){expr=v.expr}else if(isSignalRef(v)){expr=v.signal}else if(isDateTime(v)){isTime=true;expr=dateTimeToExpr(v)}else if(isString(v)||isNumber(v)){if(isTime){expr="datetime(".concat(JSON.stringify(v),")");if(isLocalSingleTimeUnit(unit)){if(isNumber(v)&&v<1e4||isString(v)&&isNaN(Date.parse(v))){expr=dateTimeToExpr({[unit]:v})}}}}if(expr){return wrapTime&&isTime?"time(".concat(expr,")"):expr}return undefinedIfExprNotRequired?undefined:JSON.stringify(v)}function valueArray(fieldOrDatumDef,values){const{type:type}=fieldOrDatumDef;return values.map(v=>{const expr=valueExpr(v,{timeUnit:isFieldDef(fieldOrDatumDef)?fieldOrDatumDef.timeUnit:undefined,type:type,undefinedIfExprNotRequired:true});if(expr!==undefined){return{signal:expr}}return v})}function binRequiresRange(fieldDef,channel){if(!isBinning(fieldDef.bin)){console.warn("Only call this method for binned field defs.");return false}return isScaleChannel(channel)&&contains(["ordinal","nominal"],fieldDef.type)}function extractTitleConfig(titleConfig){const{anchor:anchor,frame:frame,offset:offset,orient:orient,color:color,subtitleColor:subtitleColor,subtitleFont:subtitleFont,subtitleFontSize:subtitleFontSize,subtitleFontStyle:subtitleFontStyle,subtitleFontWeight:subtitleFontWeight,subtitleLineHeight:subtitleLineHeight,subtitlePadding:subtitlePadding,...rest}=titleConfig;const titleMarkConfig={...rest,...color?{fill:color}:{}};const nonMark={...anchor?{anchor:anchor}:{},...frame?{frame:frame}:{},...offset?{offset:offset}:{},...orient?{orient:orient}:{}};const subtitle={...subtitleColor?{subtitleColor:subtitleColor}:{},...subtitleFont?{subtitleFont:subtitleFont}:{},...subtitleFontSize?{subtitleFontSize:subtitleFontSize}:{},...subtitleFontStyle?{subtitleFontStyle:subtitleFontStyle}:{},...subtitleFontWeight?{subtitleFontWeight:subtitleFontWeight}:{},...subtitleLineHeight?{subtitleLineHeight:subtitleLineHeight}:{},...subtitlePadding?{subtitlePadding:subtitlePadding}:{}};const subtitleMarkConfig=pick(titleMarkConfig,["align","baseline","dx","dy","limit"]);return{titleMarkConfig:titleMarkConfig,subtitleMarkConfig:subtitleMarkConfig,nonMark:nonMark,subtitle:subtitle}}function isText(v){return isString(v)||isArray(v)&&isString(v[0])}function signalOrValueRefWithCondition(val){const condition=isArray(val.condition)?val.condition.map(conditionalSignalRefOrValue):conditionalSignalRefOrValue(val.condition);return{...signalRefOrValue(val),condition:condition}}function signalRefOrValue(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}return value}function conditionalSignalRefOrValue(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}return value}function signalOrValueRef(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}if(isSignalRef(value)){return value}return value!==undefined?{value:value}:undefined}function exprFromValueOrSignalRef(ref){if(isSignalRef(ref)){return ref.signal}return $(ref.value)}function signalOrStringValue(v){if(isSignalRef(v)){return v.signal}return v==null?null:$(v)}function applyMarkConfig(e,model,propsList){for(const property of propsList){const value=getMarkConfig(property,model.markDef,model.config);if(value!==undefined){e[property]=signalOrValueRef(value)}}return e}function getStyles(mark){var _mark$style;return[].concat(mark.type,(_mark$style=mark.style)!==null&&_mark$style!==void 0?_mark$style:[])}function getMarkPropOrConfig(channel,mark,config,opt={}){const{vgChannel:vgChannel,ignoreVgConfig:ignoreVgConfig}=opt;if(vgChannel&&mark[vgChannel]!==undefined){return mark[vgChannel]}else if(mark[channel]!==undefined){return mark[channel]}else if(ignoreVgConfig&&(!vgChannel||vgChannel===channel)){return undefined}return getMarkConfig(channel,mark,config,opt)}function getMarkConfig(channel,mark,config,{vgChannel:vgChannel}={}){return getFirstDefined(vgChannel?getMarkStyleConfig(channel,mark,config.style):undefined,getMarkStyleConfig(channel,mark,config.style),vgChannel?config[mark.type][vgChannel]:undefined,config[mark.type][channel],vgChannel?config.mark[vgChannel]:config.mark[channel])}function getMarkStyleConfig(prop,mark,styleConfigIndex){return getStyleConfig(prop,getStyles(mark),styleConfigIndex)}function getStyleConfig(p,styles,styleConfigIndex){styles=array(styles);let value;for(const style of styles){const styleConfig=styleConfigIndex[style];if(styleConfig&&styleConfig[p]!==undefined){value=styleConfig[p]}}return value}function sortParams(orderDef,fieldRefOption){return array(orderDef).reduce((s,orderChannelDef)=>{var _orderChannelDef$sort;s.field.push(vgField(orderChannelDef,fieldRefOption));s.order.push((_orderChannelDef$sort=orderChannelDef.sort)!==null&&_orderChannelDef$sort!==void 0?_orderChannelDef$sort:"ascending");return s},{field:[],order:[]})}function mergeTitleFieldDefs(f1,f2){const merged=[...f1];f2.forEach(fdToMerge=>{for(const fieldDef1 of merged){if(deepEqual(fieldDef1,fdToMerge)){return}}merged.push(fdToMerge)});return merged}function mergeTitle(title1,title2){if(deepEqual(title1,title2)||!title2){return title1}else if(!title1){return title2}else{return[...array(title1),...array(title2)].join(", ")}}function mergeTitleComponent(v1,v2){const v1Val=v1.value;const v2Val=v2.value;if(v1Val==null||v2Val===null){return{explicit:v1.explicit,value:null}}else if((isText(v1Val)||isSignalRef(v1Val))&&(isText(v2Val)||isSignalRef(v2Val))){return{explicit:v1.explicit,value:mergeTitle(v1Val,v2Val)}}else if(isText(v1Val)||isSignalRef(v1Val)){return{explicit:v1.explicit,value:v1Val}}else if(isText(v2Val)||isSignalRef(v2Val)){return{explicit:v1.explicit,value:v2Val}}else if(!isText(v1Val)&&!isSignalRef(v1Val)&&!isText(v2Val)&&!isSignalRef(v2Val)){return{explicit:v1.explicit,value:mergeTitleFieldDefs(v1Val,v2Val)}}throw new Error("It should never reach here")}function isUnitSpec(spec){return"mark"in spec}class CompositeMarkNormalizer{constructor(name,run){this.name=name;this.run=run}hasMatchingType(spec){if(isUnitSpec(spec)){return getMarkType(spec.mark)===this.name}return false}}function channelHasField(encoding,channel){const channelDef=encoding&&encoding[channel];if(channelDef){if(isArray(channelDef)){return some(channelDef,fieldDef=>!!fieldDef.field)}else{return isFieldDef(channelDef)||hasConditionalFieldDef(channelDef)}}return false}function isAggregate(encoding){return some(CHANNELS,channel=>{if(channelHasField(encoding,channel)){const channelDef=encoding[channel];if(isArray(channelDef)){return some(channelDef,fieldDef=>!!fieldDef.aggregate)}else{const fieldDef=getFieldDef(channelDef);return fieldDef&&!!fieldDef.aggregate}}return false})}function extractTransformsFromEncoding(oldEncoding,config){const groupby=[];const bins=[];const timeUnits=[];const aggregate=[];const encoding={};forEach(oldEncoding,(channelDef,channel)=>{if(isFieldDef(channelDef)){const{field:field,aggregate:aggOp,bin:bin,timeUnit:timeUnit,...remaining}=channelDef;if(aggOp||timeUnit||bin){const guide=getGuide(channelDef);const isTitleDefined=guide&&guide.title;let newField=vgField(channelDef,{forAs:true});const newFieldDef={...isTitleDefined?[]:{title:title(channelDef,config,{allowDisabling:true})},...remaining,field:newField};if(aggOp){let op;if(isArgmaxDef(aggOp)){op="argmax";newField=vgField({op:"argmax",field:aggOp.argmax},{forAs:true});newFieldDef.field="".concat(newField,".").concat(field)}else if(isArgminDef(aggOp)){op="argmin";newField=vgField({op:"argmin",field:aggOp.argmin},{forAs:true});newFieldDef.field="".concat(newField,".").concat(field)}else if(aggOp!=="boxplot"&&aggOp!=="errorbar"&&aggOp!=="errorband"){op=aggOp}if(op){const aggregateEntry={op:op,as:newField};if(field){aggregateEntry.field=field}aggregate.push(aggregateEntry)}}else{groupby.push(newField);if(isTypedFieldDef(channelDef)&&isBinning(bin)){bins.push({bin:bin,field:field,as:newField});groupby.push(vgField(channelDef,{binSuffix:"end"}));if(binRequiresRange(channelDef,channel)){groupby.push(vgField(channelDef,{binSuffix:"range"}))}if(isXorY(channel)){const secondaryChannel={field:newField+"_end"};encoding[channel+"2"]=secondaryChannel}newFieldDef.bin="binned";if(!isSecondaryRangeChannel(channel)){newFieldDef["type"]=QUANTITATIVE}}else if(timeUnit){timeUnits.push({timeUnit:timeUnit,field:field,as:newField});const formatType=isTypedFieldDef(channelDef)&&channelDef.type!==TEMPORAL&&"time";if(formatType){if(channel===TEXT||channel===TOOLTIP){newFieldDef["formatType"]=formatType}else if(isNonPositionScaleChannel(channel)){newFieldDef["legend"]={formatType:formatType,...newFieldDef["legend"]}}else if(isXorY(channel)){newFieldDef["axis"]={formatType:formatType,...newFieldDef["axis"]}}}}}encoding[channel]=newFieldDef}else{groupby.push(field);encoding[channel]=oldEncoding[channel]}}else{encoding[channel]=oldEncoding[channel]}});return{bins:bins,timeUnits:timeUnits,aggregate:aggregate,groupby:groupby,encoding:encoding}}function markChannelCompatible(encoding,channel,mark){const markSupported=supportMark(channel,mark);if(!markSupported){return false}else if(markSupported==="binned"){const primaryFieldDef=encoding[channel===X2?X:Y];if(isFieldDef(primaryFieldDef)&&isFieldDef(encoding[channel])&&isBinned(primaryFieldDef.bin)){return true}else{return false}}return true}function initEncoding(encoding,mark,filled,config){return keys(encoding).reduce((normalizedEncoding,channel)=>{if(!isChannel(channel)){warn(invalidEncodingChannel(channel));return normalizedEncoding}const channelDef=encoding[channel];if(channel==="angle"&&mark==="arc"&&!encoding.theta){warn(REPLACE_ANGLE_WITH_THETA);channel=THETA}if(!markChannelCompatible(encoding,channel,mark)){warn(incompatibleChannel(channel,mark));return normalizedEncoding}if(channel===SIZE&&mark==="line"){const fieldDef=getFieldDef(encoding[channel]);if(fieldDef===null||fieldDef===void 0?void 0:fieldDef.aggregate){warn(LINE_WITH_VARYING_SIZE);return normalizedEncoding}}if(channel===COLOR&&(filled?"fill"in encoding:"stroke"in encoding)){warn(droppingColor("encoding",{fill:"fill"in encoding,stroke:"stroke"in encoding}));return normalizedEncoding}if(channel===DETAIL||channel===ORDER&&!isArray(channelDef)&&!isValueDef(channelDef)||channel===TOOLTIP&&isArray(channelDef)){if(channelDef){normalizedEncoding[channel]=array(channelDef).reduce((defs,fieldDef)=>{if(!isFieldDef(fieldDef)){warn(emptyFieldDef(fieldDef,channel))}else{defs.push(initFieldDef(fieldDef,channel))}return defs},[])}}else{if(channel===TOOLTIP&&channelDef===null){normalizedEncoding[channel]=null}else if(!isFieldDef(channelDef)&&!isDatumDef(channelDef)&&!isValueDef(channelDef)&&!isConditionalDef(channelDef)&&!isSignalRef(channelDef)){warn(emptyFieldDef(channelDef,channel));return normalizedEncoding}normalizedEncoding[channel]=initChannelDef(channelDef,channel,config)}return normalizedEncoding},{})}function normalizeEncoding(encoding,config){const normalizedEncoding={};for(const channel of keys(encoding)){const newChannelDef=initChannelDef(encoding[channel],channel,config,{compositeMark:true});normalizedEncoding[channel]=newChannelDef}return normalizedEncoding}function fieldDefs(encoding){const arr=[];for(const channel of keys(encoding)){if(channelHasField(encoding,channel)){const channelDef=encoding[channel];const channelDefArray=array(channelDef);for(const def of channelDefArray){if(isFieldDef(def)){arr.push(def)}else if(hasConditionalFieldDef(def)){arr.push(def.condition)}}}}return arr}function forEach(mapping,f,thisArg){if(!mapping){return}for(const channel of keys(mapping)){const el=mapping[channel];if(isArray(el)){for(const channelDef of el){f.call(thisArg,channelDef,channel)}}else{f.call(thisArg,el,channel)}}}function reduce(mapping,f,init,thisArg){if(!mapping){return init}return keys(mapping).reduce((r,channel)=>{const map=mapping[channel];if(isArray(map)){return map.reduce((r1,channelDef)=>f.call(thisArg,r1,channelDef,channel),r)}else{return f.call(thisArg,r,map,channel)}},init)}function pathGroupingFields(mark,encoding){return keys(encoding).reduce((details,channel)=>{switch(channel){case X:case Y:case HREF:case DESCRIPTION:case URL:case X2:case Y2:case THETA:case THETA2:case RADIUS:case RADIUS2:case LATITUDE:case LONGITUDE:case LATITUDE2:case LONGITUDE2:case TEXT:case SHAPE:case ANGLE:case TOOLTIP:return details;case ORDER:if(mark==="line"||mark==="trail"){return details}case DETAIL:case KEY:{const channelDef=encoding[channel];if(isArray(channelDef)||isFieldDef(channelDef)){for(const fieldDef of array(channelDef)){if(!fieldDef.aggregate){details.push(vgField(fieldDef,{}))}}}return details}case SIZE:if(mark==="trail"){return details}case COLOR:case FILL:case STROKE:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEDASH:case STROKEWIDTH:{const fieldDef=getFieldDef(encoding[channel]);if(fieldDef&&!fieldDef.aggregate){details.push(vgField(fieldDef,{}))}return details}}},[])}function filterTooltipWithAggregatedField(oldEncoding){const{tooltip:tooltip,...filteredEncoding}=oldEncoding;if(!tooltip){return{filteredEncoding:filteredEncoding}}let customTooltipWithAggregatedField;let customTooltipWithoutAggregatedField;if(isArray(tooltip)){for(const t of tooltip){if(t.aggregate){if(!customTooltipWithAggregatedField){customTooltipWithAggregatedField=[]}customTooltipWithAggregatedField.push(t)}else{if(!customTooltipWithoutAggregatedField){customTooltipWithoutAggregatedField=[]}customTooltipWithoutAggregatedField.push(t)}}if(customTooltipWithAggregatedField){filteredEncoding.tooltip=customTooltipWithAggregatedField}}else{if(tooltip["aggregate"]){filteredEncoding.tooltip=tooltip}else{customTooltipWithoutAggregatedField=tooltip}}if(isArray(customTooltipWithoutAggregatedField)&&customTooltipWithoutAggregatedField.length===1){customTooltipWithoutAggregatedField=customTooltipWithoutAggregatedField[0]}return{customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField,filteredEncoding:filteredEncoding}}function getCompositeMarkTooltip(tooltipSummary,continuousAxisChannelDef,encodingWithoutContinuousAxis,withFieldName=true){if("tooltip"in encodingWithoutContinuousAxis){return{tooltip:encodingWithoutContinuousAxis.tooltip}}const fiveSummaryTooltip=tooltipSummary.map(({fieldPrefix:fieldPrefix,titlePrefix:titlePrefix})=>{const mainTitle=withFieldName?" of ".concat(getTitle(continuousAxisChannelDef)):"";return{field:fieldPrefix+continuousAxisChannelDef.field,type:continuousAxisChannelDef.type,title:isSignalRef(titlePrefix)?{signal:titlePrefix+'"'.concat(escape(mainTitle),'"')}:titlePrefix+mainTitle}});const tooltipFieldDefs=fieldDefs(encodingWithoutContinuousAxis).map(toStringFieldDef);return{tooltip:[...fiveSummaryTooltip,...unique(tooltipFieldDefs,hash)]}}function getTitle(continuousAxisChannelDef){const{title:title,field:field}=continuousAxisChannelDef;return getFirstDefined(title,field)}function makeCompositeAggregatePartFactory(compositeMarkDef,continuousAxis,continuousAxisChannelDef,sharedEncoding,compositeMarkConfig){const{scale:scale,axis:axis}=continuousAxisChannelDef;return({partName:partName,mark:mark,positionPrefix:positionPrefix,endPositionPrefix:endPositionPrefix=undefined,extraEncoding:extraEncoding={}})=>{const title=getTitle(continuousAxisChannelDef);return partLayerMixins(compositeMarkDef,partName,compositeMarkConfig,{mark:mark,encoding:{[continuousAxis]:{field:positionPrefix+"_"+continuousAxisChannelDef.field,type:continuousAxisChannelDef.type,...title!==undefined?{title:title}:{},...scale!==undefined?{scale:scale}:{},...axis!==undefined?{axis:axis}:{}},...isString(endPositionPrefix)?{[continuousAxis+"2"]:{field:endPositionPrefix+"_"+continuousAxisChannelDef.field}}:{},...sharedEncoding,...extraEncoding}})}}function partLayerMixins(markDef,part,compositeMarkConfig,partBaseSpec){const{clip:clip,color:color,opacity:opacity}=markDef;const mark=markDef.type;if(markDef[part]||markDef[part]===undefined&&compositeMarkConfig[part]){return[{...partBaseSpec,mark:{...compositeMarkConfig[part],...clip?{clip:clip}:{},...color?{color:color}:{},...opacity?{opacity:opacity}:{},...isMarkDef(partBaseSpec.mark)?partBaseSpec.mark:{type:partBaseSpec.mark},style:"".concat(mark,"-").concat(part),...isBoolean(markDef[part])?{}:markDef[part]}}]}return[]}function compositeMarkContinuousAxis(spec,orient,compositeMark){const{encoding:encoding}=spec;const continuousAxis=orient==="vertical"?"y":"x";const continuousAxisChannelDef=encoding[continuousAxis];const continuousAxisChannelDef2=encoding[continuousAxis+"2"];const continuousAxisChannelDefError=encoding[continuousAxis+"Error"];const continuousAxisChannelDefError2=encoding[continuousAxis+"Error2"];return{continuousAxisChannelDef:filterAggregateFromChannelDef(continuousAxisChannelDef,compositeMark),continuousAxisChannelDef2:filterAggregateFromChannelDef(continuousAxisChannelDef2,compositeMark),continuousAxisChannelDefError:filterAggregateFromChannelDef(continuousAxisChannelDefError,compositeMark),continuousAxisChannelDefError2:filterAggregateFromChannelDef(continuousAxisChannelDefError2,compositeMark),continuousAxis:continuousAxis}}function filterAggregateFromChannelDef(continuousAxisChannelDef,compositeMark){if(continuousAxisChannelDef&&continuousAxisChannelDef.aggregate){const{aggregate:aggregate,...continuousAxisWithoutAggregate}=continuousAxisChannelDef;if(aggregate!==compositeMark){warn(errorBarContinuousAxisHasCustomizedAggregate(aggregate,compositeMark))}return continuousAxisWithoutAggregate}else{return continuousAxisChannelDef}}function compositeMarkOrient(spec,compositeMark){const{mark:mark,encoding:encoding}=spec;const{x:x,y:y}=encoding;if(isMarkDef(mark)&&mark.orient){return mark.orient}if(isContinuousFieldOrDatumDef(x)){if(isContinuousFieldOrDatumDef(y)){const xAggregate=isFieldDef(x)&&x.aggregate;const yAggregate=isFieldDef(y)&&y.aggregate;if(!xAggregate&&yAggregate===compositeMark){return"vertical"}else if(!yAggregate&&xAggregate===compositeMark){return"horizontal"}else if(xAggregate===compositeMark&&yAggregate===compositeMark){throw new Error("Both x and y cannot have aggregate")}else{if(isFieldOrDatumDefForTimeFormat(y)&&!isFieldOrDatumDefForTimeFormat(x)){return"horizontal"}return"vertical"}}return"horizontal"}else if(isContinuousFieldOrDatumDef(y)){return"vertical"}else{throw new Error("Need a valid continuous axis for ".concat(compositeMark,"s"))}}const BOXPLOT="boxplot";const BOXPLOT_PARTS=["box","median","outliers","rule","ticks"];const boxPlotNormalizer=new CompositeMarkNormalizer(BOXPLOT,normalizeBoxPlot);function getBoxPlotType(extent){if(isNumber(extent)){return"tukey"}return extent}function normalizeBoxPlot(spec,{config:config}){var _markDef$extent;spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{mark:mark,encoding:_encoding,selection:selection,projection:_p,...outerSpec}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};if(selection){warn(selectionNotSupported("boxplot"))}const extent=(_markDef$extent=markDef.extent)!==null&&_markDef$extent!==void 0?_markDef$extent:config.boxplot.extent;const sizeValue=getMarkPropOrConfig("size",markDef,config);const boxPlotType=getBoxPlotType(extent);const{bins:bins,timeUnits:timeUnits,transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,groupby:groupby,aggregate:aggregate,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,boxOrient:boxOrient,customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField}=boxParams(spec,extent,config);const{color:color,size:size,...encodingWithoutSizeColorAndContinuousAxis}=encodingWithoutContinuousAxis;const makeBoxPlotPart=sharedEncoding=>makeCompositeAggregatePartFactory(markDef,continuousAxis,continuousAxisChannelDef,sharedEncoding,config.boxplot);const makeBoxPlotExtent=makeBoxPlotPart(encodingWithoutSizeColorAndContinuousAxis);const makeBoxPlotBox=makeBoxPlotPart(encodingWithoutContinuousAxis);const makeBoxPlotMidTick=makeBoxPlotPart({...encodingWithoutSizeColorAndContinuousAxis,...size?{size:size}:{}});const fiveSummaryTooltipEncoding=getCompositeMarkTooltip([{fieldPrefix:boxPlotType==="min-max"?"upper_whisker_":"max_",titlePrefix:"Max"},{fieldPrefix:"upper_box_",titlePrefix:"Q3"},{fieldPrefix:"mid_box_",titlePrefix:"Median"},{fieldPrefix:"lower_box_",titlePrefix:"Q1"},{fieldPrefix:boxPlotType==="min-max"?"lower_whisker_":"min_",titlePrefix:"Min"}],continuousAxisChannelDef,encodingWithoutContinuousAxis);const endTick={type:"tick",color:"black",opacity:1,orient:ticksOrient,invalid:null,aria:false};const whiskerTooltipEncoding=boxPlotType==="min-max"?fiveSummaryTooltipEncoding:getCompositeMarkTooltip([{fieldPrefix:"upper_whisker_",titlePrefix:"Upper Whisker"},{fieldPrefix:"lower_whisker_",titlePrefix:"Lower Whisker"}],continuousAxisChannelDef,encodingWithoutContinuousAxis);const whiskerLayers=[...makeBoxPlotExtent({partName:"rule",mark:{type:"rule",invalid:null,aria:false},positionPrefix:"lower_whisker",endPositionPrefix:"lower_box",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"rule",mark:{type:"rule",invalid:null,aria:false},positionPrefix:"upper_box",endPositionPrefix:"upper_whisker",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"ticks",mark:endTick,positionPrefix:"lower_whisker",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"ticks",mark:endTick,positionPrefix:"upper_whisker",extraEncoding:whiskerTooltipEncoding})];const boxLayers=[...boxPlotType!=="tukey"?whiskerLayers:[],...makeBoxPlotBox({partName:"box",mark:{type:"bar",...sizeValue?{size:sizeValue}:{},orient:boxOrient,invalid:null,ariaRoleDescription:"box"},positionPrefix:"lower_box",endPositionPrefix:"upper_box",extraEncoding:fiveSummaryTooltipEncoding}),...makeBoxPlotMidTick({partName:"median",mark:{type:"tick",invalid:null,...isObject(config.boxplot.median)&&config.boxplot.median.color?{color:config.boxplot.median.color}:{},...sizeValue?{size:sizeValue}:{},orient:ticksOrient,aria:false},positionPrefix:"mid_box",extraEncoding:fiveSummaryTooltipEncoding})];if(boxPlotType==="min-max"){var _outerSpec$transform;return{...outerSpec,transform:((_outerSpec$transform=outerSpec.transform)!==null&&_outerSpec$transform!==void 0?_outerSpec$transform:[]).concat(transform),layer:boxLayers}}const lowerBoxExpr='datum["lower_box_'.concat(continuousAxisChannelDef.field,'"]');const upperBoxExpr='datum["upper_box_'.concat(continuousAxisChannelDef.field,'"]');const iqrExpr="(".concat(upperBoxExpr," - ").concat(lowerBoxExpr,")");const lowerWhiskerExpr="".concat(lowerBoxExpr," - ").concat(extent," * ").concat(iqrExpr);const upperWhiskerExpr="".concat(upperBoxExpr," + ").concat(extent," * ").concat(iqrExpr);const fieldExpr='datum["'.concat(continuousAxisChannelDef.field,'"]');const joinaggregateTransform={joinaggregate:boxParamsQuartiles(continuousAxisChannelDef.field),groupby:groupby};const filteredWhiskerSpec={transform:[{filter:"(".concat(lowerWhiskerExpr," <= ").concat(fieldExpr,") && (").concat(fieldExpr," <= ").concat(upperWhiskerExpr,")")},{aggregate:[{op:"min",field:continuousAxisChannelDef.field,as:"lower_whisker_"+continuousAxisChannelDef.field},{op:"max",field:continuousAxisChannelDef.field,as:"upper_whisker_"+continuousAxisChannelDef.field},{op:"min",field:"lower_box_"+continuousAxisChannelDef.field,as:"lower_box_"+continuousAxisChannelDef.field},{op:"max",field:"upper_box_"+continuousAxisChannelDef.field,as:"upper_box_"+continuousAxisChannelDef.field},...aggregate],groupby:groupby}],layer:whiskerLayers};const{tooltip:tooltip,...encodingWithoutSizeColorContinuousAxisAndTooltip}=encodingWithoutSizeColorAndContinuousAxis;const{scale:scale,axis:axis}=continuousAxisChannelDef;const title=getTitle(continuousAxisChannelDef);const axisWithoutTitle=omit(axis,["title"]);const outlierLayersMixins=partLayerMixins(markDef,"outliers",config.boxplot,{transform:[{filter:"(".concat(fieldExpr," < ").concat(lowerWhiskerExpr,") || (").concat(fieldExpr," > ").concat(upperWhiskerExpr,")")}],mark:"point",encoding:{[continuousAxis]:{field:continuousAxisChannelDef.field,type:continuousAxisChannelDef.type,...title!==undefined?{title:title}:{},...scale!==undefined?{scale:scale}:{},...isEmpty(axisWithoutTitle)?{}:{axis:axisWithoutTitle}},...encodingWithoutSizeColorContinuousAxisAndTooltip,...color?{color:color}:{},...customTooltipWithoutAggregatedField?{tooltip:customTooltipWithoutAggregatedField}:{}}})[0];let filteredLayersMixins;const filteredLayersMixinsTransforms=[...bins,...timeUnits,joinaggregateTransform];if(outlierLayersMixins){filteredLayersMixins={transform:filteredLayersMixinsTransforms,layer:[outlierLayersMixins,filteredWhiskerSpec]}}else{filteredLayersMixins=filteredWhiskerSpec;filteredLayersMixins.transform.unshift(...filteredLayersMixinsTransforms)}return{...outerSpec,layer:[filteredLayersMixins,{transform:transform,layer:boxLayers}]}}function boxParamsQuartiles(continousAxisField){return[{op:"q1",field:continousAxisField,as:"lower_box_"+continousAxisField},{op:"q3",field:continousAxisField,as:"upper_box_"+continousAxisField}]}function boxParams(spec,extent,config){const orient=compositeMarkOrient(spec,BOXPLOT);const{continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis}=compositeMarkContinuousAxis(spec,orient,BOXPLOT);const continuousFieldName=continuousAxisChannelDef.field;const boxPlotType=getBoxPlotType(extent);const boxplotSpecificAggregate=[...boxParamsQuartiles(continuousFieldName),{op:"median",field:continuousFieldName,as:"mid_box_"+continuousFieldName},{op:"min",field:continuousFieldName,as:(boxPlotType==="min-max"?"lower_whisker_":"min_")+continuousFieldName},{op:"max",field:continuousFieldName,as:(boxPlotType==="min-max"?"upper_whisker_":"max_")+continuousFieldName}];const postAggregateCalculates=boxPlotType==="min-max"||boxPlotType==="tukey"?[]:[{calculate:'datum["upper_box_'.concat(continuousFieldName,'"] - datum["lower_box_').concat(continuousFieldName,'"]'),as:"iqr_"+continuousFieldName},{calculate:'min(datum["upper_box_'.concat(continuousFieldName,'"] + datum["iqr_').concat(continuousFieldName,'"] * ').concat(extent,', datum["max_').concat(continuousFieldName,'"])'),as:"upper_whisker_"+continuousFieldName},{calculate:'max(datum["lower_box_'.concat(continuousFieldName,'"] - datum["iqr_').concat(continuousFieldName,'"] * ').concat(extent,', datum["min_').concat(continuousFieldName,'"])'),as:"lower_whisker_"+continuousFieldName}];const{[continuousAxis]:oldContinuousAxisChannelDef,...oldEncodingWithoutContinuousAxis}=spec.encoding;const{customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField,filteredEncoding:filteredEncoding}=filterTooltipWithAggregatedField(oldEncodingWithoutContinuousAxis);const{bins:bins,timeUnits:timeUnits,aggregate:aggregate,groupby:groupby,encoding:encodingWithoutContinuousAxis}=extractTransformsFromEncoding(filteredEncoding,config);const ticksOrient=orient==="vertical"?"horizontal":"vertical";const boxOrient=orient;const transform=[...bins,...timeUnits,{aggregate:[...aggregate,...boxplotSpecificAggregate],groupby:groupby},...postAggregateCalculates];return{bins:bins,timeUnits:timeUnits,transform:transform,groupby:groupby,aggregate:aggregate,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,boxOrient:boxOrient,customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField}}const ERRORBAR="errorbar";const ERRORBAR_PARTS=["ticks","rule"];const errorBarNormalizer=new CompositeMarkNormalizer(ERRORBAR,normalizeErrorBar);function normalizeErrorBar(spec,{config:config}){spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}=errorBarParams(spec,ERRORBAR,config);delete encodingWithoutContinuousAxis["size"];const makeErrorBarPart=makeCompositeAggregatePartFactory(markDef,continuousAxis,continuousAxisChannelDef,encodingWithoutContinuousAxis,config.errorbar);const thickness=markDef.thickness;const size=markDef.size;const tick={type:"tick",orient:ticksOrient,aria:false,...thickness!==undefined?{thickness:thickness}:{},...size!==undefined?{size:size}:{}};const layer=[...makeErrorBarPart({partName:"ticks",mark:tick,positionPrefix:"lower",extraEncoding:tooltipEncoding}),...makeErrorBarPart({partName:"ticks",mark:tick,positionPrefix:"upper",extraEncoding:tooltipEncoding}),...makeErrorBarPart({partName:"rule",mark:{type:"rule",ariaRoleDescription:"errorbar",...thickness!==undefined?{size:thickness}:{}},positionPrefix:"lower",endPositionPrefix:"upper",extraEncoding:tooltipEncoding})];return{...outerSpec,transform:transform,...layer.length>1?{layer:layer}:{...layer[0]}}}function errorBarOrientAndInputType(spec,compositeMark){const{encoding:encoding}=spec;if(errorBarIsInputTypeRaw(encoding)){return{orient:compositeMarkOrient(spec,compositeMark),inputType:"raw"}}const isTypeAggregatedUpperLower=errorBarIsInputTypeAggregatedUpperLower(encoding);const isTypeAggregatedError=errorBarIsInputTypeAggregatedError(encoding);const x=encoding.x;const y=encoding.y;if(isTypeAggregatedUpperLower){if(isTypeAggregatedError){throw new Error("".concat(compositeMark," cannot be both type aggregated-upper-lower and aggregated-error"))}const x2=encoding.x2;const y2=encoding.y2;if(isFieldOrDatumDef(x2)&&isFieldOrDatumDef(y2)){throw new Error("".concat(compositeMark," cannot have both x2 and y2"))}else if(isFieldOrDatumDef(x2)){if(isContinuousFieldOrDatumDef(x)){return{orient:"horizontal",inputType:"aggregated-upper-lower"}}else{throw new Error("Both x and x2 have to be quantitative in ".concat(compositeMark))}}else if(isFieldOrDatumDef(y2)){if(isContinuousFieldOrDatumDef(y)){return{orient:"vertical",inputType:"aggregated-upper-lower"}}else{throw new Error("Both y and y2 have to be quantitative in ".concat(compositeMark))}}throw new Error("No ranged axis")}else{const xError=encoding.xError;const xError2=encoding.xError2;const yError=encoding.yError;const yError2=encoding.yError2;if(isFieldOrDatumDef(xError2)&&!isFieldOrDatumDef(xError)){throw new Error("".concat(compositeMark," cannot have xError2 without xError"))}if(isFieldOrDatumDef(yError2)&&!isFieldOrDatumDef(yError)){throw new Error("".concat(compositeMark," cannot have yError2 without yError"))}if(isFieldOrDatumDef(xError)&&isFieldOrDatumDef(yError)){throw new Error("".concat(compositeMark," cannot have both xError and yError with both are quantiative"))}else if(isFieldOrDatumDef(xError)){if(isContinuousFieldOrDatumDef(x)){return{orient:"horizontal",inputType:"aggregated-error"}}else{throw new Error("All x, xError, and xError2 (if exist) have to be quantitative")}}else if(isFieldOrDatumDef(yError)){if(isContinuousFieldOrDatumDef(y)){return{orient:"vertical",inputType:"aggregated-error"}}else{throw new Error("All y, yError, and yError2 (if exist) have to be quantitative")}}throw new Error("No ranged axis")}}function errorBarIsInputTypeRaw(encoding){return(isFieldOrDatumDef(encoding.x)||isFieldOrDatumDef(encoding.y))&&!isFieldOrDatumDef(encoding.x2)&&!isFieldOrDatumDef(encoding.y2)&&!isFieldOrDatumDef(encoding.xError)&&!isFieldOrDatumDef(encoding.xError2)&&!isFieldOrDatumDef(encoding.yError)&&!isFieldOrDatumDef(encoding.yError2)}function errorBarIsInputTypeAggregatedUpperLower(encoding){return isFieldOrDatumDef(encoding.x2)||isFieldOrDatumDef(encoding.y2)}function errorBarIsInputTypeAggregatedError(encoding){return isFieldOrDatumDef(encoding.xError)||isFieldOrDatumDef(encoding.xError2)||isFieldOrDatumDef(encoding.yError)||isFieldOrDatumDef(encoding.yError2)}function errorBarParams(spec,compositeMark,config){var _outerSpec$transform;const{mark:mark,encoding:encoding,selection:selection,projection:_p,...outerSpec}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};if(selection){warn(selectionNotSupported(compositeMark))}const{orient:orient,inputType:inputType}=errorBarOrientAndInputType(spec,compositeMark);const{continuousAxisChannelDef:continuousAxisChannelDef,continuousAxisChannelDef2:continuousAxisChannelDef2,continuousAxisChannelDefError:continuousAxisChannelDefError,continuousAxisChannelDefError2:continuousAxisChannelDefError2,continuousAxis:continuousAxis}=compositeMarkContinuousAxis(spec,orient,compositeMark);const{errorBarSpecificAggregate:errorBarSpecificAggregate,postAggregateCalculates:postAggregateCalculates,tooltipSummary:tooltipSummary,tooltipTitleWithFieldName:tooltipTitleWithFieldName}=errorBarAggregationAndCalculation(markDef,continuousAxisChannelDef,continuousAxisChannelDef2,continuousAxisChannelDefError,continuousAxisChannelDefError2,inputType,compositeMark,config);const{[continuousAxis]:oldContinuousAxisChannelDef,[continuousAxis==="x"?"x2":"y2"]:oldContinuousAxisChannelDef2,[continuousAxis==="x"?"xError":"yError"]:oldContinuousAxisChannelDefError,[continuousAxis==="x"?"xError2":"yError2"]:oldContinuousAxisChannelDefError2,...oldEncodingWithoutContinuousAxis}=encoding;const{bins:bins,timeUnits:timeUnits,aggregate:oldAggregate,groupby:oldGroupBy,encoding:encodingWithoutContinuousAxis}=extractTransformsFromEncoding(oldEncodingWithoutContinuousAxis,config);const aggregate=[...oldAggregate,...errorBarSpecificAggregate];const groupby=inputType!=="raw"?[]:oldGroupBy;const tooltipEncoding=getCompositeMarkTooltip(tooltipSummary,continuousAxisChannelDef,encodingWithoutContinuousAxis,tooltipTitleWithFieldName);return{transform:[...(_outerSpec$transform=outerSpec.transform)!==null&&_outerSpec$transform!==void 0?_outerSpec$transform:[],...bins,...timeUnits,...aggregate.length===0?[]:[{aggregate:aggregate,groupby:groupby}],...postAggregateCalculates],groupby:groupby,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:orient==="vertical"?"horizontal":"vertical",markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}}function errorBarAggregationAndCalculation(markDef,continuousAxisChannelDef,continuousAxisChannelDef2,continuousAxisChannelDefError,continuousAxisChannelDefError2,inputType,compositeMark,config){let errorBarSpecificAggregate=[];let postAggregateCalculates=[];const continuousFieldName=continuousAxisChannelDef.field;let tooltipSummary;let tooltipTitleWithFieldName=false;if(inputType==="raw"){const center=markDef.center?markDef.center:markDef.extent?markDef.extent==="iqr"?"median":"mean":config.errorbar.center;const extent=markDef.extent?markDef.extent:center==="mean"?"stderr":"iqr";if(center==="median"!==(extent==="iqr")){warn(errorBarCenterIsUsedWithWrongExtent(center,extent,compositeMark))}if(extent==="stderr"||extent==="stdev"){errorBarSpecificAggregate=[{op:extent,field:continuousFieldName,as:"extent_"+continuousFieldName},{op:center,field:continuousFieldName,as:"center_"+continuousFieldName}];postAggregateCalculates=[{calculate:'datum["center_'.concat(continuousFieldName,'"] + datum["extent_').concat(continuousFieldName,'"]'),as:"upper_"+continuousFieldName},{calculate:'datum["center_'.concat(continuousFieldName,'"] - datum["extent_').concat(continuousFieldName,'"]'),as:"lower_"+continuousFieldName}];tooltipSummary=[{fieldPrefix:"center_",titlePrefix:titleCase(center)},{fieldPrefix:"upper_",titlePrefix:getTitlePrefix(center,extent,"+")},{fieldPrefix:"lower_",titlePrefix:getTitlePrefix(center,extent,"-")}];tooltipTitleWithFieldName=true}else{let centerOp;let lowerExtentOp;let upperExtentOp;if(extent==="ci"){centerOp="mean";lowerExtentOp="ci0";upperExtentOp="ci1"}else{centerOp="median";lowerExtentOp="q1";upperExtentOp="q3"}errorBarSpecificAggregate=[{op:lowerExtentOp,field:continuousFieldName,as:"lower_"+continuousFieldName},{op:upperExtentOp,field:continuousFieldName,as:"upper_"+continuousFieldName},{op:centerOp,field:continuousFieldName,as:"center_"+continuousFieldName}];tooltipSummary=[{fieldPrefix:"upper_",titlePrefix:title({field:continuousFieldName,aggregate:upperExtentOp,type:"quantitative"},config,{allowDisabling:false})},{fieldPrefix:"lower_",titlePrefix:title({field:continuousFieldName,aggregate:lowerExtentOp,type:"quantitative"},config,{allowDisabling:false})},{fieldPrefix:"center_",titlePrefix:title({field:continuousFieldName,aggregate:centerOp,type:"quantitative"},config,{allowDisabling:false})}]}}else{if(markDef.center||markDef.extent){warn(errorBarCenterAndExtentAreNotNeeded(markDef.center,markDef.extent))}if(inputType==="aggregated-upper-lower"){tooltipSummary=[];postAggregateCalculates=[{calculate:'datum["'.concat(continuousAxisChannelDef2.field,'"]'),as:"upper_"+continuousFieldName},{calculate:'datum["'.concat(continuousFieldName,'"]'),as:"lower_"+continuousFieldName}]}else if(inputType==="aggregated-error"){tooltipSummary=[{fieldPrefix:"",titlePrefix:continuousFieldName}];postAggregateCalculates=[{calculate:'datum["'.concat(continuousFieldName,'"] + datum["').concat(continuousAxisChannelDefError.field,'"]'),as:"upper_"+continuousFieldName}];if(continuousAxisChannelDefError2){postAggregateCalculates.push({calculate:'datum["'.concat(continuousFieldName,'"] + datum["').concat(continuousAxisChannelDefError2.field,'"]'),as:"lower_"+continuousFieldName})}else{postAggregateCalculates.push({calculate:'datum["'.concat(continuousFieldName,'"] - datum["').concat(continuousAxisChannelDefError.field,'"]'),as:"lower_"+continuousFieldName})}}for(const postAggregateCalculate of postAggregateCalculates){tooltipSummary.push({fieldPrefix:postAggregateCalculate.as.substring(0,6),titlePrefix:replaceAll(replaceAll(postAggregateCalculate.calculate,'datum["',""),'"]',"")})}}return{postAggregateCalculates:postAggregateCalculates,errorBarSpecificAggregate:errorBarSpecificAggregate,tooltipSummary:tooltipSummary,tooltipTitleWithFieldName:tooltipTitleWithFieldName}}function getTitlePrefix(center,extent,operation){return titleCase(center)+" "+operation+" "+extent}const ERRORBAND="errorband";const ERRORBAND_PARTS=["band","borders"];const errorBandNormalizer=new CompositeMarkNormalizer(ERRORBAND,normalizeErrorBand);function normalizeErrorBand(spec,{config:config}){spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}=errorBarParams(spec,ERRORBAND,config);const errorBandDef=markDef;const makeErrorBandPart=makeCompositeAggregatePartFactory(errorBandDef,continuousAxis,continuousAxisChannelDef,encodingWithoutContinuousAxis,config.errorband);const is2D=spec.encoding.x!==undefined&&spec.encoding.y!==undefined;let bandMark={type:is2D?"area":"rect"};let bordersMark={type:is2D?"line":"rule"};const interpolate={...errorBandDef.interpolate?{interpolate:errorBandDef.interpolate}:{},...errorBandDef.tension&&errorBandDef.interpolate?{tension:errorBandDef.tension}:{}};if(is2D){bandMark={...bandMark,...interpolate,ariaRoleDescription:"errorband"};bordersMark={...bordersMark,...interpolate,aria:false}}else if(errorBandDef.interpolate){warn(errorBand1DNotSupport("interpolate"))}else if(errorBandDef.tension){warn(errorBand1DNotSupport("tension"))}return{...outerSpec,transform:transform,layer:[...makeErrorBandPart({partName:"band",mark:bandMark,positionPrefix:"lower",endPositionPrefix:"upper",extraEncoding:tooltipEncoding}),...makeErrorBandPart({partName:"borders",mark:bordersMark,positionPrefix:"lower",extraEncoding:tooltipEncoding}),...makeErrorBandPart({partName:"borders",mark:bordersMark,positionPrefix:"upper",extraEncoding:tooltipEncoding})]}}const compositeMarkRegistry={};function add(mark,run,parts){const normalizer=new CompositeMarkNormalizer(mark,run);compositeMarkRegistry[mark]={normalizer:normalizer,parts:parts}}function getAllCompositeMarks(){return keys(compositeMarkRegistry)}add(BOXPLOT,normalizeBoxPlot,BOXPLOT_PARTS);add(ERRORBAR,normalizeErrorBar,ERRORBAR_PARTS);add(ERRORBAND,normalizeErrorBand,ERRORBAND_PARTS);const VL_ONLY_LEGEND_CONFIG=["gradientHorizontalMaxLength","gradientHorizontalMinLength","gradientVerticalMaxLength","gradientVerticalMinLength","unselectedOpacity"];const HEADER_TITLE_PROPERTIES_MAP={titleAlign:"align",titleAnchor:"anchor",titleAngle:"angle",titleBaseline:"baseline",titleColor:"color",titleFont:"font",titleFontSize:"fontSize",titleFontStyle:"fontStyle",titleFontWeight:"fontWeight",titleLimit:"limit",titleLineHeight:"lineHeight",titleOrient:"orient",titlePadding:"offset"};const HEADER_LABEL_PROPERTIES_MAP={labelAlign:"align",labelAnchor:"anchor",labelAngle:"angle",labelBaseline:"baseline",labelColor:"color",labelFont:"font",labelFontSize:"fontSize",labelFontStyle:"fontStyle",labelFontWeight:"fontWeight",labelLimit:"limit",labelLineHeight:"lineHeight",labelOrient:"orient",labelPadding:"offset"};const HEADER_TITLE_PROPERTIES=keys(HEADER_TITLE_PROPERTIES_MAP);const HEADER_LABEL_PROPERTIES=keys(HEADER_LABEL_PROPERTIES_MAP);const HEADER_CONFIGS_INDEX={header:1,headerRow:1,headerColumn:1,headerFacet:1};const HEADER_CONFIGS=keys(HEADER_CONFIGS_INDEX);const LEGEND_SCALE_CHANNELS=["size","shape","fill","stroke","strokeDash","strokeWidth","opacity"];const defaultLegendConfig={gradientHorizontalMaxLength:200,gradientHorizontalMinLength:100,gradientVerticalMaxLength:200,gradientVerticalMinLength:64,unselectedOpacity:.35};const COMMON_LEGEND_PROPERTY_INDEX={aria:1,clipHeight:1,columnPadding:1,columns:1,cornerRadius:1,description:1,direction:1,fillColor:1,format:1,formatType:1,gradientLength:1,gradientOpacity:1,gradientStrokeColor:1,gradientStrokeWidth:1,gradientThickness:1,gridAlign:1,labelAlign:1,labelBaseline:1,labelColor:1,labelFont:1,labelFontSize:1,labelFontStyle:1,labelFontWeight:1,labelLimit:1,labelOffset:1,labelOpacity:1,labelOverlap:1,labelPadding:1,labelSeparation:1,legendX:1,legendY:1,offset:1,orient:1,padding:1,rowPadding:1,strokeColor:1,symbolDash:1,symbolDashOffset:1,symbolFillColor:1,symbolLimit:1,symbolOffset:1,symbolOpacity:1,symbolSize:1,symbolStrokeColor:1,symbolStrokeWidth:1,symbolType:1,tickCount:1,tickMinStep:1,title:1,titleAlign:1,titleAnchor:1,titleBaseline:1,titleColor:1,titleFont:1,titleFontSize:1,titleFontStyle:1,titleFontWeight:1,titleLimit:1,titleLineHeight:1,titleOpacity:1,titleOrient:1,titlePadding:1,type:1,values:1,zindex:1};function assembleParameterSignals(params){const signals=[];for(const param of params||[]){const{expr:expr,bind:bind,...rest}=param;if(bind&&expr){const signal={...rest,bind:bind,init:expr};signals.push(signal)}else{const signal={...rest,...expr?{update:expr}:{},...bind?{bind:bind}:{}};signals.push(signal)}}return signals}const SELECTION_ID="_vgsid_";const defaultConfig={single:{on:"click",fields:[SELECTION_ID],resolve:"global",empty:"all",clear:"dblclick"},multi:{on:"click",fields:[SELECTION_ID],toggle:"event.shiftKey",resolve:"global",empty:"all",clear:"dblclick"},interval:{on:"[mousedown, window:mouseup] > window:mousemove!",encodings:["x","y"],translate:"[mousedown, window:mouseup] > window:mousemove!",zoom:"wheel!",mark:{fill:"#333",fillOpacity:.125,stroke:"white"},resolve:"global",clear:"dblclick"}};function isLegendBinding(bind){return!!bind&&(bind==="legend"||!!bind.legend)}function isLegendStreamBinding(bind){return isLegendBinding(bind)&&isObject(bind)}function isAnyConcatSpec(spec){return isVConcatSpec(spec)||isHConcatSpec(spec)||isConcatSpec(spec)}function isConcatSpec(spec){return"concat"in spec}function isVConcatSpec(spec){return"vconcat"in spec}function isHConcatSpec(spec){return"hconcat"in spec}function isFitType(autoSizeType){return autoSizeType==="fit"||autoSizeType==="fit-x"||autoSizeType==="fit-y"}function getFitType(sizeType){return sizeType?"fit-".concat(getPositionScaleChannel(sizeType)):"fit"}const TOP_LEVEL_PROPERTIES=["background","padding"];function extractTopLevelProperties(t,includeParams){const o={};for(const p of TOP_LEVEL_PROPERTIES){if(t&&t[p]!==undefined){o[p]=signalRefOrValue(t[p])}}if(includeParams){o.params=t.params}return o}function isStep(size){return isObject(size)&&size["step"]!==undefined}function isFrameMixins(o){return o["view"]||o["width"]||o["height"]}const DEFAULT_SPACING=20;const COMPOSITION_LAYOUT_INDEX={align:1,bounds:1,center:1,columns:1,spacing:1};const COMPOSITION_LAYOUT_PROPERTIES=keys(COMPOSITION_LAYOUT_INDEX);function extractCompositionLayout(spec,specType,config){const compositionConfig=config[specType];const layout={};const{spacing:spacingConfig,columns:columns}=compositionConfig;if(spacingConfig!==undefined){layout.spacing=spacingConfig}if(columns!==undefined){if(isFacetSpec(spec)&&!isFacetMapping(spec.facet)||isConcatSpec(spec)){layout.columns=columns}}if(isVConcatSpec(spec)){layout.columns=1}for(const prop of COMPOSITION_LAYOUT_PROPERTIES){if(spec[prop]!==undefined){if(prop==="spacing"){var _spacing$row,_spacing$column;const spacing=spec[prop];layout[prop]=isNumber(spacing)?spacing:{row:(_spacing$row=spacing.row)!==null&&_spacing$row!==void 0?_spacing$row:spacingConfig,column:(_spacing$column=spacing.column)!==null&&_spacing$column!==void 0?_spacing$column:spacingConfig}}else{layout[prop]=spec[prop]}}}return layout}function getViewConfigContinuousSize(viewConfig,channel){var _viewConfig$channel;return(_viewConfig$channel=viewConfig[channel])!==null&&_viewConfig$channel!==void 0?_viewConfig$channel:viewConfig[channel==="width"?"continuousWidth":"continuousHeight"]}function getViewConfigDiscreteStep(viewConfig,channel){const size=getViewConfigDiscreteSize(viewConfig,channel);return isStep(size)?size.step:DEFAULT_STEP}function getViewConfigDiscreteSize(viewConfig,channel){var _viewConfig$channel2;const size=(_viewConfig$channel2=viewConfig[channel])!==null&&_viewConfig$channel2!==void 0?_viewConfig$channel2:viewConfig[channel==="width"?"discreteWidth":"discreteHeight"];return getFirstDefined(size,{step:viewConfig.step})}const DEFAULT_STEP=20;const defaultViewConfig={continuousWidth:200,continuousHeight:200,step:DEFAULT_STEP};const defaultConfig$1={background:"white",padding:5,timeFormat:"%b %d, %Y",countTitle:"Count of Records",view:defaultViewConfig,mark:defaultMarkConfig,arc:{},area:{},bar:defaultBarConfig,circle:{},geoshape:{},image:{},line:{},point:{},rect:defaultRectConfig,rule:{color:"black"},square:{},text:{color:"black"},tick:defaultTickConfig,trail:{},boxplot:{size:14,extent:1.5,box:{},median:{color:"white"},outliers:{},rule:{},ticks:null},errorbar:{center:"mean",rule:true,ticks:false},errorband:{band:{opacity:.3},borders:false},scale:defaultScaleConfig,projection:{},legend:defaultLegendConfig,header:{titlePadding:10,labelPadding:10},headerColumn:{},headerRow:{},headerFacet:{},selection:defaultConfig,style:{},title:{},facet:{spacing:DEFAULT_SPACING},concat:{spacing:DEFAULT_SPACING}};const tab10=["#4c78a8","#f58518","#e45756","#72b7b2","#54a24b","#eeca3b","#b279a2","#ff9da6","#9d755d","#bab0ac"];const DEFAULT_FONT_SIZE={text:11,guideLabel:10,guideTitle:11,groupTitle:13,groupSubtitle:12};const DEFAULT_COLOR={blue:tab10[0],orange:tab10[1],red:tab10[2],teal:tab10[3],green:tab10[4],yellow:tab10[5],purple:tab10[6],pink:tab10[7],brown:tab10[8],gray0:"#000",gray1:"#111",gray2:"#222",gray3:"#333",gray4:"#444",gray5:"#555",gray6:"#666",gray7:"#777",gray8:"#888",gray9:"#999",gray10:"#aaa",gray11:"#bbb",gray12:"#ccc",gray13:"#ddd",gray14:"#eee",gray15:"#fff"};function colorSignalConfig(color={}){return{signals:[{name:"color",value:isObject(color)?{...DEFAULT_COLOR,...color}:DEFAULT_COLOR}],mark:{color:{signal:"color.blue"}},rule:{color:{signal:"color.gray0"}},text:{color:{signal:"color.gray0"}},style:{"guide-label":{fill:{signal:"color.gray0"}},"guide-title":{fill:{signal:"color.gray0"}},"group-title":{fill:{signal:"color.gray0"}},"group-subtitle":{fill:{signal:"color.gray0"}},cell:{stroke:{signal:"color.gray8"}}},axis:{domainColor:{signal:"color.gray13"},gridColor:{signal:"color.gray8"},tickColor:{signal:"color.gray13"}},range:{category:[{signal:"color.blue"},{signal:"color.orange"},{signal:"color.red"},{signal:"color.teal"},{signal:"color.green"},{signal:"color.yellow"},{signal:"color.purple"},{signal:"color.pink"},{signal:"color.brown"},{signal:"color.grey8"}]}}}function fontSizeSignalConfig(fontSize){return{signals:[{name:"fontSize",value:isObject(fontSize)?{...DEFAULT_FONT_SIZE,...fontSize}:DEFAULT_FONT_SIZE}],text:{fontSize:{signal:"fontSize.text"}},style:{"guide-label":{fontSize:{signal:"fontSize.guideLabel"}},"guide-title":{fontSize:{signal:"fontSize.guideTitle"}},"group-title":{fontSize:{signal:"fontSize.groupTitle"}},"group-subtitle":{fontSize:{signal:"fontSize.groupSubtitle"}}}}}function fontConfig(font){return{text:{font:font},style:{"guide-label":{font:font},"guide-title":{font:font},"group-title":{font:font},"group-subtitle":{font:font}}}}function getAxisConfigInternal(axisConfig){const props=keys(axisConfig||{});const axisConfigInternal={};for(const prop of props){const val=axisConfig[prop];axisConfigInternal[prop]=isConditionalAxisValue(val)?signalOrValueRefWithCondition(val):signalRefOrValue(val)}return axisConfigInternal}function getStyleConfigInternal(styleConfig){const props=keys(styleConfig);const styleConfigInternal={};for(const prop of props){styleConfigInternal[prop]=getAxisConfigInternal(styleConfig[prop])}return styleConfigInternal}const configPropsWithExpr=[...MARK_CONFIGS,...AXIS_CONFIGS,...HEADER_CONFIGS,"background","padding","legend","lineBreak","scale","style","title","view"];function initConfig(specifiedConfig={}){const{color:color,font:font,fontSize:fontSize,...restConfig}=specifiedConfig;const mergedConfig=mergeConfig({},defaultConfig$1,font?fontConfig(font):{},color?colorSignalConfig(color):{},fontSize?fontSizeSignalConfig(fontSize):{},restConfig||{});const outputConfig=omit(mergedConfig,configPropsWithExpr);for(const prop of["background","lineBreak","padding"]){if(mergedConfig[prop]){outputConfig[prop]=signalRefOrValue(mergedConfig[prop])}}for(const markConfigType of MARK_CONFIGS){if(mergedConfig[markConfigType]){outputConfig[markConfigType]=replaceExprRefInIndex(mergedConfig[markConfigType])}}for(const axisConfigType of AXIS_CONFIGS){if(mergedConfig[axisConfigType]){outputConfig[axisConfigType]=getAxisConfigInternal(mergedConfig[axisConfigType])}}for(const headerConfigType of HEADER_CONFIGS){if(mergedConfig[headerConfigType]){outputConfig[headerConfigType]=replaceExprRefInIndex(mergedConfig[headerConfigType])}}if(mergedConfig.legend){outputConfig.legend=replaceExprRefInIndex(mergedConfig.legend)}if(mergedConfig.scale){outputConfig.scale=replaceExprRefInIndex(mergedConfig.scale)}if(mergedConfig.style){outputConfig.style=getStyleConfigInternal(mergedConfig.style)}if(mergedConfig.title){outputConfig.title=replaceExprRefInIndex(mergedConfig.title)}if(mergedConfig.view){outputConfig.view=replaceExprRefInIndex(mergedConfig.view)}return outputConfig}const MARK_STYLES=["view",...PRIMITIVE_MARKS];const VL_ONLY_CONFIG_PROPERTIES=["color","fontSize","background","padding","facet","concat","numberFormat","timeFormat","countTitle","header","axisQuantitative","axisTemporal","axisDiscrete","axisPoint","axisXBand","axisXPoint","axisXDiscrete","axisXQuantitative","axisXTemporal","axisYBand","axisYPoint","axisYDiscrete","axisYQuantitative","axisYTemporal","scale","selection","overlay"];const VL_ONLY_ALL_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX={view:["continuousWidth","continuousHeight","discreteWidth","discreteHeight","step"],...VL_ONLY_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX};function stripAndRedirectConfig(config){config=duplicate(config);for(const prop of VL_ONLY_CONFIG_PROPERTIES){delete config[prop]}if(config.axis){for(const prop in config.axis){if(isConditionalAxisValue(config.axis[prop])){delete config.axis[prop]}}}if(config.legend){for(const prop of VL_ONLY_LEGEND_CONFIG){delete config.legend[prop]}}if(config.mark){for(const prop of VL_ONLY_MARK_CONFIG_PROPERTIES){delete config.mark[prop]}if(config.mark.tooltip&&isObject(config.mark.tooltip)){delete config.mark.tooltip}}if(config.params){config.signals=(config.signals||[]).concat(assembleParameterSignals(config.params));delete config.params}for(const markType of MARK_STYLES){for(const prop of VL_ONLY_MARK_CONFIG_PROPERTIES){delete config[markType][prop]}const vlOnlyMarkSpecificConfigs=VL_ONLY_ALL_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX[markType];if(vlOnlyMarkSpecificConfigs){for(const prop of vlOnlyMarkSpecificConfigs){delete config[markType][prop]}}redirectConfigToStyleConfig(config,markType)}for(const m of getAllCompositeMarks()){delete config[m]}redirectTitleConfig(config);for(const prop in config){if(isObject(config[prop])&&isEmpty(config[prop])){delete config[prop]}}return isEmpty(config)?undefined:config}function redirectTitleConfig(config){const{titleMarkConfig:titleMarkConfig,subtitleMarkConfig:subtitleMarkConfig,subtitle:subtitle}=extractTitleConfig(config.title);if(!isEmpty(titleMarkConfig)){config.style["group-title"]={...config.style["group-title"],...titleMarkConfig}}if(!isEmpty(subtitleMarkConfig)){config.style["group-subtitle"]={...config.style["group-subtitle"],...subtitleMarkConfig}}if(!isEmpty(subtitle)){config.title=subtitle}else{delete config.title}}function redirectConfigToStyleConfig(config,prop,toProp,compositeMarkPart){var _toProp;const propConfig=compositeMarkPart?config[prop][compositeMarkPart]:config[prop];if(prop==="view"){toProp="cell"}const style={...propConfig,...config.style[(_toProp=toProp)!==null&&_toProp!==void 0?_toProp:prop]};if(!isEmpty(style)){var _toProp2;config.style[(_toProp2=toProp)!==null&&_toProp2!==void 0?_toProp2:prop]=style}if(!compositeMarkPart){delete config[prop]}}function isLayerSpec(spec){return"layer"in spec}function isRepeatSpec(spec){return"repeat"in spec}function isLayerRepeatSpec(spec){return!isArray(spec.repeat)&&spec.repeat["layer"]}class SpecMapper{map(spec,params){if(isFacetSpec(spec)){return this.mapFacet(spec,params)}else if(isRepeatSpec(spec)){return this.mapRepeat(spec,params)}else if(isHConcatSpec(spec)){return this.mapHConcat(spec,params)}else if(isVConcatSpec(spec)){return this.mapVConcat(spec,params)}else if(isConcatSpec(spec)){return this.mapConcat(spec,params)}else{return this.mapLayerOrUnit(spec,params)}}mapLayerOrUnit(spec,params){if(isLayerSpec(spec)){return this.mapLayer(spec,params)}else if(isUnitSpec(spec)){return this.mapUnit(spec,params)}throw new Error(invalidSpec(spec))}mapLayer(spec,params){return{...spec,layer:spec.layer.map(subspec=>this.mapLayerOrUnit(subspec,params))}}mapHConcat(spec,params){return{...spec,hconcat:spec.hconcat.map(subspec=>this.map(subspec,params))}}mapVConcat(spec,params){return{...spec,vconcat:spec.vconcat.map(subspec=>this.map(subspec,params))}}mapConcat(spec,params){const{concat:concat,...rest}=spec;return{...rest,concat:concat.map(subspec=>this.map(subspec,params))}}mapFacet(spec,params){return{...spec,spec:this.map(spec.spec,params)}}mapRepeat(spec,params){return{...spec,spec:this.map(spec.spec,params)}}}const STACK_OFFSET_INDEX={zero:1,center:1,normalize:1};function isStackOffset(s){return s in STACK_OFFSET_INDEX}const STACKABLE_MARKS=new Set([ARC,BAR,AREA,RULE,POINT,CIRCLE,SQUARE,LINE,TEXT$1,TICK]);const STACK_BY_DEFAULT_MARKS=new Set([BAR,AREA,ARC]);function potentialStackedChannel(encoding,x){const y=x==="x"?"y":"radius";const xDef=encoding[x];const yDef=encoding[y];if(isFieldDef(xDef)&&isFieldDef(yDef)){if(channelDefType(xDef)==="quantitative"&&channelDefType(yDef)==="quantitative"){if(xDef.stack){return x}else if(yDef.stack){return y}const xAggregate=isFieldDef(xDef)&&!!xDef.aggregate;const yAggregate=isFieldDef(yDef)&&!!yDef.aggregate;if(xAggregate!==yAggregate){return xAggregate?x:y}else{var _xDef$scale,_yDef$scale;const xScale=(_xDef$scale=xDef.scale)===null||_xDef$scale===void 0?void 0:_xDef$scale.type;const yScale=(_yDef$scale=yDef.scale)===null||_yDef$scale===void 0?void 0:_yDef$scale.type;if(xScale&&xScale!=="linear"){return y}else if(yScale&&yScale!=="linear"){return x}}}else if(channelDefType(xDef)==="quantitative"){return x}else if(channelDefType(yDef)==="quantitative"){return y}}else if(channelDefType(xDef)==="quantitative"){return x}else if(channelDefType(yDef)==="quantitative"){return y}return undefined}function getDimensionChannel(channel){switch(channel){case"x":return"y";case"y":return"x";case"theta":return"radius";case"radius":return"theta"}}function stack(m,encoding,opt={}){const mark=isMarkDef(m)?m.type:m;if(!STACKABLE_MARKS.has(mark)){return null}const fieldChannel=potentialStackedChannel(encoding,"x")||potentialStackedChannel(encoding,"theta");if(!fieldChannel){return null}const stackedFieldDef=encoding[fieldChannel];const stackedField=isFieldDef(stackedFieldDef)?vgField(stackedFieldDef,{}):undefined;let dimensionChannel=getDimensionChannel(fieldChannel);let dimensionDef=encoding[dimensionChannel];let dimensionField=isFieldDef(dimensionDef)?vgField(dimensionDef,{}):undefined;if(dimensionField===stackedField){dimensionField=undefined;dimensionDef=undefined;dimensionChannel=undefined}const stackBy=NONPOSITION_CHANNELS.reduce((sc,channel)=>{if(channel!=="tooltip"&&channelHasField(encoding,channel)){const channelDef=encoding[channel];for(const cDef of array(channelDef)){const fieldDef=getFieldDef(cDef);if(fieldDef.aggregate){continue}const f=vgField(fieldDef,{});if(!f||f!==dimensionField){sc.push({channel:channel,fieldDef:fieldDef})}}}return sc},[]);let offset;if(stackedFieldDef.stack!==undefined){if(isBoolean(stackedFieldDef.stack)){offset=stackedFieldDef.stack?"zero":null}else{offset=stackedFieldDef.stack}}else if(stackBy.length>0&&STACK_BY_DEFAULT_MARKS.has(mark)){offset="zero"}if(!offset||!isStackOffset(offset)){return null}if(isAggregate(encoding)&&stackBy.length===0){return null}if(stackedFieldDef.scale&&stackedFieldDef.scale.type&&stackedFieldDef.scale.type!==ScaleType.LINEAR){if(opt.disallowNonLinearStack){return null}else{warn(cannotStackNonLinearScale(stackedFieldDef.scale.type))}}if(isFieldOrDatumDef(encoding[getSecondaryRangeChannel(fieldChannel)])){if(stackedFieldDef.stack!==undefined){warn(cannotStackRangedMark(fieldChannel))}return null}if(isFieldDef(stackedFieldDef)&&stackedFieldDef.aggregate&&!contains(SUM_OPS,stackedFieldDef.aggregate)){warn(stackNonSummativeAggregate(stackedFieldDef.aggregate))}return{groupbyChannel:dimensionDef?dimensionChannel:undefined,groupbyField:dimensionField,fieldChannel:fieldChannel,impute:stackedFieldDef.impute===null?false:isPathMark(mark),stackBy:stackBy,offset:offset}}function dropLineAndPoint(markDef){const{point:_point,line:_line,...mark}=markDef;return keys(mark).length>1?mark:mark.type}function dropLineAndPointFromConfig(config){for(const mark of["line","area","rule","trail"]){if(config[mark]){config={...config,[mark]:omit(config[mark],["point","line"])}}}return config}function getPointOverlay(markDef,markConfig={},encoding){if(markDef.point==="transparent"){return{opacity:0}}else if(markDef.point){return isObject(markDef.point)?markDef.point:{}}else if(markDef.point!==undefined){return null}else{if(markConfig.point||encoding.shape){return isObject(markConfig.point)?markConfig.point:{}}return undefined}}function getLineOverlay(markDef,markConfig={}){if(markDef.line){return markDef.line===true?{}:markDef.line}else if(markDef.line!==undefined){return null}else{if(markConfig.line){return markConfig.line===true?{}:markConfig.line}return undefined}}class PathOverlayNormalizer{constructor(){_defineProperty(this,"name","path-overlay")}hasMatchingType(spec,config){if(isUnitSpec(spec)){const{mark:mark,encoding:encoding}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};switch(markDef.type){case"line":case"rule":case"trail":return!!getPointOverlay(markDef,config[markDef.type],encoding);case"area":return!!getPointOverlay(markDef,config[markDef.type],encoding)||!!getLineOverlay(markDef,config[markDef.type])}}return false}run(spec,params,normalize){const{config:config}=params;const{selection:selection,projection:projection,mark:mark,encoding:e,...outerSpec}=spec;const encoding=normalizeEncoding(e,config);const markDef=isMarkDef(mark)?mark:{type:mark};const pointOverlay=getPointOverlay(markDef,config[markDef.type],encoding);const lineOverlay=markDef.type==="area"&&getLineOverlay(markDef,config[markDef.type]);const layer=[{...selection?{selection:selection}:{},mark:dropLineAndPoint({...markDef.type==="area"&&markDef.opacity===undefined&&markDef.fillOpacity===undefined?{opacity:.7}:{},...markDef}),encoding:omit(encoding,["shape"])}];const stackProps=stack(markDef,encoding);let overlayEncoding=encoding;if(stackProps){const{fieldChannel:stackFieldChannel,offset:offset}=stackProps;overlayEncoding={...encoding,[stackFieldChannel]:{...encoding[stackFieldChannel],...offset?{stack:offset}:{}}}}if(lineOverlay){layer.push({...projection?{projection:projection}:{},mark:{type:"line",...pick(markDef,["clip","interpolate","tension","tooltip"]),...lineOverlay},encoding:overlayEncoding})}if(pointOverlay){layer.push({...projection?{projection:projection}:{},mark:{type:"point",opacity:1,filled:true,...pick(markDef,["clip","tooltip"]),...pointOverlay},encoding:overlayEncoding})}return normalize({...outerSpec,layer:layer},{...params,config:dropLineAndPointFromConfig(config)})}}class RangeStepNormalizer{constructor(){_defineProperty(this,"name","RangeStep")}hasMatchingType(spec){if(isUnitSpec(spec)&&spec.encoding){for(const channel of POSITION_SCALE_CHANNELS){const def=spec.encoding[channel];if(def&&isFieldOrDatumDef(def)){var _def$scale;if(def===null||def===void 0?void 0:(_def$scale=def.scale)===null||_def$scale===void 0?void 0:_def$scale["rangeStep"]){return true}}}}return false}run(spec){const sizeMixins={};let encoding={...spec.encoding};for(const channel of POSITION_SCALE_CHANNELS){const sizeType=getSizeChannel(channel);const def=encoding[channel];if(def&&isFieldOrDatumDef(def)){var _def$scale2;if(def===null||def===void 0?void 0:(_def$scale2=def.scale)===null||_def$scale2===void 0?void 0:_def$scale2["rangeStep"]){const{scale:scale,...defWithoutScale}=def;const{rangeStep:rangeStep,...scaleWithoutRangeStep}=scale;sizeMixins[sizeType]={step:scale["rangeStep"]};warn(RANGE_STEP_DEPRECATED);encoding={...encoding,[channel]:{...defWithoutScale,...isEmpty(scaleWithoutRangeStep)?{}:{scale:scaleWithoutRangeStep}}}}}}return{...sizeMixins,...spec,encoding:encoding}}}function replaceRepeaterInFacet(facet,repeater){if(!repeater){return facet}if(isFacetMapping(facet)){return replaceRepeaterInMapping(facet,repeater)}return replaceRepeaterInFieldDef(facet,repeater)}function replaceRepeaterInEncoding(encoding,repeater){if(!repeater){return encoding}return replaceRepeaterInMapping(encoding,repeater)}function replaceRepeatInProp(prop,o,repeater){const val=o[prop];if(isRepeatRef(val)){if(val.repeat in repeater){return{...o,[prop]:repeater[val.repeat]}}else{warn(noSuchRepeatedValue(val.repeat));return undefined}}return o}function replaceRepeaterInFieldDef(fieldDef,repeater){fieldDef=replaceRepeatInProp("field",fieldDef,repeater);if(fieldDef===undefined){return undefined}else if(fieldDef===null){return null}if(isSortableFieldDef(fieldDef)&&isSortField(fieldDef.sort)){const sort=replaceRepeatInProp("field",fieldDef.sort,repeater);fieldDef={...fieldDef,...sort?{sort:sort}:{}}}return fieldDef}function replaceRepeaterInFieldOrDatumDef(def,repeater){if(isFieldDef(def)){return replaceRepeaterInFieldDef(def,repeater)}else{const datumDef=replaceRepeatInProp("datum",def,repeater);if(datumDef!==def&&!datumDef.type){datumDef.type="nominal"}return datumDef}}function replaceRepeaterInChannelDef(channelDef,repeater){if(isFieldOrDatumDef(channelDef)){const fd=replaceRepeaterInFieldOrDatumDef(channelDef,repeater);if(fd){return fd}else if(isConditionalDef(channelDef)){return{condition:channelDef.condition}}}else{if(hasConditionalFieldOrDatumDef(channelDef)){const fd=replaceRepeaterInFieldOrDatumDef(channelDef.condition,repeater);if(fd){return{...channelDef,condition:fd}}else{const{condition:condition,...channelDefWithoutCondition}=channelDef;return channelDefWithoutCondition}}return channelDef}return undefined}function replaceRepeaterInMapping(mapping,repeater){const out={};for(const channel in mapping){if(has(mapping,channel)){const channelDef=mapping[channel];if(isArray(channelDef)){out[channel]=channelDef.map(cd=>replaceRepeaterInChannelDef(cd,repeater)).filter(cd=>cd)}else{const cd=replaceRepeaterInChannelDef(channelDef,repeater);if(cd!==undefined){out[channel]=cd}}}}return out}class RuleForRangedLineNormalizer{constructor(){_defineProperty(this,"name","RuleForRangedLine")}hasMatchingType(spec){if(isUnitSpec(spec)){const{encoding:encoding,mark:mark}=spec;if(mark==="line"){for(const channel of SECONDARY_RANGE_CHANNEL){const mainChannel=getMainRangeChannel(channel);const mainChannelDef=encoding[mainChannel];if(encoding[channel]){if(isFieldDef(mainChannelDef)&&!isBinned(mainChannelDef.bin)||isDatumDef(mainChannelDef)){return true}}}}}return false}run(spec,params,normalize){const{encoding:encoding}=spec;warn(lineWithRange(!!encoding.x2,!!encoding.y2));return normalize({...spec,mark:"rule"},params)}}class CoreNormalizer extends SpecMapper{constructor(...args){super(...args);_defineProperty(this,"nonFacetUnitNormalizers",[boxPlotNormalizer,errorBarNormalizer,errorBandNormalizer,new PathOverlayNormalizer,new RuleForRangedLineNormalizer,new RangeStepNormalizer])}map(spec,params){if(isUnitSpec(spec)){const hasRow=channelHasField(spec.encoding,ROW);const hasColumn=channelHasField(spec.encoding,COLUMN);const hasFacet=channelHasField(spec.encoding,FACET);if(hasRow||hasColumn||hasFacet){return this.mapFacetedUnit(spec,params)}}return super.map(spec,params)}mapUnit(spec,params){const{parentEncoding:parentEncoding,parentProjection:parentProjection}=params;const encoding=replaceRepeaterInEncoding(spec.encoding,params.repeater);const specWithReplacedEncoding={...spec,...encoding?{encoding:encoding}:{}};if(parentEncoding||parentProjection){return this.mapUnitWithParentEncodingOrProjection(specWithReplacedEncoding,params)}const normalizeLayerOrUnit=this.mapLayerOrUnit.bind(this);for(const unitNormalizer of this.nonFacetUnitNormalizers){if(unitNormalizer.hasMatchingType(specWithReplacedEncoding,params.config)){return unitNormalizer.run(specWithReplacedEncoding,params,normalizeLayerOrUnit)}}return specWithReplacedEncoding}mapRepeat(spec,params){if(isLayerRepeatSpec(spec)){return this.mapLayerRepeat(spec,params)}else{return this.mapNonLayerRepeat(spec,params)}}mapLayerRepeat(spec,params){const{repeat:repeat,spec:childSpec,...rest}=spec;const{row:row,column:column,layer:layer}=repeat;const{repeater:repeater={},repeaterPrefix:repeaterPrefix=""}=params;if(row||column){return this.mapRepeat({...spec,repeat:{...row?{row:row}:{},...column?{column:column}:{}},spec:{repeat:{layer:layer},spec:childSpec}},params)}else{return{...rest,layer:layer.map(layerValue=>{const childRepeater={...repeater,layer:layerValue};const childName=(childSpec.name||"")+repeaterPrefix+"child__layer_".concat(varName(layerValue));const child=this.mapLayerOrUnit(childSpec,{...params,repeater:childRepeater,repeaterPrefix:childName});child.name=childName;return child})}}}mapNonLayerRepeat(spec,params){var _childSpec$data;const{repeat:repeat,spec:childSpec,data:data,...remainingProperties}=spec;if(!isArray(repeat)&&spec.columns){spec=omit(spec,["columns"]);warn(columnsNotSupportByRowCol("repeat"))}const concat=[];const{repeater:repeater={},repeaterPrefix:repeaterPrefix=""}=params;const row=!isArray(repeat)&&repeat.row||[repeater?repeater.row:null];const column=!isArray(repeat)&&repeat.column||[repeater?repeater.column:null];const repeatValues=isArray(repeat)&&repeat||[repeater?repeater.repeat:null];for(const repeatValue of repeatValues){for(const rowValue of row){for(const columnValue of column){const childRepeater={repeat:repeatValue,row:rowValue,column:columnValue,layer:repeater.layer};const childName=(childSpec.name||"")+repeaterPrefix+"child__"+(isArray(repeat)?"".concat(varName(repeatValue)):(repeat.row?"row_".concat(varName(rowValue)):"")+(repeat.column?"column_".concat(varName(columnValue)):""));const child=this.map(childSpec,{...params,repeater:childRepeater,repeaterPrefix:childName});child.name=childName;concat.push(omit(child,["data"]))}}}const columns=isArray(repeat)?spec.columns:repeat.column?repeat.column.length:1;return{data:(_childSpec$data=childSpec.data)!==null&&_childSpec$data!==void 0?_childSpec$data:data,align:"all",...remainingProperties,columns:columns,concat:concat}}mapFacet(spec,params){const{facet:facet}=spec;if(isFacetMapping(facet)&&spec.columns){spec=omit(spec,["columns"]);warn(columnsNotSupportByRowCol("facet"))}return super.mapFacet(spec,params)}mapUnitWithParentEncodingOrProjection(spec,params){const{encoding:encoding,projection:projection}=spec;const{parentEncoding:parentEncoding,parentProjection:parentProjection,config:config}=params;const mergedProjection=mergeProjection({parentProjection:parentProjection,projection:projection});const mergedEncoding=mergeEncoding({parentEncoding:parentEncoding,encoding:replaceRepeaterInEncoding(encoding,params.repeater)});return this.mapUnit({...spec,...mergedProjection?{projection:mergedProjection}:{},...mergedEncoding?{encoding:mergedEncoding}:{}},{config:config})}mapFacetedUnit(spec,params){const{row:row,column:column,facet:facet,...encoding}=spec.encoding;const{mark:mark,width:width,projection:projection,height:height,view:view,selection:selection,encoding:_,...outerSpec}=spec;const{facetMapping:facetMapping,layout:layout}=this.getFacetMappingAndLayout({row:row,column:column,facet:facet},params);const newEncoding=replaceRepeaterInEncoding(encoding,params.repeater);return this.mapFacet({...outerSpec,...layout,facet:facetMapping,spec:{...width?{width:width}:{},...height?{height:height}:{},...view?{view:view}:{},...projection?{projection:projection}:{},mark:mark,encoding:newEncoding,...selection?{selection:selection}:{}}},params)}getFacetMappingAndLayout(facets,params){const{row:row,column:column,facet:facet}=facets;if(row||column){if(facet){warn(facetChannelDropped([...row?[ROW]:[],...column?[COLUMN]:[]]))}const facetMapping={};const layout={};for(const channel of[ROW,COLUMN]){const def=facets[channel];if(def){const{align:align,center:center,spacing:spacing,columns:columns,...defWithoutLayout}=def;facetMapping[channel]=defWithoutLayout;for(const prop of["align","center","spacing"]){if(def[prop]!==undefined){var _layout$prop;layout[prop]=(_layout$prop=layout[prop])!==null&&_layout$prop!==void 0?_layout$prop:{};layout[prop][channel]=def[prop]}}}}return{facetMapping:facetMapping,layout:layout}}else{const{align:align,center:center,spacing:spacing,columns:columns,...facetMapping}=facet;return{facetMapping:replaceRepeaterInFacet(facetMapping,params.repeater),layout:{...align?{align:align}:{},...center?{center:center}:{},...spacing?{spacing:spacing}:{},...columns?{columns:columns}:{}}}}}mapLayer(spec,{parentEncoding:parentEncoding,parentProjection:parentProjection,...otherParams}){const{encoding:encoding,projection:projection,...rest}=spec;const params={...otherParams,parentEncoding:mergeEncoding({parentEncoding:parentEncoding,encoding:encoding,layer:true}),parentProjection:mergeProjection({parentProjection:parentProjection,projection:projection})};return super.mapLayer(rest,params)}}function mergeEncoding({parentEncoding:parentEncoding,encoding:encoding={},layer:layer}){let merged={};if(parentEncoding){const channels=new Set([...keys(parentEncoding),...keys(encoding)]);for(const channel of channels){const channelDef=encoding[channel];const parentChannelDef=parentEncoding[channel];if(isFieldOrDatumDef(channelDef)){const mergedChannelDef={...parentChannelDef,...channelDef};merged[channel]=mergedChannelDef}else if(hasConditionalFieldOrDatumDef(channelDef)){merged[channel]={...channelDef,condition:{...parentChannelDef,...channelDef.condition}}}else if(channelDef||channelDef===null){merged[channel]=channelDef}else if(layer||isValueDef(parentChannelDef)||isSignalRef(parentChannelDef)||isFieldOrDatumDef(parentChannelDef)||isArray(parentChannelDef)){merged[channel]=parentChannelDef}}}else{merged=encoding}return!merged||isEmpty(merged)?undefined:merged}function mergeProjection(opt){const{parentProjection:parentProjection,projection:projection}=opt;if(parentProjection&&projection){warn(projectionOverridden({parentProjection:parentProjection,projection:projection}))}return projection!==null&&projection!==void 0?projection:parentProjection}function normalize(spec,config){if(config===undefined){config=initConfig(spec.config)}const normalizedSpec=normalizeGenericSpec(spec,config);const{width:width,height:height}=spec;const autosize=normalizeAutoSize(normalizedSpec,{width:width,height:height,autosize:spec.autosize},config);return{...normalizedSpec,...autosize?{autosize:autosize}:{}}}const normalizer=new CoreNormalizer;function normalizeGenericSpec(spec,config={}){return normalizer.map(spec,{config:config})}function _normalizeAutoSize(autosize){return isString(autosize)?{type:autosize}:autosize!==null&&autosize!==void 0?autosize:{}}function normalizeAutoSize(spec,sizeInfo,config){let{width:width,height:height}=sizeInfo;const isFitCompatible=isUnitSpec(spec)||isLayerSpec(spec);const autosizeDefault={};if(!isFitCompatible){if(width=="container"){warn(containerSizeNonSingle("width"));width=undefined}if(height=="container"){warn(containerSizeNonSingle("height"));height=undefined}}else{if(width=="container"&&height=="container"){autosizeDefault.type="fit";autosizeDefault.contains="padding"}else if(width=="container"){autosizeDefault.type="fit-x";autosizeDefault.contains="padding"}else if(height=="container"){autosizeDefault.type="fit-y";autosizeDefault.contains="padding"}}const autosize={type:"pad",...autosizeDefault,...config?_normalizeAutoSize(config.autosize):{},..._normalizeAutoSize(spec.autosize)};if(autosize.type==="fit"&&!isFitCompatible){warn(FIT_NON_SINGLE);autosize.type="pad"}if(width=="container"&&!(autosize.type=="fit"||autosize.type=="fit-x")){warn(containerSizeNotCompatibleWithAutosize("width"))}if(height=="container"&&!(autosize.type=="fit"||autosize.type=="fit-y")){warn(containerSizeNotCompatibleWithAutosize("height"))}if(deepEqual(autosize,{type:"pad"})){return undefined}return autosize}class Split{constructor(explicit={},implicit={}){this.explicit=explicit;this.implicit=implicit}clone(){return new Split(duplicate(this.explicit),duplicate(this.implicit))}combine(){return{...this.explicit,...this.implicit}}get(key){return getFirstDefined(this.explicit[key],this.implicit[key])}getWithExplicit(key){if(this.explicit[key]!==undefined){return{explicit:true,value:this.explicit[key]}}else if(this.implicit[key]!==undefined){return{explicit:false,value:this.implicit[key]}}return{explicit:false,value:undefined}}setWithExplicit(key,value){if(value.value!==undefined){this.set(key,value.value,value.explicit)}}set(key,value,explicit){delete this[explicit?"implicit":"explicit"][key];this[explicit?"explicit":"implicit"][key]=value;return this}copyKeyFromSplit(key,s){if(s.explicit[key]!==undefined){this.set(key,s.explicit[key],true)}else if(s.implicit[key]!==undefined){this.set(key,s.implicit[key],false)}}copyKeyFromObject(key,s){if(s[key]!==undefined){this.set(key,s[key],true)}}copyAll(other){for(const key of keys(other.combine())){const val=other.getWithExplicit(key);this.setWithExplicit(key,val)}}}function makeExplicit(value){return{explicit:true,value:value}}function makeImplicit(value){return{explicit:false,value:value}}function tieBreakByComparing(compare){return(v1,v2,property,propertyOf)=>{const diff=compare(v1.value,v2.value);if(diff>0){return v1}else if(diff<0){return v2}return defaultTieBreaker(v1,v2,property,propertyOf)}}function defaultTieBreaker(v1,v2,property,propertyOf){if(v1.explicit&&v2.explicit){warn(mergeConflictingProperty(property,propertyOf,v1.value,v2.value))}return v1}function mergeValuesWithExplicit(v1,v2,property,propertyOf,tieBreaker=defaultTieBreaker){if(v1===undefined||v1.value===undefined){return v2}if(v1.explicit&&!v2.explicit){return v1}else if(v2.explicit&&!v1.explicit){return v2}else if(deepEqual(v1.value,v2.value)){return v1}else{return tieBreaker(v1,v2,property,propertyOf)}}class AncestorParse extends Split{constructor(explicit={},implicit={},parseNothing=false){super(explicit,implicit);this.explicit=explicit;this.implicit=implicit;this.parseNothing=parseNothing}clone(){const clone=super.clone();clone.parseNothing=this.parseNothing;return clone}}function isUrlData(data){return"url"in data}function isInlineData(data){return"values"in data}function isNamedData(data){return"name"in data&&!isUrlData(data)&&!isInlineData(data)&&!isGenerator(data)}function isGenerator(data){return data&&(isSequenceGenerator(data)||isSphereGenerator(data)||isGraticuleGenerator(data))}function isSequenceGenerator(data){return"sequence"in data}function isSphereGenerator(data){return"sphere"in data}function isGraticuleGenerator(data){return"graticule"in data}let DataSourceType;(function(DataSourceType){DataSourceType[DataSourceType["Raw"]=0]="Raw";DataSourceType[DataSourceType["Main"]=1]="Main";DataSourceType[DataSourceType["Row"]=2]="Row";DataSourceType[DataSourceType["Column"]=3]="Column";DataSourceType[DataSourceType["Lookup"]=4]="Lookup"})(DataSourceType||(DataSourceType={}));function isFilter(t){return"filter"in t}function isImputeSequence(t){return(t===null||t===void 0?void 0:t["stop"])!==undefined}function isLookup(t){return"lookup"in t}function isLookupData(from){return"data"in from}function isLookupSelection(from){return"selection"in from}function isPivot(t){return"pivot"in t}function isDensity(t){return"density"in t}function isQuantile(t){return"quantile"in t}function isRegression(t){return"regression"in t}function isLoess(t){return"loess"in t}function isSample(t){return"sample"in t}function isWindow(t){return"window"in t}function isJoinAggregate(t){return"joinaggregate"in t}function isFlatten(t){return"flatten"in t}function isCalculate(t){return"calculate"in t}function isBin(t){return"bin"in t}function isImpute(t){return"impute"in t}function isTimeUnit(t){return"timeUnit"in t}function isAggregate$1(t){return"aggregate"in t}function isStack(t){return"stack"in t}function isFold(t){return"fold"in t}function normalizeTransform(transform){return transform.map(t=>{if(isFilter(t)){return{filter:normalizeLogicalComposition(t.filter,normalizePredicate)}}return t})}const VIEW="view",LBRACK="[",RBRACK="]",LBRACE="{",RBRACE="}",COLON=":",COMMA=",",NAME="@",GT=">",ILLEGAL=/[[\]{}]/,DEFAULT_MARKS={"*":1,arc:1,area:1,group:1,image:1,line:1,path:1,rect:1,rule:1,shape:1,symbol:1,text:1,trail:1};let DEFAULT_SOURCE,MARKS;function eventSelector(selector,source,marks){DEFAULT_SOURCE=source||VIEW;MARKS=marks||DEFAULT_MARKS;return parseMerge(selector.trim()).map(parseSelector)}function isMarkType(type){return MARKS[type]}function find(s,i,endChar,pushChar,popChar){const n=s.length;let count=0,c;for(;i<n;++i){c=s[i];if(!count&&c===endChar)return i;else if(popChar&&popChar.indexOf(c)>=0)--count;else if(pushChar&&pushChar.indexOf(c)>=0)++count}return i}function parseMerge(s){const output=[],n=s.length;let start=0,i=0;while(i<n){i=find(s,i,COMMA,LBRACK+LBRACE,RBRACK+RBRACE);output.push(s.substring(start,i).trim());start=++i}if(output.length===0){throw"Empty event selector: "+s}return output}function parseSelector(s){return s[0]==="["?parseBetween(s):parseStream(s)}function parseBetween(s){const n=s.length;let i=1,b;i=find(s,i,RBRACK,LBRACK,RBRACK);if(i===n){throw"Empty between selector: "+s}b=parseMerge(s.substring(1,i));if(b.length!==2){throw"Between selector must have two elements: "+s}s=s.slice(i+1).trim();if(s[0]!==GT){throw"Expected '>' after between selector: "+s}b=b.map(parseSelector);const stream=parseSelector(s.slice(1).trim());if(stream.between){return{between:b,stream:stream}}else{stream.between=b}return stream}function parseStream(s){const stream={source:DEFAULT_SOURCE},source=[];let throttle=[0,0],markname=0,start=0,n=s.length,i=0,j,filter;if(s[n-1]===RBRACE){i=s.lastIndexOf(LBRACE);if(i>=0){try{throttle=parseThrottle(s.substring(i+1,n-1))}catch(e){throw"Invalid throttle specification: "+s}s=s.slice(0,i).trim();n=s.length}else throw"Unmatched right brace: "+s;i=0}if(!n)throw s;if(s[0]===NAME)markname=++i;j=find(s,i,COLON);if(j<n){source.push(s.substring(start,j).trim());start=i=++j}i=find(s,i,LBRACK);if(i===n){source.push(s.substring(start,n).trim())}else{source.push(s.substring(start,i).trim());filter=[];start=++i;if(start===n)throw"Unmatched left bracket: "+s}while(i<n){i=find(s,i,RBRACK);if(i===n)throw"Unmatched left bracket: "+s;filter.push(s.substring(start,i).trim());if(i<n-1&&s[++i]!==LBRACK)throw"Expected left bracket: "+s;start=++i}if(!(n=source.length)||ILLEGAL.test(source[n-1])){throw"Invalid event selector: "+s}if(n>1){stream.type=source[1];if(markname){stream.markname=source[0].slice(1)}else if(isMarkType(source[0])){stream.marktype=source[0]}else{stream.source=source[0]}}else{stream.type=source[0]}if(stream.type.slice(-1)==="!"){stream.consume=true;stream.type=stream.type.slice(0,-1)}if(filter!=null)stream.filter=filter;if(throttle[0])stream.throttle=throttle[0];if(throttle[1])stream.debounce=throttle[1];return stream}function parseThrottle(s){const a=s.split(COMMA);if(!s.length||a.length>2)throw s;return a.map(_=>{const x=+_;if(x!==x)throw s;return x})}function wrapCondition(model,channelDef,vgChannel,refFn){const condition=isConditionalDef(channelDef)&&channelDef.condition;const valueRef=refFn(channelDef);if(condition){const conditions=array(condition);const vgConditions=conditions.map(c=>{const conditionValueRef=refFn(c);const test=isConditionalSelection(c)?parseSelectionPredicate(model,c.selection):expression(model,c.test);return{test:test,...conditionValueRef}});return{[vgChannel]:[...vgConditions,...valueRef!==undefined?[valueRef]:[]]}}else{return valueRef!==undefined?{[vgChannel]:valueRef}:{}}}function text(model,channel="text"){const channelDef=model.encoding[channel];return wrapCondition(model,channelDef,channel,cDef=>textRef(cDef,model.config))}function textRef(channelDef,config,expr="datum"){if(channelDef){if(isValueDef(channelDef)){return signalOrValueRef(channelDef.value)}if(isFieldOrDatumDef(channelDef)){const{format:format,formatType:formatType}=getFormatMixins(channelDef);return formatSignalRef({fieldOrDatumDef:channelDef,format:format,formatType:formatType,expr:expr,config:config})}}return undefined}function tooltip(model,opt={}){const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding.tooltip;if(isArray(channelDef)){return{tooltip:tooltipRefForEncoding({tooltip:channelDef},stack,config,opt)}}else{const datum=opt.reactiveGeom?"datum.datum":"datum";return wrapCondition(model,channelDef,"tooltip",cDef=>{const tooltipRefFromChannelDef=textRef(cDef,config,datum);if(tooltipRefFromChannelDef){return tooltipRefFromChannelDef}if(cDef===null){return undefined}let markTooltip=getMarkPropOrConfig("tooltip",markDef,config);if(markTooltip===true){markTooltip={content:"encoding"}}if(isString(markTooltip)){return{value:markTooltip}}else if(isObject(markTooltip)){if(isSignalRef(markTooltip)){return markTooltip}else if(markTooltip.content==="encoding"){return tooltipRefForEncoding(encoding,stack,config,opt)}else{return{signal:datum}}}return undefined})}}function tooltipData(encoding,stack,config,{reactiveGeom:reactiveGeom}={}){const toSkip={};const expr=reactiveGeom?"datum.datum":"datum";const tuples=[];function add(fDef,channel){var _value;const mainChannel=getMainRangeChannel(channel);const fieldDef=isTypedFieldDef(fDef)?fDef:{...fDef,type:encoding[mainChannel].type};const title=fieldDef.title||defaultTitle(fieldDef,config);const key=array(title).join(", ");let value;if(isXorY(channel)){const channel2=channel==="x"?"x2":"y2";const fieldDef2=getFieldDef(encoding[channel2]);if(isBinned(fieldDef.bin)&&fieldDef2){const startField=vgField(fieldDef,{expr:expr});const endField=vgField(fieldDef2,{expr:expr});const{format:format,formatType:formatType}=getFormatMixins(fieldDef);value=binFormatExpression(startField,endField,format,formatType,config);toSkip[channel2]=true}else if(stack&&stack.fieldChannel===channel&&stack.offset==="normalize"){const{format:format,formatType:formatType}=getFormatMixins(fieldDef);value=formatSignalRef({fieldOrDatumDef:fieldDef,format:format,formatType:formatType,expr:expr,config:config,normalizeStack:true}).signal}}value=(_value=value)!==null&&_value!==void 0?_value:textRef(fieldDef,config,expr).signal;tuples.push({channel:channel,key:key,value:value})}forEach(encoding,(channelDef,channel)=>{if(isFieldDef(channelDef)){add(channelDef,channel)}else if(hasConditionalFieldDef(channelDef)){add(channelDef.condition,channel)}});const out={};for(const{channel:channel,key:key,value:value}of tuples){if(!toSkip[channel]&&!out[key]){out[key]=value}}return out}function tooltipRefForEncoding(encoding,stack,config,{reactiveGeom:reactiveGeom}={}){const data=tooltipData(encoding,stack,config,{reactiveGeom:reactiveGeom});const keyValues=entries(data).map(([key,value])=>'"'.concat(key,'": ').concat(value));return keyValues.length>0?{signal:"{".concat(keyValues.join(", "),"}")}:undefined}function aria(model){const{markDef:markDef,config:config}=model;const enableAria=getMarkPropOrConfig("aria",markDef,config);if(enableAria===false){return{}}return{...enableAria?{aria:enableAria}:{},...ariaRoleDescription(model),...description(model)}}function ariaRoleDescription(model){const{mark:mark,markDef:markDef,config:config}=model;if(config.aria===false){return{}}const ariaRoleDesc=getMarkPropOrConfig("ariaRoleDescription",markDef,config);if(ariaRoleDesc!=null){return{ariaRoleDescription:{value:ariaRoleDesc}}}return mark in VG_MARK_INDEX?{}:{ariaRoleDescription:{value:mark}}}function description(model){const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding.description;if(channelDef){return wrapCondition(model,channelDef,"description",cDef=>textRef(cDef,model.config))}const descriptionValue=getMarkPropOrConfig("description",markDef,config);if(descriptionValue!=null){return{description:signalOrValueRef(descriptionValue)}}if(config.aria===false){return{}}const data=tooltipData(encoding,stack,config);if(isEmpty(data)){return undefined}return{description:{signal:entries(data).map(([key,value],index)=>'"'.concat(index>0?"; ":"").concat(key,': " + (').concat(value,")")).join(" + ")}}}function nonPosition(channel,model,opt={}){const{markDef:markDef,encoding:encoding,config:config}=model;const{vgChannel:vgChannel}=opt;let{defaultRef:defaultRef,defaultValue:defaultValue}=opt;if(defaultRef===undefined){var _defaultValue;defaultValue=(_defaultValue=defaultValue)!==null&&_defaultValue!==void 0?_defaultValue:getMarkPropOrConfig(channel,markDef,config,{vgChannel:vgChannel,ignoreVgConfig:true});if(defaultValue!==undefined){defaultRef=signalOrValueRef(defaultValue)}}const channelDef=encoding[channel];return wrapCondition(model,channelDef,vgChannel!==null&&vgChannel!==void 0?vgChannel:channel,cDef=>midPoint({channel:channel,channelDef:cDef,markDef:markDef,config:config,scaleName:model.scaleName(channel),scale:model.getScaleComponent(channel),stack:null,defaultRef:defaultRef}))}function color(model,opt={filled:undefined}){var _opt$filled,_ref,_getMarkPropOrConfig,_getMarkPropOrConfig2;const{markDef:markDef,encoding:encoding,config:config}=model;const{type:markType}=markDef;const filled=(_opt$filled=opt.filled)!==null&&_opt$filled!==void 0?_opt$filled:getMarkPropOrConfig("filled",markDef,config);const transparentIfNeeded=contains(["bar","point","circle","square","geoshape"],markType)?"transparent":undefined;const defaultFill=(_ref=(_getMarkPropOrConfig=getMarkPropOrConfig(filled===true?"color":undefined,markDef,config,{vgChannel:"fill"}))!==null&&_getMarkPropOrConfig!==void 0?_getMarkPropOrConfig:config.mark[filled===true&&"color"])!==null&&_ref!==void 0?_ref:transparentIfNeeded;const defaultStroke=(_getMarkPropOrConfig2=getMarkPropOrConfig(filled===false?"color":undefined,markDef,config,{vgChannel:"stroke"}))!==null&&_getMarkPropOrConfig2!==void 0?_getMarkPropOrConfig2:config.mark[filled===false&&"color"];const colorVgChannel=filled?"fill":"stroke";const fillStrokeMarkDefAndConfig={...defaultFill?{fill:signalOrValueRef(defaultFill)}:{},...defaultStroke?{stroke:signalOrValueRef(defaultStroke)}:{}};if(markDef.color&&(filled?markDef.fill:markDef.stroke)){warn(droppingColor("property",{fill:"fill"in markDef,stroke:"stroke"in markDef}))}return{...fillStrokeMarkDefAndConfig,...nonPosition("color",model,{vgChannel:colorVgChannel,defaultValue:filled?defaultFill:defaultStroke}),...nonPosition("fill",model,{defaultValue:encoding.fill?defaultFill:undefined}),...nonPosition("stroke",model,{defaultValue:encoding.stroke?defaultStroke:undefined})}}function zindex(model){const{encoding:encoding,mark:mark}=model;const order=encoding.order;if(!isPathMark(mark)&&isValueDef(order)){return wrapCondition(model,order,"zindex",cd=>signalOrValueRef(cd.value))}return{}}function getOffset(channel,markDef){const offsetChannel=getOffsetChannel(channel);const markDefOffsetValue=markDef[offsetChannel];if(markDefOffsetValue){return markDefOffsetValue}return undefined}function pointPosition(channel,model,{defaultPos:defaultPos,vgChannel:vgChannel,isMidPoint:isMidPoint}){const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding[channel];const channel2Def=encoding[getSecondaryRangeChannel(channel)];const scaleName=model.scaleName(channel);const scale=model.getScaleComponent(channel);const offset=getOffset(channel,markDef);const defaultRef=pointPositionDefaultRef({model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale});const valueRef=!channelDef&&isXorY(channel)&&(encoding.latitude||encoding.longitude)?{field:model.getName(channel)}:positionRef({channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,isMidPoint:isMidPoint,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef});return valueRef?{[vgChannel||channel]:valueRef}:undefined}function positionRef(params){const{channel:channel,channelDef:channelDef,isMidPoint:isMidPoint,scaleName:scaleName,stack:stack,offset:offset,markDef:markDef,config:config}=params;if(isFieldOrDatumDef(channelDef)&&stack&&channel===stack.fieldChannel){if(isFieldDef(channelDef)){const band=getBand({channel:channel,fieldDef:channelDef,isMidPoint:isMidPoint,markDef:markDef,stack:stack,config:config});if(band!==undefined){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,startSuffix:"start",band:band,offset:offset})}}return valueRefForFieldOrDatumDef(channelDef,scaleName,{suffix:"end"},{offset:offset})}return midPointRefWithPositionInvalidTest(params)}function pointPositionDefaultRef({model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale}){const{markDef:markDef,config:config}=model;return()=>{const mainChannel=getMainRangeChannel(channel);const vgChannel=getVgPositionChannel(channel);const definedValueOrConfig=getMarkPropOrConfig(channel,markDef,config,{vgChannel:vgChannel});if(definedValueOrConfig!==undefined){return widthHeightValueOrSignalRef(channel,definedValueOrConfig)}switch(defaultPos){case"zeroOrMin":case"zeroOrMax":if(scaleName){const scaleType=scale.get("type");if(contains([ScaleType.LOG,ScaleType.TIME,ScaleType.UTC],scaleType));else{if(scale.domainDefinitelyIncludesZero()){return{scale:scaleName,value:0}}}}if(defaultPos==="zeroOrMin"){return mainChannel==="y"?{field:{group:"height"}}:{value:0}}else{switch(mainChannel){case"radius":return{signal:"min(".concat(model.width.signal,",").concat(model.height.signal,")/2")};case"theta":return{signal:"2*PI"};case"x":return{field:{group:"width"}};case"y":return{value:0}}}break;case"mid":{const sizeRef=model[getSizeChannel(channel)];return{...sizeRef,mult:.5}}}return undefined}}const ALIGNED_X_CHANNEL={left:"x",center:"xc",right:"x2"};const BASELINED_Y_CHANNEL={top:"y",middle:"yc",bottom:"y2"};function vgAlignedPositionChannel(channel,markDef,config,defaultAlign="middle"){if(channel==="radius"||channel==="theta"){return getVgPositionChannel(channel)}const alignChannel=channel==="x"?"align":"baseline";const align=getMarkPropOrConfig(alignChannel,markDef,config);let alignExcludingSignal;if(isSignalRef(align)){warn(rangeMarkAlignmentCannotBeExpression(alignChannel));alignExcludingSignal=undefined}else{alignExcludingSignal=align}if(channel==="x"){return ALIGNED_X_CHANNEL[alignExcludingSignal||(defaultAlign==="top"?"left":"center")]}else{return BASELINED_Y_CHANNEL[alignExcludingSignal||defaultAlign]}}function pointOrRangePosition(channel,model,{defaultPos:defaultPos,defaultPos2:defaultPos2,range:range}){if(range){return rangePosition(channel,model,{defaultPos:defaultPos,defaultPos2:defaultPos2})}return pointPosition(channel,model,{defaultPos:defaultPos})}function rangePosition(channel,model,{defaultPos:defaultPos,defaultPos2:defaultPos2}){const{markDef:markDef,config:config}=model;const channel2=getSecondaryRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const pos2Mixins=pointPosition2OrSize(model,defaultPos2,channel2);const vgChannel=pos2Mixins[sizeChannel]?vgAlignedPositionChannel(channel,markDef,config):getVgPositionChannel(channel);return{...pointPosition(channel,model,{defaultPos:defaultPos,vgChannel:vgChannel}),...pos2Mixins}}function pointPosition2OrSize(model,defaultPos,channel){const{encoding:encoding,mark:mark,markDef:markDef,stack:stack,config:config}=model;const baseChannel=getMainRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const vgChannel=getVgPositionChannel(channel);const channelDef=encoding[baseChannel];const scaleName=model.scaleName(baseChannel);const scale=model.getScaleComponent(baseChannel);const offset=channel in encoding||channel in markDef?getOffset(channel,model.markDef):getOffset(baseChannel,model.markDef);if(!channelDef&&(channel==="x2"||channel==="y2")&&(encoding.latitude||encoding.longitude)){return{[vgChannel]:{field:model.getName(channel)}}}const valueRef=position2Ref({channel:channel,channelDef:channelDef,channel2Def:encoding[channel],markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:undefined});if(valueRef!==undefined){return{[vgChannel]:valueRef}}return position2orSize(channel,markDef)||position2orSize(channel,{[channel]:getMarkStyleConfig(channel,markDef,config.style),[sizeChannel]:getMarkStyleConfig(sizeChannel,markDef,config.style)})||position2orSize(channel,config[mark])||position2orSize(channel,config.mark)||{[vgChannel]:pointPositionDefaultRef({model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale})()}}function position2Ref({channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef}){if(isFieldOrDatumDef(channelDef)&&stack&&channel.charAt(0)===stack.fieldChannel.charAt(0)){return valueRefForFieldOrDatumDef(channelDef,scaleName,{suffix:"start"},{offset:offset})}return midPointRefWithPositionInvalidTest({channel:channel,channelDef:channel2Def,scaleName:scaleName,scale:scale,stack:stack,markDef:markDef,config:config,offset:offset,defaultRef:defaultRef})}function position2orSize(channel,markDef){const sizeChannel=getSizeChannel(channel);const vgChannel=getVgPositionChannel(channel);if(markDef[vgChannel]!==undefined){return{[vgChannel]:widthHeightValueOrSignalRef(channel,markDef[vgChannel])}}else if(markDef[channel]!==undefined){return{[vgChannel]:widthHeightValueOrSignalRef(channel,markDef[channel])}}else if(markDef[sizeChannel]){return{[sizeChannel]:widthHeightValueOrSignalRef(channel,markDef[sizeChannel])}}return undefined}function rectPosition(model,channel,mark){var _ref,_encoding$sizeChannel;const{config:config,encoding:encoding,markDef:markDef,stack:stack}=model;const channel2=getSecondaryRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const channelDef=encoding[channel];const channelDef2=encoding[channel2];const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;const scaleName=model.scaleName(channel);const orient=markDef.orient;const hasSizeDef=(_ref=(_encoding$sizeChannel=encoding[sizeChannel])!==null&&_encoding$sizeChannel!==void 0?_encoding$sizeChannel:encoding.size)!==null&&_ref!==void 0?_ref:getMarkPropOrConfig("size",markDef,config,{vgChannel:sizeChannel});const isBarBand=mark==="bar"&&(channel==="x"?orient==="vertical":orient==="horizontal");if(isFieldDef(channelDef)&&(isBinning(channelDef.bin)||isBinned(channelDef.bin)||channelDef.timeUnit&&!channelDef2)&&!hasSizeDef&&!hasDiscreteDomain(scaleType)){var _model$component$axes,_axis$get;const band=getBand({channel:channel,fieldDef:channelDef,stack:stack,markDef:markDef,config:config});const axis=(_model$component$axes=model.component.axes[channel])===null||_model$component$axes===void 0?void 0:_model$component$axes[0];const axisTranslate=(_axis$get=axis===null||axis===void 0?void 0:axis.get("translate"))!==null&&_axis$get!==void 0?_axis$get:.5;return rectBinPosition({fieldDef:channelDef,fieldDef2:channelDef2,channel:channel,markDef:markDef,scaleName:scaleName,band:band,axisTranslate:axisTranslate,spacing:isXorY(channel)?getMarkPropOrConfig("binSpacing",markDef,config):undefined,reverse:scale.get("reverse"),config:config})}else if((isFieldOrDatumDef(channelDef)&&hasDiscreteDomain(scaleType)||isBarBand)&&!channelDef2){return positionAndSize(mark,channelDef,channel,model)}else{return rangePosition(channel,model,{defaultPos:"zeroOrMax",defaultPos2:"zeroOrMin"})}}function defaultSizeRef(mark,sizeChannel,scaleName,scale,config,band){if(scale){const scaleType=scale.get("type");if(scaleType==="point"||scaleType==="band"){if(config[mark].discreteBandSize!==undefined){return{value:config[mark].discreteBandSize}}if(scaleType===ScaleType.POINT){const scaleRange=scale.get("range");if(isVgRangeStep(scaleRange)&&isNumber(scaleRange.step)){return{value:scaleRange.step-2}}return{value:DEFAULT_STEP-2}}else{return{scale:scaleName,band:band}}}else{return{value:config[mark].continuousBandSize}}}const step=getViewConfigDiscreteStep(config.view,sizeChannel);const value=getFirstDefined(config[mark].discreteBandSize,step-2);return value!==undefined?{value:value}:undefined}function positionAndSize(mark,fieldDef,channel,model){var _ref2;const{markDef:markDef,encoding:encoding,config:config,stack:stack}=model;const orient=markDef.orient;const scaleName=model.scaleName(channel);const scale=model.getScaleComponent(channel);const vgSizeChannel=getSizeChannel(channel);const channel2=getSecondaryRangeChannel(channel);const useVlSizeChannel=orient==="horizontal"&&channel==="y"||orient==="vertical"&&channel==="x";const sizeFromMarkOrConfig=getMarkPropOrConfig(useVlSizeChannel?"size":vgSizeChannel,markDef,config,{vgChannel:vgSizeChannel});let sizeMixins;if(encoding.size||sizeFromMarkOrConfig!==undefined){if(useVlSizeChannel){sizeMixins=nonPosition("size",model,{vgChannel:vgSizeChannel,defaultValue:sizeFromMarkOrConfig})}else{warn(cannotApplySizeToNonOrientedMark(markDef.type))}}const band=(_ref2=isFieldOrDatumDef(fieldDef)?getBand({channel:channel,fieldDef:fieldDef,markDef:markDef,stack:stack,config:config}):undefined)!==null&&_ref2!==void 0?_ref2:1;sizeMixins=sizeMixins||{[vgSizeChannel]:defaultSizeRef(mark,vgSizeChannel,scaleName,scale,config,band)};const center=(scale===null||scale===void 0?void 0:scale.get("type"))!=="band"||!("band"in sizeMixins[vgSizeChannel]);const vgChannel=vgAlignedPositionChannel(channel,markDef,config,center?"middle":"top");const offset=getOffset(channel,markDef);const posRef=midPointRefWithPositionInvalidTest({channel:channel,channelDef:fieldDef,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:pointPositionDefaultRef({model:model,defaultPos:"mid",channel:channel,scaleName:scaleName,scale:scale}),band:center?.5:(1-band)/2});if(vgSizeChannel){return{[vgChannel]:posRef,...sizeMixins}}else{const vgChannel2=getVgPositionChannel(channel2);const sizeRef=sizeMixins[vgSizeChannel];const sizeOffset=offset?{...sizeRef,offset:offset}:sizeRef;return{[vgChannel]:posRef,[vgChannel2]:isArray(posRef)?[posRef[0],{...posRef[1],offset:sizeOffset}]:{...posRef,offset:sizeOffset}}}}function getBinSpacing(channel,spacing,reverse,translate,offset){if(isPolarPositionChannel(channel)){return 0}const spacingOffset=channel==="x"||channel==="y2"?-spacing/2:spacing/2;if(isSignalRef(reverse)||isSignalRef(offset)||isSignalRef(translate)){const reverseExpr=signalOrStringValue(reverse);const offsetExpr=signalOrStringValue(offset);const translateExpr=signalOrStringValue(translate);const t=translateExpr?"".concat(translateExpr," + "):"";const r=reverseExpr?"(".concat(reverseExpr," ? -1 : 1) * "):"";const o=offsetExpr?"(".concat(offsetExpr," + ").concat(spacingOffset,")"):spacingOffset;return{signal:t+r+o}}else{offset=offset||0;return translate+(reverse?-offset-spacingOffset:+offset+spacingOffset)}}function rectBinPosition({fieldDef:fieldDef,fieldDef2:fieldDef2,channel:channel,band:band,scaleName:scaleName,markDef:markDef,spacing:spacing=0,axisTranslate:axisTranslate,reverse:reverse,config:config}){const channel2=getSecondaryRangeChannel(channel);const vgChannel=getVgPositionChannel(channel);const vgChannel2=getVgPositionChannel(channel2);const offset=getOffset(channel,markDef);if(isBinning(fieldDef.bin)||fieldDef.timeUnit){return{[vgChannel2]:rectBinRef({channel:channel,fieldDef:fieldDef,scaleName:scaleName,markDef:markDef,band:(1-band)/2,offset:getBinSpacing(channel2,spacing,reverse,axisTranslate,offset),config:config}),[vgChannel]:rectBinRef({channel:channel,fieldDef:fieldDef,scaleName:scaleName,markDef:markDef,band:1-(1-band)/2,offset:getBinSpacing(channel,spacing,reverse,axisTranslate,offset),config:config})}}else if(isBinned(fieldDef.bin)){const startRef=valueRefForFieldOrDatumDef(fieldDef,scaleName,{},{offset:getBinSpacing(channel2,spacing,reverse,axisTranslate,offset)});if(isFieldDef(fieldDef2)){return{[vgChannel2]:startRef,[vgChannel]:valueRefForFieldOrDatumDef(fieldDef2,scaleName,{},{offset:getBinSpacing(channel,spacing,reverse,axisTranslate,offset)})}}else if(isBinParams(fieldDef.bin)&&fieldDef.bin.step){return{[vgChannel2]:startRef,[vgChannel]:{signal:'scale("'.concat(scaleName,'", ').concat(vgField(fieldDef,{expr:"datum"})," + ").concat(fieldDef.bin.step,")"),offset:getBinSpacing(channel,spacing,reverse,axisTranslate,offset)}}}}warn(channelRequiredForBinned(channel2));return undefined}function rectBinRef({channel:channel,fieldDef:fieldDef,scaleName:scaleName,markDef:markDef,band:band,offset:offset,config:config}){const r=interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:fieldDef,band:band,offset:offset});return wrapPositionInvalidTest({fieldDef:fieldDef,channel:channel,markDef:markDef,ref:r,config:config})}const ALWAYS_IGNORE=new Set(["aria"]);function baseEncodeEntry(model,ignore){const{fill:fill=undefined,stroke:stroke=undefined}=ignore.color==="include"?color(model):{};return{...markDefProperties(model.markDef,ignore),...wrapAllFieldsInvalid(model,"fill",fill),...wrapAllFieldsInvalid(model,"stroke",stroke),...nonPosition("opacity",model),...nonPosition("fillOpacity",model),...nonPosition("strokeOpacity",model),...nonPosition("strokeWidth",model),...nonPosition("strokeDash",model),...zindex(model),...tooltip(model),...text(model,"href"),...aria(model)}}function wrapAllFieldsInvalid(model,channel,valueRef){const{config:config,mark:mark,markDef:markDef}=model;const invalid=getMarkPropOrConfig("invalid",markDef,config);if(invalid==="hide"&&valueRef&&!isPathMark(mark)){const test=allFieldsInvalidPredicate(model,{invalid:true,channels:SCALE_CHANNELS});if(test){return{[channel]:[{test:test,value:null},...array(valueRef)]}}}return valueRef?{[channel]:valueRef}:{}}function markDefProperties(mark,ignore){return VG_MARK_CONFIGS.reduce((m,prop)=>{if(!ALWAYS_IGNORE.has(prop)&&mark[prop]!==undefined&&ignore[prop]!=="ignore"){m[prop]=signalOrValueRef(mark[prop])}return m},{})}function allFieldsInvalidPredicate(model,{invalid:invalid=false,channels:channels}){const filterIndex=channels.reduce((aggregator,channel)=>{const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");const field=model.vgField(channel,{expr:"datum"});if(field&&hasContinuousDomain(scaleType)){aggregator[field]=true}}return aggregator},{});const fields=keys(filterIndex);if(fields.length>0){const op=invalid?"||":"&&";return fields.map(field=>fieldInvalidPredicate(field,invalid)).join(" ".concat(op," "))}return undefined}function defined(model){const{config:config,markDef:markDef}=model;const invalid=getMarkPropOrConfig("invalid",markDef,config);if(invalid){const signal=allFieldsInvalidPredicate$1(model,{channels:POSITION_SCALE_CHANNELS});if(signal){return{defined:{signal:signal}}}}return{}}function allFieldsInvalidPredicate$1(model,{invalid:invalid=false,channels:channels}){const filterIndex=channels.reduce((aggregator,channel)=>{const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");const field=model.vgField(channel,{expr:"datum"});if(field&&hasContinuousDomain(scaleType)){aggregator[field]=true}}return aggregator},{});const fields=keys(filterIndex);if(fields.length>0){const op=invalid?"||":"&&";return fields.map(field=>fieldInvalidPredicate(field,invalid)).join(" ".concat(op," "))}return undefined}function valueIfDefined(prop,value){if(value!==undefined){return{[prop]:signalOrValueRef(value)}}return undefined}const VORONOI="voronoi";const nearest={has:selCmpt=>selCmpt.type!=="interval"&&selCmpt.nearest,parse:(model,selCmpt)=>{if(selCmpt.events){for(const s of selCmpt.events){s.markname=model.getName(VORONOI)}}},marks:(model,selCmpt,marks)=>{const{x:x,y:y}=selCmpt.project.hasChannel;const markType=model.mark;if(isPathMark(markType)){warn(nearestNotSupportForContinuous(markType));return marks}const cellDef={name:model.getName(VORONOI),type:"path",interactive:true,from:{data:model.getName("marks")},encode:{update:{fill:{value:"transparent"},strokeWidth:{value:.35},stroke:{value:"transparent"},isVoronoi:{value:true},...tooltip(model,{reactiveGeom:true})}},transform:[{type:"voronoi",x:{expr:x||!y?"datum.datum.x || 0":"0"},y:{expr:y||!x?"datum.datum.y || 0":"0"},size:[model.getSizeSignalRef("width"),model.getSizeSignalRef("height")]}]};let index=0;let exists=false;marks.forEach((mark,i)=>{var _mark$name;const name=(_mark$name=mark.name)!==null&&_mark$name!==void 0?_mark$name:"";if(name===model.component.mark[0].name){index=i}else if(name.indexOf(VORONOI)>=0){exists=true}});if(!exists){marks.splice(index+1,0,cellDef)}return marks}};class DataFlowNode{constructor(parent,debugName){this.debugName=debugName;_defineProperty(this,"_children",[]);_defineProperty(this,"_parent",null);_defineProperty(this,"_hash",void 0);if(parent){this.parent=parent}}clone(){throw new Error("Cannot clone node")}get parent(){return this._parent}set parent(parent){this._parent=parent;if(parent){parent.addChild(this)}}get children(){return this._children}numChildren(){return this._children.length}addChild(child,loc){if(this._children.indexOf(child)>-1){warn(ADD_SAME_CHILD_TWICE);return}if(loc!==undefined){this._children.splice(loc,0,child)}else{this._children.push(child)}}removeChild(oldChild){const loc=this._children.indexOf(oldChild);this._children.splice(loc,1);return loc}remove(){let loc=this._parent.removeChild(this);for(const child of this._children){child._parent=this._parent;this._parent.addChild(child,loc++)}}insertAsParentOf(other){const parent=other.parent;parent.removeChild(this);this.parent=parent;other.parent=this}swapWithParent(){const parent=this._parent;const newParent=parent.parent;for(const child of this._children){child.parent=parent}this._children=[];parent.removeChild(this);parent.parent.removeChild(parent);this.parent=newParent;parent.parent=this}}class OutputNode extends DataFlowNode{clone(){const cloneObj=new this.constructor;cloneObj.debugName="clone_"+this.debugName;cloneObj._source=this._source;cloneObj._name="clone_"+this._name;cloneObj.type=this.type;cloneObj.refCounts=this.refCounts;cloneObj.refCounts[cloneObj._name]=0;return cloneObj}constructor(parent,source,type,refCounts){super(parent,source);this.type=type;this.refCounts=refCounts;_defineProperty(this,"_source",void 0);_defineProperty(this,"_name",void 0);this._source=this._name=source;if(this.refCounts&&!(this._name in this.refCounts)){this.refCounts[this._name]=0}}dependentFields(){return new Set}producedFields(){return new Set}hash(){if(this._hash===undefined){this._hash="Output ".concat(uniqueId())}return this._hash}getSource(){this.refCounts[this._name]++;return this._source}isRequired(){return!!this.refCounts[this._name]}setSource(source){this._source=source}}class TimeUnitNode extends DataFlowNode{clone(){return new TimeUnitNode(null,duplicate(this.formula))}constructor(parent,formula){super(parent);this.formula=formula}static makeFromEncoding(parent,model){const formula=model.reduceFieldDef((timeUnitComponent,fieldDef,channel)=>{const{field:field,timeUnit:timeUnit}=fieldDef;const channelDef2=isUnitModel(model)?model.encoding[getSecondaryRangeChannel(channel)]:undefined;const band=isUnitModel(model)&&hasBand(channel,fieldDef,channelDef2,model.stack,model.markDef,model.config);if(timeUnit){const as=vgField(fieldDef,{forAs:true});timeUnitComponent[hash({as:as,field:field,timeUnit:timeUnit})]={as:as,field:field,timeUnit:timeUnit,...band?{band:true}:{}}}return timeUnitComponent},{});if(isEmpty(formula)){return null}return new TimeUnitNode(parent,formula)}static makeFromTransform(parent,t){const{timeUnit:timeUnit,...other}={...t};const normalizedTimeUnit=normalizeTimeUnit(timeUnit);const component={...other,timeUnit:normalizedTimeUnit};return new TimeUnitNode(parent,{[hash(component)]:component})}merge(other){this.formula={...this.formula};for(const key in other.formula){if(!this.formula[key]||other.formula[key].band){this.formula[key]=other.formula[key]}}for(const child of other.children){other.removeChild(child);child.parent=this}other.remove()}removeFormulas(fields){const newFormula={};for(const[key,timeUnit]of entries(this.formula)){if(!fields.has(timeUnit.as)){newFormula[key]=timeUnit}}this.formula=newFormula}producedFields(){return new Set(vals(this.formula).map(f=>f.as))}dependentFields(){return new Set(vals(this.formula).map(f=>f.field))}hash(){return"TimeUnit ".concat(hash(this.formula))}assemble(){const transforms=[];for(const f of vals(this.formula)){const{field:field,as:as,timeUnit:timeUnit}=f;const{unit:unit,utc:utc,...params}=normalizeTimeUnit(timeUnit);transforms.push({field:replacePathInField(field),type:"timeunit",...unit?{units:getTimeUnitParts(unit)}:{},...utc?{timezone:"utc"}:{},...params,as:[as,"".concat(as,"_end")]})}return transforms}}const TUPLE_FIELDS="_tuple_fields";class SelectionProjectionComponent{constructor(...items){_defineProperty(this,"hasChannel",void 0);_defineProperty(this,"hasField",void 0);_defineProperty(this,"timeUnit",void 0);_defineProperty(this,"items",void 0);this.items=items;this.hasChannel={};this.hasField={}}}const project={has:()=>true,parse:(model,selCmpt,selDef)=>{var _selCmpt$project;const name=selCmpt.name;const proj=(_selCmpt$project=selCmpt.project)!==null&&_selCmpt$project!==void 0?_selCmpt$project:selCmpt.project=new SelectionProjectionComponent;const parsed={};const timeUnits={};const signals=new Set;const signalName=(p,range)=>{const suffix=range==="visual"?p.channel:p.field;let sg=varName("".concat(name,"_").concat(suffix));for(let counter=1;signals.has(sg);counter++){sg=varName("".concat(name,"_").concat(suffix,"_").concat(counter))}signals.add(sg);return{[range]:sg}};if(!selDef.fields&&!selDef.encodings){const cfg=model.config.selection[selDef.type];if(selDef.init){for(const init of array(selDef.init)){for(const key of keys(init)){if(isSingleDefUnitChannel(key)){(selDef.encodings||(selDef.encodings=[])).push(key)}else{if(selDef.type==="interval"){warn(INTERVAL_INITIALIZED_WITH_X_Y);selDef.encodings=cfg.encodings}else{(selDef.fields||(selDef.fields=[])).push(key)}}}}}else{selDef.encodings=cfg.encodings;selDef.fields=cfg.fields}}for(const field of(_selDef$fields=selDef.fields)!==null&&_selDef$fields!==void 0?_selDef$fields:[]){var _selDef$fields;const p={type:"E",field:field};p.signals={...signalName(p,"data")};proj.items.push(p);proj.hasField[field]=p}for(const channel of(_selDef$encodings=selDef.encodings)!==null&&_selDef$encodings!==void 0?_selDef$encodings:[]){var _selDef$encodings;const fieldDef=model.fieldDef(channel);if(fieldDef){let field=fieldDef.field;if(fieldDef.aggregate){warn(cannotProjectAggregate(channel,fieldDef.aggregate));continue}else if(!field){warn(cannotProjectOnChannelWithoutField(channel));continue}if(fieldDef.timeUnit){field=model.vgField(channel);const component={timeUnit:fieldDef.timeUnit,as:field,field:fieldDef.field};timeUnits[hash(component)]=component}if(!parsed[field]){let type="E";if(selCmpt.type==="interval"){const scaleType=model.getScaleComponent(channel).get("type");if(hasContinuousDomain(scaleType)){type="R"}}else if(fieldDef.bin){type="R-RE"}const p={field:field,channel:channel,type:type};p.signals={...signalName(p,"data"),...signalName(p,"visual")};proj.items.push(parsed[field]=p);proj.hasField[field]=proj.hasChannel[channel]=parsed[field]}}else{warn(cannotProjectOnChannelWithoutField(channel))}}if(selDef.init){const parseInit=i=>proj.items.map(p=>i[p.channel]!==undefined?i[p.channel]:i[p.field]);if(selDef.type==="interval"){selCmpt.init=parseInit(selDef.init)}else{const init=array(selDef.init);selCmpt.init=init.map(parseInit)}}if(!isEmpty(timeUnits)){proj.timeUnit=new TimeUnitNode(null,timeUnits)}},signals:(model,selCmpt,allSignals)=>{const name=selCmpt.name+TUPLE_FIELDS;const hasSignal=allSignals.filter(s=>s.name===name);return hasSignal.length>0?allSignals:allSignals.concat({name:name,value:selCmpt.project.items.map(proj=>{const{signals:signals,hasLegend:hasLegend,...rest}=proj;rest.field=replacePathInField(rest.field);return rest})})}};const inputBindings={has:selCmpt=>selCmpt.type==="single"&&selCmpt.resolve==="global"&&selCmpt.bind&&selCmpt.bind!=="scales"&&!isLegendBinding(selCmpt.bind),parse:(model,selCmpt,selDef,origDef)=>{if(!origDef.on)delete selCmpt.events;if(!origDef.clear)delete selCmpt.clear},topLevelSignals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const bind=selCmpt.bind;const init=selCmpt.init&&selCmpt.init[0];const datum=nearest.has(selCmpt)?"(item().isVoronoi ? datum.datum : datum)":"datum";proj.items.forEach((p,i)=>{const sgname=varName("".concat(name,"_").concat(p.field));const hasSignal=signals.filter(s=>s.name===sgname);if(!hasSignal.length){var _ref,_bind$p$field;signals.unshift({name:sgname,...init?{init:assembleInit(init[i])}:{value:null},on:selCmpt.events?[{events:selCmpt.events,update:"datum && item().mark.marktype !== 'group' ? ".concat(datum,"[").concat($(p.field),"] : null")}]:[],bind:(_ref=(_bind$p$field=bind[p.field])!==null&&_bind$p$field!==void 0?_bind$p$field:bind[p.channel])!==null&&_ref!==void 0?_ref:bind})}});return signals},signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const signal=signals.filter(s=>s.name===name+TUPLE)[0];const fields=name+TUPLE_FIELDS;const values=proj.items.map(p=>varName("".concat(name,"_").concat(p.field)));const valid=values.map(v=>"".concat(v," !== null")).join(" && ");if(values.length){signal.update="".concat(valid," ? {fields: ").concat(fields,", values: [").concat(values.join(", "),"]} : null")}delete signal.value;delete signal.on;return signals}};const TOGGLE="_toggle";const toggle={has:selCmpt=>selCmpt.type==="multi"&&!!selCmpt.toggle,signals:(model,selCmpt,signals)=>signals.concat({name:selCmpt.name+TOGGLE,value:false,on:[{events:selCmpt.events,update:selCmpt.toggle}]}),modifyExpr:(model,selCmpt)=>{const tpl=selCmpt.name+TUPLE;const signal=selCmpt.name+TOGGLE;return"".concat(signal," ? null : ").concat(tpl,", ")+(selCmpt.resolve==="global"?"".concat(signal," ? null : true, "):"".concat(signal," ? null : {unit: ").concat(unitName(model),"}, "))+"".concat(signal," ? ").concat(tpl," : null")}};const clear={has:selCmpt=>selCmpt.clear!==undefined&&selCmpt.clear!==false,parse:(model,selCmpt,selDef)=>{if(selDef.clear){selCmpt.clear=isString(selDef.clear)?eventSelector(selDef.clear,"scope"):selDef.clear}},topLevelSignals:(model,selCmpt,signals)=>{if(inputBindings.has(selCmpt)){for(const proj of selCmpt.project.items){const idx=signals.findIndex(n=>n.name===varName("".concat(selCmpt.name,"_").concat(proj.field)));if(idx!==-1){signals[idx].on.push({events:selCmpt.clear,update:"null"})}}}return signals},signals:(model,selCmpt,signals)=>{function addClear(idx,update){if(idx!==-1&&signals[idx].on){signals[idx].on.push({events:selCmpt.clear,update:update})}}if(selCmpt.type==="interval"){for(const proj of selCmpt.project.items){const vIdx=signals.findIndex(n=>n.name===proj.signals.visual);addClear(vIdx,"[0, 0]");if(vIdx===-1){const dIdx=signals.findIndex(n=>n.name===proj.signals.data);addClear(dIdx,"null")}}}else{let tIdx=signals.findIndex(n=>n.name===selCmpt.name+TUPLE);addClear(tIdx,"null");if(toggle.has(selCmpt)){tIdx=signals.findIndex(n=>n.name===selCmpt.name+TOGGLE);addClear(tIdx,"false")}}return signals}};const scaleBindings={has:selCmpt=>selCmpt.type==="interval"&&selCmpt.resolve==="global"&&selCmpt.bind&&selCmpt.bind==="scales",parse:(model,selCmpt)=>{const bound=selCmpt.scales=[];for(const proj of selCmpt.project.items){const channel=proj.channel;if(!isScaleChannel(channel)){continue}const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;if(!scale||!hasContinuousDomain(scaleType)){warn(SCALE_BINDINGS_CONTINUOUS);continue}const extent={selection:selCmpt.name,field:proj.field};scale.set("selectionExtent",extent,true);bound.push(proj)}},topLevelSignals:(model,selCmpt,signals)=>{const bound=selCmpt.scales.filter(proj=>signals.filter(s=>s.name===proj.signals.data).length===0);if(!model.parent||isTopLevelLayer(model)||bound.length===0){return signals}const namedSg=signals.filter(s=>s.name===selCmpt.name)[0];let update=namedSg.update;if(update.indexOf(VL_SELECTION_RESOLVE)>=0){namedSg.update="{".concat(bound.map(proj=>"".concat($(proj.field),": ").concat(proj.signals.data)).join(", "),"}")}else{for(const proj of bound){const mapping="".concat($(proj.field),": ").concat(proj.signals.data);if(update.indexOf(mapping)<0){update="".concat(update.substring(0,update.length-1),", ").concat(mapping,"}")}}namedSg.update=update}return signals.concat(bound.map(proj=>({name:proj.signals.data})))},signals:(model,selCmpt,signals)=>{if(model.parent&&!isTopLevelLayer(model)){for(const proj of selCmpt.scales){const signal=signals.filter(s=>s.name===proj.signals.data)[0];signal.push="outer";delete signal.value;delete signal.update}}return signals}};function domain$1(model,channel){const scale=$(model.scaleName(channel));return"domain(".concat(scale,")")}function isTopLevelLayer(model){var _model$parent$parent;return model.parent&&isLayerModel(model.parent)&&((_model$parent$parent=!model.parent.parent)!==null&&_model$parent$parent!==void 0?_model$parent$parent:isTopLevelLayer(model.parent.parent))}const legendBindings={has:selCmpt=>{const spec=selCmpt.resolve==="global"&&selCmpt.bind&&isLegendBinding(selCmpt.bind);const projLen=selCmpt.project.items.length===1&&selCmpt.project.items[0].field!==SELECTION_ID;if(spec&&!projLen){warn(LEGEND_BINDINGS_MUST_HAVE_PROJECTION)}return spec&&projLen},parse:(model,selCmpt,selDef,origDef)=>{if(!origDef.on)delete selCmpt.events;if(!origDef.clear)delete selCmpt.clear;if(origDef.on||origDef.clear){const legendFilter='event.item && indexof(event.item.mark.role, "legend") < 0';for(const evt of selCmpt.events){var _evt$filter;evt.filter=array((_evt$filter=evt.filter)!==null&&_evt$filter!==void 0?_evt$filter:[]);if(evt.filter.indexOf(legendFilter)<0){evt.filter.push(legendFilter)}}}const evt=isLegendStreamBinding(selCmpt.bind)?selCmpt.bind.legend:"click";const stream=isString(evt)?eventSelector(evt,"view"):array(evt);selCmpt.bind={legend:{merge:stream}}},topLevelSignals:(model,selCmpt,signals)=>{const selName=selCmpt.name;const stream=isLegendStreamBinding(selCmpt.bind)&&selCmpt.bind.legend;const markName=name=>s=>{const ds=duplicate(s);ds.markname=name;return ds};for(const proj of selCmpt.project.items){if(!proj.hasLegend)continue;const prefix="".concat(varName(proj.field),"_legend");const sgName="".concat(selName,"_").concat(prefix);const hasSignal=signals.filter(s=>s.name===sgName);if(hasSignal.length===0){const events=stream.merge.map(markName("".concat(prefix,"_symbols"))).concat(stream.merge.map(markName("".concat(prefix,"_labels")))).concat(stream.merge.map(markName("".concat(prefix,"_entries"))));signals.unshift({name:sgName,...!selCmpt.init?{value:null}:{},on:[{events:events,update:"datum.value || item().items[0].items[0].datum.value",force:true},{events:stream.merge,update:"!event.item || !datum ? null : ".concat(sgName),force:true}]})}}return signals},signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const tuple=signals.find(s=>s.name===name+TUPLE);const fields=name+TUPLE_FIELDS;const values=proj.items.filter(p=>p.hasLegend).map(p=>varName("".concat(name,"_").concat(varName(p.field),"_legend")));const valid=values.map(v=>"".concat(v," !== null")).join(" && ");const update="".concat(valid," ? {fields: ").concat(fields,", values: [").concat(values.join(", "),"]} : null");if(selCmpt.events&&values.length>0){tuple.on.push({events:values.map(signal=>({signal:signal})),update:update})}else if(values.length>0){tuple.update=update;delete tuple.value;delete tuple.on}const toggle=signals.find(s=>s.name===name+TOGGLE);const events=isLegendStreamBinding(selCmpt.bind)&&selCmpt.bind.legend;if(toggle){if(!selCmpt.events)toggle.on[0].events=events;else toggle.on.push({...toggle.on[0],events:events})}return signals}};function parseInteractiveLegend(model,channel,legendCmpt){var _model$fieldDef;const field=(_model$fieldDef=model.fieldDef(channel))===null||_model$fieldDef===void 0?void 0:_model$fieldDef.field;forEachSelection(model,selCmpt=>{var _selCmpt$project$hasF;const proj=(_selCmpt$project$hasF=selCmpt.project.hasField[field])!==null&&_selCmpt$project$hasF!==void 0?_selCmpt$project$hasF:selCmpt.project.hasChannel[channel];if(proj&&legendBindings.has(selCmpt)){var _legendCmpt$get;const legendSelections=(_legendCmpt$get=legendCmpt.get("selections"))!==null&&_legendCmpt$get!==void 0?_legendCmpt$get:[];legendSelections.push(selCmpt.name);legendCmpt.set("selections",legendSelections,false);proj.hasLegend=true}})}const ANCHOR="_translate_anchor";const DELTA="_translate_delta";const translate={has:selCmpt=>selCmpt.type==="interval"&&selCmpt.translate,signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const hasScales=scaleBindings.has(selCmpt);const anchor=name+ANCHOR;const{x:x,y:y}=selCmpt.project.hasChannel;let events=eventSelector(selCmpt.translate,"scope");if(!hasScales){events=events.map(e=>(e.between[0].markname=name+BRUSH,e))}signals.push({name:anchor,value:{},on:[{events:events.map(e=>e.between[0]),update:"{x: x(unit), y: y(unit)"+(x!==undefined?", extent_x: "+(hasScales?domain$1(model,X):"slice(".concat(x.signals.visual,")")):"")+(y!==undefined?", extent_y: "+(hasScales?domain$1(model,Y):"slice(".concat(y.signals.visual,")")):"")+"}"}]},{name:name+DELTA,value:{},on:[{events:events,update:"{x: ".concat(anchor,".x - x(unit), y: ").concat(anchor,".y - y(unit)}")}]});if(x!==undefined){onDelta(model,selCmpt,x,"width",signals)}if(y!==undefined){onDelta(model,selCmpt,y,"height",signals)}return signals}};function onDelta(model,selCmpt,proj,size,signals){var _scaleCmpt$get;const name=selCmpt.name;const anchor=name+ANCHOR;const delta=name+DELTA;const channel=proj.channel;const hasScales=scaleBindings.has(selCmpt);const signal=signals.filter(s=>s.name===proj.signals[hasScales?"data":"visual"])[0];const sizeSg=model.getSizeSignalRef(size).signal;const scaleCmpt=model.getScaleComponent(channel);const scaleType=scaleCmpt.get("type");const sign=hasScales&&channel===X?"-":"";const extent="".concat(anchor,".extent_").concat(channel);const offset="".concat(sign).concat(delta,".").concat(channel," / ")+(hasScales?"".concat(sizeSg):"span(".concat(extent,")"));const panFn=!hasScales?"panLinear":scaleType==="log"?"panLog":scaleType==="pow"?"panPow":"panLinear";const update="".concat(panFn,"(").concat(extent,", ").concat(offset)+(hasScales&&scaleType==="pow"?", ".concat((_scaleCmpt$get=scaleCmpt.get("exponent"))!==null&&_scaleCmpt$get!==void 0?_scaleCmpt$get:1):"")+")";signal.on.push({events:{signal:delta},update:hasScales?update:"clampRange(".concat(update,", 0, ").concat(sizeSg,")")})}const ANCHOR$1="_zoom_anchor";const DELTA$1="_zoom_delta";const zoom={has:selCmpt=>selCmpt.type==="interval"&&selCmpt.zoom,signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const hasScales=scaleBindings.has(selCmpt);const delta=name+DELTA$1;const{x:x,y:y}=selCmpt.project.hasChannel;const sx=$(model.scaleName(X));const sy=$(model.scaleName(Y));let events=eventSelector(selCmpt.zoom,"scope");if(!hasScales){events=events.map(e=>(e.markname=name+BRUSH,e))}signals.push({name:name+ANCHOR$1,on:[{events:events,update:!hasScales?"{x: x(unit), y: y(unit)}":"{"+[sx?"x: invert(".concat(sx,", x(unit))"):"",sy?"y: invert(".concat(sy,", y(unit))"):""].filter(expr=>!!expr).join(", ")+"}"}]},{name:delta,on:[{events:events,force:true,update:"pow(1.001, event.deltaY * pow(16, event.deltaMode))"}]});if(x!==undefined){onDelta$1(model,selCmpt,x,"width",signals)}if(y!==undefined){onDelta$1(model,selCmpt,y,"height",signals)}return signals}};function onDelta$1(model,selCmpt,proj,size,signals){var _scaleCmpt$get;const name=selCmpt.name;const channel=proj.channel;const hasScales=scaleBindings.has(selCmpt);const signal=signals.filter(s=>s.name===proj.signals[hasScales?"data":"visual"])[0];const sizeSg=model.getSizeSignalRef(size).signal;const scaleCmpt=model.getScaleComponent(channel);const scaleType=scaleCmpt.get("type");const base=hasScales?domain$1(model,channel):signal.name;const delta=name+DELTA$1;const anchor="".concat(name).concat(ANCHOR$1,".").concat(channel);const zoomFn=!hasScales?"zoomLinear":scaleType==="log"?"zoomLog":scaleType==="pow"?"zoomPow":"zoomLinear";const update="".concat(zoomFn,"(").concat(base,", ").concat(anchor,", ").concat(delta)+(hasScales&&scaleType==="pow"?", ".concat((_scaleCmpt$get=scaleCmpt.get("exponent"))!==null&&_scaleCmpt$get!==void 0?_scaleCmpt$get:1):"")+")";signal.on.push({events:{signal:delta},update:hasScales?update:"clampRange(".concat(update,", 0, ").concat(sizeSg,")")})}const compilers=[project,toggle,scaleBindings,legendBindings,translate,zoom,inputBindings,nearest,clear];function forEachTransform(selCmpt,cb){for(const t of compilers){if(t.has(selCmpt)){cb(t)}}}function assembleInit(init,isExpr=true,wrap=identity){if(isArray(init)){const assembled=init.map(v=>assembleInit(v,isExpr,wrap));return isExpr?"[".concat(assembled.join(", "),"]"):assembled}else if(isDateTime(init)){if(isExpr){return wrap(dateTimeToExpr(init))}else{return wrap(dateTimeToTimestamp(init))}}return isExpr?wrap(JSON.stringify(init)):init}function assembleUnitSelectionSignals(model,signals){forEachSelection(model,(selCmpt,selCompiler)=>{const name=selCmpt.name;let modifyExpr=selCompiler.modifyExpr(model,selCmpt);signals.push(...selCompiler.signals(model,selCmpt));forEachTransform(selCmpt,txCompiler=>{if(txCompiler.signals){signals=txCompiler.signals(model,selCmpt,signals)}if(txCompiler.modifyExpr){modifyExpr=txCompiler.modifyExpr(model,selCmpt,modifyExpr)}});signals.push({name:name+MODIFY,on:[{events:{signal:selCmpt.name+TUPLE},update:"modify(".concat($(selCmpt.name+STORE),", ").concat(modifyExpr,")")}]})});return cleanupEmptyOnArray(signals)}function assembleFacetSignals(model,signals){if(model.component.selection&&keys(model.component.selection).length){const name=$(model.getName("cell"));signals.unshift({name:"facet",value:{},on:[{events:eventSelector("mousemove","scope"),update:"isTuple(facet) ? facet : group(".concat(name,").datum")}]})}return cleanupEmptyOnArray(signals)}function assembleTopLevelSignals(model,signals){let hasSelections=false;forEachSelection(model,(selCmpt,selCompiler)=>{const name=selCmpt.name;const store=$(name+STORE);const hasSg=signals.filter(s=>s.name===name);if(hasSg.length===0){const resolve=selCmpt.resolve==="global"?"union":selCmpt.resolve;const isMulti=selCmpt.type==="multi"?", true)":")";signals.push({name:selCmpt.name,update:"".concat(VL_SELECTION_RESOLVE,"(").concat(store,", ").concat($(resolve)).concat(isMulti)})}hasSelections=true;if(selCompiler.topLevelSignals){signals=selCompiler.topLevelSignals(model,selCmpt,signals)}forEachTransform(selCmpt,txCompiler=>{if(txCompiler.topLevelSignals){signals=txCompiler.topLevelSignals(model,selCmpt,signals)}})});if(hasSelections){const hasUnit=signals.filter(s=>s.name==="unit");if(hasUnit.length===0){signals.unshift({name:"unit",value:{},on:[{events:"mousemove",update:"isTuple(group()) ? group() : unit"}]})}}return cleanupEmptyOnArray(signals)}function assembleUnitSelectionData(model,data){const dataCopy=[...data];forEachSelection(model,selCmpt=>{const init={name:selCmpt.name+STORE};if(selCmpt.init){const fields=selCmpt.project.items.map(proj=>{const{signals:signals,...rest}=proj;return rest});const insert=selCmpt.init.map(i=>assembleInit(i,false));init.values=selCmpt.type==="interval"?[{unit:unitName(model,{escape:false}),fields:fields,values:insert}]:insert.map(i=>({unit:unitName(model,{escape:false}),fields:fields,values:i}))}const contains=dataCopy.filter(d=>d.name===selCmpt.name+STORE);if(!contains.length){dataCopy.push(init)}});return dataCopy}function assembleUnitSelectionMarks(model,marks){forEachSelection(model,(selCmpt,selCompiler)=>{marks=selCompiler.marks?selCompiler.marks(model,selCmpt,marks):marks;forEachTransform(selCmpt,txCompiler=>{if(txCompiler.marks){marks=txCompiler.marks(model,selCmpt,marks)}})});return marks}function assembleLayerSelectionMarks(model,marks){for(const child of model.children){if(isUnitModel(child)){marks=assembleUnitSelectionMarks(child,marks)}}return marks}function assembleSelectionScaleDomain(model,extent){const name=extent.selection;const selCmpt=model.getSelectionComponent(name,varName(name));return{signal:parseSelectionBinExtent(selCmpt,extent)}}function cleanupEmptyOnArray(signals){return signals.map(s=>{if(s.on&&!s.on.length)delete s.on;return s})}const BRUSH="_brush";const SCALE_TRIGGER="_scale_trigger";const interval={signals:(model,selCmpt)=>{const name=selCmpt.name;const fieldsSg=name+TUPLE_FIELDS;const hasScales=scaleBindings.has(selCmpt);const signals=[];const dataSignals=[];const scaleTriggers=[];if(selCmpt.translate&&!hasScales){const filterExpr="!event.item || event.item.mark.name !== ".concat($(name+BRUSH));events(selCmpt,(on,evt)=>{var _evt$between$0$filter;const filters=array((_evt$between$0$filter=evt.between[0].filter)!==null&&_evt$between$0$filter!==void 0?_evt$between$0$filter:evt.between[0].filter=[]);if(filters.indexOf(filterExpr)<0){filters.push(filterExpr)}return on})}selCmpt.project.items.forEach((proj,i)=>{const channel=proj.channel;if(channel!==X&&channel!==Y){warn("Interval selections only support x and y encoding channels.");return}const init=selCmpt.init?selCmpt.init[i]:null;const cs=channelSignals(model,selCmpt,proj,init);const dname=proj.signals.data;const vname=proj.signals.visual;const scaleName=$(model.scaleName(channel));const scaleType=model.getScaleComponent(channel).get("type");const toNum=hasContinuousDomain(scaleType)?"+":"";signals.push(...cs);dataSignals.push(dname);scaleTriggers.push({scaleName:model.scaleName(channel),expr:"(!isArray(".concat(dname,") || ")+"(".concat(toNum,"invert(").concat(scaleName,", ").concat(vname,")[0] === ").concat(toNum).concat(dname,"[0] && ")+"".concat(toNum,"invert(").concat(scaleName,", ").concat(vname,")[1] === ").concat(toNum).concat(dname,"[1]))")})});if(!hasScales){signals.push({name:name+SCALE_TRIGGER,value:{},on:[{events:scaleTriggers.map(t=>({scale:t.scaleName})),update:scaleTriggers.map(t=>t.expr).join(" && ")+" ? ".concat(name+SCALE_TRIGGER," : {}")}]})}const init=selCmpt.init;const update="unit: ".concat(unitName(model),", fields: ").concat(fieldsSg,", values");return signals.concat({name:name+TUPLE,...init?{init:"{".concat(update,": ").concat(assembleInit(init),"}")}:{},on:[{events:[{signal:dataSignals.join(" || ")}],update:dataSignals.join(" && ")+" ? {".concat(update,": [").concat(dataSignals,"]} : null")}]})},modifyExpr:(model,selCmpt)=>{const tpl=selCmpt.name+TUPLE;return tpl+", "+(selCmpt.resolve==="global"?"true":"{unit: ".concat(unitName(model),"}"))},marks:(model,selCmpt,marks)=>{const name=selCmpt.name;const{x:x,y:y}=selCmpt.project.hasChannel;const xvname=x&&x.signals.visual;const yvname=y&&y.signals.visual;const store="data(".concat($(selCmpt.name+STORE),")");if(scaleBindings.has(selCmpt)){return marks}const update={x:x!==undefined?{signal:"".concat(xvname,"[0]")}:{value:0},y:y!==undefined?{signal:"".concat(yvname,"[0]")}:{value:0},x2:x!==undefined?{signal:"".concat(xvname,"[1]")}:{field:{group:"width"}},y2:y!==undefined?{signal:"".concat(yvname,"[1]")}:{field:{group:"height"}}};if(selCmpt.resolve==="global"){for(const key of keys(update)){update[key]=[{test:"".concat(store,".length && ").concat(store,"[0].unit === ").concat(unitName(model)),...update[key]},{value:0}]}}const{fill:fill,fillOpacity:fillOpacity,cursor:cursor,...stroke}=selCmpt.mark;const vgStroke=keys(stroke).reduce((def,k)=>{def[k]=[{test:[x!==undefined&&"".concat(xvname,"[0] !== ").concat(xvname,"[1]"),y!==undefined&&"".concat(yvname,"[0] !== ").concat(yvname,"[1]")].filter(t=>t).join(" && "),value:stroke[k]},{value:null}];return def},{});return[{name:name+BRUSH+"_bg",type:"rect",clip:true,encode:{enter:{fill:{value:fill},fillOpacity:{value:fillOpacity}},update:update}},...marks,{name:name+BRUSH,type:"rect",clip:true,encode:{enter:{...cursor?{cursor:{value:cursor}}:{},fill:{value:"transparent"}},update:{...update,...vgStroke}}}]}};function channelSignals(model,selCmpt,proj,init){const channel=proj.channel;const vname=proj.signals.visual;const dname=proj.signals.data;const hasScales=scaleBindings.has(selCmpt);const scaleName=$(model.scaleName(channel));const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;const scaled=str=>"scale(".concat(scaleName,", ").concat(str,")");const size=model.getSizeSignalRef(channel===X?"width":"height").signal;const coord="".concat(channel,"(unit)");const on=events(selCmpt,(def,evt)=>[...def,{events:evt.between[0],update:"[".concat(coord,", ").concat(coord,"]")},{events:evt,update:"[".concat(vname,"[0], clamp(").concat(coord,", 0, ").concat(size,")]")}]);on.push({events:{signal:selCmpt.name+SCALE_TRIGGER},update:hasContinuousDomain(scaleType)?"[".concat(scaled("".concat(dname,"[0]")),", ").concat(scaled("".concat(dname,"[1]")),"]"):"[0, 0]"});return hasScales?[{name:dname,on:[]}]:[{name:vname,...init?{init:assembleInit(init,true,scaled)}:{value:[]},on:on},{name:dname,...init?{init:assembleInit(init)}:{},on:[{events:{signal:vname},update:"".concat(vname,"[0] === ").concat(vname,"[1] ? null : invert(").concat(scaleName,", ").concat(vname,")")}]}]}function events(selCmpt,cb){return selCmpt.events.reduce((on,evt)=>{if(!evt.between){warn("".concat(evt," is not an ordered event stream for interval selections."));return on}return cb(on,evt)},[])}function singleOrMultiSignals(model,selCmpt){const name=selCmpt.name;const fieldsSg=name+TUPLE_FIELDS;const project=selCmpt.project;const datum="(item().isVoronoi ? datum.datum : datum)";const values=project.items.map(p=>{const fieldDef=model.fieldDef(p.channel);return fieldDef&&fieldDef.bin?"[".concat(datum,"[").concat($(model.vgField(p.channel,{})),"], ")+"".concat(datum,"[").concat($(model.vgField(p.channel,{binSuffix:"end"})),"]]"):"".concat(datum,"[").concat($(p.field),"]")}).join(", ");const update="unit: ".concat(unitName(model),", fields: ").concat(fieldsSg,", values");const events=selCmpt.events;return[{name:name+TUPLE,on:events?[{events:events,update:"datum && item().mark.marktype !== 'group' ? {".concat(update,": [").concat(values,"]} : null"),force:true}]:[]}]}const multi={signals:singleOrMultiSignals,modifyExpr:(model,selCmpt)=>{const tpl=selCmpt.name+TUPLE;return tpl+", "+(selCmpt.resolve==="global"?"null":"{unit: ".concat(unitName(model),"}"))}};const single={signals:singleOrMultiSignals,modifyExpr:(model,selCmpt)=>{const tpl=selCmpt.name+TUPLE;return tpl+", "+(selCmpt.resolve==="global"?"true":"{unit: ".concat(unitName(model),"}"))}};const STORE="_store";const TUPLE="_tuple";const MODIFY="_modify";const VL_SELECTION_RESOLVE="vlSelectionResolve";const compilers$1={single:single,multi:multi,interval:interval};function forEachSelection(model,cb){const selections=model.component.selection;if(selections){for(const sel of vals(selections)){const success=cb(sel,compilers$1[sel.type]);if(success===true)break}}}function getFacetModel(model){let parent=model.parent;while(parent){if(isFacetModel(parent)){break}parent=parent.parent}return parent}function unitName(model,{escape:escape}={escape:true}){let name=escape?$(model.name):model.name;const facetModel=getFacetModel(model);if(facetModel){const{facet:facet}=facetModel;for(const channel of FACET_CHANNELS){if(facet[channel]){name+=" + '__facet_".concat(channel,"_' + (facet[").concat($(facetModel.vgField(channel)),"])")}}}return name}function requiresSelectionId(model){let identifier=false;forEachSelection(model,selCmpt=>{identifier=identifier||selCmpt.project.items.some(proj=>proj.field===SELECTION_ID)});return identifier}const RawCode="RawCode";const Literal="Literal";const Property="Property";const Identifier="Identifier";const ArrayExpression="ArrayExpression";const BinaryExpression="BinaryExpression";const CallExpression="CallExpression";const ConditionalExpression="ConditionalExpression";const LogicalExpression="LogicalExpression";const MemberExpression="MemberExpression";const ObjectExpression="ObjectExpression";const UnaryExpression="UnaryExpression";function ASTNode(type){this.type=type}ASTNode.prototype.visit=function(visitor){let c,i,n;if(visitor(this))return 1;for(c=children(this),i=0,n=c.length;i<n;++i){if(c[i].visit(visitor))return 1}};function children(node){switch(node.type){case ArrayExpression:return node.elements;case BinaryExpression:case LogicalExpression:return[node.left,node.right];case CallExpression:return[node.callee].concat(node.arguments);case ConditionalExpression:return[node.test,node.consequent,node.alternate];case MemberExpression:return[node.object,node.property];case ObjectExpression:return node.properties;case Property:return[node.key,node.value];case UnaryExpression:return[node.argument];case Identifier:case Literal:case RawCode:default:return[]}}var TokenName,source,index,length,lookahead;var TokenBooleanLiteral=1,TokenEOF=2,TokenIdentifier=3,TokenKeyword=4,TokenNullLiteral=5,TokenNumericLiteral=6,TokenPunctuator=7,TokenStringLiteral=8,TokenRegularExpression=9;TokenName={};TokenName[TokenBooleanLiteral]="Boolean";TokenName[TokenEOF]="<end>";TokenName[TokenIdentifier]="Identifier";TokenName[TokenKeyword]="Keyword";TokenName[TokenNullLiteral]="Null";TokenName[TokenNumericLiteral]="Numeric";TokenName[TokenPunctuator]="Punctuator";TokenName[TokenStringLiteral]="String";TokenName[TokenRegularExpression]="RegularExpression";var SyntaxArrayExpression="ArrayExpression",SyntaxBinaryExpression="BinaryExpression",SyntaxCallExpression="CallExpression",SyntaxConditionalExpression="ConditionalExpression",SyntaxIdentifier="Identifier",SyntaxLiteral="Literal",SyntaxLogicalExpression="LogicalExpression",SyntaxMemberExpression="MemberExpression",SyntaxObjectExpression="ObjectExpression",SyntaxProperty="Property",SyntaxUnaryExpression="UnaryExpression";var MessageUnexpectedToken="Unexpected token %0",MessageUnexpectedNumber="Unexpected number",MessageUnexpectedString="Unexpected string",MessageUnexpectedIdentifier="Unexpected identifier",MessageUnexpectedReserved="Unexpected reserved word",MessageUnexpectedEOS="Unexpected end of input",MessageInvalidRegExp="Invalid regular expression",MessageUnterminatedRegExp="Invalid regular expression: missing /",MessageStrictOctalLiteral="Octal literals are not allowed in strict mode.",MessageStrictDuplicateProperty="Duplicate data property in object literal not allowed in strict mode";var ILLEGAL$1="ILLEGAL",DISABLED="Disabled.";var RegexNonAsciiIdentifierStart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u08A0-\\u08B2\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1CE9-\\u1CEC\\u1CEE-\\u1CF1\\u1CF5\\u1CF6\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"),RegexNonAsciiIdentifierPart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u0800-\\u082D\\u0840-\\u085B\\u08A0-\\u08B2\\u08E4-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B56\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C03\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58\\u0C59\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C81-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D01-\\u0D03\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D57\\u0D60-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D82\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB9\\u0EBB-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1877\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19D9\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1CD0-\\u1CD2\\u1CD4-\\u1CF6\\u1CF8\\u1CF9\\u1D00-\\u1DF5\\u1DFC-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u2E2F\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099\\u309A\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA69D\\uA69F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA827\\uA840-\\uA873\\uA880-\\uA8C4\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA900-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2D\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]");function assert(condition,message){if(!condition){throw new Error("ASSERT: "+message)}}function isDecimalDigit(ch){return ch>=48&&ch<=57}function isHexDigit(ch){return"0123456789abcdefABCDEF".indexOf(ch)>=0}function isOctalDigit(ch){return"01234567".indexOf(ch)>=0}function isWhiteSpace(ch){return ch===32||ch===9||ch===11||ch===12||ch===160||ch>=5760&&[5760,6158,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8239,8287,12288,65279].indexOf(ch)>=0}function isLineTerminator(ch){return ch===10||ch===13||ch===8232||ch===8233}function isIdentifierStart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch===92||ch>=128&&RegexNonAsciiIdentifierStart.test(String.fromCharCode(ch))}function isIdentifierPart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch>=48&&ch<=57||ch===92||ch>=128&&RegexNonAsciiIdentifierPart.test(String.fromCharCode(ch))}const keywords={if:1,in:1,do:1,var:1,for:1,new:1,try:1,let:1,this:1,else:1,case:1,void:1,with:1,enum:1,while:1,break:1,catch:1,throw:1,const:1,yield:1,class:1,super:1,return:1,typeof:1,delete:1,switch:1,export:1,import:1,public:1,static:1,default:1,finally:1,extends:1,package:1,private:1,function:1,continue:1,debugger:1,interface:1,protected:1,instanceof:1,implements:1};function skipComment(){while(index<length){const ch=source.charCodeAt(index);if(isWhiteSpace(ch)||isLineTerminator(ch)){++index}else{break}}}function scanHexEscape(prefix){var i,len,ch,code=0;len=prefix==="u"?4:2;for(i=0;i<len;++i){if(index<length&&isHexDigit(source[index])){ch=source[index++];code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}else{throwError({},MessageUnexpectedToken,ILLEGAL$1)}}return String.fromCharCode(code)}function scanUnicodeCodePointEscape(){var ch,code,cu1,cu2;ch=source[index];code=0;if(ch==="}"){throwError({},MessageUnexpectedToken,ILLEGAL$1)}while(index<length){ch=source[index++];if(!isHexDigit(ch)){break}code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}if(code>1114111||ch!=="}"){throwError({},MessageUnexpectedToken,ILLEGAL$1)}if(code<=65535){return String.fromCharCode(code)}cu1=(code-65536>>10)+55296;cu2=(code-65536&1023)+56320;return String.fromCharCode(cu1,cu2)}function getEscapedIdentifier(){var ch,id;ch=source.charCodeAt(index++);id=String.fromCharCode(ch);if(ch===92){if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL$1)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierStart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}id=ch}while(index<length){ch=source.charCodeAt(index);if(!isIdentifierPart(ch)){break}++index;id+=String.fromCharCode(ch);if(ch===92){id=id.substr(0,id.length-1);if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL$1)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierPart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}id+=ch}}return id}function getIdentifier(){var start,ch;start=index++;while(index<length){ch=source.charCodeAt(index);if(ch===92){index=start;return getEscapedIdentifier()}if(isIdentifierPart(ch)){++index}else{break}}return source.slice(start,index)}function scanIdentifier(){var start,id,type;start=index;id=source.charCodeAt(index)===92?getEscapedIdentifier():getIdentifier();if(id.length===1){type=TokenIdentifier}else if(keywords.hasOwnProperty(id)){type=TokenKeyword}else if(id==="null"){type=TokenNullLiteral}else if(id==="true"||id==="false"){type=TokenBooleanLiteral}else{type=TokenIdentifier}return{type:type,value:id,start:start,end:index}}function scanPunctuator(){var start=index,code=source.charCodeAt(index),code2,ch1=source[index],ch2,ch3,ch4;switch(code){case 46:case 40:case 41:case 59:case 44:case 123:case 125:case 91:case 93:case 58:case 63:case 126:++index;return{type:TokenPunctuator,value:String.fromCharCode(code),start:start,end:index};default:code2=source.charCodeAt(index+1);if(code2===61){switch(code){case 43:case 45:case 47:case 60:case 62:case 94:case 124:case 37:case 38:case 42:index+=2;return{type:TokenPunctuator,value:String.fromCharCode(code)+String.fromCharCode(code2),start:start,end:index};case 33:case 61:index+=2;if(source.charCodeAt(index)===61){++index}return{type:TokenPunctuator,value:source.slice(start,index),start:start,end:index}}}}ch4=source.substr(index,4);if(ch4===">>>="){index+=4;return{type:TokenPunctuator,value:ch4,start:start,end:index}}ch3=ch4.substr(0,3);if(ch3===">>>"||ch3==="<<="||ch3===">>="){index+=3;return{type:TokenPunctuator,value:ch3,start:start,end:index}}ch2=ch3.substr(0,2);if(ch1===ch2[1]&&"+-<>&|".indexOf(ch1)>=0||ch2==="=>"){index+=2;return{type:TokenPunctuator,value:ch2,start:start,end:index}}if("<>=!+-*%&|^/".indexOf(ch1)>=0){++index;return{type:TokenPunctuator,value:ch1,start:start,end:index}}throwError({},MessageUnexpectedToken,ILLEGAL$1)}function scanHexLiteral(start){let number="";while(index<length){if(!isHexDigit(source[index])){break}number+=source[index++]}if(number.length===0){throwError({},MessageUnexpectedToken,ILLEGAL$1)}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}return{type:TokenNumericLiteral,value:parseInt("0x"+number,16),start:start,end:index}}function scanOctalLiteral(start){let number="0"+source[index++];while(index<length){if(!isOctalDigit(source[index])){break}number+=source[index++]}if(isIdentifierStart(source.charCodeAt(index))||isDecimalDigit(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}return{type:TokenNumericLiteral,value:parseInt(number,8),octal:true,start:start,end:index}}function scanNumericLiteral(){var number,start,ch;ch=source[index];assert(isDecimalDigit(ch.charCodeAt(0))||ch===".","Numeric literal must start with a decimal digit or a decimal point");start=index;number="";if(ch!=="."){number=source[index++];ch=source[index];if(number==="0"){if(ch==="x"||ch==="X"){++index;return scanHexLiteral(start)}if(isOctalDigit(ch)){return scanOctalLiteral(start)}if(ch&&isDecimalDigit(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}}while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="."){number+=source[index++];while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="e"||ch==="E"){number+=source[index++];ch=source[index];if(ch==="+"||ch==="-"){number+=source[index++]}if(isDecimalDigit(source.charCodeAt(index))){while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}}else{throwError({},MessageUnexpectedToken,ILLEGAL$1)}}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL$1)}return{type:TokenNumericLiteral,value:parseFloat(number),start:start,end:index}}function scanStringLiteral(){var str="",quote,start,ch,code,octal=false;quote=source[index];assert(quote==="'"||quote==='"',"String literal must starts with a quote");start=index;++index;while(index<length){ch=source[index++];if(ch===quote){quote="";break}else if(ch==="\\"){ch=source[index++];if(!ch||!isLineTerminator(ch.charCodeAt(0))){switch(ch){case"u":case"x":if(source[index]==="{"){++index;str+=scanUnicodeCodePointEscape()}else{str+=scanHexEscape(ch)}break;case"n":str+="\n";break;case"r":str+="\r";break;case"t":str+="\t";break;case"b":str+="\b";break;case"f":str+="\f";break;case"v":str+="\v";break;default:if(isOctalDigit(ch)){code="01234567".indexOf(ch);if(code!==0){octal=true}if(index<length&&isOctalDigit(source[index])){octal=true;code=code*8+"01234567".indexOf(source[index++]);if("0123".indexOf(ch)>=0&&index<length&&isOctalDigit(source[index])){code=code*8+"01234567".indexOf(source[index++])}}str+=String.fromCharCode(code)}else{str+=ch}break}}else{if(ch==="\r"&&source[index]==="\n"){++index}}}else if(isLineTerminator(ch.charCodeAt(0))){break}else{str+=ch}}if(quote!==""){throwError({},MessageUnexpectedToken,ILLEGAL$1)}return{type:TokenStringLiteral,value:str,octal:octal,start:start,end:index}}function testRegExp(pattern,flags){let tmp=pattern;if(flags.indexOf("u")>=0){tmp=tmp.replace(/\\u\{([0-9a-fA-F]+)\}/g,($0,$1)=>{if(parseInt($1,16)<=1114111){return"x"}throwError({},MessageInvalidRegExp)}).replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,"x")}try{new RegExp(tmp)}catch(e){throwError({},MessageInvalidRegExp)}try{return new RegExp(pattern,flags)}catch(exception){return null}}function scanRegExpBody(){var ch,str,classMarker,terminated,body;ch=source[index];assert(ch==="/","Regular expression literal must start with a slash");str=source[index++];classMarker=false;terminated=false;while(index<length){ch=source[index++];str+=ch;if(ch==="\\"){ch=source[index++];if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}str+=ch}else if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}else if(classMarker){if(ch==="]"){classMarker=false}}else{if(ch==="/"){terminated=true;break}else if(ch==="["){classMarker=true}}}if(!terminated){throwError({},MessageUnterminatedRegExp)}body=str.substr(1,str.length-2);return{value:body,literal:str}}function scanRegExpFlags(){var ch,str,flags;str="";flags="";while(index<length){ch=source[index];if(!isIdentifierPart(ch.charCodeAt(0))){break}++index;if(ch==="\\"&&index<length){throwError({},MessageUnexpectedToken,ILLEGAL$1)}else{flags+=ch;str+=ch}}if(flags.search(/[^gimuy]/g)>=0){throwError({},MessageInvalidRegExp,flags)}return{value:flags,literal:str}}function scanRegExp(){var start,body,flags,value;lookahead=null;skipComment();start=index;body=scanRegExpBody();flags=scanRegExpFlags();value=testRegExp(body.value,flags.value);return{literal:body.literal+flags.literal,value:value,regex:{pattern:body.value,flags:flags.value},start:start,end:index}}function isIdentifierName(token){return token.type===TokenIdentifier||token.type===TokenKeyword||token.type===TokenBooleanLiteral||token.type===TokenNullLiteral}function advance(){skipComment();if(index>=length){return{type:TokenEOF,start:index,end:index}}const ch=source.charCodeAt(index);if(isIdentifierStart(ch)){return scanIdentifier()}if(ch===40||ch===41||ch===59){return scanPunctuator()}if(ch===39||ch===34){return scanStringLiteral()}if(ch===46){if(isDecimalDigit(source.charCodeAt(index+1))){return scanNumericLiteral()}return scanPunctuator()}if(isDecimalDigit(ch)){return scanNumericLiteral()}return scanPunctuator()}function lex(){const token=lookahead;index=token.end;lookahead=advance();index=token.end;return token}function peek(){const pos=index;lookahead=advance();index=pos}function finishArrayExpression(elements){const node=new ASTNode(SyntaxArrayExpression);node.elements=elements;return node}function finishBinaryExpression(operator,left,right){const node=new ASTNode(operator==="||"||operator==="&&"?SyntaxLogicalExpression:SyntaxBinaryExpression);node.operator=operator;node.left=left;node.right=right;return node}function finishCallExpression(callee,args){const node=new ASTNode(SyntaxCallExpression);node.callee=callee;node.arguments=args;return node}function finishConditionalExpression(test,consequent,alternate){const node=new ASTNode(SyntaxConditionalExpression);node.test=test;node.consequent=consequent;node.alternate=alternate;return node}function finishIdentifier(name){const node=new ASTNode(SyntaxIdentifier);node.name=name;return node}function finishLiteral(token){const node=new ASTNode(SyntaxLiteral);node.value=token.value;node.raw=source.slice(token.start,token.end);if(token.regex){if(node.raw==="//"){node.raw="/(?:)/"}node.regex=token.regex}return node}function finishMemberExpression(accessor,object,property){const node=new ASTNode(SyntaxMemberExpression);node.computed=accessor==="[";node.object=object;node.property=property;if(!node.computed)property.member=true;return node}function finishObjectExpression(properties){const node=new ASTNode(SyntaxObjectExpression);node.properties=properties;return node}function finishProperty(kind,key,value){const node=new ASTNode(SyntaxProperty);node.key=key;node.value=value;node.kind=kind;return node}function finishUnaryExpression(operator,argument){const node=new ASTNode(SyntaxUnaryExpression);node.operator=operator;node.argument=argument;node.prefix=true;return node}function throwError(token,messageFormat){var error,args=Array.prototype.slice.call(arguments,2),msg=messageFormat.replace(/%(\d)/g,(whole,index)=>{assert(index<args.length,"Message reference must be in range");return args[index]});error=new Error(msg);error.index=index;error.description=msg;throw error}function throwUnexpected(token){if(token.type===TokenEOF){throwError(token,MessageUnexpectedEOS)}if(token.type===TokenNumericLiteral){throwError(token,MessageUnexpectedNumber)}if(token.type===TokenStringLiteral){throwError(token,MessageUnexpectedString)}if(token.type===TokenIdentifier){throwError(token,MessageUnexpectedIdentifier)}if(token.type===TokenKeyword){throwError(token,MessageUnexpectedReserved)}throwError(token,MessageUnexpectedToken,token.value)}function expect(value){const token=lex();if(token.type!==TokenPunctuator||token.value!==value){throwUnexpected(token)}}function match(value){return lookahead.type===TokenPunctuator&&lookahead.value===value}function matchKeyword(keyword){return lookahead.type===TokenKeyword&&lookahead.value===keyword}function parseArrayInitialiser(){const elements=[];index=lookahead.start;expect("[");while(!match("]")){if(match(",")){lex();elements.push(null)}else{elements.push(parseConditionalExpression());if(!match("]")){expect(",")}}}lex();return finishArrayExpression(elements)}function parseObjectPropertyKey(){index=lookahead.start;const token=lex();if(token.type===TokenStringLiteral||token.type===TokenNumericLiteral){if(token.octal){throwError(token,MessageStrictOctalLiteral)}return finishLiteral(token)}return finishIdentifier(token.value)}function parseObjectProperty(){var token,key,id,value;index=lookahead.start;token=lookahead;if(token.type===TokenIdentifier){id=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",id,value)}if(token.type===TokenEOF||token.type===TokenPunctuator){throwUnexpected(token)}else{key=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",key,value)}}function parseObjectInitialiser(){var properties=[],property,name,key,map={},toString=String;index=lookahead.start;expect("{");while(!match("}")){property=parseObjectProperty();if(property.key.type===SyntaxIdentifier){name=property.key.name}else{name=toString(property.key.value)}key="$"+name;if(Object.prototype.hasOwnProperty.call(map,key)){throwError({},MessageStrictDuplicateProperty)}else{map[key]=true}properties.push(property);if(!match("}")){expect(",")}}expect("}");return finishObjectExpression(properties)}function parseGroupExpression(){expect("(");const expr=parseExpression();expect(")");return expr}const legalKeywords={if:1};function parsePrimaryExpression(){var type,token,expr;if(match("(")){return parseGroupExpression()}if(match("[")){return parseArrayInitialiser()}if(match("{")){return parseObjectInitialiser()}type=lookahead.type;index=lookahead.start;if(type===TokenIdentifier||legalKeywords[lookahead.value]){expr=finishIdentifier(lex().value)}else if(type===TokenStringLiteral||type===TokenNumericLiteral){if(lookahead.octal){throwError(lookahead,MessageStrictOctalLiteral)}expr=finishLiteral(lex())}else if(type===TokenKeyword){throw new Error(DISABLED)}else if(type===TokenBooleanLiteral){token=lex();token.value=token.value==="true";expr=finishLiteral(token)}else if(type===TokenNullLiteral){token=lex();token.value=null;expr=finishLiteral(token)}else if(match("/")||match("/=")){expr=finishLiteral(scanRegExp());peek()}else{throwUnexpected(lex())}return expr}function parseArguments(){const args=[];expect("(");if(!match(")")){while(index<length){args.push(parseConditionalExpression());if(match(")")){break}expect(",")}}expect(")");return args}function parseNonComputedProperty(){index=lookahead.start;const token=lex();if(!isIdentifierName(token)){throwUnexpected(token)}return finishIdentifier(token.value)}function parseNonComputedMember(){expect(".");return parseNonComputedProperty()}function parseComputedMember(){expect("[");const expr=parseExpression();expect("]");return expr}function parseLeftHandSideExpressionAllowCall(){var expr,args,property;expr=parsePrimaryExpression();for(;;){if(match(".")){property=parseNonComputedMember();expr=finishMemberExpression(".",expr,property)}else if(match("(")){args=parseArguments();expr=finishCallExpression(expr,args)}else if(match("[")){property=parseComputedMember();expr=finishMemberExpression("[",expr,property)}else{break}}return expr}function parsePostfixExpression(){const expr=parseLeftHandSideExpressionAllowCall();if(lookahead.type===TokenPunctuator){if(match("++")||match("--")){throw new Error(DISABLED)}}return expr}function parseUnaryExpression(){var token,expr;if(lookahead.type!==TokenPunctuator&&lookahead.type!==TokenKeyword){expr=parsePostfixExpression()}else if(match("++")||match("--")){throw new Error(DISABLED)}else if(match("+")||match("-")||match("~")||match("!")){token=lex();expr=parseUnaryExpression();expr=finishUnaryExpression(token.value,expr)}else if(matchKeyword("delete")||matchKeyword("void")||matchKeyword("typeof")){throw new Error(DISABLED)}else{expr=parsePostfixExpression()}return expr}function binaryPrecedence(token){let prec=0;if(token.type!==TokenPunctuator&&token.type!==TokenKeyword){return 0}switch(token.value){case"||":prec=1;break;case"&&":prec=2;break;case"|":prec=3;break;case"^":prec=4;break;case"&":prec=5;break;case"==":case"!=":case"===":case"!==":prec=6;break;case"<":case">":case"<=":case">=":case"instanceof":case"in":prec=7;break;case"<<":case">>":case">>>":prec=8;break;case"+":case"-":prec=9;break;case"*":case"/":case"%":prec=11;break}return prec}function parseBinaryExpression(){var marker,markers,expr,token,prec,stack,right,operator,left,i;marker=lookahead;left=parseUnaryExpression();token=lookahead;prec=binaryPrecedence(token);if(prec===0){return left}token.prec=prec;lex();markers=[marker,lookahead];right=parseUnaryExpression();stack=[left,token,right];while((prec=binaryPrecedence(lookahead))>0){while(stack.length>2&&prec<=stack[stack.length-2].prec){right=stack.pop();operator=stack.pop().value;left=stack.pop();markers.pop();expr=finishBinaryExpression(operator,left,right);stack.push(expr)}token=lex();token.prec=prec;stack.push(token);markers.push(lookahead);expr=parseUnaryExpression();stack.push(expr)}i=stack.length-1;expr=stack[i];markers.pop();while(i>1){markers.pop();expr=finishBinaryExpression(stack[i-1].value,stack[i-2],expr);i-=2}return expr}function parseConditionalExpression(){var expr,consequent,alternate;expr=parseBinaryExpression();if(match("?")){lex();consequent=parseConditionalExpression();expect(":");alternate=parseConditionalExpression();expr=finishConditionalExpression(expr,consequent,alternate)}return expr}function parseExpression(){const expr=parseConditionalExpression();if(match(",")){throw new Error(DISABLED)}return expr}function parser(code){source=code;index=0;length=source.length;lookahead=null;peek();const expr=parseExpression();if(lookahead.type!==TokenEOF){throw new Error("Unexpect token after expression.")}return expr}function getName(node){const name=[];if(node.type==="Identifier"){return[node.name]}if(node.type==="Literal"){return[node.value]}if(node.type==="MemberExpression"){name.push(...getName(node.object));name.push(...getName(node.property))}return name}function startsWithDatum(node){if(node.object.type==="MemberExpression"){return startsWithDatum(node.object)}return node.object.name==="datum"}function getDependentFields(expression){const ast=parser(expression);const dependents=new Set;ast.visit(node=>{if(node.type==="MemberExpression"&&startsWithDatum(node)){dependents.add(getName(node).slice(1).join("."))}});return dependents}class FilterNode extends DataFlowNode{clone(){return new FilterNode(null,this.model,duplicate(this.filter))}constructor(parent,model,filter){super(parent);this.model=model;this.filter=filter;_defineProperty(this,"expr",void 0);_defineProperty(this,"_dependentFields",void 0);this.expr=expression(this.model,this.filter,this);this._dependentFields=getDependentFields(this.expr)}dependentFields(){return this._dependentFields}producedFields(){return new Set}assemble(){return{type:"filter",expr:this.expr}}hash(){return"Filter ".concat(this.expr)}}function parseUnitSelection(model,selDefs){const selCmpts={};const selectionConfig=model.config.selection;for(const name of keys(selDefs!==null&&selDefs!==void 0?selDefs:{})){const selDef=duplicate(selDefs[name]);const{fields:fields,encodings:encodings,...cfg}=selectionConfig[selDef.type];for(const key in cfg){if(key==="encodings"&&selDef.fields||key==="fields"&&selDef.encodings){continue}if(key==="mark"){selDef[key]={...cfg[key],...selDef[key]}}if(selDef[key]===undefined||selDef[key]===true){var _cfg$key;selDef[key]=(_cfg$key=cfg[key])!==null&&_cfg$key!==void 0?_cfg$key:selDef[key]}}const safeName=varName(name);const selCmpt=selCmpts[safeName]={...selDef,name:safeName,events:isString(selDef.on)?eventSelector(selDef.on,"scope"):duplicate(selDef.on)};forEachTransform(selCmpt,txCompiler=>{if(txCompiler.has(selCmpt)&&txCompiler.parse){txCompiler.parse(model,selCmpt,selDef,selDefs[name])}})}return selCmpts}function parseSelectionPredicate(model,selections,dfnode,datum="datum"){const stores=[];function expr(name){const vname=varName(name);const selCmpt=model.getSelectionComponent(vname,name);const store=$(vname+STORE);if(selCmpt.project.timeUnit){const child=dfnode!==null&&dfnode!==void 0?dfnode:model.component.data.raw;const tunode=selCmpt.project.timeUnit.clone();if(child.parent){tunode.insertAsParentOf(child)}else{child.parent=tunode}}if(selCmpt.empty!=="none"){stores.push(store)}return"vlSelectionTest(".concat(store,", ").concat(datum)+(selCmpt.resolve==="global"?")":", ".concat($(selCmpt.resolve),")"))}const predicateStr=logicalExpr(selections,expr);return(stores.length?"!("+stores.map(s=>"length(data(".concat(s,"))")).join(" || ")+") || ":"")+"(".concat(predicateStr,")")}function parseSelectionBinExtent(selCmpt,extent){const encoding=extent["encoding"];let field=extent["field"];if(!encoding&&!field){field=selCmpt.project.items[0].field;if(selCmpt.project.items.length>1){warn('A "field" or "encoding" must be specified when using a selection as a scale domain. '+'Using "field": '.concat($(field),"."))}}else if(encoding&&!field){const encodings=selCmpt.project.items.filter(p=>p.channel===encoding);if(!encodings.length||encodings.length>1){field=selCmpt.project.items[0].field;warn((!encodings.length?"No ":"Multiple ")+"matching ".concat($(encoding)," encoding found for selection ").concat($(extent.selection),". ")+'Using "field": '.concat($(field),"."))}else{field=encodings[0].field}}return"".concat(selCmpt.name,"[").concat($(field),"]")}function materializeSelections(model,main){forEachSelection(model,selCmpt=>{const selection=selCmpt.name;const lookupName=model.getName("lookup_".concat(selection));model.component.data.outputNodes[lookupName]=selCmpt.materialized=new OutputNode(new FilterNode(main,model,{selection:selection}),lookupName,DataSourceType.Lookup,model.component.data.outputNodeRefCounts)})}function expression(model,filterOp,node){return logicalExpr(filterOp,predicate=>{if(isString(predicate)){return predicate}else if(isSelectionPredicate(predicate)){return parseSelectionPredicate(model,predicate.selection,node)}else{return fieldFilterExpression(predicate)}})}function assembleTitle(title,config){if(!title){return undefined}if(isArray(title)&&!isText(title)){return title.map(fieldDef=>defaultTitle(fieldDef,config)).join(", ")}return title}function setAxisEncode(axis,part,vgProp,vgRef){var _axis$encode,_axis$encode$part,_axis$encode$part$upd;axis.encode=(_axis$encode=axis.encode)!==null&&_axis$encode!==void 0?_axis$encode:{};axis.encode[part]=(_axis$encode$part=axis.encode[part])!==null&&_axis$encode$part!==void 0?_axis$encode$part:{};axis.encode[part].update=(_axis$encode$part$upd=axis.encode[part].update)!==null&&_axis$encode$part$upd!==void 0?_axis$encode$part$upd:{};axis.encode[part].update[vgProp]=vgRef}function assembleAxis(axisCmpt,kind,config,opt={header:false}){const{disable:disable,orient:orient,scale:scale,labelExpr:labelExpr,title:title,zindex:zindex,...axis}=axisCmpt.combine();if(disable){return undefined}for(const prop in axis){const propType=AXIS_PROPERTY_TYPE[prop];const propValue=axis[prop];if(propType&&propType!==kind&&propType!=="both"){delete axis[prop]}else if(isConditionalAxisValue(propValue)){const{condition:condition,...valueOrSignalRef}=propValue;const conditions=array(condition);const propIndex=CONDITIONAL_AXIS_PROP_INDEX[prop];if(propIndex){const{vgProp:vgProp,part:part}=propIndex;const vgRef=[...conditions.map(c=>{const{test:test,...valueOrSignalCRef}=c;return{test:expression(null,test),...valueOrSignalCRef}}),valueOrSignalRef];setAxisEncode(axis,part,vgProp,vgRef);delete axis[prop]}else if(propIndex===null){const signalRef={signal:conditions.map(c=>{const{test:test,...valueOrSignalCRef}=c;return"".concat(expression(null,test)," ? ").concat(exprFromValueOrSignalRef(valueOrSignalCRef)," : ")}).join("")+exprFromValueOrSignalRef(valueOrSignalRef)};axis[prop]=signalRef}}else if(isSignalRef(propValue)){const propIndex=CONDITIONAL_AXIS_PROP_INDEX[prop];if(propIndex){const{vgProp:vgProp,part:part}=propIndex;setAxisEncode(axis,part,vgProp,propValue);delete axis[prop]}}}if(kind==="grid"){if(!axis.grid){return undefined}if(axis.encode){const{grid:grid}=axis.encode;axis.encode={...grid?{grid:grid}:{}};if(isEmpty(axis.encode)){delete axis.encode}}return{scale:scale,orient:orient,...axis,domain:false,labels:false,aria:false,maxExtent:0,minExtent:0,ticks:false,zindex:getFirstDefined(zindex,0)}}else{if(!opt.header&&axisCmpt.mainExtracted){return undefined}if(labelExpr!==undefined){var _axis$encode2,_axis$encode2$labels;let expr=labelExpr;if(((_axis$encode2=axis.encode)===null||_axis$encode2===void 0?void 0:(_axis$encode2$labels=_axis$encode2.labels)===null||_axis$encode2$labels===void 0?void 0:_axis$encode2$labels.update)&&isSignalRef(axis.encode.labels.update.text)){expr=replaceAll(labelExpr,"datum.label",axis.encode.labels.update.text.signal)}setAxisEncode(axis,"labels","text",{signal:expr})}if(axis.labelAlign===null){delete axis.labelAlign}if(axis.encode){for(const part of AXIS_PARTS){if(!axisCmpt.hasAxisPart(part)){delete axis.encode[part]}}if(isEmpty(axis.encode)){delete axis.encode}}const titleString=assembleTitle(title,config);return{scale:scale,orient:orient,grid:false,...titleString?{title:titleString}:{},...axis,...config.aria===false?{aria:false}:{},zindex:getFirstDefined(zindex,0)}}}function assembleAxisSignals(model){const{axes:axes}=model.component;const signals=[];for(const channel of POSITION_SCALE_CHANNELS){if(axes[channel]){for(const axis of axes[channel]){if(!axis.get("disable")&&!axis.get("gridScale")){const sizeType=channel==="x"?"height":"width";const update=model.getSizeSignalRef(sizeType).signal;if(sizeType!==update){signals.push({name:sizeType,update:update})}}}}}return signals}function assembleAxes(axisComponents,config){const{x:x=[],y:y=[]}=axisComponents;return[...x.map(a=>assembleAxis(a,"grid",config)),...y.map(a=>assembleAxis(a,"grid",config)),...x.map(a=>assembleAxis(a,"main",config)),...y.map(a=>assembleAxis(a,"main",config))].filter(a=>a)}function getAxisConfigFromConfigTypes(configTypes,config,channel,orient){return Object.assign.apply(null,[{},...configTypes.map(configType=>{if(configType==="axisOrient"){const orient1=channel==="x"?"bottom":"left";const orientConfig1=config[channel==="x"?"axisBottom":"axisLeft"]||{};const orientConfig2=config[channel==="x"?"axisTop":"axisRight"]||{};const props=new Set([...keys(orientConfig1),...keys(orientConfig2)]);const conditionalOrientAxisConfig={};for(const prop of props.values()){conditionalOrientAxisConfig[prop]={signal:"".concat(orient["signal"],' === "').concat(orient1,'" ? ').concat(signalOrStringValue(orientConfig1[prop])," : ").concat(signalOrStringValue(orientConfig2[prop]))}}return conditionalOrientAxisConfig}return config[configType]})])}function getAxisConfigs(channel,scaleType,orient,config){const typeBasedConfigTypes=scaleType==="band"?["axisDiscrete","axisBand"]:scaleType==="point"?["axisDiscrete","axisPoint"]:isQuantitative(scaleType)?["axisQuantitative"]:scaleType==="time"||scaleType==="utc"?["axisTemporal"]:[];const axisChannel=channel==="x"?"axisX":"axisY";const axisOrient=isSignalRef(orient)?"axisOrient":"axis"+titleCase(orient);const vlOnlyConfigTypes=[...typeBasedConfigTypes,...typeBasedConfigTypes.map(c=>axisChannel+c.substr(4))];const vgConfigTypes=["axis",axisOrient,axisChannel];return{vlOnlyAxisConfig:getAxisConfigFromConfigTypes(vlOnlyConfigTypes,config,channel,orient),vgAxisConfig:getAxisConfigFromConfigTypes(vgConfigTypes,config,channel,orient),axisConfigStyle:getAxisConfigStyle([...vgConfigTypes,...vlOnlyConfigTypes],config)}}function getAxisConfigStyle(axisConfigTypes,config){const toMerge=[{}];for(const configType of axisConfigTypes){var _config$configType;let style=(_config$configType=config[configType])===null||_config$configType===void 0?void 0:_config$configType.style;if(style){style=array(style);for(const s of style){toMerge.push(config.style[s])}}}return Object.assign.apply(null,toMerge)}function getAxisConfig(property,styleConfigIndex,style,axisConfigs={}){const styleConfig=getStyleConfig(property,style,styleConfigIndex);if(styleConfig!==undefined){return{configFrom:"style",configValue:styleConfig}}for(const configFrom of["vlOnlyAxisConfig","vgAxisConfig","axisConfigStyle"]){var _axisConfigs$configFr;if(((_axisConfigs$configFr=axisConfigs[configFrom])===null||_axisConfigs$configFr===void 0?void 0:_axisConfigs$configFr[property])!==undefined){return{configFrom:configFrom,configValue:axisConfigs[configFrom][property]}}}return{}}const axisRules={scale:({model:model,channel:channel})=>model.scaleName(channel),format:({fieldOrDatumDef:fieldOrDatumDef,config:config,axis:axis})=>{const{format:format,formatType:formatType}=axis;return guideFormat(fieldOrDatumDef,fieldOrDatumDef.type,format,formatType,config,true)},formatType:({axis:axis,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType})=>{const{formatType:formatType}=axis;return guideFormatType(formatType,fieldOrDatumDef,scaleType)},grid:({fieldOrDatumDef:fieldOrDatumDef,axis:axis,scaleType:scaleType})=>{if(isFieldDef(fieldOrDatumDef)&&isBinned(fieldOrDatumDef.bin)){return false}else{var _axis$grid;return(_axis$grid=axis.grid)!==null&&_axis$grid!==void 0?_axis$grid:defaultGrid(scaleType,fieldOrDatumDef)}},gridScale:({model:model,channel:channel})=>gridScale(model,channel),labelAlign:({axis:axis,labelAngle:labelAngle,orient:orient,channel:channel})=>axis.labelAlign||defaultLabelAlign(labelAngle,orient,channel),labelAngle:({labelAngle:labelAngle})=>labelAngle,labelBaseline:({axis:axis,labelAngle:labelAngle,orient:orient,channel:channel})=>axis.labelBaseline||defaultLabelBaseline(labelAngle,orient,channel),labelFlush:({axis:axis,fieldOrDatumDef:fieldOrDatumDef,channel:channel})=>{var _axis$labelFlush;return(_axis$labelFlush=axis.labelFlush)!==null&&_axis$labelFlush!==void 0?_axis$labelFlush:defaultLabelFlush(fieldOrDatumDef.type,channel)},labelOverlap:({axis:axis,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType})=>{var _axis$labelOverlap;return(_axis$labelOverlap=axis.labelOverlap)!==null&&_axis$labelOverlap!==void 0?_axis$labelOverlap:defaultLabelOverlap(fieldOrDatumDef.type,scaleType,isFieldDef(fieldOrDatumDef)&&!!fieldOrDatumDef.timeUnit,isFieldDef(fieldOrDatumDef)?fieldOrDatumDef.sort:undefined)},orient:({orient:orient})=>orient,tickCount:({channel:channel,model:model,axis:axis,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType})=>{var _axis$tickCount;const sizeType=channel==="x"?"width":channel==="y"?"height":undefined;const size=sizeType?model.getSizeSignalRef(sizeType):undefined;return(_axis$tickCount=axis.tickCount)!==null&&_axis$tickCount!==void 0?_axis$tickCount:defaultTickCount({fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,size:size,values:axis.values})},title:({axis:axis,model:model,channel:channel})=>{if(axis.title!==undefined){return axis.title}const fieldDefTitle=getFieldDefTitle(model,channel);if(fieldDefTitle!==undefined){return fieldDefTitle}const fieldDef=model.typedFieldDef(channel);const channel2=channel==="x"?"x2":"y2";const fieldDef2=model.fieldDef(channel2);return mergeTitleFieldDefs(fieldDef?[toFieldDefBase(fieldDef)]:[],isFieldDef(fieldDef2)?[toFieldDefBase(fieldDef2)]:[])},values:({axis:axis,fieldOrDatumDef:fieldOrDatumDef})=>values(axis,fieldOrDatumDef),zindex:({axis:axis,fieldOrDatumDef:fieldOrDatumDef,mark:mark})=>{var _axis$zindex;return(_axis$zindex=axis.zindex)!==null&&_axis$zindex!==void 0?_axis$zindex:defaultZindex(mark,fieldOrDatumDef)}};function defaultGrid(scaleType,fieldDef){return!hasDiscreteDomain(scaleType)&&isFieldDef(fieldDef)&&!isBinning(fieldDef===null||fieldDef===void 0?void 0:fieldDef.bin)}function gridScale(model,channel){const gridChannel=channel==="x"?"y":"x";if(model.getScaleComponent(gridChannel)){return model.scaleName(gridChannel)}return undefined}function getLabelAngle(fieldOrDatumDef,axis,channel,styleConfig,axisConfigs){const labelAngle=axis===null||axis===void 0?void 0:axis.labelAngle;if(labelAngle!==undefined){return isSignalRef(labelAngle)?labelAngle:normalizeAngle(labelAngle)}else{const{configValue:angle}=getAxisConfig("labelAngle",styleConfig,axis===null||axis===void 0?void 0:axis.style,axisConfigs);if(angle!==undefined){return normalizeAngle(angle)}else{if(channel===X&&contains([NOMINAL,ORDINAL],fieldOrDatumDef.type)&&!(isFieldDef(fieldOrDatumDef)&&fieldOrDatumDef.timeUnit)){return 270}return undefined}}}function normalizeAngleExpr(angle){return"(((".concat(angle.signal," % 360) + 360) % 360)")}function defaultLabelBaseline(angle,orient,channel,alwaysIncludeMiddle){if(angle!==undefined){if(channel==="x"){if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsTop=isSignalRef(orient)?"(".concat(orient.signal,' === "top")'):orient==="top";return{signal:"(45 < ".concat(a," && ").concat(a," < 135) || (225 < ").concat(a," && ").concat(a,' < 315) ? "middle" :')+"(".concat(a," <= 45 || 315 <= ").concat(a,") === ").concat(orientIsTop,' ? "bottom" : "top"')}}if(45<angle&&angle<135||225<angle&&angle<315){return"middle"}if(isSignalRef(orient)){const op=angle<=45||315<=angle?"===":"!==";return{signal:"".concat(orient.signal," ").concat(op,' "top" ? "bottom" : "top"')}}return(angle<=45||315<=angle)===(orient==="top")?"bottom":"top"}else{if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsLeft=isSignalRef(orient)?"(".concat(orient.signal,' === "left")'):orient==="left";const middle=alwaysIncludeMiddle?'"middle"':"null";return{signal:"".concat(a," <= 45 || 315 <= ").concat(a," || (135 <= ").concat(a," && ").concat(a," <= 225) ? ").concat(middle," : (45 <= ").concat(a," && ").concat(a," <= 135) === ").concat(orientIsLeft,' ? "top" : "bottom"')}}if(angle<=45||315<=angle||135<=angle&&angle<=225){return alwaysIncludeMiddle?"middle":null}if(isSignalRef(orient)){const op=45<=angle&&angle<=135?"===":"!==";return{signal:"".concat(orient.signal," ").concat(op,' "left" ? "top" : "bottom"')}}return(45<=angle&&angle<=135)===(orient==="left")?"top":"bottom"}}return undefined}function defaultLabelAlign(angle,orient,channel){if(angle===undefined){return undefined}const isX=channel==="x";const startAngle=isX?0:90;const mainOrient=isX?"bottom":"left";if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsMain=isSignalRef(orient)?"(".concat(orient.signal,' === "').concat(mainOrient,'")'):orient===mainOrient;return{signal:"(".concat(startAngle?"("+a+" + 90)":a," % 180 === 0) ? ").concat(isX?null:'"center"'," :")+"(".concat(startAngle," < ").concat(a," && ").concat(a," < ").concat(180+startAngle,") === ").concat(orientIsMain,' ? "left" : "right"')}}if((angle+startAngle)%180===0){return isX?null:"center"}if(isSignalRef(orient)){const op=startAngle<angle&&angle<180+startAngle?"===":"!==";const orientIsMain="".concat(orient.signal," ").concat(op,' "').concat(mainOrient,'"');return{signal:"".concat(orientIsMain,' ? "left" : "right"')}}if((startAngle<angle&&angle<180+startAngle)===(orient===mainOrient)){return"left"}return"right"}function defaultLabelFlush(type,channel){if(channel==="x"&&contains(["quantitative","temporal"],type)){return true}return undefined}function defaultLabelOverlap(type,scaleType,hasTimeUnit,sort){if(hasTimeUnit&&!isObject(sort)||type!=="nominal"&&type!=="ordinal"){if(scaleType==="log"||scaleType==="symlog"){return"greedy"}return true}return undefined}function defaultOrient(channel){return channel==="x"?"bottom":"left"}function defaultTickCount({fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,size:size,values:vals}){if(!vals&&!hasDiscreteDomain(scaleType)&&scaleType!=="log"){if(isFieldDef(fieldOrDatumDef)){var _normalizeTimeUnit;if(isBinning(fieldOrDatumDef.bin)){return{signal:"ceil(".concat(size.signal,"/10)")}}if(fieldOrDatumDef.timeUnit&&contains(["month","hours","day","quarter"],(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit)){return undefined}}return{signal:"ceil(".concat(size.signal,"/40)")}}return undefined}function getFieldDefTitle(model,channel){const channel2=channel==="x"?"x2":"y2";const fieldDef=model.fieldDef(channel);const fieldDef2=model.fieldDef(channel2);const title1=fieldDef?fieldDef.title:undefined;const title2=fieldDef2?fieldDef2.title:undefined;if(title1&&title2){return mergeTitle(title1,title2)}else if(title1){return title1}else if(title2){return title2}else if(title1!==undefined){return title1}else if(title2!==undefined){return title2}return undefined}function values(axis,fieldOrDatumDef){const vals=axis.values;if(isArray(vals)){return valueArray(fieldOrDatumDef,vals)}else if(isSignalRef(vals)){return vals}return undefined}function defaultZindex(mark,fieldDef){if(mark==="rect"&&isDiscrete(fieldDef)){return 1}return 0}class CalculateNode extends DataFlowNode{clone(){return new CalculateNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform;_defineProperty(this,"_dependentFields",void 0);this._dependentFields=getDependentFields(this.transform.calculate)}static parseAllForSortIndex(parent,model){model.forEachFieldDef((fieldDef,channel)=>{if(!isScaleFieldDef(fieldDef)){return}if(isSortArray(fieldDef.sort)){const{field:field,timeUnit:timeUnit}=fieldDef;const sort=fieldDef.sort;const calculate=sort.map((sortValue,i)=>"".concat(fieldFilterExpression({field:field,timeUnit:timeUnit,equal:sortValue})," ? ").concat(i," : ")).join("")+sort.length;parent=new CalculateNode(parent,{calculate:calculate,as:sortArrayIndexField(fieldDef,channel,{forAs:true})})}});return parent}producedFields(){return new Set([this.transform.as])}dependentFields(){return this._dependentFields}assemble(){return{type:"formula",expr:this.transform.calculate,as:this.transform.as}}hash(){return"Calculate ".concat(hash(this.transform))}}function sortArrayIndexField(fieldDef,channel,opt){return vgField(fieldDef,{prefix:channel,suffix:"sort_index",...opt!==null&&opt!==void 0?opt:{}})}function getHeaderChannel(channel,orient){if(contains(["top","bottom"],orient)){return"column"}else if(contains(["left","right"],orient)){return"row"}return channel==="row"?"row":"column"}function getHeaderProperty(prop,header,config,channel){const headerSpecificConfig=channel==="row"?config.headerRow:channel==="column"?config.headerColumn:config.headerFacet;return getFirstDefined((header||{})[prop],headerSpecificConfig[prop],config.header[prop])}function getHeaderProperties(properties,header,config,channel){const props={};for(const prop of properties){const value=getHeaderProperty(prop,header||{},config,channel);if(value!==undefined){props[prop]=value}}return props}const HEADER_CHANNELS=["row","column"];const HEADER_TYPES=["header","footer"];function assembleTitleGroup(model,channel){const title=model.component.layoutHeaders[channel].title;const config=model.config?model.config:undefined;const facetFieldDef=model.component.layoutHeaders[channel].facetFieldDef?model.component.layoutHeaders[channel].facetFieldDef:undefined;const{titleAnchor:titleAnchor,titleAngle:ta,titleOrient:titleOrient}=getHeaderProperties(["titleAnchor","titleAngle","titleOrient"],facetFieldDef.header,config,channel);const headerChannel=getHeaderChannel(channel,titleOrient);const titleAngle=normalizeAngle(ta);return{name:"".concat(channel,"-title"),type:"group",role:"".concat(headerChannel,"-title"),title:{text:title,...channel==="row"?{orient:"left"}:{},style:"guide-title",...defaultHeaderGuideBaseline(titleAngle,headerChannel),...defaultHeaderGuideAlign(headerChannel,titleAngle,titleAnchor),...assembleHeaderProperties(config,facetFieldDef,channel,HEADER_TITLE_PROPERTIES,HEADER_TITLE_PROPERTIES_MAP)}}}function defaultHeaderGuideAlign(headerChannel,angle,anchor="middle"){switch(anchor){case"start":return{align:"left"};case"end":return{align:"right"}}const align=defaultLabelAlign(angle,headerChannel==="row"?"left":"top",headerChannel==="row"?"y":"x");return align?{align:align}:{}}function defaultHeaderGuideBaseline(angle,channel){const baseline=defaultLabelBaseline(angle,channel==="row"?"left":"top",channel==="row"?"y":"x",true);return baseline?{baseline:baseline}:{}}function assembleHeaderGroups(model,channel){const layoutHeader=model.component.layoutHeaders[channel];const groups=[];for(const headerType of HEADER_TYPES){if(layoutHeader[headerType]){for(const headerComponent of layoutHeader[headerType]){const group=assembleHeaderGroup(model,channel,headerType,layoutHeader,headerComponent);if(group!=null){groups.push(group)}}}}return groups}function getSort(facetFieldDef,channel){const{sort:sort}=facetFieldDef;if(isSortField(sort)){var _sort$order;return{field:vgField(sort,{expr:"datum"}),order:(_sort$order=sort.order)!==null&&_sort$order!==void 0?_sort$order:"ascending"}}else if(isArray(sort)){return{field:sortArrayIndexField(facetFieldDef,channel,{expr:"datum"}),order:"ascending"}}else{return{field:vgField(facetFieldDef,{expr:"datum"}),order:sort!==null&&sort!==void 0?sort:"ascending"}}}function assembleLabelTitle(facetFieldDef,channel,config){const{format:format,formatType:formatType,labelAngle:labelAngle,labelAnchor:labelAnchor,labelOrient:labelOrient,labelExpr:labelExpr}=getHeaderProperties(["format","formatType","labelAngle","labelAnchor","labelOrient","labelExpr"],facetFieldDef.header,config,channel);const titleTextExpr=formatSignalRef({fieldOrDatumDef:facetFieldDef,format:format,formatType:formatType,expr:"parent",config:config}).signal;const headerChannel=getHeaderChannel(channel,labelOrient);return{text:{signal:labelExpr?replaceAll(replaceAll(labelExpr,"datum.label",titleTextExpr),"datum.value",vgField(facetFieldDef,{expr:"parent"})):titleTextExpr},...channel==="row"?{orient:"left"}:{},style:"guide-label",frame:"group",...defaultHeaderGuideBaseline(labelAngle,headerChannel),...defaultHeaderGuideAlign(headerChannel,labelAngle,labelAnchor),...assembleHeaderProperties(config,facetFieldDef,channel,HEADER_LABEL_PROPERTIES,HEADER_LABEL_PROPERTIES_MAP)}}function assembleHeaderGroup(model,channel,headerType,layoutHeader,headerComponent){if(headerComponent){let title=null;const{facetFieldDef:facetFieldDef}=layoutHeader;const config=model.config?model.config:undefined;if(facetFieldDef&&headerComponent.labels){const{labelOrient:labelOrient}=getHeaderProperties(["labelOrient"],facetFieldDef.header,config,channel);if(channel==="row"&&!contains(["top","bottom"],labelOrient)||channel==="column"&&!contains(["left","right"],labelOrient)){title=assembleLabelTitle(facetFieldDef,channel,config)}}const isFacetWithoutRowCol=isFacetModel(model)&&!isFacetMapping(model.facet);const axes=headerComponent.axes;const hasAxes=(axes===null||axes===void 0?void 0:axes.length)>0;if(title||hasAxes){const sizeChannel=channel==="row"?"height":"width";return{name:model.getName("".concat(channel,"_").concat(headerType)),type:"group",role:"".concat(channel,"-").concat(headerType),...layoutHeader.facetFieldDef?{from:{data:model.getName(channel+"_domain")},sort:getSort(facetFieldDef,channel)}:{},...hasAxes&&isFacetWithoutRowCol?{from:{data:model.getName("facet_domain_".concat(channel))}}:{},...title?{title:title}:{},...headerComponent.sizeSignal?{encode:{update:{[sizeChannel]:headerComponent.sizeSignal}}}:{},...hasAxes?{axes:axes}:{}}}}return null}const LAYOUT_TITLE_BAND={column:{start:0,end:1},row:{start:1,end:0}};function getLayoutTitleBand(titleAnchor,headerChannel){return LAYOUT_TITLE_BAND[headerChannel][titleAnchor]}function assembleLayoutTitleBand(headerComponentIndex,config){const titleBand={};for(const channel of FACET_CHANNELS){const headerComponent=headerComponentIndex[channel];if(headerComponent===null||headerComponent===void 0?void 0:headerComponent.facetFieldDef){const{titleAnchor:titleAnchor,titleOrient:titleOrient}=getHeaderProperties(["titleAnchor","titleOrient"],headerComponent.facetFieldDef.header,config,channel);const headerChannel=getHeaderChannel(channel,titleOrient);const band=getLayoutTitleBand(titleAnchor,headerChannel);if(band!==undefined){titleBand[headerChannel]=band}}}return isEmpty(titleBand)?undefined:titleBand}function assembleHeaderProperties(config,facetFieldDef,channel,properties,propertiesMap){const props={};for(const prop of properties){if(!propertiesMap[prop]){continue}const value=getHeaderProperty(prop,facetFieldDef===null||facetFieldDef===void 0?void 0:facetFieldDef.header,config,channel);if(value!==undefined){props[propertiesMap[prop]]=value}}return props}function assembleLayoutSignals(model){return[...sizeSignals(model,"width"),...sizeSignals(model,"height"),...sizeSignals(model,"childWidth"),...sizeSignals(model,"childHeight")]}function sizeSignals(model,sizeType){const channel=sizeType==="width"?"x":"y";const size=model.component.layoutSize.get(sizeType);if(!size||size==="merged"){return[]}const name=model.getSizeSignalRef(sizeType).signal;if(size==="step"){const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const type=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const scaleName=model.scaleName(channel);if(isFacetModel(model.parent)){const parentResolve=model.parent.component.resolve;if(parentResolve.scale[channel]==="independent"){return[stepSignal(scaleName,range)]}}return[stepSignal(scaleName,range),{name:name,update:sizeExpr(scaleName,scaleComponent,"domain('".concat(scaleName,"').length"))}]}}throw new Error("layout size is step although width/height is not step.")}else if(size=="container"){const isWidth=name.endsWith("width");const expr=isWidth?"containerSize()[0]":"containerSize()[1]";const defaultValue=getViewConfigContinuousSize(model.config.view,isWidth?"width":"height");const safeExpr="isFinite(".concat(expr,") ? ").concat(expr," : ").concat(defaultValue);return[{name:name,init:safeExpr,on:[{update:safeExpr,events:"window:resize"}]}]}else{return[{name:name,value:size}]}}function stepSignal(scaleName,range){return{name:scaleName+"_step",value:range.step}}function sizeExpr(scaleName,scaleComponent,cardinality){const type=scaleComponent.get("type");const padding=scaleComponent.get("padding");const paddingOuter=getFirstDefined(scaleComponent.get("paddingOuter"),padding);let paddingInner=scaleComponent.get("paddingInner");paddingInner=type==="band"?paddingInner!==undefined?paddingInner:padding:1;return"bandspace(".concat(cardinality,", ").concat(signalOrStringValue(paddingInner),", ").concat(signalOrStringValue(paddingOuter),") * ").concat(scaleName,"_step")}function getSizeTypeFromLayoutSizeType(layoutSizeType){return layoutSizeType==="childWidth"?"width":layoutSizeType==="childHeight"?"height":layoutSizeType}function guideEncodeEntry(encoding,model){return keys(encoding).reduce((encode,channel)=>{const valueDef=encoding[channel];return{...encode,...wrapCondition(model,valueDef,channel,def=>signalOrValueRef(def.value))}},{})}function defaultScaleResolve(channel,model){if(isLayerModel(model)||isFacetModel(model)){return"shared"}else if(isConcatModel(model)){return isXorY(channel)?"independent":"shared"}throw new Error("invalid model type for resolve")}function parseGuideResolve(resolve,channel){const channelScaleResolve=resolve.scale[channel];const guide=isXorY(channel)?"axis":"legend";if(channelScaleResolve==="independent"){if(resolve[guide][channel]==="shared"){warn(independentScaleMeansIndependentGuide(channel))}return"independent"}return resolve[guide][channel]||"shared"}const LEGEND_COMPONENT_PROPERTY_INDEX={...COMMON_LEGEND_PROPERTY_INDEX,disable:1,labelExpr:1,selections:1,opacity:1,shape:1,stroke:1,fill:1,size:1,strokeWidth:1,strokeDash:1,encode:1};const LEGEND_COMPONENT_PROPERTIES=keys(LEGEND_COMPONENT_PROPERTY_INDEX);class LegendComponent extends Split{}const legendEncodeRules={symbols:symbols,gradient:gradient,labels:labels,entries:entries$1};function symbols(symbolsSpec,{fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt,legendType:legendType}){var _legendCmpt$get,_legendCmpt$get2,_legendCmpt$get3,_getMaxValue;if(legendType!=="symbol"){return undefined}const{markDef:markDef,encoding:encoding,config:config,mark:mark}=model;const filled=markDef.filled&&mark!=="trail";let out={...applyMarkConfig({},model,FILL_STROKE_CONFIG),...color(model,{filled:filled})};const symbolOpacity=(_legendCmpt$get=legendCmpt.get("symbolOpacity"))!==null&&_legendCmpt$get!==void 0?_legendCmpt$get:config.legend.symbolOpacity;const symbolFillColor=(_legendCmpt$get2=legendCmpt.get("symbolFillColor"))!==null&&_legendCmpt$get2!==void 0?_legendCmpt$get2:config.legend.symbolFillColor;const symbolStrokeColor=(_legendCmpt$get3=legendCmpt.get("symbolStrokeColor"))!==null&&_legendCmpt$get3!==void 0?_legendCmpt$get3:config.legend.symbolStrokeColor;const opacity=symbolOpacity===undefined?(_getMaxValue=getMaxValue(encoding.opacity))!==null&&_getMaxValue!==void 0?_getMaxValue:markDef.opacity:undefined;if(out.fill){if(channel==="fill"||filled&&channel===COLOR){delete out.fill}else{if(out.fill["field"]){if(symbolFillColor){delete out.fill}else{var _config$legend$symbol;out.fill=signalOrValueRef((_config$legend$symbol=config.legend.symbolBaseFillColor)!==null&&_config$legend$symbol!==void 0?_config$legend$symbol:"black");out.fillOpacity=signalOrValueRef(opacity!==null&&opacity!==void 0?opacity:1)}}else if(isArray(out.fill)){var _ref,_getFirstConditionVal,_encoding$fill;const fill=(_ref=(_getFirstConditionVal=getFirstConditionValue((_encoding$fill=encoding.fill)!==null&&_encoding$fill!==void 0?_encoding$fill:encoding.color))!==null&&_getFirstConditionVal!==void 0?_getFirstConditionVal:markDef.fill)!==null&&_ref!==void 0?_ref:filled&&markDef.color;if(fill){out.fill=signalOrValueRef(fill)}}}}if(out.stroke){if(channel==="stroke"||!filled&&channel===COLOR){delete out.stroke}else{if(out.stroke["field"]||symbolStrokeColor){delete out.stroke}else if(isArray(out.stroke)){const stroke=getFirstDefined(getFirstConditionValue(encoding.stroke||encoding.color),markDef.stroke,filled?markDef.color:undefined);if(stroke){out.stroke={value:stroke}}}}}if(channel!==OPACITY){const condition=isFieldDef(fieldOrDatumDef)&&selectedCondition(model,legendCmpt,fieldOrDatumDef);if(condition){out.opacity=[{test:condition,...signalOrValueRef(opacity!==null&&opacity!==void 0?opacity:1)},signalOrValueRef(config.legend.unselectedOpacity)]}else if(opacity){out.opacity=signalOrValueRef(opacity)}}out={...out,...symbolsSpec};return isEmpty(out)?undefined:out}function gradient(gradientSpec,{model:model,legendType:legendType,legendCmpt:legendCmpt}){var _legendCmpt$get4;if(legendType!=="gradient"){return undefined}const{config:config,markDef:markDef,encoding:encoding}=model;let out={};const gradientOpacity=(_legendCmpt$get4=legendCmpt.get("gradientOpacity"))!==null&&_legendCmpt$get4!==void 0?_legendCmpt$get4:config.legend.gradientOpacity;const opacity=gradientOpacity===undefined?getMaxValue(encoding.opacity)||markDef.opacity:undefined;if(opacity){out.opacity=signalOrValueRef(opacity)}out={...out,...gradientSpec};return isEmpty(out)?undefined:out}function labels(specifiedlabelsSpec,{fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt}){const legend=model.legend(channel)||{};const config=model.config;const condition=isFieldDef(fieldOrDatumDef)?selectedCondition(model,legendCmpt,fieldOrDatumDef):undefined;const opacity=condition?[{test:condition,value:1},{value:config.legend.unselectedOpacity}]:undefined;const{format:format,formatType:formatType}=legend;const text=isCustomFormatType(formatType)?formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:format,formatType:formatType,config:config}):undefined;const labelsSpec={...opacity?{opacity:opacity}:{},...text?{text:text}:{},...specifiedlabelsSpec};return isEmpty(labelsSpec)?undefined:labelsSpec}function entries$1(entriesSpec,{legendCmpt:legendCmpt}){const selections=legendCmpt.get("selections");return(selections===null||selections===void 0?void 0:selections.length)?{...entriesSpec,fill:{value:"transparent"}}:entriesSpec}function getMaxValue(channelDef){return getConditionValue(channelDef,(v,conditionalDef)=>Math.max(v,conditionalDef.value))}function getFirstConditionValue(channelDef){return getConditionValue(channelDef,(v,conditionalDef)=>getFirstDefined(v,conditionalDef.value))}function getConditionValue(channelDef,reducer){if(hasConditionalValueDef(channelDef)){return array(channelDef.condition).reduce(reducer,channelDef.value)}else if(isValueDef(channelDef)){return channelDef.value}return undefined}function selectedCondition(model,legendCmpt,fieldDef){const selections=legendCmpt.get("selections");if(!(selections===null||selections===void 0?void 0:selections.length))return undefined;const field=$(fieldDef.field);return selections.map(name=>{const store=$(varName(name)+STORE);return"(!length(data(".concat(store,")) || (").concat(name,"[").concat(field,"] && indexof(").concat(name,"[").concat(field,"], datum.value) >= 0))")}).join(" || ")}const legendRules={direction:({direction:direction})=>direction,format:({fieldOrDatumDef:fieldOrDatumDef,legend:legend,config:config})=>{const{format:format,formatType:formatType}=legend;return guideFormat(fieldOrDatumDef,fieldOrDatumDef.type,format,formatType,config,false)},formatType:({legend:legend,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType})=>{const{formatType:formatType}=legend;return guideFormatType(formatType,fieldOrDatumDef,scaleType)},gradientLength:params=>{var _ref,_legend$gradientLengt;const{legend:legend,legendConfig:legendConfig}=params;return(_ref=(_legend$gradientLengt=legend.gradientLength)!==null&&_legend$gradientLengt!==void 0?_legend$gradientLengt:legendConfig.gradientLength)!==null&&_ref!==void 0?_ref:defaultGradientLength(params)},labelOverlap:({legend:legend,legendConfig:legendConfig,scaleType:scaleType})=>{var _ref2,_legend$labelOverlap;return(_ref2=(_legend$labelOverlap=legend.labelOverlap)!==null&&_legend$labelOverlap!==void 0?_legend$labelOverlap:legendConfig.labelOverlap)!==null&&_ref2!==void 0?_ref2:defaultLabelOverlap$1(scaleType)},symbolType:({legend:legend,markDef:markDef,channel:channel,encoding:encoding})=>{var _legend$symbolType;return(_legend$symbolType=legend.symbolType)!==null&&_legend$symbolType!==void 0?_legend$symbolType:defaultSymbolType(markDef.type,channel,encoding.shape,markDef.shape)},title:({fieldOrDatumDef:fieldOrDatumDef,config:config})=>title(fieldOrDatumDef,config,{allowDisabling:true}),type:({legendType:legendType,scaleType:scaleType,channel:channel})=>{if(isColorChannel(channel)&&isContinuousToContinuous(scaleType)){if(legendType==="gradient"){return undefined}}else if(legendType==="symbol"){return undefined}return legendType},values:({fieldOrDatumDef:fieldOrDatumDef,legend:legend})=>values$1(legend,fieldOrDatumDef)};function values$1(legend,fieldOrDatumDef){const vals=legend.values;if(isArray(vals)){return valueArray(fieldOrDatumDef,vals)}else if(isSignalRef(vals)){return vals}return undefined}function defaultSymbolType(mark,channel,shapeChannelDef,markShape){if(channel!=="shape"){var _getFirstConditionVal;const shape=(_getFirstConditionVal=getFirstConditionValue(shapeChannelDef))!==null&&_getFirstConditionVal!==void 0?_getFirstConditionVal:markShape;if(shape){return shape}}switch(mark){case"bar":case"rect":case"image":case"square":return"square";case"line":case"trail":case"rule":return"stroke";case"arc":case"point":case"circle":case"tick":case"geoshape":case"area":case"text":return"circle"}}function getLegendType(params){const{legend:legend}=params;return getFirstDefined(legend.type,defaultType$1(params))}function defaultType$1({channel:channel,timeUnit:timeUnit,scaleType:scaleType}){if(isColorChannel(channel)){if(contains(["quarter","month","day"],timeUnit)){return"symbol"}if(isContinuousToContinuous(scaleType)){return"gradient"}}return"symbol"}function getDirection({legendConfig:legendConfig,legendType:legendType,orient:orient,legend:legend}){var _ref3,_legend$direction;return(_ref3=(_legend$direction=legend.direction)!==null&&_legend$direction!==void 0?_legend$direction:legendConfig[legendType?"gradientDirection":"symbolDirection"])!==null&&_ref3!==void 0?_ref3:defaultDirection(orient,legendType)}function defaultDirection(orient,legendType){switch(orient){case"top":case"bottom":return"horizontal";case"left":case"right":case"none":case undefined:return undefined;default:return legendType==="gradient"?"horizontal":undefined}}function defaultGradientLength({legendConfig:legendConfig,model:model,direction:direction,orient:orient,scaleType:scaleType}){const{gradientHorizontalMaxLength:gradientHorizontalMaxLength,gradientHorizontalMinLength:gradientHorizontalMinLength,gradientVerticalMaxLength:gradientVerticalMaxLength,gradientVerticalMinLength:gradientVerticalMinLength}=legendConfig;if(isContinuousToContinuous(scaleType)){if(direction==="horizontal"){if(orient==="top"||orient==="bottom"){return gradientLengthSignal(model,"width",gradientHorizontalMinLength,gradientHorizontalMaxLength)}else{return gradientHorizontalMinLength}}else{return gradientLengthSignal(model,"height",gradientVerticalMinLength,gradientVerticalMaxLength)}}return undefined}function gradientLengthSignal(model,sizeType,min,max){const sizeSignal=model.getSizeSignalRef(sizeType).signal;return{signal:"clamp(".concat(sizeSignal,", ").concat(min,", ").concat(max,")")}}function defaultLabelOverlap$1(scaleType){if(contains(["quantile","threshold","log","symlog"],scaleType)){return"greedy"}return undefined}function parseLegend(model){const legendComponent=isUnitModel(model)?parseUnitLegend(model):parseNonUnitLegend(model);model.component.legends=legendComponent;return legendComponent}function parseUnitLegend(model){const{encoding:encoding}=model;const legendComponent={};for(const channel of[COLOR,...LEGEND_SCALE_CHANNELS]){const def=getFieldOrDatumDef(encoding[channel]);if(!def||!model.getScaleComponent(channel)){continue}if(channel===SHAPE&&isFieldDef(def)&&def.type===GEOJSON){continue}legendComponent[channel]=parseLegendForChannel(model,channel)}return legendComponent}function getLegendDefWithScale(model,channel){const scale=model.scaleName(channel);if(model.mark==="trail"){if(channel==="color"){return{stroke:scale}}else if(channel==="size"){return{strokeWidth:scale}}}if(channel==="color"){return model.markDef.filled?{fill:scale}:{stroke:scale}}return{[channel]:scale}}function isExplicit(value,property,legend,fieldDef){switch(property){case"disable":return legend!==undefined;case"values":return!!(legend===null||legend===void 0?void 0:legend.values);case"title":if(property==="title"&&value===(fieldDef===null||fieldDef===void 0?void 0:fieldDef.title)){return true}}return value===(legend||{})[property]}function parseLegendForChannel(model,channel){var _normalizeTimeUnit,_legend$encoding,_legend;let legend=model.legend(channel);const{markDef:markDef,encoding:encoding,config:config}=model;const legendConfig=config.legend;const legendCmpt=new LegendComponent({},getLegendDefWithScale(model,channel));parseInteractiveLegend(model,channel,legendCmpt);const disable=legend!==undefined?!legend:legendConfig.disable;legendCmpt.set("disable",disable,legend!==undefined);if(disable){return legendCmpt}legend=legend||{};const scaleType=model.getScaleComponent(channel).get("type");const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const timeUnit=isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit:undefined;const orient=legend.orient||config.legend.orient||"right";const legendType=getLegendType({legend:legend,channel:channel,timeUnit:timeUnit,scaleType:scaleType});const direction=getDirection({legend:legend,legendType:legendType,orient:orient,legendConfig:legendConfig});const ruleParams={legend:legend,channel:channel,model:model,markDef:markDef,encoding:encoding,fieldOrDatumDef:fieldOrDatumDef,legendConfig:legendConfig,config:config,scaleType:scaleType,orient:orient,legendType:legendType,direction:direction};for(const property of LEGEND_COMPONENT_PROPERTIES){if(legendType==="gradient"&&property.startsWith("symbol")||legendType==="symbol"&&property.startsWith("gradient")){continue}const value=property in legendRules?legendRules[property](ruleParams):legend[property];if(value!==undefined){const explicit=isExplicit(value,property,legend,model.fieldDef(channel));if(explicit||config.legend[property]===undefined){legendCmpt.set(property,value,explicit)}}}const legendEncoding=(_legend$encoding=(_legend=legend)===null||_legend===void 0?void 0:_legend.encoding)!==null&&_legend$encoding!==void 0?_legend$encoding:{};const selections=legendCmpt.get("selections");const legendEncode={};const legendEncodeParams={fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt,legendType:legendType};for(const part of["labels","legend","title","symbols","gradient","entries"]){var _legendEncoding$part;const legendEncodingPart=guideEncodeEntry((_legendEncoding$part=legendEncoding[part])!==null&&_legendEncoding$part!==void 0?_legendEncoding$part:{},model);const value=part in legendEncodeRules?legendEncodeRules[part](legendEncodingPart,legendEncodeParams):legendEncodingPart;if(value!==undefined&&!isEmpty(value)){legendEncode[part]={...(selections===null||selections===void 0?void 0:selections.length)&&isFieldDef(fieldOrDatumDef)?{name:"".concat(varName(fieldOrDatumDef.field),"_legend_").concat(part)}:{},...(selections===null||selections===void 0?void 0:selections.length)?{interactive:!!selections}:{},update:value}}}if(!isEmpty(legendEncode)){var _legend2;legendCmpt.set("encode",legendEncode,!!((_legend2=legend)===null||_legend2===void 0?void 0:_legend2.encoding))}return legendCmpt}function parseNonUnitLegend(model){const{legends:legends,resolve:resolve}=model.component;for(const child of model.children){parseLegend(child);for(const channel of keys(child.component.legends)){resolve.legend[channel]=parseGuideResolve(model.component.resolve,channel);if(resolve.legend[channel]==="shared"){legends[channel]=mergeLegendComponent(legends[channel],child.component.legends[channel]);if(!legends[channel]){resolve.legend[channel]="independent";delete legends[channel]}}}}for(const channel of keys(legends)){for(const child of model.children){if(!child.component.legends[channel]){continue}if(resolve.legend[channel]==="shared"){delete child.component.legends[channel]}}}return legends}function mergeLegendComponent(mergedLegend,childLegend){if(!mergedLegend){return childLegend.clone()}const mergedOrient=mergedLegend.getWithExplicit("orient");const childOrient=childLegend.getWithExplicit("orient");if(mergedOrient.explicit&&childOrient.explicit&&mergedOrient.value!==childOrient.value){return undefined}let typeMerged=false;for(const prop of LEGEND_COMPONENT_PROPERTIES){const mergedValueWithExplicit=mergeValuesWithExplicit(mergedLegend.getWithExplicit(prop),childLegend.getWithExplicit(prop),prop,"legend",(v1,v2)=>{switch(prop){case"symbolType":return mergeSymbolType(v1,v2);case"title":return mergeTitleComponent(v1,v2);case"type":typeMerged=true;return makeImplicit("symbol")}return defaultTieBreaker(v1,v2,prop,"legend")});mergedLegend.setWithExplicit(prop,mergedValueWithExplicit)}if(typeMerged){var _mergedLegend$implici,_mergedLegend$implici2,_mergedLegend$explici,_mergedLegend$explici2;if((_mergedLegend$implici=mergedLegend.implicit)===null||_mergedLegend$implici===void 0?void 0:(_mergedLegend$implici2=_mergedLegend$implici.encode)===null||_mergedLegend$implici2===void 0?void 0:_mergedLegend$implici2.gradient){deleteNestedProperty(mergedLegend.implicit,["encode","gradient"])}if((_mergedLegend$explici=mergedLegend.explicit)===null||_mergedLegend$explici===void 0?void 0:(_mergedLegend$explici2=_mergedLegend$explici.encode)===null||_mergedLegend$explici2===void 0?void 0:_mergedLegend$explici2.gradient){deleteNestedProperty(mergedLegend.explicit,["encode","gradient"])}}return mergedLegend}function mergeSymbolType(st1,st2){if(st2.value==="circle"){return st2}return st1}function setLegendEncode(legend,part,vgProp,vgRef){var _legend$encode,_legend$encode$part,_legend$encode$part$u;legend.encode=(_legend$encode=legend.encode)!==null&&_legend$encode!==void 0?_legend$encode:{};legend.encode[part]=(_legend$encode$part=legend.encode[part])!==null&&_legend$encode$part!==void 0?_legend$encode$part:{};legend.encode[part].update=(_legend$encode$part$u=legend.encode[part].update)!==null&&_legend$encode$part$u!==void 0?_legend$encode$part$u:{};legend.encode[part].update[vgProp]=vgRef}function assembleLegends(model){const legendComponentIndex=model.component.legends;const legendByDomain={};for(const channel of keys(legendComponentIndex)){const scaleComponent=model.getScaleComponent(channel);const domainHash=stringify(scaleComponent.get("domains"));if(legendByDomain[domainHash]){for(const mergedLegendComponent of legendByDomain[domainHash]){const merged=mergeLegendComponent(mergedLegendComponent,legendComponentIndex[channel]);if(!merged){legendByDomain[domainHash].push(legendComponentIndex[channel])}}}else{legendByDomain[domainHash]=[legendComponentIndex[channel].clone()]}}const legends=vals(legendByDomain).flat().map(l=>assembleLegend(l,model.config)).filter(l=>l!==undefined);return legends}function assembleLegend(legendCmpt,config){var _legend$encode2;const{disable:disable,labelExpr:labelExpr,selections:selections,...legend}=legendCmpt.combine();if(disable){return undefined}if(config.aria===false&&legend.aria==undefined){legend.aria=false}if((_legend$encode2=legend.encode)===null||_legend$encode2===void 0?void 0:_legend$encode2.symbols){const out=legend.encode.symbols.update;if(out.fill&&out.fill["value"]!=="transparent"&&!out.stroke&&!legend.stroke){out.stroke={value:"transparent"}}for(const property of LEGEND_SCALE_CHANNELS){if(legend[property]){delete out[property]}}}if(!legend.title){delete legend.title}if(labelExpr!==undefined){var _legend$encode3,_legend$encode3$label;let expr=labelExpr;if(((_legend$encode3=legend.encode)===null||_legend$encode3===void 0?void 0:(_legend$encode3$label=_legend$encode3.labels)===null||_legend$encode3$label===void 0?void 0:_legend$encode3$label.update)&&isSignalRef(legend.encode.labels.update.text)){expr=replaceAll(labelExpr,"datum.label",legend.encode.labels.update.text.signal)}setLegendEncode(legend,"labels","text",{signal:expr})}return legend}function assembleProjections(model){if(isLayerModel(model)||isConcatModel(model)){return assembleProjectionsForModelAndChildren(model)}else{return assembleProjectionForModel(model)}}function assembleProjectionsForModelAndChildren(model){return model.children.reduce((projections,child)=>projections.concat(child.assembleProjections()),assembleProjectionForModel(model))}function assembleProjectionForModel(model){const component=model.component.projection;if(!component||component.merged){return[]}const projection=component.combine();const{name:name}=projection;if(!component.data){return[{name:name,...{translate:{signal:"[width / 2, height / 2]"}},...projection}]}else{const size={signal:"[".concat(component.size.map(ref=>ref.signal).join(", "),"]")};const fits=component.data.reduce((sources,data)=>{const source=isSignalRef(data)?data.signal:"data('".concat(model.lookupDataSource(data),"')");if(!contains(sources,source)){sources.push(source)}return sources},[]);if(fits.length<=0){throw new Error("Projection's fit didn't find any data sources")}return[{name:name,size:size,fit:{signal:fits.length>1?"[".concat(fits.join(", "),"]"):fits[0]},...projection}]}}const PROJECTION_PROPERTIES=["type","clipAngle","clipExtent","center","rotate","precision","reflectX","reflectY","coefficient","distance","fraction","lobes","parallel","radius","ratio","spacing","tilt"];class ProjectionComponent extends Split{constructor(name,specifiedProjection,size,data){super({...specifiedProjection},{name:name});this.specifiedProjection=specifiedProjection;this.size=size;this.data=data;_defineProperty(this,"merged",false)}get isFit(){return!!this.data}}function parseProjection(model){model.component.projection=isUnitModel(model)?parseUnitProjection(model):parseNonUnitProjections(model)}function parseUnitProjection(model){if(model.hasProjection){var _model$config$project;const proj=model.specifiedProjection;const fit=!(proj&&(proj.scale!=null||proj.translate!=null));const size=fit?[model.getSizeSignalRef("width"),model.getSizeSignalRef("height")]:undefined;const data=fit?gatherFitData(model):undefined;return new ProjectionComponent(model.projectionName(true),{...(_model$config$project=model.config.projection)!==null&&_model$config$project!==void 0?_model$config$project:{},...proj!==null&&proj!==void 0?proj:{}},size,data)}return undefined}function gatherFitData(model){const data=[];const{encoding:encoding}=model;for(const posssiblePair of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){if(getFieldOrDatumDef(encoding[posssiblePair[0]])||getFieldOrDatumDef(encoding[posssiblePair[1]])){data.push({signal:model.getName("geojson_".concat(data.length))})}}if(model.channelHasField(SHAPE)&&model.typedFieldDef(SHAPE).type===GEOJSON){data.push({signal:model.getName("geojson_".concat(data.length))})}if(data.length===0){data.push(model.requestDataName(DataSourceType.Main))}return data}function mergeIfNoConflict(first,second){const allPropertiesShared=every(PROJECTION_PROPERTIES,prop=>{if(!has(first.explicit,prop)&&!has(second.explicit,prop)){return true}if(has(first.explicit,prop)&&has(second.explicit,prop)&&stringify(first.get(prop))===stringify(second.get(prop))){return true}return false});const size=stringify(first.size)===stringify(second.size);if(size){if(allPropertiesShared){return first}else if(stringify(first.explicit)===stringify({})){return second}else if(stringify(second.explicit)===stringify({})){return first}}return null}function parseNonUnitProjections(model){if(model.children.length===0){return undefined}let nonUnitProjection;for(const child of model.children){parseProjection(child)}const mergable=every(model.children,child=>{const projection=child.component.projection;if(!projection){return true}else if(!nonUnitProjection){nonUnitProjection=projection;return true}else{const merge=mergeIfNoConflict(nonUnitProjection,projection);if(merge){nonUnitProjection=merge}return!!merge}});if(nonUnitProjection&&mergable){const name=model.projectionName(true);const modelProjection=new ProjectionComponent(name,nonUnitProjection.specifiedProjection,nonUnitProjection.size,duplicate(nonUnitProjection.data));for(const child of model.children){const projection=child.component.projection;if(projection){if(projection.isFit){modelProjection.data.push(...child.component.projection.data)}child.renameProjection(projection.get("name"),name);projection.merged=true}}return modelProjection}return undefined}function rangeFormula(model,fieldDef,channel,config){if(binRequiresRange(fieldDef,channel)){var _ref,_model$axis;const guide=isUnitModel(model)?(_ref=(_model$axis=model.axis(channel))!==null&&_model$axis!==void 0?_model$axis:model.legend(channel))!==null&&_ref!==void 0?_ref:{}:{};const startField=vgField(fieldDef,{expr:"datum"});const endField=vgField(fieldDef,{expr:"datum",binSuffix:"end"});return{formulaAs:vgField(fieldDef,{binSuffix:"range",forAs:true}),formula:binFormatExpression(startField,endField,guide.format,guide.formatType,config)}}return{}}function binKey(bin,field){return"".concat(binToString(bin),"_").concat(field)}function getSignalsFromModel(model,key){return{signal:model.getName("".concat(key,"_bins")),extentSignal:model.getName("".concat(key,"_extent"))}}function getBinSignalName(model,field,bin){var _normalizeBin;const normalizedBin=(_normalizeBin=normalizeBin(bin,undefined))!==null&&_normalizeBin!==void 0?_normalizeBin:{};const key=binKey(normalizedBin,field);return model.getName("".concat(key,"_bins"))}function isBinTransform(t){return"as"in t}function createBinComponent(t,bin,model){let as;let span;if(isBinTransform(t)){as=isString(t.as)?[t.as,"".concat(t.as,"_end")]:[t.as[0],t.as[1]]}else{as=[vgField(t,{forAs:true}),vgField(t,{binSuffix:"end",forAs:true})]}const normalizedBin={...normalizeBin(bin,undefined)};const key=binKey(normalizedBin,t.field);const{signal:signal,extentSignal:extentSignal}=getSignalsFromModel(model,key);if(isSelectionExtent(normalizedBin.extent)){const ext=normalizedBin.extent;const selName=ext.selection;span=parseSelectionBinExtent(model.getSelectionComponent(varName(selName),selName),ext);delete normalizedBin.extent}const binComponent={bin:normalizedBin,field:t.field,as:[as],...signal?{signal:signal}:{},...extentSignal?{extentSignal:extentSignal}:{},...span?{span:span}:{}};return{key:key,binComponent:binComponent}}class BinNode extends DataFlowNode{clone(){return new BinNode(null,duplicate(this.bins))}constructor(parent,bins){super(parent);this.bins=bins}static makeFromEncoding(parent,model){const bins=model.reduceFieldDef((binComponentIndex,fieldDef,channel)=>{if(isTypedFieldDef(fieldDef)&&isBinning(fieldDef.bin)){const{key:key,binComponent:binComponent}=createBinComponent(fieldDef,fieldDef.bin,model);binComponentIndex[key]={...binComponent,...binComponentIndex[key],...rangeFormula(model,fieldDef,channel,model.config)}}return binComponentIndex},{});if(isEmpty(bins)){return null}return new BinNode(parent,bins)}static makeFromTransform(parent,t,model){const{key:key,binComponent:binComponent}=createBinComponent(t,t.bin,model);return new BinNode(parent,{[key]:binComponent})}merge(other,renameSignal){for(const key of keys(other.bins)){if(key in this.bins){renameSignal(other.bins[key].signal,this.bins[key].signal);this.bins[key].as=unique([...this.bins[key].as,...other.bins[key].as],hash)}else{this.bins[key]=other.bins[key]}}for(const child of other.children){other.removeChild(child);child.parent=this}other.remove()}producedFields(){return new Set(vals(this.bins).map(c=>c.as).flat(2))}dependentFields(){return new Set(vals(this.bins).map(c=>c.field))}hash(){return"Bin ".concat(hash(this.bins))}assemble(){return vals(this.bins).flatMap(bin=>{const transform=[];const[binAs,...remainingAs]=bin.as;const{extent:extent,...params}=bin.bin;const binTrans={type:"bin",field:replacePathInField(bin.field),as:binAs,signal:bin.signal,...!isSelectionExtent(extent)?{extent:extent}:{extent:null},...bin.span?{span:{signal:"span(".concat(bin.span,")")}}:{},...params};if(!extent&&bin.extentSignal){transform.push({type:"extent",field:replacePathInField(bin.field),signal:bin.extentSignal});binTrans.extent={signal:bin.extentSignal}}transform.push(binTrans);for(const as of remainingAs){for(let i=0;i<2;i++){transform.push({type:"formula",expr:vgField({field:binAs[i]},{expr:"datum"}),as:as[i]})}}if(bin.formula){transform.push({type:"formula",expr:bin.formula,as:bin.formulaAs})}return transform})}}function addDimension(dims,channel,fieldDef,model){const channelDef2=isUnitModel(model)?model.encoding[getSecondaryRangeChannel(channel)]:undefined;if(isTypedFieldDef(fieldDef)&&isUnitModel(model)&&hasBand(channel,fieldDef,channelDef2,model.stack,model.markDef,model.config)){dims.add(vgField(fieldDef,{}));dims.add(vgField(fieldDef,{suffix:"end"}));if(fieldDef.bin&&binRequiresRange(fieldDef,channel)){dims.add(vgField(fieldDef,{binSuffix:"range"}))}}else if(isGeoPositionChannel(channel)){const posChannel=getPositionChannelFromLatLong(channel);dims.add(model.getName(posChannel))}else{dims.add(vgField(fieldDef))}return dims}function mergeMeasures(parentMeasures,childMeasures){for(const field of keys(childMeasures)){const ops=childMeasures[field];for(const op of keys(ops)){if(field in parentMeasures){var _parentMeasures$field;parentMeasures[field][op]=new Set([...(_parentMeasures$field=parentMeasures[field][op])!==null&&_parentMeasures$field!==void 0?_parentMeasures$field:[],...ops[op]])}else{parentMeasures[field]={[op]:ops[op]}}}}}class AggregateNode extends DataFlowNode{clone(){return new AggregateNode(null,new Set(this.dimensions),duplicate(this.measures))}constructor(parent,dimensions,measures){super(parent);this.dimensions=dimensions;this.measures=measures}get groupBy(){return this.dimensions}static makeFromEncoding(parent,model){let isAggregate=false;model.forEachFieldDef(fd=>{if(fd.aggregate){isAggregate=true}});const meas={};const dims=new Set;if(!isAggregate){return null}model.forEachFieldDef((fieldDef,channel)=>{const{aggregate:aggregate,field:field}=fieldDef;if(aggregate){if(aggregate==="count"){var _meas$;meas["*"]=(_meas$=meas["*"])!==null&&_meas$!==void 0?_meas$:{};meas["*"]["count"]=new Set([vgField(fieldDef,{forAs:true})])}else{if(isArgminDef(aggregate)||isArgmaxDef(aggregate)){var _meas$argField;const op=isArgminDef(aggregate)?"argmin":"argmax";const argField=aggregate[op];meas[argField]=(_meas$argField=meas[argField])!==null&&_meas$argField!==void 0?_meas$argField:{};meas[argField][op]=new Set([vgField({op:op,field:argField},{forAs:true})])}else{var _meas$field;meas[field]=(_meas$field=meas[field])!==null&&_meas$field!==void 0?_meas$field:{};meas[field][aggregate]=new Set([vgField(fieldDef,{forAs:true})])}if(isScaleChannel(channel)&&model.scaleDomain(channel)==="unaggregated"){var _meas$field2;meas[field]=(_meas$field2=meas[field])!==null&&_meas$field2!==void 0?_meas$field2:{};meas[field]["min"]=new Set([vgField({field:field,aggregate:"min"},{forAs:true})]);meas[field]["max"]=new Set([vgField({field:field,aggregate:"max"},{forAs:true})])}}}else{addDimension(dims,channel,fieldDef,model)}});if(dims.size+keys(meas).length===0){return null}return new AggregateNode(parent,dims,meas)}static makeFromTransform(parent,t){const dims=new Set;const meas={};for(const s of t.aggregate){const{op:op,field:field,as:as}=s;if(op){if(op==="count"){var _meas$2;meas["*"]=(_meas$2=meas["*"])!==null&&_meas$2!==void 0?_meas$2:{};meas["*"]["count"]=new Set([as?as:vgField(s,{forAs:true})])}else{var _meas$field3;meas[field]=(_meas$field3=meas[field])!==null&&_meas$field3!==void 0?_meas$field3:{};meas[field][op]=new Set([as?as:vgField(s,{forAs:true})])}}}for(const s of(_t$groupby=t.groupby)!==null&&_t$groupby!==void 0?_t$groupby:[]){var _t$groupby;dims.add(s)}if(dims.size+keys(meas).length===0){return null}return new AggregateNode(parent,dims,meas)}merge(other){if(setEqual(this.dimensions,other.dimensions)){mergeMeasures(this.measures,other.measures);return true}else{debug("different dimensions, cannot merge");return false}}addDimensions(fields){fields.forEach(this.dimensions.add,this.dimensions)}dependentFields(){return new Set([...this.dimensions,...keys(this.measures)])}producedFields(){const out=new Set;for(const field of keys(this.measures)){for(const op of keys(this.measures[field])){const m=this.measures[field][op];if(m.size===0){out.add("".concat(op,"_").concat(field))}else{m.forEach(out.add,out)}}}return out}hash(){return"Aggregate ".concat(hash({dimensions:this.dimensions,measures:this.measures}))}assemble(){const ops=[];const fields=[];const as=[];for(const field of keys(this.measures)){for(const op of keys(this.measures[field])){for(const alias of this.measures[field][op]){as.push(alias);ops.push(op);fields.push(field==="*"?null:replacePathInField(field))}}}const result={type:"aggregate",groupby:[...this.dimensions].map(replacePathInField),ops:ops,fields:fields,as:as};return result}}class FacetNode extends DataFlowNode{constructor(parent,model,name,data){super(parent);this.model=model;this.name=name;this.data=data;_defineProperty(this,"column",void 0);_defineProperty(this,"row",void 0);_defineProperty(this,"facet",void 0);_defineProperty(this,"childModel",void 0);for(const channel of FACET_CHANNELS){const fieldDef=model.facet[channel];if(fieldDef){const{bin:bin,sort:sort}=fieldDef;this[channel]={name:model.getName("".concat(channel,"_domain")),fields:[vgField(fieldDef),...isBinning(bin)?[vgField(fieldDef,{binSuffix:"end"})]:[]],...isSortField(sort)?{sortField:sort}:isArray(sort)?{sortIndexField:sortArrayIndexField(fieldDef,channel)}:{}}}}this.childModel=model.child}hash(){let out="Facet";for(const channel of FACET_CHANNELS){if(this[channel]){out+=" ".concat(channel.charAt(0),":").concat(hash(this[channel]))}}return out}get fields(){const f=[];for(const channel of FACET_CHANNELS){var _this$channel;if((_this$channel=this[channel])===null||_this$channel===void 0?void 0:_this$channel.fields){f.push(...this[channel].fields)}}return f}dependentFields(){const depFields=new Set(this.fields);for(const channel of FACET_CHANNELS){if(this[channel]){if(this[channel].sortField){depFields.add(this[channel].sortField.field)}if(this[channel].sortIndexField){depFields.add(this[channel].sortIndexField)}}}return depFields}producedFields(){return new Set}getSource(){return this.name}getChildIndependentFieldsWithStep(){const childIndependentFieldsWithStep={};for(const channel of POSITION_SCALE_CHANNELS){const childScaleComponent=this.childModel.component.scales[channel];if(childScaleComponent&&!childScaleComponent.merged){const type=childScaleComponent.get("type");const range=childScaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const domain=assembleDomain(this.childModel,channel);const field=getFieldFromDomain(domain);if(field){childIndependentFieldsWithStep[channel]=field}else{warn(unknownField(channel))}}}}return childIndependentFieldsWithStep}assembleRowColumnHeaderData(channel,crossedDataName,childIndependentFieldsWithStep){const childChannel={row:"y",column:"x"}[channel];const fields=[];const ops=[];const as=[];if(childIndependentFieldsWithStep&&childIndependentFieldsWithStep[childChannel]){if(crossedDataName){fields.push("distinct_".concat(childIndependentFieldsWithStep[childChannel]));ops.push("max")}else{fields.push(childIndependentFieldsWithStep[childChannel]);ops.push("distinct")}as.push("distinct_".concat(childIndependentFieldsWithStep[childChannel]))}const{sortField:sortField,sortIndexField:sortIndexField}=this[channel];if(sortField){const{op:op=DEFAULT_SORT_OP,field:field}=sortField;fields.push(field);ops.push(op);as.push(vgField(sortField,{forAs:true}))}else if(sortIndexField){fields.push(sortIndexField);ops.push("max");as.push(sortIndexField)}return{name:this[channel].name,source:crossedDataName!==null&&crossedDataName!==void 0?crossedDataName:this.data,transform:[{type:"aggregate",groupby:this[channel].fields,...fields.length?{fields:fields,ops:ops,as:as}:{}}]}}assembleFacetHeaderData(childIndependentFieldsWithStep){const{columns:columns}=this.model.layout;const{layoutHeaders:layoutHeaders}=this.model.component;const data=[];const hasSharedAxis={};for(const headerChannel of HEADER_CHANNELS){for(const headerType of HEADER_TYPES){var _ref;const headers=(_ref=layoutHeaders[headerChannel]&&layoutHeaders[headerChannel][headerType])!==null&&_ref!==void 0?_ref:[];for(const header of headers){var _header$axes;if(((_header$axes=header.axes)===null||_header$axes===void 0?void 0:_header$axes.length)>0){hasSharedAxis[headerChannel]=true;break}}}if(hasSharedAxis[headerChannel]){const cardinality='length(data("'.concat(this.facet.name,'"))');const stop=headerChannel==="row"?columns?{signal:"ceil(".concat(cardinality," / ").concat(columns,")")}:1:columns?{signal:"min(".concat(cardinality,", ").concat(columns,")")}:{signal:cardinality};data.push({name:"".concat(this.facet.name,"_").concat(headerChannel),transform:[{type:"sequence",start:0,stop:stop}]})}}const{row:row,column:column}=hasSharedAxis;if(row||column){data.unshift(this.assembleRowColumnHeaderData("facet",null,childIndependentFieldsWithStep))}return data}assemble(){const data=[];let crossedDataName=null;const childIndependentFieldsWithStep=this.getChildIndependentFieldsWithStep();const{column:column,row:row,facet:facet}=this;if(column&&row&&(childIndependentFieldsWithStep.x||childIndependentFieldsWithStep.y)){var _childIndependentFiel,_childIndependentFiel2;crossedDataName="cross_".concat(this.column.name,"_").concat(this.row.name);const fields=[].concat((_childIndependentFiel=childIndependentFieldsWithStep.x)!==null&&_childIndependentFiel!==void 0?_childIndependentFiel:[],(_childIndependentFiel2=childIndependentFieldsWithStep.y)!==null&&_childIndependentFiel2!==void 0?_childIndependentFiel2:[]);const ops=fields.map(()=>"distinct");data.push({name:crossedDataName,source:this.data,transform:[{type:"aggregate",groupby:this.fields,fields:fields,ops:ops}]})}for(const channel of[COLUMN,ROW]){if(this[channel]){data.push(this.assembleRowColumnHeaderData(channel,crossedDataName,childIndependentFieldsWithStep))}}if(facet){const facetData=this.assembleFacetHeaderData(childIndependentFieldsWithStep);if(facetData){data.push(...facetData)}}return data}}function unquote(pattern){if(pattern[0]==="'"&&pattern[pattern.length-1]==="'"||pattern[0]==='"'&&pattern[pattern.length-1]==='"'){return pattern.slice(1,-1)}return pattern}function parseExpression$1(field,parse){const f=accessPathWithDatum(field);if(parse==="number"){return"toNumber(".concat(f,")")}else if(parse==="boolean"){return"toBoolean(".concat(f,")")}else if(parse==="string"){return"toString(".concat(f,")")}else if(parse==="date"){return"toDate(".concat(f,")")}else if(parse==="flatten"){return f}else if(parse.indexOf("date:")===0){const specifier=unquote(parse.slice(5,parse.length));return"timeParse(".concat(f,",'").concat(specifier,"')")}else if(parse.indexOf("utc:")===0){const specifier=unquote(parse.slice(4,parse.length));return"utcParse(".concat(f,",'").concat(specifier,"')")}else{warn(unrecognizedParse(parse));return null}}function getImplicitFromFilterTransform(transform){const implicit={};forEachLeaf(transform.filter,filter=>{if(isFieldPredicate(filter)){let val=null;if(isFieldEqualPredicate(filter)){val=signalRefOrValue(filter.equal)}else if(isFieldLTEPredicate(filter)){val=signalRefOrValue(filter.lte)}else if(isFieldLTPredicate(filter)){val=signalRefOrValue(filter.lt)}else if(isFieldGTPredicate(filter)){val=signalRefOrValue(filter.gt)}else if(isFieldGTEPredicate(filter)){val=signalRefOrValue(filter.gte)}else if(isFieldRangePredicate(filter)){val=filter.range[0]}else if(isFieldOneOfPredicate(filter)){var _filter$oneOf;val=((_filter$oneOf=filter.oneOf)!==null&&_filter$oneOf!==void 0?_filter$oneOf:filter["in"])[0]}if(val){if(isDateTime(val)){implicit[filter.field]="date"}else if(isNumber(val)){implicit[filter.field]="number"}else if(isString(val)){implicit[filter.field]="string"}}if(filter.timeUnit){implicit[filter.field]="date"}}});return implicit}function getImplicitFromEncoding(model){const implicit={};function add(fieldDef){if(isFieldOrDatumDefForTimeFormat(fieldDef)){implicit[fieldDef.field]="date"}else if(fieldDef.type==="quantitative"&&isMinMaxOp(fieldDef.aggregate)){implicit[fieldDef.field]="number"}else if(accessPathDepth(fieldDef.field)>1){if(!(fieldDef.field in implicit)){implicit[fieldDef.field]="flatten"}}else if(isScaleFieldDef(fieldDef)&&isSortField(fieldDef.sort)&&accessPathDepth(fieldDef.sort.field)>1){if(!(fieldDef.sort.field in implicit)){implicit[fieldDef.sort.field]="flatten"}}}if(isUnitModel(model)||isFacetModel(model)){model.forEachFieldDef((fieldDef,channel)=>{if(isTypedFieldDef(fieldDef)){add(fieldDef)}else{const mainChannel=getMainRangeChannel(channel);const mainFieldDef=model.fieldDef(mainChannel);add({...fieldDef,type:mainFieldDef.type})}})}if(isUnitModel(model)){const{mark:mark,markDef:markDef,encoding:encoding}=model;if(isPathMark(mark)&&!model.encoding.order){const dimensionChannel=markDef.orient==="horizontal"?"y":"x";const dimensionChannelDef=encoding[dimensionChannel];if(isFieldDef(dimensionChannelDef)&&dimensionChannelDef.type==="quantitative"&&!(dimensionChannelDef.field in implicit)){implicit[dimensionChannelDef.field]="number"}}}return implicit}function getImplicitFromSelection(model){const implicit={};if(isUnitModel(model)&&model.component.selection){for(const name of keys(model.component.selection)){const selCmpt=model.component.selection[name];for(const proj of selCmpt.project.items){if(!proj.channel&&accessPathDepth(proj.field)>1){implicit[proj.field]="flatten"}}}}return implicit}class ParseNode extends DataFlowNode{clone(){return new ParseNode(null,duplicate(this._parse))}constructor(parent,parse){super(parent);_defineProperty(this,"_parse",void 0);this._parse=parse}hash(){return"Parse ".concat(hash(this._parse))}static makeExplicit(parent,model,ancestorParse){let explicit={};const data=model.data;if(!isGenerator(data)&&data&&data.format&&data.format.parse){explicit=data.format.parse}return this.makeWithAncestors(parent,explicit,{},ancestorParse)}static makeWithAncestors(parent,explicit,implicit,ancestorParse){for(const field of keys(implicit)){const parsedAs=ancestorParse.getWithExplicit(field);if(parsedAs.value!==undefined){if(parsedAs.explicit||parsedAs.value===implicit[field]||parsedAs.value==="derived"||implicit[field]==="flatten"){delete implicit[field]}else{warn(differentParse(field,implicit[field],parsedAs.value))}}}for(const field of keys(explicit)){const parsedAs=ancestorParse.get(field);if(parsedAs!==undefined){if(parsedAs===explicit[field]){delete explicit[field]}else{warn(differentParse(field,explicit[field],parsedAs))}}}const parse=new Split(explicit,implicit);ancestorParse.copyAll(parse);const p={};for(const key of keys(parse.combine())){const val=parse.get(key);if(val!==null){p[key]=val}}if(keys(p).length===0||ancestorParse.parseNothing){return null}return new ParseNode(parent,p)}get parse(){return this._parse}merge(other){this._parse={...this._parse,...other.parse};other.remove()}assembleFormatParse(){const formatParse={};for(const field of keys(this._parse)){const p=this._parse[field];if(accessPathDepth(field)===1){formatParse[field]=p}}return formatParse}producedFields(){return new Set(keys(this._parse))}dependentFields(){return new Set(keys(this._parse))}assembleTransforms(onlyNested=false){return keys(this._parse).filter(field=>onlyNested?accessPathDepth(field)>1:true).map(field=>{const expr=parseExpression$1(field,this._parse[field]);if(!expr){return null}const formula={type:"formula",expr:expr,as:removePathFromField(field)};return formula}).filter(t=>t!==null)}}class IdentifierNode extends DataFlowNode{clone(){return new IdentifierNode(null)}constructor(parent){super(parent)}dependentFields(){return new Set}producedFields(){return new Set([SELECTION_ID])}hash(){return"Identifier"}assemble(){return{type:"identifier",as:SELECTION_ID}}}class GraticuleNode extends DataFlowNode{clone(){return new GraticuleNode(null,this.params)}constructor(parent,params){super(parent);this.params=params}dependentFields(){return new Set}producedFields(){return undefined}hash(){return"Graticule ".concat(hash(this.params))}assemble(){return{type:"graticule",...this.params===true?{}:this.params}}}class SequenceNode extends DataFlowNode{clone(){return new SequenceNode(null,this.params)}constructor(parent,params){super(parent);this.params=params}dependentFields(){return new Set}producedFields(){var _this$params$as;return new Set([(_this$params$as=this.params.as)!==null&&_this$params$as!==void 0?_this$params$as:"data"])}hash(){return"Hash ".concat(hash(this.params))}assemble(){return{type:"sequence",...this.params}}}class SourceNode extends DataFlowNode{constructor(data){var _data;super(null);_defineProperty(this,"_data",void 0);_defineProperty(this,"_name",void 0);_defineProperty(this,"_generator",void 0);data=(_data=data)!==null&&_data!==void 0?_data:{name:"source"};let format;if(!isGenerator(data)){format=data.format?{...omit(data.format,["parse"])}:{}}if(isInlineData(data)){this._data={values:data.values}}else if(isUrlData(data)){this._data={url:data.url};if(!format.type){let defaultExtension=/(?:\.([^.]+))?$/.exec(data.url)[1];if(!contains(["json","csv","tsv","dsv","topojson"],defaultExtension)){defaultExtension="json"}format.type=defaultExtension}}else if(isSphereGenerator(data)){this._data={values:[{type:"Sphere"}]}}else if(isNamedData(data)||isGenerator(data)){this._data={}}this._generator=isGenerator(data);if(data.name){this._name=data.name}if(format&&!isEmpty(format)){this._data.format=format}}dependentFields(){return new Set}producedFields(){return undefined}get data(){return this._data}hasName(){return!!this._name}get isGenerator(){return this._generator}get dataName(){return this._name}set dataName(name){this._name=name}set parent(parent){throw new Error("Source nodes have to be roots.")}remove(){throw new Error("Source nodes are roots and cannot be removed.")}hash(){throw new Error("Cannot hash sources")}assemble(){return{name:this._name,...this._data,transform:[]}}}function isDataSourceNode(node){return node instanceof SourceNode||node instanceof GraticuleNode||node instanceof SequenceNode}var _modified=new WeakMap;class Optimizer{constructor(){_modified.set(this,{writable:true,value:void 0});_classPrivateFieldSet(this,_modified,false)}setModified(){_classPrivateFieldSet(this,_modified,true)}get modifiedFlag(){return _classPrivateFieldGet(this,_modified)}}class BottomUpOptimizer extends Optimizer{getNodeDepths(node,depth,depths){depths.set(node,depth);for(const child of node.children){this.getNodeDepths(child,depth+1,depths)}return depths}optimize(node){const depths=this.getNodeDepths(node,0,new Map);const topologicalSort=[...depths.entries()].sort((a,b)=>b[1]-a[1]);for(const tuple of topologicalSort){this.run(tuple[0])}return this.modifiedFlag}}class TopDownOptimizer extends Optimizer{optimize(node){this.run(node);for(const child of node.children){this.optimize(child)}return this.modifiedFlag}}class MergeIdenticalNodes extends TopDownOptimizer{mergeNodes(parent,nodes){const mergedNode=nodes.shift();for(const node of nodes){parent.removeChild(node);node.parent=mergedNode;node.remove()}}run(node){const hashes=node.children.map(x=>x.hash());const buckets={};for(let i=0;i<hashes.length;i++){if(buckets[hashes[i]]===undefined){buckets[hashes[i]]=[node.children[i]]}else{buckets[hashes[i]].push(node.children[i])}}for(const k of keys(buckets)){if(buckets[k].length>1){this.setModified();this.mergeNodes(node,buckets[k])}}}}class RemoveUnnecessaryIdentifierNodes extends TopDownOptimizer{constructor(model){super();_defineProperty(this,"requiresSelectionId",void 0);this.requiresSelectionId=model&&requiresSelectionId(model)}run(node){if(node instanceof IdentifierNode){if(!(this.requiresSelectionId&&(isDataSourceNode(node.parent)||node.parent instanceof AggregateNode||node.parent instanceof ParseNode))){this.setModified();node.remove()}}}}class RemoveDuplicateTimeUnits extends Optimizer{optimize(node){this.run(node,new Set);return this.modifiedFlag}run(node,timeUnitFields){let producedFields=new Set;if(node instanceof TimeUnitNode){producedFields=node.producedFields();if(hasIntersection(producedFields,timeUnitFields)){this.setModified();node.removeFormulas(timeUnitFields);if(node.producedFields.length===0){node.remove()}}}for(const child of node.children){this.run(child,new Set([...timeUnitFields,...producedFields]))}}}class RemoveUnnecessaryOutputNodes extends TopDownOptimizer{constructor(){super()}run(node){if(node instanceof OutputNode&&!node.isRequired()){this.setModified();node.remove()}}}class MoveParseUp extends BottomUpOptimizer{run(node){if(isDataSourceNode(node)){return}if(node.numChildren()>1){return}for(const child of node.children){if(child instanceof ParseNode){if(node instanceof ParseNode){this.setModified();node.merge(child)}else{if(fieldIntersection(node.producedFields(),child.dependentFields())){continue}this.setModified();child.swapWithParent()}}}return}}class MergeParse extends BottomUpOptimizer{run(node){const originalChildren=[...node.children];const parseChildren=node.children.filter(child=>child instanceof ParseNode);if(node.numChildren()>1&&parseChildren.length>=1){const commonParse={};const conflictingParse=new Set;for(const parseNode of parseChildren){const parse=parseNode.parse;for(const k of keys(parse)){if(!(k in commonParse)){commonParse[k]=parse[k]}else if(commonParse[k]!==parse[k]){conflictingParse.add(k)}}}for(const field of conflictingParse){delete commonParse[field]}if(!isEmpty(commonParse)){this.setModified();const mergedParseNode=new ParseNode(node,commonParse);for(const childNode of originalChildren){if(childNode instanceof ParseNode){for(const key of keys(commonParse)){delete childNode.parse[key]}}node.removeChild(childNode);childNode.parent=mergedParseNode;if(childNode instanceof ParseNode&&keys(childNode.parse).length===0){childNode.remove()}}}}}}class RemoveUnusedSubtrees extends BottomUpOptimizer{run(node){if(node instanceof OutputNode||node.numChildren()>0||node instanceof FacetNode);else if(node instanceof SourceNode);else{this.setModified();node.remove()}}}class MergeTimeUnits extends BottomUpOptimizer{run(node){const timeUnitChildren=node.children.filter(x=>x instanceof TimeUnitNode);const combination=timeUnitChildren.pop();for(const timeUnit of timeUnitChildren){this.setModified();combination.merge(timeUnit)}}}class MergeAggregates extends BottomUpOptimizer{run(node){const aggChildren=node.children.filter(child=>child instanceof AggregateNode);const groupedAggregates={};for(const agg of aggChildren){const groupBys=hash(agg.groupBy);if(!(groupBys in groupedAggregates)){groupedAggregates[groupBys]=[]}groupedAggregates[groupBys].push(agg)}for(const group of keys(groupedAggregates)){const mergeableAggs=groupedAggregates[group];if(mergeableAggs.length>1){const mergedAggs=mergeableAggs.pop();for(const agg of mergeableAggs){if(mergedAggs.merge(agg)){node.removeChild(agg);agg.parent=mergedAggs;agg.remove();this.setModified()}}}}}}class MergeBins extends BottomUpOptimizer{constructor(model){super();this.model=model}run(node){const moveBinsUp=!(isDataSourceNode(node)||node instanceof FilterNode||node instanceof ParseNode||node instanceof IdentifierNode);const promotableBins=[];const remainingBins=[];for(const child of node.children){if(child instanceof BinNode){if(moveBinsUp&&!fieldIntersection(node.producedFields(),child.dependentFields())){promotableBins.push(child)}else{remainingBins.push(child)}}}if(promotableBins.length>0){const promotedBin=promotableBins.pop();for(const bin of promotableBins){promotedBin.merge(bin,this.model.renameSignal.bind(this.model))}this.setModified();if(node instanceof BinNode){node.merge(promotedBin,this.model.renameSignal.bind(this.model))}else{promotedBin.swapWithParent()}}if(remainingBins.length>1){const remainingBin=remainingBins.pop();for(const bin of remainingBins){remainingBin.merge(bin,this.model.renameSignal.bind(this.model))}this.setModified()}}}class MergeOutputs extends BottomUpOptimizer{run(node){const children=[...node.children];const hasOutputChild=some(children,child=>child instanceof OutputNode);if(!hasOutputChild||node.numChildren()<=1){return}const otherChildren=[];let mainOutput;for(const child of children){if(child instanceof OutputNode){let lastOutput=child;while(lastOutput.numChildren()===1){const[theChild]=lastOutput.children;if(theChild instanceof OutputNode){lastOutput=theChild}else{break}}otherChildren.push(...lastOutput.children);if(mainOutput){node.removeChild(child);child.parent=mainOutput.parent;mainOutput.parent.removeChild(mainOutput);mainOutput.parent=lastOutput;this.setModified()}else{mainOutput=lastOutput}}else{otherChildren.push(child)}}if(otherChildren.length){this.setModified();for(const child of otherChildren){child.parent.removeChild(child);child.parent=mainOutput}}}}class JoinAggregateTransformNode extends DataFlowNode{clone(){return new JoinAggregateTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){this.transform.groupby=unique(this.transform.groupby.concat(fields),d=>d)}dependentFields(){const out=new Set;if(this.transform.groupby){this.transform.groupby.forEach(out.add,out)}this.transform.joinaggregate.map(w=>w.field).filter(f=>f!==undefined).forEach(out.add,out);return out}producedFields(){return new Set(this.transform.joinaggregate.map(this.getDefaultName))}getDefaultName(joinAggregateFieldDef){var _joinAggregateFieldDe;return(_joinAggregateFieldDe=joinAggregateFieldDef.as)!==null&&_joinAggregateFieldDe!==void 0?_joinAggregateFieldDe:vgField(joinAggregateFieldDef)}hash(){return"JoinAggregateTransform ".concat(hash(this.transform))}assemble(){const fields=[];const ops=[];const as=[];for(const joinaggregate of this.transform.joinaggregate){ops.push(joinaggregate.op);as.push(this.getDefaultName(joinaggregate));fields.push(joinaggregate.field===undefined?null:joinaggregate.field)}const groupby=this.transform.groupby;return{type:"joinaggregate",as:as,ops:ops,fields:fields,...groupby!==undefined?{groupby:groupby}:{}}}}function getStackByFields(model){return model.stack.stackBy.reduce((fields,by)=>{const fieldDef=by.fieldDef;const _field=vgField(fieldDef);if(_field){fields.push(_field)}return fields},[])}function isValidAsArray(as){return isArray(as)&&as.every(s=>isString(s))&&as.length>1}class StackNode extends DataFlowNode{clone(){return new StackNode(null,duplicate(this._stack))}constructor(parent,stack){super(parent);_defineProperty(this,"_stack",void 0);this._stack=stack}static makeFromTransform(parent,stackTransform){const{stack:stack,groupby:groupby,as:as,offset:offset="zero"}=stackTransform;const sortFields=[];const sortOrder=[];if(stackTransform.sort!==undefined){for(const sortField of stackTransform.sort){sortFields.push(sortField.field);sortOrder.push(getFirstDefined(sortField.order,"ascending"))}}const sort={field:sortFields,order:sortOrder};let normalizedAs;if(isValidAsArray(as)){normalizedAs=as}else if(isString(as)){normalizedAs=[as,as+"_end"]}else{normalizedAs=[stackTransform.stack+"_start",stackTransform.stack+"_end"]}return new StackNode(parent,{stackField:stack,groupby:groupby,offset:offset,sort:sort,facetby:[],as:normalizedAs})}static makeFromEncoding(parent,model){const stackProperties=model.stack;const{encoding:encoding}=model;if(!stackProperties){return null}const{groupbyChannel:groupbyChannel,fieldChannel:fieldChannel,offset:offset,impute:impute}=stackProperties;let dimensionFieldDef;if(groupbyChannel){const cDef=encoding[groupbyChannel];dimensionFieldDef=getFieldDef(cDef)}const stackby=getStackByFields(model);const orderDef=model.encoding.order;let sort;if(isArray(orderDef)||isFieldDef(orderDef)){sort=sortParams(orderDef)}else{sort=stackby.reduce((s,field)=>{s.field.push(field);s.order.push(fieldChannel==="y"?"descending":"ascending");return s},{field:[],order:[]})}return new StackNode(parent,{dimensionFieldDef:dimensionFieldDef,stackField:model.vgField(fieldChannel),facetby:[],stackby:stackby,sort:sort,offset:offset,impute:impute,as:[model.vgField(fieldChannel,{suffix:"start",forAs:true}),model.vgField(fieldChannel,{suffix:"end",forAs:true})]})}get stack(){return this._stack}addDimensions(fields){this._stack.facetby.push(...fields)}dependentFields(){const out=new Set;out.add(this._stack.stackField);this.getGroupbyFields().forEach(out.add,out);this._stack.facetby.forEach(out.add,out);this._stack.sort.field.forEach(out.add,out);return out}producedFields(){return new Set(this._stack.as)}hash(){return"Stack ".concat(hash(this._stack))}getGroupbyFields(){const{dimensionFieldDef:dimensionFieldDef,impute:impute,groupby:groupby}=this._stack;if(dimensionFieldDef){if(dimensionFieldDef.bin){if(impute){return[vgField(dimensionFieldDef,{binSuffix:"mid"})]}return[vgField(dimensionFieldDef,{}),vgField(dimensionFieldDef,{binSuffix:"end"})]}return[vgField(dimensionFieldDef)]}return groupby!==null&&groupby!==void 0?groupby:[]}assemble(){const transform=[];const{facetby:facetby,dimensionFieldDef:dimensionFieldDef,stackField:field,stackby:stackby,sort:sort,offset:offset,impute:impute,as:as}=this._stack;if(impute&&dimensionFieldDef){const{band:band=.5,bin:bin}=dimensionFieldDef;if(bin){transform.push({type:"formula",expr:"".concat(band,"*")+vgField(dimensionFieldDef,{expr:"datum"})+"+".concat(1-band,"*")+vgField(dimensionFieldDef,{expr:"datum",binSuffix:"end"}),as:vgField(dimensionFieldDef,{binSuffix:"mid",forAs:true})})}transform.push({type:"impute",field:field,groupby:[...stackby,...facetby],key:vgField(dimensionFieldDef,{binSuffix:"mid"}),method:"value",value:0})}transform.push({type:"stack",groupby:[...this.getGroupbyFields(),...facetby],field:field,sort:sort,as:as,offset:offset});return transform}}class WindowTransformNode extends DataFlowNode{clone(){return new WindowTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){this.transform.groupby=unique(this.transform.groupby.concat(fields),d=>d)}dependentFields(){var _this$transform$group,_this$transform$sort;const out=new Set;((_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]).forEach(out.add,out);((_this$transform$sort=this.transform.sort)!==null&&_this$transform$sort!==void 0?_this$transform$sort:[]).forEach(m=>out.add(m.field));this.transform.window.map(w=>w.field).filter(f=>f!==undefined).forEach(out.add,out);return out}producedFields(){return new Set(this.transform.window.map(this.getDefaultName))}getDefaultName(windowFieldDef){var _windowFieldDef$as;return(_windowFieldDef$as=windowFieldDef.as)!==null&&_windowFieldDef$as!==void 0?_windowFieldDef$as:vgField(windowFieldDef)}hash(){return"WindowTransform ".concat(hash(this.transform))}assemble(){const fields=[];const ops=[];const as=[];const params=[];for(const window of this.transform.window){ops.push(window.op);as.push(this.getDefaultName(window));params.push(window.param===undefined?null:window.param);fields.push(window.field===undefined?null:window.field)}const frame=this.transform.frame;const groupby=this.transform.groupby;if(frame&&frame[0]===null&&frame[1]===null&&ops.every(o=>isAggregateOp(o))){return{type:"joinaggregate",as:as,ops:ops,fields:fields,...groupby!==undefined?{groupby:groupby}:{}}}const sortFields=[];const sortOrder=[];if(this.transform.sort!==undefined){for(const sortField of this.transform.sort){var _sortField$order;sortFields.push(sortField.field);sortOrder.push((_sortField$order=sortField.order)!==null&&_sortField$order!==void 0?_sortField$order:"ascending")}}const sort={field:sortFields,order:sortOrder};const ignorePeers=this.transform.ignorePeers;return{type:"window",params:params,as:as,ops:ops,fields:fields,sort:sort,...ignorePeers!==undefined?{ignorePeers:ignorePeers}:{},...groupby!==undefined?{groupby:groupby}:{},...frame!==undefined?{frame:frame}:{}}}}function cloneSubtree(facet){function clone(node){if(!(node instanceof FacetNode)){const copy=node.clone();if(copy instanceof OutputNode){const newName=FACET_SCALE_PREFIX+copy.getSource();copy.setSource(newName);facet.model.component.data.outputNodes[newName]=copy}else if(copy instanceof AggregateNode||copy instanceof StackNode||copy instanceof WindowTransformNode||copy instanceof JoinAggregateTransformNode){copy.addDimensions(facet.fields)}for(const n of node.children.flatMap(clone)){n.parent=copy}return[copy]}return node.children.flatMap(clone)}return clone}function moveFacetDown(node){if(node instanceof FacetNode){if(node.numChildren()===1&&!(node.children[0]instanceof OutputNode)){const child=node.children[0];if(child instanceof AggregateNode||child instanceof StackNode||child instanceof WindowTransformNode||child instanceof JoinAggregateTransformNode){child.addDimensions(node.fields)}child.swapWithParent();moveFacetDown(node)}else{const facetMain=node.model.component.data.main;moveMainDownToFacet(facetMain);const cloner=cloneSubtree(node);const copy=node.children.map(cloner).flat();for(const c of copy){c.parent=facetMain}}}else{node.children.map(moveFacetDown)}}function moveMainDownToFacet(node){if(node instanceof OutputNode&&node.type===DataSourceType.Main){if(node.numChildren()===1){const child=node.children[0];if(!(child instanceof FacetNode)){child.swapWithParent();moveMainDownToFacet(node)}}}}const FACET_SCALE_PREFIX="scale_";const MAX_OPTIMIZATION_RUNS=5;function checkLinks(nodes){for(const node of nodes){for(const child of node.children){if(child.parent!==node){return false}}if(!checkLinks(node.children)){return false}}return true}function runOptimizer(optimizer,nodes){let modified=false;for(const node of nodes){modified=optimizer.optimize(node)||modified}return modified}function optimizationDataflowHelper(dataComponent,model,firstPass){let roots=dataComponent.sources;let modified=false;modified=runOptimizer(new RemoveUnnecessaryOutputNodes,roots)||modified;modified=runOptimizer(new RemoveUnnecessaryIdentifierNodes(model),roots)||modified;roots=roots.filter(r=>r.numChildren()>0);modified=runOptimizer(new RemoveUnusedSubtrees,roots)||modified;roots=roots.filter(r=>r.numChildren()>0);if(!firstPass){modified=runOptimizer(new MoveParseUp,roots)||modified;modified=runOptimizer(new MergeBins(model),roots)||modified;modified=runOptimizer(new RemoveDuplicateTimeUnits,roots)||modified;modified=runOptimizer(new MergeParse,roots)||modified;modified=runOptimizer(new MergeAggregates,roots)||modified;modified=runOptimizer(new MergeTimeUnits,roots)||modified;modified=runOptimizer(new MergeIdenticalNodes,roots)||modified;modified=runOptimizer(new MergeOutputs,roots)||modified}dataComponent.sources=roots;return modified}function optimizeDataflow(data,model){checkLinks(data.sources);let firstPassCounter=0;let secondPassCounter=0;for(let i=0;i<MAX_OPTIMIZATION_RUNS;i++){if(!optimizationDataflowHelper(data,model,true)){break}firstPassCounter++}data.sources.map(moveFacetDown);for(let i=0;i<MAX_OPTIMIZATION_RUNS;i++){if(!optimizationDataflowHelper(data,model,false)){break}secondPassCounter++}checkLinks(data.sources);if(Math.max(firstPassCounter,secondPassCounter)===MAX_OPTIMIZATION_RUNS){warn("Maximum optimization runs(".concat(MAX_OPTIMIZATION_RUNS,") reached."))}}class SignalRefWrapper{constructor(exprGenerator){_defineProperty(this,"signal",void 0);Object.defineProperty(this,"signal",{enumerable:true,get:exprGenerator})}static fromName(rename,signalName){return new SignalRefWrapper(()=>rename(signalName))}}function parseScaleDomain(model){if(isUnitModel(model)){parseUnitScaleDomain(model)}else{parseNonUnitScaleDomain(model)}}function parseUnitScaleDomain(model){const localScaleComponents=model.component.scales;for(const channel of keys(localScaleComponents)){const domains=parseDomainForChannel(model,channel);const localScaleCmpt=localScaleComponents[channel];localScaleCmpt.setWithExplicit("domains",domains);parseSelectionDomain(model,channel);if(model.component.data.isFaceted){let facetParent=model;while(!isFacetModel(facetParent)&&facetParent.parent){facetParent=facetParent.parent}const resolve=facetParent.component.resolve.scale[channel];if(resolve==="shared"){for(const domain of domains.value){if(isDataRefDomain(domain)){domain.data=FACET_SCALE_PREFIX+domain.data.replace(FACET_SCALE_PREFIX,"")}}}}}}function parseNonUnitScaleDomain(model){for(const child of model.children){parseScaleDomain(child)}const localScaleComponents=model.component.scales;for(const channel of keys(localScaleComponents)){let domains;let selectionExtent=null;for(const child of model.children){const childComponent=child.component.scales[channel];if(childComponent){if(domains===undefined){domains=childComponent.getWithExplicit("domains")}else{domains=mergeValuesWithExplicit(domains,childComponent.getWithExplicit("domains"),"domains","scale",domainsTieBreaker)}const se=childComponent.get("selectionExtent");if(selectionExtent&&se&&selectionExtent.selection!==se.selection){warn(NEEDS_SAME_SELECTION)}selectionExtent=se}}localScaleComponents[channel].setWithExplicit("domains",domains);if(selectionExtent){localScaleComponents[channel].set("selectionExtent",selectionExtent,true)}}}function normalizeUnaggregatedDomain(domain,fieldDef,scaleType,scaleConfig){if(domain==="unaggregated"){const{valid:valid,reason:reason}=canUseUnaggregatedDomain(fieldDef,scaleType);if(!valid){warn(reason);return undefined}}else if(domain===undefined&&scaleConfig.useUnaggregatedDomain){const{valid:valid}=canUseUnaggregatedDomain(fieldDef,scaleType);if(valid){return"unaggregated"}}return domain}function parseDomainForChannel(model,channel){const scaleType=model.getScaleComponent(channel).get("type");const{encoding:encoding}=model;const domain=normalizeUnaggregatedDomain(model.scaleDomain(channel),model.typedFieldDef(channel),scaleType,model.config.scale);if(domain!==model.scaleDomain(channel)){model.specifiedScales[channel]={...model.specifiedScales[channel],domain:domain}}if(channel==="x"&&getFieldOrDatumDef(encoding.x2)){if(getFieldOrDatumDef(encoding.x)){return mergeValuesWithExplicit(parseSingleChannelDomain(scaleType,domain,model,"x"),parseSingleChannelDomain(scaleType,domain,model,"x2"),"domain","scale",domainsTieBreaker)}else{return parseSingleChannelDomain(scaleType,domain,model,"x2")}}else if(channel==="y"&&getFieldOrDatumDef(encoding.y2)){if(getFieldOrDatumDef(encoding.y)){return mergeValuesWithExplicit(parseSingleChannelDomain(scaleType,domain,model,"y"),parseSingleChannelDomain(scaleType,domain,model,"y2"),"domain","scale",domainsTieBreaker)}else{return parseSingleChannelDomain(scaleType,domain,model,"y2")}}return parseSingleChannelDomain(scaleType,domain,model,channel)}function mapDomainToDataSignal(domain,type,timeUnit){return domain.map(v=>{const data=valueExpr(v,{timeUnit:timeUnit,type:type});return{signal:"{data: ".concat(data,"}")}})}function convertDomainIfItIsDateTime(domain,type,timeUnit){var _normalizeTimeUnit;const normalizedTimeUnit=(_normalizeTimeUnit=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit;if(type==="temporal"||normalizedTimeUnit){return mapDomainToDataSignal(domain,type,normalizedTimeUnit)}return[domain]}function parseSingleChannelDomain(scaleType,domain,model,channel){const{encoding:encoding}=model;const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const{type:type}=fieldOrDatumDef;const timeUnit=fieldOrDatumDef["timeUnit"];if(isDomainUnionWith(domain)){const defaultDomain=parseSingleChannelDomain(scaleType,undefined,model,channel);const unionWith=convertDomainIfItIsDateTime(domain.unionWith,type,timeUnit);return makeExplicit([...defaultDomain.value,...unionWith])}else if(isSignalRef(domain)){return makeExplicit([domain])}else if(domain&&domain!=="unaggregated"&&!isSelectionDomain(domain)){return makeExplicit(convertDomainIfItIsDateTime(domain,type,timeUnit))}const stack=model.stack;if(stack&&channel===stack.fieldChannel){if(stack.offset==="normalize"){return makeImplicit([[0,1]])}const data=model.requestDataName(DataSourceType.Main);return makeImplicit([{data:data,field:model.vgField(channel,{suffix:"start"})},{data:data,field:model.vgField(channel,{suffix:"end"})}])}const sort=isScaleChannel(channel)&&isFieldDef(fieldOrDatumDef)?domainSort(model,channel,scaleType):undefined;if(isDatumDef(fieldOrDatumDef)){const d=convertDomainIfItIsDateTime([fieldOrDatumDef.datum],type,timeUnit);return makeImplicit(d)}const fieldDef=fieldOrDatumDef;if(domain==="unaggregated"){const data=model.requestDataName(DataSourceType.Main);const{field:field}=fieldOrDatumDef;return makeImplicit([{data:data,field:vgField({field:field,aggregate:"min"})},{data:data,field:vgField({field:field,aggregate:"max"})}])}else if(isBinning(fieldDef.bin)){if(hasDiscreteDomain(scaleType)){if(scaleType==="bin-ordinal"){return makeImplicit([])}return makeImplicit([{data:isBoolean$1(sort)?model.requestDataName(DataSourceType.Main):model.requestDataName(DataSourceType.Raw),field:model.vgField(channel,binRequiresRange(fieldDef,channel)?{binSuffix:"range"}:{}),sort:sort===true||!isObject(sort)?{field:model.vgField(channel,{}),op:"min"}:sort}])}else{const{bin:bin}=fieldDef;if(isBinning(bin)){const binSignal=getBinSignalName(model,fieldDef.field,bin);return makeImplicit([new SignalRefWrapper(()=>{const signal=model.getSignalName(binSignal);return"[".concat(signal,".start, ").concat(signal,".stop]")})])}else{return makeImplicit([{data:model.requestDataName(DataSourceType.Main),field:model.vgField(channel,{})}])}}}else if(fieldDef.timeUnit&&contains(["time","utc"],scaleType)&&hasBand(channel,fieldDef,isUnitModel(model)?model.encoding[getSecondaryRangeChannel(channel)]:undefined,model.stack,model.markDef,model.config)){const data=model.requestDataName(DataSourceType.Main);return makeImplicit([{data:data,field:model.vgField(channel)},{data:data,field:model.vgField(channel,{suffix:"end"})}])}else if(sort){return makeImplicit([{data:isBoolean$1(sort)?model.requestDataName(DataSourceType.Main):model.requestDataName(DataSourceType.Raw),field:model.vgField(channel),sort:sort}])}else{return makeImplicit([{data:model.requestDataName(DataSourceType.Main),field:model.vgField(channel)}])}}function normalizeSortField(sort,isStackedMeasure){const{op:op,field:field,order:order}=sort;return{op:op!==null&&op!==void 0?op:isStackedMeasure?"sum":DEFAULT_SORT_OP,...field?{field:replacePathInField(field)}:{},...order?{order:order}:{}}}function parseSelectionDomain(model,channel){var _model$fieldDef;const scale=model.component.scales[channel];const spec=model.specifiedScales[channel].domain;const bin=(_model$fieldDef=model.fieldDef(channel))===null||_model$fieldDef===void 0?void 0:_model$fieldDef.bin;const domain=isSelectionDomain(spec)&&spec;const extent=isBinParams(bin)&&isSelectionExtent(bin.extent)&&bin.extent;if(domain||extent){scale.set("selectionExtent",domain!==null&&domain!==void 0?domain:extent,true)}}function domainSort(model,channel,scaleType){if(!hasDiscreteDomain(scaleType)){return undefined}const fieldDef=model.fieldDef(channel);const sort=fieldDef.sort;if(isSortArray(sort)){return{op:"min",field:sortArrayIndexField(fieldDef,channel),order:"ascending"}}const{stack:stack}=model;const stackDimensions=stack?[...stack.groupbyField?[stack.groupbyField]:[],...stack.stackBy.map(s=>s.fieldDef.field)]:undefined;if(isSortField(sort)){const isStackedMeasure=stack&&!contains(stackDimensions,sort.field);return normalizeSortField(sort,isStackedMeasure)}else if(isSortByEncoding(sort)){const{encoding:encoding,order:order}=sort;const fieldDefToSortBy=model.fieldDef(encoding);const{aggregate:aggregate,field:field}=fieldDefToSortBy;const isStackedMeasure=stack&&!contains(stackDimensions,field);if(isArgminDef(aggregate)||isArgmaxDef(aggregate)){return normalizeSortField({field:vgField(fieldDefToSortBy),order:order},isStackedMeasure)}else if(isAggregateOp(aggregate)||!aggregate){return normalizeSortField({op:aggregate,field:field,order:order},isStackedMeasure)}}else if(sort==="descending"){return{op:"min",field:model.vgField(channel),order:"descending"}}else if(contains(["ascending",undefined],sort)){return true}return undefined}function canUseUnaggregatedDomain(fieldDef,scaleType){const{aggregate:aggregate,type:type}=fieldDef;if(!aggregate){return{valid:false,reason:unaggregateDomainHasNoEffectForRawField(fieldDef)}}if(isString(aggregate)&&!SHARED_DOMAIN_OP_INDEX[aggregate]){return{valid:false,reason:unaggregateDomainWithNonSharedDomainOp(aggregate)}}if(type==="quantitative"){if(scaleType==="log"){return{valid:false,reason:unaggregatedDomainWithLogScale(fieldDef)}}}return{valid:true}}function domainsTieBreaker(v1,v2,property,propertyOf){if(v1.explicit&&v2.explicit){warn(mergeConflictingDomainProperty(property,propertyOf,v1.value,v2.value))}return{explicit:v1.explicit,value:[...v1.value,...v2.value]}}function mergeDomains(domains){const uniqueDomains=unique(domains.map(domain=>{if(isDataRefDomain(domain)){const{sort:_s,...domainWithoutSort}=domain;return domainWithoutSort}return domain}),hash);const sorts=unique(domains.map(d=>{if(isDataRefDomain(d)){const s=d.sort;if(s!==undefined&&!isBoolean$1(s)){if("op"in s&&s.op==="count"){delete s.field}if(s.order==="ascending"){delete s.order}}return s}return undefined}).filter(s=>s!==undefined),hash);if(uniqueDomains.length===0){return undefined}else if(uniqueDomains.length===1){const domain=domains[0];if(isDataRefDomain(domain)&&sorts.length>0){let sort=sorts[0];if(sorts.length>1){warn(MORE_THAN_ONE_SORT);sort=true}else{if(isObject(sort)&&"field"in sort){const sortField=sort.field;if(domain.field===sortField){sort=sort.order?{order:sort.order}:true}}}return{...domain,sort:sort}}return domain}const unionDomainSorts=unique(sorts.map(s=>{if(isBoolean$1(s)||!("op"in s)||isString(s.op)&&s.op in MULTIDOMAIN_SORT_OP_INDEX){return s}warn(domainSortDropped(s));return true}),hash);let sort;if(unionDomainSorts.length===1){sort=unionDomainSorts[0]}else if(unionDomainSorts.length>1){warn(MORE_THAN_ONE_SORT);sort=true}const allData=unique(domains.map(d=>{if(isDataRefDomain(d)){return d.data}return null}),x=>x);if(allData.length===1&&allData[0]!==null){const domain={data:allData[0],fields:uniqueDomains.map(d=>d.field),...sort?{sort:sort}:{}};return domain}return{fields:uniqueDomains,...sort?{sort:sort}:{}}}function getFieldFromDomain(domain){if(isDataRefDomain(domain)&&isString(domain.field)){return domain.field}else if(isDataRefUnionedDomain(domain)){let field;for(const nonUnionDomain of domain.fields){if(isDataRefDomain(nonUnionDomain)&&isString(nonUnionDomain.field)){if(!field){field=nonUnionDomain.field}else if(field!==nonUnionDomain.field){warn(FACETED_INDEPENDENT_DIFFERENT_SOURCES);return field}}}warn(FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES);return field}else if(isFieldRefUnionDomain(domain)){warn(FACETED_INDEPENDENT_SAME_SOURCE);const field=domain.fields[0];return isString(field)?field:undefined}return undefined}function assembleDomain(model,channel){const scaleComponent=model.component.scales[channel];const domains=scaleComponent.get("domains").map(domain=>{if(isDataRefDomain(domain)){domain.data=model.lookupDataSource(domain.data)}return domain});return mergeDomains(domains)}function assembleScales(model){if(isLayerModel(model)||isConcatModel(model)){return model.children.reduce((scales,child)=>scales.concat(assembleScales(child)),assembleScalesForModel(model))}else{return assembleScalesForModel(model)}}function assembleScalesForModel(model){return keys(model.component.scales).reduce((scales,channel)=>{const scaleComponent=model.component.scales[channel];if(scaleComponent.merged){return scales}const scale=scaleComponent.combine();const{name:name,type:type,selectionExtent:selectionExtent,domains:_d,range:_r,reverse:reverse,...otherScaleProps}=scale;const range=assembleScaleRange(scale.range,name,channel,model);let domainRaw;if(selectionExtent){domainRaw=assembleSelectionScaleDomain(model,selectionExtent)}const domain=assembleDomain(model,channel);scales.push({name:name,type:type,...domain?{domain:domain}:{},...domainRaw?{domainRaw:domainRaw}:{},range:range,...reverse!==undefined?{reverse:reverse}:{},...otherScaleProps});return scales},[])}function assembleScaleRange(scaleRange,scaleName,channel,model){if(isXorY(channel)){if(isVgRangeStep(scaleRange)){return{step:{signal:scaleName+"_step"}}}}else if(isObject(scaleRange)&&isDataRefDomain(scaleRange)){return{...scaleRange,data:model.lookupDataSource(scaleRange.data)}}return scaleRange}class ScaleComponent extends Split{constructor(name,typeWithExplicit){super({},{name:name});_defineProperty(this,"merged",false);this.setWithExplicit("type",typeWithExplicit)}domainDefinitelyIncludesZero(){if(this.get("zero")!==false){return true}return some(this.get("domains"),d=>isArray(d)&&d.length===2&&d[0]<=0&&d[1]>=0)}}const RANGE_PROPERTIES=["range","scheme"];function getSizeChannel$1(channel){return channel==="x"?"width":channel==="y"?"height":undefined}function parseUnitScaleRange(model){const localScaleComponents=model.component.scales;for(const channel of SCALE_CHANNELS){const localScaleCmpt=localScaleComponents[channel];if(!localScaleCmpt){continue}const rangeWithExplicit=parseRangeForChannel(channel,model);localScaleCmpt.setWithExplicit("range",rangeWithExplicit)}}function getBinStepSignal(model,channel){const fieldDef=model.fieldDef(channel);if(fieldDef&&fieldDef.bin&&isBinning(fieldDef.bin)){const binSignal=getBinSignalName(model,fieldDef.field,fieldDef.bin);const sizeType=getSizeChannel$1(channel);const sizeSignal=model.getName(sizeType);return new SignalRefWrapper(()=>{const updatedName=model.getSignalName(binSignal);const binCount="(".concat(updatedName,".stop - ").concat(updatedName,".start) / ").concat(updatedName,".step");return"".concat(model.getSignalName(sizeSignal)," / (").concat(binCount,")")})}return undefined}function parseRangeForChannel(channel,model){const specifiedScale=model.specifiedScales[channel];const{size:size}=model;const mergedScaleCmpt=model.getScaleComponent(channel);const scaleType=mergedScaleCmpt.get("type");for(const property of RANGE_PROPERTIES){if(specifiedScale[property]!==undefined){const supportedByScaleType=scaleTypeSupportProperty(scaleType,property);const channelIncompatability=channelScalePropertyIncompatability(channel,property);if(!supportedByScaleType){warn(scalePropertyNotWorkWithScaleType(scaleType,property,channel))}else if(channelIncompatability){warn(channelIncompatability)}else{switch(property){case"range":{const range=specifiedScale.range;if(isArray(range)){if(isXorY(channel)){return makeExplicit(range.map(v=>{if(v==="width"||v==="height"){const sizeSignal=model.getName(v);const getSignalName=model.getSignalName.bind(model);return SignalRefWrapper.fromName(getSignalName,sizeSignal)}return v}))}}else if(isObject(range)){return makeExplicit({data:model.requestDataName(DataSourceType.Main),field:range.field,sort:{op:"min",field:model.vgField(channel)}})}return makeExplicit(range)}case"scheme":return makeExplicit(parseScheme(specifiedScale[property]))}}}}if(channel===X||channel===Y){const sizeChannel=channel===X?"width":"height";const sizeValue=size[sizeChannel];if(isStep(sizeValue)){if(hasDiscreteDomain(scaleType)){return makeExplicit({step:sizeValue.step})}else{warn(stepDropped(sizeChannel))}}}const{rangeMin:rangeMin,rangeMax:rangeMax}=specifiedScale;const d=defaultRange(channel,model);if((rangeMin!==undefined||rangeMax!==undefined)&&scaleTypeSupportProperty(scaleType,"rangeMin")&&isArray(d)&&d.length===2){return makeExplicit([rangeMin!==null&&rangeMin!==void 0?rangeMin:d[0],rangeMax!==null&&rangeMax!==void 0?rangeMax:d[1]])}return makeImplicit(d)}function parseScheme(scheme){if(isExtendedScheme(scheme)){return{scheme:scheme.name,...omit(scheme,["name"])}}return{scheme:scheme}}function defaultRange(channel,model){const{size:size,config:config,mark:mark,encoding:encoding}=model;const getSignalName=model.getSignalName.bind(model);const{type:type}=getFieldOrDatumDef(encoding[channel]);const mergedScaleCmpt=model.getScaleComponent(channel);const scaleType=mergedScaleCmpt.get("type");const{domain:domain,domainMid:domainMid}=model.specifiedScales[channel];switch(channel){case X:case Y:{if(contains(["point","band"],scaleType)){if(channel===X&&!size.width){const w=getViewConfigDiscreteSize(config.view,"width");if(isStep(w)){return w}}else if(channel===Y&&!size.height){const h=getViewConfigDiscreteSize(config.view,"height");if(isStep(h)){return h}}}const sizeType=getSizeChannel$1(channel);const sizeSignal=model.getName(sizeType);if(channel===Y&&hasContinuousDomain(scaleType)){return[SignalRefWrapper.fromName(getSignalName,sizeSignal),0]}else{return[0,SignalRefWrapper.fromName(getSignalName,sizeSignal)]}}case SIZE:{const zero=model.component.scales[channel].get("zero");const rangeMin=sizeRangeMin(mark,zero,config);const rangeMax=sizeRangeMax(mark,size,model,config);if(isContinuousToDiscrete(scaleType)){return interpolateRange(rangeMin,rangeMax,defaultContinuousToDiscreteCount(scaleType,config,domain,channel))}else{return[rangeMin,rangeMax]}}case THETA:return[0,Math.PI*2];case ANGLE:return[0,360];case RADIUS:{return[0,new SignalRefWrapper(()=>{const w=model.getSignalName("width");const h=model.getSignalName("height");return"min(".concat(w,",").concat(h,")/2")})]}case STROKEWIDTH:return[config.scale.minStrokeWidth,config.scale.maxStrokeWidth];case STROKEDASH:return[[1,0],[4,2],[2,1],[1,1],[1,2,4,2]];case SHAPE:return"symbol";case COLOR:case FILL:case STROKE:if(scaleType==="ordinal"){return type==="nominal"?"category":"ordinal"}else{if(domainMid!==undefined){return"diverging"}else{return mark==="rect"||mark==="geoshape"?"heatmap":"ramp"}}case OPACITY:case FILLOPACITY:case STROKEOPACITY:return[config.scale.minOpacity,config.scale.maxOpacity]}throw new Error("Scale range undefined for channel ".concat(channel))}function defaultContinuousToDiscreteCount(scaleType,config,domain,channel){switch(scaleType){case"quantile":return config.scale.quantileCount;case"quantize":return config.scale.quantizeCount;case"threshold":if(domain!==undefined&&isArray(domain)){return domain.length+1}else{warn(domainRequiredForThresholdScale(channel));return 3}}}function interpolateRange(rangeMin,rangeMax,cardinality){const f=()=>{const rMax=signalOrStringValue(rangeMax);const rMin=signalOrStringValue(rangeMin);const step="(".concat(rMax," - ").concat(rMin,") / (").concat(cardinality," - 1)");return"sequence(".concat(rMin,", ").concat(rMax," + ").concat(step,", ").concat(step,")")};if(isSignalRef(rangeMax)){return new SignalRefWrapper(f)}else{return{signal:f()}}}function sizeRangeMin(mark,zero,config){if(zero){if(isSignalRef(zero)){return{signal:"".concat(zero.signal," ? 0 : ").concat(sizeRangeMin(mark,false,config))}}else{return 0}}switch(mark){case"bar":case"tick":return config.scale.minBandSize;case"line":case"trail":case"rule":return config.scale.minStrokeWidth;case"text":return config.scale.minFontSize;case"point":case"square":case"circle":return config.scale.minSize}throw new Error(incompatibleChannel("size",mark))}const MAX_SIZE_RANGE_STEP_RATIO=.95;function sizeRangeMax(mark,size,model,config){const xyStepSignals={x:getBinStepSignal(model,"x"),y:getBinStepSignal(model,"y")};switch(mark){case"bar":case"tick":{if(config.scale.maxBandSize!==undefined){return config.scale.maxBandSize}const min=minXYStep(size,xyStepSignals,config.view);if(isNumber(min)){return min-1}else{return new SignalRefWrapper(()=>"".concat(min.signal," - 1"))}}case"line":case"trail":case"rule":return config.scale.maxStrokeWidth;case"text":return config.scale.maxFontSize;case"point":case"square":case"circle":{if(config.scale.maxSize){return config.scale.maxSize}const pointStep=minXYStep(size,xyStepSignals,config.view);if(isNumber(pointStep)){return Math.pow(MAX_SIZE_RANGE_STEP_RATIO*pointStep,2)}else{return new SignalRefWrapper(()=>"pow(".concat(MAX_SIZE_RANGE_STEP_RATIO," * ").concat(pointStep.signal,", 2)"))}}}throw new Error(incompatibleChannel("size",mark))}function minXYStep(size,xyStepSignals,viewConfig){const widthStep=isStep(size.width)?size.width.step:getViewConfigDiscreteStep(viewConfig,"width");const heightStep=isStep(size.height)?size.height.step:getViewConfigDiscreteStep(viewConfig,"height");if(xyStepSignals.x||xyStepSignals.y){return new SignalRefWrapper(()=>{const exprs=[xyStepSignals.x?xyStepSignals.x.signal:widthStep,xyStepSignals.y?xyStepSignals.y.signal:heightStep];return"min(".concat(exprs.join(", "),")")})}return Math.min(widthStep,heightStep)}function parseScaleProperty(model,property){if(isUnitModel(model)){parseUnitScaleProperty(model,property)}else{parseNonUnitScaleProperty(model,property)}}function parseUnitScaleProperty(model,property){const localScaleComponents=model.component.scales;const{config:config,encoding:encoding,markDef:markDef,specifiedScales:specifiedScales}=model;for(const channel of keys(localScaleComponents)){const specifiedScale=specifiedScales[channel];const localScaleCmpt=localScaleComponents[channel];const mergedScaleCmpt=model.getScaleComponent(channel);const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const specifiedValue=specifiedScale[property];const scaleType=mergedScaleCmpt.get("type");const scalePadding=mergedScaleCmpt.get("padding");const scalePaddingInner=mergedScaleCmpt.get("paddingInner");const supportedByScaleType=scaleTypeSupportProperty(scaleType,property);const channelIncompatability=channelScalePropertyIncompatability(channel,property);if(specifiedValue!==undefined){if(!supportedByScaleType){warn(scalePropertyNotWorkWithScaleType(scaleType,property,channel))}else if(channelIncompatability){warn(channelIncompatability)}}if(supportedByScaleType&&channelIncompatability===undefined){if(specifiedValue!==undefined){const timeUnit=fieldOrDatumDef["timeUnit"];const type=fieldOrDatumDef.type;switch(property){case"domainMax":case"domainMin":if(isDateTime(specifiedScale[property])||type==="temporal"||timeUnit){localScaleCmpt.set(property,{signal:valueExpr(specifiedScale[property],{type:type,timeUnit:timeUnit})},true)}else{localScaleCmpt.set(property,specifiedScale[property],true)}break;default:localScaleCmpt.copyKeyFromObject(property,specifiedScale)}}else{const value=property in scaleRules?scaleRules[property]({model:model,channel:channel,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,scalePadding:scalePadding,scalePaddingInner:scalePaddingInner,domain:specifiedScale.domain,markDef:markDef,config:config}):config.scale[property];if(value!==undefined){localScaleCmpt.set(property,value,false)}}}}}const scaleRules={bins:({model:model,fieldOrDatumDef:fieldOrDatumDef})=>isFieldDef(fieldOrDatumDef)?bins(model,fieldOrDatumDef):undefined,interpolate:({channel:channel,fieldOrDatumDef:fieldOrDatumDef})=>interpolate(channel,fieldOrDatumDef.type),nice:({scaleType:scaleType,channel:channel,fieldOrDatumDef:fieldOrDatumDef})=>nice(scaleType,channel,fieldOrDatumDef),padding:({channel:channel,scaleType:scaleType,fieldOrDatumDef:fieldOrDatumDef,markDef:markDef,config:config})=>padding(channel,scaleType,config.scale,fieldOrDatumDef,markDef,config.bar),paddingInner:({scalePadding:scalePadding,channel:channel,markDef:markDef,config:config})=>paddingInner(scalePadding,channel,markDef.type,config.scale),paddingOuter:({scalePadding:scalePadding,channel:channel,scaleType:scaleType,markDef:markDef,scalePaddingInner:scalePaddingInner,config:config})=>paddingOuter(scalePadding,channel,scaleType,markDef.type,scalePaddingInner,config.scale),reverse:({fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,channel:channel,config:config})=>{const sort=isFieldDef(fieldOrDatumDef)?fieldOrDatumDef.sort:undefined;return reverse(scaleType,sort,channel,config.scale)},zero:({channel:channel,fieldOrDatumDef:fieldOrDatumDef,domain:domain,markDef:markDef,scaleType:scaleType})=>zero$1(channel,fieldOrDatumDef,domain,markDef,scaleType)};function parseScaleRange(model){if(isUnitModel(model)){parseUnitScaleRange(model)}else{parseNonUnitScaleProperty(model,"range")}}function parseNonUnitScaleProperty(model,property){const localScaleComponents=model.component.scales;for(const child of model.children){if(property==="range"){parseScaleRange(child)}else{parseScaleProperty(child,property)}}for(const channel of keys(localScaleComponents)){let valueWithExplicit;for(const child of model.children){const childComponent=child.component.scales[channel];if(childComponent){const childValueWithExplicit=childComponent.getWithExplicit(property);valueWithExplicit=mergeValuesWithExplicit(valueWithExplicit,childValueWithExplicit,property,"scale",tieBreakByComparing((v1,v2)=>{switch(property){case"range":if(v1.step&&v2.step){return v1.step-v2.step}return 0}return 0}))}}localScaleComponents[channel].setWithExplicit(property,valueWithExplicit)}}function bins(model,fieldDef){const bin=fieldDef.bin;if(isBinning(bin)){const binSignal=getBinSignalName(model,fieldDef.field,bin);return new SignalRefWrapper(()=>model.getSignalName(binSignal))}else if(isBinned(bin)&&isBinParams(bin)&&bin.step!==undefined){return{step:bin.step}}return undefined}function interpolate(channel,type){if(contains([COLOR,FILL,STROKE],channel)&&type!=="nominal"){return"hcl"}return undefined}function nice(scaleType,channel,fieldOrDatumDef){var _getFieldDef;if(((_getFieldDef=getFieldDef(fieldOrDatumDef))===null||_getFieldDef===void 0?void 0:_getFieldDef.bin)||contains([ScaleType.TIME,ScaleType.UTC],scaleType)){return undefined}return channel in POSITION_SCALE_CHANNEL_INDEX?true:undefined}function padding(channel,scaleType,scaleConfig,fieldOrDatumDef,markDef,barConfig){if(channel in POSITION_SCALE_CHANNEL_INDEX){if(isContinuousToContinuous(scaleType)){if(scaleConfig.continuousPadding!==undefined){return scaleConfig.continuousPadding}const{type:type,orient:orient}=markDef;if(type==="bar"&&!(isFieldDef(fieldOrDatumDef)&&(fieldOrDatumDef.bin||fieldOrDatumDef.timeUnit))){if(orient==="vertical"&&channel==="x"||orient==="horizontal"&&channel==="y"){return barConfig.continuousBandSize}}}if(scaleType===ScaleType.POINT){return scaleConfig.pointPadding}}return undefined}function paddingInner(paddingValue,channel,mark,scaleConfig){if(paddingValue!==undefined){return undefined}if(channel in POSITION_SCALE_CHANNEL_INDEX){const{bandPaddingInner:bandPaddingInner,barBandPaddingInner:barBandPaddingInner,rectBandPaddingInner:rectBandPaddingInner}=scaleConfig;return getFirstDefined(bandPaddingInner,mark==="bar"?barBandPaddingInner:rectBandPaddingInner)}return undefined}function paddingOuter(paddingValue,channel,scaleType,mark,paddingInnerValue,scaleConfig){if(paddingValue!==undefined){return undefined}if(channel in POSITION_SCALE_CHANNEL_INDEX){if(scaleType===ScaleType.BAND){const{bandPaddingOuter:bandPaddingOuter}=scaleConfig;return getFirstDefined(bandPaddingOuter,isSignalRef(paddingInnerValue)?{signal:"".concat(paddingInnerValue.signal,"/2")}:paddingInnerValue/2)}}return undefined}function reverse(scaleType,sort,channel,scaleConfig){if(channel==="x"&&scaleConfig.xReverse!==undefined){if(hasContinuousDomain(scaleType)&&sort==="descending"){if(isSignalRef(scaleConfig.xReverse)){return{signal:"!".concat(scaleConfig.xReverse.signal)}}else{return!scaleConfig.xReverse}}return scaleConfig.xReverse}if(hasContinuousDomain(scaleType)&&sort==="descending"){return true}return undefined}function zero$1(channel,fieldDef,specifiedDomain,markDef,scaleType){const hasCustomDomain=!!specifiedDomain&&specifiedDomain!=="unaggregated";if(hasCustomDomain){if(hasContinuousDomain(scaleType)){if(isArray(specifiedDomain)){const first=specifiedDomain[0];const last=specifiedDomain[specifiedDomain.length-1];if(first<=0&&last>=0){return true}}return false}}if(channel==="size"&&fieldDef.type==="quantitative"&&!isContinuousToDiscrete(scaleType)){return true}if(!(isFieldDef(fieldDef)&&fieldDef.bin)&&contains([...POSITION_SCALE_CHANNELS,...POLAR_POSITION_SCALE_CHANNELS],channel)){const{orient:orient,type:type}=markDef;if(contains(["bar","area","line","trail"],type)){if(orient==="horizontal"&&channel==="y"||orient==="vertical"&&channel==="x"){return false}}return true}return false}function scaleType(specifiedScale,channel,fieldDef,mark){const defaultScaleType=defaultType$2(channel,fieldDef,mark);const{type:type}=specifiedScale;if(!isScaleChannel(channel)){return null}if(type!==undefined){if(!channelSupportScaleType(channel,type)){warn(scaleTypeNotWorkWithChannel(channel,type,defaultScaleType));return defaultScaleType}if(isFieldDef(fieldDef)&&!scaleTypeSupportDataType(type,fieldDef.type)){warn(scaleTypeNotWorkWithFieldDef(type,defaultScaleType));return defaultScaleType}return type}return defaultScaleType}function defaultType$2(channel,fieldDef,mark){var _fieldDef$axis;switch(fieldDef.type){case"nominal":case"ordinal":if(isColorChannel(channel)||rangeType(channel)==="discrete"){if(channel==="shape"&&fieldDef.type==="ordinal"){warn(discreteChannelCannotEncode(channel,"ordinal"))}return"ordinal"}if(channel in POSITION_SCALE_CHANNEL_INDEX){if(contains(["rect","bar","image","rule"],mark)){return"band"}}else if(mark==="arc"&&channel in POLAR_POSITION_SCALE_CHANNEL_INDEX){return"band"}if(fieldDef.band!==undefined||isPositionFieldOrDatumDef(fieldDef)&&((_fieldDef$axis=fieldDef.axis)===null||_fieldDef$axis===void 0?void 0:_fieldDef$axis.tickBand)){return"band"}return"point";case"temporal":if(isColorChannel(channel)){return"time"}else if(rangeType(channel)==="discrete"){warn(discreteChannelCannotEncode(channel,"temporal"));return"ordinal"}else if(isFieldDef(fieldDef)&&fieldDef.timeUnit&&normalizeTimeUnit(fieldDef.timeUnit).utc){return"utc"}return"time";case"quantitative":if(isColorChannel(channel)){if(isFieldDef(fieldDef)&&isBinning(fieldDef.bin)){return"bin-ordinal"}return"linear"}else if(rangeType(channel)==="discrete"){warn(discreteChannelCannotEncode(channel,"quantitative"));return"ordinal"}return"linear";case"geojson":return undefined}throw new Error(invalidFieldType(fieldDef.type))}function parseScales(model,{ignoreRange:ignoreRange}={}){parseScaleCore(model);parseScaleDomain(model);for(const prop of NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTIES){parseScaleProperty(model,prop)}if(!ignoreRange){parseScaleRange(model)}}function parseScaleCore(model){if(isUnitModel(model)){model.component.scales=parseUnitScaleCore(model)}else{model.component.scales=parseNonUnitScaleCore(model)}}function parseUnitScaleCore(model){const{encoding:encoding,mark:mark}=model;return SCALE_CHANNELS.reduce((scaleComponents,channel)=>{const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef&&mark===GEOSHAPE&&channel===SHAPE&&fieldOrDatumDef.type===GEOJSON){return scaleComponents}let specifiedScale=fieldOrDatumDef&&fieldOrDatumDef["scale"];if(fieldOrDatumDef&&specifiedScale!==null&&specifiedScale!==false){var _specifiedScale;specifiedScale=(_specifiedScale=specifiedScale)!==null&&_specifiedScale!==void 0?_specifiedScale:{};const sType=scaleType(specifiedScale,channel,fieldOrDatumDef,mark);scaleComponents[channel]=new ScaleComponent(model.scaleName(channel+"",true),{value:sType,explicit:specifiedScale.type===sType})}return scaleComponents},{})}const scaleTypeTieBreaker=tieBreakByComparing((st1,st2)=>scaleTypePrecedence(st1)-scaleTypePrecedence(st2));function parseNonUnitScaleCore(model){const scaleComponents=model.component.scales={};const scaleTypeWithExplicitIndex={};const resolve=model.component.resolve;for(const child of model.children){parseScaleCore(child);for(const channel of keys(child.component.scales)){var _resolve$scale$channe;resolve.scale[channel]=(_resolve$scale$channe=resolve.scale[channel])!==null&&_resolve$scale$channe!==void 0?_resolve$scale$channe:defaultScaleResolve(channel,model);if(resolve.scale[channel]==="shared"){const explicitScaleType=scaleTypeWithExplicitIndex[channel];const childScaleType=child.component.scales[channel].getWithExplicit("type");if(explicitScaleType){if(scaleCompatible(explicitScaleType.value,childScaleType.value)){scaleTypeWithExplicitIndex[channel]=mergeValuesWithExplicit(explicitScaleType,childScaleType,"type","scale",scaleTypeTieBreaker)}else{resolve.scale[channel]="independent";delete scaleTypeWithExplicitIndex[channel]}}else{scaleTypeWithExplicitIndex[channel]=childScaleType}}}}for(const channel of keys(scaleTypeWithExplicitIndex)){const name=model.scaleName(channel,true);const typeWithExplicit=scaleTypeWithExplicitIndex[channel];scaleComponents[channel]=new ScaleComponent(name,typeWithExplicit);for(const child of model.children){const childScale=child.component.scales[channel];if(childScale){child.renameScale(childScale.get("name"),name);childScale.merged=true}}}return scaleComponents}class NameMap{constructor(){_defineProperty(this,"nameMap",void 0);this.nameMap={}}rename(oldName,newName){this.nameMap[oldName]=newName}has(name){return this.nameMap[name]!==undefined}get(name){while(this.nameMap[name]&&name!==this.nameMap[name]){name=this.nameMap[name]}return name}}function isUnitModel(model){return(model===null||model===void 0?void 0:model.type)==="unit"}function isFacetModel(model){return(model===null||model===void 0?void 0:model.type)==="facet"}function isConcatModel(model){return(model===null||model===void 0?void 0:model.type)==="concat"}function isLayerModel(model){return(model===null||model===void 0?void 0:model.type)==="layer"}class Model{constructor(spec,type,parent,parentGivenName,config,resolve,view){var _spec$name,_spec$transform;this.type=type;this.parent=parent;this.config=config;_defineProperty(this,"name",void 0);_defineProperty(this,"size",void 0);_defineProperty(this,"title",void 0);_defineProperty(this,"description",void 0);_defineProperty(this,"data",void 0);_defineProperty(this,"transforms",void 0);_defineProperty(this,"layout",void 0);_defineProperty(this,"scaleNameMap",void 0);_defineProperty(this,"projectionNameMap",void 0);_defineProperty(this,"signalNameMap",void 0);_defineProperty(this,"component",void 0);_defineProperty(this,"view",void 0);_defineProperty(this,"children",[]);_defineProperty(this,"correctDataNames",mark=>{if(mark.from&&mark.from.data){mark.from.data=this.lookupDataSource(mark.from.data)}if(mark.from&&mark.from.facet&&mark.from.facet.data){mark.from.facet.data=this.lookupDataSource(mark.from.facet.data)}return mark});this.parent=parent;this.config=config;this.view=replaceExprRefInIndex(view);this.name=(_spec$name=spec.name)!==null&&_spec$name!==void 0?_spec$name:parentGivenName;this.title=isText(spec.title)?{text:spec.title}:spec.title?this.initTitle(spec.title):undefined;this.scaleNameMap=parent?parent.scaleNameMap:new NameMap;this.projectionNameMap=parent?parent.projectionNameMap:new NameMap;this.signalNameMap=parent?parent.signalNameMap:new NameMap;this.data=spec.data;this.description=spec.description;this.transforms=normalizeTransform((_spec$transform=spec.transform)!==null&&_spec$transform!==void 0?_spec$transform:[]);this.layout=type==="layer"||type==="unit"?{}:extractCompositionLayout(spec,type,config);this.component={data:{sources:parent?parent.component.data.sources:[],outputNodes:parent?parent.component.data.outputNodes:{},outputNodeRefCounts:parent?parent.component.data.outputNodeRefCounts:{},isFaceted:isFacetSpec(spec)||parent&&parent.component.data.isFaceted&&spec.data===undefined},layoutSize:new Split,layoutHeaders:{row:{},column:{},facet:{}},mark:null,resolve:{scale:{},axis:{},legend:{},...resolve?duplicate(resolve):{}},selection:null,scales:null,projection:null,axes:{},legends:{}}}initTitle(title){const props=keys(title);const titleInternal={text:signalRefOrValue(title.text)};for(const prop of props){titleInternal[prop]=signalRefOrValue(title[prop])}return titleInternal}get width(){return this.getSizeSignalRef("width")}get height(){return this.getSizeSignalRef("height")}parse(){this.parseScale();this.parseLayoutSize();this.renameTopLevelLayoutSizeSignal();this.parseSelections();this.parseProjection();this.parseData();this.parseAxesAndHeaders();this.parseLegends();this.parseMarkGroup()}parseScale(){parseScales(this)}parseProjection(){parseProjection(this)}renameTopLevelLayoutSizeSignal(){if(this.getName("width")!=="width"){this.renameSignal(this.getName("width"),"width")}if(this.getName("height")!=="height"){this.renameSignal(this.getName("height"),"height")}}parseLegends(){parseLegend(this)}assembleGroupStyle(){if(this.type==="unit"||this.type==="layer"){var _this$view$style,_this$view;return(_this$view$style=(_this$view=this.view)===null||_this$view===void 0?void 0:_this$view.style)!==null&&_this$view$style!==void 0?_this$view$style:"cell"}return undefined}assembleEncodeFromView(view){const{style:_,...baseView}=view;const e={};for(const property of keys(baseView)){const value=baseView[property];if(value!==undefined){e[property]=signalOrValueRef(value)}}return e}assembleGroupEncodeEntry(isTopLevel){let encodeEntry={};if(this.view){encodeEntry=this.assembleEncodeFromView(this.view)}if(!isTopLevel){if(this.description){encodeEntry["description"]=signalOrValueRef(this.description)}if(this.type==="unit"||this.type==="layer"){var _encodeEntry;return{width:this.getSizeSignalRef("width"),height:this.getSizeSignalRef("height"),...(_encodeEntry=encodeEntry)!==null&&_encodeEntry!==void 0?_encodeEntry:{}}}}return isEmpty(encodeEntry)?undefined:encodeEntry}assembleLayout(){if(!this.layout){return undefined}const{spacing:spacing,...layout}=this.layout;const{component:component,config:config}=this;const titleBand=assembleLayoutTitleBand(component.layoutHeaders,config);return{padding:spacing,...this.assembleDefaultLayout(),...layout,...titleBand?{titleBand:titleBand}:{}}}assembleDefaultLayout(){return{}}assembleHeaderMarks(){const{layoutHeaders:layoutHeaders}=this.component;let headerMarks=[];for(const channel of FACET_CHANNELS){if(layoutHeaders[channel].title){headerMarks.push(assembleTitleGroup(this,channel))}}for(const channel of HEADER_CHANNELS){headerMarks=headerMarks.concat(assembleHeaderGroups(this,channel))}return headerMarks}assembleAxes(){return assembleAxes(this.component.axes,this.config)}assembleLegends(){return assembleLegends(this)}assembleProjections(){return assembleProjections(this)}assembleTitle(){var _this$title;const{encoding:encoding,...titleNoEncoding}=(_this$title=this.title)!==null&&_this$title!==void 0?_this$title:{};const title={...extractTitleConfig(this.config.title).nonMark,...titleNoEncoding,...encoding?{encode:{update:encoding}}:{}};if(title.text){if(contains(["unit","layer"],this.type)){if(contains(["middle",undefined],title.anchor)){var _title$frame;title.frame=(_title$frame=title.frame)!==null&&_title$frame!==void 0?_title$frame:"group"}}else{var _title$anchor;title.anchor=(_title$anchor=title.anchor)!==null&&_title$anchor!==void 0?_title$anchor:"start"}return isEmpty(title)?undefined:title}return undefined}assembleGroup(signals=[]){const group={};signals=signals.concat(this.assembleSignals());if(signals.length>0){group.signals=signals}const layout=this.assembleLayout();if(layout){group.layout=layout}group.marks=[].concat(this.assembleHeaderMarks(),this.assembleMarks());const scales=!this.parent||isFacetModel(this.parent)?assembleScales(this):[];if(scales.length>0){group.scales=scales}const axes=this.assembleAxes();if(axes.length>0){group.axes=axes}const legends=this.assembleLegends();if(legends.length>0){group.legends=legends}return group}getName(text){return varName((this.name?this.name+"_":"")+text)}getDataName(type){return this.getName(DataSourceType[type].toLowerCase())}requestDataName(name){const fullName=this.getDataName(name);const refCounts=this.component.data.outputNodeRefCounts;refCounts[fullName]=(refCounts[fullName]||0)+1;return fullName}getSizeSignalRef(layoutSizeType){if(isFacetModel(this.parent)){const sizeType=getSizeTypeFromLayoutSizeType(layoutSizeType);const channel=getPositionScaleChannel(sizeType);const scaleComponent=this.component.scales[channel];if(scaleComponent&&!scaleComponent.merged){const type=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const scaleName=scaleComponent.get("name");const domain=assembleDomain(this,channel);const field=getFieldFromDomain(domain);if(field){const fieldRef=vgField({aggregate:"distinct",field:field},{expr:"datum"});return{signal:sizeExpr(scaleName,scaleComponent,fieldRef)}}else{warn(unknownField(channel));return null}}}}return{signal:this.signalNameMap.get(this.getName(layoutSizeType))}}lookupDataSource(name){const node=this.component.data.outputNodes[name];if(!node){return name}return node.getSource()}getSignalName(oldSignalName){return this.signalNameMap.get(oldSignalName)}renameSignal(oldName,newName){this.signalNameMap.rename(oldName,newName)}renameScale(oldName,newName){this.scaleNameMap.rename(oldName,newName)}renameProjection(oldName,newName){this.projectionNameMap.rename(oldName,newName)}scaleName(originalScaleName,parse){if(parse){return this.getName(originalScaleName)}if(isChannel(originalScaleName)&&isScaleChannel(originalScaleName)&&this.component.scales[originalScaleName]||this.scaleNameMap.has(this.getName(originalScaleName))){return this.scaleNameMap.get(this.getName(originalScaleName))}return undefined}projectionName(parse){if(parse){return this.getName("projection")}if(this.component.projection&&!this.component.projection.merged||this.projectionNameMap.has(this.getName("projection"))){return this.projectionNameMap.get(this.getName("projection"))}return undefined}getScaleComponent(channel){if(!this.component.scales){throw new Error("getScaleComponent cannot be called before parseScale(). Make sure you have called parseScale or use parseUnitModelWithScale().")}const localScaleComponent=this.component.scales[channel];if(localScaleComponent&&!localScaleComponent.merged){return localScaleComponent}return this.parent?this.parent.getScaleComponent(channel):undefined}getSelectionComponent(variableName,origName){let sel=this.component.selection[variableName];if(!sel&&this.parent){sel=this.parent.getSelectionComponent(variableName,origName)}if(!sel){throw new Error(selectionNotFound(origName))}return sel}hasAxisOrientSignalRef(){var _this$component$axes$,_this$component$axes$2;return((_this$component$axes$=this.component.axes.x)===null||_this$component$axes$===void 0?void 0:_this$component$axes$.some(a=>a.hasOrientSignalRef()))||((_this$component$axes$2=this.component.axes.y)===null||_this$component$axes$2===void 0?void 0:_this$component$axes$2.some(a=>a.hasOrientSignalRef()))}}class ModelWithField extends Model{vgField(channel,opt={}){const fieldDef=this.fieldDef(channel);if(!fieldDef){return undefined}return vgField(fieldDef,opt)}reduceFieldDef(f,init){return reduce(this.getMapping(),(acc,cd,c)=>{const fieldDef=getFieldDef(cd);if(fieldDef){return f(acc,fieldDef,c)}return acc},init)}forEachFieldDef(f,t){forEach(this.getMapping(),(cd,c)=>{const fieldDef=getFieldDef(cd);if(fieldDef){f(fieldDef,c)}},t)}}class DensityTransformNode extends DataFlowNode{clone(){return new DensityTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"value",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"density"]}dependentFields(){var _this$transform$group;return new Set([this.transform.density,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return"DensityTransform ".concat(hash(this.transform))}assemble(){const{density:density,...rest}=this.transform;const result={type:"kde",field:density,...rest};return result}}class FilterInvalidNode extends DataFlowNode{clone(){return new FilterInvalidNode(null,{...this.filter})}constructor(parent,filter){super(parent);this.filter=filter}static make(parent,model){const{config:config,mark:mark,markDef:markDef}=model;const invalid=getMarkPropOrConfig("invalid",markDef,config);if(invalid!=="filter"){return null}const filter=model.reduceFieldDef((aggregator,fieldDef,channel)=>{const scaleComponent=isScaleChannel(channel)&&model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");if(hasContinuousDomain(scaleType)&&fieldDef.aggregate!=="count"&&!isPathMark(mark)){aggregator[fieldDef.field]=fieldDef}}return aggregator},{});if(!keys(filter).length){return null}return new FilterInvalidNode(parent,filter)}dependentFields(){return new Set(keys(this.filter))}producedFields(){return new Set}hash(){return"FilterInvalid ".concat(hash(this.filter))}assemble(){const filters=keys(this.filter).reduce((vegaFilters,field)=>{const fieldDef=this.filter[field];const ref=vgField(fieldDef,{expr:"datum"});if(fieldDef!==null){if(fieldDef.type==="temporal"){vegaFilters.push("(isDate(".concat(ref,") || (isValid(").concat(ref,") && isFinite(+").concat(ref,")))"))}else if(fieldDef.type==="quantitative"){vegaFilters.push("isValid(".concat(ref,")"));vegaFilters.push("isFinite(+".concat(ref,")"))}else;}return vegaFilters},[]);return filters.length>0?{type:"filter",expr:filters.join(" && ")}:null}}class FlattenTransformNode extends DataFlowNode{clone(){return new FlattenTransformNode(this.parent,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform;this.transform=duplicate(transform);const{flatten:flatten,as:as=[]}=this.transform;this.transform.as=flatten.map((f,i)=>{var _as$i;return(_as$i=as[i])!==null&&_as$i!==void 0?_as$i:f})}dependentFields(){return new Set(this.transform.flatten)}producedFields(){return new Set(this.transform.as)}hash(){return"FlattenTransform ".concat(hash(this.transform))}assemble(){const{flatten:fields,as:as}=this.transform;const result={type:"flatten",fields:fields,as:as};return result}}class FoldTransformNode extends DataFlowNode{clone(){return new FoldTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"key",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"value"]}dependentFields(){return new Set(this.transform.fold)}producedFields(){return new Set(this.transform.as)}hash(){return"FoldTransform ".concat(hash(this.transform))}assemble(){const{fold:fold,as:as}=this.transform;const result={type:"fold",fields:fold,as:as};return result}}class GeoJSONNode extends DataFlowNode{clone(){return new GeoJSONNode(null,duplicate(this.fields),this.geojson,this.signal)}static parseAll(parent,model){if(model.component.projection&&!model.component.projection.isFit){return parent}let geoJsonCounter=0;for(const coordinates of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){const pair=coordinates.map(channel=>{const def=getFieldOrDatumDef(model.encoding[channel]);return isFieldDef(def)?def.field:isDatumDef(def)?{expr:"".concat(def.datum)}:isValueDef(def)?{expr:"".concat(def["value"])}:undefined});if(pair[0]||pair[1]){parent=new GeoJSONNode(parent,pair,null,model.getName("geojson_".concat(geoJsonCounter++)))}}if(model.channelHasField(SHAPE)){const fieldDef=model.typedFieldDef(SHAPE);if(fieldDef.type===GEOJSON){parent=new GeoJSONNode(parent,null,fieldDef.field,model.getName("geojson_".concat(geoJsonCounter++)))}}return parent}constructor(parent,fields,geojson,signal){super(parent);this.fields=fields;this.geojson=geojson;this.signal=signal}dependentFields(){var _this$fields;const fields=((_this$fields=this.fields)!==null&&_this$fields!==void 0?_this$fields:[]).filter(isString);return new Set([...this.geojson?[this.geojson]:[],...fields])}producedFields(){return new Set}hash(){return"GeoJSON ".concat(this.geojson," ").concat(this.signal," ").concat(hash(this.fields))}assemble(){return{type:"geojson",...this.fields?{fields:this.fields}:{},...this.geojson?{geojson:this.geojson}:{},signal:this.signal}}}class GeoPointNode extends DataFlowNode{clone(){return new GeoPointNode(null,this.projection,duplicate(this.fields),duplicate(this.as))}constructor(parent,projection,fields,as){super(parent);this.projection=projection;this.fields=fields;this.as=as}static parseAll(parent,model){if(!model.projectionName()){return parent}for(const coordinates of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){const pair=coordinates.map(channel=>{const def=getFieldOrDatumDef(model.encoding[channel]);return isFieldDef(def)?def.field:isDatumDef(def)?{expr:"".concat(def.datum)}:isValueDef(def)?{expr:"".concat(def["value"])}:undefined});const suffix=coordinates[0]===LONGITUDE2?"2":"";if(pair[0]||pair[1]){parent=new GeoPointNode(parent,model.projectionName(),pair,[model.getName("x"+suffix),model.getName("y"+suffix)])}}return parent}dependentFields(){return new Set(this.fields.filter(isString))}producedFields(){return new Set(this.as)}hash(){return"Geopoint ".concat(this.projection," ").concat(hash(this.fields)," ").concat(hash(this.as))}assemble(){return{type:"geopoint",projection:this.projection,fields:this.fields,as:this.as}}}class ImputeNode extends DataFlowNode{clone(){return new ImputeNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}dependentFields(){var _this$transform$group;return new Set([this.transform.impute,this.transform.key,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set([this.transform.impute])}processSequence(keyvals){const{start:start=0,stop:stop,step:step}=keyvals;const result=[start,stop,...step?[step]:[]].join(",");return{signal:"sequence(".concat(result,")")}}static makeFromTransform(parent,imputeTransform){return new ImputeNode(parent,imputeTransform)}static makeFromEncoding(parent,model){const encoding=model.encoding;const xDef=encoding.x;const yDef=encoding.y;if(isFieldDef(xDef)&&isFieldDef(yDef)){const imputedChannel=xDef.impute?xDef:yDef.impute?yDef:undefined;if(imputedChannel===undefined){return undefined}const keyChannel=xDef.impute?yDef:yDef.impute?xDef:undefined;const{method:method,value:value,frame:frame,keyvals:keyvals}=imputedChannel.impute;const groupbyFields=pathGroupingFields(model.mark,encoding);return new ImputeNode(parent,{impute:imputedChannel.field,key:keyChannel.field,...method?{method:method}:{},...value!==undefined?{value:value}:{},...frame?{frame:frame}:{},...keyvals!==undefined?{keyvals:keyvals}:{},...groupbyFields.length?{groupby:groupbyFields}:{}})}return null}hash(){return"Impute ".concat(hash(this.transform))}assemble(){const{impute:impute,key:key,keyvals:keyvals,method:method,groupby:groupby,value:value,frame:frame=[null,null]}=this.transform;const imputeTransform={type:"impute",field:impute,key:key,...keyvals?{keyvals:isImputeSequence(keyvals)?this.processSequence(keyvals):keyvals}:{},method:"value",...groupby?{groupby:groupby}:{},value:!method||method==="value"?value:null};if(method&&method!=="value"){const deriveNewField={type:"window",as:["imputed_".concat(impute,"_value")],ops:[method],fields:[impute],frame:frame,ignorePeers:false,...groupby?{groupby:groupby}:{}};const replaceOriginal={type:"formula",expr:"datum.".concat(impute," === null ? datum.imputed_").concat(impute,"_value : datum.").concat(impute),as:impute};return[imputeTransform,deriveNewField,replaceOriginal]}else{return[imputeTransform]}}}class LoessTransformNode extends DataFlowNode{clone(){return new LoessTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:transform.on,(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:transform.loess]}dependentFields(){var _this$transform$group;return new Set([this.transform.loess,this.transform.on,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return"LoessTransform ".concat(hash(this.transform))}assemble(){const{loess:loess,on:on,...rest}=this.transform;const result={type:"loess",x:on,y:loess,...rest};return result}}class LookupNode extends DataFlowNode{clone(){return new LookupNode(null,duplicate(this.transform),this.secondary)}constructor(parent,transform,secondary){super(parent);this.transform=transform;this.secondary=secondary}static make(parent,model,transform,counter){const sources=model.component.data.sources;const{from:from}=transform;let fromOutputNode=null;if(isLookupData(from)){let fromSource=findSource(from.data,sources);if(!fromSource){fromSource=new SourceNode(from.data);sources.push(fromSource)}const fromOutputName=model.getName("lookup_".concat(counter));fromOutputNode=new OutputNode(fromSource,fromOutputName,DataSourceType.Lookup,model.component.data.outputNodeRefCounts);model.component.data.outputNodes[fromOutputName]=fromOutputNode}else if(isLookupSelection(from)){const selName=from.selection;transform={as:selName,...transform};fromOutputNode=model.getSelectionComponent(varName(selName),selName).materialized;if(!fromOutputNode){throw new Error(noSameUnitLookup(selName))}}return new LookupNode(parent,transform,fromOutputNode.getSource())}dependentFields(){return new Set([this.transform.lookup])}producedFields(){return new Set(this.transform.as?array(this.transform.as):this.transform.from.fields)}hash(){return"Lookup ".concat(hash({transform:this.transform,secondary:this.secondary}))}assemble(){let foreign;if(this.transform.from.fields){foreign={values:this.transform.from.fields,...this.transform.as?{as:array(this.transform.as)}:{}}}else{let asName=this.transform.as;if(!isString(asName)){warn(NO_FIELDS_NEEDS_AS);asName="_lookup"}foreign={as:[asName]}}return{type:"lookup",from:this.secondary,key:this.transform.from.key,fields:[this.transform.lookup],...foreign,...this.transform.default?{default:this.transform.default}:{}}}}class QuantileTransformNode extends DataFlowNode{clone(){return new QuantileTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"prob",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"value"]}dependentFields(){var _this$transform$group;return new Set([this.transform.quantile,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return"QuantileTransform ".concat(hash(this.transform))}assemble(){const{quantile:quantile,...rest}=this.transform;const result={type:"quantile",field:quantile,...rest};return result}}class RegressionTransformNode extends DataFlowNode{clone(){return new RegressionTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:transform.on,(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:transform.regression]}dependentFields(){var _this$transform$group;return new Set([this.transform.regression,this.transform.on,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return"RegressionTransform ".concat(hash(this.transform))}assemble(){const{regression:regression,on:on,...rest}=this.transform;const result={type:"regression",x:on,y:regression,...rest};return result}}class PivotTransformNode extends DataFlowNode{clone(){return new PivotTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){var _this$transform$group;this.transform.groupby=unique(((_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]).concat(fields),d=>d)}producedFields(){return undefined}dependentFields(){var _this$transform$group2;return new Set([this.transform.pivot,this.transform.value,...(_this$transform$group2=this.transform.groupby)!==null&&_this$transform$group2!==void 0?_this$transform$group2:[]])}hash(){return"PivotTransform ".concat(hash(this.transform))}assemble(){const{pivot:pivot,value:value,groupby:groupby,limit:limit,op:op}=this.transform;return{type:"pivot",field:pivot,value:value,...limit!==undefined?{limit:limit}:{},...op!==undefined?{op:op}:{},...groupby!==undefined?{groupby:groupby}:{}}}}class SampleTransformNode extends DataFlowNode{clone(){return new SampleTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}dependentFields(){return new Set}producedFields(){return new Set}hash(){return"SampleTransform ".concat(hash(this.transform))}assemble(){return{type:"sample",size:this.transform.sample}}}function makeWalkTree(data){let datasetIndex=0;function walkTree(node,dataSource){if(node instanceof SourceNode){if(!node.isGenerator&&!isUrlData(node.data)){data.push(dataSource);const newData={name:null,source:dataSource.name,transform:[]};dataSource=newData}}if(node instanceof ParseNode){if(node.parent instanceof SourceNode&&!dataSource.source){var _dataSource$format;dataSource.format={...(_dataSource$format=dataSource.format)!==null&&_dataSource$format!==void 0?_dataSource$format:{},parse:node.assembleFormatParse()};dataSource.transform.push(...node.assembleTransforms(true))}else{dataSource.transform.push(...node.assembleTransforms())}}if(node instanceof FacetNode){if(!dataSource.name){dataSource.name="data_".concat(datasetIndex++)}if(!dataSource.source||dataSource.transform.length>0){data.push(dataSource);node.data=dataSource.name}else{node.data=dataSource.source}for(const d of node.assemble()){data.push(d)}return}if(node instanceof GraticuleNode||node instanceof SequenceNode||node instanceof FilterInvalidNode||node instanceof FilterNode||node instanceof CalculateNode||node instanceof GeoPointNode||node instanceof GeoJSONNode||node instanceof AggregateNode||node instanceof LookupNode||node instanceof WindowTransformNode||node instanceof JoinAggregateTransformNode||node instanceof FoldTransformNode||node instanceof FlattenTransformNode||node instanceof DensityTransformNode||node instanceof LoessTransformNode||node instanceof QuantileTransformNode||node instanceof RegressionTransformNode||node instanceof IdentifierNode||node instanceof SampleTransformNode||node instanceof PivotTransformNode){dataSource.transform.push(node.assemble())}if(node instanceof BinNode||node instanceof TimeUnitNode||node instanceof ImputeNode||node instanceof StackNode){dataSource.transform.push(...node.assemble())}if(node instanceof OutputNode){if(dataSource.source&&dataSource.transform.length===0){node.setSource(dataSource.source)}else if(node.parent instanceof OutputNode){node.setSource(dataSource.name)}else{if(!dataSource.name){dataSource.name="data_".concat(datasetIndex++)}node.setSource(dataSource.name);if(node.numChildren()===1){data.push(dataSource);const newData={name:null,source:dataSource.name,transform:[]};dataSource=newData}}}switch(node.numChildren()){case 0:if(node instanceof OutputNode&&(!dataSource.source||dataSource.transform.length>0)){data.push(dataSource)}break;case 1:walkTree(node.children[0],dataSource);break;default:{if(!dataSource.name){dataSource.name="data_".concat(datasetIndex++)}let source=dataSource.name;if(!dataSource.source||dataSource.transform.length>0){data.push(dataSource)}else{source=dataSource.source}for(const child of node.children){const newData={name:null,source:source,transform:[]};walkTree(child,newData)}break}}}return walkTree}function assembleFacetData(root){const data=[];const walkTree=makeWalkTree(data);for(const child of root.children){walkTree(child,{source:root.name,name:null,transform:[]})}return data}function assembleRootData(dataComponent,datasets){const data=[];const walkTree=makeWalkTree(data);let sourceIndex=0;for(const root of dataComponent.sources){if(!root.hasName()){root.dataName="source_".concat(sourceIndex++)}const newData=root.assemble();walkTree(root,newData)}for(const d of data){if(d.transform.length===0){delete d.transform}}let whereTo=0;for(const[i,d]of data.entries()){var _d$transform;if(((_d$transform=d.transform)!==null&&_d$transform!==void 0?_d$transform:[]).length===0&&!d.source){data.splice(whereTo++,0,data.splice(i,1)[0])}}for(const d of data){for(const t of(_d$transform2=d.transform)!==null&&_d$transform2!==void 0?_d$transform2:[]){var _d$transform2;if(t.type==="lookup"){t.from=dataComponent.outputNodes[t.from].getSource()}}}for(const d of data){if(d.name in datasets){d.values=datasets[d.name]}}return data}function getHeaderType(orient){if(orient==="top"||orient==="left"||isSignalRef(orient)){return"header"}return"footer"}function parseFacetHeaders(model){for(const channel of FACET_CHANNELS){parseFacetHeader(model,channel)}mergeChildAxis(model,"x");mergeChildAxis(model,"y")}function parseFacetHeader(model,channel){const{facet:facet,config:config,child:child,component:component}=model;if(model.channelHasField(channel)){var _fieldDef$header;const fieldDef=facet[channel];const titleConfig=getHeaderProperty("title",null,config,channel);let title$1=title(fieldDef,config,{allowDisabling:true,includeDefault:titleConfig===undefined||!!titleConfig});if(child.component.layoutHeaders[channel].title){title$1=isArray(title$1)?title$1.join(", "):title$1;title$1+=" / "+child.component.layoutHeaders[channel].title;child.component.layoutHeaders[channel].title=null}const labelOrient=getHeaderProperty("labelOrient",fieldDef,config,channel);const header=(_fieldDef$header=fieldDef.header)!==null&&_fieldDef$header!==void 0?_fieldDef$header:{};const labels=getFirstDefined(header.labels,config.header.labels,true);const headerType=contains(["bottom","right"],labelOrient)?"footer":"header";component.layoutHeaders[channel]={title:title$1,facetFieldDef:fieldDef,[headerType]:channel==="facet"?[]:[makeHeaderComponent(model,channel,labels)]}}}function makeHeaderComponent(model,channel,labels){const sizeType=channel==="row"?"height":"width";return{labels:labels,sizeSignal:model.child.component.layoutSize.get(sizeType)?model.child.getSizeSignalRef(sizeType):undefined,axes:[]}}function mergeChildAxis(model,channel){const{child:child}=model;if(child.component.axes[channel]){const{layoutHeaders:layoutHeaders,resolve:resolve}=model.component;resolve.axis[channel]=parseGuideResolve(resolve,channel);if(resolve.axis[channel]==="shared"){const headerChannel=channel==="x"?"column":"row";const layoutHeader=layoutHeaders[headerChannel];for(const axisComponent of child.component.axes[channel]){var _layoutHeader$headerT;const headerType=getHeaderType(axisComponent.get("orient"));layoutHeader[headerType]=(_layoutHeader$headerT=layoutHeader[headerType])!==null&&_layoutHeader$headerT!==void 0?_layoutHeader$headerT:[makeHeaderComponent(model,headerChannel,false)];const mainAxis=assembleAxis(axisComponent,"main",model.config,{header:true});if(mainAxis){layoutHeader[headerType][0].axes.push(mainAxis)}axisComponent.mainExtracted=true}}}}function parseLayerLayoutSize(model){parseChildrenLayoutSize(model);parseNonUnitLayoutSizeForChannel(model,"width");parseNonUnitLayoutSizeForChannel(model,"height")}function parseConcatLayoutSize(model){parseChildrenLayoutSize(model);const widthType=model.layout.columns===1?"width":"childWidth";const heightType=model.layout.columns===undefined?"height":"childHeight";parseNonUnitLayoutSizeForChannel(model,widthType);parseNonUnitLayoutSizeForChannel(model,heightType)}function parseChildrenLayoutSize(model){for(const child of model.children){child.parseLayoutSize()}}function parseNonUnitLayoutSizeForChannel(model,layoutSizeType){const sizeType=getSizeTypeFromLayoutSizeType(layoutSizeType);const channel=getPositionScaleChannel(sizeType);const resolve=model.component.resolve;const layoutSizeCmpt=model.component.layoutSize;let mergedSize;for(const child of model.children){const childSize=child.component.layoutSize.getWithExplicit(sizeType);const scaleResolve=resolve.scale[channel];if(scaleResolve==="independent"&&childSize.value==="step"){mergedSize=undefined;break}if(mergedSize){if(scaleResolve==="independent"&&mergedSize.value!==childSize.value){mergedSize=undefined;break}mergedSize=mergeValuesWithExplicit(mergedSize,childSize,sizeType,"")}else{mergedSize=childSize}}if(mergedSize){for(const child of model.children){model.renameSignal(child.getName(sizeType),model.getName(layoutSizeType));child.component.layoutSize.set(sizeType,"merged",false)}layoutSizeCmpt.setWithExplicit(layoutSizeType,mergedSize)}else{layoutSizeCmpt.setWithExplicit(layoutSizeType,{explicit:false,value:undefined})}}function parseUnitLayoutSize(model){const{size:size,component:component}=model;for(const channel of POSITION_SCALE_CHANNELS){const sizeType=getSizeChannel(channel);if(size[sizeType]){const specifiedSize=size[sizeType];component.layoutSize.set(sizeType,isStep(specifiedSize)?"step":specifiedSize,true)}else{const defaultSize=defaultUnitSize(model,sizeType);component.layoutSize.set(sizeType,defaultSize,false)}}}function defaultUnitSize(model,sizeType){const channel=sizeType==="width"?"x":"y";const config=model.config;const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(scaleType)){const size=getViewConfigDiscreteSize(config.view,sizeType);if(isVgRangeStep(range)||isStep(size)){return"step"}else{return size}}else{return getViewConfigContinuousSize(config.view,sizeType)}}else if(model.hasProjection||model.mark==="arc"){return getViewConfigContinuousSize(config.view,sizeType)}else{const size=getViewConfigDiscreteSize(config.view,sizeType);return isStep(size)?size.step:size}}function facetSortFieldName(fieldDef,sort,opt){return vgField(sort,{suffix:"by_".concat(vgField(fieldDef)),...opt!==null&&opt!==void 0?opt:{}})}class FacetModel extends ModelWithField{constructor(spec,parent,parentGivenName,config){super(spec,"facet",parent,parentGivenName,config,spec.resolve);_defineProperty(this,"facet",void 0);_defineProperty(this,"child",void 0);_defineProperty(this,"children",void 0);this.child=buildModel(spec.spec,this,this.getName("child"),undefined,config);this.children=[this.child];this.facet=this.initFacet(spec.facet)}initFacet(facet){if(!isFacetMapping(facet)){return{facet:this.initFacetFieldDef(facet,"facet")}}const channels=keys(facet);const normalizedFacet={};for(const channel of channels){if(!contains([ROW,COLUMN],channel)){warn(incompatibleChannel(channel,"facet"));break}const fieldDef=facet[channel];if(fieldDef.field===undefined){warn(emptyFieldDef(fieldDef,channel));break}normalizedFacet[channel]=this.initFacetFieldDef(fieldDef,channel)}return normalizedFacet}initFacetFieldDef(fieldDef,channel){const{header:header,...rest}=fieldDef;const facetFieldDef=initFieldDef(rest,channel);if(header){facetFieldDef.header=replaceExprRefInIndex(header)}return facetFieldDef}channelHasField(channel){return!!this.facet[channel]}fieldDef(channel){return this.facet[channel]}parseData(){this.component.data=parseData(this);this.child.parseData()}parseLayoutSize(){parseChildrenLayoutSize(this)}parseSelections(){this.child.parseSelections();this.component.selection=this.child.component.selection}parseMarkGroup(){this.child.parseMarkGroup()}parseAxesAndHeaders(){this.child.parseAxesAndHeaders();parseFacetHeaders(this)}assembleSelectionTopLevelSignals(signals){return this.child.assembleSelectionTopLevelSignals(signals)}assembleSignals(){this.child.assembleSignals();return[]}assembleSelectionData(data){return this.child.assembleSelectionData(data)}getHeaderLayoutMixins(){const layoutMixins={};for(const channel of FACET_CHANNELS){for(const headerType of HEADER_TYPES){const layoutHeaderComponent=this.component.layoutHeaders[channel];const headerComponent=layoutHeaderComponent[headerType];const{facetFieldDef:facetFieldDef}=layoutHeaderComponent;if(facetFieldDef){const titleOrient=getHeaderProperty("titleOrient",facetFieldDef.header,this.config,channel);if(contains(["right","bottom"],titleOrient)){var _layoutMixins$titleAn;const headerChannel=getHeaderChannel(channel,titleOrient);layoutMixins.titleAnchor=(_layoutMixins$titleAn=layoutMixins.titleAnchor)!==null&&_layoutMixins$titleAn!==void 0?_layoutMixins$titleAn:{};layoutMixins.titleAnchor[headerChannel]="end"}}if(headerComponent===null||headerComponent===void 0?void 0:headerComponent[0]){const sizeType=channel==="row"?"height":"width";const bandType=headerType==="header"?"headerBand":"footerBand";if(channel!=="facet"&&!this.child.component.layoutSize.get(sizeType)){var _layoutMixins$bandTyp;layoutMixins[bandType]=(_layoutMixins$bandTyp=layoutMixins[bandType])!==null&&_layoutMixins$bandTyp!==void 0?_layoutMixins$bandTyp:{};layoutMixins[bandType][channel]=.5}if(layoutHeaderComponent.title){var _layoutMixins$offset;layoutMixins.offset=(_layoutMixins$offset=layoutMixins.offset)!==null&&_layoutMixins$offset!==void 0?_layoutMixins$offset:{};layoutMixins.offset[channel==="row"?"rowTitle":"columnTitle"]=10}}}}return layoutMixins}assembleDefaultLayout(){const{column:column,row:row}=this.facet;const columns=column?this.columnDistinctSignal():row?1:undefined;let align="all";if(!row&&this.component.resolve.scale.x==="independent"){align="none"}else if(!column&&this.component.resolve.scale.y==="independent"){align="none"}return{...this.getHeaderLayoutMixins(),...columns?{columns:columns}:{},bounds:"full",align:align}}assembleLayoutSignals(){return this.child.assembleLayoutSignals()}columnDistinctSignal(){if(this.parent&&this.parent instanceof FacetModel){return undefined}else{const facetLayoutDataName=this.getName("column_domain");return{signal:"length(data('".concat(facetLayoutDataName,"'))")}}}assembleGroup(signals){if(this.parent&&this.parent instanceof FacetModel){return{...this.channelHasField("column")?{encode:{update:{columns:{field:vgField(this.facet.column,{prefix:"distinct"})}}}}:{},...super.assembleGroup(signals)}}return super.assembleGroup(signals)}getCardinalityAggregateForChild(){const fields=[];const ops=[];const as=[];if(this.child instanceof FacetModel){if(this.child.channelHasField("column")){const field=vgField(this.child.facet.column);fields.push(field);ops.push("distinct");as.push("distinct_".concat(field))}}else{for(const channel of POSITION_SCALE_CHANNELS){const childScaleComponent=this.child.component.scales[channel];if(childScaleComponent&&!childScaleComponent.merged){const type=childScaleComponent.get("type");const range=childScaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const domain=assembleDomain(this.child,channel);const field=getFieldFromDomain(domain);if(field){fields.push(field);ops.push("distinct");as.push("distinct_".concat(field))}else{warn(unknownField(channel))}}}}}return{fields:fields,ops:ops,as:as}}assembleFacet(){const{name:name,data:data}=this.component.data.facetRoot;const{row:row,column:column}=this.facet;const{fields:fields,ops:ops,as:as}=this.getCardinalityAggregateForChild();const groupby=[];for(const channel of FACET_CHANNELS){const fieldDef=this.facet[channel];if(fieldDef){groupby.push(vgField(fieldDef));const{bin:bin,sort:sort}=fieldDef;if(isBinning(bin)){groupby.push(vgField(fieldDef,{binSuffix:"end"}))}if(isSortField(sort)){const{field:field,op:op=DEFAULT_SORT_OP}=sort;const outputName=facetSortFieldName(fieldDef,sort);if(row&&column){fields.push(outputName);ops.push("max");as.push(outputName)}else{fields.push(field);ops.push(op);as.push(outputName)}}else if(isArray(sort)){const outputName=sortArrayIndexField(fieldDef,channel);fields.push(outputName);ops.push("max");as.push(outputName)}}}const cross=!!row&&!!column;return{name:name,data:data,groupby:groupby,...cross||fields.length>0?{aggregate:{...cross?{cross:cross}:{},...fields.length?{fields:fields,ops:ops,as:as}:{}}}:{}}}facetSortFields(channel){const{facet:facet}=this;const fieldDef=facet[channel];if(fieldDef){if(isSortField(fieldDef.sort)){return[facetSortFieldName(fieldDef,fieldDef.sort,{expr:"datum"})]}else if(isArray(fieldDef.sort)){return[sortArrayIndexField(fieldDef,channel,{expr:"datum"})]}return[vgField(fieldDef,{expr:"datum"})]}return[]}facetSortOrder(channel){const{facet:facet}=this;const fieldDef=facet[channel];if(fieldDef){const{sort:sort}=fieldDef;const order=(isSortField(sort)?sort.order:!isArray(sort)&&sort)||"ascending";return[order]}return[]}assembleLabelTitle(){const{facet:facet,config:config}=this;if(facet.facet){return assembleLabelTitle(facet.facet,"facet",config)}const ORTHOGONAL_ORIENT={row:["top","bottom"],column:["left","right"]};for(const channel of HEADER_CHANNELS){if(facet[channel]){var _facet$channel;const labelOrient=getHeaderProperty("labelOrient",(_facet$channel=facet[channel])===null||_facet$channel===void 0?void 0:_facet$channel.header,config,channel);if(contains(ORTHOGONAL_ORIENT[channel],labelOrient)){return assembleLabelTitle(facet[channel],channel,config)}}}return undefined}assembleMarks(){const{child:child}=this;const facetRoot=this.component.data.facetRoot;const data=assembleFacetData(facetRoot);const encodeEntry=child.assembleGroupEncodeEntry(false);const title=this.assembleLabelTitle()||child.assembleTitle();const style=child.assembleGroupStyle();const markGroup={name:this.getName("cell"),type:"group",...title?{title:title}:{},...style?{style:style}:{},from:{facet:this.assembleFacet()},sort:{field:FACET_CHANNELS.map(c=>this.facetSortFields(c)).flat(),order:FACET_CHANNELS.map(c=>this.facetSortOrder(c)).flat()},...data.length>0?{data:data}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},...child.assembleGroup(assembleFacetSignals(this,[]))};return[markGroup]}getMapping(){return this.facet}}function makeJoinAggregateFromFacet(parent,facet){const{row:row,column:column}=facet;if(row&&column){let newParent=null;for(const fieldDef of[row,column]){if(isSortField(fieldDef.sort)){const{field:field,op:op=DEFAULT_SORT_OP}=fieldDef.sort;parent=newParent=new JoinAggregateTransformNode(parent,{joinaggregate:[{op:op,field:field,as:facetSortFieldName(fieldDef,fieldDef.sort,{forAs:true})}],groupby:[vgField(fieldDef)]})}}return newParent}return null}function findSource(data,sources){for(const other of sources){var _data$format,_otherData$format,_data$format2,_otherData$format2;const otherData=other.data;if(data.name&&other.hasName()&&data.name!==other.dataName){continue}const formatMesh=(_data$format=data["format"])===null||_data$format===void 0?void 0:_data$format.mesh;const otherFeature=(_otherData$format=otherData.format)===null||_otherData$format===void 0?void 0:_otherData$format.feature;if(formatMesh&&otherFeature){continue}const formatFeature=(_data$format2=data["format"])===null||_data$format2===void 0?void 0:_data$format2.feature;if((formatFeature||otherFeature)&&formatFeature!==otherFeature){continue}const otherMesh=(_otherData$format2=otherData.format)===null||_otherData$format2===void 0?void 0:_otherData$format2.mesh;if((formatMesh||otherMesh)&&formatMesh!==otherMesh){continue}if(isInlineData(data)&&isInlineData(otherData)){if(deepEqual(data.values,otherData.values)){return other}}else if(isUrlData(data)&&isUrlData(otherData)){if(data.url===otherData.url){return other}}else if(isNamedData(data)){if(data.name===other.dataName){return other}}}return null}function parseRoot(model,sources){if(model.data||!model.parent){if(model.data===null){const source=new SourceNode({values:[]});sources.push(source);return source}const existingSource=findSource(model.data,sources);if(existingSource){if(!isGenerator(model.data)){existingSource.data.format=mergeDeep({},model.data.format,existingSource.data.format)}if(!existingSource.hasName()&&model.data.name){existingSource.dataName=model.data.name}return existingSource}else{const source=new SourceNode(model.data);sources.push(source);return source}}else{return model.parent.component.data.facetRoot?model.parent.component.data.facetRoot:model.parent.component.data.main}}function parseTransformArray(head,model,ancestorParse){let lookupCounter=0;for(const t of model.transforms){let derivedType=undefined;let transformNode;if(isCalculate(t)){transformNode=head=new CalculateNode(head,t);derivedType="derived"}else if(isFilter(t)){var _ParseNode$makeWithAn;const implicit=getImplicitFromFilterTransform(t);transformNode=head=(_ParseNode$makeWithAn=ParseNode.makeWithAncestors(head,{},implicit,ancestorParse))!==null&&_ParseNode$makeWithAn!==void 0?_ParseNode$makeWithAn:head;head=new FilterNode(head,model,t.filter)}else if(isBin(t)){transformNode=head=BinNode.makeFromTransform(head,t,model);derivedType="number"}else if(isTimeUnit(t)){derivedType="date";const parsedAs=ancestorParse.getWithExplicit(t.field);if(parsedAs.value===undefined){head=new ParseNode(head,{[t.field]:derivedType});ancestorParse.set(t.field,derivedType,false)}transformNode=head=TimeUnitNode.makeFromTransform(head,t)}else if(isAggregate$1(t)){transformNode=head=AggregateNode.makeFromTransform(head,t);derivedType="number";if(requiresSelectionId(model)){head=new IdentifierNode(head)}}else if(isLookup(t)){transformNode=head=LookupNode.make(head,model,t,lookupCounter++);derivedType="derived"}else if(isWindow(t)){transformNode=head=new WindowTransformNode(head,t);derivedType="number"}else if(isJoinAggregate(t)){transformNode=head=new JoinAggregateTransformNode(head,t);derivedType="number"}else if(isStack(t)){transformNode=head=StackNode.makeFromTransform(head,t);derivedType="derived"}else if(isFold(t)){transformNode=head=new FoldTransformNode(head,t);derivedType="derived"}else if(isFlatten(t)){transformNode=head=new FlattenTransformNode(head,t);derivedType="derived"}else if(isPivot(t)){transformNode=head=new PivotTransformNode(head,t);derivedType="derived"}else if(isSample(t)){head=new SampleTransformNode(head,t)}else if(isImpute(t)){transformNode=head=ImputeNode.makeFromTransform(head,t);derivedType="derived"}else if(isDensity(t)){transformNode=head=new DensityTransformNode(head,t);derivedType="derived"}else if(isQuantile(t)){transformNode=head=new QuantileTransformNode(head,t);derivedType="derived"}else if(isRegression(t)){transformNode=head=new RegressionTransformNode(head,t);derivedType="derived"}else if(isLoess(t)){transformNode=head=new LoessTransformNode(head,t);derivedType="derived"}else{warn(invalidTransformIgnored(t));continue}if(transformNode&&derivedType!==undefined){for(const field of(_transformNode$produc=transformNode.producedFields())!==null&&_transformNode$produc!==void 0?_transformNode$produc:[]){var _transformNode$produc;ancestorParse.set(field,derivedType,false)}}}return head}function parseData(model){var _data$format3,_ParseNode$makeExplic,_ParseNode$makeWithAn2;let head=parseRoot(model,model.component.data.sources);const{outputNodes:outputNodes,outputNodeRefCounts:outputNodeRefCounts}=model.component.data;const ancestorParse=model.parent?model.parent.component.data.ancestorParse.clone():new AncestorParse;const data=model.data;if(isGenerator(data)){if(isSequenceGenerator(data)){head=new SequenceNode(head,data.sequence)}else if(isGraticuleGenerator(data)){head=new GraticuleNode(head,data.graticule)}ancestorParse.parseNothing=true}else if((data===null||data===void 0?void 0:(_data$format3=data.format)===null||_data$format3===void 0?void 0:_data$format3.parse)===null){ancestorParse.parseNothing=true}head=(_ParseNode$makeExplic=ParseNode.makeExplicit(head,model,ancestorParse))!==null&&_ParseNode$makeExplic!==void 0?_ParseNode$makeExplic:head;head=new IdentifierNode(head);const parentIsLayer=model.parent&&isLayerModel(model.parent);if(isUnitModel(model)||isFacetModel(model)){if(parentIsLayer){var _BinNode$makeFromEnco;head=(_BinNode$makeFromEnco=BinNode.makeFromEncoding(head,model))!==null&&_BinNode$makeFromEnco!==void 0?_BinNode$makeFromEnco:head}}if(model.transforms.length>0){head=parseTransformArray(head,model,ancestorParse)}const implicitSelection=getImplicitFromSelection(model);const implicitEncoding=getImplicitFromEncoding(model);head=(_ParseNode$makeWithAn2=ParseNode.makeWithAncestors(head,{},{...implicitSelection,...implicitEncoding},ancestorParse))!==null&&_ParseNode$makeWithAn2!==void 0?_ParseNode$makeWithAn2:head;if(isUnitModel(model)){head=GeoJSONNode.parseAll(head,model);head=GeoPointNode.parseAll(head,model)}if(isUnitModel(model)||isFacetModel(model)){var _TimeUnitNode$makeFro;if(!parentIsLayer){var _BinNode$makeFromEnco2;head=(_BinNode$makeFromEnco2=BinNode.makeFromEncoding(head,model))!==null&&_BinNode$makeFromEnco2!==void 0?_BinNode$makeFromEnco2:head}head=(_TimeUnitNode$makeFro=TimeUnitNode.makeFromEncoding(head,model))!==null&&_TimeUnitNode$makeFro!==void 0?_TimeUnitNode$makeFro:head;head=CalculateNode.parseAllForSortIndex(head,model)}const rawName=model.getDataName(DataSourceType.Raw);const raw=new OutputNode(head,rawName,DataSourceType.Raw,outputNodeRefCounts);outputNodes[rawName]=raw;head=raw;if(isUnitModel(model)){var _ImputeNode$makeFromE,_StackNode$makeFromEn;const agg=AggregateNode.makeFromEncoding(head,model);if(agg){head=agg;if(requiresSelectionId(model)){head=new IdentifierNode(head)}}head=(_ImputeNode$makeFromE=ImputeNode.makeFromEncoding(head,model))!==null&&_ImputeNode$makeFromE!==void 0?_ImputeNode$makeFromE:head;head=(_StackNode$makeFromEn=StackNode.makeFromEncoding(head,model))!==null&&_StackNode$makeFromEn!==void 0?_StackNode$makeFromEn:head}if(isUnitModel(model)){var _FilterInvalidNode$ma;head=(_FilterInvalidNode$ma=FilterInvalidNode.make(head,model))!==null&&_FilterInvalidNode$ma!==void 0?_FilterInvalidNode$ma:head}const mainName=model.getDataName(DataSourceType.Main);const main=new OutputNode(head,mainName,DataSourceType.Main,outputNodeRefCounts);outputNodes[mainName]=main;head=main;if(isUnitModel(model)){materializeSelections(model,main)}let facetRoot=null;if(isFacetModel(model)){var _makeJoinAggregateFro;const facetName=model.getName("facet");head=(_makeJoinAggregateFro=makeJoinAggregateFromFacet(head,model.facet))!==null&&_makeJoinAggregateFro!==void 0?_makeJoinAggregateFro:head;facetRoot=new FacetNode(head,model,facetName,main.getSource());outputNodes[facetName]=facetRoot}return{...model.component.data,outputNodes:outputNodes,outputNodeRefCounts:outputNodeRefCounts,raw:raw,main:main,facetRoot:facetRoot,ancestorParse:ancestorParse}}class ConcatModel extends Model{constructor(spec,parent,parentGivenName,config){var _spec$resolve,_spec$resolve$axis,_spec$resolve2,_spec$resolve2$axis;super(spec,"concat",parent,parentGivenName,config,spec.resolve);_defineProperty(this,"children",void 0);if(((_spec$resolve=spec.resolve)===null||_spec$resolve===void 0?void 0:(_spec$resolve$axis=_spec$resolve.axis)===null||_spec$resolve$axis===void 0?void 0:_spec$resolve$axis.x)==="shared"||((_spec$resolve2=spec.resolve)===null||_spec$resolve2===void 0?void 0:(_spec$resolve2$axis=_spec$resolve2.axis)===null||_spec$resolve2$axis===void 0?void 0:_spec$resolve2$axis.y)==="shared"){warn(CONCAT_CANNOT_SHARE_AXIS)}this.children=this.getChildren(spec).map((child,i)=>buildModel(child,this,this.getName("concat_"+i),undefined,config))}parseData(){this.component.data=parseData(this);for(const child of this.children){child.parseData()}}parseSelections(){this.component.selection={};for(const child of this.children){child.parseSelections();for(const key of keys(child.component.selection)){this.component.selection[key]=child.component.selection[key]}}}parseMarkGroup(){for(const child of this.children){child.parseMarkGroup()}}parseAxesAndHeaders(){for(const child of this.children){child.parseAxesAndHeaders()}}getChildren(spec){if(isVConcatSpec(spec)){return spec.vconcat}else if(isHConcatSpec(spec)){return spec.hconcat}return spec.concat}parseLayoutSize(){parseConcatLayoutSize(this)}parseAxisGroup(){return null}assembleSelectionTopLevelSignals(signals){return this.children.reduce((sg,child)=>child.assembleSelectionTopLevelSignals(sg),signals)}assembleSignals(){this.children.forEach(child=>child.assembleSignals());return[]}assembleLayoutSignals(){const layoutSignals=assembleLayoutSignals(this);for(const child of this.children){layoutSignals.push(...child.assembleLayoutSignals())}return layoutSignals}assembleSelectionData(data){return this.children.reduce((db,child)=>child.assembleSelectionData(db),data)}assembleMarks(){return this.children.map(child=>{const title=child.assembleTitle();const style=child.assembleGroupStyle();const encodeEntry=child.assembleGroupEncodeEntry(false);return{type:"group",name:child.getName("group"),...title?{title:title}:{},...style?{style:style}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},...child.assembleGroup()}})}assembleDefaultLayout(){const columns=this.layout.columns;return{...columns!=null?{columns:columns}:{},bounds:"full",align:"each"}}}function isFalseOrNull(v){return v===false||v===null}const AXIS_COMPONENT_PROPERTIES_INDEX={disable:1,gridScale:1,scale:1,...COMMON_AXIS_PROPERTIES_INDEX,labelExpr:1,encode:1};const AXIS_COMPONENT_PROPERTIES=keys(AXIS_COMPONENT_PROPERTIES_INDEX);class AxisComponent extends Split{constructor(explicit={},implicit={},mainExtracted=false){super();this.explicit=explicit;this.implicit=implicit;this.mainExtracted=mainExtracted}clone(){return new AxisComponent(duplicate(this.explicit),duplicate(this.implicit),this.mainExtracted)}hasAxisPart(part){if(part==="axis"){return true}if(part==="grid"||part==="title"){return!!this.get(part)}return!isFalseOrNull(this.get(part))}hasOrientSignalRef(){return isSignalRef(this.explicit.orient)}}function labels$1(model,channel,specifiedLabelsSpec){var _getFieldOrDatumDef;const{encoding:encoding,config:config}=model;const fieldOrDatumDef=(_getFieldOrDatumDef=getFieldOrDatumDef(encoding[channel]))!==null&&_getFieldOrDatumDef!==void 0?_getFieldOrDatumDef:getFieldOrDatumDef(encoding[getSecondaryRangeChannel(channel)]);const axis=model.axis(channel)||{};const{format:format,formatType:formatType}=axis;if(isCustomFormatType(formatType)){return{text:formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:format,formatType:formatType,config:config}),...specifiedLabelsSpec}}return specifiedLabelsSpec}function parseUnitAxes(model){return POSITION_SCALE_CHANNELS.reduce((axis,channel)=>{if(model.component.scales[channel]){axis[channel]=[parseAxis(channel,model)]}return axis},{})}const OPPOSITE_ORIENT={bottom:"top",top:"bottom",left:"right",right:"left"};function parseLayerAxes(model){const{axes:axes,resolve:resolve}=model.component;const axisCount={top:0,bottom:0,right:0,left:0};for(const child of model.children){child.parseAxesAndHeaders();for(const channel of keys(child.component.axes)){resolve.axis[channel]=parseGuideResolve(model.component.resolve,channel);if(resolve.axis[channel]==="shared"){axes[channel]=mergeAxisComponents(axes[channel],child.component.axes[channel]);if(!axes[channel]){resolve.axis[channel]="independent";delete axes[channel]}}}}for(const channel of POSITION_SCALE_CHANNELS){for(const child of model.children){if(!child.component.axes[channel]){continue}if(resolve.axis[channel]==="independent"){var _axes$channel;axes[channel]=((_axes$channel=axes[channel])!==null&&_axes$channel!==void 0?_axes$channel:[]).concat(child.component.axes[channel]);for(const axisComponent of child.component.axes[channel]){const{value:orient,explicit:explicit}=axisComponent.getWithExplicit("orient");if(isSignalRef(orient)){continue}if(axisCount[orient]>0&&!explicit){const oppositeOrient=OPPOSITE_ORIENT[orient];if(axisCount[orient]>axisCount[oppositeOrient]){axisComponent.set("orient",oppositeOrient,false)}}axisCount[orient]++}}delete child.component.axes[channel]}if(resolve.axis[channel]==="independent"&&axes[channel]&&axes[channel].length>1){for(const axisCmpt of axes[channel]){if(!!axisCmpt.get("grid")&&!axisCmpt.explicit.grid){axisCmpt.implicit.grid=false}}}}}function mergeAxisComponents(mergedAxisCmpts,childAxisCmpts){if(mergedAxisCmpts){if(mergedAxisCmpts.length!==childAxisCmpts.length){return undefined}const length=mergedAxisCmpts.length;for(let i=0;i<length;i++){const merged=mergedAxisCmpts[i];const child=childAxisCmpts[i];if(!!merged!==!!child){return undefined}else if(merged&&child){const mergedOrient=merged.getWithExplicit("orient");const childOrient=child.getWithExplicit("orient");if(mergedOrient.explicit&&childOrient.explicit&&mergedOrient.value!==childOrient.value){return undefined}else{mergedAxisCmpts[i]=mergeAxisComponent(merged,child)}}}}else{return childAxisCmpts.map(axisComponent=>axisComponent.clone())}return mergedAxisCmpts}function mergeAxisComponent(merged,child){for(const prop of AXIS_COMPONENT_PROPERTIES){const mergedValueWithExplicit=mergeValuesWithExplicit(merged.getWithExplicit(prop),child.getWithExplicit(prop),prop,"axis",(v1,v2)=>{switch(prop){case"title":return mergeTitleComponent(v1,v2);case"gridScale":return{explicit:v1.explicit,value:getFirstDefined(v1.value,v2.value)}}return defaultTieBreaker(v1,v2,prop,"axis")});merged.setWithExplicit(prop,mergedValueWithExplicit)}return merged}function isExplicit$1(value,property,axis,model,channel){if(property==="disable"){return axis!==undefined}axis=axis||{};switch(property){case"titleAngle":case"labelAngle":return value===(isSignalRef(axis.labelAngle)?axis.labelAngle:normalizeAngle(axis.labelAngle));case"values":return!!axis.values;case"encode":return!!axis.encoding||!!axis.labelAngle;case"title":if(value===getFieldDefTitle(model,channel)){return true}}return value===axis[property]}const propsToAlwaysIncludeConfig=new Set(["grid","translate","format","formatType","orient","labelExpr","tickCount","position","tickMinStep"]);function parseAxis(channel,model){var _axis,_config,_config$axis,_axis2,_axis$encoding;let axis=model.axis(channel);const axisComponent=new AxisComponent;const fieldOrDatumDef=getFieldOrDatumDef(model.encoding[channel]);const{mark:mark,config:config}=model;const orient=((_axis=axis)===null||_axis===void 0?void 0:_axis.orient)||((_config=config[channel==="x"?"axisX":"axisY"])===null||_config===void 0?void 0:_config.orient)||((_config$axis=config.axis)===null||_config$axis===void 0?void 0:_config$axis.orient)||defaultOrient(channel);const scaleType=model.getScaleComponent(channel).get("type");const axisConfigs=getAxisConfigs(channel,scaleType,orient,model.config);const disable=axis!==undefined?!axis:getAxisConfig("disable",config.style,(_axis2=axis)===null||_axis2===void 0?void 0:_axis2.style,axisConfigs).configValue;axisComponent.set("disable",disable,axis!==undefined);if(disable){return axisComponent}axis=axis||{};const labelAngle=getLabelAngle(fieldOrDatumDef,axis,channel,config.style,axisConfigs);const ruleParams={fieldOrDatumDef:fieldOrDatumDef,axis:axis,channel:channel,model:model,scaleType:scaleType,orient:orient,labelAngle:labelAngle,mark:mark,config:config};for(const property of AXIS_COMPONENT_PROPERTIES){const value=property in axisRules?axisRules[property](ruleParams):isAxisProperty(property)?axis[property]:undefined;const hasValue=value!==undefined;const explicit=isExplicit$1(value,property,axis,model,channel);if(hasValue&&explicit){axisComponent.set(property,value,explicit)}else{const{configValue:configValue=undefined,configFrom:configFrom=undefined}=isAxisProperty(property)&&property!=="values"?getAxisConfig(property,config.style,axis.style,axisConfigs):{};const hasConfigValue=configValue!==undefined;if(hasValue&&!hasConfigValue){axisComponent.set(property,value,explicit)}else if(!(configFrom==="vgAxisConfig")||propsToAlwaysIncludeConfig.has(property)&&hasConfigValue||isConditionalAxisValue(configValue)||isSignalRef(configValue)){axisComponent.set(property,configValue,false)}}}const axisEncoding=(_axis$encoding=axis.encoding)!==null&&_axis$encoding!==void 0?_axis$encoding:{};const axisEncode=AXIS_PARTS.reduce((e,part)=>{var _axisEncoding$part;if(!axisComponent.hasAxisPart(part)){return e}const axisEncodingPart=guideEncodeEntry((_axisEncoding$part=axisEncoding[part])!==null&&_axisEncoding$part!==void 0?_axisEncoding$part:{},model);const value=part==="labels"?labels$1(model,channel,axisEncodingPart):axisEncodingPart;if(value!==undefined&&!isEmpty(value)){e[part]={update:value}}return e},{});if(!isEmpty(axisEncode)){axisComponent.set("encode",axisEncode,!!axis.encoding||axis.labelAngle!==undefined)}return axisComponent}function initLayoutSize({encoding:encoding,size:size}){for(const channel of POSITION_SCALE_CHANNELS){const sizeType=getSizeChannel(channel);if(isStep(size[sizeType])){if(isContinuousFieldOrDatumDef(encoding[channel])){delete size[sizeType];warn(stepDropped(sizeType))}}}return size}function initMarkdef(originalMarkDef,encoding,config){const markDef=replaceExprRefInIndex(originalMarkDef);const specifiedOrient=getMarkPropOrConfig("orient",markDef,config);markDef.orient=orient(markDef.type,encoding,specifiedOrient);if(specifiedOrient!==undefined&&specifiedOrient!==markDef.orient){warn(orientOverridden(markDef.orient,specifiedOrient))}if(markDef.type==="bar"&&markDef.orient){const cornerRadiusEnd=getMarkPropOrConfig("cornerRadiusEnd",markDef,config);if(cornerRadiusEnd!==undefined){const newProps=markDef.orient==="horizontal"&&encoding.x2||markDef.orient==="vertical"&&encoding.y2?["cornerRadius"]:BAR_CORNER_RADIUS_INDEX[markDef.orient];for(const newProp of newProps){markDef[newProp]=cornerRadiusEnd}if(markDef.cornerRadiusEnd!==undefined){delete markDef.cornerRadiusEnd}}}const specifiedOpacity=getMarkPropOrConfig("opacity",markDef,config);if(specifiedOpacity===undefined){markDef.opacity=opacity(markDef.type,encoding)}const specifiedCursor=getMarkPropOrConfig("cursor",markDef,config);if(specifiedCursor===undefined){markDef.cursor=cursor(markDef,encoding,config)}return markDef}function cursor(markDef,encoding,config){if(encoding.href||markDef.href||getMarkPropOrConfig("href",markDef,config)){return"pointer"}return markDef.cursor}function opacity(mark,encoding){if(contains([POINT,TICK,CIRCLE,SQUARE],mark)){if(!isAggregate(encoding)){return.7}}return undefined}function defaultFilled(markDef,config,{graticule:graticule}){if(graticule){return false}const filledConfig=getMarkConfig("filled",markDef,config);const mark=markDef.type;return getFirstDefined(filledConfig,mark!==POINT&&mark!==LINE&&mark!==RULE)}function orient(mark,encoding,specifiedOrient){switch(mark){case POINT:case CIRCLE:case SQUARE:case TEXT$1:case RECT:case IMAGE:return undefined}const{x:x,y:y,x2:x2,y2:y2}=encoding;switch(mark){case BAR:if(isFieldDef(x)&&(isBinned(x.bin)||isFieldDef(y)&&y.aggregate&&!x.aggregate)){return"vertical"}if(isFieldDef(y)&&(isBinned(y.bin)||isFieldDef(x)&&x.aggregate&&!y.aggregate)){return"horizontal"}if(y2||x2){if(specifiedOrient){return specifiedOrient}if(!x2){if(isFieldDef(x)&&x.type===QUANTITATIVE&&!isBinning(x.bin)||isNumericDataDef(x)){return"horizontal"}}if(!y2){if(isFieldDef(y)&&y.type===QUANTITATIVE&&!isBinning(y.bin)||isNumericDataDef(y)){return"vertical"}}}case RULE:if(x2&&!(isFieldDef(x)&&isBinned(x.bin))&&y2&&!(isFieldDef(y)&&isBinned(y.bin))){return undefined}case AREA:if(y2){if(isFieldDef(y)&&isBinned(y.bin)){return"horizontal"}else{return"vertical"}}else if(x2){if(isFieldDef(x)&&isBinned(x.bin)){return"vertical"}else{return"horizontal"}}else if(mark===RULE){if(x&&!y){return"vertical"}else if(y&&!x){return"horizontal"}}case LINE:case TICK:{const xIsContinuous=isContinuousFieldOrDatumDef(x);const yIsContinuous=isContinuousFieldOrDatumDef(y);if(xIsContinuous&&!yIsContinuous){return mark!=="tick"?"horizontal":"vertical"}else if(!xIsContinuous&&yIsContinuous){return mark!=="tick"?"vertical":"horizontal"}else if(xIsContinuous&&yIsContinuous){const xDef=x;const yDef=y;const xIsTemporal=xDef.type===TEMPORAL;const yIsTemporal=yDef.type===TEMPORAL;if(xIsTemporal&&!yIsTemporal){return mark!=="tick"?"vertical":"horizontal"}else if(!xIsTemporal&&yIsTemporal){return mark!=="tick"?"horizontal":"vertical"}if(!xDef.aggregate&&yDef.aggregate){return mark!=="tick"?"vertical":"horizontal"}else if(xDef.aggregate&&!yDef.aggregate){return mark!=="tick"?"horizontal":"vertical"}if(specifiedOrient){return specifiedOrient}return"vertical"}else{if(specifiedOrient){return specifiedOrient}return undefined}}}return"vertical"}const arc={vgMark:"arc",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...rectPosition(model,"radius","arc"),...rectPosition(model,"theta","arc")})};const area={vgMark:"area",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"include",size:"ignore",theta:"ignore"}),...pointOrRangePosition("x",model,{defaultPos:"zeroOrMin",defaultPos2:"zeroOrMin",range:model.markDef.orient==="horizontal"}),...pointOrRangePosition("y",model,{defaultPos:"zeroOrMin",defaultPos2:"zeroOrMin",range:model.markDef.orient==="vertical"}),...defined(model)})};const bar={vgMark:"rect",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x","bar"),...rectPosition(model,"y","bar")})};const geoshape={vgMark:"shape",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"})}),postEncodingTransform:model=>{const{encoding:encoding}=model;const shapeDef=encoding.shape;const transform={type:"geoshape",projection:model.projectionName(),...shapeDef&&isFieldDef(shapeDef)&&shapeDef.type===GEOJSON?{field:vgField(shapeDef,{expr:"datum"})}:{}};return[transform]}};const image={vgMark:"image",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"ignore",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x","image"),...rectPosition(model,"y","image"),...text(model,"url")})};const line={vgMark:"line",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model,{vgChannel:"strokeWidth"}),...defined(model)})};const trail={vgMark:"trail",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"include",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model),...defined(model)})};function encodeEntry(model,fixedShape){const{config:config}=model;return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"include",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model),...nonPosition("angle",model),...shapeMixins(model,config,fixedShape)}}function shapeMixins(model,config,fixedShape){if(fixedShape){return{shape:{value:fixedShape}}}return nonPosition("shape",model)}const point={vgMark:"symbol",encodeEntry:model=>encodeEntry(model)};const circle={vgMark:"symbol",encodeEntry:model=>encodeEntry(model,"circle")};const square={vgMark:"symbol",encodeEntry:model=>encodeEntry(model,"square")};const rect={vgMark:"rect",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x","rect"),...rectPosition(model,"y","rect")})};const rule={vgMark:"rule",encodeEntry:model=>{const{markDef:markDef}=model;const orient=markDef.orient;if(!model.encoding.x&&!model.encoding.y&&!model.encoding.latitude&&!model.encoding.longitude){return{}}return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...pointOrRangePosition("x",model,{defaultPos:orient==="horizontal"?"zeroOrMax":"mid",defaultPos2:"zeroOrMin",range:orient!=="vertical"}),...pointOrRangePosition("y",model,{defaultPos:orient==="vertical"?"zeroOrMax":"mid",defaultPos2:"zeroOrMin",range:orient!=="horizontal"}),...nonPosition("size",model,{vgChannel:"strokeWidth"})}}};const text$1={vgMark:"text",encodeEntry:model=>{const{config:config,encoding:encoding}=model;return{...baseEncodeEntry(model,{align:"include",baseline:"include",color:"include",size:"ignore",orient:"ignore",theta:"include"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...text(model),...nonPosition("size",model,{vgChannel:"fontSize"}),...nonPosition("angle",model),...valueIfDefined("align",align(model.markDef,encoding,config)),...valueIfDefined("baseline",baseline(model.markDef,encoding,config)),...pointPosition("radius",model,{defaultPos:null,isMidPoint:true}),...pointPosition("theta",model,{defaultPos:null,isMidPoint:true})}}};function align(markDef,encoding,config){const a=getMarkPropOrConfig("align",markDef,config);if(a===undefined){return"center"}return undefined}function baseline(markDef,encoding,config){const b=getMarkPropOrConfig("baseline",markDef,config);if(b===undefined){return"middle"}return undefined}const tick={vgMark:"rect",encodeEntry:model=>{const{config:config,markDef:markDef}=model;const orient=markDef.orient;const vgSizeChannel=orient==="horizontal"?"width":"height";const vgThicknessChannel=orient==="horizontal"?"height":"width";return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid",vgChannel:"xc"}),...pointPosition("y",model,{defaultPos:"mid",vgChannel:"yc"}),...nonPosition("size",model,{defaultValue:defaultSize(model),vgChannel:vgSizeChannel}),[vgThicknessChannel]:signalOrValueRef(getMarkPropOrConfig("thickness",markDef,config))}}};function defaultSize(model){var _getMarkPropOrConfig;const{config:config,markDef:markDef}=model;const{orient:orient}=markDef;const vgSizeChannel=orient==="horizontal"?"width":"height";const scale=model.getScaleComponent(orient==="horizontal"?"x":"y");const markPropOrConfig=(_getMarkPropOrConfig=getMarkPropOrConfig("size",markDef,config,{vgChannel:vgSizeChannel}))!==null&&_getMarkPropOrConfig!==void 0?_getMarkPropOrConfig:config.tick.bandSize;if(markPropOrConfig!==undefined){return markPropOrConfig}else{const scaleRange=scale?scale.get("range"):undefined;if(scaleRange&&isVgRangeStep(scaleRange)&&isNumber(scaleRange.step)){return scaleRange.step*3/4}const defaultViewStep=getViewConfigDiscreteStep(config.view,vgSizeChannel);return defaultViewStep*3/4}}const markCompiler={arc:arc,area:area,bar:bar,circle:circle,geoshape:geoshape,image:image,line:line,point:point,rect:rect,rule:rule,square:square,text:text$1,tick:tick,trail:trail};function parseMarkGroups(model){if(contains([LINE,AREA,TRAIL],model.mark)){const details=pathGroupingFields(model.mark,model.encoding);if(details.length>0){return getPathGroups(model,details)}}else if(contains([BAR],model.mark)){const hasCornerRadius=VG_CORNERRADIUS_CHANNELS.some(prop=>getMarkPropOrConfig(prop,model.markDef,model.config));if(model.stack&&!model.fieldDef("size")&&hasCornerRadius){return getGroupsForStackedBarWithCornerRadius(model)}}return getMarkGroup(model)}const FACETED_PATH_PREFIX="faceted_path_";function getPathGroups(model,details){return[{name:model.getName("pathgroup"),type:"group",from:{facet:{name:FACETED_PATH_PREFIX+model.requestDataName(DataSourceType.Main),data:model.requestDataName(DataSourceType.Main),groupby:details}},encode:{update:{width:{field:{group:"width"}},height:{field:{group:"height"}}}},marks:getMarkGroup(model,{fromPrefix:FACETED_PATH_PREFIX})}]}const STACK_GROUP_PREFIX="stack_group_";function getGroupsForStackedBarWithCornerRadius(model){const[mark]=getMarkGroup(model,{fromPrefix:STACK_GROUP_PREFIX});const fieldScale=model.scaleName(model.stack.fieldChannel);const stackField=(opt={})=>model.vgField(model.stack.fieldChannel,opt);const stackFieldGroup=(func,expr)=>{const vgFieldMinMax=[stackField({prefix:"min",suffix:"start",expr:expr}),stackField({prefix:"max",suffix:"start",expr:expr}),stackField({prefix:"min",suffix:"end",expr:expr}),stackField({prefix:"max",suffix:"end",expr:expr})];return"".concat(func,"(").concat(vgFieldMinMax.map(field=>"scale('".concat(fieldScale,"',").concat(field,")")).join(","),")")};let groupUpdate;let innerGroupUpdate;if(model.stack.fieldChannel==="x"){groupUpdate={...pick(mark.encode.update,["y","yc","y2","height",...VG_CORNERRADIUS_CHANNELS]),x:{signal:stackFieldGroup("min","datum")},x2:{signal:stackFieldGroup("max","datum")},clip:{value:true}};innerGroupUpdate={x:{field:{group:"x"},mult:-1},height:{field:{group:"height"}}};mark.encode.update={...omit(mark.encode.update,["y","yc","y2"]),height:{field:{group:"height"}}}}else{groupUpdate={...pick(mark.encode.update,["x","xc","x2","width"]),y:{signal:stackFieldGroup("min","datum")},y2:{signal:stackFieldGroup("max","datum")},clip:{value:true}};innerGroupUpdate={y:{field:{group:"y"},mult:-1},width:{field:{group:"width"}}};mark.encode.update={...omit(mark.encode.update,["x","xc","x2"]),width:{field:{group:"width"}}}}for(const key of VG_CORNERRADIUS_CHANNELS){const configValue=getMarkConfig(key,model.markDef,model.config);if(mark.encode.update[key]){groupUpdate[key]=mark.encode.update[key];delete mark.encode.update[key]}else if(configValue){groupUpdate[key]=signalOrValueRef(configValue)}if(configValue){mark.encode.update[key]={value:0}}}const groupByField=model.fieldDef(model.stack.groupbyChannel);const groupby=vgField(groupByField)?[vgField(groupByField)]:[];if((groupByField===null||groupByField===void 0?void 0:groupByField.bin)||(groupByField===null||groupByField===void 0?void 0:groupByField.timeUnit)){groupby.push(vgField(groupByField,{binSuffix:"end"}))}const strokeProperties=["stroke","strokeWidth","strokeJoin","strokeCap","strokeDash","strokeDashOffset","strokeMiterLimit","strokeOpacity"];groupUpdate=strokeProperties.reduce((encode,prop)=>{if(mark.encode.update[prop]){return{...encode,[prop]:mark.encode.update[prop]}}else{const configValue=getMarkConfig(prop,model.markDef,model.config);if(configValue!==undefined){return{...encode,[prop]:signalOrValueRef(configValue)}}else{return encode}}},groupUpdate);if(groupUpdate.stroke){groupUpdate.strokeForeground={value:true};groupUpdate.strokeOffset={value:0}}return[{type:"group",from:{facet:{data:model.requestDataName(DataSourceType.Main),name:STACK_GROUP_PREFIX+model.requestDataName(DataSourceType.Main),groupby:groupby,aggregate:{fields:[stackField({suffix:"start"}),stackField({suffix:"start"}),stackField({suffix:"end"}),stackField({suffix:"end"})],ops:["min","max","min","max"]}}},encode:{update:groupUpdate},marks:[{type:"group",encode:{update:innerGroupUpdate},marks:[mark]}]}]}function getSort$1(model){const{encoding:encoding,stack:stack,mark:mark,markDef:markDef,config:config}=model;const order=encoding.order;if(!isArray(order)&&isValueDef(order)&&isNullOrFalse(order.value)||!order&&isNullOrFalse(getMarkPropOrConfig("order",markDef,config))){return undefined}else if((isArray(order)||isFieldDef(order))&&!stack){return sortParams(order,{expr:"datum"})}else if(isPathMark(mark)){const dimensionChannel=markDef.orient==="horizontal"?"y":"x";const dimensionChannelDef=encoding[dimensionChannel];if(isFieldDef(dimensionChannelDef)){const s=dimensionChannelDef.sort;if(isArray(s)){return{field:vgField(dimensionChannelDef,{prefix:dimensionChannel,suffix:"sort_index",expr:"datum"})}}else if(isSortField(s)){return{field:vgField({aggregate:isAggregate(model.encoding)?s.op:undefined,field:s.field},{expr:"datum"})}}else if(isSortByEncoding(s)){const fieldDefToSort=model.fieldDef(s.encoding);return{field:vgField(fieldDefToSort,{expr:"datum"}),order:s.order}}else if(s===null){return undefined}else{return{field:vgField(dimensionChannelDef,{binSuffix:model.stack&&model.stack.impute?"mid":undefined,expr:"datum"})}}}return undefined}return undefined}function getMarkGroup(model,opt={fromPrefix:""}){const{mark:mark,markDef:markDef,encoding:encoding,config:config}=model;const clip=getFirstDefined(markDef.clip,scaleClip(model),projectionClip(model));const style=getStyles(markDef);const key=encoding.key;const sort=getSort$1(model);const interactive=interactiveFlag(model);const aria=getMarkPropOrConfig("aria",markDef,config);const postEncodingTransform=markCompiler[mark].postEncodingTransform?markCompiler[mark].postEncodingTransform(model):null;return[{name:model.getName("marks"),type:markCompiler[mark].vgMark,...clip?{clip:true}:{},...style?{style:style}:{},...key?{key:key.field}:{},...sort?{sort:sort}:{},...interactive?interactive:{},...aria===false?{aria:aria}:{},from:{data:opt.fromPrefix+model.requestDataName(DataSourceType.Main)},encode:{update:markCompiler[mark].encodeEntry(model)},...postEncodingTransform?{transform:postEncodingTransform}:{}}]}function scaleClip(model){const xScale=model.getScaleComponent("x");const yScale=model.getScaleComponent("y");return xScale&&xScale.get("selectionExtent")||yScale&&yScale.get("selectionExtent")?true:undefined}function projectionClip(model){const projection=model.component.projection;return projection&&!projection.isFit?true:undefined}function interactiveFlag(model){if(!model.component.selection)return null;const unitCount=keys(model.component.selection).length;let parentCount=unitCount;let parent=model.parent;while(parent&&parentCount===0){parentCount=keys(parent.component.selection).length;parent=parent.parent}return parentCount?{interactive:unitCount>0||!!model.encoding.tooltip}:null}class UnitModel extends ModelWithField{constructor(spec,parent,parentGivenName,parentGivenSize={},config){super(spec,"unit",parent,parentGivenName,config,undefined,isFrameMixins(spec)?spec.view:undefined);_defineProperty(this,"markDef",void 0);_defineProperty(this,"encoding",void 0);_defineProperty(this,"specifiedScales",{});_defineProperty(this,"stack",void 0);_defineProperty(this,"specifiedAxes",{});_defineProperty(this,"specifiedLegends",{});_defineProperty(this,"specifiedProjection",{});_defineProperty(this,"selection",{});_defineProperty(this,"children",[]);const markDef=isMarkDef(spec.mark)?{...spec.mark}:{type:spec.mark};const mark=markDef.type;if(markDef.filled===undefined){markDef.filled=defaultFilled(markDef,config,{graticule:spec.data&&isGraticuleGenerator(spec.data)})}const encoding=this.encoding=initEncoding(spec.encoding||{},mark,markDef.filled,config);this.markDef=initMarkdef(markDef,encoding,config);this.size=initLayoutSize({encoding:encoding,size:isFrameMixins(spec)?{...parentGivenSize,...spec.width?{width:spec.width}:{},...spec.height?{height:spec.height}:{}}:parentGivenSize});this.stack=stack(mark,encoding);this.specifiedScales=this.initScales(mark,encoding);this.specifiedAxes=this.initAxes(encoding);this.specifiedLegends=this.initLegends(encoding);this.specifiedProjection=spec.projection;this.selection=spec.selection}get hasProjection(){const{encoding:encoding}=this;const isGeoShapeMark=this.mark===GEOSHAPE;const hasGeoPosition=encoding&&GEOPOSITION_CHANNELS.some(channel=>isFieldOrDatumDef(encoding[channel]));return isGeoShapeMark||hasGeoPosition}scaleDomain(channel){const scale=this.specifiedScales[channel];return scale?scale.domain:undefined}axis(channel){return this.specifiedAxes[channel]}legend(channel){return this.specifiedLegends[channel]}initScales(mark,encoding){return SCALE_CHANNELS.reduce((scales,channel)=>{const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef){var _fieldOrDatumDef$scal;scales[channel]=this.initScale((_fieldOrDatumDef$scal=fieldOrDatumDef.scale)!==null&&_fieldOrDatumDef$scal!==void 0?_fieldOrDatumDef$scal:{})}return scales},{})}initScale(scale){const{domain:domain,range:range}=scale;const scaleInternal=replaceExprRefInIndex(scale);if(isArray(domain)){scaleInternal.domain=domain.map(signalRefOrValue)}if(isArray(range)){scaleInternal.range=range.map(signalRefOrValue)}return scaleInternal}initAxes(encoding){return POSITION_SCALE_CHANNELS.reduce((_axis,channel)=>{const channelDef=encoding[channel];if(isFieldOrDatumDef(channelDef)||channel===X&&isFieldOrDatumDef(encoding.x2)||channel===Y&&isFieldOrDatumDef(encoding.y2)){const axisSpec=isFieldOrDatumDef(channelDef)?channelDef.axis:undefined;_axis[channel]=axisSpec?this.initAxis({...axisSpec}):axisSpec}return _axis},{})}initAxis(axis){const props=keys(axis);const axisInternal={};for(const prop of props){const val=axis[prop];axisInternal[prop]=isConditionalAxisValue(val)?signalOrValueRefWithCondition(val):signalRefOrValue(val)}return axisInternal}initLegends(encoding){return NONPOSITION_SCALE_CHANNELS.reduce((_legend,channel)=>{const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef&&supportLegend(channel)){const legend=fieldOrDatumDef.legend;_legend[channel]=legend?replaceExprRefInIndex(legend):legend}return _legend},{})}parseData(){this.component.data=parseData(this)}parseLayoutSize(){parseUnitLayoutSize(this)}parseSelections(){this.component.selection=parseUnitSelection(this,this.selection)}parseMarkGroup(){this.component.mark=parseMarkGroups(this)}parseAxesAndHeaders(){this.component.axes=parseUnitAxes(this)}assembleSelectionTopLevelSignals(signals){return assembleTopLevelSignals(this,signals)}assembleSignals(){return[...assembleAxisSignals(this),...assembleUnitSelectionSignals(this,[])]}assembleSelectionData(data){return assembleUnitSelectionData(this,data)}assembleLayout(){return null}assembleLayoutSignals(){return assembleLayoutSignals(this)}assembleMarks(){var _this$component$mark;let marks=(_this$component$mark=this.component.mark)!==null&&_this$component$mark!==void 0?_this$component$mark:[];if(!this.parent||!isLayerModel(this.parent)){marks=assembleUnitSelectionMarks(this,marks)}return marks.map(this.correctDataNames)}getMapping(){return this.encoding}get mark(){return this.markDef.type}channelHasField(channel){return channelHasField(this.encoding,channel)}fieldDef(channel){const channelDef=this.encoding[channel];return getFieldDef(channelDef)}typedFieldDef(channel){const fieldDef=this.fieldDef(channel);if(isTypedFieldDef(fieldDef)){return fieldDef}return null}}class LayerModel extends Model{constructor(spec,parent,parentGivenName,parentGivenSize,config){super(spec,"layer",parent,parentGivenName,config,spec.resolve,spec.view);_defineProperty(this,"children",void 0);const layoutSize={...parentGivenSize,...spec.width?{width:spec.width}:{},...spec.height?{height:spec.height}:{}};this.children=spec.layer.map((layer,i)=>{if(isLayerSpec(layer)){return new LayerModel(layer,this,this.getName("layer_"+i),layoutSize,config)}else if(isUnitSpec(layer)){return new UnitModel(layer,this,this.getName("layer_"+i),layoutSize,config)}throw new Error(invalidSpec(layer))})}parseData(){this.component.data=parseData(this);for(const child of this.children){child.parseData()}}parseLayoutSize(){parseLayerLayoutSize(this)}parseSelections(){this.component.selection={};for(const child of this.children){child.parseSelections();for(const key of keys(child.component.selection)){this.component.selection[key]=child.component.selection[key]}}}parseMarkGroup(){for(const child of this.children){child.parseMarkGroup()}}parseAxesAndHeaders(){parseLayerAxes(this)}assembleSelectionTopLevelSignals(signals){return this.children.reduce((sg,child)=>child.assembleSelectionTopLevelSignals(sg),signals)}assembleSignals(){return this.children.reduce((signals,child)=>signals.concat(child.assembleSignals()),assembleAxisSignals(this))}assembleLayoutSignals(){return this.children.reduce((signals,child)=>signals.concat(child.assembleLayoutSignals()),assembleLayoutSignals(this))}assembleSelectionData(data){return this.children.reduce((db,child)=>child.assembleSelectionData(db),data)}assembleTitle(){let title=super.assembleTitle();if(title){return title}for(const child of this.children){title=child.assembleTitle();if(title){return title}}return undefined}assembleLayout(){return null}assembleMarks(){return assembleLayerSelectionMarks(this,this.children.flatMap(child=>child.assembleMarks()))}assembleLegends(){return this.children.reduce((legends,child)=>legends.concat(child.assembleLegends()),assembleLegends(this))}}function buildModel(spec,parent,parentGivenName,unitSize,config){if(isFacetSpec(spec)){return new FacetModel(spec,parent,parentGivenName,config)}else if(isLayerSpec(spec)){return new LayerModel(spec,parent,parentGivenName,unitSize,config)}else if(isUnitSpec(spec)){return new UnitModel(spec,parent,parentGivenName,unitSize,config)}else if(isAnyConcatSpec(spec)){return new ConcatModel(spec,parent,parentGivenName,config)}throw new Error(invalidSpec(spec))}function compile(inputSpec,opt={}){if(opt.logger){set(opt.logger)}if(opt.fieldTitle){setTitleFormatter(opt.fieldTitle)}try{const config=initConfig(mergeConfig(opt.config,inputSpec.config));const spec=normalize(inputSpec,config);const model=buildModel(spec,null,"",undefined,config);model.parse();optimizeDataflow(model.component.data,model);const vgSpec=assembleTopLevelModel(model,getTopLevelProperties(inputSpec,spec.autosize,config,model),inputSpec.datasets,inputSpec.usermeta);return{spec:vgSpec,normalized:spec}}finally{if(opt.logger){reset()}if(opt.fieldTitle){resetTitleFormatter()}}}function getTopLevelProperties(inputSpec,autosize,config,model){const width=model.component.layoutSize.get("width");const height=model.component.layoutSize.get("height");if(autosize===undefined){autosize={type:"pad"};if(model.hasAxisOrientSignalRef()){autosize.resize=true}}else if(isString(autosize)){autosize={type:autosize}}if(width&&height&&isFitType(autosize.type)){if(width==="step"&&height==="step"){warn(droppingFit());autosize.type="pad"}else if(width==="step"||height==="step"){const sizeType=width==="step"?"width":"height";warn(droppingFit(getPositionScaleChannel(sizeType)));const inverseSizeType=sizeType==="width"?"height":"width";autosize.type=getFitType(inverseSizeType)}}return{...keys(autosize).length===1&&autosize.type?autosize.type==="pad"?{}:{autosize:autosize.type}:{autosize:autosize},...extractTopLevelProperties(config,false),...extractTopLevelProperties(inputSpec,true)}}function assembleTopLevelModel(model,topLevelProperties,datasets={},usermeta){const vgConfig=model.config?stripAndRedirectConfig(model.config):undefined;const data=[].concat(model.assembleSelectionData([]),assembleRootData(model.component.data,datasets));const projections=model.assembleProjections();const title=model.assembleTitle();const style=model.assembleGroupStyle();const encodeEntry=model.assembleGroupEncodeEntry(true);let layoutSignals=model.assembleLayoutSignals();layoutSignals=layoutSignals.filter(signal=>{if((signal.name==="width"||signal.name==="height")&&signal.value!==undefined){topLevelProperties[signal.name]=+signal.value;return false}return true});const{params:params,...otherTopLevelProps}=topLevelProperties;return{$schema:"https://vega.github.io/schema/vega/v5.json",...model.description?{description:model.description}:{},...otherTopLevelProps,...title?{title:title}:{},...style?{style:style}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},data:data,...projections.length>0?{projections:projections}:{},...model.assembleGroup([...layoutSignals,...model.assembleSelectionTopLevelSignals([]),...assembleParameterSignals(params)]),...vgConfig?{config:vgConfig}:{},...usermeta?{usermeta:usermeta}:{}}}exports.accessPathDepth=accessPathDepth;exports.accessPathWithDatum=accessPathWithDatum;exports.compile=compile;exports.contains=contains;exports.deepEqual=deepEqual;exports.deleteNestedProperty=deleteNestedProperty;exports.duplicate=duplicate;exports.entries=entries;exports.every=every;exports.fieldIntersection=fieldIntersection;exports.flatAccessWithDatum=flatAccessWithDatum;exports.getFirstDefined=getFirstDefined;exports.hasIntersection=hasIntersection;exports.hash=hash;exports.internalField=internalField;exports.isBoolean=isBoolean$1;exports.isEmpty=isEmpty;exports.isEqual=isEqual;exports.isInternalField=isInternalField;exports.isNullOrFalse=isNullOrFalse;exports.isNumeric=isNumeric;exports.keys=keys;exports.logicalExpr=logicalExpr;exports.mergeDeep=mergeDeep;exports.normalize=normalize;exports.normalizeAngle=normalizeAngle;exports.omit=omit;exports.pick=pick;exports.prefixGenerator=prefixGenerator;exports.removePathFromField=removePathFromField;exports.replaceAll=replaceAll;exports.replacePathInField=replacePathInField;exports.resetIdCounter=resetIdCounter;exports.setEqual=setEqual;exports.some=some;exports.stringify=stringify;exports.titleCase=titleCase;exports.unique=unique;exports.uniqueId=uniqueId;exports.vals=vals;exports.varName=varName;exports.version=version;Object.defineProperty(exports,"__esModule",{value:true})}))}).call(this,__webpack_require__(71).Buffer)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Utils}));var json_stringify_pretty_compact__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(62);var json_stringify_pretty_compact__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(json_stringify_pretty_compact__WEBPACK_IMPORTED_MODULE_0__);class Utils{static formatWarningToStr(...args){let value=args[0];if(args.length>=2){try{if(typeof args[1]==="string"){value+=`\n${args[1]}`}else{value+="\n"+json_stringify_pretty_compact__WEBPACK_IMPORTED_MODULE_0___default()(args[1],{maxLength:70})}}catch(err){}}return value}static formatErrorToStr(...args){let error=args[0];if(!error){error="ERR"}else if(error instanceof Error){error=error.message}return Utils.formatWarningToStr(error,...Array.from(args).slice(1))}}},,,,,,function(module,exports,__webpack_require__){"use strict";exports.byteLength=byteLength;exports.toByteArray=toByteArray;exports.fromByteArray=fromByteArray;var lookup=[];var revLookup=[];var Arr=typeof Uint8Array!=="undefined"?Uint8Array:Array;var code="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";for(var i=0,len=code.length;i<len;++i){lookup[i]=code[i];revLookup[code.charCodeAt(i)]=i}revLookup["-".charCodeAt(0)]=62;revLookup["_".charCodeAt(0)]=63;function getLens(b64){var len=b64.length;if(len%4>0){throw new Error("Invalid string. Length must be a multiple of 4")}var validLen=b64.indexOf("=");if(validLen===-1)validLen=len;var placeHoldersLen=validLen===len?0:4-validLen%4;return[validLen,placeHoldersLen]}function byteLength(b64){var lens=getLens(b64);var validLen=lens[0];var placeHoldersLen=lens[1];return(validLen+placeHoldersLen)*3/4-placeHoldersLen}function _byteLength(b64,validLen,placeHoldersLen){return(validLen+placeHoldersLen)*3/4-placeHoldersLen}function toByteArray(b64){var tmp;var lens=getLens(b64);var validLen=lens[0];var placeHoldersLen=lens[1];var arr=new Arr(_byteLength(b64,validLen,placeHoldersLen));var curByte=0;var len=placeHoldersLen>0?validLen-4:validLen;var i;for(i=0;i<len;i+=4){tmp=revLookup[b64.charCodeAt(i)]<<18|revLookup[b64.charCodeAt(i+1)]<<12|revLookup[b64.charCodeAt(i+2)]<<6|revLookup[b64.charCodeAt(i+3)];arr[curByte++]=tmp>>16&255;arr[curByte++]=tmp>>8&255;arr[curByte++]=tmp&255}if(placeHoldersLen===2){tmp=revLookup[b64.charCodeAt(i)]<<2|revLookup[b64.charCodeAt(i+1)]>>4;arr[curByte++]=tmp&255}if(placeHoldersLen===1){tmp=revLookup[b64.charCodeAt(i)]<<10|revLookup[b64.charCodeAt(i+1)]<<4|revLookup[b64.charCodeAt(i+2)]>>2;arr[curByte++]=tmp>>8&255;arr[curByte++]=tmp&255}return arr}function tripletToBase64(num){return lookup[num>>18&63]+lookup[num>>12&63]+lookup[num>>6&63]+lookup[num&63]}function encodeChunk(uint8,start,end){var tmp;var output=[];for(var i=start;i<end;i+=3){tmp=(uint8[i]<<16&16711680)+(uint8[i+1]<<8&65280)+(uint8[i+2]&255);output.push(tripletToBase64(tmp))}return output.join("")}function fromByteArray(uint8){var tmp;var len=uint8.length;var extraBytes=len%3;var parts=[];var maxChunkLength=16383;for(var i=0,len2=len-extraBytes;i<len2;i+=maxChunkLength){parts.push(encodeChunk(uint8,i,i+maxChunkLength>len2?len2:i+maxChunkLength))}if(extraBytes===1){tmp=uint8[len-1];parts.push(lookup[tmp>>2]+lookup[tmp<<4&63]+"==")}else if(extraBytes===2){tmp=(uint8[len-2]<<8)+uint8[len-1];parts.push(lookup[tmp>>10]+lookup[tmp>>4&63]+lookup[tmp<<2&63]+"=")}return parts.join("")}},function(module,exports){exports.read=function(buffer,offset,isLE,mLen,nBytes){var e,m;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var nBits=-7;var i=isLE?nBytes-1:0;var d=isLE?-1:1;var s=buffer[offset+i];i+=d;e=s&(1<<-nBits)-1;s>>=-nBits;nBits+=eLen;for(;nBits>0;e=e*256+buffer[offset+i],i+=d,nBits-=8){}m=e&(1<<-nBits)-1;e>>=-nBits;nBits+=mLen;for(;nBits>0;m=m*256+buffer[offset+i],i+=d,nBits-=8){}if(e===0){e=1-eBias}else if(e===eMax){return m?NaN:(s?-1:1)*Infinity}else{m=m+Math.pow(2,mLen);e=e-eBias}return(s?-1:1)*m*Math.pow(2,e-mLen)};exports.write=function(buffer,value,offset,isLE,mLen,nBytes){var e,m,c;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var rt=mLen===23?Math.pow(2,-24)-Math.pow(2,-77):0;var i=isLE?0:nBytes-1;var d=isLE?1:-1;var s=value<0||value===0&&1/value<0?1:0;value=Math.abs(value);if(isNaN(value)||value===Infinity){m=isNaN(value)?1:0;e=eMax}else{e=Math.floor(Math.log(value)/Math.LN2);if(value*(c=Math.pow(2,-e))<1){e--;c*=2}if(e+eBias>=1){value+=rt/c}else{value+=rt*Math.pow(2,1-eBias)}if(value*c>=2){e++;c/=2}if(e+eBias>=eMax){m=0;e=eMax}else if(e+eBias>=1){m=(value*c-1)*Math.pow(2,mLen);e=e+eBias}else{m=value*Math.pow(2,eBias-1)*Math.pow(2,mLen);e=0}}for(;mLen>=8;buffer[offset+i]=m&255,i+=d,m/=256,mLen-=8){}e=e<<mLen|m;eLen+=mLen;for(;eLen>0;buffer[offset+i]=e&255,i+=d,e/=256,eLen-=8){}buffer[offset+i-d]|=s*128}},function(module,exports){var toString={}.toString;module.exports=Array.isArray||function(arr){return toString.call(arr)=="[object Array]"}},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function bisector(f){let delta=f;let compare=f;if(f.length===1){delta=(d,x)=>f(d)-x;compare=ascendingComparator(f)}function left(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid}return lo}function right(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1}return lo}function center(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;const i=left(a,x,lo,hi-1);return i>lo&&delta(a[i-1],x)>-delta(a[i],x)?i-1:i}return{left:left,center:center,right:right}}function ascendingComparator(f){return(d,x)=>ascending(f(d),x)}function number(x){return x===null?NaN:+x}function*numbers(values,valueof){if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){yield value}}}}const ascendingBisect=bisector(ascending);const bisectRight=ascendingBisect.right;const bisectLeft=ascendingBisect.left;const bisectCenter=bisector(number).center;function count(values,valueof){let count=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count}}}return count}function length(array){return array.length|0}function empty(length){return!(length>0)}function arrayify(values){return typeof values!=="object"||"length"in values?values:Array.from(values)}function reducer(reduce){return values=>reduce(...values)}function cross(...values){const reduce=typeof values[values.length-1]==="function"&&reducer(values.pop());values=values.map(arrayify);const lengths=values.map(length);const j=values.length-1;const index=new Array(j+1).fill(0);const product=[];if(j<0||lengths.some(empty))return product;while(true){product.push(index.map((j,i)=>values[i][j]));let i=j;while(++index[i]===lengths[i]){if(i===0)return reduce?product.map(reduce):product;index[i--]=0}}}function cumsum(values,valueof){var sum=0,index=0;return Float64Array.from(values,valueof===undefined?v=>sum+=+v||0:v=>sum+=+valueof(v,index++,values)||0)}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function variance(values,valueof){let count=0;let delta;let mean=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}if(count>1)return sum/(count-1)}function deviation(values,valueof){const v=variance(values,valueof);return v?Math.sqrt(v):v}function extent(values,valueof){let min;let max;if(valueof===undefined){for(const value of values){if(value!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}return[min,max]}class Adder{constructor(){this._partials=new Float64Array(32);this._n=0}add(x){const p=this._partials;let i=0;for(let j=0;j<this._n&&j<32;j++){const y=p[j],hi=x+y,lo=Math.abs(x)<Math.abs(y)?x-(hi-y):y-(hi-x);if(lo)p[i++]=lo;x=hi}p[i]=x;this._n=i+1;return this}valueOf(){const p=this._partials;let n=this._n,x,y,lo,hi=0;if(n>0){hi=p[--n];while(n>0){x=hi;y=p[--n];hi=x+y;lo=y-(hi-x);if(lo)break}if(n>0&&(lo<0&&p[n-1]<0||lo>0&&p[n-1]>0)){y=lo*2;x=hi+y;if(y==x-hi)hi=x}}return hi}}function fsum(values,valueof){const adder=new Adder;if(valueof===undefined){for(let value of values){if(value=+value){adder.add(value)}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){adder.add(value)}}}return+adder}function identity(x){return x}function group(values,...keys){return nest(values,identity,identity,keys)}function groups(values,...keys){return nest(values,Array.from,identity,keys)}function rollup(values,reduce,...keys){return nest(values,identity,reduce,keys)}function rollups(values,reduce,...keys){return nest(values,Array.from,reduce,keys)}function index(values,...keys){return nest(values,identity,unique,keys)}function indexes(values,...keys){return nest(values,Array.from,unique,keys)}function unique(values){if(values.length!==1)throw new Error("duplicate key");return values[0]}function nest(values,map,reduce,keys){return function regroup(values,i){if(i>=keys.length)return reduce(values);const groups=new Map;const keyof=keys[i++];let index=-1;for(const value of values){const key=keyof(value,++index,values);const group=groups.get(key);if(group)group.push(value);else groups.set(key,[value])}for(const[key,values]of groups){groups.set(key,regroup(values,i))}return map(groups)}(values,0)}var array=Array.prototype;var slice=array.slice;function constant(x){return function(){return x}}var e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function ticks(start,stop,count){var reverse,i=-1,n,ticks,step;stop=+stop,start=+start,count=+count;if(start===stop&&count>0)return[start];if(reverse=stop<start)n=start,start=stop,stop=n;if((step=tickIncrement(start,stop,count))===0||!isFinite(step))return[];if(step>0){start=Math.ceil(start/step);stop=Math.floor(stop/step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)*step}else{step=-step;start=Math.ceil(start*step);stop=Math.floor(stop*step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)/step}if(reverse)ticks.reverse();return ticks}function tickIncrement(start,stop,count){var step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log(step)/Math.LN10),error=step/Math.pow(10,power);return power>=0?(error>=e10?10:error>=e5?5:error>=e2?2:1)*Math.pow(10,power):-Math.pow(10,-power)/(error>=e10?10:error>=e5?5:error>=e2?2:1)}function tickStep(start,stop,count){var step0=Math.abs(stop-start)/Math.max(0,count),step1=Math.pow(10,Math.floor(Math.log(step0)/Math.LN10)),error=step0/step1;if(error>=e10)step1*=10;else if(error>=e5)step1*=5;else if(error>=e2)step1*=2;return stop<start?-step1:step1}function nice(start,stop,count){let prestep;while(true){const step=tickIncrement(start,stop,count);if(step===prestep||step===0||!isFinite(step)){return[start,stop]}else if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step}prestep=step}}function sturges(values){return Math.ceil(Math.log(count(values))/Math.LN2)+1}function bin(){var value=identity,domain=extent,threshold=sturges;function histogram(data){if(!Array.isArray(data))data=Array.from(data);var i,n=data.length,x,values=new Array(n);for(i=0;i<n;++i){values[i]=value(data[i],i,data)}var xz=domain(values),x0=xz[0],x1=xz[1],tz=threshold(values,x0,x1);if(!Array.isArray(tz)){tz=+tz;if(domain===extent)[x0,x1]=nice(x0,x1,tz);tz=ticks(x0,x1,tz);if(tz[tz.length-1]===x1)tz.pop()}var m=tz.length;while(tz[0]<=x0)tz.shift(),--m;while(tz[m-1]>x1)tz.pop(),--m;var bins=new Array(m+1),bin;for(i=0;i<=m;++i){bin=bins[i]=[];bin.x0=i>0?tz[i-1]:x0;bin.x1=i<m?tz[i]:x1}for(i=0;i<n;++i){x=values[i];if(x0<=x&&x<=x1){bins[bisectRight(tz,x,0,m)].push(data[i])}}return bins}histogram.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(_),histogram):value};histogram.domain=function(_){return arguments.length?(domain=typeof _==="function"?_:constant([_[0],_[1]]),histogram):domain};histogram.thresholds=function(_){return arguments.length?(threshold=typeof _==="function"?_:Array.isArray(_)?constant(slice.call(_)):constant(_),histogram):threshold};return histogram}function max(values,valueof){let max;if(valueof===undefined){for(const value of values){if(value!=null&&(max<value||max===undefined&&value>=value)){max=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value}}}return max}function min(values,valueof){let min;if(valueof===undefined){for(const value of values){if(value!=null&&(min>value||min===undefined&&value>=value)){min=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value}}}return min}function quickselect(array,k,left=0,right=array.length-1,compare=ascending){while(right>left){if(right-left>600){const n=right-left+1;const m=k-left+1;const z=Math.log(n);const s=.5*Math.exp(2*z/3);const sd=.5*Math.sqrt(z*s*(n-s)/n)*(m-n/2<0?-1:1);const newLeft=Math.max(left,Math.floor(k-m*s/n+sd));const newRight=Math.min(right,Math.floor(k+(n-m)*s/n+sd));quickselect(array,k,newLeft,newRight,compare)}const t=array[k];let i=left;let j=right;swap(array,left,k);if(compare(array[right],t)>0)swap(array,left,right);while(i<j){swap(array,i,j),++i,--j;while(compare(array[i],t)<0)++i;while(compare(array[j],t)>0)--j}if(compare(array[left],t)===0)swap(array,left,j);else++j,swap(array,j,right);if(j<=k)left=j+1;if(k<=j)right=j-1}return array}function swap(array,i,j){const t=array[i];array[i]=array[j];array[j]=t}function quantile(values,p,valueof){values=Float64Array.from(numbers(values,valueof));if(!(n=values.length))return;if((p=+p)<=0||n<2)return min(values);if(p>=1)return max(values);var n,i=(n-1)*p,i0=Math.floor(i),value0=max(quickselect(values,i0).subarray(0,i0+1)),value1=min(values.subarray(i0+1));return value0+(value1-value0)*(i-i0)}function quantileSorted(values,p,valueof=number){if(!(n=values.length))return;if((p=+p)<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function freedmanDiaconis(values,min,max){return Math.ceil((max-min)/(2*(quantile(values,.75)-quantile(values,.25))*Math.pow(count(values),-1/3)))}function scott(values,min,max){return Math.ceil((max-min)/(3.5*deviation(values)*Math.pow(count(values),-1/3)))}function maxIndex(values,valueof){let max;let maxIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}return maxIndex}function mean(values,valueof){let count=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count,sum+=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count,sum+=value}}}if(count)return sum/count}function median(values,valueof){return quantile(values,.5,valueof)}function*flatten(arrays){for(const array of arrays){yield*array}}function merge(arrays){return Array.from(flatten(arrays))}function minIndex(values,valueof){let min;let minIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}return minIndex}function pairs(values,pairof=pair){const pairs=[];let previous;let first=false;for(const value of values){if(first)pairs.push(pairof(previous,value));previous=value;first=true}return pairs}function pair(a,b){return[a,b]}function permute(source,keys){return Array.from(keys,key=>source[key])}function range(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}function least(values,compare=ascending){let min;let defined=false;if(compare.length===1){let minValue;for(const element of values){const value=compare(element);if(defined?ascending(value,minValue)<0:ascending(value,value)===0){min=element;minValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,min)<0:compare(value,value)===0){min=value;defined=true}}}return min}function leastIndex(values,compare=ascending){if(compare.length===1)return minIndex(values,compare);let minValue;let min=-1;let index=-1;for(const value of values){++index;if(min<0?compare(value,value)===0:compare(value,minValue)<0){minValue=value;min=index}}return min}function greatest(values,compare=ascending){let max;let defined=false;if(compare.length===1){let maxValue;for(const element of values){const value=compare(element);if(defined?ascending(value,maxValue)>0:ascending(value,value)===0){max=element;maxValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,max)>0:compare(value,value)===0){max=value;defined=true}}}return max}function greatestIndex(values,compare=ascending){if(compare.length===1)return maxIndex(values,compare);let maxValue;let max=-1;let index=-1;for(const value of values){++index;if(max<0?compare(value,value)===0:compare(value,maxValue)>0){maxValue=value;max=index}}return max}function scan(values,compare){const index=leastIndex(values,compare);return index<0?undefined:index}var shuffle=shuffler(Math.random);function shuffler(random){return function shuffle(array,i0=0,i1=array.length){let m=i1-(i0=+i0);while(m){const i=random()*m--|0,t=array[m+i0];array[m+i0]=array[i+i0];array[i+i0]=t}return array}}function sum(values,valueof){let sum=0;if(valueof===undefined){for(let value of values){if(value=+value){sum+=value}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){sum+=value}}}return sum}function transpose(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=min(matrix,length$1),transpose=new Array(m);++i<m;){for(var j=-1,n,row=transpose[i]=new Array(n);++j<n;){row[j]=matrix[j][i]}}return transpose}function length$1(d){return d.length}function zip(){return transpose(arguments)}function every(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(!test(value,++index,values)){return false}}return true}function some(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(test(value,++index,values)){return true}}return false}function filter(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");const array=[];let index=-1;for(const value of values){if(test(value,++index,values)){array.push(value)}}return array}function map(values,mapper){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");if(typeof mapper!=="function")throw new TypeError("mapper is not a function");return Array.from(values,(value,index)=>mapper(value,index,values))}function reduce(values,reducer,value){if(typeof reducer!=="function")throw new TypeError("reducer is not a function");const iterator=values[Symbol.iterator]();let done,next,index=-1;if(arguments.length<3){({done:done,value:value}=iterator.next());if(done)return;++index}while(({done:done,value:next}=iterator.next()),!done){value=reducer(value,next,++index,values)}return value}function reverse(values){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).reverse()}function sort(values,comparator=ascending){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).sort(comparator)}function difference(values,...others){values=new Set(values);for(const other of others){for(const value of other){values.delete(value)}}return values}function disjoint(values,other){const iterator=other[Symbol.iterator](),set=new Set;for(const v of values){if(set.has(v))return false;let value,done;while(({value:value,done:done}=iterator.next())){if(done)break;if(Object.is(v,value))return false;set.add(value)}}return true}function set(values){return values instanceof Set?values:new Set(values)}function intersection(values,...others){values=new Set(values);others=others.map(set);out:for(const value of values){for(const other of others){if(!other.has(value)){values.delete(value);continue out}}}return values}function superset(values,other){const iterator=values[Symbol.iterator](),set=new Set;for(const o of other){if(set.has(o))continue;let value,done;while(({value:value,done:done}=iterator.next())){if(done)return false;set.add(value);if(Object.is(o,value))break}}return true}function subset(values,other){return superset(other,values)}function union(...others){const set=new Set;for(const other of others){for(const o of other){set.add(o)}}return set}exports.Adder=Adder;exports.ascending=ascending;exports.bin=bin;exports.bisect=bisectRight;exports.bisectCenter=bisectCenter;exports.bisectLeft=bisectLeft;exports.bisectRight=bisectRight;exports.bisector=bisector;exports.count=count;exports.cross=cross;exports.cumsum=cumsum;exports.descending=descending;exports.deviation=deviation;exports.difference=difference;exports.disjoint=disjoint;exports.every=every;exports.extent=extent;exports.filter=filter;exports.fsum=fsum;exports.greatest=greatest;exports.greatestIndex=greatestIndex;exports.group=group;exports.groups=groups;exports.histogram=bin;exports.index=index;exports.indexes=indexes;exports.intersection=intersection;exports.least=least;exports.leastIndex=leastIndex;exports.map=map;exports.max=max;exports.maxIndex=maxIndex;exports.mean=mean;exports.median=median;exports.merge=merge;exports.min=min;exports.minIndex=minIndex;exports.nice=nice;exports.pairs=pairs;exports.permute=permute;exports.quantile=quantile;exports.quantileSorted=quantileSorted;exports.quickselect=quickselect;exports.range=range;exports.reduce=reduce;exports.reverse=reverse;exports.rollup=rollup;exports.rollups=rollups;exports.scan=scan;exports.shuffle=shuffle;exports.shuffler=shuffler;exports.some=some;exports.sort=sort;exports.subset=subset;exports.sum=sum;exports.superset=superset;exports.thresholdFreedmanDiaconis=freedmanDiaconis;exports.thresholdScott=scott;exports.thresholdSturges=sturges;exports.tickIncrement=tickIncrement;exports.tickStep=tickStep;exports.ticks=ticks;exports.transpose=transpose;exports.union=union;exports.variance=variance;exports.zip=zip;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function formatDecimal(x){return Math.abs(x=Math.round(x))>=1e21?x.toLocaleString("en").replace(/,/g,""):x.toString(10)}function formatDecimalParts(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]}function exponent(x){return x=formatDecimalParts(Math.abs(x)),x?x[1]:NaN}function formatGroup(grouping,thousands){return function(value,width){var i=value.length,t=[],j=0,g=grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=grouping[j=(j+1)%grouping.length]}return t.reverse().join(thousands)}}function formatNumerals(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}var re=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function formatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match;return new FormatSpecifier({fill:match[1],align:match[2],sign:match[3],symbol:match[4],zero:match[5],width:match[6],comma:match[7],precision:match[8]&&match[8].slice(1),trim:match[9],type:match[10]})}formatSpecifier.prototype=FormatSpecifier.prototype;function FormatSpecifier(specifier){this.fill=specifier.fill===undefined?" ":specifier.fill+"";this.align=specifier.align===undefined?">":specifier.align+"";this.sign=specifier.sign===undefined?"-":specifier.sign+"";this.symbol=specifier.symbol===undefined?"":specifier.symbol+"";this.zero=!!specifier.zero;this.width=specifier.width===undefined?undefined:+specifier.width;this.comma=!!specifier.comma;this.precision=specifier.precision===undefined?undefined:+specifier.precision;this.trim=!!specifier.trim;this.type=specifier.type===undefined?"":specifier.type+""}FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(this.width===undefined?"":Math.max(1,this.width|0))+(this.comma?",":"")+(this.precision===undefined?"":"."+Math.max(0,this.precision|0))+(this.trim?"~":"")+this.type};function formatTrim(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}var prefixExponent;function formatPrefixAuto(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=Math.max(-8,Math.min(8,Math.floor(exponent/3)))*3)+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimalParts(x,Math.max(0,p+i-1))[0]}function formatRounded(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")}var formatTypes={"%":(x,p)=>(x*100).toFixed(p),b:x=>Math.round(x).toString(2),c:x=>x+"",d:formatDecimal,e:(x,p)=>x.toExponential(p),f:(x,p)=>x.toFixed(p),g:(x,p)=>x.toPrecision(p),o:x=>Math.round(x).toString(8),p:(x,p)=>formatRounded(x*100,p),r:formatRounded,s:formatPrefixAuto,X:x=>Math.round(x).toString(16).toUpperCase(),x:x=>Math.round(x).toString(16)};function identity(x){return x}var map=Array.prototype.map,prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function formatLocale(locale){var group=locale.grouping===undefined||locale.thousands===undefined?identity:formatGroup(map.call(locale.grouping,Number),locale.thousands+""),currencyPrefix=locale.currency===undefined?"":locale.currency[0]+"",currencySuffix=locale.currency===undefined?"":locale.currency[1]+"",decimal=locale.decimal===undefined?".":locale.decimal+"",numerals=locale.numerals===undefined?identity:formatNumerals(map.call(locale.numerals,String)),percent=locale.percent===undefined?"%":locale.percent+"",minus=locale.minus===undefined?"−":locale.minus+"",nan=locale.nan===undefined?"NaN":locale.nan+"";function newFormat(specifier){specifier=formatSpecifier(specifier);var fill=specifier.fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,trim=specifier.trim,type=specifier.type;if(type==="n")comma=true,type="g";else if(!formatTypes[type])precision===undefined&&(precision=12),trim=true,type="g";if(zero||fill==="0"&&align==="=")zero=true,fill="0",align="=";var prefix=symbol==="$"?currencyPrefix:symbol==="#"&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix=symbol==="$"?currencySuffix:/[%p]/.test(type)?percent:"";var formatType=formatTypes[type],maybeSuffix=/[defgprs%]/.test(type);precision=precision===undefined?6:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision));function format(value){var valuePrefix=prefix,valueSuffix=suffix,i,n,c;if(type==="c"){valueSuffix=formatType(value)+valueSuffix;value=""}else{value=+value;var valueNegative=value<0||1/value<0;value=isNaN(value)?nan:formatType(Math.abs(value),precision);if(trim)value=formatTrim(value);if(valueNegative&&+value===0&&sign!=="+")valueNegative=false;valuePrefix=(valueNegative?sign==="("?sign:minus:sign==="-"||sign==="("?"":sign)+valuePrefix;valueSuffix=(type==="s"?prefixes[8+prefixExponent/3]:"")+valueSuffix+(valueNegative&&sign==="("?")":"");if(maybeSuffix){i=-1,n=value.length;while(++i<n){if(c=value.charCodeAt(i),48>c||c>57){valueSuffix=(c===46?decimal+value.slice(i+1):value.slice(i))+valueSuffix;value=value.slice(0,i);break}}}}if(comma&&!zero)value=group(value,Infinity);var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";if(comma&&zero)value=group(padding+value,padding.length?width-valueSuffix.length:Infinity),padding="";switch(align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix;break}return numerals(value)}format.toString=function(){return specifier+""};return format}function formatPrefix(specifier,value){var f=newFormat((specifier=formatSpecifier(specifier),specifier.type="f",specifier)),e=Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3,k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}return{format:newFormat,formatPrefix:formatPrefix}}var locale;defaultLocale({thousands:",",grouping:[3],currency:["$",""]});function defaultLocale(definition){locale=formatLocale(definition);exports.format=locale.format;exports.formatPrefix=locale.formatPrefix;return locale}function precisionFixed(step){return Math.max(0,-exponent(Math.abs(step)))}function precisionPrefix(step,value){return Math.max(0,Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3-exponent(Math.abs(step)))}function precisionRound(step,max){step=Math.abs(step),max=Math.abs(max)-step;return Math.max(0,exponent(max)-exponent(step))+1}exports.FormatSpecifier=FormatSpecifier;exports.formatDefaultLocale=defaultLocale;exports.formatLocale=formatLocale;exports.formatSpecifier=formatSpecifier;exports.precisionFixed=precisionFixed;exports.precisionPrefix=precisionPrefix;exports.precisionRound=precisionRound;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var t0=new Date,t1=new Date;function newInterval(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=function(date){return floori(date=new Date(+date)),date};interval.ceil=function(date){return floori(date=new Date(date-1)),offseti(date,1),floori(date),date};interval.round=function(date){var d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=function(date,step){return offseti(date=new Date(+date),step==null?1:Math.floor(step)),date};interval.range=function(start,stop,step){var range=[],previous;start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=function(test){return newInterval((function(date){if(date>=date)while(floori(date),!test(date))date.setTime(date-1)}),(function(date,step){if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,+1),!test(date)){}}}}))};if(count){interval.count=function(start,end){t0.setTime(+start),t1.setTime(+end);floori(t0),floori(t1);return Math.floor(count(t0,t1))};interval.every=function(step){step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?function(d){return field(d)%step===0}:function(d){return interval.count(0,d)%step===0})}}return interval}var millisecond=newInterval((function(){}),(function(date,step){date.setTime(+date+step)}),(function(start,end){return end-start}));millisecond.every=function(k){k=Math.floor(k);if(!isFinite(k)||!(k>0))return null;if(!(k>1))return millisecond;return newInterval((function(date){date.setTime(Math.floor(date/k)*k)}),(function(date,step){date.setTime(+date+step*k)}),(function(start,end){return(end-start)/k}))};var milliseconds=millisecond.range;var durationSecond=1e3;var durationMinute=6e4;var durationHour=36e5;var durationDay=864e5;var durationWeek=6048e5;var second=newInterval((function(date){date.setTime(date-date.getMilliseconds())}),(function(date,step){date.setTime(+date+step*durationSecond)}),(function(start,end){return(end-start)/durationSecond}),(function(date){return date.getUTCSeconds()}));var seconds=second.range;var minute=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getMinutes()}));var minutes=minute.range;var hour=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond-date.getMinutes()*durationMinute)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getHours()}));var hours=hour.range;var day=newInterval(date=>date.setHours(0,0,0,0),(date,step)=>date.setDate(date.getDate()+step),(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationDay,date=>date.getDate()-1);var days=day.range;function weekday(i){return newInterval((function(date){date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+step*7)}),(function(start,end){return(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationWeek}))}var sunday=weekday(0);var monday=weekday(1);var tuesday=weekday(2);var wednesday=weekday(3);var thursday=weekday(4);var friday=weekday(5);var saturday=weekday(6);var sundays=sunday.range;var mondays=monday.range;var tuesdays=tuesday.range;var wednesdays=wednesday.range;var thursdays=thursday.range;var fridays=friday.range;var saturdays=saturday.range;var month=newInterval((function(date){date.setDate(1);date.setHours(0,0,0,0)}),(function(date,step){date.setMonth(date.getMonth()+step)}),(function(start,end){return end.getMonth()-start.getMonth()+(end.getFullYear()-start.getFullYear())*12}),(function(date){return date.getMonth()}));var months=month.range;var year=newInterval((function(date){date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step)}),(function(start,end){return end.getFullYear()-start.getFullYear()}),(function(date){return date.getFullYear()}));year.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step*k)}))};var years=year.range;var utcMinute=newInterval((function(date){date.setUTCSeconds(0,0)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getUTCMinutes()}));var utcMinutes=utcMinute.range;var utcHour=newInterval((function(date){date.setUTCMinutes(0,0,0)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getUTCHours()}));var utcHours=utcHour.range;var utcDay=newInterval((function(date){date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step)}),(function(start,end){return(end-start)/durationDay}),(function(date){return date.getUTCDate()-1}));var utcDays=utcDay.range;function utcWeekday(i){return newInterval((function(date){date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step*7)}),(function(start,end){return(end-start)/durationWeek}))}var utcSunday=utcWeekday(0);var utcMonday=utcWeekday(1);var utcTuesday=utcWeekday(2);var utcWednesday=utcWeekday(3);var utcThursday=utcWeekday(4);var utcFriday=utcWeekday(5);var utcSaturday=utcWeekday(6);var utcSundays=utcSunday.range;var utcMondays=utcMonday.range;var utcTuesdays=utcTuesday.range;var utcWednesdays=utcWednesday.range;var utcThursdays=utcThursday.range;var utcFridays=utcFriday.range;var utcSaturdays=utcSaturday.range;var utcMonth=newInterval((function(date){date.setUTCDate(1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCMonth(date.getUTCMonth()+step)}),(function(start,end){return end.getUTCMonth()-start.getUTCMonth()+(end.getUTCFullYear()-start.getUTCFullYear())*12}),(function(date){return date.getUTCMonth()}));var utcMonths=utcMonth.range;var utcYear=newInterval((function(date){date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step)}),(function(start,end){return end.getUTCFullYear()-start.getUTCFullYear()}),(function(date){return date.getUTCFullYear()}));utcYear.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step*k)}))};var utcYears=utcYear.range;exports.timeDay=day;exports.timeDays=days;exports.timeFriday=friday;exports.timeFridays=fridays;exports.timeHour=hour;exports.timeHours=hours;exports.timeInterval=newInterval;exports.timeMillisecond=millisecond;exports.timeMilliseconds=milliseconds;exports.timeMinute=minute;exports.timeMinutes=minutes;exports.timeMonday=monday;exports.timeMondays=mondays;exports.timeMonth=month;exports.timeMonths=months;exports.timeSaturday=saturday;exports.timeSaturdays=saturdays;exports.timeSecond=second;exports.timeSeconds=seconds;exports.timeSunday=sunday;exports.timeSundays=sundays;exports.timeThursday=thursday;exports.timeThursdays=thursdays;exports.timeTuesday=tuesday;exports.timeTuesdays=tuesdays;exports.timeWednesday=wednesday;exports.timeWednesdays=wednesdays;exports.timeWeek=sunday;exports.timeWeeks=sundays;exports.timeYear=year;exports.timeYears=years;exports.utcDay=utcDay;exports.utcDays=utcDays;exports.utcFriday=utcFriday;exports.utcFridays=utcFridays;exports.utcHour=utcHour;exports.utcHours=utcHours;exports.utcMillisecond=millisecond;exports.utcMilliseconds=milliseconds;exports.utcMinute=utcMinute;exports.utcMinutes=utcMinutes;exports.utcMonday=utcMonday;exports.utcMondays=utcMondays;exports.utcMonth=utcMonth;exports.utcMonths=utcMonths;exports.utcSaturday=utcSaturday;exports.utcSaturdays=utcSaturdays;exports.utcSecond=second;exports.utcSeconds=seconds;exports.utcSunday=utcSunday;exports.utcSundays=utcSundays;exports.utcThursday=utcThursday;exports.utcThursdays=utcThursdays;exports.utcTuesday=utcTuesday;exports.utcTuesdays=utcTuesdays;exports.utcWednesday=utcWednesday;exports.utcWednesdays=utcWednesdays;exports.utcWeek=utcSunday;exports.utcWeeks=utcSundays;exports.utcYear=utcYear;exports.utcYears=utcYears;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function bisector(f){let delta=f;let compare=f;if(f.length===1){delta=(d,x)=>f(d)-x;compare=ascendingComparator(f)}function left(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid}return lo}function right(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;while(lo<hi){const mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1}return lo}function center(a,x,lo,hi){if(lo==null)lo=0;if(hi==null)hi=a.length;const i=left(a,x,lo,hi-1);return i>lo&&delta(a[i-1],x)>-delta(a[i],x)?i-1:i}return{left:left,center:center,right:right}}function ascendingComparator(f){return(d,x)=>ascending(f(d),x)}function number(x){return x===null?NaN:+x}function*numbers(values,valueof){if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){yield value}}}}const ascendingBisect=bisector(ascending);const bisectRight=ascendingBisect.right;const bisectLeft=ascendingBisect.left;const bisectCenter=bisector(number).center;function count(values,valueof){let count=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count}}}return count}function length(array){return array.length|0}function empty(length){return!(length>0)}function arrayify(values){return typeof values!=="object"||"length"in values?values:Array.from(values)}function reducer(reduce){return values=>reduce(...values)}function cross(...values){const reduce=typeof values[values.length-1]==="function"&&reducer(values.pop());values=values.map(arrayify);const lengths=values.map(length);const j=values.length-1;const index=new Array(j+1).fill(0);const product=[];if(j<0||lengths.some(empty))return product;while(true){product.push(index.map((j,i)=>values[i][j]));let i=j;while(++index[i]===lengths[i]){if(i===0)return reduce?product.map(reduce):product;index[i--]=0}}}function cumsum(values,valueof){var sum=0,index=0;return Float64Array.from(values,valueof===undefined?v=>sum+=+v||0:v=>sum+=+valueof(v,index++,values)||0)}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function variance(values,valueof){let count=0;let delta;let mean=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}if(count>1)return sum/(count-1)}function deviation(values,valueof){const v=variance(values,valueof);return v?Math.sqrt(v):v}function extent(values,valueof){let min;let max;if(valueof===undefined){for(const value of values){if(value!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null){if(min===undefined){if(value>=value)min=max=value}else{if(min>value)min=value;if(max<value)max=value}}}}return[min,max]}class Adder{constructor(){this._partials=new Float64Array(32);this._n=0}add(x){const p=this._partials;let i=0;for(let j=0;j<this._n&&j<32;j++){const y=p[j],hi=x+y,lo=Math.abs(x)<Math.abs(y)?x-(hi-y):y-(hi-x);if(lo)p[i++]=lo;x=hi}p[i]=x;this._n=i+1;return this}valueOf(){const p=this._partials;let n=this._n,x,y,lo,hi=0;if(n>0){hi=p[--n];while(n>0){x=hi;y=p[--n];hi=x+y;lo=y-(hi-x);if(lo)break}if(n>0&&(lo<0&&p[n-1]<0||lo>0&&p[n-1]>0)){y=lo*2;x=hi+y;if(y==x-hi)hi=x}}return hi}}function fsum(values,valueof){const adder=new Adder;if(valueof===undefined){for(let value of values){if(value=+value){adder.add(value)}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){adder.add(value)}}}return+adder}function identity(x){return x}function group(values,...keys){return nest(values,identity,identity,keys)}function groups(values,...keys){return nest(values,Array.from,identity,keys)}function rollup(values,reduce,...keys){return nest(values,identity,reduce,keys)}function rollups(values,reduce,...keys){return nest(values,Array.from,reduce,keys)}function index(values,...keys){return nest(values,identity,unique,keys)}function indexes(values,...keys){return nest(values,Array.from,unique,keys)}function unique(values){if(values.length!==1)throw new Error("duplicate key");return values[0]}function nest(values,map,reduce,keys){return function regroup(values,i){if(i>=keys.length)return reduce(values);const groups=new Map;const keyof=keys[i++];let index=-1;for(const value of values){const key=keyof(value,++index,values);const group=groups.get(key);if(group)group.push(value);else groups.set(key,[value])}for(const[key,values]of groups){groups.set(key,regroup(values,i))}return map(groups)}(values,0)}var array=Array.prototype;var slice=array.slice;function constant(x){return function(){return x}}var e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function ticks(start,stop,count){var reverse,i=-1,n,ticks,step;stop=+stop,start=+start,count=+count;if(start===stop&&count>0)return[start];if(reverse=stop<start)n=start,start=stop,stop=n;if((step=tickIncrement(start,stop,count))===0||!isFinite(step))return[];if(step>0){start=Math.ceil(start/step);stop=Math.floor(stop/step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)*step}else{step=-step;start=Math.ceil(start*step);stop=Math.floor(stop*step);ticks=new Array(n=Math.ceil(stop-start+1));while(++i<n)ticks[i]=(start+i)/step}if(reverse)ticks.reverse();return ticks}function tickIncrement(start,stop,count){var step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log(step)/Math.LN10),error=step/Math.pow(10,power);return power>=0?(error>=e10?10:error>=e5?5:error>=e2?2:1)*Math.pow(10,power):-Math.pow(10,-power)/(error>=e10?10:error>=e5?5:error>=e2?2:1)}function tickStep(start,stop,count){var step0=Math.abs(stop-start)/Math.max(0,count),step1=Math.pow(10,Math.floor(Math.log(step0)/Math.LN10)),error=step0/step1;if(error>=e10)step1*=10;else if(error>=e5)step1*=5;else if(error>=e2)step1*=2;return stop<start?-step1:step1}function nice(start,stop,count){let prestep;while(true){const step=tickIncrement(start,stop,count);if(step===prestep||step===0||!isFinite(step)){return[start,stop]}else if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step}prestep=step}}function sturges(values){return Math.ceil(Math.log(count(values))/Math.LN2)+1}function bin(){var value=identity,domain=extent,threshold=sturges;function histogram(data){if(!Array.isArray(data))data=Array.from(data);var i,n=data.length,x,values=new Array(n);for(i=0;i<n;++i){values[i]=value(data[i],i,data)}var xz=domain(values),x0=xz[0],x1=xz[1],tz=threshold(values,x0,x1);if(!Array.isArray(tz)){tz=+tz;if(domain===extent)[x0,x1]=nice(x0,x1,tz);tz=ticks(x0,x1,tz);if(tz[tz.length-1]===x1)tz.pop()}var m=tz.length;while(tz[0]<=x0)tz.shift(),--m;while(tz[m-1]>x1)tz.pop(),--m;var bins=new Array(m+1),bin;for(i=0;i<=m;++i){bin=bins[i]=[];bin.x0=i>0?tz[i-1]:x0;bin.x1=i<m?tz[i]:x1}for(i=0;i<n;++i){x=values[i];if(x0<=x&&x<=x1){bins[bisectRight(tz,x,0,m)].push(data[i])}}return bins}histogram.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(_),histogram):value};histogram.domain=function(_){return arguments.length?(domain=typeof _==="function"?_:constant([_[0],_[1]]),histogram):domain};histogram.thresholds=function(_){return arguments.length?(threshold=typeof _==="function"?_:Array.isArray(_)?constant(slice.call(_)):constant(_),histogram):threshold};return histogram}function max(values,valueof){let max;if(valueof===undefined){for(const value of values){if(value!=null&&(max<value||max===undefined&&value>=value)){max=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value}}}return max}function min(values,valueof){let min;if(valueof===undefined){for(const value of values){if(value!=null&&(min>value||min===undefined&&value>=value)){min=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value}}}return min}function quickselect(array,k,left=0,right=array.length-1,compare=ascending){while(right>left){if(right-left>600){const n=right-left+1;const m=k-left+1;const z=Math.log(n);const s=.5*Math.exp(2*z/3);const sd=.5*Math.sqrt(z*s*(n-s)/n)*(m-n/2<0?-1:1);const newLeft=Math.max(left,Math.floor(k-m*s/n+sd));const newRight=Math.min(right,Math.floor(k+(n-m)*s/n+sd));quickselect(array,k,newLeft,newRight,compare)}const t=array[k];let i=left;let j=right;swap(array,left,k);if(compare(array[right],t)>0)swap(array,left,right);while(i<j){swap(array,i,j),++i,--j;while(compare(array[i],t)<0)++i;while(compare(array[j],t)>0)--j}if(compare(array[left],t)===0)swap(array,left,j);else++j,swap(array,j,right);if(j<=k)left=j+1;if(k<=j)right=j-1}return array}function swap(array,i,j){const t=array[i];array[i]=array[j];array[j]=t}function quantile(values,p,valueof){values=Float64Array.from(numbers(values,valueof));if(!(n=values.length))return;if((p=+p)<=0||n<2)return min(values);if(p>=1)return max(values);var n,i=(n-1)*p,i0=Math.floor(i),value0=max(quickselect(values,i0).subarray(0,i0+1)),value1=min(values.subarray(i0+1));return value0+(value1-value0)*(i-i0)}function quantileSorted(values,p,valueof=number){if(!(n=values.length))return;if((p=+p)<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function freedmanDiaconis(values,min,max){return Math.ceil((max-min)/(2*(quantile(values,.75)-quantile(values,.25))*Math.pow(count(values),-1/3)))}function scott(values,min,max){return Math.ceil((max-min)/(3.5*deviation(values)*Math.pow(count(values),-1/3)))}function maxIndex(values,valueof){let max;let maxIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value,maxIndex=index}}}return maxIndex}function mean(values,valueof){let count=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){++count,sum+=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){++count,sum+=value}}}if(count)return sum/count}function median(values,valueof){return quantile(values,.5,valueof)}function*flatten(arrays){for(const array of arrays){yield*array}}function merge(arrays){return Array.from(flatten(arrays))}function minIndex(values,valueof){let min;let minIndex=-1;let index=-1;if(valueof===undefined){for(const value of values){++index;if(value!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}else{for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value,minIndex=index}}}return minIndex}function pairs(values,pairof=pair){const pairs=[];let previous;let first=false;for(const value of values){if(first)pairs.push(pairof(previous,value));previous=value;first=true}return pairs}function pair(a,b){return[a,b]}function permute(source,keys){return Array.from(keys,key=>source[key])}function range(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}function least(values,compare=ascending){let min;let defined=false;if(compare.length===1){let minValue;for(const element of values){const value=compare(element);if(defined?ascending(value,minValue)<0:ascending(value,value)===0){min=element;minValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,min)<0:compare(value,value)===0){min=value;defined=true}}}return min}function leastIndex(values,compare=ascending){if(compare.length===1)return minIndex(values,compare);let minValue;let min=-1;let index=-1;for(const value of values){++index;if(min<0?compare(value,value)===0:compare(value,minValue)<0){minValue=value;min=index}}return min}function greatest(values,compare=ascending){let max;let defined=false;if(compare.length===1){let maxValue;for(const element of values){const value=compare(element);if(defined?ascending(value,maxValue)>0:ascending(value,value)===0){max=element;maxValue=value;defined=true}}}else{for(const value of values){if(defined?compare(value,max)>0:compare(value,value)===0){max=value;defined=true}}}return max}function greatestIndex(values,compare=ascending){if(compare.length===1)return maxIndex(values,compare);let maxValue;let max=-1;let index=-1;for(const value of values){++index;if(max<0?compare(value,value)===0:compare(value,maxValue)>0){maxValue=value;max=index}}return max}function scan(values,compare){const index=leastIndex(values,compare);return index<0?undefined:index}var shuffle=shuffler(Math.random);function shuffler(random){return function shuffle(array,i0=0,i1=array.length){let m=i1-(i0=+i0);while(m){const i=random()*m--|0,t=array[m+i0];array[m+i0]=array[i+i0];array[i+i0]=t}return array}}function sum(values,valueof){let sum=0;if(valueof===undefined){for(let value of values){if(value=+value){sum+=value}}}else{let index=-1;for(let value of values){if(value=+valueof(value,++index,values)){sum+=value}}}return sum}function transpose(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=min(matrix,length$1),transpose=new Array(m);++i<m;){for(var j=-1,n,row=transpose[i]=new Array(n);++j<n;){row[j]=matrix[j][i]}}return transpose}function length$1(d){return d.length}function zip(){return transpose(arguments)}function every(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(!test(value,++index,values)){return false}}return true}function some(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");let index=-1;for(const value of values){if(test(value,++index,values)){return true}}return false}function filter(values,test){if(typeof test!=="function")throw new TypeError("test is not a function");const array=[];let index=-1;for(const value of values){if(test(value,++index,values)){array.push(value)}}return array}function map(values,mapper){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");if(typeof mapper!=="function")throw new TypeError("mapper is not a function");return Array.from(values,(value,index)=>mapper(value,index,values))}function reduce(values,reducer,value){if(typeof reducer!=="function")throw new TypeError("reducer is not a function");const iterator=values[Symbol.iterator]();let done,next,index=-1;if(arguments.length<3){({done:done,value:value}=iterator.next());if(done)return;++index}while(({done:done,value:next}=iterator.next()),!done){value=reducer(value,next,++index,values)}return value}function reverse(values){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).reverse()}function sort(values,comparator=ascending){if(typeof values[Symbol.iterator]!=="function")throw new TypeError("values is not iterable");return Array.from(values).sort(comparator)}function difference(values,...others){values=new Set(values);for(const other of others){for(const value of other){values.delete(value)}}return values}function disjoint(values,other){const iterator=other[Symbol.iterator](),set=new Set;for(const v of values){if(set.has(v))return false;let value,done;while(({value:value,done:done}=iterator.next())){if(done)break;if(Object.is(v,value))return false;set.add(value)}}return true}function set(values){return values instanceof Set?values:new Set(values)}function intersection(values,...others){values=new Set(values);others=others.map(set);out:for(const value of values){for(const other of others){if(!other.has(value)){values.delete(value);continue out}}}return values}function superset(values,other){const iterator=values[Symbol.iterator](),set=new Set;for(const o of other){if(set.has(o))continue;let value,done;while(({value:value,done:done}=iterator.next())){if(done)return false;set.add(value);if(Object.is(o,value))break}}return true}function subset(values,other){return superset(other,values)}function union(...others){const set=new Set;for(const other of others){for(const o of other){set.add(o)}}return set}exports.Adder=Adder;exports.ascending=ascending;exports.bin=bin;exports.bisect=bisectRight;exports.bisectCenter=bisectCenter;exports.bisectLeft=bisectLeft;exports.bisectRight=bisectRight;exports.bisector=bisector;exports.count=count;exports.cross=cross;exports.cumsum=cumsum;exports.descending=descending;exports.deviation=deviation;exports.difference=difference;exports.disjoint=disjoint;exports.every=every;exports.extent=extent;exports.filter=filter;exports.fsum=fsum;exports.greatest=greatest;exports.greatestIndex=greatestIndex;exports.group=group;exports.groups=groups;exports.histogram=bin;exports.index=index;exports.indexes=indexes;exports.intersection=intersection;exports.least=least;exports.leastIndex=leastIndex;exports.map=map;exports.max=max;exports.maxIndex=maxIndex;exports.mean=mean;exports.median=median;exports.merge=merge;exports.min=min;exports.minIndex=minIndex;exports.nice=nice;exports.pairs=pairs;exports.permute=permute;exports.quantile=quantile;exports.quantileSorted=quantileSorted;exports.quickselect=quickselect;exports.range=range;exports.reduce=reduce;exports.reverse=reverse;exports.rollup=rollup;exports.rollups=rollups;exports.scan=scan;exports.shuffle=shuffle;exports.shuffler=shuffler;exports.some=some;exports.sort=sort;exports.subset=subset;exports.sum=sum;exports.superset=superset;exports.thresholdFreedmanDiaconis=freedmanDiaconis;exports.thresholdScott=scott;exports.thresholdSturges=sturges;exports.tickIncrement=tickIncrement;exports.tickStep=tickStep;exports.ticks=ticks;exports.transpose=transpose;exports.union=union;exports.variance=variance;exports.zip=zip;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var t0=new Date,t1=new Date;function newInterval(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=function(date){return floori(date=new Date(+date)),date};interval.ceil=function(date){return floori(date=new Date(date-1)),offseti(date,1),floori(date),date};interval.round=function(date){var d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=function(date,step){return offseti(date=new Date(+date),step==null?1:Math.floor(step)),date};interval.range=function(start,stop,step){var range=[],previous;start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=function(test){return newInterval((function(date){if(date>=date)while(floori(date),!test(date))date.setTime(date-1)}),(function(date,step){if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,+1),!test(date)){}}}}))};if(count){interval.count=function(start,end){t0.setTime(+start),t1.setTime(+end);floori(t0),floori(t1);return Math.floor(count(t0,t1))};interval.every=function(step){step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?function(d){return field(d)%step===0}:function(d){return interval.count(0,d)%step===0})}}return interval}var millisecond=newInterval((function(){}),(function(date,step){date.setTime(+date+step)}),(function(start,end){return end-start}));millisecond.every=function(k){k=Math.floor(k);if(!isFinite(k)||!(k>0))return null;if(!(k>1))return millisecond;return newInterval((function(date){date.setTime(Math.floor(date/k)*k)}),(function(date,step){date.setTime(+date+step*k)}),(function(start,end){return(end-start)/k}))};var milliseconds=millisecond.range;var durationSecond=1e3;var durationMinute=6e4;var durationHour=36e5;var durationDay=864e5;var durationWeek=6048e5;var second=newInterval((function(date){date.setTime(date-date.getMilliseconds())}),(function(date,step){date.setTime(+date+step*durationSecond)}),(function(start,end){return(end-start)/durationSecond}),(function(date){return date.getUTCSeconds()}));var seconds=second.range;var minute=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getMinutes()}));var minutes=minute.range;var hour=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond-date.getMinutes()*durationMinute)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getHours()}));var hours=hour.range;var day=newInterval(date=>date.setHours(0,0,0,0),(date,step)=>date.setDate(date.getDate()+step),(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationDay,date=>date.getDate()-1);var days=day.range;function weekday(i){return newInterval((function(date){date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+step*7)}),(function(start,end){return(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationWeek}))}var sunday=weekday(0);var monday=weekday(1);var tuesday=weekday(2);var wednesday=weekday(3);var thursday=weekday(4);var friday=weekday(5);var saturday=weekday(6);var sundays=sunday.range;var mondays=monday.range;var tuesdays=tuesday.range;var wednesdays=wednesday.range;var thursdays=thursday.range;var fridays=friday.range;var saturdays=saturday.range;var month=newInterval((function(date){date.setDate(1);date.setHours(0,0,0,0)}),(function(date,step){date.setMonth(date.getMonth()+step)}),(function(start,end){return end.getMonth()-start.getMonth()+(end.getFullYear()-start.getFullYear())*12}),(function(date){return date.getMonth()}));var months=month.range;var year=newInterval((function(date){date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step)}),(function(start,end){return end.getFullYear()-start.getFullYear()}),(function(date){return date.getFullYear()}));year.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step*k)}))};var years=year.range;var utcMinute=newInterval((function(date){date.setUTCSeconds(0,0)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getUTCMinutes()}));var utcMinutes=utcMinute.range;var utcHour=newInterval((function(date){date.setUTCMinutes(0,0,0)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getUTCHours()}));var utcHours=utcHour.range;var utcDay=newInterval((function(date){date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step)}),(function(start,end){return(end-start)/durationDay}),(function(date){return date.getUTCDate()-1}));var utcDays=utcDay.range;function utcWeekday(i){return newInterval((function(date){date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step*7)}),(function(start,end){return(end-start)/durationWeek}))}var utcSunday=utcWeekday(0);var utcMonday=utcWeekday(1);var utcTuesday=utcWeekday(2);var utcWednesday=utcWeekday(3);var utcThursday=utcWeekday(4);var utcFriday=utcWeekday(5);var utcSaturday=utcWeekday(6);var utcSundays=utcSunday.range;var utcMondays=utcMonday.range;var utcTuesdays=utcTuesday.range;var utcWednesdays=utcWednesday.range;var utcThursdays=utcThursday.range;var utcFridays=utcFriday.range;var utcSaturdays=utcSaturday.range;var utcMonth=newInterval((function(date){date.setUTCDate(1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCMonth(date.getUTCMonth()+step)}),(function(start,end){return end.getUTCMonth()-start.getUTCMonth()+(end.getUTCFullYear()-start.getUTCFullYear())*12}),(function(date){return date.getUTCMonth()}));var utcMonths=utcMonth.range;var utcYear=newInterval((function(date){date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step)}),(function(start,end){return end.getUTCFullYear()-start.getUTCFullYear()}),(function(date){return date.getUTCFullYear()}));utcYear.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step*k)}))};var utcYears=utcYear.range;exports.timeDay=day;exports.timeDays=days;exports.timeFriday=friday;exports.timeFridays=fridays;exports.timeHour=hour;exports.timeHours=hours;exports.timeInterval=newInterval;exports.timeMillisecond=millisecond;exports.timeMilliseconds=milliseconds;exports.timeMinute=minute;exports.timeMinutes=minutes;exports.timeMonday=monday;exports.timeMondays=mondays;exports.timeMonth=month;exports.timeMonths=months;exports.timeSaturday=saturday;exports.timeSaturdays=saturdays;exports.timeSecond=second;exports.timeSeconds=seconds;exports.timeSunday=sunday;exports.timeSundays=sundays;exports.timeThursday=thursday;exports.timeThursdays=thursdays;exports.timeTuesday=tuesday;exports.timeTuesdays=tuesdays;exports.timeWednesday=wednesday;exports.timeWednesdays=wednesdays;exports.timeWeek=sunday;exports.timeWeeks=sundays;exports.timeYear=year;exports.timeYears=years;exports.utcDay=utcDay;exports.utcDays=utcDays;exports.utcFriday=utcFriday;exports.utcFridays=utcFridays;exports.utcHour=utcHour;exports.utcHours=utcHours;exports.utcMillisecond=millisecond;exports.utcMilliseconds=milliseconds;exports.utcMinute=utcMinute;exports.utcMinutes=utcMinutes;exports.utcMonday=utcMonday;exports.utcMondays=utcMondays;exports.utcMonth=utcMonth;exports.utcMonths=utcMonths;exports.utcSaturday=utcSaturday;exports.utcSaturdays=utcSaturdays;exports.utcSecond=second;exports.utcSeconds=seconds;exports.utcSunday=utcSunday;exports.utcSundays=utcSundays;exports.utcThursday=utcThursday;exports.utcThursdays=utcThursdays;exports.utcTuesday=utcTuesday;exports.utcTuesdays=utcTuesdays;exports.utcWednesday=utcWednesday;exports.utcWednesdays=utcWednesdays;exports.utcWeek=utcSunday;exports.utcWeeks=utcSundays;exports.utcYear=utcYear;exports.utcYears=utcYears;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(36),__webpack_require__(39),__webpack_require__(43),__webpack_require__(96),__webpack_require__(47)):undefined})(this,(function(exports,vegaUtil,vegaDataflow,vegaStatistics,d3Array,vegaTime){"use strict";function multikey(f){return x=>{const n=f.length;let i=1,k=String(f[0](x));for(;i<n;++i){k+="|"+f[i](x)}return k}}function groupkey(fields){return!fields||!fields.length?function(){return""}:fields.length===1?fields[0]:multikey(fields)}function measureName(op,field,as){return as||op+(!field?"":"_"+field)}const noop=()=>{};const base_op={init:noop,add:noop,rem:noop,idx:0};const AggregateOps={values:{init:m=>m.cell.store=true,value:m=>m.cell.data.values(),idx:-1},count:{value:m=>m.cell.num},__count__:{value:m=>m.missing+m.valid},missing:{value:m=>m.missing},valid:{value:m=>m.valid},sum:{init:m=>m.sum=0,value:m=>m.sum,add:(m,v)=>m.sum+=+v,rem:(m,v)=>m.sum-=v},product:{init:m=>m.product=1,value:m=>m.valid?m.product:undefined,add:(m,v)=>m.product*=v,rem:(m,v)=>m.product/=v},mean:{init:m=>m.mean=0,value:m=>m.valid?m.mean:undefined,add:(m,v)=>(m.mean_d=v-m.mean,m.mean+=m.mean_d/m.valid),rem:(m,v)=>(m.mean_d=v-m.mean,m.mean-=m.valid?m.mean_d/m.valid:m.mean)},average:{value:m=>m.valid?m.mean:undefined,req:["mean"],idx:1},variance:{init:m=>m.dev=0,value:m=>m.valid>1?m.dev/(m.valid-1):undefined,add:(m,v)=>m.dev+=m.mean_d*(v-m.mean),rem:(m,v)=>m.dev-=m.mean_d*(v-m.mean),req:["mean"],idx:1},variancep:{value:m=>m.valid>1?m.dev/m.valid:undefined,req:["variance"],idx:2},stdev:{value:m=>m.valid>1?Math.sqrt(m.dev/(m.valid-1)):undefined,req:["variance"],idx:2},stdevp:{value:m=>m.valid>1?Math.sqrt(m.dev/m.valid):undefined,req:["variance"],idx:2},stderr:{value:m=>m.valid>1?Math.sqrt(m.dev/(m.valid*(m.valid-1))):undefined,req:["variance"],idx:2},distinct:{value:m=>m.cell.data.distinct(m.get),req:["values"],idx:3},ci0:{value:m=>m.cell.data.ci0(m.get),req:["values"],idx:3},ci1:{value:m=>m.cell.data.ci1(m.get),req:["values"],idx:3},median:{value:m=>m.cell.data.q2(m.get),req:["values"],idx:3},q1:{value:m=>m.cell.data.q1(m.get),req:["values"],idx:3},q3:{value:m=>m.cell.data.q3(m.get),req:["values"],idx:3},min:{init:m=>m.min=undefined,value:m=>m.min=Number.isNaN(m.min)?m.cell.data.min(m.get):m.min,add:(m,v)=>{if(v<m.min||m.min===undefined)m.min=v},rem:(m,v)=>{if(v<=m.min)m.min=NaN},req:["values"],idx:4},max:{init:m=>m.max=undefined,value:m=>m.max=Number.isNaN(m.max)?m.cell.data.max(m.get):m.max,add:(m,v)=>{if(v>m.max||m.max===undefined)m.max=v},rem:(m,v)=>{if(v>=m.max)m.max=NaN},req:["values"],idx:4},argmin:{init:m=>m.argmin=undefined,value:m=>m.argmin||m.cell.data.argmin(m.get),add:(m,v,t)=>{if(v<m.min)m.argmin=t},rem:(m,v)=>{if(v<=m.min)m.argmin=undefined},req:["min","values"],idx:3},argmax:{init:m=>m.argmax=undefined,value:m=>m.argmax||m.cell.data.argmax(m.get),add:(m,v,t)=>{if(v>m.max)m.argmax=t},rem:(m,v)=>{if(v>=m.max)m.argmax=undefined},req:["max","values"],idx:3}};const ValidAggregateOps=Object.keys(AggregateOps);function measure(key,value){return out=>vegaUtil.extend({name:key,out:out||key},base_op,value)}ValidAggregateOps.forEach(key=>{AggregateOps[key]=measure(key,AggregateOps[key])});function createMeasure(op,name){return AggregateOps[op](name)}function compareIndex(a,b){return a.idx-b.idx}function resolve(agg){const map={};agg.forEach(a=>map[a.name]=a);const getreqs=a=>{if(!a.req)return;a.req.forEach(key=>{if(!map[key])getreqs(map[key]=AggregateOps[key]())})};agg.forEach(getreqs);return Object.values(map).sort(compareIndex)}function init(){this.valid=0;this.missing=0;this._ops.forEach(op=>op.init(this))}function add(v,t){if(v==null||v===""){++this.missing;return}if(v!==v)return;++this.valid;this._ops.forEach(op=>op.add(this,v,t))}function rem(v,t){if(v==null||v===""){--this.missing;return}if(v!==v)return;--this.valid;this._ops.forEach(op=>op.rem(this,v,t))}function set(t){this._out.forEach(op=>t[op.out]=op.value(this));return t}function compileMeasures(agg,field){const get=field||vegaUtil.identity,ops=resolve(agg),out=agg.slice().sort(compareIndex);function ctr(cell){this._ops=ops;this._out=out;this.cell=cell;this.init()}ctr.prototype.init=init;ctr.prototype.add=add;ctr.prototype.rem=rem;ctr.prototype.set=set;ctr.prototype.get=get;ctr.fields=agg.map(op=>op.out);return ctr}function TupleStore(key){this._key=key?vegaUtil.field(key):vegaDataflow.tupleid;this.reset()}const prototype=TupleStore.prototype;prototype.reset=function(){this._add=[];this._rem=[];this._ext=null;this._get=null;this._q=null};prototype.add=function(v){this._add.push(v)};prototype.rem=function(v){this._rem.push(v)};prototype.values=function(){this._get=null;if(this._rem.length===0)return this._add;const a=this._add,r=this._rem,k=this._key,n=a.length,m=r.length,x=Array(n-m),map={};let i,j,v;for(i=0;i<m;++i){map[k(r[i])]=1}for(i=0,j=0;i<n;++i){if(map[k(v=a[i])]){map[k(v)]=0}else{x[j++]=v}}this._rem=[];return this._add=x};prototype.distinct=function(get){const v=this.values(),map={};let n=v.length,count=0,s;while(--n>=0){s=get(v[n])+"";if(!vegaUtil.hasOwnProperty(map,s)){map[s]=1;++count}}return count};prototype.extent=function(get){if(this._get!==get||!this._ext){const v=this.values(),i=vegaUtil.extentIndex(v,get);this._ext=[v[i[0]],v[i[1]]];this._get=get}return this._ext};prototype.argmin=function(get){return this.extent(get)[0]||{}};prototype.argmax=function(get){return this.extent(get)[1]||{}};prototype.min=function(get){const m=this.extent(get)[0];return m!=null?get(m):undefined};prototype.max=function(get){const m=this.extent(get)[1];return m!=null?get(m):undefined};prototype.quartile=function(get){if(this._get!==get||!this._q){this._q=vegaStatistics.quartiles(this.values(),get);this._get=get}return this._q};prototype.q1=function(get){return this.quartile(get)[0]};prototype.q2=function(get){return this.quartile(get)[1]};prototype.q3=function(get){return this.quartile(get)[2]};prototype.ci=function(get){if(this._get!==get||!this._ci){this._ci=vegaStatistics.bootstrapCI(this.values(),1e3,.05,get);this._get=get}return this._ci};prototype.ci0=function(get){return this.ci(get)[0]};prototype.ci1=function(get){return this.ci(get)[1]};function Aggregate(params){vegaDataflow.Transform.call(this,null,params);this._adds=[];this._mods=[];this._alen=0;this._mlen=0;this._drop=true;this._cross=false;this._dims=[];this._dnames=[];this._measures=[];this._countOnly=false;this._counts=null;this._prev=null;this._inputs=null;this._outputs=null}Aggregate.Definition={type:"Aggregate",metadata:{generates:true,changes:true},params:[{name:"groupby",type:"field",array:true},{name:"ops",type:"enum",array:true,values:ValidAggregateOps},{name:"fields",type:"field",null:true,array:true},{name:"as",type:"string",null:true,array:true},{name:"drop",type:"boolean",default:true},{name:"cross",type:"boolean",default:false},{name:"key",type:"field"}]};vegaUtil.inherits(Aggregate,vegaDataflow.Transform,{transform(_,pulse){const aggr=this,out=pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS),mod=_.modified();aggr.stamp=out.stamp;if(aggr.value&&(mod||pulse.modified(aggr._inputs,true))){aggr._prev=aggr.value;aggr.value=mod?aggr.init(_):{};pulse.visit(pulse.SOURCE,t=>aggr.add(t))}else{aggr.value=aggr.value||aggr.init(_);pulse.visit(pulse.REM,t=>aggr.rem(t));pulse.visit(pulse.ADD,t=>aggr.add(t))}out.modifies(aggr._outputs);aggr._drop=_.drop!==false;if(_.cross&&aggr._dims.length>1){aggr._drop=false;aggr.cross()}if(pulse.clean()&&aggr._drop){out.clean(true).runAfter(()=>this.clean())}return aggr.changes(out)},cross(){const aggr=this,curr=aggr.value,dims=aggr._dnames,vals=dims.map(()=>({})),n=dims.length;function collect(cells){let key,i,t,v;for(key in cells){t=cells[key].tuple;for(i=0;i<n;++i){vals[i][v=t[dims[i]]]=v}}}collect(aggr._prev);collect(curr);function generate(base,tuple,index){const name=dims[index],v=vals[index++];for(const k in v){const key=base?base+"|"+k:k;tuple[name]=v[k];if(index<n)generate(key,tuple,index);else if(!curr[key])aggr.cell(key,tuple)}}generate("",{},0)},init(_){const inputs=this._inputs=[],outputs=this._outputs=[],inputMap={};function inputVisit(get){const fields=vegaUtil.array(vegaUtil.accessorFields(get)),n=fields.length;let i=0,f;for(;i<n;++i){if(!inputMap[f=fields[i]]){inputMap[f]=1;inputs.push(f)}}}this._dims=vegaUtil.array(_.groupby);this._dnames=this._dims.map(d=>{const dname=vegaUtil.accessorName(d);inputVisit(d);outputs.push(dname);return dname});this.cellkey=_.key?_.key:groupkey(this._dims);this._countOnly=true;this._counts=[];this._measures=[];const fields=_.fields||[null],ops=_.ops||["count"],as=_.as||[],n=fields.length,map={};let field,op,m,mname,outname,i;if(n!==ops.length){vegaUtil.error("Unmatched number of fields and aggregate ops.")}for(i=0;i<n;++i){field=fields[i];op=ops[i];if(field==null&&op!=="count"){vegaUtil.error("Null aggregate field specified.")}mname=vegaUtil.accessorName(field);outname=measureName(op,mname,as[i]);outputs.push(outname);if(op==="count"){this._counts.push(outname);continue}m=map[mname];if(!m){inputVisit(field);m=map[mname]=[];m.field=field;this._measures.push(m)}if(op!=="count")this._countOnly=false;m.push(createMeasure(op,outname))}this._measures=this._measures.map(m=>compileMeasures(m,m.field));return{}},cellkey:groupkey(),cell(key,t){let cell=this.value[key];if(!cell){cell=this.value[key]=this.newcell(key,t);this._adds[this._alen++]=cell}else if(cell.num===0&&this._drop&&cell.stamp<this.stamp){cell.stamp=this.stamp;this._adds[this._alen++]=cell}else if(cell.stamp<this.stamp){cell.stamp=this.stamp;this._mods[this._mlen++]=cell}return cell},newcell(key,t){const cell={key:key,num:0,agg:null,tuple:this.newtuple(t,this._prev&&this._prev[key]),stamp:this.stamp,store:false};if(!this._countOnly){const measures=this._measures,n=measures.length;cell.agg=Array(n);for(let i=0;i<n;++i){cell.agg[i]=new measures[i](cell)}}if(cell.store){cell.data=new TupleStore}return cell},newtuple(t,p){const names=this._dnames,dims=this._dims,n=dims.length,x={};for(let i=0;i<n;++i){x[names[i]]=dims[i](t)}return p?vegaDataflow.replace(p.tuple,x):vegaDataflow.ingest(x)},clean(){const cells=this.value;for(const key in cells){if(cells[key].num===0){delete cells[key]}}},add(t){const key=this.cellkey(t),cell=this.cell(key,t);cell.num+=1;if(this._countOnly)return;if(cell.store)cell.data.add(t);const agg=cell.agg;for(let i=0,n=agg.length;i<n;++i){agg[i].add(agg[i].get(t),t)}},rem(t){const key=this.cellkey(t),cell=this.cell(key,t);cell.num-=1;if(this._countOnly)return;if(cell.store)cell.data.rem(t);const agg=cell.agg;for(let i=0,n=agg.length;i<n;++i){agg[i].rem(agg[i].get(t),t)}},celltuple(cell){const tuple=cell.tuple,counts=this._counts;if(cell.store){cell.data.values()}for(let i=0,n=counts.length;i<n;++i){tuple[counts[i]]=cell.num}if(!this._countOnly){const agg=cell.agg;for(let i=0,n=agg.length;i<n;++i){agg[i].set(tuple)}}return tuple},changes(out){const adds=this._adds,mods=this._mods,prev=this._prev,drop=this._drop,add=out.add,rem=out.rem,mod=out.mod;let cell,key,i,n;if(prev)for(key in prev){cell=prev[key];if(!drop||cell.num)rem.push(cell.tuple)}for(i=0,n=this._alen;i<n;++i){add.push(this.celltuple(adds[i]));adds[i]=null}for(i=0,n=this._mlen;i<n;++i){cell=mods[i];(cell.num===0&&drop?rem:mod).push(this.celltuple(cell));mods[i]=null}this._alen=this._mlen=0;this._prev=null;return out}});const EPSILON=1e-14;function Bin(params){vegaDataflow.Transform.call(this,null,params)}Bin.Definition={type:"Bin",metadata:{modifies:true},params:[{name:"field",type:"field",required:true},{name:"interval",type:"boolean",default:true},{name:"anchor",type:"number"},{name:"maxbins",type:"number",default:20},{name:"base",type:"number",default:10},{name:"divide",type:"number",array:true,default:[5,2]},{name:"extent",type:"number",array:true,length:2,required:true},{name:"span",type:"number"},{name:"step",type:"number"},{name:"steps",type:"number",array:true},{name:"minstep",type:"number",default:0},{name:"nice",type:"boolean",default:true},{name:"name",type:"string"},{name:"as",type:"string",array:true,length:2,default:["bin0","bin1"]}]};vegaUtil.inherits(Bin,vegaDataflow.Transform,{transform(_,pulse){const band=_.interval!==false,bins=this._bins(_),start=bins.start,step=bins.step,as=_.as||["bin0","bin1"],b0=as[0],b1=as[1];let flag;if(_.modified()){pulse=pulse.reflow(true);flag=pulse.SOURCE}else{flag=pulse.modified(vegaUtil.accessorFields(_.field))?pulse.ADD_MOD:pulse.ADD}pulse.visit(flag,band?t=>{const v=bins(t);t[b0]=v;t[b1]=v==null?null:start+step*(1+(v-start)/step)}:t=>t[b0]=bins(t));return pulse.modifies(band?as:b0)},_bins(_){if(this.value&&!_.modified()){return this.value}const field=_.field,bins=vegaStatistics.bin(_),step=bins.step;let start=bins.start,stop=start+Math.ceil((bins.stop-start)/step)*step,a,d;if((a=_.anchor)!=null){d=a-(start+step*Math.floor((a-start)/step));start+=d;stop+=d}const f=function(t){let v=vegaUtil.toNumber(field(t));return v==null?null:v<start?-Infinity:v>stop?+Infinity:(v=Math.max(start,Math.min(v,stop-step)),start+step*Math.floor(EPSILON+(v-start)/step))};f.start=start;f.stop=bins.stop;f.step=step;return this.value=vegaUtil.accessor(f,vegaUtil.accessorFields(field),_.name||"bin_"+vegaUtil.accessorName(field))}});function SortedList(idFunc,source,input){const $=idFunc;let data=source||[],add=input||[],rem={},cnt=0;return{add:t=>add.push(t),remove:t=>rem[$(t)]=++cnt,size:()=>data.length,data:(compare,resort)=>{if(cnt){data=data.filter(t=>!rem[$(t)]);rem={};cnt=0}if(resort&&compare){data.sort(compare)}if(add.length){data=compare?vegaUtil.merge(compare,data,add.sort(compare)):data.concat(add);add=[]}return data}}}function Collect(params){vegaDataflow.Transform.call(this,[],params)}Collect.Definition={type:"Collect",metadata:{source:true},params:[{name:"sort",type:"compare"}]};vegaUtil.inherits(Collect,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.ALL),list=SortedList(vegaDataflow.tupleid,this.value,out.materialize(out.ADD).add),sort=_.sort,mod=pulse.changed()||sort&&(_.modified("sort")||pulse.modified(sort.fields));out.visit(out.REM,list.remove);this.modified(mod);this.value=out.source=list.data(vegaDataflow.stableCompare(sort),mod);if(pulse.source&&pulse.source.root){this.value.root=pulse.source.root}return out}});function Compare(params){vegaDataflow.Operator.call(this,null,update,params)}vegaUtil.inherits(Compare,vegaDataflow.Operator);function update(_){return this.value&&!_.modified()?this.value:vegaUtil.compare(_.fields,_.orders)}function CountPattern(params){vegaDataflow.Transform.call(this,null,params)}CountPattern.Definition={type:"CountPattern",metadata:{generates:true,changes:true},params:[{name:"field",type:"field",required:true},{name:"case",type:"enum",values:["upper","lower","mixed"],default:"mixed"},{name:"pattern",type:"string",default:'[\\w"]+'},{name:"stopwords",type:"string",default:""},{name:"as",type:"string",array:true,length:2,default:["text","count"]}]};function tokenize(text,tcase,match){switch(tcase){case"upper":text=text.toUpperCase();break;case"lower":text=text.toLowerCase();break}return text.match(match)}vegaUtil.inherits(CountPattern,vegaDataflow.Transform,{transform(_,pulse){const process=update=>tuple=>{var tokens=tokenize(get(tuple),_.case,match)||[],t;for(var i=0,n=tokens.length;i<n;++i){if(!stop.test(t=tokens[i]))update(t)}};const init=this._parameterCheck(_,pulse),counts=this._counts,match=this._match,stop=this._stop,get=_.field,as=_.as||["text","count"],add=process(t=>counts[t]=1+(counts[t]||0)),rem=process(t=>counts[t]-=1);if(init){pulse.visit(pulse.SOURCE,add)}else{pulse.visit(pulse.ADD,add);pulse.visit(pulse.REM,rem)}return this._finish(pulse,as)},_parameterCheck(_,pulse){let init=false;if(_.modified("stopwords")||!this._stop){this._stop=new RegExp("^"+(_.stopwords||"")+"$","i");init=true}if(_.modified("pattern")||!this._match){this._match=new RegExp(_.pattern||"[\\w']+","g");init=true}if(_.modified("field")||pulse.modified(_.field.fields)){init=true}if(init)this._counts={};return init},_finish(pulse,as){const counts=this._counts,tuples=this._tuples||(this._tuples={}),text=as[0],count=as[1],out=pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS);let w,t,c;for(w in counts){t=tuples[w];c=counts[w]||0;if(!t&&c){tuples[w]=t=vegaDataflow.ingest({});t[text]=w;t[count]=c;out.add.push(t)}else if(c===0){if(t)out.rem.push(t);counts[w]=null;tuples[w]=null}else if(t[count]!==c){t[count]=c;out.mod.push(t)}}return out.modifies(as)}});function Cross(params){vegaDataflow.Transform.call(this,null,params)}Cross.Definition={type:"Cross",metadata:{generates:true},params:[{name:"filter",type:"expr"},{name:"as",type:"string",array:true,length:2,default:["a","b"]}]};vegaUtil.inherits(Cross,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE),as=_.as||["a","b"],a=as[0],b=as[1],reset=!this.value||pulse.changed(pulse.ADD_REM)||_.modified("as")||_.modified("filter");let data=this.value;if(reset){if(data)out.rem=data;data=pulse.materialize(pulse.SOURCE).source;out.add=this.value=cross(data,a,b,_.filter||vegaUtil.truthy)}else{out.mod=data}out.source=this.value;return out.modifies(as)}});function cross(input,a,b,filter){var data=[],t={},n=input.length,i=0,j,left;for(;i<n;++i){t[a]=left=input[i];for(j=0;j<n;++j){t[b]=input[j];if(filter(t)){data.push(vegaDataflow.ingest(t));t={};t[a]=left}}}return data}const Distributions={kde:vegaStatistics.randomKDE,mixture:vegaStatistics.randomMixture,normal:vegaStatistics.randomNormal,lognormal:vegaStatistics.randomLogNormal,uniform:vegaStatistics.randomUniform};const DISTRIBUTIONS="distributions",FUNCTION="function",FIELD="field";function parse(def,data){const func=def[FUNCTION];if(!vegaUtil.hasOwnProperty(Distributions,func)){vegaUtil.error("Unknown distribution function: "+func)}const d=Distributions[func]();for(const name in def){if(name===FIELD){d.data((def.from||data()).map(def[name]))}else if(name===DISTRIBUTIONS){d[name](def[name].map(_=>parse(_,data)))}else if(typeof d[name]===FUNCTION){d[name](def[name])}}return d}function Density(params){vegaDataflow.Transform.call(this,null,params)}const distributions=[{key:{function:"normal"},params:[{name:"mean",type:"number",default:0},{name:"stdev",type:"number",default:1}]},{key:{function:"lognormal"},params:[{name:"mean",type:"number",default:0},{name:"stdev",type:"number",default:1}]},{key:{function:"uniform"},params:[{name:"min",type:"number",default:0},{name:"max",type:"number",default:1}]},{key:{function:"kde"},params:[{name:"field",type:"field",required:true},{name:"from",type:"data"},{name:"bandwidth",type:"number",default:0}]}];const mixture={key:{function:"mixture"},params:[{name:"distributions",type:"param",array:true,params:distributions},{name:"weights",type:"number",array:true}]};Density.Definition={type:"Density",metadata:{generates:true},params:[{name:"extent",type:"number",array:true,length:2},{name:"steps",type:"number"},{name:"minsteps",type:"number",default:25},{name:"maxsteps",type:"number",default:200},{name:"method",type:"string",default:"pdf",values:["pdf","cdf"]},{name:"distribution",type:"param",params:distributions.concat(mixture)},{name:"as",type:"string",array:true,default:["value","density"]}]};vegaUtil.inherits(Density,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS);if(!this.value||pulse.changed()||_.modified()){const dist=parse(_.distribution,source(pulse)),minsteps=_.steps||_.minsteps||25,maxsteps=_.steps||_.maxsteps||200;let method=_.method||"pdf";if(method!=="pdf"&&method!=="cdf"){vegaUtil.error("Invalid density method: "+method)}if(!_.extent&&!dist.data){vegaUtil.error("Missing density extent parameter.")}method=dist[method];const as=_.as||["value","density"],domain=_.extent||vegaUtil.extent(dist.data()),values=vegaStatistics.sampleCurve(method,domain,minsteps,maxsteps).map(v=>{const tuple={};tuple[as[0]]=v[0];tuple[as[1]]=v[1];return vegaDataflow.ingest(tuple)});if(this.value)out.rem=this.value;this.value=out.add=out.source=values}return out}});function source(pulse){return()=>pulse.materialize(pulse.SOURCE).source}function fieldNames(fields,as){if(!fields)return null;return fields.map((f,i)=>as[i]||vegaUtil.accessorName(f))}function partition(data,groupby,field){const groups=[],get=f=>f(t);let map,i,n,t,k,g;if(groupby==null){groups.push(data.map(field))}else{for(map={},i=0,n=data.length;i<n;++i){t=data[i];k=groupby.map(get);g=map[k];if(!g){map[k]=g=[];g.dims=k;groups.push(g)}g.push(field(t))}}return groups}const Output="bin";function DotBin(params){vegaDataflow.Transform.call(this,null,params)}DotBin.Definition={type:"DotBin",metadata:{modifies:true},params:[{name:"field",type:"field",required:true},{name:"groupby",type:"field",array:true},{name:"step",type:"number"},{name:"smooth",type:"boolean",default:false},{name:"as",type:"string",default:Output}]};const autostep=(data,field)=>vegaUtil.span(vegaUtil.extent(data,field))/30;vegaUtil.inherits(DotBin,vegaDataflow.Transform,{transform(_,pulse){if(this.value&&!(_.modified()||pulse.changed())){return pulse}const source=pulse.materialize(pulse.SOURCE).source,groups=partition(pulse.source,_.groupby,vegaUtil.identity),smooth=_.smooth||false,field=_.field,step=_.step||autostep(source,field),sort=vegaDataflow.stableCompare((a,b)=>field(a)-field(b)),as=_.as||Output,n=groups.length;let min=Infinity,max=-Infinity,i=0,j;for(;i<n;++i){const g=groups[i].sort(sort);j=-1;for(const v of vegaStatistics.dotbin(g,step,smooth,field)){if(v<min)min=v;if(v>max)max=v;g[++j][as]=v}}this.value={start:min,stop:max,step:step};return pulse.reflow(true).modifies(as)}});function Expression(params){vegaDataflow.Operator.call(this,null,update$1,params);this.modified(true)}vegaUtil.inherits(Expression,vegaDataflow.Operator);function update$1(_){const expr=_.expr;return this.value&&!_.modified("expr")?this.value:vegaUtil.accessor(datum=>expr(datum,_),vegaUtil.accessorFields(expr),vegaUtil.accessorName(expr))}function Extent(params){vegaDataflow.Transform.call(this,[undefined,undefined],params)}Extent.Definition={type:"Extent",metadata:{},params:[{name:"field",type:"field",required:true}]};vegaUtil.inherits(Extent,vegaDataflow.Transform,{transform(_,pulse){const extent=this.value,field=_.field,mod=pulse.changed()||pulse.modified(field.fields)||_.modified("field");let min=extent[0],max=extent[1];if(mod||min==null){min=+Infinity;max=-Infinity}pulse.visit(mod?pulse.SOURCE:pulse.ADD,t=>{const v=vegaUtil.toNumber(field(t));if(v!=null){if(v<min)min=v;if(v>max)max=v}});if(!Number.isFinite(min)||!Number.isFinite(max)){let name=vegaUtil.accessorName(field);if(name)name=` for field "${name}"`;pulse.dataflow.warn(`Infinite extent${name}: [${min}, ${max}]`);min=max=undefined}this.value=[min,max]}});function Subflow(pulse,parent){vegaDataflow.Operator.call(this,pulse);this.parent=parent;this.count=0}vegaUtil.inherits(Subflow,vegaDataflow.Operator,{connect(target){this.detachSubflow=target.detachSubflow;this.targets().add(target);return target.source=this},add(t){this.count+=1;this.value.add.push(t)},rem(t){this.count-=1;this.value.rem.push(t)},mod(t){this.value.mod.push(t)},init(pulse){this.value.init(pulse,pulse.NO_SOURCE)},evaluate(){return this.value}});function Facet(params){vegaDataflow.Transform.call(this,{},params);this._keys=vegaUtil.fastmap();const a=this._targets=[];a.active=0;a.forEach=f=>{for(let i=0,n=a.active;i<n;++i){f(a[i],i,a)}}}vegaUtil.inherits(Facet,vegaDataflow.Transform,{activate(flow){this._targets[this._targets.active++]=flow},subflow(key,flow,pulse,parent){const flows=this.value;let sf=vegaUtil.hasOwnProperty(flows,key)&&flows[key],df,p;if(!sf){p=parent||(p=this._group[key])&&p.tuple;df=pulse.dataflow;sf=new Subflow(pulse.fork(pulse.NO_SOURCE),this);df.add(sf).connect(flow(df,key,p));flows[key]=sf;this.activate(sf)}else if(sf.value.stamp<pulse.stamp){sf.init(pulse);this.activate(sf)}return sf},clean(){const flows=this.value;for(const key in flows){if(flows[key].count===0){const detach=flows[key].detachSubflow;if(detach)detach();delete flows[key]}}},initTargets(){const a=this._targets,n=a.length;for(let i=0;i<n&&a[i]!=null;++i){a[i]=null}a.active=0},transform(_,pulse){const df=pulse.dataflow,key=_.key,flow=_.subflow,cache=this._keys,rekey=_.modified("key"),subflow=key=>this.subflow(key,flow,pulse);this._group=_.group||{};this.initTargets();pulse.visit(pulse.REM,t=>{const id=vegaDataflow.tupleid(t),k=cache.get(id);if(k!==undefined){cache.delete(id);subflow(k).rem(t)}});pulse.visit(pulse.ADD,t=>{const k=key(t);cache.set(vegaDataflow.tupleid(t),k);subflow(k).add(t)});if(rekey||pulse.modified(key.fields)){pulse.visit(pulse.MOD,t=>{const id=vegaDataflow.tupleid(t),k0=cache.get(id),k1=key(t);if(k0===k1){subflow(k1).mod(t)}else{cache.set(id,k1);subflow(k0).rem(t);subflow(k1).add(t)}})}else if(pulse.changed(pulse.MOD)){pulse.visit(pulse.MOD,t=>{subflow(cache.get(vegaDataflow.tupleid(t))).mod(t)})}if(rekey){pulse.visit(pulse.REFLOW,t=>{const id=vegaDataflow.tupleid(t),k0=cache.get(id),k1=key(t);if(k0!==k1){cache.set(id,k1);subflow(k0).rem(t);subflow(k1).add(t)}})}if(pulse.clean()){df.runAfter(()=>{this.clean();cache.clean()})}else if(cache.empty>df.cleanThreshold){df.runAfter(cache.clean)}return pulse}});function Field(params){vegaDataflow.Operator.call(this,null,update$2,params)}vegaUtil.inherits(Field,vegaDataflow.Operator);function update$2(_){return this.value&&!_.modified()?this.value:vegaUtil.isArray(_.name)?vegaUtil.array(_.name).map(f=>vegaUtil.field(f)):vegaUtil.field(_.name,_.as)}function Filter(params){vegaDataflow.Transform.call(this,vegaUtil.fastmap(),params)}Filter.Definition={type:"Filter",metadata:{changes:true},params:[{name:"expr",type:"expr",required:true}]};vegaUtil.inherits(Filter,vegaDataflow.Transform,{transform(_,pulse){const df=pulse.dataflow,cache=this.value,output=pulse.fork(),add=output.add,rem=output.rem,mod=output.mod,test=_.expr;let isMod=true;pulse.visit(pulse.REM,t=>{const id=vegaDataflow.tupleid(t);if(!cache.has(id))rem.push(t);else cache.delete(id)});pulse.visit(pulse.ADD,t=>{if(test(t,_))add.push(t);else cache.set(vegaDataflow.tupleid(t),1)});function revisit(t){const id=vegaDataflow.tupleid(t),b=test(t,_),s=cache.get(id);if(b&&s){cache.delete(id);add.push(t)}else if(!b&&!s){cache.set(id,1);rem.push(t)}else if(isMod&&b&&!s){mod.push(t)}}pulse.visit(pulse.MOD,revisit);if(_.modified()){isMod=false;pulse.visit(pulse.REFLOW,revisit)}if(cache.empty>df.cleanThreshold)df.runAfter(cache.clean);return output}});function Flatten(params){vegaDataflow.Transform.call(this,[],params)}Flatten.Definition={type:"Flatten",metadata:{generates:true},params:[{name:"fields",type:"field",array:true,required:true},{name:"index",type:"string"},{name:"as",type:"string",array:true}]};vegaUtil.inherits(Flatten,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE),fields=_.fields,as=fieldNames(fields,_.as||[]),index=_.index||null,m=as.length;out.rem=this.value;pulse.visit(pulse.SOURCE,t=>{const arrays=fields.map(f=>f(t)),maxlen=arrays.reduce((l,a)=>Math.max(l,a.length),0);let i=0,j,d,v;for(;i<maxlen;++i){d=vegaDataflow.derive(t);for(j=0;j<m;++j){d[as[j]]=(v=arrays[j][i])==null?null:v}if(index){d[index]=i}out.add.push(d)}});this.value=out.source=out.add;if(index)out.modifies(index);return out.modifies(as)}});function Fold(params){vegaDataflow.Transform.call(this,[],params)}Fold.Definition={type:"Fold",metadata:{generates:true},params:[{name:"fields",type:"field",array:true,required:true},{name:"as",type:"string",array:true,length:2,default:["key","value"]}]};vegaUtil.inherits(Fold,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE),fields=_.fields,fnames=fields.map(vegaUtil.accessorName),as=_.as||["key","value"],k=as[0],v=as[1],n=fields.length;out.rem=this.value;pulse.visit(pulse.SOURCE,t=>{for(let i=0,d;i<n;++i){d=vegaDataflow.derive(t);d[k]=fnames[i];d[v]=fields[i](t);out.add.push(d)}});this.value=out.source=out.add;return out.modifies(as)}});function Formula(params){vegaDataflow.Transform.call(this,null,params)}Formula.Definition={type:"Formula",metadata:{modifies:true},params:[{name:"expr",type:"expr",required:true},{name:"as",type:"string",required:true},{name:"initonly",type:"boolean"}]};vegaUtil.inherits(Formula,vegaDataflow.Transform,{transform(_,pulse){const func=_.expr,as=_.as,mod=_.modified(),flag=_.initonly?pulse.ADD:mod?pulse.SOURCE:pulse.modified(func.fields)||pulse.modified(as)?pulse.ADD_MOD:pulse.ADD;if(mod){pulse=pulse.materialize().reflow(true)}if(!_.initonly){pulse.modifies(as)}return pulse.visit(flag,t=>t[as]=func(t,_))}});function Generate(params){vegaDataflow.Transform.call(this,[],params)}vegaUtil.inherits(Generate,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.ALL),gen=_.generator;let data=this.value,num=_.size-data.length,add,rem,t;if(num>0){for(add=[];--num>=0;){add.push(t=vegaDataflow.ingest(gen(_)));data.push(t)}out.add=out.add.length?out.materialize(out.ADD).add.concat(add):add}else{rem=data.slice(0,-num);out.rem=out.rem.length?out.materialize(out.REM).rem.concat(rem):rem;data=data.slice(-num)}out.source=this.value=data;return out}});const Methods={value:"value",median:d3Array.median,mean:d3Array.mean,min:d3Array.min,max:d3Array.max};const Empty=[];function Impute(params){vegaDataflow.Transform.call(this,[],params)}Impute.Definition={type:"Impute",metadata:{changes:true},params:[{name:"field",type:"field",required:true},{name:"key",type:"field",required:true},{name:"keyvals",array:true},{name:"groupby",type:"field",array:true},{name:"method",type:"enum",default:"value",values:["value","mean","median","max","min"]},{name:"value",default:0}]};function getValue(_){var m=_.method||Methods.value,v;if(Methods[m]==null){vegaUtil.error("Unrecognized imputation method: "+m)}else if(m===Methods.value){v=_.value!==undefined?_.value:0;return()=>v}else{return Methods[m]}}function getField(_){const f=_.field;return t=>t?f(t):NaN}vegaUtil.inherits(Impute,vegaDataflow.Transform,{transform(_,pulse){var out=pulse.fork(pulse.ALL),impute=getValue(_),field=getField(_),fName=vegaUtil.accessorName(_.field),kName=vegaUtil.accessorName(_.key),gNames=(_.groupby||[]).map(vegaUtil.accessorName),groups=partition$1(pulse.source,_.groupby,_.key,_.keyvals),curr=[],prev=this.value,m=groups.domain.length,group,value,gVals,kVal,g,i,j,l,n,t;for(g=0,l=groups.length;g<l;++g){group=groups[g];gVals=group.values;value=NaN;for(j=0;j<m;++j){if(group[j]!=null)continue;kVal=groups.domain[j];t={_impute:true};for(i=0,n=gVals.length;i<n;++i)t[gNames[i]]=gVals[i];t[kName]=kVal;t[fName]=Number.isNaN(value)?value=impute(group,field):value;curr.push(vegaDataflow.ingest(t))}}if(curr.length)out.add=out.materialize(out.ADD).add.concat(curr);if(prev.length)out.rem=out.materialize(out.REM).rem.concat(prev);this.value=curr;return out}});function partition$1(data,groupby,key,keyvals){var get=f=>f(t),groups=[],domain=keyvals?keyvals.slice():[],kMap={},gMap={},gVals,gKey,group,i,j,k,n,t;domain.forEach((k,i)=>kMap[k]=i+1);for(i=0,n=data.length;i<n;++i){t=data[i];k=key(t);j=kMap[k]||(kMap[k]=domain.push(k));gKey=(gVals=groupby?groupby.map(get):Empty)+"";if(!(group=gMap[gKey])){group=gMap[gKey]=[];groups.push(group);group.values=gVals}group[j-1]=t}groups.domain=domain;return groups}function JoinAggregate(params){Aggregate.call(this,params)}JoinAggregate.Definition={type:"JoinAggregate",metadata:{modifies:true},params:[{name:"groupby",type:"field",array:true},{name:"fields",type:"field",null:true,array:true},{name:"ops",type:"enum",array:true,values:ValidAggregateOps},{name:"as",type:"string",null:true,array:true},{name:"key",type:"field"}]};vegaUtil.inherits(JoinAggregate,Aggregate,{transform(_,pulse){const aggr=this,mod=_.modified();let cells;if(aggr.value&&(mod||pulse.modified(aggr._inputs,true))){cells=aggr.value=mod?aggr.init(_):{};pulse.visit(pulse.SOURCE,t=>aggr.add(t))}else{cells=aggr.value=aggr.value||this.init(_);pulse.visit(pulse.REM,t=>aggr.rem(t));pulse.visit(pulse.ADD,t=>aggr.add(t))}aggr.changes();pulse.visit(pulse.SOURCE,t=>{vegaUtil.extend(t,cells[aggr.cellkey(t)].tuple)});return pulse.reflow(mod).modifies(this._outputs)},changes(){const adds=this._adds,mods=this._mods;let i,n;for(i=0,n=this._alen;i<n;++i){this.celltuple(adds[i]);adds[i]=null}for(i=0,n=this._mlen;i<n;++i){this.celltuple(mods[i]);mods[i]=null}this._alen=this._mlen=0}});function KDE(params){vegaDataflow.Transform.call(this,null,params)}KDE.Definition={type:"KDE",metadata:{generates:true},params:[{name:"groupby",type:"field",array:true},{name:"field",type:"field",required:true},{name:"cumulative",type:"boolean",default:false},{name:"counts",type:"boolean",default:false},{name:"bandwidth",type:"number",default:0},{name:"extent",type:"number",array:true,length:2},{name:"resolve",type:"enum",values:["shared","independent"],default:"independent"},{name:"steps",type:"number"},{name:"minsteps",type:"number",default:25},{name:"maxsteps",type:"number",default:200},{name:"as",type:"string",array:true,default:["value","density"]}]};vegaUtil.inherits(KDE,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS);if(!this.value||pulse.changed()||_.modified()){const source=pulse.materialize(pulse.SOURCE).source,groups=partition(source,_.groupby,_.field),names=(_.groupby||[]).map(vegaUtil.accessorName),bandwidth=_.bandwidth,method=_.cumulative?"cdf":"pdf",as=_.as||["value","density"],values=[];let domain=_.extent,minsteps=_.steps||_.minsteps||25,maxsteps=_.steps||_.maxsteps||200;if(method!=="pdf"&&method!=="cdf"){vegaUtil.error("Invalid density method: "+method)}if(_.resolve==="shared"){if(!domain)domain=vegaUtil.extent(source,_.field);minsteps=maxsteps=_.steps||maxsteps}groups.forEach(g=>{const density=vegaStatistics.randomKDE(g,bandwidth)[method],scale=_.counts?g.length:1,local=domain||vegaUtil.extent(g);vegaStatistics.sampleCurve(density,local,minsteps,maxsteps).forEach(v=>{const t={};for(let i=0;i<names.length;++i){t[names[i]]=g.dims[i]}t[as[0]]=v[0];t[as[1]]=v[1]*scale;values.push(vegaDataflow.ingest(t))})});if(this.value)out.rem=this.value;this.value=out.add=out.source=values}return out}});function Key(params){vegaDataflow.Operator.call(this,null,update$3,params)}vegaUtil.inherits(Key,vegaDataflow.Operator);function update$3(_){return this.value&&!_.modified()?this.value:vegaUtil.key(_.fields,_.flat)}function Load(params){vegaDataflow.Transform.call(this,[],params);this._pending=null}vegaUtil.inherits(Load,vegaDataflow.Transform,{transform(_,pulse){const df=pulse.dataflow;if(this._pending){return output(this,pulse,this._pending)}if(stop(_))return pulse.StopPropagation;if(_.values){return output(this,pulse,df.parse(_.values,_.format))}else if(_.async){const p=df.request(_.url,_.format).then(res=>{this._pending=vegaUtil.array(res.data);return df=>df.touch(this)});return{async:p}}else{return df.request(_.url,_.format).then(res=>output(this,pulse,vegaUtil.array(res.data)))}}});function stop(_){return _.modified("async")&&!(_.modified("values")||_.modified("url")||_.modified("format"))}function output(op,pulse,data){data.forEach(vegaDataflow.ingest);const out=pulse.fork(pulse.NO_FIELDS&pulse.NO_SOURCE);out.rem=op.value;op.value=out.source=out.add=data;op._pending=null;if(out.rem.length)out.clean(true);return out}function Lookup(params){vegaDataflow.Transform.call(this,{},params)}Lookup.Definition={type:"Lookup",metadata:{modifies:true},params:[{name:"index",type:"index",params:[{name:"from",type:"data",required:true},{name:"key",type:"field",required:true}]},{name:"values",type:"field",array:true},{name:"fields",type:"field",array:true,required:true},{name:"as",type:"string",array:true},{name:"default",default:null}]};vegaUtil.inherits(Lookup,vegaDataflow.Transform,{transform(_,pulse){const keys=_.fields,index=_.index,values=_.values,defaultValue=_.default==null?null:_.default,reset=_.modified(),n=keys.length;let flag=reset?pulse.SOURCE:pulse.ADD,out=pulse,as=_.as,set,m,mods;if(values){m=values.length;if(n>1&&!as){vegaUtil.error('Multi-field lookup requires explicit "as" parameter.')}if(as&&as.length!==n*m){vegaUtil.error('The "as" parameter has too few output field names.')}as=as||values.map(vegaUtil.accessorName);set=function(t){for(var i=0,k=0,j,v;i<n;++i){v=index.get(keys[i](t));if(v==null)for(j=0;j<m;++j,++k)t[as[k]]=defaultValue;else for(j=0;j<m;++j,++k)t[as[k]]=values[j](v)}}}else{if(!as){vegaUtil.error("Missing output field names.")}set=function(t){for(var i=0,v;i<n;++i){v=index.get(keys[i](t));t[as[i]]=v==null?defaultValue:v}}}if(reset){out=pulse.reflow(true)}else{mods=keys.some(k=>pulse.modified(k.fields));flag|=mods?pulse.MOD:0}pulse.visit(flag,set);return out.modifies(as)}});function MultiExtent(params){vegaDataflow.Operator.call(this,null,update$4,params)}vegaUtil.inherits(MultiExtent,vegaDataflow.Operator);function update$4(_){if(this.value&&!_.modified()){return this.value}const ext=_.extents,n=ext.length;let min=+Infinity,max=-Infinity,i,e;for(i=0;i<n;++i){e=ext[i];if(e[0]<min)min=e[0];if(e[1]>max)max=e[1]}return[min,max]}function MultiValues(params){vegaDataflow.Operator.call(this,null,update$5,params)}vegaUtil.inherits(MultiValues,vegaDataflow.Operator);function update$5(_){return this.value&&!_.modified()?this.value:_.values.reduce((data,_)=>data.concat(_),[])}function Params(params){vegaDataflow.Transform.call(this,null,params)}vegaUtil.inherits(Params,vegaDataflow.Transform,{transform(_,pulse){this.modified(_.modified());this.value=_;return pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS)}});function Pivot(params){Aggregate.call(this,params)}Pivot.Definition={type:"Pivot",metadata:{generates:true,changes:true},params:[{name:"groupby",type:"field",array:true},{name:"field",type:"field",required:true},{name:"value",type:"field",required:true},{name:"op",type:"enum",values:ValidAggregateOps,default:"sum"},{name:"limit",type:"number",default:0},{name:"key",type:"field"}]};vegaUtil.inherits(Pivot,Aggregate,{_transform:Aggregate.prototype.transform,transform(_,pulse){return this._transform(aggregateParams(_,pulse),pulse)}});function aggregateParams(_,pulse){const key=_.field,value=_.value,op=(_.op==="count"?"__count__":_.op)||"sum",fields=vegaUtil.accessorFields(key).concat(vegaUtil.accessorFields(value)),keys=pivotKeys(key,_.limit||0,pulse);if(pulse.changed())_.set("__pivot__",null,null,true);return{key:_.key,groupby:_.groupby,ops:keys.map(()=>op),fields:keys.map(k=>get(k,key,value,fields)),as:keys.map(k=>k+""),modified:_.modified.bind(_)}}function get(k,key,value,fields){return vegaUtil.accessor(d=>key(d)===k?value(d):NaN,fields,k+"")}function pivotKeys(key,limit,pulse){const map={},list=[];pulse.visit(pulse.SOURCE,t=>{const k=key(t);if(!map[k]){map[k]=1;list.push(k)}});list.sort(vegaUtil.ascending);return limit?list.slice(0,limit):list}function PreFacet(params){Facet.call(this,params)}vegaUtil.inherits(PreFacet,Facet,{transform(_,pulse){const flow=_.subflow,field=_.field,subflow=t=>this.subflow(vegaDataflow.tupleid(t),flow,pulse,t);if(_.modified("field")||field&&pulse.modified(vegaUtil.accessorFields(field))){vegaUtil.error("PreFacet does not support field modification.")}this.initTargets();if(field){pulse.visit(pulse.MOD,t=>{const sf=subflow(t);field(t).forEach(_=>sf.mod(_))});pulse.visit(pulse.ADD,t=>{const sf=subflow(t);field(t).forEach(_=>sf.add(vegaDataflow.ingest(_)))});pulse.visit(pulse.REM,t=>{const sf=subflow(t);field(t).forEach(_=>sf.rem(_))})}else{pulse.visit(pulse.MOD,t=>subflow(t).mod(t));pulse.visit(pulse.ADD,t=>subflow(t).add(t));pulse.visit(pulse.REM,t=>subflow(t).rem(t))}if(pulse.clean()){pulse.runAfter(()=>this.clean())}return pulse}});function Project(params){vegaDataflow.Transform.call(this,null,params)}Project.Definition={type:"Project",metadata:{generates:true,changes:true},params:[{name:"fields",type:"field",array:true},{name:"as",type:"string",null:true,array:true}]};vegaUtil.inherits(Project,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE),fields=_.fields,as=fieldNames(_.fields,_.as||[]),derive=fields?(s,t)=>project(s,t,fields,as):vegaDataflow.rederive;let lut;if(this.value){lut=this.value}else{pulse=pulse.addAll();lut=this.value={}}pulse.visit(pulse.REM,t=>{const id=vegaDataflow.tupleid(t);out.rem.push(lut[id]);lut[id]=null});pulse.visit(pulse.ADD,t=>{const dt=derive(t,vegaDataflow.ingest({}));lut[vegaDataflow.tupleid(t)]=dt;out.add.push(dt)});pulse.visit(pulse.MOD,t=>{out.mod.push(derive(t,lut[vegaDataflow.tupleid(t)]))});return out}});function project(s,t,fields,as){for(let i=0,n=fields.length;i<n;++i){t[as[i]]=fields[i](s)}return t}function Proxy(params){vegaDataflow.Transform.call(this,null,params)}vegaUtil.inherits(Proxy,vegaDataflow.Transform,{transform(_,pulse){this.value=_.value;return _.modified("value")?pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS):pulse.StopPropagation}});function Quantile(params){vegaDataflow.Transform.call(this,null,params)}Quantile.Definition={type:"Quantile",metadata:{generates:true,changes:true},params:[{name:"groupby",type:"field",array:true},{name:"field",type:"field",required:true},{name:"probs",type:"number",array:true},{name:"step",type:"number",default:.01},{name:"as",type:"string",array:true,default:["prob","value"]}]};const EPSILON$1=1e-14;vegaUtil.inherits(Quantile,vegaDataflow.Transform,{transform(_,pulse){const out=pulse.fork(pulse.NO_SOURCE|pulse.NO_FIELDS),as=_.as||["prob","value"];if(this.value&&!_.modified()&&!pulse.changed()){out.source=this.value;return out}co