"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSettings = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const numericKeys = ['alpha', 'beta', 'gamma', 'period'];
const booleanKeys = ['pad'];

function castBasedOnKey(key, val) {
  if (~numericKeys.indexOf(key)) return Number(val);

  if (~booleanKeys.indexOf(key)) {
    switch (val) {
      case 'true':
      case 1:
      case '1':
        return true;

      default:
        return false;
    }
  }

  return val;
}

const parseSettings = settingsStr => {
  return settingsStr.split(/\s/).reduce((acc, value) => {
    const [key, val] = value.split(/=/);
    acc[key] = castBasedOnKey(key, val);
    return acc;
  }, {});
};

exports.parseSettings = parseSettings;