(window["tileMap_bundle_jsonpfunction"]=window["tileMap_bundle_jsonpfunction"]||[]).push([[4],{22:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"convertToGeoJson",(function(){return convertToGeoJson}));__webpack_require__.d(__webpack_exports__,"geoContains",(function(){return geoContains}));function decodeGeoHash(geohash){const BITS=[16,8,4,2,1];const BASE32="0123456789bcdefghjkmnpqrstuvwxyz";let isEven=true;const lat=[];const lon=[];lat[0]=-90;lat[1]=90;lon[0]=-180;lon[1]=180;let latErr=90;let lonErr=180;[...geohash].forEach(nextChar=>{const cd=BASE32.indexOf(nextChar);for(let j=0;j<5;j++){const mask=BITS[j];if(isEven){lonErr=lonErr/=2;refineInterval(lon,cd,mask)}else{latErr=latErr/=2;refineInterval(lat,cd,mask)}isEven=!isEven}});lat[2]=(lat[0]+lat[1])/2;lon[2]=(lon[0]+lon[1])/2;return{latitude:lat,longitude:lon}}function refineInterval(interval,cd,mask){if(cd&mask){interval[0]=(interval[0]+interval[1])/2}else{interval[1]=(interval[0]+interval[1])/2}}function geoContains(collar,bounds){if(!bounds||!collar)return false;if(bounds.top_left.lat>collar.top_left.lat||bounds.top_left.lon<collar.top_left.lon){return false}if(bounds.bottom_right.lat<collar.bottom_right.lat||bounds.bottom_right.lon>collar.bottom_right.lon){return false}return true}const gridAtEquator={1:[5009400,4992600],2:[1252300,624100],3:[156500,156e3],4:[39100,19500],5:[4900,4900],6:[1200,609.4],7:[152.9,152.4],8:[38.2,19],9:[4.8,4.8],10:[1.2,.595],11:[.149,.149],12:[.037,.019]};function gridDimensions(precision){return gridAtEquator[precision]}function convertToGeoJson(tabifiedResponse,{geohash:geohash,geocentroid:geocentroid,metric:metric}){let features;let min=Infinity;let max=-Infinity;if(tabifiedResponse&&tabifiedResponse.rows){const table=tabifiedResponse;const geohashColumn=geohash?table.columns[geohash.accessor]:null;if(!geohashColumn){features=[]}else{const metricColumn=table.columns[metric.accessor];const geocentroidColumn=geocentroid?table.columns[geocentroid.accessor]:null;features=table.rows.map(row=>{const geohashValue=row[geohashColumn.id];if(!geohashValue)return false;const geohashLocation=decodeGeoHash(geohashValue);let pointCoordinates;if(geocentroidColumn){const location=row[geocentroidColumn.id];pointCoordinates=[location.lon,location.lat]}else{pointCoordinates=[geohashLocation.longitude[2],geohashLocation.latitude[2]]}const rectangle=[[geohashLocation.latitude[0],geohashLocation.longitude[0]],[geohashLocation.latitude[0],geohashLocation.longitude[1]],[geohashLocation.latitude[1],geohashLocation.longitude[1]],[geohashLocation.latitude[1],geohashLocation.longitude[0]]];const centerLatLng=[geohashLocation.latitude[2],geohashLocation.longitude[2]];if(geohash!==null&&geohash!==void 0&&geohash.params.useGeocentroid){pointCoordinates[0]=clampGrid(pointCoordinates[0],geohashLocation.longitude[0],geohashLocation.longitude[1]);pointCoordinates[1]=clampGrid(pointCoordinates[1],geohashLocation.latitude[0],geohashLocation.latitude[1])}const value=row[metricColumn.id];min=Math.min(min,value);max=Math.max(max,value);return{type:"Feature",geometry:{type:"Point",coordinates:pointCoordinates},properties:{geohash:geohashValue,geohash_meta:{center:centerLatLng,rectangle:rectangle},value:value}}}).filter(row=>!!row)}}else{features=[]}const convertedData={featureCollection:{type:"FeatureCollection",features:features},meta:{min:min,max:max,geohashPrecision:geohash===null||geohash===void 0?void 0:geohash.params.precision,geohashGridDimensionsAtEquator:geohash!==null&&geohash!==void 0&&geohash.params.precision?gridDimensions(geohash.params.precision):undefined}};if(geohash&&geohash.accessor){convertedData.meta.geohash=tabifiedResponse.columns[geohash.accessor].meta}return convertedData}function clampGrid(val,min,max){if(val>max)val=max;else if(val<min)val=min;return val}}}]);