"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withTheme = exports.keyframes = exports.createGlobalStyle = exports.EuiThemeProvider = exports.euiStyled = exports.css = void 0;

var _react = _interopRequireDefault(require("react"));

var styledComponents = _interopRequireWildcard(require("styled-components"));

var _eui_theme_dark = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_dark.json"));

var _eui_theme_light = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_light.json"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const EuiThemeProvider = ({
  darkMode = false,
  ...otherProps
}) => /*#__PURE__*/_react.default.createElement(styledComponents.ThemeProvider, _extends({}, otherProps, {
  theme: outerTheme => ({ ...outerTheme,
    eui: darkMode ? _eui_theme_dark.default : _eui_theme_light.default,
    darkMode
  })
}));

exports.EuiThemeProvider = EuiThemeProvider;
const {
  default: euiStyled,
  css,
  createGlobalStyle,
  keyframes,
  withTheme
} = styledComponents;
exports.withTheme = withTheme;
exports.keyframes = keyframes;
exports.createGlobalStyle = createGlobalStyle;
exports.css = css;
exports.euiStyled = euiStyled;