"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stubFields = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const stubFields = [{
  name: 'machine.os',
  esTypes: ['text'],
  type: 'string',
  aggregatable: false,
  searchable: false,
  filterable: true
}, {
  name: 'machine.os.raw',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'not.filterable',
  type: 'string',
  esTypes: ['text'],
  aggregatable: true,
  searchable: false,
  filterable: false
}, {
  name: 'bytes',
  type: 'number',
  esTypes: ['long'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: '@timestamp',
  type: 'date',
  esTypes: ['date'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'clientip',
  type: 'ip',
  esTypes: ['ip'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'bool.field',
  type: 'boolean',
  esTypes: ['boolean'],
  aggregatable: true,
  searchable: true,
  filterable: true
}];
exports.stubFields = stubFields;