"use strict";

module.exports = function () {
  "use strict";
  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() {
      this.constructor = child;
    }

    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message = message;
    this.expected = expected;
    this.found = found;
    this.location = location;
    this.name = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser = this,
        peg$FAILED = {},
        peg$startRuleFunctions = {
      start: peg$parsestart,
      Literal: peg$parseLiteral
    },
        peg$startRuleFunction = peg$parsestart,
        peg$c0 = function (query, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      if (query !== null) return query;
      return nodeTypes.function.buildNode('is', '*', '*');
    },
        peg$c1 = function () {
      return errorOnLuceneSyntax;
    },
        peg$c2 = function (head, query) {
      return query;
    },
        peg$c3 = function (head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('or', nodes);
    },
        peg$c4 = function (head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');
      if (cursor) return cursor;
      return buildFunctionNode('and', nodes);
    },
        peg$c5 = function (query) {
      if (query.type === 'cursor') return query;
      return buildFunctionNode('not', [query]);
    },
        peg$c6 = "(",
        peg$c7 = {
      type: "literal",
      value: "(",
      description: "\"(\""
    },
        peg$c8 = ")",
        peg$c9 = {
      type: "literal",
      value: ")",
      description: "\")\""
    },
        peg$c10 = function (query, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return query;
    },
        peg$c11 = ":",
        peg$c12 = {
      type: "literal",
      value: ":",
      description: "\":\""
    },
        peg$c13 = "{",
        peg$c14 = {
      type: "literal",
      value: "{",
      description: "\"{\""
    },
        peg$c15 = "}",
        peg$c16 = {
      type: "literal",
      value: "}",
      description: "\"}\""
    },
        peg$c17 = function (field, query, trailing) {
      if (query.type === 'cursor') {
        return { ...query,
          nestedPath: query.nestedPath ? `${field.value}.${query.nestedPath}` : field.value
        };
      }

      ;

      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return buildFunctionNode('nested', [field, query]);
    },
        peg$c18 = {
      type: "other",
      description: "fieldName"
    },
        peg$c19 = function (field, operator, value) {
      if (value.type === 'cursor') {
        return { ...value,
          suggestionTypes: ['conjunction']
        };
      }

      const range = buildNamedArgNode(operator, value);
      return buildFunctionNode('range', [field, range]);
    },
        peg$c20 = function (field, partial) {
      if (partial.type === 'cursor') {
        return { ...partial,
          fieldName: field.value,
          suggestionTypes: ['value', 'conjunction']
        };
      }

      return partial(field);
    },
        peg$c21 = function (partial) {
      if (partial.type === 'cursor') {
        const fieldName = `${partial.prefix}${partial.suffix}`.trim();
        return { ...partial,
          fieldName,
          suggestionTypes: ['field', 'operator', 'conjunction']
        };
      }

      const field = buildLiteralNode(null);
      return partial(field);
    },
        peg$c22 = function (partial, trailing) {
      if (trailing.type === 'cursor') {
        return { ...trailing,
          suggestionTypes: ['conjunction']
        };
      }

      return partial;
    },
        peg$c23 = function (head, partial) {
      return partial;
    },
        peg$c24 = function (head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');

      if (cursor) {
        return { ...cursor,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('or', nodes.map(partial => partial(field)));
    },
        peg$c25 = function (head, tail) {
      const nodes = [head, ...tail];
      const cursor = parseCursor && nodes.find(node => node.type === 'cursor');

      if (cursor) {
        return { ...cursor,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('and', nodes.map(partial => partial(field)));
    },
        peg$c26 = function (partial) {
      if (partial.type === 'cursor') {
        return { ...list,
          suggestionTypes: ['value']
        };
      }

      return field => buildFunctionNode('not', [partial(field)]);
    },
        peg$c27 = {
      type: "other",
      description: "value"
    },
        peg$c28 = function (value) {
      if (value.type === 'cursor') return value;
      const isPhrase = buildLiteralNode(true);
      return field => buildFunctionNode('is', [field, value, isPhrase]);
    },
        peg$c29 = function (value) {
      if (value.type === 'cursor') return value;

      if (!allowLeadingWildcards && value.type === 'wildcard' && nodeTypes.wildcard.hasLeadingWildcard(value)) {
        error('Leading wildcards are disabled. See query:allowLeadingWildcards in Advanced Settings.');
      }

      const isPhrase = buildLiteralNode(false);
      return field => buildFunctionNode('is', [field, value, isPhrase]);
    },
        peg$c30 = {
      type: "other",
      description: "OR"
    },
        peg$c31 = "or",
        peg$c32 = {
      type: "literal",
      value: "or",
      description: "\"or\""
    },
        peg$c33 = {
      type: "other",
      description: "AND"
    },
        peg$c34 = "and",
        peg$c35 = {
      type: "literal",
      value: "and",
      description: "\"and\""
    },
        peg$c36 = {
      type: "other",
      description: "NOT"
    },
        peg$c37 = "not",
        peg$c38 = {
      type: "literal",
      value: "not",
      description: "\"not\""
    },
        peg$c39 = {
      type: "other",
      description: "literal"
    },
        peg$c40 = function () {
      return parseCursor;
    },
        peg$c41 = "\"",
        peg$c42 = {
      type: "literal",
      value: "\"",
      description: "\"\\\"\""
    },
        peg$c43 = function (prefix, cursor, suffix) {
      const {
        start,
        end
      } = location();
      return {
        type: 'cursor',
        start: start.offset,
        end: end.offset - cursor.length,
        prefix: prefix.join(''),
        suffix: suffix.join(''),
        text: text().replace(cursor, '')
      };
    },
        peg$c44 = function (chars) {
      return buildLiteralNode(chars.join(''));
    },
        peg$c45 = "\\",
        peg$c46 = {
      type: "literal",
      value: "\\",
      description: "\"\\\\\""
    },
        peg$c47 = /^[\\"]/,
        peg$c48 = {
      type: "class",
      value: "[\\\\\"]",
      description: "[\\\\\"]"
    },
        peg$c49 = function (char) {
      return char;
    },
        peg$c50 = /^[^"]/,
        peg$c51 = {
      type: "class",
      value: "[^\"]",
      description: "[^\"]"
    },
        peg$c52 = function (chars) {
      const sequence = chars.join('').trim();
      if (sequence === 'null') return buildLiteralNode(null);
      if (sequence === 'true') return buildLiteralNode(true);
      if (sequence === 'false') return buildLiteralNode(false);
      if (chars.includes(wildcardSymbol)) return buildWildcardNode(sequence);
      return buildLiteralNode(sequence);
    },
        peg$c53 = {
      type: "any",
      description: "any character"
    },
        peg$c54 = "*",
        peg$c55 = {
      type: "literal",
      value: "*",
      description: "\"*\""
    },
        peg$c56 = function () {
      return wildcardSymbol;
    },
        peg$c57 = "\\t",
        peg$c58 = {
      type: "literal",
      value: "\\t",
      description: "\"\\\\t\""
    },
        peg$c59 = function () {
      return '\t';
    },
        peg$c60 = "\\r",
        peg$c61 = {
      type: "literal",
      value: "\\r",
      description: "\"\\\\r\""
    },
        peg$c62 = function () {
      return '\r';
    },
        peg$c63 = "\\n",
        peg$c64 = {
      type: "literal",
      value: "\\n",
      description: "\"\\\\n\""
    },
        peg$c65 = function () {
      return '\n';
    },
        peg$c66 = function (keyword) {
      return keyword;
    },
        peg$c67 = /^[\\():<>"*{}]/,
        peg$c68 = {
      type: "class",
      value: "[\\\\():<>\"*{}]",
      description: "[\\\\():<>\"*{}]"
    },
        peg$c69 = "<=",
        peg$c70 = {
      type: "literal",
      value: "<=",
      description: "\"<=\""
    },
        peg$c71 = function () {
      return 'lte';
    },
        peg$c72 = ">=",
        peg$c73 = {
      type: "literal",
      value: ">=",
      description: "\">=\""
    },
        peg$c74 = function () {
      return 'gte';
    },
        peg$c75 = "<",
        peg$c76 = {
      type: "literal",
      value: "<",
      description: "\"<\""
    },
        peg$c77 = function () {
      return 'lt';
    },
        peg$c78 = ">",
        peg$c79 = {
      type: "literal",
      value: ">",
      description: "\">\""
    },
        peg$c80 = function () {
      return 'gt';
    },
        peg$c81 = {
      type: "other",
      description: "whitespace"
    },
        peg$c82 = /^[ \t\r\n]/,
        peg$c83 = {
      type: "class",
      value: "[\\ \\t\\r\\n]",
      description: "[\\ \\t\\r\\n]"
    },
        peg$c84 = "@kuery-cursor@",
        peg$c85 = {
      type: "literal",
      value: "@kuery-cursor@",
      description: "\"@kuery-cursor@\""
    },
        peg$c86 = function () {
      return cursorSymbol;
    },
        peg$c87 = "||",
        peg$c88 = {
      type: "literal",
      value: "||",
      description: "\"||\""
    },
        peg$c89 = function () {
      error('LuceneOr');
    },
        peg$c90 = "&&",
        peg$c91 = {
      type: "literal",
      value: "&&",
      description: "\"&&\""
    },
        peg$c92 = function () {
      error('LuceneAnd');
    },
        peg$c93 = "+",
        peg$c94 = {
      type: "literal",
      value: "+",
      description: "\"+\""
    },
        peg$c95 = "-",
        peg$c96 = {
      type: "literal",
      value: "-",
      description: "\"-\""
    },
        peg$c97 = function () {
      error('LuceneNot');
    },
        peg$c98 = "!",
        peg$c99 = {
      type: "literal",
      value: "!",
      description: "\"!\""
    },
        peg$c100 = "_exists_",
        peg$c101 = {
      type: "literal",
      value: "_exists_",
      description: "\"_exists_\""
    },
        peg$c102 = function () {
      error('LuceneExists');
    },
        peg$c103 = function () {
      error('LuceneRange');
    },
        peg$c104 = "?",
        peg$c105 = {
      type: "literal",
      value: "?",
      description: "\"?\""
    },
        peg$c106 = function () {
      error('LuceneWildcard');
    },
        peg$c107 = "/",
        peg$c108 = {
      type: "literal",
      value: "/",
      description: "\"/\""
    },
        peg$c109 = /^[^\/]/,
        peg$c110 = {
      type: "class",
      value: "[^/]",
      description: "[^/]"
    },
        peg$c111 = function () {
      error('LuceneRegex');
    },
        peg$c112 = "~",
        peg$c113 = {
      type: "literal",
      value: "~",
      description: "\"~\""
    },
        peg$c114 = /^[0-9]/,
        peg$c115 = {
      type: "class",
      value: "[0-9]",
      description: "[0-9]"
    },
        peg$c116 = function () {
      error('LuceneFuzzy');
    },
        peg$c117 = function () {
      error('LuceneProximity');
    },
        peg$c118 = "^",
        peg$c119 = {
      type: "literal",
      value: "^",
      description: "\"^\""
    },
        peg$c120 = function () {
      error('LuceneBoost');
    },
        peg$c121 = function () {
      return char;
    },
        peg$c122 = "=",
        peg$c123 = {
      type: "literal",
      value: "=",
      description: "\"=\""
    },
        peg$c124 = "[",
        peg$c125 = {
      type: "literal",
      value: "[",
      description: "\"[\""
    },
        peg$c126 = "]",
        peg$c127 = {
      type: "literal",
      value: "]",
      description: "\"]\""
    },
        peg$c128 = "TO",
        peg$c129 = {
      type: "literal",
      value: "TO",
      description: "\"TO\""
    },
        peg$currPos = 0,
        peg$savedPos = 0,
        peg$posDetailsCache = [{
      line: 1,
      column: 1,
      seenCR: false
    }],
        peg$maxFailPos = 0,
        peg$maxFailExpected = [],
        peg$silentFails = 0,
        peg$resultsCache = {},
        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(null, [{
        type: "other",
        description: description
      }], input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function error(message) {
      throw peg$buildException(message, null, input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p,
          ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;

        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line: details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);

          if (ch === "\n") {
            if (!details.seenCR) {
              details.line++;
            }

            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails = peg$computePosDetails(endPos);
      return {
        start: {
          offset: startPos,
          line: startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line: endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) {
        return;
      }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;
        expected.sort(function (a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
          }

          return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\x08/g, '\\b').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\f/g, '\\f').replace(/\r/g, '\\r').replace(/[\x00-\x07\x0B\x0E\x0F]/g, function (ch) {
            return '\\x0' + hex(ch);
          }).replace(/[\x10-\x1F\x80-\xFF]/g, function (ch) {
            return '\\x' + hex(ch);
          }).replace(/[\u0100-\u0FFF]/g, function (ch) {
            return '\\u0' + hex(ch);
          }).replace(/[\u1000-\uFFFF]/g, function (ch) {
            return '\\u' + hex(ch);
          });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc,
            foundDesc,
            i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1 ? expectedDescs.slice(0, -1).join(", ") + " or " + expectedDescs[expected.length - 1] : expectedDescs[0];
        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";
        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(message !== null ? message : buildMessage(expected, found), expected, found, location);
    }

    function peg$parsestart() {
      var s0, s1, s2, s3;
      var key = peg$currPos * 56 + 0,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseOrQuery();

        if (s2 === peg$FAILED) {
          s2 = null;
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOptionalSpace();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c0(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseOrQuery() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 1,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c1();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseLuceneQuery();

        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseAndQuery();

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$currPos;
          s4 = peg$parseOr();

          if (s4 !== peg$FAILED) {
            s5 = peg$parseAndQuery();

            if (s5 !== peg$FAILED) {
              peg$savedPos = s3;
              s4 = peg$c2(s1, s5);
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$currPos;
              s4 = peg$parseOr();

              if (s4 !== peg$FAILED) {
                s5 = peg$parseAndQuery();

                if (s5 !== peg$FAILED) {
                  peg$savedPos = s3;
                  s4 = peg$c2(s1, s5);
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            }
          } else {
            s2 = peg$FAILED;
          }

          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c3(s1, s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$parseAndQuery();
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseAndQuery() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 2,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseNotQuery();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parseAnd();

        if (s4 !== peg$FAILED) {
          s5 = peg$parseNotQuery();

          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s4 = peg$c2(s1, s5);
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }

        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            s4 = peg$parseAnd();

            if (s4 !== peg$FAILED) {
              s5 = peg$parseNotQuery();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c2(s1, s5);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c4(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNotQuery();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseNotQuery() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 3,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseNot();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseSubQuery();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c5(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseSubQuery();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseSubQuery() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 4,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c6;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c7);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrQuery();

          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c8;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c9);
                }
              }

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c10(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNestedQuery();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseNestedQuery() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;
      var key = peg$currPos * 56 + 5,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c11;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c12);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 123) {
                s5 = peg$c13;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c14);
                }
              }

              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseSpace();

                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseSpace();
                }

                if (s6 !== peg$FAILED) {
                  s7 = peg$parseOrQuery();

                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseOptionalSpace();

                    if (s8 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 125) {
                        s9 = peg$c15;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;

                        if (peg$silentFails === 0) {
                          peg$fail(peg$c16);
                        }
                      }

                      if (s9 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c17(s1, s7, s8);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseExpression();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseExpression() {
      var s0;
      var key = peg$currPos * 56 + 6,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseFieldRangeExpression();

      if (s0 === peg$FAILED) {
        s0 = peg$parseFieldValueExpression();

        if (s0 === peg$FAILED) {
          s0 = peg$parseValueExpression();
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseField() {
      var s0, s1;
      var key = peg$currPos * 56 + 7,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$parseLiteral();
      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c18);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseFieldRangeExpression() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 8,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseRangeOperator();

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLiteral();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c19(s1, s3, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseFieldValueExpression() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 9,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseField();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c11;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c12);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseListOfValues();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c20(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseValueExpression() {
      var s0, s1;
      var key = peg$currPos * 56 + 10,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseValue();

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c21(s1);
      }

      s0 = s1;
      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseListOfValues() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 11,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c6;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c7);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrListOfValues();

          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();

            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c8;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c9);
                }
              }

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c22(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseValue();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseOrListOfValues() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 12,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseAndListOfValues();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parseOr();

        if (s4 !== peg$FAILED) {
          s5 = peg$parseAndListOfValues();

          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s4 = peg$c23(s1, s5);
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }

        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            s4 = peg$parseOr();

            if (s4 !== peg$FAILED) {
              s5 = peg$parseAndListOfValues();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c23(s1, s5);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c24(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseAndListOfValues();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseAndListOfValues() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 13,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseNotListOfValues();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parseAnd();

        if (s4 !== peg$FAILED) {
          s5 = peg$parseNotListOfValues();

          if (s5 !== peg$FAILED) {
            peg$savedPos = s3;
            s4 = peg$c23(s1, s5);
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }

        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            s4 = peg$parseAnd();

            if (s4 !== peg$FAILED) {
              s5 = peg$parseNotListOfValues();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c23(s1, s5);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c25(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseNotListOfValues();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseNotListOfValues() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 14,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseNot();

      if (s1 !== peg$FAILED) {
        s2 = peg$parseListOfValues();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c26(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseListOfValues();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseValue() {
      var s0, s1;
      var key = peg$currPos * 56 + 15,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseQuotedString();

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c28(s1);
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseUnquotedLiteral();

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c29(s1);
        }

        s0 = s1;
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c27);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseOr() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 16,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c31) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c32);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneOr();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c30);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseAnd() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 17,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c34) {
          s2 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c35);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneAnd();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c33);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseNot() {
      var s0, s1, s2, s3;
      var key = peg$currPos * 56 + 18,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$currPos;

      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c37) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c38);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseSpace();
          }
        } else {
          s2 = peg$FAILED;
        }

        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        peg$savedPos = peg$currPos;
        s1 = peg$c1();

        if (s1) {
          s1 = void 0;
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          s2 = peg$parseLuceneNot();

          if (s2 !== peg$FAILED) {
            s1 = [s1, s2];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c36);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLiteral() {
      var s0, s1;
      var key = peg$currPos * 56 + 19,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;
      s0 = peg$parseQuotedString();

      if (s0 === peg$FAILED) {
        s0 = peg$parseUnquotedLiteral();
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c39);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseQuotedString() {
      var s0, s1, s2, s3, s4, s5, s6;
      var key = peg$currPos * 56 + 20,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c40();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s2 = peg$c41;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c42);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseQuotedCharacter();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseQuotedCharacter();
          }

          if (s3 !== peg$FAILED) {
            s4 = peg$parseCursor();

            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseQuotedCharacter();

              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseQuotedCharacter();
              }

              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 34) {
                  s6 = peg$c41;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;

                  if (peg$silentFails === 0) {
                    peg$fail(peg$c42);
                  }
                }

                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c43(s3, s4, s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 34) {
          s1 = peg$c41;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c42);
          }
        }

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseQuotedCharacter();

          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseQuotedCharacter();
          }

          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 34) {
              s3 = peg$c41;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c42);
              }
            }

            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c44(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseQuotedCharacter() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 21,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 92) {
          s1 = peg$c45;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c46);
          }
        }

        if (s1 !== peg$FAILED) {
          if (peg$c47.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c48);
            }
          }

          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c49(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          peg$silentFails++;
          s2 = peg$parseCursor();
          peg$silentFails--;

          if (s2 === peg$FAILED) {
            s1 = void 0;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }

          if (s1 !== peg$FAILED) {
            if (peg$c50.test(input.charAt(peg$currPos))) {
              s2 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s2 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c51);
              }
            }

            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c49(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseUnquotedLiteral() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 22,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c40();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseUnquotedCharacter();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseUnquotedCharacter();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseCursor();

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseUnquotedCharacter();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseUnquotedCharacter();
            }

            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c43(s2, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseUnquotedCharacter();

        if (s2 !== peg$FAILED) {
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parseUnquotedCharacter();
          }
        } else {
          s1 = peg$FAILED;
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c52(s1);
        }

        s0 = s1;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseUnquotedCharacter() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 23,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedSpecialCharacter();

        if (s0 === peg$FAILED) {
          s0 = peg$parseEscapedKeyword();

          if (s0 === peg$FAILED) {
            s0 = peg$parseWildcard();

            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$currPos;
              peg$silentFails++;
              s2 = peg$parseSpecialCharacter();
              peg$silentFails--;

              if (s2 === peg$FAILED) {
                s1 = void 0;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }

              if (s1 !== peg$FAILED) {
                s2 = peg$currPos;
                peg$silentFails++;
                s3 = peg$parseKeyword();
                peg$silentFails--;

                if (s3 === peg$FAILED) {
                  s2 = void 0;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }

                if (s2 !== peg$FAILED) {
                  s3 = peg$currPos;
                  peg$silentFails++;
                  s4 = peg$parseCursor();
                  peg$silentFails--;

                  if (s4 === peg$FAILED) {
                    s3 = void 0;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }

                  if (s3 !== peg$FAILED) {
                    if (input.length > peg$currPos) {
                      s4 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s4 = peg$FAILED;

                      if (peg$silentFails === 0) {
                        peg$fail(peg$c53);
                      }
                    }

                    if (s4 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c49(s4);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseWildcard() {
      var s0, s1;
      var key = peg$currPos * 56 + 24,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 42) {
        s1 = peg$c54;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c55);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c56();
      }

      s0 = s1;
      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseOptionalSpace() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 25,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c40();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseCursor();

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c43(s2, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = [];
        s1 = peg$parseSpace();

        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parseSpace();
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseEscapedWhitespace() {
      var s0, s1;
      var key = peg$currPos * 56 + 26,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.substr(peg$currPos, 2) === peg$c57) {
        s1 = peg$c57;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c58);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c59();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.substr(peg$currPos, 2) === peg$c60) {
          s1 = peg$c60;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c61);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c62();
        }

        s0 = s1;

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;

          if (input.substr(peg$currPos, 2) === peg$c63) {
            s1 = peg$c63;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c64);
            }
          }

          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c65();
          }

          s0 = s1;
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseEscapedSpecialCharacter() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 27,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c45;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c46);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseSpecialCharacter();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c49(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseEscapedKeyword() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 28,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c45;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c46);
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c31) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c32);
          }
        }

        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c34) {
            s2 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c35);
            }
          }

          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c37) {
              s2 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s2 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c38);
              }
            }
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c66(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseKeyword() {
      var s0;
      var key = peg$currPos * 56 + 29,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseOr();

      if (s0 === peg$FAILED) {
        s0 = peg$parseAnd();

        if (s0 === peg$FAILED) {
          s0 = peg$parseNot();
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseSpecialCharacter() {
      var s0;
      var key = peg$currPos * 56 + 30,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      if (peg$c67.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c68);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseRangeOperator() {
      var s0, s1;
      var key = peg$currPos * 56 + 31,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.substr(peg$currPos, 2) === peg$c69) {
        s1 = peg$c69;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c70);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c71();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.substr(peg$currPos, 2) === peg$c72) {
          s1 = peg$c72;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c73);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c74();
        }

        s0 = s1;

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;

          if (input.charCodeAt(peg$currPos) === 60) {
            s1 = peg$c75;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c76);
            }
          }

          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c77();
          }

          s0 = s1;

          if (s0 === peg$FAILED) {
            s0 = peg$currPos;

            if (input.charCodeAt(peg$currPos) === 62) {
              s1 = peg$c78;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c79);
              }
            }

            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c80();
            }

            s0 = s1;
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseSpace() {
      var s0, s1;
      var key = peg$currPos * 56 + 32,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      peg$silentFails++;

      if (peg$c82.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c83);
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c81);
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseCursor() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 33,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c40();

      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 14) === peg$c84) {
          s2 = peg$c84;
          peg$currPos += 14;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c85);
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c86();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneOr() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 34,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c87) {
          s2 = peg$c87;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c88);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c89();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneAnd() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 35,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c90) {
          s2 = peg$c90;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c91);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c92();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 43) {
          s1 = peg$c93;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c94);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c92();
        }

        s0 = s1;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneNot() {
      var s0, s1;
      var key = peg$currPos * 56 + 36,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c95;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c96);
        }
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c97();
      }

      s0 = s1;

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 33) {
          s1 = peg$c98;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c99);
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c97();
        }

        s0 = s1;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneQuery() {
      var s0;
      var key = peg$currPos * 56 + 37,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseLuceneFieldQuery();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneValue();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneExists();
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneFieldQuery() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 38,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseLuceneLiteral();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c11;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c12);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLuceneValue();

              if (s5 !== peg$FAILED) {
                s1 = [s1, s2, s3, s4, s5];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneValue() {
      var s0;
      var key = peg$currPos * 56 + 39,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseLuceneRange();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneWildcard();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneRegex();

          if (s0 === peg$FAILED) {
            s0 = peg$parseLuceneFuzzy();

            if (s0 === peg$FAILED) {
              s0 = peg$parseLuceneProximity();

              if (s0 === peg$FAILED) {
                s0 = peg$parseLuceneBoost();
              }
            }
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneExists() {
      var s0, s1, s2, s3, s4, s5;
      var key = peg$currPos * 56 + 40,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.substr(peg$currPos, 8) === peg$c100) {
        s1 = peg$c100;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c101);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c11;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c12);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();

            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parseLuceneLiteral();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c102();
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneRange() {
      var s0, s1, s2, s3, s4, s5, s6;
      var key = peg$currPos * 56 + 41,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseRangeOperator();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseLuceneLiteral();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c103();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseLuceneRangeStart();

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseSpace();

          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseSpace();
          }

          if (s2 !== peg$FAILED) {
            s3 = peg$parseLuceneLiteral();

            if (s3 !== peg$FAILED) {
              s4 = peg$parseLuceneTo();

              if (s4 !== peg$FAILED) {
                s5 = peg$parseLuceneLiteral();

                if (s5 !== peg$FAILED) {
                  s6 = peg$parseLuceneRangeEnd();

                  if (s6 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c103();
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneWildcard() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 42,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseLuceneUnquotedCharacter();

      if (s2 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 42) {
          s2 = peg$c54;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c55);
          }
        }
      }

      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseLuceneUnquotedCharacter();

        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s2 = peg$c54;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c55);
            }
          }
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 63) {
          s2 = peg$c104;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c105);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseLuceneWildcard();

          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseLuceneWildcard();
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c106();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneRegex() {
      var s0, s1, s2, s3;
      var key = peg$currPos * 56 + 43,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 47) {
        s1 = peg$c107;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c108);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];

        if (peg$c109.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c110);
          }
        }

        while (s3 !== peg$FAILED) {
          s2.push(s3);

          if (peg$c109.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c110);
            }
          }
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 47) {
            s3 = peg$c107;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c108);
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c111();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneFuzzy() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 44,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseLuceneUnquotedLiteral();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 126) {
          s2 = peg$c112;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c113);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c114.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c115);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c114.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c115);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c116();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneProximity() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 45,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseQuotedString();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 126) {
          s2 = peg$c112;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c113);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c114.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c115);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c114.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c115);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c117();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneBoost() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 46,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = peg$parseLuceneLiteral();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 94) {
          s2 = peg$c118;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c119);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];

          if (peg$c114.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c115);
            }
          }

          while (s4 !== peg$FAILED) {
            s3.push(s4);

            if (peg$c114.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c115);
              }
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c120();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneLiteral() {
      var s0;
      var key = peg$currPos * 56 + 47,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseQuotedString();

      if (s0 === peg$FAILED) {
        s0 = peg$parseLuceneUnquotedLiteral();
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneUnquotedLiteral() {
      var s0, s1;
      var key = peg$currPos * 56 + 48,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = [];
      s1 = peg$parseLuceneUnquotedCharacter();

      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parseLuceneUnquotedCharacter();
        }
      } else {
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneUnquotedCharacter() {
      var s0, s1, s2, s3;
      var key = peg$currPos * 56 + 49,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseEscapedWhitespace();

      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedLuceneSpecialCharacter();

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$currPos;
          peg$silentFails++;
          s2 = peg$parseLuceneSpecialCharacter();
          peg$silentFails--;

          if (s2 === peg$FAILED) {
            s1 = void 0;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }

          if (s1 !== peg$FAILED) {
            s2 = peg$currPos;
            peg$silentFails++;
            s3 = peg$parseLuceneKeyword();
            peg$silentFails--;

            if (s3 === peg$FAILED) {
              s2 = void 0;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }

            if (s2 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c53);
                }
              }

              if (s3 !== peg$FAILED) {
                s1 = [s1, s2, s3];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneKeyword() {
      var s0;
      var key = peg$currPos * 56 + 50,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$parseOr();

      if (s0 === peg$FAILED) {
        s0 = peg$parseAnd();

        if (s0 === peg$FAILED) {
          s0 = peg$parseLuceneOr();

          if (s0 === peg$FAILED) {
            s0 = peg$parseLuceneAnd();

            if (s0 === peg$FAILED) {
              s0 = peg$parseLuceneNot();

              if (s0 === peg$FAILED) {
                s0 = peg$parseLuceneTo();
              }
            }
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseEscapedLuceneSpecialCharacter() {
      var s0, s1, s2;
      var key = peg$currPos * 56 + 51,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c45;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c46);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseLuceneSpecialCharacter();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c121();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneSpecialCharacter() {
      var s0;
      var key = peg$currPos * 56 + 52,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      if (input.charCodeAt(peg$currPos) === 43) {
        s0 = peg$c93;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c94);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s0 = peg$c95;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c96);
          }
        }

        if (s0 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 61) {
            s0 = peg$c122;
            peg$currPos++;
          } else {
            s0 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c123);
            }
          }

          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 62) {
              s0 = peg$c78;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c79);
              }
            }

            if (s0 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 60) {
                s0 = peg$c75;
                peg$currPos++;
              } else {
                s0 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c76);
                }
              }

              if (s0 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 33) {
                  s0 = peg$c98;
                  peg$currPos++;
                } else {
                  s0 = peg$FAILED;

                  if (peg$silentFails === 0) {
                    peg$fail(peg$c99);
                  }
                }

                if (s0 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s0 = peg$c6;
                    peg$currPos++;
                  } else {
                    s0 = peg$FAILED;

                    if (peg$silentFails === 0) {
                      peg$fail(peg$c7);
                    }
                  }

                  if (s0 === peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                      s0 = peg$c8;
                      peg$currPos++;
                    } else {
                      s0 = peg$FAILED;

                      if (peg$silentFails === 0) {
                        peg$fail(peg$c9);
                      }
                    }

                    if (s0 === peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 123) {
                        s0 = peg$c13;
                        peg$currPos++;
                      } else {
                        s0 = peg$FAILED;

                        if (peg$silentFails === 0) {
                          peg$fail(peg$c14);
                        }
                      }

                      if (s0 === peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 125) {
                          s0 = peg$c15;
                          peg$currPos++;
                        } else {
                          s0 = peg$FAILED;

                          if (peg$silentFails === 0) {
                            peg$fail(peg$c16);
                          }
                        }

                        if (s0 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 91) {
                            s0 = peg$c124;
                            peg$currPos++;
                          } else {
                            s0 = peg$FAILED;

                            if (peg$silentFails === 0) {
                              peg$fail(peg$c125);
                            }
                          }

                          if (s0 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 93) {
                              s0 = peg$c126;
                              peg$currPos++;
                            } else {
                              s0 = peg$FAILED;

                              if (peg$silentFails === 0) {
                                peg$fail(peg$c127);
                              }
                            }

                            if (s0 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 94) {
                                s0 = peg$c118;
                                peg$currPos++;
                              } else {
                                s0 = peg$FAILED;

                                if (peg$silentFails === 0) {
                                  peg$fail(peg$c119);
                                }
                              }

                              if (s0 === peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 34) {
                                  s0 = peg$c41;
                                  peg$currPos++;
                                } else {
                                  s0 = peg$FAILED;

                                  if (peg$silentFails === 0) {
                                    peg$fail(peg$c42);
                                  }
                                }

                                if (s0 === peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 126) {
                                    s0 = peg$c112;
                                    peg$currPos++;
                                  } else {
                                    s0 = peg$FAILED;

                                    if (peg$silentFails === 0) {
                                      peg$fail(peg$c113);
                                    }
                                  }

                                  if (s0 === peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 42) {
                                      s0 = peg$c54;
                                      peg$currPos++;
                                    } else {
                                      s0 = peg$FAILED;

                                      if (peg$silentFails === 0) {
                                        peg$fail(peg$c55);
                                      }
                                    }

                                    if (s0 === peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 63) {
                                        s0 = peg$c104;
                                        peg$currPos++;
                                      } else {
                                        s0 = peg$FAILED;

                                        if (peg$silentFails === 0) {
                                          peg$fail(peg$c105);
                                        }
                                      }

                                      if (s0 === peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 58) {
                                          s0 = peg$c11;
                                          peg$currPos++;
                                        } else {
                                          s0 = peg$FAILED;

                                          if (peg$silentFails === 0) {
                                            peg$fail(peg$c12);
                                          }
                                        }

                                        if (s0 === peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 92) {
                                            s0 = peg$c45;
                                            peg$currPos++;
                                          } else {
                                            s0 = peg$FAILED;

                                            if (peg$silentFails === 0) {
                                              peg$fail(peg$c46);
                                            }
                                          }

                                          if (s0 === peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 47) {
                                              s0 = peg$c107;
                                              peg$currPos++;
                                            } else {
                                              s0 = peg$FAILED;

                                              if (peg$silentFails === 0) {
                                                peg$fail(peg$c108);
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneTo() {
      var s0, s1, s2, s3, s4;
      var key = peg$currPos * 56 + 53,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c128) {
          s2 = peg$c128;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c129);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();

          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }

          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneRangeStart() {
      var s0;
      var key = peg$currPos * 56 + 54,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      if (input.charCodeAt(peg$currPos) === 91) {
        s0 = peg$c124;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c125);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 123) {
          s0 = peg$c13;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c14);
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    function peg$parseLuceneRangeEnd() {
      var s0;
      var key = peg$currPos * 56 + 55,
          cached = peg$resultsCache[key];

      if (cached) {
        peg$currPos = cached.nextPos;
        return cached.result;
      }

      if (input.charCodeAt(peg$currPos) === 93) {
        s0 = peg$c126;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c127);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 125) {
          s0 = peg$c15;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c16);
          }
        }
      }

      peg$resultsCache[key] = {
        nextPos: peg$currPos,
        result: s0
      };
      return s0;
    }

    const {
      errorOnLuceneSyntax,
      parseCursor,
      cursorSymbol,
      allowLeadingWildcards = true,
      helpers: {
        nodeTypes
      }
    } = options;
    const buildFunctionNode = nodeTypes.function.buildNodeWithArgumentNodes;
    const buildLiteralNode = nodeTypes.literal.buildNode;
    const buildWildcardNode = nodeTypes.wildcard.buildNode;
    const buildNamedArgNode = nodeTypes.namedArg.buildNode;
    const {
      wildcardSymbol
    } = nodeTypes.wildcard;
    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({
          type: "end",
          description: "end of input"
        });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse: peg$parse
  };
}();