"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultComponents = exports.components = void 0;

var _containers = require("./containers");

var _indicators = require("./indicators");

var _Control = _interopRequireDefault(require("./Control"));

var _Group = _interopRequireWildcard(require("./Group"));

var _Input = _interopRequireDefault(require("./Input"));

var _Menu = _interopRequireWildcard(require("./Menu"));

var _MultiValue = _interopRequireWildcard(require("./MultiValue"));

var _Option = _interopRequireDefault(require("./Option"));

var _Placeholder = _interopRequireDefault(require("./Placeholder"));

var _SingleValue = _interopRequireDefault(require("./SingleValue"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var components = {
  ClearIndicator: _indicators.ClearIndicator,
  Control: _Control.default,
  DropdownIndicator: _indicators.DropdownIndicator,
  DownChevron: _indicators.DownChevron,
  CrossIcon: _indicators.CrossIcon,
  Group: _Group.default,
  GroupHeading: _Group.GroupHeading,
  IndicatorsContainer: _containers.IndicatorsContainer,
  IndicatorSeparator: _indicators.IndicatorSeparator,
  Input: _Input.default,
  LoadingIndicator: _indicators.LoadingIndicator,
  Menu: _Menu.default,
  MenuList: _Menu.MenuList,
  MenuPortal: _Menu.MenuPortal,
  LoadingMessage: _Menu.LoadingMessage,
  NoOptionsMessage: _Menu.NoOptionsMessage,
  MultiValue: _MultiValue.default,
  MultiValueContainer: _MultiValue.MultiValueContainer,
  MultiValueLabel: _MultiValue.MultiValueLabel,
  MultiValueRemove: _MultiValue.MultiValueRemove,
  Option: _Option.default,
  Placeholder: _Placeholder.default,
  SelectContainer: _containers.SelectContainer,
  SingleValue: _SingleValue.default,
  ValueContainer: _containers.ValueContainer
};
exports.components = components;

var defaultComponents = function defaultComponents(props) {
  return _objectSpread({}, components, props.components);
};

exports.defaultComponents = defaultComponents;