<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


# parse-url

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/parse-url.svg)](https://travis-ci.org/IonicaBizau/parse-url/) [![Version](https://img.shields.io/npm/v/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Downloads](https://img.shields.io/npm/dt/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>

> An advanced url parser supporting git urls too.

For low-level path parsing, check out [`parse-path`](https://github.com/IonicaBizau/parse-path). This very module is designed to parse urls. By default the urls are normalized.

## :cloud: Installation

```sh
# Using npm
npm install --save parse-url

# Using yarn
yarn add parse-url
```


## :clipboard: Example



```js
// Dependencies
const parseUrl = require("parse-url")

console.log(parseUrl("http://ionicabizau.net/blog"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'ionicabizau.net',
//   user: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog' }

console.log(parseUrl("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'domain.com',
//   user: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash' }

// If you want to parse fancy Git urls, turn off the automatic url normalization
console.log(parseUrl("git+ssh://git@host.xz/path/name.git", false))
// { protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: null,
//   resource: 'host.xz',
//   user: 'git',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git' }

console.log(parseUrl("git@github.com:IonicaBizau/git-stats.git", false))
// { protocols: [],
//   protocol: 'ssh',
//   port: null,
//   resource: 'github.com',
//   user: 'git',
//   pathname: '/IonicaBizau/git-stats.git',
//   hash: '',
//   search: '',
//   href: 'git@github.com:IonicaBizau/git-stats.git' }
```



## :question: Get Help

There are few ways to get help:

 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:

 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:



## :memo: Documentation


### `parseUrl(url, normalize)`
Parses the input url.

**Note**: This *throws* if invalid urls are provided.

#### Params

- **String** `url`: The input url.
- **Boolean|Object** `normalize`: Wheter to normalize the url or not.                         Default is `false`. If `true`, the url will
                        be normalized. If an object, it will be the
                        options object sent to [`normalize-url`](https://github.com/sindresorhus/normalize-url).

                        For SSH urls, normalize won't work.

#### Return
- **Object** An object containing the following fields:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `protocol` (String): The first protocol, `"ssh"` (if the url is a ssh url) or `"file"`.
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `query` (Object): The url querystring, parsed as object.



## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects

I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:


## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:


 - [`delta-screen`](https://github.com/carlosmarte/delta-screen#readme)—[delta-screen on npm](https://www.npmjs.com/package/delta-screen)
 - [`deploy-versioning`](https://github.com/educastellano/deploy-versioning#readme)—Deploy your code keeping older versions.
 - [`eval-spider`](https://github.com/evalsocket/eval-spider/blob/master/README.md) (by evalsocket)—crawle website
 - [`fuge-runner`](https://github.com/apparatus/fuge-runner#readme) (by Peter Elger)—[![npm version][npm-badge]][npm-url] [![npm downloads][npm-downloads-badge]][npm-url] [![Build Status][travis-badge]][travis-url]
 - [`get-tarball-cli`](https://npmjs.com/package/get-tarball-cli) (by Vincent G. Cabrera)—Download tarballs from npm using a package-lock.json file
 - [`git-up`](https://github.com/IonicaBizau/git-up)—A low level git url parser.
 - [`heroku-wp-environment-sync`](https://github.com/taneliheikkinen/heroku-wp-environment-sync#readme) (by Taneli Heikkinen)—A heroku plugin to sync different wordpress environments.
 - [`hologit`](https://github.com/EmergencePlatform/hologit#readme) (by Chris Alfano)—Hologit automates the projection of layered composite file trees based on flat, declarative plans
 - [`hubot-will-it-connect`](https://github.com/gambtho/hubot-will-it-connect#readme) (by gambtho)—Connects hubot with willitconnect, to validate CF's ability to connect to external resources
 - [`kakapo`](https://github.com/devlucky/Kakapo.js#readme) (by devlucky)—Next generation mocking framework in Javascript
 - [`lien`](https://github.com/LienJS/Lien)—An easy to use web framework for Node.js.
 - [`microbe.js`](https://github.com/Aweary/microbe.js) (by Brandon Dail)—A small Node.js framework for simple routing
 - [`miguelcostero-ng2-toasty`](https://github.com/akserg/ng2-toasty) (by Sergey Akopkokhyants)—Angular2 Toasty component shows growl-style alerts and messages for your web app
 - [`native-zip`](https://npmjs.com/package/native-zip) (by kardel)—app内H5应用本地化打包工具，支持增量打包，全量打包
 - [`ndla-source-map-resolver`](https://npmjs.com/package/ndla-source-map-resolver) (by ndla@knowit.no)—Source map resolver for errors logged via ndla-error-reporter.
 - [`normalize-ssh`](https://github.com/zkochan/normalize-ssh#readme) (by Zoltan Kochan)—Normalize a SSH URL
 - [`parse-db-uri`](https://github.com/IonicaBizau/parse-db-uri#readme)—Parse database URIs
 - [`robots-agent`](https://github.com/gajus/robots-agent#readme) (by Gajus Kuizinas)—robots.txt agent with cache.
 - [`ssh-host-manager`](https://github.com/shyim/ssh-session-manager#readme) (by Shyim)—Simple CLI to manage your ssh shortcuts
 - [`ts-scraper`](https://github.com/pskd73/ts-scraper#readme) (by Pramod Kumar)—Scarp links present in the website recursively
 - [`tumblr-text`](https://npmjs.com/package/tumblr-text) (by cobaimelan)—[![Build Status](http://img.shields.io/travis/ayhankuru/tumblr-text.svg?style=flat-square)](https://travis-ci.org/ayhankuru/tumblr-text) [![Build Status](https://img.shields.io/david/ayhankuru/tumblr-text.svg?style=flat-square)](https://david-dm.org/ayhan
 - [`url-local`](https://github.com/IonicaBizau/url-local#readme)—Checks if a given url is a local url or not.
 - [`vrt-cli`](https://github.com/cesarferreira/vrt-cli#readme) (by Viktor Bezdek)—> Visual regression testing helper toolkit.
 - [`wander-cli`](https://github.com/dividedbyzeroco/wander-js#readme) (by Jake Josol)—Database Migrations for Modern Apps
 - [`warp-server`](https://github.com/dividedbyzeroco/warp-server#readme) (by Warp)—Warp Server
 - [`xbuilder-forms`](https://github.com/stewartmegaw/xBuilderForms#readme) (by Stewart Megaw)—Quickly add beautiful and powerful forms to your application

## :scroll: License

[MIT][license] © [Ionică Bizău][website]


[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg

[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW

[license]: http://showalicense.com/?fullname=Ionic%C4%83%20Biz%C4%83u%20%3Cbizauionica%40gmail.com%3E%20(https%3A%2F%2Fionicabizau.net)&year=2015#license-mit
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
