"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFilterStream = void 0;
const stream_1 = require("stream");
function createFilterStream(fn) {
    return new stream_1.Transform({
        objectMode: true,
        async transform(obj, enc, done) {
            const canPushDownStream = fn(obj);
            if (canPushDownStream) {
                this.push(obj);
            }
            done();
        },
    });
}
exports.createFilterStream = createFilterStream;
