"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = exports.getDataPath = exports.getConfigDirectory = exports.getConfigPath = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const config_schema_1 = require("@kbn/config-schema");
const repo_root_1 = require("../repo_root");
const isString = (v) => typeof v === 'string';
const CONFIG_PATHS = [
    process.env.KBN_PATH_CONF && path_1.join(process.env.KBN_PATH_CONF, 'kibana.yml'),
    process.env.KIBANA_PATH_CONF && path_1.join(process.env.KIBANA_PATH_CONF, 'kibana.yml'),
    process.env.CONFIG_PATH,
    path_1.join(repo_root_1.REPO_ROOT, 'config/kibana.yml'),
].filter(isString);
const CONFIG_DIRECTORIES = [
    process.env.KBN_PATH_CONF,
    process.env.KIBANA_PATH_CONF,
    path_1.join(repo_root_1.REPO_ROOT, 'config'),
    '/etc/kibana',
].filter(isString);
const DATA_PATHS = [
    process.env.DATA_PATH,
    path_1.join(repo_root_1.REPO_ROOT, 'data'),
    '/var/lib/kibana',
].filter(isString);
function findFile(paths) {
    const availablePath = paths.find((configPath) => {
        try {
            fs_1.accessSync(configPath, fs_1.constants.R_OK);
            return true;
        }
        catch (e) {
            // Check the next path
        }
    });
    return availablePath || paths[0];
}
/**
 * Get the path of kibana.yml
 * @internal
 */
const getConfigPath = () => findFile(CONFIG_PATHS);
exports.getConfigPath = getConfigPath;
/**
 * Get the directory containing configuration files
 * @internal
 */
const getConfigDirectory = () => findFile(CONFIG_DIRECTORIES);
exports.getConfigDirectory = getConfigDirectory;
/**
 * Get the directory containing runtime data
 * @internal
 */
const getDataPath = () => findFile(DATA_PATHS);
exports.getDataPath = getDataPath;
exports.config = {
    path: 'path',
    schema: config_schema_1.schema.object({
        data: config_schema_1.schema.string({ defaultValue: () => exports.getDataPath() }),
    }),
};
