"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.lastValueFrom = exports.firstValueFrom = void 0;
const operators_1 = require("rxjs/operators");
function firstValueFrom(source) {
    // we can't use SafeSubscriber the same way that RxJS 7 does, so instead we
    return source.pipe(operators_1.first()).toPromise();
}
exports.firstValueFrom = firstValueFrom;
function lastValueFrom(source) {
    return source.pipe(operators_1.last()).toPromise();
}
exports.lastValueFrom = lastValueFrom;
