"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
const lodash_1 = require("lodash");
function merge(baseObj, ...sources) {
    const firstSource = sources[0];
    if (firstSource === undefined) {
        return baseObj;
    }
    return sources
        .slice(1)
        .reduce((merged, nextSource) => mergeObjects(merged, nextSource), mergeObjects(baseObj, firstSource));
}
exports.merge = merge;
const isMergable = (obj) => lodash_1.isPlainObject(obj);
const mergeObjects = (baseObj, overrideObj) => [...new Set([...Object.keys(baseObj), ...Object.keys(overrideObj)])].reduce((merged, key) => {
    const baseVal = baseObj[key];
    const overrideVal = overrideObj[key];
    if (isMergable(baseVal) && isMergable(overrideVal)) {
        merged[key] = mergeObjects(baseVal, overrideVal);
    }
    else if (overrideVal !== undefined) {
        merged[key] = overrideVal;
    }
    else if (baseVal !== undefined) {
        merged[key] = baseVal;
    }
    return merged;
}, {});
