"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupIntoMap = exports.mapValuesOfMap = void 0;
function mapValuesOfMap(map, mapper) {
    const result = new Map();
    for (const [key, value] of map.entries()) {
        result.set(key, mapper(value));
    }
    return result;
}
exports.mapValuesOfMap = mapValuesOfMap;
function groupIntoMap(collection, groupBy) {
    const map = new Map();
    collection.forEach((item) => {
        const key = groupBy(item);
        const values = map.get(key) || [];
        values.push(item);
        map.set(key, values);
    });
    return map;
}
exports.groupIntoMap = groupIntoMap;
