"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.get = void 0;
function get(obj, path) {
    if (typeof path === 'string') {
        if (path.includes('.')) {
            throw new Error('Using dots in `get` with a string is not allowed, use array instead');
        }
        return obj[path];
    }
    for (const key of path) {
        obj = obj[key];
    }
    return obj;
}
exports.get = get;
