"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerProxyService = void 0;
const monaco_imports_1 = require("../monaco_imports");
const constants_1 = require("./constants");
class WorkerProxyService {
    async getAnnos(modelUri) {
        if (!this.worker) {
            throw new Error('Worker Proxy Service has not been setup!');
        }
        await this.worker.withSyncedResources([modelUri]);
        const proxy = await this.worker.getProxy();
        return proxy.parse(modelUri.toString());
    }
    setup() {
        this.worker = monaco_imports_1.monaco.editor.createWebWorker({ label: constants_1.ID, moduleId: '' });
    }
    stop() {
        if (this.worker)
            this.worker.dispose();
    }
}
exports.WorkerProxyService = WorkerProxyService;
//# sourceMappingURL=worker_proxy_service.js.map