"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.XJsonWorker = void 0;
const grammar_1 = require("../grammar");
class XJsonWorker {
    constructor(ctx) {
        this.ctx = ctx;
    }
    async parse(modelUri) {
        if (!this.parser) {
            this.parser = grammar_1.createParser();
        }
        const model = this.ctx.getMirrorModels().find((m) => m.uri.toString() === modelUri);
        if (model) {
            return this.parser(model.getValue());
        }
    }
}
exports.XJsonWorker = XJsonWorker;
//# sourceMappingURL=xjson_worker.js.map