"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const xjson_1 = require("./xjson");
const painless_1 = require("./painless");
const esql_1 = require("./esql");
const monaco_imports_1 = require("./monaco_imports");
// @ts-ignore
const xjson_editor_worker_js_1 = tslib_1.__importDefault(require("!!raw-loader!../target/public/xjson.editor.worker.js"));
// @ts-ignore
const default_editor_worker_js_1 = tslib_1.__importDefault(require("!!raw-loader!../target/public/default.editor.worker.js"));
// @ts-ignore
const painless_editor_worker_js_1 = tslib_1.__importDefault(require("!!raw-loader!../target/public/painless.editor.worker.js"));
/**
 * Register languages and lexer rules
 */
monaco_imports_1.monaco.languages.register({ id: xjson_1.XJsonLang.ID });
monaco_imports_1.monaco.languages.setMonarchTokensProvider(xjson_1.XJsonLang.ID, xjson_1.XJsonLang.lexerRules);
monaco_imports_1.monaco.languages.setLanguageConfiguration(xjson_1.XJsonLang.ID, xjson_1.XJsonLang.languageConfiguration);
monaco_imports_1.monaco.languages.register({ id: painless_1.PainlessLang.ID });
monaco_imports_1.monaco.languages.setMonarchTokensProvider(painless_1.PainlessLang.ID, painless_1.PainlessLang.lexerRules);
monaco_imports_1.monaco.languages.setLanguageConfiguration(painless_1.PainlessLang.ID, painless_1.PainlessLang.languageConfiguration);
monaco_imports_1.monaco.languages.register({ id: esql_1.EsqlLang.ID });
monaco_imports_1.monaco.languages.setMonarchTokensProvider(esql_1.EsqlLang.ID, esql_1.EsqlLang.lexerRules);
/**
 * Create web workers by language ID
 */
const mapLanguageIdToWorker = {
    [xjson_1.XJsonLang.ID]: xjson_editor_worker_js_1.default,
    [painless_1.PainlessLang.ID]: painless_editor_worker_js_1.default,
};
// @ts-ignore
window.MonacoEnvironment = {
    // needed for functional tests so that we can get value from 'editor'
    monaco: monaco_imports_1.monaco,
    getWorker: (module, languageId) => {
        const workerSrc = mapLanguageIdToWorker[languageId] || default_editor_worker_js_1.default;
        const blob = new Blob([workerSrc], { type: 'application/javascript' });
        return new Worker(URL.createObjectURL(blob));
    },
};
//# sourceMappingURL=register_globals.js.map