"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PainlessWorker = void 0;
const lib_1 = require("./lib");
class PainlessWorker {
    constructor(ctx) {
        this._ctx = ctx;
    }
    getTextDocument(modelUri) {
        const model = this._ctx.getMirrorModels().find((m) => m.uri.toString() === modelUri);
        return model?.getValue();
    }
    async getSyntaxErrors(modelUri) {
        const code = this.getTextDocument(modelUri);
        if (code) {
            return lib_1.parseAndGetSyntaxErrors(code);
        }
    }
    provideAutocompleteSuggestions(currentLineChars, context, fields) {
        // Array of the active line words, e.g., [boolean, isTrue, =, true]
        const words = currentLineChars.replace('\t', '').split(' ');
        const autocompleteSuggestions = lib_1.getAutocompleteSuggestions(context, words, fields);
        return autocompleteSuggestions;
    }
}
exports.PainlessWorker = PainlessWorker;
//# sourceMappingURL=painless_worker.js.map