"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAndGetSyntaxErrors = void 0;
const antlr4ts_1 = require("antlr4ts");
const painless_parser_1 = require("../../antlr/painless_parser");
const error_listener_1 = require("./error_listener");
const lexer_1 = require("./lexer");
const parse = (code) => {
    const inputStream = antlr4ts_1.CharStreams.fromString(code);
    const lexer = new lexer_1.PainlessLexerEnhanced(inputStream);
    const painlessLangErrorListener = new error_listener_1.PainlessErrorListener();
    const tokenStream = new antlr4ts_1.CommonTokenStream(lexer);
    const parser = new painless_parser_1.painless_parser(tokenStream);
    lexer.removeErrorListeners();
    parser.removeErrorListeners();
    lexer.addErrorListener(painlessLangErrorListener);
    parser.addErrorListener(painlessLangErrorListener);
    const errors = painlessLangErrorListener.getErrors();
    return {
        source: parser.source(),
        errors,
    };
};
const parseAndGetSyntaxErrors = (code) => {
    const { errors } = parse(code);
    return errors;
};
exports.parseAndGetSyntaxErrors = parseAndGetSyntaxErrors;
//# sourceMappingURL=parser.js.map