"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PainlessLexerEnhanced = void 0;
const painless_lexer_1 = require("../../antlr/painless_lexer");
/*
 * This extends the PainlessLexer class in order to handle backslashes appropriately
 * It is being invoked in painless_lexer.g4
 * Based on the Java implementation: https://github.com/elastic/elasticsearch/blob/feab123ba400b150f3dcd04dd27cf57474b70d5a/modules/lang-painless/src/main/java/org/elasticsearch/painless/antlr/EnhancedPainlessLexer.java#L73
 */
class PainlessLexerEnhanced extends painless_lexer_1.painless_lexer {
    constructor(input) {
        super(input);
    }
    isSlashRegex() {
        const lastToken = super.nextToken();
        if (lastToken == null) {
            return true;
        }
        // @ts-ignore
        switch (lastToken._type) {
            case painless_lexer_1.painless_lexer.RBRACE:
            case painless_lexer_1.painless_lexer.RP:
            case painless_lexer_1.painless_lexer.OCTAL:
            case painless_lexer_1.painless_lexer.HEX:
            case painless_lexer_1.painless_lexer.INTEGER:
            case painless_lexer_1.painless_lexer.DECIMAL:
            case painless_lexer_1.painless_lexer.ID:
            case painless_lexer_1.painless_lexer.DOTINTEGER:
            case painless_lexer_1.painless_lexer.DOTID:
                return false;
            default:
                return true;
        }
    }
}
exports.PainlessLexerEnhanced = PainlessLexerEnhanced;
//# sourceMappingURL=lexer.js.map