"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PainlessErrorListener = void 0;
class PainlessErrorListener {
    constructor() {
        this.errors = [];
    }
    syntaxError(recognizer, offendingSymbol, line, column, message, e) {
        let endColumn = column + 1;
        if (offendingSymbol?._text) {
            endColumn = column + offendingSymbol._text.length;
        }
        this.errors.push({
            startLineNumber: line,
            endLineNumber: line,
            startColumn: column,
            endColumn,
            message,
        });
    }
    getErrors() {
        return this.errors;
    }
}
exports.PainlessErrorListener = PainlessErrorListener;
//# sourceMappingURL=error_listener.js.map