"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSuggestionProvider = void 0;
const monaco_imports_1 = require("../monaco_imports");
const lib_1 = require("./lib");
const constants_1 = require("./constants");
const completion_adapter_1 = require("./completion_adapter");
const diagnostics_adapter_1 = require("./diagnostics_adapter");
const workerProxyService = new lib_1.WorkerProxyService();
const editorStateService = new lib_1.EditorStateService();
const worker = (...uris) => {
    return workerProxyService.getWorker(uris);
};
const getSuggestionProvider = (context, fields) => {
    editorStateService.setup(context, fields);
    return new completion_adapter_1.PainlessCompletionAdapter(worker, editorStateService);
};
exports.getSuggestionProvider = getSuggestionProvider;
monaco_imports_1.monaco.languages.onLanguage(constants_1.ID, async () => {
    workerProxyService.setup();
    new diagnostics_adapter_1.DiagnosticsAdapter(worker);
});
//# sourceMappingURL=language.js.map