"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.legacyLoggingConfigSchema = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const HANDLED_IN_KIBANA_PLATFORM = joi_1.default.any().description('This key is handled in the new platform ONLY');
exports.legacyLoggingConfigSchema = joi_1.default.object()
    .keys({
    appenders: HANDLED_IN_KIBANA_PLATFORM,
    loggers: HANDLED_IN_KIBANA_PLATFORM,
    root: HANDLED_IN_KIBANA_PLATFORM,
    silent: joi_1.default.boolean().default(false),
    quiet: joi_1.default.boolean().when('silent', {
        is: true,
        then: joi_1.default.boolean().default(true).valid(true),
        otherwise: joi_1.default.boolean().default(false),
    }),
    verbose: joi_1.default.boolean().when('quiet', {
        is: true,
        then: joi_1.default.valid(false).default(false),
        otherwise: joi_1.default.boolean().default(false),
    }),
    events: joi_1.default.any().default({}),
    dest: joi_1.default.string().default('stdout'),
    filter: joi_1.default.any().default({}),
    json: joi_1.default.boolean().when('dest', {
        is: 'stdout',
        then: joi_1.default.boolean().default(!process.stdout.isTTY),
        otherwise: joi_1.default.boolean().default(true),
    }),
    timezone: joi_1.default.string(),
    rotate: joi_1.default.object()
        .keys({
        enabled: joi_1.default.boolean().default(false),
        everyBytes: joi_1.default.number()
            // > 1MB
            .greater(1048576)
            // < 1GB
            .less(1073741825)
            // 10MB
            .default(10485760),
        keepFiles: joi_1.default.number().greater(2).less(1024).default(7),
        pollingInterval: joi_1.default.number().greater(5000).less(3600000).default(10000),
        usePolling: joi_1.default.boolean().default(false),
    })
        .default(),
})
    .default();
