"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.attachMetaData = exports.getLogEventData = exports.isEventData = exports.metadataSymbol = void 0;
const lodash_1 = require("lodash");
exports.metadataSymbol = Symbol('log message with metadata');
const isEventData = (eventData) => {
    return Boolean(lodash_1.isPlainObject(eventData) && eventData[exports.metadataSymbol]);
};
exports.isEventData = isEventData;
const getLogEventData = (eventData) => {
    const { message, metadata } = eventData[exports.metadataSymbol];
    return {
        ...metadata,
        message,
    };
};
exports.getLogEventData = getLogEventData;
const attachMetaData = (message, metadata = {}) => {
    return {
        [exports.metadataSymbol]: {
            message,
            metadata,
        },
    };
};
exports.attachMetaData = attachMetaData;
