"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLogReporter = void 0;
const fs_1 = require("fs");
const stream_1 = require("stream");
// @ts-expect-error missing type def
const good_squeeze_1 = require("@hapi/good-squeeze");
const log_format_json_1 = require("./log_format_json");
const log_format_string_1 = require("./log_format_string");
const log_interceptor_1 = require("./log_interceptor");
function getLogReporter({ events, config }) {
    const squeeze = new good_squeeze_1.Squeeze(events);
    const format = config.json ? new log_format_json_1.KbnLoggerJsonFormat(config) : new log_format_string_1.KbnLoggerStringFormat(config);
    const logInterceptor = new log_interceptor_1.LogInterceptor();
    if (config.dest === 'stdout') {
        stream_1.pipeline(logInterceptor, squeeze, format, onFinished);
        // The `pipeline` function is used to properly close all streams in the
        // pipeline in case one of them ends or fails. Since stdout obviously
        // shouldn't be closed in case of a failure in one of the other streams,
        // we're not including that in the call to `pipeline`, but rely on the old
        // `pipe` function instead.
        format.pipe(process.stdout);
    }
    else {
        const dest = fs_1.createWriteStream(config.dest, {
            flags: 'a',
            encoding: 'utf8',
        });
        stream_1.pipeline(logInterceptor, squeeze, format, dest, onFinished);
    }
    return logInterceptor;
}
exports.getLogReporter = getLogReporter;
function onFinished(err) {
    if (err) {
        // eslint-disable-next-line no-console
        console.error('An unexpected error occurred in the logging pipeline:', err.stack);
    }
}
