"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KbnLoggerJsonFormat = void 0;
const tslib_1 = require("tslib");
// @ts-expect-error missing type def
const json_stringify_safe_1 = tslib_1.__importDefault(require("json-stringify-safe"));
const log_format_1 = require("./log_format");
const stripColors = function (string) {
    return string.replace(/\u001b[^m]+m/g, '');
};
class KbnLoggerJsonFormat extends log_format_1.BaseLogFormat {
    format(data) {
        data.message = stripColors(data.message);
        data['@timestamp'] = this.extractAndFormatTimestamp(data);
        return json_stringify_safe_1.default(data);
    }
}
exports.KbnLoggerJsonFormat = KbnLoggerJsonFormat;
