"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isUndeclaredErrorEvent = exports.isLogEvent = exports.isErrorEvent = exports.isOpsEvent = exports.isResponseEvent = void 0;
const metadata_1 = require("./metadata");
const isResponseEvent = (e) => e.event === 'response';
exports.isResponseEvent = isResponseEvent;
const isOpsEvent = (e) => e.event === 'ops';
exports.isOpsEvent = isOpsEvent;
const isErrorEvent = (e) => e.event === 'error';
exports.isErrorEvent = isErrorEvent;
const isLogEvent = (e) => metadata_1.isEventData(e.data);
exports.isLogEvent = isLogEvent;
const isUndeclaredErrorEvent = (e) => e.error instanceof Error;
exports.isUndeclaredErrorEvent = isUndeclaredErrorEvent;
