"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeAll = exports.unique = exports.hasValues = exports.isObject = exports.isString = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const isString = value => typeof value === 'string';

exports.isString = isString;

const isObject = value => typeof value === 'object' && value !== null;

exports.isObject = isObject;

const hasValues = values => Object.keys(values).length > 0;

exports.hasValues = hasValues;

const unique = (arr = []) => [...new Set(arr)];

exports.unique = unique;

const merge = (a, b) => unique([...Object.keys(a), ...Object.keys(b)]).reduce((acc, key) => {
  if (isObject(a[key]) && isObject(b[key]) && !Array.isArray(a[key]) && !Array.isArray(b[key])) {
    return { ...acc,
      [key]: merge(a[key], b[key])
    };
  }

  return { ...acc,
    [key]: b[key] === undefined ? a[key] : b[key]
  };
}, {});

const mergeAll = (...sources) => sources.filter(isObject).reduce((acc, source) => merge(acc, source));

exports.mergeAll = mergeAll;