"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.rawConfigServiceMock = void 0;
const rxjs_1 = require("rxjs");
const createRawConfigServiceMock = ({ rawConfig = {}, rawConfig$ = undefined, } = {}) => {
    const mocked = {
        loadConfig: jest.fn(),
        stop: jest.fn(),
        reloadConfig: jest.fn(),
        getConfig$: jest.fn().mockReturnValue(rawConfig$ || rxjs_1.of(rawConfig)),
    };
    return mocked;
};
exports.rawConfigServiceMock = {
    create: createRawConfigServiceMock,
};
