"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPluginSearchPaths = void 0;
const path_1 = require("path");
function getPluginSearchPaths({ rootDir, oss, examples }) {
    return [
        path_1.resolve(rootDir, 'src', 'plugins'),
        ...(oss ? [] : [path_1.resolve(rootDir, 'x-pack', 'plugins')]),
        path_1.resolve(rootDir, 'plugins'),
        ...(examples ? [path_1.resolve(rootDir, 'examples')] : []),
        ...(examples && !oss ? [path_1.resolve(rootDir, 'x-pack', 'examples')] : []),
        path_1.resolve(rootDir, '..', 'kibana-extra'),
    ];
}
exports.getPluginSearchPaths = getPluginSearchPaths;
