"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjectToConfigAdapter = void 0;
const lodash_1 = require("lodash");
const safer_lodash_set_1 = require("@elastic/safer-lodash-set");
const std_1 = require("@kbn/std");
/**
 * Allows plain javascript object to behave like `RawConfig` instance.
 * @internal
 */
class ObjectToConfigAdapter {
    constructor(rawConfig) {
        this.rawConfig = rawConfig;
    }
    has(configPath) {
        return lodash_1.has(this.rawConfig, configPath);
    }
    get(configPath) {
        return lodash_1.get(this.rawConfig, configPath);
    }
    set(configPath, value) {
        safer_lodash_set_1.set(this.rawConfig, configPath, value);
    }
    getFlattenedPaths() {
        return Object.keys(std_1.getFlattenedObject(this.rawConfig));
    }
    toRaw() {
        return lodash_1.cloneDeep(this.rawConfig);
    }
}
exports.ObjectToConfigAdapter = ObjectToConfigAdapter;
