"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvOptions = exports.rawConfigServiceMock = exports.configServiceMock = exports.configMock = void 0;
// these CANT be exported by the main entrypoint, as it cause ts check failures
// in `src/test` and `src/xpack/test` projects due to definition conflicts between
// mocha and jest declaring the same globals such as `it` or `beforeAll`, as the test
// files imports types from `core` that is importing the main `@kbn/config` entrypoint.
// For now, these should be imported using `import {} from '@kbn/config/target/mocks'`
var config_mock_1 = require("./config.mock");
Object.defineProperty(exports, "configMock", { enumerable: true, get: function () { return config_mock_1.configMock; } });
var config_service_mock_1 = require("./config_service.mock");
Object.defineProperty(exports, "configServiceMock", { enumerable: true, get: function () { return config_service_mock_1.configServiceMock; } });
var raw_config_service_mock_1 = require("./raw/raw_config_service.mock");
Object.defineProperty(exports, "rawConfigServiceMock", { enumerable: true, get: function () { return raw_config_service_mock_1.rawConfigServiceMock; } });
var env_1 = require("./__mocks__/env");
Object.defineProperty(exports, "getEnvOptions", { enumerable: true, get: function () { return env_1.getEnvOptions; } });
