"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.mockPackage = void 0;
const realPath = jest.requireActual('path');
jest.doMock('path', () => ({
    ...realPath,
    resolve(...pathSegments) {
        return pathSegments.join('/');
    },
    dirname(filePath) {
        return '/test/kibanaRoot';
    },
}));
exports.mockPackage = {
    raw: {},
};
jest.doMock('load-json-file', () => ({
    sync: () => exports.mockPackage.raw,
}));
