"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Env = void 0;
const tslib_1 = require("tslib");
const path_1 = require("path");
const load_json_file_1 = tslib_1.__importDefault(require("load-json-file"));
const plugins_1 = require("./plugins");
class Env {
    /**
     * @internal
     */
    constructor(homeDir, pkg, options) {
        this.homeDir = homeDir;
        this.configDir = path_1.resolve(this.homeDir, 'config');
        this.binDir = path_1.resolve(this.homeDir, 'bin');
        this.logDir = path_1.resolve(this.homeDir, 'log');
        this.pluginSearchPaths = plugins_1.getPluginSearchPaths({
            rootDir: this.homeDir,
            oss: options.cliArgs.oss,
            examples: options.cliArgs.runExamples,
        });
        this.cliArgs = Object.freeze(options.cliArgs);
        this.configs = Object.freeze(options.configs);
        this.isDevCliParent = options.isDevCliParent;
        const isDevMode = this.cliArgs.dev || this.cliArgs.envName === 'development';
        this.mode = Object.freeze({
            dev: isDevMode,
            name: isDevMode ? 'development' : 'production',
            prod: !isDevMode,
        });
        const isKibanaDistributable = Boolean(pkg.build && pkg.build.distributable === true);
        this.packageInfo = Object.freeze({
            branch: pkg.branch,
            buildNum: isKibanaDistributable ? pkg.build.number : Number.MAX_SAFE_INTEGER,
            buildSha: isKibanaDistributable ? pkg.build.sha : 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
            version: pkg.version,
            dist: isKibanaDistributable,
        });
    }
    /**
     * @internal
     */
    static createDefault(repoRoot, options, pkg) {
        if (!pkg) {
            pkg = load_json_file_1.default.sync(path_1.join(repoRoot, 'package.json'));
        }
        return new Env(repoRoot, pkg, options);
    }
}
exports.Env = Env;
