"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyDeprecations = void 0;
const lodash_1 = require("lodash");
const noopLogger = (msg) => undefined;
/**
 * Applies deprecations on given configuration and logs any deprecation warning using provided logger.
 *
 * @internal
 */
const applyDeprecations = (config, deprecations, logger = noopLogger) => {
    let processed = lodash_1.cloneDeep(config);
    deprecations.forEach(({ deprecation, path }) => {
        processed = deprecation(processed, path, logger);
    });
    return processed;
};
exports.applyDeprecations = applyDeprecations;
