"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.configServiceMock = void 0;
const rxjs_1 = require("rxjs");
const object_to_config_adapter_1 = require("./object_to_config_adapter");
const createConfigServiceMock = ({ atPath = {}, getConfig$ = {}, } = {}) => {
    const mocked = {
        atPath: jest.fn(),
        atPathSync: jest.fn(),
        getConfig$: jest.fn(),
        getUsedPaths: jest.fn(),
        getUnusedPaths: jest.fn(),
        isEnabledAtPath: jest.fn(),
        setSchema: jest.fn(),
        addDeprecationProvider: jest.fn(),
        validate: jest.fn(),
    };
    mocked.atPath.mockReturnValue(new rxjs_1.BehaviorSubject(atPath));
    mocked.atPathSync.mockReturnValue(atPath);
    mocked.getConfig$.mockReturnValue(new rxjs_1.BehaviorSubject(new object_to_config_adapter_1.ObjectToConfigAdapter(getConfig$)));
    mocked.getUsedPaths.mockResolvedValue([]);
    mocked.getUnusedPaths.mockResolvedValue([]);
    mocked.isEnabledAtPath.mockResolvedValue(true);
    return mocked;
};
exports.configServiceMock = {
    create: createConfigServiceMock,
};
