"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.URIType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const internals_1 = require("../internals");
const type_1 = require("./type");
class URIType extends type_1.Type {
    constructor(options = {}) {
        super(internals_1.internals.string().uri({ scheme: options.scheme }), options);
    }
    handleError(type, { value, scheme }) {
        switch (type) {
            case 'any.required':
            case 'string.base':
                return `expected value of type [string] but got [${type_detect_1.default(value)}].`;
            case 'string.uriCustomScheme':
                return `expected URI with scheme [${scheme}].`;
            case 'string.uri':
                return `value must be a valid URI (see RFC 3986).`;
        }
    }
}
exports.URIType = URIType;
