"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnionType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const errors_1 = require("../errors");
const internals_1 = require("../internals");
const type_1 = require("./type");
class UnionType extends type_1.Type {
    constructor(types, options) {
        const schema = internals_1.internals.alternatives(types.map((type) => type.getSchema()));
        super(schema, options);
    }
    handleError(type, { reason, value }, path) {
        switch (type) {
            case 'any.required':
                return `expected at least one defined value but got [${type_detect_1.default(value)}]`;
            case 'alternatives.child':
                return new errors_1.SchemaTypesError('types that failed validation:', path, reason.map((e, index) => {
                    const childPathWithIndex = e.path.slice();
                    childPathWithIndex.splice(path.length, 0, index.toString());
                    return e instanceof errors_1.SchemaTypesError
                        ? new errors_1.SchemaTypesError(e.message, childPathWithIndex, e.errors)
                        : new errors_1.SchemaTypeError(e.message, childPathWithIndex);
                }));
        }
    }
}
exports.UnionType = UnionType;
