"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const internals_1 = require("../internals");
const type_1 = require("./type");
class StreamType extends type_1.Type {
    constructor(options) {
        super(internals_1.internals.stream(), options);
    }
    handleError(type, { value }) {
        if (type === 'any.required' || type === 'stream.base') {
            return `expected value of type [Stream] but got [${type_detect_1.default(value)}]`;
        }
    }
}
exports.StreamType = StreamType;
