"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecordOfType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const errors_1 = require("../errors");
const internals_1 = require("../internals");
const type_1 = require("./type");
class RecordOfType extends type_1.Type {
    constructor(keyType, valueType, options = {}) {
        const schema = internals_1.internals.record().entries(keyType.getSchema(), valueType.getSchema());
        super(schema, options);
    }
    handleError(type, { entryKey, reason, value }, path) {
        switch (type) {
            case 'any.required':
            case 'record.base':
                return `expected value of type [object] but got [${type_detect_1.default(value)}]`;
            case 'record.parse':
                return `could not parse record value from json input`;
            case 'record.key':
            case 'record.value':
                const childPathWithIndex = path.slice();
                childPathWithIndex.splice(path.length, 0, 
                // If `key` validation failed, let's stress that to make error more obvious.
                type === 'record.key' ? `key("${entryKey}")` : entryKey.toString(), 
                // Error could have happened deep inside value/key schema and error message should
                // include full path.
                ...(reason instanceof errors_1.SchemaTypeError ? reason.path : []));
                return reason instanceof errors_1.SchemaTypesError
                    ? new errors_1.SchemaTypesError(reason, childPathWithIndex, reason.errors)
                    : new errors_1.SchemaTypeError(reason, childPathWithIndex);
        }
    }
}
exports.RecordOfType = RecordOfType;
