"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NumberType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const internals_1 = require("../internals");
const type_1 = require("./type");
class NumberType extends type_1.Type {
    constructor(options = {}) {
        let schema = internals_1.internals.number();
        if (options.min !== undefined) {
            schema = schema.min(options.min);
        }
        if (options.max !== undefined) {
            schema = schema.max(options.max);
        }
        super(schema, options);
    }
    handleError(type, { limit, value }) {
        switch (type) {
            case 'any.required':
            case 'number.base':
                return `expected value of type [number] but got [${type_detect_1.default(value)}]`;
            case 'number.min':
                return `Value must be equal to or greater than [${limit}].`;
            case 'number.max':
                return `Value must be equal to or lower than [${limit}].`;
        }
    }
}
exports.NumberType = NumberType;
