"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeverType = void 0;
const internals_1 = require("../internals");
const type_1 = require("./type");
class NeverType extends type_1.Type {
    constructor() {
        super(internals_1.internals.any().forbidden());
    }
    handleError(type) {
        switch (type) {
            case 'any.unknown':
                return "a value wasn't expected to be present";
        }
    }
}
exports.NeverType = NeverType;
