"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.LiteralType = void 0;
const internals_1 = require("../internals");
const type_1 = require("./type");
class LiteralType extends type_1.Type {
    constructor(value) {
        super(internals_1.internals.any().valid(value));
    }
    handleError(type, { value, valids: [expectedValue] }) {
        switch (type) {
            case 'any.required':
            case 'any.allowOnly':
                return `expected value to equal [${expectedValue}]`;
        }
    }
}
exports.LiteralType = LiteralType;
