"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const internals_1 = require("../internals");
const type_1 = require("./type");
class IpType extends type_1.Type {
    constructor(options = { versions: ['ipv4', 'ipv6'] }) {
        const schema = internals_1.internals.string().ip({ version: options.versions, cidr: 'forbidden' });
        super(schema, options);
    }
    handleError(type, { value, version }) {
        switch (type) {
            case 'string.base':
                return `expected value of type [string] but got [${type_detect_1.default(value)}]`;
            case 'string.ipVersion':
                return `value must be a valid ${version.join(' or ')} address`;
        }
    }
}
exports.IpType = IpType;
