"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DurationType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const duration_1 = require("../duration");
const errors_1 = require("../errors");
const internals_1 = require("../internals");
const type_1 = require("./type");
class DurationType extends type_1.Type {
    constructor(options = {}) {
        let defaultValue;
        if (typeof options.defaultValue === 'function') {
            const originalDefaultValue = options.defaultValue;
            defaultValue = () => duration_1.ensureDuration(originalDefaultValue());
        }
        else if (typeof options.defaultValue === 'string' ||
            typeof options.defaultValue === 'number') {
            defaultValue = duration_1.ensureDuration(options.defaultValue);
        }
        else {
            defaultValue = options.defaultValue;
        }
        super(internals_1.internals.duration(), { ...options, defaultValue });
    }
    handleError(type, { message, value }, path) {
        switch (type) {
            case 'any.required':
            case 'duration.base':
                return `expected value of type [moment.Duration] but got [${type_detect_1.default(value)}]`;
            case 'duration.parse':
                return new errors_1.SchemaTypeError(message, path);
        }
    }
}
exports.DurationType = DurationType;
