"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ByteSizeType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const byte_size_value_1 = require("../byte_size_value");
const errors_1 = require("../errors");
const internals_1 = require("../internals");
const type_1 = require("./type");
class ByteSizeType extends type_1.Type {
    constructor(options = {}) {
        let schema = internals_1.internals.bytes();
        if (options.min !== undefined) {
            schema = schema.min(options.min);
        }
        if (options.max !== undefined) {
            schema = schema.max(options.max);
        }
        super(schema, {
            defaultValue: byte_size_value_1.ensureByteSizeValue(options.defaultValue),
            validate: options.validate,
        });
    }
    handleError(type, { limit, message, value }, path) {
        switch (type) {
            case 'any.required':
            case 'bytes.base':
                return `expected value of type [ByteSize] but got [${type_detect_1.default(value)}]`;
            case 'bytes.parse':
                return new errors_1.SchemaTypeError(message, path);
            case 'bytes.min':
                return `Value must be equal to or greater than [${limit.toString()}]`;
            case 'bytes.max':
                return `Value must be equal to or less than [${limit.toString()}]`;
        }
    }
}
exports.ByteSizeType = ByteSizeType;
