"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArrayType = void 0;
const tslib_1 = require("tslib");
const type_detect_1 = tslib_1.__importDefault(require("type-detect"));
const internals_1 = require("../internals");
const type_1 = require("./type");
class ArrayType extends type_1.Type {
    constructor(type, options = {}) {
        let schema = internals_1.internals.array().items(type.getSchema().optional()).sparse(false);
        if (options.minSize !== undefined) {
            schema = schema.min(options.minSize);
        }
        if (options.maxSize !== undefined) {
            schema = schema.max(options.maxSize);
        }
        super(schema, options);
    }
    handleError(type, { limit, reason, value }) {
        switch (type) {
            case 'any.required':
            case 'array.base':
                return `expected value of type [array] but got [${type_detect_1.default(value)}]`;
            case 'array.sparse':
                return `sparse array are not allowed`;
            case 'array.parse':
                return `could not parse array value from json input`;
            case 'array.min':
                return `array size is [${value.length}], but cannot be smaller than [${limit}]`;
            case 'array.max':
                return `array size is [${value.length}], but cannot be greater than [${limit}]`;
            case 'array.includesOne':
                return reason[0];
        }
    }
}
exports.ArrayType = ArrayType;
